package main

import (
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	pb "github.com/hyperledger/fabric/protos/peer"
)

// EncCC example simple Chaincode implementation of a chaincode that uses encryption/signatures
type GXHCC struct {
}

// Init does nothing for this cc
func (t *GXHCC) Init(stub shim.ChaincodeStubInterface) pb.Response {
	return shim.Success([]byte("GXHCC init successful! "))
}

// Invoke for this chaincode exposes
func (t *GXHCC) Invoke(stub shim.ChaincodeStubInterface) pb.Response {
	// get arguments and transient
	functionName, args := stub.GetFunctionAndParameters()

	switch functionName {
	case "authority":

	case "schema":
		res,err := SchemaProcess(args,stub)
		if err!=nil{
			return shim.Error(fmt.Sprintf("SchemaProcess function err: %s", err))
		}
		return shim.Success([]byte(res))

	case "put":
			res,err := put(args,stub)
			if err!=nil{
				return shim.Error(fmt.Sprintf("put function err: %s", err))
			}
			return shim.Success([]byte(res))
	case "get":
		res,err := get(args,stub)
		if err!=nil{
			return shim.Error(fmt.Sprintf("put function err: %s", err))
		}
		return shim.Success([]byte(res))
	case "update":
		res,err := update(args,stub)
		if err!=nil{
			return shim.Error(fmt.Sprintf("put function err: %s", err))
		}
		return shim.Success([]byte(res))



	default:
		return shim.Error(fmt.Sprintf("Unsupported function %s", functionName))
	}
	return shim.Success([]byte("GXHCC invoke successful "))
}

func main() {
	err := shim.Start(&GXHCC{})
	if err != nil {
		fmt.Printf("Error starting EncCC chaincode: %s", err)
	}
}



