package main

import (
	"encoding/json"
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
)

type Schema struct {
}



func SchemaProcess(args []string, stub shim.ChaincodeStubInterface)(string, error){
	if len(args) < 2{
		return "", fmt.Errorf("Expect features with 2 or more parameters to play! ")
	}
	schema := &Schema{}
	switch args[0] {

	case "put":
		return schema.put(args[1:],stub)
	case "update":
		return schema.update(args[1:],stub)
	case "get":
		return schema.get(args[1],stub)
	default:
		return "",fmt.Errorf(fmt.Sprintf("Unsupported schema function of %s", args[0]))

	}
}
/*
	put
	args 字段说明：
	1：args[0]代表我们具体操作的表，
    2：args[1:]后面的数据表示要记录到数据库的数据,每一个string 必须是json字符串，并且需要每一个json 字符串都必须包含id 字段

我们可以发现json字符串都被我们解析成了map[string]interface{}类型的map,其中key代表表模板的字段，interface可以是一个结构，我们当前将他看做我们表模板字段的初始值。

*/
func (this *Schema) put(args []string, stub shim.ChaincodeStubInterface) (string, error) {
	if len(args) != 2 {
		return "", fmt.Errorf("Expected  2 parameters to function put!")
	}
	var mapResult map[string]interface{}

	if err := json.Unmarshal([]byte(args[1]), &mapResult); err != nil {
		return "", fmt.Errorf("parameters Unmarshal fail,args string not json string,err: %s", err)
	}else{
		if extrastr,ok := mapResult["extra"];ok{
			var extraResult map[string]interface{}
			if err := json.Unmarshal([]byte(extrastr.(string)), &extraResult); err != nil {
				return "", fmt.Errorf("parameters Unmarshal fail,extra string not json string,err: %s", err)
			}
		}
	}
	_ ,ok:= mapResult["id"]
	if !ok{
		return "", fmt.Errorf("The id field must exist ")
	}
	if value,_ :=stub.GetState(args[0]);value != nil{
		return "", fmt.Errorf("the parameter %s already exists and cannot be added", args[0])
	}
	putDate,_:= json.Marshal(mapResult) //处理重复字段
	if err := stub.PutState(args[0], putDate); err != nil {
		return "", fmt.Errorf("PutState fail,err: %s", err)
	}
	return fmt.Sprintf("%s schema put success!",args[0]), nil
}

/*
	if update Schema 那么我们没有办法比较旧有的一个模板，
	TODO,增加版本管理
*/
func (this *Schema) update(args []string, stub shim.ChaincodeStubInterface) (string, error) {
	if len(args) != 2 {
		return "", fmt.Errorf("expected 2 parameters to function put!")
	}
	var mapResult map[string]interface{}

	if err := json.Unmarshal([]byte(args[1]), &mapResult); err != nil {
		return "", fmt.Errorf("parameters Unmarshal fail,args string not json string,err: %s", err)
	}else{
		if extrastr,ok := mapResult["extra"];ok{
			var extraResult map[string]interface{}
			if err := json.Unmarshal([]byte(extrastr.(string)), &extraResult); err != nil {
				return "", fmt.Errorf("parameters Unmarshal fail,extra string not json string,err: %s", err)
			}
		}
	}
	_ ,ok:= mapResult["id"]
	if !ok{
		return "", fmt.Errorf("The id field must exist ")
	}
	result, err := stub.GetState(args[0])
	if err != nil || result == nil {
		return "", fmt.Errorf("GetSchema data fail,please check your parameters ")
	}

	err = stub.PutState(args[0], []byte(args[1]))
	return fmt.Sprintf("%s schema update success!",args[0]), err

}

func (this *Schema) get(args string, stub shim.ChaincodeStubInterface) (string, error) {
	result, err := stub.GetState(args)
	if err != nil || result == nil {
		return "", fmt.Errorf("GetSchema data fail,please check your parameters ")
	}
	return string(result), nil
}
