package main

import (
	"encoding/json"
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)



func TestSearchQrKey(t *testing.T) {
	s := []int64{19,20,30,40,101,192,200}
	num := SearchQrKey(1092,s)
	fmt.Println(num)
}

func TestAddEquipmentInfo(t *testing.T) {
	info := &QrCode{}
	//info.Pics = []string{"speciesDesc","speciesDesc"}
	result,_:= json.Marshal(info)
	fmt.Println(string(result))
}

var(
	companyInfo =`{"cid":"1101","cname":"公司","contacts":"one people","cmpanyAddress":"adress is street","companyDesc":"this is company","companyType":"","businessLicense":"","contactPhone":"12345678765","legalPerson":"one people","status":0}`
	dealerInfo = `{"did":"1101","cid":"1101","dealerName":"DealerName","contacts":"contacts","contactPhone":"contacts","salesCount":0,"commissionRatio":0,"status":0}`
	detectionInfo = `{"did":"1101","cid":"1101","detectionName":"detectionName","contacts":"contacts","contactPhone":"contactPhone","status":0}`
	supplierInfo = `{"sid":"1101","cid":"1101","supplierName":"supplierName","supplierAddress":"supplierName","principal":"principal","phone":"phone","status":0}`
	pecies =`{"pid":"1101","cid":"1101","speciesName":"speciesName","mainClass":"mainClass","subClass":"subClass","growingEnv":"growingEnv","growthCycle":0,"pics":["speciesDesc","speciesDesc"],"speciesDesc":"speciesDesc","status":0}`
	resumeInfo =`{"rid":"1101","cid":"1101","baseId":"baseId","sid":"1101","bno":"1102","pics":["speciesDesc","speciesDesc"],"tags":"resumeTime","resumeTime":"resumeTime"}`
	baseInfo =`{"baseId":"1101","cid":"1101","baseName":"baseName","baseAddress":"baseName","area":0,"principal":"baseName","phone":"baseName","basePics":["speciesDesc","speciesDesc"],"status":0}`
	plotInfo =`{"pid":"1101","cid":"1101","baseId":"baseId","plotName":"plotName","plotAddress":"plotName","area":0,"principal":"plotName","phone":"plotName","plotPics":["speciesDesc","speciesDesc"],"status":0}`
	equipmentInfo =`{"eid":"1101","cid":"1101","baseId":"baseId","equipName":"equipName","equipModel":"equipModel1","producer":"producer","producedDate":"producedDate","usedDate":"now","status":0}`
	equipUsedRecord =`{"eu_id":"1101","eid":"1101","uid":"one people","userName":"userName","duration":0,"usedDate":"now"}`
	purchaseInfo =`{"pid":"1101","cid":"1101","baseId":"baseId","purchaseName":"purchaseName","purchaseNo":"purchaseName","purchaseType":0,"producer":"producer","purchaseCount":0,"purchaseDate":"purchaseDate","purchasingAgentId":"purchaseAddress","purchasingAgent":"purchaseAddress","packingSize":"100","businessUnit":"packingSize","purchaseAddress":"purchaseAddress","purchaseBill":["speciesDesc","speciesDesc"],"supplierId":"supplierId"}`
	receive =`{"rid":"1101","cid":"1101","baseId":"baseId","areaId":"areaId","supplierId":"supplierId","receiveName":"receiveName","receiveType":"receiveType","producer":"producer","receiveCount":0,"receiveDate":"receiveDate","receiverId":"receiveDate","receiver":"receiveDate"}`
	pattern =`{"id":"1101","patternName":"patternName","bizType":"patternName","remark":"patternName","status":0}`
	activityInfo =`{"id":"1101","cid":"1101","baseId":"baseId","plotId":"plotId","sid":"sid","bno":"bno","bizType":"bizType"}`
	quarantineInfo =`{"id":"1101","cid":"1101","baseId":"baseId","plotId":"plotId","sid":"sid","bno":"bno","quaName":"quaName","bizType":"bizType","qno":"qno","quaDate":"qno","quaReport":["speciesDesc","speciesDesc"],"principalId":"qno","principal":""}`
	harvesinfo =`{"id":"1101","cid":"1101","baseId":"baseId","plotId":"baseId","sid":"baseId","bno":"bno","harvestName":"harvestName","bizType":"bizType","hno":"hno","startDate":"hno","endDate":"endDate","principalId":"endDate","principal":"endDate"}`
	qualityTesting =`{"qtId":"1101","qtOrgName":"qtOrgName","qtMethod":"qtOrgName","qtDate":"qtOrgName","qtResult":"qtOrgName","qtUser":"qtUser","qtReport":"qtUser","waterReport":["speciesDesc","speciesDesc"],"landReport":["speciesDesc","speciesDesc"],"airReport":["speciesDesc","speciesDesc"]}`
	packagingInfo =`{"packid":"1101","cid":"1101","baseId":"baseId","plotId":"plotId","sid":"1101","bno":"1102","packInfo":"packInfo","bizType":"bizType","pno":"bizType","packCount":0,"packUnit":"packUnit","packDate":"packUnit","packPics":["speciesDesc","speciesDesc"],"principalId":"packUnit","principal":"packUnit"}`
	salesInfo =`{"id":"1101","cid":"1101","baseId":"baseId","plotId":"plotId","sid":"sid","bno":"1101","saleInfo":"saleInfo","bizType":"bizType","sno":"1101","customer":"customer","saleCount":0,"packingSize":"customer","saleDate":"saleDate","salePics":"salePics","trackingNo":"trackingNo","logisticsName":"logisticsName","did":0,"principalId":"principalId","principal":"principalId","commissionRatio":0}`
	qrcode =`{"p_no":"1102","start_number":0,"count":100,"product_show":{"product_name":true,"pick_date":true,"expiration_date":10,"product_type":true,"product_no":true,"stoage_mode":"低温保存","product_des":true,"product_files":["speciesDesc","speciesDesc"]},"retrospect_show":{"base_name":"1101","polt_name":"1101","species_name":"1101","plant_activity":"1101","plant_test":"1101","plant_pick":"1101",
"quality_test":"1101","packaging":"1101","sale_info":"1101","logistics_info":false,"base_files":["speciesDesc","speciesDesc"]},"quality_test_show":{"qtId":"1101","detection":false,"detection_mode":false,"detection_tiem":false,"detection_result":false,"detection_people":false,"detection_paper":false,"land_detection_paper":false,"write_detection_paper":false,"air_detection_paper":false},"company_show":
{"cid":"1101","principal":false,"principal_phone":false,"company_name":false,"company_person":false,"company_address":false,"company_intro":false,"business_license":false}}`
)

func TestAddActivityInfo(t *testing.T) {
	cc := new(Retrospect)
	stub := shim.NewMockStub("RetrospectCC",cc)
	stub.MockInit("init",nil)
	//var testResult bool
	print := true

	responseByAddBus := stub.MockInvoke("invoke1",[][]byte{[]byte("addCompanyInfo"),[]byte(companyInfo)})
	if responseByAddBus.Status != 200{
		//testResult = false
		t.Error(responseByAddBus.Message)
	}else if print{
		fmt.Println(string(responseByAddBus.Payload))
	}
	responsedealerInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addDealerInfo"),[]byte(dealerInfo)})
	if responsedealerInfo.Status != 200{
		//testResult = false
		t.Error(responsedealerInfo.Message)
	}else if print{
		fmt.Println(string(responsedealerInfo.Payload))
	}
	responsedetectionInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addDetectionInfo"),[]byte(detectionInfo)})
	if responsedetectionInfo.Status != 200{
		//testResult = false
		t.Error(responsedetectionInfo.Message)
	}else if print{
		fmt.Println(string(responsedetectionInfo.Payload))
	}
	responsesupplierInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addSupplierInfo"),[]byte(supplierInfo)})
	if responsesupplierInfo.Status != 200{
		//testResult = false
		t.Error(responsesupplierInfo.Message)
	}else if print{
		fmt.Println(string(responsesupplierInfo.Payload))
	}
	responsepecies := stub.MockInvoke("invoke1",[][]byte{[]byte("addPeciesInfo"),[]byte(pecies)})
	if responsepecies.Status != 200{
		//testResult = false
		t.Error(responsepecies.Message)
	}else if print{
		fmt.Println(string(responsepecies.Payload))
	}
	responseresumeInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addResumeInfo"),[]byte(resumeInfo)})
	if responseresumeInfo.Status != 200{
		//testResult = false
		t.Error(responseresumeInfo.Message)
	}else if print{
		fmt.Println(string(responseresumeInfo.Payload))
	}
	responsebaseInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addBaseInfo"),[]byte(baseInfo)})
	if responsebaseInfo.Status != 200{
		//testResult = false
		t.Error(responsebaseInfo.Message)
	}else if print{
		fmt.Println(string(responsebaseInfo.Payload))
	}
	responseplotInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addPlotInfo"),[]byte(plotInfo)})
	if responseplotInfo.Status != 200{
		//testResult = false
		t.Error(responseplotInfo.Message)
	}else if print{
		fmt.Println(string(responseplotInfo.Payload))
	}
	responseequipmentInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addEquipmentInfo"),[]byte(equipmentInfo)})
	if responseequipmentInfo.Status != 200{
		//testResult = false
		t.Error(responseequipmentInfo.Message)
	}else if print{
		fmt.Println(string(responseequipmentInfo.Payload))
	}
	responseequipUsedRecord := stub.MockInvoke("invoke1",[][]byte{[]byte("addEquipUsedRecord"),[]byte(equipUsedRecord)})
	if responseequipUsedRecord.Status != 200{
		//testResult = false
		t.Error(responseequipUsedRecord.Message)
	}else if print{
		fmt.Println(string(responseequipUsedRecord.Payload))
	}
	responsepurchaseInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addPurchaseInfo"),[]byte(purchaseInfo)})
	if responsepurchaseInfo.Status != 200{
		//testResult = false
		t.Error(responsepurchaseInfo.Message)
	}else if print{
		fmt.Println(string(responsepurchaseInfo.Payload))
	}
	responsereceive := stub.MockInvoke("invoke1",[][]byte{[]byte("addReceiveInfo"),[]byte(receive)})
	if responsereceive.Status != 200{
		//testResult = false
		t.Error(responsereceive.Message)
	}else if print{
		fmt.Println(string(responsereceive.Payload))
	}
	responsepattern := stub.MockInvoke("invoke1",[][]byte{[]byte("addPatternInfo"),[]byte(pattern)})
	if responsepattern.Status != 200{
		//testResult = false
		t.Error(responsepattern.Message)
	}else if print{
		fmt.Println(string(responsepattern.Payload))
	}
	resactivityInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addActivityInfo"),[]byte(activityInfo)})
	if resactivityInfo.Status != 200{
		//testResult = false
		t.Error(resactivityInfo.Message)
	}else if print{
		fmt.Println(string(resactivityInfo.Payload))
	}
	resquarantineInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addPlantingQuarantineInfo"),[]byte(quarantineInfo)})
	if resquarantineInfo.Status != 200{
		//testResult = false
		t.Error(resquarantineInfo.Message)
	}else if print{
		fmt.Println(string(resquarantineInfo.Payload))
	}
	resharvesinfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addPlantingHarvesinfo"),[]byte(harvesinfo)})
	if resharvesinfo.Status != 200{
		//testResult = false
		t.Error(resharvesinfo.Message)
	}else if print{
		fmt.Println(string(resharvesinfo.Payload))
	}
	resqualityTesting := stub.MockInvoke("invoke1",[][]byte{[]byte("addQualityTestInfo"),[]byte(qualityTesting)})
	if resqualityTesting.Status != 200{
		//testResult = false
		t.Error(resqualityTesting.Message)
	}else if print{
		fmt.Println(string(resqualityTesting.Payload))
	}
	respackagingInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addPackingInfo"),[]byte(packagingInfo)})
	if respackagingInfo.Status != 200{
		//testResult = false
		t.Error(respackagingInfo.Message)
	}else if print{
		fmt.Println(string(respackagingInfo.Payload))
	}
	ressalesInfo := stub.MockInvoke("invoke1",[][]byte{[]byte("addsaleInfo"),[]byte(salesInfo)})
	if ressalesInfo.Status != 200{
		//testResult = false
		t.Error(ressalesInfo.Message)
	}else if print{
		fmt.Println(string(ressalesInfo.Payload))
	}
	resqrcode := stub.MockInvoke("invoke1",[][]byte{[]byte("addReprospectShowInfo"),[]byte(qrcode)})
	if resqrcode.Status != 200{
		//testResult = false
		t.Error(resqrcode.Message)
	}else if print{
		fmt.Println(string(resqrcode.Payload))
	}
	resSearch := stub.MockInvoke("invoke1",[][]byte{[]byte("searchRespectInfo"),[]byte("1102"),[]byte("89")})
	if resSearch.Status != 200{
		//testResult = false
		t.Error(resSearch.Message)
	}else if print{
		fmt.Println(string(resSearch.Payload))
	}
	resSearch1 := stub.MockInvoke("invoke1",[][]byte{[]byte("searchRespectInfo"),[]byte("1102"),[]byte("89")})
	if resSearch1.Status != 200{
		//testResult = false
		t.Error(resSearch1.Message)
	}else if print{
		fmt.Println(string(resSearch1.Payload))
	}
}