package main

import (
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)

func TestGetCommonName(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("getCertCommonName")})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

}


//7455	    162316 ns/op
//5402	    214421 ns/op
func BenchmarkPut(b *testing.B){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(schemaCheck)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println()
	fmt.Println("========================================invoke schema get============================================")
	fmt.Println()
	fmt.Println()
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))

	for i:=0;i<b.N ;i++  {
		responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputCs)})
		if responseByPut.Status != 200{
			fmt.Println()
			fmt.Println("========================================invoke data put============================================")
			fmt.Println()
			fmt.Println()
			fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
				responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))
			return
		}
	}

}
