package main

import (
	"encoding/json"
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"reflect"
	"testing"
)

var (
	SchemaNew = `{"leadger_fields":{"abail":{"val":"0001-01-01T00:00:00Z","auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1584936259}},"issue":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},
"extrate":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"transfer":{"users":null,"roles":null}},
"fcheck":{"ftype":"big.int","must":false,"fieldlen":1}},"sabail":{"val":"0001-01-01T00:00:00Z","auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"issue":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1584936259}},"extrate":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},
"transfer":{"users":null,"roles":null}},"fcheck":null}},"storage_fields":{"common_name":{"val":"1","auth":{"read":{"users":null,"roles":null},
"write":{"users":null,"roles":null}},"fcheck":null},"alinkman":{"val":10.34,"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"float64","must":true,"fieldlen":1}},"amob":{"val":"0001-01-01T00:00:00Z",
"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"time.Time","must":true,"fieldlen":0}},
"aname":{"val":"Aname","auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":
{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"string","must":true,"fieldlen":16}},
"atype":{"val":100,"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"int","must":true,"fieldlen":1}},"backup":
{"val":{"aname":"Aname","atype":"Atype"},"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},
"write":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":null},"id":{"val":"1","auth":{"read":
{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":null}},"schema_auth":{"read":{"users":null,"roles":null},
"write":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":0}}},"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":0}},"write":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":0}}}}`
	merSchema = `{"leadger_fields":{"regular":{"val":6000,"auth":{"read":{"users":null,"roles":null},"issue":{"users":null,"roles":null},"extrate":{"users":null,"roles":null},"transfer":{"users":null,
"roles":null}},"fcheck":{"ftype":"big.int","must":false,"fieldlen":6}},"rregular":{"val":6000,"auth":{"read":{"users":null,"roles":null},"issue":{"users":null,"roles":null},"extrate":{"users":null,"roles"
:null},"transfer":{"users":null,"roles":null}},"fcheck":{"ftype":"big.int","must":false,"fieldlen":6}}},"storage_fields":{"common_name":{"val":"1","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":null},
"acid":{"val":3,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles"
:null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"actionid":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,
"fieldlen":6}},"adiscounts":{"val":"0.8","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"aid":{"val":0,"auth":{"read":
{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"are":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":
null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"backup":{"val":{},"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":null},"cid":{"val":0,"auth":{"read":
{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"cosperson":{"val":100,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,
"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"did":{"val":2,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,
"fieldlen":6}},"dineraprice":{"val":80,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"dinerprice":{"val":100,"auth":
{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"dinersprice":{"val":90,"auth":{"read":{"users":null,"roles":null},"write":
{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"distype":{"val":16,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":
"float64","must":false,"fieldlen":6}},"esign":{"val":"2010-12-31 15:38:54","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}}
,"fid":{"val":4,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"firrenew":{"val":"2010-01-02 15:38:54","auth":{"read":
{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"haver":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"id":{"val":"1","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":false,"fieldlen":6}},"indate":{"val":"2018/10/29  16:46:57","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"ischain":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"isset":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"issnp":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"keywords":{"val":"test","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"licence":{"val":"103451015521","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"linedate":{"val":"2010-01-02 15:38:54","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"mact":{"val":"123456","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"mactname":{"val":"联系人1","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"maddr":{"val":"测试地址1","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"marea":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"mbtype":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"mdiposit":{"val":"中国银行","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"mlinkman":{"val":"联系人1","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"mlinkmob":{"val":"18555555555","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"mname":{"val":"测试连锁店1","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"mno":{"val":"59118600000005","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"mno2":{"val":"05910005","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"msubtype":{"val":10,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"mtype":{"val":9,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"murl":{"val":"http://www.baidu.com","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"ordertel":{"val":"13444444444","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"paystatue":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"perquisites":{"val":3,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"persales":{"val":100,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"pname":{"val":"8820180008552970","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"ppass":{"val":"152820","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"relevel":{"val":5,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"retype":{"val":0,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"sdiscounts":{"val":"0.85","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"shophours":{"val":"24小时营业","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"sregular":{"val":6000,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"ssign":{"val":"2010-01-01 15:38:54","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"string","must":true,"fieldlen":160}},"statue":{"val":0,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"supperaprice":{"val":90,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"supperprice":{"val":120,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"suppersprice":{"val":110,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"tstatue":{"val":1,"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}},"warmline":{"val":"600","auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":{"ftype":"float64","must":false,"fieldlen":6}}},"schema_auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}},"auth":{"read":{"users":null,"roles":null},"write":{"users":null,"roles":null}}}
`
	merarrary = `[{
    "id": "1",
    "mname": "测试连锁店1",
    "maddr": "测试地址1",
    "mlinkman": "联系人1",
    "mlinkmob": "18555555555",
    "mtype": 9,
    "mact": "123456",
    "mdiposit": "中国银行",
    "mactname": "联系人1",
    "licence": "103451015521",
    "murl": "http://www.baidu.com",
    "mno": "59118600000005",
    "mno2": "05910005",
    "indate": "2018/10/29  16:46:57",
    "aid": 0,
    "regular": "60000000",
    "adiscounts": 0.8,
    "sdiscounts": 0.85,
    "distype": 16,
    "msubtype": 10,
    "ischain": 1,
    "cosperson": 100,
    "statue": 0,
    "retype": 0,
    "did": 2,
    "warmline": 600,
    "cid": 0,
    "sregular": 60000000,
    "keywords": "test",
    "paystatue": 1,
    "are": 1,
    "marea": 1,
    "actionid": 1,
    "tstatue": 1,
    "rregular": "60000000",
    "ssign": "2010-01-01 15:38:54",
    "firrenew": "2010-01-02 15:38:54",
    "ordertel": "13444444444",
    "shophours": "24小时营业",
    "persales": 100,
    "linedate": "2010-01-02 15:38:54",
    "issnp": 1,
    "esign": "2010-12-31 15:38:54",
    "fid": 4,
    "acid": 3,
    "pname": "8820180008552970",
    "ppass": "152820",
    "isset": 1,
    "haver": 1,
   
    "dinerprice": 100,
    "dinersprice": 90,
    "dineraprice": 80,
  
    "supperprice": 120,
    "suppersprice": 110,
    "supperaprice": 90,
    "common_name":"",
    "perquisites": 3,
    "relevel": 5,
    "mbtype": 1,
    "backup": {}
  },{
    "id": "2",
    "mname": "测试连锁店1",
    "maddr": "测试地址1",
    "mlinkman": "联系人1",
    "mlinkmob": "18555555555",
    "mtype": 9,
    "mact": "123456",
    "mdiposit": "中国银行",
    "mactname": "联系人1",
    "licence": "103451015521",
    "murl": "http://www.baidu.com",
    "mno": "59118600000005",
    "mno2": "05910005",
    "indate": "2018/10/29  16:46:57",
    "aid": 0,
    "regular": "60000000",
    "adiscounts": 0.8,
    "sdiscounts": 0.85,
    "distype": 16,
    "msubtype": 10,
    "ischain": 1,
    "cosperson": 100,
    "statue": 0,
    "retype": 0,
    "did": 2,
    "warmline": 600,
    "cid": 0,
    "sregular": 6000,
    "keywords": "test",
    "paystatue": 1,
    "are": 1,
    "marea": 1,
    "actionid": 1,
    "tstatue": 1,
    "rregular": "60000000",
    "ssign": "2010-01-01 15:38:54",
    "firrenew": "2010-01-02 15:38:54",
    "ordertel": "13444444444",
    "shophours": "24小时营业",
    "persales": 100,
    "linedate": "2010-01-02 15:38:54",
    "issnp": 1,
    "esign": "2010-12-31 15:38:54",
    "fid": 4,
    "acid": 3,
    "pname": "8820180008552970",
    "ppass": "152820",
    "isset": 1,
    "haver": 1,
   
    "dinerprice": 100,
    "dinersprice": 90,
    "dineraprice": 80,
  
    "supperprice": 120,
    "suppersprice": 110,
    "supperaprice": 90,
    "common_name":"",
    "perquisites": 3,
    "relevel": 5,
    "mbtype": 1,
    "backup": {}
  }]`
	SchemaPutNew = `{"leadger_fields":{},"storage_fields":{"common_name":{"val":"1","auth":{"read":{"users":null,"roles":null},
"write":{"users":null,"roles":null}},"fcheck":null},"alinkman":{"val":10.34,"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"float64","must":true,"fieldlen":1}},"amob":{"val":"0001-01-01T00:00:00Z",
"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"time.Time","must":true,"fieldlen":0}},
"aname":{"val":"Aname","auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":
{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"string","must":true,"fieldlen":16}},
"atype":{"val":100,"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"int","must":true,"fieldlen":1}},"backup":
{"val":{"aname":"Aname","atype":"Atype"},"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},
"write":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":null},"id":{"val":"1","auth":{"read":
{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":null}},"schema_auth":{"read":{"users":null,"roles":null},
"write":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":0}}},"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":0}},"write":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":0}}}}`

	SchemaUpdate = `{"leadger_fields":{"abail22":{"val":"0","auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1584936259}},"issue":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},
"extrate":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"transfer":{"users":null,"roles":null}},
"fcheck":{"ftype":"big.int","must":true,"fieldlen":1}},"sabail":{"val":"0001-01-01T00:00:00Z","auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"issue":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1584936259}},"extrate":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},
"transfer":{"users":null,"roles":null}},"fcheck":null}},"storage_fields":{"common_name":{"val":"1","auth":{"read":{"users":null,"roles":null},
"write":{"users":null,"roles":null}},"fcheck":null},"alinkmanNew":{"val":10.34,"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"float64","must":true,"fieldlen":1}},"amob":{"val":"0001-01-01T00:00:00Z",
"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"time.Time","must":true,"fieldlen":0}},
"aname":{"val":"Aname","auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":
{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"string","must":true,"fieldlen":6}},
"atype":{"val":100,"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":{"ftype":"int","must":true,"fieldlen":1}},"backup":
{"val":{"aname":"Aname","atype":"Atype"},"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}},
"write":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1584936259}}},"fcheck":null},"id":{"val":"1","auth":{"read":
{"users":null,"roles":null},"write":{"users":null,"roles":null}},"fcheck":null}},"schema_auth":{"read":{"users":null,"roles":null},
"write":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":0}}},"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":0}},"write":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":0}}}}`


)

func TestGXHSchemaPut(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println("========================================invoke schema put============================================")
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(SchemaNew)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println()
	fmt.Println("========================================invoke schema get============================================")
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke schema update============================================")
	responseByupdate := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("update"),[]byte("alibusi"),[]byte(SchemaUpdate)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByupdate.Status,responseByupdate.Message,string(responseByupdate.Payload))
	fmt.Println("========================================invoke schema get============================================")
	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
	fmt.Println()
}


func TestGXHCreateAccount(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(SchemaNew)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println()
	fmt.Println("========================================invoke createAccount============================================")
	fmt.Println()
	fmt.Println()
	responseBycreate := stub.MockInvoke("invoke1",[][]byte{[]byte("createAccount"), []byte("alibusi"),[]byte(inputarrary)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseBycreate.Status,responseBycreate.Message,string(responseBycreate.Payload))
	fmt.Println()
	fmt.Println()
	fmt.Println("========================================invoke updateStoreData============================================")
	fmt.Println()
	fmt.Println()
	responseByputData := stub.MockInvoke("invoke1",[][]byte{[]byte("upStoreData"), []byte("alibusi"),[]byte(inputUpdate)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByputData.Status,responseByputData.Message,string(responseByputData.Payload))
	fmt.Println()
	fmt.Println()
	fmt.Println("========================================invoke get============================================")
	fmt.Println()
	fmt.Println()
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(inputUpdate)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))

}

func TestGXHPutData(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(SchemaPutNew)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println()
	fmt.Println("========================================invoke putData============================================")
	fmt.Println()
	fmt.Println()
	responseByputData := stub.MockInvoke("invoke1",[][]byte{[]byte("putData"), []byte("alibusi"),[]byte(inputPutarray)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByputData.Status,responseByputData.Message,string(responseByputData.Payload))
	fmt.Println()
}

var (
	issueTx = `{"account_type":"alibusi","account_id":"1","action_amount":"1230","fund_type":"abail","back_up":{"account_type":"","account_id":"","action_amount":0,"fund_type":"","back_up":null}}`
	extract = `{"account_type":"alibusi","account_id":"1","action_amount":"123","fund_type":"abail","back_up":{"account_type":"","account_id":"","action_amount":0,"fund_type":"","back_up":null}}`
	commontx = `{"sender_account":"alibusi","sender_id":"1","sender_funt":"abail","receiver_account":"alibusi","receiver_account_id":"2","receiver_funt":"abail","amount":"223"}`
	merTx = `{"mid":"1","bid":"1","tamount":"18050100","treposit":"16988320","bereposit":"60000000","afreposit":"43011700","feerate":0.0055,"fee":"99275","oamount":"21235400","adiscounts":0.8,"sdiscounts":0.85,"nodisamount":"0","disamount":"0","perquisites":"0"}
`
)

func TestGXHIssueandExtract(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(SchemaNew)})
	if responseByPutschema.Status != 200{
		t.Errorf("schema init fail,err: %s",responseByPutschema.Message)
	}
	fmt.Println()
	responseBycreate := stub.MockInvoke("invoke1",[][]byte{[]byte("createAccount"), []byte("alibusi"),[]byte(inputarrary)})
	if responseBycreate.Status != 200{
		t.Errorf("createAccount init fail,err: %s",responseBycreate.Message)
	}
	fmt.Println()
	responseByIssue := stub.MockInvoke("invoke1",[][]byte{[]byte("createTx"), []byte("issue"),[]byte(issueTx)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByIssue.Status,responseByIssue.Message,string(responseByIssue.Payload))
	fmt.Println()
	responseByextract := stub.MockInvoke("invoke1",[][]byte{[]byte("createTx"), []byte("extract"),[]byte(extract)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByextract.Status,responseByextract.Message,string(responseByextract.Payload))
	fmt.Println()
	fmt.Println()
	responseBytx := stub.MockInvoke("invoke1",[][]byte{[]byte("createTx"), []byte("transfer"),[]byte("commontx"),[]byte(commontx)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseBytx.Status,responseBytx.Message,string(responseBytx.Payload))
	fmt.Println()
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"2"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
}

/*
	测试商户交易
*/
//736288 590270 620798
func TestGXHmerTx(t *testing.T){
	stub := GXHmerTxinit()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("createTx"), []byte("transfer"),[]byte("merchants"),[]byte(merTx)})
	if responseByPutschema.Status != 200{
		fmt.Printf("schema init fail,err: %s",responseByPutschema.Message)
	}
	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("merchants"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
}



func GXHmerTxinit()*shim.MockStub{
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(SchemaNew)})
	if responseByPutschema.Status != 200{
		fmt.Printf("schema put alibusi fail,err: %s",responseByPutschema.Message)
		return stub
	}

	responseBycreate := stub.MockInvoke("invoke1",[][]byte{[]byte("createAccount"), []byte("alibusi"),[]byte(inputarrary)})
	if responseBycreate.Status != 200{
		fmt.Printf("createAccount alibusi fail,err: %s",responseBycreate.Message)
		return stub
	}
	fmt.Println()
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	responseByMerschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("merchants"),[]byte(merSchema)})
	if responseByMerschema.Status != 200{
		fmt.Printf("schema put merchants fail,err: %s",responseByMerschema.Message)
		return stub
	}
	responseBycreateMer := stub.MockInvoke("invoke1",[][]byte{[]byte("createAccount"), []byte("merchants"),[]byte(merarrary)})
	if responseBycreateMer.Status != 200{
		fmt.Printf("createAccount merchants fail,err: %s",responseBycreateMer.Message)
		return stub
	}

	return stub
}

func TestDeassign(t *testing.T) {
	var m map[string]interface{}
	err := json.Unmarshal([]byte(commontx),&m)
	if err != nil{
		t.Errorf(err.Error())
	}
	onwer,_ := m["sender_account"].(float64)
	//fmt.Println(ok)
	fmt.Println(onwer == 0)
}

//5958 5242  5600 5909
func BenchmarkBackUpCheck(b *testing.B) {
	var m map[string]interface{}
	err := json.Unmarshal([]byte(commontx),&m)
	if err != nil{
		fmt.Println(err.Error())
		return
	}
	for i:=0;i<b.N ;i++  {
		fmt.Println( reflect.DeepEqual(m["sender_account"] , m["receiver_account"]))
	}
}

