package main

import (
	"encoding/json"
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)

var (
	BusinessData = `{"id":100,"cid":101,"cname":"中心","userId":100,"userName":"中心","idNo":"测试数据","mobile":"测试数据","lno":"测试数据","tradeDate":"测试数据","tradeAddress":"测试数据","hospital":"测试数据","amount":"测试数据",
"remark":"测试数据","createTime":"测试数据","updateTime":"测试数据","imageKeys":["测试","ceshi"],"fileKeys":["测试","ceshi"],"chips":[{"chipSno":"","packInfo":"","packCount":0},{"chipSno":"","packInfo":"","packCount":0}]}`
	CompanyData =`{"id":100,"businessLicense":"测试数据","cname":"测试数据","cmpanyAddress":"测试数据","companyDesc":"测试数据","companyType":"测试数据","contactPhone":"测试数据","contacts":"测试数据","legalPerson":"测试数据","status":1}`
    InvoiceData =`{"id":100,"cid":100,"cname":"测试数据","uid":100,"userName":"测试数据","idNo":"测试数据","mobile":"测试数据","invoiceNo":"发票单号","lno":"测试数据","billingUnit":"测试数据","billingType":100,"receiveUnit":"测试数据",
  "amount":100.0099,"remark":"测试数据","invoiceType":1,"ProductCodes":["测试","ceshi"],"lnoKeys":["测试","ceshi"],"imageKeys":["测试","ceshi"],"fileKeys":["测试","ceshi"]}`
	UseDate = `{"lno":"测试数据","chipSno":"测试数据1","productNo":"测试数据","userId":100,"usedTime":"测试数据","imageKeys":["测试","ceshi"],"fileKeys":["测试","ceshi"],"videoKeys":["测试","ceshi"]}`
	UseDate2 = `{"lno":"测试数据","chipSno":"测试数据2","productNo":"测试数据","userId":100,"usedTime":"测试数据","imageKeys":["测试","ceshi"],"fileKeys":["测试","ceshi"],"videoKeys":["测试","ceshi"]}`

)

func TestJsonByte(t *testing.T){
	business := BizInfoDto{
		Id  :100,
		Cid     :101,
		Cname  :"中心",
		UserId  :100,
		UserName :"中心",
		IdNo   :"测试数据",
		Mobile  :"测试数据",
		Lno  :"测试数据",
		TradeDate:"测试数据",
		TradeAddress :"测试数据",
		Hospital   :"测试数据",
		Amount   :"测试数据",
		Remark   :"测试数据",
		CreateTime :"测试数据",
		UpdateTime:"测试数据",
		ImageKeys  :[]string{"测试","ceshi"},
		FileKeys   :[]string{"测试","ceshi"},
		Chips  :[]ChipPacking{ChipPacking{},ChipPacking{}},
	}
	marshalStruct(business)

	//company:=&CompanyInfo{
	//	Id :100,
	//	BusinessLicense  :"测试数据",
	//	Cname 		:"测试数据",
	//	CmpanyAddress  :"测试数据",
	//	CompanyDesc  :"测试数据",
	//	CompanyType  :"测试数据",
	//	ContactPhone :"测试数据",
	//	Contacts   :"测试数据",
	//	LegalPerson  :"测试数据",
	//	Status   :1,
	//}
	//marshalStruct(company)
//invoiceInfo := &InvoiceInfoDto{
//	Id  	 :100,
//	Cid    :100,
//	Cname   :"测试数据",
//	Uid     :100,
//	UserName:"测试数据",
//	IdNo    :"测试数据",
//	Mobile  :"测试数据",
//	//TaxId   string   `json:"taxId"`   //税号
//	InvoiceNo :"测试数据",
//	Lno   :"测试数据",
//	BillingUnit :"测试数据",
//	BillingType  :100,
//	ReceiveUnit :"测试数据",
//	Amount   :100.0099,
//	Remark   :"测试数据",
//	InvoiceType  :1,
//	ProductCodes  :[]string{"测试","ceshi"},
//	LnoKeys    :[]string{"测试","ceshi"},
//	ImageKeys   :[]string{"测试","ceshi"},
//	FileKeys   :[]string{"测试","ceshi"},
//}
//	marshalStruct(invoiceInfo)

//usedInfo:= ChipUsedDto{
//	Lno    :"测试数据",
//	ChipSno  :"测试数据1",
//	ProductNo :"测试数据",
//	UserId   :100,
//	UsedTime :"测试数据",
//	ImageKeys  :[]string{"测试","ceshi"},
//	FileKeys    :[]string{"测试","ceshi"},
//	VideoKeys  :[]string{"测试","ceshi"},
//}
//	marshalStruct(usedInfo)
}

func marshalStruct(arg interface{}){
	argByte,err := json.Marshal(arg)
	if err!=nil{
		panic(err)
		return
	}
	fmt.Println(string(argByte))
}

func TestSearchTransferListByInvoiceNo(t *testing.T) {
	cc := new(Medical)
	stub := shim.NewMockStub("BeanCC",cc)
	stub.MockInit("init",nil)
    //var testResult bool
	 print := true

	responseByAddBus := stub.MockInvoke("invoke1",[][]byte{[]byte("addBusinessInfo"),[]byte(BusinessData)})
	if responseByAddBus.Status != 200{
		//testResult = false
		t.Error(responseByAddBus.Message)
	}else if print{
		fmt.Println(string(responseByAddBus.Payload))
	}
	responseByAddCom := stub.MockInvoke("invoke1",[][]byte{[]byte("addCompanyInfo"),[]byte(CompanyData)})
	if responseByAddCom.Status != 200{
		//testResult = false
		t.Error(responseByAddCom.Message)
	}else if print{
		fmt.Println(string(responseByAddCom.Payload))
	}
	responseByAddInvoice := stub.MockInvoke("invoke1",[][]byte{[]byte("addInvoiceInfo"),[]byte(InvoiceData)})
	if responseByAddInvoice.Status != 200{
		//testResult = false
		t.Error(responseByAddInvoice.Message)
	}else if print{
		fmt.Println(string(responseByAddInvoice.Payload))
	}
	responseByAddUse := stub.MockInvoke("invoke1",[][]byte{[]byte("addUseInfo"),[]byte(UseDate)})
	if responseByAddUse.Status != 200{
		//testResult = false
		t.Error(responseByAddUse.Message)
	}else if print{
		fmt.Println(string(responseByAddUse.Payload))
	}
	responseByAddUse2 := stub.MockInvoke("invoke1",[][]byte{[]byte("addUseInfo"),[]byte(UseDate2)})
	if responseByAddUse2.Status != 200{
		//testResult = false
		t.Error(responseByAddUse2.Message)
	}else if print{
		fmt.Println(string(responseByAddUse2.Payload))
	}
	responseBySearchList := stub.MockInvoke("invoke1",[][]byte{[]byte("searchTransferList"),[]byte("发票单号")})
	if responseBySearchList.Status != 200{
		//testResult = false
		t.Error(responseBySearchList.Message)
	}else if print{
		fmt.Println(string(responseBySearchList.Payload))
	}

}