package main

import (
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)

func TestGXHCC(t *testing.T) {
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println(string(response.Payload))
	input := `{"aname":"alibusi","aname":"alibus","atype":"type","alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"","aader":"aader","amob":"1234567890"}}`
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s \n",responseByget.Status,responseByget.Message,string(responseByget.Payload))
	return
	input2 := `{"id":"1","aname":"aaa","atype":"aaa","alinkman":"cc","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"aaa","aader":"aader","amob":"1234567890"}}`
	responseByPut2 := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(input2)})
	fmt.Printf("Invoke22 status %d,message %s and payload %s\n",responseByPut2.Status,responseByPut2.Message,string(responseByPut2.Payload))
	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke22 status %d,message %s and payload %s",responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
}

func TestGXHSchema(t *testing.T){

//	input := `{"id":"1","aname":"alibusi","aname":"alibus","atype":"type","alinkman":"","aader":"aader",
//"amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"",
//"aader":"aader","amob":"1234567890"}}`

	schema := `{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"fields":{"acid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":3},"id":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"1"},"actionid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"adiscounts":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"0.8"},"aid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"altdate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-01 15:38:54"},"are":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"backup":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":{}},"cid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"contract":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"16161616032"},"cosperson":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":100},"did":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":2},"dineraprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":80},"dineretime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"15:30:59"},"dinerprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":100},"dinersprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":90},"dinerstime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"11:10:00"},"distype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":16},"dledate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-01 15:38:54"},"esign":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-12-31 15:38:54"},"fid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":4},"firrenew":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-02 15:38:54"},"haver":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"indate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2018/10/29  16:46:57"},"ischain":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"isset":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"issnp":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"keywords":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"test"},"lat":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"43.840345"},"licence":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"103451015521"},"linedate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-02 15:38:54"},"lng":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"125.28796"},"mact":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"123456"},"mactname":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"联系人1"},"maddr":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"测试地址1"},"marea":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"mbtype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"mdiposit":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"中国银行"},"mlinkman":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"联系人1"},"mlinkmob":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"18555555555"},"mname":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"测试连锁店1"},"mno":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"59118600000005"},"mno2":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"05910005"},"msubtype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":10},"mtype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":9},"murl":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"http://www.baidu.com"},"ordertel":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"13444444444"},"paystatue":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"perquisites":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":3},"persales":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":100},"pname":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"8820180008552970"},"ppass":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"152820"},"regular":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":6000},"relevel":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":5},"retype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"rregular":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":6000},"sdiscounts":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"0.85"},"shophours":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"24小时营业"},"sregular":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":6000},"ssign":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-01 15:38:54"},"statue":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"supperaprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":90},"supperetime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"23:59:59"},"supperprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":120},"suppersprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":110},"supperstime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"15:31:00"},"tstatue":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"mcode":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"11201700000003"},"warmline":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"600"}},"schema_auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}}}`
	inputarrary := `[{"id":"1","aname":"alibusi","atype":"type","alinkman":"",
"aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890"}},{"id":"2","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type",
"alinkman":"","aader":"aader","amob":"1234567890"}}]`

	update := `{"alinkman":"张三","id":"1","backup":{}}`
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println("MockInit Payload: ",string(response.Payload))

	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(schema)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))

	responseByGet := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByGet.Status,responseByGet.Message,string(responseByGet.Payload))
	fmt.Println()
	return
	fmt.Println("========================================invoke data put============================================")
	fmt.Println()
	fmt.Println()

	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputarrary)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))

	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))


	fmt.Println()
	fmt.Println("========================================invoke data update============================================")
	fmt.Println()
	fmt.Println()

	responseByUpdate := stub.MockInvoke("invoke1",[][]byte{[]byte("update"), []byte("alibusi"),[]byte(update)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByUpdate.Status,responseByUpdate.Message,string(responseByUpdate.Payload))

	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))

	//inputfail := `{"id":"2","atype":"type","alinkman":"","aader":"aader","amob":"1234567890","backup":{"id":"1","aname":"alibusi","atype":"type","alinkman":"","aader":"aader","amob":"1234567890"}}`
	//fmt.Println()
	//fmt.Println("========================================fail input data============================================")
	//
	//
	//responseByPutfail := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputfail)})
	//fmt.Printf("Invoke status %d,message %s and payload %s\n",
	//	responseByPutfail.Status,responseByPutfail.Message,string(responseByPutfail.Payload))
	//responseBygetfail := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	//fmt.Printf("Invoke status %d,message %s and payload %s \n",
	//	responseBygetfail.Status,responseBygetfail.Message,string(responseBygetfail.Payload))
}


func TestGXH(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	stub.MockInvoke("invoke1",[][]byte{[]byte("cert")})
}