package main

import (
	"encoding/json"
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)

var schemaCheck = `{"fields":{"alinkman":{"val":10.34,"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1583501961}},"write":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1583501961}}},"fcheck":{"ftype":"float64","must":true,"fieldlen":1}},
"amob":{"val":"0001-01-01T00:00:00Z","auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":
{"Admin@org2.example.com":1583501961}},"write":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":
1583501961}}},"fcheck":{"ftype":"time.Time","must":true,"fieldlen":0}},"aname":{"val":"Aname","auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1583501961}},"write":{"users":{"Admin@org2.example.com":0},
"roles":{"Admin@org2.example.com":1583501961}}},"fcheck":{"ftype":"string","must":true,"fieldlen":16}},"atype":{"val":100,
"auth":{"read":{"users":{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1583501961}},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1583501961}}},"fcheck":{"ftype":"int",
"must":true,"fieldlen":1}},"backup":{"val":{"aname":"Aname","atype":"Atype"},"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1583501961}},"write":{"users":{"Admin@org2.example.com":0},
"roles":{"Admin@org2.example.com":1583501961}}},"fcheck":null},"id":{"val":"1","auth":{"read":{"users":null,"roles":null},
"write":{"users":null,"roles":null}},"fcheck":null}},"schema_auth":{"read":{"users":null,"roles":null},"write":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":1583501961}}},"auth":{"read":{"users":
{"Admin@org2.example.com":0},"roles":{"Admin@org2.example.com":0}},"write":{"users":{"Admin@org2.example.com":0},
"roles":{"Admin@org2.example.com":0}}}}
`

var schemaupdate = `{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"fields":{"acid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":3},"id":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"1"},"actionid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"adiscounts":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"0.8"},"aid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"altdate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-01 15:38:54"},"are":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"backup":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":{}},"cid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"contract":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"16161616032"},"cosperson":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":100},"did":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":2},"dineraprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":80},"dineretime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"15:30:59"},"dinerprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":100},"dinersprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":90},"dinerstime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"11:10:00"},"distype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":16},"dledate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-01 15:38:54"},"esign":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-12-31 15:38:54"},"fid":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":4},"firrenew":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-02 15:38:54"},"haver":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"indate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2018/10/29  16:46:57"},"ischain":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"isset":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"issnp":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"keywords":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"test"},"lat":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"43.840345"},"licence":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"103451015521"},"linedate":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-02 15:38:54"},"lng":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"125.28796"},"mact":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"123456"},"mactname":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"联系人1"},"maddr":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"测试地址1"},"marea":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"mbtype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"mdiposit":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"中国银行"},"mlinkman":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"联系人1"},"mlinkmob":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"18555555555"},"mname":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"测试连锁店1"},"mno":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"59118600000005"},"mno2":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"05910005"},"msubtype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":10},"mtype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":9},"murl":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"http://www.baidu.com"},"ordertel":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"13444444444"},"paystatue":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"perquisites":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":3},"persales":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":100},"pname":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"8820180008552970"},"ppass":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"152820"},"regular":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":6000},"relevel":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":5},"retype":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"rregular":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":6000},"sdiscounts":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"0.85"},"shophours":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"24小时营业"},"sregular":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":6000},"ssign":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"2010-01-01 15:38:54"},"statue":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":0},"supperaprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":90},"supperetime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"23:59:59"},"supperprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":120},"suppersprice":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":110},"supperstime":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"15:31:00"},"tstatue":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":1},"mcode":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"11201700000003"},"warmline":{"auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}},"val":"600"}},"schema_auth":{"read":{"roles":null,"users":null},"write":{"roles":null,"users":null}}}`
var schema = `{"fields":{"alinkman":{"val":"Alinkman","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"amob":{"val":"Amob","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"aname":{"val":"Aname","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"atype":{"val":"Atype","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"backup":{"val":{"aname":"Aname","atype":"Atype"},"auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":
{"admin":0},"roles":{"admin":1582972202}}}},"id":{"val":"1","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}}},"schema_auth":{"read":{"users":null,"roles":null},"write":{"users":{"admin":0},"roles":{"admin":0}}},"auth":{"read":{"users":
{"admin":0},"roles":{"admin":0}},"write":{"users":{"admin":0},"roles":{"admin":1582972202}}}}
`
var schema2 = `{"fields":{"alinkman":{"val":"Alinkman","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"amob":{"val":"Amob","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"aname":{"val":"Aname","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"atype":{"val":"Atype","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"backup":{"val":{"aname":"Aname","atype":"Atype"},"auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":
{"admin":0},"roles":{"admin":1582972202}}}},"id":{"val":"1","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}}},"schema_auth":{"read":{"users":null,"roles":null},"write":{"users":{"admin":0},"roles":{"admin":1582972202}}},"auth":{"read":{"users":
{"admin":0},"roles":{"admin":0}},"write":{"users":{"admin":0},"roles":{"admin":0}}}}
`

var schema3 = `{"fields":{"alinkman":{"val":"Alinkman","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"amob":{"val":"Amob","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"aname":{"val":"Aname","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"atype":{"val":"Atype","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}},"backup":{"val":{"aname":"Aname","atype":"Atype"},"auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":
{"admin":0},"roles":{"admin":1582972202}}}},"id":{"val":"1","auth":{"read":{"users":{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":
{"admin":1582972202}}}}},"schema_auth":{"read":{"users":null,"roles":null},"write":{"users":{"admin":0},"roles":{"admin":1582972202}}},"auth":{"read":{"users":
{"admin":0},"roles":{"admin":1582972202}},"write":{"users":{"admin":0},"roles":{"admin":0}}}}
`
/*
	以下部分是增加权限内容的测试
*/

var (
	inputUpdate = `{"id":"1","aname":"alibusi","atype":"newtype","alinkman":"newalinkman",
"amob":"new1234567890","backup":{"aname":"alibusi","atype":"type"}}`

	inputarrary = `[{"id":"1","aname":"alibusi","atype":"type","alinkman":"alinkman",
"amob":"1234567890","backup":{"aname":"alibusi","atype":"type"}},{"id":"2","aname":"alibusi","atype":"type","alinkman":"alinkman",
"amob":"1234567890","backup":{"aname":"alibusi","atype":"type"}}]`
)
func TestGXHSchemaAuth(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(schemaupdate)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println()
	fmt.Println("========================================invoke schema get============================================")
	fmt.Println()
	fmt.Println()
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke schema update============================================")
	fmt.Println()
	fmt.Println()
	responseByupdate := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("update"),[]byte("alibusi"),[]byte(schemaupdate)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByupdate.Status,responseByupdate.Message,string(responseByupdate.Payload))
}

/*
	测试使用table 数据构建 schema
*/
func TestGXHSchemaAuthBytable(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(inputUpdate)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	fmt.Println()
	fmt.Println("========================================invoke schema get============================================")
	fmt.Println()
	fmt.Println()
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke schema update============================================")
	fmt.Println()
	fmt.Println()
	responseByupdate := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("update"),[]byte("alibusi"),[]byte(inputUpdate)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByupdate.Status,responseByupdate.Message,string(responseByupdate.Payload))
}

func TestGXHDataPutAuth(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(schema3)})
	//使用schema 数据测试过期时间err,schema right data,使用schema3 测试读取字段时的过滤
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data put============================================")
	fmt.Println()
	fmt.Println()
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputarrary)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))

	responseByget = stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data update============================================")
	fmt.Println()
	fmt.Println()
	responseByUpdate := stub.MockInvoke("invoke1",[][]byte{[]byte("update"), []byte("alibusi"),[]byte(inputUpdate)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByUpdate.Status,responseByUpdate.Message,string(responseByUpdate.Payload))

	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
}

var testData = `{"float64":10.33,"int":10,"string":"我中国人a！","time.Time":"2018-08-15 16:29:46"}`

func TestFieldCheck(t *testing.T){
	var testmap map[string]interface{}
	json.Unmarshal([]byte(testData),&testmap)
	intC := &Checks{
		FType:"int",
		Must:true,
		Fieldlen:1,
	}
	err := fieldCheckout(intC,testmap["int"])
	if err != nil{
		t.Error(err)
	}
	floatC := &Checks{
		FType:"float64",
		Must:true,
		Fieldlen:1,
	}
	err = fieldCheckout(floatC,testmap["float64"])
	if err != nil{
		t.Error(err)
	}
	stringC := &Checks{
		FType:"string",
		Must:true,
		Fieldlen:6,
	}
	err = fieldCheckout(stringC,testmap["string"])
	if err != nil{
		t.Error(err)
	}
	timeC := &Checks{
		FType:"time.Time",
		Must:true,
		Fieldlen:1,
	}
	err = fieldCheckout(timeC,testmap["time.Time"])
	if err != nil{
		t.Error(err)
	}
}


var (
	inputC = `{"id":"1","aname":"alibusi","atype":1000,"alinkman":1.233,
"amob":"new1234567890","backup":{"aname":"alibusi","atype":"type"}}`

	inputCs = `[{
	"id": "1",
	"aname": "alibusi",
	"atype": 102,
	"alinkman": 10.34,
	"amob": "2018-10-29  16:46:57",
	"backup": {
		"aname": "alibusi",
		"atype": "type"
	}
}, {
	"id": "2",
	"aname": "alibusi",
	"atype": 102,
	"alinkman": 10.34,
	"amob": "2018-10-29  16:46:57",
	"backup": {
		"aname": "alibusi",
		"atype": "type"
	}
}]`
)
/*
	本测试主要进行data put,update的测试操作，主要进行fieldcheck 的测试。
*/
func TestPut(t *testing.T){
	cc := new(GXHCC)
	stub := shim.NewMockStub("GXHCC",cc)
	stub.MockInit("init",nil)
	fmt.Println()
	fmt.Println("========================================invoke schema put============================================")
	fmt.Println()
	fmt.Println()
	responseByPutschema := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("put"),[]byte("alibusi"),[]byte(schemaCheck)})
	//使用schema 数据测试过期时间err,schema right data,使用schema3 测试读取字段时的过滤
	fmt.Printf("Invoke status %d,message %s and payload %s\n",
		responseByPutschema.Status,responseByPutschema.Message,string(responseByPutschema.Payload))
	responseByget := stub.MockInvoke("invoke1",[][]byte{[]byte("schema"), []byte("get"),[]byte("alibusi")})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data put============================================")
	fmt.Println()
	fmt.Println()
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"), []byte("alibusi"),[]byte(inputCs)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))

	responseByget = stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget.Status,responseByget.Message,string(responseByget.Payload))
	fmt.Println()
	fmt.Println("========================================invoke data update============================================")
	fmt.Println()
	fmt.Println()
	responseByUpdate := stub.MockInvoke("invoke1",[][]byte{[]byte("update"), []byte("alibusi"),[]byte(inputC)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s\n",
		responseByUpdate.Status,responseByUpdate.Message,string(responseByUpdate.Payload))

	responseByget2 := stub.MockInvoke("invoke1",[][]byte{[]byte("get"), []byte("alibusi"),[]byte(`{"id":"1"}`)})
	fmt.Printf("Invoke status %d,message %s ,and payload %s \n",
		responseByget2.Status,responseByget2.Message,string(responseByget2.Payload))
}


