package main

import (
	"fmt"
	"github.com/hyperledger/fabric/core/chaincode/shim"
	"testing"
)

func TestPutData(t *testing.T){
	cc := new(TestCC)
	stub := shim.NewMockStub("TestCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println(string(response.Payload))
	input := `[{"id":"1","aname":"共享惠","tablename":"alibusi"},{"id":"2","aname":"共享惠","tablename":"alibusi"}]`
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("put"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))
}

func TestPutNoData(t *testing.T){
	cc := new(TestCC)
	stub := shim.NewMockStub("TestCC",cc)
	response:= stub.MockInit("init",nil)
	fmt.Println(string(response.Payload))
	input := `[{"id":"1","aname":"共享惠","tablename":"alibusi"},{"id":"2","aname":"共享惠","tablename":"alibusi"}]`
	responseByPut := stub.MockInvoke("invoke1",[][]byte{[]byte("putNo"),[]byte(input)})
	fmt.Printf("Invoke status %d,message %s and payload %s\n",responseByPut.Status,responseByPut.Message,string(responseByPut.Payload))
}