package main

import (
	"fmt"

	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/errors"
	"github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/common/profile"
	lkeap "github.com/tencentcloud/tencentcloud-sdk-go/tencentcloud/lkeap/v20240522"
)

func main() {
        // 实例化一个认证对象，入参需要传入腾讯云账户 SecretId 和 SecretKey，此处还需注意密钥对的保密
        // 代码泄露可能会导致 SecretId 和 SecretKey 泄露，并威胁账号下所有资源的安全性
        // 以下代码示例仅供参考，建议采用更安全的方式来使用密钥
        // 请参见：https://cloud.tencent.com/document/product/1278/85305
        // 密钥可前往官网控制台 https://console.cloud.tencent.com/cam/capi 进行获取
        credential := common.NewCredential(
                "AKID64oLfmfLtESUJ6i8LPSM4gCVbiniQuBF",
                "rX2JMBnBMJ2YqulOo37xa5OUMSN4Xnpd",
        )
        // 使用临时密钥示例
        // credential := common.NewTokenCredential("SecretId", "SecretKey", "Token")
        // 实例化一个client选项，可选的，没有特殊需求可以跳过
        cpf := profile.NewClientProfile()
        cpf.HttpProfile.Endpoint = "lkeap.tencentcloudapi.com"
        // 实例化要请求产品的client对象,clientProfile是可选的
        client, _ := lkeap.NewClient(credential, "ap-guangzhou", cpf)

        // 实例化一个请求对象,每个接口都会对应一个request对象
        request := lkeap.NewReconstructDocumentSSERequest()
        
        request.FileType = common.StringPtr("TXT")
        request.FileBase64 = common.StringPtr("data:application/octet-stream;base64,4oCc6L+Z5bCx6LGh6Iqx5LiA5qC344CC5aaC5p6c5L2g54ix5LiK5LqG5LiA5py155Sf6ZW/IArlnKjkuIDpopfmmJ/mmJ/kuIrnmoToirHvvIzpgqPkuYjlpJzpl7TvvIwgCuS9oOeci+edgOWkqeepuuWwseaEn+WIsOeUnOicnOaEiSAK5b+r44CC5omA5pyJ55qE5pif5pif5LiK6YO9CuWlveixoeW8gOedgOiKseOAguKAnQ==")
        // 返回的resp是一个ReconstructDocumentSSEResponse的实例，与请求对象对应
        response, err := client.ReconstructDocumentSSE(request)
        if _, ok := err.(*errors.TencentCloudSDKError); ok {
                fmt.Printf("An API error has returned: %s", err)
                return
        }
        if err != nil {
                panic(err)
        }
        // 输出json格式的字符串回包
        if response.Response != nil {
            // 非流式响应
            fmt.Println(response.ToJsonString())
        } else {
            // 流式响应
            for event := range response.Events {
                fmt.Println(string(event.Data))
            }
        }
} 