-- Create the qa table if it doesn't exist
CREATE TABLE IF NOT EXISTS public.qa (
  id BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT NOW(),
  question TEXT,
  answer TEXT,
  summary TEXT,
  "from" TEXT,
  "to" TEXT,
  from_id TEXT,
  to_id TEXT,
  milvus BOOLEAN DEFAULT FALSE,
  graph BOOLEAN DEFAULT FALSE,
  CONSTRAINT qa_pkey PRIMARY KEY (id)
) TABLESPACE pg_default;

-- Create or replace the qa_latest_from_id view
CREATE OR REPLACE VIEW public.qa_latest_from_id AS
SELECT DISTINCT ON (qa.from_id)
  qa.id,
  qa.created_at,
  qa.question,
  qa.answer,
  qa.summary,
  qa."from",
  qa."to",
  qa.from_id,
  qa.to_id,
  qa.milvus,
  qa.graph
FROM
  qa
WHERE
  qa.from_id IS NOT NULL
ORDER BY
  qa.from_id,
  qa.created_at DESC;