package main

import (
	"io"
	"os"
	"runtime"
	"strings"

	"github.com/natefinch/lumberjack"
	"github.com/rs/zerolog"
	"github.com/rs/zerolog/log"
)

// 获取调用者的包名
func getPackageName() string {
	pc, _, _, ok := runtime.Caller(2) // 2 表示跳过当前函数和上一层
	if !ok {
		return "unknown"
	}
	fullName := runtime.FuncForPC(pc).Name()
	parts := strings.Split(fullName, ".")
	pkg := strings.Join(parts[:len(parts)-1], ".")
	return pkg
}

func loggingInit() {

	// debug := flag.Bool("debug", false, "sets log level to debug")
	// flag.Parse()

	zerolog.SetGlobalLevel(zerolog.InfoLevel)
	// if *debug {
	//     zerolog.SetGlobalLevel(zerolog.DebugLevel)
	// }

	// // Configure log rotation with lumberjack
	lumberjackLogger := &lumberjack.Logger{
		Filename: "/var/log/agent_chat.log",
		//Filename:   "agent_chat.log",
		MaxSize:    1,    // Max size in megabytes before log is rotated
		MaxBackups: 3,    // Max number of old log files to retain
		MaxAge:     28,   // Max number of days to retain old log files
		Compress:   true, // Compress old log files
	}

	// // Initialize a logger with rotating file output
	// logger := zerolog.New(lumberjackLogger).With().Timestamp().Logger()
	// log.Logger = logger
	//log.Logger = log.Output(zerolog.ConsoleWriter{Out: os.Stdout})

	multi := io.MultiWriter(zerolog.ConsoleWriter{Out: os.Stdout}, lumberjackLogger)

	//zerolog.ConsoleWriter{Out: os.Stderr, TimeFormat: time.RFC3339}
	logger := zerolog.New(multi).
		Level(zerolog.TraceLevel).
		With().
		Timestamp().
		// Str("package", getPackageName()). // 动态添加包名
		Caller().
		Int("pid", os.Getpid()).
		Logger()

	log.Logger = logger

	zerolog.TimeFieldFormat = zerolog.TimeFormatUnix

	log.Debug().Msg("This message appears only when log level set to Debug")
	log.Info().Msg("This message appears when log level set to Debug or Info")

	//updatePool()
}
