package main

import (
	"context"
	"encoding/json"
	"log"
	"testing"

	"github.com/firebase/genkit/go/ai"
	"github.com/firebase/genkit/go/genkit"
	"github.com/firebase/genkit/go/plugins/googlegenai"
)

//  func TestGenerateEmbedding(t *testing.T)

func TestGenerateEmbedding(t *testing.T) {
	ctx := context.Background()

	// Initialize Genkit with Google AI plugin
	g, err := genkit.Init(ctx, genkit.WithPlugins(&googlegenai.GoogleAI{
		APIKey: "AIzaSyCoYBOmnwRWlH_-nT25lpn8pMg3T18Q0uI",
	}))
	if err != nil {
		log.Fatalf("Failed to initialize Genkit: %v", err)
	}

	// Initialize the embedder
	embedder := googlegenai.GoogleAIEmbedder(g, "embedding-001")
	if embedder == nil {
		log.Fatal("embedder is not defined")
	}

	// Create EmbedRequest for the query
	query := "What is the capital of UK?"
	request := &ai.EmbedRequest{
		Input: []*ai.Document{ai.DocumentFromText(query, nil)}, // Wrap the query in a Document
	}

	// Generate embedding
	embedding, err := embedder.Embed(ctx, request)
	if err != nil {
		log.Fatalf("Failed to generate embedding: %v", err)
	}

	// Print the embedding
	embeddingJSON, err := json.Marshal(embedding)
	if err != nil {
		log.Fatalf("Failed to marshal embedding: %v", err)
	}
	log.Printf("Embedding for '%s': %s", query, string(embeddingJSON))
	//log.Printf("Embedding dimension: %d", len(embedding))
}
