package main

import (
	"context"
	"fmt"
	"log"
	"net/http"

	"github.com/firebase/genkit/go/ai"
	"github.com/firebase/genkit/go/genkit"
	"github.com/wade-liwei/agentchat/plugins/deepseek"

	"github.com/firebase/genkit/go/plugins/server"
)

func main() {

	ctx := context.Background()

	ds := deepseek.DeepSeek{
		APIKey: "sk-9f70df871a7c4b8aa566a3c7a0603706",
	}

	g, err := genkit.Init(ctx, genkit.WithPlugins(&ds))
	if err != nil {
		log.Fatal(err)
	}

	m := ds.DefineModel(g,
		deepseek.ModelDefinition{
			Name: "deepseek-chat", // Choose an appropriate model
			Type: "chat",          // Must be chat for tool support
		},
		nil)

	// Define a simple flow that generates jokes about a given topic
	genkit.DefineFlow(g, "jokesFlow", func(ctx context.Context, input string) (string, error) {
		resp, err := genkit.Generate(ctx, g,
			ai.WithModel(m),
			ai.WithPrompt(`Tell silly short jokes about apple`))

		if err != nil {
			fmt.Println(err.Error())
			return "", err
		}

		fmt.Println("resp.Text()", resp.Text())

		if err != nil {
			return "", err
		}

		text := resp.Text()
		return text, nil
	})

	// 配置限速器：每秒 10 次请求，突发容量 20，最大并发 5
	rl := NewRateLimiter(10, 20, 5)

	// 创建 Genkit HTTP 处理器
	mux := http.NewServeMux()

	for _, a := range genkit.ListFlows(g) {
		handler := rl.Middleware(genkit.Handler(a))
		mux.Handle("POST /"+a.Name(), handler)
	}

	// 启动服务器，监听
	log.Printf("Server starting on 0.0.0.0:3400")
	if err := server.Start(ctx, "0.0.0.0:3400", mux); err != nil {
		log.Fatalf("Server failed: %v", err)
	}
}
