



create table public.qa (
  id bigint generated by default as identity not null,
  created_at timestamp with time zone not null default now(),
  user_id bigint null,
  username text null,
  question text null,
  answer text null,
  constraint qa_pkey primary key (id)
) TABLESPACE pg_default;



create view public.latest_qa as
select distinct
  on (qa.user_id) qa.id,
  qa.created_at,
  qa.user_id,
  qa.username,
  qa.question,
  qa.answer
from
  qa
order by
  qa.user_id,
  qa.created_at desc;