import random
import uuid
from locust import HttpUser, task, between

class ChatUser(HttpUser):
    # Wait between 1 and 5 seconds between requests
    wait_time = between(1, 5)

    @task
    def post_chat(self):
        # Define possible values for dynamic fields
        questions = [
            "What is the capital of UK?",
            "Who is the president of the USA?",
            "What is the largest planet in our solar system?",
            "What is the boiling point of water?",
            "Who wrote 'Pride and Prejudice'?"
        ]
        model_options = [
            ["deepseek/deepseek-chat"],
            ["ollama/llama3.1"],
            ["deepseek/deepseek-chat", "ollama/llama3.1"]
        ]
        names = ["Alice", "Bob", "Charlie", "Diana", "Eve"]
        boolean_options = [True, False]

        # Generate request payload
        payload = {
            "content": random.choice(questions),
            "models": random.choice(model_options),
            "apiKey": f"sk-{uuid.uuid4().hex[:16]}",
            "from": random.choice(names),
            "from_id": f"user-{uuid.uuid4().hex[:8]}",
            "to": random.choice(names),
            "to_id": "user456",  # Fixed to_id
            "milvus": random.choice(boolean_options),
            "graph": random.choice(boolean_options)
        }

        # Send POST request to /chat
        headers = {
            "accept": "application/json",
            "Content-Type": "application/json"
        }

        with self.client.post(
            "/chat",
            json=payload,
            headers=headers,
            catch_response=True
        ) as response:
            try:
                # Validate response based on HTTP status code
                if response.status_code == 200:
                    response.success()
                else:
                    response.failure(f"Unexpected status code: {response.status_code} - {response.text}")
            except ValueError:
                response.failure(f"Invalid response: {response.text}")
            except Exception as e:
                response.failure(f"Error: {str(e)}")