create table public.qa (
  id bigint generated by default as identity not null,
  created_at timestamp with time zone not null default now(),
  question text null,
  answer text null,
  summary text null,
  "from" text null,
  "to" text null,
  from_id text null,
  to_id text null,
  milvus boolean null default false,
  graph boolean null default false,
  constraint qa_pkey primary key (id)
) TABLESPACE pg_default;



CREATE VIEW public.qa_latest_from_id AS
SELECT DISTINCT ON (qa.from_id)
    qa.id,
    qa.created_at,
    qa.question,
    qa.answer,
    qa.summary,
    qa."from",
    qa."to",
    qa.from_id,
    qa.to_id,
    qa.milvus,
    qa.graph
FROM
    qa
WHERE
    qa.from_id IS NOT NULL
ORDER BY
    qa.from_id,
    qa.created_at DESC;



