import React, { Component } from 'react';
import * as echarts from 'echarts';
import moment from 'moment'
class App extends Component {
    state={
        data:[],
        TopAxisX:[],
        BottomAxisX:[],
        TopAxisX1:[],
        AxisY:[],
        Links:[],
        target:[],
        duration: -10,
        interval: null,
        requestDuration: -100,
        startText:'',
        endText:'',
        value:0,
        getValue:0,
        time:-100,
        getTime:-100,
        blockOld:0,
        endblockOld:0,
        count:0,
        endCount:0,
    }
    inputChangeValue=(e)=>{
        this.setState({
            value:e.target.value,
        })
    }
    inputChangeTime=(e)=>{
        this.setState({
            time:e.target.value,
        })
    }
    getInputHeight=()=>{
        this.setState({
            getValue:this.state.value
        })
        console.log(this.state.getValue,'点击获取的value')
    }
    getInputTime=()=>{
        this.setState({
            getTime:this.state.time
        })
        console.log(this.state.getTime,'点击获取的time')
    }
    componentDidMount(){
        let that = this
        var chartDom = document.getElementById('main');
        var myChart = echarts.init(chartDom);
        myChart.showLoading()
        fetch(`/api/graph_by_height_and_duration?height=0&duration=${that.state.requestDuration}`,{
            method:'GET',
            headers:{
                'Content-Type':'application/json;charset=UTF-8'
            },
        })
        .then(res =>
            res.json()
        ) 
        .then((resData) => {
            myChart.hideLoading()
            let allRows0Arr = []
            let allRows1Arr = []
            let allRows2Arr = []
            let allTopAxisXArr = []
            let allBottomAxisXArr = []
            let allLinksArr = []
            this.setState({
                data: resData.result.Rows,
                TopAxisX: resData.result.AxisX.TopAxisX,
                BottomAxisX: resData.result.AxisX.BottomAxisX,
                AxisY: resData.result.AxisY,
                Links: resData.result.Links,
            }, ()=>{
                let {Rows, AxisX, Links } = resData.result
                let {TopAxisX, BottomAxisX} = AxisX
                allRows0Arr = Rows[0]
                allRows1Arr = Rows[1]
                allRows2Arr = Rows[2]
                allTopAxisXArr = TopAxisX
                allBottomAxisXArr = BottomAxisX
                allLinksArr = Links
                that.initChart(resData)
                console.log(this.state.getValue,'高')
                console.log(this.state.getTime,'时间')
                if(!that.interval){
                        that.interval = setInterval(() => {
                            // fetch(`/api/graph_by_height_and_duration?height=0&duration=${that.state.requestDuration}`,{
                            fetch(`/api/graph_by_height_and_duration?height=${this.state.getValue}&duration=${that.state.requestDuration}`,{
                                method:'GET',
                                headers:{
                                    'Content-Type':'application/json;charset=UTF-8'
                                },
                            })
                            .then(res =>res.json()) 
                            .then((newData) => {
                                let {Rows, AxisX, Links } = newData.result
                                let {TopAxisX, BottomAxisX} = AxisX
                                allRows0Arr = Rows[0]
                                allRows1Arr = Rows[1]
                                allRows2Arr = Rows[2]
                                allTopAxisXArr = TopAxisX
                                allBottomAxisXArr = BottomAxisX
                                allLinksArr = Links
                                newData.result.Rows[0] = allRows0Arr
                                newData.result.Rows[1] = allRows1Arr
                                newData.result.Rows[2] = allRows2Arr
                                newData.result.AxisX.TopAxisX = allTopAxisXArr
                                newData.result.AxisX.BottomAxisX = allBottomAxisXArr
                                newData.result.Links = allLinksArr
                                that.initChart(newData)
                            })
                        }, 60000);
                }
                var chartDom = document.getElementById('main');
                var myChart = echarts.init(chartDom);

                myChart.on('datazoom', function(params){
                    clearInterval(that.interval)
                    var options = myChart.getOption();
                    var endValue=options.dataZoom[0].endValue;
                    var startValue=options.dataZoom[0].startValue;
                    var min=0
                    var endmin=0
                    var min3=0
                    var startBlock=0
                    var endBlock=0;
                    var maxBlock = 0
                    var minBlock = 0
                    options.series.map(item=>{
                        item.markLine.data.forEach(item1=>{
                            item1.map(item2=>{
                                if(item2.yAxis === 'Block'){
                                    if(item2.label !== undefined){
                                        if(maxBlock === 0 ){
                                            maxBlock=item2.label.formatter
                                            minBlock=item2.label.formatter
                                        }else {
                                            if(item2.label.formatter<minBlock){
                                                minBlock = item2.label.formatter
                                            }
                                            if(item2.label.formatter>maxBlock){
                                                maxBlock = item2.label.formatter
                                            }
                                        }
                                    }
                                    if(min === 0){
                                        endmin=item2.xAxis - endValue
                                        min = item2.xAxis - startValue;
                                        if(min < 0 ){
                                            min = -min;
                                        }
                                        if(endmin<0){
                                            endmin=-endmin
                                        }
                                        if(item2.label!==undefined){
                                            startBlock=item2.label.formatter
                                            endBlock=item2.label.formatter
                                            min3=item2.xAxis
                                        }
                                    }else {
                                        var min2=item2.xAxis - startValue;
                                        var endmin2=item2.xAxis - endValue;
                                        if(min2 < 0){
                                            min2 = -min2;
                                        }
                                        if(endmin2<0){
                                            endmin2=-endmin2
                                        }
                                        if(min > min2){
                                            min = min2 
                                            if(item2.label !== undefined ){
                                                startBlock=item2.label.formatter
                                                min3=item2.xAxis
                                            }
                                        }
                                        if(endmin > endmin2){
                                            endmin=endmin2
                                            if(item2.label !== undefined ){
                                                endBlock=item2.label.formatter
                                                min3=item2.xAxis
                                            }
                                        }
                                    }
                                }
                            })
                        })
                    })
                    if(params.start === 0){
                        myChart.showLoading()
                        console.log(startBlock,'startBlock')

                        // if(startBlock !=0 ){ 
                        //    that.setState({
                        //         blockOld:startBlock,
                        //         count:0,
                        //     })
                        // } else if(startBlock == 0 || startBlock == "" || startBlock == undefined){ 
                        //     that.setState({
                        //         startBlock:that.state.blockOld,
                        //         count:that.state.count+1,
                        //         requestDuration:that.state.requestDuration*(that.state.count+1)
                        //     })
                        // }
                        that.setState({
                            requestDuration:-100,
                            duration:-10,
                        },()=>{
                            if(startBlock !=0 ){ 
                                that.setState({
                                     blockOld:startBlock,
                                     count:0,
                                 })
                             } else if(startBlock == 0 || startBlock == "" || startBlock == undefined){ 
                                 that.setState({
                                     startBlock:that.state.blockOld,
                                     count:that.state.count+1,
                                     requestDuration:that.state.requestDuration*(that.state.count+1)
                                 })
                             }
                             console.log(that.state.requestDuration,'requestDurationfgfgf')
                             console.log(startBlock,'startBlock')
                             console.log(that.state.count,'count')
                            fetch(`/api/graph_by_height_and_duration?height=${startBlock}&duration=${that.state.requestDuration}`,{
                                method:'GET',
                                headers:{
                                    'Content-Type':'application/json;charset=UTF-8'
                                },
                            })
                            .then(res =>res.json()) 
                            .then((newData) => {
                                myChart.hideLoading()
                                let {Rows, AxisX, Links } = newData.result
                                let {TopAxisX, BottomAxisX} = AxisX
                                allRows0Arr = Rows[0]
                                allRows1Arr = Rows[1]
                                allRows2Arr = Rows[2]
                                allTopAxisXArr = TopAxisX
                                allBottomAxisXArr = BottomAxisX
                                allLinksArr = Links
                                newData.result.Rows[0] = allRows0Arr
                                newData.result.Rows[1] = allRows1Arr
                                newData.result.Rows[2] = allRows2Arr
                                newData.result.AxisX.TopAxisX = allTopAxisXArr
                                newData.result.AxisX.BottomAxisX = allBottomAxisXArr
                                newData.result.Links = allLinksArr
                                that.initChart(newData)
                            })
                        })
                    }

                    if(params.end === 100){
                        myChart.showLoading()
                        console.log(endBlock,'endBlock')
                        that.setState({  
                            requestDuration:100,
                            duration:10,
                        },()=>{
                            if(startBlock !=0 ){ 
                                that.setState({
                                     endblockOld:endBlock,
                                     endCount:0,
                                 })
                             } else if(startBlock == 0 || startBlock == "" || startBlock == undefined){ 
                                 that.setState({
                                     endBlock:that.state.endblockOld,
                                     endCount:that.state.endCount+1,
                                     requestDuration:that.state.requestDuration*(that.state.endCount+1)
                                 })
                             }
                             console.log(that.state.requestDuration,'requestDurationfgfgf')
                             console.log(endBlock,'startBlock')
                             console.log(that.state.endCount,'endCount')
                            fetch(`/api/graph_by_height_and_duration?height=${endBlock}&duration=${that.state.requestDuration}`,{
                                method:'GET',
                                headers:{
                                    'Content-Type':'application/json;charset=UTF-8'
                                },
                            })
                            .then(res =>res.json()) 
                            .then((newData) => {
                                myChart.hideLoading()
                                let {Rows, AxisX, Links } = newData.result
                                let {TopAxisX, BottomAxisX} = AxisX
                                allRows0Arr = Rows[0]
                                allRows1Arr = Rows[1]
                                allRows2Arr = Rows[2]
                                allTopAxisXArr = TopAxisX
                                allBottomAxisXArr = BottomAxisX
                                allLinksArr = Links
                                
                                
                                newData.result.Rows[0] = allRows0Arr
                                newData.result.Rows[1] = allRows1Arr
                                newData.result.Rows[2] = allRows2Arr
                                newData.result.AxisX.TopAxisX = allTopAxisXArr
                                newData.result.AxisX.BottomAxisX = allBottomAxisXArr
                                newData.result.Links = allLinksArr
                                that.initChart(newData,1)
                            })
                        })
                    }
                    let flag=false
                    options.series.map(item=>{
                        item.data.map(item1=>{
                            console.log(item1.value[0],'item.value')
                            console.log(endValue,'endValue')
                            console.log(startValue,'startValue')
                            if(startValue <= item1.value[0] && endValue >= item1.value[0]){
                                if(item1.value[7] === 'Witness'){
                                    flag = true
                                }
                            }
                        })
                    })
                    if(flag === true ){ 
                        that.interval = setInterval(() => {
                            fetch(`/api/graph_by_height_and_duration?height=0&duration=${that.state.requestDuration}`,{
                                method:'GET',
                                headers:{
                                    'Content-Type':'application/json;charset=UTF-8'
                                },
                            })
                            .then(res =>res.json()) 
                            .then((newData) => {
                                let {Rows, AxisX, Links } = newData.result
                                let {TopAxisX, BottomAxisX} = AxisX
                                allRows0Arr = Rows[0]
                                allRows1Arr = Rows[1]
                                allRows2Arr = Rows[2]
                                allTopAxisXArr = TopAxisX
                                allBottomAxisXArr = BottomAxisX
                                allLinksArr = Links
                                
                                newData.result.Rows[0] = allRows0Arr
                                newData.result.Rows[1] = allRows1Arr
                                newData.result.Rows[2] = allRows2Arr
                                newData.result.AxisX.TopAxisX = allTopAxisXArr
                                newData.result.AxisX.BottomAxisX = allBottomAxisXArr
                                newData.result.Links = allLinksArr
                                that.initChart(newData)
                            })
                        }, 60000);
                    }else{ 
                        clearInterval(that.interval)
                    }
                   
                })
            })
        })
        
    }
    componentWillUnmount() {
        this.state.interval = null
    }
    initChart(data) {
        var chartDom = document.getElementById('main');
        var myChart = echarts.init(chartDom);
        var maxtime=moment(data.result.AxisX.BlockTime/1000000)
        maxtime.format('YYYY-MM-DD HH:mm:ss')
        maxtime.add(this.state.duration,'seconds').format('YYYY-MM-DD HH:mm:ss')        
        maxtime.unix()
        var mintime=moment(data.result.AxisX.BlockTime/1000000)
        var markline=data.result.AxisX.TopAxisX.map(item=>{
            return [ 
                        {
                            xAxis:item.Time, 
                            yAxis: 'Block',
                            label: {
                                show: true,
                                lineHeight:25,
                                position: 'insideMiddleTop',
                                formatter:item.Value , 
                            },
                            lineStyle: { color: 'red', type: 'solid',with:30},
                        },
                        {
                            xAxis: item.Time, 
                            yAxis: 'Block'
                        },
                    ] 
        })
        data.result.AxisX.BottomAxisX.map(item=>{
            markline.push([
                        {
                            xAxis:item.Time, 
                            yAxis: 'Round',
                            label: {
                                show: true,
                                lineHeight:10,
                                position: 'insideMiddleTop',
                                formatter:item.Value, 
                            },
                            lineStyle: { color: 'green', type: 'solid',with:30},
                        },
                        {
                            xAxis: item.Time, 
                            yAxis: 'Round'
                        },
                    ])
        })
        if(this.state.duration<0){
            maxtime=moment(data.result.AxisX.BlockTime/1000000)
            mintime=moment(data.result.AxisX.BlockTime/1000000)
            mintime.subtract(-(this.state.duration),'seconds').format('YYYY-MM-DD HH:mm:ss')
            moment(data.result.AxisX.BlockTime/1000000).format('YYYY-MM-DD HH:mm:ss')
        }
        if(this.state.duration>0){
            mintime=moment(data.result.AxisX.BlockTime/1000000);
            maxtime=moment(data.result.AxisX.BlockTime/1000000)
            maxtime.add(this.state.requestDuration,'seconds').format('YYYY-MM-DD HH:mm:ss')
            
        }
        var source= data.result.Rows
        var target=[];
        for(var i in source){
            var list=[];
            var lineList=source[i];
            for (var j in lineList) {
                list.push([
                    lineList[j].XAsTime,
                    lineList[j].Type,
                    lineList[j].Y,
                    lineList[j].Desc,
                    lineList[j].Round,
                    lineList[j].Index,
                    lineList[j].ID,
                    lineList[j].Role,
                    lineList[j].TxCount
                ]);
            }
            target.push(list);
        }
        var option;
        const series = [];
        this.state.AxisY.forEach(function (type) {
                const arr = target.map(function (item) {
                const data = item.map((item, index) => {
                        var colors 
                        if(item[7]==='Normal'){
                            colors ='#4B4B4B'
                        }else if(item[7]==='Witness'){
                            colors ='#4A4CFF'
                        }else if(item[7]==='Famous1'){
                            colors ='#00FFFF'
                        }else if(item[7]==='Famous2'){
                            colors ='#06FF02'
                        }
                        
                    return {
                        label: {
                            show: true,
                            position: 'top'
                        },
                        emphasis: {
                            label: {
                                show: true,
                            }
                        },
                        name: item[6],
                        value: item,
                        itemStyle:{
                                borderWidth: 1,
                                borderColor: '#333',
                                color:colors,
                        },
                        symbolSize:item[3]==item[6]? 15 : 15 
                    }; 
                })
                return data;
            })
            var newArr=arr.reduce(function(total,currentValue){
                return total.concat(currentValue)
            })
            let links = data.result.Links;
            links.map(item=>{
                item['source'] = item['Source']
                item['target'] = item['Target']
            })
            series.push({
                name: type,
                type: 'graph',
                coordinateSystem: 'cartesian2d',
                data: newArr,
                links: links,
                edgeSymbol: ['none', 'arrow'],
                edgeSymbolSize: 5,
                legendHoverLink: false,
                lineStyle: {
                    color: '#333'
                },
                itemStyle: {
                    borderWidth: 1,
                    borderColor: '#333',
                },
                label: {
                    color: '#333',
                    position: 'center'
                },
                symbolSize: 15,
                markLine:{
                        symbol:'circle',
                        data:markline,
                }
            });
            
        });
        option = {
            visualMap: {
                show: false,
                dimension: 1,
            },
            legend: {
                show: false,
                data: this.state.AxisY,
                
                selectedMode: 'single',
                right: 100
            },
            grid: {
                left: 40,
                bottom: 50,
                containLabel: true,
                top: 80
            },
            dataZoom: [
                {
                    type: 'inside',
                    startValue:mintime.unix()*1000000000,
                    endValue:this.state.duration < 0 ? maxtime.unix()*1000000000 : (maxtime.subtract(90,'second')).unix()*1000000000,
                    startText:'11111',
                    disabled:false,
                    zoomLock: true,
                },
                {
                    disabled:false,
                    zoomLock: true,
                    labelFormatter: function (value) {
                        return moment(value/1000000).format('YYYY-MM-DD HH:mm:ss')
                    },
                    startText:'11111'
                },
            ],
            xAxis: [
                {
                    name:'Time',
                    axisLabel: {
                        formatter: (function(value){
                            return moment(parseInt(value/1000000)).format('YYYY-MM-DD HH:mm:ss')
                        })
                    },
                    max:this.state.duration < 0 ? maxtime.unix()*1000000000 :  maxtime.add(100,'second').unix()*1000000000,
                    min:this.state.duration <0 ? mintime.subtract(100,'second').unix()*1000000000 : mintime.unix()*1000000000,
                    
                    axisLine:{
                        show:true,
                        symbol: ['none', 'arrow']
                    },
                    axisTick: {
                        alignWithLabel:true,
                    },
                },
                {
                    axisLine:{
                        show: true,
                        symbol: ['none', 'arrow']
                    },
                    axisLabel:{
                        inside: false,
                    },
                    axisTick: {
                        alignWithLabel:true,
                    },
                },
            ],
            yAxis: {
                type: 'category',
                name:'Validator',
                nameTextStyle: {
                    align: "center",
                    lineHeight: 40,
                },
                data: this.state.AxisY,
                triggerEvent: true,
                axisLabel:{
                    margin:8,
                    formatter:function(data){
                        var val=''
                        if(data.length>5){
                            val = data.substr(0,4)+'...';
                            return val ;
                        }else {
                            return data;
                        }
                    }
                },
                boundaryGap: false,
                axisTick: {
                    alignWithLabel: true
                }
            },
            toolbox: {
                feature: {
                    dataZoom: {}
                }
            },
            
            series: series,
        };
        this.setState({
            startText:moment((option.xAxis[0].min)/1000000).format('YYYY-MM-DD HH:mm:ss'),
            endText:moment((option.xAxis[0].max)/1000000).format('YYYY-MM-DD HH:mm:ss')
        })
        myChart.setOption(option,true);
        this.extension(myChart);
    }

    extension(myChart) {
        var elementDiv = document.getElementById('extension');
        if(!elementDiv){
            var div = document.createElement('div')
            div.setAttribute('id', 'extension')
            div.style.display = 'block'
            document.querySelector('html').appendChild(div)
        }
        
        var styleCss=`position: absolute;margin-left:35px;z-index: 99999;color: #fff;font-size: 12px;padding: 5px;display: inline;border-radius: 4px;background-color: #303133;box-shadow: rgba(0, 0, 0, 0.3) 2px 2px 8px`
        myChart.on('mouseover',function(params){
            if (params.componentType === 'yAxis') {
                elementDiv = document.querySelector('#extension')
                var elementStyle = styleCss
                elementDiv.style.cssText = elementStyle
                elementDiv.innerHTML = params.value
                document.querySelector('html').onmousemove = function (event) {
                var elementDiv = document.querySelector('#extension')
                var xx = event.pageX - 10
                var yy = event.pageY + 15
                elementDiv.style.top = yy + 'px'
                elementDiv.style.left = xx + 'px'
                }
            }else if(params.componentType === "series"){
                if(params.name === params.data.name){
                    elementDiv = document.querySelector('#extension')
                    elementStyle = styleCss
                    elementDiv.style.cssText = elementStyle
                    elementDiv.innerHTML=`
                                            <p>${moment(parseInt(params.data.value[0]/1000000)).format('YYYY-MM-DD HH:mm:ss.SSS')}</p>
                                            <p>round：${params.data.value[4]}</p>
                                            <p>TxCount： ${params.data.value[8]}</p>
                                        `
                    document.querySelector('html').onmousemove = function (event) {
                        var elementDiv = document.querySelector('#extension')
                        var xx = event.pageX - 10
                        var yy = event.pageY + 15
                        elementDiv.style.top = yy + 'px'
                        elementDiv.style.left = xx + 'px'
                    }
                }
            }else if(params.componentType === "markLine"){
                    elementDiv = document.querySelector('#extension')
                    elementStyle = styleCss
                    elementDiv.style.cssText = elementStyle
                    elementDiv.innerHTML = moment(parseInt(params.data.xAxis/1000000)).format('YYYY-MM-DD HH:mm:ss.SSS')
                    document.querySelector('html').onmousemove = function (event) {
                        elementDiv = document.querySelector('#extension')
                        var xx = event.pageX - 10
                        var yy = event.pageY + 15
                        elementDiv.style.top = yy + 'px'
                        elementDiv.style.left = xx + 'px'
                    }
            }
        })

        myChart.on('mouseout', function (params) {
            elementDiv = document.querySelector('#extension')
            if (params.componentType === 'yAxis') {
                elementDiv.style.cssText = 'display:none'
            }
            if(params.componentType === "series"){
                if(params.name === params.data.name){
                    elementDiv.style.cssText = 'display:none'
                }
            }
            if(params.componentType === "markLine"){
                elementDiv.style.cssText = 'display:none'
            }
        })
    }
    render() {
        const {startText,endText}=this.state
        return (
           <div>
                <div style={{width:'50%',display:'flex',justifyContent:'space-around'}}>
                    <div>
                        <input value={this.state.value}  onChange={this.inputChangeValue} style={{width:'30%',textAlign:'center'}}/>
                        <button onClick={this.getInputHeight} style={{cursor:'pointer'}}>双击切换高度</button>
                    </div>
                    {/* <div>
                        <input value={this.state.time}  onChange={this.inputChangeTime} style={{width:'30%',textAlign:'center'}}/>
                        <button onClick={this.getInputTime} style={{cursor:'pointer'}}>切换时间</button>
                    </div> */}
                    <div>当前高度：{this.state.getValue}</div>
                    <div>当前时间：{this.state.requestDuration}</div>
                </div>
                <div style={{position:'relative'}}>
                    <div id="main" className="container" style={{position:'relative', padding: '50px', boxSizing:'border-box',  width: '100%', height: 900 }}> </div>
                    <div style={{position:'absolute',left:'1%',top:'91%',fontSize:'12px',color:'#80828a'}}>{startText}</div>
                    <div style={{position:'absolute',right:'5%',top:'91%',fontSize:'12px',color:'#80828a'}}>{endText}</div>
                </div>
                
           </div>
        );
    }
}
export default App;
