import React, { Component } from 'react';
import * as echarts from 'echarts';
import moment from 'moment'
class App extends Component {
    state={
        data:[],
        TopAxisX:[],
        BottomAxisX:[],
        TopAxisX1:[],
        AxisY:[],
        Links:[],
        target:[],
        // duration: -50,
        duration: -10,
        interval: null,
        // requestDuration: -50
        requestDuration: -100
    }
    componentDidMount(){
        let that = this
        var chartDom = document.getElementById('main');
        var myChart = echarts.init(chartDom);
        myChart.showLoading()
        fetch(`/api/graph_by_height_and_duration?height=0&duration=${that.state.requestDuration}`,{
        // fetch(`/api/graph_by_height_and_duration?height=0&duration=${that.state.requestDuration}`,{
            method:'GET',
            headers:{
                'Content-Type':'application/json;charset=UTF-8'
            },
        })
        .then(res =>
            res.json()
        ) 
        .then((resData) => {
            myChart.hideLoading()
            let allRows0Arr = []
            let allRows1Arr = []
            let allRows2Arr = []
            let allTopAxisXArr = []
            let allBottomAxisXArr = []
            let allLinksArr = []
            this.setState({
                data: resData.result.Rows,
                TopAxisX: resData.result.AxisX.TopAxisX,
                BottomAxisX: resData.result.AxisX.BottomAxisX,
                AxisY: resData.result.AxisY,
                Links: resData.result.Links,
            }, ()=>{
                // handle arr Rows [3 arr]\TopAxisX [...{}]\BottomAxisX [...{}]\Links [...{}]

                let {Rows, AxisX, Links } = resData.result
                let {TopAxisX, BottomAxisX} = AxisX
                allRows0Arr = Rows[0]
                allRows1Arr = Rows[1]
                allRows2Arr = Rows[2]
                allTopAxisXArr = TopAxisX
                allBottomAxisXArr = BottomAxisX
                allLinksArr = Links
                // console.log(Rows, TopAxisX, BottomAxisX, Links)
                that.initChart(resData)
                
                // that.interval = setInterval(() => {
                //     fetch(`/api/graph_by_height_and_duration?height=0&duration=${that.state.requestDuration}`,{
                //         method:'GET',
                //         headers:{
                //             'Content-Type':'application/json;charset=UTF-8'
                //         },
                //     })
                //     .then(res =>res.json()) 
                //     .then((newData) => {
                //         let {Rows, AxisX, Links } = newData.result
                //         let {TopAxisX, BottomAxisX} = AxisX

                //         // allRows0Arr = [...allRows0Arr, ...Rows[0].slice(Rows[0].length-2, Rows[0].length-1)]
                //         // allRows1Arr = [...allRows1Arr, ...Rows[1].slice(Rows[1].length-2, Rows[1].length-1)]
                //         // allRows2Arr = [...allRows2Arr, ...Rows[2].slice(Rows[2].length-2, Rows[2].length-1)]
                //         // allTopAxisXArr = [...allTopAxisXArr, ...TopAxisX.slice(TopAxisX.length-2, TopAxisX.length-1)]
                //         // allBottomAxisXArr = [...allBottomAxisXArr, ...BottomAxisX.slice(BottomAxisX.length-2, BottomAxisX.length-1)]
                //         // allLinksArr = [...allLinksArr, ...Links.slice(Links.length-2, Links.length-1)]
                //         allRows0Arr = Rows[0]
                //         allRows1Arr = Rows[1]
                //         allRows2Arr = Rows[2]
                //         allTopAxisXArr = TopAxisX
                //         allBottomAxisXArr = BottomAxisX
                //         allLinksArr = Links
                        
                        

                //         newData.result.Rows[0] = allRows0Arr
                //         newData.result.Rows[1] = allRows1Arr
                //         newData.result.Rows[2] = allRows2Arr
                //         newData.result.AxisX.TopAxisX = allTopAxisXArr
                //         newData.result.AxisX.BottomAxisX = allBottomAxisXArr
                //         newData.result.Links = allLinksArr
                //         that.initChart(newData)
                //     })
                // }, 5000);
                var chartDom = document.getElementById('main');
                var myChart = echarts.init(chartDom);
                myChart.on('datazoom', function(params){
                    console.log(params,'params');
                    var options = myChart.getOption();
                    var endValue=options.dataZoom[0].endValue;
                    var startValue=options.dataZoom[0].startValue;
                    console.log('开始时间：',moment(startValue/1000000).format('YYYY-MM-DD HH:mm:ss:sss'))
                    // console.log(options,'options')
                    // console.log(options.series,'series')
                    // var min1
                    // var min2
                    var min=0
                    var min3=0
                    var b=0
                    var maxB = 0 
                    var minB = 0
                    options.series.map(item=>{
                        item.markLine.data.forEach(item1=>{
                            item1.map(item2=>{
                                // console.log(item2.xAxis)
                                if(item2.yAxis === 'Block'){
                                    if(item2.label !== undefined){
                                        if(maxB === 0 ){
                                            maxB=item2.label.formatter
                                            minB=item2.label.formatter
                                        }else {
                                            if(item2.label.formatter<minB){
                                                minB = item2.label.formatter
                                            }
                                            if(item2.label.formatter>maxB){
                                                maxB = item2.label.formatter
                                            }
                                        }
                                    }
                                    if(min === 0){
                                        min = item2.xAxis - startValue;
                                        if(min < 0 ){
                                            min = -min;
                                        }
                                        if(item2.label!==undefined){
                                            b=item2.label.formatter
                                            min3=item2.xAxis
                                        }
                                    }else {
                                        var min2=item2.xAxis - startValue;
                                        if(min2 < 0){
                                            min2 = -min2;
                                        }
                                        if(min > min2){
                                            min = min2 
                                            if(item2.label !== undefined ){
                                                b=item2.label.formatter
                                                min3=item2.xAxis
                                            }
                                        }
                                    }
                                }
                            })
                        })
                    })
                    // console.log(min,'最小');
                    console.log(b,'当前');
                    console.log(maxB,'max');
                    console.log(minB,'min');


                    if(params.start == 0){
                        fetch(`/api/graph_by_height_and_duration?height=${b}&duration=${that.state.requestDuration}`,{
                            method:'GET',
                            headers:{
                                'Content-Type':'application/json;charset=UTF-8'
                            },
                        })
                        .then(res =>res.json()) 
                        .then((newData) => {
                            let {Rows, AxisX, Links } = newData.result
                            let {TopAxisX, BottomAxisX} = AxisX
    
                            // allRows0Arr = [...allRows0Arr, ...Rows[0].slice(Rows[0].length-2, Rows[0].length-1)]
                            // allRows1Arr = [...allRows1Arr, ...Rows[1].slice(Rows[1].length-2, Rows[1].length-1)]
                            // allRows2Arr = [...allRows2Arr, ...Rows[2].slice(Rows[2].length-2, Rows[2].length-1)]
                            // allTopAxisXArr = [...allTopAxisXArr, ...TopAxisX.slice(TopAxisX.length-2, TopAxisX.length-1)]
                            // allBottomAxisXArr = [...allBottomAxisXArr, ...BottomAxisX.slice(BottomAxisX.length-2, BottomAxisX.length-1)]
                            // allLinksArr = [...allLinksArr, ...Links.slice(Links.length-2, Links.length-1)]
                            allRows0Arr = Rows[0]
                            allRows1Arr = Rows[1]
                            allRows2Arr = Rows[2]
                            allTopAxisXArr = TopAxisX
                            allBottomAxisXArr = BottomAxisX
                            allLinksArr = Links
                            
                            
    
                            newData.result.Rows[0] = allRows0Arr
                            newData.result.Rows[1] = allRows1Arr
                            newData.result.Rows[2] = allRows2Arr
                            newData.result.AxisX.TopAxisX = allTopAxisXArr
                            newData.result.AxisX.BottomAxisX = allBottomAxisXArr
                            newData.result.Links = allLinksArr
                            that.initChart(newData,1)
                        })
                    }





                    // console.log(moment(min3/1000000).format('YYYY-MM-DD HH:mm:ss'),'最小')
              
                    // if(params.start<=40){
                    //     console.log("该往后加载数据了")
                    //     fetch(`/api/graph_by_height_and_duration?height=${b}&duration=${that.state.requestDuration}`,{
                    //         method:'GET',
                    //         headers:{
                    //             'Content-Type':'application/json;charset=UTF-8'
                    //         },
                    //     })
                    //     .then(res =>res.json()) 
                    //     .then((newDatas) => {
                    //         console.log(newDatas.result)
                    //         // console.log(moment(newDatas.result.AxisX.BlockTime/1000000).format('YYYY-MM-DD HH:mm:ss'))
                    //     })
                    // }
                })
            })
        })
        
    }
    componentWillUnmount() {
        this.state.interval = null
    }
    initChart(data,values) {
        var chartDom = document.getElementById('main');
        var myChart = echarts.init(chartDom);
        var maxtime=moment(data.result.AxisX.BlockTime/1000000)
        maxtime.format('YYYY-MM-DD HH:mm:ss')
        // console.log(maxtime.format('YYYY-MM-DD HH:mm:ss'))
        maxtime.add(this.state.duration,'seconds').format('YYYY-MM-DD HH:mm:ss')        
        maxtime.unix()
        var mintime=moment(data.result.AxisX.BlockTime/1000000)
        var markline=data.result.AxisX.TopAxisX.map(item=>{
            return [ 
                        {
                            // name: 'start', 
                            xAxis:item.Time, 
                            yAxis: 'Block',
                            label: {
                                show: true,
                                lineHeight:25,
                                position: 'insideMiddleTop',
                                formatter:item.Value , 
                            },
                            lineStyle: { color: 'red', type: 'solid',with:30},
                        },
                        {
                            // name: 'end', 
                            xAxis: item.Time, 
                            yAxis: 'Block'
                        },
                    ] 
        })
        data.result.AxisX.BottomAxisX.map(item=>{
            markline.push( [ 
                        {
                            // name: 'start', 
                            xAxis:item.Time, 
                            yAxis: 'Round',
                            label: {
                                show: true,
                                lineHeight:10,
                                position: 'insideMiddleTop',
                                formatter:item.Value, 
                            },
                            lineStyle: { color: 'green', type: 'solid',with:30},
                        },
                        {
                            // name: 'end', 
                            xAxis: item.Time, 
                            yAxis: 'Round'
                        },
                    ] )
        })

        if(this.state.duration<0){
            maxtime=moment(data.result.AxisX.BlockTime/1000000)
            mintime=moment(data.result.AxisX.BlockTime/1000000)
            // mintime.add(-(this.state.duration),'seconds').format('YYYY-MM-DD HH:mm:ss')
            mintime.subtract(-(this.state.duration),'seconds').format('YYYY-MM-DD HH:mm:ss')
            moment(data.result.AxisX.BlockTime/1000000).format('YYYY-MM-DD HH:mm:ss')

        }    
        var source= data.result.Rows
        var target=[];
        for(var i in source){
            var list=[];
            var lineList=source[i];
            for (var j in lineList) {
                list.push([
                    lineList[j].XAsTime,
                    lineList[j].Type,
                    lineList[j].Y,
                    lineList[j].Desc,
                    lineList[j].Round,
                    lineList[j].Index,
                    lineList[j].ID,
                    lineList[j].Role
                ]);
            }
            target.push(list);
        }
    
        // var chartDom = document.getElementById('main');
        // var myChart = echarts.init(chartDom);
        var option;
        const series = [];
        this.state.AxisY.forEach(function (type) {
                const arr = target.map(function (item) {
                const data = item.map((item, index) => {
                        var colors 
                        if(item[7]==='Normal'){
                            colors ='#4B4B4B'
                        }else if(item[7]==='Witness'){
                            colors ='#4A4CFF'
                        }else if(item[7]==='Famous1'){
                            colors ='#00FFFF'
                        }else if(item[7]==='Famous2'){
                            colors ='#06FF02'
                        }
                        
                    return {
                        label: {
                            show: true,
                            position: 'top'
                        },
                        emphasis: {
                            label: {
                                show: true,
                            }
                        },
                        name: item[6],
                        value: item,
                        // x: item[0],
                        itemStyle:{
                                borderWidth: 1,
                                borderColor: '#333',
                                color:colors,
                        },
                        symbolSize:item[3]==item[6]? 15 : 15 
                    }; 
                })
                return data;
            })
            var newArr=arr.reduce(function(total,currentValue){
                return total.concat(currentValue)
            })
            let links = data.result.Links;
            links.map(item=>{
                item['source'] = item['Source']
                item['target'] = item['Target']
            })
            // links.pop();
            series.push({
                name: type,
                type: 'graph',
                coordinateSystem: 'cartesian2d',
                data: newArr,
                links: links,
                edgeSymbol: ['none', 'arrow'],
                edgeSymbolSize: 5,
                legendHoverLink: false,
                lineStyle: {
                    color: '#333'
                },
                itemStyle: {
                    borderWidth: 1,
                    borderColor: '#333',
                },
                label: {
                    color: '#333',
                    position: 'center'
                },
                symbolSize: 15,
                markLine:{
                        symbol:'circle',
                        data:markline,
                }
            });
            
        });
        option = {
            visualMap: {
                show: false,
                dimension: 1,
            },
            legend: {
                show: false,
                data: this.state.AxisY,
                
                selectedMode: 'single',
                right: 100
            },
            grid: {
                left: 40,
                bottom: 50,
                containLabel: true,
                top: 80
            },
            dataZoom: [
                {
                    type: 'inside',
                    startValue:mintime.unix()*1000000000,
                    endValue:maxtime.unix()*1000000000,
                    disabled:false,
                    zoomLock: true,
                    // xAxisIndex: [0],
                    // labelFormatter: function (dataIndex) {
                    //     console.log(dataIndex,'dd')
                    // }
                },
                {
                    // start: 40,
                    // end:60,
                    // startValue:mintime.unix()*1000000000,
                    // endValue:maxtime.unix()*1000000000,
                    disabled:false,
                    zoomLock: true,
                },
                
            ],
            xAxis: [
                {
                    name:'Time',
                    axisLabel: {
                        formatter: (function(value){
                            return moment(parseInt(value/1000000)).format('YYYY-MM-DD HH:mm:ss')
                        })
                    },
                    // max:maxtime.add(5,'seconds').unix()*1000000000,
                    max:maxtime.unix()*1000000000,
                    min:mintime.subtract(100,'seconds').unix()*1000000000,
                    // splitNumber:10,
                    axisLine:{
                        show:true,
                        symbol: ['none', 'arrow']
                    },
                    axisTick: { 
                        alignWithLabel:true,
                    },
                },

                // 上边的轴指的是之前block 
                {
                    axisLine:{
                        show: true,
                        symbol: ['none', 'arrow']
                    },
                    axisLabel:{
                        inside: false,
                    },
                    axisTick: { 
                        alignWithLabel:true,
                    },
                },
                // {
                //     axisLine:{
                //         show: true,
                //         symbol: ['none', 'arrow']
                //     },
                //     offset:-550,
                //     axisLabel: {
                //         formatter: (function(value){
                //             return moment(parseInt(value/1000000)).format('YYYY-MM-DD HH:mm:ss')
                //         })
                //     },
                //     max:maxtime.unix()*1000000000,
                //     min:mintime.subtract(100,'seconds').unix()*1000000000,
                    
                //     axisTick: { 
                //         alignWithLabel:true,
                //     },
                // },
            ],
            yAxis: {
                type: 'category',
                name:'Validator',
                nameTextStyle: {
                    align: "center",
                    lineHeight: 40,
                },
                data: this.state.AxisY,
                triggerEvent: true,
                axisLabel:{
                    margin:8,
                    formatter:function(data){ 
                        var val=''
                        if(data.length>5){
                            val = data.substr(0,4)+'...';
                            return val ;
                        }else {
                            return data;
                        }
                    }
                },
                boundaryGap: false,
                // scale: true,
                axisTick: {
                    alignWithLabel: true
                }
            },
            toolbox: {
                feature: {
                    dataZoom: {}
                }
            },
            // dataZoom: {
            //     type: 'inside'
            // },
            
            series: series,
        }; 
        myChart.setOption(option);
        // window.addEventListener("resize", function () {
        //     myChart.resize();  //使图表自适应窗口的大小
        // })
        this.extension(myChart); 
    }

    extension(myChart) {
        var elementDiv = document.getElementById('extension');
        if(!elementDiv){
            var div = document.createElement('div')
            div.setAttribute('id', 'extension')
            div.style.display = 'block'
            document.querySelector('html').appendChild(div)
        }
        var styleCss=`position: absolute;margin-left:35px;z-index: 99999;color: #fff;font-size: 12px;padding: 5px;display: inline;border-radius: 4px;background-color: #303133;box-shadow: rgba(0, 0, 0, 0.3) 2px 2px 8px`
        myChart.on('mouseover',function(params){
            if (params.componentType === 'yAxis') {
                elementDiv = document.querySelector('#extension')
                var elementStyle = styleCss
                elementDiv.style.cssText = elementStyle
                elementDiv.innerHTML = params.value
                document.querySelector('html').onmousemove = function (event) {
                var elementDiv = document.querySelector('#extension')
                var xx = event.pageX - 10
                var yy = event.pageY + 15
                elementDiv.style.top = yy + 'px'
                elementDiv.style.left = xx + 'px'
                }
            }else if(params.componentType === "series"){
                if(params.name === params.data.name){
                    elementDiv = document.querySelector('#extension')
                    elementStyle = styleCss
                    elementDiv.style.cssText = elementStyle
                    elementDiv.innerHTML=`<p>${moment(parseInt(params.data.value[0]/1000000)).format('YYYY-MM-DD HH:mm:ss.SSS')}</p><p>round：${params.data.value[4]}</p>`
                    document.querySelector('html').onmousemove = function (event) {
                        var elementDiv = document.querySelector('#extension')
                        var xx = event.pageX - 10
                        var yy = event.pageY + 15
                        elementDiv.style.top = yy + 'px'
                        elementDiv.style.left = xx + 'px'
                    }
                }
            }else if(params.componentType === "markLine"){
                    elementDiv = document.querySelector('#extension')
                    elementStyle = styleCss
                    elementDiv.style.cssText = elementStyle
                    elementDiv.innerHTML = moment(parseInt(params.data.xAxis/1000000)).format('YYYY-MM-DD HH:mm:ss.SSS')
                    document.querySelector('html').onmousemove = function (event) {
                        elementDiv = document.querySelector('#extension')
                        var xx = event.pageX - 10
                        var yy = event.pageY + 15
                        elementDiv.style.top = yy + 'px'
                        elementDiv.style.left = xx + 'px'
                    }
            }
        })

        myChart.on('mouseout', function (params) {
            elementDiv = document.querySelector('#extension')
            if (params.componentType === 'yAxis') {
                elementDiv.style.cssText = 'display:none'
            }
            if(params.componentType === "series"){
                if(params.name === params.data.name){
                    elementDiv.style.cssText = 'display:none'
                }
            }
            if(params.componentType === "markLine"){
                elementDiv.style.cssText = 'display:none'
            }
        })
    }
    render() {
        return (
            <div id="main" className="container" style={{ padding: '50px', boxSizing:'border-box',  width: '100%', height: 900 }}> 
            </div>
        );
    }
}
export default App;
