import React, { Component } from 'react';
import * as echarts from 'echarts';
import moment from 'moment'
class App extends Component {
    state={
        data:[],
        TopAxisX:[],
        BottomAxisX:[],
        TopAxisX1:[],
        AxisY:[],
        Links:[],
        target:[],
    }
  componentDidMount(){
    fetch('/api/graph_by_height_and_duration?height=0&duration=0',{
        method:'GET',
        headers:{
            'Content-Type':'application/json;charset=UTF-8'
        },
    })
    .then(res =>
        res.json()
    )
    .then((data) => {
        this.setState({
            data:data.result.Rows,
            TopAxisX:data.result.AxisX.TopAxisX,
            BottomAxisX:data.result.AxisX.BottomAxisX,
            AxisY:data.result.AxisY,
            Links:data.result.Links,
        })

        var markline=data.result.AxisX.TopAxisX.map(item=>{
            return [ 
                        {
                            // name: 'start', 
                            xAxis:item.Time, 
                            yAxis: '1',
                            label: {
                                show: true,
                                lineHeight:25,
                                // position: 'start', // 改变label位置
                                position: 'insideMiddleTop',
                                formatter:item.Value , // 格式化标签文本
                            },
                            lineStyle: { color: 'red', type: 'solid',with:30},
                        },
                        {
                            // name: 'end', 
                            xAxis: item.Time, 
                            yAxis: '1'
                        },
                    ] 
        })
        data.result.AxisX.BottomAxisX.map(item=>{
            markline.push( [ 
                        {
                            // name: 'start', 
                            xAxis:item.Time, 
                            yAxis: '0',
                            label: {
                                show: true,
                                lineHeight:25,
                                // position: 'start', // 改变label位置
                                position: 'insideMiddleTop',
                                formatter:item.Value , // 格式化标签文本
                            },
                            lineStyle: { color: 'green', type: 'solid',with:30},
                        },
                        {
                            // name: 'end', 
                            xAxis: item.Time, 
                            yAxis: '0'
                        },
                    ] )
        })



        var source= data.result.Rows
        var target=[];
        for(var i in source){
            var list=[];
            var lineList=source[i];
            for (var j in lineList) {
                list.push([
                    lineList[j].XAsTime,
                    lineList[j].Type,
                    lineList[j].Y,
                    lineList[j].Desc,
                    lineList[j].Round,
                    lineList[j].Index,
                    lineList[j].ID,
                    lineList[j].Role
                ]);
            }
            target.push(list);
        }

        var chartDom = document.getElementById('main');
        var myChart = echarts.init(chartDom);
        var option;
        const series = [];
        this.state.AxisY.forEach(function (type) {
             const arr = target.map(function (item) {
                const data = item.map((item, index) => {
                        var colors 
                        if(item[7]==='Normal'){
                            colors ='#4B4B4B'
                        }else if(item[7]==='Witness'){
                            colors ='#4A4CFF'
                        }else if(item[7]==='Famous1'){
                            colors ='#00FFFF'
                        }else if(item[7]==='Famous2'){
                            colors ='#06FF02'
                        }
                        
                    return {
                        label: {
                            show: true,
                            position: 'top'
                        },
                        emphasis: {
                            label: {
                                show: true,
                            }
                        },
                        name: item[6],
                        value: item,
                        // x: item[0],
                        itemStyle:{
                                borderWidth: 1,
                                borderColor: '#333',
                                color:colors,
                        },
                        symbolSize:item[3]==item[6]? 15 : 15 
                    }; 
                })
                return data;
            })
            var newArr=arr.reduce(function(total,currentValue){
                return total.concat(currentValue)
            })
            let links = data.result.Links;
            links.map(item=>{
                item['source'] = item['Source']
                item['target'] = item['Target']
            })
            // links.pop();
            series.push({
                name: type,
                type: 'graph',
                coordinateSystem: 'cartesian2d',
                data: newArr,
                links: links,
                edgeSymbol: ['none', 'arrow'],
                edgeSymbolSize: 5,
                legendHoverLink: false,
                lineStyle: {
                    color: '#333'
                },
                itemStyle: {
                    borderWidth: 1,
                    borderColor: '#333',
                },
                label: {
                    color: '#333',
                    position: 'center'
                },
                symbolSize: 15,
                markLine:{
                        symbol:'circle',
                        data:markline,
                      }
            });
            
        });
        option = {
            visualMap: {
                show: false,
                dimension: 1,
            },
            legend: {
                show: false,
                data: this.state.AxisY,
                
                selectedMode: 'single',
                right: 100
            },
            grid: {
                left: 0,
                bottom: 0,
                containLabel: true,
                top: 80
            },
            xAxis: [
                {
                    // type: 'value',
                    // type:'time',
                    axisLabel: {
                        formatter: (function(value){
                            return moment(parseInt(value/1000000)).format('YYYY-MM-DD HH:mm:ss.SSS')
                        })
                    },
                    min: data.result.AxisX.AxisXBegin,
                    max:data.result.AxisX.AxisXEnd,
                    interval:(data.result.AxisX.AxisXEnd-data.result.AxisX.AxisXBegin)/5,
                    // offset:-75,
                    axisLine:{
                        show:true,
                        symbol: ['none', 'arrow']
                    },
                    // boundaryGap: true,
                    axisTick: { 
                        alignWithLabel:true,
                    },

                },

                // 上边的轴指的是之前block 
                {
                    name:'block',
                    // data:topValue,
                    // offset:-75,
                    axisLine:{
                        show: true,
                        symbol: ['none', 'arrow']
                    },
                    axisLabel:{
                        inside: false,
                    },
                    // boundaryGap: true,
                    axisTick: { 
                        alignWithLabel:true,
                    }
                },
                {
                    axisLine:{
                        show: true,
                        symbol: ['none', 'arrow']
                    },
                    axisLabel:{
                        inside: true,
                    },
                    // boundaryGap: true,
                    axisTick: { 
                        alignWithLabel:true,
                    }
                },
            ],
            yAxis: {
                type: 'category',
                name:'validator',
                data: this.state.AxisY,
                triggerEvent: true,
                axisLabel:{
                    margin:8,
                    formatter:function(data){ 
                        var val=''
                        if(data.length>4){
                            val = data.substr(0,4)+'...';
                            return val ;
                        }else {
                            return data;
                        }
                    }
                },
                boundaryGap: false,
                // min: 0,
                // max: 5,
                // scale: true,
                axisTick: {
                    alignWithLabel: true
                }
                
            },
            toolbox: {
                feature: {
                    dataZoom: {}
                }
            },
            // dataZoom: {
            //     type: 'inside'
            // },
            series: series,
        }; 
        myChart.setOption(option);

        extension(myChart);
        function extension(myChart){
            var elementDiv = document.getElementById('extension');
            if(!elementDiv){
                var div = document.createElement('div')
                div.setAttribute('id', 'extension')
                div.style.display = 'block'
                document.querySelector('html').appendChild(div)
            }
            myChart.on('mouseover',function(params){
                if (params.componentType == 'yAxis') {
                    var elementDiv = document.querySelector('#extension')
                    var elementStyle =
                      'position: absolute;margin-left:35px;z-index: 99999;color: #fff;font-size: 12px;padding: 5px;display: inline;border-radius: 4px;background-color: #303133;box-shadow: rgba(0, 0, 0, 0.3) 2px 2px 8px'
                    elementDiv.style.cssText = elementStyle
                    elementDiv.innerHTML = params.value
                    document.querySelector('html').onmousemove = function (event) {
                      var elementDiv = document.querySelector('#extension')
                      var xx = event.pageX - 10
                      var yy = event.pageY + 15
                      elementDiv.style.top = yy + 'px'
                      elementDiv.style.left = xx + 'px'
                    }
                  }
            })
            myChart.on('mousemove', function (params) {
                console.log(params)
                if(params.componentType == "series"){
                    if(params.name === params.data.name){
                        var elementDiv = document.querySelector('#extension')
                        var elementStyle =
                            `position: absolute;
                            margin-left:35px;
                            z-index: 99999;
                            color: #fff;
                            font-size: 12px;
                            padding: 5px;
                            display: inline;
                            border-radius: 4px;background-color: #303133;
                            box-shadow: rgba(0, 0, 0, 0.3) 2px 2px 8px`

                        elementDiv.style.cssText = elementStyle
                        elementDiv.innerHTML = moment(parseInt(params.data.value[0]/1000000)).format('YYYY-MM-DD HH:mm:ss.SSS')
                        document.querySelector('html').onmousemove = function (event) {
                            var elementDiv = document.querySelector('#extension')
                            var xx = event.pageX - 10
                            var yy = event.pageY + 15
                            elementDiv.style.top = yy + 'px'
                            elementDiv.style.left = xx + 'px'
                          }
                    }
                }
            })
            myChart.on('mouseout', function (params) {
                if (params.componentType == 'yAxis') {
                  var elementDiv = document.querySelector('#extension')
                  elementDiv.style.cssText = 'display:none'
                }
                if(params.componentType == "series"){
                    if(params.name === params.data.name){
                        var elementDiv = document.querySelector('#extension')
                        elementDiv.style.cssText = 'display:none'
                    }
                }
            })
        }
    })
  }
  render() {
    return (
        <div id="main" className="container" style={{ padding: '50px', boxSizing:'border-box',  width: '100%', height: 1000 }}> 
        </div>
    );
  }
}
export default App;
