package multisend

import (
	"testing"
)

func TestSendTx(t *testing.T) {

	clientFactory, exists := clientFactories["ethclient"]
	if !exists {
		t.Error("can't find ethclient in clientFactories")
	}

	cfg := Config{
		SendTxPrivateKey: "a1994419e9b06a7b27e8d094840ae26a6b7806633bb8be55a1a835f1620d8cec",
	}
	client, err := clientFactory.NewClient(cfg)

	if err != nil {
		t.Errorf(err.Error())
	}

	tx, err := client.BuildTx(nil)

	if err != nil {
		t.Errorf(err.Error())
	}

	txAsBytes, err := tx.MarshalBinary()

	if err != nil {
		t.Errorf(err.Error())
	}

	t.Logf("txAsHex: %x \n", txAsBytes)

}
