package multisend

import (
	"context"
	"crypto/ecdsa"
	"math/big"

	"github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/ethclient"

	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/crypto"
)

var sendTxPrivatekey string = "a1994419e9b06a7b27e8d094840ae26a6b7806633bb8be55a1a835f1620d8cec"
var toAddress common.Address = common.HexToAddress("0x0071B39fd266F8aeF392fb50F078A233b2218a0b")

// func RegisterBuildTxParam(name string, factory Param) error {
// 	if _, exists := buildTxPrama[name]; exists {
// 		return fmt.Errorf("source param with the specified name already exists: %s", name)
// 	}
// 	buildTxPrama[name] = factory
// 	return nil
// }

func init() {
	if err := RegisterClientFactory("ethclient", NewEthClientFactory()); err != nil {
		panic(err)
	}
}

type EthClientFactory struct{}

type EthClient struct {
	PrivateKey *ecdsa.PrivateKey
	FromAddr   common.Address
	NodeUrl    string
	Nonce      uint64
	GasPrice   *big.Int
	ChainId    *big.Int
	GasLimit   uint64
}

var _ ClientFactory = (*EthClientFactory)(nil)
var _ Client = (*EthClient)(nil)

func NewEthClientFactory() *EthClientFactory {
	return &EthClientFactory{}
}

func (f *EthClientFactory) ValidateConfig(cfg Config) error {
	return nil
}

func (f *EthClientFactory) NewClient(cfg Config) (Client, error) {

	sendTxPrivatekeyAsECDSA, err := crypto.HexToECDSA(sendTxPrivatekey)
	if err != nil {
		panic(err)
	}
	sendTxPublicKey := sendTxPrivatekeyAsECDSA.Public()
	sendTxPublicKeyECDSA, ok := sendTxPublicKey.(*ecdsa.PublicKey)
	if !ok {
		panic("publicKey.(*ecdsa.PublicKey) not ok")
	}
	sendTxFromAddress := crypto.PubkeyToAddress(*sendTxPublicKeyECDSA)

	buildTxParam := EthClient{
		PrivateKey: sendTxPrivatekeyAsECDSA,
		FromAddr:   sendTxFromAddress,
		NodeUrl:    "http://13.40.31.153:8545",
		//https://heco.getblock.io/mainnet/
		//NodeUrl: "https://heco.getblock.io/mainnet/",
		//NodeUrl: "https://http-mainnet-node.huobichain.com",
	}

	cli, err := ethclient.Dial(buildTxParam.NodeUrl)
	if err != nil {
		panic(err)
	}

	nonce, err := cli.PendingNonceAt(context.Background(), buildTxParam.FromAddr)
	if err != nil {
		panic(err)
	}

	gasPrice, err := cli.SuggestGasPrice(context.Background())
	if err != nil {
		panic(err)
	}

	ChainId, err := cli.NetworkID(context.Background())
	if err != nil {
		panic(err)
	}

	buildTxParam.Nonce = nonce
	buildTxParam.GasPrice = gasPrice
	buildTxParam.ChainId = ChainId

	return &buildTxParam, nil
}

func (c *EthClient) GenerateTx() (*types.Transaction, error) {

	select {
	case txRootHashList := <-originalTxsHashQueue:
		if c.GasLimit == 0 {
			cli, err := ethclient.Dial(c.NodeUrl)
			if err != nil {
				panic(err)
			}

			gasLimit, err := cli.EstimateGas(context.Background(), ethereum.CallMsg{
				To:   &toAddress,
				Data: *txRootHashList,
			})
			if err != nil {
				return nil, err
			}

			c.GasLimit = gasLimit

		}

		tx, err := buildSendTx(c.Nonce, toAddress, big.NewInt(0), c.GasLimit, c.GasPrice, *txRootHashList, c.ChainId, c.PrivateKey)
		if err != nil {
			return nil, err
		}

		c.Nonce += 1

		return tx, nil

	}
}
