package multisend

import (
	"context"
	"fmt"
	"testing"
	"time"

	"github.com/go-redis/redis_rate/v9"
)

func TestRateLimit(t *testing.T) {

	client:= initClient(10)

	ctx := context.Background()
	limiter := redis_rate.NewLimiter(client)

	for i := 0; i < 10; i++ {
		res, err := limiter.Allow(ctx, "project:123", redis_rate.PerSecond(10))
		if err != nil {
			panic(err)
		}

		client.Set(ctx, "key", i, time.Second*100)
		fmt.Println("allowed", res.Allowed, "remaining", res.Remaining)

	}

}
