package main

import (
	"fmt"
	"os"
	"sync"

	"code.wuban.net.cn/multisend"
	"code.wuban.net.cn/multisend/internal/logging"
	"github.com/spf13/cobra"
)

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}

var (
	rate, sendPeriod, count, expectedTime int
	websocketAddr, redisAddr, redisPasswd string
)

func init() {
	//cobra.OnInitialize(initConfig)
	rootCmd.PersistentFlags().StringVar(&websocketAddr, "websocketAddr", "ws://13.40.31.153:8546", "eth classical websocket rpc addr")
	rootCmd.PersistentFlags().IntVar(&rate, "rate", 1, "every period send tx number")
	rootCmd.PersistentFlags().IntVar(&sendPeriod, "sendPeriod", 3, "send tx time unit")
	rootCmd.PersistentFlags().IntVar(&count, "count", 100, "total tx number")
	rootCmd.PersistentFlags().IntVar(&expectedTime, "expectedTime", 100, "the  expected time used to send the total tx number")
	rootCmd.PersistentFlags().StringVar(&redisAddr, "redisAddr", "127.0.0.1:6379", "commit the  original txs to the redis queue")
	rootCmd.PersistentFlags().StringVar(&redisPasswd, "redisPasswd", "redis20220217", "redis password")
}

var rootCmd = &cobra.Command{
	Use:   "sendTxs",
	Short: "send batch txs hash to chain and original txs to redis",
	Run: func(cmd *cobra.Command, args []string) {
		logger := logging.NewLogrusLogger("cmd")
		cfg := multisend.Config{
			Rate:          rate,
			Count:         count,
			Connections:   1,
			Time:          int(expectedTime),
			SendPeriod:    int(sendPeriod),
			ClientFactory: "ethclient",
		}

		transactor, err := multisend.NewTransactor(websocketAddr, &cfg)

		if err != nil {
			logger.Error(err.Error())
			return
		}

		transactor.Start()

		wg := sync.WaitGroup{}

		wg.Add(1)

		go func() {
			defer wg.Done()
			if err := multisend.ProduceOriginalTx(); err != nil {
				logger.Error(err.Error())
				return
			}

		}()

		multisend.Start(redisAddr, redisPasswd)

	},
}
