package multisend

import (
	"crypto/ecdsa"
	"math/big"

	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
)

func buildSendTx(nonce uint64, to common.Address, amount *big.Int, gasLimit uint64, gasPrice *big.Int, data []byte, chainId *big.Int, privateKey *ecdsa.PrivateKey) (*types.Transaction, error) {
	return buildTx(nonce, to, amount, gasLimit, gasPrice, data, chainId, privateKey)
}

func buildOriginalTx(nonce uint64, to common.Address, amount int64, chainId *big.Int, privateKey *ecdsa.PrivateKey) (*types.Transaction, error) {

	return buildTx(nonce, to, big.NewInt(int64(amount)), 0, big.NewInt(0), nil, chainId, privateKey)

}

func buildTx(nonce uint64, to common.Address, amount *big.Int, gasLimit uint64, gasPrice *big.Int, data []byte, chainId *big.Int, privateKey *ecdsa.PrivateKey) (*types.Transaction, error) {

	tx := types.NewTransaction(nonce, to, amount, gasLimit, gasPrice, data)
	if privateKey != nil {
		signedTx, err := types.SignTx(tx, types.NewEIP155Signer(chainId), privateKey)
		if err != nil {
			return nil, err
		}
		tx = signedTx
	}

	return tx, nil
}
