import { style } from '@vanilla-extract/css'
import { sprinkles } from 'nft/css/sprinkles.css'

export const chevron = style([
  sprinkles({
    height: '28',
    width: '28',
    transition: '250',
    marginLeft: 'auto',
    marginRight: '0',
  }),
])

export const chevronDown = style({
  transform: 'rotate(180deg)',
  cursor: 'pointer',
})

export const sectionDivider = style([
  sprinkles({
    borderRadius: '20',
    marginTop: '8',
    width: 'full',
    borderWidth: '0.5px',
    borderStyle: 'solid',
    borderColor: 'backgroundOutline',
  }),
])

export const button = style([
  sprinkles({
    paddingX: { sm: '12', md: '16' },
    paddingY: { sm: '10', md: '16' },
    textAlign: 'center',
    fontWeight: 'semibold',
    fontSize: { sm: '16', md: '20' },
    lineHeight: { sm: '20', md: '24' },
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    alignSelf: 'flex-end',
    borderRadius: '12',
  }),
])

export const listingModalIcon = style([
  sprinkles({
    borderWidth: '1px',
    borderStyle: 'solid',
    borderColor: 'backgroundSurface',
  }),
  {
    boxSizing: 'border-box',
    marginLeft: '-2px',
    marginRight: '4px',
  },
])

export const warningTooltip = style([
  sprinkles({
    paddingTop: '8',
    paddingRight: '8',
    paddingBottom: '8',
    paddingLeft: '12',
  }),
  {
    boxShadow: '0px 4px 16px rgba(10, 10, 59, 0.2)',
  },
])

export const listingSectionBorder = style([
  sprinkles({
    padding: '8',
    borderRadius: '8',
    borderColor: 'backgroundOutline',
    borderStyle: 'solid',
    borderWidth: '1px',
  }),
])
