import { Path, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [NoTransactions, AnimatedNoTransactions] = createIcon({
  name: 'NoTransactions',
  getIcon: (props) => (
    <Svg fill="none" viewBox="0 0 102 94" {...props}>
      <Path
        clipRule="evenodd"
        d="M20.5247 9.00098L5.2535 13.3799C1.53727 14.4455 -0.611486 18.322 0.454126 22.0382L13.6601 68.093C14.7257 71.8092 18.6022 73.958 22.3184 72.8924L56.817 63H31.5247C25.4495 63 20.5247 58.0752 20.5247 52V9.00098Z"
        fill="currentColor"
        fillRule="evenodd"
      />
      <Path
        clipRule="evenodd"
        d="M31.5244 0C27.6584 0 24.5244 3.13401 24.5244 7V52C24.5244 55.866 27.6584 59 31.5244 59H56.7608C60.618 51.6192 67.9151 46.3207 76.5244 45.2321V7C76.5244 3.13401 73.3904 0 69.5244 0H31.5244ZM37.0244 19C38.4051 19 39.5244 17.8807 39.5244 16.5C39.5244 15.1193 38.4051 14 37.0244 14C35.6437 14 34.5244 15.1193 34.5244 16.5C34.5244 17.8807 35.6437 19 37.0244 19ZM39.5244 29.5C39.5244 30.8807 38.4051 32 37.0244 32C35.6437 32 34.5244 30.8807 34.5244 29.5C34.5244 28.1193 35.6437 27 37.0244 27C38.4051 27 39.5244 28.1193 39.5244 29.5ZM37.0244 45C38.4051 45 39.5244 43.8807 39.5244 42.5C39.5244 41.1193 38.4051 40 37.0244 40C35.6437 40 34.5244 41.1193 34.5244 42.5C34.5244 43.8807 35.6437 45 37.0244 45ZM44.5244 16.5C44.5244 15.1193 45.6437 14 47.0244 14H64.0244C65.4051 14 66.5244 15.1193 66.5244 16.5C66.5244 17.8807 65.4051 19 64.0244 19H47.0244C45.6437 19 44.5244 17.8807 44.5244 16.5ZM47.0244 27C45.6437 27 44.5244 28.1193 44.5244 29.5C44.5244 30.8807 45.6437 32 47.0244 32H64.0244C65.4051 32 66.5244 30.8807 66.5244 29.5C66.5244 28.1193 65.4051 27 64.0244 27H47.0244ZM44.5244 42.5C44.5244 41.1193 45.6437 40 47.0244 40H64.0244C65.4051 40 66.5244 41.1193 66.5244 42.5C66.5244 43.8807 65.4051 45 64.0244 45H47.0244C45.6437 45 44.5244 43.8807 44.5244 42.5Z"
        fill="currentColor"
        fillRule="evenodd"
      />
      <Path
        clipRule="evenodd"
        d="M79.8188 93.0254C91.9691 93.0254 101.819 83.1757 101.819 71.0254C101.819 58.8751 91.9691 49.0254 79.8188 49.0254C67.6686 49.0254 57.8188 58.8751 57.8188 71.0254C57.8188 83.1757 67.6686 93.0254 79.8188 93.0254ZM88.0682 71.0251L79.8185 62.7754L71.5689 71.0251L79.8185 79.2748L88.0682 71.0251Z"
        fill="currentColor"
        fillRule="evenodd"
      />
    </Svg>
  ),
})
