import {
  InterfaceElementName,
  InterfaceModalName,
  InterfacePageName,
  InterfaceSectionName,
} from '@uniswap/analytics-events'
import { OnboardingCardLoggingName } from 'uniswap/src/features/telemetry/types'

export const ModalName = {
  AccountBlocked: 'account-blocked-modal',
  AccountEdit: 'account-edit-modal',
  AccountEditLabel: 'account-edit--label-modal',
  AccountSwitcher: 'account-switcher-modal',
  AcrossRoutingInfo: 'across-routing-info-modal',
  ActionCannotBeCompletedModal: 'action-cannot-be-completed-modal',
  AddLiquidity: 'add-liquidity',
  AddPasskey: 'add-passkey',
  AddressClaim: 'address-claim-modal',
  AddressQR: 'address-qr-modal',
  AddWallet: 'add-wallet-modal',
  AppRatingModal: 'app-rating-modal',
  BackupReminder: 'backup-reminder-modal',
  BackupReminderWarning: 'backup-reminder-warning-modal',
  Bag: 'bag-modal',
  Banners: 'banners-modal',
  BiometricsModal: 'biometrics-modal',
  BlockedAccount: 'blocked-account',
  BlockedAddress: 'blocked-address',
  BridgingWarning: 'bridging-warning-modal',
  BuyNativeToken: 'buy-native-token-modal',
  CancelOrders: 'cancel-orders-modal',
  ChooseProfilePhoto: 'choose-profile-photo-modal',
  ChooseProviderModal: 'choose-provider-modal',
  ChooseUnitag: 'choose-unitag-modal',
  ClaimFee: 'claim-fee-modal',
  ClaimPopup: 'claim-popup',
  CloudBackupInfo: 'cloud-backup-info-modal',
  ConfirmCreatePosition: 'confirm-create-position-modal',
  ConnectionError: 'connection-error-modal',
  ConnectionsDappListModal: 'connections-dapp-list-modal',
  ContractAddressExplainer: 'contract-address-explainer-modal',
  CreatePasskey: 'create-passkey-modal',
  CreatePosition: 'create-position-modal',
  CurrencySearch: 'currency-search-modal',
  DappRequest: 'dapp-request',
  Delegate: 'delegate',
  DelegationMismatch: 'delegation-mismatch-modal',
  DeletePasskeySpeedbump: 'delete-passkey-speedbump-modal',
  DeletePasskey: 'delete-passkey-modal',
  DevFlags: 'dev-flags-modal',
  Dialog: 'dialog-modal',
  DownloadApp: 'download-app-modal',
  DynamicFeeTierSpeedbump: 'dynamic-fee-tier-speedbump-modal',
  EditLabelSettingsModal: 'edit-label-settings-modal',
  EditProfileSettingsModal: 'edit-profile-settings-modal',
  ENSClaimPeriod: 'ens-claim-period',
  EnterPassword: 'enter-password-modal',
  EstimatedTimeInfo: 'estimated-time-info-modal',
  ExchangeTransferModal: 'exchange-transfer-modal',
  Execute: 'execute',
  Experiments: 'experiments',
  Explore: 'explore-modal',
  ExploreProtocolFilter: 'explore-pools-protocol-filter',
  FaceIDWarning: 'face-id-warning',
  FeatureFlags: 'feature-flags-modal',
  FeeClaim: 'fee-claim-modal',
  FeeTierSearch: 'fee-tier-search-modal',
  FiatCurrencySelector: 'fiat-currency-selector',
  FiatOffRampConfirmTransfer: 'fiat-off-ramp-confirm-transfer',
  FiatOffRampConfirmTransferError: 'fiat-off-ramp-confirm-transfer-error',
  FiatOffRampUnsupportedTokenModal: 'fiat-off-ramp-unsupported-token-modal',
  FiatOnramp: 'fiat-onramp-modal',
  FiatOnRampAggregator: 'fiat-on-ramp-aggregator',
  FiatOnRampCountryList: 'fiat-on-ramp-country-list',
  FiatOnRampTokenSelector: 'fiat-on-ramp-token-selector',
  ForceUpgradeModal: 'force-upgrade-modal',
  ForgotPassword: 'forgot-password',
  FOTInfo: 'fee-on-transfer',
  FundWallet: 'fund-wallet',
  GetTheApp: 'get-the-app',
  HiddenNFTInfoModal: 'hidden-nft-info-modal',
  HiddenTokenInfoModal: 'hidden-token-info-modal',
  Hook: 'hook',
  KoreaCexTransferInfoModal: 'korea-cex-transfer-info-modal',
  LanguageSelector: 'language-selector-modal',
  Legal: 'legal',
  LowNativeBalanceWarning: 'low-native-balance-warning',
  LpIncentiveClaimModal: 'lp-incentive-claim-modal',
  ManageWalletsModal: 'manage-wallets-modal',
  MigrateLiquidity: 'migrate-liquidity',
  NativeBalanceInfo: 'native-balance-info',
  NetworkFeeInfo: 'network-fee-info',
  NetworkSelector: 'network-selector-modal',
  NewAddressSpeedBump: 'new-address-speed-bump',
  NewAddressWarning: 'new-address-warning-modal',
  NftCollection: 'nft-collection',
  NotFound: 'not-found',
  NotificationsOSSettings: 'notifications-os-settings-modal',
  OffchainActivity: 'offchain-activity-modal',
  OnDeviceRecoveryConfirmation: 'on-device-recovery-confirmation',
  OtpInputExpired: 'otp-input-expired',
  OtpScanInput: 'otp-scan-input',
  PasskeyManagement: 'passkey-management-modal',
  PasskeysHelp: 'passkeys-help-modal',
  PriceImpact: 'price-impact-modal',
  PrivacyChoices: 'privacy-choices-modal',
  PermissionsModal: 'permissions-modal',
  PortfolioBalanceModal: 'portfolio-balance-modal',
  PostSwapSmartWalletNudge: 'post-swap-smart-wallet-nudge',
  PrivacyPolicy: 'privacy-policy',
  PrivateKeySpeedBumpModal: 'private-key-speed-bump-modal',
  QRCodeNetworkInfo: 'qr-code-network-info',
  Queue: 'queue',
  QueuedOrderModal: 'queued-order-modal',
  ReceiveCryptoModal: 'receive-crypto-modal',
  RecentlyConnectedModal: 'recently-connected-modal',
  ReceiveCryptoQr: 'receive-crypto-qr',
  RecipientSelectErc20Warning: 'recipient-select-erc20-warning',
  RecipientSelectNewWarning: 'recipient-select-new-warning',
  RecipientSelectSelfSendWarning: 'recipient-select-self-send-warning',
  RecipientSelectSmartContractWarning: 'recipient-select-smart-contract-warning',
  RecipientSelectViewOnlyWarning: 'recipient-select-view-only-warning',
  RecoverySpeedBump: 'recovery-speed-bump',
  RemoveLiquidity: 'remove-liquidity',
  RemoveSeedPhraseWarningModal: 'remove-seed-phrase-warning-modal',
  RemoveWallet: 'remove-wallet-modal',
  ResetCreatePositionsForm: 'reset-create-positions-form',
  RestoreWallet: 'restore-wallet-modal',
  Scantastic: 'scantastic',
  SmartWalletAdvancedSettingsModal: 'smart-wallet-advanced-settings-modal',
  SmartWalletConfirmModal: 'smart-wallet-confirm-modal',
  SmartContractSpeedBump: 'smart-contract-speed-bump',
  SmartWalletInsufficientFundsOnNetworkModal: 'smart-wallet-insufficient-funds-modal',
  ScreenshotWarning: 'screenshot-warning',
  Search: 'search-modal',
  SeedPhraseWarningModal: 'seed-phrase-warning-modal',
  Send: 'send-modal',
  SendReview: 'send-review-modal',
  SendWarning: 'send-warning-modal',
  Settings: 'settings',
  SettingsAppearance: 'appearance-settings-modal',
  SignIn: 'sign-in-modal',
  SignUp: 'sign-up-modal',
  SlippageInfo: 'slippage-info-modal',
  SlippageWarningModal: 'slippage-warning-modal',
  SmartWalletCreatedModal: 'smart-wallet-created-modal',
  SmartWalletDisableModal: 'smart-wallet-disable-modal',
  SmartWalletEducationalModal: 'smart-wallet-educational-modal',
  SmartWalletEnabledModal: 'smart-wallet-enabled-modal',
  SmartWalletInfoModal: 'smart-wallet-info-modal',
  SmartWalletUpgradeModal: 'smart-wallet-upgrade-modal',
  SmartWalletUnavailableModal: 'smart-wallet-unavailable-modal',
  StorageWarning: 'storage-warning-modal',
  Swap: 'swap-modal',
  SwapError: 'swap-error-modal',
  SwapProtection: 'swap-protection-modal',
  SwapReview: 'swap-review-modal',
  SwapSettings: 'swap-settings-modal',
  SwapSettingsDefaultRoutingInfo: 'swap-settings-default-routing-info-modal',
  SwapWarning: 'swap-warning-modal',
  TestnetMode: 'testnet-mode-modal',
  TestnetSwitchModal: 'testnet-switch-modal',
  TokenSafety: 'token-safety-modal',
  TokenSelector: 'token-selector',
  TokenWarning: 'token-warning',
  TokenWarningModal: 'token-warning-modal',
  TooltipContent: 'tooltip-content',
  TransactionActions: 'transaction-actions',
  TransactionCancellation: 'transaction-cancellation-modal',
  TransactionConfirmation: 'transaction-confirmation-modal',
  TransactionDetails: 'transaction-details',
  TokenNotFound: 'token-not-found',
  PoolNotFound: 'pool-not-found',
  UkDisclaimer: 'uk-disclaimer-modal',
  UniconsDevModal: 'unicons-dev-modal',
  UniconsV2: 'unicons-v2-intro-modal',
  UniswapXInfo: 'uniswapx-info-modal',
  UnitagsChange: 'unitags-change-modal',
  UnitagsChangeConfirm: 'unitags-change-confirm-modal',
  UnitagsDelete: 'unitags-delete-modal',
  UnitagsIntro: 'unitags-intro-modal',
  UniWalletConnect: 'uniwallet-connect-modal',
  UnsupportedCurrency: 'unsupported-currency-modal',
  UwULinkErc20SendModal: 'uwulink-erc20-send-modal',
  VerifyPasskey: 'verify-passkey-modal',
  V4HooksInfo: 'v4-hooks-info-modal',
  ViewOnlyExplainer: 'view-only-explainer-modal',
  ViewSeedPhraseWarning: 'view-seed-phrase-warning',
  Vote: 'vote',
  WalletConnectScan: 'wallet-connect-scan-modal',
  WCDappConnectedNetworks: 'wc-dapp-connected-networks-modal',
  WCPendingConnection: 'wc-pending-connection-modal',
  WCSignRequest: 'wc-sign-request-modal',
  WCViewOnlyWarning: 'wc-view-only-warning-modal',
  // alphabetize additional values.
} as const

export type ModalNameType = (typeof ModalName)[keyof typeof ModalName] | InterfaceModalName

/**
 * Possible names for the telement property in TraceContext
 */
export const ElementName = {
  AcceptNewRate: 'accept-new-rate',
  AccountCard: 'account-card',
  AddManualBackup: 'add-manual-backup',
  AddViewOnlyWallet: 'add-view-only-wallet',
  AddCloudBackup: 'add-cloud-backup',
  AddHook: 'add-hook',
  AddPasskey: 'add-passkey',
  AddPasskeyCrossPlatform: 'add-passkey-cross-platform',
  AddPasskeyPlatform: 'add-passkey-platform',
  AlreadyHaveWalletSignIn: 'already-have-wallet-sign-in',
  AppCrashScreen: 'app-crash-screen',
  BackButton: 'back-button',
  Buy: 'buy',
  BuyNativeTokenButton: 'buy-native-token-button',
  BridgeNativeTokenButton: 'bridge-native-token-button',
  Cancel: 'cancel',
  ChainEthereum: 'chain-ethereum',
  ChainUnichain: 'chain-unichain',
  ChainUnichainSepolia: 'chain-unichain-sepolia',
  ChainSepolia: 'chain-sepolia',
  ChainOptimism: 'chain-optimism',
  ChainArbitrum: 'chain-arbitrum',
  ChainPolygon: 'chain-polygon',
  ChainCelo: 'chain-celo',
  ChainBNB: 'chain-bnb',
  ChainAvalanche: 'chain-avalanche',
  ChainBase: 'chain-base',
  ChainBlast: 'chain-blast',
  ChainMonadTestnet: 'chain-monad-testnet',
  ChainSoneium: 'chain-soneium',
  ChainWorldChain: 'chain-world-chain',
  ChainZora: 'chain-zora',
  ChainZkSync: 'chain-zksync',
  ChooseInputToken: 'choose-input-token',
  ChooseOutputToken: 'choose-output-token',
  ClearPending: 'clear-pending',
  Confirm: 'confirm',
  ConnectExistingWallet: 'connect-existing-wallet',
  Continue: 'continue',
  Copy: 'copy',
  CopyAddress: 'copy-address',
  CreateAccount: 'create-account',
  CreateAWallet: 'create-a-wallet',
  CreatePasskey: 'create-passkey',
  DeletePasskey: 'delete-passkey',
  DeletePasskeyAcknowledge: 'delete-passkey-acknowledge',
  Disconnect: 'disconnect',
  EmptyStateBuy: 'empty-state-buy',
  EmptyStateImport: 'empty-state-get-import',
  EmptyStateReceive: 'empty-state-receive',
  EmptyStateCEXTransfer: 'empty-state-cex-transfer',
  Enable: 'enable',
  EtherscanView: 'etherscan-view',
  ExtensionPopupOpenButton: 'extension-popup-open-button',
  FiatOnRampTokenSelector: 'fiat-on-ramp-token-selector',
  FiatOnRampWidgetButton: 'fiat-on-ramp-widget-button',
  FiatOnRampCountryPicker: 'fiat-on-ramp-country-picker',
  GetHelp: 'get-help',
  GetTheApp: 'get-the-app',
  ImportAccount: 'import-account',
  InlineWarningCardCheckbox: 'inline-warning-card-checkbox',
  LimitOrderButton: 'limit-order-button',
  MaybeLaterButton: 'maybe-later-button',
  MoonpayExplorerView: 'moonpay-explorer-view',
  NetworkButton: 'network-button',
  Next: 'next',
  NftItem: 'nft-item',
  OK: 'ok',
  OnboardingIntroCardFundWallet: 'onboarding-intro-card-fund-wallet',
  OnboardingIntroCardEnablePushNotifications: 'onboarding-intro-card-enable-push-notifications',
  OnboardingImportBackup: 'onboarding-import-backup',
  OnboardingImportSeedPhrase: 'onboarding-import-seed-phrase',
  OnboardingImportViewPrivateKeys: 'onboarding-import-view-private-keys',
  OnboardingPasskey: 'onboarding-passkey',
  OnDeviceRecoveryImportOther: 'on-device-recovery-import-other',
  OnDeviceRecoveryWallet: 'on-device-recovery-wallet',
  OnDeviceRecoveryModalCancel: 'on-device-recovery-modal-cancel',
  OnDeviceRecoveryModalConfirm: 'on-device-recovery-modal-confirm',
  OpenCameraRoll: 'open-camera-roll',
  OpenNftsList: 'open-nfts-list',
  PreselectAsset: 'preselect-asset',
  PresetPercentage: 'preset-percentage',
  QRCodeModalToggle: 'qr-code-modal-toggle',
  Receive: 'receive',
  RecoveryHelpButton: 'recovery-help-button',
  Remove: 'remove',
  RestoreFromCloud: 'restore-from-cloud',
  RestoreWalletModal: 'restore-wallet-modal',
  Sell: 'sell',
  Send: 'send',
  SetPercentageInput: 'set-percentage-input',
  SetPercentageOutput: 'set-percentage-output',
  SignIn: 'sign-in',
  Skip: 'skip',
  Swap: 'swap',
  SwapFormHeader: 'swap-form-header',
  SwapReview: 'swap-review',
  SendReview: 'send-review',
  SmartWalletDisclaimer: 'smart-wallet-disclaimer',
  SmartWalletEnabled: 'smart-wallet-enabled',
  SmartWalletNotNow: 'smart-wallet-not-now',
  SwapRoutingPreferenceDefault: 'swap-routing-preference-default',
  SwapRoutingPreferenceUniswapX: 'swap-routing-preference-UniswapX',
  SwapRoutingPreferenceV2: 'swap-routing-preference-v2',
  SwapRoutingPreferenceV3: 'swap-routing-preference-v3',
  SwapRoutingPreferenceV4: 'swap-routing-preference-v4',
  SwapRoutingPreferenceV4Hooks: 'swap-routing-preference-v4-hooks',
  SwitchCurrenciesButton: 'switch-currencies-button',
  TDPActionMenuButton: 'tdp-action-menu-button',
  TimeFrame1H: 'time-frame-1H',
  TimeFrame1D: 'time-frame-1D',
  TimeFrame1W: 'time-frame-1W',
  TimeFrame1M: 'time-frame-1M',
  TimeFrame1Y: 'time-frame-1Y',
  TimeFrameAll: 'time-frame-All',
  TokenAddress: 'token-address',
  TokenInputSelector: 'token-input-selector',
  TokenItem: 'token-item',
  TokenLinkEtherscan: 'token-link-etherscan',
  TokenLinkTwitter: 'token-link-twitter',
  TokenLinkWebsite: 'token-link-website',
  TokenOutputSelector: 'token-output-selector',
  TokenWarningCard: 'token-warning-card',
  Unwrap: 'unwrap',
  ViewNativePrivateKeysOnCopied: 'view-native-private-keys-on-copied',
  WalletCard: 'wallet-card',
  WalletConnectScan: 'wallet-connect-scan',
  WalletQRCode: 'wallet-qr-code',
  Wrap: 'wrap',
  // alphabetize additional values.
} as const

export type ElementNameType =
  | (typeof ElementName)[keyof typeof ElementName]
  | InterfaceElementName
  | OnboardingCardLoggingName

/**
 * Possible names for the section property in TraceContext
 */
export const SectionName = {
  CurrencyInputPanel: 'currency-input-panel',
  CurrencyOutputPanel: 'currency-output-panel',
  ExploreFavoriteTokensSection: 'explore-favorite-tokens-section',
  ExploreSearch: 'explore-search',
  ExploreTopTokensSection: 'explore-top-tokens-section',
  HomeActivityTab: 'home-activity-tab',
  HomeExploreTab: 'home-explore-tab',
  HomeNFTsTab: 'home-nfts-tab',
  HomeTokensTab: 'home-tokens-tab',
  ImportAccountForm: 'import-account-form',
  ProfileActivityTab: 'profile-activity-tab',
  ProfileNftsTab: 'profile-nfts-tab',
  ProfileTokensTab: 'profile-tokens-tab',
  SwapForm: 'swap-form',
  SwapPending: 'swap-pending',
  SwapReview: 'swap-review',
  TokenSelector: 'token-selector',
  TokenDetails: 'token-details',

  // These name / values don't match because we refactored code to use "send", but wanted to preserve old names for dashboards
  SendForm: 'transfer-form',
  SendReview: 'transfer-review',
  SendRecipientSelectFullScreen: 'send-recipient-select',

  ChainSelector: 'chain-selector',
  CreatePositionDepositStep: 'create-position-deposit-step',
  CreatePositionPriceRangeStep: 'create-position-price-range-step',
  CreatePositionSelectTokensStep: 'create-position-select-tokens-step',
  // alphabetize additional values.
} as const

export type SectionNameType = (typeof SectionName)[keyof typeof SectionName] | InterfaceSectionName

export const InterfacePageNameLocal = {
  Send: 'send-page',
  Limit: 'limit-page',
  Buy: 'buy-page',
  Positions: 'positions-page',
  PositionDetails: 'position-details-page',
  CreatePosition: 'create-position-page',
  MigrateV2: 'migrate-v2-page',
  MigrateV2Pair: 'migrate-v2-pair-page',
  MigrateV3: 'migrate-v3-page',
}

export type InterfacePageNameType =
  | (typeof InterfacePageNameLocal)[keyof typeof InterfacePageNameLocal]
  | InterfacePageName
