/**
 * IDs for testing purposes
 */
export const TestID = {
  AccountCard: 'account-card',
  AccountDrawer: 'account-drawer',
  AccountHeaderAvatar: 'account-header-avatar',
  AccountHeaderCopyAddress: 'account-header-copy-address',
  AccountHeaderSettings: 'account-header-settings-icon',
  AccountSwitcherAddWallet: 'account-switcher-add-wallet',
  ActivityContent: 'activity-content',
  ActivityPopupCloseIcon: 'activity-popup-close-icon',
  ActivityTab: 'activity-tab',
  AddCloudBackup: 'add-cloud-backup',
  AddManualBackup: 'add-manual-backup',
  AddressDisplay: 'address-display',
  AddressDisplayCopyHelper: 'address-display-copy-helper',
  AmountInputIn: 'amount-input-in',
  AmountInputOut: 'amount-input-out',
  AppSettingsDevModal: 'app-settings-dev-modal',
  Back: 'back',
  BreadcrumbHoverCopy: 'breadcrumb-hover-copy',
  BuyFiatButton: 'buy-fiat-button',
  BuyFormAmountInput: 'buy-form-amount-input',
  Cancel: 'cancel',
  ChooseInputToken: 'choose-input-token',
  ChooseOutputToken: 'choose-output-token',
  ChooseProviderModalClose: 'ChooseProviderModal-close',
  ClaimFeeModalClose: 'ClaimFeeModal-close-icon',
  Close: 'close',
  CompanyMenuMobileDrawer: 'company-menu-mobile-drawer',
  Confirm: 'confirm',
  ConfirmationCloseIcon: 'confirmation-close-icon',
  ConnectingViewWrapperBack: 'ConnectingViewWrapper-back',
  ConnectingViewWrapperClose: 'ConnectingViewWrapper-close',
  Continue: 'continue',
  Copy: 'copy',
  CountryListModalClose: 'CountryListModal-close',
  CreateAccount: 'create-account',
  CreatePasskey: 'create-passkey',
  CurrentBreadcrumb: 'current-breadcrumb',
  DecimalPadBackspace: 'decimal-pad-backspace',
  DecimalPadDecimal: 'decimal-pad-decimal',
  DecimalPadNumber0: 'decimal-pad-0',
  DecimalPadNumber1: 'decimal-pad-1',
  DecimalPadNumber2: 'decimal-pad-2',
  DecimalPadNumber3: 'decimal-pad-3',
  DecimalPadNumber4: 'decimal-pad-4',
  DecimalPadNumber5: 'decimal-pad-5',
  DecimalPadNumber6: 'decimal-pad-6',
  DecimalPadNumber7: 'decimal-pad-7',
  DecimalPadNumber8: 'decimal-pad-8',
  DecimalPadNumber9: 'decimal-pad-9',
  DevDeletePrivateKeysButton: 'delete-private-keys-button',
  DevDeleteSeedPhraseButton: 'delete-seed-phrase-button',
  DevFlagsBox: 'dev-flags-box',
  DevFlagsSettingsToggle: 'dev-flags-settings-toggle',
  DevSeedPhrasePrivateKeysAccordion: 'seed-phrase-private-keys-accordion',
  DialogCloseButton: 'Dialog-closeButton',
  Done: 'done',
  DownloadUniswapApp: 'nav-dropdown-download-app',
  DownloadUniswapModal: 'download-uniswap-modal',
  Edit: 'edit',
  ExcludedNetworkBanner: 'excluded-network-banner',
  ExploreSearchInput: 'explore-search-input',
  Favorite: 'favorite',
  FiatOnRampCountryPicker: 'fiat-on-ramp-country-picker',
  GasInfoRow: 'gas-info-row',
  ImportAccount: 'import-account',
  ImportAccountInput: 'import-account-input',
  LandingPage: 'landing-page',
  LimitsMenuContainer: 'LimitsMenuContainer',
  LiquidityModalHeaderClose: 'LiquidityModalHeader-close',
  MiniPortfolioNavbar: 'mini-portfolio-navbar',
  MiniPortfolioPage: 'mini-portfolio-page',
  MiniPortfolioTotalBalance: 'portfolio-total-balance',
  MobileWebSettingsMenu: 'mobile-web-settings-menu',
  NativeSeedPhraseInput: 'native-seed-phrase-input',
  NavCompanyDropdown: 'nav-company-dropdown',
  NavCompanyMenu: 'nav-company-menu',
  NavSearchInput: 'nav-search-input',
  NavUniswapLogo: 'nav-uniswap-logo',
  NetworkLogo: 'network-logo',
  NewUserCTAButton: 'new-user-cta-button',
  Next: 'next',
  NFTsTab: 'NFTs-tab',
  NotificationToastTitle: 'notification-toast-title',
  OK: 'ok',
  OnboardingHeaderBack: 'onboarding-header-back',
  OnboardingImportSeedPhrase: 'onboarding-import-seed-phrase',
  OnboardingPasskey: 'onboarding-passkey',
  OnboardingViewPrivateKeys: 'onboarding-view-private-keys',
  OpenDeviceLanguageSettings: 'open-device-language-settings',
  PDPLinksLoadingSkeleton: 'pdp-links-loading-skeleton',
  PoolDetailsAddLiquidityButton: 'pool-details-add-liquidity-button',
  PoolDetailsSwapButton: 'pool-details-swap-button',
  PortfolioBalance: 'portfolio-balance',
  PortfolioRelativeChange: 'portfolio-relative-change',
  PriceExplorerAnimatedNumber: 'price-explorer-animated-number',
  PriceExplorerChart: 'price-explorer-chart',
  PriceText: 'price-text',
  QRCodeModalToggle: 'qr-code-modal-toggle',
  RangeInputDecrement: 'range-input-decrement',
  RangeInputIncrement: 'range-input-increment',
  ReadMoreButton: 'read-more-button',
  RelativePriceChange: 'relative-price-change',
  Remove: 'remove',
  RestoreFromCloud: 'restore-from-cloud',
  RestoreWallet: 'restore-wallet',
  ReviewSwap: 'review-swap',
  ReviewTransfer: 'review-transfer',
  RoutePreferenceToggleOptimal: 'route-preference-toggle-Optimal',
  RoutePreferenceToggleUniswapX: 'route-preference-toggle-UniswapX',
  RoutePreferenceToggleV2: 'route-preference-toggle-v2',
  RoutePreferenceToggleV3: 'route-preference-toggle-v3',
  SearchEtherscanItem: 'search-etherscan-item',
  SearchNFTCollectionItem: 'search-nft-collection-item',
  SearchTokenItem: 'search-token-item',
  SearchTokensAndWallets: 'search-tokens-and-wallets',
  SectionHeaderPrefix: 'section-header-',
  SelectRecipient: 'select-recipient',
  SelectWalletScreenLoaded: 'select-wallet-screen-loaded',
  Send: 'send',
  SendModalHeaderLabel: 'send-modal-header-label',
  SendReview: 'send-review',
  SendReviewModal: 'send-review-modal',
  SetMaxInput: 'set-max-input',
  SetMaxOutput: 'set-max-output',
  SettingsIconWithSlippage: 'settings-icon-with-slippage',
  ShowHiddenTokens: 'show-hidden-tokens',
  Skip: 'skip',
  SmartWalletUpgradeModalEnable: 'smart-wallet-upgrade-modal-enable',
  SmartWalletUpgradeModalMaybeLater: 'smart-wallet-upgrade-modal-maybe-later',
  Submit: 'submit',
  Swap: 'swap',
  SwapFormHeader: 'swap-form-header',
  SwapSettings: 'swap-settings',
  SwitchCurrenciesButton: 'switch-currencies-button',
  TableErrorModal: 'table-error-modal',
  TestnetsToggle: 'testnets-toggle',
  TimeSelector: 'time-selector',
  ToggleUniswapXButton: 'toggle-uniswap-x-button',
  TokenDescriptionFull: 'token-description-full',
  TokenDescriptionTruncated: 'token-description-truncated',
  TokenDetailsAboutHeader: 'token-details-about-header',
  TokenDetailsActionButton: 'token-details-action-button',
  TokenDetailsBuyButton: 'token-details-buy-button',
  TokenDetailsHeaderText: 'token-details-header-text',
  TokenDetailsMobileBottomBar: 'tdp-mobile-bottom-bar',
  TokenDetailsMoreButton: 'token-details-more-button',
  TokenDetailsSellButton: 'token-details-sell-button',
  TokenDetailsSwapButton: 'token-details-swap-button',
  TokenLinkCopy: 'token-link-copy',
  TokenLinkEtherscan: 'token-link-etherscan',
  TokenLinkTwitter: 'token-link-twitter',
  TokenLinkWebsite: 'token-link-website',
  TokenLogo: 'token-logo',
  TokenSelectorToggle: 'token-selector-toggle',
  TokensTab: 'tokens-tab',
  TokenWarningAccept: 'token-warning-accept',
  UKDisclaimer: 'uk-disclaimer',
  ViewNativePrivateKey: 'view-native-private-key',
  ViewNativePrivateKeysOnCopied: 'view-native-private-keys-on-copied',
  WalletBuyCrypto: 'wallet-buy-crypto',
  WalletCard: 'wallet-card',
  WalletDisconnect: 'wallet-disconnect',
  WalletNameInput: 'wallet-name-input',
  WalletQRCode: 'wallet-qr-code',
  WalletReceiveCrypto: 'wallet-receive-crypto',
  WalletSettings: 'wallet-settings',
  WalletSettingsPrivateKeys: 'wallet-settings-private-keys',
  WalletSettingsRecoveryPhrase: 'wallet-settings-recovery-phrase',
  WatchWallet: 'watch-wallet',
  Web3StatusConnected: 'web3-status-connected',
  WCDappNetworks: 'wc-dapp-networks',
  WCDappSwitchAccount: 'wc-dapp-switch-account',
  // alphabetize additional values.
} as const

export type TestIDType = (typeof TestID)[keyof typeof TestID]

export type TestIDIterableType = `${(typeof TestID)[keyof typeof TestID]}-${number}`

export type TestIDwithSufixType = `${(typeof TestID)[keyof typeof TestID]}-${string}`
