import { Path, Svg } from 'react-native-svg'
import { createIcon } from '../factories/createIcon'

export const [EmptyNftsIcon, AnimatedEmptyNftsIcon] = createIcon({
  name: 'EmptyNftsIcon',
  getIcon: (props) => (
    <Svg width="115" height="115" viewBox="0 0 115 115" fill="none" {...props}>
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M44.73 22.3814C45.8607 18.4387 49.9738 16.1591 53.9165 17.2896L92.6724 28.4028C96.6153 29.5334 98.8957 33.6465 97.7651 37.5894L83.7534 86.4526C82.8933 89.4523 80.3066 91.4873 77.3823 91.7925C77.404 91.502 77.4155 91.2086 77.4155 90.9126V43.1675C77.4155 36.7218 72.1903 31.4966 65.7446 31.4966H42.1167L44.73 22.3814Z"
        fill={props.color || 'currentColor'}
        opacity={0.5}
      />
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M65.1719 35.7405C69.5901 35.7406 73.1719 39.3223 73.1719 43.7405V90.3392C73.1719 94.7574 69.5901 98.3391 65.1719 98.3392H26C21.5817 98.3392 18 94.7574 18 90.3392V43.7405C18 39.3223 21.5817 35.7405 26 35.7405H65.1719ZM69.1719 66.3382C67.7854 64.4576 63.6813 60.9384 58.3574 61.9056C53.0335 62.8728 45.8792 71.4431 42.5518 76.0101C41.304 73.8302 37.9771 69.8006 31.7383 70.3685C26.769 70.8209 23.281 74.3979 22.1719 76.8157V88.6976C22.1719 91.4826 24.4298 93.7405 27.2148 93.7405H64.1289C66.9139 93.7405 69.1719 91.4826 69.1719 88.6976V66.3382ZM35.6719 51.7405C31.5297 51.7405 28.1719 54.8745 28.1719 58.7405C28.1719 62.6065 31.5297 65.7405 35.6719 65.7405C39.8139 65.7404 43.1719 62.6065 43.1719 58.7405C43.1719 54.8746 39.8139 51.7406 35.6719 51.7405Z"
        fill={props.color || 'currentColor'}
      />
    </Svg>
  ),
})
