# Development

## Install Dependencies

```bash
yarn install
```

## Generate locale files

```
yarn i18n:extract
```

## Run the interface

```bash
yarn start
```

# Contributing

Thank you for your interest in contributing to the Uniswap interface! 🦄

## Finding a first issue

Start with issues with the label
[`good first issue`](https://github.com/Uniswap/uniswap-interface/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22).

## Pull requests

**Please open all pull requests against the `main` branch.**
CI checks will run against all PRs.

# Translations

Help Uniswap reach a global audience! 

Uniswap uses [Crowdin](https://crowdin.com/project/uniswap-interface) 
for managing translations. Whenever a new string is added to the project,
it gets uploaded to Crowdin for translation by [this workflow](./.github/workflows/crowdin.yaml).

Every hour, translations are synced from Crowdin in [this other workflow](./.github/workflows/crowdin-sync.yaml).

You can contribute by joining Crowdin to proofread existing translations [here](https://crowdin.com/project/uniswap-interface/invite?d=93i5n413q403t4g473p443o4c3t2g3s21343u2c3n403l4b3v2735353i4g4k4l4g453j4g4o4j4e4k4b323l4a3h463s4g453q443m4e3t2b303s2a35353l403o443v293e303k4g4n4r4g483i4g4r4j4e4o473i5n4a3t463t4o4)

Or, ask to join us as a translator in the Discord!
