import { Image } from 'react-native'
import { PlainImageProps } from 'ui/src/components/UniversalImage/types'

export function PlainImage({ uri, size, resizeMode, style, testID }: PlainImageProps): JSX.Element {
  return (
    <Image
      height={size.height}
      resizeMode={resizeMode}
      source={{ uri }}
      style={{ aspectRatio: size.aspectRatio, flex: size.aspectRatio ? 1 : undefined, ...style }}
      testID={testID}
      width={size.width}
    />
  )
}
