import { ChainId } from '@uniswap/sdk-core'
import { L2ChainInfo, getChainInfo, useSupportedChainId } from 'constants/chains'
import { Trans } from 'i18n'
import { AlertTriangle } from 'react-feather'
import styled from 'styled-components'
import { MEDIA_WIDTHS } from 'theme'
import { ExternalLink } from 'theme/components'
import { useChainId } from 'wagmi'

const BodyRow = styled.div`
  color: ${({ theme }) => theme.neutral1};
  font-size: 12px;
  font-weight: 485;
  font-size: 14px;
  line-height: 20px;
`
const CautionTriangle = styled(AlertTriangle)`
  color: ${({ theme }) => theme.deprecated_accentWarning};
`
const Link = styled(ExternalLink)`
  color: ${({ theme }) => theme.black};
  text-decoration: underline;
`
const TitleRow = styled.div`
  align-items: center;
  display: flex;
  justify-content: flex-start;
  margin-bottom: 8px;
`
const TitleText = styled.div`
  color: ${({ theme }) => theme.neutral1};
  font-weight: 535;
  font-size: 16px;
  line-height: 24px;
  margin: 0px 12px;
`
const Wrapper = styled.div`
  background-color: ${({ theme }) => theme.surface1};
  border-radius: 12px;
  border: 1px solid ${({ theme }) => theme.surface3};
  bottom: 60px;
  z-index: 2;
  display: none;
  max-width: 348px;
  padding: 16px 20px;
  position: fixed;
  right: 16px;
  @media screen and (min-width: ${MEDIA_WIDTHS.deprecated_upToMedium}px) {
    display: block;
  }
`

export function ChainConnectivityWarning() {
  const chainId = useChainId()
  const supportedChain = useSupportedChainId(chainId)
  const info = getChainInfo({ chainId: supportedChain, withFallback: true })
  const label = info.label

  return (
    <Wrapper>
      <TitleRow>
        <CautionTriangle />
        <TitleText>
          <Trans>Network warning</Trans>
        </TitleText>
      </TitleRow>
      <BodyRow>
        {chainId === ChainId.MAINNET ? (
          <Trans>You may have lost your network connection.</Trans>
        ) : (
          <Trans>{{ label }} might be down right now, or you may have lost your network connection.</Trans>
        )}{' '}
        {(info as L2ChainInfo).statusPage !== undefined && (
          <span>
            <Trans>Check network status</Trans>{' '}
            <Link href={(info as L2ChainInfo).statusPage || ''}>
              <Trans>here.</Trans>
            </Link>
          </span>
        )}
      </BodyRow>
    </Wrapper>
  )
}
