# Contributing to Uniswap Interface

👋 Thanks for your interest in contributing to Uniswap!  
This repository is the **public mirror** of Uniswap Labs' front-end interfaces, including the web app, wallet mobile app, and wallet browser extension.

## Development Workflow

Uniswap Labs maintains and develops all interfaces in a **private repository**. At the end of each development cycle:

1. A **production release** is created internally.
2. The release is then **published to this public repository**.
3. All releases are tagged and visible in the [Releases](https://github.com/Uniswap/interface/releases) tab.

Because of this private development model:

**We do not accept pull requests to this repository.**

## How You *Can* Contribute

We still welcome your ideas, feedback, and issue reports. The best ways to contribute are:

### Reporting Bugs

Open a [GitHub Issue](https://github.com/Uniswap/interface/issues/new?template=bug_report.md) and fill out the template. Be sure to include:

- Which app is affected (web, mobile, or extension)
- Platform (iOS, Android, browser version, etc.)
- App version (Production or dev)
- Steps to reproduce, screenshots, logs, etc.

### Suggesting Features or Improvements

Start a [Discussion](https://github.com/Uniswap/interface/discussions) to propose ideas, gather feedback, or brainstorm improvements.

## Repo Overview

- Review the [README](README.md) to understand the repo's general architecture.
