import { Path, Svg } from 'react-native-svg'
import { createIcon } from '../factories/createIcon'

export const [EmptyActivityIcon, AnimatedEmptyActivityIcon] = createIcon({
  name: 'EmptyActivityIcon',
  getIcon: (props) => (
    <Svg width="115" height="115" viewBox="0 0 115 115" fill="none" {...props}>
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M27.3427 63C27.3427 69.075 32.2677 73.9998 38.3427 74H63.6357L29.1367 83.8926C25.4205 84.9581 21.5441 82.8089 20.4785 79.0928L7.27241 33.0381C6.2069 29.3219 8.35603 25.4455 12.0722 24.3799L27.3427 20.001V63Z"
        fill={props.color || 'currentColor'}
        opacity={0.5}
      />
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M76.343 11C80.209 11 83.343 14.134 83.343 18V56.2314C74.734 57.3199 67.4386 62.6196 63.5813 70H38.3431C34.4771 70 31.3431 66.866 31.3431 63V18C31.3431 14.134 34.4771 11 38.3431 11H76.343ZM43.843 51C42.4623 51 41.343 52.1193 41.343 53.5C41.343 54.8807 42.4623 56 43.843 56C45.2238 56 46.343 54.8807 46.343 53.5C46.343 52.1193 45.2238 51 43.843 51ZM53.843 51C52.4623 51 51.343 52.1193 51.343 53.5C51.343 54.8807 52.4623 56 53.843 56H70.843C72.2238 56 73.343 54.8807 73.343 53.5C73.343 52.1193 72.2238 51 70.843 51H53.843ZM43.843 38C42.4623 38 41.343 39.1193 41.343 40.5C41.343 41.8807 42.4623 43 43.843 43C45.2238 43 46.343 41.8807 46.343 40.5C46.343 39.1193 45.2238 38 43.843 38ZM53.843 38C52.4623 38 51.343 39.1193 51.343 40.5C51.343 41.8807 52.4623 43 53.843 43H70.843C72.2238 43 73.343 41.8807 73.343 40.5C73.343 39.1193 72.2238 38 70.843 38H53.843ZM43.843 25C42.4623 25 41.343 26.1193 41.343 27.5C41.343 28.8807 42.4623 30 43.843 30C45.2238 30 46.343 28.8807 46.343 27.5C46.343 26.1193 45.2238 25 43.843 25ZM53.843 25C52.4623 25 51.343 26.1193 51.343 27.5C51.343 28.8807 52.4623 30 53.843 30H70.843C72.2238 30 73.343 28.8807 73.343 27.5C73.343 26.1193 72.2238 25 70.843 25H53.843Z"
        fill={props.color || 'currentColor'}
        opacity={0.5}
      />
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M86.6372 104.025C98.7875 104.025 108.637 94.1757 108.637 82.0254C108.637 69.8751 98.7875 60.0254 86.6372 60.0254C74.4869 60.0254 64.6372 69.8751 64.6372 82.0254C64.6372 94.1757 74.4869 104.025 86.6372 104.025ZM94.8866 82.0251L86.6369 73.7754L78.3872 82.0251L86.6369 90.2748L94.8866 82.0251Z"
        fill={props.color || 'currentColor'}
      />
    </Svg>
  ),
})
