import { SVGProps } from 'constants/icons/types'

const ARS_ICON = (props: SVGProps) => {
  return (
    <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
      <g clipPath="url(#clip0_2407_117)">
        <g clipPath="url(#clip1_2407_117)">
          <path d="M76.584 -7.23999H-26.584V57.24H76.584V-7.23999Z" fill="#74ACDF" />
          <path d="M76.584 14.2538H-26.584V35.7475H76.584V14.2538Z" fill="white" />
          <path
            d="M24.5923 25.1689L28.2617 33.1634C28.2617 33.1634 28.3249 33.3162 28.4268 33.2742C28.5287 33.232 28.4653 33.0792 28.4653 33.0792L25.407 24.8315M25.3193 27.942C25.2747 29.1578 26.0225 29.8265 25.9247 30.9122C25.8271 31.998 26.4234 32.6119 26.5617 33.0341C26.7001 33.4563 26.4121 33.7088 26.5362 33.7689C26.6604 33.829 26.9321 33.4954 26.8435 32.8951C26.755 32.2948 26.2993 32.1166 26.4064 30.7905C26.5134 29.4644 25.864 29.1556 26.0221 27.9459"
            fill="#F6B40E"
          />
          <path
            d="M24.5923 25.1689L28.2617 33.1634C28.2617 33.1634 28.3249 33.3162 28.4268 33.2742C28.5287 33.232 28.4653 33.0792 28.4653 33.0792L25.407 24.8315M25.3193 27.942C25.2747 29.1578 26.0225 29.8265 25.9247 30.9122C25.8271 31.998 26.4234 32.6119 26.5617 33.0341C26.7001 33.4563 26.4121 33.7088 26.5362 33.7689C26.6604 33.829 26.9321 33.4954 26.8435 32.8951C26.755 32.2948 26.2993 32.1166 26.4064 30.7905C26.5134 29.4644 25.864 29.1556 26.0221 27.9459"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M24.5588 25.0001L24.8896 33.7903C24.8896 33.7903 24.8894 33.9556 24.9997 33.9558C25.11 33.9558 25.1099 33.7904 25.1099 33.7904L25.4407 25.0001M24.1694 27.8403C23.6628 28.9465 24.0978 29.8504 23.592 30.8161C23.0863 31.7819 23.4023 32.5772 23.3685 33.0202C23.3348 33.4633 22.9721 33.5864 23.0637 33.6894C23.1555 33.7925 23.5341 33.5882 23.682 32.9997C23.8299 32.4112 23.4771 32.0722 24.0836 30.888C24.6899 29.7038 24.2081 29.1699 24.8171 28.1129"
            fill="#F6B40E"
          />
          <path
            d="M24.5588 25.0001L24.8896 33.7903C24.8896 33.7903 24.8894 33.9556 24.9997 33.9558C25.11 33.9558 25.1099 33.7904 25.1099 33.7904L25.4407 25.0001M24.1694 27.8403C23.6628 28.9465 24.0978 29.8504 23.592 30.8161C23.0863 31.7819 23.4023 32.5772 23.3685 33.0202C23.3348 33.4633 22.9721 33.5864 23.0637 33.6894C23.1555 33.7925 23.5341 33.5882 23.682 32.9997C23.8299 32.4112 23.4771 32.0722 24.0836 30.888C24.6899 29.7038 24.2081 29.1699 24.8171 28.1129"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M24.5924 24.8313L21.5341 33.0789C21.5341 33.0789 21.4707 33.2316 21.5726 33.2739C21.6744 33.3162 21.7377 33.1633 21.7377 33.1633L25.4072 25.1688M23.1457 27.3062C22.2544 28.1343 22.3104 29.136 21.4735 29.8345C20.6367 30.5333 20.6243 31.3891 20.4235 31.7854C20.2228 32.1818 19.8406 32.1567 19.8859 32.2869C19.9312 32.4173 20.3592 32.3735 20.721 31.8864C21.0829 31.3993 20.8867 30.9511 21.9001 30.0891C22.9135 29.2271 22.6727 28.5495 23.6398 27.8059"
            fill="#F6B40E"
          />
          <path
            d="M24.5924 24.8313L21.5341 33.0789C21.5341 33.0789 21.4707 33.2316 21.5726 33.2739C21.6744 33.3162 21.7377 33.1633 21.7377 33.1633L25.4072 25.1688M23.1457 27.3062C22.2544 28.1343 22.3104 29.136 21.4735 29.8345C20.6367 30.5333 20.6243 31.3891 20.4235 31.7854C20.2228 32.1818 19.8406 32.1567 19.8859 32.2869C19.9312 32.4173 20.3592 32.3735 20.721 31.8864C21.0829 31.3993 20.8867 30.9511 21.9001 30.0891C22.9135 29.2271 22.6727 28.5495 23.6398 27.8059"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M24.6882 24.6881L18.7065 31.1376C18.7065 31.1376 18.5895 31.2544 18.6674 31.3325C18.7453 31.4105 18.8622 31.2935 18.8622 31.2935L25.3118 25.3117M22.4045 26.421C21.2641 26.845 20.9325 27.7918 19.892 28.117C18.8515 28.4423 18.5126 29.2282 18.1754 29.5175C17.8383 29.807 17.4948 29.6375 17.4868 29.7751C17.4788 29.9129 17.8909 30.0363 18.4116 29.7247C18.9324 29.4132 18.9226 28.924 20.1888 28.5154C21.4549 28.1069 21.4917 27.3887 22.6698 27.0718"
            fill="#F6B40E"
          />
          <path
            d="M24.6882 24.6881L18.7065 31.1376C18.7065 31.1376 18.5895 31.2544 18.6674 31.3325C18.7453 31.4105 18.8622 31.2935 18.8622 31.2935L25.3118 25.3117M22.4045 26.421C21.2641 26.845 20.9325 27.7918 19.892 28.117C18.8515 28.4423 18.5126 29.2282 18.1754 29.5175C17.8383 29.807 17.4948 29.6375 17.4868 29.7751C17.4788 29.9129 17.8909 30.0363 18.4116 29.7247C18.9324 29.4132 18.9226 28.924 20.1888 28.5154C21.4549 28.1069 21.4917 27.3887 22.6698 27.0718"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M25.556 28.1479C25.6144 29.3155 26.2764 29.8325 26.1464 30.8966C26.4319 30.0551 25.7436 29.4028 25.7828 28.16M24.7964 25.0963L27.3094 30.5871L25.2036 24.9274"
            fill="#85340A"
          />
          <path
            d="M24.3087 28.121C23.9159 29.2221 24.3296 29.9531 23.8023 30.8864C24.388 30.2182 24.0018 29.3522 24.5136 28.219M24.7747 25.011L24.9952 31.0455L25.2156 25.0108"
            fill="#85340A"
          />
          <path
            d="M23.1671 27.6189C22.3828 28.4859 22.4853 29.3196 21.641 29.9801C22.4378 29.5869 22.4124 28.639 23.3189 27.7879M24.7878 24.9241L22.6822 30.5836L25.1952 25.0926"
            fill="#85340A"
          />
          <path
            d="M22.3046 26.7182C21.2482 27.219 21.0239 28.0284 19.9911 28.3155C20.8777 28.2572 21.217 27.3718 22.3802 26.9323M24.8332 24.8486L20.7221 29.2716L25.1451 25.1602"
            fill="#85340A"
          />
          <path
            d="M24.831 24.5925L16.8365 28.2619C16.8365 28.2619 16.6837 28.3251 16.7258 28.427C16.7679 28.5289 16.9207 28.4655 16.9207 28.4655L25.1685 25.4072M22.0579 25.3196C20.8421 25.2749 20.1734 26.0227 19.0877 25.9249C18.0019 25.8273 17.388 26.4237 16.9658 26.5619C16.5436 26.7003 16.2911 26.4123 16.231 26.5364C16.1709 26.6606 16.5045 26.9323 17.1048 26.8438C17.7051 26.7552 17.8833 26.2995 19.2094 26.4066C20.5355 26.5136 20.8444 25.8642 22.054 26.0223"
            fill="#F6B40E"
          />
          <path
            d="M24.831 24.5925L16.8365 28.2619C16.8365 28.2619 16.6837 28.3251 16.7258 28.427C16.7679 28.5289 16.9207 28.4655 16.9207 28.4655L25.1685 25.4072M22.0579 25.3196C20.8421 25.2749 20.1734 26.0227 19.0877 25.9249C18.0019 25.8273 17.388 26.4237 16.9658 26.5619C16.5436 26.7003 16.2911 26.4123 16.231 26.5364C16.1709 26.6606 16.5045 26.9323 17.1048 26.8438C17.7051 26.7552 17.8833 26.2995 19.2094 26.4066C20.5355 26.5136 20.8444 25.8642 22.054 26.0223"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M24.9997 24.5589L16.2096 24.8896C16.2096 24.8896 16.0442 24.8895 16.0441 24.9997C16.044 25.11 16.2094 25.1099 16.2094 25.1099L24.9997 25.4407M22.1596 24.1694C21.0534 23.6628 20.1494 24.0979 19.1838 23.592C18.2179 23.0863 17.4226 23.4023 16.9796 23.3685C16.5365 23.3348 16.4135 22.9721 16.3105 23.0637C16.2074 23.1555 16.4116 23.5342 17.0001 23.6821C17.5886 23.83 17.9277 23.4772 19.1118 24.0836C20.296 24.69 20.8299 24.2082 21.887 24.8171"
            fill="#F6B40E"
          />
          <path
            d="M24.9997 24.5589L16.2096 24.8896C16.2096 24.8896 16.0442 24.8895 16.0441 24.9997C16.044 25.11 16.2094 25.1099 16.2094 25.1099L24.9997 25.4407M22.1596 24.1694C21.0534 23.6628 20.1494 24.0979 19.1838 23.592C18.2179 23.0863 17.4226 23.4023 16.9796 23.3685C16.5365 23.3348 16.4135 22.9721 16.3105 23.0637C16.2074 23.1555 16.4116 23.5342 17.0001 23.6821C17.5886 23.83 17.9277 23.4772 19.1118 24.0836C20.296 24.69 20.8299 24.2082 21.887 24.8171"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M25.1686 24.5924L16.921 21.5341C16.921 21.5341 16.7682 21.4707 16.7259 21.5725C16.6837 21.6744 16.8365 21.7376 16.8365 21.7376L24.8311 25.4071M22.6937 23.1457C21.8655 22.2544 20.8639 22.3103 20.1653 21.4735C19.4666 20.6366 18.6108 20.6243 18.2145 20.4235C17.818 20.2228 17.8431 19.8406 17.7129 19.8858C17.5826 19.9312 17.6264 20.3592 18.1135 20.721C18.6006 21.0829 19.0488 20.8866 19.9108 21.9001C20.7728 22.9135 21.4504 22.6726 22.1939 23.6398"
            fill="#F6B40E"
          />
          <path
            d="M25.1686 24.5924L16.921 21.5341C16.921 21.5341 16.7682 21.4707 16.7259 21.5725C16.6837 21.6744 16.8365 21.7376 16.8365 21.7376L24.8311 25.4071M22.6937 23.1457C21.8655 22.2544 20.8639 22.3103 20.1653 21.4735C19.4666 20.6366 18.6108 20.6243 18.2145 20.4235C17.818 20.2228 17.8431 19.8406 17.7129 19.8858C17.5826 19.9312 17.6264 20.3592 18.1135 20.721C18.6006 21.0829 19.0488 20.8866 19.9108 21.9001C20.7728 22.9135 21.4504 22.6726 22.1939 23.6398"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M25.3118 24.688L18.8623 18.7062C18.8623 18.7062 18.7455 18.5892 18.6674 18.6671C18.5894 18.745 18.7064 18.862 18.7064 18.862L24.6882 25.3115M23.5789 22.4042C23.1549 21.2639 22.2081 20.9323 21.8829 19.8918C21.5576 18.8513 20.7717 18.5123 20.4824 18.1752C20.1929 17.838 20.3624 17.4945 20.2248 17.4865C20.087 17.4785 19.9637 17.8907 20.2752 18.4114C20.5867 18.9321 21.0759 18.9224 21.4845 20.1885C21.8931 21.4546 22.6113 21.4915 22.9281 22.6695"
            fill="#F6B40E"
          />
          <path
            d="M25.3118 24.688L18.8623 18.7062C18.8623 18.7062 18.7455 18.5892 18.6674 18.6671C18.5894 18.745 18.7064 18.862 18.7064 18.862L24.6882 25.3115M23.5789 22.4042C23.1549 21.2639 22.2081 20.9323 21.8829 19.8918C21.5576 18.8513 20.7717 18.5123 20.4824 18.1752C20.1929 17.838 20.3624 17.4945 20.2248 17.4865C20.087 17.4785 19.9637 17.8907 20.2752 18.4114C20.5867 18.9321 21.0759 18.9224 21.4845 20.1885C21.8931 21.4546 22.6113 21.4915 22.9281 22.6695"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M21.8522 25.5558C20.6847 25.6143 20.1676 26.2763 19.1036 26.1463C19.945 26.4317 20.5973 25.7435 21.8401 25.7826M24.9038 24.7962L19.4131 27.3093L25.0728 25.2035"
            fill="#85340A"
          />
          <path
            d="M21.879 24.3089C20.7779 23.9161 20.0469 24.3298 19.1136 23.8025C19.7818 24.3882 20.6478 24.002 21.781 24.5138M24.9889 24.7749L18.9545 24.9954L24.9892 25.2158"
            fill="#85340A"
          />
          <path
            d="M22.381 23.1671C21.514 22.3828 20.6803 22.4854 20.0198 21.641C20.413 22.4379 21.3609 22.4125 22.212 23.3189M25.0759 24.7878L19.4163 22.6823L24.9073 25.1952"
            fill="#85340A"
          />
          <path
            d="M23.2816 22.3044C22.7808 21.2481 21.9713 21.0237 21.6842 19.9909C21.7426 20.8776 22.628 21.2169 23.0675 22.38M25.1512 24.833L20.7282 20.722L24.8396 25.145"
            fill="#85340A"
          />
          <path
            d="M25.4077 24.8311L21.7383 16.8366C21.7383 16.8366 21.6751 16.6838 21.5732 16.7258C21.4713 16.768 21.5347 16.9208 21.5347 16.9208L24.593 25.1685M24.6807 22.058C24.7253 20.8422 23.9775 20.1735 24.0753 19.0878C24.1729 18.002 23.5766 17.3881 23.4383 16.9659C23.2999 16.5437 23.5879 16.2912 23.4638 16.2311C23.3396 16.171 23.0679 16.5046 23.1565 17.1049C23.245 17.7052 23.7007 17.8834 23.5936 19.2095C23.4866 20.5356 24.136 20.8444 23.9779 22.0541"
            fill="#F6B40E"
          />
          <path
            d="M25.4077 24.8311L21.7383 16.8366C21.7383 16.8366 21.6751 16.6838 21.5732 16.7258C21.4713 16.768 21.5347 16.9208 21.5347 16.9208L24.593 25.1685M24.6807 22.058C24.7253 20.8422 23.9775 20.1735 24.0753 19.0878C24.1729 18.002 23.5766 17.3881 23.4383 16.9659C23.2999 16.5437 23.5879 16.2912 23.4638 16.2311C23.3396 16.171 23.0679 16.5046 23.1565 17.1049C23.245 17.7052 23.7007 17.8834 23.5936 19.2095C23.4866 20.5356 24.136 20.8444 23.9779 22.0541"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M25.4412 24.9999L25.1104 16.2097C25.1104 16.2097 25.1106 16.0444 25.0003 16.0442C24.89 16.0442 24.8901 16.2096 24.8901 16.2096L24.5593 24.9999M25.8306 22.1597C26.3372 21.0535 25.9022 20.1496 26.408 19.1839C26.9137 18.2181 26.5977 17.4228 26.6315 16.9798C26.6652 16.5367 27.0279 16.4136 26.9363 16.3106C26.8445 16.2075 26.4659 16.4118 26.318 17.0003C26.1701 17.5888 26.5229 17.9278 25.9164 19.112C25.3101 20.2962 25.7919 20.8301 25.1829 21.8871"
            fill="#F6B40E"
          />
          <path
            d="M25.4412 24.9999L25.1104 16.2097C25.1104 16.2097 25.1106 16.0444 25.0003 16.0442C24.89 16.0442 24.8901 16.2096 24.8901 16.2096L24.5593 24.9999M25.8306 22.1597C26.3372 21.0535 25.9022 20.1496 26.408 19.1839C26.9137 18.2181 26.5977 17.4228 26.6315 16.9798C26.6652 16.5367 27.0279 16.4136 26.9363 16.3106C26.8445 16.2075 26.4659 16.4118 26.318 17.0003C26.1701 17.5888 26.5229 17.9278 25.9164 19.112C25.3101 20.2962 25.7919 20.8301 25.1829 21.8871"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M25.4076 25.1687L28.4659 16.9211C28.4659 16.9211 28.5293 16.7684 28.4274 16.7261C28.3256 16.6838 28.2623 16.8367 28.2623 16.8367L24.5928 24.8312M26.8543 22.6938C27.7456 21.8657 27.6896 20.864 28.5265 20.1655C29.3633 19.4667 29.3757 18.6109 29.5765 18.2146C29.7772 17.8182 30.1594 17.8433 30.1141 17.7131C30.0688 17.5827 29.6408 17.6265 29.279 18.1136C28.9171 18.6007 29.1133 19.0489 28.0999 19.9109C27.0865 20.7729 27.3273 21.4505 26.3602 22.1941"
            fill="#F6B40E"
          />
          <path
            d="M25.4076 25.1687L28.4659 16.9211C28.4659 16.9211 28.5293 16.7684 28.4274 16.7261C28.3256 16.6838 28.2623 16.8367 28.2623 16.8367L24.5928 24.8312M26.8543 22.6938C27.7456 21.8657 27.6896 20.864 28.5265 20.1655C29.3633 19.4667 29.3757 18.6109 29.5765 18.2146C29.7772 17.8182 30.1594 17.8433 30.1141 17.7131C30.0688 17.5827 29.6408 17.6265 29.279 18.1136C28.9171 18.6007 29.1133 19.0489 28.0999 19.9109C27.0865 20.7729 27.3273 21.4505 26.3602 22.1941"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M25.3118 25.3119L31.2935 18.8624C31.2935 18.8624 31.4105 18.7456 31.3326 18.6675C31.2547 18.5895 31.1378 18.7065 31.1378 18.7065L24.6882 24.6883M27.5955 23.579C28.7359 23.155 29.0675 22.2082 30.108 21.883C31.1485 21.5577 31.4874 20.7718 31.8246 20.4825C32.1617 20.193 32.5052 20.3625 32.5132 20.2249C32.5212 20.0871 32.1091 19.9637 31.5884 20.2753C31.0676 20.5868 31.0774 21.076 29.8112 21.4846C28.5451 21.8931 28.5083 22.6113 27.3302 22.9282"
            fill="#F6B40E"
          />
          <path
            d="M25.3118 25.3119L31.2935 18.8624C31.2935 18.8624 31.4105 18.7456 31.3326 18.6675C31.2547 18.5895 31.1378 18.7065 31.1378 18.7065L24.6882 24.6883M27.5955 23.579C28.7359 23.155 29.0675 22.2082 30.108 21.883C31.1485 21.5577 31.4874 20.7718 31.8246 20.4825C32.1617 20.193 32.5052 20.3625 32.5132 20.2249C32.5212 20.0871 32.1091 19.9637 31.5884 20.2753C31.0676 20.5868 31.0774 21.076 29.8112 21.4846C28.5451 21.8931 28.5083 22.6113 27.3302 22.9282"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M24.444 21.8521C24.3856 20.6845 23.7236 20.1675 23.8536 19.1034C23.5681 19.9449 24.2564 20.5972 24.2172 21.84M25.2036 24.9037L22.6906 19.4129L24.7964 25.0726"
            fill="#85340A"
          />
          <path
            d="M25.6913 21.879C26.0841 20.7779 25.6704 20.0469 26.1977 19.1136C25.612 19.7818 25.9982 20.6478 25.4864 21.781M25.2253 24.989L25.0048 18.9545L24.7844 24.9892"
            fill="#85340A"
          />
          <path
            d="M26.8329 22.3811C27.6172 21.5141 27.5147 20.6804 28.359 20.0199C27.5622 20.4131 27.5876 21.361 26.6811 22.2121M25.2122 25.0759L27.3178 19.4164L24.8048 24.9074"
            fill="#85340A"
          />
          <path
            d="M27.6954 23.2818C28.7518 22.781 28.9761 21.9716 30.0089 21.6845C29.1223 21.7428 28.783 22.6282 27.6198 23.0677M25.1668 25.1514L29.2779 20.7284L24.8549 24.8398"
            fill="#85340A"
          />
          <path
            d="M25.169 25.4075L33.1635 21.7381C33.1635 21.7381 33.3163 21.6749 33.2742 21.573C33.2321 21.4711 33.0793 21.5345 33.0793 21.5345L24.8315 24.5928M27.9421 24.6804C29.1579 24.7251 29.8266 23.9773 30.9123 24.0751C31.9981 24.1727 32.612 23.5763 33.0342 23.4381C33.4564 23.2997 33.7089 23.5877 33.769 23.4636C33.8291 23.3394 33.4955 23.0677 32.8952 23.1562C32.2949 23.2448 32.1167 23.7005 30.7906 23.5934C29.4645 23.4864 29.1556 24.1358 27.946 23.9777"
            fill="#F6B40E"
          />
          <path
            d="M25.169 25.4075L33.1635 21.7381C33.1635 21.7381 33.3163 21.6749 33.2742 21.573C33.2321 21.4711 33.0793 21.5345 33.0793 21.5345L24.8315 24.5928M27.9421 24.6804C29.1579 24.7251 29.8266 23.9773 30.9123 24.0751C31.9981 24.1727 32.612 23.5763 33.0342 23.4381C33.4564 23.2997 33.7089 23.5877 33.769 23.4636C33.8291 23.3394 33.4955 23.0677 32.8952 23.1562C32.2949 23.2448 32.1167 23.7005 30.7906 23.5934C29.4645 23.4864 29.1556 24.1358 27.946 23.9777"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M25.0003 25.4411L33.7904 25.1104C33.7904 25.1104 33.9558 25.1105 33.9559 25.0003C33.956 24.89 33.7906 24.8901 33.7906 24.8901L25.0003 24.5593M27.8404 25.8306C28.9466 26.3372 29.8506 25.9021 30.8162 26.408C31.7821 26.9137 32.5774 26.5977 33.0204 26.6315C33.4635 26.6652 33.5865 27.0279 33.6895 26.9363C33.7926 26.8445 33.5884 26.4658 32.9999 26.3179C32.4114 26.17 32.0723 26.5228 30.8882 25.9164C29.704 25.31 29.1701 25.7918 28.113 25.1829"
            fill="#F6B40E"
          />
          <path
            d="M25.0003 25.4411L33.7904 25.1104C33.7904 25.1104 33.9558 25.1105 33.9559 25.0003C33.956 24.89 33.7906 24.8901 33.7906 24.8901L25.0003 24.5593M27.8404 25.8306C28.9466 26.3372 29.8506 25.9021 30.8162 26.408C31.7821 26.9137 32.5774 26.5977 33.0204 26.6315C33.4635 26.6652 33.5865 27.0279 33.6895 26.9363C33.7926 26.8445 33.5884 26.4658 32.9999 26.3179C32.4114 26.17 32.0723 26.5228 30.8882 25.9164C29.704 25.31 29.1701 25.7918 28.113 25.1829"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M24.8314 25.4076L33.079 28.4659C33.079 28.4659 33.2318 28.5293 33.2741 28.4275C33.3163 28.3256 33.1635 28.2624 33.1635 28.2624L25.1689 24.5929M27.3063 26.8543C28.1345 27.7456 29.1361 27.6897 29.8347 28.5265C30.5334 29.3634 31.3892 29.3757 31.7855 29.5765C32.182 29.7772 32.1569 30.1594 32.2871 30.1142C32.4174 30.0688 32.3736 29.6408 31.8865 29.279C31.3994 28.9171 30.9512 29.1134 30.0892 28.0999C29.2272 27.0865 28.5496 27.3274 27.8061 26.3602"
            fill="#F6B40E"
          />
          <path
            d="M24.8314 25.4076L33.079 28.4659C33.079 28.4659 33.2318 28.5293 33.2741 28.4275C33.3163 28.3256 33.1635 28.2624 33.1635 28.2624L25.1689 24.5929M27.3063 26.8543C28.1345 27.7456 29.1361 27.6897 29.8347 28.5265C30.5334 29.3634 31.3892 29.3757 31.7855 29.5765C32.182 29.7772 32.1569 30.1594 32.2871 30.1142C32.4174 30.0688 32.3736 29.6408 31.8865 29.279C31.3994 28.9171 30.9512 29.1134 30.0892 28.0999C29.2272 27.0865 28.5496 27.3274 27.8061 26.3602"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M24.6882 25.312L31.1377 31.2937C31.1377 31.2937 31.2545 31.4108 31.3326 31.3329C31.4106 31.2549 31.2936 31.138 31.2936 31.138L25.3118 24.6884M26.4211 27.5957C26.8451 28.7361 27.7919 29.0677 28.1171 30.1082C28.4424 31.1487 29.2283 31.4876 29.5176 31.8248C29.8071 32.1619 29.6376 32.5054 29.7752 32.5135C29.913 32.5215 30.0363 32.1093 29.7248 31.5886C29.4133 31.0679 28.9241 31.0776 28.5155 29.8114C28.1069 28.5453 27.3887 28.5085 27.0719 27.3304"
            fill="#F6B40E"
          />
          <path
            d="M24.6882 25.312L31.1377 31.2937C31.1377 31.2937 31.2545 31.4108 31.3326 31.3329C31.4106 31.2549 31.2936 31.138 31.2936 31.138L25.3118 24.6884M26.4211 27.5957C26.8451 28.7361 27.7919 29.0677 28.1171 30.1082C28.4424 31.1487 29.2283 31.4876 29.5176 31.8248C29.8071 32.1619 29.6376 32.5054 29.7752 32.5135C29.913 32.5215 30.0363 32.1093 29.7248 31.5886C29.4133 31.0679 28.9241 31.0776 28.5155 29.8114C28.1069 28.5453 27.3887 28.5085 27.0719 27.3304"
            stroke="#85340A"
            strokeWidth="0.143352"
          />
          <path
            d="M28.1478 24.4442C29.3153 24.3857 29.8324 23.7237 30.8964 23.8537C30.055 23.5683 29.4027 24.2565 28.1599 24.2174M25.0962 25.2038L30.5869 22.6907L24.9272 24.7965"
            fill="#85340A"
          />
          <path
            d="M28.121 25.6911C29.2221 26.0839 29.9531 25.6702 30.8864 26.1975C30.2182 25.6118 29.3522 25.998 28.219 25.4862M25.0111 25.2251L31.0455 25.0046L25.0108 24.7842"
            fill="#85340A"
          />
          <path
            d="M27.619 26.8329C28.486 27.6172 29.3197 27.5146 29.9802 28.359C29.587 27.5621 28.6391 27.5875 27.788 26.6811M24.9241 25.2122L30.5837 27.3177L25.0927 24.8048"
            fill="#85340A"
          />
          <path
            d="M26.7184 27.6956C27.2192 28.7519 28.0287 28.9763 28.3158 30.0091C28.2574 29.1224 27.372 28.7831 26.9325 27.62M24.8488 25.167L29.2718 29.278L25.1604 24.855"
            fill="#85340A"
          />
          <path
            d="M24.9997 28.5823C26.9782 28.5823 28.582 26.9784 28.582 25C28.582 23.0216 26.9782 21.4178 24.9997 21.4178C23.0213 21.4178 21.4175 23.0216 21.4175 25C21.4175 26.9784 23.0213 28.5823 24.9997 28.5823Z"
            fill="#F6B40E"
            stroke="#85340A"
            strokeWidth="0.19344"
          />
          <path
            d="M26.2211 24.234C25.9765 24.234 25.7422 24.34 25.6045 24.5604C25.88 24.8084 26.4887 24.8353 26.9021 24.5322C26.723 24.3394 26.4657 24.234 26.2211 24.234ZM26.2171 24.2904C26.4551 24.2861 26.6777 24.3954 26.7087 24.504C26.4332 24.8071 25.9929 24.7808 25.7173 24.5604C25.8379 24.3675 26.0319 24.2938 26.2171 24.2904Z"
            fill="#843511"
          />
          <path
            d="M26.2677 24.0638C25.9097 24.0638 25.8269 24.1465 25.6615 24.2843C25.4961 24.422 25.4135 24.3944 25.386 24.422C25.3586 24.4497 25.386 24.5322 25.441 24.5046C25.496 24.4769 25.6065 24.422 25.7716 24.2842C25.9371 24.1463 26.1021 24.1465 26.2676 24.1465C26.7636 24.1465 27.0392 24.5597 27.0941 24.5321C27.1492 24.5045 26.8186 24.0637 26.2676 24.0637L26.2677 24.0638Z"
            fill="#85340A"
          />
          <path
            d="M27.2593 24.2288C26.6255 23.6778 25.8265 23.595 25.3855 24.0085C25.2775 24.153 25.2084 24.3075 25.18 24.4688C25.1245 24.7826 25.2226 25.1216 25.4685 25.469C25.4407 25.4689 25.3855 25.4964 25.358 25.524C25.1391 25.1057 25.0618 24.676 25.1336 24.2673C25.1524 24.1605 25.1817 24.0554 25.2199 23.9532C25.8261 23.4573 26.6527 23.4021 27.2589 24.2288L27.2593 24.2288Z"
            fill="#85340A"
          />
          <path
            d="M26.2123 24.7515C26.3493 24.7515 26.4603 24.6405 26.4603 24.5035C26.4603 24.3666 26.3493 24.2555 26.2123 24.2555C26.0754 24.2555 25.9644 24.3666 25.9644 24.5035C25.9644 24.6405 26.0754 24.7515 26.2123 24.7515Z"
            fill="#85340A"
          />
          <path
            d="M26.9292 24.6699C26.4607 25.0281 25.9923 25.0006 25.7168 24.8352C25.4412 24.6699 25.4412 24.6148 25.4962 24.6148C25.5512 24.6148 25.6063 24.6699 25.8268 24.78C26.0473 24.8904 26.3778 24.8904 26.9289 24.6699L26.9292 24.6699Z"
            fill="#85340A"
          />
          <path
            d="M24.452 25.4952C24.3342 25.5167 24.2505 25.6212 24.2505 25.741C24.2505 25.8779 24.3636 25.9869 24.5003 25.9869C24.5812 25.9869 24.6554 25.9486 24.7018 25.8821C24.7972 25.9538 24.9294 25.9614 25.0001 25.9627C25.0109 25.9629 25.025 25.9627 25.0323 25.9627C25.103 25.9614 25.2352 25.9538 25.3305 25.8821C25.377 25.9486 25.4512 25.9869 25.532 25.9869C25.6687 25.9869 25.7819 25.8779 25.7819 25.741C25.7819 25.6212 25.6982 25.5167 25.5804 25.4952C25.6465 25.5185 25.6892 25.5825 25.6892 25.6524C25.6892 25.7436 25.6155 25.8176 25.524 25.8176C25.4362 25.8176 25.3639 25.748 25.3587 25.6604C25.3318 25.7141 25.2254 25.8739 25.0162 25.8821C24.807 25.8739 24.7006 25.7141 24.6737 25.6604C24.6685 25.7479 24.5962 25.8176 24.5084 25.8176C24.4169 25.8176 24.3432 25.7436 24.3432 25.6524C24.3432 25.5825 24.3858 25.5186 24.452 25.4952Z"
            fill="#85340A"
          />
          <path
            d="M24.7216 26.229C24.4459 26.229 24.3369 26.4788 24.0889 26.6441C24.2267 26.5891 24.3351 26.4804 24.5281 26.3701C24.7211 26.2599 24.8856 26.3942 24.9956 26.3942H24.9996C25.1097 26.3942 25.2742 26.2599 25.4671 26.3701C25.6601 26.4804 25.7726 26.5891 25.9104 26.6441C25.6624 26.4788 25.5494 26.229 25.2737 26.229C25.2187 26.229 25.1097 26.2587 24.9996 26.3136H24.9956C24.8856 26.2586 24.7766 26.229 24.7216 26.229Z"
            fill="#85340A"
          />
          <path
            d="M24.6284 26.5553C24.5195 26.5601 24.3757 26.5819 24.1689 26.6439C24.6651 26.5337 24.7746 26.7003 24.9951 26.7003H24.9991C25.2196 26.7003 25.3291 26.5337 25.8253 26.6439C25.274 26.4786 25.1644 26.5875 24.9991 26.5875H24.9951C24.8918 26.5875 24.8098 26.5472 24.6284 26.5553Z"
            fill="#85340A"
          />
          <path
            d="M24.1941 26.6404C24.1621 26.6408 24.1272 26.641 24.0894 26.6444C24.6681 26.6996 24.3899 27.0313 24.9961 27.0313H25.0001C25.6063 27.0313 25.3321 26.6995 25.9109 26.6444C25.3047 26.5894 25.4963 26.9467 25.0001 26.9467H24.9961C24.5309 26.9467 24.6742 26.6344 24.1941 26.6404Z"
            fill="#85340A"
          />
          <path
            d="M25.4964 27.5354C25.4964 27.2615 25.2742 27.0393 25.0004 27.0393C24.7266 27.0393 24.5044 27.2615 24.5044 27.5354C24.5589 27.3057 24.7645 27.1434 25.0004 27.1434C25.2368 27.1434 25.442 27.3057 25.4964 27.5354Z"
            fill="#85340A"
          />
          <path
            d="M22.7729 24.2288C23.4067 23.6778 24.2057 23.595 24.6467 24.0085C24.7547 24.153 24.8238 24.3075 24.8522 24.4688C24.9077 24.7826 24.8096 25.1216 24.5638 25.469C24.5915 25.4689 24.6468 25.4964 24.6743 25.524C24.8931 25.1057 24.9705 24.676 24.8987 24.2673C24.8799 24.1605 24.8505 24.0554 24.8123 23.9532C24.2061 23.4573 23.3796 23.4021 22.7733 24.2288L22.7729 24.2288Z"
            fill="#85340A"
          />
          <path
            d="M23.7645 24.0638C24.1226 24.0638 24.2053 24.1465 24.3707 24.2843C24.5362 24.422 24.6187 24.3944 24.6462 24.422C24.6736 24.4497 24.6462 24.5322 24.5912 24.5046C24.5362 24.4769 24.4257 24.422 24.2606 24.2842C24.0952 24.1463 23.9301 24.1465 23.7646 24.1465C23.2686 24.1465 22.9931 24.5597 22.9381 24.5321C22.8831 24.5045 23.2136 24.0637 23.7646 24.0637L23.7645 24.0638Z"
            fill="#85340A"
          />
          <path
            d="M23.7474 24.234C23.5028 24.234 23.2686 24.34 23.1309 24.5604C23.4064 24.8084 24.0151 24.8353 24.4285 24.5322C24.2494 24.3394 23.992 24.234 23.7474 24.234ZM23.7434 24.2904C23.9815 24.2861 24.204 24.3954 24.2351 24.504C23.9595 24.8071 23.5192 24.7808 23.2437 24.5604C23.3643 24.3675 23.5582 24.2938 23.7434 24.2904Z"
            fill="#843511"
          />
          <path
            d="M23.7802 24.7515C23.9172 24.7515 24.0282 24.6405 24.0282 24.5035C24.0282 24.3666 23.9172 24.2555 23.7802 24.2555C23.6433 24.2555 23.5322 24.3666 23.5322 24.5035C23.5322 24.6405 23.6433 24.7515 23.7802 24.7515Z"
            fill="#85340A"
          />
          <path
            d="M23.103 24.6699C23.5715 25.0281 24.0399 25.0006 24.3155 24.8352C24.591 24.6699 24.591 24.6148 24.536 24.6148C24.481 24.6148 24.426 24.6699 24.2054 24.78C23.9849 24.8904 23.6544 24.8904 23.1033 24.6699L23.103 24.6699Z"
            fill="#85340A"
          />
        </g>
      </g>
      <defs>
        <clipPath id="clip0_2407_117">
          <path
            d="M0.5 25C0.5 11.469 11.469 0.5 25 0.5V0.5C38.531 0.5 49.5 11.469 49.5 25V25C49.5 38.531 38.531 49.5 25 49.5V49.5C11.469 49.5 0.5 38.531 0.5 25V25Z"
            fill="white"
          />
        </clipPath>
        <clipPath id="clip1_2407_117">
          <rect width="103.168" height="64.48" fill="white" transform="translate(-26.584 -7.23999)" />
        </clipPath>
      </defs>
    </svg>
  )
}

export default ARS_ICON
