export { RemoveScroll } from '@tamagui/remove-scroll'
export {
  Accordion,
  Anchor,
  AnimatePresence,
  Avatar,
  Circle,
  Image,
  Input,
  ListItem,
  Popover,
  Portal,
  ScrollView,
  Select,
  Sheet,
  Square,
  Switch,
  Tabs,
  TamaguiProvider,
  Theme,
  YGroup,
  getToken,
  getTokenValue,
  isWeb,
  styled,
  useComposedRefs,
  useIsTouchDevice,
  useMedia,
  usePropsAndStyle,
  useWindowDimensions,
} from 'tamagui'
export type {
  Adapt,
  CircleProps,
  ColorTokens,
  GetRef,
  InputProps,
  PopperProps,
  SpaceTokens,
  SwitchProps,
  TamaguiProviderProps,
  ThemeKeys,
  Tokens,
  ViewProps,
} from 'tamagui'
export { LinearGradient } from 'tamagui/linear-gradient'
export * from 'ui/src/animations'
export { AddressQRCode, QRCodeDisplay } from './components/QRCode'
export type { GradientProps } from './components/QRCode'
export { Unicon } from './components/Unicon'
export * from './components/Unicon/utils'
export * from './components/UniversalImage/UniversalImage'
export * from './components/UniversalImage/types'
export * from './components/UniversalImage/utils'
export { Button } from './components/button/Button'
export type { GeneratedIcon, IconProps } from './components/factories/createIcon'
export * from './components/input/CheckBox'
export * from './components/input/utils'
export { Flex, Inset, Separator, flexStyles, type FlexProps } from './components/layout'
export { ContextMenu } from './components/menu/ContextMenu'
export { MenuContent } from './components/menu/MenuContent'
export type { MenuContentItem } from './components/menu/types'
export { AdaptiveWebModal, WebBottomSheet } from './components/modal/AdaptiveWebModal'
export * from './components/text'
export { Tooltip } from './components/tooltip/Tooltip'
export * from './components/touchable'
export { useDeviceInsets } from './hooks/useDeviceInsets'
export { useIsDarkMode } from './hooks/useIsDarkMode'
export { useIsShortMobileDevice } from './hooks/useIsShortMobileDevice'
export { useSporeColors, type DynamicColor } from './hooks/useSporeColors'
// eslint-disable-next-line no-restricted-imports
export { ImpactFeedbackStyle } from 'expo-haptics'
export * from './utils/haptics/useHapticFeedback'

// Theme
export * from './styles/ScrollbarStyles'
export * from './theme/shadows'
export * from './utils/colors'

// Loaders
export * from './loading/FlexLoader'
export * from './loading/Loader'
export * from './loading/NftCardLoader'
export * from './loading/Shine'
export * from './loading/Skeleton'
export * from './loading/SpinningLoader'
export * from './loading/TransactionLoader'
