import type { SVGProps } from 'constants/icons/types'

const MXN_ICON = (props: SVGProps) => {
  return (
    <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
      <g clipPath="url(#clip0_2407_229)">
        <path d="M33.1636 0.5H49.5001V49.5H33.1636V0.5Z" fill="#CE1126" />
        <path d="M16.8364 0.5H33.1634V49.5H16.8364V0.5Z" fill="white" />
        <path d="M0.5 0.5H16.8365V49.5H0.5V0.5Z" fill="#006847" />
        <path
          d="M27.7373 28.7898L27.7564 29.1248L27.8904 29.0387L27.7947 28.7516L27.7373 28.7898Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M27.7273 28.7994C27.7855 28.7994 27.8326 28.7523 27.8326 28.6941C27.8326 28.636 27.7855 28.5889 27.7273 28.5889C27.6692 28.5889 27.6221 28.636 27.6221 28.6941C27.6221 28.7523 27.6692 28.7994 27.7273 28.7994Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M28.1584 29.3162L27.9 29.077L27.7852 29.1727L28.1297 29.3641L28.1584 29.3162Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M28.1294 29.4598C28.0911 29.4024 28.1007 29.3354 28.1581 29.2971C28.206 29.2588 28.273 29.2684 28.3112 29.3162C28.34 29.3641 28.3304 29.4311 28.2825 29.4693C28.2347 29.5076 28.1677 29.4981 28.1294 29.4502V29.4598ZM30.0722 25.7369L30.3306 25.9857L30.3689 25.8613L30.1296 25.6986L30.0722 25.7369Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M30.0438 25.7752C30.1019 25.7752 30.149 25.7281 30.149 25.6699C30.149 25.6118 30.1019 25.5646 30.0438 25.5646C29.9856 25.5646 29.9385 25.6118 29.9385 25.6699C29.9385 25.7281 29.9856 25.7752 30.0438 25.7752Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M30.752 25.89L30.3691 25.9953L30.3979 25.8709L30.7328 25.8326L30.752 25.89Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M30.8187 25.9379C30.8768 25.9379 30.9239 25.8908 30.9239 25.8326C30.9239 25.7745 30.8768 25.7274 30.8187 25.7274C30.7605 25.7274 30.7134 25.7745 30.7134 25.8326C30.7134 25.8908 30.7605 25.9379 30.8187 25.9379Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M29.4312 27.8232L29.1919 27.4404L29.2302 27.4308L29.5077 27.7467L29.4312 27.8232Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M29.1725 27.4787C29.2359 27.4787 29.2873 27.4273 29.2873 27.3639C29.2873 27.3004 29.2359 27.249 29.1725 27.249C29.109 27.249 29.0576 27.3004 29.0576 27.3639C29.0576 27.4273 29.109 27.4787 29.1725 27.4787Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M29.4502 27.8328L29.7564 27.8902L29.766 27.8424L29.5076 27.7467L29.4502 27.8328Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M29.8426 27.9955C29.9007 27.9955 29.9479 27.9484 29.9479 27.8902C29.9479 27.8321 29.9007 27.785 29.8426 27.785C29.7844 27.785 29.7373 27.8321 29.7373 27.8902C29.7373 27.9484 29.7844 27.9955 29.8426 27.9955Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.2918 28.675C22.2918 28.7324 22.2535 28.7707 22.2152 28.7707C22.177 28.7707 22.1387 28.7228 22.1387 28.675C22.1387 28.6271 22.177 28.5793 22.2152 28.5793C22.2535 28.5793 22.2918 28.6271 22.2918 28.675ZM22.2918 28.8473L22.3588 29.2301L22.2631 29.2014L22.2344 28.8664L22.2918 28.8473Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.3777 28.7229C22.416 28.7803 22.349 28.8664 22.2629 28.8856C22.1863 28.9143 22.0811 28.876 22.0811 28.7994C22.0811 28.7133 22.2055 28.7611 22.2342 28.7516C22.282 28.7324 22.3299 28.6559 22.3777 28.7229Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M21.7079 29.3928C21.7766 29.3928 21.8323 29.3542 21.8323 29.3067C21.8323 29.2591 21.7766 29.2205 21.7079 29.2205C21.6392 29.2205 21.5835 29.2591 21.5835 29.3067C21.5835 29.3542 21.6392 29.3928 21.7079 29.3928Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M21.9087 29.2875L22.2819 29.2684L22.2149 29.1918L21.9087 29.2301V29.2875Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M21.9375 29.2492C21.9758 29.3449 21.9758 29.4693 21.8705 29.4502C21.7653 29.4406 21.7844 29.3449 21.7748 29.3066C21.7653 29.2397 21.6983 29.1822 21.7653 29.1152C21.8227 29.0578 21.9088 29.1535 21.9375 29.2492V29.2492Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M20.7411 27.3447C20.7834 27.3447 20.8177 27.2976 20.8177 27.2395C20.8177 27.1813 20.7834 27.1342 20.7411 27.1342C20.6988 27.1342 20.6646 27.1813 20.6646 27.2395C20.6646 27.2976 20.6988 27.3447 20.7411 27.3447Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M20.7414 27.4787L20.751 27.8328L20.6553 27.7467L20.6648 27.4596L20.7414 27.4787Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M20.8846 27.3734C20.9037 27.45 20.7793 27.4979 20.6931 27.4787C20.6166 27.4692 20.5496 27.4213 20.5687 27.3447C20.5687 27.2777 20.6836 27.2873 20.7123 27.3065C20.7506 27.3352 20.8558 27.249 20.8846 27.3734V27.3734Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M20.1098 27.852C20.1785 27.852 20.2342 27.8263 20.2342 27.7945C20.2342 27.7628 20.1785 27.7371 20.1098 27.7371C20.0411 27.7371 19.9854 27.7628 19.9854 27.7945C19.9854 27.8263 20.0411 27.852 20.1098 27.852Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M20.3392 27.7945L20.6167 27.7754L20.7315 27.8711L20.3296 27.852L20.3392 27.7945Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M20.2342 27.6414C20.3107 27.6414 20.3586 27.7275 20.349 27.8137C20.349 27.9094 20.2725 27.9764 20.2055 27.9668C20.1289 27.9572 20.1385 27.8902 20.1385 27.8711L20.1863 27.7945C20.1863 27.7658 20.1672 27.6988 20.1768 27.6797C20.1768 27.651 20.1959 27.6414 20.2342 27.6414V27.6414ZM20.0045 25.4689C19.9758 25.5264 19.9088 25.5646 19.8896 25.5359C19.8609 25.5168 19.8705 25.4498 19.8992 25.4019C19.9279 25.3541 19.9758 25.3254 20.0141 25.3445C20.0428 25.3637 20.0428 25.4211 20.0141 25.4689H20.0045ZM19.6982 26.0336L19.8514 25.6603L19.8322 25.6412L19.6504 25.8996L19.6982 26.0336Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M19.832 25.6699C19.7458 25.6125 19.7363 25.5455 19.7554 25.4881C19.7841 25.4402 19.8416 25.4689 19.8416 25.4689L19.9085 25.5359C19.9277 25.5455 19.9755 25.5264 20.0042 25.5742C20.0425 25.6221 20.0234 25.6699 20.0042 25.6699C19.9763 25.685 19.9451 25.6929 19.9133 25.6929C19.8816 25.6929 19.8503 25.685 19.8224 25.6699H19.832ZM19.1716 25.6125C19.2291 25.6508 19.2673 25.7082 19.2386 25.7369C19.2195 25.7752 19.1621 25.7752 19.1046 25.7369C19.0472 25.6986 19.0185 25.6603 19.0376 25.6221C19.0568 25.5838 19.1238 25.5838 19.1716 25.6221V25.6125ZM19.3343 25.7752L19.6214 25.9474V26.091L19.3056 25.823L19.3343 25.7752Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M19.3343 25.8135C19.2673 25.8805 19.2099 25.89 19.1621 25.8613C19.1046 25.8326 19.1525 25.7752 19.1525 25.7752L19.2099 25.7178C19.229 25.689 19.2099 25.6412 19.2673 25.6221C19.3152 25.5838 19.363 25.6125 19.363 25.6412C19.3726 25.6699 19.3917 25.756 19.3343 25.8135V25.8135Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M27.804 28.809L27.7657 28.8473L27.7466 28.9143V28.809L27.7849 28.7803L27.804 28.809V28.809Z"
          fill="#AA8C30"
        />
        <path
          d="M27.8138 28.7324C27.8138 28.7324 27.7946 28.7803 27.7276 28.7803C27.6702 28.7803 27.6319 28.7515 27.6319 28.7133L27.6415 28.6271L27.6128 28.6654V28.7324L27.6606 28.7898H27.6989L27.7372 28.7994L27.7851 28.7803L27.8138 28.7611V28.742V28.7324ZM28.1392 29.3066H28.0817C27.9908 29.272 27.9041 29.227 27.8233 29.1726L28.1105 29.3641L28.1392 29.3066ZM28.321 29.3832C28.321 29.3832 28.321 29.4406 28.2636 29.4598C28.2062 29.4885 28.1679 29.4789 28.1487 29.4598C28.1364 29.4474 28.1273 29.4322 28.1223 29.4155C28.1173 29.3988 28.1165 29.3811 28.12 29.3641L28.1105 29.4119L28.1392 29.4693L28.1966 29.498H28.2444L28.2731 29.4789L28.3114 29.4406L28.3306 29.4023L28.321 29.3832V29.3832ZM30.1776 25.7465V25.823L30.1106 25.756L30.1394 25.7178L30.1776 25.7465V25.7465ZM30.1489 25.6508C30.1489 25.6986 30.0724 25.7752 30.0245 25.7465C29.9671 25.7273 29.9288 25.6699 29.9575 25.6125L29.9384 25.6412L29.948 25.7178L30.0054 25.7656H30.0628L30.1202 25.7465L30.1489 25.6891V25.6508V25.6508ZM30.9146 25.7848C30.9146 25.7848 30.905 25.756 30.9146 25.7848C30.9146 25.8326 30.8667 25.9187 30.8093 25.9092C30.7423 25.9092 30.7136 25.8517 30.7231 25.8039V25.8805L30.7519 25.9092L30.7997 25.9379H30.8476L30.905 25.8996L30.9241 25.8517V25.823L30.9146 25.7848V25.7848Z"
          fill="#AA8C30"
        />
        <path
          d="M30.6463 25.8517C30.6463 25.8517 30.6463 25.8709 30.6176 25.89C30.5854 25.9087 30.5535 25.9279 30.5219 25.9475L30.7324 25.89L30.7133 25.8326L30.6463 25.8517V25.8517ZM29.3447 27.5648L29.3256 27.6031V27.6605L29.2107 27.4691L29.249 27.45L29.3447 27.5648ZM29.2777 27.3734C29.249 27.4309 29.1629 27.4691 29.1246 27.4404C29.0768 27.4117 29.048 27.3256 29.0959 27.2873L29.0672 27.3064L29.0576 27.3639L29.0768 27.4117L29.115 27.4596L29.1533 27.4787L29.2203 27.4596L29.2682 27.4309C29.2682 27.4309 29.2969 27.3351 29.2682 27.383L29.2777 27.3734ZM29.6988 27.8232C29.6988 27.8232 29.6988 27.8424 29.6605 27.8424H29.5457L29.7371 27.8807L29.7563 27.8424L29.6988 27.8232Z"
          fill="#AA8C30"
        />
        <path
          d="M29.9479 27.8711C29.967 27.9381 29.9096 28.0051 29.833 27.9764C29.7564 27.9477 29.7373 27.8807 29.7564 27.8328L29.7373 27.8902L29.7564 27.9477L29.8043 27.986L29.8521 28.0051L29.9 27.986L29.9479 27.9381L29.9574 27.8807V27.8711H29.9479ZM22.3682 28.7229C22.3873 28.742 22.3586 28.8377 22.2725 28.8664C22.1768 28.9047 22.1385 28.8664 22.1193 28.8377L22.1002 28.7803L22.0811 28.7994L22.1002 28.8377L22.1385 28.876L22.215 28.8951L22.2725 28.8856L22.3299 28.8568L22.3586 28.8281L22.3873 28.7899V28.742L22.3777 28.7229H22.3682Z"
          fill="#AA8C30"
        />
        <path
          d="M22.2918 28.9142L22.2631 28.943L22.2439 29.0004V28.9047L22.2822 28.876L22.2918 28.9142ZM22.0047 29.2205C22.0047 29.2205 21.9951 29.2396 22.0143 29.2588L22.0908 29.2779H21.9568L21.9377 29.2301L22.0047 29.2205V29.2205ZM21.9568 29.3162C21.9574 29.3327 21.9542 29.3491 21.9473 29.3641C21.9281 29.4023 21.9186 29.4406 21.8707 29.431C21.8503 29.427 21.8318 29.4163 21.818 29.4008C21.8042 29.3853 21.7958 29.3656 21.7941 29.3449C21.7923 29.3275 21.7856 29.311 21.775 29.2971V29.3449L21.8037 29.4215L21.8611 29.4502H21.8994L21.9377 29.431L21.9568 29.3832V29.3066V29.3162ZM21.5932 29.2971C21.5932 29.2971 21.6123 29.3641 21.6889 29.3641C21.7559 29.3641 21.7846 29.3449 21.7846 29.3449V29.3736L21.7559 29.3832L21.6984 29.3928L21.641 29.3832L21.6123 29.3641L21.5932 29.3258V29.2971V29.2971ZM20.8754 27.3543V27.383C20.8658 27.4117 20.818 27.4691 20.7318 27.4691C20.6553 27.4691 20.617 27.4404 20.5979 27.4117C20.5691 27.383 20.5691 27.3447 20.5691 27.3447V27.3926L20.5979 27.4404L20.684 27.4787H20.7605L20.8371 27.4596L20.8754 27.4213V27.3543V27.3543ZM20.7414 27.5266L20.6936 27.5457C20.6833 27.5546 20.6737 27.5642 20.6648 27.5744V27.4787H20.7414V27.5361V27.5266ZM20.3777 27.7945L20.416 27.8232C20.4543 27.8424 20.6553 27.8615 20.6553 27.8615L20.3395 27.8519L20.3586 27.7945H20.3777V27.7945ZM20.349 27.7945L20.3299 27.8424C20.3107 27.8711 20.2725 27.9572 20.2055 27.9476C20.1385 27.9381 20.148 27.8902 20.148 27.8807V27.8615L20.1385 27.9094L20.1576 27.9381L20.1768 27.9572H20.2342L20.2725 27.9476L20.3107 27.9094L20.3299 27.8711L20.349 27.8232V27.7945V27.7945ZM20.1768 27.8041C20.1768 27.8041 20.1768 27.8232 20.1193 27.8232L19.9949 27.8041L20.0236 27.8328L20.0619 27.8424H20.1576L20.1768 27.8041V27.8041ZM20.0141 25.6029C20.0141 25.6029 20.0236 25.6316 19.9949 25.6508C19.9662 25.6699 19.8992 25.6891 19.8609 25.6603C19.8227 25.6412 19.7461 25.5646 19.7461 25.5646L19.7844 25.6221L19.8322 25.6699L19.9088 25.6891H19.9854L20.0141 25.6508L20.0236 25.6316V25.5933L20.0141 25.6029Z"
          fill="#AA8C30"
        />
        <path
          d="M19.7938 25.6986V25.7369L19.7843 25.8326L19.8417 25.6795L19.8226 25.6603L19.7938 25.6986V25.6986ZM19.3823 25.8135L19.3919 25.8422C19.411 25.89 19.5833 26.0432 19.5833 26.0432L19.3153 25.8326L19.344 25.7848L19.3823 25.8135V25.8135ZM19.2962 25.8326L19.2292 25.8613C19.2101 25.8613 19.1526 25.8613 19.1526 25.823V25.7752L19.1335 25.823L19.1431 25.8517L19.1813 25.8709H19.2388L19.2866 25.8517L19.2962 25.8422V25.8326ZM19.2005 25.7273H19.1431C19.0952 25.7273 19.0474 25.6699 19.0474 25.6699L19.0761 25.7273L19.1622 25.7656L19.1909 25.7273H19.2005Z"
          fill="#AA8C30"
        />
        <path
          d="M31.1154 25.0096C31.0867 25.2967 30.7996 25.4594 30.6465 25.5647C30.557 25.6318 30.4821 25.7164 30.4264 25.8135L30.3689 25.9858L30.3498 26.091V26.1293L30.3689 26.292L30.3594 26.6174L30.5604 26.4738L30.7135 26.4164H30.7518C30.7518 26.4164 30.5891 26.5695 30.5316 26.7418C30.4646 26.9236 30.3402 27.2969 30.1201 27.4117C29.9 27.5361 29.7564 27.4883 29.6799 27.5553L29.6033 27.6414L29.5076 27.7658L29.4311 27.8615L29.3641 27.919L29.3162 27.9477C29.3162 27.9859 29.3162 28.0434 29.2971 28.0817L29.2492 28.2635L29.3449 28.2252H29.4502L29.3928 28.3209C29.3832 28.3688 29.4023 28.675 29.1152 28.8568C28.8281 29.0387 28.0912 29.01 28.0912 29.01L27.9572 29.0674L27.8232 29.1631L27.7084 29.2971L27.6988 29.3258C27.6988 29.3258 27.6031 29.4406 27.5361 29.4789L27.3256 29.6225L27.4979 29.632L27.7658 29.7469C27.7658 29.7469 27.5936 29.7469 27.4787 29.7852C27.3734 29.833 26.8566 30.1201 26.6174 30.1106C26.359 30.1106 26.0049 29.7469 26.0049 29.7469L25.8518 29.632L25.5838 29.5746L25.2488 29.5555V29.5172L25.2584 29.4598L25.5455 29.4693C25.7082 29.4885 25.7561 29.5459 25.89 29.5651C25.9804 29.5776 26.0724 29.5678 26.158 29.5363L26.6078 29.1727L27.0576 29.0195L27.2299 29.0387L27.3064 29.0578L27.3734 29.077L27.2969 29.1727L27.182 29.2397L27.2395 29.2875L27.5266 29.2397L27.6223 29.2684L27.6414 29.2779L27.6797 29.1822C27.718 29.1344 27.8711 29.01 27.9477 28.9621C28.0146 28.9143 28.0338 28.9143 28.0434 28.8856C28.0721 28.8664 28.1678 28.6272 28.1678 28.6272L28.1773 28.5027L28.4932 28.2061L28.7037 27.9764L28.7994 27.718L28.7898 27.6701C28.7898 27.6701 28.8568 27.7467 28.8473 27.9094C28.8377 28.0721 28.7994 28.1199 28.7994 28.1199C28.7994 28.1199 29.01 27.9764 29.1248 27.9285C29.2205 27.8807 29.2875 27.8902 29.3162 27.8902C29.3765 27.8534 29.4287 27.8045 29.4693 27.7467C29.5363 27.651 29.5459 27.6318 29.5459 27.5936L29.5555 27.383L29.5363 26.8375L29.7277 26.4356L29.9957 26.1963L30.0436 26.1676L30.0148 26.2633V26.359C30.0148 26.359 30.1488 26.1867 30.2158 26.1484L30.2637 26.1293L30.3211 25.9762C30.3402 25.8805 30.3402 25.7369 30.3402 25.7369V25.5168L30.302 25.3445L30.1775 25.0096V24.5693L30.0818 24.4449C30.0818 24.4449 30.168 24.4354 30.2732 24.5885C30.3461 24.7053 30.3949 24.8354 30.4168 24.9713L30.6752 24.1961C30.6752 24.1961 30.7422 24.2918 30.79 24.4354L30.857 24.6938L30.9527 24.4832L30.9623 24.5598C30.9814 24.6268 31.1346 24.7225 31.1154 25.0096V25.0096ZM25.9666 29.9861C25.9666 29.9861 25.9092 29.8713 25.6699 29.7469C25.5329 29.6812 25.3882 29.633 25.2393 29.6033V29.699L25.6221 29.8617L25.8135 30.0149L25.9666 29.9861Z"
          fill="#9CA168"
        />
        <path
          d="M27.7083 29.2588C27.809 29.1566 27.9215 29.0667 28.0433 28.9908C28.1217 28.9542 28.2059 28.9316 28.2921 28.9238C28.4356 28.8951 28.4548 28.9238 28.7897 28.7324C29.1247 28.541 29.2013 28.34 29.2683 28.2826C29.3353 28.2348 29.4501 28.2156 29.4501 28.2156L29.1917 28.5219C29.0673 28.6559 28.9333 28.742 28.7419 28.8664C28.5505 28.9908 28.1677 29.0004 28.1677 29.0004C28.0481 29.0205 27.9377 29.0774 27.8519 29.1631C27.7562 29.2396 27.6987 29.3258 27.6987 29.3258C27.6987 29.3258 27.6796 29.2875 27.6987 29.2588H27.7083ZM28.6366 28.2826C28.3208 28.5697 28.2251 28.8377 28.2251 28.8377L28.6366 28.4549C28.7802 28.3209 28.9812 28.2635 29.0673 28.1678C29.163 28.0912 29.163 28.0242 29.2204 27.9764L29.3161 27.8902C29.3161 27.8902 29.1821 27.7945 28.6366 28.2826V28.2826ZM27.9763 28.943C27.9763 28.943 28.1103 28.8855 28.1677 28.7611C28.1964 28.675 28.1772 28.6559 28.2347 28.5506C28.2347 28.5506 28.5601 28.2443 28.6749 28.1103C28.8759 27.8711 28.7897 27.6701 28.7897 27.6701C28.7897 27.6701 28.8089 27.7658 28.7228 27.8807C28.6366 27.9764 28.2251 28.2635 28.1677 28.4357C28.1198 28.5984 28.1485 28.5984 28.1294 28.6941C28.072 28.8855 27.9763 28.943 27.9763 28.943ZM27.7657 29.7469C27.7657 29.7469 27.603 29.6416 27.4212 29.6512C27.0479 29.6799 26.7321 29.9 26.4929 29.9096C26.244 29.9096 26.1483 29.7947 25.9569 29.6607C25.756 29.5268 25.2583 29.5459 25.2583 29.5459V29.5555L25.2487 29.5746C25.2487 29.5746 25.5933 29.5746 25.7368 29.6129C26.0239 29.699 26.1675 29.9957 26.4929 29.967C26.9044 29.9478 27.2394 29.6894 27.4116 29.6894C27.6987 29.6894 27.7657 29.7469 27.7657 29.7469V29.7469ZM25.9187 29.5555C25.9187 29.5555 26.2058 29.6129 26.4354 29.4502C26.6556 29.2875 26.9235 29.0674 27.0671 29.0578C27.2202 29.0482 27.3733 29.0865 27.3733 29.0865C27.3733 29.0865 27.1819 28.9908 27.0384 29.0004C26.8849 28.9956 26.7329 29.0319 26.5981 29.1057C26.4546 29.1918 26.3876 29.3449 26.2345 29.4406C26.0909 29.5363 25.9187 29.565 25.9187 29.565V29.5555ZM25.8708 29.9478C25.8325 29.9478 25.7847 29.9766 25.7751 29.967C25.756 29.967 25.6794 29.8713 25.5454 29.8139C25.421 29.7469 25.2392 29.7086 25.2392 29.7086C25.2392 29.7086 25.22 29.7086 25.2583 29.7277L25.5454 29.833C25.6266 29.8754 25.6983 29.934 25.756 30.0053C25.756 30.0148 25.7942 30.0627 25.8708 30.0627C25.9378 30.0627 25.9665 30.0148 25.9665 29.9957C25.9569 29.967 25.9091 29.9478 25.8708 29.9478ZM26.0718 29.6607C26.0718 29.6607 26.1866 29.7373 26.378 29.7277C26.78 29.7277 27.0288 29.4406 27.2968 29.3449C27.5647 29.2492 27.6987 29.3258 27.6987 29.3258V29.3066C27.6115 29.246 27.5082 29.2127 27.4021 29.2109C26.9618 29.2205 26.5407 29.498 26.3589 29.5746C26.1866 29.6512 26.0718 29.6703 26.0718 29.6703V29.6607ZM30.3593 26.6269C30.2157 26.7705 30.0147 27.2203 29.9286 27.3351C29.8329 27.4596 29.7276 27.4978 29.6798 27.5457L29.4405 27.8615C29.4022 27.9189 29.3927 27.8998 29.364 27.9189C29.3353 27.9477 29.3257 27.9477 29.364 27.9381C29.4118 27.9285 29.4214 27.8998 29.4884 27.8232C29.5554 27.7467 29.5554 27.7084 29.6606 27.6127C29.7659 27.517 29.9573 27.4117 30.053 27.2969C30.1487 27.1725 30.3401 26.7226 30.455 26.6078C30.5603 26.493 30.7517 26.4164 30.7517 26.4164C30.7517 26.4164 30.5985 26.3781 30.3593 26.6269ZM29.6702 27.4787C29.6702 27.4787 29.6702 27.3926 29.7659 27.2777C29.8616 27.1629 29.8999 27.182 29.9765 27.0002C30.053 26.8279 30.0913 26.6557 30.1583 26.4738C30.2157 26.2824 30.3306 26.1102 30.3306 26.1102C30.3306 26.1102 30.2253 26.1102 30.12 26.2633C29.967 26.4678 29.8445 26.6935 29.7563 26.9332C29.6606 27.182 29.6606 27.4787 29.6606 27.4787H29.6702ZM29.5362 27.651C29.5362 27.651 29.5745 27.6223 29.5841 27.4021C29.5841 27.182 29.5745 26.8662 29.6319 26.7035C29.6989 26.5504 30.0435 26.1771 30.0435 26.1771C30.0435 26.1771 29.8999 26.2059 29.6989 26.3685C29.5075 26.5312 29.4118 26.7227 29.431 26.8758C29.431 27.0289 29.5267 27.2012 29.5267 27.3543L29.5362 27.6414V27.651ZM30.3497 26.1006L30.4646 25.7178C30.5028 25.6508 30.5028 25.6029 30.6751 25.4115C30.7708 25.3062 30.8665 25.2297 30.9144 25.0766C30.9526 24.9234 30.9526 24.4928 30.9526 24.4928C30.9526 24.4928 30.9048 24.531 30.8761 24.6076C30.8378 24.6842 30.8665 24.9617 30.7995 25.0861C30.7325 25.2201 30.589 25.5264 30.5124 25.5934C30.5124 25.5934 30.5028 25.3732 30.522 25.1531C30.5507 24.933 30.6177 24.866 30.656 24.7225C30.6942 24.5789 30.6751 24.2057 30.6751 24.2057C30.6751 24.2057 30.5507 24.3205 30.4933 24.4641C30.4358 24.6076 30.3976 24.8469 30.3976 25.0383C30.3976 25.2297 30.4454 25.3828 30.455 25.4881C30.455 25.5934 30.4646 25.6508 30.4263 25.7656C30.3784 25.8805 30.4071 25.8039 30.3784 25.9187C30.3617 25.9832 30.3425 26.0471 30.321 26.1102H30.3497V26.1006ZM30.0817 24.4545C30.0817 24.4545 30.1774 24.5789 30.1679 24.732C30.1487 24.8756 30.0913 25.0766 30.1487 25.2297C30.2062 25.3828 30.2923 25.3924 30.321 25.4881C30.3401 25.5742 30.3401 25.7465 30.3401 25.7465C30.3401 25.7465 30.388 25.4211 30.3593 25.3254C30.321 25.2297 30.3114 25.2775 30.2636 25.1818C30.2157 25.0861 30.2636 24.8277 30.2253 24.6746C30.2066 24.5859 30.1554 24.5074 30.0817 24.4545Z"
          fill="#717732"
        />
        <path
          d="M23.9854 29.967C23.9854 29.967 24.0141 29.8713 24.2246 29.7756C24.4352 29.6799 24.7414 29.5363 24.7701 29.5555C24.8084 29.5746 24.7605 29.6799 24.7605 29.6799L24.5596 29.7469L24.3969 29.8426L24.2055 29.967H23.9854Z"
          fill="#9CA168"
        />
        <path
          d="M24.5217 29.4119C24.2441 29.4215 24.1006 29.4885 24.0432 29.5076C24.0336 29.5076 23.9953 29.5268 23.957 29.5076C23.8996 29.4885 23.8422 29.4024 23.8422 29.4024L23.7848 29.3545L23.7752 29.5459L23.3924 29.2014L23.3445 29.4311L23.2967 29.5268L22.9139 29.1631L22.9234 29.4502H22.8277L22.5406 29.2588L22.4641 29.2971L22.5598 29.4598L22.2057 29.4885L22.1291 29.5459L22.0621 29.632V29.6608H22.1961C22.2248 29.6416 22.2439 29.5938 22.2535 29.6129C22.2631 29.632 22.2727 29.7086 22.3205 29.7086C22.3684 29.6895 22.5311 29.5746 22.6459 29.6225C22.7703 29.6895 22.4736 29.7756 22.5119 29.8617C22.5406 29.9574 22.7512 29.9192 22.799 29.8904C22.8564 29.8617 23.0191 29.6608 23.0861 29.7373C23.1818 29.833 22.8947 29.9287 22.9426 30.0244C23 30.1297 23.1531 30.1106 23.2297 30.0627C23.3062 30.0149 23.4881 29.7469 23.5264 29.8043C23.5934 29.9 23.3732 30.0053 23.4307 30.0914C23.4881 30.168 23.6125 30.0914 23.6891 30.0244C23.7752 29.967 23.8039 29.833 23.9187 29.766C24.024 29.7086 24.0145 29.7373 24.0527 29.7277C24.0814 29.7277 24.1676 29.6416 24.1676 29.6416L24.426 29.5363H24.56L24.627 29.5746L24.7609 29.5938L24.7705 29.4789C24.7705 29.4789 24.6174 29.4119 24.5121 29.4119H24.5217ZM22.4162 29.4119L22.4641 29.3162L22.4354 29.2684C22.4354 29.2684 22.3396 29.2205 22.2535 29.1344C22.2109 29.0835 22.1589 29.0412 22.1004 29.01C22.0452 28.9764 21.9909 28.9413 21.9377 28.9047L21.8803 28.6846L21.842 28.6272L21.7463 28.6654L21.6123 28.1965L21.5836 28.1104H21.5262L21.4209 28.3975L21.2965 28.2156L21.2678 27.8328L21.1912 27.919L21.0955 28.0147L20.9232 27.6606C20.9232 27.6606 20.9041 27.6606 20.8945 27.6893C20.8945 27.718 20.8754 27.8233 20.8945 27.8902C20.8102 27.8394 20.7302 27.7818 20.6553 27.718C20.483 27.5649 20.4352 27.4883 20.4352 27.4883L20.3586 27.2969L20.4352 27.1342L20.4734 26.9428L20.3012 27.0098L20.2725 26.5695L20.2437 26.4356L20.0428 26.7227L19.9662 26.6078V26.3207L19.9088 26.3111L19.8227 26.4643C19.8227 26.4643 19.7461 26.3016 19.7078 26.2729C19.7174 26.2059 19.727 26.0527 19.6887 25.9283C19.6408 25.7752 19.593 25.6891 19.6025 25.5647C19.6217 25.4307 19.6791 25.4211 19.6695 25.3733C19.6695 25.3063 19.5738 25.402 19.6121 25.3254C19.6408 25.2584 19.8992 25.0861 19.8514 25C19.7939 24.9043 19.5355 25.134 19.593 24.9809C19.66 24.8277 19.8992 24.8277 19.9184 24.6076C19.9184 24.4832 19.6791 24.7033 19.66 24.6268C19.6408 24.5598 19.8131 24.4258 19.8131 24.3397C19.8131 24.244 19.8418 24.244 19.7939 24.1961C19.7461 24.1483 19.6025 24.3779 19.6025 24.3779L19.4398 24.3205L19.3824 24.5502L19.3346 24.7416L19.1336 24.6268L19.1814 24.866L19.2293 25.0957L19.0283 25.0383L19.1336 25.2393L19.2771 25.3828L19.3729 25.5072L19.4303 25.5359L19.526 25.6317L19.5451 25.7465L19.593 25.89L19.6025 26.0336V26.2537L19.593 26.3303C19.5547 26.3303 19.4973 26.2729 19.4686 26.3111C19.4398 26.359 19.5834 26.4643 19.5643 26.5025C19.5355 26.5217 19.3154 26.4547 19.3059 26.5217C19.2963 26.5887 19.325 26.6844 19.4494 26.7131C19.5738 26.7418 19.8514 26.8088 19.8035 26.8662C19.7557 26.9236 19.4494 26.694 19.4686 26.8662C19.471 26.9235 19.4906 26.9787 19.5247 27.0247C19.5588 27.0708 19.6059 27.1056 19.66 27.1246C19.7461 27.1533 20.0523 27.1246 20.0428 27.1916C20.0141 27.2586 19.7844 27.1629 19.7557 27.2682C19.7365 27.3734 19.9279 27.3926 19.9662 27.3926C20.0045 27.3926 20.1289 27.3926 20.1863 27.4309L20.5117 27.7371C20.6074 27.8233 20.8084 27.9572 20.8658 27.9955C20.8084 27.9955 20.684 27.9764 20.6648 28.0242C20.6361 28.0817 21.1338 28.2539 20.9902 28.3113C20.8467 28.3688 20.7031 28.1582 20.6553 28.2826C20.617 28.407 20.751 28.5123 20.8275 28.5697C20.9041 28.608 21.3348 28.5697 21.2582 28.6654C21.1625 28.7611 20.8563 28.5984 20.8467 28.7229C20.8467 28.8377 21.0572 29.0195 21.1721 29.01C21.2773 29.01 21.4018 28.8377 21.4496 28.9334C21.4975 29.0291 21.3635 29.0674 21.4688 29.0865C21.574 29.1057 21.6506 28.9908 21.775 29.01C21.8898 29.0291 22.0812 29.1057 22.1961 29.2014C22.2681 29.273 22.3383 29.3464 22.4066 29.4215L22.4162 29.4119Z"
          fill="#9CA168"
        />
        <path
          d="M24.1097 29.9096C24.1863 29.9096 24.1958 29.9479 24.2054 29.9479C24.2054 29.9479 24.3394 29.8426 24.4638 29.7756C24.5786 29.7086 24.7509 29.6799 24.7509 29.6799H24.77C24.77 29.6799 24.5499 29.7469 24.4542 29.8139L24.215 29.9766C24.215 29.9957 24.1575 30.0244 24.081 30.0244C24.014 30.0244 23.9853 29.9861 23.9853 29.967C23.9853 29.9383 24.0331 29.9096 24.1097 29.9096V29.9096ZM24.7605 29.5842C24.7605 29.5842 24.6935 29.5842 24.6648 29.5555C24.6056 29.5154 24.5352 29.4953 24.4638 29.498C24.3489 29.5044 24.2402 29.552 24.1575 29.632C24.1575 29.632 24.1384 29.6799 24.0523 29.7277C24.081 29.7373 24.1384 29.699 24.1958 29.6512C24.28 29.5903 24.3794 29.5539 24.4829 29.5459C24.5595 29.5363 24.6074 29.5746 24.6456 29.6033C24.6839 29.632 24.7605 29.6225 24.7605 29.6225V29.5842V29.5842ZM20.8941 28.0051V27.9477C20.8941 27.9477 20.8366 27.9285 20.7314 27.852C20.607 27.785 20.339 27.5744 20.339 27.5744L20.5591 27.7754C20.6559 27.8559 20.7582 27.9294 20.8654 27.9955H20.8941V28.0051ZM23.6216 29.9383L23.7365 29.766C23.813 29.6512 23.8704 29.6129 23.88 29.6033C23.8896 29.5938 23.8513 29.5363 23.8322 29.4885C23.813 29.4502 23.813 29.4023 23.813 29.3928C23.813 29.3928 23.8417 29.4693 23.8896 29.5076L23.9853 29.5746C23.9853 29.5746 24.081 29.565 24.081 29.5459C24.081 29.5268 24.081 29.5076 24.0618 29.498C24.0427 29.498 24.0236 29.5172 23.9757 29.498C23.88 29.4502 23.8417 29.3066 23.7843 29.3066C23.7269 29.2971 23.7652 29.4598 23.7365 29.4598C23.6407 29.4598 23.5833 29.1248 23.3536 29.1152C23.2101 29.1057 23.1814 29.1344 23.1718 29.1727C23.1718 29.2014 23.3632 29.4023 23.2962 29.4311C23.2292 29.4598 23.0282 29.1152 22.8751 29.1152C22.722 29.1152 22.7124 29.1631 22.722 29.2014C22.7316 29.2301 22.8943 29.2588 22.856 29.3641C22.8177 29.4693 22.6646 29.2014 22.5306 29.2205C22.3966 29.2301 22.3775 29.2492 22.3679 29.2875C22.3679 29.3258 22.4157 29.3832 22.3966 29.3928C22.3775 29.4119 22.3009 29.4023 22.2243 29.4502C22.1574 29.498 22.0616 29.632 22.0616 29.632C22.0616 29.632 22.1478 29.498 22.2722 29.4885H22.6933L22.6072 29.4215C22.5593 29.3832 22.521 29.2971 22.521 29.2971L22.655 29.4215L22.7986 29.5172C22.7986 29.5172 22.9325 29.5172 22.9421 29.5363C22.9421 29.5555 22.9421 29.5842 22.8847 29.6416C22.8418 29.6849 22.7971 29.7264 22.7507 29.766L22.9038 29.6512L23.0187 29.5555C23.0187 29.5555 23.1144 29.5746 23.124 29.565C23.1335 29.565 23.124 29.5363 23.0665 29.4406C23.0234 29.3779 22.9819 29.3141 22.9421 29.2492C22.9421 29.2492 23.0187 29.3162 23.0952 29.4215C23.1814 29.5172 23.1622 29.5746 23.1909 29.5746L23.3058 29.5938C23.3345 29.5938 23.3345 29.632 23.2771 29.7182C23.2197 29.8043 23.1814 29.9096 23.1814 29.9096L23.3058 29.7564C23.3632 29.699 23.4015 29.6225 23.4206 29.6225H23.5355L23.4685 29.498C23.4302 29.4023 23.4206 29.2875 23.4206 29.2875C23.4206 29.2875 23.4589 29.4023 23.5163 29.4789L23.6216 29.632H23.746C23.746 29.6703 23.746 29.6895 23.6982 29.766L23.6216 29.9287V29.9383ZM21.9755 28.9813L22.0999 29.01C22.0999 29.01 21.9755 28.9334 21.9372 28.8186C21.9085 28.7229 21.9372 28.4932 21.8798 28.4932C21.832 28.4932 21.7937 28.6654 21.7458 28.6272C21.6884 28.5984 21.765 28.2922 21.698 28.1678C21.6406 28.0338 21.5066 27.9477 21.4683 27.9955C21.4396 28.0434 21.4491 28.3209 21.363 28.2635C21.2673 28.1965 21.363 27.9572 21.3439 27.852C21.3152 27.7467 21.2482 27.6605 21.2003 27.6893C21.1525 27.718 21.2195 27.9189 21.1429 27.9285C21.0568 27.9285 21.0759 27.785 21.0472 27.7658C21.0089 27.7563 20.9898 27.7945 20.9802 27.7658C20.9611 27.7371 20.9706 27.6414 20.9228 27.651C20.8845 27.651 20.8941 27.7467 20.9036 27.785L20.9611 27.9189C20.9706 27.9477 21.0376 27.9859 21.0281 28.0147C21.0281 28.0338 20.9898 28.0529 20.9515 28.0529H20.8175L20.9515 28.0816C20.9898 28.0816 21.0663 28.0721 21.0855 28.1008L21.1907 28.2635C21.1907 28.2635 21.2195 28.1965 21.229 28.0816V27.8807C21.229 27.8807 21.2577 28.0051 21.2577 28.0816L21.229 28.3113C21.229 28.3113 21.3152 28.3783 21.2865 28.407H21.0663C20.9706 28.407 20.8175 28.3783 20.8175 28.3783C20.8175 28.3783 20.9515 28.4357 21.0472 28.4549C21.1429 28.474 21.3343 28.474 21.3343 28.474L21.4683 28.6272C21.4683 28.6272 21.5353 28.5219 21.5449 28.407V28.1582L21.5831 28.3688C21.5822 28.4664 21.5661 28.5632 21.5353 28.6559C21.4935 28.6914 21.4445 28.7175 21.3917 28.7324C21.296 28.7611 21.1142 28.7803 21.1142 28.7803C21.1142 28.7803 21.2865 28.809 21.4013 28.7803C21.5257 28.7516 21.5353 28.7133 21.5736 28.7324L21.6406 28.7898L21.7363 28.8664L21.6597 28.9143L21.5449 28.9717L21.7171 28.9143L21.8032 28.8855L21.8415 28.9047L21.832 28.809L21.8032 28.675C21.8032 28.675 21.8511 28.7324 21.8607 28.7994L21.8702 28.9143C21.8702 28.9143 21.8798 28.9334 21.9659 28.9717L21.9755 28.9813ZM19.5925 26.2441C19.5925 26.2441 19.6212 26.1102 19.6212 25.957C19.6212 25.8135 19.5255 25.5838 19.4968 25.5647C19.4893 25.5492 19.4829 25.5332 19.4777 25.5168L19.5447 25.4211L19.449 25.4881L19.3532 25.4498C19.315 25.4211 19.2958 25.3828 19.2958 25.3828L19.3915 25.4307C19.4298 25.4498 19.4394 25.4402 19.4394 25.4402L19.4107 25.2967L19.2575 25.2201C19.1618 25.1627 19.0661 25.0766 19.0661 25.0766L19.2767 25.1914L19.4011 25.2201C19.4011 25.2201 19.4872 25.201 19.5255 25.1723L19.6499 25.0861C19.6499 25.0861 19.5734 25.134 19.5159 25.1436L19.4011 25.1627L19.3724 24.9809L19.2863 24.8947C19.2193 24.799 19.1714 24.6842 19.1714 24.6842C19.1714 24.6842 19.2384 24.7703 19.2958 24.8086C19.3532 24.8564 19.4011 24.9234 19.4011 24.9234L19.5255 24.8469L19.7456 24.6938L19.5351 24.7895L19.4107 24.8469V24.732C19.4298 24.6938 19.4681 24.6363 19.4681 24.6076C19.4585 24.5693 19.4298 24.5885 19.4202 24.5598L19.4585 24.3588V24.4545C19.4681 24.4832 19.4585 24.5215 19.4968 24.5215C19.5351 24.5215 19.7456 24.3205 19.7648 24.2822C19.7935 24.2439 19.8318 24.1387 19.7265 24.1865C19.6212 24.2248 19.6404 24.3109 19.5542 24.3109C19.5255 24.3109 19.4968 24.1961 19.4585 24.2152C19.4298 24.2439 19.3628 24.3109 19.3437 24.4066C19.3245 24.4832 19.3628 24.598 19.315 24.6363C19.2671 24.6746 19.2193 24.5023 19.1427 24.5215C19.047 24.5502 19.0279 24.6746 19.047 24.7129C19.0566 24.7703 19.248 25 19.1906 25.0191C19.1331 25.0479 18.98 24.8277 18.9034 24.9809C18.8077 25.1244 19.1523 25.2775 19.1906 25.3158C19.2384 25.3541 19.1906 25.3637 19.2575 25.4402C19.315 25.5168 19.4011 25.5359 19.4394 25.5838C19.4777 25.6316 19.6021 25.8709 19.6021 26.024V26.2441H19.5925ZM20.4921 27.5457C20.4921 27.5457 20.406 27.45 20.4347 27.2969C20.4634 27.1342 20.5782 26.8566 20.5304 26.8184C20.5017 26.7801 20.3773 26.9906 20.3486 26.9428C20.3199 26.8949 20.4156 26.6174 20.3677 26.5025C20.3199 26.3877 20.3103 26.3111 20.2146 26.3207C20.1189 26.3303 20.071 26.6557 20.0232 26.6078C19.9753 26.5408 20.0519 26.3973 20.0232 26.3207C19.9849 26.2441 19.9753 26.2154 19.9275 26.225C19.87 26.2346 19.8509 26.3877 19.8126 26.3877C19.7839 26.3877 19.7169 26.1963 19.6499 26.2346C19.5829 26.2537 19.8222 26.5695 19.8222 26.5695C19.8222 26.5695 19.87 26.5313 19.8892 26.4738L19.937 26.3686C19.937 26.3686 19.9562 26.4643 19.937 26.5121C19.9179 26.5504 19.9083 26.6461 19.9083 26.6461C19.9083 26.6461 19.8413 26.6652 19.7456 26.6461C19.6499 26.6365 19.5638 26.5982 19.5638 26.5982C19.5638 26.5982 19.6308 26.6365 19.7361 26.6652L19.9466 26.7227L20.0136 26.8184L20.0997 26.9236L20.1572 26.7705L20.2529 26.5025C20.2529 26.5025 20.2337 26.6939 20.205 26.7897L20.1572 27.0289C20.1572 27.0289 20.0615 27.0289 19.9562 27.0002L19.6691 26.9428L19.9562 27.0385L20.1763 27.0959L20.272 27.2299L20.3486 27.1246C20.3964 27.0576 20.4251 26.9811 20.4251 26.9811C20.4251 26.9811 20.406 27.0863 20.3773 27.1533L20.3199 27.2586L20.1859 27.2777H19.9945C20.1064 27.3132 20.222 27.3357 20.339 27.3447C20.339 27.3447 20.339 27.383 20.3868 27.45C20.4123 27.4878 20.4448 27.5203 20.4825 27.5457H20.4921Z"
          fill="#717732"
        />
        <path
          d="M24.5791 30.4264C24.5791 30.4264 24.5312 30.369 24.4643 30.3307C24.3973 30.302 24.3686 30.3115 24.3686 30.3115H24.3398L24.4068 30.1584L24.8279 29.7469L24.8949 29.3354H25.1533V29.9L25.2299 29.9287L25.7084 30.2158V30.3402L25.6318 30.369L25.5744 30.3977L25.4021 30.4168L25.0863 30.1871L24.9523 30.0531L24.7227 30.3498L24.5695 30.4264H24.5791Z"
          fill="white"
        />
        <path
          d="M24.9041 29.3354V29.4311C24.9041 29.4885 24.9041 29.8139 24.885 29.8617C24.8754 29.9096 24.6457 29.9957 24.5021 30.1106C24.3777 30.2254 24.3777 30.3115 24.3777 30.3115L24.2533 30.3498C24.1672 30.3785 24.1289 30.4264 24.1289 30.4264C24.1289 30.4264 24.1768 30.2158 24.3969 30.034C24.6074 29.8426 24.7127 29.8234 24.7318 29.7947C24.751 29.766 24.7318 29.4024 24.7318 29.3736C24.7414 29.3449 24.7701 29.3449 24.7893 29.3449H24.9137L24.9041 29.3354ZM25.4496 30.5412L25.507 30.4551L25.574 30.3977L25.4783 30.3402C25.3539 30.2924 25.2869 30.302 25.2104 30.2445C25.1483 30.1987 25.0935 30.1439 25.0477 30.0818L24.9328 30.1775L25.0668 30.3402C25.1242 30.3977 25.2678 30.4168 25.3348 30.4551L25.4496 30.5508V30.5412Z"
          fill="#016848"
        />
        <path
          d="M25.1149 29.3354L25.2585 29.3449L25.2776 29.3928C25.2776 29.4024 25.2776 29.699 25.2585 29.7947C25.2439 29.8804 25.2113 29.9619 25.1628 30.034C25.1245 30.0627 24.9331 30.2254 24.847 30.3211C24.7513 30.4072 24.6651 30.5316 24.6651 30.5316L24.6077 30.4551C24.579 30.4168 24.5503 30.4072 24.5503 30.3881C24.6134 30.2791 24.7021 30.1871 24.8087 30.1201C24.9522 30.0244 25.0862 29.9096 25.1054 29.7469C25.1341 29.5842 25.1149 29.3354 25.1149 29.3354Z"
          fill="#CD202A"
        />
        <path
          d="M25.9568 30.3594C25.9568 30.3594 25.9281 30.3307 25.8229 30.3211C25.708 30.3211 25.708 30.3402 25.708 30.3402C25.708 30.3402 25.641 30.2637 25.5549 30.2063C25.4592 30.1393 25.3826 30.1488 25.2869 30.0818C25.1912 30.0149 25.1338 29.9191 25.1338 29.9191L25.2104 29.766C25.2104 29.766 25.2965 29.8904 25.3826 29.9574C25.4783 30.0244 25.6697 30.0818 25.7367 30.1488C25.8037 30.1967 25.9568 30.3594 25.9568 30.3594Z"
          fill="#CD202A"
        />
        <path
          d="M26.9142 28.541C26.9142 28.541 26.627 28.4453 26.6558 28.3496C26.6749 28.2539 27.2874 28.0912 27.2874 28.0912L27.297 27.9285C27.297 27.9285 27.2013 27.9285 27.0577 27.9764C26.8418 28.0494 26.6157 28.0881 26.3878 28.0912C26.2347 28.0912 26.1485 28.0721 26.1007 28.0625C25.3609 28.012 24.6208 27.9673 23.8804 27.9285C23.8421 27.9301 23.8038 27.9301 23.7655 27.9285C23.4784 27.8998 23.2966 27.4691 23.2966 27.4691L23.1626 27.4883C23.1626 27.4883 23.2009 27.7084 23.1339 27.7275C22.9903 27.7658 22.0716 27.2682 22.0716 27.2682L22.0142 27.4691C22.0142 27.4691 22.5884 27.7754 22.5692 27.8807C22.5501 27.9955 22.3778 27.9859 22.3778 27.9859L22.4544 28.1199C22.4831 28.1199 23.3827 28.1678 23.4019 28.4357C23.4019 28.5506 23.1817 28.6176 23.1817 28.6176L23.2583 28.7133V28.7516C23.2583 28.7516 23.756 28.7516 23.8995 28.8377C24.0335 28.9143 24.1101 29.0291 24.2823 29.1248C24.7797 29.203 25.2857 29.2094 25.7849 29.1439C25.9858 29.0865 26.1103 28.8568 26.4452 28.7611C26.7802 28.6559 26.8855 28.6463 26.8855 28.6463L26.9142 28.541Z"
          fill="#30C2DC"
          stroke="#0872A7"
          strokeWidth="0.0382813"
        />
        <path
          d="M22.2818 28.2826C22.3717 28.2826 22.4445 28.2098 22.4445 28.1199C22.4445 28.0301 22.3717 27.9572 22.2818 27.9572C22.192 27.9572 22.1191 28.0301 22.1191 28.1199C22.1191 28.2098 22.192 28.2826 22.2818 28.2826Z"
          fill="white"
          stroke="#0872A7"
          strokeWidth="0.0765625"
        />
        <path
          d="M23.2008 27.5361C23.2906 27.5361 23.3635 27.4633 23.3635 27.3734C23.3635 27.2836 23.2906 27.2108 23.2008 27.2108C23.1109 27.2108 23.0381 27.2836 23.0381 27.3734C23.0381 27.4633 23.1109 27.5361 23.2008 27.5361Z"
          fill="white"
          stroke="#0872A7"
          strokeWidth="0.0765625"
        />
        <path
          d="M27.0289 28.7229C27.1188 28.7229 27.1916 28.65 27.1916 28.5602C27.1916 28.4703 27.1188 28.3975 27.0289 28.3975C26.9391 28.3975 26.8662 28.4703 26.8662 28.5602C26.8662 28.65 26.9391 28.7229 27.0289 28.7229Z"
          fill="white"
          stroke="#0872A7"
          strokeWidth="0.0765625"
        />
        <path
          d="M21.5643 27.1342C21.5165 27.249 21.7175 27.4787 21.861 27.5074C22.0046 27.5266 22.0907 27.4979 22.1098 27.4213C22.1385 27.3543 22.1098 27.2777 22.0811 27.2299C21.9854 27.1055 21.6218 27.0098 21.5643 27.1342V27.1342Z"
          fill="#F8C83C"
        />
        <path
          d="M22.0142 27.316C22.0142 27.2394 21.8898 27.1725 21.8228 27.1725C21.7558 27.1725 21.6601 27.1725 21.6792 27.2107C21.6888 27.249 21.8898 27.3064 21.8898 27.3256C21.8898 27.3447 21.8324 27.3734 21.8611 27.4021C21.8994 27.4309 21.9376 27.4117 21.9664 27.3926C22.0046 27.3639 22.0238 27.3543 22.0142 27.316V27.316Z"
          fill="white"
        />
        <path
          d="M23.2963 28.6941C23.325 28.7994 23.2389 28.8568 23.1336 28.9047C23.0283 28.9525 22.8082 28.9238 22.7508 28.8377C22.7125 28.742 22.8465 28.608 22.9709 28.5793C23.1049 28.5506 23.258 28.5984 23.2963 28.6941V28.6941Z"
          fill="#F8C83C"
        />
        <path
          d="M23.067 28.7611C23.1149 28.7516 23.1149 28.8186 23.1531 28.8186C23.1914 28.8186 23.2201 28.7516 23.2106 28.7133C23.201 28.6654 23.134 28.6176 23.067 28.6176C23.0096 28.6176 22.8373 28.7707 22.8565 28.809C22.8756 28.8568 22.9139 28.8473 22.9522 28.8281C22.9809 28.8186 23.0287 28.7611 23.067 28.7611Z"
          fill="white"
        />
        <path
          d="M27.2396 28.1391C27.3353 28.273 27.5076 28.1486 27.5554 28.1008C27.6033 28.0529 27.7468 27.9668 27.6894 27.8902C27.632 27.7945 27.5267 27.8041 27.4597 27.8137C27.3927 27.8137 27.2683 27.9094 27.2396 27.9572C27.2109 28.0051 27.1917 28.0816 27.2396 28.1486V28.1391Z"
          fill="#F8C83C"
        />
        <path
          d="M27.2681 28.0625C27.2681 28.0625 27.2776 27.9189 27.4116 27.9094C27.4786 27.9094 27.4882 27.9285 27.5456 27.9668C27.5935 27.9955 27.6222 27.9189 27.6222 27.9189C27.6222 27.9189 27.6222 28.0146 27.5265 28.0242C27.4403 28.0242 27.4786 27.9859 27.3829 27.9668C27.3063 27.9668 27.2681 28.0625 27.2681 28.0625Z"
          fill="white"
        />
        <path
          d="M25.1437 27.785L25.0767 27.7467H24.5981L24.8565 28.5123L25.1724 28.9525L25.2872 28.9908L25.5265 28.9812L25.5743 28.8568L25.4786 28.1295L25.1437 27.785V27.785Z"
          fill="#F9AA51"
          stroke="#953220"
          strokeWidth="0.0382813"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M24.2822 27.8328L24.2918 27.7467L24.4354 27.7371C24.4896 27.7286 24.5451 27.7319 24.598 27.7467C24.6076 27.7467 24.7895 27.9668 24.8373 28.1104C24.8947 28.2443 24.9713 28.474 25.0479 28.6176C25.1225 28.7483 25.2023 28.876 25.2871 29.0004H24.9809L24.8373 28.9525L24.3971 28.2635L24.2822 27.8328V27.8328Z"
          fill="#F9AA51"
          stroke="#953220"
          strokeWidth="0.0382813"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M24.1002 27.7371L24.2916 27.7467C24.3107 27.7563 24.5117 27.9381 24.5883 28.1486C24.6744 28.3688 24.6266 28.3975 24.7318 28.6272C24.8275 28.8473 24.9807 29.01 24.9807 29.01C24.9807 29.01 24.6744 29.01 24.5021 28.9908C24.3395 28.9621 24.282 28.9621 24.2438 28.9143C24.203 28.8772 24.158 28.8451 24.1098 28.8186H23.9375L23.9854 28.5793L23.9375 28.0529V27.7754L24.1002 27.7371V27.7371ZM25.8898 27.8807L25.6027 27.7658L25.0764 27.7371L25.1147 28.0051C25.1338 28.1391 25.2295 28.4453 25.3061 28.5984C25.4018 28.7516 25.4879 28.9334 25.5357 28.9813C25.574 29.0195 25.8803 28.8951 25.8803 28.8951L26.0812 28.8664L26.0525 28.6463L26.0238 28.5793L26.0717 27.9668L26.0334 27.8711H25.8898V27.8807Z"
          fill="#F9AA51"
          stroke="#953220"
          strokeWidth="0.0382813"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M24.0142 27.8807C24.0142 27.9477 24.0812 27.9572 24.1099 27.9477C24.1194 27.9477 24.1864 27.919 24.1864 27.8328C24.1864 27.7467 24.129 27.6701 24.0142 27.6606C23.9089 27.6606 23.8228 27.7945 23.8228 27.8902C23.8228 27.9859 23.9185 28.0338 23.9185 28.0721C23.9185 28.0721 23.8228 28.1582 23.8228 28.3113C23.8228 28.4645 23.9567 28.5793 23.9567 28.5793C23.9567 28.5793 23.8228 28.6846 23.8228 28.7899C23.8228 28.8951 23.9185 28.9717 24.0142 28.9717C24.1099 28.9717 24.2343 28.9047 24.2343 28.8281C24.2343 28.742 24.1577 28.6941 24.1003 28.6941C24.0429 28.6941 24.0142 28.7324 24.0142 28.7611V27.8807ZM25.9761 27.9285C25.9761 27.9955 25.9378 27.9955 25.8995 27.9955C25.8612 27.9955 25.8134 27.9764 25.8134 27.8902C25.8134 27.8041 25.9187 27.7658 25.9952 27.7658C26.0622 27.7658 26.1866 27.8615 26.1866 27.9764C26.1866 28.0912 26.0909 28.1678 26.0909 28.1678C26.0909 28.1678 26.1483 28.1965 26.1483 28.34C26.1483 28.4836 26.0526 28.5889 26.0526 28.5889C26.0526 28.5889 26.177 28.6367 26.177 28.7899C26.177 28.943 26.0813 28.9908 26.0048 28.9908C25.9282 28.9908 25.8038 28.943 25.8038 28.8473C25.8038 28.7516 25.8708 28.7037 25.9187 28.7037C25.9665 28.7037 26.0144 28.7611 26.0144 28.8186"
          fill="#F9AA51"
        />
        <path
          d="M25.9761 27.9285C25.9761 27.9955 25.9378 27.9955 25.8995 27.9955C25.8612 27.9955 25.8134 27.9764 25.8134 27.8902C25.8134 27.8041 25.9187 27.7658 25.9952 27.7658C26.0622 27.7658 26.1866 27.8615 26.1866 27.9764C26.1866 28.0912 26.0909 28.1678 26.0909 28.1678C26.0909 28.1678 26.1483 28.1965 26.1483 28.34C26.1483 28.4836 26.0526 28.5889 26.0526 28.5889C26.0526 28.5889 26.177 28.6367 26.177 28.7899C26.177 28.943 26.0813 28.9908 26.0048 28.9908C25.9282 28.9908 25.8038 28.943 25.8038 28.8473C25.8038 28.7516 25.8708 28.7037 25.9187 28.7037C25.9665 28.7037 26.0144 28.7611 26.0144 28.8186M24.0142 27.8807C24.0142 27.9477 24.0812 27.9572 24.1099 27.9477C24.1194 27.9477 24.1864 27.919 24.1864 27.8328C24.1864 27.7467 24.129 27.6701 24.0142 27.6606C23.9089 27.6606 23.8228 27.7945 23.8228 27.8902C23.8228 27.9859 23.9185 28.0338 23.9185 28.0721C23.9185 28.0721 23.8228 28.1582 23.8228 28.3113C23.8228 28.4645 23.9567 28.5793 23.9567 28.5793C23.9567 28.5793 23.8228 28.6846 23.8228 28.7899C23.8228 28.8951 23.9185 28.9717 24.0142 28.9717C24.1099 28.9717 24.2343 28.9047 24.2343 28.8281C24.2343 28.742 24.1577 28.6941 24.1003 28.6941C24.0429 28.6941 24.0142 28.7324 24.0142 28.7611V27.8807Z"
          stroke="#953220"
          strokeWidth="0.0382813"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M24.1963 28.7324L24.225 28.7707C24.2441 28.7994 24.2537 28.8473 24.2824 28.8664C24.3494 28.9334 24.8375 28.9525 24.9906 28.9525C25.1437 28.9525 25.584 28.9717 25.6701 28.9238C25.7658 28.8664 25.7658 28.7898 25.8137 28.7516L25.8807 28.7133L25.8232 28.7707V28.8664L25.852 28.9334C25.852 28.9334 25.852 28.9621 25.7945 28.9908C25.7371 29.0291 25.6988 29.0387 25.6223 29.0482C25.5457 29.0482 24.6078 29.0482 24.4547 29.0291C24.3016 29.0004 24.3111 29.0004 24.2633 28.9717C24.2379 28.9526 24.2153 28.9301 24.1963 28.9047L24.225 28.8377L24.1963 28.7229V28.7324ZM25.7275 27.8232L25.8041 27.8615C25.8041 27.8615 25.7371 27.8807 25.6797 28.0338C25.6223 28.1773 25.6797 28.2252 25.6318 28.2443H25.1916L25.1246 28.0721L25.7275 27.8232V27.8232Z"
          fill="#953220"
        />
        <path
          d="M27.0192 27.7658C27.0192 27.7658 26.9522 27.7371 26.9235 27.6701C26.8852 27.6223 26.8565 27.5457 26.8852 27.5361C26.9139 27.517 26.9618 27.5648 26.9618 27.6127C26.9618 27.6605 27.0192 27.7658 27.0192 27.7658V27.7658ZM27.8231 27.5457L27.8901 27.6414L27.9858 27.6892C27.9858 27.6892 27.8709 27.6892 27.8327 27.6605C27.8031 27.6251 27.7774 27.5866 27.7561 27.5457H27.8231V27.5457Z"
          fill="#231F20"
        />
        <path
          d="M28.0627 27.6127C28.0627 27.6127 27.9957 27.651 27.9382 27.6318C27.8808 27.6127 27.8425 27.5744 27.8521 27.5553C27.8808 27.5266 27.8904 27.5361 27.9191 27.5744C27.9574 27.6031 28.0627 27.6127 28.0627 27.6127V27.6127ZM28.4646 27.2682C28.4646 27.2682 28.4072 27.3256 28.3689 27.3256C28.3306 27.3256 28.2541 27.3064 28.2541 27.2873C28.2541 27.2682 28.3498 27.2586 28.3689 27.2586L28.4646 27.2682V27.2682ZM27.8617 26.4738C27.8617 26.4738 27.766 26.493 27.7373 26.5408C27.7086 26.5887 27.7181 26.6365 27.7564 26.6365C27.7947 26.6365 27.8043 26.5791 27.8043 26.5695C27.8043 26.5504 27.8617 26.4738 27.8617 26.4738ZM27.4597 26.6939C27.4597 26.6939 27.3927 26.7322 27.3736 26.7705C27.3544 26.8088 27.3449 26.8853 27.3736 26.8949C27.4214 26.8949 27.431 26.8279 27.4406 26.7992L27.4597 26.6844V26.6939Z"
          fill="#231F20"
        />
        <path
          d="M26.7416 27.1725L26.5215 27.4022C26.5215 27.4022 27.0287 27.6893 27.4211 27.6701C27.8039 27.6701 28.2441 27.3543 28.2824 27.2873C28.3016 27.2299 28.2824 26.9619 28.2346 26.8758C28.1771 26.7897 27.9092 26.5887 27.8135 26.5887C27.7178 26.5983 27.5264 26.7418 27.3637 26.8949C27.201 27.0576 27.2105 27.2012 26.9809 27.182L26.7416 27.1725V27.1725Z"
          fill="#8CBEBF"
          stroke="#04534E"
          strokeWidth="0.0382813"
        />
        <path
          d="M26.6844 27.2682C26.6844 27.2682 27.2299 27.3447 27.383 27.2107C27.5361 27.0672 27.7084 26.7992 27.8137 26.7322C27.9285 26.6748 27.9764 26.6748 27.9764 26.6748L28.0912 26.7705L28.2348 26.8758L28.273 27.1342V27.2777L28.1104 27.4117L27.7945 27.5553L27.5074 27.651L27.249 27.6414L26.7418 27.4883L26.6078 27.4021L26.5791 27.3734L26.6844 27.2682V27.2682Z"
          fill="#0C8489"
        />
        <path
          d="M27.5074 26.9523C27.5074 26.9045 27.5457 26.9141 27.584 26.9141C27.6223 26.9141 27.6701 26.9141 27.6701 26.9619C27.6701 27.0098 27.6223 27.0767 27.5744 27.0767C27.5457 27.0767 27.5074 27.0002 27.5074 26.9523ZM27.7275 27.0863C27.7275 27.048 27.7562 27.0289 27.8041 27.0289C27.8615 27.0289 27.8998 27.0863 27.8998 27.1246C27.8998 27.1629 27.8615 27.2012 27.8137 27.2012C27.7658 27.2012 27.7275 27.1342 27.7275 27.0863V27.0863ZM27.651 27.4117C27.651 27.3639 27.6893 27.3543 27.7371 27.3543C27.785 27.3543 27.8137 27.3734 27.8137 27.4213C27.8137 27.4691 27.7754 27.517 27.718 27.517C27.6797 27.517 27.651 27.4691 27.651 27.4213V27.4117ZM27.3639 27.316C27.3639 27.2586 27.4213 27.2394 27.4596 27.2394C27.5074 27.2394 27.5457 27.2873 27.5457 27.3351C27.5457 27.3926 27.5074 27.4404 27.4691 27.4404C27.4213 27.4404 27.3734 27.3734 27.3734 27.316H27.3639ZM26.9141 27.3734C26.9141 27.3442 26.9257 27.3162 26.9463 27.2956C26.9669 27.275 26.9949 27.2634 27.0241 27.2634C27.0533 27.2634 27.0813 27.275 27.1019 27.2956C27.1226 27.3162 27.1342 27.3442 27.1342 27.3734C27.1342 27.4026 27.1226 27.4306 27.1019 27.4512C27.0813 27.4719 27.0533 27.4835 27.0241 27.4835C26.9949 27.4835 26.9669 27.4719 26.9463 27.4512C26.9257 27.4306 26.9141 27.4026 26.9141 27.3734Z"
          fill="#04534E"
        />
        <path
          d="M27.7275 27.0863C27.7275 27.048 27.7754 27.0289 27.8041 27.0289C27.8424 27.0289 27.8615 27.0576 27.8615 27.0959C27.8615 27.1342 27.8424 27.1629 27.8137 27.1629C27.7754 27.1629 27.7275 27.1246 27.7275 27.0863V27.0863ZM27.651 27.4021C27.651 27.3543 27.6988 27.3351 27.7467 27.3351C27.785 27.3351 27.8232 27.3543 27.8232 27.4021C27.8232 27.45 27.785 27.4787 27.7371 27.4787C27.6893 27.4787 27.651 27.4404 27.651 27.4021V27.4021ZM27.3639 27.3064C27.3639 27.2586 27.45 27.2394 27.4787 27.2394C27.5074 27.2394 27.5074 27.2682 27.5074 27.316C27.5074 27.3639 27.4787 27.4021 27.45 27.4021C27.4117 27.4021 27.3734 27.3543 27.3734 27.3064H27.3639ZM27.5074 26.9523C27.5074 26.9045 27.5361 26.9045 27.5648 26.9045C27.5936 26.9045 27.6127 26.9141 27.6127 26.9619C27.6127 27.0002 27.5936 27.0385 27.5648 27.0385C27.5361 27.0385 27.5074 26.9906 27.5074 26.9428V26.9523ZM26.9141 27.3351C26.9141 27.2873 26.9619 27.2394 27.0193 27.2394C27.0863 27.2394 27.1533 27.2586 27.1533 27.3064C27.1533 27.3639 27.0768 27.45 27.0098 27.45C26.9428 27.45 26.9141 27.383 26.9141 27.3351Z"
          fill="#8CBEBF"
        />
        <path
          d="M27.1248 27.249C27.1248 27.249 27.0482 27.2586 27.01 27.2969C26.9717 27.3351 26.9621 27.383 26.9908 27.3926C27.01 27.4021 27.0387 27.3639 27.0387 27.3447L27.1248 27.249ZM27.4789 27.1725C27.4789 27.1725 27.4119 27.2203 27.4023 27.2682C27.4023 27.3256 27.4023 27.3447 27.4215 27.3447C27.4406 27.3447 27.4502 27.2873 27.4502 27.249C27.4406 27.2299 27.4789 27.1725 27.4789 27.1725Z"
          fill="#231F20"
        />
        <path
          d="M27.5361 27.249C27.5361 27.249 27.4978 27.249 27.4595 27.2777C27.4308 27.3065 27.4021 27.3447 27.4212 27.3447C27.4404 27.3447 27.4787 27.3352 27.4787 27.316C27.4787 27.2969 27.5361 27.249 27.5361 27.249V27.249ZM27.6126 26.8279L27.5648 26.8758C27.5457 26.8949 27.5169 26.9428 27.5457 26.9619C27.5648 26.9619 27.5839 26.9524 27.6031 26.9141C27.6222 26.8758 27.6222 26.8279 27.6222 26.8279H27.6126ZM27.8902 27.0002C27.8902 27.0002 27.8232 27.0098 27.7945 27.0481C27.7753 27.0768 27.7562 27.1055 27.7945 27.1055C27.8328 27.1055 27.8232 27.0959 27.8423 27.0672C27.8423 27.0385 27.8902 27.0002 27.8902 27.0002V27.0002ZM27.8423 27.3256C27.8423 27.3256 27.8328 27.3734 27.7849 27.3926C27.7466 27.4213 27.7371 27.4404 27.7179 27.4117C27.6988 27.3735 27.7179 27.3639 27.7466 27.3543C27.7784 27.3444 27.8103 27.3348 27.8423 27.3256V27.3256Z"
          fill="#231F20"
        />
        <path
          d="M28.2827 27.1055C28.2827 27.1055 28.3114 27.2586 28.187 27.3256C28.053 27.4021 27.6894 27.6605 27.3448 27.6318C27.0003 27.5936 26.6079 27.4021 26.6079 27.4021L26.5601 27.4309L26.6462 27.4691L26.9142 27.5744L27.2108 27.6701H27.4022L27.5649 27.6605L27.8712 27.5553L28.1296 27.4213L28.2636 27.3256L28.2923 27.2777V27.1246L28.2827 27.1055V27.1055Z"
          fill="#04534E"
        />
        <path
          d="M21.5453 25.1723C21.5453 25.1723 21.6219 25.2393 21.6219 25.2967C21.6123 25.3541 21.5932 25.3732 21.5645 25.3637C21.5453 25.3637 21.5453 25.2967 21.5453 25.268V25.1723V25.1723ZM22.1387 25.7178C22.1387 25.7178 22.11 25.8135 22.0717 25.8231C22.0334 25.8326 22.0047 25.7943 22.0047 25.7752C22.0143 25.7561 22.0525 25.7752 22.0717 25.7561L22.1291 25.7178H22.1387ZM20.8562 25.7943C20.8562 25.7943 20.885 25.8518 20.9328 25.8613C20.9902 25.8709 21.0094 25.8326 20.9998 25.8135H20.9424L20.8467 25.7943H20.8562ZM21.0859 26.2441C21.0859 26.2441 21.1338 26.3016 21.1912 26.3016C21.2127 26.3054 21.2348 26.3018 21.254 26.2914C21.2731 26.2809 21.2881 26.2643 21.2965 26.2441C21.2965 26.2346 21.2199 26.2346 21.2008 26.2537C21.1721 26.2729 21.0859 26.2441 21.0859 26.2441ZM21.4879 26.5887C21.4879 26.5887 21.5836 26.5695 21.6123 26.5408C21.6314 26.5121 21.6506 26.4643 21.6314 26.4451C21.6123 26.4068 21.5932 26.4738 21.5836 26.5025L21.4879 26.5887Z"
          fill="#231F20"
        />
        <path
          d="M22.1387 26.3111C22.1387 26.3111 22.2057 25.8422 21.8325 25.5168C21.4497 25.1914 21.2104 25.268 21.0764 25.3924C20.952 25.5072 20.8372 25.9092 21.2391 26.2537C21.6411 26.5982 22.1291 26.493 22.1291 26.493L22.1387 26.3111Z"
          fill="#8CBEBF"
          stroke="#04534E"
          strokeWidth="0.0382813"
        />
        <path
          d="M20.9805 25.8231C20.9805 25.8231 20.9805 25.5647 21.1049 25.4881C21.1669 25.4552 21.2349 25.435 21.3048 25.4287C21.3748 25.4224 21.4453 25.4302 21.5122 25.4516C21.5791 25.4731 21.641 25.5076 21.6943 25.5533C21.7476 25.599 21.7913 25.6549 21.8227 25.7178C22.0141 26.1006 22.0141 26.292 21.9662 26.4834H21.7557L21.4303 26.3494L21.1623 26.1484L20.99 25.8231H20.9805Z"
          fill="#0C8489"
        />
        <path
          d="M22.0907 26.3781C22.0907 26.3781 22.0237 26.4547 21.8897 26.4451C21.7462 26.4451 21.1241 26.2728 20.9614 25.7082V25.8326L20.971 25.8709L21.0188 25.9857L21.1528 26.1771L21.3155 26.3207L21.5261 26.4355L21.6792 26.4738L21.8706 26.5121H21.9854L22.0812 26.3781H22.0907Z"
          fill="#04534E"
        />
        <path
          d="M21.7558 26.2154C21.7558 26.1676 21.7845 26.1676 21.8228 26.1676C21.861 26.1676 21.8993 26.1484 21.8993 26.1963C21.8993 26.2441 21.8706 26.3207 21.8323 26.3207C21.7845 26.3207 21.7558 26.2633 21.7558 26.225V26.2154ZM21.7845 25.9188C21.7845 25.8805 21.8132 25.8518 21.861 25.8518C21.9089 25.8518 21.928 25.8805 21.928 25.9188C21.928 25.9475 21.8993 25.9762 21.861 25.9762C21.8228 25.9762 21.7845 25.9475 21.7845 25.9188ZM21.4974 26.2441C21.4974 26.2154 21.5356 26.1963 21.5835 26.1963C21.6218 26.1963 21.6601 26.2154 21.6601 26.2441C21.6601 26.2729 21.5835 26.3111 21.5356 26.3111C21.4878 26.3111 21.4974 26.2729 21.4974 26.2441ZM21.4687 25.89C21.4687 25.8518 21.4974 25.8613 21.5356 25.8613C21.5739 25.8613 21.6218 25.8709 21.6218 25.9188C21.6218 25.9666 21.5739 26.024 21.5261 26.024C21.4974 26.024 21.4687 25.9379 21.4687 25.89V25.89ZM21.2103 25.957C21.2103 25.9188 21.2294 25.8613 21.2772 25.8613C21.3251 25.8613 21.3729 25.9188 21.3729 25.957C21.3729 25.9857 21.3347 26.024 21.2868 26.024C21.239 26.024 21.2007 25.9857 21.2007 25.957H21.2103ZM21.2581 25.6412C21.2581 25.6029 21.2772 25.6029 21.3251 25.6029C21.3729 25.6029 21.4208 25.6221 21.4208 25.6604C21.4208 25.6986 21.3634 25.7561 21.3155 25.7561C21.2581 25.7561 21.2581 25.6795 21.2581 25.6412V25.6412ZM21.5452 25.6125C21.5452 25.5742 21.5739 25.5838 21.6218 25.5838C21.6696 25.5838 21.6983 25.6125 21.6983 25.6508C21.6983 25.6891 21.6409 25.7274 21.6026 25.7274C21.5548 25.7274 21.5452 25.6508 21.5452 25.6125V25.6125Z"
          fill="#04534E"
        />
        <path
          d="M21.2581 25.6317C21.2581 25.6029 21.2772 25.5838 21.3155 25.5838C21.3538 25.5838 21.3825 25.5838 21.3825 25.6317C21.3825 25.6699 21.3538 25.6986 21.3155 25.6986C21.2868 25.6986 21.2485 25.6699 21.2581 25.6317ZM21.2007 25.9379C21.2007 25.8996 21.2198 25.8613 21.2581 25.8613C21.2964 25.8613 21.3251 25.8613 21.3251 25.9092C21.3251 25.957 21.2964 25.9858 21.2581 25.9858C21.2198 25.9858 21.2007 25.9858 21.2007 25.9379ZM21.5356 25.6125C21.5356 25.5838 21.5644 25.5838 21.6026 25.5838C21.6409 25.5838 21.6696 25.5838 21.6696 25.6221C21.6696 25.6508 21.6313 25.6699 21.6026 25.6699C21.5644 25.6699 21.5452 25.6412 21.5452 25.6125H21.5356ZM21.4782 25.9092C21.4782 25.9475 21.5069 25.9858 21.5452 25.9858C21.5835 25.9858 21.6218 25.9475 21.6218 25.9092C21.6218 25.8709 21.5739 25.8326 21.5452 25.8326C21.4974 25.8326 21.4782 25.8709 21.4782 25.9092ZM21.794 25.8613C21.794 25.8996 21.8323 25.9379 21.8706 25.9379C21.9089 25.9379 21.9472 25.8996 21.9472 25.8613C21.9472 25.8326 21.9089 25.7943 21.8706 25.7943C21.8323 25.7943 21.794 25.8326 21.794 25.8613ZM21.4878 26.2442C21.4878 26.2154 21.5165 26.1772 21.5548 26.1772C21.5931 26.1772 21.6218 26.1963 21.6218 26.2346C21.6218 26.2633 21.5644 26.3111 21.5261 26.3111C21.4974 26.3111 21.4878 26.2729 21.4878 26.2442V26.2442ZM21.7653 26.1963C21.7653 26.158 21.794 26.1484 21.8323 26.1484C21.8706 26.1484 21.8993 26.1484 21.8993 26.1963C21.8993 26.2442 21.861 26.2729 21.8228 26.2729C21.7749 26.2729 21.7558 26.2346 21.7558 26.1963H21.7653Z"
          fill="#8CBEBF"
        />
        <path
          d="M21.8419 25.7274C21.8419 25.7274 21.8802 25.7752 21.8897 25.8231L21.8802 25.9092C21.861 25.9092 21.8419 25.8805 21.8323 25.8422V25.7178L21.8419 25.7274ZM21.5931 25.469C21.5931 25.469 21.6218 25.5072 21.6218 25.5455C21.6218 25.5838 21.6218 25.6221 21.5931 25.6221C21.5739 25.6221 21.5739 25.5838 21.5739 25.5551L21.5931 25.4594V25.469ZM21.306 25.5072C21.306 25.5072 21.3347 25.5455 21.3347 25.5838C21.3347 25.6221 21.3347 25.6604 21.3155 25.6604C21.2964 25.6604 21.2964 25.6221 21.2964 25.5934L21.306 25.4977V25.5072Z"
          fill="#231F20"
        />
        <path
          d="M21.21 25.5551L21.277 25.5934C21.3152 25.6221 21.3248 25.6508 21.3152 25.6604C21.2961 25.6795 21.2674 25.6604 21.2674 25.6412L21.21 25.5551ZM21.4301 25.8518C21.4301 25.8518 21.4779 25.8518 21.5162 25.8805C21.5449 25.9092 21.5641 25.9379 21.5449 25.957C21.5354 25.9762 21.4875 25.9379 21.4684 25.9188C21.4543 25.8972 21.4415 25.8748 21.4301 25.8518ZM21.1621 25.8518L21.2387 25.8709C21.2674 25.89 21.2674 25.9283 21.2578 25.9379C21.2482 25.9379 21.2291 25.9379 21.21 25.9092L21.1621 25.8422V25.8518ZM21.8033 26.0432L21.8129 26.1389C21.8129 26.1867 21.8225 26.2346 21.8033 26.2346C21.7842 26.2346 21.7746 26.1772 21.7746 26.1389L21.8033 26.0432Z"
          fill="#231F20"
        />
        <path
          d="M21.7271 26.1484L21.794 26.1771C21.8132 26.1963 21.8132 26.225 21.794 26.225L21.7653 26.1867L21.7271 26.1389V26.1484ZM21.4399 26.158L21.5165 26.1771C21.5356 26.1963 21.5356 26.2537 21.5356 26.2728C21.5356 26.2728 21.4974 26.2728 21.4878 26.2346C21.4769 26.2081 21.4641 26.1826 21.4495 26.158H21.4399Z"
          fill="#231F20"
        />
        <path
          d="M21.3345 25.2871C21.3345 25.2871 21.0856 25.3445 21.0474 25.5072C20.9899 25.6699 20.9899 25.8518 20.9899 25.8518L20.9517 25.6412L21.0091 25.5168L21.0761 25.3924L21.1909 25.3254L21.2866 25.2871H21.3345V25.2871ZM22.1192 26.2441C22.1192 26.2441 22.1384 26.1867 22.0714 25.9953C21.9948 25.7943 21.8417 25.5359 21.8417 25.5359L21.9565 25.6699L22.0522 25.823L22.1001 25.957L22.1384 26.0814V26.2059L22.1192 26.2537V26.2441Z"
          fill="#04534E"
        />
        <path
          d="M22.3681 25.9283C22.3681 25.9283 22.4638 25.9857 22.4638 26.024V26.0719C22.4351 26.0719 22.3968 26.0432 22.3872 26.024L22.3681 25.9283ZM22.0044 26.9141C22.0044 26.9141 22.0427 26.8375 22.1001 26.8184C22.1575 26.7801 22.1958 26.7896 22.2054 26.7992C22.2245 26.8184 22.1767 26.8662 22.1384 26.8758L22.0044 26.9141ZM22.6169 27.1533C22.6169 27.1533 22.6839 27.1246 22.7126 27.0768C22.7605 27.0385 22.7604 27.0098 22.7509 26.9906C22.7317 26.981 22.6839 27.0002 22.6552 27.0385L22.6169 27.1533ZM22.5499 27.0959C22.5499 27.0959 22.569 27.0193 22.5978 26.9906C22.6169 26.9619 22.6456 26.9523 22.6647 26.9619C22.6935 26.981 22.6743 27.0098 22.6647 27.0289L22.5499 27.0959V27.0959Z"
          fill="#231F20"
        />
        <path
          d="M23.5835 26.627C23.5835 26.627 23.2007 26.0719 22.5977 26.0432C22.1192 26.0145 21.9757 26.4451 21.9948 26.5695C22.0044 26.7035 22.1862 26.9811 22.8274 27.0194C23.4591 27.0672 23.5644 26.7322 23.5931 26.7035C23.6122 26.694 23.5835 26.627 23.5835 26.627V26.627Z"
          fill="#8CBEBF"
          stroke="#04534E"
          strokeWidth="0.0382813"
        />
        <path
          d="M23.1339 26.2441C23.1339 26.2441 23.2871 26.3686 23.3541 26.4643C23.421 26.56 23.4402 26.627 23.4019 26.6365C23.3636 26.6557 23.0191 26.3303 22.732 26.2633C22.4449 26.1963 22.2056 26.2633 22.1482 26.3973C22.0908 26.5312 22.1099 26.7322 22.2439 26.8184C22.3683 26.9045 22.9808 27.0098 22.9808 27.0098L23.2679 26.9619L23.4402 26.8662L23.4785 26.7705L23.5168 26.6365L23.5359 26.5887L23.3923 26.426L23.1339 26.2441V26.2441Z"
          fill="#0C8489"
        />
        <path
          d="M22.6456 26.3207C22.6456 26.359 22.6073 26.3781 22.569 26.3781C22.5308 26.3781 22.5021 26.359 22.5021 26.3207C22.5021 26.2824 22.5308 26.2537 22.569 26.2537C22.6073 26.2537 22.6456 26.2824 22.6456 26.3207ZM22.2915 26.4451C22.2915 26.4164 22.3298 26.4164 22.3776 26.4164C22.4255 26.4164 22.4446 26.4451 22.4446 26.4738C22.4446 26.5121 22.3776 26.5695 22.3489 26.5504C22.3011 26.5217 22.2915 26.4834 22.2915 26.4547V26.4451ZM22.6743 26.6557C22.6743 26.6078 22.703 26.5695 22.7509 26.5695C22.7987 26.5695 22.8466 26.6078 22.8466 26.6557C22.8466 26.7035 22.7796 26.7514 22.7317 26.7514C22.6839 26.7514 22.6647 26.7035 22.6647 26.6557H22.6743Z"
          fill="#04534E"
        />
        <path
          d="M22.3872 26.7418C22.3872 26.7035 22.4255 26.6939 22.4638 26.6939C22.4925 26.6939 22.5403 26.7322 22.5403 26.7705C22.5403 26.8088 22.4925 26.8375 22.4638 26.8375C22.4255 26.8375 22.3872 26.7801 22.3872 26.7418Z"
          fill="#8CBEBF"
        />
        <path
          d="M22.8945 26.8758C22.8945 26.8471 22.9137 26.8183 22.9424 26.8183C22.9807 26.8183 23.0189 26.8375 23.0189 26.8662C23.0189 26.8949 22.9902 26.9332 22.952 26.9332C22.9367 26.9332 22.9221 26.9271 22.9113 26.9164C22.9006 26.9056 22.8945 26.891 22.8945 26.8758V26.8758ZM23.1242 26.7035C23.1242 26.6652 23.1434 26.6652 23.1816 26.6652C23.2295 26.6652 23.2678 26.6939 23.2678 26.7322C23.2678 26.7705 23.2199 26.7896 23.1721 26.7896C23.1338 26.7896 23.1242 26.7418 23.1242 26.6939V26.7035Z"
          fill="#04534E"
        />
        <path
          d="M22.6171 26.292C22.6171 26.3207 22.6075 26.3398 22.5788 26.3398C22.5405 26.3398 22.5022 26.3207 22.5022 26.292C22.5022 26.2537 22.5214 26.2441 22.5501 26.2441C22.5788 26.2441 22.6171 26.2537 22.6171 26.292V26.292ZM22.4353 26.4355C22.4353 26.4738 22.3874 26.493 22.3491 26.493C22.3108 26.493 22.3013 26.4738 22.3013 26.4355C22.3013 26.4068 22.3204 26.3973 22.3587 26.3973C22.3874 26.3973 22.4353 26.3973 22.4353 26.4355ZM22.5214 26.7322C22.5214 26.7609 22.5118 26.7896 22.4735 26.7896C22.4353 26.7896 22.3874 26.7609 22.3874 26.7322C22.3874 26.7035 22.4065 26.6844 22.4353 26.6844C22.4735 26.6844 22.5214 26.7035 22.5214 26.7322ZM22.8181 26.6365C22.8181 26.6652 22.7606 26.7035 22.7224 26.7035C22.6841 26.7035 22.6745 26.6461 22.6745 26.6078C22.6745 26.5791 22.7032 26.5504 22.7415 26.5504C22.7702 26.5504 22.8181 26.5982 22.8181 26.6365V26.6365ZM23.2679 26.7322C23.2679 26.7609 23.2104 26.7609 23.1722 26.7609C23.153 26.7609 23.1243 26.7227 23.1243 26.6844C23.1243 26.6557 23.1243 26.627 23.2104 26.6365C23.2392 26.6365 23.2679 26.6939 23.2679 26.7322ZM22.9999 26.8566C22.9999 26.8949 22.9808 26.9236 22.9425 26.9236C22.9349 26.9236 22.9275 26.9221 22.9205 26.9193C22.9135 26.9164 22.9072 26.9121 22.9019 26.9068C22.8965 26.9015 22.8923 26.8952 22.8894 26.8882C22.8865 26.8812 22.8851 26.8738 22.8851 26.8662C22.8851 26.8279 22.9138 26.8184 22.9425 26.8184C22.9808 26.8184 22.9999 26.8279 22.9999 26.8662V26.8566Z"
          fill="#8CBEBF"
        />
        <path
          d="M23.0479 26.6748C23.0479 26.6748 23.1053 26.6557 23.1436 26.6652C23.201 26.6652 23.201 26.6844 23.201 26.694L23.1436 26.7131L23.0479 26.6748ZM22.7895 26.8949L22.8756 26.8566C22.9139 26.8566 22.9426 26.8566 22.933 26.8854C22.933 26.9141 22.9234 26.9141 22.8852 26.9141L22.7895 26.8949V26.8949ZM22.6172 26.5121C22.6172 26.5121 22.7225 26.56 22.7512 26.6078C22.7703 26.6461 22.7799 26.6557 22.7512 26.6652C22.732 26.6844 22.7129 26.6557 22.6937 26.6365C22.6675 26.5955 22.642 26.554 22.6172 26.5121V26.5121Z"
          fill="#231F20"
        />
        <path
          d="M22.5885 26.6557L22.7129 26.627C22.7512 26.627 22.7607 26.627 22.7607 26.6461C22.7607 26.6652 22.7607 26.6748 22.7225 26.6748L22.5885 26.6461V26.6557ZM22.3301 26.6557C22.3301 26.6557 22.4258 26.6652 22.4449 26.6939C22.4641 26.7131 22.4641 26.7322 22.4545 26.7514C22.4449 26.7609 22.4066 26.7514 22.3875 26.7418C22.3684 26.7322 22.3301 26.6557 22.3301 26.6557Z"
          fill="#231F20"
        />
        <path
          d="M22.3202 26.7801C22.3202 26.7801 22.3489 26.7322 22.3872 26.7226C22.4159 26.7131 22.4542 26.7226 22.4638 26.7226C22.4638 26.7514 22.4351 26.7705 22.4063 26.7801H22.3106H22.3202ZM22.2532 26.3973L22.3394 26.4164C22.3681 26.4451 22.3776 26.4642 22.3681 26.4738H22.3011C22.2628 26.4451 22.2437 26.3973 22.2437 26.3973H22.2532ZM22.4446 26.1676C22.4446 26.1676 22.5403 26.1963 22.5595 26.2346C22.5882 26.2728 22.5882 26.3016 22.5786 26.3111L22.5021 26.2728L22.4446 26.1676V26.1676Z"
          fill="#231F20"
        />
        <path
          d="M23.4689 26.8184C23.4689 26.8184 23.2871 26.9715 22.8756 26.9619C22.4641 26.9428 22.0812 26.7705 21.9951 26.5791L22.0334 26.6748L22.1291 26.7897L22.4162 26.9428L22.7416 27.0098L23 27.0289L23.2393 26.9906L23.4307 26.8949L23.4594 26.8471L23.4785 26.8184H23.4689ZM23.5264 26.627L23.3637 26.4356C23.2095 26.3194 23.0498 26.2108 22.8852 26.1102L23.1914 26.2442L23.3924 26.4164L23.5359 26.5695V26.6174L23.5264 26.627Z"
          fill="#04534E"
        />
        <path
          d="M23.5454 26.2441C23.5454 26.2441 23.6507 26.292 23.6698 26.3207L23.7081 26.3686C23.7081 26.3686 23.6794 26.4356 23.6603 26.4068L23.6028 26.3399C23.5813 26.3094 23.5621 26.2775 23.5454 26.2441V26.2441ZM23.8612 26.0815C23.8612 26.0815 23.9569 26.1293 23.9856 26.1772C24.0239 26.225 24.0144 26.2633 24.0048 26.2729C23.9856 26.2729 23.9187 26.2154 23.9091 26.1963C23.9091 26.1676 23.8612 26.0815 23.8612 26.0815Z"
          fill="#231F20"
        />
        <path
          d="M23.9472 26.0623C23.9472 26.0623 24.0429 26.1293 24.062 26.158C24.0812 26.1963 24.1099 26.2346 24.0812 26.2537C24.0524 26.2537 24.0046 26.2059 23.9854 26.1772L23.9567 26.0623H23.9472ZM24.4831 26.1867C24.4831 26.1867 24.5501 26.2154 24.5597 26.2824V26.3781L24.5022 26.3207V26.2729L24.4831 26.1867V26.1867ZM24.6171 26.2346C24.6171 26.2346 24.6745 26.292 24.6841 26.3303C24.6841 26.3686 24.6937 26.3973 24.6649 26.3973C24.6362 26.4068 24.6171 26.3686 24.6171 26.3399V26.2442V26.2346ZM23.6792 27.383C23.6792 27.383 23.7271 27.4022 23.7653 27.383C23.8132 27.3734 23.8419 27.3352 23.8323 27.3065C23.8323 27.2873 23.8036 27.2586 23.7749 27.2969C23.7462 27.3256 23.7558 27.3447 23.7366 27.3543L23.6792 27.383ZM24.196 27.5266C24.196 27.5266 24.263 27.517 24.3108 27.4596C24.3587 27.4117 24.3778 27.3735 24.3491 27.3639C24.3204 27.3543 24.2726 27.3639 24.263 27.4022C24.2477 27.447 24.225 27.4891 24.196 27.5266ZM24.6171 27.5361L24.7128 27.4692C24.7511 27.4309 24.7798 27.4117 24.7511 27.3734C24.7224 27.3543 24.7032 27.3734 24.6841 27.383L24.6745 27.4404C24.658 27.4739 24.6388 27.5059 24.6171 27.5361V27.5361Z"
          fill="#231F20"
        />
        <path
          d="M24.7513 27.5361C24.7513 27.5361 24.8087 27.4691 24.8183 27.4309C24.8278 27.3926 24.8374 27.3447 24.8183 27.3543C24.7896 27.3543 24.7608 27.3926 24.7513 27.4117C24.7509 27.4532 24.7509 27.4947 24.7513 27.5361V27.5361Z"
          fill="#231F20"
        />
        <path
          d="M23.4593 26.8471C23.4593 26.6557 23.7272 26.225 24.0335 26.2346C24.1579 26.2346 24.4163 26.3016 24.6077 26.3973C24.78 26.4738 24.8374 26.5504 24.9427 26.5887C25.0575 26.6078 25.2298 26.5887 25.2298 26.5887L25.6126 26.5408L25.3063 26.981L25.2106 27.0768C25.2106 27.0768 25.1149 27.2682 24.8278 27.3639C24.5694 27.4691 24.11 27.3926 23.8995 27.3447C23.6985 27.2969 23.4497 27.0959 23.4593 26.8471V26.8471Z"
          fill="#8CBEBF"
          stroke="#04534E"
          strokeWidth="0.0382813"
        />
        <path
          d="M23.4591 26.8471H23.4782C23.4782 26.8088 23.4974 26.7514 23.5261 26.6844C23.5744 26.5769 23.6426 26.4795 23.7271 26.3973C23.8228 26.3111 23.9185 26.2537 24.0237 26.2537C24.2209 26.28 24.4139 26.3314 24.5979 26.4068C24.6677 26.4341 24.7324 26.473 24.7894 26.5217C24.8758 26.591 24.9851 26.6251 25.0956 26.6174L25.2296 26.6078L25.5646 26.5695L25.2966 26.9715L25.1817 27.0672C25.0997 27.2003 24.9748 27.3015 24.8276 27.3543C24.7319 27.383 24.6171 27.4021 24.4927 27.4021C24.2726 27.4021 24.0333 27.3543 23.9089 27.3256C23.8006 27.2973 23.7016 27.2412 23.6218 27.1629C23.5784 27.1242 23.5433 27.0771 23.5187 27.0244C23.494 26.9718 23.4802 26.9147 23.4782 26.8566V26.8471H23.4399C23.4408 26.9119 23.4548 26.9758 23.4811 27.035C23.5075 27.0943 23.5455 27.1475 23.5931 27.1916C23.6785 27.2745 23.7841 27.3339 23.8993 27.3639C24.0333 27.3926 24.263 27.4404 24.4927 27.4404C24.6131 27.4417 24.7329 27.4223 24.8468 27.383C25.1243 27.2777 25.22 27.0959 25.22 27.0863L25.2009 27.0768L25.2105 27.0959L25.3253 27.0002L25.6507 26.5217L25.22 26.5695H25.0956C25.0475 26.5717 24.9994 26.5685 24.9521 26.56C24.8946 26.5504 24.8563 26.5217 24.8085 26.493C24.7606 26.4547 24.7128 26.4164 24.6171 26.3781C24.5149 26.3319 24.4093 26.2935 24.3013 26.2633C24.196 26.2346 24.1003 26.2154 24.0333 26.2154C23.9376 26.2154 23.8706 26.2441 23.794 26.292C23.6929 26.3625 23.608 26.4538 23.5452 26.56C23.4875 26.6458 23.4514 26.7443 23.4399 26.8471H23.4591V26.8471Z"
          fill="#04534E"
        />
        <path
          d="M25.3064 26.9045C25.2682 26.9332 25.2395 26.9332 25.2012 26.9332C25.1533 26.9332 24.3111 26.4164 24.0527 26.4355C23.7848 26.4547 23.5359 26.5695 23.5264 26.8375C23.5264 27.115 23.5838 27.115 23.6412 27.1916C23.6986 27.2682 24.2154 27.383 24.2154 27.383H24.5217L24.7801 27.3447L25.0002 27.2203L25.1246 27.1246L25.2107 27.0289L25.3064 26.9045V26.9045Z"
          fill="#0C8489"
        />
        <path
          d="M23.9664 26.7705C23.9664 26.8183 23.9473 26.8662 23.8898 26.8662C23.842 26.8662 23.8037 26.8375 23.8037 26.7801C23.8037 26.7322 23.8324 26.7131 23.8803 26.7131C23.9281 26.7131 23.9664 26.7131 23.9664 26.7705V26.7705ZM24.0621 26.5312C24.0621 26.493 24.1004 26.4738 24.1482 26.4738C24.1961 26.4738 24.2344 26.4834 24.2344 26.5312C24.2344 26.5791 24.1961 26.6078 24.1387 26.6078C24.0812 26.6078 24.0525 26.5791 24.0525 26.5312H24.0621ZM24.5598 26.6748C24.5598 26.6365 24.598 26.5982 24.6363 26.5982C24.6746 26.5982 24.7129 26.6365 24.7129 26.6748C24.7129 26.7131 24.6746 26.7418 24.6363 26.7418C24.6268 26.7432 24.617 26.7425 24.6077 26.7397C24.5985 26.737 24.5899 26.7323 24.5826 26.7259C24.5754 26.7195 24.5696 26.7117 24.5656 26.7028C24.5617 26.694 24.5597 26.6845 24.5598 26.6748V26.6748ZM24.6555 26.981C24.6555 26.9332 24.6937 26.8853 24.7512 26.8853C24.7895 26.8853 24.8277 26.9141 24.8277 26.9619C24.8277 27.0098 24.8086 27.0576 24.7703 27.0576C24.7225 27.0576 24.665 27.0289 24.665 26.981H24.6555ZM24.4162 27.1725C24.4162 27.1342 24.4545 27.1055 24.5023 27.1055C24.5502 27.1055 24.5789 27.1342 24.5789 27.182C24.5789 27.2203 24.5502 27.249 24.5023 27.249C24.4641 27.249 24.4162 27.2203 24.4162 27.182V27.1725ZM23.9473 27.0959C23.9473 27.0576 23.9855 27.0289 24.0238 27.0289C24.0354 27.0246 24.0479 27.0232 24.0601 27.0247C24.0724 27.0263 24.084 27.0308 24.0942 27.0378C24.1043 27.0449 24.1126 27.0543 24.1183 27.0652C24.124 27.0762 24.127 27.0883 24.127 27.1007C24.127 27.113 24.124 27.1252 24.1183 27.1361C24.1126 27.1471 24.1043 27.1565 24.0942 27.1635C24.084 27.1706 24.0724 27.1751 24.0601 27.1766C24.0479 27.1782 24.0354 27.1767 24.0238 27.1725C24.0035 27.1725 23.984 27.1644 23.9697 27.15C23.9553 27.1357 23.9473 27.1162 23.9473 27.0959V27.0959Z"
          fill="#04534E"
        />
        <path
          d="M23.9664 26.7609C23.9664 26.7992 23.9281 26.8375 23.8803 26.8375C23.86 26.8375 23.8405 26.8294 23.8261 26.8151C23.8118 26.8007 23.8037 26.7813 23.8037 26.7609C23.8037 26.7131 23.842 26.7035 23.8803 26.7035C23.9281 26.7035 23.9664 26.7131 23.9664 26.7514V26.7609ZM24.2057 26.5217C24.2057 26.56 24.1961 26.5887 24.1578 26.5887C24.11 26.5887 24.0621 26.56 24.0621 26.5121C24.0621 26.4738 24.0908 26.4451 24.1291 26.4451C24.177 26.4451 24.2057 26.4738 24.2057 26.5217ZM24.7033 26.6461C24.7033 26.6844 24.665 26.7131 24.6268 26.7131C24.5885 26.7131 24.5598 26.6844 24.5598 26.6461C24.5598 26.6174 24.5885 26.5887 24.6268 26.5887C24.665 26.5887 24.7033 26.6174 24.7033 26.6461Z"
          fill="#8CBEBF"
        />
        <path
          d="M24.4352 26.8566C24.4352 26.9141 24.416 26.9524 24.3682 26.9524C24.3203 26.9524 24.2725 26.9236 24.2725 26.8662C24.2725 26.8184 24.3012 26.7992 24.3586 26.7992C24.416 26.7992 24.4352 26.7992 24.4352 26.8566V26.8566Z"
          fill="#04534E"
        />
        <path
          d="M24.0813 27.0863C24.0813 27.1246 24.0526 27.1533 24.0048 27.1533C23.986 27.1535 23.9679 27.1467 23.9538 27.1344C23.9397 27.122 23.9306 27.1049 23.9282 27.0863C23.9282 27.0385 23.9761 27.0193 24.0239 27.0193C24.0622 27.0193 24.0813 27.0385 24.0813 27.0768V27.0863ZM24.4259 26.8471C24.4259 26.8674 24.4178 26.8869 24.4035 26.9012C24.3891 26.9156 24.3696 26.9236 24.3493 26.9236C24.329 26.9236 24.3095 26.9156 24.2952 26.9012C24.2808 26.8869 24.2728 26.8674 24.2728 26.8471C24.2728 26.8268 24.2808 26.8073 24.2952 26.7929C24.3095 26.7786 24.329 26.7705 24.3493 26.7705C24.3696 26.7705 24.3891 26.7786 24.4035 26.7929C24.4178 26.8073 24.4259 26.8268 24.4259 26.8471ZM24.8278 26.9428C24.8278 27.0002 24.7991 27.0385 24.7513 27.0385C24.7383 27.04 24.7252 27.0386 24.7129 27.0343C24.7006 27.0301 24.6894 27.0231 24.6802 27.0139C24.671 27.0046 24.664 26.9935 24.6597 26.9811C24.6554 26.9688 24.654 26.9557 24.6556 26.9428C24.6556 26.9045 24.6747 26.8854 24.7226 26.8854C24.7704 26.8854 24.8183 26.9045 24.8183 26.9523L24.8278 26.9428ZM24.5694 27.1629C24.5694 27.2012 24.5407 27.2299 24.4929 27.2299C24.445 27.2299 24.4067 27.2012 24.4067 27.1629C24.4067 27.115 24.445 27.0959 24.4929 27.0959C24.5312 27.0959 24.5694 27.1246 24.5694 27.1629Z"
          fill="#8CBEBF"
        />
        <path
          d="M24.598 26.9141C24.598 26.9141 24.7225 26.8949 24.7512 26.9141C24.7703 26.9428 24.7703 26.9715 24.7512 26.9906L24.6842 26.981L24.598 26.9141ZM24.4736 26.5025C24.4736 26.5025 24.5693 26.5312 24.6076 26.5695C24.6459 26.6078 24.6459 26.6461 24.6363 26.6557C24.6363 26.6557 24.5885 26.6748 24.5693 26.6365L24.4736 26.5025V26.5025ZM24.1865 26.6939C24.1865 26.6939 24.3014 26.7609 24.3205 26.7896C24.3492 26.8279 24.3588 26.8566 24.3396 26.8758C24.3396 26.8853 24.2727 26.8758 24.2631 26.8471C24.2382 26.7957 24.2126 26.7447 24.1865 26.6939V26.6939Z"
          fill="#231F20"
        />
        <path
          d="M24.1387 26.7801C24.1387 26.7801 24.2631 26.7992 24.2918 26.8279C24.3301 26.8471 24.3492 26.8471 24.3492 26.8662C24.3492 26.8854 24.3301 26.9045 24.3109 26.9045L24.2152 26.8662C24.2152 26.8471 24.1387 26.7897 24.1387 26.7897V26.7801ZM23.9855 26.4164C23.9855 26.4164 24.1195 26.4356 24.1482 26.4547C24.177 26.4738 24.177 26.5313 24.1482 26.5504C24.1195 26.5695 24.0908 26.5313 24.0717 26.5121C24.0717 26.4834 23.9855 26.4164 23.9855 26.4164V26.4164ZM23.708 26.6078C23.708 26.6078 23.8324 26.6652 23.8707 26.7227C23.8898 26.7514 23.909 26.7705 23.8707 26.7801C23.8324 26.7992 23.7941 26.7322 23.7941 26.7227C23.7696 26.6814 23.7407 26.6429 23.708 26.6078V26.6078Z"
          fill="#231F20"
        />
        <path
          d="M23.689 26.7609L23.7942 26.7514C23.8325 26.7514 23.8899 26.7322 23.8899 26.7609C23.8899 26.7896 23.8421 26.7992 23.8134 26.7897L23.689 26.7609V26.7609ZM24.3397 27.1916C24.3397 27.1916 24.4354 27.1342 24.4642 27.1438C24.512 27.1533 24.5216 27.1438 24.5216 27.1725C24.5216 27.2012 24.4737 27.1916 24.4642 27.1916C24.4259 27.1921 24.3876 27.1921 24.3493 27.1916H24.3397ZM23.8804 27.1246C23.8804 27.1246 23.9187 27.0768 23.9474 27.0672L24.0048 27.0768C24.0048 27.0959 23.9761 27.1246 23.9569 27.1246H23.8804V27.1246Z"
          fill="#231F20"
        />
        <path
          d="M25.1915 27.0385C25.1915 27.0385 25.0767 27.1916 24.9044 27.2682C24.713 27.3447 24.5886 27.3639 24.3398 27.3543C24.1521 27.351 23.9681 27.3017 23.8038 27.2107C23.6794 27.1512 23.5711 27.0625 23.488 26.9523C23.4593 26.8949 23.5167 27.048 23.5167 27.048L23.6603 27.2395L23.8517 27.316L24.1101 27.383L24.3589 27.4117H24.5503L24.78 27.3734L24.9331 27.3256L25.0288 27.2586L25.1054 27.2012L25.2011 27.0385H25.1915ZM24.9618 26.5887C24.9618 26.5887 24.8949 26.6078 24.7417 26.5217C24.5886 26.426 24.4068 26.3016 24.0718 26.3016C23.7273 26.3016 23.6124 26.5313 23.5933 26.5504L23.7464 26.3494L23.8995 26.2537L24.024 26.2441H24.1388L24.2919 26.292L24.4259 26.3303L24.5886 26.3877L24.7322 26.4643L24.8949 26.5504L24.9618 26.5887V26.5887ZM25.4212 26.6844H25.1628C25.1054 26.6939 25.1054 26.7035 25.0958 26.7227C25.0904 26.7359 25.084 26.7487 25.0767 26.7609L25.0097 26.627L25.2872 26.5887L25.4404 26.6461L25.4212 26.6939V26.6844Z"
          fill="#04534E"
        />
        <path
          d="M25.0573 28.0912C25.0669 28.1295 25.0956 28.1678 25.1339 28.1678H25.2679L25.5359 28.1486L25.6316 28.0433L25.689 27.7945L25.7655 27.6988L26.0144 27.5553L26.2345 27.4978L26.378 27.4787L26.5694 27.4117L26.713 27.3447L26.7704 27.249L26.8374 27.1055L26.7704 26.9141L26.6173 26.7226L26.3685 26.6174H26.1484L25.9091 26.7035L25.4976 26.7992C25.4976 26.7992 25.2583 26.8949 25.1626 27.0863C25.0669 27.2586 25.0669 27.3064 25.0573 27.5457C25.0382 27.7849 25.0573 28.0912 25.0573 28.0912V28.0912Z"
          fill="#0C8489"
          stroke="#04534E"
          strokeWidth="0.0382813"
        />
        <path
          d="M25.1628 28.0051C25.2489 28.0051 25.1819 27.8711 25.2776 27.718C25.3734 27.5553 25.4691 27.3639 25.5073 27.3639C25.536 27.3639 25.536 27.3926 25.5743 27.383C25.603 27.3734 25.67 27.316 25.67 27.3064C25.67 27.2873 25.67 27.2107 25.737 27.1437C25.804 27.0863 25.9093 27.0098 25.9476 27.0002C25.9954 26.9906 26.0146 26.981 26.0241 27.0002C26.0337 27.0193 26.005 27.048 26.0337 27.0672C26.0624 27.0672 26.1294 27.0672 26.1581 27.0193C26.1773 26.9715 26.1677 26.9523 26.1677 26.9523C26.1677 26.9523 26.2155 26.9045 26.3112 26.9236C26.4069 26.9428 26.4069 26.9428 26.4165 26.9715C26.4261 27.0098 26.3782 27.0098 26.3878 27.0385C26.3974 27.0672 26.3878 27.0576 26.3878 27.0768C26.3974 27.0959 26.4165 27.1533 26.4835 27.1533C26.5409 27.1533 26.5601 27.115 26.5601 27.115L26.5792 27.0863C26.5792 27.0863 26.5984 27.048 26.5792 27.0289C26.5505 27.0098 26.5601 26.9906 26.5792 27.0098C26.6079 27.0098 26.6941 27.1437 26.7323 27.0959C26.761 27.0385 26.761 26.9619 26.7515 26.9428L26.5984 26.7322L26.3687 26.6461L26.0624 26.6748L25.7562 26.8471L25.4786 26.9906C25.4786 26.9906 25.4691 27.2203 25.4212 27.182C25.3638 27.1342 25.2968 27.0289 25.2776 27.0576L25.1819 27.3447C25.1532 27.4309 25.0671 27.6797 25.0862 27.7754C25.0862 27.8711 25.1341 28.0051 25.1628 28.0051V28.0051Z"
          fill="#8CBEBF"
        />
        <path
          d="M25.4402 27.6414L25.3828 27.6701C25.373 27.6799 25.366 27.6923 25.3626 27.7057C25.3592 27.7192 25.3596 27.7334 25.3637 27.7467C25.3732 27.7754 25.4211 27.8041 25.4211 27.8041H25.4594L25.5264 27.785C25.5264 27.785 25.5551 27.7562 25.5551 27.718C25.5551 27.6797 25.5359 27.6701 25.5264 27.6701L25.4402 27.6414V27.6414ZM25.9188 27.249C25.8709 27.2299 25.8518 27.2586 25.8518 27.2682V27.316C25.8518 27.316 25.8518 27.3734 25.8805 27.383C25.8996 27.3926 25.957 27.4117 25.9762 27.3926C25.9953 27.3734 26.0145 27.3639 26.0145 27.3256C26.0145 27.2873 25.957 27.2682 25.957 27.2682L25.9188 27.249ZM26.3016 27.3447C26.3016 27.3256 26.2633 27.316 26.2346 27.316C26.2059 27.316 26.1771 27.3543 26.1867 27.4021C26.1963 27.45 26.2441 27.45 26.2824 27.4404C26.3207 27.4404 26.3111 27.383 26.3111 27.3734L26.3016 27.3352V27.3447ZM25.1914 27.4117C25.1914 27.4404 25.2393 27.4787 25.2871 27.4787C25.3095 27.4792 25.3313 27.4717 25.3488 27.4578C25.3663 27.4438 25.3783 27.4241 25.3828 27.4021C25.3828 27.3734 25.3541 27.4309 25.3158 27.4404C25.2775 27.4404 25.2488 27.4596 25.2297 27.4404L25.201 27.4117H25.1914Z"
          fill="#8CBEBF"
        />
        <path
          d="M25.5552 27.718C25.5552 27.718 25.5552 27.7658 25.5265 27.7945L25.4499 27.8137C25.4308 27.8137 25.4021 27.8137 25.3925 27.7945L25.3638 27.7371C25.3638 27.7371 25.4021 27.8041 25.4595 27.7849C25.5265 27.7754 25.5552 27.718 25.5552 27.718V27.718ZM26.5792 27.0863C26.5792 27.0863 26.5792 27.1342 26.5409 27.1533C26.5026 27.1724 26.4835 27.182 26.4644 27.1725C26.4452 27.1725 26.4165 27.1724 26.4069 27.1437C26.3591 27.0767 26.3878 27.0289 26.3878 27.0289C26.3878 27.0289 26.4165 27.1533 26.4835 27.1437C26.5505 27.1342 26.5792 27.0863 26.5792 27.0863V27.0863ZM25.67 27.2969C25.67 27.2969 25.6317 27.3926 25.5743 27.3926C25.5073 27.3926 25.5169 27.383 25.5169 27.3639C25.5169 27.3639 25.5456 27.383 25.5743 27.3639C25.603 27.3639 25.67 27.3064 25.67 27.3064V27.2969ZM25.8423 27.2873C25.8423 27.2873 25.8423 27.3543 25.8614 27.383C25.8806 27.4021 25.9093 27.4117 25.938 27.4117C25.9667 27.4117 25.9858 27.4117 26.005 27.383C26.0241 27.3543 26.005 27.3256 26.005 27.3256L25.9954 27.3543C25.989 27.3635 25.9804 27.371 25.9704 27.376C25.9603 27.381 25.9492 27.3834 25.938 27.383C25.9188 27.383 25.8806 27.383 25.871 27.3543L25.8423 27.2873V27.2873ZM26.1677 26.9523C26.1677 26.9523 26.1868 27.0002 26.1485 27.048C26.1103 27.0863 26.0337 27.0672 26.0337 27.0672C26.0337 27.0672 26.0911 27.0767 26.1294 27.048C26.1581 27.0098 26.1677 26.9523 26.1677 26.9523Z"
          fill="#04534E"
        />
        <path
          d="M25.1338 28.1486C25.1338 28.1486 25.5357 28.1486 25.5645 28.0816C25.6027 28.0338 25.5357 27.8137 25.775 27.6414C26.0143 27.4691 26.2057 27.4691 26.3396 27.4596C26.4641 27.4596 26.7416 27.3639 26.799 27.115C26.8277 26.9619 26.6172 26.9523 26.5406 26.8088C26.4641 26.6652 26.2631 26.7226 26.2535 26.7226C26.2535 26.7226 26.0238 26.7226 25.9186 26.8184C25.8611 26.8853 25.8707 26.9619 25.8324 26.9906C25.8133 27.0289 25.5453 26.9906 25.5166 27.0385C25.4879 27.0767 25.5166 27.1725 25.4975 27.1916C25.4783 27.2107 25.4209 27.1342 25.4209 27.1342L25.44 26.9141L25.775 26.7226L26.1578 26.5025H26.4258L26.6938 26.6461L26.8277 26.7992C26.8277 26.7992 26.8564 26.8566 26.866 26.9715C26.8725 27.0227 26.8692 27.0746 26.8564 27.1246C26.8183 27.2327 26.7488 27.3269 26.6567 27.3951C26.5646 27.4634 26.4542 27.5025 26.3396 27.5074C26.11 27.517 25.8994 27.6223 25.8037 27.6988C25.6984 27.7754 25.641 28.1103 25.641 28.1486C25.641 28.1965 25.1434 28.1678 25.1434 28.1678L25.1338 28.1486V28.1486Z"
          fill="#04534E"
        />
        <path
          d="M25.2968 27.3639C25.2777 27.383 25.249 27.3734 25.2394 27.3543C25.2202 27.2873 25.2681 27.1916 25.2681 27.1916V27.3064C25.2777 27.3256 25.2968 27.3256 25.3064 27.3352V27.3639H25.2968ZM25.5552 27.3064C25.5361 27.3064 25.5361 27.2395 25.5552 27.2107L25.6796 27.1055L25.6318 27.2203C25.6222 27.249 25.5839 27.316 25.5552 27.316V27.3064ZM25.4595 27.718C25.4404 27.718 25.4308 27.6893 25.4308 27.6414C25.4308 27.5936 25.5074 27.517 25.5074 27.517L25.4882 27.6127V27.6797C25.4882 27.7084 25.4691 27.718 25.4595 27.718V27.718Z"
          fill="#231F20"
        />
        <path
          d="M25.6414 27.6031L25.5648 27.6701C25.5265 27.6893 25.4787 27.7276 25.4595 27.718C25.4308 27.718 25.4691 27.6606 25.4883 27.651L25.6414 27.6031ZM25.9859 27.1151L25.9189 27.2108C25.8998 27.2586 25.8902 27.3065 25.9189 27.3065C25.9381 27.3256 25.9668 27.249 25.9668 27.2299L25.9859 27.1151Z"
          fill="#231F20"
        />
        <path
          d="M26.1101 27.2873C26.1101 27.2873 26.0814 27.2586 26.024 27.2394C25.9666 27.2299 25.9379 27.2394 25.9283 27.2586C25.9283 27.2777 25.89 27.2969 25.9092 27.316L25.9762 27.2873C25.9857 27.2873 26.0144 27.2682 26.0432 27.2777H26.1197L26.1101 27.2873ZM26.0432 26.9523C26.0623 26.9619 26.091 26.9332 26.1197 26.9045L26.1676 26.8088L26.091 26.8566C26.0623 26.8758 26.0336 26.9332 26.0432 26.9523ZM26.5695 26.9332L26.4738 27.0002C26.4547 27.0289 26.426 27.0576 26.4451 27.0767C26.4738 27.0959 26.493 27.0576 26.5121 27.0385L26.5695 26.9428V26.9332ZM26.4164 27.2873C26.4164 27.2873 26.3973 27.3351 26.3494 27.3639C26.3111 27.3926 26.2537 27.4021 26.2537 27.3926C26.2346 27.3734 26.2537 27.3447 26.2728 27.3351L26.3398 27.316C26.3781 27.316 26.4164 27.2873 26.4164 27.2873Z"
          fill="#231F20"
        />
        <path
          d="M22.9307 26.452C23.0508 26.4704 23.1703 26.3413 23.1975 26.1637C23.2247 25.986 23.1493 25.8271 23.0291 25.8087C22.9089 25.7904 22.7895 25.9195 22.7623 26.0971C22.7351 26.2747 22.8105 26.4337 22.9307 26.452Z"
          fill="url(#paint0_radial_2407_229)"
        />
        <path
          d="M23.1145 25.5264L22.9805 25.8613L23.0857 25.8422L23.1527 25.5551L23.1145 25.5264Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.1815 25.3828C23.1241 25.3828 23.0858 25.4211 23.0858 25.4785C23.0762 25.5168 23.105 25.5646 23.1528 25.5742C23.2007 25.5742 23.2485 25.5455 23.2485 25.4881C23.2485 25.4402 23.2198 25.3924 23.172 25.3924L23.1815 25.3828ZM28.8089 26.2059L28.4835 26.5121L28.6175 26.5408L28.8376 26.2537L28.8089 26.2059Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M28.9524 26.0814C28.895 26.0527 28.828 26.0814 28.7897 26.1293C28.7814 26.1408 28.7757 26.1541 28.7731 26.168C28.7705 26.182 28.7711 26.1964 28.7747 26.2102C28.7784 26.2239 28.7851 26.2367 28.7943 26.2475C28.8035 26.2584 28.815 26.267 28.828 26.2729C28.8759 26.3016 28.9524 26.2729 28.9812 26.225C28.9895 26.2135 28.9952 26.2003 28.9978 26.1863C29.0004 26.1723 28.9999 26.1579 28.9962 26.1441C28.9925 26.1304 28.9858 26.1176 28.9766 26.1068C28.9674 26.0959 28.9559 26.0873 28.9429 26.0814H28.9524ZM20.6167 24.4641L20.789 24.8373L20.8655 24.7416L20.6741 24.4545L20.6167 24.4641Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M20.55 24.3014C20.5305 24.3196 20.5186 24.3446 20.5168 24.3712C20.5151 24.3979 20.5235 24.4242 20.5404 24.4449C20.5787 24.4928 20.6361 24.5023 20.684 24.4641C20.7035 24.4458 20.7153 24.4208 20.7171 24.3942C20.7189 24.3675 20.7104 24.3412 20.6935 24.3205C20.686 24.309 20.6761 24.2993 20.6644 24.292C20.6528 24.2846 20.6397 24.2799 20.6261 24.2781C20.6125 24.2763 20.5987 24.2774 20.5855 24.2814C20.5724 24.2854 20.5602 24.2922 20.55 24.3014Z"
          fill="#FCCA3E"
          stroke="#AA8C30"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.2102 25.402C23.2102 25.402 23.2293 25.4211 23.2102 25.402C23.1719 25.402 23.0953 25.4307 23.0953 25.4881C23.0953 25.5359 23.1336 25.5647 23.1719 25.5647H23.1145L23.0953 25.5264L23.0762 25.4881L23.0857 25.4402L23.1145 25.402L23.1527 25.3924H23.1814L23.2102 25.402V25.402Z"
          fill="#AA8C30"
        />
        <path
          d="M23.1338 25.6221C23.1338 25.6221 23.1146 25.6221 23.0955 25.6508L23.0381 25.7273L23.1051 25.5455L23.1529 25.5646L23.1338 25.6221V25.6221ZM28.9717 26.1101C28.9717 26.1101 29.0004 26.1389 28.9717 26.1101C28.943 26.0814 28.8377 26.091 28.809 26.1484C28.7898 26.2059 28.809 26.2537 28.8568 26.2728C28.9047 26.292 28.8377 26.2728 28.8377 26.2728L28.7898 26.2346L28.7803 26.1963V26.1389L28.8186 26.1006L28.876 26.0719H28.9238L28.9525 26.091L28.9813 26.1101H28.9717Z"
          fill="#AA8C30"
        />
        <path
          d="M28.7802 26.3207H28.7228L28.6079 26.3877L28.7897 26.225L28.828 26.2729L28.7802 26.3207V26.3207ZM20.588 24.2822C20.588 24.2822 20.6167 24.2727 20.588 24.2822C20.5593 24.3109 20.5306 24.3971 20.5688 24.4354C20.5862 24.4502 20.6082 24.4583 20.6311 24.4583C20.6539 24.4583 20.6759 24.4502 20.6933 24.4354C20.7315 24.4067 20.6933 24.4545 20.6933 24.4545L20.6358 24.4832H20.5976L20.5497 24.4641L20.521 24.4162V24.3588L20.5306 24.3109L20.5593 24.2918L20.588 24.2822V24.2822Z"
          fill="#AA8C30"
        />
        <path
          d="M20.7126 24.5215C20.7126 24.5215 20.6935 24.5406 20.703 24.5789L20.7222 24.6937L20.6265 24.4832L20.6743 24.4641L20.7126 24.5215Z"
          fill="#AA8C30"
        />
        <path
          d="M20.7925 25.281C20.8815 25.4551 21.0491 25.5474 21.1668 25.4872C21.2844 25.427 21.3075 25.2371 21.2184 25.063C21.1294 24.8889 20.9618 24.7966 20.8441 24.8568C20.7265 24.917 20.7034 25.1069 20.7925 25.281Z"
          fill="url(#paint1_radial_2407_229)"
        />
        <path
          d="M20.5977 25.0957C20.5977 25.0957 20.6743 25.1148 20.7126 25.0957C20.7604 25.067 20.7604 25.0383 20.77 25.0287L20.7891 24.9617C20.7733 24.9178 20.747 24.8783 20.7126 24.8469H20.636C20.6264 24.8277 20.636 24.8086 20.6169 24.799C20.5977 24.799 20.4925 24.9234 20.5116 24.9426C20.5307 24.9617 20.5403 24.933 20.5499 24.9426V25.0383L20.6073 25.0957H20.5977Z"
          fill="#E92736"
        />
        <path
          d="M20.7125 24.8564C20.7125 24.8756 20.7604 24.933 20.7795 24.933H20.8657C20.8752 24.933 20.9327 24.8851 20.9327 24.8564L20.9231 24.799C20.9135 24.7799 20.9231 24.7225 20.8944 24.7129C20.8752 24.7129 20.8752 24.7129 20.8657 24.6937C20.8465 24.6937 20.8657 24.665 20.8465 24.6459C20.837 24.6172 20.6551 24.7225 20.6743 24.7416C20.6838 24.7607 20.703 24.7416 20.7125 24.7607V24.8564V24.8564Z"
          fill="#E92736"
        />
        <path
          d="M21.1145 24.8086L21.1049 24.6746C21.0857 24.6651 21.057 24.6651 21.0475 24.6459C21.0475 24.6363 21.0762 24.6268 21.0762 24.6076C21.0762 24.5885 20.8848 24.6172 20.8848 24.6363C20.9039 24.6651 20.9326 24.6459 20.9326 24.6651L20.8943 24.7129L20.9135 24.799C20.923 24.8086 20.9135 24.8277 20.9326 24.8373L20.9805 24.8469H21.0857C21.0953 24.8373 21.1049 24.8469 21.1145 24.8086ZM22.7893 25.7943C22.7893 25.7943 22.818 25.8518 22.8563 25.8613H22.9232C22.9328 25.8613 22.9711 25.8518 22.9807 25.8326L23.0094 25.7274L22.9615 25.6699C22.9615 25.6508 22.9902 25.6508 22.9807 25.6317C22.9711 25.6125 22.8275 25.6317 22.8275 25.6508C22.8275 25.6699 22.8467 25.6604 22.8467 25.6795L22.7893 25.7274V25.7943V25.7943Z"
          fill="#E92736"
        />
        <path
          d="M22.9902 25.7273V25.823L23.0381 25.8709H23.1242C23.1383 25.8581 23.1483 25.8415 23.1529 25.823C23.1625 25.8039 23.2008 25.7752 23.1912 25.7656L23.1816 25.7273C23.1816 25.7178 23.2104 25.7082 23.2104 25.6891C23.2104 25.6699 23.0477 25.6125 23.0477 25.6316C23.0381 25.6603 23.0668 25.6508 23.0572 25.6699C23.0572 25.6699 22.9998 25.7082 22.9998 25.7273H22.9902Z"
          fill="#E92736"
        />
        <path
          d="M23.2581 25.957C23.2773 25.9474 23.3347 25.89 23.3347 25.8613L23.3251 25.823L23.3634 25.8135C23.3634 25.8039 23.239 25.689 23.239 25.7178C23.2294 25.7369 23.2581 25.7465 23.239 25.756H23.2007L23.1529 25.823C23.1529 25.8326 23.1337 25.8326 23.1433 25.8517L23.1529 25.89L23.2199 25.957H23.2581V25.957ZM28.3208 26.3781C28.3208 26.3781 28.3208 26.4355 28.3496 26.4738L28.407 26.5025H28.4644C28.4835 26.5025 28.5314 26.4355 28.5314 26.4164V26.3494C28.5314 26.3398 28.5505 26.3494 28.5505 26.3303C28.5505 26.3111 28.4261 26.2441 28.4165 26.2728V26.3015L28.3496 26.3207L28.3208 26.3781V26.3781Z"
          fill="#E92736"
        />
        <path
          d="M28.5122 26.4164L28.4644 26.4738V26.5408L28.5505 26.5791C28.5645 26.5757 28.5776 26.5691 28.5888 26.56C28.6079 26.56 28.6558 26.5504 28.6558 26.5312V26.5025C28.6653 26.493 28.6845 26.5025 28.7036 26.4834C28.7132 26.4738 28.6079 26.359 28.5983 26.3685C28.5792 26.3877 28.5983 26.3973 28.5983 26.3973L28.5122 26.4164V26.4164Z"
          fill="#E92736"
        />
        <path
          d="M28.56 26.7035H28.6557L28.6844 26.6652L28.7131 26.6748C28.7322 26.6748 28.7131 26.5313 28.7035 26.5408C28.6844 26.5408 28.6939 26.5695 28.6844 26.5695C28.6652 26.5695 28.6557 26.5504 28.6461 26.5408L28.5791 26.5504C28.56 26.56 28.5504 26.5504 28.5408 26.5695L28.5312 26.5983V26.6844L28.56 26.7035V26.7035Z"
          fill="#E92736"
        />
        <path
          d="M20.7223 24.933C20.7414 24.9521 20.7223 25.0096 20.7031 25.0287C20.6936 25.0478 20.6074 25.0287 20.6074 25.0096V24.9426C20.617 24.933 20.6457 24.8947 20.6744 24.8947C20.6936 24.8947 20.7223 24.9234 20.7223 24.933V24.933ZM20.751 24.8182C20.7414 24.8469 20.751 24.866 20.7701 24.8756C20.7701 24.8947 20.8371 24.9043 20.8658 24.8947C20.8658 24.8947 20.9041 24.7894 20.885 24.7703C20.885 24.7607 20.8467 24.7512 20.8275 24.7607C20.799 24.7755 20.7731 24.7949 20.751 24.8182V24.8182ZM20.9615 24.7224V24.7799C20.9615 24.7799 21.0094 24.8182 21.0381 24.8182C21.0572 24.8182 21.0668 24.7416 21.0668 24.7224C21.0668 24.7033 21.0668 24.7129 21.0477 24.7033L20.952 24.7224H20.9615ZM22.9617 25.7752C22.9617 25.8039 22.9043 25.823 22.8852 25.823C22.866 25.823 22.8373 25.756 22.8469 25.7465C22.8469 25.7369 22.866 25.7178 22.8852 25.7178H22.9521V25.7752H22.9617ZM23.0383 25.7273C23.0191 25.7273 23.0191 25.756 23.0191 25.7752C23.0191 25.7848 23.0383 25.8326 23.0574 25.8422C23.0766 25.8422 23.1531 25.8039 23.1531 25.7848L23.1244 25.7465L23.0383 25.7273ZM23.2297 25.8039C23.2105 25.8039 23.1914 25.8326 23.1914 25.8422C23.1914 25.8422 23.1914 25.89 23.2105 25.9092C23.2297 25.9187 23.2775 25.89 23.2871 25.8805V25.8517L23.2297 25.8039V25.8039ZM28.4742 26.4355C28.4551 26.4451 28.4072 26.4355 28.3977 26.4355C28.3785 26.4355 28.3785 26.3494 28.3977 26.3494C28.3977 26.3494 28.4264 26.3303 28.4359 26.3398C28.4551 26.3398 28.4838 26.359 28.4838 26.3781V26.4355H28.4742ZM28.5508 26.4355L28.5029 26.4547V26.5312C28.5125 26.5408 28.5986 26.5504 28.5986 26.5312C28.6178 26.5312 28.6082 26.493 28.6082 26.493L28.5508 26.4355ZM28.6369 26.5887H28.5891L28.5604 26.6461C28.5604 26.6652 28.6082 26.6748 28.6178 26.6748C28.6273 26.6748 28.6369 26.6748 28.6465 26.6557L28.6369 26.5887V26.5887Z"
          fill="#F7E204"
        />
        <path
          d="M28.03 26.9993C28.0938 27.0699 28.2599 27.0237 28.4011 26.8962C28.5423 26.7686 28.6051 26.608 28.5413 26.5374C28.4775 26.4668 28.3113 26.513 28.1701 26.6405C28.029 26.7681 27.9662 26.9287 28.03 26.9993Z"
          fill="url(#paint2_radial_2407_229)"
        />
        <path
          d="M22.3775 21.8801C22.3775 21.8801 22.0904 21.9088 21.8799 21.8801C21.6885 21.8418 21.7268 21.3154 21.7172 21.3059C21.7172 21.2867 21.5928 21.1623 21.6215 21.0475C21.6406 20.9326 22.0043 20.6264 22.0617 20.6072C22.1 20.5977 22.1766 20.6264 22.1766 20.6264C22.1766 20.6264 22.2723 20.5307 22.301 20.5307C22.3297 20.5307 22.368 20.5881 22.3584 20.6072C22.3393 20.6359 22.2148 20.7029 22.2053 20.7699C22.1957 20.8273 22.2053 20.8848 22.167 20.9422C22.1287 20.9996 22.0617 21.0762 22.0521 21.124C22.0426 21.1719 22.0234 21.2197 22.0521 21.2293C22.0904 21.2484 22.2148 21.2293 22.3201 21.1815C22.4254 21.1336 22.4732 21.0762 22.4828 21.0857C22.502 21.0857 22.4254 21.2102 22.3105 21.258C22.1861 21.3059 22.1191 21.3633 22.0521 21.3537C22.0521 21.3537 21.9947 21.5068 22.1861 21.5164C22.3871 21.526 22.502 21.4781 22.502 21.4781L22.3775 21.8801V21.8801ZM21.2291 23.1051C21.2291 23.1051 21.3918 23.1625 21.3918 23.3348C21.3918 23.507 21.2195 23.6506 21.2291 23.9568C21.2291 24.2631 21.277 24.2631 21.6789 24.5885C21.6885 24.5885 21.7746 24.6842 21.7938 24.7799C21.8225 24.8756 21.8895 25.4498 22.2723 25.4498C22.6551 25.4498 22.7125 25.2106 22.7125 25.2106L22.5498 24.9713C22.5498 24.9713 22.4158 25.0096 22.3393 24.9904C22.3 24.9783 22.264 24.9574 22.2342 24.9292C22.2043 24.901 22.1813 24.8662 22.167 24.8277C22.1191 24.732 22.1096 24.5119 22.0426 24.4162C21.8799 24.177 21.5928 24.1291 21.5928 23.8803C21.5928 23.6219 21.7746 23.5932 21.7172 23.2965C21.6598 22.9998 21.3057 22.8467 21.3057 22.8467L21.1621 22.7893L21.1143 23.0859L21.2387 23.1051H21.2291Z"
          fill="#A8AC71"
        />
        <path
          d="M22.301 20.99C22.4254 20.9613 22.3488 20.6264 22.3488 20.6264L22.2627 20.6934C22.2627 20.6934 22.3201 20.7699 22.3201 20.8465C22.3201 20.9231 22.301 20.99 22.301 20.99V20.99Z"
          fill="#F1A720"
        />
        <path
          d="M22.531 24.3492L22.464 24.2918C22.4257 24.2631 22.2152 24.1004 22.2535 23.6219C22.2917 23.0668 23.0861 22.7797 23.1339 22.5596C23.2009 22.3108 23.3828 22.2055 22.7416 21.7078L22.5884 21.8897L22.8564 22.0811C22.8564 22.0811 22.9138 22.0524 22.9138 22.1289C22.9138 22.1959 22.8468 22.2629 22.8181 22.3203C22.8181 22.3682 22.4162 22.6457 22.3875 22.6744L22.1578 22.8658C22.1578 22.8658 22.0525 22.9615 21.9568 23.1721C21.8611 23.3826 21.9089 23.6506 21.9089 23.6506C21.9089 23.6506 21.9089 24.244 22.531 24.3492V24.3492Z"
          fill="#A8AC71"
        />
        <path
          d="M22.1479 24.6555L22.1861 24.866L22.0617 24.9139H22.0043L21.966 24.9234L21.8703 25.0191H21.8416L21.8225 24.9521C21.8204 24.917 21.8172 24.8818 21.8129 24.8469L21.9277 24.8947H21.9756L22.0043 24.8852L22.0521 24.7703L22.1479 24.6555V24.6555ZM21.765 24.6937L21.7172 24.6172L21.6406 24.5502L21.7363 24.5023H21.832L21.8129 24.6172L21.7746 24.6937H21.765ZM21.9852 24.3588C21.9852 24.3588 22.0426 24.3875 22.0617 24.4353L22.1096 24.531L21.9564 24.5215L21.8512 24.4832L21.9182 24.3875L21.9852 24.3588ZM21.9277 25.2775C21.9277 25.2775 21.899 25.2584 21.8799 25.2105L21.8512 25.0861L21.9469 25.067L22.0617 25.1148H22.0904L22.0617 25.1723L21.9564 25.268H21.9277V25.2775ZM22.3105 24.9617C22.3105 24.9617 22.234 24.933 22.2148 24.8947C22.2053 24.8469 22.1957 24.8564 22.1957 24.8564L22.167 24.9713L22.1287 25.0861L22.1383 25.1053L22.234 25.0766L22.2914 25.0096L22.3201 24.9617H22.3105ZM21.9564 25.3254L22.0521 25.3828C22.1191 25.4211 22.1479 25.4211 22.1479 25.4211L22.2053 25.3732L22.2436 25.2775L22.2531 25.268L22.0139 25.2871L21.9564 25.3254V25.3254ZM22.2914 25.2297L22.4924 25.1148L22.502 25.0096L22.4637 24.9809H22.3488L22.3201 25.1148L22.2914 25.2393V25.2297ZM22.1479 25.4211C22.1479 25.4211 22.2914 25.4881 22.5307 25.4019C22.6455 25.3541 22.6646 25.3062 22.6646 25.3062L22.5689 25.268L22.4732 25.3445L22.1479 25.4211V25.4211ZM21.9564 23.8707L21.9277 23.775L21.9182 23.6793L21.9852 23.7176L22.0904 23.7941L22.0234 23.8516L21.9564 23.8707ZM22.1287 24.1578L22.0617 24.0812C22.0439 24.0503 22.028 24.0183 22.0139 23.9855L22.0904 24.0047L22.1766 24.0525L22.1383 24.1578H22.1287V24.1578Z"
          fill="#78732E"
        />
        <path
          d="M21.6792 20.9518C21.66 20.9996 21.6409 21.0857 21.7079 21.1049C21.7462 21.1049 21.8993 21.1049 22.062 20.9135C22.1386 20.8178 22.1386 20.7221 22.1386 20.7221L22.1768 20.6264C22.1768 20.6264 22.1098 20.5785 22.0046 20.6455C21.889 20.7398 21.7803 20.8421 21.6792 20.9518V20.9518Z"
          fill="#C6C7A6"
        />
        <path
          d="M22.1288 20.7125C22.1447 20.7125 22.1575 20.6997 22.1575 20.6838C22.1575 20.6679 22.1447 20.6551 22.1288 20.6551C22.113 20.6551 22.1001 20.6679 22.1001 20.6838C22.1001 20.6997 22.113 20.7125 22.1288 20.7125Z"
          fill="#1C242F"
        />
        <path
          d="M21.9182 20.7125C21.8416 20.7699 21.7842 20.8369 21.7842 20.8369C21.7842 20.8369 21.8895 20.8082 21.9756 20.7316C22.0047 20.7078 22.0385 20.6904 22.0748 20.6805C22.111 20.6706 22.149 20.6685 22.1861 20.6742C22.2053 20.6742 22.1957 20.6455 22.1861 20.6359C22.1574 20.6168 22.0809 20.6072 22.0617 20.6168C22.0617 20.6168 21.9852 20.6551 21.9182 20.7125V20.7125Z"
          fill="#A8AC71"
        />
        <path
          d="M22.2532 23.8133V23.641L22.1862 23.6984L22.1192 23.7941L22.2149 23.8229L22.2532 23.8133V23.8133ZM21.9087 23.6219V23.44C21.9087 23.3539 21.947 23.2008 21.947 23.2008L21.9853 23.3061L22.1097 23.4975L22.1479 23.5262L22.0522 23.5932L21.9374 23.6314L21.9087 23.6219V23.6219ZM22.2532 23.5645L22.2724 23.4879L22.3106 23.3922L22.2054 23.4879L22.1575 23.5262L22.2149 23.574H22.2628L22.2532 23.5645ZM21.9757 23.1242C21.9757 23.1242 21.9948 23.0668 22.0427 22.9998L22.1479 22.8563L22.1958 23.0477L22.2245 23.2008V23.2295L22.1767 23.2486C22.1671 23.2486 22.0522 23.2486 22.0331 23.2199L21.9757 23.1242V23.1242ZM22.3394 23.3348L22.4063 23.2678L22.4829 23.1912L22.2341 23.2391L22.2724 23.3156L22.3394 23.3348ZM22.1958 22.8275L22.2819 22.751C22.3489 22.684 22.3776 22.6936 22.3776 22.6936L22.4063 22.9615L22.2819 22.9232L22.1862 22.8275H22.1958Z"
          fill="#78732E"
        />
        <path
          d="M22.4924 23.1816L22.6455 23.0285L22.3967 22.9519L22.4445 23.1242L22.4924 23.1816ZM22.5977 22.7797L22.6168 22.5213L22.502 22.5978L22.4062 22.6744L22.435 22.7127L22.5307 22.7701H22.5977V22.7797ZM22.8178 22.5309V22.3394L22.7316 22.4256C22.7107 22.4429 22.6915 22.4621 22.6742 22.483L22.7412 22.5213L22.8178 22.5309ZM22.9135 22.7988L23.0283 22.7031C23.0734 22.6685 23.1123 22.6264 23.1432 22.5787L22.8273 22.55L22.8369 22.684L22.9135 22.7988V22.7988ZM22.167 21.7461V21.8896H22.4254L22.3584 21.7939L22.2818 21.7461L22.2053 21.6695L22.167 21.7461ZM22.6838 22.9902L22.7986 22.8945L22.8943 22.818L22.6359 22.7893L22.6455 22.9615L22.6838 22.9902ZM23.1623 22.5309C23.1623 22.5309 23.191 22.4352 23.191 22.3394C23.1917 22.2909 23.1852 22.2426 23.1719 22.1959L22.9805 22.3203L23.0092 22.416L23.0857 22.5021L23.1623 22.5309V22.5309Z"
          fill="#78732E"
        />
        <path
          d="M22.8369 22.3012C22.8369 22.3012 22.8943 22.2342 22.9039 22.1959V22.1672H23.057L23.1432 22.1768L23.1527 22.1863L23.0857 22.2629L22.99 22.3203L22.8752 22.3299L22.8369 22.3012V22.3012ZM23.1432 22.1576L23.0475 21.9949L22.99 21.9184L22.9135 22.1289V22.1576H23.1432Z"
          fill="#78732E"
        />
        <path
          d="M21.2964 23.641L21.2677 23.6984C21.2677 23.6984 21.3634 23.641 21.4495 23.6506C21.5261 23.6506 21.6122 23.7463 21.6122 23.7463L21.6313 23.6793C21.6313 23.6793 21.5261 23.5836 21.4591 23.574C21.3921 23.574 21.2964 23.641 21.2964 23.641V23.641ZM21.3442 23.1912L21.3729 23.2199C21.3729 23.2295 21.3729 23.1529 21.4782 23.1051C21.5739 23.0668 21.6409 23.1051 21.6409 23.1051C21.6409 23.1051 21.6218 23.0381 21.5739 23.0285C21.5261 23.0189 21.4782 23.0285 21.4304 23.0668C21.3729 23.1051 21.3442 23.1912 21.3442 23.1912V23.1912ZM21.6888 23.5262C21.6888 23.5262 21.6409 23.4305 21.5548 23.4018C21.4782 23.3826 21.3729 23.4496 21.3729 23.4496L21.3538 23.4975C21.3538 23.4975 21.4687 23.44 21.5452 23.4687C21.6313 23.507 21.6696 23.6027 21.6696 23.6027L21.6888 23.5262V23.5262ZM21.306 23.1434L21.3347 23.1721C21.3347 23.1721 21.3155 23.0764 21.3729 23.0094L21.4591 22.9328L21.4112 22.9137C21.4112 22.9137 21.3442 22.9615 21.3155 23.0094C21.2964 23.0572 21.2964 23.1146 21.306 23.1338V23.1434ZM21.2581 22.9519C21.2868 22.9041 21.3538 22.885 21.3538 22.885L21.3251 22.8658H21.2964C21.2964 22.8658 21.2581 22.885 21.2294 22.9424C21.2007 23.0094 21.2007 23.0955 21.2007 23.0955L21.2485 23.1146C21.2485 23.1146 21.239 23.0189 21.2581 22.9615V22.9519ZM21.861 21.4973C21.928 21.459 21.9759 21.4685 21.9759 21.4685C21.9759 21.4685 21.8802 21.5643 21.928 21.6887C21.8706 21.7844 21.8515 21.8705 21.8515 21.8705H21.9089L21.9376 21.7269C21.9724 21.7915 22.0215 21.8471 22.0812 21.8896H22.1577C22.1577 21.8896 22.1577 21.7939 22.2056 21.6982C22.2461 21.7489 22.2987 21.7884 22.3587 21.8131V21.7844C22.3587 21.7844 22.2726 21.7365 22.2247 21.6695V21.66C22.2821 21.5643 22.3587 21.5355 22.3587 21.5355L22.4161 21.5738L22.4257 21.5643L22.3874 21.5068H22.3396L22.2056 21.6408C22.1824 21.6013 22.1632 21.5597 22.1481 21.5164H22.1099C22.1099 21.5164 22.0333 21.5164 21.9567 21.6408C21.9472 21.5451 22.0524 21.4494 22.0524 21.4494L22.0429 21.4207L21.8515 21.459C21.7845 21.4877 21.7366 21.5547 21.7366 21.5547V21.6121C21.7366 21.6121 21.8036 21.5355 21.861 21.4973ZM21.9759 21.66C22.0237 21.593 22.1194 21.5451 22.1194 21.5451C22.1194 21.5451 22.1194 21.6025 22.1864 21.6695C22.1481 21.7461 22.129 21.8514 22.129 21.8514C22.129 21.8514 22.0429 21.7939 21.9759 21.6982C21.9715 21.6891 21.9683 21.6794 21.9663 21.6695C21.9662 21.6663 21.9662 21.6631 21.9663 21.66H21.9759ZM21.4017 23.2773V23.3348C21.4017 23.3348 21.4591 23.2678 21.5452 23.2678C21.6409 23.2678 21.7175 23.3348 21.7175 23.3348V23.2486C21.6983 23.2486 21.6218 23.2008 21.5548 23.2008C21.4782 23.2008 21.3921 23.2773 21.3921 23.2773H21.4017ZM23.0286 22.416C23.0177 22.391 23.0081 22.3655 22.9999 22.3394L23.0382 22.3203C23.0867 22.2832 23.1316 22.2415 23.1722 22.1959L23.1435 22.1576H23.019L22.9138 22.148L22.9521 22.0141L22.9903 21.9088L22.9521 21.8705C22.9521 21.8705 22.9616 21.9088 22.8851 21.9184C22.8117 21.9078 22.7405 21.8852 22.6745 21.8514V21.8896L22.8659 21.9375L22.9616 21.9184C22.9431 21.9489 22.9271 21.9809 22.9138 22.0141L22.8946 22.0906L22.9138 22.1002L22.9042 22.1672L23.0095 22.1768L23.1435 22.1863C23.1435 22.1863 23.0765 22.2629 23.0095 22.2916C23.0002 22.2956 22.9906 22.2988 22.9808 22.3012L22.9042 22.1863V22.2246L22.9521 22.3203L22.8372 22.3012L22.8085 22.3299V22.5213L22.6745 22.483L22.6458 22.5021L22.6171 22.5213C22.6171 22.5213 22.5884 22.6361 22.5884 22.7701C22.4735 22.7414 22.4065 22.6744 22.4065 22.6744L22.3778 22.6935C22.3778 22.6935 22.3587 22.8084 22.3874 22.9424C22.315 22.9208 22.2491 22.8813 22.196 22.8275L22.1577 22.8658L22.196 23.2008L22.2056 23.2295C22.1865 23.2309 22.1673 23.2309 22.1481 23.2295C22.0524 23.2295 21.9759 23.1242 21.9759 23.1242L21.9472 23.2008C21.9472 23.2008 21.9854 23.4113 22.1003 23.507L22.129 23.5262C22.0333 23.6027 21.9089 23.6219 21.9089 23.6219L21.9185 23.6793C21.9714 23.7224 22.0257 23.7639 22.0812 23.8037C22.0237 23.8516 21.9567 23.8707 21.9567 23.8707L21.9759 23.909L22.1099 23.8133C22.1561 23.8313 22.2043 23.8442 22.2534 23.8516V23.8133L22.1386 23.7941V23.7846C22.1864 23.7463 22.2534 23.641 22.2534 23.641V23.5644C22.2534 23.5644 22.2151 23.5644 22.1673 23.5262C22.3108 23.4305 22.3108 23.3826 22.3108 23.3826L22.3396 23.3348C22.3396 23.3348 22.2917 23.3156 22.2534 23.2391C22.3318 23.2337 22.4091 23.2176 22.4831 23.1912L22.5022 23.1721C22.5022 23.1721 22.4448 23.0859 22.4161 22.9807L22.6458 23.0285L22.6841 22.9902C22.6841 22.9902 22.6554 22.9041 22.6458 22.7988L22.8851 22.8275L22.9138 22.7988C22.9138 22.7988 22.8372 22.6553 22.8372 22.5787V22.5691H23.1435L23.1626 22.5309C23.1626 22.5309 23.0669 22.4639 23.0286 22.416V22.416ZM22.2247 23.6027C22.2247 23.6027 22.196 23.6793 22.129 23.7559L22.1003 23.775C22.0872 23.7694 22.0744 23.763 22.062 23.7559C21.9854 23.708 21.9663 23.6602 21.9663 23.6602L22.1577 23.5357L22.2247 23.6027V23.6027ZM22.2917 23.3635L22.1481 23.507C22.1376 23.495 22.128 23.4822 22.1194 23.4687C22.0524 23.3826 21.9663 23.3156 21.9759 23.1816C21.9759 23.1816 22.0237 23.2773 22.1386 23.2678L22.2151 23.2486C22.2438 23.3252 22.2917 23.3635 22.2917 23.3635ZM22.4448 23.1721L22.2534 23.2199C22.2466 23.2106 22.2402 23.201 22.2343 23.1912C22.196 23.0668 22.196 22.885 22.196 22.885C22.196 22.885 22.2821 22.9424 22.3874 22.9711L22.4448 23.1625V23.1721ZM22.4161 22.9424C22.397 22.8371 22.4161 22.7223 22.4161 22.7223C22.4161 22.7223 22.4831 22.7797 22.5979 22.7988C22.5979 22.9041 22.6171 22.9615 22.6171 22.9615L22.4161 22.9424ZM22.8563 22.7701C22.8563 22.7701 22.7894 22.7988 22.6458 22.7797C22.639 22.6905 22.639 22.6009 22.6458 22.5117C22.6649 22.5117 22.7415 22.55 22.8181 22.5596V22.5691C22.8218 22.6375 22.8347 22.7051 22.8563 22.7701V22.7701ZM22.8563 22.5309H22.8372V22.3299C22.8372 22.3299 22.9138 22.349 22.9712 22.3394C22.9808 22.3777 22.9712 22.3873 23.0095 22.4352C23.0382 22.4926 23.0956 22.5309 23.0956 22.5309C23.0956 22.5309 22.9138 22.55 22.8468 22.5309H22.8563ZM22.2821 23.9664L22.263 23.9185C22.263 23.9185 22.196 23.9664 22.1673 24.0238C22.1609 24.0243 22.1545 24.0243 22.1481 24.0238L21.995 23.9568L22.0142 23.9855L22.1577 24.043L22.129 24.1578L22.1481 24.1865C22.1481 24.1865 22.1481 24.11 22.1864 24.0525H22.2821L22.263 24.1195C22.253 24.1577 22.2434 24.196 22.2343 24.2344L22.263 24.2535H22.4257L22.397 24.2248H22.3396C22.311 24.2207 22.282 24.2207 22.2534 24.2248L22.2821 24.1291L22.3013 24.0717L22.2821 24.0143L22.196 24.0238L22.2726 23.9568L22.2821 23.9664ZM21.4112 23.8611C21.4739 23.8663 21.5338 23.8896 21.5835 23.9281V23.8803C21.5835 23.8803 21.5069 23.7846 21.4208 23.7846C21.3251 23.7846 21.2294 23.8707 21.2294 23.8707V23.9664C21.2294 23.9664 21.3155 23.8611 21.4112 23.8611V23.8611ZM22.4257 25.3445C22.33 25.3924 22.2151 25.3924 22.2151 25.3924L22.2821 25.268C22.4735 25.2201 22.5118 25.0861 22.5118 25.0861L22.5022 25.0383C22.5022 25.0383 22.4544 25.1627 22.2917 25.2297L22.3491 24.9809L22.3013 24.9617C22.3013 24.9617 22.2247 25.0574 22.1481 25.0861C22.1806 25.0203 22.2001 24.9488 22.2056 24.8756L22.1864 24.8373C22.1864 24.8373 22.129 24.8851 22.0524 24.8947H22.0046C22.0524 24.8373 22.1386 24.6555 22.1386 24.6555L22.129 24.6172C22.129 24.6172 22.062 24.7799 21.995 24.8564L21.9663 24.8852C21.9097 24.865 21.8552 24.8393 21.8036 24.8086V24.8373C21.8036 24.8373 21.8706 24.8852 21.9472 24.9139L21.8515 25.0096V25.0861L22.0812 25.1148C22.0417 25.1789 21.9896 25.2342 21.928 25.2775L21.9567 25.3254C21.9567 25.3254 22.062 25.3254 22.2438 25.2775C22.196 25.3732 22.1481 25.4211 22.1481 25.4211C22.1481 25.4211 22.3204 25.4307 22.4353 25.3732C22.5501 25.3158 22.5884 25.2584 22.5884 25.2584L22.5501 25.2201C22.5501 25.2201 22.531 25.3062 22.4257 25.3445V25.3445ZM21.8993 25.0287L21.995 24.9234C22.1099 24.9521 22.1481 24.9139 22.1481 24.9139C22.1481 24.9139 22.1673 24.9809 22.1003 25.0861C22.0338 25.0773 21.9692 25.0579 21.9089 25.0287H21.8993ZM22.0046 25.268L22.1003 25.1435C22.1105 25.1346 22.1201 25.125 22.129 25.1148C22.2438 25.1148 22.3108 25.0191 22.3108 25.0191C22.3108 25.0191 22.3204 25.1148 22.2726 25.2297C22.1194 25.2871 22.0046 25.268 22.0046 25.268V25.268ZM21.861 24.5119C21.9759 24.5215 22.1099 24.5693 22.1099 24.5693L22.1003 24.5119L21.8802 24.4736C21.9185 24.3875 21.995 24.3492 21.995 24.3492L21.9567 24.3301C21.9567 24.3301 21.9185 24.3301 21.861 24.4449L21.8419 24.4641C21.8323 24.4636 21.8227 24.4636 21.8132 24.4641C21.7175 24.4641 21.6313 24.5215 21.6313 24.5215L21.6505 24.5502C21.6505 24.5502 21.7366 24.5119 21.8228 24.5119L21.7653 24.7033L21.7845 24.7512L21.861 24.5119V24.5119ZM21.6313 24.043L21.6122 23.9855C21.6122 23.9855 21.4878 23.9473 21.4017 23.9855C21.306 24.0334 21.2485 24.1291 21.2485 24.1291L21.2868 24.2057C21.2868 24.2057 21.3442 24.0908 21.4304 24.0621C21.5069 24.0334 21.6313 24.043 21.6313 24.043V24.043ZM21.861 24.2248L21.7845 24.1865C21.7845 24.1865 21.6601 24.2152 21.6122 24.2631C21.5644 24.3109 21.5261 24.4258 21.5452 24.4545C21.5548 24.4928 21.5931 24.5119 21.5931 24.5119C21.5931 24.5119 21.6122 24.3875 21.6792 24.3301C21.7366 24.2727 21.861 24.2248 21.861 24.2248ZM21.5739 24.1865C21.6122 24.1387 21.7079 24.1195 21.7079 24.1195L21.6601 24.0717C21.6601 24.0717 21.5452 24.0908 21.4878 24.1387L21.3538 24.3014L21.4208 24.3684L21.5644 24.1865H21.5739ZM21.9567 20.7603C22.0237 20.6838 22.0812 20.6838 22.1003 20.6838H22.1577C22.1263 20.744 22.1038 20.8085 22.0907 20.8752C22.0716 20.9518 22.0429 20.9709 22.0142 21.0187C21.9854 21.0666 21.928 21.1623 21.9185 21.2389C21.9185 21.3154 21.9376 21.3537 21.9663 21.3633C21.9854 21.3633 22.0142 21.325 22.0142 21.3154C22.0142 21.2867 21.995 21.3154 21.9759 21.3154C21.9567 21.3154 21.9759 21.2867 21.9567 21.2389C21.9567 21.191 22.0142 21.0666 22.0333 21.0283C22.062 20.99 22.1099 20.9326 22.1194 20.8752C22.1194 20.8082 22.1673 20.6838 22.1673 20.6838C22.1673 20.6742 22.1386 20.6646 22.0716 20.6646C22.0427 20.6672 22.0148 20.6763 21.9899 20.6912C21.965 20.7061 21.9439 20.7265 21.928 20.7508C21.8897 20.7986 21.794 20.8369 21.794 20.8369C21.794 20.8369 21.8993 20.8369 21.9567 20.7603V20.7603Z"
          fill="white"
        />
        <path
          d="M22.3395 21.5164H22.148L22.1959 21.6599L22.3395 21.5164ZM22.1098 21.5164L22.0715 21.4781C22.0637 21.4669 22.054 21.4572 22.0428 21.4494L21.9758 21.4973L21.9375 21.6408L21.9566 21.6599L22.1098 21.5068V21.5164ZM22.0811 21.8992L21.9471 21.6887L21.8705 21.8514L21.9088 21.8705L22.0045 21.8801L22.0811 21.8896V21.8992ZM22.6553 25.3158H22.6457C22.5377 25.3875 22.4116 25.4273 22.282 25.4307C22.2055 25.4307 22.1098 25.4115 22.0236 25.3637C21.9711 25.3292 21.9309 25.2789 21.9088 25.2201C21.8609 25.134 21.8514 25.0287 21.8322 24.9234C21.8179 24.8227 21.7855 24.7255 21.7365 24.6363C21.6791 24.5406 21.5643 24.4736 21.4494 24.3875C21.3884 24.3387 21.3382 24.2778 21.302 24.2086C21.2657 24.1394 21.2443 24.0635 21.2389 23.9855C21.238 23.9664 21.238 23.9472 21.2389 23.9281C21.2433 23.8085 21.2727 23.6912 21.325 23.5836C21.3633 23.4879 21.4111 23.3922 21.4111 23.3156V23.2773C21.392 23.2199 21.3346 23.1721 21.2963 23.1338L21.2006 23.0764L21.124 23.0476V23.0764L21.191 23.0955V23.0859V23.0955C21.2249 23.1149 21.2569 23.1373 21.2867 23.1625C21.3346 23.2008 21.3729 23.2391 21.3824 23.2869V23.3156C21.3824 23.3826 21.3441 23.4687 21.2963 23.574C21.2437 23.6849 21.2144 23.8054 21.2102 23.9281C21.2079 24.0203 21.2275 24.1118 21.2675 24.195C21.3074 24.2782 21.3665 24.3507 21.4398 24.4066C21.5547 24.5023 21.6695 24.5598 21.727 24.6555C21.7844 24.7512 21.7939 24.8947 21.8227 25.0383C21.8418 25.1053 21.8514 25.1723 21.8801 25.2297C21.9088 25.2967 21.9471 25.3445 22.0141 25.3828C22.0951 25.4315 22.1875 25.4579 22.282 25.4594C22.5021 25.4594 22.6648 25.3349 22.6648 25.3349L22.6553 25.3158V25.3158Z"
          fill="#78732E"
        />
        <path
          d="M22.483 24.9426L22.3873 24.9617C22.3368 24.961 22.2887 24.9404 22.2533 24.9043C22.1959 24.8469 22.1768 24.799 22.1672 24.732C22.1576 24.665 22.1385 24.5789 22.1002 24.4736C22.0523 24.3684 21.9375 24.2822 21.8227 24.1961C21.727 24.11 21.6217 24.0238 21.6025 23.9377C21.601 23.9218 21.601 23.9058 21.6025 23.8898C21.6025 23.8133 21.6313 23.7367 21.66 23.641C21.6982 23.5549 21.7365 23.4496 21.7365 23.3348V23.2773C21.7174 23.1242 21.593 23.0094 21.4877 22.9328C21.4185 22.8895 21.3447 22.8542 21.2676 22.8275V22.8467H21.2771C21.3154 22.8658 21.4207 22.9137 21.5164 22.9902C21.6121 23.0572 21.6887 23.1529 21.7078 23.2773V23.3348C21.7078 23.4496 21.6791 23.5453 21.6408 23.6315C21.6121 23.7272 21.5738 23.8037 21.5738 23.8898C21.5725 23.9058 21.5725 23.9218 21.5738 23.9377C21.6025 24.043 21.7078 24.1291 21.8131 24.2152C21.9184 24.3014 22.0332 24.3875 22.0715 24.4832C22.1193 24.5885 22.1289 24.6746 22.1385 24.732C22.1486 24.8046 22.1822 24.8718 22.2342 24.9234C22.2916 24.9713 22.3395 24.9904 22.3873 24.9904C22.4275 24.992 22.4674 24.9821 22.5021 24.9617L22.483 24.9426V24.9426Z"
          fill="#78732E"
        />
        <path
          d="M23.1817 24.3588C23.1817 24.3588 23.3253 24.3875 23.3157 24.4928C23.3157 24.6076 23.2583 24.7512 23.2583 24.7512L23.0669 24.5885L23.1722 24.4928L23.2104 24.4449L23.1913 24.3492L23.1817 24.3588Z"
          fill="#A8AC71"
        />
        <path
          d="M20.8941 23.0476C20.8941 23.0476 20.7601 23.0955 20.7314 23.0381C20.7123 22.9807 20.7218 22.9424 20.7218 22.9232C20.7218 22.9137 20.6357 22.9041 20.6453 22.8275C20.6453 22.751 20.741 22.7605 20.7697 22.7605C20.7888 22.7605 20.7984 22.6457 20.8654 22.6457C20.9324 22.6457 20.9611 22.7318 20.9611 22.7318L20.8941 23.0476V23.0476Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M21.038 23.0859C21.038 23.0859 20.9327 23.1433 20.8944 23.0859C20.8561 23.0381 20.8944 22.9615 20.8848 22.9519C20.8657 22.9424 20.7987 22.9137 20.8179 22.8562C20.8179 22.7797 20.8944 22.8084 20.9136 22.7892C20.9423 22.7797 20.9614 22.684 21.038 22.6935C21.105 22.7127 21.1145 22.7701 21.1145 22.7701L21.038 23.0859V23.0859Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M21.2291 23.1146C21.2291 23.1146 21.2004 23.1816 21.1143 23.1625C21.0377 23.1529 21.0664 23.0381 21.0473 23.0189C21.0377 22.9998 20.9803 22.9807 20.9898 22.9041C20.9994 22.8371 21.076 22.8467 21.1047 22.8371C21.1238 22.8275 21.1525 22.7127 21.2004 22.7318C21.2578 22.7414 21.3152 22.8084 21.2961 22.8371C21.2961 22.8371 21.1908 22.8754 21.1717 22.9519C21.1621 23.0285 21.2291 23.1146 21.2291 23.1146Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.9903 24.3301L22.818 24.1291L22.6458 23.9185L22.4735 23.8324L22.3587 23.6506V23.44L22.3969 23.3156L22.4639 23.2199C22.4639 23.2199 22.1098 23.3539 22.2917 24.0334C22.3682 24.3205 22.5596 24.3588 22.5596 24.3588L22.885 24.3396L22.9807 24.3301H22.9903Z"
          fill="#AF7029"
        />
        <path
          d="M22.8277 22.0715C22.8565 22.0715 22.8756 22.0715 22.8852 22.0906L22.8947 22.1481C22.8951 22.1544 22.8951 22.1608 22.8947 22.1672L22.9043 22.1768C22.7799 22.4352 22.5311 22.5596 22.311 22.7127C22.1966 22.7917 22.099 22.8925 22.0238 23.0094C21.9272 23.1673 21.8805 23.3508 21.8899 23.5358C21.8994 23.9186 22.043 24.1387 22.2057 24.244C22.3247 24.3236 22.4644 24.3668 22.6076 24.3684H22.6363L22.7512 24.3588C22.8274 24.3492 22.9041 24.3428 22.9809 24.3397C23.0257 24.3394 23.0705 24.3426 23.1149 24.3492C23.1531 24.3492 23.1723 24.3684 23.1819 24.3779C23.1929 24.3878 23.1998 24.4015 23.201 24.4162C23.201 24.4449 23.1819 24.4832 23.1531 24.5119L23.0861 24.5598V24.5885L23.1723 24.5311C23.201 24.4928 23.2201 24.4641 23.2201 24.4162C23.2188 24.3987 23.2121 24.382 23.201 24.3684C23.1819 24.3492 23.1531 24.3397 23.1149 24.3301C23.0705 24.3236 23.0257 24.3204 22.9809 24.3205L22.6363 24.3397V24.3588V24.3397C22.63 24.3398 22.6236 24.3398 22.6172 24.3397C22.5502 24.3397 22.3779 24.3397 22.2248 24.2248C22.0717 24.1291 21.9281 23.9186 21.9186 23.5358V23.507C21.9186 23.2965 21.9664 23.1434 22.0334 23.0285C22.1483 22.8371 22.3205 22.7414 22.4928 22.617C22.6651 22.5022 22.8277 22.3873 22.9139 22.1863C23 21.9854 22.9139 22.1672 22.9139 22.1481L22.9043 22.0811C22.8947 22.0619 22.866 22.0428 22.8277 22.0428V22.0715V22.0715Z"
          fill="#816C2A"
        />
        <path
          d="M23.3062 24.4354C23.3062 24.4354 23.2104 24.5885 23.1913 24.5981C23.1722 24.5981 23.2679 24.6172 23.287 24.6555L23.2679 24.6938C23.2679 24.6938 23.1722 24.6268 23.1243 24.6268L23.1147 24.5693C23.1147 24.5693 23.1626 24.5502 23.2009 24.5119C23.2296 24.4832 23.2679 24.4067 23.2679 24.3875L23.2966 24.4354H23.3062Z"
          fill="white"
        />
        <path
          d="M23.6313 24.5406L23.4208 24.5981L23.3155 24.5311C23.3155 24.5311 23.3155 24.4449 23.2772 24.4066C23.2294 24.3684 23.2007 24.3588 23.1528 24.3397C23.1146 24.3205 22.9614 24.3205 22.9614 24.3205L22.5786 23.909L22.7222 23.9281L22.9519 23.8994L23.1528 23.8803L23.2677 23.8994L23.3825 23.9281L23.4399 23.9856L23.5069 24.043L23.5739 24.1387L23.6122 24.2631L23.6313 24.3875V24.5406V24.5406Z"
          fill="#FCCA3D"
        />
        <path
          d="M23.6411 24.5215C23.6411 24.5215 23.5646 24.5502 23.4688 24.5502C23.3731 24.5502 23.3157 24.5311 23.3157 24.5311L23.2966 24.598L23.2583 24.6938V24.9426L23.4593 24.9809L23.5646 24.9426L23.622 24.6746L23.6315 24.5311L23.6411 24.5215Z"
          fill="#AF7029"
        />
        <path
          d="M23.5837 24.4258V24.5215H23.6315V24.4449L23.5837 24.4258ZM23.3923 22.1289L23.3731 21.9662L23.3062 21.8514L23.22 21.7365L23.1339 21.6408L23.086 21.593L23.0669 21.5643L22.8468 21.5738L22.7319 21.7078C22.7319 21.7078 23.019 21.9184 23.1435 22.1481C23.2392 22.1768 23.3157 22.2438 23.354 22.282L23.3636 22.2629L23.3923 22.1289V22.1289Z"
          fill="#FCCA3D"
        />
        <path
          d="M23.1814 22.3203C23.1814 22.483 23.1527 22.5691 23.124 22.6074L23.258 22.4543L23.3537 22.282C23.2948 22.2217 23.2228 22.1758 23.1432 22.148C23.1623 22.2055 23.1814 22.2629 23.1814 22.3203V22.3203Z"
          fill="#AF7029"
        />
        <path
          d="M23.4877 24.8373L23.3824 24.7129L23.2867 24.6459L23.2676 24.665H23.2771L23.3729 24.732C23.4073 24.7715 23.4393 24.813 23.4686 24.8565L23.4877 24.8373Z"
          fill="#816C2A"
        />
        <path
          d="M23.622 24.6555C23.622 24.6555 23.6028 24.732 23.5263 24.799C23.4497 24.866 23.354 24.9043 23.354 24.9043L23.5646 24.9904L23.7081 24.8564L23.6124 24.6555H23.622Z"
          fill="#6F5B24"
        />
        <path
          d="M23.6506 24.8373L23.6314 24.8564L23.5932 24.8947L23.5645 24.933L23.6219 24.7033L23.6602 24.7703V24.8086L23.6506 24.8373Z"
          fill="#404118"
        />
        <path
          d="M22.3775 21.8801C22.3775 21.8801 22.0904 21.9088 21.8799 21.8801C21.6885 21.8418 21.7268 21.3154 21.7172 21.3059C21.7172 21.2867 21.5928 21.1623 21.6215 21.0475C21.6406 20.9326 22.0043 20.6264 22.0617 20.6072C22.1 20.5977 22.1766 20.6264 22.1766 20.6264C22.1766 20.6264 22.2723 20.5307 22.301 20.5307C22.3297 20.5307 22.368 20.5881 22.3584 20.6072C22.3393 20.6359 22.2148 20.7029 22.2053 20.7699C22.1957 20.8273 22.2053 20.8848 22.167 20.9422C22.1287 20.9996 22.0617 21.0762 22.0522 21.124C22.0426 21.1719 22.0234 21.2197 22.0522 21.2293C22.0904 21.2484 22.2148 21.2293 22.3201 21.1815C22.4254 21.1336 22.4732 21.0762 22.4828 21.0857C22.502 21.0857 22.4254 21.2102 22.3106 21.258C22.1861 21.3059 22.1191 21.3633 22.0522 21.3537C22.0522 21.3537 21.9947 21.5068 22.1861 21.5164C22.3871 21.526 22.502 21.4781 22.502 21.4781L22.3775 21.8801V21.8801Z"
          stroke="#78732E"
          strokeWidth="0.0191406"
        />
        <path
          d="M24.9042 19.6885C24.9042 19.6885 24.3587 19.5928 24.3683 20.033C24.3683 20.1766 24.4066 20.2244 24.5118 20.2531C24.6267 20.2818 24.8564 20.301 25.0478 20.4732C25.2392 20.6455 25.2583 20.7699 25.2583 20.8752C25.2583 20.9709 25.2105 21.0666 25.2105 21.0666L25.3349 21.66L25.4497 22.1002L25.8134 21.8896L26.0335 21.2389L25.756 20.0713L24.8947 19.6885H24.9042Z"
          fill="#AB6D29"
          stroke="#4D2A15"
          strokeWidth="0.0287109"
        />
        <path
          d="M25.4305 21.9375C25.4305 21.9375 25.6219 21.8609 25.6697 21.7078C25.6697 21.6695 25.4783 21.4877 25.4783 21.4877L25.6219 21.5834C25.6697 21.6312 25.7176 21.6504 25.7176 21.6408C25.7463 21.6408 25.8324 21.4398 25.7941 21.392C25.7654 21.3537 25.708 21.2484 25.6314 21.2006C25.5549 21.1432 25.4496 21.1527 25.4496 21.1527C25.4496 21.1527 25.5932 21.1049 25.6697 21.1527C25.7367 21.1814 25.7463 21.2293 25.7559 21.2101C25.7563 21.1124 25.7401 21.0153 25.708 20.923C25.6697 20.8656 25.641 20.8273 25.5549 20.8178C25.4592 20.7986 25.373 20.8082 25.373 20.8082C25.373 20.8082 25.4975 20.7316 25.5932 20.7603C25.6889 20.7795 25.6889 20.8273 25.6889 20.8178C25.6757 20.7419 25.6532 20.668 25.6219 20.5977C25.5786 20.5386 25.5231 20.4897 25.4592 20.4541L25.3252 20.435H25.2773C25.2773 20.435 25.3443 20.3871 25.44 20.3967C25.5357 20.4062 25.5357 20.435 25.5453 20.435C25.5645 20.435 25.5453 20.4158 25.4783 20.3775C25.3723 20.3214 25.2638 20.2703 25.1529 20.2244H24.9137C24.9137 20.2244 24.9137 20.1574 24.9807 20.1478C25.0477 20.1383 25.0764 20.1478 25.0668 20.1383C25.0668 20.1191 24.8563 20.0713 24.8563 20.0713H24.6936L24.4639 20.1L24.5117 20.033C24.5404 20.0043 24.5883 19.9947 24.617 19.9852C24.7031 19.966 24.5787 19.899 24.5787 19.899L24.6361 19.8033L24.9424 19.8225L25.5645 20.1957L25.8611 20.4445L26.0525 20.923L25.9951 21.7461L25.574 22.0906L25.3826 22.1098L25.4305 21.9375V21.9375Z"
          fill="#4D2A15"
        />
        <path
          d="M24.8852 19.899C24.8852 19.899 24.866 19.8416 24.866 19.765V19.698C24.866 19.698 24.6746 19.6693 24.5311 19.7842C24.378 19.899 24.4641 20.1 24.4641 20.1C24.4641 20.1 24.5311 20.0426 24.6076 20.0043C24.6938 19.9756 24.8373 19.9852 24.8373 19.9852C24.8565 19.966 24.8086 19.9086 24.7512 19.899L24.5885 19.8895C24.5885 19.8895 24.6555 19.8416 24.7608 19.8512C24.866 19.8607 24.8852 19.899 24.8852 19.899V19.899Z"
          fill="#D2A567"
        />
        <path
          d="M25.5072 22.0045L25.3732 22.0523L25.4593 22.6266L26.0048 23.5549L26.2919 23.507L26.3876 23.3348L26.4546 23.3635C26.4929 23.4017 26.5982 23.5836 26.6843 23.6219C26.78 23.6506 26.8183 23.641 26.9044 23.708C26.981 23.7654 27.2777 24.2057 27.2873 24.2152C27.3064 24.2344 27.2681 24.0334 27.2681 24.0334L27.182 23.775L27.0767 23.5932L27.0576 23.5453H27.2011L27.2968 23.6027L27.4404 23.7271L27.5169 23.8133L27.5552 23.909L27.5744 23.9855L27.6126 24.1099L27.6892 24.2726L27.7849 24.4353L27.8136 24.3779L27.7658 24.1865L27.6222 23.7176L27.5265 23.5644L27.6796 23.6601C27.7179 23.6601 27.8232 23.8324 27.8232 23.8324L27.8902 23.9951L27.938 24.1482L27.9763 24.2822L28.0242 24.4258L28.1103 24.3779L28.0912 24.2726L28.0146 23.9473L27.9859 23.6027C27.9859 23.6027 28.0242 23.6027 28.0816 23.6601C28.1294 23.7176 28.1773 23.842 28.1773 23.842L28.206 24.1482L28.2539 24.4353L28.3496 24.7224L28.4453 24.9139L28.5123 25.0096V24.866L28.3974 23.641L28.407 23.5932C28.407 23.5932 28.4261 23.5836 28.4644 23.641L28.5505 23.7846L28.5792 23.976L28.5984 24.1099L28.6271 24.3588L28.6558 24.6267L28.7802 24.9139L28.8472 25.0765L28.8855 24.8851L28.8281 23.5836L28.8568 23.5453L28.9525 23.641L29.0099 23.7176L29.0578 24.0047L29.0865 24.8373L29.1152 25.0478L29.364 22.8849L29.5076 22.8562L29.5267 22.8084L29.4214 22.7318L29.1726 22.349L29.0099 21.9758L28.7228 21.4398L28.2156 20.8273L27.8232 20.5019L27.6796 20.4062L27.6988 20.3201L27.7849 20.1861H27.7083L27.5361 20.2148L27.3638 20.1574L27.0289 19.9277L26.6748 19.7555L26.4642 19.6789L25.957 19.5545L25.4498 19.4875H25.2296L25.0191 19.5162C25.0191 19.5162 24.9234 19.5641 24.8851 19.631C24.8468 19.6885 24.8468 19.7363 24.8564 19.832C24.866 19.9277 24.9234 19.9756 25.0669 20.033C25.2105 20.0904 25.5455 20.3201 25.5455 20.3201L25.6986 20.4732L25.756 20.5498L25.7656 20.6072L25.8804 21.4685L25.6603 21.9279L25.5072 22.0045V22.0045Z"
          fill="#8F4620"
        />
        <path
          d="M26.0527 23.3348C26.0527 23.3348 26.1484 23.4879 26.2729 23.3635C26.4068 23.2486 26.2154 22.9041 26.225 22.885C26.225 22.8658 26.2824 22.8563 26.2824 22.8563L26.3781 23.0381C26.3781 23.0381 26.4355 23.1338 26.4068 23.2774C26.3877 23.4305 26.2441 23.5645 26.2441 23.5645L26.0814 23.5166L26.0527 23.3252V23.3348Z"
          fill="#AB6D29"
        />
        <path
          d="M29.23 25.3254L29.1151 24.9808L29.0769 24.7129L29.0481 23.9951C29.0386 23.8994 29.0481 23.775 29.029 23.7558L28.9046 23.5836L28.8567 23.5357L28.8854 23.507C28.8854 23.507 28.9333 23.5549 28.9429 23.5357C28.9524 23.507 28.9429 23.3826 28.895 23.1912C28.8472 22.9998 28.6079 22.55 28.6079 22.55L28.627 22.5787L28.694 22.6457L28.8376 22.7605L29.1534 22.8754L29.3161 22.9041L29.431 23.1242C29.431 23.1242 29.5075 23.4974 29.4979 23.6889C29.4979 23.8803 29.4884 24.0334 29.4118 24.2248C29.3353 24.4162 29.3161 25.0096 29.3161 25.1053L29.2683 25.2967L29.23 25.3254V25.3254Z"
          fill="#4D2A15"
        />
        <path
          d="M29.2302 24.3301C29.2302 24.3301 29.2972 24.2439 29.3259 24.1387C29.3546 24.043 29.3642 23.1912 29.2685 23.0859C29.1779 23.0048 29.0698 22.9459 28.9526 22.9137L29.0292 23.1912L29.0962 23.2869L29.144 23.4305C29.144 23.4975 29.211 23.6697 29.2206 23.8898L29.2302 24.3205V24.3301Z"
          fill="#8F4620"
        />
        <path
          d="M28.7705 24.8469C28.7705 24.8469 28.8184 24.4545 28.7992 24.1674C28.7801 23.8803 28.7514 23.842 28.7227 23.7846C28.6423 23.6322 28.5782 23.4718 28.5312 23.3061C28.4643 23.0572 28.4164 22.8754 28.3781 22.8275C28.3303 22.7797 28.2441 22.6744 28.225 22.7031C28.2059 22.7318 28.2059 22.7893 28.2059 22.7893L28.0814 22.7605L28.0527 22.684L28.091 22.5596V22.5021L28.0719 22.416L28.225 22.5404L28.5408 22.751L28.7035 23.4209L28.8471 23.8229L28.8662 24.5119L28.8566 25.1244L28.7705 24.8469V24.8469ZM28.9619 22.9615L29.0863 23.0572C29.1342 23.0955 29.2299 23.1529 29.2107 23.1529L29.0576 23.0955L28.9619 23.0285V22.9615V22.9615Z"
          fill="#4D2A15"
        />
        <path
          d="M28.3498 24.6938C28.3498 24.6938 28.4073 24.5598 28.3977 24.3779C28.3881 24.2057 28.302 23.775 28.2733 23.7271C28.2446 23.6697 28.1202 23.5932 28.0149 23.3443C27.9 23.1146 27.9096 23.0572 27.833 22.9807C27.7809 22.9178 27.7298 22.8539 27.6799 22.7893L27.7086 22.5309L27.9766 22.6744L28.101 22.7318L28.235 23.4018L28.3594 23.5932L28.4168 23.8516L28.4838 24.4736L28.5125 24.9713L28.4934 25.0191L28.3403 24.6938H28.3498ZM28.0245 24.4066C28.0245 24.4066 28.0245 24.2152 27.9862 24.043C27.9383 23.8611 27.8905 23.7367 27.8426 23.6793C27.7257 23.5617 27.62 23.4336 27.5268 23.2965C27.4352 23.1634 27.3361 23.0356 27.2301 22.9137V22.6553L27.3928 22.7701C27.451 22.8007 27.5084 22.8326 27.5651 22.8658L27.6416 23.1529L27.7373 23.3539L27.8713 23.5453L27.967 23.6219L28.0149 23.9281L28.0436 24.1004L28.1202 24.3492L28.0914 24.4736L28.0245 24.4162V24.4066ZM27.7948 24.4066L27.7182 24.3396C27.7182 24.3396 27.7661 24.2918 27.7469 24.1961C27.7182 24.1004 27.6991 24.0047 27.6512 23.909C27.6034 23.8133 27.5938 23.7559 27.5651 23.7271C27.4559 23.6224 27.3442 23.5203 27.2301 23.4209L26.943 23.1721C26.8664 23.1242 26.809 23.1146 26.809 23.1146L26.7707 22.8084C26.7707 22.8084 26.8664 22.9424 26.9334 22.9615L27.0866 23.0189L27.3067 23.4018L27.3832 23.4975L27.5746 23.6602L27.6608 23.8229L27.7182 24.0143L27.7948 24.2727L27.8139 24.4354L27.7948 24.4162V24.4066ZM27.3737 24.3301C27.3737 24.3301 27.2493 24.1865 27.2205 24.0908C27.2014 23.9951 27.2397 23.9951 27.2014 23.8898C27.1373 23.7493 27.0385 23.6275 26.9143 23.5357C26.809 23.44 26.6559 23.3156 26.6655 23.2486C26.6655 23.1816 26.6942 23.1721 26.6942 23.1721L26.7612 23.2295L27.0961 23.5932L27.2014 23.7846L27.2875 24.0238L27.3354 24.1291L27.3832 24.2727L27.3737 24.3301V24.3301ZM28.5987 22.55C28.5987 22.55 28.8379 22.8371 28.8954 22.5691C28.9241 22.4543 28.8188 22.2246 28.8188 22.2246L28.5317 21.7461L28.0819 21.191L27.8139 21.0666L27.9096 21.2197C27.9096 21.2197 28.101 21.4111 28.3594 21.8609C28.6178 22.3012 28.5604 22.5309 28.5604 22.5309L28.5987 22.55V22.55ZM27.2397 20.7891C27.2397 20.7891 27.7086 21.191 28.0053 21.6217C28.302 22.0523 28.4264 22.3395 28.3594 22.3873C28.2924 22.4543 28.101 22.3586 28.0245 22.2437C27.9479 22.1193 27.8809 21.9088 27.6034 21.5834C27.3162 21.258 27.1823 21.2102 27.1823 21.2102L26.9717 20.8848L27.2397 20.7891V20.7891ZM26.9909 21.7461C26.9909 21.7461 27.278 21.9758 27.4407 22.1576C27.5379 22.2593 27.6275 22.3681 27.7086 22.483L27.8139 22.5883C27.8139 22.5883 27.7565 22.4734 27.7948 22.4352C27.8235 22.3969 27.8713 22.416 27.8713 22.416L26.9909 21.4877V21.7461V21.7461ZM26.9334 21.7652C26.9334 21.7652 27.0291 21.9375 27.1727 22.0811C27.274 22.1807 27.3761 22.2796 27.4789 22.3777L27.5459 22.6074C27.5459 22.6074 27.144 22.3012 27.144 22.3777C27.1613 22.4596 27.1937 22.5375 27.2397 22.6074L27.1153 22.5404L26.943 22.3012L26.8473 22.0811L26.7325 21.7939L26.9334 21.7652Z"
          fill="#4D2A15"
        />
        <path
          d="M25.7275 22.7223C25.7275 22.7223 25.9381 22.9137 26.0529 22.7223C26.1678 22.5404 26.0721 22.3394 26.0721 22.3394C26.0721 22.3394 26.3688 22.7701 26.4549 22.3586C26.4645 22.282 26.273 22.0045 26.273 22.0045L26.34 21.9375L26.4932 22.1863C26.4932 22.1863 26.6367 22.1289 26.6367 21.9566C26.6367 21.7844 26.4836 21.5547 26.4836 21.5547L26.6271 21.7078C26.6271 21.7078 26.8951 21.7078 26.9047 21.5451C26.9047 21.3824 26.675 21.2101 26.675 21.2101C26.675 21.2101 26.8664 21.2197 26.8664 21.1144C26.8568 20.9996 26.608 20.923 26.5984 20.856C26.5984 20.7891 26.675 20.6742 26.7898 20.7412C26.9047 20.7986 27.0578 20.856 27.1248 20.7316C27.1918 20.6072 27.1248 20.5785 27.1248 20.5785L26.9621 20.5402L26.6941 20.4062L26.4932 20.3297L26.2826 20.301L26.3592 20.4637L26.4166 20.8943V21.0953L26.4549 21.5355L26.3592 21.8992L26.2922 21.9662L26.2539 22.0141L26.1582 22.2055L26.0434 22.349L25.8807 22.5596L25.7275 22.7223V22.7223Z"
          fill="#4D2A15"
        />
        <path
          d="M27.2013 23.5357C27.2013 23.5357 27.1534 23.4113 27.0386 23.3156C26.9237 23.2295 26.7515 23.2199 26.7515 23.2199L27.0577 23.5453H27.2013V23.5357ZM27.6319 23.6123C27.6319 23.6123 27.5362 23.4209 27.4214 23.2965C27.3065 23.1721 27.23 23.0094 27.1917 23.0094L27.1438 23.0189L27.1726 23.2678L27.3831 23.4783C27.3831 23.4783 27.5745 23.6219 27.6319 23.6123V23.6123ZM27.986 23.5932C27.986 23.5932 27.9382 23.3635 27.8233 23.1434C27.7085 22.9232 27.5745 22.8275 27.5745 22.8275L27.6032 23.0668L27.6989 23.2965L27.8616 23.5262L27.986 23.5932ZM28.2731 23.4687C28.2731 23.4687 28.3593 22.9902 28.2827 22.8658C28.2364 22.7863 28.1608 22.7279 28.0722 22.7031L28.0243 22.7701L28.0722 23.1146L28.1774 23.373L28.2731 23.4687V23.4687ZM28.5603 22.6744C28.5603 22.6744 28.6272 22.7127 28.7134 22.8658C28.7995 23.0285 28.9144 23.507 28.9144 23.5357C28.9144 23.5549 28.8665 23.5453 28.8569 23.5357L28.5698 23.0859L28.5124 22.6744H28.5603Z"
          fill="#AB6D29"
        />
        <path
          d="M26.56 23.2295C26.56 23.2295 26.7132 23.1912 26.7132 23.1338C26.7132 23.0859 26.5218 22.9807 26.5409 22.8945C26.5505 22.8562 26.694 22.9041 26.7036 22.8754C26.7227 22.8467 26.56 22.5883 26.6079 22.5308C26.6557 22.4734 26.7993 22.8084 26.7993 22.8084C26.7993 22.8084 26.8759 22.9615 26.8471 23.0476C26.7514 23.3348 26.56 23.2295 26.56 23.2295V23.2295ZM26.9141 22.8849C26.9141 22.8658 27.1534 22.9137 27.1534 22.8945C27.163 22.8467 26.9428 22.6744 26.9428 22.6744C26.9428 22.6744 26.895 22.5787 26.9141 22.5691C26.9237 22.55 27.0673 22.5787 27.0768 22.5691C27.0768 22.5404 26.9141 22.3203 26.9141 22.282C26.9141 22.2437 26.962 22.282 26.962 22.282C26.962 22.282 27.0864 22.416 27.1534 22.5213C27.23 22.6361 27.297 22.7223 27.2682 22.9041C27.2491 23.0955 26.8854 22.9424 26.9141 22.8849ZM27.9669 22.5404C27.9669 22.5404 27.919 22.3777 27.9477 22.3586L28.0243 22.3203C28.0243 22.3203 27.8999 22.2437 27.8425 22.2437C27.785 22.2437 27.7755 22.2246 27.7659 22.2437C27.7468 22.2724 27.8616 22.4351 27.8616 22.4351L27.9573 22.5308L27.9669 22.5404Z"
          fill="#D2A567"
        />
        <path
          d="M27.2586 22.6553C27.2586 22.6553 27.6127 22.751 27.6222 22.7223C27.6414 22.6936 27.3351 22.416 27.3351 22.416V22.349C27.3351 22.3299 27.4595 22.3299 27.4978 22.3586C27.5265 22.3873 27.4978 22.4543 27.4978 22.4735C27.517 22.4926 27.6318 22.6649 27.651 22.6361C27.6701 22.6074 27.6318 22.3969 27.6414 22.3873C27.6414 22.3682 27.7754 22.5022 27.8041 22.5309C27.8424 22.55 28.0433 22.7031 28.0625 22.6266C28.0816 22.5596 28.0912 22.55 28.0912 22.5022C28.0816 22.4639 28.1486 22.7031 28.0625 22.7319C27.9668 22.7701 27.8615 22.7031 27.8615 22.7031L27.7754 22.6361L27.7275 22.5883C27.7275 22.5883 27.7849 22.7797 27.7275 22.7988C27.6605 22.818 27.584 22.8084 27.584 22.8084L27.4404 22.7893L27.249 22.6553H27.2586ZM28.072 22.416C28.072 22.416 28.4549 22.6457 28.4836 22.6074C28.5218 22.5596 28.3879 22.0332 28.407 21.9758C28.4261 21.9279 28.7133 22.5787 28.5793 22.6649C28.4644 22.7319 28.4166 22.684 28.4166 22.684L28.2252 22.5883L28.072 22.416V22.416ZM29.1248 23.3731L29.2109 23.4113L29.2588 23.4305L29.1535 23.4496L29.1248 23.3731V23.3731ZM28.7611 22.1193L28.8185 22.1481L28.8664 22.1672L28.8185 22.1863C28.8086 22.1843 28.799 22.1811 28.7898 22.1768L28.7611 22.1193ZM28.6463 21.9279C28.6463 21.9279 28.6845 21.9471 28.742 21.9184C28.7994 21.8897 28.7898 21.8514 28.7898 21.8418C28.7898 21.8227 28.7037 21.8227 28.675 21.8035C28.6558 21.7844 28.6558 21.7557 28.6558 21.7557H28.541L28.6463 21.9375V21.9279ZM28.9812 23.0381L29.1343 23.1051C29.1631 23.1051 29.2205 23.1434 29.2109 23.1529C29.2109 23.1625 29.1152 23.1721 29.0769 23.1529C29.0291 23.1242 29.0195 23.1338 29.0195 23.1338L28.9812 23.0381V23.0381ZM28.3592 21.3059H28.4549C28.474 21.325 28.4549 21.4016 28.4261 21.4303L28.3496 21.4686C28.3065 21.4124 28.265 21.3549 28.2252 21.2963L28.3592 21.3059V21.3059ZM27.8136 20.8274L27.9285 20.8178C27.9668 20.8178 28.0146 20.8465 28.0433 20.8656C28.0816 20.8848 28.1103 21.1145 28.0912 21.1527C28.072 21.2006 27.8232 21.0092 27.8136 20.9901C27.8136 20.9709 27.6988 20.7986 27.6988 20.7986L27.8136 20.8178V20.8274ZM27.5744 20.7125C27.5744 20.7125 27.7658 20.7317 27.7467 20.6168C27.7383 20.5465 27.7042 20.4817 27.651 20.435L27.4213 20.5977L27.5744 20.7125V20.7125ZM27.0767 20.502C27.0767 20.502 27.1246 20.5211 27.182 20.502C27.2394 20.4828 27.383 20.2914 27.4883 20.2723C27.5935 20.2436 27.6222 20.2436 27.6414 20.2723C27.6605 20.2914 27.6414 20.4063 27.6222 20.435C27.6031 20.4637 27.2873 20.5977 27.2873 20.5977L27.1724 20.5785L27.0767 20.5498V20.502V20.502ZM27.0193 20.1574C26.9715 20.0426 26.8853 20.0043 26.8566 20.0043C26.8279 20.0139 26.9619 20.1287 26.981 20.2723L27.0002 20.5402H27.0672V20.4924L27.0863 20.4445V20.4063L27.0767 20.3297L27.0576 20.2723L27.048 20.2244L27.0193 20.1574V20.1574ZM26.5791 19.9947C26.4614 19.8694 26.3176 19.7714 26.158 19.7076C26.1388 19.7076 26.4642 19.899 26.5408 20.033C26.6078 20.1479 26.6078 20.3201 26.6365 20.3393C26.6748 20.368 26.7035 20.3393 26.7035 20.3297C26.7035 20.3297 26.7322 20.2914 26.7226 20.2819L26.7035 20.1957L26.6556 20.1192L26.6269 20.0617L26.5791 19.9947ZM26.158 19.8225C25.9349 19.6629 25.6666 19.579 25.3924 19.5832C25.1148 19.5832 24.9808 19.6024 25.0191 19.7555C25.0574 19.899 25.1818 19.9565 25.4019 19.9565C25.6316 19.9565 25.689 19.9373 25.8039 19.9756C25.9187 20.0139 26.0336 20.0713 26.0814 20.1287C26.1197 20.167 25.9857 20.0139 25.8804 19.9373L25.689 19.7938C25.689 19.7938 25.6699 19.7459 25.823 19.7746C25.9761 19.7938 26.1867 19.8895 26.2345 20.0235C26.292 20.1479 26.2824 20.2149 26.2824 20.2531C26.2824 20.2723 26.3398 20.234 26.3398 20.234L26.359 20.167C26.359 20.167 26.3685 20.1192 26.3398 20.0713C26.3111 20.0043 26.3015 19.9852 26.2345 19.9086L26.158 19.8225V19.8225ZM25.4211 22.0045C25.5359 22.0045 25.7847 21.794 25.823 21.4877C25.8218 21.1562 25.7568 20.828 25.6316 20.5211C25.5838 20.4541 25.6986 20.4924 25.7656 20.5498C25.823 20.6168 25.957 21.0475 25.957 21.3633C25.957 21.6791 25.8804 21.7748 25.7177 21.9375C25.5455 22.0906 25.4115 22.0811 25.4115 22.0811L25.4211 22.0045ZM25.8135 22.8945C25.8135 22.8945 25.8709 22.9615 25.9283 22.9424C26.0431 22.8945 26.225 22.8084 26.225 22.6553C26.225 22.5404 26.091 22.4447 26.0814 22.4065V22.3299L26.2058 22.3586L26.2345 22.5309C26.2345 22.5309 26.2824 22.5787 26.3302 22.5596C26.3877 22.5404 26.5217 22.4352 26.5121 22.3299C26.4929 22.2342 26.3494 22.1098 26.3398 22.0619C26.3308 22.0307 26.3308 21.9975 26.3398 21.9662L26.4547 21.9854L26.4929 22.1289C26.4929 22.1289 26.5217 22.1863 26.5886 22.1672C26.6556 22.1576 26.7801 22.0332 26.7513 21.9758L26.6269 21.7748V21.7078L26.6748 21.7365C26.6748 21.7365 26.7131 21.7557 26.8088 21.727C26.8949 21.6983 26.981 21.6313 26.981 21.5738C26.981 21.5164 26.914 21.459 26.9045 21.4207V21.3729L26.9619 21.3824L27.0384 21.4781L27.0576 21.5738L27.0289 21.6695L26.9236 21.794L26.8088 21.8322H26.7801L26.847 21.9471L26.8279 22.1002L26.7322 22.1959L26.5982 22.2629V22.4065L26.5217 22.5596L26.359 22.6553H26.3111L26.292 22.751L26.1963 22.8945L26.0049 23.019L25.8804 23.0381L25.8039 22.9328L25.8135 22.8945V22.8945Z"
          fill="#D2A567"
        />
        <path
          d="M26.7899 21.2772C26.7899 21.2772 27.0866 21.3729 27.077 21.1815C27.077 21.0666 26.7899 20.8273 26.7708 20.7891C26.7516 20.7412 26.7612 20.6934 26.7612 20.6934L26.9047 20.8273C26.9047 20.8273 27.0961 20.8752 27.1536 20.7604C27.2014 20.6551 27.1536 20.5881 27.1536 20.5785H27.1918L27.2875 20.5881L27.2684 20.7604L27.1727 21.1815C27.1727 21.1815 27.2014 21.3441 27.077 21.3633C26.943 21.3633 26.7899 21.2772 26.7899 21.2772V21.2772ZM27.077 23.5357C27.077 23.5357 27.077 23.4496 27.01 23.3922C26.943 23.3348 26.8186 23.2773 26.7995 23.2582C26.8663 23.3501 26.9365 23.4395 27.01 23.5262L27.077 23.5357ZM27.5077 23.5453L27.3163 23.3061C27.2971 23.2391 27.2206 23.1051 27.1536 23.0955C27.0961 23.0955 27.211 23.3252 27.211 23.3252L27.4502 23.5453H27.5077V23.5453ZM27.9192 23.5453L27.7565 23.2295C27.7278 23.1625 27.6608 22.9711 27.5842 22.9137C27.5077 22.8658 27.5842 23.0094 27.5842 23.0094L27.6799 23.2582L27.8139 23.4783L27.9096 23.5453H27.9192ZM28.2159 23.3731C28.2159 23.3731 28.2063 23.1625 28.1776 23.019C28.1609 22.9188 28.1102 22.8276 28.034 22.7606L28.0436 23.019L28.2159 23.3731V23.3731ZM28.8379 23.5262L28.6944 23.1625C28.6514 23.0518 28.5969 22.9459 28.5317 22.8467L28.5604 23.0668L28.6944 23.4305L28.8379 23.5262ZM29.3739 22.8754C29.3739 22.8754 29.2782 22.7797 29.0772 22.6936C28.945 22.6448 28.8063 22.6158 28.6657 22.6074L28.6848 22.6361L28.7805 22.7127L28.9911 22.8275L29.2782 22.8945L29.3739 22.8754V22.8754Z"
          fill="#D2A567"
        />
        <path
          d="M27.1627 22.9902C27.1627 22.9902 27.1627 23.1816 27.2584 23.2869L27.6125 23.641C27.6508 23.6793 27.6891 23.8994 27.7561 24.0812C27.8135 24.2727 27.8326 24.4162 27.8614 24.4641C27.8901 24.5215 27.9475 24.6076 27.9092 24.598C27.8614 24.598 27.8135 24.5406 27.7944 24.4736C27.7657 24.4066 27.7752 24.4066 27.7848 24.3109C27.7848 24.2152 27.6412 23.7463 27.5742 23.6984C27.5073 23.641 27.201 23.3922 27.0862 23.2199C26.9713 23.0381 26.9905 22.9998 26.9905 22.9998H27.1627V22.9902Z"
          fill="#202020"
        />
        <path
          d="M27.6512 24.1865C27.5842 24.0525 27.5746 23.9281 27.5555 23.8516C27.4673 23.7213 27.3533 23.6106 27.2205 23.5262C27.1727 23.507 27.077 23.5357 27.0291 23.507L26.7516 23.2008C26.7516 23.2008 26.7229 23.2391 26.7324 23.2486C26.742 23.2486 26.9908 23.5357 27.0865 23.6123C27.1822 23.708 27.2301 23.8994 27.2971 24.0525C27.3545 24.2057 27.3354 24.1674 27.3354 24.2439C27.3449 24.3205 27.3928 24.3588 27.4311 24.3588C27.4693 24.3588 27.498 24.3396 27.4789 24.3301C27.4074 24.2524 27.3521 24.1614 27.3162 24.0621C27.2588 23.9281 27.2014 23.6793 27.1248 23.5932L27.0961 23.574L27.1918 23.5645C27.2588 23.5645 27.5172 23.7941 27.5363 23.8611C27.5555 23.9281 27.5363 23.9568 27.632 24.1865C27.7469 24.4162 27.7947 24.4736 27.7947 24.4736H27.8139L27.6512 24.1865ZM27.2588 22.6553L27.4885 22.7893L27.5842 22.8084C27.5842 22.8084 27.6129 23.1434 27.7469 23.3348C27.8809 23.5262 27.9957 23.5932 27.9957 23.5932C27.9957 23.5932 27.9957 23.9568 28.0914 24.2057C28.1693 24.3966 28.202 24.6029 28.1871 24.8086C28.168 24.8564 28.0914 24.665 28.034 24.4928L27.8904 24.0143C27.8505 23.8877 27.7854 23.7705 27.699 23.6697C27.632 23.6219 27.6799 23.6314 27.7182 23.6697C27.8062 23.7657 27.8716 23.8801 27.9096 24.0047C27.967 24.1961 27.9957 24.3875 28.0244 24.3875C28.0627 24.3875 28.0818 24.3588 28.0818 24.3205C28.0818 24.2822 28.0436 24.1865 28.0148 24.0047C27.9766 23.8133 27.9479 23.6984 27.9191 23.6506C27.8904 23.5932 27.8426 23.5932 27.7277 23.3826C27.6447 23.2587 27.5802 23.1233 27.5363 22.9807V22.885C27.5076 22.8658 27.498 22.885 27.4023 22.8371C27.3066 22.7893 27.2588 22.6553 27.2588 22.6553Z"
          fill="#202020"
        />
        <path
          d="M27.7275 22.5883C27.7275 22.5883 27.8424 22.684 27.9094 22.7031C27.9668 22.7318 28.0625 22.7318 28.0625 22.7318C28.0625 22.7318 28.0338 23.0572 28.1582 23.2582C28.2826 23.4688 28.4166 23.5836 28.4166 23.5836C28.4166 23.5836 28.4357 23.6602 28.474 24.11L28.5314 24.7416C28.5314 24.9139 28.541 25.5455 28.5219 25.5264C28.4262 25.4498 28.5027 25.1148 28.4549 24.9713C28.407 24.8277 28.3305 24.8086 28.2348 24.3971C28.1391 24.0143 28.2061 23.9186 28.1391 23.7654C28.0721 23.6123 27.9859 23.6027 27.9859 23.6027C27.9859 23.6027 28.1104 23.6219 28.1582 23.7559C28.2061 23.8803 28.2156 24.2152 28.2539 24.3779C28.3496 24.7607 28.4836 24.9522 28.4836 24.9522C28.4836 24.9522 28.4549 24.4736 28.4166 24.2057C28.3783 23.9377 28.3879 23.7176 28.3305 23.6123C28.2826 23.5166 28.1773 23.4209 28.1104 23.2965C28.0434 23.1529 28.0242 22.885 27.9955 22.818C27.9668 22.751 27.9477 22.7701 27.8998 22.751C27.7562 22.6936 27.7275 22.5883 27.7275 22.5883Z"
          fill="#202020"
        />
        <path
          d="M28.0625 22.416C28.0625 22.416 28.1678 22.5309 28.3113 22.6074C28.4453 22.6936 28.5219 22.6648 28.541 22.684C28.5602 22.7031 28.5123 22.9807 28.6559 23.2391C28.7994 23.507 28.8473 23.507 28.8568 23.5453L28.9047 24.598C28.9238 24.866 28.943 25.7465 28.8377 25.7465C28.7324 25.7465 28.8281 25.0957 28.7707 24.9426C28.7229 24.7895 28.7229 24.8373 28.675 24.7129C28.6176 24.598 28.6176 24.1195 28.541 23.8324C28.474 23.6219 28.4166 23.5836 28.4166 23.5836C28.4166 23.5836 28.5123 23.641 28.5697 23.8229C28.6176 23.9951 28.6271 24.5885 28.6846 24.6746C28.742 24.7703 28.8186 24.8852 28.8377 24.9617C28.8568 25.0574 28.8377 23.8611 28.7994 23.7846C28.7803 23.708 28.541 23.2773 28.5123 23.0381C28.5027 22.7988 28.4932 22.7701 28.474 22.751C28.4453 22.7318 28.3783 22.751 28.2635 22.6457C28.1486 22.5309 28.0721 22.416 28.0721 22.416H28.0625Z"
          fill="#202020"
        />
        <path
          d="M28.6175 22.55C28.6175 22.5309 28.694 22.684 28.9046 22.7701C29.1247 22.8562 29.3353 22.8371 29.364 22.8658C29.4777 23.1081 29.5334 23.3735 29.5267 23.641C29.5267 24.0717 29.4501 24.0334 29.3831 24.4066C29.3161 24.7895 29.3161 25.5359 29.2778 25.6508C29.2587 25.6986 29.23 25.7178 29.2108 25.7943C29.1821 25.8613 29.23 26.0049 29.163 26.0049C29.096 26.0049 29.0864 25.8996 29.0864 25.8422C29.0864 25.7848 29.1534 25.5742 29.1534 25.3637C29.1534 25.1531 29.1151 25.134 29.0769 24.8852C29.0481 24.6459 29.0481 23.8611 29.0194 23.7846C28.9907 23.708 28.8567 23.5453 28.8567 23.5453C28.8567 23.5453 29.0003 23.641 29.0386 23.7367C29.0769 23.8516 29.0769 24.7225 29.1151 24.8947C29.1534 25.0766 29.1438 24.8564 29.1534 24.7512C29.1726 24.6555 29.2204 24.2248 29.2204 23.9951C29.2108 23.7654 29.1151 23.2678 29.029 23.1912C29.029 23.1912 29.0769 23.2391 29.1247 23.3443L29.1821 23.3922L29.2587 23.4305C29.2322 23.4288 29.2063 23.4223 29.1821 23.4113L29.1343 23.3826C29.2008 23.5798 29.2332 23.787 29.23 23.9951C29.2396 24.3779 29.1821 25.2393 29.2395 25.2584C29.3065 25.2584 29.2874 24.7799 29.3544 24.3971C29.4214 24.0143 29.5075 23.9568 29.4788 23.6314C29.4501 23.3252 29.364 22.9807 29.297 22.9328C29.2395 22.8945 29.0481 22.9041 28.8759 22.7988C28.7036 22.6936 28.6079 22.5787 28.6175 22.55V22.55ZM25.8804 22.9902C25.8804 22.9902 25.9378 23.0189 26.0144 22.9902C26.0813 22.952 26.2728 22.7988 26.2728 22.7318V22.6074C26.2728 22.6074 26.2728 22.6361 26.3397 22.6457C26.3876 22.6457 26.5503 22.5309 26.5599 22.4543V22.2246C26.5312 22.2055 26.5981 22.2533 26.6364 22.2246C26.6651 22.1959 26.8183 22.1002 26.8183 21.9949C26.8183 21.8992 26.7226 21.8035 26.7226 21.8035H26.847C26.8948 21.7939 27.0384 21.7078 27.0384 21.6121C27.0384 21.5164 26.981 21.3824 26.8661 21.3729C26.8661 21.3729 26.9522 21.392 27.0384 21.3729C27.1245 21.3346 27.1532 21.2771 27.1532 21.1814C27.1532 21.0857 26.981 20.8943 26.9522 20.8752C26.914 20.8561 27.1341 20.9326 27.1915 20.8465C27.2394 20.7508 27.2489 20.7029 27.2298 20.6551C27.2202 20.6072 27.1724 20.5881 27.1724 20.5881C27.1724 20.5881 27.2681 20.6168 27.3925 20.5498C27.5169 20.4924 27.6222 20.4062 27.6796 20.4062C27.737 20.4062 27.4978 20.5402 27.4882 20.6072C27.4882 20.6359 27.5552 20.6838 27.6604 20.7699L27.6796 20.7795C27.7274 20.8082 27.9188 20.8178 27.9284 20.8273C27.9476 20.8273 27.7466 20.8273 27.7657 20.8465C27.9278 20.9662 28.0756 21.1043 28.206 21.258C28.206 21.258 28.2347 21.2867 28.2729 21.2963L28.3687 21.3154H28.2538C28.3421 21.4329 28.4251 21.5543 28.5026 21.6791C28.5026 21.6791 28.5409 21.727 28.5696 21.7365L28.6653 21.7557C28.6653 21.7748 28.5505 21.7557 28.5696 21.7748C28.6589 21.9244 28.7419 22.0777 28.8185 22.2342C28.8185 22.2342 28.5792 21.8227 28.2921 21.5068C28.005 21.1814 27.9476 21.1432 27.9284 21.1719C27.9093 21.2006 28.139 21.4877 28.2634 21.6791C28.3878 21.8801 28.4931 22.1289 28.4931 22.1289C28.4931 22.1289 28.206 21.5355 27.804 21.1719C27.402 20.7986 27.3638 20.7412 27.3255 20.7604C27.2681 20.7699 27.2298 21.0475 27.2681 21.0953C27.2968 21.1527 27.5839 21.3824 27.8423 21.6695C28.0911 21.9566 28.4069 22.4734 28.4069 22.4734C28.4069 22.4734 28.1772 22.1098 27.7944 21.7078C27.4116 21.3059 27.2681 21.2006 27.2394 21.2006C27.2106 21.2006 27.2011 21.2771 27.1628 21.3441C27.1149 21.4016 27.0192 21.392 27.0192 21.4207C27.0192 21.4494 27.3446 21.7461 27.4021 21.7844C27.469 21.8227 27.5073 21.8035 27.5552 21.8322L27.6604 21.8992L27.5456 21.8609C27.4978 21.8418 27.4499 21.8418 27.4499 21.8609C27.4499 21.8801 27.7083 22.1959 27.7562 22.215C27.7944 22.2342 27.8231 22.2246 27.8806 22.2533C27.938 22.2725 28.0241 22.3299 28.0241 22.3299L27.871 22.2629C27.804 22.2629 27.7753 22.2629 27.7753 22.282C27.7753 22.3012 27.9763 22.5596 27.9667 22.5691C27.9667 22.5691 27.6604 22.2055 27.4116 21.9854C27.1532 21.7557 27.0384 21.7078 27.0288 21.7174C27.0192 21.727 27.0288 21.7939 26.9618 21.8131C26.9044 21.8418 26.847 21.8418 26.847 21.8705C26.847 21.8896 27.0671 22.1098 27.2298 22.282C27.3343 22.398 27.4364 22.516 27.536 22.6361L27.1915 22.3012C27.0097 22.1289 26.9235 22.0619 26.9044 22.0715C26.8853 22.0811 26.8853 22.1672 26.9044 22.1959C26.914 22.215 27.2489 22.6074 27.2394 22.617C27.2298 22.6266 26.847 22.148 26.8183 22.148C26.7991 22.148 26.78 22.2055 26.7608 22.2437C26.7321 22.2629 26.6269 22.2629 26.6269 22.3012C26.6269 22.3395 27.1628 22.8754 27.1437 22.8754C27.1437 22.8754 26.7034 22.4926 26.6843 22.5213C26.6747 22.5404 26.8757 22.9041 26.8661 22.9137C26.847 22.9232 26.5981 22.5309 26.579 22.5309C26.5599 22.5309 26.5599 22.5787 26.4929 22.6361C26.4259 22.6936 26.3493 22.6744 26.3493 22.6936C26.3493 22.7223 26.713 23.1338 26.7034 23.1434C26.7034 23.1434 26.3206 22.751 26.3206 22.7701C26.3206 22.7701 26.2919 22.7988 26.3015 22.8275C26.3302 22.9232 26.4163 23.1051 26.3972 23.1146C26.3972 23.1146 26.2823 22.8754 26.2536 22.885C26.2249 22.885 26.2249 22.9424 26.1579 22.9807C26.1101 23.0094 26.0622 22.9998 26.0622 23.0285C26.0622 23.0572 26.1292 23.0955 26.1579 23.1529C26.1866 23.2104 26.2153 23.3443 26.2153 23.3443C26.2153 23.3443 26.1771 23.2295 26.1196 23.1625C26.0718 23.0955 26.0239 23.0477 25.9856 23.0477C25.9474 23.0477 25.9187 23.0859 25.9187 23.0859L25.8804 22.9998V22.9902Z"
          fill="#202020"
        />
        <path
          d="M29.364 22.8658C29.364 22.8658 29.4788 22.8563 29.4979 22.8276C29.5075 22.7988 29.4501 22.8276 29.3448 22.7031C29.23 22.5883 28.962 21.7748 28.6462 21.3633C28.1485 20.7029 27.6892 20.4063 27.6892 20.4063C27.6892 20.4063 28.2347 20.7221 28.6653 21.3537C29.1056 21.9854 29.2108 22.4926 29.3353 22.617C29.4597 22.751 29.5745 22.7701 29.5649 22.8084C29.5649 22.8467 29.5458 22.8754 29.4979 22.885L29.3353 22.8945L29.3544 22.8658H29.364ZM25.689 22.684L25.7081 22.6936C25.7368 22.6936 25.8899 22.55 25.8804 22.5022C25.8804 22.5022 25.8134 22.483 25.756 22.4256C25.6985 22.3682 25.689 22.282 25.689 22.282C25.689 22.282 25.7368 22.3777 25.7847 22.4065C25.8229 22.4352 25.8899 22.4543 25.9187 22.4352C25.9378 22.4065 26.1579 22.2438 26.1483 22.1863C26.1483 22.1863 26.0813 22.1863 26.0144 22.1385C25.9474 22.0906 25.9378 21.9854 25.9378 21.9854C25.9378 21.9854 25.9761 22.0715 26.0431 22.1002C26.1101 22.1289 26.177 22.1193 26.1962 22.1002C26.2153 22.0715 26.3589 21.8705 26.3397 21.8131C26.3397 21.8131 26.2728 21.8131 26.2058 21.7748C26.1388 21.727 26.1005 21.6121 26.1005 21.6121C26.1005 21.6121 26.1483 21.7078 26.2345 21.727C26.3206 21.7461 26.3876 21.6887 26.3972 21.6313C26.4163 21.5738 26.4642 21.3442 26.3972 21.2867C26.3972 21.2867 26.2823 21.325 26.2058 21.2867C26.1292 21.2484 26.1005 21.1432 26.1005 21.1432C26.1005 21.1432 26.1579 21.2389 26.2536 21.2389C26.3397 21.258 26.378 21.2102 26.3876 21.1719C26.4067 21.1432 26.4067 21.0092 26.3876 20.9422C26.3589 20.8752 26.3015 20.8752 26.2919 20.7699C26.2919 20.7699 26.2632 20.8082 26.1483 20.8082C26.0335 20.8082 25.9761 20.6838 25.9761 20.6838C25.9761 20.6838 26.0718 20.7699 26.1579 20.7604C26.244 20.7604 26.2728 20.6838 26.2823 20.6264C26.2823 20.569 26.2345 20.5115 26.2058 20.4541C26.1866 20.3967 26.1771 20.3297 26.1675 20.3393C26.1483 20.3393 26.1292 20.3967 26.0144 20.3776C25.8995 20.3584 25.8708 20.2818 25.8708 20.2818C25.8708 20.2818 25.9569 20.3393 26.0144 20.3393C26.0813 20.3393 26.1292 20.301 26.1292 20.2531C26.1292 20.2149 26.1005 20.1287 25.9569 20.0043C25.8703 19.9307 25.7809 19.8605 25.689 19.7938C25.689 19.7938 25.8804 19.899 26.0048 20.0043C26.1292 20.1 26.1962 20.2053 26.1962 20.2053C26.1962 20.2053 26.3302 20.2531 26.3397 20.2053C26.3589 20.1574 26.3589 20.1096 26.311 20.0139C26.2728 19.9469 26.1579 19.8225 26.1579 19.8225C26.1579 19.8225 26.2728 19.9182 26.3302 20.0234C26.3876 20.1287 26.3685 20.2053 26.3685 20.2244C26.3685 20.2531 26.6269 20.3488 26.6843 20.3201C26.7417 20.2818 26.713 20.2053 26.6651 20.1287L26.5694 19.9947C26.5694 19.9947 26.6364 20.0617 26.6843 20.1383C26.7226 20.2053 26.7608 20.2723 26.7417 20.301C26.7226 20.3393 26.6938 20.3488 26.6938 20.368L26.8661 20.4637C26.9522 20.5115 27.0479 20.5594 27.0575 20.5307C27.0767 20.502 27.0767 20.4445 27.0767 20.3584C27.0671 20.2818 27.0192 20.1574 27.0192 20.1574C27.0192 20.1574 27.0767 20.2723 27.0862 20.3584V20.5498C27.1149 20.569 27.1819 20.5785 27.1819 20.5785C27.1819 20.5785 27.1245 20.6168 27.0192 20.5785C26.9044 20.5498 26.4259 20.3106 26.4067 20.3297C26.3876 20.3584 26.6269 20.502 26.7417 20.6168C26.8565 20.7125 26.9044 20.8274 26.9044 20.8274C26.9044 20.8274 26.8183 20.7508 26.7321 20.7029C26.646 20.6551 26.3972 20.5307 26.378 20.5498C26.3685 20.569 26.4737 20.5881 26.4833 20.6072C26.4929 20.6264 26.4067 20.7029 26.4067 20.7412C26.4067 20.7699 26.7704 21.0283 26.7608 21.0475C26.7417 21.0762 26.6651 21.1432 26.646 21.1432C26.6364 21.1432 26.4546 20.9996 26.4546 21.0188C26.4546 21.0475 26.5503 21.1336 26.5503 21.1527C26.5503 21.1719 26.4929 21.2102 26.5024 21.2484C26.512 21.2963 26.7034 21.4494 26.6938 21.5068C26.6938 21.5547 26.5981 21.6026 26.6173 21.6408L26.7321 21.794L26.5886 21.6887C26.5599 21.6504 26.4929 21.5738 26.4833 21.5834C26.4464 21.6421 26.4205 21.7069 26.4067 21.7748C26.4067 21.8131 26.5024 21.8609 26.512 21.9471C26.5312 22.0428 26.5024 22.1385 26.4929 22.1385C26.4929 22.1385 26.3685 21.9758 26.3493 21.9758C26.3206 21.9758 26.2919 21.9758 26.2728 22.0236C26.2536 22.0619 26.177 22.1863 26.1962 22.2151C26.1962 22.2246 26.3206 22.2533 26.3206 22.349C26.3206 22.4447 26.244 22.5309 26.2345 22.5309L26.0813 22.3395C26.0622 22.3395 25.9091 22.5213 25.9091 22.5309C25.9091 22.5596 26.0048 22.6361 25.9952 22.6649C25.9761 22.7031 25.8995 22.6649 25.8517 22.684L25.7272 22.7318C25.7081 22.7318 25.689 22.684 25.689 22.684V22.684Z"
          fill="#202020"
        />
        <path
          d="M27.6798 20.4062C27.6798 20.4062 27.6894 20.3584 27.7181 20.3297C27.7372 20.3105 27.8329 20.2053 27.7946 20.1766C27.7659 20.1574 27.6415 20.1957 27.5649 20.1957C27.4884 20.1861 27.4405 20.1957 27.2108 20.0139C27.2108 20.0139 26.5026 19.5258 25.4021 19.4588C25.0575 19.4396 24.9044 19.5545 24.8853 19.631C24.8853 19.6406 24.981 19.4875 25.3255 19.4875C25.9743 19.5106 26.6067 19.6983 27.163 20.033C27.1917 20.0617 27.3831 20.2435 27.5554 20.2244C27.7372 20.1957 27.7755 20.1766 27.7659 20.2053C27.7659 20.2244 27.7085 20.301 27.6989 20.3201L27.6702 20.4158V20.4062H27.6798ZM25.7657 20.5498C25.7109 20.455 25.6396 20.3707 25.5552 20.301C25.3648 20.1684 25.1591 20.0591 24.9427 19.9756C24.9235 19.9756 25.4021 20.1957 25.536 20.3297L25.7657 20.5498Z"
          fill="#202020"
        />
        <path
          d="M25.7654 21.3441C25.7654 21.3441 25.7271 21.2963 25.6314 21.2293C25.572 21.1918 25.5075 21.1628 25.44 21.1432L25.6697 21.2006C25.7271 21.258 25.7654 21.3441 25.7654 21.3441ZM25.6984 20.9326C25.6984 20.9326 25.6697 20.8848 25.5357 20.8369C25.4018 20.7986 25.373 20.8082 25.373 20.8082C25.373 20.8082 25.4975 20.7508 25.5932 20.8082C25.6206 20.8187 25.6452 20.8354 25.6651 20.857C25.685 20.8786 25.6997 20.9044 25.708 20.9326H25.6984ZM25.6219 20.5881C25.6219 20.5881 25.5932 20.5307 25.4783 20.4924C25.3539 20.4445 25.2773 20.4349 25.2773 20.4349C25.2773 20.4349 25.4018 20.4062 25.5166 20.4541C25.641 20.5019 25.6219 20.5881 25.6219 20.5881ZM25.4783 20.3775C25.4783 20.3775 25.4496 20.3297 25.2199 20.2818C24.9998 20.2244 24.9137 20.2244 24.9137 20.2244C24.9137 20.2244 25.2295 20.1957 25.3156 20.2244C25.4018 20.2627 25.4783 20.3775 25.4783 20.3775ZM25.0668 20.1383C25.0668 20.1383 24.9328 20.1 24.7988 20.0904L24.4639 20.1C24.4639 20.1 24.8467 20.0426 24.9424 20.0617C25.0477 20.0904 25.0668 20.1383 25.0668 20.1383Z"
          fill="#D2A567"
        />
        <path
          d="M23.8131 24.8756C23.8131 24.8756 23.8801 25 24.0046 25C24.1481 25 24.2534 25.1914 24.2534 25.1914L24.1098 25.3445L23.7557 25.3637L23.6409 25.1723L23.8131 24.8851V24.8756ZM23.8131 24.7607C23.8323 24.732 23.7174 24.5023 23.6313 24.4736C23.5547 24.4258 23.66 24.5406 23.6409 24.5885C23.6217 24.6363 23.6122 24.6842 23.6217 24.7033C23.6217 24.7033 23.6887 24.799 23.6504 24.8469C23.6217 24.8947 23.8227 24.7512 23.8227 24.7512L23.8131 24.7607Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.7558 25.1053C23.7558 25.1053 23.8228 25.134 23.8706 25.1244C23.9185 25.1053 23.9663 25.0574 23.9663 25.0574L23.7558 25.1053ZM23.6888 25.0191C23.6888 25.0191 23.8897 24.8756 23.8802 24.799C23.861 24.7225 23.8132 24.7225 23.7845 24.732C23.7262 24.7637 23.6743 24.8059 23.6313 24.8565L23.6888 25.0191Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.5547 25.1148C23.5547 25.1148 23.5834 25.2105 23.6504 25.2105C23.7174 25.2105 23.8131 25.1627 23.8131 25.1148C23.8131 25.0861 23.7461 25.0191 23.7078 24.9904C23.66 24.9713 23.5643 25.0191 23.5643 25.0191L23.5547 25.1148Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.7369 24.9809C23.7178 25.0096 23.5934 25.0766 23.5551 25.0766C23.5168 25.0766 23.4307 24.9809 23.4594 24.9617L23.5742 24.933C23.6029 24.9139 23.6125 24.866 23.6316 24.866C23.6508 24.866 23.6986 24.8852 23.7178 24.9139C23.7369 24.9426 23.7465 24.9522 23.7369 24.9809V24.9809Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.6027 25.067C23.6027 25.067 23.4113 25.3349 23.3251 25.3158C23.2486 25.3062 23.3634 24.9426 23.3634 24.9426L23.4591 24.9808C23.5166 25 23.5835 25.0287 23.6027 25.0765V25.067Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.2583 24.8852C23.2583 24.8852 23.5071 24.9234 23.5167 24.9617C23.5263 25.0096 23.4019 25.0574 23.3253 25.0574C23.2583 25.0574 23.2583 24.8756 23.2583 24.8756V24.8852Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.6265 25.2584C22.6265 25.2584 22.6647 25.3828 22.77 25.3924C22.8849 25.3924 22.9806 25.2775 22.9806 25.2775L22.7222 25.1818L22.6265 25.2584Z"
          fill="#202220"
        />
        <path
          d="M22.6265 25.2584L22.6552 25.3254C22.6839 25.3541 22.7126 25.3924 22.77 25.3924H22.7796C22.8849 25.3924 22.9901 25.2775 22.9901 25.2775L22.7222 25.1627L22.6265 25.2584L22.7222 25.1818L22.9806 25.2775L22.9614 25.2871C22.9327 25.3254 22.8562 25.3828 22.7796 25.3828C22.7222 25.3828 22.6839 25.3541 22.6647 25.3158C22.6571 25.3037 22.6507 25.2909 22.6456 25.2775C22.6423 25.2744 22.6392 25.2712 22.636 25.268L22.6265 25.2584Z"
          fill="#4B4139"
        />
        <path
          d="M22.7031 25.2297C22.7031 25.2297 22.7414 25.3254 22.8945 25.3254C23.0285 25.3254 23.1434 25.2106 23.1434 25.2106L22.9137 25.0287L22.7031 25.2201V25.2297Z"
          fill="#202220"
        />
        <path
          d="M22.7029 25.2297C22.7029 25.2297 22.7412 25.3254 22.8943 25.3254C22.9886 25.3191 23.0772 25.2782 23.1432 25.2105L22.9135 25.0191L22.6934 25.2297H22.7029L22.9135 25.0383L23.1432 25.2105H23.1336C23.0687 25.2726 22.984 25.3099 22.8943 25.3158C22.8392 25.3188 22.7848 25.3018 22.7412 25.268C22.7305 25.2596 22.7209 25.2499 22.7125 25.2393C22.7123 25.2361 22.7123 25.2329 22.7125 25.2297H22.7029V25.2297Z"
          fill="#4B4139"
        />
        <path
          d="M22.7222 25.2488C22.7222 25.2488 22.7796 25.2967 22.8562 25.3063L23.0284 25.2871L22.9327 25.3158H22.8179L22.77 25.2967L22.7317 25.268L22.7222 25.2488V25.2488Z"
          fill="#4B4139"
        />
        <path
          d="M22.8943 25.1244C22.8943 25.1244 22.9518 25.2775 23.0857 25.2584C23.2102 25.2488 23.2197 25.1627 23.2197 25.1627L23.0666 24.9521L22.8848 25.1244H22.8943Z"
          fill="#202220"
        />
        <path
          d="M22.8946 25.1244H22.8851L22.9233 25.201C22.9521 25.2297 22.9999 25.268 23.0669 25.268H23.086C23.153 25.2584 23.1817 25.2392 23.2009 25.2105C23.2104 25.1996 23.217 25.1864 23.22 25.1723L23.0669 24.9426L22.8755 25.1244H22.8851L23.0765 24.9617L23.2104 25.1723C23.2104 25.1818 23.2009 25.2392 23.086 25.2584C23.0797 25.2588 23.0733 25.2588 23.0669 25.2584C23.0095 25.2584 22.9712 25.2201 22.9329 25.1914C22.9219 25.1764 22.9123 25.1603 22.9042 25.1435C22.904 25.1372 22.904 25.1308 22.9042 25.1244C22.901 25.1245 22.8978 25.1245 22.8946 25.1244V25.1244Z"
          fill="#4B4139"
        />
        <path
          d="M22.9041 25.1531C22.9041 25.1531 22.9902 25.2488 23.0572 25.2488C23.1242 25.2488 23.1721 25.2201 23.1721 25.2201V25.2297L23.1338 25.2488L23.0764 25.2584H23.0094L22.952 25.2201L22.9041 25.1531V25.1531ZM22.6553 25.3063C22.6553 25.3063 22.7127 25.3733 22.7701 25.3733C22.8275 25.3733 22.9137 25.3254 22.9137 25.3254H22.9232L22.9137 25.335L22.8563 25.3733L22.7797 25.3924L22.7223 25.3828L22.684 25.3541L22.6553 25.3254V25.3063V25.3063Z"
          fill="#4B4139"
        />
        <path
          d="M23.2388 24.866C23.2962 24.866 23.4302 25.0287 23.4302 25.1148C23.4302 25.201 23.3919 25.3254 23.3345 25.3158C23.2675 25.3158 23.124 25.1914 23.0953 25.1244C23.0666 25.067 23.0283 25.0191 23.057 24.9904C23.0761 24.9521 23.2484 24.866 23.2484 24.866H23.2388ZM22.6263 24.8852C22.6263 24.8852 22.5306 24.8086 22.4828 24.8469C22.4445 24.8852 22.4541 25.0191 22.4828 25.0383C22.5115 25.0766 22.6263 24.9809 22.6263 24.9809V24.8852Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.6076 24.9809C22.6076 24.9809 22.4736 24.9809 22.4736 25.0479C22.4736 25.1148 22.5406 25.1723 22.5502 25.1914C22.5693 25.201 22.6842 25.134 22.6842 25.134L22.6076 24.9809V24.9809Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.665 25.0861C22.665 25.0861 22.5215 25.1244 22.5215 25.1818C22.5215 25.2201 22.5885 25.3063 22.6268 25.3063C22.6746 25.3063 22.7033 25.2201 22.7225 25.2105C22.7416 25.1914 22.665 25.0861 22.665 25.0861ZM22.732 24.6938C22.732 24.6938 22.7033 24.6555 22.6459 24.6746C22.5885 24.7033 22.5215 24.7607 22.5406 24.8469C22.5406 24.9426 22.5789 25 22.5789 25L22.7799 24.933L22.732 24.6938V24.6938Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.7414 24.8469C22.7414 24.8469 22.5691 24.9043 22.5596 24.9713C22.5596 25.0478 22.5979 25.1148 22.6553 25.1244C22.6936 25.134 22.8467 24.9904 22.8467 24.9904L22.751 24.8564L22.7414 24.8469Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.8944 25.134C22.8944 25.134 22.7221 25.2488 22.703 25.2488C22.6743 25.2488 22.6073 25.1531 22.6264 25.0957C22.6456 25.0383 22.7604 24.9904 22.8083 24.9713C22.8466 24.9521 22.904 25.134 22.904 25.134H22.8944ZM23.0475 24.5023C23.0475 24.5023 22.9901 24.4641 22.8848 24.4641C22.7891 24.4736 22.703 24.6076 22.6934 24.6842C22.6839 24.7512 22.6934 24.8756 22.7317 24.8947C22.77 24.9139 22.9901 24.7416 22.9901 24.7416L23.0475 24.5023Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.8369 25.0191C22.7603 25.0191 22.7029 24.9139 22.7125 24.8469C22.722 24.7894 22.8656 24.6746 22.9422 24.6937C23.0187 24.6937 22.9996 24.8852 22.9996 24.8852C22.9996 24.8852 22.9039 25.0287 22.8369 25.0191Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.0669 25C23.0669 25 23.0287 25.0957 22.9617 25.1244C22.8851 25.1627 22.8373 25.134 22.799 25.0766C22.7511 25.0096 22.8181 24.9809 22.8468 24.9521C22.8851 24.9234 22.9808 24.9043 22.9808 24.9043L23.0669 25V25Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M22.9522 24.7894C22.9522 24.7894 22.866 24.8469 22.9139 24.9234C22.9617 25 23 25.0191 23.0574 25.0383C23.1149 25.0478 23.1531 25.0287 23.201 24.9713C23.2488 24.9139 23.3158 24.8851 23.3063 24.8181C23.3063 24.7512 23.2776 24.6937 23.2297 24.6746C23.1914 24.6555 23.067 24.6746 22.9426 24.7799L22.9522 24.7894Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M23.1817 24.4641C23.1817 24.4641 23.0956 24.4258 23.0286 24.4641C22.9712 24.5023 22.9233 24.5789 22.9233 24.6555L22.9329 24.8182C22.9329 24.8182 23.0286 24.799 23.0765 24.7512C23.1243 24.7033 23.153 24.6842 23.1435 24.6555C23.1435 24.6555 23.1147 24.6268 23.1147 24.5693C23.1147 24.4736 23.1817 24.4641 23.1817 24.4641V24.4641Z"
          fill="#202220"
        />
        <path
          d="M23.1817 24.4641C23.1817 24.4641 23.0859 24.4449 23.0381 24.4736C22.9902 24.5023 22.9424 24.5502 22.9328 24.6172C22.9137 24.6842 22.9328 24.6937 22.9328 24.6937C22.9328 24.6937 22.9137 24.6459 22.9328 24.5885C22.952 24.5311 22.9998 24.4736 23.0477 24.4545C23.0917 24.4439 23.1376 24.4439 23.1817 24.4545V24.4641Z"
          fill="#4B4139"
        />
        <path
          d="M25.6697 26.3016L25.7941 26.2441L25.9473 26.1484L25.976 26.3207L25.842 26.4164H25.7271L25.6602 26.3686L25.6793 26.3016H25.6697Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M25.4882 26.3111H25.5743L25.67 26.3016C25.6892 26.3016 25.7179 26.3973 25.7179 26.3973L25.6796 26.4451L25.5647 26.5121L25.469 26.4547L25.4595 26.3207H25.4882V26.3111ZM26.4165 26.2633L26.3495 26.1772L26.1868 26.0336V26.4164H26.3591L26.4356 26.292L26.4165 26.2633V26.2633Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M25.4879 26.3111C25.4879 26.3111 25.4592 26.2728 25.3922 26.2824C25.3156 26.292 25.2391 26.3494 25.2295 26.4068C25.2295 26.4547 25.2295 26.5982 25.2678 26.627C25.3061 26.6557 25.3635 26.6748 25.44 26.6557C25.5166 26.627 25.9186 26.3781 25.9186 26.3781L25.8229 26.4068L25.708 26.3877C25.708 26.3877 25.6602 26.4547 25.5932 26.4643C25.5262 26.4738 25.5166 26.4355 25.4975 26.4068L25.4879 26.3111V26.3111Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M25.7656 26.4451L25.6699 26.4834C25.6393 26.5019 25.6073 26.5179 25.5742 26.5312L25.6029 26.6557L25.7752 26.6939L25.8805 26.5982V26.4834L25.7561 26.4451H25.7656ZM26.56 26.359L26.5025 26.3016C26.4738 26.2633 26.426 26.2537 26.4164 26.2633L26.3207 26.3685V26.4547L26.4164 26.5025L26.4834 26.5121L26.5791 26.4547L26.56 26.359Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M25.9664 26.3016L25.8516 26.3686L25.7559 26.4451L25.8516 26.5408L25.9377 26.56L26.1291 26.426L26.11 26.3016H25.9664ZM26.6938 26.4547L26.6555 26.3973C26.6172 26.3686 26.5789 26.359 26.5598 26.359C26.5406 26.359 26.4641 26.4738 26.4641 26.4738L26.4545 26.5026L26.5215 26.5791L26.6459 26.6078L26.732 26.5313L26.6938 26.4547Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M26.378 26.5887L26.4737 26.6078C26.4737 26.6078 26.4642 26.6269 26.4929 26.6461C26.512 26.6652 26.5216 26.6461 26.5216 26.6461C26.5216 26.6461 26.5216 26.7418 26.6173 26.8088C26.6173 26.8088 26.7321 26.8471 26.78 26.8088C26.8374 26.7801 26.8278 26.8183 26.8278 26.8183L26.981 26.6269C26.981 26.6269 26.981 26.5887 26.9427 26.5887C26.9427 26.5887 26.9714 26.4738 26.8757 26.4451C26.78 26.4164 26.6938 26.4547 26.6938 26.4547C26.6938 26.4547 26.6173 26.5982 26.579 26.5791C26.5576 26.5701 26.5381 26.5571 26.5216 26.5408L26.4642 26.4738L26.3972 26.4547C26.3589 26.4355 26.3302 26.3685 26.3302 26.3685C26.3302 26.3685 26.2728 26.3685 26.2536 26.3398C26.2352 26.3229 26.2191 26.3036 26.2058 26.2824L26.0622 26.3781C26.0622 26.3781 26.0622 26.426 25.9761 26.4834C25.8995 26.5504 25.8421 26.5504 25.8421 26.5504C25.8421 26.5504 25.8229 26.6748 25.7272 26.6461C25.6315 26.6365 25.5741 26.5312 25.5741 26.5312C25.5741 26.5312 25.5071 26.5217 25.4688 26.5791C25.421 26.6365 25.4019 26.6557 25.4019 26.7131C25.4019 26.7705 25.4401 26.8471 25.4688 26.8758C25.4976 26.9045 25.5933 26.9715 25.6985 26.9141C25.8134 26.8566 25.7751 26.7705 25.7751 26.7705L25.8325 26.7322C25.8995 26.6844 25.9761 26.6174 26.0239 26.5982"
          fill="#F8C83C"
        />
        <path
          d="M26.378 26.5887L26.4737 26.6078C26.4737 26.6078 26.4642 26.6269 26.4929 26.6461C26.512 26.6652 26.5216 26.6461 26.5216 26.6461C26.5216 26.6461 26.5216 26.7418 26.6173 26.8088C26.6173 26.8088 26.7321 26.8471 26.78 26.8088C26.8374 26.7801 26.8278 26.8183 26.8278 26.8183L26.981 26.6269C26.981 26.6269 26.981 26.5887 26.9427 26.5887C26.9427 26.5887 26.9714 26.4738 26.8757 26.4451C26.78 26.4164 26.6938 26.4547 26.6938 26.4547C26.6938 26.4547 26.6173 26.5982 26.579 26.5791C26.5576 26.5701 26.5381 26.5571 26.5216 26.5408L26.4642 26.4738L26.3972 26.4547C26.3589 26.4355 26.3302 26.3685 26.3302 26.3685C26.3302 26.3685 26.2728 26.3685 26.2536 26.3398C26.2352 26.3229 26.2191 26.3036 26.2058 26.2824L26.0622 26.3781C26.0622 26.3781 26.0622 26.426 25.9761 26.4834C25.8995 26.5504 25.8421 26.5504 25.8421 26.5504C25.8421 26.5504 25.8229 26.6748 25.7272 26.6461C25.6315 26.6365 25.5741 26.5312 25.5741 26.5312C25.5741 26.5312 25.5071 26.5217 25.4688 26.5791C25.421 26.6365 25.4019 26.6557 25.4019 26.7131C25.4019 26.7705 25.4401 26.8471 25.4688 26.8758C25.4976 26.9045 25.5933 26.9715 25.6985 26.9141C25.8134 26.8566 25.7751 26.7705 25.7751 26.7705L25.8325 26.7322C25.8995 26.6844 25.9761 26.6174 26.0239 26.5982"
          stroke="#977C2E"
          strokeWidth="0.0191406"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M26.2059 25.8326V26.0719C26.2059 26.0719 26.2442 26.292 26.1963 26.359C26.1485 26.426 25.9762 26.4164 25.9475 26.359C25.9284 26.292 25.9379 26.1102 25.9379 26.1102L26.2059 25.8231V25.8326Z"
          fill="#F8C83C"
          stroke="#977C2E"
          strokeWidth="0.0191406"
        />
        <path
          d="M26.0144 26.5695C26.0144 26.5695 25.9761 26.6365 26.091 26.6461C26.1037 26.6472 26.1164 26.6452 26.1281 26.6402C26.1398 26.6352 26.1501 26.6274 26.158 26.6174C26.1867 26.5887 26.1867 26.56 26.1867 26.56C26.1867 26.56 26.1771 26.6461 26.2824 26.6557C26.3877 26.6557 26.3781 26.5504 26.3781 26.5504"
          fill="#F8C83C"
        />
        <path
          d="M26.0144 26.5695C26.0144 26.5695 25.9761 26.6365 26.091 26.6461C26.1037 26.6472 26.1164 26.6452 26.1281 26.6402C26.1398 26.6352 26.1501 26.6274 26.158 26.6174C26.1867 26.5887 26.1867 26.56 26.1867 26.56C26.1867 26.56 26.1771 26.6461 26.2824 26.6557C26.3877 26.6557 26.3781 26.5504 26.3781 26.5504"
          stroke="#977C2E"
          strokeWidth="0.0191406"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M25.0959 26.7705C25.0959 26.7705 25.0289 26.6652 25.0959 26.627C25.1724 26.5887 25.2203 26.627 25.2586 26.627C25.3064 26.627 25.2873 26.5121 25.2777 26.493C25.2777 26.4643 25.249 26.4164 25.2299 26.3973C25.2107 26.3973 24.9619 26.4164 24.9715 26.5791C24.9715 26.7418 25.0959 26.7705 25.0959 26.7705ZM25.4787 27.1629C25.4787 27.1629 25.4021 27.0481 25.4404 26.9811C25.4883 26.9141 25.517 26.9619 25.5361 26.9524C25.5553 26.9524 25.5648 26.9045 25.5361 26.8279C25.5074 26.7514 25.45 26.7227 25.4213 26.7131C25.4021 26.7131 25.249 26.8184 25.2777 26.9619C25.316 27.1342 25.4691 27.1629 25.4691 27.1629H25.4787ZM26.8664 27.0289C26.8664 27.0289 27.1344 27.1438 27.1535 26.8662C27.1631 26.7227 27.0291 26.627 26.9908 26.627C26.9621 26.627 26.9429 26.6461 26.8951 26.7035C26.8472 26.7609 26.809 26.7992 26.8281 26.8184C26.8472 26.8471 26.9238 26.7992 26.9621 26.8854C27.0195 27.0289 26.8664 27.0289 26.8664 27.0289Z"
          fill="#202220"
        />
        <path
          d="M25.4787 27.1629C25.4787 27.1629 25.2681 27.115 25.2681 26.9141C25.2681 26.7801 25.4212 26.7227 25.4212 26.7227C25.4212 26.7227 25.2872 26.7896 25.2777 26.9141C25.2777 27.115 25.4691 27.1629 25.4691 27.1629H25.4787ZM25.0958 26.7705C25.0958 26.7705 24.9714 26.7418 24.9619 26.5695C24.9427 26.3973 25.2298 26.4068 25.2298 26.4068C25.2298 26.4068 24.9619 26.4068 24.9714 26.5791C24.9906 26.7514 25.0958 26.7705 25.0958 26.7705ZM26.8663 27.0289C26.8663 27.0289 26.9238 27.0576 26.9812 27.048C27.0482 27.048 27.1152 27.0289 27.1439 26.9332C27.1726 26.8279 27.1535 26.7801 27.0865 26.6939C27.0386 26.627 26.9908 26.627 26.9908 26.627C26.9908 26.627 27.0482 26.6365 27.0865 26.6939C27.1247 26.7514 27.1726 26.8184 27.1343 26.9332C27.096 27.048 26.9908 27.048 26.9429 27.048L26.8663 27.0289V27.0289Z"
          fill="#4B4139"
        />
        <path
          d="M23.6699 21.3537L23.6221 21.3441L23.6604 21.258L23.7943 21.2102L23.9379 21.2006H24.0814L24.1484 21.2389L24.225 21.4207L23.9475 21.5834L23.8996 21.6025L23.89 21.526L23.8422 21.4207L23.6699 21.3537Z"
          fill="#904720"
        />
        <path d="M26.2918 25.4211L26.2822 25L25.1338 25.3445L25.5932 25.7656L26.2918 25.4211Z" fill="#202020" />
        <path
          d="M24.1959 24.6842L24.1002 24.6076L23.9949 24.5502H23.8992L23.8896 24.5693L23.8992 24.6076L24.0045 24.732L24.1768 24.8277L24.2438 24.8756L24.282 24.8947L24.1863 24.6842H24.1959ZM24.1672 24.866H24.2342L24.2916 24.9522L24.3395 25.0287L24.3873 25.1244L24.4064 25.1914L24.282 25.1627L23.9088 25.0479L23.9471 24.9617L24.0045 24.9043L24.0619 24.8852L24.1385 24.866H24.1672Z"
          fill="#D2A567"
        />
        <path
          d="M24.4068 25.1723L24.4643 25.1627L24.5025 25.1244L24.4834 24.9904L24.5121 24.5502L24.2154 24.1961L24.1484 24.3971L24.2441 24.7608L24.3016 24.9713L24.4068 25.1723Z"
          fill="#D2A567"
        />
        <path
          d="M24.1864 24.3588C24.1864 24.3588 24.1673 24.3971 24.196 24.5119C24.2247 24.6267 24.263 24.8947 24.3683 25.067C24.464 25.2392 24.2726 24.9234 24.2726 24.9234C24.2726 24.9234 24.1099 24.5693 24.129 24.3014C24.1577 24.0238 24.1864 24.3588 24.1864 24.3588V24.3588Z"
          fill="#AB6D29"
        />
        <path
          d="M24.4064 24.5885C24.4064 24.5885 24.3395 24.665 24.3299 24.732V24.8947C24.3299 24.8947 24.3299 24.8182 24.3969 24.799C24.4639 24.7799 24.4543 24.9809 24.4543 25L24.4926 24.6363L24.4064 24.5885V24.5885ZM24.4447 25.3254L24.1098 25.2488C23.9279 25.1723 23.8418 25.1053 23.8418 25.0574C23.8418 25.0191 24.148 25.0766 24.1959 25.0861C24.2438 25.0957 24.3777 25.1627 24.3777 25.1627H24.4543L24.5979 25.1053L24.617 25.2584L24.4447 25.3254V25.3254ZM23.8705 25.2584C23.8705 25.2584 23.9662 25.3158 23.9184 25.3445C23.8801 25.3732 23.7748 25.3732 23.7461 25.3637L24.0715 25.4402L24.1289 25.3828C24.0462 25.3409 23.9632 25.2994 23.8801 25.2584H23.8705Z"
          fill="#AB6D29"
        />
        <path
          d="M23.7939 25.1723C23.7939 25.1531 23.8131 25.2201 23.9279 25.2297C24.0428 25.2488 24.1002 25.2106 24.1002 25.2106L24.148 25.2488L24.2055 25.2584L24.1576 25.3445L23.9375 25.2775L23.8227 25.2201L23.7939 25.1723Z"
          fill="#D2A567"
        />
        <path
          d="M24.5502 25.0191L24.6076 25.1053L24.6459 24.9139V24.7225L24.5215 24.6459L24.5502 25.0191Z"
          fill="#AB6D29"
        />
        <path
          d="M24.215 24.7129L24.1193 24.5406L23.9854 24.3014L24.0619 24.1674L24.1576 24.3014C24.1576 24.3014 24.1289 24.3971 24.1576 24.4928C24.1576 24.5885 24.215 24.7033 24.215 24.7033V24.7129Z"
          fill="#4D2A15"
        />
        <path
          d="M23.5264 25.3063C23.5264 25.3063 23.5742 25.2393 23.6699 25.2297C23.7752 25.2201 23.8613 25.2393 23.8613 25.2393L24.0527 25.3541L24.1006 25.4211L23.7178 25.3637L23.5264 25.3063V25.3063Z"
          fill="#D2A567"
        />
        <path
          d="M24.5407 24.6172L24.5503 24.933C24.5599 25 24.6077 25.0766 24.5981 25.1053C24.5981 25.134 24.579 25.1436 24.5216 25.1627C24.4737 25.1818 24.378 25.1627 24.378 25.1627C24.378 25.1627 24.4737 25.1531 24.4737 25.134C24.4833 25.1149 24.4546 25.0287 24.445 24.9426C24.445 24.866 24.445 24.7799 24.4259 24.7799C24.3972 24.7799 24.3685 24.8086 24.3589 24.8182C24.3589 24.8277 24.3876 24.5311 24.4163 24.5024C24.4546 24.4641 24.5407 24.6268 24.5407 24.6268V24.6172Z"
          fill="#8F4620"
        />
        <path
          d="M23.8322 25.2297C23.8322 25.2297 23.7939 25.201 23.7939 25.1723C23.7939 25.1436 23.8322 25.2967 24.0523 25.2871C24.2629 25.2775 24.2438 25.268 24.2438 25.268H24.349C24.349 25.268 24.3299 25.3637 24.3107 25.3732C24.2916 25.3732 24.148 25.4785 24.1385 25.4881L24.0906 25.5168V25.4977L24.0619 25.335L23.8801 25.268L23.8322 25.2297V25.2297Z"
          fill="#AB6D29"
        />
        <path
          d="M24.2154 24.7129C24.2154 24.7129 23.9665 24.4449 23.8804 24.2822C23.8038 24.11 23.8517 23.8803 23.8517 23.8803L24.0814 24.1865C24.0814 24.1865 24.0527 24.244 24.0622 24.3397C24.0718 24.4354 24.2154 24.7033 24.2154 24.7033V24.7129Z"
          fill="#8F4620"
        />
        <path
          d="M24.0526 25.6316C24.0526 25.6125 24.0335 25.5551 24.0813 25.4976C24.2292 25.3568 24.4054 25.2491 24.5981 25.1818V25.4115L24.1196 25.6412L24.0526 25.6316V25.6316Z"
          fill="#AB6D29"
        />
        <path
          d="M24.0813 25.4594L24.1866 25.3637C24.1866 25.3349 24.1292 25.3254 24.0239 25.3062C23.957 25.2895 23.8926 25.2637 23.8325 25.2297C23.8325 25.2297 23.9569 25.335 24.0144 25.3541C24.0622 25.3732 24.0622 25.3924 24.0526 25.4115L24.0813 25.4594V25.4594ZM24.713 25.5168L24.6173 25.3541L24.5981 25.1818L24.5216 25.2392L24.378 25.2871C24.378 25.2871 24.5312 25.2871 24.5312 25.3349C24.5312 25.3924 24.3015 25.4115 24.3015 25.4211C24.3015 25.4211 24.4833 25.3828 24.4737 25.4211C24.4546 25.4689 24.378 25.4689 24.2823 25.5168C24.2024 25.548 24.1256 25.5865 24.0526 25.6316C24.0526 25.6316 24.0909 25.6603 24.1675 25.6508C24.2345 25.6508 24.3876 25.6125 24.3876 25.6125L24.6747 25.4976L24.713 25.5168Z"
          fill="#8F4620"
        />
        <path
          d="M24.7127 25.5168C24.7127 25.5168 24.6361 25.4881 24.5787 25.1436C24.5213 24.799 24.5309 24.7129 24.5309 24.7129L24.6744 24.8086L24.7988 25.0287L24.7127 25.5072V25.5168Z"
          fill="#AB6D29"
        />
        <path
          d="M24.7608 24.9426C24.7608 24.9426 24.6938 25.134 24.6938 25.2488C24.6938 25.3637 24.6938 25.4402 24.713 25.5168C24.7507 25.582 24.7992 25.6402 24.8565 25.6891L24.9044 25.6412L24.9331 25.4881V25.2297L24.7608 24.9426V24.9426Z"
          fill="#8F4620"
        />
        <path
          d="M24.9523 25.2106C24.9523 25.2106 24.9906 25.6891 24.8566 25.6986C24.8088 25.7082 24.7227 25.5168 24.7131 25.5072C24.7131 25.5072 24.8184 25.6986 24.8662 25.6699C24.9428 25.6412 24.9141 25.1723 24.9141 25.1723L24.9523 25.2106ZM24.7131 25.5168L24.6652 25.4498C24.627 25.3924 24.6652 25.4977 24.3973 25.5934C24.1293 25.6891 24.0527 25.6316 24.0527 25.6316C24.0527 25.6316 24.1389 25.6986 24.3973 25.6221C24.6557 25.5455 24.6365 25.5264 24.6652 25.5264L24.7131 25.5168V25.5168Z"
          fill="#202020"
        />
        <path
          d="M24.2342 24.9043C24.2342 24.9043 24.282 24.933 24.3299 25.0287L24.4064 25.1914L24.416 25.1818L24.3395 25.0192L24.1768 24.7703L24.2342 24.9043Z"
          fill="#AB6D29"
        />
        <path
          d="M24.0814 25.4977C24.0814 25.4977 24.1102 25.4019 24.0814 25.3924C24.0527 25.3732 24.0336 25.3924 23.8518 25.3732C23.742 25.3578 23.6333 25.3355 23.5264 25.3062C23.5264 25.3062 23.6508 25.3828 23.7656 25.4115C23.8514 25.4351 23.9376 25.4574 24.024 25.4785H24.0719L24.0814 25.4977V25.4977Z"
          fill="#8F4620"
        />
        <path
          d="M24.0814 25.4977L24.0623 25.4594C24.0432 25.4402 24.0145 25.4594 23.7943 25.4115L23.5264 25.3158C23.5264 25.3158 23.6029 25.3732 23.7943 25.4211L24.0814 25.4977V25.4977Z"
          fill="#202020"
        />
        <path
          d="M24.1768 24.866C24.1768 24.866 24.0141 24.866 23.9662 24.9139C23.9184 24.9522 23.8418 25.067 23.8418 25.067L23.9471 25.0766C23.9471 25.0766 23.9375 24.9809 23.9854 24.933C24.0332 24.8852 24.1098 24.8756 24.1768 24.866V24.866Z"
          fill="#AB6D29"
        />
        <path
          d="M23.8706 24.5598C23.8706 24.5598 23.9376 24.6459 24.0046 24.6746C24.0716 24.7033 24.1386 24.732 24.1673 24.7703C24.2056 24.799 24.2343 24.9043 24.2343 24.9043C24.2343 24.9043 24.0046 24.799 23.9663 24.7512C23.9185 24.6937 23.8706 24.5598 23.8706 24.5598V24.5598Z"
          fill="#8F4620"
        />
        <path
          d="M24.1003 24.6172C24.1003 24.6172 24.0716 24.5789 24.0046 24.5502C23.9472 24.5215 23.9089 24.5215 23.8802 24.5406C23.8707 24.5502 23.8802 24.5598 23.8802 24.5598L23.9568 24.6842L24.0046 24.6746C24.0046 24.6746 23.8802 24.598 23.9089 24.5789C23.9664 24.5215 24.1003 24.6076 24.1003 24.6076V24.6172Z"
          fill="#8F4620"
        />
        <path
          d="M24.7131 24.3205L26.0146 23.6506L26.6271 24.5119L25.5074 24.799L24.9141 24.8564L24.627 24.6459L24.7131 24.3205Z"
          fill="#202020"
        />
        <path
          d="M26.4547 24.6842L28.0625 26.0814L27.8902 26.2059L27.5074 26.1006L26.7227 25.3254L26.4355 25.0287L26.4547 24.6842Z"
          fill="#4D2A15"
        />
        <path
          d="M28.5219 25.8039L27.5936 25.1053L26.4355 24.2344L26.4643 24.6459L27.7945 25.8709L28.2348 26.0814L28.4549 26.0145L28.5697 25.8996L28.5219 25.8039V25.8039Z"
          fill="#4D2A15"
        />
        <path
          d="M26.4453 24.8182C26.4453 24.8182 26.9143 25.3445 27.2684 25.6125C27.6225 25.8805 27.9574 26.1676 28.034 26.1293C28.101 26.091 28.0723 26.0432 28.0723 26.0432L26.4453 24.7129V24.8182V24.8182Z"
          fill="#803F1D"
        />
        <path
          d="M27.584 26.158L27.4309 26.2824L27.2395 26.2059L26.2441 25.1914L26.292 25L26.4355 25.0287L27.584 26.158Z"
          fill="#4D2A15"
        />
        <path
          d="M28.5218 25.8039C28.5218 25.8039 28.3974 26.091 28.139 26.024C27.8806 25.957 26.4546 24.6076 26.4546 24.6076V24.7512C26.4546 24.7512 27.8901 26.0719 28.1772 26.1197C28.4548 26.1771 28.6845 25.9283 28.6558 25.9092C28.6119 25.8762 28.5672 25.8443 28.5218 25.8135V25.8039Z"
          fill="#202020"
        />
        <path
          d="M26.292 25.0287C26.292 25.0287 26.7514 25.6221 26.9906 25.8326C27.2395 26.0527 27.45 26.225 27.5457 26.2058C27.6414 26.1867 27.4883 26.0719 27.4883 26.0719L26.7896 25.3924L26.4355 25.0287C26.4355 25.0287 26.292 24.9713 26.292 25.0287V25.0287Z"
          fill="#803F1D"
        />
        <path
          d="M26.4067 25.0287C26.4067 25.0287 27.5743 26.2154 27.6604 26.2441C27.8519 26.3016 28.139 26.1006 28.139 26.1006L28.0433 26.0432L28.0241 26.0814C28.0241 26.0814 27.9763 26.1963 27.7179 26.1484C27.2524 25.8102 26.8256 25.4219 26.445 24.9904L26.4067 25.0287V25.0287Z"
          fill="#202020"
        />
        <path
          d="M26.8473 26.1676L26.4166 25.6795L26.3209 25.5168L26.3018 25.3062L27.1439 26.1676L27.0291 26.2441L26.9238 26.2059L26.8473 26.1676Z"
          fill="#4D2A15"
        />
        <path
          d="M27.6128 26.1867C27.6128 26.1867 27.5171 26.3398 27.3735 26.3111C27.2877 26.2912 27.2106 26.2442 27.1534 26.1771L26.3399 25.3828L26.3208 25.2584C26.3208 25.2584 27.2108 26.2059 27.3735 26.2441C27.4884 26.2728 27.5649 26.1293 27.5649 26.1293L27.6128 26.1867V26.1867Z"
          fill="#202020"
        />
        <path
          d="M27.1629 26.158C27.1629 26.158 27.1246 26.2728 27.0002 26.2537C26.8854 26.2441 26.8471 26.1963 26.8471 26.1963L26.3494 25.6029L26.3398 25.4498C26.3398 25.4498 26.8566 26.158 26.9715 26.2059C27.0959 26.2441 27.1246 26.1197 27.1246 26.1197L27.1629 26.158V26.158Z"
          fill="#202020"
        />
        <path
          d="M26.627 24.6076C26.627 24.6076 27.1055 25.0191 27.1534 25.0383C27.1916 25.0574 27.3639 25.067 27.3735 25.0957C27.3735 25.1148 27.2586 25.0957 27.2491 25.1148C27.2491 25.1435 27.4979 25.3445 27.5362 25.3541C27.5745 25.3541 27.7754 25.3541 27.7754 25.3828C27.7754 25.4115 27.6319 25.3828 27.6319 25.4115C27.6319 25.4402 27.8424 25.6221 27.8903 25.6221C27.9286 25.6316 28.1774 25.6316 28.1774 25.6603C28.1774 25.6891 27.9764 25.6603 27.986 25.6986C27.986 25.7369 28.3305 25.957 28.3209 25.9857C28.3018 26.0144 27.8998 25.7178 27.8903 25.7273C27.8828 25.7746 27.8666 25.82 27.8424 25.8613C27.8137 25.8709 27.8424 25.7273 27.8233 25.6699C27.8041 25.6125 27.5649 25.4307 27.5362 25.4498C27.517 25.4785 27.5362 25.5838 27.517 25.5838C27.4979 25.5838 27.517 25.4498 27.4979 25.4019C27.4692 25.3541 27.2491 25.1723 27.2204 25.1723C27.1916 25.1723 27.2108 25.268 27.1916 25.2871C27.1725 25.3062 27.1725 25.1723 27.1438 25.134C27.1151 25.0957 26.6079 24.6363 26.627 24.6076V24.6076Z"
          fill="#B07229"
        />
        <path
          d="M25.8038 25.9475C25.8038 25.9475 25.8038 26.1293 25.7272 26.158C25.6507 26.1867 25.488 25.8231 25.488 25.8231L25.4497 25.4785L25.689 25.7082L25.8038 25.9475V25.9475ZM26.445 25.8518V25.7561L26.4259 25.6412L26.4067 25.4498L26.3685 25.335L26.3302 25.2488H26.2728L26.1483 25.3445L26.1101 25.469L26.177 25.6986L26.2345 25.8996L26.3302 25.9379L26.445 25.8518V25.8518Z"
          fill="#4D2A15"
        />
        <path
          d="M26.2826 26.1772C26.3113 26.158 26.2539 25.9092 26.2539 25.9092L26.1104 25.5455L26.0625 25.4115L25.9477 25.3637L25.8711 25.4594L25.8807 25.6029L26.0625 25.9379C26.1104 26.0145 26.2348 26.1867 26.2826 26.1676V26.1772Z"
          fill="#4D2A15"
        />
        <path
          d="M26.1482 25.3828C26.1961 25.4211 26.2439 25.5168 26.2535 25.5838C26.2535 25.5838 26.3492 25.8613 26.3396 25.8805C26.3301 25.9092 26.2631 25.9092 26.2631 25.9092C26.2631 25.9092 26.3971 26.0527 26.4354 26.0336C26.4832 26.0144 26.4641 25.8805 26.4449 25.8517C26.4354 25.823 26.3971 25.8517 26.3779 25.8135C26.3588 25.7848 26.3109 25.6029 26.3109 25.4976V25.2871C26.3301 25.2584 26.4258 25.5072 26.4258 25.6412L26.4736 25.6986L26.4258 25.4498L26.3779 25.2775L26.3971 25.1627V25.0861L26.4641 25.1244C26.4832 25.1244 26.5119 25.0861 26.5215 24.9713C26.5311 24.8564 26.5119 24.5119 26.5119 24.5119L25.9951 25.1914L26.1482 25.3828V25.3828Z"
          fill="#202020"
        />
        <path
          d="M26.1486 25.3254C26.1486 25.3254 26.1295 25.5168 26.1965 25.7082C26.2635 25.89 26.2826 25.8996 26.2922 25.9187C26.3113 25.9474 26.3113 26.1484 26.2922 26.1676C26.2922 26.1676 26.1486 25.8326 26.1008 25.6699C26.0625 25.4976 26.0529 25.4402 26.0242 25.4211L25.9668 25.4115L26.1582 25.3254H26.1486Z"
          fill="#202020"
        />
        <path
          d="M26.1008 26.3016C26.1104 26.3016 26.1008 26.225 26.1008 26.225L26.0816 26.0527L25.8998 25.6699L25.7084 25.4977L25.6031 25.335L25.584 25.6412C25.584 25.6412 25.7275 25.9475 25.8232 26.0432C25.9189 26.1293 26.0721 26.3111 26.1008 26.3016V26.3016Z"
          fill="#4D2A15"
        />
        <path
          d="M25.354 25.469C25.354 25.469 25.3923 25.5455 25.3923 25.6029V25.6986L25.5263 25.9666C25.5933 26.091 25.6603 26.2059 25.7177 26.1867C25.7655 26.158 25.7847 26.0719 25.7942 26.0623C25.7942 26.0527 25.7272 26.158 25.6985 26.1389C25.6603 26.1293 25.5071 25.6412 25.5167 25.6316L25.4401 25.5742L25.354 25.469V25.469ZM25.8995 25.8805L25.7655 25.6412C25.7272 25.5647 25.6698 25.5072 25.6603 25.5072C25.6411 25.5072 25.622 25.3637 25.622 25.3637C25.622 25.3637 25.6698 25.4594 25.7464 25.4977C25.8134 25.5264 25.8517 25.5551 25.8899 25.5455L25.9091 25.6986L25.8995 25.89V25.8805Z"
          fill="#202020"
        />
        <path
          d="M25.5743 25.6317C25.5743 25.6317 25.603 25.7369 25.67 25.8422L25.8519 26.0623C25.8519 26.0623 25.7274 25.9475 25.6604 25.8518C25.5935 25.7561 25.5552 25.6317 25.5552 25.6317H25.5647H25.5743Z"
          fill="#5C3A1D"
        />
        <path
          d="M25.9189 25.5072C25.9189 25.5072 25.9571 25.4115 25.9858 25.4115L26.072 25.3924C26.072 25.3924 26.0241 25.3828 25.9763 25.335C25.938 25.2775 25.9284 25.2871 25.8806 25.2393L25.9093 25.3828L25.9189 25.5072ZM25.8901 25.5359L26.0816 25.957C26.1103 26.0719 26.1103 26.225 26.1103 26.225L26.0528 26.024C26.0241 25.9283 25.8901 25.6699 25.8806 25.6412C25.8614 25.6125 25.8806 25.5455 25.8806 25.5455L25.8901 25.5359Z"
          fill="#202020"
        />
        <path
          d="M26.091 25.335L26.1293 24.8756L26.091 24.7033L25.8804 24.244C25.8804 24.244 25.8709 24.3109 25.8134 24.3109C25.7247 24.2862 25.6449 24.2364 25.5838 24.1674C25.5436 24.2878 25.537 24.4168 25.5646 24.5406L25.9761 25.2967L26.091 25.335V25.335Z"
          fill="#4D2A15"
        />
        <path
          d="M25.2872 25.6412C25.2872 25.6412 25.3542 25.7178 25.3829 25.7082C25.4212 25.6986 25.4116 25.5551 25.3638 25.4689C25.3159 25.3924 24.8279 24.732 24.7513 24.6937C24.6843 24.6555 25.2872 25.6412 25.2872 25.6412Z"
          fill="#8B441F"
        />
        <path
          d="M25.6222 25.3732C25.6317 25.4019 25.67 25.6125 25.5839 25.6316C25.469 25.6508 24.9235 24.9139 24.847 24.8086C24.847 24.8086 24.5024 24.598 24.5024 24.5406C24.5024 24.4928 24.8661 24.6172 24.8661 24.6172L25.5839 25.3062L25.6222 25.3732Z"
          fill="#8B441F"
        />
        <path
          d="M25.2873 25.6412C25.2873 25.6412 25.2299 25.536 25.2203 25.4498C25.2203 25.3828 25.1916 25.3445 25.1916 25.3158C25.0542 25.0989 24.9073 24.8882 24.7514 24.6842L24.5791 24.5789C24.5808 24.6399 24.5872 24.7007 24.5982 24.7608C24.5982 24.7608 24.7227 24.9904 24.9045 25.201L25.2873 25.6412V25.6412Z"
          fill="#202020"
        />
        <path
          d="M25.8898 25.5359C25.9377 25.5072 25.9186 25.3254 25.8898 25.268C25.8803 25.2106 25.5549 24.5406 25.5549 24.5406L25.4592 24.5789L25.2773 24.4354L25.1816 24.3301L25.2104 24.5693V24.6938L25.4592 25.134L25.8898 25.5359V25.5359ZM26.2535 25.134L26.3301 25.0383L26.2822 24.7033L26.0717 23.976C26.0717 23.976 26.0238 23.9951 25.976 23.9568C25.9339 23.9298 25.8953 23.8977 25.8611 23.8611L25.909 24.2918L26.1291 24.9043L26.1482 25.0861L26.2439 25.134H26.2535Z"
          fill="#4D2A15"
        />
        <path
          d="M25.5839 25.3062C25.5839 25.3062 25.3733 25.0766 25.2968 24.9617L25.1723 24.732C25.1723 24.732 25.1149 24.7607 25.0384 24.732C24.9714 24.6937 24.8661 24.5885 24.8661 24.5885C24.8661 24.5885 24.8087 24.7033 25.1149 25.0191C25.469 25.3732 25.5934 25.3062 25.5934 25.3062H25.5839Z"
          fill="#202020"
        />
        <path
          d="M26.1006 25.3828C26.1963 25.3445 26.1963 24.9713 26.1006 24.7129C26.0145 24.4641 25.8805 24.2344 25.8805 24.2344C25.8805 24.2344 26.0527 24.6555 26.091 24.8086C26.1293 24.9809 26.091 25.0957 26.0623 25.0957C26.0336 25.0861 26.0336 25 25.9666 24.8373C25.89 24.6746 25.8422 24.6363 25.8422 24.6363C25.8422 24.6363 26.091 25.3063 26.024 25.2967C25.957 25.2775 25.6125 24.5311 25.5934 24.5119C25.5838 24.4928 25.5742 24.5406 25.5742 24.5406C25.5742 24.5406 25.8805 25.4785 26.1006 25.3828V25.3828Z"
          fill="#8B441F"
        />
        <path
          d="M26.3017 23.5645L26.4548 23.8898L26.5026 24.2248L26.5122 24.5119C26.5122 24.5119 26.5218 25.0861 26.4548 25.0861C26.3878 25.1053 26.3495 25.0383 26.3495 25.0191L26.2155 24.3875L26.0815 23.7367L26.1294 23.6984L26.1485 23.6027L26.2442 23.5932L26.3017 23.5645V23.5645Z"
          fill="#4D2A15"
        />
        <path
          d="M25.8901 25.5359C25.9476 25.5359 25.8901 25.3828 25.8901 25.3828C25.8901 25.3828 25.8423 25.4498 25.7944 25.4019C25.7562 25.3541 25.6987 25.1627 25.6987 25.1627L25.6604 25.0478C25.6604 25.0478 25.6126 25.1723 25.5647 25.1723C25.4978 25.1723 25.2106 24.6842 25.2106 24.6842L25.1724 24.732C25.1724 24.732 25.5839 25.5838 25.8901 25.5359V25.5359Z"
          fill="#8B441F"
        />
        <path
          d="M25.6984 25.1627C25.6984 25.1627 25.7463 25.0479 25.7271 24.933C25.6821 24.8002 25.6244 24.672 25.5549 24.5502L25.4592 24.5406L25.2773 24.4449C25.3821 24.7034 25.524 24.9452 25.6984 25.1627V25.1627ZM25.9377 24.9904C25.9377 24.9904 25.8994 24.732 25.775 24.4928C25.7281 24.3752 25.6636 24.2655 25.5836 24.1674V24.4354C25.5836 24.4354 25.6984 24.4832 25.775 24.6268C25.8382 24.7437 25.8926 24.8653 25.9377 24.9904V24.9904ZM26.2631 24.5502C26.2631 24.5502 26.2439 24.2631 26.1961 24.1004L26.1004 23.7176L26.1291 23.6984H26.177C26.2439 23.708 26.2727 23.8611 26.2727 23.8611L26.2535 23.6219C26.2474 23.609 26.241 23.5962 26.2344 23.5836H26.1291C26.1291 23.5836 26.1482 23.6506 26.1195 23.6793C26.0908 23.708 26.0717 23.6697 26.0621 23.6602L26.0525 23.6889L26.0717 23.842V23.976C26.0717 23.976 26.11 24.1387 26.1674 24.2439L26.2631 24.5502V24.5502ZM26.5119 24.5119C26.5119 24.5119 26.5598 24.11 26.4736 23.842C26.4403 23.7224 26.3816 23.6114 26.3014 23.5166L26.2535 23.574C26.2535 23.574 26.3971 23.7941 26.4449 23.9951C26.4832 24.2152 26.5119 24.5119 26.5119 24.5119ZM26.1004 24.7225C26.1004 24.7225 26.0621 24.3971 26.0047 24.1961L25.9281 23.909L25.842 23.842C25.842 23.842 25.8898 24.0525 25.8898 24.1195L25.8803 24.2152C25.8803 24.2152 25.9186 24.3301 25.976 24.4258C26.0334 24.5215 26.1004 24.7129 26.1004 24.7129V24.7225Z"
          fill="#202020"
        />
        <path
          d="M26.3206 25.2201C26.3972 25.2201 26.3206 24.7607 26.2919 24.6459L26.0718 23.976C26.0718 23.976 26.3015 24.7607 26.2823 24.799C26.2536 24.8565 26.1675 24.5598 26.1483 24.5693C26.1292 24.5693 26.3206 25.0957 26.244 25.1053C26.1866 25.1053 26.1483 24.9904 26.1483 24.9904V25.1053C26.1483 25.1053 26.1962 25.2201 26.3206 25.2201Z"
          fill="#904720"
        />
        <path
          d="M26.4163 24.9904C26.4737 24.9904 26.3972 24.5598 26.3589 24.3588L26.2153 23.7846C26.2153 23.7846 26.3206 24.0525 26.3876 24.3588C26.445 24.665 26.4833 25.0574 26.4354 25.067C26.3685 25.067 26.3397 25.0096 26.3397 25.0096V24.9426C26.3397 24.9426 26.3589 24.9904 26.4163 24.9904V24.9904Z"
          fill="#904720"
        />
        <path
          d="M25.6701 25.4977C25.6701 25.5264 25.6701 25.6795 25.5936 25.6699C25.517 25.6603 25.3734 25.5264 25.3447 25.4307C25.3447 25.4307 25.517 25.6221 25.5744 25.6221C25.6318 25.6221 25.6318 25.4307 25.6223 25.3732C25.6223 25.3254 25.6701 25.4977 25.6701 25.4977V25.4977Z"
          fill="#312317"
        />
        <path
          d="M26.0815 23.4305C26.0815 23.4305 26.1772 23.4975 26.2729 23.4496C26.3098 23.4234 26.3402 23.389 26.3618 23.3492C26.3834 23.3094 26.3955 23.2652 26.3974 23.2199C26.3974 23.1625 26.3974 23.1051 26.3495 23.0381C26.2921 22.9711 26.4261 23.0955 26.4261 23.2199C26.4261 23.3348 26.4261 23.5453 26.2347 23.5932C26.0433 23.641 26.1294 23.5836 26.1294 23.5836L26.0815 23.4305Z"
          fill="#D2A567"
        />
        <path
          d="M25.9282 23.0668C25.9282 23.0668 26.0526 23.2582 26.1005 23.4496C26.1483 23.6219 26.1388 23.6889 26.1005 23.6984C26.0718 23.6984 26.0622 23.6793 26.0622 23.6314L25.9282 23.0572V23.0668Z"
          fill="#8F4620"
        />
        <path d="M23.7847 23.3061L24.5886 24.4832L25.6126 23.3348L24.9714 22.684L23.7847 23.3061Z" fill="#1E2121" />
        <path
          d="M24.8086 22.5883L24.7607 22.7797L24.8564 23.0859L25.0287 23.2582L25.2201 23.3922L25.268 23.2486L25.3158 23.0764L25.3637 23.0572L25.4881 23.1051L25.5742 22.9807L25.7082 22.751L25.6795 22.6553L25.6412 22.5883L25.4402 22.2342L25.3732 22.3682L25.3063 22.4065L25.1914 22.3395L25.0479 22.5309L24.866 22.4447L24.8086 22.5883Z"
          fill="#4D2A15"
        />
        <path
          d="M25.2298 23.3922C25.2298 23.3922 25.2585 23.3635 25.2777 23.2774C25.2872 23.1817 25.2968 22.8945 25.2681 22.7797C25.2394 22.6649 25.1724 22.4447 25.1532 22.4639C25.1341 22.4734 25.2681 22.7031 25.2489 22.9902C25.2298 23.2678 25.2489 23.3443 25.182 23.3731C25.1245 23.4018 25.2298 23.3922 25.2298 23.3922Z"
          fill="#5C3818"
        />
        <path
          d="M25.2681 22.9232C25.2681 22.9232 25.4021 23.1146 25.469 23.0381C25.536 22.9711 25.4978 22.7318 25.469 22.6361L25.3733 22.3969L25.4116 22.3586L25.4786 22.617C25.5073 22.7223 25.5743 23.0189 25.4882 23.0764C25.4021 23.1242 25.2776 22.9615 25.2776 22.9615V22.9232H25.2681Z"
          fill="#5C3818"
        />
        <path
          d="M24.8374 23.0476C24.8374 23.0476 24.8853 22.9807 24.9427 22.9807C25.0097 22.9807 25.0192 22.9998 25.0192 22.9998L25.0767 23.1529L25.1628 23.3156L25.2394 23.4017L25.2011 23.4496H25.1341L24.9427 23.3539L24.8853 23.2773L24.8374 23.0476V23.0476Z"
          fill="#8F4620"
        />
        <path
          d="M25.1533 24.7129C25.0959 24.7512 24.9523 24.6842 24.8662 24.6076L24.3494 24.0908L24.292 23.8516L24.4643 23.8898L24.7514 23.7654L24.8088 23.6697L25.1629 23.4783L25.3543 23.3826L25.785 23.3635L25.8807 23.1625C25.8807 23.1625 26.0338 23.4113 26.0529 23.507C26.0721 23.6027 26.0721 23.9186 26.0338 23.9377C25.9955 23.9664 25.8615 23.842 25.8424 23.842C25.8137 23.842 25.9381 24.2822 25.8424 24.3014C25.7371 24.3109 25.5553 24.1291 25.5553 24.1291C25.5553 24.1291 25.6318 24.5311 25.5553 24.5311C25.4596 24.5311 25.249 24.4354 25.1629 24.3397C25.1629 24.3397 25.2586 24.665 25.1629 24.7225L25.1533 24.7129Z"
          fill="#D2A567"
        />
        <path
          d="M25.0764 24.2057L25.1625 24.3397C25.1816 24.3684 25.1625 24.5598 25.1434 24.5885C25.1146 24.6651 25.0189 24.5024 24.9711 24.3684L24.7988 24.0813C24.7988 24.043 25.0764 24.2057 25.0764 24.2057V24.2057ZM25.909 23.2199C25.909 23.2199 26.0525 23.842 25.9855 23.8611C25.909 23.8803 25.6984 23.6697 25.6793 23.6315L25.3635 23.1434L25.3061 23.0764L25.3252 23.0477L25.4496 23.0955L25.909 23.2199Z"
          fill="#8F4620"
        />
        <path
          d="M24.8375 24.4067C24.8088 24.4354 24.7418 24.3301 24.7131 24.3109L24.4834 24.0526C24.3877 23.9568 24.3111 23.8803 24.3111 23.8611C24.3111 23.8324 24.2441 23.7654 24.2441 23.7654L24.3016 23.708L24.3686 23.6984C24.3686 23.6984 24.7801 24.0238 24.8088 24.0813C24.8375 24.1291 24.8566 24.3971 24.8375 24.4162V24.4067ZM25.4596 24.4162C25.4404 24.4354 25.1725 24.2344 25.048 24.0717C24.9332 23.909 24.8184 23.7654 24.7896 23.6889C24.7731 23.6412 24.7571 23.5934 24.7418 23.5453L24.8184 23.5645C24.8184 23.5645 25.4883 24.3875 25.4596 24.4162ZM25.5553 24.1291C25.5361 24.1483 25.4213 24.0621 25.3447 23.9664C25.2777 23.8707 25.316 23.7463 25.316 23.7463C25.316 23.7463 25.5648 24.11 25.5553 24.1291ZM25.7084 24.0908C25.6701 24.11 25.517 23.9186 25.383 23.708C25.2873 23.5549 25.2586 23.5262 25.2395 23.5166C25.2091 23.5026 25.1768 23.4929 25.1437 23.4879L25.1246 23.4688L25.1916 23.4496L25.249 23.3826L25.3256 23.2869L25.651 23.9377C25.651 23.9377 25.7275 24.0813 25.7084 24.0908V24.0908Z"
          fill="#8F4620"
        />
        <path
          d="M24.8661 24.6076C24.8661 24.6363 24.8661 24.6555 24.7704 24.6459C24.6938 24.6459 24.2249 24.3875 24.0239 24.0525C23.944 23.925 23.8642 23.7974 23.7847 23.6697L23.8804 23.5645L24.6077 24.3971L24.8661 24.6076V24.6076Z"
          fill="#AB6D29"
        />
        <path
          d="M24.8658 24.6076C24.8754 24.6459 24.8275 24.6555 24.7893 24.6459C24.7318 24.6363 24.55 24.5693 24.2629 24.244C23.9758 23.9186 23.8514 23.6793 23.8514 23.6697L23.8418 23.5357L23.9279 23.4975L24.4256 24.2631L24.8658 24.6076V24.6076Z"
          fill="#8F4620"
        />
        <path
          d="M25.3541 24.2822C25.3541 24.2822 25.201 24.1674 25.1053 24.0525C25.0096 23.9377 24.8182 23.6697 24.8182 23.6123C24.8182 23.5645 24.9139 23.5645 24.9139 23.5645L24.9043 23.4209L24.9234 23.3826L25.067 23.44L25.2488 23.6602L25.3158 23.7559C25.3158 23.7559 25.4307 24.0238 25.4115 24.043C25.3828 24.0813 25.2201 23.8994 25.201 23.9186C25.1818 23.9377 25.3924 24.2535 25.3541 24.2822V24.2822ZM25.067 24.2057C25.067 24.2057 25.1244 24.2822 25.0957 24.3301C25.0766 24.3875 25.0574 24.4162 24.9809 24.3014C24.9043 24.1865 24.8182 24.0621 24.8086 24.0717C24.8086 24.0813 24.8182 24.244 24.7799 24.244C24.7416 24.244 24.6268 24.11 24.5502 23.9951L24.3588 23.708C24.3588 23.708 24.3779 23.6602 24.3684 23.5357L24.3588 23.3443C24.3588 23.3443 24.3588 23.3826 24.3779 23.4113L24.4162 23.4688L24.6842 23.7846L24.7607 23.7367L24.9234 24.0525L25.0766 24.2057H25.067ZM24.0334 23.7272C24.0334 23.7272 24.2439 24.11 24.4449 24.3109C24.5648 24.4361 24.7078 24.5369 24.866 24.6076L24.2344 23.8516L24.043 23.7367L24.0334 23.7272ZM25.6604 23.9568C25.6508 23.9568 25.5168 23.8229 25.4307 23.6984C25.3555 23.5837 25.3095 23.4522 25.2967 23.3156L25.3158 23.0477C25.3158 23.0477 25.5359 23.2774 25.5838 23.3826C25.6221 23.4783 25.7082 23.6315 25.6891 23.6506C25.6699 23.6602 25.5264 23.5549 25.5072 23.574C25.4881 23.6027 25.6795 23.9377 25.6604 23.9568V23.9568ZM25.9092 23.7176C25.8805 23.7272 25.7656 23.6027 25.7369 23.5262C25.7082 23.4305 25.6986 23.2773 25.6986 23.2773L25.6029 23.0477L25.6125 22.7988L25.7082 22.7797L25.8518 22.9807C25.8518 22.9807 25.9092 23.1051 25.9092 23.2678C25.9092 23.4496 25.9379 23.6984 25.9092 23.7176V23.7176ZM24.1865 24.3397C23.9951 24.1004 23.8707 23.8611 23.8707 23.8611L23.8037 23.6506L23.842 23.6793C23.842 23.6793 23.8994 23.9281 24.1961 24.2248C24.5023 24.5215 24.5693 24.5502 24.5693 24.5502C24.5693 24.5502 24.6268 24.7129 24.598 24.7703C24.598 24.7703 24.3779 24.5789 24.1865 24.3397V24.3397Z"
          fill="#4D2A15"
        />
        <path
          d="M24.5119 24.6842C24.5119 24.6842 24.2535 24.4545 24.043 24.2057C23.842 23.9377 23.708 23.6889 23.708 23.6889L23.8037 23.6027C23.8037 23.6027 23.976 24.0047 24.0908 24.1674C24.2302 24.3404 24.3706 24.5127 24.5119 24.6842V24.6842ZM24.866 24.6076L24.4258 24.1387C24.3326 24.0373 24.2522 23.9248 24.1865 23.8037L24.3109 23.8516C24.3109 23.8516 24.3588 23.9855 24.4736 24.1195L24.8756 24.6076H24.866ZM24.8086 24.0717C24.8086 24.0717 24.6459 23.8803 24.5693 23.7463L24.4066 23.4592C24.4066 23.4592 24.6268 23.7176 24.6938 23.7271C24.7607 23.7463 24.7607 23.7271 24.7607 23.7271C24.7607 23.7271 24.732 23.8228 24.7607 23.8994C24.7703 23.976 24.8086 24.0717 24.8086 24.0717V24.0717ZM24.8756 23.2678C24.8756 23.2678 24.9043 23.4017 24.8852 23.4879C24.866 23.574 24.8182 23.5644 24.8182 23.5644L24.9617 23.7367C25.0096 23.7941 25.134 23.8803 25.134 23.8803L24.9904 23.6697C24.9521 23.6027 24.8947 23.5166 24.9234 23.4496C24.9426 23.3826 25.0766 23.4974 25.1148 23.5262L25.3063 23.7463C25.3063 23.7463 25.2584 23.5549 25.1723 23.4879C25.0798 23.4103 24.984 23.3369 24.8852 23.2678H24.8756Z"
          fill="#202020"
        />
        <path
          d="M25.5358 23.6889L25.4018 23.3539L25.2774 22.9711V23.1816C25.2774 23.2773 25.2391 23.4113 25.2009 23.4305C25.1626 23.4496 25.153 23.4496 25.0764 23.4305C25.0095 23.4113 25.1339 23.4688 25.1339 23.4688C25.1339 23.4688 25.2104 23.4688 25.2296 23.4305C25.2679 23.3922 25.2774 23.3156 25.3157 23.3252C25.3444 23.3348 25.3827 23.4496 25.4114 23.507L25.5358 23.6889Z"
          fill="#202020"
        />
        <path
          d="M25.2869 22.9615C25.2869 22.9615 25.44 23.1434 25.507 23.0572C25.574 22.9807 25.5357 22.7606 25.5357 22.7606C25.5357 22.7606 25.6314 22.7893 25.6602 22.7606C25.6889 22.7414 25.6793 22.6649 25.6793 22.6649C25.6793 22.6649 25.8516 22.9041 25.9281 23.0668C26.0143 23.2199 26.0525 23.507 26.0525 23.507C26.0525 23.507 25.909 23.2774 25.842 23.0668C25.775 22.8658 25.6793 22.7797 25.6602 22.7988C25.6506 22.818 25.6219 22.952 25.641 23.0285C25.6602 23.0955 25.7176 23.1912 25.7559 23.2869C25.8037 23.3922 25.8516 23.5549 25.8516 23.5549L25.7176 23.3635C25.6697 23.2965 25.6219 23.2678 25.5836 23.2391C25.5549 23.2104 25.507 23.1434 25.4592 23.1338C25.4113 23.1147 25.3156 23.0668 25.3156 23.1051L25.2965 23.0285L25.2773 22.9615H25.2869Z"
          fill="#202020"
        />
        <path
          d="M24.751 23.7176L24.9041 23.9856L25.0764 24.2057C25.0764 24.2057 24.9232 24.0717 24.8658 23.9856C24.8084 23.8899 24.751 23.7176 24.751 23.7176V23.7176Z"
          fill="#171717"
        />
        <path
          d="M25.7752 23.7559C25.756 23.775 25.6794 23.7463 25.6794 23.775C25.6699 23.8037 25.7177 23.8994 25.7752 23.9568C25.823 24.0143 25.8421 24.0143 25.8613 24.0047L25.8421 23.8994V23.7559C25.8326 23.7367 25.7752 23.7559 25.7752 23.7559Z"
          fill="#8F4620"
        />
        <path
          d="M23.9185 22.6553L23.8228 22.7127L23.7271 22.9328L23.7558 23.3443L23.9185 23.574C23.9759 23.6697 24.1864 23.8994 24.2343 23.8803C24.2917 23.8707 24.3491 23.708 24.3491 23.6219L24.3683 23.3731C24.3683 23.3731 24.4161 23.4688 24.5022 23.5549C24.5884 23.6506 24.6649 23.7367 24.6937 23.7272C24.7415 23.7272 24.8563 23.4879 24.8659 23.4496C24.8659 23.4209 24.5597 22.684 24.5597 22.684L24.4257 22.617L23.9185 22.6553V22.6553Z"
          fill="#D2A567"
        />
        <path
          d="M24.5981 23.2773L24.6843 23.5549C24.713 23.6506 24.6843 23.7271 24.7034 23.7271C24.713 23.7271 24.8757 23.5166 24.8757 23.4209C24.8757 23.3252 24.8757 23.2295 24.8374 22.9424C24.7896 22.6457 24.847 22.5596 24.847 22.5596L24.7513 22.483L24.6077 22.7988V23.2773H24.5981ZM24.0718 23.1051L24.1196 23.4879C24.1388 23.5836 24.1962 23.7367 24.2249 23.7271C24.2536 23.7271 24.3493 23.4783 24.3589 23.3922C24.3589 23.3922 24.2919 23.2678 24.2919 22.9711C24.2919 22.6648 24.2632 22.6361 24.2632 22.6361L24.0718 23.1051Z"
          fill="#AB6D29"
        />
        <path
          d="M23.6601 22.5117C23.6601 22.5117 23.4209 22.8563 23.4305 23.0477C23.4305 23.2391 23.4592 23.2008 23.5262 23.373C23.574 23.5453 23.6027 23.7941 23.6027 23.8133C23.6027 23.842 23.641 23.8133 23.6506 23.7846L23.6601 22.5117V22.5117Z"
          fill="#45392D"
        />
        <path
          d="M23.6604 22.5596C23.6604 22.5596 23.4499 22.8754 23.469 23.0572C23.4786 23.2391 23.5073 23.2295 23.5647 23.3922C23.6317 23.5453 23.6317 23.8133 23.6317 23.8133C23.6317 23.8133 23.6987 23.7941 23.7753 23.7367C23.8316 23.6906 23.8801 23.6357 23.9188 23.574L23.8422 23.4113L23.7848 23.2678L23.7274 23.1721L23.7465 22.8754L23.804 22.6457V22.5691L23.6604 22.5596V22.5596Z"
          fill="#AB6D29"
        />
        <path
          d="M24.7896 23.1146L24.6365 23.0668C24.5982 23.0381 24.5791 22.9711 24.5791 22.9711L24.6078 22.9137L24.7896 23.1051V23.1146Z"
          fill="#DBAD6C"
        />
        <path
          d="M23.6984 22.5883C23.6984 22.5883 23.5549 22.9137 23.5644 23.1434C23.589 23.3205 23.644 23.4922 23.7271 23.6506V22.9137L23.7941 22.6935V22.5787L23.6984 22.5883V22.5883Z"
          fill="#D2A567"
        />
        <path
          d="M24.0716 22.6648V22.7988C24.062 22.8467 23.9759 22.8945 23.9472 22.9519L23.8706 23.1721C23.8706 23.1721 23.8993 23.0764 23.9567 23.0285C24.0046 22.9807 24.0237 22.9328 24.0333 22.9711C24.0429 22.9998 24.062 23.1242 24.0524 23.1529C24.0429 23.1721 23.995 23.2103 23.9759 23.306C23.9581 23.3653 23.9581 23.4286 23.9759 23.4879L24.0142 23.3156C24.0237 23.2678 24.062 23.2486 24.062 23.2486L24.1577 23.4209V23.2773C24.1769 23.2103 24.2534 23.1242 24.263 23.1242C24.2917 23.1242 24.3204 23.1051 24.2438 23.0668C24.2151 23.0476 24.2343 22.7414 24.2438 22.7223C24.2726 22.7127 24.3874 22.7127 24.3778 22.6648C24.3432 22.6057 24.3014 22.551 24.2534 22.5021L24.062 22.6648H24.0716Z"
          fill="#8F4620"
        />
        <path
          d="M24.7703 23.3252L24.6555 23.3061C24.6452 23.3025 24.6362 23.2961 24.6294 23.2877C24.6226 23.2792 24.6184 23.269 24.6172 23.2582V23.2104L24.7129 23.2582L24.7703 23.3252Z"
          fill="#DBAD6C"
        />
        <path
          d="M23.8132 23.3635C23.8132 23.3922 23.7845 23.4305 23.7653 23.4783L23.7366 23.5932L23.7079 23.3443L23.6792 23.1625L23.6313 23.2104C23.6313 23.2104 23.6313 23.0955 23.6505 23.0381C23.6792 22.9807 23.6888 22.9041 23.6696 22.885C23.6505 22.885 23.6122 22.9137 23.5931 22.9424L23.5356 23.0381L23.5835 22.8945C23.6122 22.8563 23.7175 22.7318 23.7462 22.6744L23.7653 22.5787L23.8419 22.5692C23.8419 22.5692 23.928 22.6361 23.928 22.6936C23.928 22.7223 23.8419 22.751 23.8419 22.7606C23.8419 22.7606 23.7749 22.7606 23.7653 23.0094C23.7462 23.2678 23.8132 23.2486 23.8132 23.3635V23.3635ZM24.5214 22.6936C24.5214 22.6936 24.5405 22.8371 24.5214 22.885C24.5118 22.9233 24.4735 22.9615 24.4448 23.0094C24.4065 23.0668 24.4161 23.2008 24.4161 23.2008L24.4544 23.1051L24.5022 23.019C24.5118 23.019 24.5501 23.0668 24.5692 23.1434L24.6267 23.3348C24.6267 23.3348 24.6075 23.2391 24.6267 23.2391C24.6458 23.2391 24.6649 23.2391 24.7032 23.2678L24.7702 23.3252C24.7702 23.3252 24.7702 23.2869 24.7224 23.2295C24.6745 23.1721 24.6458 23.1912 24.6267 23.1242C24.6171 23.0572 24.6075 22.9807 24.6171 22.9615C24.6171 22.9328 24.6554 22.9711 24.6841 23.0094L24.7989 23.1147L24.7511 23.0381V22.818C24.7511 22.7414 24.7511 22.6649 24.7702 22.6457C24.7989 22.6266 24.8085 22.5309 24.7894 22.5117C24.7894 22.4926 24.5214 22.7031 24.5214 22.7031V22.6936Z"
          fill="#8F4620"
        />
        <path
          d="M25.354 22.4064C25.354 22.4064 25.354 22.5596 25.3827 22.6553L25.4688 22.9424C25.4688 22.9424 25.3827 22.7988 25.3444 22.6744C25.3062 22.5404 25.2774 22.4064 25.2487 22.3873C25.2104 22.3873 25.1722 22.4543 25.1722 22.5117C25.1784 22.6238 25.2043 22.734 25.2487 22.8371C25.2966 22.9041 25.1817 22.7414 25.153 22.6553L25.0956 22.4926C25.0956 22.4926 25.0669 22.5596 25.0765 22.6457C25.0956 22.7318 25.1626 22.8467 25.1626 22.8467L25.086 22.7701L25.0382 22.7223C25.0382 22.7223 25.0382 22.8371 25.0669 22.885L25.1626 23.0094L25.0669 22.9232C25.0516 22.9094 25.0387 22.8933 25.0286 22.8754C25.0286 22.8754 25.0382 23.0381 25.0765 23.1242L25.1913 23.3443C25.1913 23.3443 25.0956 23.2773 25.0382 23.1338C24.9803 22.9317 24.9545 22.7218 24.9616 22.5117L25.0573 22.3682C25.0956 22.3012 25.153 22.0045 25.153 22.0045C25.153 22.0045 25.2104 22.282 25.2583 22.3394C25.3062 22.3873 25.354 22.4064 25.354 22.4064V22.4064ZM24.6937 22.3203L24.7511 22.4256L24.7989 22.5021C24.7989 22.5021 24.7128 22.5978 24.6267 22.6648C24.531 22.7318 24.4161 22.8084 24.3874 22.7701C24.3587 22.7318 24.3587 22.6935 24.3587 22.6935C24.3587 22.6935 24.4544 22.6361 24.5405 22.55C24.5926 22.5048 24.635 22.4494 24.6649 22.3873L24.6937 22.3203ZM23.861 22.5978C23.861 22.5978 23.8706 22.7701 23.9472 22.7605C24.0237 22.7605 24.2343 22.5404 24.2438 22.5309C24.263 22.5309 24.2726 22.4734 24.2726 22.4543V22.3969C24.2726 22.3969 24.0333 22.6266 23.9567 22.6361C23.9388 22.6395 23.9203 22.6378 23.9033 22.631C23.8863 22.6242 23.8717 22.6127 23.861 22.5978V22.5978ZM23.861 22.3682L23.8419 22.5213C23.8419 22.5596 23.861 22.5883 23.861 22.5883C23.861 22.5883 23.6983 22.6457 23.6696 22.5883C23.6409 22.5404 23.6601 22.4734 23.6601 22.4734L23.7749 22.4639C23.8132 22.4543 23.8706 22.3682 23.8706 22.3682H23.861ZM25.421 22.1289C25.421 22.1289 25.488 22.3012 25.5358 22.3777L25.6411 22.5883L25.4976 22.4352C25.4655 22.4098 25.4336 22.3843 25.4019 22.3586L25.421 22.2725V22.1289Z"
          fill="#1E2121"
        />
        <path
          d="M23.6314 22.4734H23.7271L23.7941 22.4639L23.8516 22.3682C23.8516 22.3682 23.8229 22.4734 23.8516 22.5596C23.8707 22.6361 23.909 22.6457 23.9281 22.6457C23.995 22.6351 24.0561 22.6012 24.1004 22.55L24.2631 22.416C24.2631 22.416 24.2439 22.5117 24.2822 22.6074C24.3109 22.7127 24.3779 22.7127 24.4545 22.6553C24.5311 22.5883 24.6076 22.483 24.6459 22.4352L24.7033 22.3586L24.7895 22.2916L24.866 21.8705L24.8182 21.8131L24.7225 21.8705L24.5885 21.8131L24.5502 21.7652L24.4736 21.8896L24.3971 21.9375H24.3588L24.2631 21.9662L24.2248 21.8801L24.2057 21.8227L24.1578 21.8035L23.9664 21.9949L23.8707 21.9853L23.7654 22.148L23.6889 22.2437L23.6123 22.4352L23.6314 22.4734V22.4734Z"
          fill="#DBAD6C"
        />
        <path
          d="M24.5309 22.0523C24.5309 22.0523 24.55 22.1481 24.4926 22.3299C24.4352 22.5117 24.3682 22.617 24.3682 22.617C24.3682 22.617 24.5596 22.5117 24.6457 22.3107C24.7414 22.1002 24.7127 21.8705 24.7127 21.8705L24.5309 22.0523V22.0523ZM24.7605 21.8609C24.7605 21.8609 24.7797 21.8897 24.7605 22.0523L24.7031 22.3586L24.751 22.4447C24.7701 22.4926 24.8371 22.5787 24.885 22.5691C24.9232 22.55 24.9998 22.5022 25.0477 22.3969L25.1434 22.1768C25.1721 22.1576 25.1721 22.1768 25.1816 22.1959C25.1816 22.1959 25.2008 22.2916 25.2486 22.3299C25.2965 22.3682 25.3443 22.4256 25.3826 22.4065C25.4113 22.3873 25.4305 22.3395 25.4305 22.3107L25.3348 22.0045L25.2104 21.6982L25.1338 21.5834L24.9137 21.6025L24.7605 21.8609V21.8609Z"
          fill="#8F4620"
        />
        <path
          d="M25.1339 21.5834C25.1339 21.5834 25.1913 21.7078 25.2009 21.8514C25.2009 21.9949 25.1722 22.1385 25.1722 22.1385V21.8514C25.1626 21.7365 25.1147 21.6887 25.1147 21.66L25.1339 21.5834V21.5834Z"
          fill="#AB6D29"
        />
        <path
          d="M25.4308 22.1289V22.3203C25.4116 22.3682 25.3351 22.2725 25.2776 22.0811C25.2298 21.8897 25.2394 21.8514 25.2011 21.7557C25.1532 21.66 25.1341 21.5834 25.1341 21.5834L25.2394 21.5643L25.4308 22.1385V22.1289ZM24.8948 22.4926C24.8948 22.4926 25.1054 22.3682 25.1341 22.0141C25.1341 21.8514 25.0384 21.5834 25.0384 21.5834C25.0384 21.5834 25.0384 21.8705 24.9618 22.0619L24.8183 22.3586L24.8948 22.3108L24.9522 22.2246V22.349L24.8948 22.4926V22.4926ZM24.713 21.8705C24.713 21.8705 24.713 21.9471 24.6173 22.0141C24.5312 22.0906 24.378 22.1672 24.378 22.1672C24.378 22.1672 24.4929 22.0619 24.5312 21.9662C24.579 21.8705 24.5407 21.8131 24.5407 21.8131C24.5407 21.8131 24.5312 21.8609 24.4833 21.9088C24.4354 21.9567 24.3589 21.9471 24.3589 21.9471C24.3589 21.9471 24.3589 21.8992 24.4067 21.8514C24.4163 21.8418 24.4067 21.8131 24.4259 21.794C24.445 21.7174 24.512 21.6121 24.512 21.6121C24.512 21.6121 24.5599 21.727 24.6077 21.7748L24.713 21.8705V21.8705Z"
          fill="#4D2A15"
        />
        <path
          d="M25.3637 21.4494C25.3637 21.4494 25.4115 21.5738 25.4307 21.7557C25.4498 21.9279 25.4307 22.1385 25.4307 22.1385L25.2967 21.8992C25.268 21.8322 25.268 21.7365 25.2488 21.6791C25.2265 21.6472 25.197 21.621 25.1627 21.6025L25.0861 21.593C25.0861 21.593 25.1531 21.5642 25.1531 21.5068V21.4303C25.2194 21.4592 25.2933 21.4659 25.3637 21.4494V21.4494ZM24.8947 22.1959C24.8947 22.1959 25.0096 22.0428 25.0383 21.8418C25.067 21.6504 25.0383 21.5834 25.0383 21.5834C25.0383 21.5834 24.9904 21.5738 24.9426 21.5355C24.8947 21.4973 24.8469 21.4016 24.8469 21.4016C24.8469 21.4016 24.866 21.4973 24.8469 21.6312C24.8277 21.7557 24.7129 21.8705 24.7129 21.8705C24.7129 21.8705 24.7703 21.8896 24.8277 21.8609C24.9426 21.7939 24.9234 21.6695 24.9234 21.6695C24.9234 21.6695 24.9521 21.6887 24.9521 21.8418C24.9521 21.9949 24.8947 22.1959 24.8947 22.1959V22.1959Z"
          fill="#1E2121"
        />
        <path
          d="M23.5643 22.4639C23.5356 22.4639 23.6313 22.3107 23.6983 22.2055L23.861 21.9471C23.861 21.9471 23.8801 21.9662 23.9184 21.9662C23.9573 21.9602 23.9945 21.946 24.0275 21.9246C24.0605 21.9031 24.0886 21.8749 24.1098 21.8418C24.1403 21.7812 24.1629 21.7168 24.1768 21.6504C24.1768 21.6217 24.1768 21.7844 24.2534 21.8705C24.3299 21.9662 24.3204 21.9566 24.3491 21.9471C24.3491 21.9471 24.3491 22.0619 24.3204 22.1576L24.2629 22.416C24.2629 22.416 24.2725 22.2246 24.2438 22.1672C24.2151 22.1098 24.196 22.1672 24.1672 22.2437C24.1385 22.3107 24.0811 22.3586 24.0811 22.3586L24.1577 22.1863C24.1864 22.0906 24.1672 22.0906 24.1577 22.0906C24.1577 22.0906 24.1385 22.0906 24.1098 22.1193C24.0811 22.1576 24.0428 22.1672 24.0428 22.1672C24.0428 22.1672 24.0811 22.1385 24.1003 22.0906C24.1003 22.0428 24.1481 21.9758 24.1672 21.9566L24.2055 21.8801C24.2055 21.8609 24.2055 21.8227 24.1864 21.8227C24.1672 21.8227 24.1481 21.8514 24.0811 21.9184C24.0045 21.9853 23.9854 21.9853 23.9854 22.0141L23.9184 22.2055C23.8969 22.2814 23.868 22.3552 23.8323 22.4256L23.794 22.4639L23.8514 22.2725C23.8897 22.1768 23.9471 22.0332 23.928 22.0141C23.9184 21.9949 23.8897 21.9949 23.8801 22.0141C23.8706 22.0332 23.7844 22.1193 23.7174 22.2246C23.6504 22.3299 23.6504 22.4639 23.6313 22.4734H23.5643V22.4639Z"
          fill="#8F4620"
        />
        <path
          d="M25.4308 21.3346C25.4308 21.3442 25.4403 21.4303 25.3638 21.4494C25.3008 21.4683 25.2332 21.4649 25.1724 21.4399V21.325L25.4308 21.3346Z"
          fill="#874F20"
        />
        <path
          d="M23.9283 21.5834L23.8708 21.7461C23.823 21.8418 23.756 21.9088 23.7656 21.9184C23.7656 21.9279 23.8134 21.9758 23.8804 21.9662C23.9378 21.9662 23.957 21.6025 23.957 21.6025V21.5834H23.9283Z"
          fill="#B27129"
        />
        <path
          d="M24.8849 21.3824C24.8849 21.3824 24.8466 21.8609 24.7127 21.8609C24.5787 21.8609 24.5213 21.6217 24.5213 21.6217C24.5213 21.6217 24.5021 21.9566 24.3299 21.9566C24.2437 21.9566 24.1672 21.6982 24.1767 21.6504C24.1767 21.6504 24.148 21.8227 24.0619 21.8896C23.8992 22.0236 23.7939 21.9566 23.7939 21.9375C23.7843 21.9184 23.9279 21.7748 23.947 21.5834C23.947 21.5834 23.9758 21.593 24.014 21.5355C24.0523 21.4781 24.081 21.4207 24.1097 21.4303C24.1576 21.4303 24.3586 21.3441 24.3586 21.3441L24.4543 21.2197C24.4543 21.2197 24.4734 21.258 24.55 21.2102C24.5943 21.1758 24.6275 21.1292 24.6457 21.0762L24.8562 21.2484L24.8754 21.3824H24.8849Z"
          fill="#DBAD6C"
        />
        <path
          d="M24.3398 20.9135L24.5504 21.2006L24.5982 21.1623C24.6174 21.2006 24.6365 21.2293 24.627 21.258C24.5982 21.325 24.5312 21.4303 24.5791 21.5451C24.5791 21.5451 24.5695 21.4781 24.5982 21.4016C24.627 21.325 24.6461 21.2963 24.6652 21.3059C24.6844 21.3059 24.7131 21.7461 24.7418 21.7461C24.7705 21.7461 24.8088 21.5451 24.8088 21.4016C24.8088 21.258 24.8375 21.3729 24.8566 21.4016C24.8662 21.4303 24.9906 21.6313 25.0959 21.593C25.1916 21.5738 25.1916 21.3824 25.182 21.3441C25.182 21.3059 25.1055 21.057 25.1055 21.057L24.6365 20.7699L24.5982 20.8848C24.5695 20.9613 24.3398 20.9135 24.3398 20.9135V20.9135Z"
          fill="#B27129"
        />
        <path
          d="M25.0001 20.8656C25.0001 20.8656 25.0288 20.8943 25.0767 21.0092C25.1245 21.124 25.1245 21.4973 25.0767 21.4973C25.0097 21.4973 24.8853 21.4303 24.8661 21.3729C24.847 21.325 24.8757 21.1432 24.8374 21.0857C24.7926 21.0222 24.7602 20.9507 24.7417 20.8752L24.7513 20.7316L24.8565 20.6934L25.0097 20.8656H25.0001Z"
          fill="#8F4620"
        />
        <path
          d="M24.9712 20.7508L25.1626 21.0475L25.354 21.2963L25.4306 21.3346C25.4012 21.3676 25.3614 21.3894 25.3178 21.3964C25.2742 21.4034 25.2295 21.3951 25.1913 21.3729C25.1243 21.3346 25.1626 21.2197 25.0765 21.0283C25.019 20.9132 24.9334 20.8145 24.8276 20.7412L24.8851 20.6934L24.9808 20.7508H24.9712Z"
          fill="#4D2A15"
        />
        <path
          d="M24.866 20.5976C24.866 20.5976 25.0383 20.7029 25.1053 20.8369L25.2775 21.1623C25.3541 21.2867 25.4402 21.325 25.4307 21.3346C25.4307 21.3441 25.3828 21.3537 25.335 21.3346C25.2944 21.3005 25.2617 21.2581 25.2393 21.2101L25.0479 20.8848C24.9965 20.8263 24.9348 20.7776 24.866 20.7412C24.866 20.7508 24.9139 20.7795 24.9904 20.9039C25.0379 20.9756 25.0675 21.0576 25.0766 21.1432L24.9809 20.99C24.9234 20.8752 24.7799 20.7316 24.7703 20.7508L24.8852 20.9805L24.9809 21.2293L24.8469 21.0092C24.7703 20.8848 24.7512 20.9039 24.7225 20.8656L24.6172 20.7316C24.6172 20.7316 24.6842 20.7508 24.7607 20.7029C24.8277 20.6551 24.8564 20.5881 24.8564 20.5881L24.866 20.5976Z"
          fill="#1E2121"
        />
        <path
          d="M24.4067 20.9135C24.4067 20.9135 24.5216 20.9422 24.5886 20.9326H24.6747C24.6747 20.9326 24.713 20.9805 24.713 21.0379C24.713 21.0953 24.6651 21.2006 24.6556 21.2102C24.6364 21.2102 24.6364 21.1145 24.6077 21.0762C24.5474 21.018 24.4835 20.9636 24.4163 20.9135H24.4067Z"
          fill="#8F4620"
        />
        <path
          d="M24.4735 21.2197C24.4735 21.2197 24.5118 21.3441 24.4735 21.5068C24.4544 21.6887 24.3491 21.8609 24.33 21.8609C24.3013 21.8609 24.3108 21.6695 24.3013 21.5738C24.3014 21.5611 24.3014 21.5483 24.3013 21.5355L24.2534 21.6504C24.2534 21.6408 24.2917 21.4686 24.2821 21.459V21.392L24.4065 21.2389L24.4735 21.2197Z"
          fill="#B27129"
        />
        <path
          d="M24.2535 21.3441C24.2152 21.392 24.1578 21.3729 24.1195 21.392C24.0717 21.4016 24.0525 21.4781 24.0525 21.4781C24.0525 21.4781 24.0908 21.4494 24.11 21.459C24.1291 21.459 24.1482 21.459 24.11 21.5547C24.0717 21.6313 23.9377 21.7748 23.9473 21.7844C23.9473 21.7844 24.1004 21.66 24.1387 21.593C24.1961 21.5164 24.1865 21.4781 24.1961 21.4494C24.2057 21.4207 24.2631 21.392 24.2822 21.392C24.2822 21.392 24.3205 21.392 24.3301 21.4494L24.3684 21.6408C24.3981 21.5799 24.4206 21.5156 24.4354 21.4494L24.4449 21.2293L24.3971 21.2197L24.2822 21.1527C24.2822 21.1527 24.3014 21.2867 24.2535 21.3441V21.3441Z"
          fill="#8F4620"
        />
        <path
          d="M24.866 20.4637C24.866 20.4637 24.9139 20.5881 24.8182 20.6647C24.7895 20.6934 24.7607 20.7029 24.7129 20.7125C24.6555 20.7125 24.5789 20.6647 24.5789 20.6647L24.2822 20.5402L24.1195 20.4924L24.043 20.4732L24.0525 20.3871L24.2918 20.3967L24.5215 20.4924L24.6172 20.5211L24.7129 20.5307H24.7703L24.8277 20.5211L24.8564 20.4924L24.866 20.4637V20.4637Z"
          fill="#DBAD6C"
        />
        <path
          d="M24.8661 20.4637C24.8757 20.4828 24.847 20.5594 24.8278 20.5594C24.8087 20.569 24.7608 20.5881 24.6747 20.5689C24.579 20.5498 24.4929 20.4924 24.3876 20.4732C24.2919 20.435 24.2249 20.4158 24.1483 20.4158C24.0718 20.4158 24.1005 20.3775 24.1005 20.3775C24.1005 20.3775 24.2823 20.3584 24.4354 20.4158C24.5886 20.4732 24.6556 20.5115 24.7321 20.5115C24.847 20.5115 24.8661 20.4637 24.8661 20.4637Z"
          fill="#AB6D29"
        />
        <path
          d="M24.0527 20.3775H24.1197C24.1484 20.3775 24.1676 20.3584 24.1676 20.3584L24.158 20.4062H24.0623V20.3775H24.0527Z"
          fill="#4D2A15"
        />
        <path
          d="M24.6361 20.7412C24.6361 20.7412 24.7414 20.8369 24.7127 20.9326L24.5213 20.8369L24.1863 20.7029L24.0141 20.6455L23.9854 20.6168L24.0428 20.5594V20.502L24.2629 20.5307L24.4926 20.5977L24.6361 20.7412Z"
          fill="#DBAD6C"
        />
        <path
          d="M24.4162 20.8848C24.4162 20.8848 24.6076 21.124 24.5598 21.2101L24.1291 20.923L23.9664 21.1814L23.6123 21.0092C23.6123 21.0092 23.8994 20.7891 23.9377 20.7412L23.9664 20.6838L24.1291 20.7221L24.3875 20.7986L24.4162 20.8943V20.8848Z"
          fill="#DBAD6C"
        />
        <path
          d="M24.3111 20.5307C24.3111 20.5307 24.4643 20.569 24.5695 20.6264C24.6652 20.6647 24.7992 20.6838 24.7992 20.6838C24.7992 20.6838 24.7418 20.7412 24.6365 20.7412C24.6078 20.7412 24.5312 20.6838 24.4834 20.6455C24.4355 20.6072 24.292 20.569 24.292 20.569L24.3111 20.5307V20.5307Z"
          fill="#AB6D29"
        />
        <path
          d="M24.043 20.4445L24.2248 20.5019C24.2918 20.5307 24.2918 20.5211 24.3205 20.5211L24.3301 20.5019C24.3301 20.5019 24.3492 20.5689 24.2918 20.5689C24.2344 20.5689 24.2248 20.5498 24.1578 20.5211C24.0908 20.4924 24.043 20.5211 24.043 20.5211V20.4541V20.4445Z"
          fill="#4D2A15"
        />
        <path
          d="M24.6457 20.8752C24.6457 20.8752 24.7318 20.923 24.7127 20.9326C24.7031 20.9326 24.6553 20.9613 24.5883 20.9613C24.5213 20.9613 24.4926 20.9613 24.4447 20.9422C24.3969 20.923 24.3682 20.8369 24.2533 20.7891C24.1822 20.7574 24.1086 20.7318 24.0332 20.7125L23.9375 20.6934L24.0141 20.6646L24.2629 20.7125L24.4734 20.7795L24.5979 20.8369L24.6457 20.8752V20.8752ZM24.2342 21.0187L24.282 21.2101L24.2533 21.3346L24.1863 21.3728L24.1289 21.3537L24.1098 21.3154C24.1098 21.3154 24.1385 21.2676 24.1098 21.2293C24.0811 21.191 23.9566 21.1336 23.9566 21.1336C23.9566 21.1336 24.0045 21.0379 24.0523 21.0187C24.1193 20.9996 24.0906 20.923 24.0906 20.923L24.2342 21.0187V21.0187Z"
          fill="#AB6D29"
        />
        <path
          d="M23.9856 20.6168C23.9856 20.6168 24.0239 20.6551 24.11 20.6646L24.2727 20.6934C24.2919 20.7029 24.3493 20.6742 24.3589 20.6742L24.311 20.7029L24.5024 20.7699C24.5886 20.8082 24.6555 20.8656 24.6555 20.8656L24.5024 20.7986C24.428 20.7695 24.3511 20.7471 24.2727 20.7316C24.1196 20.7029 23.9761 20.7125 23.9378 20.7029C23.9091 20.6934 23.9569 20.6934 23.9665 20.6742C23.9856 20.6551 23.9856 20.6168 23.9856 20.6168V20.6168Z"
          fill="#4D2A15"
        />
        <path
          d="M24.5406 21.1527C24.5406 21.1527 24.5885 21.2102 24.5406 21.2293C24.4928 21.2484 24.3492 21.2389 24.2918 21.1719L24.2535 21.0762C24.2248 21.0475 24.1291 20.9805 24.0621 20.9518C24.0143 20.9135 24.0908 20.9039 24.0908 20.9039L24.3684 21.0283C24.4449 21.0666 24.5406 21.1527 24.5406 21.1527V21.1527Z"
          fill="#AB6D29"
        />
        <path
          d="M24.5501 21.1623C24.5501 21.1623 24.4544 21.0283 24.1673 20.9135L24.2534 20.8943H24.1099C24.0877 20.8844 24.0654 20.8748 24.0429 20.8656C23.8897 20.8274 23.8802 20.8274 23.8706 20.8082C23.8706 20.7891 23.8419 20.8082 23.8323 20.8369C23.8144 20.8633 23.7952 20.8889 23.7749 20.9135C23.8369 20.8941 23.9027 20.8908 23.9663 20.9039C24.0524 20.9231 24.0524 20.9518 24.0429 20.99C24.0429 21.0188 23.9376 21.1432 23.9472 21.1432C23.9567 21.1432 24.0142 21.0283 24.0907 21.0475C24.1673 21.0666 24.1864 21.1049 24.1864 21.1049L24.1769 21.0379C24.1577 21.0188 24.0812 20.9422 24.1003 20.9422C24.1194 20.9422 24.2151 20.9709 24.3491 21.0379C24.4831 21.1049 24.5022 21.124 24.5405 21.1623H24.5501Z"
          fill="#4D2A15"
        />
        <path
          d="M24.0908 20.9422C24.0908 20.9422 24.3014 21.0092 24.2918 21.2293C24.2918 21.459 24.1195 21.4207 24.1004 21.3346C24.0908 21.2484 24.1291 21.3729 24.1865 21.3633C24.2535 21.3537 24.2631 21.2867 24.2631 21.2006C24.2631 21.1145 24.2344 21.0762 24.1865 21.0283C24.1567 20.9974 24.1247 20.9686 24.0908 20.9422V20.9422Z"
          fill="#DBAD6C"
        />
        <path
          d="M23.1626 20.4062C23.1626 20.4062 23.1913 20.4062 23.1244 20.5785C23.0884 20.6962 23.0262 20.8042 22.9425 20.8943C22.7703 21.0857 22.6937 21.0857 22.7128 21.1623C22.732 21.2484 22.799 21.2293 22.8085 21.2293C22.8277 21.2293 23.1435 20.7699 23.1435 20.7699L23.2105 20.5019L23.1913 20.4254L23.1722 20.3967L23.1626 20.4062Z"
          fill="#6C3F18"
        />
        <path
          d="M23.9378 20.0713C23.9378 20.0713 24.0335 20.2053 23.9952 20.4541C23.9665 20.7125 23.6315 20.9326 23.6315 20.9326L23.153 21.2772L22.9425 21.258H22.8851C22.8468 21.2484 22.8181 21.2197 22.8181 21.2197C22.7989 21.2197 22.7798 21.124 22.7798 21.124L22.8372 21.0475L23.019 20.8752L23.1243 20.7125C23.1243 20.7125 23.1817 20.6168 23.1817 20.5307C23.1913 20.435 23.1722 20.3967 23.1722 20.3967L23.2104 20.4637L23.2296 20.5977L23.2104 20.7508L23.3444 20.6551L23.5071 20.5881C23.5071 20.5881 23.555 20.5785 23.5933 20.4924C23.622 20.3967 23.6507 20.2531 23.6507 20.1861V20.0522H23.6698C23.6698 20.0617 23.7177 20.1479 23.7177 20.1861L23.7464 20.3967L23.8325 20.3201L23.8995 20.2053C23.9187 20.167 23.9378 20.1096 23.9378 20.0713V20.0713Z"
          fill="#DBAD6C"
        />
        <path
          d="M23.9953 21.3441C23.9953 21.3441 24.024 21.3633 24.0145 21.459C24.0049 21.5547 23.9187 21.6025 23.89 21.6025V21.4781L23.7848 21.3824L23.6699 21.3537L23.6891 21.3346C23.6986 21.3154 23.823 21.2676 23.823 21.2676L23.9953 21.3441Z"
          fill="#904720"
        />
        <path
          d="M23.909 21.3441C23.909 21.3441 23.9377 21.3728 23.9951 21.3633C24.0525 21.3537 24.0717 21.2676 24.043 21.2293C24.0142 21.191 24.0238 21.3058 23.9951 21.325C23.9568 21.325 23.9185 21.2293 23.8707 21.2293C23.8228 21.2101 23.7463 21.2484 23.7271 21.2771C23.708 21.3058 23.8037 21.2771 23.8037 21.2771L23.8611 21.2963L23.8994 21.3058V21.3441H23.909Z"
          fill="#AB6D29"
        />
        <path
          d="M23.201 20.99C23.201 20.99 23.268 21.0092 23.335 20.9996C23.402 20.99 23.5742 20.923 23.5742 20.923L23.7082 20.8273C23.7656 20.7604 23.9475 20.6551 23.9666 20.4254C23.9857 20.2053 23.9379 20.0713 23.9379 20.0713C23.9379 20.0713 24.2059 20.3584 23.9666 20.6934C23.8135 20.9135 23.6795 20.9805 23.6795 20.9805C23.6795 20.9805 23.9475 20.9039 23.9666 20.9709C23.9857 21.0283 23.957 21.124 23.9475 21.1432C23.9475 21.1432 24.091 21.1719 24.1197 21.2484C24.1293 21.2963 23.9475 21.2006 23.8135 21.2293C23.739 21.2459 23.6718 21.2862 23.6221 21.3441C23.6221 21.3441 23.5934 21.3059 23.4785 21.3059C23.3541 21.3059 23.2967 21.3633 23.2297 21.3537C23.1627 21.3537 22.9426 21.3059 22.9043 21.2484L23.0479 21.0857C23.1148 20.9613 23.201 20.99 23.201 20.99V20.99Z"
          fill="#904720"
        />
        <path
          d="M23.7559 20.3871C23.7559 20.3871 23.8611 20.2914 23.8994 20.2053L23.9377 20.0713C23.9377 20.0713 23.9473 20.1479 23.8898 20.2436C23.8506 20.2991 23.8057 20.3504 23.7559 20.3967V20.3871Z"
          fill="#AB6D29"
        />
        <path
          d="M23.7273 20.1574C23.7273 20.1574 23.823 20.4828 23.7273 20.6264C23.6316 20.7604 23.2393 20.9326 23.2393 20.9326C23.2393 20.9326 23.5359 20.7699 23.6221 20.5881C23.7178 20.3967 23.7178 20.2436 23.7178 20.2436L23.7273 20.1479V20.1574Z"
          fill="#904720"
        />
        <path
          d="M23.335 20.9996C23.335 20.9996 23.4594 20.9996 23.5264 20.9517C23.6029 20.9135 23.7082 20.8178 23.7082 20.8178C23.7082 20.8178 23.6125 20.9039 23.5838 20.9039C23.5551 20.9039 23.5359 20.856 23.5455 20.8273C23.5455 20.8273 23.5264 20.8943 23.4689 20.9326C23.4291 20.9635 23.3836 20.9863 23.335 20.9996V20.9996ZM23.6221 20.5881C23.6221 20.5881 23.7369 20.4732 23.7369 20.2435C23.7369 20.0139 23.6412 20.0521 23.6412 20.0521C23.6412 20.0521 23.7178 20.1096 23.6986 20.2818C23.6891 20.4637 23.6316 20.5881 23.6316 20.5881H23.6221ZM23.7561 20.6072C23.7561 20.6072 23.8805 20.5785 23.9187 20.5115C23.9666 20.4349 23.9666 20.301 23.9666 20.301C23.9666 20.301 23.9475 20.4254 23.9187 20.4732C23.8805 20.5211 23.7561 20.6072 23.7561 20.6072V20.6072ZM23.6891 21.3346C23.6891 21.3346 23.7465 21.2197 23.823 21.2389C23.9092 21.2771 23.9092 21.3346 23.9092 21.3346C23.9092 21.3346 23.8805 21.2963 23.8135 21.2867C23.7684 21.291 23.7254 21.3076 23.6891 21.3346V21.3346ZM23.4594 21.124L23.7465 21.0474L23.9666 20.9709C23.9666 20.9709 23.8805 21.0666 23.7561 21.1527C23.6221 21.2197 23.5168 21.2293 23.5168 21.2293C23.5168 21.2293 23.7561 21.124 23.7752 21.0762C23.7752 21.0762 23.5455 21.1432 23.4594 21.124Z"
          fill="#1E2121"
        />
        <path
          d="M23.1818 20.856C23.2263 20.8865 23.2568 20.9334 23.2666 20.9863C23.2765 21.0393 23.2649 21.094 23.2345 21.1384C23.204 21.1828 23.1572 21.2133 23.1042 21.2232C23.0513 21.233 22.9966 21.2215 22.9521 21.191"
          fill="white"
        />
        <path
          d="M23.172 20.8752C23.1999 20.9062 23.2163 20.946 23.2184 20.9877C23.2205 21.0295 23.2082 21.0707 23.1834 21.1044C23.1587 21.138 23.1232 21.1622 23.0827 21.1728C23.0423 21.1833 22.9995 21.1796 22.9614 21.1623"
          fill="#F16E16"
        />
        <path
          d="M23.086 20.9805C23.1006 20.9791 23.1152 20.982 23.1282 20.9887C23.1412 20.9953 23.152 21.0056 23.1593 21.0182C23.1666 21.0309 23.1702 21.0453 23.1696 21.0599C23.169 21.0745 23.1642 21.0886 23.1558 21.1006C23.1474 21.1126 23.1358 21.1219 23.1223 21.1275C23.1088 21.133 23.094 21.1346 23.0796 21.1321C23.0652 21.1295 23.0519 21.1229 23.0412 21.113C23.0304 21.1031 23.0228 21.0903 23.019 21.0762"
          fill="black"
        />
        <path
          d="M23.105 21.0666C23.1037 21.0729 23.1 21.0785 23.0946 21.0821C23.0892 21.0857 23.0826 21.087 23.0763 21.0857C23.0699 21.0845 23.0643 21.0807 23.0607 21.0754C23.0571 21.07 23.0558 21.0634 23.0571 21.057C23.0566 21.0535 23.0571 21.0498 23.0586 21.0465C23.0601 21.0432 23.0624 21.0404 23.0654 21.0384C23.0685 21.0364 23.072 21.0353 23.0756 21.0352C23.0792 21.0351 23.0827 21.0361 23.0858 21.0379C23.0858 21.0379 23.105 21.0475 23.105 21.0666V21.0666Z"
          fill="#D5D3CA"
        />
        <path
          d="M23.2294 20.7221C23.2294 20.7221 23.3442 20.6072 23.3729 20.4541C23.3921 20.301 23.3729 20.2148 23.3729 20.2148L23.4399 20.2818L23.4687 20.3967L23.4304 20.5881L23.5548 20.5307C23.6275 20.3821 23.6605 20.2172 23.6505 20.0522C23.6505 20.0522 23.6792 20.1191 23.6313 20.3393C23.5835 20.5594 23.5452 20.5881 23.3825 20.6838C23.2574 20.758 23.1574 20.868 23.0954 20.9996C23.0447 21.0864 22.9836 21.1668 22.9136 21.2389C22.9136 21.2389 22.9997 21.124 23.038 21.0283C23.105 20.8943 23.172 20.8178 23.172 20.8178L23.2294 20.7221V20.7221Z"
          fill="#AB6D29"
        />
        <path
          d="M23.1722 20.8178C23.1722 20.8178 23.22 20.6646 23.22 20.5785C23.22 20.4924 23.1626 20.3967 23.1626 20.3967C23.1626 20.3967 23.2392 20.3967 23.2487 20.5689C23.2487 20.7603 23.22 20.7603 23.1722 20.8178Z"
          fill="#904720"
        />
        <path
          d="M23.402 20.6264C23.402 20.6264 23.4594 20.4828 23.4594 20.3967C23.4594 20.301 23.3828 20.2148 23.3828 20.2148C23.3828 20.2148 23.4785 20.234 23.4785 20.4062C23.4785 20.5689 23.4594 20.5689 23.402 20.6264V20.6264Z"
          fill="#4D2A15"
        />
        <path
          d="M22.866 21.2484C22.866 21.2484 22.8182 21.191 22.8277 21.1527C22.8277 21.1049 22.8277 21.0953 22.933 20.9805C23.0107 20.9129 23.0756 20.8319 23.1244 20.7412C23.1531 20.6838 23.2393 20.5211 23.1723 20.3967C23.1723 20.3967 23.2201 20.5881 23.1148 20.7221C23.0446 20.8309 22.9573 20.9279 22.8564 21.0092C22.7607 21.0762 22.7607 21.1049 22.7607 21.1432C22.7607 21.1814 22.7703 21.2101 22.7895 21.2197C22.8182 21.2389 22.866 21.2389 22.866 21.2389V21.2484Z"
          fill="#AB6D29"
        />
        <path
          d="M23.89 21.6025C23.89 21.6025 23.9092 21.6025 23.9283 21.5738C23.9379 21.5547 23.9379 21.5068 23.8996 21.459C23.8695 21.4145 23.8259 21.3809 23.7752 21.3633L23.6221 21.3441C23.6221 21.3441 23.6508 21.4016 23.7178 21.4398C23.7561 21.459 23.8135 21.4399 23.8518 21.4686C23.8805 21.5068 23.89 21.6025 23.89 21.6025V21.6025Z"
          fill="#6C4119"
        />
        <path
          d="M23.8896 21.6025C23.8896 21.6025 24.0045 21.5642 24.0141 21.4494L24.0045 21.3537C24.0045 21.3537 24.0236 21.392 24.0715 21.4111L24.1098 21.392C24.1098 21.392 24.0428 21.6121 23.8896 21.6025Z"
          fill="#6C4119"
        />
        <path
          d="M23.0669 21.5834L23.1339 21.6408L23.2009 21.7078L23.488 21.6313L23.5837 21.5451L23.4976 21.4207H23.2966L23.0669 21.5834V21.5834Z"
          fill="#BF802D"
        />
        <path
          d="M23.7558 21.4877L23.708 21.4111C23.708 21.4111 23.6888 21.3824 23.6506 21.3633C23.6123 21.3346 23.44 21.3442 23.44 21.3442L23.3156 21.3633C23.3156 21.3633 23.2773 21.4016 23.2199 21.3824L23.0094 21.3154L22.8754 21.2484C22.8754 21.2484 22.7701 21.2102 22.7414 21.2197C22.7222 21.2197 22.6457 21.3154 22.6457 21.3154C22.6457 21.3154 22.617 21.3729 22.6553 21.3729C22.684 21.3729 22.6074 21.392 22.6074 21.392C22.6074 21.392 22.3873 21.5068 22.3586 21.7174C22.3203 21.9279 22.7127 22.2438 22.8562 22.0811C22.8562 22.0811 22.6457 21.9279 22.684 21.794C22.7222 21.6695 22.8275 21.5834 22.9902 21.5738C23.1529 21.5738 23.1625 21.5451 23.239 21.4973C23.306 21.4399 23.44 21.4111 23.5453 21.5164C23.641 21.6217 23.1625 21.7174 23.1625 21.7174L23.2199 21.794C23.2199 21.794 23.8037 21.593 23.7558 21.4877V21.4877Z"
          fill="#F9C83A"
          stroke="#8F4620"
          strokeWidth="0.0287109"
        />
        <path
          d="M22.6553 21.9853C22.6553 21.9853 22.416 21.9279 22.4352 21.7078C22.4457 21.6379 22.4755 21.5722 22.5211 21.5182C22.5667 21.4641 22.6264 21.4237 22.6936 21.4015C22.7319 21.392 22.7223 21.2771 22.7606 21.2676C22.7988 21.258 22.8754 21.2676 22.9137 21.2963C22.9424 21.3346 23.019 21.3633 23.019 21.3633C23.019 21.3633 22.5979 21.5547 22.5883 21.7939C22.5883 21.9566 22.6553 21.9853 22.6553 21.9853V21.9853Z"
          fill="#FCF3D8"
        />
        <path
          d="M23.7557 21.459C23.7557 21.459 23.727 21.4781 23.7174 21.459C23.6792 21.3824 23.5739 21.3633 23.4878 21.3633C23.3825 21.3633 23.3059 21.4016 23.2294 21.4016L23.0954 21.3824C22.9997 21.3824 22.8274 21.2484 22.7796 21.258C22.7413 21.2771 22.7221 21.325 22.7317 21.3537C22.7317 21.3729 22.6551 21.3824 22.636 21.3537C22.6169 21.325 22.703 21.2197 22.7796 21.2197C22.9805 21.2197 23.1337 21.3537 23.2294 21.3537C23.3251 21.3537 23.3538 21.3059 23.4878 21.3059C23.6217 21.3059 23.7557 21.3633 23.7557 21.459V21.459Z"
          fill="#FDEAAF"
        />
        <path
          d="M23.1053 21.6217L23.268 21.5643L23.4402 21.5068L23.2871 21.6025L23.1244 21.6408L23.0957 21.6217H23.1053Z"
          fill="#513625"
        />
        <path
          d="M22.7607 22.1098C22.7512 22.1193 22.665 22.1098 22.5311 22.0236C22.3971 21.9375 22.3588 21.7844 22.3588 21.7844C22.3588 21.7844 22.3301 21.6408 22.4736 21.4973C22.6076 21.3441 22.6268 21.392 22.6363 21.4016V21.4111L22.5119 21.5068L22.4449 21.6121L22.3971 21.7078V21.8035L22.4641 21.9184L22.6555 22.0428L22.7607 22.1098V22.1098Z"
          fill="#F9C83A"
        />
        <path
          d="M22.6936 21.2867L22.684 21.2676V21.2867V21.2676V21.2867V21.2676L22.6648 21.2772H22.684V21.2676L22.6648 21.2772L22.684 21.2676H22.6648V21.2772L22.684 21.2676H22.6648H22.684L22.6648 21.258H22.684H22.6648H22.684H22.6648H22.684H22.6648C22.6507 21.2728 22.6379 21.2888 22.6266 21.3059C22.6159 21.3198 22.6093 21.3363 22.6074 21.3537C22.6074 21.3729 22.6266 21.392 22.6361 21.4016H22.751C22.753 21.3998 22.7546 21.3976 22.7558 21.3951C22.7569 21.3926 22.7575 21.3899 22.7575 21.3872C22.7575 21.3845 22.7569 21.3818 22.7558 21.3793C22.7546 21.3769 22.753 21.3747 22.751 21.3729C22.7491 21.3695 22.7463 21.3669 22.7429 21.3652C22.7395 21.3634 22.7356 21.3628 22.7318 21.3633H22.684C22.6746 21.3657 22.6647 21.3657 22.6553 21.3633V21.3537C22.6537 21.3474 22.6537 21.3409 22.6553 21.3346C22.6635 21.3209 22.6731 21.308 22.684 21.2963V21.2867H22.6936V21.2676C22.694 21.2638 22.6934 21.26 22.6917 21.2566C22.69 21.2531 22.6873 21.2503 22.684 21.2484C22.6804 21.2479 22.6768 21.2485 22.6735 21.2499C22.6702 21.2514 22.6674 21.2538 22.6654 21.2568C22.6634 21.2598 22.6623 21.2633 22.6622 21.2669C22.6621 21.2705 22.663 21.2741 22.6648 21.2772C22.6666 21.2792 22.6688 21.2808 22.6713 21.2819C22.6738 21.2831 22.6765 21.2836 22.6792 21.2836C22.6819 21.2836 22.6846 21.2831 22.6871 21.2819C22.6895 21.2808 22.6918 21.2792 22.6936 21.2772V21.2867Z"
          fill="#8B5122"
        />
        <path
          d="M23.0953 21.4877L22.8082 21.5738C22.7795 21.593 22.8943 21.5738 22.9805 21.5738C23.0153 21.5683 23.0509 21.5683 23.0857 21.5738H23.1527C23.2676 21.526 23.4973 21.4399 23.5164 21.5356C23.5356 21.6313 23.2006 21.6983 23.2006 21.6983V21.727L23.4686 21.66L23.6025 21.593L23.6504 21.5164L23.5164 21.4207H23.325L23.2293 21.4494L23.0953 21.4877V21.4877Z"
          fill="#F9C83A"
        />
        <path
          d="M22.6838 21.8992C22.7029 21.9566 22.7508 22.0428 22.7986 22.0715C22.7986 22.0715 22.8082 22.0715 22.7986 22.0715C22.7986 22.0906 22.7604 22.1098 22.6742 22.0906C22.5785 22.0619 22.4445 22.0236 22.3584 21.7748V21.8227L22.4062 21.9184L22.502 22.0141L22.6359 22.1098L22.7316 22.1289L22.8178 22.1098L22.8561 22.0811L22.7699 22.0045L22.6742 21.8322V21.8992H22.6838Z"
          fill="#8F4620"
        />
        <path
          d="M23.6315 24.4354V24.5311H23.5741L23.5837 24.4066L23.6315 24.4354ZM23.2679 21.8035L23.1722 21.6982H23.1147L23.2104 21.8322L23.2679 21.8035Z"
          fill="#FCCA3D"
        />
        <path
          d="M23.6221 24.6555L23.4977 24.5789L23.3062 24.531V24.5598H23.3254C23.382 24.5659 23.4371 24.5821 23.4881 24.6076C23.531 24.6272 23.5725 24.6496 23.6125 24.6746L23.6221 24.6555V24.6555ZM23.6221 24.4162H23.4115C23.335 24.4353 23.2967 24.4736 23.2967 24.4736L23.3062 24.4928C23.3636 24.4491 23.4354 24.4286 23.5072 24.4353C23.5423 24.4343 23.5774 24.4343 23.6125 24.4353V24.4162H23.6221ZM23.5934 24.2152L23.402 24.3109L23.268 24.4066L23.2871 24.4258L23.3254 24.3971L23.4115 24.3396C23.4728 24.3029 23.5368 24.2709 23.6029 24.2439L23.5934 24.2152V24.2152ZM23.4594 24.0047C23.4614 24.0377 23.4548 24.0707 23.4402 24.1004C23.4254 24.1204 23.4094 24.1396 23.3924 24.1578L23.268 24.2918L23.201 24.3588L23.2105 24.3779C23.249 24.3398 23.2873 24.3016 23.3254 24.2631L23.4115 24.1674L23.4594 24.11C23.4881 24.0621 23.4881 24.0143 23.4881 24.0143H23.4594V24.0047ZM23.2967 23.909C23.309 23.9662 23.3057 24.0257 23.2871 24.0812L23.2105 24.2439L23.1723 24.3205L23.1627 24.3492H23.1818C23.1818 24.3492 23.2775 24.1865 23.3062 24.0908C23.3191 24.0539 23.3256 24.0151 23.3254 23.976V23.909H23.2967V23.909ZM23.134 23.8898C23.1318 23.9217 23.1318 23.9537 23.134 23.9855C23.1369 24.0273 23.1336 24.0692 23.1244 24.11C23.1089 24.1579 23.0929 24.2058 23.0766 24.2535L23.0479 24.3301H23.067L23.1436 24.1195C23.1627 24.0812 23.1627 24.0238 23.1627 23.976V23.8898H23.134V23.8898ZM23.0096 23.8898V23.9855L23 24.1291C22.9857 24.1926 22.9729 24.2564 22.9617 24.3205H22.9809L22.9904 24.2631L23.0191 24.1387C23.0383 24.0525 23.0383 23.8898 23.0383 23.8898H23.0096V23.8898ZM22.8852 23.9185C22.8773 23.9885 22.8773 24.0591 22.8852 24.1291C22.8564 24.2057 22.8469 24.3205 22.8469 24.3205H22.8756C22.8817 24.2594 22.8913 24.1987 22.9043 24.1387V23.909H22.8852V23.9185ZM22.7799 23.9185V23.9377C22.7799 23.9664 22.7799 24.0334 22.7512 24.11L22.7129 24.2535L22.6937 24.3301L22.7129 24.3396L22.7799 24.1195C22.7945 24.0601 22.801 23.9989 22.799 23.9377V23.9281H22.7799V23.9185ZM22.6555 23.9281V23.976C22.6555 24.0238 22.6555 24.0908 22.6268 24.1387C22.6076 24.1865 22.5598 24.2248 22.5311 24.2535C22.5096 24.2707 22.4873 24.2867 22.4641 24.3014H22.4545L22.4641 24.3205C22.4641 24.3205 22.598 24.2439 22.6555 24.1482C22.6837 24.0785 22.6936 24.0027 22.6842 23.9281H22.6555V23.9281ZM22.5885 23.909V23.9185C22.5708 23.9702 22.545 24.0187 22.5119 24.0621L22.4162 24.1578L22.3684 24.1769L22.3492 24.1865L22.3588 24.2152C22.3588 24.2152 22.4736 24.1482 22.5311 24.0812C22.5789 24.0143 22.6076 23.909 22.6076 23.909H22.5885V23.909ZM22.4736 23.8516V23.8611C22.4616 23.8776 22.4488 23.8936 22.4354 23.909C22.4354 23.9281 22.4162 23.9473 22.4066 23.9568L22.3301 24.0047C22.3143 24.0145 22.2983 24.0241 22.2822 24.0334L22.2918 24.0525L22.3396 24.0238L22.4162 23.976L22.4736 23.909L22.4928 23.8611L22.4736 23.8516V23.8516ZM22.4162 23.775L22.3971 23.8037C22.3755 23.8268 22.3532 23.8492 22.3301 23.8707C22.318 23.8841 22.3052 23.8969 22.2918 23.909L22.2631 23.9281V23.9473L22.3205 23.9185L22.4354 23.7941L22.4162 23.775V23.775ZM22.3971 23.7271L22.3779 23.7463L22.3109 23.7846L22.2439 23.8133V23.842C22.2631 23.842 22.2727 23.842 22.2918 23.8228L22.4066 23.7463L22.3971 23.7271V23.7271ZM22.3684 23.6793L22.3109 23.708C22.2983 23.7147 22.2856 23.7211 22.2727 23.7271C22.2609 23.7354 22.248 23.7419 22.2344 23.7463V23.7654L22.2822 23.7559L22.3779 23.6984V23.6793H22.3684ZM22.3492 23.574C22.3348 23.5886 22.3188 23.6015 22.3014 23.6123L22.2344 23.641V23.6602C22.2727 23.6602 22.3014 23.641 22.3301 23.6219C22.3436 23.6134 22.3564 23.6038 22.3684 23.5932L22.3492 23.574V23.574ZM22.3492 23.4018L22.3109 23.44L22.2535 23.5166C22.2509 23.5203 22.2477 23.5236 22.2439 23.5262V23.5549L22.2631 23.5453C22.2674 23.5396 22.2707 23.5331 22.2727 23.5262C22.2727 23.507 22.3014 23.4879 22.3301 23.4592L22.3588 23.44L22.3684 23.4209L22.3588 23.4018H22.3492ZM23.1723 22.4256H23.2967V22.4064V22.4256V22.416V22.4256V22.416V22.4256V22.416L23.2871 22.4256V22.416V22.4256V22.416H23.2775H23.2871H23.2775V22.4064H23.2871H23.1723V22.4256V22.4256ZM23.1723 22.349H23.1818L23.2393 22.3394L23.3158 22.2916L23.3445 22.2629C23.3539 22.2605 23.3638 22.2605 23.3732 22.2629V22.2342L23.3254 22.2533L23.2488 22.3012L23.1818 22.3299V22.349H23.1723ZM23.1723 22.2342C23.1818 22.2342 23.201 22.2342 23.2201 22.215L23.3158 22.1576L23.3828 22.1289V22.1002L23.335 22.1193L23.2393 22.1768L23.1627 22.215V22.2342H23.1723ZM23.1244 22.1385L23.2393 22.0428L23.3637 21.9566L23.3541 21.9375L23.2297 22.0332L23.1148 22.1098L23.1244 22.1289V22.1385ZM23.0479 22.0141L23.2967 21.8322L23.2775 21.8131L23.0287 21.9949L23.0479 22.0141ZM22.933 21.8896L23.0766 21.7939L23.1914 21.7174L23.1818 21.6982L23.067 21.7748L22.9234 21.8705L22.933 21.8896ZM22.8564 21.8227C22.9228 21.7739 22.9898 21.726 23.0574 21.6791L23.1148 21.6408V21.6217C23.0919 21.6299 23.0696 21.6395 23.0479 21.6504C22.9769 21.7004 22.9067 21.7514 22.8373 21.8035L22.8564 21.8227Z"
          fill="#816C2A"
        />
        <path
          d="M23.0479 21.5834L23.0574 21.593C23.1276 21.6501 23.1917 21.7142 23.2488 21.7844C23.3254 21.8801 23.3828 21.9949 23.3828 22.1002V22.1385C23.3583 22.2822 23.2917 22.4154 23.1914 22.5213C23.0479 22.7031 22.8277 22.8563 22.6555 23.0094C22.5696 23.0796 22.4924 23.1599 22.4258 23.2486C22.3674 23.3262 22.3341 23.4197 22.3301 23.5166V23.5262C22.3301 23.6219 22.3684 23.7176 22.4258 23.7846C22.452 23.8261 22.487 23.8613 22.5284 23.8878C22.5697 23.9142 22.6164 23.9313 22.665 23.9377C22.6842 23.9388 22.7033 23.9388 22.7225 23.9377C22.8564 23.9377 23.0096 23.8899 23.1531 23.8899C23.268 23.8899 23.3828 23.9186 23.4881 24.0334C23.5838 24.1387 23.6125 24.3109 23.6125 24.4736C23.6121 24.5796 23.6025 24.6852 23.5838 24.7895C23.576 24.8377 23.5664 24.8855 23.5551 24.933H23.5742C23.5742 24.933 23.6412 24.7129 23.6412 24.4736C23.6412 24.3109 23.6029 24.1291 23.5072 24.0143C23.4624 23.9658 23.4074 23.9278 23.3462 23.903C23.285 23.8782 23.2191 23.8672 23.1531 23.8707C23 23.8707 22.8564 23.909 22.7225 23.909H22.665C22.621 23.9034 22.5786 23.8886 22.5407 23.8655C22.5028 23.8424 22.4701 23.8116 22.4449 23.775C22.393 23.702 22.3631 23.6157 22.3588 23.5262V23.5166C22.3588 23.3922 22.4162 23.2869 22.5119 23.1817C22.6459 23.0285 22.8564 22.8754 23.0383 22.7031C23.2297 22.55 23.3828 22.3682 23.4115 22.1289V22.1002C23.4115 21.9662 23.3158 21.8322 23.2297 21.727C23.1773 21.6677 23.1196 21.6132 23.0574 21.5643L23.0479 21.5834V21.5834Z"
          fill="#78732E"
        />
        <path
          d="M22.866 21.8227L22.8373 21.7939L22.8086 21.8035L22.8564 21.8418L22.866 21.8227ZM22.9426 21.8896L22.9234 21.8705H22.9043L22.9234 21.8992L22.9426 21.8896Z"
          fill="#A8AC71"
        />
        <path
          d="M23.0479 22.0141L23.0287 21.9854L23.0191 22.0045L23.0383 22.0236L23.0479 22.0141ZM23.1244 22.1289V22.1098H23.0957L23.1244 22.1385V22.1289ZM23.1723 22.2437V22.215H23.1627V22.2437H23.1723ZM23.1723 22.3586V22.3203V22.3586ZM23.1723 22.4256V22.3969V22.4352V22.4256ZM22.2439 23.5645L22.2535 23.507C22.2631 23.4783 22.2344 23.5166 22.2344 23.5166V23.5549H22.2439V23.5645Z"
          fill="#78732E"
        />
        <path d="M22.2342 23.6314H22.2246V23.6697H22.2342V23.6314Z" fill="white" />
        <path d="M22.2437 23.7654V23.7367H22.2246V23.7846L22.2437 23.7654Z" fill="#78732E" />
        <path
          d="M22.2535 23.842V23.8133H22.2344V23.842H22.2535ZM22.2727 23.9473L22.2631 23.9186V23.9568L22.2727 23.9473ZM22.3014 24.0621L22.2822 24.0238V24.0621H22.3014Z"
          fill="white"
        />
        <path
          d="M22.3681 24.2152L22.3585 24.1865H22.3394L22.3585 24.2152H22.3681ZM22.4829 24.3205L22.4446 24.2918C22.4255 24.2727 22.4351 24.3109 22.4351 24.3109L22.4638 24.3301L22.4829 24.3205V24.3205ZM23.2294 24.3779L23.2007 24.3588L23.2198 24.3875V24.3779H23.2294Z"
          fill="#A8AC71"
        />
        <path d="M23.2963 24.4258L23.2676 24.4066V24.4258H23.2867H23.2963Z" fill="white" />
        <path
          d="M23.3062 24.4545L23.2871 24.4736L23.3158 24.4928L23.3062 24.4545V24.4545ZM23.3062 24.5598V24.5215C23.3062 24.5119 23.3062 24.5215 23.3062 24.5215V24.5598Z"
          fill="#A8AC71"
        />
        <path
          d="M23.2773 24.6746V24.6459L23.2582 24.6746H23.2773ZM22.1289 20.6838C22.1289 20.6838 22.1768 20.6742 22.1385 20.7221L22.1672 20.6838L22.148 20.6742L22.1289 20.6838V20.6838Z"
          fill="white"
        />
        <path d="M23.0574 21.5547L23.0861 21.5834L23.0479 21.5738L23.0574 21.5547V21.5547Z" fill="#F9C83A" />
        <path d="M23.0857 21.5834H23.0283L23.0475 21.5738H23.0857V21.5834Z" fill="#8F4620" />
        <path
          d="M23.5356 24.933C23.5356 24.933 23.5739 24.933 23.5835 24.9043C23.6026 24.8852 23.5835 24.933 23.5835 24.933L23.5548 24.9426L23.5356 24.933Z"
          fill="#977C2E"
        />
      </g>
      <defs>
        <radialGradient
          id="paint0_radial_2407_229"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(22.9791 26.1306) rotate(22.9539) scale(0.289529 0.289746)"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="#F15770" />
        </radialGradient>
        <radialGradient
          id="paint1_radial_2407_229"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(21.0023 25.1741) rotate(-95.2719) scale(0.287121 0.266491)"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="#F15770" />
        </radialGradient>
        <radialGradient
          id="paint2_radial_2407_229"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(28.2916 26.7668) rotate(50.0373) scale(0.149546 0.293603)"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="#F15770" />
        </radialGradient>
        <clipPath id="clip0_2407_229">
          <path
            d="M0.5 25C0.5 11.469 11.469 0.5 25 0.5V0.5C38.531 0.5 49.5 11.469 49.5 25V25C49.5 38.531 38.531 49.5 25 49.5V49.5C11.469 49.5 0.5 38.531 0.5 25V25Z"
            fill="white"
          />
        </clipPath>
      </defs>
    </svg>
  )
}

export default MXN_ICON
