import { Path, Svg } from 'react-native-svg'
import { createIcon } from '../factories/createIcon'

export const [EmptyTokensIcon, AnimatedEmptyTokensIcon] = createIcon({
  name: 'EmptyTokensIcon',
  getIcon: (props) => (
    <Svg width="115" height="115" viewBox="0 0 115 115" fill="none" {...props}>
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M22.0146 49.4697C25.0091 49.4698 26.5067 50.9674 26.5068 53.9619V56.957C26.5068 59.9517 25.0092 61.4491 22.0146 61.4492H19.0195C16.0247 61.4492 14.5273 59.9518 14.5273 56.957V53.9619C14.5275 50.9673 16.0248 49.4697 19.0195 49.4697H22.0146ZM42.9775 49.4697C45.9722 49.4697 47.4696 50.9673 47.4697 53.9619V56.957C47.4697 59.9518 45.9723 61.4492 42.9775 61.4492H39.9834C36.9886 61.4492 35.4912 59.9518 35.4912 56.957V53.9619C35.4913 50.9673 36.9887 49.4697 39.9834 49.4697H42.9775ZM63.9414 49.4697C66.472 49.4697 67.933 50.5393 68.3252 52.6777C64.4856 54.653 61.2029 57.5572 58.7705 61.0918C57.2265 60.4855 56.4541 59.1074 56.4541 56.957V53.9619C56.4542 50.9674 57.9518 49.4698 60.9463 49.4697H63.9414ZM22.0146 29.1055C25.0092 29.1056 26.5068 30.603 26.5068 33.5977V36.5928C26.5067 39.5872 25.0091 41.0849 22.0146 41.085H19.0195C16.0248 41.085 14.5275 39.5873 14.5273 36.5928V33.5977C14.5273 30.6029 16.0247 29.1055 19.0195 29.1055H22.0146ZM42.9775 29.1055C45.9723 29.1055 47.4697 30.6029 47.4697 33.5977V36.5928C47.4696 39.5873 45.9722 41.085 42.9775 41.085H39.9834C36.9887 41.085 35.4913 39.5873 35.4912 36.5928V33.5977C35.4912 30.6029 36.9886 29.1055 39.9834 29.1055H42.9775ZM63.9414 29.1055C66.9362 29.1055 68.4336 30.6029 68.4336 33.5977V36.5928C68.4335 39.5873 66.9361 41.085 63.9414 41.085H60.9463C57.9518 41.0849 56.4542 39.5872 56.4541 36.5928V33.5977C56.4541 30.603 57.9517 29.1056 60.9463 29.1055H63.9414ZM68.5 18C69.8807 18 71 19.1193 71 20.5C71 21.8807 69.8807 23 68.5 23H14.5C13.1193 23 12 21.8807 12 20.5C12 19.1193 13.1193 18 14.5 18H68.5Z"
        fill={props.color || 'currentColor'}
        opacity={0.5}
      />
      <Path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M80.2031 97.8125C92.3534 97.8125 102.203 87.9628 102.203 75.8125C102.203 63.6622 92.3534 53.8125 80.2031 53.8125C68.0529 53.8125 58.2031 63.6622 58.2031 75.8125C58.2031 87.9628 68.0529 97.8125 80.2031 97.8125ZM88.4524 75.8122L80.2027 67.5625L71.9531 75.8122L80.2027 84.0619L88.4524 75.8122Z"
        fill={props.color || 'currentColor'}
      />
    </Svg>
  ),
})
