export enum FiatCurrency {
  AustralianDollar = 'AUD',
  BrazilianReal = 'BRL',
  CanadianDollar = 'CAD',
  ChineseYuan = 'CNY',
  Euro = 'EUR',
  BritishPound = 'GBP',
  HongKongDollar = 'HKD',
  IndonesianRupiah = 'IDR',
  IndianRupee = 'INR',
  JapaneseYen = 'JPY',
  NigerianNaira = 'NGN',
  PakistaniRupee = 'PKR',
  RussianRuble = 'RUB',
  SingaporeDollar = 'SGD',
  SouthKoreanWon = 'KRW',
  ThaiBaht = 'THB',
  TurkishLira = 'TRY',
  UkrainianHryvnia = 'UAH',
  UnitedStatesDollar = 'USD',
  VietnameseDong = 'VND',
}

export const DEFAULT_LOCAL_CURRENCY: FiatCurrency = FiatCurrency.UnitedStatesDollar

export const ORDERED_CURRENCIES: FiatCurrency[] = [
  FiatCurrency.UnitedStatesDollar,
  FiatCurrency.AustralianDollar,
  FiatCurrency.BrazilianReal,
  FiatCurrency.CanadianDollar,
  FiatCurrency.ChineseYuan,
  FiatCurrency.Euro,
  FiatCurrency.BritishPound,
  FiatCurrency.HongKongDollar,
  FiatCurrency.IndonesianRupiah,
  FiatCurrency.IndianRupee,
  FiatCurrency.JapaneseYen,
  FiatCurrency.SouthKoreanWon,
  FiatCurrency.NigerianNaira,
  FiatCurrency.PakistaniRupee,
  FiatCurrency.RussianRuble,
  FiatCurrency.SingaporeDollar,
  FiatCurrency.ThaiBaht,
  FiatCurrency.TurkishLira,
  FiatCurrency.UkrainianHryvnia,
  FiatCurrency.VietnameseDong,
]
