import { Path, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [Clear, AnimatedClear] = createIcon({
  name: 'Clear',
  getIcon: (props) => (
    <Svg viewBox="0 0 16 16" fill="none" {...props}>
      <Path
        d="M7.99992 1.33337C4.31992 1.33337 1.33325 4.32004 1.33325 8.00004C1.33325 11.68 4.31992 14.6667 7.99992 14.6667C11.6799 14.6667 14.6666 11.68 14.6666 8.00004C14.6666 4.32004 11.6799 1.33337 7.99992 1.33337ZM10.3532 9.64669C10.5466 9.84002 10.5466 10.1601 10.3532 10.3534C10.2533 10.4534 10.1266 10.5 9.99992 10.5C9.87325 10.5 9.74658 10.4534 9.64658 10.3534L7.99992 8.7067L6.35325 10.3534C6.25325 10.4534 6.12658 10.5 5.99992 10.5C5.87325 10.5 5.74659 10.4534 5.64659 10.3534C5.45325 10.1601 5.45325 9.84002 5.64659 9.64669L7.29325 8.00004L5.64659 6.35339C5.45325 6.16006 5.45325 5.84002 5.64659 5.64669C5.83992 5.45335 6.15992 5.45335 6.35325 5.64669L7.99992 7.29337L9.64658 5.64669C9.83992 5.45335 10.1599 5.45335 10.3532 5.64669C10.5466 5.84002 10.5466 6.16006 10.3532 6.35339L8.70658 8.00004L10.3532 9.64669Z"
        fill={'currentColor' ?? '#7D7D7D'}
      />
    </Svg>
  ),
  defaultFill: '#7D7D7D',
})
