import { Path, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [OnboardingUnicon, AnimatedOnboardingUnicon] = createIcon({
  name: 'Unicon',
  getIcon: (props) => (
    <Svg fill="none" viewBox="0 0 29 29" {...props}>
      <Path
        clipRule="evenodd"
        d="M12.0604 12.0605C12.2325 11.8884 12.4911 11.8416 12.7207 11.9219C13.3109 12.1283 13.9454 12.2404 14.6061 12.2404C15.2187 12.2404 15.8087 12.144 16.3619 11.9654C16.6157 11.8835 16.8981 11.9368 17.0867 12.1254V12.1254C17.2753 12.314 17.3286 12.5964 17.2467 12.8502C17.0681 13.4034 16.9717 13.9935 16.9717 14.6061C16.9717 15.3179 17.1019 15.9992 17.3398 16.6277C17.4174 16.8328 17.377 17.0669 17.222 17.222V17.222C17.0669 17.377 16.8328 17.4174 16.6277 17.3398C15.9992 17.1019 15.3179 16.9717 14.6061 16.9717C13.9934 16.9717 13.4033 17.0681 12.8501 17.2467C12.5963 17.3286 12.3139 17.2753 12.1254 17.0867V17.0867C11.9368 16.8982 11.8835 16.6158 11.9654 16.362C12.144 15.8088 12.2404 15.2187 12.2404 14.6061C12.2404 13.9454 12.1282 13.3109 11.9219 12.7207C11.8416 12.4911 11.8884 12.2325 12.0604 12.0605V12.0605ZM20.7428 8.46935C20.3783 8.1049 20.2447 7.5778 20.2924 7.0646C20.3088 6.88837 20.3172 6.70981 20.3172 6.5293C20.3172 3.37513 17.7602 0.818176 14.6061 0.818176C11.4519 0.818176 8.89493 3.37513 8.89493 6.5293C8.89493 6.65376 8.89891 6.77729 8.90675 6.89977C8.94205 7.4511 8.79503 8.01374 8.40438 8.40439V8.40439C8.01374 8.79504 7.45109 8.94206 6.89976 8.90676C6.77728 8.89892 6.65376 8.89494 6.5293 8.89494C3.37513 8.89494 0.818176 11.4519 0.818176 14.6061C0.818176 17.7602 3.37513 20.3172 6.5293 20.3172C6.70979 20.3172 6.88832 20.3088 7.06453 20.2924C7.57774 20.2447 8.10486 20.3783 8.46931 20.7428V20.7428C8.83377 21.1073 8.96738 21.6344 8.91968 22.1476C8.9033 22.3238 8.89493 22.5023 8.89493 22.6828C8.89493 25.837 11.4519 28.3939 14.6061 28.3939C17.7602 28.3939 20.3172 25.837 20.3172 22.6828C20.3172 22.6201 20.3162 22.5576 20.3142 22.4954C20.295 21.9012 20.4576 21.2984 20.878 20.878V20.878C21.2984 20.4577 21.9012 20.295 22.4954 20.3142C22.5576 20.3162 22.6201 20.3172 22.6828 20.3172C25.837 20.3172 28.3939 17.7602 28.3939 14.6061C28.3939 11.4519 25.837 8.89494 22.6828 8.89494C22.5023 8.89494 22.3237 8.90331 22.1475 8.91969C21.6343 8.9674 21.1072 8.83379 20.7428 8.46935V8.46935Z"
        fill={'currentColor' ?? '#767BFB'}
        fillOpacity="0.85"
        fillRule="evenodd"
      />
    </Svg>
  ),
  defaultFill: '#767BFB',
})
