# Swift Mobile GraphQL Schema

This Framework contains autogenerated code that is generated from running Apollo iOS graphQL codegen. This code is not checked in, but the generated files are referenced for the XCode build process.

## Generating the Swift GraphQL Schema

`yarn mobile ios:prebuild`

## Verifying Schema Changes

When the schema is changed, please verify the build process still works.

Run `yarn mobile ios` and ensure it builds successfully. This will implicitly run `yarn mobile ios:prebuild` which will clean and regenerate the swift files.

If an error does occur, check the errors via building in XCode for more detailed logs. Then either remove freshly deleted file references or add files to the project that may be required. If needed, adapt the Swift usages of the schema.

## Adding Generated Files

To add new graphql queries or fragments to Swift:

1. Ensure the file is listed in `apps/mobile/ios/apollo-codegen-config.json`'s `"operationSearchPaths"` and `"schemaSearchPaths"`
2. Add the needed generated files to the XCode project. To add new files, right-click the `WidgetsCore` folder in XCode, and select `add files to "Uniswap"...`. Then select the fragments, operations, and schema folder and keep create groups checked. Then click add.
