import { useTheme } from 'lib/styled-components'
import { ComponentProps } from 'react'

export const WalletOneLinkQR = (props: ComponentProps<'svg'>) => {
  const theme = useTheme()
  const bg = theme.darkMode ? 'black' : 'white'

  return (
    <svg width="300" height="300" viewBox="0 0 300 300" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
      <g clipPath="url(#clip0_12_3375)">
        <path
          d="M277.215 0H22.7848C10.2011 0 0 10.2011 0 22.7848V277.215C0 289.799 10.2011 300 22.7848 300H277.215C289.799 300 300 289.799 300 277.215V22.7848C300 10.2011 289.799 0 277.215 0Z"
          fill={bg}
        />
        <path
          d="M7.59497 11.0682C7.59497 11.9894 7.96091 12.8729 8.61227 13.5242C9.26364 14.1756 10.1471 14.5415 11.0683 14.5415C11.9894 14.5415 12.8729 14.1756 13.5243 13.5242C14.1756 12.8729 14.5416 11.9894 14.5416 11.0682C14.5416 10.1471 14.1756 9.26361 13.5243 8.61224C12.8729 7.96088 11.9894 7.59494 11.0683 7.59494C10.1471 7.59494 9.26364 7.96088 8.61227 8.61224C7.96091 9.26361 7.59497 10.1471 7.59497 11.0682ZM14.5416 11.0682C14.5416 11.9894 14.9075 12.8729 15.5589 13.5242C16.2102 14.1756 17.0937 14.5415 18.0149 14.5415C18.936 14.5415 19.8195 14.1756 20.4708 13.5242C21.1222 12.8729 21.4881 11.9894 21.4881 11.0682C21.4881 10.1471 21.1222 9.26361 20.4708 8.61224C19.8195 7.96088 18.936 7.59494 18.0149 7.59494C17.0937 7.59494 16.2102 7.96088 15.5589 8.61224C14.9075 9.26361 14.5416 10.1471 14.5416 11.0682ZM21.4881 11.0682C21.4881 11.9894 21.8541 12.8729 22.5055 13.5242C23.1568 14.1756 24.0403 14.5415 24.9614 14.5415C25.8826 14.5415 26.7661 14.1756 27.4174 13.5242C28.0688 12.8729 28.4347 11.9894 28.4347 11.0682C28.4347 10.1471 28.0688 9.26361 27.4174 8.61224C26.7661 7.96088 25.8826 7.59494 24.9614 7.59494C24.0403 7.59494 23.1568 7.96088 22.5055 8.61224C21.8541 9.26361 21.4881 10.1471 21.4881 11.0682ZM28.4347 11.0682C28.4347 11.9894 28.8007 12.8729 29.452 13.5242C30.1034 14.1756 30.9869 14.5415 31.908 14.5415C32.8292 14.5415 33.7126 14.1756 34.364 13.5242C35.0154 12.8729 35.3813 11.9894 35.3813 11.0682C35.3813 10.1471 35.0154 9.26361 34.364 8.61224C33.7126 7.96088 32.8292 7.59494 31.908 7.59494C30.9869 7.59494 30.1034 7.96088 29.452 8.61224C28.8007 9.26361 28.4347 10.1471 28.4347 11.0682ZM35.3813 11.0682C35.3813 11.9894 35.7473 12.8729 36.3986 13.5242C37.05 14.1756 37.9334 14.5415 38.8546 14.5415C39.7758 14.5415 40.6592 14.1756 41.3106 13.5242C41.962 12.8729 42.3279 11.9894 42.3279 11.0682C42.3279 10.1471 41.962 9.26361 41.3106 8.61224C40.6592 7.96088 39.7758 7.59494 38.8546 7.59494C37.9334 7.59494 37.05 7.96088 36.3986 8.61224C35.7473 9.26361 35.3813 10.1471 35.3813 11.0682ZM42.3279 11.0682C42.3279 11.5244 42.4177 11.976 42.5923 12.3974C42.7668 12.8188 43.0227 13.2017 43.3452 13.5242C43.6677 13.8467 44.0506 14.1026 44.472 14.2771C44.8934 14.4517 45.3451 14.5415 45.8012 14.5415C46.2573 14.5415 46.709 14.4517 47.1304 14.2771C47.5518 14.1026 47.9347 13.8467 48.2572 13.5242C48.5797 13.2017 48.8356 12.8188 49.0101 12.3974C49.1847 11.976 49.2745 11.5244 49.2745 11.0682C49.2745 10.6121 49.1847 10.1605 49.0101 9.73906C48.8356 9.31766 48.5797 8.93477 48.2572 8.61224C47.9347 8.28972 47.5518 8.03388 47.1304 7.85933C46.709 7.68478 46.2573 7.59494 45.8012 7.59494C45.3451 7.59494 44.8934 7.68478 44.472 7.85933C44.0506 8.03388 43.6677 8.28972 43.3452 8.61224C43.0227 8.93477 42.7668 9.31766 42.5923 9.73906C42.4177 10.1605 42.3279 10.6121 42.3279 11.0682ZM49.2745 11.0682C49.2745 11.5244 49.3643 11.976 49.5389 12.3974C49.7134 12.8188 49.9693 13.2017 50.2918 13.5242C50.6143 13.8467 50.9972 14.1026 51.4186 14.2771C51.84 14.4517 52.2917 14.5415 52.7478 14.5415C53.2039 14.5415 53.6556 14.4517 54.077 14.2771C54.4984 14.1026 54.8813 13.8467 55.2038 13.5242C55.5263 13.2017 55.7821 12.8188 55.9567 12.3974C56.1312 11.976 56.2211 11.5244 56.2211 11.0682C56.2211 10.6121 56.1312 10.1605 55.9567 9.73906C55.7821 9.31766 55.5263 8.93477 55.2038 8.61224C54.8813 8.28972 54.4984 8.03388 54.077 7.85933C53.6556 7.68478 53.2039 7.59494 52.7478 7.59494C52.2917 7.59494 51.84 7.68478 51.4186 7.85933C50.9972 8.03388 50.6143 8.28972 50.2918 8.61224C49.9693 8.93477 49.7134 9.31766 49.5389 9.73906C49.3643 10.1605 49.2745 10.6121 49.2745 11.0682ZM77.0609 11.0682C77.0609 11.5244 77.1507 11.976 77.3252 12.3974C77.4998 12.8188 77.7556 13.2017 78.0782 13.5242C78.4007 13.8468 78.7836 14.1026 79.205 14.2771C79.6264 14.4517 80.078 14.5415 80.5341 14.5415C80.9903 14.5415 81.4419 14.4517 81.8633 14.2771C82.2847 14.1026 82.6676 13.8468 82.9901 13.5242C83.3127 13.2017 83.5685 12.8188 83.743 12.3974C83.9176 11.976 84.0074 11.5244 84.0074 11.0682C84.0074 10.6121 83.9176 10.1605 83.743 9.73906C83.5685 9.31766 83.3127 8.93477 82.9901 8.61224C82.6676 8.28972 82.2847 8.03388 81.8633 7.85933C81.4419 7.68478 80.9903 7.59494 80.5341 7.59494C80.078 7.59494 79.6264 7.68478 79.205 7.85933C78.7836 8.03388 78.4007 8.28972 78.0782 8.61224C77.7556 8.93477 77.4998 9.31766 77.3252 9.73906C77.1507 10.1605 77.0609 10.6121 77.0609 11.0682ZM84.0074 11.0682C84.0074 11.9894 84.3734 12.8729 85.0247 13.5242C85.6761 14.1756 86.5596 14.5415 87.4807 14.5415C88.4019 14.5415 89.2854 14.1756 89.9367 13.5242C90.5881 12.8729 90.954 11.9894 90.954 11.0682C90.954 10.1471 90.5881 9.26361 89.9367 8.61224C89.2854 7.96088 88.4019 7.59494 87.4807 7.59494C86.5596 7.59494 85.6761 7.96088 85.0247 8.61224C84.3734 9.26361 84.0074 10.1471 84.0074 11.0682ZM97.9006 11.0682C97.9006 11.5244 97.9905 11.976 98.165 12.3974C98.3396 12.8188 98.5954 13.2017 98.9179 13.5242C99.2404 13.8468 99.6233 14.1026 100.045 14.2771C100.466 14.4517 100.918 14.5415 101.374 14.5415C101.83 14.5415 102.282 14.4517 102.703 14.2771C103.124 14.1026 103.507 13.8468 103.83 13.5242C104.152 13.2017 104.408 12.8188 104.583 12.3974C104.757 11.976 104.847 11.5244 104.847 11.0682C104.847 10.6121 104.757 10.1605 104.583 9.73906C104.408 9.31766 104.152 8.93477 103.83 8.61224C103.507 8.28972 103.124 8.03388 102.703 7.85933C102.282 7.68478 101.83 7.59494 101.374 7.59494C100.918 7.59494 100.466 7.68478 100.045 7.85933C99.6233 8.03388 99.2404 8.28972 98.9179 8.61224C98.5954 8.93477 98.3396 9.31766 98.165 9.73906C97.9905 10.1605 97.9006 10.6121 97.9006 11.0682ZM111.794 11.0682C111.794 11.9894 112.16 12.8729 112.811 13.5242C113.462 14.1756 114.346 14.5415 115.267 14.5415C116.188 14.5415 117.072 14.1756 117.723 13.5242C118.374 12.8729 118.74 11.9894 118.74 11.0682C118.74 10.1471 118.374 9.26361 117.723 8.61224C117.072 7.96088 116.188 7.59494 115.267 7.59494C114.346 7.59494 113.462 7.96088 112.811 8.61224C112.16 9.26361 111.794 10.1471 111.794 11.0682ZM167.366 11.0682C167.366 11.9894 167.732 12.8729 168.384 13.5242C169.035 14.1756 169.919 14.5415 170.84 14.5415C171.761 14.5415 172.644 14.1756 173.296 13.5242C173.947 12.8729 174.313 11.9894 174.313 11.0682C174.313 10.1471 173.947 9.26361 173.296 8.61224C172.644 7.96088 171.761 7.59494 170.84 7.59494C169.919 7.59494 169.035 7.96088 168.384 8.61224C167.732 9.26361 167.366 10.1471 167.366 11.0682ZM181.26 11.0682C181.26 11.9894 181.626 12.8729 182.277 13.5242C182.928 14.1756 183.812 14.5415 184.733 14.5415C185.654 14.5415 186.538 14.1756 187.189 13.5242C187.84 12.8729 188.206 11.9894 188.206 11.0682C188.206 10.1471 187.84 9.26361 187.189 8.61224C186.538 7.96088 185.654 7.59494 184.733 7.59494C183.812 7.59494 182.928 7.96088 182.277 8.61224C181.626 9.26361 181.26 10.1471 181.26 11.0682ZM188.206 11.0682C188.206 11.9894 188.572 12.8729 189.224 13.5242C189.875 14.1756 190.758 14.5415 191.68 14.5415C192.601 14.5415 193.484 14.1756 194.136 13.5242C194.787 12.8729 195.153 11.9894 195.153 11.0682C195.153 10.1471 194.787 9.26361 194.136 8.61224C193.484 7.96088 192.601 7.59494 191.68 7.59494C190.758 7.59494 189.875 7.96088 189.224 8.61224C188.572 9.26361 188.206 10.1471 188.206 11.0682ZM195.153 11.0682C195.153 11.5244 195.243 11.976 195.417 12.3974C195.592 12.8188 195.848 13.2017 196.17 13.5242C196.493 13.8468 196.876 14.1026 197.297 14.2771C197.718 14.4517 198.17 14.5415 198.626 14.5415C199.082 14.5415 199.534 14.4517 199.955 14.2771C200.377 14.1026 200.76 13.8468 201.082 13.5242C201.405 13.2017 201.661 12.8188 201.835 12.3974C202.01 11.976 202.099 11.5244 202.099 11.0682C202.099 10.6121 202.01 10.1605 201.835 9.73906C201.661 9.31766 201.405 8.93477 201.082 8.61224C200.76 8.28972 200.377 8.03388 199.955 7.85933C199.534 7.68478 199.082 7.59494 198.626 7.59494C198.17 7.59494 197.718 7.68478 197.297 7.85933C196.876 8.03388 196.493 8.28972 196.17 8.61224C195.848 8.93477 195.592 9.31766 195.417 9.73906C195.243 10.1605 195.153 10.6121 195.153 11.0682ZM202.099 11.0682C202.099 11.9894 202.465 12.8729 203.117 13.5242C203.768 14.1756 204.652 14.5415 205.573 14.5415C206.494 14.5415 207.377 14.1756 208.029 13.5242C208.68 12.8729 209.046 11.9894 209.046 11.0682C209.046 10.1471 208.68 9.26361 208.029 8.61224C207.377 7.96088 206.494 7.59494 205.573 7.59494C204.652 7.59494 203.768 7.96088 203.117 8.61224C202.465 9.26361 202.099 10.1471 202.099 11.0682ZM209.046 11.0682C209.046 11.9894 209.412 12.8729 210.063 13.5242C210.715 14.1756 211.598 14.5415 212.519 14.5415C213.44 14.5415 214.324 14.1756 214.975 13.5242C215.627 12.8729 215.993 11.9894 215.993 11.0682C215.993 10.1471 215.627 9.26361 214.975 8.61224C214.324 7.96088 213.44 7.59494 212.519 7.59494C211.598 7.59494 210.715 7.96088 210.063 8.61224C209.412 9.26361 209.046 10.1471 209.046 11.0682ZM243.779 11.0682C243.779 11.9894 244.145 12.8729 244.796 13.5242C245.448 14.1756 246.331 14.5415 247.252 14.5415C248.173 14.5415 249.057 14.1756 249.708 13.5242C250.36 12.8729 250.726 11.9894 250.726 11.0682C250.726 10.1471 250.36 9.26361 249.708 8.61224C249.057 7.96088 248.173 7.59494 247.252 7.59494C246.331 7.59494 245.448 7.96088 244.796 8.61224C244.145 9.26361 243.779 10.1471 243.779 11.0682ZM250.726 11.0682C250.726 11.9894 251.091 12.8729 251.743 13.5242C252.394 14.1756 253.278 14.5415 254.199 14.5415C255.12 14.5415 256.003 14.1756 256.655 13.5242C257.306 12.8729 257.672 11.9894 257.672 11.0682C257.672 10.1471 257.306 9.26361 256.655 8.61224C256.003 7.96088 255.12 7.59494 254.199 7.59494C253.278 7.59494 252.394 7.96088 251.743 8.61224C251.091 9.26361 250.726 10.1471 250.726 11.0682ZM257.672 11.0682C257.672 11.9894 258.038 12.8729 258.689 13.5242C259.341 14.1756 260.224 14.5415 261.145 14.5415C262.067 14.5415 262.95 14.1756 263.601 13.5242C264.253 12.8729 264.619 11.9894 264.619 11.0682C264.619 10.1471 264.253 9.26361 263.601 8.61224C262.95 7.96088 262.067 7.59494 261.145 7.59494C260.224 7.59494 259.341 7.96088 258.689 8.61224C258.038 9.26361 257.672 10.1471 257.672 11.0682ZM264.619 11.0682C264.619 11.9894 264.985 12.8729 265.636 13.5242C266.287 14.1756 267.171 14.5415 268.092 14.5415C269.013 14.5415 269.897 14.1756 270.548 13.5242C271.199 12.8729 271.565 11.9894 271.565 11.0682C271.565 10.1471 271.199 9.26361 270.548 8.61224C269.897 7.96088 269.013 7.59494 268.092 7.59494C267.171 7.59494 266.287 7.96088 265.636 8.61224C264.985 9.26361 264.619 10.1471 264.619 11.0682ZM271.565 11.0682C271.565 11.9894 271.931 12.8729 272.583 13.5242C273.234 14.1756 274.117 14.5415 275.039 14.5415C275.96 14.5415 276.843 14.1756 277.495 13.5242C278.146 12.8729 278.512 11.9894 278.512 11.0682C278.512 10.1471 278.146 9.26361 277.495 8.61224C276.843 7.96088 275.96 7.59494 275.039 7.59494C274.117 7.59494 273.234 7.96088 272.583 8.61224C271.931 9.26361 271.565 10.1471 271.565 11.0682ZM278.512 11.0682C278.512 11.9894 278.878 12.8729 279.529 13.5242C280.181 14.1756 281.064 14.5415 281.985 14.5415C282.906 14.5415 283.79 14.1756 284.441 13.5242C285.093 12.8729 285.458 11.9894 285.458 11.0682C285.458 10.1471 285.093 9.26361 284.441 8.61224C283.79 7.96088 282.906 7.59494 281.985 7.59494C281.064 7.59494 280.181 7.96088 279.529 8.61224C278.878 9.26361 278.512 10.1471 278.512 11.0682ZM285.458 11.0682C285.458 11.9894 285.824 12.8729 286.476 13.5242C287.127 14.1756 288.011 14.5415 288.932 14.5415C289.853 14.5415 290.736 14.1756 291.388 13.5242C292.039 12.8729 292.405 11.9894 292.405 11.0682C292.405 10.1471 292.039 9.26361 291.388 8.61224C290.736 7.96088 289.853 7.59494 288.932 7.59494C288.011 7.59494 287.127 7.96088 286.476 8.61224C285.824 9.26361 285.458 10.1471 285.458 11.0682ZM7.59497 18.0148C7.59497 18.936 7.96091 19.8194 8.61227 20.4708C9.26364 21.1222 10.1471 21.4881 11.0683 21.4881C11.9894 21.4881 12.8729 21.1222 13.5243 20.4708C14.1756 19.8194 14.5416 18.936 14.5416 18.0148C14.5416 17.0936 14.1756 16.2102 13.5243 15.5588C12.8729 14.9075 11.9894 14.5415 11.0683 14.5415C10.1471 14.5415 9.26364 14.9075 8.61227 15.5588C7.96091 16.2102 7.59497 17.0936 7.59497 18.0148ZM49.2745 18.0148C49.2745 18.4709 49.3643 18.9226 49.5389 19.344C49.7134 19.7654 49.9693 20.1483 50.2918 20.4708C50.6143 20.7933 50.9972 21.0492 51.4186 21.2237C51.84 21.3983 52.2917 21.4881 52.7478 21.4881C53.2039 21.4881 53.6556 21.3983 54.077 21.2237C54.4984 21.0492 54.8813 20.7933 55.2038 20.4708C55.5263 20.1483 55.7821 19.7654 55.9567 19.344C56.1312 18.9226 56.2211 18.4709 56.2211 18.0148C56.2211 17.5587 56.1312 17.107 55.9567 16.6857C55.7821 16.2643 55.5263 15.8814 55.2038 15.5588C54.8813 15.2363 54.4984 14.9805 54.077 14.8059C53.6556 14.6314 53.2039 14.5415 52.7478 14.5415C52.2917 14.5415 51.84 14.6314 51.4186 14.8059C50.9972 14.9805 50.6143 15.2363 50.2918 15.5588C49.9693 15.8814 49.7134 16.2643 49.5389 16.6857C49.3643 17.107 49.2745 17.5587 49.2745 18.0148ZM63.1677 18.0148C63.1677 18.936 63.5336 19.8194 64.185 20.4708C64.8363 21.1222 65.7198 21.4881 66.641 21.4881C67.5621 21.4881 68.4456 21.1222 69.097 20.4708C69.7483 19.8194 70.1143 18.936 70.1143 18.0148C70.1143 17.0936 69.7483 16.2102 69.097 15.5588C68.4456 14.9075 67.5621 14.5415 66.641 14.5415C65.7198 14.5415 64.8363 14.9075 64.185 15.5588C63.5336 16.2102 63.1677 17.0936 63.1677 18.0148ZM90.954 18.0148C90.954 18.936 91.32 19.8194 91.9713 20.4708C92.6227 21.1222 93.5061 21.4881 94.4273 21.4881C95.3485 21.4881 96.2319 21.1222 96.8833 20.4708C97.5347 19.8194 97.9006 18.936 97.9006 18.0148C97.9006 17.0936 97.5347 16.2102 96.8833 15.5588C96.2319 14.9075 95.3485 14.5415 94.4273 14.5415C93.5061 14.5415 92.6227 14.9075 91.9713 15.5588C91.32 16.2102 90.954 17.0936 90.954 18.0148ZM111.794 18.0148C111.794 18.936 112.16 19.8194 112.811 20.4708C113.462 21.1222 114.346 21.4881 115.267 21.4881C116.188 21.4881 117.072 21.1222 117.723 20.4708C118.374 19.8194 118.74 18.936 118.74 18.0148C118.74 17.0936 118.374 16.2102 117.723 15.5588C117.072 14.9075 116.188 14.5415 115.267 14.5415C114.346 14.5415 113.462 14.9075 112.811 15.5588C112.16 16.2102 111.794 17.0936 111.794 18.0148ZM118.74 18.0148C118.74 18.936 119.106 19.8194 119.758 20.4708C120.409 21.1222 121.292 21.4881 122.214 21.4881C123.135 21.4881 124.018 21.1222 124.67 20.4708C125.321 19.8194 125.687 18.936 125.687 18.0148C125.687 17.0936 125.321 16.2102 124.67 15.5588C124.018 14.9075 123.135 14.5415 122.214 14.5415C121.292 14.5415 120.409 14.9075 119.758 15.5588C119.106 16.2102 118.74 17.0936 118.74 18.0148ZM125.687 18.0148C125.687 18.936 126.053 19.8194 126.704 20.4708C127.356 21.1222 128.239 21.4881 129.16 21.4881C130.081 21.4881 130.965 21.1222 131.616 20.4708C132.268 19.8194 132.634 18.936 132.634 18.0148C132.634 17.0936 132.268 16.2102 131.616 15.5588C130.965 14.9075 130.081 14.5415 129.16 14.5415C128.239 14.5415 127.356 14.9075 126.704 15.5588C126.053 16.2102 125.687 17.0936 125.687 18.0148ZM132.634 18.0148C132.634 18.936 132.999 19.8194 133.651 20.4708C134.302 21.1222 135.186 21.4881 136.107 21.4881C137.028 21.4881 137.911 21.1222 138.563 20.4708C139.214 19.8194 139.58 18.936 139.58 18.0148C139.58 17.0936 139.214 16.2102 138.563 15.5588C137.911 14.9075 137.028 14.5415 136.107 14.5415C135.186 14.5415 134.302 14.9075 133.651 15.5588C132.999 16.2102 132.634 17.0936 132.634 18.0148ZM139.58 18.0148C139.58 18.936 139.946 19.8194 140.597 20.4708C141.249 21.1222 142.132 21.4881 143.053 21.4881C143.975 21.4881 144.858 21.1222 145.509 20.4708C146.161 19.8194 146.527 18.936 146.527 18.0148C146.527 17.0936 146.161 16.2102 145.509 15.5588C144.858 14.9075 143.975 14.5415 143.053 14.5415C142.132 14.5415 141.249 14.9075 140.597 15.5588C139.946 16.2102 139.58 17.0936 139.58 18.0148ZM146.527 18.0148C146.527 18.936 146.893 19.8194 147.544 20.4708C148.195 21.1222 149.079 21.4881 150 21.4881C150.921 21.4881 151.805 21.1222 152.456 20.4708C153.107 19.8194 153.473 18.936 153.473 18.0148C153.473 17.0936 153.107 16.2102 152.456 15.5588C151.805 14.9075 150.921 14.5415 150 14.5415C149.079 14.5415 148.195 14.9075 147.544 15.5588C146.893 16.2102 146.527 17.0936 146.527 18.0148ZM153.473 18.0148C153.473 18.4709 153.563 18.9226 153.738 19.344C153.912 19.7654 154.168 20.1483 154.491 20.4708C154.813 20.7933 155.196 21.0492 155.617 21.2237C156.039 21.3983 156.491 21.4881 156.947 21.4881C157.403 21.4881 157.854 21.3983 158.276 21.2237C158.697 21.0492 159.08 20.7933 159.403 20.4708C159.725 20.1483 159.981 19.7654 160.156 19.344C160.33 18.9226 160.42 18.4709 160.42 18.0148C160.42 17.5587 160.33 17.107 160.156 16.6857C159.981 16.2643 159.725 15.8814 159.403 15.5588C159.08 15.2363 158.697 14.9805 158.276 14.8059C157.854 14.6314 157.403 14.5415 156.947 14.5415C156.491 14.5415 156.039 14.6314 155.617 14.8059C155.196 14.9805 154.813 15.2363 154.491 15.5588C154.168 15.8814 153.912 16.2643 153.738 16.6857C153.563 17.107 153.473 17.5587 153.473 18.0148ZM160.42 18.0148C160.42 18.936 160.786 19.8194 161.437 20.4708C162.089 21.1222 162.972 21.4881 163.893 21.4881C164.814 21.4881 165.698 21.1222 166.349 20.4708C167.001 19.8194 167.366 18.936 167.366 18.0148C167.366 17.0936 167.001 16.2102 166.349 15.5588C165.698 14.9075 164.814 14.5415 163.893 14.5415C162.972 14.5415 162.089 14.9075 161.437 15.5588C160.786 16.2102 160.42 17.0936 160.42 18.0148ZM167.366 18.0148C167.366 18.936 167.732 19.8194 168.384 20.4708C169.035 21.1222 169.919 21.4881 170.84 21.4881C171.761 21.4881 172.644 21.1222 173.296 20.4708C173.947 19.8194 174.313 18.936 174.313 18.0148C174.313 17.0936 173.947 16.2102 173.296 15.5588C172.644 14.9075 171.761 14.5415 170.84 14.5415C169.919 14.5415 169.035 14.9075 168.384 15.5588C167.732 16.2102 167.366 17.0936 167.366 18.0148ZM181.26 18.0148C181.26 18.936 181.626 19.8194 182.277 20.4708C182.928 21.1222 183.812 21.4881 184.733 21.4881C185.654 21.4881 186.538 21.1222 187.189 20.4708C187.84 19.8194 188.206 18.936 188.206 18.0148C188.206 17.0936 187.84 16.2102 187.189 15.5588C186.538 14.9075 185.654 14.5415 184.733 14.5415C183.812 14.5415 182.928 14.9075 182.277 15.5588C181.626 16.2102 181.26 17.0936 181.26 18.0148ZM188.206 18.0148C188.206 18.936 188.572 19.8194 189.224 20.4708C189.875 21.1222 190.758 21.4881 191.68 21.4881C192.601 21.4881 193.484 21.1222 194.136 20.4708C194.787 19.8194 195.153 18.936 195.153 18.0148C195.153 17.0936 194.787 16.2102 194.136 15.5588C193.484 14.9075 192.601 14.5415 191.68 14.5415C190.758 14.5415 189.875 14.9075 189.224 15.5588C188.572 16.2102 188.206 17.0936 188.206 18.0148ZM209.046 18.0148C209.046 18.936 209.412 19.8194 210.063 20.4708C210.715 21.1222 211.598 21.4881 212.519 21.4881C213.44 21.4881 214.324 21.1222 214.975 20.4708C215.627 19.8194 215.993 18.936 215.993 18.0148C215.993 17.0936 215.627 16.2102 214.975 15.5588C214.324 14.9075 213.44 14.5415 212.519 14.5415C211.598 14.5415 210.715 14.9075 210.063 15.5588C209.412 16.2102 209.046 17.0936 209.046 18.0148ZM222.939 18.0148C222.939 18.936 223.305 19.8194 223.957 20.4708C224.608 21.1222 225.491 21.4881 226.413 21.4881C227.334 21.4881 228.217 21.1222 228.868 20.4708C229.52 19.8194 229.886 18.936 229.886 18.0148C229.886 17.0936 229.52 16.2102 228.868 15.5588C228.217 14.9075 227.334 14.5415 226.413 14.5415C225.491 14.5415 224.608 14.9075 223.957 15.5588C223.305 16.2102 222.939 17.0936 222.939 18.0148ZM243.779 18.0148C243.779 18.936 244.145 19.8194 244.796 20.4708C245.448 21.1222 246.331 21.4881 247.252 21.4881C248.173 21.4881 249.057 21.1222 249.708 20.4708C250.36 19.8194 250.726 18.936 250.726 18.0148C250.726 17.0936 250.36 16.2102 249.708 15.5588C249.057 14.9075 248.173 14.5415 247.252 14.5415C246.331 14.5415 245.448 14.9075 244.796 15.5588C244.145 16.2102 243.779 17.0936 243.779 18.0148ZM285.458 18.0148C285.458 18.936 285.824 19.8194 286.476 20.4708C287.127 21.1222 288.011 21.4881 288.932 21.4881C289.853 21.4881 290.736 21.1222 291.388 20.4708C292.039 19.8194 292.405 18.936 292.405 18.0148C292.405 17.0936 292.039 16.2102 291.388 15.5588C290.736 14.9075 289.853 14.5415 288.932 14.5415C288.011 14.5415 287.127 14.9075 286.476 15.5588C285.824 16.2102 285.458 17.0936 285.458 18.0148ZM7.59497 24.9614C7.59497 25.8826 7.96091 26.766 8.61227 27.4174C9.26364 28.0688 10.1471 28.4347 11.0683 28.4347C11.9894 28.4347 12.8729 28.0688 13.5243 27.4174C14.1756 26.766 14.5416 25.8826 14.5416 24.9614C14.5416 24.0402 14.1756 23.1568 13.5243 22.5054C12.8729 21.8541 11.9894 21.4881 11.0683 21.4881C10.1471 21.4881 9.26364 21.8541 8.61227 22.5054C7.96091 23.1568 7.59497 24.0402 7.59497 24.9614ZM21.4881 24.9614C21.4881 25.8826 21.8541 26.766 22.5055 27.4174C23.1568 28.0688 24.0403 28.4347 24.9614 28.4347C25.8826 28.4347 26.7661 28.0688 27.4174 27.4174C28.0688 26.766 28.4347 25.8826 28.4347 24.9614C28.4347 24.0402 28.0688 23.1568 27.4174 22.5054C26.7661 21.8541 25.8826 21.4881 24.9614 21.4881C24.0403 21.4881 23.1568 21.8541 22.5055 22.5054C21.8541 23.1568 21.4881 24.0402 21.4881 24.9614ZM28.4347 24.9614C28.4347 25.8826 28.8007 26.766 29.452 27.4174C30.1034 28.0688 30.9869 28.4347 31.908 28.4347C32.8292 28.4347 33.7126 28.0688 34.364 27.4174C35.0154 26.766 35.3813 25.8826 35.3813 24.9614C35.3813 24.0402 35.0154 23.1568 34.364 22.5054C33.7126 21.8541 32.8292 21.4881 31.908 21.4881C30.9869 21.4881 30.1034 21.8541 29.452 22.5054C28.8007 23.1568 28.4347 24.0402 28.4347 24.9614ZM35.3813 24.9614C35.3813 25.8826 35.7473 26.766 36.3986 27.4174C37.05 28.0688 37.9334 28.4347 38.8546 28.4347C39.7758 28.4347 40.6592 28.0688 41.3106 27.4174C41.962 26.766 42.3279 25.8826 42.3279 24.9614C42.3279 24.0402 41.962 23.1568 41.3106 22.5054C40.6592 21.8541 39.7758 21.4881 38.8546 21.4881C37.9334 21.4881 37.05 21.8541 36.3986 22.5054C35.7473 23.1568 35.3813 24.0402 35.3813 24.9614ZM49.2745 24.9614C49.2745 25.4175 49.3643 25.8692 49.5389 26.2906C49.7134 26.712 49.9693 27.0949 50.2918 27.4174C50.6143 27.7399 50.9972 27.9958 51.4186 28.1703C51.84 28.3449 52.2917 28.4347 52.7478 28.4347C53.2039 28.4347 53.6556 28.3449 54.077 28.1703C54.4984 27.9958 54.8813 27.7399 55.2038 27.4174C55.5263 27.0949 55.7821 26.712 55.9567 26.2906C56.1312 25.8692 56.2211 25.4175 56.2211 24.9614C56.2211 24.5053 56.1312 24.0536 55.9567 23.6322C55.7821 23.2108 55.5263 22.8279 55.2038 22.5054C54.8813 22.1829 54.4984 21.9271 54.077 21.7525C53.6556 21.578 53.2039 21.4881 52.7478 21.4881C52.2917 21.4881 51.84 21.578 51.4186 21.7525C50.9972 21.9271 50.6143 22.1829 50.2918 22.5054C49.9693 22.8279 49.7134 23.2108 49.5389 23.6322C49.3643 24.0536 49.2745 24.5053 49.2745 24.9614ZM70.1143 24.9614C70.1143 25.8826 70.4802 26.766 71.1316 27.4174C71.7829 28.0688 72.6664 28.4347 73.5876 28.4347C74.5087 28.4347 75.3922 28.0688 76.0436 27.4174C76.6949 26.766 77.0609 25.8826 77.0609 24.9614C77.0609 24.0402 76.6949 23.1568 76.0436 22.5054C75.3922 21.8541 74.5087 21.4881 73.5876 21.4881C72.6664 21.4881 71.7829 21.8541 71.1316 22.5054C70.4802 23.1568 70.1143 24.0402 70.1143 24.9614ZM104.847 24.9614C104.847 25.8826 105.213 26.766 105.865 27.4174C106.516 28.0688 107.399 28.4347 108.321 28.4347C109.242 28.4347 110.125 28.0688 110.776 27.4174C111.428 26.766 111.794 25.8826 111.794 24.9614C111.794 24.0402 111.428 23.1568 110.776 22.5054C110.125 21.8541 109.242 21.4881 108.321 21.4881C107.399 21.4881 106.516 21.8541 105.865 22.5054C105.213 23.1568 104.847 24.0402 104.847 24.9614ZM111.794 24.9614C111.794 25.8826 112.16 26.766 112.811 27.4174C113.462 28.0688 114.346 28.4347 115.267 28.4347C116.188 28.4347 117.072 28.0688 117.723 27.4174C118.374 26.766 118.74 25.8826 118.74 24.9614C118.74 24.0402 118.374 23.1568 117.723 22.5054C117.072 21.8541 116.188 21.4881 115.267 21.4881C114.346 21.4881 113.462 21.8541 112.811 22.5054C112.16 23.1568 111.794 24.0402 111.794 24.9614ZM118.74 24.9614C118.74 25.8826 119.106 26.766 119.758 27.4174C120.409 28.0688 121.292 28.4347 122.214 28.4347C123.135 28.4347 124.018 28.0688 124.67 27.4174C125.321 26.766 125.687 25.8826 125.687 24.9614C125.687 24.0402 125.321 23.1568 124.67 22.5054C124.018 21.8541 123.135 21.4881 122.214 21.4881C121.292 21.4881 120.409 21.8541 119.758 22.5054C119.106 23.1568 118.74 24.0402 118.74 24.9614ZM132.634 24.9614C132.634 25.8826 132.999 26.766 133.651 27.4174C134.302 28.0688 135.186 28.4347 136.107 28.4347C137.028 28.4347 137.911 28.0688 138.563 27.4174C139.214 26.766 139.58 25.8826 139.58 24.9614C139.58 24.0402 139.214 23.1568 138.563 22.5054C137.911 21.8541 137.028 21.4881 136.107 21.4881C135.186 21.4881 134.302 21.8541 133.651 22.5054C132.999 23.1568 132.634 24.0402 132.634 24.9614ZM146.527 24.9614C146.527 25.8826 146.893 26.766 147.544 27.4174C148.195 28.0688 149.079 28.4347 150 28.4347C150.921 28.4347 151.805 28.0688 152.456 27.4174C153.107 26.766 153.473 25.8826 153.473 24.9614C153.473 24.0402 153.107 23.1568 152.456 22.5054C151.805 21.8541 150.921 21.4881 150 21.4881C149.079 21.4881 148.195 21.8541 147.544 22.5054C146.893 23.1568 146.527 24.0402 146.527 24.9614ZM153.473 24.9614C153.473 25.4175 153.563 25.8692 153.738 26.2906C153.912 26.712 154.168 27.0949 154.491 27.4174C154.813 27.7399 155.196 27.9958 155.617 28.1703C156.039 28.3449 156.491 28.4347 156.947 28.4347C157.403 28.4347 157.854 28.3449 158.276 28.1703C158.697 27.9958 159.08 27.7399 159.403 27.4174C159.725 27.0949 159.981 26.712 160.156 26.2906C160.33 25.8692 160.42 25.4175 160.42 24.9614C160.42 24.5053 160.33 24.0536 160.156 23.6322C159.981 23.2108 159.725 22.8279 159.403 22.5054C159.08 22.1829 158.697 21.9271 158.276 21.7525C157.854 21.578 157.403 21.4881 156.947 21.4881C156.491 21.4881 156.039 21.578 155.617 21.7525C155.196 21.9271 154.813 22.1829 154.491 22.5054C154.168 22.8279 153.912 23.2108 153.738 23.6322C153.563 24.0536 153.473 24.5053 153.473 24.9614ZM167.366 24.9614C167.366 25.8826 167.732 26.766 168.384 27.4174C169.035 28.0688 169.919 28.4347 170.84 28.4347C171.761 28.4347 172.644 28.0688 173.296 27.4174C173.947 26.766 174.313 25.8826 174.313 24.9614C174.313 24.0402 173.947 23.1568 173.296 22.5054C172.644 21.8541 171.761 21.4881 170.84 21.4881C169.919 21.4881 169.035 21.8541 168.384 22.5054C167.732 23.1568 167.366 24.0402 167.366 24.9614ZM188.206 24.9614C188.206 25.8826 188.572 26.766 189.224 27.4174C189.875 28.0688 190.758 28.4347 191.68 28.4347C192.601 28.4347 193.484 28.0688 194.136 27.4174C194.787 26.766 195.153 25.8826 195.153 24.9614C195.153 24.0402 194.787 23.1568 194.136 22.5054C193.484 21.8541 192.601 21.4881 191.68 21.4881C190.758 21.4881 189.875 21.8541 189.224 22.5054C188.572 23.1568 188.206 24.0402 188.206 24.9614ZM222.939 24.9614C222.939 25.8826 223.305 26.766 223.957 27.4174C224.608 28.0688 225.491 28.4347 226.413 28.4347C227.334 28.4347 228.217 28.0688 228.868 27.4174C229.52 26.766 229.886 25.8826 229.886 24.9614C229.886 24.0402 229.52 23.1568 228.868 22.5054C228.217 21.8541 227.334 21.4881 226.413 21.4881C225.491 21.4881 224.608 21.8541 223.957 22.5054C223.305 23.1568 222.939 24.0402 222.939 24.9614ZM229.886 24.9614C229.886 25.8826 230.252 26.766 230.903 27.4174C231.554 28.0688 232.438 28.4347 233.359 28.4347C234.28 28.4347 235.164 28.0688 235.815 27.4174C236.466 26.766 236.832 25.8826 236.832 24.9614C236.832 24.0402 236.466 23.1568 235.815 22.5054C235.164 21.8541 234.28 21.4881 233.359 21.4881C232.438 21.4881 231.554 21.8541 230.903 22.5054C230.252 23.1568 229.886 24.0402 229.886 24.9614ZM243.779 24.9614C243.779 25.8826 244.145 26.766 244.796 27.4174C245.448 28.0688 246.331 28.4347 247.252 28.4347C248.173 28.4347 249.057 28.0688 249.708 27.4174C250.36 26.766 250.726 25.8826 250.726 24.9614C250.726 24.0402 250.36 23.1568 249.708 22.5054C249.057 21.8541 248.173 21.4881 247.252 21.4881C246.331 21.4881 245.448 21.8541 244.796 22.5054C244.145 23.1568 243.779 24.0402 243.779 24.9614ZM257.672 24.9614C257.672 25.8826 258.038 26.766 258.689 27.4174C259.341 28.0688 260.224 28.4347 261.145 28.4347C262.067 28.4347 262.95 28.0688 263.601 27.4174C264.253 26.766 264.619 25.8826 264.619 24.9614C264.619 24.0402 264.253 23.1568 263.601 22.5054C262.95 21.8541 262.067 21.4881 261.145 21.4881C260.224 21.4881 259.341 21.8541 258.689 22.5054C258.038 23.1568 257.672 24.0402 257.672 24.9614ZM264.619 24.9614C264.619 25.8826 264.985 26.766 265.636 27.4174C266.287 28.0688 267.171 28.4347 268.092 28.4347C269.013 28.4347 269.897 28.0688 270.548 27.4174C271.199 26.766 271.565 25.8826 271.565 24.9614C271.565 24.0402 271.199 23.1568 270.548 22.5054C269.897 21.8541 269.013 21.4881 268.092 21.4881C267.171 21.4881 266.287 21.8541 265.636 22.5054C264.985 23.1568 264.619 24.0402 264.619 24.9614ZM271.565 24.9614C271.565 25.8826 271.931 26.766 272.583 27.4174C273.234 28.0688 274.117 28.4347 275.039 28.4347C275.96 28.4347 276.843 28.0688 277.495 27.4174C278.146 26.766 278.512 25.8826 278.512 24.9614C278.512 24.0402 278.146 23.1568 277.495 22.5054C276.843 21.8541 275.96 21.4881 275.039 21.4881C274.117 21.4881 273.234 21.8541 272.583 22.5054C271.931 23.1568 271.565 24.0402 271.565 24.9614ZM285.458 24.9614C285.458 25.8826 285.824 26.766 286.476 27.4174C287.127 28.0688 288.011 28.4347 288.932 28.4347C289.853 28.4347 290.736 28.0688 291.388 27.4174C292.039 26.766 292.405 25.8826 292.405 24.9614C292.405 24.0402 292.039 23.1568 291.388 22.5054C290.736 21.8541 289.853 21.4881 288.932 21.4881C288.011 21.4881 287.127 21.8541 286.476 22.5054C285.824 23.1568 285.458 24.0402 285.458 24.9614ZM7.59497 31.908C7.59497 32.8292 7.96091 33.7126 8.61227 34.364C9.26364 35.0154 10.1471 35.3813 11.0683 35.3813C11.9894 35.3813 12.8729 35.0154 13.5243 34.364C14.1756 33.7126 14.5416 32.8292 14.5416 31.908C14.5416 30.9868 14.1756 30.1034 13.5243 29.452C12.8729 28.8006 11.9894 28.4347 11.0683 28.4347C10.1471 28.4347 9.26364 28.8006 8.61227 29.452C7.96091 30.1034 7.59497 30.9868 7.59497 31.908ZM21.4881 31.908C21.4881 32.8292 21.8541 33.7126 22.5055 34.364C23.1568 35.0154 24.0403 35.3813 24.9614 35.3813C25.8826 35.3813 26.7661 35.0154 27.4174 34.364C28.0688 33.7126 28.4347 32.8292 28.4347 31.908C28.4347 30.9868 28.0688 30.1034 27.4174 29.452C26.7661 28.8006 25.8826 28.4347 24.9614 28.4347C24.0403 28.4347 23.1568 28.8006 22.5055 29.452C21.8541 30.1034 21.4881 30.9868 21.4881 31.908ZM28.4347 31.908C28.4347 32.8292 28.8007 33.7126 29.452 34.364C30.1034 35.0154 30.9869 35.3813 31.908 35.3813C32.8292 35.3813 33.7126 35.0154 34.364 34.364C35.0154 33.7126 35.3813 32.8292 35.3813 31.908C35.3813 30.9868 35.0154 30.1034 34.364 29.452C33.7126 28.8006 32.8292 28.4347 31.908 28.4347C30.9869 28.4347 30.1034 28.8006 29.452 29.452C28.8007 30.1034 28.4347 30.9868 28.4347 31.908ZM35.3813 31.908C35.3813 32.8292 35.7473 33.7126 36.3986 34.364C37.05 35.0154 37.9334 35.3813 38.8546 35.3813C39.7758 35.3813 40.6592 35.0154 41.3106 34.364C41.962 33.7126 42.3279 32.8292 42.3279 31.908C42.3279 30.9868 41.962 30.1034 41.3106 29.452C40.6592 28.8006 39.7758 28.4347 38.8546 28.4347C37.9334 28.4347 37.05 28.8006 36.3986 29.452C35.7473 30.1034 35.3813 30.9868 35.3813 31.908ZM49.2745 31.908C49.2745 32.3641 49.3643 32.8158 49.5389 33.2372C49.7134 33.6586 49.9693 34.0415 50.2918 34.364C50.6143 34.6865 50.9972 34.9424 51.4186 35.1169C51.84 35.2915 52.2917 35.3813 52.7478 35.3813C53.2039 35.3813 53.6556 35.2915 54.077 35.1169C54.4984 34.9424 54.8813 34.6865 55.2038 34.364C55.5263 34.0415 55.7821 33.6586 55.9567 33.2372C56.1312 32.8158 56.2211 32.3641 56.2211 31.908C56.2211 31.4519 56.1312 31.0002 55.9567 30.5788C55.7821 30.1574 55.5263 29.7745 55.2038 29.452C54.8813 29.1295 54.4984 28.8736 54.077 28.6991C53.6556 28.5245 53.2039 28.4347 52.7478 28.4347C52.2917 28.4347 51.84 28.5245 51.4186 28.6991C50.9972 28.8736 50.6143 29.1295 50.2918 29.452C49.9693 29.7745 49.7134 30.1574 49.5389 30.5788C49.3643 31.0002 49.2745 31.4519 49.2745 31.908ZM70.1143 31.908C70.1143 32.8292 70.4802 33.7126 71.1316 34.364C71.7829 35.0154 72.6664 35.3813 73.5876 35.3813C74.5087 35.3813 75.3922 35.0154 76.0436 34.364C76.6949 33.7126 77.0609 32.8292 77.0609 31.908C77.0609 30.9868 76.6949 30.1034 76.0436 29.452C75.3922 28.8006 74.5087 28.4347 73.5876 28.4347C72.6664 28.4347 71.7829 28.8006 71.1316 29.452C70.4802 30.1034 70.1143 30.9868 70.1143 31.908ZM84.0074 31.908C84.0074 32.8292 84.3734 33.7126 85.0247 34.364C85.6761 35.0154 86.5596 35.3813 87.4807 35.3813C88.4019 35.3813 89.2854 35.0154 89.9367 34.364C90.5881 33.7126 90.954 32.8292 90.954 31.908C90.954 30.9868 90.5881 30.1034 89.9367 29.452C89.2854 28.8006 88.4019 28.4347 87.4807 28.4347C86.5596 28.4347 85.6761 28.8006 85.0247 29.452C84.3734 30.1034 84.0074 30.9868 84.0074 31.908ZM90.954 31.908C90.954 32.8292 91.32 33.7126 91.9713 34.364C92.6227 35.0154 93.5061 35.3813 94.4273 35.3813C95.3485 35.3813 96.2319 35.0154 96.8833 34.364C97.5347 33.7126 97.9006 32.8292 97.9006 31.908C97.9006 30.9868 97.5347 30.1034 96.8833 29.452C96.2319 28.8006 95.3485 28.4347 94.4273 28.4347C93.5061 28.4347 92.6227 28.8006 91.9713 29.452C91.32 30.1034 90.954 30.9868 90.954 31.908ZM104.847 31.908C104.847 32.8292 105.213 33.7126 105.865 34.364C106.516 35.0154 107.399 35.3813 108.321 35.3813C109.242 35.3813 110.125 35.0154 110.776 34.364C111.428 33.7126 111.794 32.8292 111.794 31.908C111.794 30.9868 111.428 30.1034 110.776 29.452C110.125 28.8006 109.242 28.4347 108.321 28.4347C107.399 28.4347 106.516 28.8006 105.865 29.452C105.213 30.1034 104.847 30.9868 104.847 31.908ZM111.794 31.908C111.794 32.8292 112.16 33.7126 112.811 34.364C113.462 35.0154 114.346 35.3813 115.267 35.3813C116.188 35.3813 117.072 35.0154 117.723 34.364C118.374 33.7126 118.74 32.8292 118.74 31.908C118.74 30.9868 118.374 30.1034 117.723 29.452C117.072 28.8006 116.188 28.4347 115.267 28.4347C114.346 28.4347 113.462 28.8006 112.811 29.452C112.16 30.1034 111.794 30.9868 111.794 31.908ZM118.74 31.908C118.74 32.8292 119.106 33.7126 119.758 34.364C120.409 35.0154 121.292 35.3813 122.214 35.3813C123.135 35.3813 124.018 35.0154 124.67 34.364C125.321 33.7126 125.687 32.8292 125.687 31.908C125.687 30.9868 125.321 30.1034 124.67 29.452C124.018 28.8006 123.135 28.4347 122.214 28.4347C121.292 28.4347 120.409 28.8006 119.758 29.452C119.106 30.1034 118.74 30.9868 118.74 31.908ZM125.687 31.908C125.687 32.8292 126.053 33.7126 126.704 34.364C127.356 35.0154 128.239 35.3813 129.16 35.3813C130.081 35.3813 130.965 35.0154 131.616 34.364C132.268 33.7126 132.634 32.8292 132.634 31.908C132.634 30.9868 132.268 30.1034 131.616 29.452C130.965 28.8006 130.081 28.4347 129.16 28.4347C128.239 28.4347 127.356 28.8006 126.704 29.452C126.053 30.1034 125.687 30.9868 125.687 31.908ZM139.58 31.908C139.58 32.8292 139.946 33.7126 140.597 34.364C141.249 35.0154 142.132 35.3813 143.053 35.3813C143.975 35.3813 144.858 35.0154 145.509 34.364C146.161 33.7126 146.527 32.8292 146.527 31.908C146.527 30.9868 146.161 30.1034 145.509 29.452C144.858 28.8006 143.975 28.4347 143.053 28.4347C142.132 28.4347 141.249 28.8006 140.597 29.452C139.946 30.1034 139.58 30.9868 139.58 31.908ZM146.527 31.908C146.527 32.8292 146.893 33.7126 147.544 34.364C148.195 35.0154 149.079 35.3813 150 35.3813C150.921 35.3813 151.805 35.0154 152.456 34.364C153.107 33.7126 153.473 32.8292 153.473 31.908C153.473 30.9868 153.107 30.1034 152.456 29.452C151.805 28.8006 150.921 28.4347 150 28.4347C149.079 28.4347 148.195 28.8006 147.544 29.452C146.893 30.1034 146.527 30.9868 146.527 31.908ZM174.313 31.908C174.313 32.8292 174.679 33.7126 175.33 34.364C175.982 35.0154 176.865 35.3813 177.786 35.3813C178.708 35.3813 179.591 35.0154 180.242 34.364C180.894 33.7126 181.26 32.8292 181.26 31.908C181.26 30.9868 180.894 30.1034 180.242 29.452C179.591 28.8006 178.708 28.4347 177.786 28.4347C176.865 28.4347 175.982 28.8006 175.33 29.452C174.679 30.1034 174.313 30.9868 174.313 31.908ZM202.099 31.908C202.099 32.8292 202.465 33.7126 203.117 34.364C203.768 35.0154 204.652 35.3813 205.573 35.3813C206.494 35.3813 207.377 35.0154 208.029 34.364C208.68 33.7126 209.046 32.8292 209.046 31.908C209.046 30.9868 208.68 30.1034 208.029 29.452C207.377 28.8006 206.494 28.4347 205.573 28.4347C204.652 28.4347 203.768 28.8006 203.117 29.452C202.465 30.1034 202.099 30.9868 202.099 31.908ZM209.046 31.908C209.046 32.8292 209.412 33.7126 210.063 34.364C210.715 35.0154 211.598 35.3813 212.519 35.3813C213.44 35.3813 214.324 35.0154 214.975 34.364C215.627 33.7126 215.993 32.8292 215.993 31.908C215.993 30.9868 215.627 30.1034 214.975 29.452C214.324 28.8006 213.44 28.4347 212.519 28.4347C211.598 28.4347 210.715 28.8006 210.063 29.452C209.412 30.1034 209.046 30.9868 209.046 31.908ZM215.993 31.908C215.993 32.8292 216.359 33.7126 217.01 34.364C217.661 35.0154 218.545 35.3813 219.466 35.3813C220.387 35.3813 221.271 35.0154 221.922 34.364C222.573 33.7126 222.939 32.8292 222.939 31.908C222.939 30.9868 222.573 30.1034 221.922 29.452C221.271 28.8006 220.387 28.4347 219.466 28.4347C218.545 28.4347 217.661 28.8006 217.01 29.452C216.359 30.1034 215.993 30.9868 215.993 31.908ZM222.939 31.908C222.939 32.8292 223.305 33.7126 223.957 34.364C224.608 35.0154 225.491 35.3813 226.413 35.3813C227.334 35.3813 228.217 35.0154 228.868 34.364C229.52 33.7126 229.886 32.8292 229.886 31.908C229.886 30.9868 229.52 30.1034 228.868 29.452C228.217 28.8006 227.334 28.4347 226.413 28.4347C225.491 28.4347 224.608 28.8006 223.957 29.452C223.305 30.1034 222.939 30.9868 222.939 31.908ZM243.779 31.908C243.779 32.8292 244.145 33.7126 244.796 34.364C245.448 35.0154 246.331 35.3813 247.252 35.3813C248.173 35.3813 249.057 35.0154 249.708 34.364C250.36 33.7126 250.726 32.8292 250.726 31.908C250.726 30.9868 250.36 30.1034 249.708 29.452C249.057 28.8006 248.173 28.4347 247.252 28.4347C246.331 28.4347 245.448 28.8006 244.796 29.452C244.145 30.1034 243.779 30.9868 243.779 31.908ZM257.672 31.908C257.672 32.8292 258.038 33.7126 258.689 34.364C259.341 35.0154 260.224 35.3813 261.145 35.3813C262.067 35.3813 262.95 35.0154 263.601 34.364C264.253 33.7126 264.619 32.8292 264.619 31.908C264.619 30.9868 264.253 30.1034 263.601 29.452C262.95 28.8006 262.067 28.4347 261.145 28.4347C260.224 28.4347 259.341 28.8006 258.689 29.452C258.038 30.1034 257.672 30.9868 257.672 31.908ZM264.619 31.908C264.619 32.8292 264.985 33.7126 265.636 34.364C266.287 35.0154 267.171 35.3813 268.092 35.3813C269.013 35.3813 269.897 35.0154 270.548 34.364C271.199 33.7126 271.565 32.8292 271.565 31.908C271.565 30.9868 271.199 30.1034 270.548 29.452C269.897 28.8006 269.013 28.4347 268.092 28.4347C267.171 28.4347 266.287 28.8006 265.636 29.452C264.985 30.1034 264.619 30.9868 264.619 31.908ZM271.565 31.908C271.565 32.8292 271.931 33.7126 272.583 34.364C273.234 35.0154 274.117 35.3813 275.039 35.3813C275.96 35.3813 276.843 35.0154 277.495 34.364C278.146 33.7126 278.512 32.8292 278.512 31.908C278.512 30.9868 278.146 30.1034 277.495 29.452C276.843 28.8006 275.96 28.4347 275.039 28.4347C274.117 28.4347 273.234 28.8006 272.583 29.452C271.931 30.1034 271.565 30.9868 271.565 31.908ZM285.458 31.908C285.458 32.8292 285.824 33.7126 286.476 34.364C287.127 35.0154 288.011 35.3813 288.932 35.3813C289.853 35.3813 290.736 35.0154 291.388 34.364C292.039 33.7126 292.405 32.8292 292.405 31.908C292.405 30.9868 292.039 30.1034 291.388 29.452C290.736 28.8006 289.853 28.4347 288.932 28.4347C288.011 28.4347 287.127 28.8006 286.476 29.452C285.824 30.1034 285.458 30.9868 285.458 31.908ZM7.59497 38.8546C7.59497 39.7758 7.96091 40.6592 8.61227 41.3106C9.26364 41.9619 10.1471 42.3279 11.0683 42.3279C11.9894 42.3279 12.8729 41.9619 13.5243 41.3106C14.1756 40.6592 14.5416 39.7758 14.5416 38.8546C14.5416 37.9334 14.1756 37.05 13.5243 36.3986C12.8729 35.7472 11.9894 35.3813 11.0683 35.3813C10.1471 35.3813 9.26364 35.7472 8.61227 36.3986C7.96091 37.05 7.59497 37.9334 7.59497 38.8546ZM21.4881 38.8546C21.4881 39.7758 21.8541 40.6592 22.5055 41.3106C23.1568 41.9619 24.0403 42.3279 24.9614 42.3279C25.8826 42.3279 26.7661 41.9619 27.4174 41.3106C28.0688 40.6592 28.4347 39.7758 28.4347 38.8546C28.4347 37.9334 28.0688 37.05 27.4174 36.3986C26.7661 35.7472 25.8826 35.3813 24.9614 35.3813C24.0403 35.3813 23.1568 35.7472 22.5055 36.3986C21.8541 37.05 21.4881 37.9334 21.4881 38.8546ZM28.4347 38.8546C28.4347 39.7758 28.8007 40.6592 29.452 41.3106C30.1034 41.9619 30.9869 42.3279 31.908 42.3279C32.8292 42.3279 33.7126 41.9619 34.364 41.3106C35.0154 40.6592 35.3813 39.7758 35.3813 38.8546C35.3813 37.9334 35.0154 37.05 34.364 36.3986C33.7126 35.7472 32.8292 35.3813 31.908 35.3813C30.9869 35.3813 30.1034 35.7472 29.452 36.3986C28.8007 37.05 28.4347 37.9334 28.4347 38.8546ZM35.3813 38.8546C35.3813 39.7758 35.7473 40.6592 36.3986 41.3106C37.05 41.9619 37.9334 42.3279 38.8546 42.3279C39.7758 42.3279 40.6592 41.9619 41.3106 41.3106C41.962 40.6592 42.3279 39.7758 42.3279 38.8546C42.3279 37.9334 41.962 37.05 41.3106 36.3986C40.6592 35.7472 39.7758 35.3813 38.8546 35.3813C37.9334 35.3813 37.05 35.7472 36.3986 36.3986C35.7473 37.05 35.3813 37.9334 35.3813 38.8546ZM49.2745 38.8546C49.2745 39.3107 49.3643 39.7624 49.5389 40.1838C49.7134 40.6052 49.9693 40.9881 50.2918 41.3106C50.6143 41.6331 50.9972 41.8889 51.4186 42.0635C51.84 42.238 52.2917 42.3279 52.7478 42.3279C53.2039 42.3279 53.6556 42.238 54.077 42.0635C54.4984 41.8889 54.8813 41.6331 55.2038 41.3106C55.5263 40.9881 55.7821 40.6052 55.9567 40.1838C56.1312 39.7624 56.2211 39.3107 56.2211 38.8546C56.2211 38.3985 56.1312 37.9468 55.9567 37.5254C55.7821 37.104 55.5263 36.7211 55.2038 36.3986C54.8813 36.0761 54.4984 35.8202 54.077 35.6457C53.6556 35.4711 53.2039 35.3813 52.7478 35.3813C52.2917 35.3813 51.84 35.4711 51.4186 35.6457C50.9972 35.8202 50.6143 36.0761 50.2918 36.3986C49.9693 36.7211 49.7134 37.104 49.5389 37.5254C49.3643 37.9468 49.2745 38.3985 49.2745 38.8546ZM70.1143 38.8546C70.1143 39.7758 70.4802 40.6592 71.1316 41.3106C71.7829 41.9619 72.6664 42.3279 73.5876 42.3279C74.5087 42.3279 75.3922 41.9619 76.0436 41.3106C76.6949 40.6592 77.0609 39.7758 77.0609 38.8546C77.0609 37.9334 76.6949 37.05 76.0436 36.3986C75.3922 35.7472 74.5087 35.3813 73.5876 35.3813C72.6664 35.3813 71.7829 35.7472 71.1316 36.3986C70.4802 37.05 70.1143 37.9334 70.1143 38.8546ZM90.954 38.8546C90.954 39.7758 91.32 40.6592 91.9713 41.3106C92.6227 41.9619 93.5061 42.3279 94.4273 42.3279C95.3485 42.3279 96.2319 41.9619 96.8833 41.3106C97.5347 40.6592 97.9006 39.7758 97.9006 38.8546C97.9006 37.9334 97.5347 37.05 96.8833 36.3986C96.2319 35.7472 95.3485 35.3813 94.4273 35.3813C93.5061 35.3813 92.6227 35.7472 91.9713 36.3986C91.32 37.05 90.954 37.9334 90.954 38.8546ZM97.9006 38.8546C97.9006 39.3107 97.9905 39.7624 98.165 40.1838C98.3396 40.6052 98.5954 40.9881 98.9179 41.3106C99.2404 41.6331 99.6233 41.8889 100.045 42.0635C100.466 42.238 100.918 42.3279 101.374 42.3279C101.83 42.3279 102.282 42.238 102.703 42.0635C103.124 41.8889 103.507 41.6331 103.83 41.3106C104.152 40.9881 104.408 40.6052 104.583 40.1838C104.757 39.7624 104.847 39.3107 104.847 38.8546C104.847 38.3985 104.757 37.9468 104.583 37.5254C104.408 37.104 104.152 36.7211 103.83 36.3986C103.507 36.0761 103.124 35.8202 102.703 35.6457C102.282 35.4711 101.83 35.3813 101.374 35.3813C100.918 35.3813 100.466 35.4711 100.045 35.6457C99.6233 35.8202 99.2404 36.0761 98.9179 36.3986C98.5954 36.7211 98.3396 37.104 98.165 37.5254C97.9905 37.9468 97.9006 38.3985 97.9006 38.8546ZM104.847 38.8546C104.847 39.7758 105.213 40.6592 105.865 41.3106C106.516 41.9619 107.399 42.3279 108.321 42.3279C109.242 42.3279 110.125 41.9619 110.776 41.3106C111.428 40.6592 111.794 39.7758 111.794 38.8546C111.794 37.9334 111.428 37.05 110.776 36.3986C110.125 35.7472 109.242 35.3813 108.321 35.3813C107.399 35.3813 106.516 35.7472 105.865 36.3986C105.213 37.05 104.847 37.9334 104.847 38.8546ZM111.794 38.8546C111.794 39.7758 112.16 40.6592 112.811 41.3106C113.462 41.9619 114.346 42.3279 115.267 42.3279C116.188 42.3279 117.072 41.9619 117.723 41.3106C118.374 40.6592 118.74 39.7758 118.74 38.8546C118.74 37.9334 118.374 37.05 117.723 36.3986C117.072 35.7472 116.188 35.3813 115.267 35.3813C114.346 35.3813 113.462 35.7472 112.811 36.3986C112.16 37.05 111.794 37.9334 111.794 38.8546ZM125.687 38.8546C125.687 39.7758 126.053 40.6592 126.704 41.3106C127.356 41.9619 128.239 42.3279 129.16 42.3279C130.081 42.3279 130.965 41.9619 131.616 41.3106C132.268 40.6592 132.634 39.7758 132.634 38.8546C132.634 37.9334 132.268 37.05 131.616 36.3986C130.965 35.7472 130.081 35.3813 129.16 35.3813C128.239 35.3813 127.356 35.7472 126.704 36.3986C126.053 37.05 125.687 37.9334 125.687 38.8546ZM153.473 38.8546C153.473 39.3107 153.563 39.7624 153.738 40.1838C153.912 40.6052 154.168 40.9881 154.491 41.3106C154.813 41.6331 155.196 41.8889 155.617 42.0635C156.039 42.238 156.491 42.3279 156.947 42.3279C157.403 42.3279 157.854 42.238 158.276 42.0635C158.697 41.8889 159.08 41.6331 159.403 41.3106C159.725 40.9881 159.981 40.6052 160.156 40.1838C160.33 39.7624 160.42 39.3107 160.42 38.8546C160.42 38.3985 160.33 37.9468 160.156 37.5254C159.981 37.104 159.725 36.7211 159.403 36.3986C159.08 36.0761 158.697 35.8202 158.276 35.6457C157.854 35.4711 157.403 35.3813 156.947 35.3813C156.491 35.3813 156.039 35.4711 155.617 35.6457C155.196 35.8202 154.813 36.0761 154.491 36.3986C154.168 36.7211 153.912 37.104 153.738 37.5254C153.563 37.9468 153.473 38.3985 153.473 38.8546ZM167.366 38.8546C167.366 39.7758 167.732 40.6592 168.384 41.3106C169.035 41.9619 169.919 42.3279 170.84 42.3279C171.761 42.3279 172.644 41.9619 173.296 41.3106C173.947 40.6592 174.313 39.7758 174.313 38.8546C174.313 37.9334 173.947 37.05 173.296 36.3986C172.644 35.7472 171.761 35.3813 170.84 35.3813C169.919 35.3813 169.035 35.7472 168.384 36.3986C167.732 37.05 167.366 37.9334 167.366 38.8546ZM195.153 38.8546C195.153 39.3107 195.243 39.7624 195.417 40.1838C195.592 40.6052 195.848 40.9881 196.17 41.3106C196.493 41.6331 196.876 41.8889 197.297 42.0635C197.718 42.238 198.17 42.3279 198.626 42.3279C199.082 42.3279 199.534 42.238 199.955 42.0635C200.377 41.8889 200.76 41.6331 201.082 41.3106C201.405 40.9881 201.661 40.6052 201.835 40.1838C202.01 39.7624 202.099 39.3107 202.099 38.8546C202.099 38.3985 202.01 37.9468 201.835 37.5254C201.661 37.104 201.405 36.7211 201.082 36.3986C200.76 36.0761 200.377 35.8202 199.955 35.6457C199.534 35.4711 199.082 35.3813 198.626 35.3813C198.17 35.3813 197.718 35.4711 197.297 35.6457C196.876 35.8202 196.493 36.0761 196.17 36.3986C195.848 36.7211 195.592 37.104 195.417 37.5254C195.243 37.9468 195.153 38.3985 195.153 38.8546ZM202.099 38.8546C202.099 39.7758 202.465 40.6592 203.117 41.3106C203.768 41.9619 204.652 42.3279 205.573 42.3279C206.494 42.3279 207.377 41.9619 208.029 41.3106C208.68 40.6592 209.046 39.7758 209.046 38.8546C209.046 37.9334 208.68 37.05 208.029 36.3986C207.377 35.7472 206.494 35.3813 205.573 35.3813C204.652 35.3813 203.768 35.7472 203.117 36.3986C202.465 37.05 202.099 37.9334 202.099 38.8546ZM215.993 38.8546C215.993 39.7758 216.359 40.6592 217.01 41.3106C217.661 41.9619 218.545 42.3279 219.466 42.3279C220.387 42.3279 221.271 41.9619 221.922 41.3106C222.573 40.6592 222.939 39.7758 222.939 38.8546C222.939 37.9334 222.573 37.05 221.922 36.3986C221.271 35.7472 220.387 35.3813 219.466 35.3813C218.545 35.3813 217.661 35.7472 217.01 36.3986C216.359 37.05 215.993 37.9334 215.993 38.8546ZM243.779 38.8546C243.779 39.7758 244.145 40.6592 244.796 41.3106C245.448 41.9619 246.331 42.3279 247.252 42.3279C248.173 42.3279 249.057 41.9619 249.708 41.3106C250.36 40.6592 250.726 39.7758 250.726 38.8546C250.726 37.9334 250.36 37.05 249.708 36.3986C249.057 35.7472 248.173 35.3813 247.252 35.3813C246.331 35.3813 245.448 35.7472 244.796 36.3986C244.145 37.05 243.779 37.9334 243.779 38.8546ZM257.672 38.8546C257.672 39.7758 258.038 40.6592 258.689 41.3106C259.341 41.9619 260.224 42.3279 261.145 42.3279C262.067 42.3279 262.95 41.9619 263.601 41.3106C264.253 40.6592 264.619 39.7758 264.619 38.8546C264.619 37.9334 264.253 37.05 263.601 36.3986C262.95 35.7472 262.067 35.3813 261.145 35.3813C260.224 35.3813 259.341 35.7472 258.689 36.3986C258.038 37.05 257.672 37.9334 257.672 38.8546ZM264.619 38.8546C264.619 39.7758 264.985 40.6592 265.636 41.3106C266.287 41.9619 267.171 42.3279 268.092 42.3279C269.013 42.3279 269.897 41.9619 270.548 41.3106C271.199 40.6592 271.565 39.7758 271.565 38.8546C271.565 37.9334 271.199 37.05 270.548 36.3986C269.897 35.7472 269.013 35.3813 268.092 35.3813C267.171 35.3813 266.287 35.7472 265.636 36.3986C264.985 37.05 264.619 37.9334 264.619 38.8546ZM271.565 38.8546C271.565 39.7758 271.931 40.6592 272.583 41.3106C273.234 41.9619 274.117 42.3279 275.039 42.3279C275.96 42.3279 276.843 41.9619 277.495 41.3106C278.146 40.6592 278.512 39.7758 278.512 38.8546C278.512 37.9334 278.146 37.05 277.495 36.3986C276.843 35.7472 275.96 35.3813 275.039 35.3813C274.117 35.3813 273.234 35.7472 272.583 36.3986C271.931 37.05 271.565 37.9334 271.565 38.8546ZM285.458 38.8546C285.458 39.7758 285.824 40.6592 286.476 41.3106C287.127 41.9619 288.011 42.3279 288.932 42.3279C289.853 42.3279 290.736 41.9619 291.388 41.3106C292.039 40.6592 292.405 39.7758 292.405 38.8546C292.405 37.9334 292.039 37.05 291.388 36.3986C290.736 35.7472 289.853 35.3813 288.932 35.3813C288.011 35.3813 287.127 35.7472 286.476 36.3986C285.824 37.05 285.458 37.9334 285.458 38.8546ZM7.59497 45.8012C7.59497 46.7224 7.96091 47.6058 8.61227 48.2572C9.26364 48.9085 10.1471 49.2745 11.0683 49.2745C11.9894 49.2745 12.8729 48.9085 13.5243 48.2572C14.1756 47.6058 14.5416 46.7224 14.5416 45.8012C14.5416 44.88 14.1756 43.9966 13.5243 43.3452C12.8729 42.6938 11.9894 42.3279 11.0683 42.3279C10.1471 42.3279 9.26364 42.6938 8.61227 43.3452C7.96091 43.9966 7.59497 44.88 7.59497 45.8012ZM49.2745 45.8012C49.2745 46.2573 49.3643 46.7089 49.5389 47.1303C49.7134 47.5517 49.9693 47.9346 50.2918 48.2572C50.6143 48.5797 50.9972 48.8355 51.4186 49.0101C51.84 49.1846 52.2917 49.2745 52.7478 49.2745C53.2039 49.2745 53.6556 49.1846 54.077 49.0101C54.4984 48.8355 54.8813 48.5797 55.2038 48.2572C55.5263 47.9346 55.7821 47.5517 55.9567 47.1303C56.1312 46.7089 56.2211 46.2573 56.2211 45.8012C56.2211 45.3451 56.1312 44.8934 55.9567 44.472C55.7821 44.0506 55.5263 43.6677 55.2038 43.3452C54.8813 43.0227 54.4984 42.7668 54.077 42.5923C53.6556 42.4177 53.2039 42.3279 52.7478 42.3279C52.2917 42.3279 51.84 42.4177 51.4186 42.5923C50.9972 42.7668 50.6143 43.0227 50.2918 43.3452C49.9693 43.6677 49.7134 44.0506 49.5389 44.472C49.3643 44.8934 49.2745 45.3451 49.2745 45.8012ZM63.1677 45.8012C63.1677 46.7224 63.5336 47.6058 64.185 48.2572C64.8363 48.9085 65.7198 49.2745 66.641 49.2745C67.5621 49.2745 68.4456 48.9085 69.097 48.2572C69.7483 47.6058 70.1143 46.7224 70.1143 45.8012C70.1143 44.88 69.7483 43.9966 69.097 43.3452C68.4456 42.6938 67.5621 42.3279 66.641 42.3279C65.7198 42.3279 64.8363 42.6938 64.185 43.3452C63.5336 43.9966 63.1677 44.88 63.1677 45.8012ZM77.0609 45.8012C77.0609 46.2573 77.1507 46.7089 77.3252 47.1303C77.4998 47.5517 77.7556 47.9346 78.0782 48.2572C78.4007 48.5797 78.7836 48.8355 79.205 49.0101C79.6264 49.1846 80.078 49.2745 80.5341 49.2745C80.9903 49.2745 81.4419 49.1846 81.8633 49.0101C82.2847 48.8355 82.6676 48.5797 82.9901 48.2572C83.3127 47.9346 83.5685 47.5517 83.743 47.1303C83.9176 46.7089 84.0074 46.2573 84.0074 45.8012C84.0074 45.3451 83.9176 44.8934 83.743 44.472C83.5685 44.0506 83.3127 43.6677 82.9901 43.3452C82.6676 43.0227 82.2847 42.7668 81.8633 42.5923C81.4419 42.4177 80.9903 42.3279 80.5341 42.3279C80.078 42.3279 79.6264 42.4177 79.205 42.5923C78.7836 42.7668 78.4007 43.0227 78.0782 43.3452C77.7556 43.6677 77.4998 44.0506 77.3252 44.472C77.1507 44.8934 77.0609 45.3451 77.0609 45.8012ZM84.0074 45.8012C84.0074 46.7224 84.3734 47.6058 85.0247 48.2572C85.6761 48.9085 86.5596 49.2745 87.4807 49.2745C88.4019 49.2745 89.2854 48.9085 89.9367 48.2572C90.5881 47.6058 90.954 46.7224 90.954 45.8012C90.954 44.88 90.5881 43.9966 89.9367 43.3452C89.2854 42.6938 88.4019 42.3279 87.4807 42.3279C86.5596 42.3279 85.6761 42.6938 85.0247 43.3452C84.3734 43.9966 84.0074 44.88 84.0074 45.8012ZM90.954 45.8012C90.954 46.7224 91.32 47.6058 91.9713 48.2572C92.6227 48.9085 93.5061 49.2745 94.4273 49.2745C95.3485 49.2745 96.2319 48.9085 96.8833 48.2572C97.5347 47.6058 97.9006 46.7224 97.9006 45.8012C97.9006 44.88 97.5347 43.9966 96.8833 43.3452C96.2319 42.6938 95.3485 42.3279 94.4273 42.3279C93.5061 42.3279 92.6227 42.6938 91.9713 43.3452C91.32 43.9966 90.954 44.88 90.954 45.8012ZM97.9006 45.8012C97.9006 46.2573 97.9905 46.7089 98.165 47.1303C98.3396 47.5517 98.5954 47.9346 98.9179 48.2572C99.2404 48.5797 99.6233 48.8355 100.045 49.0101C100.466 49.1846 100.918 49.2745 101.374 49.2745C101.83 49.2745 102.282 49.1846 102.703 49.0101C103.124 48.8355 103.507 48.5797 103.83 48.2572C104.152 47.9346 104.408 47.5517 104.583 47.1303C104.757 46.7089 104.847 46.2573 104.847 45.8012C104.847 45.3451 104.757 44.8934 104.583 44.472C104.408 44.0506 104.152 43.6677 103.83 43.3452C103.507 43.0227 103.124 42.7668 102.703 42.5923C102.282 42.4177 101.83 42.3279 101.374 42.3279C100.918 42.3279 100.466 42.4177 100.045 42.5923C99.6233 42.7668 99.2404 43.0227 98.9179 43.3452C98.5954 43.6677 98.3396 44.0506 98.165 44.472C97.9905 44.8934 97.9006 45.3451 97.9006 45.8012ZM118.74 45.8012C118.74 46.7224 119.106 47.6058 119.758 48.2572C120.409 48.9085 121.292 49.2745 122.214 49.2745C123.135 49.2745 124.018 48.9085 124.67 48.2572C125.321 47.6058 125.687 46.7224 125.687 45.8012C125.687 44.88 125.321 43.9966 124.67 43.3452C124.018 42.6938 123.135 42.3279 122.214 42.3279C121.292 42.3279 120.409 42.6938 119.758 43.3452C119.106 43.9966 118.74 44.88 118.74 45.8012ZM125.687 45.8012C125.687 46.7224 126.053 47.6058 126.704 48.2572C127.356 48.9085 128.239 49.2745 129.16 49.2745C130.081 49.2745 130.965 48.9085 131.616 48.2572C132.268 47.6058 132.634 46.7224 132.634 45.8012C132.634 44.88 132.268 43.9966 131.616 43.3452C130.965 42.6938 130.081 42.3279 129.16 42.3279C128.239 42.3279 127.356 42.6938 126.704 43.3452C126.053 43.9966 125.687 44.88 125.687 45.8012ZM132.634 45.8012C132.634 46.7224 132.999 47.6058 133.651 48.2572C134.302 48.9085 135.186 49.2745 136.107 49.2745C137.028 49.2745 137.911 48.9085 138.563 48.2572C139.214 47.6058 139.58 46.7224 139.58 45.8012C139.58 44.88 139.214 43.9966 138.563 43.3452C137.911 42.6938 137.028 42.3279 136.107 42.3279C135.186 42.3279 134.302 42.6938 133.651 43.3452C132.999 43.9966 132.634 44.88 132.634 45.8012ZM139.58 45.8012C139.58 46.7224 139.946 47.6058 140.597 48.2572C141.249 48.9085 142.132 49.2745 143.053 49.2745C143.975 49.2745 144.858 48.9085 145.509 48.2572C146.161 47.6058 146.527 46.7224 146.527 45.8012C146.527 44.88 146.161 43.9966 145.509 43.3452C144.858 42.6938 143.975 42.3279 143.053 42.3279C142.132 42.3279 141.249 42.6938 140.597 43.3452C139.946 43.9966 139.58 44.88 139.58 45.8012ZM146.527 45.8012C146.527 46.7224 146.893 47.6058 147.544 48.2572C148.195 48.9085 149.079 49.2745 150 49.2745C150.921 49.2745 151.805 48.9085 152.456 48.2572C153.107 47.6058 153.473 46.7224 153.473 45.8012C153.473 44.88 153.107 43.9966 152.456 43.3452C151.805 42.6938 150.921 42.3279 150 42.3279C149.079 42.3279 148.195 42.6938 147.544 43.3452C146.893 43.9966 146.527 44.88 146.527 45.8012ZM153.473 45.8012C153.473 46.2573 153.563 46.7089 153.738 47.1303C153.912 47.5517 154.168 47.9346 154.491 48.2572C154.813 48.5797 155.196 48.8355 155.617 49.0101C156.039 49.1846 156.491 49.2745 156.947 49.2745C157.403 49.2745 157.854 49.1846 158.276 49.0101C158.697 48.8355 159.08 48.5797 159.403 48.2572C159.725 47.9346 159.981 47.5517 160.156 47.1303C160.33 46.7089 160.42 46.2573 160.42 45.8012C160.42 45.3451 160.33 44.8934 160.156 44.472C159.981 44.0506 159.725 43.6677 159.403 43.3452C159.08 43.0227 158.697 42.7668 158.276 42.5923C157.854 42.4177 157.403 42.3279 156.947 42.3279C156.491 42.3279 156.039 42.4177 155.617 42.5923C155.196 42.7668 154.813 43.0227 154.491 43.3452C154.168 43.6677 153.912 44.0506 153.738 44.472C153.563 44.8934 153.473 45.3451 153.473 45.8012ZM167.366 45.8012C167.366 46.7224 167.732 47.6058 168.384 48.2572C169.035 48.9085 169.919 49.2745 170.84 49.2745C171.761 49.2745 172.644 48.9085 173.296 48.2572C173.947 47.6058 174.313 46.7224 174.313 45.8012C174.313 44.88 173.947 43.9966 173.296 43.3452C172.644 42.6938 171.761 42.3279 170.84 42.3279C169.919 42.3279 169.035 42.6938 168.384 43.3452C167.732 43.9966 167.366 44.88 167.366 45.8012ZM174.313 45.8012C174.313 46.7224 174.679 47.6058 175.33 48.2572C175.982 48.9085 176.865 49.2745 177.786 49.2745C178.708 49.2745 179.591 48.9085 180.242 48.2572C180.894 47.6058 181.26 46.7224 181.26 45.8012C181.26 44.88 180.894 43.9966 180.242 43.3452C179.591 42.6938 178.708 42.3279 177.786 42.3279C176.865 42.3279 175.982 42.6938 175.33 43.3452C174.679 43.9966 174.313 44.88 174.313 45.8012ZM181.26 45.8012C181.26 46.7224 181.626 47.6058 182.277 48.2572C182.928 48.9085 183.812 49.2745 184.733 49.2745C185.654 49.2745 186.538 48.9085 187.189 48.2572C187.84 47.6058 188.206 46.7224 188.206 45.8012C188.206 44.88 187.84 43.9966 187.189 43.3452C186.538 42.6938 185.654 42.3279 184.733 42.3279C183.812 42.3279 182.928 42.6938 182.277 43.3452C181.626 43.9966 181.26 44.88 181.26 45.8012ZM188.206 45.8012C188.206 46.7224 188.572 47.6058 189.224 48.2572C189.875 48.9085 190.758 49.2745 191.68 49.2745C192.601 49.2745 193.484 48.9085 194.136 48.2572C194.787 47.6058 195.153 46.7224 195.153 45.8012C195.153 44.88 194.787 43.9966 194.136 43.3452C193.484 42.6938 192.601 42.3279 191.68 42.3279C190.758 42.3279 189.875 42.6938 189.224 43.3452C188.572 43.9966 188.206 44.88 188.206 45.8012ZM222.939 45.8012C222.939 46.7224 223.305 47.6058 223.957 48.2572C224.608 48.9085 225.491 49.2745 226.413 49.2745C227.334 49.2745 228.217 48.9085 228.868 48.2572C229.52 47.6058 229.886 46.7224 229.886 45.8012C229.886 44.88 229.52 43.9966 228.868 43.3452C228.217 42.6938 227.334 42.3279 226.413 42.3279C225.491 42.3279 224.608 42.6938 223.957 43.3452C223.305 43.9966 222.939 44.88 222.939 45.8012ZM243.779 45.8012C243.779 46.7224 244.145 47.6058 244.796 48.2572C245.448 48.9085 246.331 49.2745 247.252 49.2745C248.173 49.2745 249.057 48.9085 249.708 48.2572C250.36 47.6058 250.726 46.7224 250.726 45.8012C250.726 44.88 250.36 43.9966 249.708 43.3452C249.057 42.6938 248.173 42.3279 247.252 42.3279C246.331 42.3279 245.448 42.6938 244.796 43.3452C244.145 43.9966 243.779 44.88 243.779 45.8012ZM285.458 45.8012C285.458 46.7224 285.824 47.6058 286.476 48.2572C287.127 48.9085 288.011 49.2745 288.932 49.2745C289.853 49.2745 290.736 48.9085 291.388 48.2572C292.039 47.6058 292.405 46.7224 292.405 45.8012C292.405 44.88 292.039 43.9966 291.388 43.3452C290.736 42.6938 289.853 42.3279 288.932 42.3279C288.011 42.3279 287.127 42.6938 286.476 43.3452C285.824 43.9966 285.458 44.88 285.458 45.8012ZM7.59497 52.7478C7.59497 53.6689 7.96091 54.5524 8.61227 55.2038C9.26364 55.8551 10.1471 56.2211 11.0683 56.2211C11.9894 56.2211 12.8729 55.8551 13.5243 55.2038C14.1756 54.5524 14.5416 53.6689 14.5416 52.7478C14.5416 51.8266 14.1756 50.9431 13.5243 50.2918C12.8729 49.6404 11.9894 49.2745 11.0683 49.2745C10.1471 49.2745 9.26364 49.6404 8.61227 50.2918C7.96091 50.9431 7.59497 51.8266 7.59497 52.7478ZM14.5416 52.7478C14.5416 53.6689 14.9075 54.5524 15.5589 55.2038C16.2102 55.8551 17.0937 56.2211 18.0149 56.2211C18.936 56.2211 19.8195 55.8551 20.4708 55.2038C21.1222 54.5524 21.4881 53.6689 21.4881 52.7478C21.4881 51.8266 21.1222 50.9431 20.4708 50.2918C19.8195 49.6404 18.936 49.2745 18.0149 49.2745C17.0937 49.2745 16.2102 49.6404 15.5589 50.2918C14.9075 50.9431 14.5416 51.8266 14.5416 52.7478ZM21.4881 52.7478C21.4881 53.6689 21.8541 54.5524 22.5055 55.2038C23.1568 55.8551 24.0403 56.2211 24.9614 56.2211C25.8826 56.2211 26.7661 55.8551 27.4174 55.2038C28.0688 54.5524 28.4347 53.6689 28.4347 52.7478C28.4347 51.8266 28.0688 50.9431 27.4174 50.2918C26.7661 49.6404 25.8826 49.2745 24.9614 49.2745C24.0403 49.2745 23.1568 49.6404 22.5055 50.2918C21.8541 50.9431 21.4881 51.8266 21.4881 52.7478ZM28.4347 52.7478C28.4347 53.6689 28.8007 54.5524 29.452 55.2038C30.1034 55.8551 30.9869 56.2211 31.908 56.2211C32.8292 56.2211 33.7126 55.8551 34.364 55.2038C35.0154 54.5524 35.3813 53.6689 35.3813 52.7478C35.3813 51.8266 35.0154 50.9431 34.364 50.2918C33.7126 49.6404 32.8292 49.2745 31.908 49.2745C30.9869 49.2745 30.1034 49.6404 29.452 50.2918C28.8007 50.9431 28.4347 51.8266 28.4347 52.7478ZM35.3813 52.7478C35.3813 53.6689 35.7473 54.5524 36.3986 55.2038C37.05 55.8551 37.9334 56.2211 38.8546 56.2211C39.7758 56.2211 40.6592 55.8551 41.3106 55.2038C41.962 54.5524 42.3279 53.6689 42.3279 52.7478C42.3279 51.8266 41.962 50.9431 41.3106 50.2918C40.6592 49.6404 39.7758 49.2745 38.8546 49.2745C37.9334 49.2745 37.05 49.6404 36.3986 50.2918C35.7473 50.9431 35.3813 51.8266 35.3813 52.7478ZM42.3279 52.7478C42.3279 53.2039 42.4177 53.6555 42.5923 54.0769C42.7668 54.4983 43.0227 54.8812 43.3452 55.2038C43.6677 55.5263 44.0506 55.7821 44.472 55.9567C44.8934 56.1312 45.3451 56.2211 45.8012 56.2211C46.2573 56.2211 46.709 56.1312 47.1304 55.9567C47.5518 55.7821 47.9347 55.5263 48.2572 55.2038C48.5797 54.8812 48.8356 54.4983 49.0101 54.0769C49.1847 53.6555 49.2745 53.2039 49.2745 52.7478C49.2745 52.2916 49.1847 51.84 49.0101 51.4186C48.8356 50.9972 48.5797 50.6143 48.2572 50.2918C47.9347 49.9692 47.5518 49.7134 47.1304 49.5389C46.709 49.3643 46.2573 49.2745 45.8012 49.2745C45.3451 49.2745 44.8934 49.3643 44.472 49.5389C44.0506 49.7134 43.6677 49.9692 43.3452 50.2918C43.0227 50.6143 42.7668 50.9972 42.5923 51.4186C42.4177 51.84 42.3279 52.2916 42.3279 52.7478ZM49.2745 52.7478C49.2745 53.2039 49.3643 53.6555 49.5389 54.0769C49.7134 54.4983 49.9693 54.8812 50.2918 55.2038C50.6143 55.5263 50.9972 55.7821 51.4186 55.9567C51.84 56.1312 52.2917 56.2211 52.7478 56.2211C53.2039 56.2211 53.6556 56.1312 54.077 55.9567C54.4984 55.7821 54.8813 55.5263 55.2038 55.2038C55.5263 54.8812 55.7821 54.4983 55.9567 54.0769C56.1312 53.6555 56.2211 53.2039 56.2211 52.7478C56.2211 52.2916 56.1312 51.84 55.9567 51.4186C55.7821 50.9972 55.5263 50.6143 55.2038 50.2918C54.8813 49.9692 54.4984 49.7134 54.077 49.5389C53.6556 49.3643 53.2039 49.2745 52.7478 49.2745C52.2917 49.2745 51.84 49.3643 51.4186 49.5389C50.9972 49.7134 50.6143 49.9692 50.2918 50.2918C49.9693 50.6143 49.7134 50.9972 49.5389 51.4186C49.3643 51.84 49.2745 52.2916 49.2745 52.7478ZM63.1677 52.7478C63.1677 53.6689 63.5336 54.5524 64.185 55.2038C64.8363 55.8551 65.7198 56.2211 66.641 56.2211C67.5621 56.2211 68.4456 55.8551 69.097 55.2038C69.7483 54.5524 70.1143 53.6689 70.1143 52.7478C70.1143 51.8266 69.7483 50.9431 69.097 50.2918C68.4456 49.6404 67.5621 49.2745 66.641 49.2745C65.7198 49.2745 64.8363 49.6404 64.185 50.2918C63.5336 50.9431 63.1677 51.8266 63.1677 52.7478ZM77.0609 52.7478C77.0609 53.2039 77.1507 53.6555 77.3252 54.0769C77.4998 54.4983 77.7556 54.8812 78.0782 55.2038C78.4007 55.5263 78.7836 55.7821 79.205 55.9567C79.6264 56.1312 80.078 56.2211 80.5341 56.2211C80.9903 56.2211 81.4419 56.1312 81.8633 55.9567C82.2847 55.7821 82.6676 55.5263 82.9901 55.2038C83.3127 54.8812 83.5685 54.4983 83.743 54.0769C83.9176 53.6555 84.0074 53.2039 84.0074 52.7478C84.0074 52.2916 83.9176 51.84 83.743 51.4186C83.5685 50.9972 83.3127 50.6143 82.9901 50.2918C82.6676 49.9692 82.2847 49.7134 81.8633 49.5389C81.4419 49.3643 80.9903 49.2745 80.5341 49.2745C80.078 49.2745 79.6264 49.3643 79.205 49.5389C78.7836 49.7134 78.4007 49.9692 78.0782 50.2918C77.7556 50.6143 77.4998 50.9972 77.3252 51.4186C77.1507 51.84 77.0609 52.2916 77.0609 52.7478ZM90.954 52.7478C90.954 53.6689 91.32 54.5524 91.9713 55.2038C92.6227 55.8551 93.5061 56.2211 94.4273 56.2211C95.3485 56.2211 96.2319 55.8551 96.8833 55.2038C97.5347 54.5524 97.9006 53.6689 97.9006 52.7478C97.9006 51.8266 97.5347 50.9431 96.8833 50.2918C96.2319 49.6404 95.3485 49.2745 94.4273 49.2745C93.5061 49.2745 92.6227 49.6404 91.9713 50.2918C91.32 50.9431 90.954 51.8266 90.954 52.7478ZM104.847 52.7478C104.847 53.6689 105.213 54.5524 105.865 55.2038C106.516 55.8551 107.399 56.2211 108.321 56.2211C109.242 56.2211 110.125 55.8551 110.776 55.2038C111.428 54.5524 111.794 53.6689 111.794 52.7478C111.794 51.8266 111.428 50.9431 110.776 50.2918C110.125 49.6404 109.242 49.2745 108.321 49.2745C107.399 49.2745 106.516 49.6404 105.865 50.2918C105.213 50.9431 104.847 51.8266 104.847 52.7478ZM118.74 52.7478C118.74 53.6689 119.106 54.5524 119.758 55.2038C120.409 55.8551 121.292 56.2211 122.214 56.2211C123.135 56.2211 124.018 55.8551 124.67 55.2038C125.321 54.5524 125.687 53.6689 125.687 52.7478C125.687 51.8266 125.321 50.9431 124.67 50.2918C124.018 49.6404 123.135 49.2745 122.214 49.2745C121.292 49.2745 120.409 49.6404 119.758 50.2918C119.106 50.9431 118.74 51.8266 118.74 52.7478ZM132.634 52.7478C132.634 53.6689 132.999 54.5524 133.651 55.2038C134.302 55.8551 135.186 56.2211 136.107 56.2211C137.028 56.2211 137.911 55.8551 138.563 55.2038C139.214 54.5524 139.58 53.6689 139.58 52.7478C139.58 51.8266 139.214 50.9431 138.563 50.2918C137.911 49.6404 137.028 49.2745 136.107 49.2745C135.186 49.2745 134.302 49.6404 133.651 50.2918C132.999 50.9431 132.634 51.8266 132.634 52.7478ZM146.527 52.7478C146.527 53.6689 146.893 54.5524 147.544 55.2038C148.195 55.8551 149.079 56.2211 150 56.2211C150.921 56.2211 151.805 55.8551 152.456 55.2038C153.107 54.5524 153.473 53.6689 153.473 52.7478C153.473 51.8266 153.107 50.9431 152.456 50.2918C151.805 49.6404 150.921 49.2745 150 49.2745C149.079 49.2745 148.195 49.6404 147.544 50.2918C146.893 50.9431 146.527 51.8266 146.527 52.7478ZM160.42 52.7478C160.42 53.6689 160.786 54.5524 161.437 55.2038C162.089 55.8551 162.972 56.2211 163.893 56.2211C164.814 56.2211 165.698 55.8551 166.349 55.2038C167.001 54.5524 167.366 53.6689 167.366 52.7478C167.366 51.8266 167.001 50.9431 166.349 50.2918C165.698 49.6404 164.814 49.2745 163.893 49.2745C162.972 49.2745 162.089 49.6404 161.437 50.2918C160.786 50.9431 160.42 51.8266 160.42 52.7478ZM174.313 52.7478C174.313 53.6689 174.679 54.5524 175.33 55.2038C175.982 55.8551 176.865 56.2211 177.786 56.2211C178.708 56.2211 179.591 55.8551 180.242 55.2038C180.894 54.5524 181.26 53.6689 181.26 52.7478C181.26 51.8266 180.894 50.9431 180.242 50.2918C179.591 49.6404 178.708 49.2745 177.786 49.2745C176.865 49.2745 175.982 49.6404 175.33 50.2918C174.679 50.9431 174.313 51.8266 174.313 52.7478ZM188.206 52.7478C188.206 53.6689 188.572 54.5524 189.224 55.2038C189.875 55.8551 190.758 56.2211 191.68 56.2211C192.601 56.2211 193.484 55.8551 194.136 55.2038C194.787 54.5524 195.153 53.6689 195.153 52.7478C195.153 51.8266 194.787 50.9431 194.136 50.2918C193.484 49.6404 192.601 49.2745 191.68 49.2745C190.758 49.2745 189.875 49.6404 189.224 50.2918C188.572 50.9431 188.206 51.8266 188.206 52.7478ZM202.099 52.7478C202.099 53.6689 202.465 54.5524 203.117 55.2038C203.768 55.8551 204.652 56.2211 205.573 56.2211C206.494 56.2211 207.377 55.8551 208.029 55.2038C208.68 54.5524 209.046 53.6689 209.046 52.7478C209.046 51.8266 208.68 50.9431 208.029 50.2918C207.377 49.6404 206.494 49.2745 205.573 49.2745C204.652 49.2745 203.768 49.6404 203.117 50.2918C202.465 50.9431 202.099 51.8266 202.099 52.7478ZM215.993 52.7478C215.993 53.6689 216.359 54.5524 217.01 55.2038C217.661 55.8551 218.545 56.2211 219.466 56.2211C220.387 56.2211 221.271 55.8551 221.922 55.2038C222.573 54.5524 222.939 53.6689 222.939 52.7478C222.939 51.8266 222.573 50.9431 221.922 50.2918C221.271 49.6404 220.387 49.2745 219.466 49.2745C218.545 49.2745 217.661 49.6404 217.01 50.2918C216.359 50.9431 215.993 51.8266 215.993 52.7478ZM229.886 52.7478C229.886 53.6689 230.252 54.5524 230.903 55.2038C231.554 55.8551 232.438 56.2211 233.359 56.2211C234.28 56.2211 235.164 55.8551 235.815 55.2038C236.466 54.5524 236.832 53.6689 236.832 52.7478C236.832 51.8266 236.466 50.9431 235.815 50.2918C235.164 49.6404 234.28 49.2745 233.359 49.2745C232.438 49.2745 231.554 49.6404 230.903 50.2918C230.252 50.9431 229.886 51.8266 229.886 52.7478ZM243.779 52.7478C243.779 53.6689 244.145 54.5524 244.796 55.2038C245.448 55.8551 246.331 56.2211 247.252 56.2211C248.173 56.2211 249.057 55.8551 249.708 55.2038C250.36 54.5524 250.726 53.6689 250.726 52.7478C250.726 51.8266 250.36 50.9431 249.708 50.2918C249.057 49.6404 248.173 49.2745 247.252 49.2745C246.331 49.2745 245.448 49.6404 244.796 50.2918C244.145 50.9431 243.779 51.8266 243.779 52.7478ZM250.726 52.7478C250.726 53.6689 251.091 54.5524 251.743 55.2038C252.394 55.8551 253.278 56.2211 254.199 56.2211C255.12 56.2211 256.003 55.8551 256.655 55.2038C257.306 54.5524 257.672 53.6689 257.672 52.7478C257.672 51.8266 257.306 50.9431 256.655 50.2918C256.003 49.6404 255.12 49.2745 254.199 49.2745C253.278 49.2745 252.394 49.6404 251.743 50.2918C251.091 50.9431 250.726 51.8266 250.726 52.7478ZM257.672 52.7478C257.672 53.6689 258.038 54.5524 258.689 55.2038C259.341 55.8551 260.224 56.2211 261.145 56.2211C262.067 56.2211 262.95 55.8551 263.601 55.2038C264.253 54.5524 264.619 53.6689 264.619 52.7478C264.619 51.8266 264.253 50.9431 263.601 50.2918C262.95 49.6404 262.067 49.2745 261.145 49.2745C260.224 49.2745 259.341 49.6404 258.689 50.2918C258.038 50.9431 257.672 51.8266 257.672 52.7478ZM264.619 52.7478C264.619 53.6689 264.985 54.5524 265.636 55.2038C266.287 55.8551 267.171 56.2211 268.092 56.2211C269.013 56.2211 269.897 55.8551 270.548 55.2038C271.199 54.5524 271.565 53.6689 271.565 52.7478C271.565 51.8266 271.199 50.9431 270.548 50.2918C269.897 49.6404 269.013 49.2745 268.092 49.2745C267.171 49.2745 266.287 49.6404 265.636 50.2918C264.985 50.9431 264.619 51.8266 264.619 52.7478ZM271.565 52.7478C271.565 53.6689 271.931 54.5524 272.583 55.2038C273.234 55.8551 274.117 56.2211 275.039 56.2211C275.96 56.2211 276.843 55.8551 277.495 55.2038C278.146 54.5524 278.512 53.6689 278.512 52.7478C278.512 51.8266 278.146 50.9431 277.495 50.2918C276.843 49.6404 275.96 49.2745 275.039 49.2745C274.117 49.2745 273.234 49.6404 272.583 50.2918C271.931 50.9431 271.565 51.8266 271.565 52.7478ZM278.512 52.7478C278.512 53.6689 278.878 54.5524 279.529 55.2038C280.181 55.8551 281.064 56.2211 281.985 56.2211C282.906 56.2211 283.79 55.8551 284.441 55.2038C285.093 54.5524 285.458 53.6689 285.458 52.7478C285.458 51.8266 285.093 50.9431 284.441 50.2918C283.79 49.6404 282.906 49.2745 281.985 49.2745C281.064 49.2745 280.181 49.6404 279.529 50.2918C278.878 50.9431 278.512 51.8266 278.512 52.7478ZM285.458 52.7478C285.458 53.6689 285.824 54.5524 286.476 55.2038C287.127 55.8551 288.011 56.2211 288.932 56.2211C289.853 56.2211 290.736 55.8551 291.388 55.2038C292.039 54.5524 292.405 53.6689 292.405 52.7478C292.405 51.8266 292.039 50.9431 291.388 50.2918C290.736 49.6404 289.853 49.2745 288.932 49.2745C288.011 49.2745 287.127 49.6404 286.476 50.2918C285.824 50.9431 285.458 51.8266 285.458 52.7478ZM63.1677 59.6944C63.1677 60.6155 63.5336 61.499 64.185 62.1503C64.8363 62.8017 65.7198 63.1676 66.641 63.1676C67.5621 63.1676 68.4456 62.8017 69.097 62.1503C69.7483 61.499 70.1143 60.6155 70.1143 59.6944C70.1143 58.7732 69.7483 57.8897 69.097 57.2384C68.4456 56.587 67.5621 56.2211 66.641 56.2211C65.7198 56.2211 64.8363 56.587 64.185 57.2384C63.5336 57.8897 63.1677 58.7732 63.1677 59.6944ZM70.1143 59.6944C70.1143 60.6155 70.4802 61.499 71.1316 62.1503C71.7829 62.8017 72.6664 63.1676 73.5876 63.1676C74.5087 63.1676 75.3922 62.8017 76.0436 62.1503C76.6949 61.499 77.0609 60.6155 77.0609 59.6944C77.0609 58.7732 76.6949 57.8897 76.0436 57.2384C75.3922 56.587 74.5087 56.2211 73.5876 56.2211C72.6664 56.2211 71.7829 56.587 71.1316 57.2384C70.4802 57.8897 70.1143 58.7732 70.1143 59.6944ZM77.0609 59.6944C77.0609 60.1505 77.1507 60.6021 77.3252 61.0235C77.4998 61.4449 77.7556 61.8278 78.0782 62.1503C78.4007 62.4729 78.7836 62.7287 79.205 62.9033C79.6264 63.0778 80.078 63.1676 80.5341 63.1676C80.9903 63.1676 81.4419 63.0778 81.8633 62.9033C82.2847 62.7287 82.6676 62.4729 82.9901 62.1503C83.3127 61.8278 83.5685 61.4449 83.743 61.0235C83.9176 60.6021 84.0074 60.1505 84.0074 59.6944C84.0074 59.2382 83.9176 58.7866 83.743 58.3652C83.5685 57.9438 83.3127 57.5609 82.9901 57.2384C82.6676 56.9158 82.2847 56.66 81.8633 56.4854C81.4419 56.3109 80.9903 56.2211 80.5341 56.2211C80.078 56.2211 79.6264 56.3109 79.205 56.4854C78.7836 56.66 78.4007 56.9158 78.0782 57.2384C77.7556 57.5609 77.4998 57.9438 77.3252 58.3652C77.1507 58.7866 77.0609 59.2382 77.0609 59.6944ZM118.74 59.6944C118.74 60.6155 119.106 61.499 119.758 62.1503C120.409 62.8017 121.292 63.1676 122.214 63.1676C123.135 63.1676 124.018 62.8017 124.67 62.1503C125.321 61.499 125.687 60.6155 125.687 59.6944C125.687 58.7732 125.321 57.8897 124.67 57.2384C124.018 56.587 123.135 56.2211 122.214 56.2211C121.292 56.2211 120.409 56.587 119.758 57.2384C119.106 57.8897 118.74 58.7732 118.74 59.6944ZM125.687 59.6944C125.687 60.6155 126.053 61.499 126.704 62.1503C127.356 62.8017 128.239 63.1676 129.16 63.1676C130.081 63.1676 130.965 62.8017 131.616 62.1503C132.268 61.499 132.634 60.6155 132.634 59.6944C132.634 58.7732 132.268 57.8897 131.616 57.2384C130.965 56.587 130.081 56.2211 129.16 56.2211C128.239 56.2211 127.356 56.587 126.704 57.2384C126.053 57.8897 125.687 58.7732 125.687 59.6944ZM139.58 59.6944C139.58 60.6155 139.946 61.499 140.597 62.1503C141.249 62.8017 142.132 63.1676 143.053 63.1676C143.975 63.1676 144.858 62.8017 145.509 62.1503C146.161 61.499 146.527 60.6155 146.527 59.6944C146.527 58.7732 146.161 57.8897 145.509 57.2384C144.858 56.587 143.975 56.2211 143.053 56.2211C142.132 56.2211 141.249 56.587 140.597 57.2384C139.946 57.8897 139.58 58.7732 139.58 59.6944ZM160.42 59.6944C160.42 60.6155 160.786 61.499 161.437 62.1503C162.089 62.8017 162.972 63.1676 163.893 63.1676C164.814 63.1676 165.698 62.8017 166.349 62.1503C167.001 61.499 167.366 60.6155 167.366 59.6944C167.366 58.7732 167.001 57.8897 166.349 57.2384C165.698 56.587 164.814 56.2211 163.893 56.2211C162.972 56.2211 162.089 56.587 161.437 57.2384C160.786 57.8897 160.42 58.7732 160.42 59.6944ZM174.313 59.6944C174.313 60.6155 174.679 61.499 175.33 62.1503C175.982 62.8017 176.865 63.1676 177.786 63.1676C178.708 63.1676 179.591 62.8017 180.242 62.1503C180.894 61.499 181.26 60.6155 181.26 59.6944C181.26 58.7732 180.894 57.8897 180.242 57.2384C179.591 56.587 178.708 56.2211 177.786 56.2211C176.865 56.2211 175.982 56.587 175.33 57.2384C174.679 57.8897 174.313 58.7732 174.313 59.6944ZM188.206 59.6944C188.206 60.6155 188.572 61.499 189.224 62.1503C189.875 62.8017 190.758 63.1676 191.68 63.1676C192.601 63.1676 193.484 62.8017 194.136 62.1503C194.787 61.499 195.153 60.6155 195.153 59.6944C195.153 58.7732 194.787 57.8897 194.136 57.2384C193.484 56.587 192.601 56.2211 191.68 56.2211C190.758 56.2211 189.875 56.587 189.224 57.2384C188.572 57.8897 188.206 58.7732 188.206 59.6944ZM209.046 59.6944C209.046 60.6155 209.412 61.499 210.063 62.1503C210.715 62.8017 211.598 63.1676 212.519 63.1676C213.44 63.1676 214.324 62.8017 214.975 62.1503C215.627 61.499 215.993 60.6155 215.993 59.6944C215.993 58.7732 215.627 57.8897 214.975 57.2384C214.324 56.587 213.44 56.2211 212.519 56.2211C211.598 56.2211 210.715 56.587 210.063 57.2384C209.412 57.8897 209.046 58.7732 209.046 59.6944ZM215.993 59.6944C215.993 60.6155 216.359 61.499 217.01 62.1503C217.661 62.8017 218.545 63.1676 219.466 63.1676C220.387 63.1676 221.271 62.8017 221.922 62.1503C222.573 61.499 222.939 60.6155 222.939 59.6944C222.939 58.7732 222.573 57.8897 221.922 57.2384C221.271 56.587 220.387 56.2211 219.466 56.2211C218.545 56.2211 217.661 56.587 217.01 57.2384C216.359 57.8897 215.993 58.7732 215.993 59.6944ZM222.939 59.6944C222.939 60.6155 223.305 61.499 223.957 62.1503C224.608 62.8017 225.491 63.1676 226.413 63.1676C227.334 63.1676 228.217 62.8017 228.868 62.1503C229.52 61.499 229.886 60.6155 229.886 59.6944C229.886 58.7732 229.52 57.8897 228.868 57.2384C228.217 56.587 227.334 56.2211 226.413 56.2211C225.491 56.2211 224.608 56.587 223.957 57.2384C223.305 57.8897 222.939 58.7732 222.939 59.6944ZM229.886 59.6944C229.886 60.6155 230.252 61.499 230.903 62.1503C231.554 62.8017 232.438 63.1676 233.359 63.1676C234.28 63.1676 235.164 62.8017 235.815 62.1503C236.466 61.499 236.832 60.6155 236.832 59.6944C236.832 58.7732 236.466 57.8897 235.815 57.2384C235.164 56.587 234.28 56.2211 233.359 56.2211C232.438 56.2211 231.554 56.587 230.903 57.2384C230.252 57.8897 229.886 58.7732 229.886 59.6944ZM35.3813 66.6409C35.3813 67.5621 35.7473 68.4456 36.3986 69.0969C37.05 69.7483 37.9334 70.1142 38.8546 70.1142C39.7758 70.1142 40.6592 69.7483 41.3106 69.0969C41.962 68.4456 42.3279 67.5621 42.3279 66.6409C42.3279 65.7198 41.962 64.8363 41.3106 64.185C40.6592 63.5336 39.7758 63.1676 38.8546 63.1676C37.9334 63.1676 37.05 63.5336 36.3986 64.185C35.7473 64.8363 35.3813 65.7198 35.3813 66.6409ZM42.3279 66.6409C42.3279 67.0971 42.4177 67.5487 42.5923 67.9701C42.7668 68.3915 43.0227 68.7744 43.3452 69.0969C43.6677 69.4195 44.0506 69.6753 44.472 69.8498C44.8934 70.0244 45.3451 70.1142 45.8012 70.1142C46.2573 70.1142 46.709 70.0244 47.1304 69.8498C47.5518 69.6753 47.9347 69.4195 48.2572 69.0969C48.5797 68.7744 48.8356 68.3915 49.0101 67.9701C49.1847 67.5487 49.2745 67.0971 49.2745 66.6409C49.2745 66.1848 49.1847 65.7332 49.0101 65.3118C48.8356 64.8904 48.5797 64.5075 48.2572 64.185C47.9347 63.8624 47.5518 63.6066 47.1304 63.432C46.709 63.2575 46.2573 63.1676 45.8012 63.1676C45.3451 63.1676 44.8934 63.2575 44.472 63.432C44.0506 63.6066 43.6677 63.8624 43.3452 64.185C43.0227 64.5075 42.7668 64.8904 42.5923 65.3118C42.4177 65.7332 42.3279 66.1848 42.3279 66.6409ZM49.2745 66.6409C49.2745 67.0971 49.3643 67.5487 49.5389 67.9701C49.7134 68.3915 49.9693 68.7744 50.2918 69.0969C50.6143 69.4195 50.9972 69.6753 51.4186 69.8498C51.84 70.0244 52.2917 70.1142 52.7478 70.1142C53.2039 70.1142 53.6556 70.0244 54.077 69.8498C54.4984 69.6753 54.8813 69.4195 55.2038 69.0969C55.5263 68.7744 55.7821 68.3915 55.9567 67.9701C56.1312 67.5487 56.2211 67.0971 56.2211 66.6409C56.2211 66.1848 56.1312 65.7332 55.9567 65.3118C55.7821 64.8904 55.5263 64.5075 55.2038 64.185C54.8813 63.8624 54.4984 63.6066 54.077 63.432C53.6556 63.2575 53.2039 63.1676 52.7478 63.1676C52.2917 63.1676 51.84 63.2575 51.4186 63.432C50.9972 63.6066 50.6143 63.8624 50.2918 64.185C49.9693 64.5075 49.7134 64.8904 49.5389 65.3118C49.3643 65.7332 49.2745 66.1848 49.2745 66.6409ZM56.2211 66.6409C56.2211 67.5621 56.587 68.4456 57.2384 69.0969C57.8898 69.7483 58.7732 70.1142 59.6944 70.1142C60.6156 70.1142 61.499 69.7483 62.1504 69.0969C62.8017 68.4456 63.1677 67.5621 63.1677 66.6409C63.1677 65.7198 62.8017 64.8363 62.1504 64.185C61.499 63.5336 60.6156 63.1676 59.6944 63.1676C58.7732 63.1676 57.8898 63.5336 57.2384 64.185C56.587 64.8363 56.2211 65.7198 56.2211 66.6409ZM70.1143 66.6409C70.1143 67.5621 70.4802 68.4456 71.1316 69.0969C71.7829 69.7483 72.6664 70.1142 73.5876 70.1142C74.5087 70.1142 75.3922 69.7483 76.0436 69.0969C76.6949 68.4456 77.0609 67.5621 77.0609 66.6409C77.0609 65.7198 76.6949 64.8363 76.0436 64.185C75.3922 63.5336 74.5087 63.1676 73.5876 63.1676C72.6664 63.1676 71.7829 63.5336 71.1316 64.185C70.4802 64.8363 70.1143 65.7198 70.1143 66.6409ZM77.0609 66.6409C77.0609 67.0971 77.1507 67.5487 77.3252 67.9701C77.4998 68.3915 77.7556 68.7744 78.0782 69.0969C78.4007 69.4195 78.7836 69.6753 79.205 69.8498C79.6264 70.0244 80.078 70.1142 80.5341 70.1142C80.9903 70.1142 81.4419 70.0244 81.8633 69.8498C82.2847 69.6753 82.6676 69.4195 82.9901 69.0969C83.3127 68.7744 83.5685 68.3915 83.743 67.9701C83.9176 67.5487 84.0074 67.0971 84.0074 66.6409C84.0074 66.1848 83.9176 65.7332 83.743 65.3118C83.5685 64.8904 83.3127 64.5075 82.9901 64.185C82.6676 63.8624 82.2847 63.6066 81.8633 63.432C81.4419 63.2575 80.9903 63.1676 80.5341 63.1676C80.078 63.1676 79.6264 63.2575 79.205 63.432C78.7836 63.6066 78.4007 63.8624 78.0782 64.185C77.7556 64.5075 77.4998 64.8904 77.3252 65.3118C77.1507 65.7332 77.0609 66.1848 77.0609 66.6409ZM84.0074 66.6409C84.0074 67.5621 84.3734 68.4456 85.0247 69.0969C85.6761 69.7483 86.5596 70.1142 87.4807 70.1142C88.4019 70.1142 89.2854 69.7483 89.9367 69.0969C90.5881 68.4456 90.954 67.5621 90.954 66.6409C90.954 65.7198 90.5881 64.8363 89.9367 64.185C89.2854 63.5336 88.4019 63.1676 87.4807 63.1676C86.5596 63.1676 85.6761 63.5336 85.0247 64.185C84.3734 64.8363 84.0074 65.7198 84.0074 66.6409ZM111.794 66.6409C111.794 67.5621 112.16 68.4456 112.811 69.0969C113.462 69.7483 114.346 70.1142 115.267 70.1142C116.188 70.1142 117.072 69.7483 117.723 69.0969C118.374 68.4456 118.74 67.5621 118.74 66.6409C118.74 65.7198 118.374 64.8363 117.723 64.185C117.072 63.5336 116.188 63.1676 115.267 63.1676C114.346 63.1676 113.462 63.5336 112.811 64.185C112.16 64.8363 111.794 65.7198 111.794 66.6409ZM118.74 66.6409C118.74 67.5621 119.106 68.4456 119.758 69.0969C120.409 69.7483 121.292 70.1142 122.214 70.1142C123.135 70.1142 124.018 69.7483 124.67 69.0969C125.321 68.4456 125.687 67.5621 125.687 66.6409C125.687 65.7198 125.321 64.8363 124.67 64.185C124.018 63.5336 123.135 63.1676 122.214 63.1676C121.292 63.1676 120.409 63.5336 119.758 64.185C119.106 64.8363 118.74 65.7198 118.74 66.6409ZM125.687 66.6409C125.687 67.5621 126.053 68.4456 126.704 69.0969C127.356 69.7483 128.239 70.1142 129.16 70.1142C130.081 70.1142 130.965 69.7483 131.616 69.0969C132.268 68.4456 132.634 67.5621 132.634 66.6409C132.634 65.7198 132.268 64.8363 131.616 64.185C130.965 63.5336 130.081 63.1676 129.16 63.1676C128.239 63.1676 127.356 63.5336 126.704 64.185C126.053 64.8363 125.687 65.7198 125.687 66.6409ZM132.634 66.6409C132.634 67.5621 132.999 68.4456 133.651 69.0969C134.302 69.7483 135.186 70.1142 136.107 70.1142C137.028 70.1142 137.911 69.7483 138.563 69.0969C139.214 68.4456 139.58 67.5621 139.58 66.6409C139.58 65.7198 139.214 64.8363 138.563 64.185C137.911 63.5336 137.028 63.1676 136.107 63.1676C135.186 63.1676 134.302 63.5336 133.651 64.185C132.999 64.8363 132.634 65.7198 132.634 66.6409ZM160.42 66.6409C160.42 67.5621 160.786 68.4456 161.437 69.0969C162.089 69.7483 162.972 70.1142 163.893 70.1142C164.814 70.1142 165.698 69.7483 166.349 69.0969C167.001 68.4456 167.366 67.5621 167.366 66.6409C167.366 65.7198 167.001 64.8363 166.349 64.185C165.698 63.5336 164.814 63.1676 163.893 63.1676C162.972 63.1676 162.089 63.5336 161.437 64.185C160.786 64.8363 160.42 65.7198 160.42 66.6409ZM174.313 66.6409C174.313 67.5621 174.679 68.4456 175.33 69.0969C175.982 69.7483 176.865 70.1142 177.786 70.1142C178.708 70.1142 179.591 69.7483 180.242 69.0969C180.894 68.4456 181.26 67.5621 181.26 66.6409C181.26 65.7198 180.894 64.8363 180.242 64.185C179.591 63.5336 178.708 63.1676 177.786 63.1676C176.865 63.1676 175.982 63.5336 175.33 64.185C174.679 64.8363 174.313 65.7198 174.313 66.6409ZM195.153 66.6409C195.153 67.0971 195.243 67.5487 195.417 67.9701C195.592 68.3915 195.848 68.7744 196.17 69.0969C196.493 69.4195 196.876 69.6753 197.297 69.8498C197.718 70.0244 198.17 70.1142 198.626 70.1142C199.082 70.1142 199.534 70.0244 199.955 69.8498C200.377 69.6753 200.76 69.4195 201.082 69.0969C201.405 68.7744 201.661 68.3915 201.835 67.9701C202.01 67.5487 202.099 67.0971 202.099 66.6409C202.099 66.1848 202.01 65.7332 201.835 65.3118C201.661 64.8904 201.405 64.5075 201.082 64.185C200.76 63.8624 200.377 63.6066 199.955 63.432C199.534 63.2575 199.082 63.1676 198.626 63.1676C198.17 63.1676 197.718 63.2575 197.297 63.432C196.876 63.6066 196.493 63.8624 196.17 64.185C195.848 64.5075 195.592 64.8904 195.417 65.3118C195.243 65.7332 195.153 66.1848 195.153 66.6409ZM209.046 66.6409C209.046 67.5621 209.412 68.4456 210.063 69.0969C210.715 69.7483 211.598 70.1142 212.519 70.1142C213.44 70.1142 214.324 69.7483 214.975 69.0969C215.627 68.4456 215.993 67.5621 215.993 66.6409C215.993 65.7198 215.627 64.8363 214.975 64.185C214.324 63.5336 213.44 63.1676 212.519 63.1676C211.598 63.1676 210.715 63.5336 210.063 64.185C209.412 64.8363 209.046 65.7198 209.046 66.6409ZM243.779 66.6409C243.779 67.5621 244.145 68.4456 244.796 69.0969C245.448 69.7483 246.331 70.1142 247.252 70.1142C248.173 70.1142 249.057 69.7483 249.708 69.0969C250.36 68.4456 250.726 67.5621 250.726 66.6409C250.726 65.7198 250.36 64.8363 249.708 64.185C249.057 63.5336 248.173 63.1676 247.252 63.1676C246.331 63.1676 245.448 63.5336 244.796 64.185C244.145 64.8363 243.779 65.7198 243.779 66.6409ZM250.726 66.6409C250.726 67.5621 251.091 68.4456 251.743 69.0969C252.394 69.7483 253.278 70.1142 254.199 70.1142C255.12 70.1142 256.003 69.7483 256.655 69.0969C257.306 68.4456 257.672 67.5621 257.672 66.6409C257.672 65.7198 257.306 64.8363 256.655 64.185C256.003 63.5336 255.12 63.1676 254.199 63.1676C253.278 63.1676 252.394 63.5336 251.743 64.185C251.091 64.8363 250.726 65.7198 250.726 66.6409ZM278.512 66.6409C278.512 67.5621 278.878 68.4456 279.529 69.0969C280.181 69.7483 281.064 70.1142 281.985 70.1142C282.906 70.1142 283.79 69.7483 284.441 69.0969C285.093 68.4456 285.458 67.5621 285.458 66.6409C285.458 65.7198 285.093 64.8363 284.441 64.185C283.79 63.5336 282.906 63.1676 281.985 63.1676C281.064 63.1676 280.181 63.5336 279.529 64.185C278.878 64.8363 278.512 65.7198 278.512 66.6409ZM7.59497 73.5875C7.59497 74.5087 7.96091 75.3922 8.61227 76.0435C9.26364 76.6949 10.1471 77.0608 11.0683 77.0608C11.9894 77.0608 12.8729 76.6949 13.5243 76.0435C14.1756 75.3922 14.5416 74.5087 14.5416 73.5875C14.5416 72.6663 14.1756 71.7829 13.5243 71.1315C12.8729 70.4802 11.9894 70.1142 11.0683 70.1142C10.1471 70.1142 9.26364 70.4802 8.61227 71.1315C7.96091 71.7829 7.59497 72.6663 7.59497 73.5875ZM35.3813 73.5875C35.3813 74.5087 35.7473 75.3922 36.3986 76.0435C37.05 76.6949 37.9334 77.0608 38.8546 77.0608C39.7758 77.0608 40.6592 76.6949 41.3106 76.0435C41.962 75.3922 42.3279 74.5087 42.3279 73.5875C42.3279 72.6663 41.962 71.7829 41.3106 71.1315C40.6592 70.4802 39.7758 70.1142 38.8546 70.1142C37.9334 70.1142 37.05 70.4802 36.3986 71.1315C35.7473 71.7829 35.3813 72.6663 35.3813 73.5875ZM97.9006 73.5875C97.9006 74.0436 97.9905 74.4953 98.165 74.9167C98.3396 75.3381 98.5954 75.721 98.9179 76.0435C99.2404 76.366 99.6233 76.6219 100.045 76.7964C100.466 76.971 100.918 77.0608 101.374 77.0608C101.83 77.0608 102.282 76.971 102.703 76.7964C103.124 76.6219 103.507 76.366 103.83 76.0435C104.152 75.721 104.408 75.3381 104.583 74.9167C104.757 74.4953 104.847 74.0436 104.847 73.5875C104.847 73.1314 104.757 72.6798 104.583 72.2584C104.408 71.837 104.152 71.4541 103.83 71.1315C103.507 70.809 103.124 70.5532 102.703 70.3786C102.282 70.2041 101.83 70.1142 101.374 70.1142C100.918 70.1142 100.466 70.2041 100.045 70.3786C99.6233 70.5532 99.2404 70.809 98.9179 71.1315C98.5954 71.4541 98.3396 71.837 98.165 72.2584C97.9905 72.6798 97.9006 73.1314 97.9006 73.5875ZM111.794 73.5875C111.794 74.5087 112.16 75.3922 112.811 76.0435C113.462 76.6949 114.346 77.0608 115.267 77.0608C116.188 77.0608 117.072 76.6949 117.723 76.0435C118.374 75.3922 118.74 74.5087 118.74 73.5875C118.74 72.6663 118.374 71.7829 117.723 71.1315C117.072 70.4802 116.188 70.1142 115.267 70.1142C114.346 70.1142 113.462 70.4802 112.811 71.1315C112.16 71.7829 111.794 72.6663 111.794 73.5875ZM125.687 73.5875C125.687 74.5087 126.053 75.3922 126.704 76.0435C127.356 76.6949 128.239 77.0608 129.16 77.0608C130.081 77.0608 130.965 76.6949 131.616 76.0435C132.268 75.3922 132.634 74.5087 132.634 73.5875C132.634 72.6663 132.268 71.7829 131.616 71.1315C130.965 70.4802 130.081 70.1142 129.16 70.1142C128.239 70.1142 127.356 70.4802 126.704 71.1315C126.053 71.7829 125.687 72.6663 125.687 73.5875ZM146.527 73.5875C146.527 74.5087 146.893 75.3922 147.544 76.0435C148.195 76.6949 149.079 77.0608 150 77.0608C150.921 77.0608 151.805 76.6949 152.456 76.0435C153.107 75.3922 153.473 74.5087 153.473 73.5875C153.473 72.6663 153.107 71.7829 152.456 71.1315C151.805 70.4802 150.921 70.1142 150 70.1142C149.079 70.1142 148.195 70.4802 147.544 71.1315C146.893 71.7829 146.527 72.6663 146.527 73.5875ZM153.473 73.5875C153.473 74.0436 153.563 74.4953 153.738 74.9167C153.912 75.3381 154.168 75.721 154.491 76.0435C154.813 76.366 155.196 76.6219 155.617 76.7964C156.039 76.971 156.491 77.0608 156.947 77.0608C157.403 77.0608 157.854 76.971 158.276 76.7964C158.697 76.6219 159.08 76.366 159.403 76.0435C159.725 75.721 159.981 75.3381 160.156 74.9167C160.33 74.4953 160.42 74.0436 160.42 73.5875C160.42 73.1314 160.33 72.6798 160.156 72.2584C159.981 71.837 159.725 71.4541 159.403 71.1315C159.08 70.809 158.697 70.5532 158.276 70.3786C157.854 70.2041 157.403 70.1142 156.947 70.1142C156.491 70.1142 156.039 70.2041 155.617 70.3786C155.196 70.5532 154.813 70.809 154.491 71.1315C154.168 71.4541 153.912 71.837 153.738 72.2584C153.563 72.6798 153.473 73.1314 153.473 73.5875ZM160.42 73.5875C160.42 74.5087 160.786 75.3922 161.437 76.0435C162.089 76.6949 162.972 77.0608 163.893 77.0608C164.814 77.0608 165.698 76.6949 166.349 76.0435C167.001 75.3922 167.366 74.5087 167.366 73.5875C167.366 72.6663 167.001 71.7829 166.349 71.1315C165.698 70.4802 164.814 70.1142 163.893 70.1142C162.972 70.1142 162.089 70.4802 161.437 71.1315C160.786 71.7829 160.42 72.6663 160.42 73.5875ZM181.26 73.5875C181.26 74.5087 181.626 75.3922 182.277 76.0435C182.928 76.6949 183.812 77.0608 184.733 77.0608C185.654 77.0608 186.538 76.6949 187.189 76.0435C187.84 75.3922 188.206 74.5087 188.206 73.5875C188.206 72.6663 187.84 71.7829 187.189 71.1315C186.538 70.4802 185.654 70.1142 184.733 70.1142C183.812 70.1142 182.928 70.4802 182.277 71.1315C181.626 71.7829 181.26 72.6663 181.26 73.5875ZM188.206 73.5875C188.206 74.5087 188.572 75.3922 189.224 76.0435C189.875 76.6949 190.758 77.0608 191.68 77.0608C192.601 77.0608 193.484 76.6949 194.136 76.0435C194.787 75.3922 195.153 74.5087 195.153 73.5875C195.153 72.6663 194.787 71.7829 194.136 71.1315C193.484 70.4802 192.601 70.1142 191.68 70.1142C190.758 70.1142 189.875 70.4802 189.224 71.1315C188.572 71.7829 188.206 72.6663 188.206 73.5875ZM195.153 73.5875C195.153 74.0436 195.243 74.4953 195.417 74.9167C195.592 75.3381 195.848 75.721 196.17 76.0435C196.493 76.366 196.876 76.6219 197.297 76.7964C197.718 76.971 198.17 77.0608 198.626 77.0608C199.082 77.0608 199.534 76.971 199.955 76.7964C200.377 76.6219 200.76 76.366 201.082 76.0435C201.405 75.721 201.661 75.3381 201.835 74.9167C202.01 74.4953 202.099 74.0436 202.099 73.5875C202.099 73.1314 202.01 72.6798 201.835 72.2584C201.661 71.837 201.405 71.4541 201.082 71.1315C200.76 70.809 200.377 70.5532 199.955 70.3786C199.534 70.2041 199.082 70.1142 198.626 70.1142C198.17 70.1142 197.718 70.2041 197.297 70.3786C196.876 70.5532 196.493 70.809 196.17 71.1315C195.848 71.4541 195.592 71.837 195.417 72.2584C195.243 72.6798 195.153 73.1314 195.153 73.5875ZM202.099 73.5875C202.099 74.5087 202.465 75.3922 203.117 76.0435C203.768 76.6949 204.652 77.0608 205.573 77.0608C206.494 77.0608 207.377 76.6949 208.029 76.0435C208.68 75.3922 209.046 74.5087 209.046 73.5875C209.046 72.6663 208.68 71.7829 208.029 71.1315C207.377 70.4802 206.494 70.1142 205.573 70.1142C204.652 70.1142 203.768 70.4802 203.117 71.1315C202.465 71.7829 202.099 72.6663 202.099 73.5875ZM209.046 73.5875C209.046 74.5087 209.412 75.3922 210.063 76.0435C210.715 76.6949 211.598 77.0608 212.519 77.0608C213.44 77.0608 214.324 76.6949 214.975 76.0435C215.627 75.3922 215.993 74.5087 215.993 73.5875C215.993 72.6663 215.627 71.7829 214.975 71.1315C214.324 70.4802 213.44 70.1142 212.519 70.1142C211.598 70.1142 210.715 70.4802 210.063 71.1315C209.412 71.7829 209.046 72.6663 209.046 73.5875ZM215.993 73.5875C215.993 74.5087 216.359 75.3922 217.01 76.0435C217.661 76.6949 218.545 77.0608 219.466 77.0608C220.387 77.0608 221.271 76.6949 221.922 76.0435C222.573 75.3922 222.939 74.5087 222.939 73.5875C222.939 72.6663 222.573 71.7829 221.922 71.1315C221.271 70.4802 220.387 70.1142 219.466 70.1142C218.545 70.1142 217.661 70.4802 217.01 71.1315C216.359 71.7829 215.993 72.6663 215.993 73.5875ZM236.832 73.5875C236.832 74.5087 237.198 75.3922 237.85 76.0435C238.501 76.6949 239.384 77.0608 240.306 77.0608C241.227 77.0608 242.11 76.6949 242.762 76.0435C243.413 75.3922 243.779 74.5087 243.779 73.5875C243.779 72.6663 243.413 71.7829 242.762 71.1315C242.11 70.4802 241.227 70.1142 240.306 70.1142C239.384 70.1142 238.501 70.4802 237.85 71.1315C237.198 71.7829 236.832 72.6663 236.832 73.5875ZM243.779 73.5875C243.779 74.5087 244.145 75.3922 244.796 76.0435C245.448 76.6949 246.331 77.0608 247.252 77.0608C248.173 77.0608 249.057 76.6949 249.708 76.0435C250.36 75.3922 250.726 74.5087 250.726 73.5875C250.726 72.6663 250.36 71.7829 249.708 71.1315C249.057 70.4802 248.173 70.1142 247.252 70.1142C246.331 70.1142 245.448 70.4802 244.796 71.1315C244.145 71.7829 243.779 72.6663 243.779 73.5875ZM250.726 73.5875C250.726 74.5087 251.091 75.3922 251.743 76.0435C252.394 76.6949 253.278 77.0608 254.199 77.0608C255.12 77.0608 256.003 76.6949 256.655 76.0435C257.306 75.3922 257.672 74.5087 257.672 73.5875C257.672 72.6663 257.306 71.7829 256.655 71.1315C256.003 70.4802 255.12 70.1142 254.199 70.1142C253.278 70.1142 252.394 70.4802 251.743 71.1315C251.091 71.7829 250.726 72.6663 250.726 73.5875ZM257.672 73.5875C257.672 74.5087 258.038 75.3922 258.689 76.0435C259.341 76.6949 260.224 77.0608 261.145 77.0608C262.067 77.0608 262.95 76.6949 263.601 76.0435C264.253 75.3922 264.619 74.5087 264.619 73.5875C264.619 72.6663 264.253 71.7829 263.601 71.1315C262.95 70.4802 262.067 70.1142 261.145 70.1142C260.224 70.1142 259.341 70.4802 258.689 71.1315C258.038 71.7829 257.672 72.6663 257.672 73.5875ZM264.619 73.5875C264.619 74.5087 264.985 75.3922 265.636 76.0435C266.287 76.6949 267.171 77.0608 268.092 77.0608C269.013 77.0608 269.897 76.6949 270.548 76.0435C271.199 75.3922 271.565 74.5087 271.565 73.5875C271.565 72.6663 271.199 71.7829 270.548 71.1315C269.897 70.4802 269.013 70.1142 268.092 70.1142C267.171 70.1142 266.287 70.4802 265.636 71.1315C264.985 71.7829 264.619 72.6663 264.619 73.5875ZM278.512 73.5875C278.512 74.5087 278.878 75.3922 279.529 76.0435C280.181 76.6949 281.064 77.0608 281.985 77.0608C282.906 77.0608 283.79 76.6949 284.441 76.0435C285.093 75.3922 285.458 74.5087 285.458 73.5875C285.458 72.6663 285.093 71.7829 284.441 71.1315C283.79 70.4802 282.906 70.1142 281.985 70.1142C281.064 70.1142 280.181 70.4802 279.529 71.1315C278.878 71.7829 278.512 72.6663 278.512 73.5875ZM285.458 73.5875C285.458 74.5087 285.824 75.3922 286.476 76.0435C287.127 76.6949 288.011 77.0608 288.932 77.0608C289.853 77.0608 290.736 76.6949 291.388 76.0435C292.039 75.3922 292.405 74.5087 292.405 73.5875C292.405 72.6663 292.039 71.7829 291.388 71.1315C290.736 70.4802 289.853 70.1142 288.932 70.1142C288.011 70.1142 287.127 70.4802 286.476 71.1315C285.824 71.7829 285.458 72.6663 285.458 73.5875ZM7.59497 80.5341C7.59497 81.4553 7.96091 82.3387 8.61227 82.9901C9.26364 83.6415 10.1471 84.0074 11.0683 84.0074C11.9894 84.0074 12.8729 83.6415 13.5243 82.9901C14.1756 82.3387 14.5416 81.4553 14.5416 80.5341C14.5416 79.6129 14.1756 78.7295 13.5243 78.0781C12.8729 77.4268 11.9894 77.0608 11.0683 77.0608C10.1471 77.0608 9.26364 77.4268 8.61227 78.0781C7.96091 78.7295 7.59497 79.6129 7.59497 80.5341ZM21.4881 80.5341C21.4881 81.4553 21.8541 82.3387 22.5055 82.9901C23.1568 83.6415 24.0403 84.0074 24.9614 84.0074C25.8826 84.0074 26.7661 83.6415 27.4174 82.9901C28.0688 82.3387 28.4347 81.4553 28.4347 80.5341C28.4347 79.6129 28.0688 78.7295 27.4174 78.0781C26.7661 77.4268 25.8826 77.0608 24.9614 77.0608C24.0403 77.0608 23.1568 77.4268 22.5055 78.0781C21.8541 78.7295 21.4881 79.6129 21.4881 80.5341ZM28.4347 80.5341C28.4347 81.4553 28.8007 82.3387 29.452 82.9901C30.1034 83.6415 30.9869 84.0074 31.908 84.0074C32.8292 84.0074 33.7126 83.6415 34.364 82.9901C35.0154 82.3387 35.3813 81.4553 35.3813 80.5341C35.3813 79.6129 35.0154 78.7295 34.364 78.0781C33.7126 77.4268 32.8292 77.0608 31.908 77.0608C30.9869 77.0608 30.1034 77.4268 29.452 78.0781C28.8007 78.7295 28.4347 79.6129 28.4347 80.5341ZM35.3813 80.5341C35.3813 81.4553 35.7473 82.3387 36.3986 82.9901C37.05 83.6415 37.9334 84.0074 38.8546 84.0074C39.7758 84.0074 40.6592 83.6415 41.3106 82.9901C41.962 82.3387 42.3279 81.4553 42.3279 80.5341C42.3279 79.6129 41.962 78.7295 41.3106 78.0781C40.6592 77.4268 39.7758 77.0608 38.8546 77.0608C37.9334 77.0608 37.05 77.4268 36.3986 78.0781C35.7473 78.7295 35.3813 79.6129 35.3813 80.5341ZM49.2745 80.5341C49.2745 80.9902 49.3643 81.4419 49.5389 81.8633C49.7134 82.2847 49.9693 82.6676 50.2918 82.9901C50.6143 83.3126 50.9972 83.5685 51.4186 83.743C51.84 83.9176 52.2917 84.0074 52.7478 84.0074C53.2039 84.0074 53.6556 83.9176 54.077 83.743C54.4984 83.5685 54.8813 83.3126 55.2038 82.9901C55.5263 82.6676 55.7821 82.2847 55.9567 81.8633C56.1312 81.4419 56.2211 80.9902 56.2211 80.5341C56.2211 80.078 56.1312 79.6263 55.9567 79.2049C55.7821 78.7835 55.5263 78.4007 55.2038 78.0781C54.8813 77.7556 54.4984 77.4998 54.077 77.3252C53.6556 77.1507 53.2039 77.0608 52.7478 77.0608C52.2917 77.0608 51.84 77.1507 51.4186 77.3252C50.9972 77.4998 50.6143 77.7556 50.2918 78.0781C49.9693 78.4007 49.7134 78.7835 49.5389 79.2049C49.3643 79.6263 49.2745 80.078 49.2745 80.5341ZM56.2211 80.5341C56.2211 81.4553 56.587 82.3387 57.2384 82.9901C57.8898 83.6415 58.7732 84.0074 59.6944 84.0074C60.6156 84.0074 61.499 83.6415 62.1504 82.9901C62.8017 82.3387 63.1677 81.4553 63.1677 80.5341C63.1677 79.6129 62.8017 78.7295 62.1504 78.0781C61.499 77.4268 60.6156 77.0608 59.6944 77.0608C58.7732 77.0608 57.8898 77.4268 57.2384 78.0781C56.587 78.7295 56.2211 79.6129 56.2211 80.5341ZM63.1677 80.5341C63.1677 81.4553 63.5336 82.3387 64.185 82.9901C64.8363 83.6415 65.7198 84.0074 66.641 84.0074C67.5621 84.0074 68.4456 83.6415 69.097 82.9901C69.7483 82.3387 70.1143 81.4553 70.1143 80.5341C70.1143 79.6129 69.7483 78.7295 69.097 78.0781C68.4456 77.4268 67.5621 77.0608 66.641 77.0608C65.7198 77.0608 64.8363 77.4268 64.185 78.0781C63.5336 78.7295 63.1677 79.6129 63.1677 80.5341ZM70.1143 80.5341C70.1143 81.4553 70.4802 82.3387 71.1316 82.9901C71.7829 83.6415 72.6664 84.0074 73.5876 84.0074C74.5087 84.0074 75.3922 83.6415 76.0436 82.9901C76.6949 82.3387 77.0609 81.4553 77.0609 80.5341C77.0609 79.6129 76.6949 78.7295 76.0436 78.0781C75.3922 77.4268 74.5087 77.0608 73.5876 77.0608C72.6664 77.0608 71.7829 77.4268 71.1316 78.0781C70.4802 78.7295 70.1143 79.6129 70.1143 80.5341ZM77.0609 80.5341C77.0609 80.9902 77.1507 81.4419 77.3252 81.8633C77.4998 82.2847 77.7556 82.6676 78.0782 82.9901C78.4007 83.3126 78.7836 83.5685 79.205 83.743C79.6264 83.9176 80.078 84.0074 80.5341 84.0074C80.9903 84.0074 81.4419 83.9176 81.8633 83.743C82.2847 83.5685 82.6676 83.3126 82.9901 82.9901C83.3127 82.6676 83.5685 82.2847 83.743 81.8633C83.9176 81.4419 84.0074 80.9902 84.0074 80.5341C84.0074 80.078 83.9176 79.6263 83.743 79.2049C83.5685 78.7835 83.3127 78.4007 82.9901 78.0781C82.6676 77.7556 82.2847 77.4998 81.8633 77.3252C81.4419 77.1507 80.9903 77.0608 80.5341 77.0608C80.078 77.0608 79.6264 77.1507 79.205 77.3252C78.7836 77.4998 78.4007 77.7556 78.0782 78.0781C77.7556 78.4007 77.4998 78.7835 77.3252 79.2049C77.1507 79.6263 77.0609 80.078 77.0609 80.5341ZM84.0074 80.5341C84.0074 81.4553 84.3734 82.3387 85.0247 82.9901C85.6761 83.6415 86.5596 84.0074 87.4807 84.0074C88.4019 84.0074 89.2854 83.6415 89.9367 82.9901C90.5881 82.3387 90.954 81.4553 90.954 80.5341C90.954 79.6129 90.5881 78.7295 89.9367 78.0781C89.2854 77.4268 88.4019 77.0608 87.4807 77.0608C86.5596 77.0608 85.6761 77.4268 85.0247 78.0781C84.3734 78.7295 84.0074 79.6129 84.0074 80.5341ZM97.9006 80.5341C97.9006 80.9902 97.9905 81.4419 98.165 81.8633C98.3396 82.2847 98.5954 82.6676 98.9179 82.9901C99.2404 83.3126 99.6233 83.5685 100.045 83.743C100.466 83.9176 100.918 84.0074 101.374 84.0074C101.83 84.0074 102.282 83.9176 102.703 83.743C103.124 83.5685 103.507 83.3126 103.83 82.9901C104.152 82.6676 104.408 82.2847 104.583 81.8633C104.757 81.4419 104.847 80.9902 104.847 80.5341C104.847 80.078 104.757 79.6263 104.583 79.2049C104.408 78.7835 104.152 78.4007 103.83 78.0781C103.507 77.7556 103.124 77.4998 102.703 77.3252C102.282 77.1507 101.83 77.0608 101.374 77.0608C100.918 77.0608 100.466 77.1507 100.045 77.3252C99.6233 77.4998 99.2404 77.7556 98.9179 78.0781C98.5954 78.4007 98.3396 78.7835 98.165 79.2049C97.9905 79.6263 97.9006 80.078 97.9006 80.5341ZM111.794 80.5341C111.794 81.4553 112.16 82.3387 112.811 82.9901C113.462 83.6415 114.346 84.0074 115.267 84.0074C116.188 84.0074 117.072 83.6415 117.723 82.9901C118.374 82.3387 118.74 81.4553 118.74 80.5341C118.74 79.6129 118.374 78.7295 117.723 78.0781C117.072 77.4268 116.188 77.0608 115.267 77.0608C114.346 77.0608 113.462 77.4268 112.811 78.0781C112.16 78.7295 111.794 79.6129 111.794 80.5341ZM153.473 80.5341C153.473 80.9902 153.563 81.4419 153.738 81.8633C153.912 82.2847 154.168 82.6676 154.491 82.9901C154.813 83.3126 155.196 83.5685 155.617 83.743C156.039 83.9176 156.491 84.0074 156.947 84.0074C157.403 84.0074 157.854 83.9176 158.276 83.743C158.697 83.5685 159.08 83.3126 159.403 82.9901C159.725 82.6676 159.981 82.2847 160.156 81.8633C160.33 81.4419 160.42 80.9902 160.42 80.5341C160.42 80.078 160.33 79.6263 160.156 79.2049C159.981 78.7835 159.725 78.4007 159.403 78.0781C159.08 77.7556 158.697 77.4998 158.276 77.3252C157.854 77.1507 157.403 77.0608 156.947 77.0608C156.491 77.0608 156.039 77.1507 155.617 77.3252C155.196 77.4998 154.813 77.7556 154.491 78.0781C154.168 78.4007 153.912 78.7835 153.738 79.2049C153.563 79.6263 153.473 80.078 153.473 80.5341ZM160.42 80.5341C160.42 81.4553 160.786 82.3387 161.437 82.9901C162.089 83.6415 162.972 84.0074 163.893 84.0074C164.814 84.0074 165.698 83.6415 166.349 82.9901C167.001 82.3387 167.366 81.4553 167.366 80.5341C167.366 79.6129 167.001 78.7295 166.349 78.0781C165.698 77.4268 164.814 77.0608 163.893 77.0608C162.972 77.0608 162.089 77.4268 161.437 78.0781C160.786 78.7295 160.42 79.6129 160.42 80.5341ZM167.366 80.5341C167.366 81.4553 167.732 82.3387 168.384 82.9901C169.035 83.6415 169.919 84.0074 170.84 84.0074C171.761 84.0074 172.644 83.6415 173.296 82.9901C173.947 82.3387 174.313 81.4553 174.313 80.5341C174.313 79.6129 173.947 78.7295 173.296 78.0781C172.644 77.4268 171.761 77.0608 170.84 77.0608C169.919 77.0608 169.035 77.4268 168.384 78.0781C167.732 78.7295 167.366 79.6129 167.366 80.5341ZM188.206 80.5341C188.206 81.4553 188.572 82.3387 189.224 82.9901C189.875 83.6415 190.758 84.0074 191.68 84.0074C192.601 84.0074 193.484 83.6415 194.136 82.9901C194.787 82.3387 195.153 81.4553 195.153 80.5341C195.153 79.6129 194.787 78.7295 194.136 78.0781C193.484 77.4268 192.601 77.0608 191.68 77.0608C190.758 77.0608 189.875 77.4268 189.224 78.0781C188.572 78.7295 188.206 79.6129 188.206 80.5341ZM195.153 80.5341C195.153 80.9902 195.243 81.4419 195.417 81.8633C195.592 82.2847 195.848 82.6676 196.17 82.9901C196.493 83.3126 196.876 83.5685 197.297 83.743C197.718 83.9176 198.17 84.0074 198.626 84.0074C199.082 84.0074 199.534 83.9176 199.955 83.743C200.377 83.5685 200.76 83.3126 201.082 82.9901C201.405 82.6676 201.661 82.2847 201.835 81.8633C202.01 81.4419 202.099 80.9902 202.099 80.5341C202.099 80.078 202.01 79.6263 201.835 79.2049C201.661 78.7835 201.405 78.4007 201.082 78.0781C200.76 77.7556 200.377 77.4998 199.955 77.3252C199.534 77.1507 199.082 77.0608 198.626 77.0608C198.17 77.0608 197.718 77.1507 197.297 77.3252C196.876 77.4998 196.493 77.7556 196.17 78.0781C195.848 78.4007 195.592 78.7835 195.417 79.2049C195.243 79.6263 195.153 80.078 195.153 80.5341ZM215.993 80.5341C215.993 81.4553 216.359 82.3387 217.01 82.9901C217.661 83.6415 218.545 84.0074 219.466 84.0074C220.387 84.0074 221.271 83.6415 221.922 82.9901C222.573 82.3387 222.939 81.4553 222.939 80.5341C222.939 79.6129 222.573 78.7295 221.922 78.0781C221.271 77.4268 220.387 77.0608 219.466 77.0608C218.545 77.0608 217.661 77.4268 217.01 78.0781C216.359 78.7295 215.993 79.6129 215.993 80.5341ZM229.886 80.5341C229.886 81.4553 230.252 82.3387 230.903 82.9901C231.554 83.6415 232.438 84.0074 233.359 84.0074C234.28 84.0074 235.164 83.6415 235.815 82.9901C236.466 82.3387 236.832 81.4553 236.832 80.5341C236.832 79.6129 236.466 78.7295 235.815 78.0781C235.164 77.4268 234.28 77.0608 233.359 77.0608C232.438 77.0608 231.554 77.4268 230.903 78.0781C230.252 78.7295 229.886 79.6129 229.886 80.5341ZM250.726 80.5341C250.726 81.4553 251.091 82.3387 251.743 82.9901C252.394 83.6415 253.278 84.0074 254.199 84.0074C255.12 84.0074 256.003 83.6415 256.655 82.9901C257.306 82.3387 257.672 81.4553 257.672 80.5341C257.672 79.6129 257.306 78.7295 256.655 78.0781C256.003 77.4268 255.12 77.0608 254.199 77.0608C253.278 77.0608 252.394 77.4268 251.743 78.0781C251.091 78.7295 250.726 79.6129 250.726 80.5341ZM278.512 80.5341C278.512 81.4553 278.878 82.3387 279.529 82.9901C280.181 83.6415 281.064 84.0074 281.985 84.0074C282.906 84.0074 283.79 83.6415 284.441 82.9901C285.093 82.3387 285.458 81.4553 285.458 80.5341C285.458 79.6129 285.093 78.7295 284.441 78.0781C283.79 77.4268 282.906 77.0608 281.985 77.0608C281.064 77.0608 280.181 77.4268 279.529 78.0781C278.878 78.7295 278.512 79.6129 278.512 80.5341ZM285.458 80.5341C285.458 81.4553 285.824 82.3387 286.476 82.9901C287.127 83.6415 288.011 84.0074 288.932 84.0074C289.853 84.0074 290.736 83.6415 291.388 82.9901C292.039 82.3387 292.405 81.4553 292.405 80.5341C292.405 79.6129 292.039 78.7295 291.388 78.0781C290.736 77.4268 289.853 77.0608 288.932 77.0608C288.011 77.0608 287.127 77.4268 286.476 78.0781C285.824 78.7295 285.458 79.6129 285.458 80.5341ZM14.5416 87.4807C14.5416 88.4019 14.9075 89.2853 15.5589 89.9367C16.2102 90.5881 17.0937 90.954 18.0149 90.954C18.936 90.954 19.8195 90.5881 20.4708 89.9367C21.1222 89.2853 21.4881 88.4019 21.4881 87.4807C21.4881 86.5595 21.1222 85.6761 20.4708 85.0247C19.8195 84.3733 18.936 84.0074 18.0149 84.0074C17.0937 84.0074 16.2102 84.3733 15.5589 85.0247C14.9075 85.6761 14.5416 86.5595 14.5416 87.4807ZM63.1677 87.4807C63.1677 88.4019 63.5336 89.2853 64.185 89.9367C64.8363 90.5881 65.7198 90.954 66.641 90.954C67.5621 90.954 68.4456 90.5881 69.097 89.9367C69.7483 89.2853 70.1143 88.4019 70.1143 87.4807C70.1143 86.5595 69.7483 85.6761 69.097 85.0247C68.4456 84.3733 67.5621 84.0074 66.641 84.0074C65.7198 84.0074 64.8363 84.3733 64.185 85.0247C63.5336 85.6761 63.1677 86.5595 63.1677 87.4807ZM70.1143 87.4807C70.1143 88.4019 70.4802 89.2853 71.1316 89.9367C71.7829 90.5881 72.6664 90.954 73.5876 90.954C74.5087 90.954 75.3922 90.5881 76.0436 89.9367C76.6949 89.2853 77.0609 88.4019 77.0609 87.4807C77.0609 86.5595 76.6949 85.6761 76.0436 85.0247C75.3922 84.3733 74.5087 84.0074 73.5876 84.0074C72.6664 84.0074 71.7829 84.3733 71.1316 85.0247C70.4802 85.6761 70.1143 86.5595 70.1143 87.4807ZM77.0609 87.4807C77.0609 87.9368 77.1507 88.3885 77.3252 88.8099C77.4998 89.2313 77.7556 89.6142 78.0782 89.9367C78.4007 90.2592 78.7836 90.5151 79.205 90.6896C79.6264 90.8642 80.078 90.954 80.5341 90.954C80.9903 90.954 81.4419 90.8642 81.8633 90.6896C82.2847 90.5151 82.6676 90.2592 82.9901 89.9367C83.3127 89.6142 83.5685 89.2313 83.743 88.8099C83.9176 88.3885 84.0074 87.9368 84.0074 87.4807C84.0074 87.0246 83.9176 86.5729 83.743 86.1515C83.5685 85.7301 83.3127 85.3472 82.9901 85.0247C82.6676 84.7022 82.2847 84.4463 81.8633 84.2718C81.4419 84.0973 80.9903 84.0074 80.5341 84.0074C80.078 84.0074 79.6264 84.0973 79.205 84.2718C78.7836 84.4463 78.4007 84.7022 78.0782 85.0247C77.7556 85.3472 77.4998 85.7301 77.3252 86.1515C77.1507 86.5729 77.0609 87.0246 77.0609 87.4807ZM90.954 87.4807C90.954 88.4019 91.32 89.2853 91.9713 89.9367C92.6227 90.5881 93.5061 90.954 94.4273 90.954C95.3485 90.954 96.2319 90.5881 96.8833 89.9367C97.5347 89.2853 97.9006 88.4019 97.9006 87.4807C97.9006 86.5595 97.5347 85.6761 96.8833 85.0247C96.2319 84.3733 95.3485 84.0074 94.4273 84.0074C93.5061 84.0074 92.6227 84.3733 91.9713 85.0247C91.32 85.6761 90.954 86.5595 90.954 87.4807ZM104.847 87.4807C104.847 88.4019 105.213 89.2853 105.865 89.9367C106.516 90.5881 107.399 90.954 108.321 90.954C109.242 90.954 110.125 90.5881 110.776 89.9367C111.428 89.2853 111.794 88.4019 111.794 87.4807C111.794 86.5595 111.428 85.6761 110.776 85.0247C110.125 84.3733 109.242 84.0074 108.321 84.0074C107.399 84.0074 106.516 84.3733 105.865 85.0247C105.213 85.6761 104.847 86.5595 104.847 87.4807ZM118.74 87.4807C118.74 88.4019 119.106 89.2853 119.758 89.9367C120.409 90.5881 121.292 90.954 122.214 90.954C123.135 90.954 124.018 90.5881 124.67 89.9367C125.321 89.2853 125.687 88.4019 125.687 87.4807C125.687 86.5595 125.321 85.6761 124.67 85.0247C124.018 84.3733 123.135 84.0074 122.214 84.0074C121.292 84.0074 120.409 84.3733 119.758 85.0247C119.106 85.6761 118.74 86.5595 118.74 87.4807ZM153.473 87.4807C153.473 87.9368 153.563 88.3885 153.738 88.8099C153.912 89.2313 154.168 89.6142 154.491 89.9367C154.813 90.2592 155.196 90.5151 155.617 90.6896C156.039 90.8642 156.491 90.954 156.947 90.954C157.403 90.954 157.854 90.8642 158.276 90.6896C158.697 90.5151 159.08 90.2592 159.403 89.9367C159.725 89.6142 159.981 89.2313 160.156 88.8099C160.33 88.3885 160.42 87.9368 160.42 87.4807C160.42 87.0246 160.33 86.5729 160.156 86.1515C159.981 85.7301 159.725 85.3472 159.403 85.0247C159.08 84.7022 158.697 84.4463 158.276 84.2718C157.854 84.0973 157.403 84.0074 156.947 84.0074C156.491 84.0074 156.039 84.0973 155.617 84.2718C155.196 84.4463 154.813 84.7022 154.491 85.0247C154.168 85.3472 153.912 85.7301 153.738 86.1515C153.563 86.5729 153.473 87.0246 153.473 87.4807ZM167.366 87.4807C167.366 88.4019 167.732 89.2853 168.384 89.9367C169.035 90.5881 169.919 90.954 170.84 90.954C171.761 90.954 172.644 90.5881 173.296 89.9367C173.947 89.2853 174.313 88.4019 174.313 87.4807C174.313 86.5595 173.947 85.6761 173.296 85.0247C172.644 84.3733 171.761 84.0074 170.84 84.0074C169.919 84.0074 169.035 84.3733 168.384 85.0247C167.732 85.6761 167.366 86.5595 167.366 87.4807ZM174.313 87.4807C174.313 88.4019 174.679 89.2853 175.33 89.9367C175.982 90.5881 176.865 90.954 177.786 90.954C178.708 90.954 179.591 90.5881 180.242 89.9367C180.894 89.2853 181.26 88.4019 181.26 87.4807C181.26 86.5595 180.894 85.6761 180.242 85.0247C179.591 84.3733 178.708 84.0074 177.786 84.0074C176.865 84.0074 175.982 84.3733 175.33 85.0247C174.679 85.6761 174.313 86.5595 174.313 87.4807ZM209.046 87.4807C209.046 88.4019 209.412 89.2853 210.063 89.9367C210.715 90.5881 211.598 90.954 212.519 90.954C213.44 90.954 214.324 90.5881 214.975 89.9367C215.627 89.2853 215.993 88.4019 215.993 87.4807C215.993 86.5595 215.627 85.6761 214.975 85.0247C214.324 84.3733 213.44 84.0074 212.519 84.0074C211.598 84.0074 210.715 84.3733 210.063 85.0247C209.412 85.6761 209.046 86.5595 209.046 87.4807ZM222.939 87.4807C222.939 88.4019 223.305 89.2853 223.957 89.9367C224.608 90.5881 225.491 90.954 226.413 90.954C227.334 90.954 228.217 90.5881 228.868 89.9367C229.52 89.2853 229.886 88.4019 229.886 87.4807C229.886 86.5595 229.52 85.6761 228.868 85.0247C228.217 84.3733 227.334 84.0074 226.413 84.0074C225.491 84.0074 224.608 84.3733 223.957 85.0247C223.305 85.6761 222.939 86.5595 222.939 87.4807ZM229.886 87.4807C229.886 88.4019 230.252 89.2853 230.903 89.9367C231.554 90.5881 232.438 90.954 233.359 90.954C234.28 90.954 235.164 90.5881 235.815 89.9367C236.466 89.2853 236.832 88.4019 236.832 87.4807C236.832 86.5595 236.466 85.6761 235.815 85.0247C235.164 84.3733 234.28 84.0074 233.359 84.0074C232.438 84.0074 231.554 84.3733 230.903 85.0247C230.252 85.6761 229.886 86.5595 229.886 87.4807ZM236.832 87.4807C236.832 88.4019 237.198 89.2853 237.85 89.9367C238.501 90.5881 239.384 90.954 240.306 90.954C241.227 90.954 242.11 90.5881 242.762 89.9367C243.413 89.2853 243.779 88.4019 243.779 87.4807C243.779 86.5595 243.413 85.6761 242.762 85.0247C242.11 84.3733 241.227 84.0074 240.306 84.0074C239.384 84.0074 238.501 84.3733 237.85 85.0247C237.198 85.6761 236.832 86.5595 236.832 87.4807ZM250.726 87.4807C250.726 88.4019 251.091 89.2853 251.743 89.9367C252.394 90.5881 253.278 90.954 254.199 90.954C255.12 90.954 256.003 90.5881 256.655 89.9367C257.306 89.2853 257.672 88.4019 257.672 87.4807C257.672 86.5595 257.306 85.6761 256.655 85.0247C256.003 84.3733 255.12 84.0074 254.199 84.0074C253.278 84.0074 252.394 84.3733 251.743 85.0247C251.091 85.6761 250.726 86.5595 250.726 87.4807ZM257.672 87.4807C257.672 88.4019 258.038 89.2853 258.689 89.9367C259.341 90.5881 260.224 90.954 261.145 90.954C262.067 90.954 262.95 90.5881 263.601 89.9367C264.253 89.2853 264.619 88.4019 264.619 87.4807C264.619 86.5595 264.253 85.6761 263.601 85.0247C262.95 84.3733 262.067 84.0074 261.145 84.0074C260.224 84.0074 259.341 84.3733 258.689 85.0247C258.038 85.6761 257.672 86.5595 257.672 87.4807ZM264.619 87.4807C264.619 88.4019 264.985 89.2853 265.636 89.9367C266.287 90.5881 267.171 90.954 268.092 90.954C269.013 90.954 269.897 90.5881 270.548 89.9367C271.199 89.2853 271.565 88.4019 271.565 87.4807C271.565 86.5595 271.199 85.6761 270.548 85.0247C269.897 84.3733 269.013 84.0074 268.092 84.0074C267.171 84.0074 266.287 84.3733 265.636 85.0247C264.985 85.6761 264.619 86.5595 264.619 87.4807ZM278.512 87.4807C278.512 88.4019 278.878 89.2853 279.529 89.9367C280.181 90.5881 281.064 90.954 281.985 90.954C282.906 90.954 283.79 90.5881 284.441 89.9367C285.093 89.2853 285.458 88.4019 285.458 87.4807C285.458 86.5595 285.093 85.6761 284.441 85.0247C283.79 84.3733 282.906 84.0074 281.985 84.0074C281.064 84.0074 280.181 84.3733 279.529 85.0247C278.878 85.6761 278.512 86.5595 278.512 87.4807ZM7.59497 94.4273C7.59497 95.3485 7.96091 96.2319 8.61227 96.8833C9.26364 97.5347 10.1471 97.9006 11.0683 97.9006C11.9894 97.9006 12.8729 97.5347 13.5243 96.8833C14.1756 96.2319 14.5416 95.3485 14.5416 94.4273C14.5416 93.5061 14.1756 92.6227 13.5243 91.9713C12.8729 91.3199 11.9894 90.954 11.0683 90.954C10.1471 90.954 9.26364 91.3199 8.61227 91.9713C7.96091 92.6227 7.59497 93.5061 7.59497 94.4273ZM14.5416 94.4273C14.5416 95.3485 14.9075 96.2319 15.5589 96.8833C16.2102 97.5347 17.0937 97.9006 18.0149 97.9006C18.936 97.9006 19.8195 97.5347 20.4708 96.8833C21.1222 96.2319 21.4881 95.3485 21.4881 94.4273C21.4881 93.5061 21.1222 92.6227 20.4708 91.9713C19.8195 91.3199 18.936 90.954 18.0149 90.954C17.0937 90.954 16.2102 91.3199 15.5589 91.9713C14.9075 92.6227 14.5416 93.5061 14.5416 94.4273ZM21.4881 94.4273C21.4881 95.3485 21.8541 96.2319 22.5055 96.8833C23.1568 97.5347 24.0403 97.9006 24.9614 97.9006C25.8826 97.9006 26.7661 97.5347 27.4174 96.8833C28.0688 96.2319 28.4347 95.3485 28.4347 94.4273C28.4347 93.5061 28.0688 92.6227 27.4174 91.9713C26.7661 91.3199 25.8826 90.954 24.9614 90.954C24.0403 90.954 23.1568 91.3199 22.5055 91.9713C21.8541 92.6227 21.4881 93.5061 21.4881 94.4273ZM35.3813 94.4273C35.3813 95.3485 35.7473 96.2319 36.3986 96.8833C37.05 97.5347 37.9334 97.9006 38.8546 97.9006C39.7758 97.9006 40.6592 97.5347 41.3106 96.8833C41.962 96.2319 42.3279 95.3485 42.3279 94.4273C42.3279 93.5061 41.962 92.6227 41.3106 91.9713C40.6592 91.3199 39.7758 90.954 38.8546 90.954C37.9334 90.954 37.05 91.3199 36.3986 91.9713C35.7473 92.6227 35.3813 93.5061 35.3813 94.4273ZM49.2745 94.4273C49.2745 94.8834 49.3643 95.3351 49.5389 95.7565C49.7134 96.1779 49.9693 96.5608 50.2918 96.8833C50.6143 97.2058 50.9972 97.4616 51.4186 97.6362C51.84 97.8107 52.2917 97.9006 52.7478 97.9006C53.2039 97.9006 53.6556 97.8107 54.077 97.6362C54.4984 97.4616 54.8813 97.2058 55.2038 96.8833C55.5263 96.5608 55.7821 96.1779 55.9567 95.7565C56.1312 95.3351 56.2211 94.8834 56.2211 94.4273C56.2211 93.9712 56.1312 93.5195 55.9567 93.0981C55.7821 92.6767 55.5263 92.2938 55.2038 91.9713C54.8813 91.6488 54.4984 91.3929 54.077 91.2184C53.6556 91.0438 53.2039 90.954 52.7478 90.954C52.2917 90.954 51.84 91.0438 51.4186 91.2184C50.9972 91.3929 50.6143 91.6488 50.2918 91.9713C49.9693 92.2938 49.7134 92.6767 49.5389 93.0981C49.3643 93.5195 49.2745 93.9712 49.2745 94.4273ZM63.1677 94.4273C63.1677 95.3485 63.5336 96.2319 64.185 96.8833C64.8363 97.5347 65.7198 97.9006 66.641 97.9006C67.5621 97.9006 68.4456 97.5347 69.097 96.8833C69.7483 96.2319 70.1143 95.3485 70.1143 94.4273C70.1143 93.5061 69.7483 92.6227 69.097 91.9713C68.4456 91.3199 67.5621 90.954 66.641 90.954C65.7198 90.954 64.8363 91.3199 64.185 91.9713C63.5336 92.6227 63.1677 93.5061 63.1677 94.4273ZM77.0609 94.4273C77.0609 94.8834 77.1507 95.3351 77.3252 95.7565C77.4998 96.1779 77.7556 96.5608 78.0782 96.8833C78.4007 97.2058 78.7836 97.4616 79.205 97.6362C79.6264 97.8107 80.078 97.9006 80.5341 97.9006C80.9903 97.9006 81.4419 97.8107 81.8633 97.6362C82.2847 97.4616 82.6676 97.2058 82.9901 96.8833C83.3127 96.5608 83.5685 96.1779 83.743 95.7565C83.9176 95.3351 84.0074 94.8834 84.0074 94.4273C84.0074 93.9712 83.9176 93.5195 83.743 93.0981C83.5685 92.6767 83.3127 92.2938 82.9901 91.9713C82.6676 91.6488 82.2847 91.3929 81.8633 91.2184C81.4419 91.0438 80.9903 90.954 80.5341 90.954C80.078 90.954 79.6264 91.0438 79.205 91.2184C78.7836 91.3929 78.4007 91.6488 78.0782 91.9713C77.7556 92.2938 77.4998 92.6767 77.3252 93.0981C77.1507 93.5195 77.0609 93.9712 77.0609 94.4273ZM90.954 94.4273C90.954 95.3485 91.32 96.2319 91.9713 96.8833C92.6227 97.5347 93.5061 97.9006 94.4273 97.9006C95.3485 97.9006 96.2319 97.5347 96.8833 96.8833C97.5347 96.2319 97.9006 95.3485 97.9006 94.4273C97.9006 93.5061 97.5347 92.6227 96.8833 91.9713C96.2319 91.3199 95.3485 90.954 94.4273 90.954C93.5061 90.954 92.6227 91.3199 91.9713 91.9713C91.32 92.6227 90.954 93.5061 90.954 94.4273ZM111.794 94.4273C111.794 95.3485 112.16 96.2319 112.811 96.8833C113.462 97.5347 114.346 97.9006 115.267 97.9006C116.188 97.9006 117.072 97.5347 117.723 96.8833C118.374 96.2319 118.74 95.3485 118.74 94.4273C118.74 93.5061 118.374 92.6227 117.723 91.9713C117.072 91.3199 116.188 90.954 115.267 90.954C114.346 90.954 113.462 91.3199 112.811 91.9713C112.16 92.6227 111.794 93.5061 111.794 94.4273ZM118.74 94.4273C118.74 95.3485 119.106 96.2319 119.758 96.8833C120.409 97.5347 121.292 97.9006 122.214 97.9006C123.135 97.9006 124.018 97.5347 124.67 96.8833C125.321 96.2319 125.687 95.3485 125.687 94.4273C125.687 93.5061 125.321 92.6227 124.67 91.9713C124.018 91.3199 123.135 90.954 122.214 90.954C121.292 90.954 120.409 91.3199 119.758 91.9713C119.106 92.6227 118.74 93.5061 118.74 94.4273ZM139.58 94.4273C139.58 95.3485 139.946 96.2319 140.597 96.8833C141.249 97.5347 142.132 97.9006 143.053 97.9006C143.975 97.9006 144.858 97.5347 145.509 96.8833C146.161 96.2319 146.527 95.3485 146.527 94.4273C146.527 93.5061 146.161 92.6227 145.509 91.9713C144.858 91.3199 143.975 90.954 143.053 90.954C142.132 90.954 141.249 91.3199 140.597 91.9713C139.946 92.6227 139.58 93.5061 139.58 94.4273ZM146.527 94.4273C146.527 95.3485 146.893 96.2319 147.544 96.8833C148.195 97.5347 149.079 97.9006 150 97.9006C150.921 97.9006 151.805 97.5347 152.456 96.8833C153.107 96.2319 153.473 95.3485 153.473 94.4273C153.473 93.5061 153.107 92.6227 152.456 91.9713C151.805 91.3199 150.921 90.954 150 90.954C149.079 90.954 148.195 91.3199 147.544 91.9713C146.893 92.6227 146.527 93.5061 146.527 94.4273ZM153.473 94.4273C153.473 94.8834 153.563 95.3351 153.738 95.7565C153.912 96.1779 154.168 96.5608 154.491 96.8833C154.813 97.2058 155.196 97.4616 155.617 97.6362C156.039 97.8107 156.491 97.9006 156.947 97.9006C157.403 97.9006 157.854 97.8107 158.276 97.6362C158.697 97.4616 159.08 97.2058 159.403 96.8833C159.725 96.5608 159.981 96.1779 160.156 95.7565C160.33 95.3351 160.42 94.8834 160.42 94.4273C160.42 93.9712 160.33 93.5195 160.156 93.0981C159.981 92.6767 159.725 92.2938 159.403 91.9713C159.08 91.6488 158.697 91.3929 158.276 91.2184C157.854 91.0438 157.403 90.954 156.947 90.954C156.491 90.954 156.039 91.0438 155.617 91.2184C155.196 91.3929 154.813 91.6488 154.491 91.9713C154.168 92.2938 153.912 92.6767 153.738 93.0981C153.563 93.5195 153.473 93.9712 153.473 94.4273ZM167.366 94.4273C167.366 95.3485 167.732 96.2319 168.384 96.8833C169.035 97.5347 169.919 97.9006 170.84 97.9006C171.761 97.9006 172.644 97.5347 173.296 96.8833C173.947 96.2319 174.313 95.3485 174.313 94.4273C174.313 93.5061 173.947 92.6227 173.296 91.9713C172.644 91.3199 171.761 90.954 170.84 90.954C169.919 90.954 169.035 91.3199 168.384 91.9713C167.732 92.6227 167.366 93.5061 167.366 94.4273ZM174.313 94.4273C174.313 95.3485 174.679 96.2319 175.33 96.8833C175.982 97.5347 176.865 97.9006 177.786 97.9006C178.708 97.9006 179.591 97.5347 180.242 96.8833C180.894 96.2319 181.26 95.3485 181.26 94.4273C181.26 93.5061 180.894 92.6227 180.242 91.9713C179.591 91.3199 178.708 90.954 177.786 90.954C176.865 90.954 175.982 91.3199 175.33 91.9713C174.679 92.6227 174.313 93.5061 174.313 94.4273ZM181.26 94.4273C181.26 95.3485 181.626 96.2319 182.277 96.8833C182.928 97.5347 183.812 97.9006 184.733 97.9006C185.654 97.9006 186.538 97.5347 187.189 96.8833C187.84 96.2319 188.206 95.3485 188.206 94.4273C188.206 93.5061 187.84 92.6227 187.189 91.9713C186.538 91.3199 185.654 90.954 184.733 90.954C183.812 90.954 182.928 91.3199 182.277 91.9713C181.626 92.6227 181.26 93.5061 181.26 94.4273ZM188.206 94.4273C188.206 95.3485 188.572 96.2319 189.224 96.8833C189.875 97.5347 190.758 97.9006 191.68 97.9006C192.601 97.9006 193.484 97.5347 194.136 96.8833C194.787 96.2319 195.153 95.3485 195.153 94.4273C195.153 93.5061 194.787 92.6227 194.136 91.9713C193.484 91.3199 192.601 90.954 191.68 90.954C190.758 90.954 189.875 91.3199 189.224 91.9713C188.572 92.6227 188.206 93.5061 188.206 94.4273ZM209.046 94.4273C209.046 95.3485 209.412 96.2319 210.063 96.8833C210.715 97.5347 211.598 97.9006 212.519 97.9006C213.44 97.9006 214.324 97.5347 214.975 96.8833C215.627 96.2319 215.993 95.3485 215.993 94.4273C215.993 93.5061 215.627 92.6227 214.975 91.9713C214.324 91.3199 213.44 90.954 212.519 90.954C211.598 90.954 210.715 91.3199 210.063 91.9713C209.412 92.6227 209.046 93.5061 209.046 94.4273ZM236.832 94.4273C236.832 95.3485 237.198 96.2319 237.85 96.8833C238.501 97.5347 239.384 97.9006 240.306 97.9006C241.227 97.9006 242.11 97.5347 242.762 96.8833C243.413 96.2319 243.779 95.3485 243.779 94.4273C243.779 93.5061 243.413 92.6227 242.762 91.9713C242.11 91.3199 241.227 90.954 240.306 90.954C239.384 90.954 238.501 91.3199 237.85 91.9713C237.198 92.6227 236.832 93.5061 236.832 94.4273ZM243.779 94.4273C243.779 95.3485 244.145 96.2319 244.796 96.8833C245.448 97.5347 246.331 97.9006 247.252 97.9006C248.173 97.9006 249.057 97.5347 249.708 96.8833C250.36 96.2319 250.726 95.3485 250.726 94.4273C250.726 93.5061 250.36 92.6227 249.708 91.9713C249.057 91.3199 248.173 90.954 247.252 90.954C246.331 90.954 245.448 91.3199 244.796 91.9713C244.145 92.6227 243.779 93.5061 243.779 94.4273ZM278.512 94.4273C278.512 95.3485 278.878 96.2319 279.529 96.8833C280.181 97.5347 281.064 97.9006 281.985 97.9006C282.906 97.9006 283.79 97.5347 284.441 96.8833C285.093 96.2319 285.458 95.3485 285.458 94.4273C285.458 93.5061 285.093 92.6227 284.441 91.9713C283.79 91.3199 282.906 90.954 281.985 90.954C281.064 90.954 280.181 91.3199 279.529 91.9713C278.878 92.6227 278.512 93.5061 278.512 94.4273ZM7.59497 101.374C7.59497 102.295 7.96091 103.178 8.61227 103.83C9.26364 104.481 10.1471 104.847 11.0683 104.847C11.9894 104.847 12.8729 104.481 13.5243 103.83C14.1756 103.178 14.5416 102.295 14.5416 101.374C14.5416 100.453 14.1756 99.5693 13.5243 98.9179C12.8729 98.2665 11.9894 97.9006 11.0683 97.9006C10.1471 97.9006 9.26364 98.2665 8.61227 98.9179C7.96091 99.5693 7.59497 100.453 7.59497 101.374ZM14.5416 101.374C14.5416 102.295 14.9075 103.178 15.5589 103.83C16.2102 104.481 17.0937 104.847 18.0149 104.847C18.936 104.847 19.8195 104.481 20.4708 103.83C21.1222 103.178 21.4881 102.295 21.4881 101.374C21.4881 100.453 21.1222 99.5693 20.4708 98.9179C19.8195 98.2665 18.936 97.9006 18.0149 97.9006C17.0937 97.9006 16.2102 98.2665 15.5589 98.9179C14.9075 99.5693 14.5416 100.453 14.5416 101.374ZM28.4347 101.374C28.4347 102.295 28.8007 103.178 29.452 103.83C30.1034 104.481 30.9869 104.847 31.908 104.847C32.8292 104.847 33.7126 104.481 34.364 103.83C35.0154 103.178 35.3813 102.295 35.3813 101.374C35.3813 100.453 35.0154 99.5693 34.364 98.9179C33.7126 98.2665 32.8292 97.9006 31.908 97.9006C30.9869 97.9006 30.1034 98.2665 29.452 98.9179C28.8007 99.5693 28.4347 100.453 28.4347 101.374ZM35.3813 101.374C35.3813 102.295 35.7473 103.178 36.3986 103.83C37.05 104.481 37.9334 104.847 38.8546 104.847C39.7758 104.847 40.6592 104.481 41.3106 103.83C41.962 103.178 42.3279 102.295 42.3279 101.374C42.3279 100.453 41.962 99.5693 41.3106 98.9179C40.6592 98.2665 39.7758 97.9006 38.8546 97.9006C37.9334 97.9006 37.05 98.2665 36.3986 98.9179C35.7473 99.5693 35.3813 100.453 35.3813 101.374ZM56.2211 101.374C56.2211 102.295 56.587 103.178 57.2384 103.83C57.8898 104.481 58.7732 104.847 59.6944 104.847C60.6156 104.847 61.499 104.481 62.1504 103.83C62.8017 103.178 63.1677 102.295 63.1677 101.374C63.1677 100.453 62.8017 99.5693 62.1504 98.9179C61.499 98.2665 60.6156 97.9006 59.6944 97.9006C58.7732 97.9006 57.8898 98.2665 57.2384 98.9179C56.587 99.5693 56.2211 100.453 56.2211 101.374ZM70.1143 101.374C70.1143 102.295 70.4802 103.178 71.1316 103.83C71.7829 104.481 72.6664 104.847 73.5876 104.847C74.5087 104.847 75.3922 104.481 76.0436 103.83C76.6949 103.178 77.0609 102.295 77.0609 101.374C77.0609 100.453 76.6949 99.5693 76.0436 98.9179C75.3922 98.2665 74.5087 97.9006 73.5876 97.9006C72.6664 97.9006 71.7829 98.2665 71.1316 98.9179C70.4802 99.5693 70.1143 100.453 70.1143 101.374ZM77.0609 101.374C77.0609 101.83 77.1507 102.282 77.3252 102.703C77.4998 103.124 77.7556 103.507 78.0782 103.83C78.4007 104.152 78.7836 104.408 79.205 104.583C79.6264 104.757 80.078 104.847 80.5341 104.847C80.9903 104.847 81.4419 104.757 81.8633 104.583C82.2847 104.408 82.6676 104.152 82.9901 103.83C83.3127 103.507 83.5685 103.124 83.743 102.703C83.9176 102.282 84.0074 101.83 84.0074 101.374C84.0074 100.918 83.9176 100.466 83.743 100.045C83.5685 99.6233 83.3127 99.2404 82.9901 98.9179C82.6676 98.5954 82.2847 98.3395 81.8633 98.165C81.4419 97.9904 80.9903 97.9006 80.5341 97.9006C80.078 97.9006 79.6264 97.9904 79.205 98.165C78.7836 98.3395 78.4007 98.5954 78.0782 98.9179C77.7556 99.2404 77.4998 99.6233 77.3252 100.045C77.1507 100.466 77.0609 100.918 77.0609 101.374ZM97.9006 101.374C97.9006 101.83 97.9905 102.282 98.165 102.703C98.3396 103.124 98.5954 103.507 98.9179 103.83C99.2404 104.152 99.6233 104.408 100.045 104.583C100.466 104.757 100.918 104.847 101.374 104.847C101.83 104.847 102.282 104.757 102.703 104.583C103.124 104.408 103.507 104.152 103.83 103.83C104.152 103.507 104.408 103.124 104.583 102.703C104.757 102.282 104.847 101.83 104.847 101.374C104.847 100.918 104.757 100.466 104.583 100.045C104.408 99.6233 104.152 99.2404 103.83 98.9179C103.507 98.5954 103.124 98.3395 102.703 98.165C102.282 97.9904 101.83 97.9006 101.374 97.9006C100.918 97.9006 100.466 97.9904 100.045 98.165C99.6233 98.3395 99.2404 98.5954 98.9179 98.9179C98.5954 99.2404 98.3396 99.6233 98.165 100.045C97.9905 100.466 97.9006 100.918 97.9006 101.374ZM111.794 101.374C111.794 102.295 112.16 103.178 112.811 103.83C113.462 104.481 114.346 104.847 115.267 104.847C116.188 104.847 117.072 104.481 117.723 103.83C118.374 103.178 118.74 102.295 118.74 101.374C118.74 100.453 118.374 99.5693 117.723 98.9179C117.072 98.2665 116.188 97.9006 115.267 97.9006C114.346 97.9006 113.462 98.2665 112.811 98.9179C112.16 99.5693 111.794 100.453 111.794 101.374ZM118.74 101.374C118.74 102.295 119.106 103.178 119.758 103.83C120.409 104.481 121.292 104.847 122.214 104.847C123.135 104.847 124.018 104.481 124.67 103.83C125.321 103.178 125.687 102.295 125.687 101.374C125.687 100.453 125.321 99.5693 124.67 98.9179C124.018 98.2665 123.135 97.9006 122.214 97.9006C121.292 97.9006 120.409 98.2665 119.758 98.9179C119.106 99.5693 118.74 100.453 118.74 101.374ZM132.634 101.374C132.634 102.295 132.999 103.178 133.651 103.83C134.302 104.481 135.186 104.847 136.107 104.847C137.028 104.847 137.911 104.481 138.563 103.83C139.214 103.178 139.58 102.295 139.58 101.374C139.58 100.453 139.214 99.5693 138.563 98.9179C137.911 98.2665 137.028 97.9006 136.107 97.9006C135.186 97.9006 134.302 98.2665 133.651 98.9179C132.999 99.5693 132.634 100.453 132.634 101.374ZM146.527 101.374C146.527 102.295 146.893 103.178 147.544 103.83C148.195 104.481 149.079 104.847 150 104.847C150.921 104.847 151.805 104.481 152.456 103.83C153.107 103.178 153.473 102.295 153.473 101.374C153.473 100.453 153.107 99.5693 152.456 98.9179C151.805 98.2665 150.921 97.9006 150 97.9006C149.079 97.9006 148.195 98.2665 147.544 98.9179C146.893 99.5693 146.527 100.453 146.527 101.374ZM174.313 101.374C174.313 102.295 174.679 103.178 175.33 103.83C175.982 104.481 176.865 104.847 177.786 104.847C178.708 104.847 179.591 104.481 180.242 103.83C180.894 103.178 181.26 102.295 181.26 101.374C181.26 100.453 180.894 99.5693 180.242 98.9179C179.591 98.2665 178.708 97.9006 177.786 97.9006C176.865 97.9006 175.982 98.2665 175.33 98.9179C174.679 99.5693 174.313 100.453 174.313 101.374ZM202.099 101.374C202.099 102.295 202.465 103.178 203.117 103.83C203.768 104.481 204.652 104.847 205.573 104.847C206.494 104.847 207.377 104.481 208.029 103.83C208.68 103.178 209.046 102.295 209.046 101.374C209.046 100.453 208.68 99.5693 208.029 98.9179C207.377 98.2665 206.494 97.9006 205.573 97.9006C204.652 97.9006 203.768 98.2665 203.117 98.9179C202.465 99.5693 202.099 100.453 202.099 101.374ZM215.993 101.374C215.993 102.295 216.359 103.178 217.01 103.83C217.661 104.481 218.545 104.847 219.466 104.847C220.387 104.847 221.271 104.481 221.922 103.83C222.573 103.178 222.939 102.295 222.939 101.374C222.939 100.453 222.573 99.5693 221.922 98.9179C221.271 98.2665 220.387 97.9006 219.466 97.9006C218.545 97.9006 217.661 98.2665 217.01 98.9179C216.359 99.5693 215.993 100.453 215.993 101.374ZM222.939 101.374C222.939 102.295 223.305 103.178 223.957 103.83C224.608 104.481 225.491 104.847 226.413 104.847C227.334 104.847 228.217 104.481 228.868 103.83C229.52 103.178 229.886 102.295 229.886 101.374C229.886 100.453 229.52 99.5693 228.868 98.9179C228.217 98.2665 227.334 97.9006 226.413 97.9006C225.491 97.9006 224.608 98.2665 223.957 98.9179C223.305 99.5693 222.939 100.453 222.939 101.374ZM229.886 101.374C229.886 102.295 230.252 103.178 230.903 103.83C231.554 104.481 232.438 104.847 233.359 104.847C234.28 104.847 235.164 104.481 235.815 103.83C236.466 103.178 236.832 102.295 236.832 101.374C236.832 100.453 236.466 99.5693 235.815 98.9179C235.164 98.2665 234.28 97.9006 233.359 97.9006C232.438 97.9006 231.554 98.2665 230.903 98.9179C230.252 99.5693 229.886 100.453 229.886 101.374ZM250.726 101.374C250.726 102.295 251.091 103.178 251.743 103.83C252.394 104.481 253.278 104.847 254.199 104.847C255.12 104.847 256.003 104.481 256.655 103.83C257.306 103.178 257.672 102.295 257.672 101.374C257.672 100.453 257.306 99.5693 256.655 98.9179C256.003 98.2665 255.12 97.9006 254.199 97.9006C253.278 97.9006 252.394 98.2665 251.743 98.9179C251.091 99.5693 250.726 100.453 250.726 101.374ZM257.672 101.374C257.672 102.295 258.038 103.178 258.689 103.83C259.341 104.481 260.224 104.847 261.145 104.847C262.067 104.847 262.95 104.481 263.601 103.83C264.253 103.178 264.619 102.295 264.619 101.374C264.619 100.453 264.253 99.5693 263.601 98.9179C262.95 98.2665 262.067 97.9006 261.145 97.9006C260.224 97.9006 259.341 98.2665 258.689 98.9179C258.038 99.5693 257.672 100.453 257.672 101.374ZM271.565 101.374C271.565 102.295 271.931 103.178 272.583 103.83C273.234 104.481 274.117 104.847 275.039 104.847C275.96 104.847 276.843 104.481 277.495 103.83C278.146 103.178 278.512 102.295 278.512 101.374C278.512 100.453 278.146 99.5693 277.495 98.9179C276.843 98.2665 275.96 97.9006 275.039 97.9006C274.117 97.9006 273.234 98.2665 272.583 98.9179C271.931 99.5693 271.565 100.453 271.565 101.374ZM285.458 101.374C285.458 102.295 285.824 103.178 286.476 103.83C287.127 104.481 288.011 104.847 288.932 104.847C289.853 104.847 290.736 104.481 291.388 103.83C292.039 103.178 292.405 102.295 292.405 101.374C292.405 100.453 292.039 99.5693 291.388 98.9179C290.736 98.2665 289.853 97.9006 288.932 97.9006C288.011 97.9006 287.127 98.2665 286.476 98.9179C285.824 99.5693 285.458 100.453 285.458 101.374ZM7.59497 108.32C7.59497 109.242 7.96091 110.125 8.61227 110.776C9.26364 111.428 10.1471 111.794 11.0683 111.794C11.9894 111.794 12.8729 111.428 13.5243 110.776C14.1756 110.125 14.5416 109.242 14.5416 108.32C14.5416 107.399 14.1756 106.516 13.5243 105.864C12.8729 105.213 11.9894 104.847 11.0683 104.847C10.1471 104.847 9.26364 105.213 8.61227 105.864C7.96091 106.516 7.59497 107.399 7.59497 108.32ZM42.3279 108.32C42.3279 108.777 42.4177 109.228 42.5923 109.65C42.7668 110.071 43.0227 110.454 43.3452 110.776C43.6677 111.099 44.0506 111.355 44.472 111.529C44.8934 111.704 45.3451 111.794 45.8012 111.794C46.2573 111.794 46.709 111.704 47.1304 111.529C47.5518 111.355 47.9347 111.099 48.2572 110.776C48.5797 110.454 48.8356 110.071 49.0101 109.65C49.1847 109.228 49.2745 108.777 49.2745 108.32C49.2745 107.864 49.1847 107.413 49.0101 106.991C48.8356 106.57 48.5797 106.187 48.2572 105.864C47.9347 105.542 47.5518 105.286 47.1304 105.112C46.709 104.937 46.2573 104.847 45.8012 104.847C45.3451 104.847 44.8934 104.937 44.472 105.112C44.0506 105.286 43.6677 105.542 43.3452 105.864C43.0227 106.187 42.7668 106.57 42.5923 106.991C42.4177 107.413 42.3279 107.864 42.3279 108.32ZM49.2745 108.32C49.2745 108.777 49.3643 109.228 49.5389 109.65C49.7134 110.071 49.9693 110.454 50.2918 110.776C50.6143 111.099 50.9972 111.355 51.4186 111.529C51.84 111.704 52.2917 111.794 52.7478 111.794C53.2039 111.794 53.6556 111.704 54.077 111.529C54.4984 111.355 54.8813 111.099 55.2038 110.776C55.5263 110.454 55.7821 110.071 55.9567 109.65C56.1312 109.228 56.2211 108.777 56.2211 108.32C56.2211 107.864 56.1312 107.413 55.9567 106.991C55.7821 106.57 55.5263 106.187 55.2038 105.864C54.8813 105.542 54.4984 105.286 54.077 105.112C53.6556 104.937 53.2039 104.847 52.7478 104.847C52.2917 104.847 51.84 104.937 51.4186 105.112C50.9972 105.286 50.6143 105.542 50.2918 105.864C49.9693 106.187 49.7134 106.57 49.5389 106.991C49.3643 107.413 49.2745 107.864 49.2745 108.32ZM56.2211 108.32C56.2211 109.242 56.587 110.125 57.2384 110.776C57.8898 111.428 58.7732 111.794 59.6944 111.794C60.6156 111.794 61.499 111.428 62.1504 110.776C62.8017 110.125 63.1677 109.242 63.1677 108.32C63.1677 107.399 62.8017 106.516 62.1504 105.864C61.499 105.213 60.6156 104.847 59.6944 104.847C58.7732 104.847 57.8898 105.213 57.2384 105.864C56.587 106.516 56.2211 107.399 56.2211 108.32ZM77.0609 108.32C77.0609 108.777 77.1507 109.228 77.3252 109.65C77.4998 110.071 77.7556 110.454 78.0782 110.776C78.4007 111.099 78.7836 111.355 79.205 111.529C79.6264 111.704 80.078 111.794 80.5341 111.794C80.9903 111.794 81.4419 111.704 81.8633 111.529C82.2847 111.355 82.6676 111.099 82.9901 110.776C83.3127 110.454 83.5685 110.071 83.743 109.65C83.9176 109.228 84.0074 108.777 84.0074 108.32C84.0074 107.864 83.9176 107.413 83.743 106.991C83.5685 106.57 83.3127 106.187 82.9901 105.864C82.6676 105.542 82.2847 105.286 81.8633 105.112C81.4419 104.937 80.9903 104.847 80.5341 104.847C80.078 104.847 79.6264 104.937 79.205 105.112C78.7836 105.286 78.4007 105.542 78.0782 105.864C77.7556 106.187 77.4998 106.57 77.3252 106.991C77.1507 107.413 77.0609 107.864 77.0609 108.32ZM84.0074 108.32C84.0074 109.242 84.3734 110.125 85.0247 110.776C85.6761 111.428 86.5596 111.794 87.4807 111.794C88.4019 111.794 89.2854 111.428 89.9367 110.776C90.5881 110.125 90.954 109.242 90.954 108.32C90.954 107.399 90.5881 106.516 89.9367 105.864C89.2854 105.213 88.4019 104.847 87.4807 104.847C86.5596 104.847 85.6761 105.213 85.0247 105.864C84.3734 106.516 84.0074 107.399 84.0074 108.32ZM97.9006 108.32C97.9006 108.777 97.9905 109.228 98.165 109.65C98.3396 110.071 98.5954 110.454 98.9179 110.776C99.2404 111.099 99.6233 111.355 100.045 111.529C100.466 111.704 100.918 111.794 101.374 111.794C101.83 111.794 102.282 111.704 102.703 111.529C103.124 111.355 103.507 111.099 103.83 110.776C104.152 110.454 104.408 110.071 104.583 109.65C104.757 109.228 104.847 108.777 104.847 108.32C104.847 107.864 104.757 107.413 104.583 106.991C104.408 106.57 104.152 106.187 103.83 105.864C103.507 105.542 103.124 105.286 102.703 105.112C102.282 104.937 101.83 104.847 101.374 104.847C100.918 104.847 100.466 104.937 100.045 105.112C99.6233 105.286 99.2404 105.542 98.9179 105.864C98.5954 106.187 98.3396 106.57 98.165 106.991C97.9905 107.413 97.9006 107.864 97.9006 108.32ZM111.794 108.32C111.794 109.242 112.16 110.125 112.811 110.776C113.462 111.428 114.346 111.794 115.267 111.794C116.188 111.794 117.072 111.428 117.723 110.776C118.374 110.125 118.74 109.242 118.74 108.32C118.74 107.399 118.374 106.516 117.723 105.864C117.072 105.213 116.188 104.847 115.267 104.847C114.346 104.847 113.462 105.213 112.811 105.864C112.16 106.516 111.794 107.399 111.794 108.32ZM118.74 108.32C118.74 109.242 119.106 110.125 119.758 110.776C120.409 111.428 121.292 111.794 122.214 111.794C123.135 111.794 124.018 111.428 124.67 110.776C125.321 110.125 125.687 109.242 125.687 108.32C125.687 107.399 125.321 106.516 124.67 105.864C124.018 105.213 123.135 104.847 122.214 104.847C121.292 104.847 120.409 105.213 119.758 105.864C119.106 106.516 118.74 107.399 118.74 108.32ZM125.687 108.32C125.687 109.242 126.053 110.125 126.704 110.776C127.356 111.428 128.239 111.794 129.16 111.794C130.081 111.794 130.965 111.428 131.616 110.776C132.268 110.125 132.634 109.242 132.634 108.32C132.634 107.399 132.268 106.516 131.616 105.864C130.965 105.213 130.081 104.847 129.16 104.847C128.239 104.847 127.356 105.213 126.704 105.864C126.053 106.516 125.687 107.399 125.687 108.32ZM132.634 108.32C132.634 109.242 132.999 110.125 133.651 110.776C134.302 111.428 135.186 111.794 136.107 111.794C137.028 111.794 137.911 111.428 138.563 110.776C139.214 110.125 139.58 109.242 139.58 108.32C139.58 107.399 139.214 106.516 138.563 105.864C137.911 105.213 137.028 104.847 136.107 104.847C135.186 104.847 134.302 105.213 133.651 105.864C132.999 106.516 132.634 107.399 132.634 108.32ZM139.58 108.32C139.58 109.242 139.946 110.125 140.597 110.776C141.249 111.428 142.132 111.794 143.053 111.794C143.975 111.794 144.858 111.428 145.509 110.776C146.161 110.125 146.527 109.242 146.527 108.32C146.527 107.399 146.161 106.516 145.509 105.864C144.858 105.213 143.975 104.847 143.053 104.847C142.132 104.847 141.249 105.213 140.597 105.864C139.946 106.516 139.58 107.399 139.58 108.32ZM146.527 108.32C146.527 109.242 146.893 110.125 147.544 110.776C148.195 111.428 149.079 111.794 150 111.794C150.921 111.794 151.805 111.428 152.456 110.776C153.107 110.125 153.473 109.242 153.473 108.32C153.473 107.399 153.107 106.516 152.456 105.864C151.805 105.213 150.921 104.847 150 104.847C149.079 104.847 148.195 105.213 147.544 105.864C146.893 106.516 146.527 107.399 146.527 108.32ZM153.473 108.32C153.473 108.777 153.563 109.228 153.738 109.65C153.912 110.071 154.168 110.454 154.491 110.776C154.813 111.099 155.196 111.355 155.617 111.529C156.039 111.704 156.491 111.794 156.947 111.794C157.403 111.794 157.854 111.704 158.276 111.529C158.697 111.355 159.08 111.099 159.403 110.776C159.725 110.454 159.981 110.071 160.156 109.65C160.33 109.228 160.42 108.777 160.42 108.32C160.42 107.864 160.33 107.413 160.156 106.991C159.981 106.57 159.725 106.187 159.403 105.864C159.08 105.542 158.697 105.286 158.276 105.112C157.854 104.937 157.403 104.847 156.947 104.847C156.491 104.847 156.039 104.937 155.617 105.112C155.196 105.286 154.813 105.542 154.491 105.864C154.168 106.187 153.912 106.57 153.738 106.991C153.563 107.413 153.473 107.864 153.473 108.32ZM160.42 108.32C160.42 109.242 160.786 110.125 161.437 110.776C162.089 111.428 162.972 111.794 163.893 111.794C164.814 111.794 165.698 111.428 166.349 110.776C167.001 110.125 167.366 109.242 167.366 108.32C167.366 107.399 167.001 106.516 166.349 105.864C165.698 105.213 164.814 104.847 163.893 104.847C162.972 104.847 162.089 105.213 161.437 105.864C160.786 106.516 160.42 107.399 160.42 108.32ZM167.366 108.32C167.366 109.242 167.732 110.125 168.384 110.776C169.035 111.428 169.919 111.794 170.84 111.794C171.761 111.794 172.644 111.428 173.296 110.776C173.947 110.125 174.313 109.242 174.313 108.32C174.313 107.399 173.947 106.516 173.296 105.864C172.644 105.213 171.761 104.847 170.84 104.847C169.919 104.847 169.035 105.213 168.384 105.864C167.732 106.516 167.366 107.399 167.366 108.32ZM174.313 108.32C174.313 109.242 174.679 110.125 175.33 110.776C175.982 111.428 176.865 111.794 177.786 111.794C178.708 111.794 179.591 111.428 180.242 110.776C180.894 110.125 181.26 109.242 181.26 108.32C181.26 107.399 180.894 106.516 180.242 105.864C179.591 105.213 178.708 104.847 177.786 104.847C176.865 104.847 175.982 105.213 175.33 105.864C174.679 106.516 174.313 107.399 174.313 108.32ZM202.099 108.32C202.099 109.242 202.465 110.125 203.117 110.776C203.768 111.428 204.652 111.794 205.573 111.794C206.494 111.794 207.377 111.428 208.029 110.776C208.68 110.125 209.046 109.242 209.046 108.32C209.046 107.399 208.68 106.516 208.029 105.864C207.377 105.213 206.494 104.847 205.573 104.847C204.652 104.847 203.768 105.213 203.117 105.864C202.465 106.516 202.099 107.399 202.099 108.32ZM209.046 108.32C209.046 109.242 209.412 110.125 210.063 110.776C210.715 111.428 211.598 111.794 212.519 111.794C213.44 111.794 214.324 111.428 214.975 110.776C215.627 110.125 215.993 109.242 215.993 108.32C215.993 107.399 215.627 106.516 214.975 105.864C214.324 105.213 213.44 104.847 212.519 104.847C211.598 104.847 210.715 105.213 210.063 105.864C209.412 106.516 209.046 107.399 209.046 108.32ZM229.886 108.32C229.886 109.242 230.252 110.125 230.903 110.776C231.554 111.428 232.438 111.794 233.359 111.794C234.28 111.794 235.164 111.428 235.815 110.776C236.466 110.125 236.832 109.242 236.832 108.32C236.832 107.399 236.466 106.516 235.815 105.864C235.164 105.213 234.28 104.847 233.359 104.847C232.438 104.847 231.554 105.213 230.903 105.864C230.252 106.516 229.886 107.399 229.886 108.32ZM236.832 108.32C236.832 109.242 237.198 110.125 237.85 110.776C238.501 111.428 239.384 111.794 240.306 111.794C241.227 111.794 242.11 111.428 242.762 110.776C243.413 110.125 243.779 109.242 243.779 108.32C243.779 107.399 243.413 106.516 242.762 105.864C242.11 105.213 241.227 104.847 240.306 104.847C239.384 104.847 238.501 105.213 237.85 105.864C237.198 106.516 236.832 107.399 236.832 108.32ZM243.779 108.32C243.779 109.242 244.145 110.125 244.796 110.776C245.448 111.428 246.331 111.794 247.252 111.794C248.173 111.794 249.057 111.428 249.708 110.776C250.36 110.125 250.726 109.242 250.726 108.32C250.726 107.399 250.36 106.516 249.708 105.864C249.057 105.213 248.173 104.847 247.252 104.847C246.331 104.847 245.448 105.213 244.796 105.864C244.145 106.516 243.779 107.399 243.779 108.32ZM250.726 108.32C250.726 109.242 251.091 110.125 251.743 110.776C252.394 111.428 253.278 111.794 254.199 111.794C255.12 111.794 256.003 111.428 256.655 110.776C257.306 110.125 257.672 109.242 257.672 108.32C257.672 107.399 257.306 106.516 256.655 105.864C256.003 105.213 255.12 104.847 254.199 104.847C253.278 104.847 252.394 105.213 251.743 105.864C251.091 106.516 250.726 107.399 250.726 108.32ZM264.619 108.32C264.619 109.242 264.985 110.125 265.636 110.776C266.287 111.428 267.171 111.794 268.092 111.794C269.013 111.794 269.897 111.428 270.548 110.776C271.199 110.125 271.565 109.242 271.565 108.32C271.565 107.399 271.199 106.516 270.548 105.864C269.897 105.213 269.013 104.847 268.092 104.847C267.171 104.847 266.287 105.213 265.636 105.864C264.985 106.516 264.619 107.399 264.619 108.32ZM271.565 108.32C271.565 109.242 271.931 110.125 272.583 110.776C273.234 111.428 274.117 111.794 275.039 111.794C275.96 111.794 276.843 111.428 277.495 110.776C278.146 110.125 278.512 109.242 278.512 108.32C278.512 107.399 278.146 106.516 277.495 105.864C276.843 105.213 275.96 104.847 275.039 104.847C274.117 104.847 273.234 105.213 272.583 105.864C271.931 106.516 271.565 107.399 271.565 108.32ZM285.458 108.32C285.458 109.242 285.824 110.125 286.476 110.776C287.127 111.428 288.011 111.794 288.932 111.794C289.853 111.794 290.736 111.428 291.388 110.776C292.039 110.125 292.405 109.242 292.405 108.32C292.405 107.399 292.039 106.516 291.388 105.864C290.736 105.213 289.853 104.847 288.932 104.847C288.011 104.847 287.127 105.213 286.476 105.864C285.824 106.516 285.458 107.399 285.458 108.32ZM7.59497 115.267C7.59497 116.188 7.96091 117.072 8.61227 117.723C9.26364 118.374 10.1471 118.74 11.0683 118.74C11.9894 118.74 12.8729 118.374 13.5243 117.723C14.1756 117.072 14.5416 116.188 14.5416 115.267C14.5416 114.346 14.1756 113.462 13.5243 112.811C12.8729 112.16 11.9894 111.794 11.0683 111.794C10.1471 111.794 9.26364 112.16 8.61227 112.811C7.96091 113.462 7.59497 114.346 7.59497 115.267ZM14.5416 115.267C14.5416 116.188 14.9075 117.072 15.5589 117.723C16.2102 118.374 17.0937 118.74 18.0149 118.74C18.936 118.74 19.8195 118.374 20.4708 117.723C21.1222 117.072 21.4881 116.188 21.4881 115.267C21.4881 114.346 21.1222 113.462 20.4708 112.811C19.8195 112.16 18.936 111.794 18.0149 111.794C17.0937 111.794 16.2102 112.16 15.5589 112.811C14.9075 113.462 14.5416 114.346 14.5416 115.267ZM35.3813 115.267C35.3813 116.188 35.7473 117.072 36.3986 117.723C37.05 118.374 37.9334 118.74 38.8546 118.74C39.7758 118.74 40.6592 118.374 41.3106 117.723C41.962 117.072 42.3279 116.188 42.3279 115.267C42.3279 114.346 41.962 113.462 41.3106 112.811C40.6592 112.16 39.7758 111.794 38.8546 111.794C37.9334 111.794 37.05 112.16 36.3986 112.811C35.7473 113.462 35.3813 114.346 35.3813 115.267ZM42.3279 115.267C42.3279 115.723 42.4177 116.175 42.5923 116.596C42.7668 117.018 43.0227 117.401 43.3452 117.723C43.6677 118.046 44.0506 118.301 44.472 118.476C44.8934 118.651 45.3451 118.74 45.8012 118.74C46.2573 118.74 46.709 118.651 47.1304 118.476C47.5518 118.301 47.9347 118.046 48.2572 117.723C48.5797 117.401 48.8356 117.018 49.0101 116.596C49.1847 116.175 49.2745 115.723 49.2745 115.267C49.2745 114.811 49.1847 114.359 49.0101 113.938C48.8356 113.516 48.5797 113.134 48.2572 112.811C47.9347 112.489 47.5518 112.233 47.1304 112.058C46.709 111.884 46.2573 111.794 45.8012 111.794C45.3451 111.794 44.8934 111.884 44.472 112.058C44.0506 112.233 43.6677 112.489 43.3452 112.811C43.0227 113.134 42.7668 113.516 42.5923 113.938C42.4177 114.359 42.3279 114.811 42.3279 115.267ZM56.2211 115.267C56.2211 116.188 56.587 117.072 57.2384 117.723C57.8898 118.374 58.7732 118.74 59.6944 118.74C60.6156 118.74 61.499 118.374 62.1504 117.723C62.8017 117.072 63.1677 116.188 63.1677 115.267C63.1677 114.346 62.8017 113.462 62.1504 112.811C61.499 112.16 60.6156 111.794 59.6944 111.794C58.7732 111.794 57.8898 112.16 57.2384 112.811C56.587 113.462 56.2211 114.346 56.2211 115.267ZM84.0074 115.267C84.0074 116.188 84.3734 117.072 85.0247 117.723C85.6761 118.374 86.5596 118.74 87.4807 118.74C88.4019 118.74 89.2854 118.374 89.9367 117.723C90.5881 117.072 90.954 116.188 90.954 115.267C90.954 114.346 90.5881 113.462 89.9367 112.811C89.2854 112.16 88.4019 111.794 87.4807 111.794C86.5596 111.794 85.6761 112.16 85.0247 112.811C84.3734 113.462 84.0074 114.346 84.0074 115.267ZM111.794 115.267C111.794 116.188 112.16 117.072 112.811 117.723C113.462 118.374 114.346 118.74 115.267 118.74C116.188 118.74 117.072 118.374 117.723 117.723C118.374 117.072 118.74 116.188 118.74 115.267C118.74 114.346 118.374 113.462 117.723 112.811C117.072 112.16 116.188 111.794 115.267 111.794C114.346 111.794 113.462 112.16 112.811 112.811C112.16 113.462 111.794 114.346 111.794 115.267ZM125.687 115.267C125.687 116.188 126.053 117.072 126.704 117.723C127.356 118.374 128.239 118.74 129.16 118.74C130.081 118.74 130.965 118.374 131.616 117.723C132.268 117.072 132.634 116.188 132.634 115.267C132.634 114.346 132.268 113.462 131.616 112.811C130.965 112.16 130.081 111.794 129.16 111.794C128.239 111.794 127.356 112.16 126.704 112.811C126.053 113.462 125.687 114.346 125.687 115.267ZM132.634 115.267C132.634 116.188 132.999 117.072 133.651 117.723C134.302 118.374 135.186 118.74 136.107 118.74C137.028 118.74 137.911 118.374 138.563 117.723C139.214 117.072 139.58 116.188 139.58 115.267C139.58 114.346 139.214 113.462 138.563 112.811C137.911 112.16 137.028 111.794 136.107 111.794C135.186 111.794 134.302 112.16 133.651 112.811C132.999 113.462 132.634 114.346 132.634 115.267ZM153.473 115.267C153.473 115.723 153.563 116.175 153.738 116.596C153.912 117.018 154.168 117.401 154.491 117.723C154.813 118.046 155.196 118.301 155.617 118.476C156.039 118.651 156.491 118.74 156.947 118.74C157.403 118.74 157.854 118.651 158.276 118.476C158.697 118.301 159.08 118.046 159.403 117.723C159.725 117.401 159.981 117.018 160.156 116.596C160.33 116.175 160.42 115.723 160.42 115.267C160.42 114.811 160.33 114.359 160.156 113.938C159.981 113.516 159.725 113.134 159.403 112.811C159.08 112.489 158.697 112.233 158.276 112.058C157.854 111.884 157.403 111.794 156.947 111.794C156.491 111.794 156.039 111.884 155.617 112.058C155.196 112.233 154.813 112.489 154.491 112.811C154.168 113.134 153.912 113.516 153.738 113.938C153.563 114.359 153.473 114.811 153.473 115.267ZM160.42 115.267C160.42 116.188 160.786 117.072 161.437 117.723C162.089 118.374 162.972 118.74 163.893 118.74C164.814 118.74 165.698 118.374 166.349 117.723C167.001 117.072 167.366 116.188 167.366 115.267C167.366 114.346 167.001 113.462 166.349 112.811C165.698 112.16 164.814 111.794 163.893 111.794C162.972 111.794 162.089 112.16 161.437 112.811C160.786 113.462 160.42 114.346 160.42 115.267ZM181.26 115.267C181.26 116.188 181.626 117.072 182.277 117.723C182.928 118.374 183.812 118.74 184.733 118.74C185.654 118.74 186.538 118.374 187.189 117.723C187.84 117.072 188.206 116.188 188.206 115.267C188.206 114.346 187.84 113.462 187.189 112.811C186.538 112.16 185.654 111.794 184.733 111.794C183.812 111.794 182.928 112.16 182.277 112.811C181.626 113.462 181.26 114.346 181.26 115.267ZM188.206 115.267C188.206 116.188 188.572 117.072 189.224 117.723C189.875 118.374 190.758 118.74 191.68 118.74C192.601 118.74 193.484 118.374 194.136 117.723C194.787 117.072 195.153 116.188 195.153 115.267C195.153 114.346 194.787 113.462 194.136 112.811C193.484 112.16 192.601 111.794 191.68 111.794C190.758 111.794 189.875 112.16 189.224 112.811C188.572 113.462 188.206 114.346 188.206 115.267ZM209.046 115.267C209.046 116.188 209.412 117.072 210.063 117.723C210.715 118.374 211.598 118.74 212.519 118.74C213.44 118.74 214.324 118.374 214.975 117.723C215.627 117.072 215.993 116.188 215.993 115.267C215.993 114.346 215.627 113.462 214.975 112.811C214.324 112.16 213.44 111.794 212.519 111.794C211.598 111.794 210.715 112.16 210.063 112.811C209.412 113.462 209.046 114.346 209.046 115.267ZM215.993 115.267C215.993 116.188 216.359 117.072 217.01 117.723C217.661 118.374 218.545 118.74 219.466 118.74C220.387 118.74 221.271 118.374 221.922 117.723C222.573 117.072 222.939 116.188 222.939 115.267C222.939 114.346 222.573 113.462 221.922 112.811C221.271 112.16 220.387 111.794 219.466 111.794C218.545 111.794 217.661 112.16 217.01 112.811C216.359 113.462 215.993 114.346 215.993 115.267ZM257.672 115.267C257.672 116.188 258.038 117.072 258.689 117.723C259.341 118.374 260.224 118.74 261.145 118.74C262.067 118.74 262.95 118.374 263.601 117.723C264.253 117.072 264.619 116.188 264.619 115.267C264.619 114.346 264.253 113.462 263.601 112.811C262.95 112.16 262.067 111.794 261.145 111.794C260.224 111.794 259.341 112.16 258.689 112.811C258.038 113.462 257.672 114.346 257.672 115.267ZM264.619 115.267C264.619 116.188 264.985 117.072 265.636 117.723C266.287 118.374 267.171 118.74 268.092 118.74C269.013 118.74 269.897 118.374 270.548 117.723C271.199 117.072 271.565 116.188 271.565 115.267C271.565 114.346 271.199 113.462 270.548 112.811C269.897 112.16 269.013 111.794 268.092 111.794C267.171 111.794 266.287 112.16 265.636 112.811C264.985 113.462 264.619 114.346 264.619 115.267ZM278.512 115.267C278.512 116.188 278.878 117.072 279.529 117.723C280.181 118.374 281.064 118.74 281.985 118.74C282.906 118.74 283.79 118.374 284.441 117.723C285.093 117.072 285.458 116.188 285.458 115.267C285.458 114.346 285.093 113.462 284.441 112.811C283.79 112.16 282.906 111.794 281.985 111.794C281.064 111.794 280.181 112.16 279.529 112.811C278.878 113.462 278.512 114.346 278.512 115.267ZM7.59497 122.214C7.59497 123.135 7.96091 124.018 8.61227 124.67C9.26364 125.321 10.1471 125.687 11.0683 125.687C11.9894 125.687 12.8729 125.321 13.5243 124.67C14.1756 124.018 14.5416 123.135 14.5416 122.214C14.5416 121.292 14.1756 120.409 13.5243 119.758C12.8729 119.106 11.9894 118.74 11.0683 118.74C10.1471 118.74 9.26364 119.106 8.61227 119.758C7.96091 120.409 7.59497 121.292 7.59497 122.214ZM14.5416 122.214C14.5416 123.135 14.9075 124.018 15.5589 124.67C16.2102 125.321 17.0937 125.687 18.0149 125.687C18.936 125.687 19.8195 125.321 20.4708 124.67C21.1222 124.018 21.4881 123.135 21.4881 122.214C21.4881 121.292 21.1222 120.409 20.4708 119.758C19.8195 119.106 18.936 118.74 18.0149 118.74C17.0937 118.74 16.2102 119.106 15.5589 119.758C14.9075 120.409 14.5416 121.292 14.5416 122.214ZM28.4347 122.214C28.4347 123.135 28.8007 124.018 29.452 124.67C30.1034 125.321 30.9869 125.687 31.908 125.687C32.8292 125.687 33.7126 125.321 34.364 124.67C35.0154 124.018 35.3813 123.135 35.3813 122.214C35.3813 121.292 35.0154 120.409 34.364 119.758C33.7126 119.106 32.8292 118.74 31.908 118.74C30.9869 118.74 30.1034 119.106 29.452 119.758C28.8007 120.409 28.4347 121.292 28.4347 122.214ZM42.3279 122.214C42.3279 122.67 42.4177 123.121 42.5923 123.543C42.7668 123.964 43.0227 124.347 43.3452 124.67C43.6677 124.992 44.0506 125.248 44.472 125.423C44.8934 125.597 45.3451 125.687 45.8012 125.687C46.2573 125.687 46.709 125.597 47.1304 125.423C47.5518 125.248 47.9347 124.992 48.2572 124.67C48.5797 124.347 48.8356 123.964 49.0101 123.543C49.1847 123.121 49.2745 122.67 49.2745 122.214C49.2745 121.758 49.1847 121.306 49.0101 120.884C48.8356 120.463 48.5797 120.08 48.2572 119.758C47.9347 119.435 47.5518 119.179 47.1304 119.005C46.709 118.83 46.2573 118.74 45.8012 118.74C45.3451 118.74 44.8934 118.83 44.472 119.005C44.0506 119.179 43.6677 119.435 43.3452 119.758C43.0227 120.08 42.7668 120.463 42.5923 120.884C42.4177 121.306 42.3279 121.758 42.3279 122.214ZM49.2745 122.214C49.2745 122.67 49.3643 123.121 49.5389 123.543C49.7134 123.964 49.9693 124.347 50.2918 124.67C50.6143 124.992 50.9972 125.248 51.4186 125.423C51.84 125.597 52.2917 125.687 52.7478 125.687C53.2039 125.687 53.6556 125.597 54.077 125.423C54.4984 125.248 54.8813 124.992 55.2038 124.67C55.5263 124.347 55.7821 123.964 55.9567 123.543C56.1312 123.121 56.2211 122.67 56.2211 122.214C56.2211 121.758 56.1312 121.306 55.9567 120.884C55.7821 120.463 55.5263 120.08 55.2038 119.758C54.8813 119.435 54.4984 119.179 54.077 119.005C53.6556 118.83 53.2039 118.74 52.7478 118.74C52.2917 118.74 51.84 118.83 51.4186 119.005C50.9972 119.179 50.6143 119.435 50.2918 119.758C49.9693 120.08 49.7134 120.463 49.5389 120.884C49.3643 121.306 49.2745 121.758 49.2745 122.214ZM56.2211 122.214C56.2211 123.135 56.587 124.018 57.2384 124.67C57.8898 125.321 58.7732 125.687 59.6944 125.687C60.6156 125.687 61.499 125.321 62.1504 124.67C62.8017 124.018 63.1677 123.135 63.1677 122.214C63.1677 121.292 62.8017 120.409 62.1504 119.758C61.499 119.106 60.6156 118.74 59.6944 118.74C58.7732 118.74 57.8898 119.106 57.2384 119.758C56.587 120.409 56.2211 121.292 56.2211 122.214ZM63.1677 122.214C63.1677 123.135 63.5336 124.018 64.185 124.67C64.8363 125.321 65.7198 125.687 66.641 125.687C67.5621 125.687 68.4456 125.321 69.097 124.67C69.7483 124.018 70.1143 123.135 70.1143 122.214C70.1143 121.292 69.7483 120.409 69.097 119.758C68.4456 119.106 67.5621 118.74 66.641 118.74C65.7198 118.74 64.8363 119.106 64.185 119.758C63.5336 120.409 63.1677 121.292 63.1677 122.214ZM70.1143 122.214C70.1143 123.135 70.4802 124.018 71.1316 124.67C71.7829 125.321 72.6664 125.687 73.5876 125.687C74.5087 125.687 75.3922 125.321 76.0436 124.67C76.6949 124.018 77.0609 123.135 77.0609 122.214C77.0609 121.292 76.6949 120.409 76.0436 119.758C75.3922 119.106 74.5087 118.74 73.5876 118.74C72.6664 118.74 71.7829 119.106 71.1316 119.758C70.4802 120.409 70.1143 121.292 70.1143 122.214ZM77.0609 122.214C77.0609 122.67 77.1507 123.121 77.3252 123.543C77.4998 123.964 77.7556 124.347 78.0782 124.67C78.4007 124.992 78.7836 125.248 79.205 125.423C79.6264 125.597 80.078 125.687 80.5341 125.687C80.9903 125.687 81.4419 125.597 81.8633 125.423C82.2847 125.248 82.6676 124.992 82.9901 124.67C83.3127 124.347 83.5685 123.964 83.743 123.543C83.9176 123.121 84.0074 122.67 84.0074 122.214C84.0074 121.758 83.9176 121.306 83.743 120.884C83.5685 120.463 83.3127 120.08 82.9901 119.758C82.6676 119.435 82.2847 119.179 81.8633 119.005C81.4419 118.83 80.9903 118.74 80.5341 118.74C80.078 118.74 79.6264 118.83 79.205 119.005C78.7836 119.179 78.4007 119.435 78.0782 119.758C77.7556 120.08 77.4998 120.463 77.3252 120.884C77.1507 121.306 77.0609 121.758 77.0609 122.214ZM84.0074 122.214C84.0074 123.135 84.3734 124.018 85.0247 124.67C85.6761 125.321 86.5596 125.687 87.4807 125.687C88.4019 125.687 89.2854 125.321 89.9367 124.67C90.5881 124.018 90.954 123.135 90.954 122.214C90.954 121.292 90.5881 120.409 89.9367 119.758C89.2854 119.106 88.4019 118.74 87.4807 118.74C86.5596 118.74 85.6761 119.106 85.0247 119.758C84.3734 120.409 84.0074 121.292 84.0074 122.214ZM97.9006 122.214C97.9006 122.67 97.9905 123.121 98.165 123.543C98.3396 123.964 98.5954 124.347 98.9179 124.67C99.2404 124.992 99.6233 125.248 100.045 125.423C100.466 125.597 100.918 125.687 101.374 125.687C101.83 125.687 102.282 125.597 102.703 125.423C103.124 125.248 103.507 124.992 103.83 124.67C104.152 124.347 104.408 123.964 104.583 123.543C104.757 123.121 104.847 122.67 104.847 122.214C104.847 121.758 104.757 121.306 104.583 120.884C104.408 120.463 104.152 120.08 103.83 119.758C103.507 119.435 103.124 119.179 102.703 119.005C102.282 118.83 101.83 118.74 101.374 118.74C100.918 118.74 100.466 118.83 100.045 119.005C99.6233 119.179 99.2404 119.435 98.9179 119.758C98.5954 120.08 98.3396 120.463 98.165 120.884C97.9905 121.306 97.9006 121.758 97.9006 122.214ZM111.794 122.214C111.794 123.135 112.16 124.018 112.811 124.67C113.462 125.321 114.346 125.687 115.267 125.687C116.188 125.687 117.072 125.321 117.723 124.67C118.374 124.018 118.74 123.135 118.74 122.214C118.74 121.292 118.374 120.409 117.723 119.758C117.072 119.106 116.188 118.74 115.267 118.74C114.346 118.74 113.462 119.106 112.811 119.758C112.16 120.409 111.794 121.292 111.794 122.214ZM125.687 122.214C125.687 123.135 126.053 124.018 126.704 124.67C127.356 125.321 128.239 125.687 129.16 125.687C130.081 125.687 130.965 125.321 131.616 124.67C132.268 124.018 132.634 123.135 132.634 122.214C132.634 121.292 132.268 120.409 131.616 119.758C130.965 119.106 130.081 118.74 129.16 118.74C128.239 118.74 127.356 119.106 126.704 119.758C126.053 120.409 125.687 121.292 125.687 122.214ZM146.527 122.214C146.527 123.135 146.893 124.018 147.544 124.67C148.195 125.321 149.079 125.687 150 125.687C150.921 125.687 151.805 125.321 152.456 124.67C153.107 124.018 153.473 123.135 153.473 122.214C153.473 121.292 153.107 120.409 152.456 119.758C151.805 119.106 150.921 118.74 150 118.74C149.079 118.74 148.195 119.106 147.544 119.758C146.893 120.409 146.527 121.292 146.527 122.214ZM153.473 122.214C153.473 122.67 153.563 123.121 153.738 123.543C153.912 123.964 154.168 124.347 154.491 124.67C154.813 124.992 155.196 125.248 155.617 125.423C156.039 125.597 156.491 125.687 156.947 125.687C157.403 125.687 157.854 125.597 158.276 125.423C158.697 125.248 159.08 124.992 159.403 124.67C159.725 124.347 159.981 123.964 160.156 123.543C160.33 123.121 160.42 122.67 160.42 122.214C160.42 121.758 160.33 121.306 160.156 120.884C159.981 120.463 159.725 120.08 159.403 119.758C159.08 119.435 158.697 119.179 158.276 119.005C157.854 118.83 157.403 118.74 156.947 118.74C156.491 118.74 156.039 118.83 155.617 119.005C155.196 119.179 154.813 119.435 154.491 119.758C154.168 120.08 153.912 120.463 153.738 120.884C153.563 121.306 153.473 121.758 153.473 122.214ZM160.42 122.214C160.42 123.135 160.786 124.018 161.437 124.67C162.089 125.321 162.972 125.687 163.893 125.687C164.814 125.687 165.698 125.321 166.349 124.67C167.001 124.018 167.366 123.135 167.366 122.214C167.366 121.292 167.001 120.409 166.349 119.758C165.698 119.106 164.814 118.74 163.893 118.74C162.972 118.74 162.089 119.106 161.437 119.758C160.786 120.409 160.42 121.292 160.42 122.214ZM188.206 122.214C188.206 123.135 188.572 124.018 189.224 124.67C189.875 125.321 190.758 125.687 191.68 125.687C192.601 125.687 193.484 125.321 194.136 124.67C194.787 124.018 195.153 123.135 195.153 122.214C195.153 121.292 194.787 120.409 194.136 119.758C193.484 119.106 192.601 118.74 191.68 118.74C190.758 118.74 189.875 119.106 189.224 119.758C188.572 120.409 188.206 121.292 188.206 122.214ZM195.153 122.214C195.153 122.67 195.243 123.121 195.417 123.543C195.592 123.964 195.848 124.347 196.17 124.67C196.493 124.992 196.876 125.248 197.297 125.423C197.718 125.597 198.17 125.687 198.626 125.687C199.082 125.687 199.534 125.597 199.955 125.423C200.377 125.248 200.76 124.992 201.082 124.67C201.405 124.347 201.661 123.964 201.835 123.543C202.01 123.121 202.099 122.67 202.099 122.214C202.099 121.758 202.01 121.306 201.835 120.884C201.661 120.463 201.405 120.08 201.082 119.758C200.76 119.435 200.377 119.179 199.955 119.005C199.534 118.83 199.082 118.74 198.626 118.74C198.17 118.74 197.718 118.83 197.297 119.005C196.876 119.179 196.493 119.435 196.17 119.758C195.848 120.08 195.592 120.463 195.417 120.884C195.243 121.306 195.153 121.758 195.153 122.214ZM209.046 122.214C209.046 123.135 209.412 124.018 210.063 124.67C210.715 125.321 211.598 125.687 212.519 125.687C213.44 125.687 214.324 125.321 214.975 124.67C215.627 124.018 215.993 123.135 215.993 122.214C215.993 121.292 215.627 120.409 214.975 119.758C214.324 119.106 213.44 118.74 212.519 118.74C211.598 118.74 210.715 119.106 210.063 119.758C209.412 120.409 209.046 121.292 209.046 122.214ZM222.939 122.214C222.939 123.135 223.305 124.018 223.957 124.67C224.608 125.321 225.491 125.687 226.413 125.687C227.334 125.687 228.217 125.321 228.868 124.67C229.52 124.018 229.886 123.135 229.886 122.214C229.886 121.292 229.52 120.409 228.868 119.758C228.217 119.106 227.334 118.74 226.413 118.74C225.491 118.74 224.608 119.106 223.957 119.758C223.305 120.409 222.939 121.292 222.939 122.214ZM229.886 122.214C229.886 123.135 230.252 124.018 230.903 124.67C231.554 125.321 232.438 125.687 233.359 125.687C234.28 125.687 235.164 125.321 235.815 124.67C236.466 124.018 236.832 123.135 236.832 122.214C236.832 121.292 236.466 120.409 235.815 119.758C235.164 119.106 234.28 118.74 233.359 118.74C232.438 118.74 231.554 119.106 230.903 119.758C230.252 120.409 229.886 121.292 229.886 122.214ZM250.726 122.214C250.726 123.135 251.091 124.018 251.743 124.67C252.394 125.321 253.278 125.687 254.199 125.687C255.12 125.687 256.003 125.321 256.655 124.67C257.306 124.018 257.672 123.135 257.672 122.214C257.672 121.292 257.306 120.409 256.655 119.758C256.003 119.106 255.12 118.74 254.199 118.74C253.278 118.74 252.394 119.106 251.743 119.758C251.091 120.409 250.726 121.292 250.726 122.214ZM264.619 122.214C264.619 123.135 264.985 124.018 265.636 124.67C266.287 125.321 267.171 125.687 268.092 125.687C269.013 125.687 269.897 125.321 270.548 124.67C271.199 124.018 271.565 123.135 271.565 122.214C271.565 121.292 271.199 120.409 270.548 119.758C269.897 119.106 269.013 118.74 268.092 118.74C267.171 118.74 266.287 119.106 265.636 119.758C264.985 120.409 264.619 121.292 264.619 122.214ZM278.512 122.214C278.512 123.135 278.878 124.018 279.529 124.67C280.181 125.321 281.064 125.687 281.985 125.687C282.906 125.687 283.79 125.321 284.441 124.67C285.093 124.018 285.458 123.135 285.458 122.214C285.458 121.292 285.093 120.409 284.441 119.758C283.79 119.106 282.906 118.74 281.985 118.74C281.064 118.74 280.181 119.106 279.529 119.758C278.878 120.409 278.512 121.292 278.512 122.214ZM285.458 122.214C285.458 123.135 285.824 124.018 286.476 124.67C287.127 125.321 288.011 125.687 288.932 125.687C289.853 125.687 290.736 125.321 291.388 124.67C292.039 124.018 292.405 123.135 292.405 122.214C292.405 121.292 292.039 120.409 291.388 119.758C290.736 119.106 289.853 118.74 288.932 118.74C288.011 118.74 287.127 119.106 286.476 119.758C285.824 120.409 285.458 121.292 285.458 122.214ZM7.59497 129.16C7.59497 130.081 7.96091 130.965 8.61227 131.616C9.26364 132.268 10.1471 132.634 11.0683 132.634C11.9894 132.634 12.8729 132.268 13.5243 131.616C14.1756 130.965 14.5416 130.081 14.5416 129.16C14.5416 128.239 14.1756 127.356 13.5243 126.704C12.8729 126.053 11.9894 125.687 11.0683 125.687C10.1471 125.687 9.26364 126.053 8.61227 126.704C7.96091 127.356 7.59497 128.239 7.59497 129.16ZM21.4881 129.16C21.4881 130.081 21.8541 130.965 22.5055 131.616C23.1568 132.268 24.0403 132.634 24.9614 132.634C25.8826 132.634 26.7661 132.268 27.4174 131.616C28.0688 130.965 28.4347 130.081 28.4347 129.16C28.4347 128.239 28.0688 127.356 27.4174 126.704C26.7661 126.053 25.8826 125.687 24.9614 125.687C24.0403 125.687 23.1568 126.053 22.5055 126.704C21.8541 127.356 21.4881 128.239 21.4881 129.16ZM28.4347 129.16C28.4347 130.081 28.8007 130.965 29.452 131.616C30.1034 132.268 30.9869 132.634 31.908 132.634C32.8292 132.634 33.7126 132.268 34.364 131.616C35.0154 130.965 35.3813 130.081 35.3813 129.16C35.3813 128.239 35.0154 127.356 34.364 126.704C33.7126 126.053 32.8292 125.687 31.908 125.687C30.9869 125.687 30.1034 126.053 29.452 126.704C28.8007 127.356 28.4347 128.239 28.4347 129.16ZM35.3813 129.16C35.3813 130.081 35.7473 130.965 36.3986 131.616C37.05 132.268 37.9334 132.634 38.8546 132.634C39.7758 132.634 40.6592 132.268 41.3106 131.616C41.962 130.965 42.3279 130.081 42.3279 129.16C42.3279 128.239 41.962 127.356 41.3106 126.704C40.6592 126.053 39.7758 125.687 38.8546 125.687C37.9334 125.687 37.05 126.053 36.3986 126.704C35.7473 127.356 35.3813 128.239 35.3813 129.16ZM70.1143 129.16C70.1143 130.081 70.4802 130.965 71.1316 131.616C71.7829 132.268 72.6664 132.634 73.5876 132.634C74.5087 132.634 75.3922 132.268 76.0436 131.616C76.6949 130.965 77.0609 130.081 77.0609 129.16C77.0609 128.239 76.6949 127.356 76.0436 126.704C75.3922 126.053 74.5087 125.687 73.5876 125.687C72.6664 125.687 71.7829 126.053 71.1316 126.704C70.4802 127.356 70.1143 128.239 70.1143 129.16ZM84.0074 129.16C84.0074 130.081 84.3734 130.965 85.0247 131.616C85.6761 132.268 86.5596 132.634 87.4807 132.634C88.4019 132.634 89.2854 132.268 89.9367 131.616C90.5881 130.965 90.954 130.081 90.954 129.16C90.954 128.239 90.5881 127.356 89.9367 126.704C89.2854 126.053 88.4019 125.687 87.4807 125.687C86.5596 125.687 85.6761 126.053 85.0247 126.704C84.3734 127.356 84.0074 128.239 84.0074 129.16ZM97.9006 129.16C97.9006 129.616 97.9905 130.068 98.165 130.489C98.3396 130.911 98.5954 131.294 98.9179 131.616C99.2404 131.939 99.6233 132.195 100.045 132.369C100.466 132.544 100.918 132.634 101.374 132.634C101.83 132.634 102.282 132.544 102.703 132.369C103.124 132.195 103.507 131.939 103.83 131.616C104.152 131.294 104.408 130.911 104.583 130.489C104.757 130.068 104.847 129.616 104.847 129.16C104.847 128.704 104.757 128.252 104.583 127.831C104.408 127.41 104.152 127.027 103.83 126.704C103.507 126.382 103.124 126.126 102.703 125.951C102.282 125.777 101.83 125.687 101.374 125.687C100.918 125.687 100.466 125.777 100.045 125.951C99.6233 126.126 99.2404 126.382 98.9179 126.704C98.5954 127.027 98.3396 127.41 98.165 127.831C97.9905 128.252 97.9006 128.704 97.9006 129.16ZM104.847 129.16C104.847 130.081 105.213 130.965 105.865 131.616C106.516 132.268 107.399 132.634 108.321 132.634C109.242 132.634 110.125 132.268 110.776 131.616C111.428 130.965 111.794 130.081 111.794 129.16C111.794 128.239 111.428 127.356 110.776 126.704C110.125 126.053 109.242 125.687 108.321 125.687C107.399 125.687 106.516 126.053 105.865 126.704C105.213 127.356 104.847 128.239 104.847 129.16ZM111.794 129.16C111.794 130.081 112.16 130.965 112.811 131.616C113.462 132.268 114.346 132.634 115.267 132.634C116.188 132.634 117.072 132.268 117.723 131.616C118.374 130.965 118.74 130.081 118.74 129.16C118.74 128.239 118.374 127.356 117.723 126.704C117.072 126.053 116.188 125.687 115.267 125.687C114.346 125.687 113.462 126.053 112.811 126.704C112.16 127.356 111.794 128.239 111.794 129.16ZM118.74 129.16C118.74 130.081 119.106 130.965 119.758 131.616C120.409 132.268 121.292 132.634 122.214 132.634C123.135 132.634 124.018 132.268 124.67 131.616C125.321 130.965 125.687 130.081 125.687 129.16C125.687 128.239 125.321 127.356 124.67 126.704C124.018 126.053 123.135 125.687 122.214 125.687C121.292 125.687 120.409 126.053 119.758 126.704C119.106 127.356 118.74 128.239 118.74 129.16ZM167.366 129.16C167.366 130.081 167.732 130.965 168.384 131.616C169.035 132.268 169.919 132.634 170.84 132.634C171.761 132.634 172.644 132.268 173.296 131.616C173.947 130.965 174.313 130.081 174.313 129.16C174.313 128.239 173.947 127.356 173.296 126.704C172.644 126.053 171.761 125.687 170.84 125.687C169.919 125.687 169.035 126.053 168.384 126.704C167.732 127.356 167.366 128.239 167.366 129.16ZM181.26 129.16C181.26 130.081 181.626 130.965 182.277 131.616C182.928 132.268 183.812 132.634 184.733 132.634C185.654 132.634 186.538 132.268 187.189 131.616C187.84 130.965 188.206 130.081 188.206 129.16C188.206 128.239 187.84 127.356 187.189 126.704C186.538 126.053 185.654 125.687 184.733 125.687C183.812 125.687 182.928 126.053 182.277 126.704C181.626 127.356 181.26 128.239 181.26 129.16ZM195.153 129.16C195.153 129.616 195.243 130.068 195.417 130.489C195.592 130.911 195.848 131.294 196.17 131.616C196.493 131.939 196.876 132.195 197.297 132.369C197.718 132.544 198.17 132.634 198.626 132.634C199.082 132.634 199.534 132.544 199.955 132.369C200.377 132.195 200.76 131.939 201.082 131.616C201.405 131.294 201.661 130.911 201.835 130.489C202.01 130.068 202.099 129.616 202.099 129.16C202.099 128.704 202.01 128.252 201.835 127.831C201.661 127.41 201.405 127.027 201.082 126.704C200.76 126.382 200.377 126.126 199.955 125.951C199.534 125.777 199.082 125.687 198.626 125.687C198.17 125.687 197.718 125.777 197.297 125.951C196.876 126.126 196.493 126.382 196.17 126.704C195.848 127.027 195.592 127.41 195.417 127.831C195.243 128.252 195.153 128.704 195.153 129.16ZM202.099 129.16C202.099 130.081 202.465 130.965 203.117 131.616C203.768 132.268 204.652 132.634 205.573 132.634C206.494 132.634 207.377 132.268 208.029 131.616C208.68 130.965 209.046 130.081 209.046 129.16C209.046 128.239 208.68 127.356 208.029 126.704C207.377 126.053 206.494 125.687 205.573 125.687C204.652 125.687 203.768 126.053 203.117 126.704C202.465 127.356 202.099 128.239 202.099 129.16ZM215.993 129.16C215.993 130.081 216.359 130.965 217.01 131.616C217.661 132.268 218.545 132.634 219.466 132.634C220.387 132.634 221.271 132.268 221.922 131.616C222.573 130.965 222.939 130.081 222.939 129.16C222.939 128.239 222.573 127.356 221.922 126.704C221.271 126.053 220.387 125.687 219.466 125.687C218.545 125.687 217.661 126.053 217.01 126.704C216.359 127.356 215.993 128.239 215.993 129.16ZM229.886 129.16C229.886 130.081 230.252 130.965 230.903 131.616C231.554 132.268 232.438 132.634 233.359 132.634C234.28 132.634 235.164 132.268 235.815 131.616C236.466 130.965 236.832 130.081 236.832 129.16C236.832 128.239 236.466 127.356 235.815 126.704C235.164 126.053 234.28 125.687 233.359 125.687C232.438 125.687 231.554 126.053 230.903 126.704C230.252 127.356 229.886 128.239 229.886 129.16ZM236.832 129.16C236.832 130.081 237.198 130.965 237.85 131.616C238.501 132.268 239.384 132.634 240.306 132.634C241.227 132.634 242.11 132.268 242.762 131.616C243.413 130.965 243.779 130.081 243.779 129.16C243.779 128.239 243.413 127.356 242.762 126.704C242.11 126.053 241.227 125.687 240.306 125.687C239.384 125.687 238.501 126.053 237.85 126.704C237.198 127.356 236.832 128.239 236.832 129.16ZM243.779 129.16C243.779 130.081 244.145 130.965 244.796 131.616C245.448 132.268 246.331 132.634 247.252 132.634C248.173 132.634 249.057 132.268 249.708 131.616C250.36 130.965 250.726 130.081 250.726 129.16C250.726 128.239 250.36 127.356 249.708 126.704C249.057 126.053 248.173 125.687 247.252 125.687C246.331 125.687 245.448 126.053 244.796 126.704C244.145 127.356 243.779 128.239 243.779 129.16ZM250.726 129.16C250.726 130.081 251.091 130.965 251.743 131.616C252.394 132.268 253.278 132.634 254.199 132.634C255.12 132.634 256.003 132.268 256.655 131.616C257.306 130.965 257.672 130.081 257.672 129.16C257.672 128.239 257.306 127.356 256.655 126.704C256.003 126.053 255.12 125.687 254.199 125.687C253.278 125.687 252.394 126.053 251.743 126.704C251.091 127.356 250.726 128.239 250.726 129.16ZM257.672 129.16C257.672 130.081 258.038 130.965 258.689 131.616C259.341 132.268 260.224 132.634 261.145 132.634C262.067 132.634 262.95 132.268 263.601 131.616C264.253 130.965 264.619 130.081 264.619 129.16C264.619 128.239 264.253 127.356 263.601 126.704C262.95 126.053 262.067 125.687 261.145 125.687C260.224 125.687 259.341 126.053 258.689 126.704C258.038 127.356 257.672 128.239 257.672 129.16ZM278.512 129.16C278.512 130.081 278.878 130.965 279.529 131.616C280.181 132.268 281.064 132.634 281.985 132.634C282.906 132.634 283.79 132.268 284.441 131.616C285.093 130.965 285.458 130.081 285.458 129.16C285.458 128.239 285.093 127.356 284.441 126.704C283.79 126.053 282.906 125.687 281.985 125.687C281.064 125.687 280.181 126.053 279.529 126.704C278.878 127.356 278.512 128.239 278.512 129.16ZM285.458 129.16C285.458 130.081 285.824 130.965 286.476 131.616C287.127 132.268 288.011 132.634 288.932 132.634C289.853 132.634 290.736 132.268 291.388 131.616C292.039 130.965 292.405 130.081 292.405 129.16C292.405 128.239 292.039 127.356 291.388 126.704C290.736 126.053 289.853 125.687 288.932 125.687C288.011 125.687 287.127 126.053 286.476 126.704C285.824 127.356 285.458 128.239 285.458 129.16ZM21.4881 136.107C21.4881 137.028 21.8541 137.911 22.5055 138.563C23.1568 139.214 24.0403 139.58 24.9614 139.58C25.8826 139.58 26.7661 139.214 27.4174 138.563C28.0688 137.911 28.4347 137.028 28.4347 136.107C28.4347 135.186 28.0688 134.302 27.4174 133.651C26.7661 132.999 25.8826 132.634 24.9614 132.634C24.0403 132.634 23.1568 132.999 22.5055 133.651C21.8541 134.302 21.4881 135.186 21.4881 136.107ZM42.3279 136.107C42.3279 136.563 42.4177 137.015 42.5923 137.436C42.7668 137.857 43.0227 138.24 43.3452 138.563C43.6677 138.885 44.0506 139.141 44.472 139.316C44.8934 139.49 45.3451 139.58 45.8012 139.58C46.2573 139.58 46.709 139.49 47.1304 139.316C47.5518 139.141 47.9347 138.885 48.2572 138.563C48.5797 138.24 48.8356 137.857 49.0101 137.436C49.1847 137.015 49.2745 136.563 49.2745 136.107C49.2745 135.651 49.1847 135.199 49.0101 134.778C48.8356 134.356 48.5797 133.973 48.2572 133.651C47.9347 133.328 47.5518 133.072 47.1304 132.898C46.709 132.723 46.2573 132.634 45.8012 132.634C45.3451 132.634 44.8934 132.723 44.472 132.898C44.0506 133.072 43.6677 133.328 43.3452 133.651C43.0227 133.973 42.7668 134.356 42.5923 134.778C42.4177 135.199 42.3279 135.651 42.3279 136.107ZM49.2745 136.107C49.2745 136.563 49.3643 137.015 49.5389 137.436C49.7134 137.857 49.9693 138.24 50.2918 138.563C50.6143 138.885 50.9972 139.141 51.4186 139.316C51.84 139.49 52.2917 139.58 52.7478 139.58C53.2039 139.58 53.6556 139.49 54.077 139.316C54.4984 139.141 54.8813 138.885 55.2038 138.563C55.5263 138.24 55.7821 137.857 55.9567 137.436C56.1312 137.015 56.2211 136.563 56.2211 136.107C56.2211 135.651 56.1312 135.199 55.9567 134.778C55.7821 134.356 55.5263 133.973 55.2038 133.651C54.8813 133.328 54.4984 133.072 54.077 132.898C53.6556 132.723 53.2039 132.634 52.7478 132.634C52.2917 132.634 51.84 132.723 51.4186 132.898C50.9972 133.072 50.6143 133.328 50.2918 133.651C49.9693 133.973 49.7134 134.356 49.5389 134.778C49.3643 135.199 49.2745 135.651 49.2745 136.107ZM77.0609 136.107C77.0609 136.563 77.1507 137.015 77.3252 137.436C77.4998 137.857 77.7556 138.24 78.0782 138.563C78.4007 138.885 78.7836 139.141 79.205 139.316C79.6264 139.49 80.078 139.58 80.5341 139.58C80.9903 139.58 81.4419 139.49 81.8633 139.316C82.2847 139.141 82.6676 138.885 82.9901 138.563C83.3127 138.24 83.5685 137.857 83.743 137.436C83.9176 137.015 84.0074 136.563 84.0074 136.107C84.0074 135.651 83.9176 135.199 83.743 134.778C83.5685 134.356 83.3127 133.973 82.9901 133.651C82.6676 133.328 82.2847 133.072 81.8633 132.898C81.4419 132.723 80.9903 132.634 80.5341 132.634C80.078 132.634 79.6264 132.723 79.205 132.898C78.7836 133.072 78.4007 133.328 78.0782 133.651C77.7556 133.973 77.4998 134.356 77.3252 134.778C77.1507 135.199 77.0609 135.651 77.0609 136.107ZM104.847 136.107C104.847 137.028 105.213 137.911 105.865 138.563C106.516 139.214 107.399 139.58 108.321 139.58C109.242 139.58 110.125 139.214 110.776 138.563C111.428 137.911 111.794 137.028 111.794 136.107C111.794 135.186 111.428 134.302 110.776 133.651C110.125 132.999 109.242 132.634 108.321 132.634C107.399 132.634 106.516 132.999 105.865 133.651C105.213 134.302 104.847 135.186 104.847 136.107ZM111.794 136.107C111.794 137.028 112.16 137.911 112.811 138.563C113.462 139.214 114.346 139.58 115.267 139.58C116.188 139.58 117.072 139.214 117.723 138.563C118.374 137.911 118.74 137.028 118.74 136.107C118.74 135.186 118.374 134.302 117.723 133.651C117.072 132.999 116.188 132.634 115.267 132.634C114.346 132.634 113.462 132.999 112.811 133.651C112.16 134.302 111.794 135.186 111.794 136.107ZM125.687 136.107C125.687 137.028 126.053 137.911 126.704 138.563C127.356 139.214 128.239 139.58 129.16 139.58C130.081 139.58 130.965 139.214 131.616 138.563C132.268 137.911 132.634 137.028 132.634 136.107C132.634 135.186 132.268 134.302 131.616 133.651C130.965 132.999 130.081 132.634 129.16 132.634C128.239 132.634 127.356 132.999 126.704 133.651C126.053 134.302 125.687 135.186 125.687 136.107ZM146.527 136.107C146.527 137.028 146.893 137.911 147.544 138.563C148.195 139.214 149.079 139.58 150 139.58C150.921 139.58 151.805 139.214 152.456 138.563C153.107 137.911 153.473 137.028 153.473 136.107C153.473 135.186 153.107 134.302 152.456 133.651C151.805 132.999 150.921 132.634 150 132.634C149.079 132.634 148.195 132.999 147.544 133.651C146.893 134.302 146.527 135.186 146.527 136.107ZM153.473 136.107C153.473 136.563 153.563 137.015 153.738 137.436C153.912 137.857 154.168 138.24 154.491 138.563C154.813 138.885 155.196 139.141 155.617 139.316C156.039 139.49 156.491 139.58 156.947 139.58C157.403 139.58 157.854 139.49 158.276 139.316C158.697 139.141 159.08 138.885 159.403 138.563C159.725 138.24 159.981 137.857 160.156 137.436C160.33 137.015 160.42 136.563 160.42 136.107C160.42 135.651 160.33 135.199 160.156 134.778C159.981 134.356 159.725 133.973 159.403 133.651C159.08 133.328 158.697 133.072 158.276 132.898C157.854 132.723 157.403 132.634 156.947 132.634C156.491 132.634 156.039 132.723 155.617 132.898C155.196 133.072 154.813 133.328 154.491 133.651C154.168 133.973 153.912 134.356 153.738 134.778C153.563 135.199 153.473 135.651 153.473 136.107ZM174.313 136.107C174.313 137.028 174.679 137.911 175.33 138.563C175.982 139.214 176.865 139.58 177.786 139.58C178.708 139.58 179.591 139.214 180.242 138.563C180.894 137.911 181.26 137.028 181.26 136.107C181.26 135.186 180.894 134.302 180.242 133.651C179.591 132.999 178.708 132.634 177.786 132.634C176.865 132.634 175.982 132.999 175.33 133.651C174.679 134.302 174.313 135.186 174.313 136.107ZM181.26 136.107C181.26 137.028 181.626 137.911 182.277 138.563C182.928 139.214 183.812 139.58 184.733 139.58C185.654 139.58 186.538 139.214 187.189 138.563C187.84 137.911 188.206 137.028 188.206 136.107C188.206 135.186 187.84 134.302 187.189 133.651C186.538 132.999 185.654 132.634 184.733 132.634C183.812 132.634 182.928 132.999 182.277 133.651C181.626 134.302 181.26 135.186 181.26 136.107ZM195.153 136.107C195.153 136.563 195.243 137.015 195.417 137.436C195.592 137.857 195.848 138.24 196.17 138.563C196.493 138.885 196.876 139.141 197.297 139.316C197.718 139.49 198.17 139.58 198.626 139.58C199.082 139.58 199.534 139.49 199.955 139.316C200.377 139.141 200.76 138.885 201.082 138.563C201.405 138.24 201.661 137.857 201.835 137.436C202.01 137.015 202.099 136.563 202.099 136.107C202.099 135.651 202.01 135.199 201.835 134.778C201.661 134.356 201.405 133.973 201.082 133.651C200.76 133.328 200.377 133.072 199.955 132.898C199.534 132.723 199.082 132.634 198.626 132.634C198.17 132.634 197.718 132.723 197.297 132.898C196.876 133.072 196.493 133.328 196.17 133.651C195.848 133.973 195.592 134.356 195.417 134.778C195.243 135.199 195.153 135.651 195.153 136.107ZM202.099 136.107C202.099 137.028 202.465 137.911 203.117 138.563C203.768 139.214 204.652 139.58 205.573 139.58C206.494 139.58 207.377 139.214 208.029 138.563C208.68 137.911 209.046 137.028 209.046 136.107C209.046 135.186 208.68 134.302 208.029 133.651C207.377 132.999 206.494 132.634 205.573 132.634C204.652 132.634 203.768 132.999 203.117 133.651C202.465 134.302 202.099 135.186 202.099 136.107ZM209.046 136.107C209.046 137.028 209.412 137.911 210.063 138.563C210.715 139.214 211.598 139.58 212.519 139.58C213.44 139.58 214.324 139.214 214.975 138.563C215.627 137.911 215.993 137.028 215.993 136.107C215.993 135.186 215.627 134.302 214.975 133.651C214.324 132.999 213.44 132.634 212.519 132.634C211.598 132.634 210.715 132.999 210.063 133.651C209.412 134.302 209.046 135.186 209.046 136.107ZM229.886 136.107C229.886 137.028 230.252 137.911 230.903 138.563C231.554 139.214 232.438 139.58 233.359 139.58C234.28 139.58 235.164 139.214 235.815 138.563C236.466 137.911 236.832 137.028 236.832 136.107C236.832 135.186 236.466 134.302 235.815 133.651C235.164 132.999 234.28 132.634 233.359 132.634C232.438 132.634 231.554 132.999 230.903 133.651C230.252 134.302 229.886 135.186 229.886 136.107ZM243.779 136.107C243.779 137.028 244.145 137.911 244.796 138.563C245.448 139.214 246.331 139.58 247.252 139.58C248.173 139.58 249.057 139.214 249.708 138.563C250.36 137.911 250.726 137.028 250.726 136.107C250.726 135.186 250.36 134.302 249.708 133.651C249.057 132.999 248.173 132.634 247.252 132.634C246.331 132.634 245.448 132.999 244.796 133.651C244.145 134.302 243.779 135.186 243.779 136.107ZM250.726 136.107C250.726 137.028 251.091 137.911 251.743 138.563C252.394 139.214 253.278 139.58 254.199 139.58C255.12 139.58 256.003 139.214 256.655 138.563C257.306 137.911 257.672 137.028 257.672 136.107C257.672 135.186 257.306 134.302 256.655 133.651C256.003 132.999 255.12 132.634 254.199 132.634C253.278 132.634 252.394 132.999 251.743 133.651C251.091 134.302 250.726 135.186 250.726 136.107ZM264.619 136.107C264.619 137.028 264.985 137.911 265.636 138.563C266.287 139.214 267.171 139.58 268.092 139.58C269.013 139.58 269.897 139.214 270.548 138.563C271.199 137.911 271.565 137.028 271.565 136.107C271.565 135.186 271.199 134.302 270.548 133.651C269.897 132.999 269.013 132.634 268.092 132.634C267.171 132.634 266.287 132.999 265.636 133.651C264.985 134.302 264.619 135.186 264.619 136.107ZM285.458 136.107C285.458 137.028 285.824 137.911 286.476 138.563C287.127 139.214 288.011 139.58 288.932 139.58C289.853 139.58 290.736 139.214 291.388 138.563C292.039 137.911 292.405 137.028 292.405 136.107C292.405 135.186 292.039 134.302 291.388 133.651C290.736 132.999 289.853 132.634 288.932 132.634C288.011 132.634 287.127 132.999 286.476 133.651C285.824 134.302 285.458 135.186 285.458 136.107ZM14.5416 143.053C14.5416 143.975 14.9075 144.858 15.5589 145.509C16.2102 146.161 17.0937 146.527 18.0149 146.527C18.936 146.527 19.8195 146.161 20.4708 145.509C21.1222 144.858 21.4881 143.975 21.4881 143.053C21.4881 142.132 21.1222 141.249 20.4708 140.597C19.8195 139.946 18.936 139.58 18.0149 139.58C17.0937 139.58 16.2102 139.946 15.5589 140.597C14.9075 141.249 14.5416 142.132 14.5416 143.053ZM42.3279 143.053C42.3279 143.51 42.4177 143.961 42.5923 144.383C42.7668 144.804 43.0227 145.187 43.3452 145.509C43.6677 145.832 44.0506 146.088 44.472 146.262C44.8934 146.437 45.3451 146.527 45.8012 146.527C46.2573 146.527 46.709 146.437 47.1304 146.262C47.5518 146.088 47.9347 145.832 48.2572 145.509C48.5797 145.187 48.8356 144.804 49.0101 144.383C49.1847 143.961 49.2745 143.51 49.2745 143.053C49.2745 142.597 49.1847 142.146 49.0101 141.724C48.8356 141.303 48.5797 140.92 48.2572 140.597C47.9347 140.275 47.5518 140.019 47.1304 139.845C46.709 139.67 46.2573 139.58 45.8012 139.58C45.3451 139.58 44.8934 139.67 44.472 139.845C44.0506 140.019 43.6677 140.275 43.3452 140.597C43.0227 140.92 42.7668 141.303 42.5923 141.724C42.4177 142.146 42.3279 142.597 42.3279 143.053ZM63.1677 143.053C63.1677 143.975 63.5336 144.858 64.185 145.509C64.8363 146.161 65.7198 146.527 66.641 146.527C67.5621 146.527 68.4456 146.161 69.097 145.509C69.7483 144.858 70.1143 143.975 70.1143 143.053C70.1143 142.132 69.7483 141.249 69.097 140.597C68.4456 139.946 67.5621 139.58 66.641 139.58C65.7198 139.58 64.8363 139.946 64.185 140.597C63.5336 141.249 63.1677 142.132 63.1677 143.053ZM70.1143 143.053C70.1143 143.975 70.4802 144.858 71.1316 145.509C71.7829 146.161 72.6664 146.527 73.5876 146.527C74.5087 146.527 75.3922 146.161 76.0436 145.509C76.6949 144.858 77.0609 143.975 77.0609 143.053C77.0609 142.132 76.6949 141.249 76.0436 140.597C75.3922 139.946 74.5087 139.58 73.5876 139.58C72.6664 139.58 71.7829 139.946 71.1316 140.597C70.4802 141.249 70.1143 142.132 70.1143 143.053ZM77.0609 143.053C77.0609 143.51 77.1507 143.961 77.3252 144.383C77.4998 144.804 77.7556 145.187 78.0782 145.509C78.4007 145.832 78.7836 146.088 79.205 146.262C79.6264 146.437 80.078 146.527 80.5341 146.527C80.9903 146.527 81.4419 146.437 81.8633 146.262C82.2847 146.088 82.6676 145.832 82.9901 145.509C83.3127 145.187 83.5685 144.804 83.743 144.383C83.9176 143.961 84.0074 143.51 84.0074 143.053C84.0074 142.597 83.9176 142.146 83.743 141.724C83.5685 141.303 83.3127 140.92 82.9901 140.597C82.6676 140.275 82.2847 140.019 81.8633 139.845C81.4419 139.67 80.9903 139.58 80.5341 139.58C80.078 139.58 79.6264 139.67 79.205 139.845C78.7836 140.019 78.4007 140.275 78.0782 140.597C77.7556 140.92 77.4998 141.303 77.3252 141.724C77.1507 142.146 77.0609 142.597 77.0609 143.053ZM104.847 143.053C104.847 143.975 105.213 144.858 105.865 145.509C106.516 146.161 107.399 146.527 108.321 146.527C109.242 146.527 110.125 146.161 110.776 145.509C111.428 144.858 111.794 143.975 111.794 143.053C111.794 142.132 111.428 141.249 110.776 140.597C110.125 139.946 109.242 139.58 108.321 139.58C107.399 139.58 106.516 139.946 105.865 140.597C105.213 141.249 104.847 142.132 104.847 143.053ZM118.74 143.053C118.74 143.975 119.106 144.858 119.758 145.509C120.409 146.161 121.292 146.527 122.214 146.527C123.135 146.527 124.018 146.161 124.67 145.509C125.321 144.858 125.687 143.975 125.687 143.053C125.687 142.132 125.321 141.249 124.67 140.597C124.018 139.946 123.135 139.58 122.214 139.58C121.292 139.58 120.409 139.946 119.758 140.597C119.106 141.249 118.74 142.132 118.74 143.053ZM132.634 143.053C132.634 143.975 132.999 144.858 133.651 145.509C134.302 146.161 135.186 146.527 136.107 146.527C137.028 146.527 137.911 146.161 138.563 145.509C139.214 144.858 139.58 143.975 139.58 143.053C139.58 142.132 139.214 141.249 138.563 140.597C137.911 139.946 137.028 139.58 136.107 139.58C135.186 139.58 134.302 139.946 133.651 140.597C132.999 141.249 132.634 142.132 132.634 143.053ZM146.527 143.053C146.527 143.975 146.893 144.858 147.544 145.509C148.195 146.161 149.079 146.527 150 146.527C150.921 146.527 151.805 146.161 152.456 145.509C153.107 144.858 153.473 143.975 153.473 143.053C153.473 142.132 153.107 141.249 152.456 140.597C151.805 139.946 150.921 139.58 150 139.58C149.079 139.58 148.195 139.946 147.544 140.597C146.893 141.249 146.527 142.132 146.527 143.053ZM153.473 143.053C153.473 143.51 153.563 143.961 153.738 144.383C153.912 144.804 154.168 145.187 154.491 145.509C154.813 145.832 155.196 146.088 155.617 146.262C156.039 146.437 156.491 146.527 156.947 146.527C157.403 146.527 157.854 146.437 158.276 146.262C158.697 146.088 159.08 145.832 159.403 145.509C159.725 145.187 159.981 144.804 160.156 144.383C160.33 143.961 160.42 143.51 160.42 143.053C160.42 142.597 160.33 142.146 160.156 141.724C159.981 141.303 159.725 140.92 159.403 140.597C159.08 140.275 158.697 140.019 158.276 139.845C157.854 139.67 157.403 139.58 156.947 139.58C156.491 139.58 156.039 139.67 155.617 139.845C155.196 140.019 154.813 140.275 154.491 140.597C154.168 140.92 153.912 141.303 153.738 141.724C153.563 142.146 153.473 142.597 153.473 143.053ZM174.313 143.053C174.313 143.975 174.679 144.858 175.33 145.509C175.982 146.161 176.865 146.527 177.786 146.527C178.708 146.527 179.591 146.161 180.242 145.509C180.894 144.858 181.26 143.975 181.26 143.053C181.26 142.132 180.894 141.249 180.242 140.597C179.591 139.946 178.708 139.58 177.786 139.58C176.865 139.58 175.982 139.946 175.33 140.597C174.679 141.249 174.313 142.132 174.313 143.053ZM181.26 143.053C181.26 143.975 181.626 144.858 182.277 145.509C182.928 146.161 183.812 146.527 184.733 146.527C185.654 146.527 186.538 146.161 187.189 145.509C187.84 144.858 188.206 143.975 188.206 143.053C188.206 142.132 187.84 141.249 187.189 140.597C186.538 139.946 185.654 139.58 184.733 139.58C183.812 139.58 182.928 139.946 182.277 140.597C181.626 141.249 181.26 142.132 181.26 143.053ZM195.153 143.053C195.153 143.51 195.243 143.961 195.417 144.383C195.592 144.804 195.848 145.187 196.17 145.509C196.493 145.832 196.876 146.088 197.297 146.262C197.718 146.437 198.17 146.527 198.626 146.527C199.082 146.527 199.534 146.437 199.955 146.262C200.377 146.088 200.76 145.832 201.082 145.509C201.405 145.187 201.661 144.804 201.835 144.383C202.01 143.961 202.099 143.51 202.099 143.053C202.099 142.597 202.01 142.146 201.835 141.724C201.661 141.303 201.405 140.92 201.082 140.597C200.76 140.275 200.377 140.019 199.955 139.845C199.534 139.67 199.082 139.58 198.626 139.58C198.17 139.58 197.718 139.67 197.297 139.845C196.876 140.019 196.493 140.275 196.17 140.597C195.848 140.92 195.592 141.303 195.417 141.724C195.243 142.146 195.153 142.597 195.153 143.053ZM209.046 143.053C209.046 143.975 209.412 144.858 210.063 145.509C210.715 146.161 211.598 146.527 212.519 146.527C213.44 146.527 214.324 146.161 214.975 145.509C215.627 144.858 215.993 143.975 215.993 143.053C215.993 142.132 215.627 141.249 214.975 140.597C214.324 139.946 213.44 139.58 212.519 139.58C211.598 139.58 210.715 139.946 210.063 140.597C209.412 141.249 209.046 142.132 209.046 143.053ZM215.993 143.053C215.993 143.975 216.359 144.858 217.01 145.509C217.661 146.161 218.545 146.527 219.466 146.527C220.387 146.527 221.271 146.161 221.922 145.509C222.573 144.858 222.939 143.975 222.939 143.053C222.939 142.132 222.573 141.249 221.922 140.597C221.271 139.946 220.387 139.58 219.466 139.58C218.545 139.58 217.661 139.946 217.01 140.597C216.359 141.249 215.993 142.132 215.993 143.053ZM243.779 143.053C243.779 143.975 244.145 144.858 244.796 145.509C245.448 146.161 246.331 146.527 247.252 146.527C248.173 146.527 249.057 146.161 249.708 145.509C250.36 144.858 250.726 143.975 250.726 143.053C250.726 142.132 250.36 141.249 249.708 140.597C249.057 139.946 248.173 139.58 247.252 139.58C246.331 139.58 245.448 139.946 244.796 140.597C244.145 141.249 243.779 142.132 243.779 143.053ZM250.726 143.053C250.726 143.975 251.091 144.858 251.743 145.509C252.394 146.161 253.278 146.527 254.199 146.527C255.12 146.527 256.003 146.161 256.655 145.509C257.306 144.858 257.672 143.975 257.672 143.053C257.672 142.132 257.306 141.249 256.655 140.597C256.003 139.946 255.12 139.58 254.199 139.58C253.278 139.58 252.394 139.946 251.743 140.597C251.091 141.249 250.726 142.132 250.726 143.053ZM264.619 143.053C264.619 143.975 264.985 144.858 265.636 145.509C266.287 146.161 267.171 146.527 268.092 146.527C269.013 146.527 269.897 146.161 270.548 145.509C271.199 144.858 271.565 143.975 271.565 143.053C271.565 142.132 271.199 141.249 270.548 140.597C269.897 139.946 269.013 139.58 268.092 139.58C267.171 139.58 266.287 139.946 265.636 140.597C264.985 141.249 264.619 142.132 264.619 143.053ZM278.512 143.053C278.512 143.975 278.878 144.858 279.529 145.509C280.181 146.161 281.064 146.527 281.985 146.527C282.906 146.527 283.79 146.161 284.441 145.509C285.093 144.858 285.458 143.975 285.458 143.053C285.458 142.132 285.093 141.249 284.441 140.597C283.79 139.946 282.906 139.58 281.985 139.58C281.064 139.58 280.181 139.946 279.529 140.597C278.878 141.249 278.512 142.132 278.512 143.053ZM285.458 143.053C285.458 143.975 285.824 144.858 286.476 145.509C287.127 146.161 288.011 146.527 288.932 146.527C289.853 146.527 290.736 146.161 291.388 145.509C292.039 144.858 292.405 143.975 292.405 143.053C292.405 142.132 292.039 141.249 291.388 140.597C290.736 139.946 289.853 139.58 288.932 139.58C288.011 139.58 287.127 139.946 286.476 140.597C285.824 141.249 285.458 142.132 285.458 143.053ZM14.5416 150C14.5416 150.921 14.9075 151.805 15.5589 152.456C16.2102 153.107 17.0937 153.473 18.0149 153.473C18.936 153.473 19.8195 153.107 20.4708 152.456C21.1222 151.805 21.4881 150.921 21.4881 150C21.4881 149.079 21.1222 148.195 20.4708 147.544C19.8195 146.893 18.936 146.527 18.0149 146.527C17.0937 146.527 16.2102 146.893 15.5589 147.544C14.9075 148.195 14.5416 149.079 14.5416 150ZM21.4881 150C21.4881 150.921 21.8541 151.805 22.5055 152.456C23.1568 153.107 24.0403 153.473 24.9614 153.473C25.8826 153.473 26.7661 153.107 27.4174 152.456C28.0688 151.805 28.4347 150.921 28.4347 150C28.4347 149.079 28.0688 148.195 27.4174 147.544C26.7661 146.893 25.8826 146.527 24.9614 146.527C24.0403 146.527 23.1568 146.893 22.5055 147.544C21.8541 148.195 21.4881 149.079 21.4881 150ZM28.4347 150C28.4347 150.921 28.8007 151.805 29.452 152.456C30.1034 153.107 30.9869 153.473 31.908 153.473C32.8292 153.473 33.7126 153.107 34.364 152.456C35.0154 151.805 35.3813 150.921 35.3813 150C35.3813 149.079 35.0154 148.195 34.364 147.544C33.7126 146.893 32.8292 146.527 31.908 146.527C30.9869 146.527 30.1034 146.893 29.452 147.544C28.8007 148.195 28.4347 149.079 28.4347 150ZM35.3813 150C35.3813 150.921 35.7473 151.805 36.3986 152.456C37.05 153.107 37.9334 153.473 38.8546 153.473C39.7758 153.473 40.6592 153.107 41.3106 152.456C41.962 151.805 42.3279 150.921 42.3279 150C42.3279 149.079 41.962 148.195 41.3106 147.544C40.6592 146.893 39.7758 146.527 38.8546 146.527C37.9334 146.527 37.05 146.893 36.3986 147.544C35.7473 148.195 35.3813 149.079 35.3813 150ZM42.3279 150C42.3279 150.456 42.4177 150.908 42.5923 151.329C42.7668 151.751 43.0227 152.133 43.3452 152.456C43.6677 152.779 44.0506 153.034 44.472 153.209C44.8934 153.383 45.3451 153.473 45.8012 153.473C46.2573 153.473 46.709 153.383 47.1304 153.209C47.5518 153.034 47.9347 152.779 48.2572 152.456C48.5797 152.133 48.8356 151.751 49.0101 151.329C49.1847 150.908 49.2745 150.456 49.2745 150C49.2745 149.544 49.1847 149.092 49.0101 148.671C48.8356 148.249 48.5797 147.867 48.2572 147.544C47.9347 147.221 47.5518 146.966 47.1304 146.791C46.709 146.617 46.2573 146.527 45.8012 146.527C45.3451 146.527 44.8934 146.617 44.472 146.791C44.0506 146.966 43.6677 147.221 43.3452 147.544C43.0227 147.867 42.7668 148.249 42.5923 148.671C42.4177 149.092 42.3279 149.544 42.3279 150ZM49.2745 150C49.2745 150.456 49.3643 150.908 49.5389 151.329C49.7134 151.751 49.9693 152.133 50.2918 152.456C50.6143 152.779 50.9972 153.034 51.4186 153.209C51.84 153.383 52.2917 153.473 52.7478 153.473C53.2039 153.473 53.6556 153.383 54.077 153.209C54.4984 153.034 54.8813 152.779 55.2038 152.456C55.5263 152.133 55.7821 151.751 55.9567 151.329C56.1312 150.908 56.2211 150.456 56.2211 150C56.2211 149.544 56.1312 149.092 55.9567 148.671C55.7821 148.249 55.5263 147.867 55.2038 147.544C54.8813 147.221 54.4984 146.966 54.077 146.791C53.6556 146.617 53.2039 146.527 52.7478 146.527C52.2917 146.527 51.84 146.617 51.4186 146.791C50.9972 146.966 50.6143 147.221 50.2918 147.544C49.9693 147.867 49.7134 148.249 49.5389 148.671C49.3643 149.092 49.2745 149.544 49.2745 150ZM56.2211 150C56.2211 150.921 56.587 151.805 57.2384 152.456C57.8898 153.107 58.7732 153.473 59.6944 153.473C60.6156 153.473 61.499 153.107 62.1504 152.456C62.8017 151.805 63.1677 150.921 63.1677 150C63.1677 149.079 62.8017 148.195 62.1504 147.544C61.499 146.893 60.6156 146.527 59.6944 146.527C58.7732 146.527 57.8898 146.893 57.2384 147.544C56.587 148.195 56.2211 149.079 56.2211 150ZM63.1677 150C63.1677 150.921 63.5336 151.805 64.185 152.456C64.8363 153.107 65.7198 153.473 66.641 153.473C67.5621 153.473 68.4456 153.107 69.097 152.456C69.7483 151.805 70.1143 150.921 70.1143 150C70.1143 149.079 69.7483 148.195 69.097 147.544C68.4456 146.893 67.5621 146.527 66.641 146.527C65.7198 146.527 64.8363 146.893 64.185 147.544C63.5336 148.195 63.1677 149.079 63.1677 150ZM70.1143 150C70.1143 150.921 70.4802 151.805 71.1316 152.456C71.7829 153.107 72.6664 153.473 73.5876 153.473C74.5087 153.473 75.3922 153.107 76.0436 152.456C76.6949 151.805 77.0609 150.921 77.0609 150C77.0609 149.079 76.6949 148.195 76.0436 147.544C75.3922 146.893 74.5087 146.527 73.5876 146.527C72.6664 146.527 71.7829 146.893 71.1316 147.544C70.4802 148.195 70.1143 149.079 70.1143 150ZM84.0074 150C84.0074 150.921 84.3734 151.805 85.0247 152.456C85.6761 153.107 86.5596 153.473 87.4807 153.473C88.4019 153.473 89.2854 153.107 89.9367 152.456C90.5881 151.805 90.954 150.921 90.954 150C90.954 149.079 90.5881 148.195 89.9367 147.544C89.2854 146.893 88.4019 146.527 87.4807 146.527C86.5596 146.527 85.6761 146.893 85.0247 147.544C84.3734 148.195 84.0074 149.079 84.0074 150ZM90.954 150C90.954 150.921 91.32 151.805 91.9713 152.456C92.6227 153.107 93.5061 153.473 94.4273 153.473C95.3485 153.473 96.2319 153.107 96.8833 152.456C97.5347 151.805 97.9006 150.921 97.9006 150C97.9006 149.079 97.5347 148.195 96.8833 147.544C96.2319 146.893 95.3485 146.527 94.4273 146.527C93.5061 146.527 92.6227 146.893 91.9713 147.544C91.32 148.195 90.954 149.079 90.954 150ZM97.9006 150C97.9006 150.456 97.9905 150.908 98.165 151.329C98.3396 151.751 98.5954 152.133 98.9179 152.456C99.2404 152.779 99.6233 153.034 100.045 153.209C100.466 153.383 100.918 153.473 101.374 153.473C101.83 153.473 102.282 153.383 102.703 153.209C103.124 153.034 103.507 152.779 103.83 152.456C104.152 152.133 104.408 151.751 104.583 151.329C104.757 150.908 104.847 150.456 104.847 150C104.847 149.544 104.757 149.092 104.583 148.671C104.408 148.249 104.152 147.867 103.83 147.544C103.507 147.221 103.124 146.966 102.703 146.791C102.282 146.617 101.83 146.527 101.374 146.527C100.918 146.527 100.466 146.617 100.045 146.791C99.6233 146.966 99.2404 147.221 98.9179 147.544C98.5954 147.867 98.3396 148.249 98.165 148.671C97.9905 149.092 97.9006 149.544 97.9006 150ZM111.794 150C111.794 150.921 112.16 151.805 112.811 152.456C113.462 153.107 114.346 153.473 115.267 153.473C116.188 153.473 117.072 153.107 117.723 152.456C118.374 151.805 118.74 150.921 118.74 150C118.74 149.079 118.374 148.195 117.723 147.544C117.072 146.893 116.188 146.527 115.267 146.527C114.346 146.527 113.462 146.893 112.811 147.544C112.16 148.195 111.794 149.079 111.794 150ZM118.74 150C118.74 150.921 119.106 151.805 119.758 152.456C120.409 153.107 121.292 153.473 122.214 153.473C123.135 153.473 124.018 153.107 124.67 152.456C125.321 151.805 125.687 150.921 125.687 150C125.687 149.079 125.321 148.195 124.67 147.544C124.018 146.893 123.135 146.527 122.214 146.527C121.292 146.527 120.409 146.893 119.758 147.544C119.106 148.195 118.74 149.079 118.74 150ZM132.634 150C132.634 150.921 132.999 151.805 133.651 152.456C134.302 153.107 135.186 153.473 136.107 153.473C137.028 153.473 137.911 153.107 138.563 152.456C139.214 151.805 139.58 150.921 139.58 150C139.58 149.079 139.214 148.195 138.563 147.544C137.911 146.893 137.028 146.527 136.107 146.527C135.186 146.527 134.302 146.893 133.651 147.544C132.999 148.195 132.634 149.079 132.634 150ZM139.58 150C139.58 150.921 139.946 151.805 140.597 152.456C141.249 153.107 142.132 153.473 143.053 153.473C143.975 153.473 144.858 153.107 145.509 152.456C146.161 151.805 146.527 150.921 146.527 150C146.527 149.079 146.161 148.195 145.509 147.544C144.858 146.893 143.975 146.527 143.053 146.527C142.132 146.527 141.249 146.893 140.597 147.544C139.946 148.195 139.58 149.079 139.58 150ZM146.527 150C146.527 150.921 146.893 151.805 147.544 152.456C148.195 153.107 149.079 153.473 150 153.473C150.921 153.473 151.805 153.107 152.456 152.456C153.107 151.805 153.473 150.921 153.473 150C153.473 149.079 153.107 148.195 152.456 147.544C151.805 146.893 150.921 146.527 150 146.527C149.079 146.527 148.195 146.893 147.544 147.544C146.893 148.195 146.527 149.079 146.527 150ZM167.366 150C167.366 150.921 167.732 151.805 168.384 152.456C169.035 153.107 169.919 153.473 170.84 153.473C171.761 153.473 172.644 153.107 173.296 152.456C173.947 151.805 174.313 150.921 174.313 150C174.313 149.079 173.947 148.195 173.296 147.544C172.644 146.893 171.761 146.527 170.84 146.527C169.919 146.527 169.035 146.893 168.384 147.544C167.732 148.195 167.366 149.079 167.366 150ZM174.313 150C174.313 150.921 174.679 151.805 175.33 152.456C175.982 153.107 176.865 153.473 177.786 153.473C178.708 153.473 179.591 153.107 180.242 152.456C180.894 151.805 181.26 150.921 181.26 150C181.26 149.079 180.894 148.195 180.242 147.544C179.591 146.893 178.708 146.527 177.786 146.527C176.865 146.527 175.982 146.893 175.33 147.544C174.679 148.195 174.313 149.079 174.313 150ZM195.153 150C195.153 150.456 195.243 150.908 195.417 151.329C195.592 151.751 195.848 152.133 196.17 152.456C196.493 152.779 196.876 153.034 197.297 153.209C197.718 153.383 198.17 153.473 198.626 153.473C199.082 153.473 199.534 153.383 199.955 153.209C200.377 153.034 200.76 152.779 201.082 152.456C201.405 152.133 201.661 151.751 201.835 151.329C202.01 150.908 202.099 150.456 202.099 150C202.099 149.544 202.01 149.092 201.835 148.671C201.661 148.249 201.405 147.867 201.082 147.544C200.76 147.221 200.377 146.966 199.955 146.791C199.534 146.617 199.082 146.527 198.626 146.527C198.17 146.527 197.718 146.617 197.297 146.791C196.876 146.966 196.493 147.221 196.17 147.544C195.848 147.867 195.592 148.249 195.417 148.671C195.243 149.092 195.153 149.544 195.153 150ZM215.993 150C215.993 150.921 216.359 151.805 217.01 152.456C217.661 153.107 218.545 153.473 219.466 153.473C220.387 153.473 221.271 153.107 221.922 152.456C222.573 151.805 222.939 150.921 222.939 150C222.939 149.079 222.573 148.195 221.922 147.544C221.271 146.893 220.387 146.527 219.466 146.527C218.545 146.527 217.661 146.893 217.01 147.544C216.359 148.195 215.993 149.079 215.993 150ZM229.886 150C229.886 150.921 230.252 151.805 230.903 152.456C231.554 153.107 232.438 153.473 233.359 153.473C234.28 153.473 235.164 153.107 235.815 152.456C236.466 151.805 236.832 150.921 236.832 150C236.832 149.079 236.466 148.195 235.815 147.544C235.164 146.893 234.28 146.527 233.359 146.527C232.438 146.527 231.554 146.893 230.903 147.544C230.252 148.195 229.886 149.079 229.886 150ZM236.832 150C236.832 150.921 237.198 151.805 237.85 152.456C238.501 153.107 239.384 153.473 240.306 153.473C241.227 153.473 242.11 153.107 242.762 152.456C243.413 151.805 243.779 150.921 243.779 150C243.779 149.079 243.413 148.195 242.762 147.544C242.11 146.893 241.227 146.527 240.306 146.527C239.384 146.527 238.501 146.893 237.85 147.544C237.198 148.195 236.832 149.079 236.832 150ZM250.726 150C250.726 150.921 251.091 151.805 251.743 152.456C252.394 153.107 253.278 153.473 254.199 153.473C255.12 153.473 256.003 153.107 256.655 152.456C257.306 151.805 257.672 150.921 257.672 150C257.672 149.079 257.306 148.195 256.655 147.544C256.003 146.893 255.12 146.527 254.199 146.527C253.278 146.527 252.394 146.893 251.743 147.544C251.091 148.195 250.726 149.079 250.726 150ZM257.672 150C257.672 150.921 258.038 151.805 258.689 152.456C259.341 153.107 260.224 153.473 261.145 153.473C262.067 153.473 262.95 153.107 263.601 152.456C264.253 151.805 264.619 150.921 264.619 150C264.619 149.079 264.253 148.195 263.601 147.544C262.95 146.893 262.067 146.527 261.145 146.527C260.224 146.527 259.341 146.893 258.689 147.544C258.038 148.195 257.672 149.079 257.672 150ZM264.619 150C264.619 150.921 264.985 151.805 265.636 152.456C266.287 153.107 267.171 153.473 268.092 153.473C269.013 153.473 269.897 153.107 270.548 152.456C271.199 151.805 271.565 150.921 271.565 150C271.565 149.079 271.199 148.195 270.548 147.544C269.897 146.893 269.013 146.527 268.092 146.527C267.171 146.527 266.287 146.893 265.636 147.544C264.985 148.195 264.619 149.079 264.619 150ZM7.59497 156.947C7.59497 157.868 7.96091 158.751 8.61227 159.403C9.26364 160.054 10.1471 160.42 11.0683 160.42C11.9894 160.42 12.8729 160.054 13.5243 159.403C14.1756 158.751 14.5416 157.868 14.5416 156.947C14.5416 156.025 14.1756 155.142 13.5243 154.491C12.8729 153.839 11.9894 153.473 11.0683 153.473C10.1471 153.473 9.26364 153.839 8.61227 154.491C7.96091 155.142 7.59497 156.025 7.59497 156.947ZM21.4881 156.947C21.4881 157.868 21.8541 158.751 22.5055 159.403C23.1568 160.054 24.0403 160.42 24.9614 160.42C25.8826 160.42 26.7661 160.054 27.4174 159.403C28.0688 158.751 28.4347 157.868 28.4347 156.947C28.4347 156.025 28.0688 155.142 27.4174 154.491C26.7661 153.839 25.8826 153.473 24.9614 153.473C24.0403 153.473 23.1568 153.839 22.5055 154.491C21.8541 155.142 21.4881 156.025 21.4881 156.947ZM28.4347 156.947C28.4347 157.868 28.8007 158.751 29.452 159.403C30.1034 160.054 30.9869 160.42 31.908 160.42C32.8292 160.42 33.7126 160.054 34.364 159.403C35.0154 158.751 35.3813 157.868 35.3813 156.947C35.3813 156.025 35.0154 155.142 34.364 154.491C33.7126 153.839 32.8292 153.473 31.908 153.473C30.9869 153.473 30.1034 153.839 29.452 154.491C28.8007 155.142 28.4347 156.025 28.4347 156.947ZM35.3813 156.947C35.3813 157.868 35.7473 158.751 36.3986 159.403C37.05 160.054 37.9334 160.42 38.8546 160.42C39.7758 160.42 40.6592 160.054 41.3106 159.403C41.962 158.751 42.3279 157.868 42.3279 156.947C42.3279 156.025 41.962 155.142 41.3106 154.491C40.6592 153.839 39.7758 153.473 38.8546 153.473C37.9334 153.473 37.05 153.839 36.3986 154.491C35.7473 155.142 35.3813 156.025 35.3813 156.947ZM42.3279 156.947C42.3279 157.403 42.4177 157.854 42.5923 158.276C42.7668 158.697 43.0227 159.08 43.3452 159.403C43.6677 159.725 44.0506 159.981 44.472 160.155C44.8934 160.33 45.3451 160.42 45.8012 160.42C46.2573 160.42 46.709 160.33 47.1304 160.155C47.5518 159.981 47.9347 159.725 48.2572 159.403C48.5797 159.08 48.8356 158.697 49.0101 158.276C49.1847 157.854 49.2745 157.403 49.2745 156.947C49.2745 156.49 49.1847 156.039 49.0101 155.617C48.8356 155.196 48.5797 154.813 48.2572 154.491C47.9347 154.168 47.5518 153.912 47.1304 153.738C46.709 153.563 46.2573 153.473 45.8012 153.473C45.3451 153.473 44.8934 153.563 44.472 153.738C44.0506 153.912 43.6677 154.168 43.3452 154.491C43.0227 154.813 42.7668 155.196 42.5923 155.617C42.4177 156.039 42.3279 156.49 42.3279 156.947ZM70.1143 156.947C70.1143 157.868 70.4802 158.751 71.1316 159.403C71.7829 160.054 72.6664 160.42 73.5876 160.42C74.5087 160.42 75.3922 160.054 76.0436 159.403C76.6949 158.751 77.0609 157.868 77.0609 156.947C77.0609 156.025 76.6949 155.142 76.0436 154.491C75.3922 153.839 74.5087 153.473 73.5876 153.473C72.6664 153.473 71.7829 153.839 71.1316 154.491C70.4802 155.142 70.1143 156.025 70.1143 156.947ZM77.0609 156.947C77.0609 157.403 77.1507 157.854 77.3252 158.276C77.4998 158.697 77.7556 159.08 78.0782 159.403C78.4007 159.725 78.7836 159.981 79.205 160.155C79.6264 160.33 80.078 160.42 80.5341 160.42C80.9903 160.42 81.4419 160.33 81.8633 160.155C82.2847 159.981 82.6676 159.725 82.9901 159.403C83.3127 159.08 83.5685 158.697 83.743 158.276C83.9176 157.854 84.0074 157.403 84.0074 156.947C84.0074 156.49 83.9176 156.039 83.743 155.617C83.5685 155.196 83.3127 154.813 82.9901 154.491C82.6676 154.168 82.2847 153.912 81.8633 153.738C81.4419 153.563 80.9903 153.473 80.5341 153.473C80.078 153.473 79.6264 153.563 79.205 153.738C78.7836 153.912 78.4007 154.168 78.0782 154.491C77.7556 154.813 77.4998 155.196 77.3252 155.617C77.1507 156.039 77.0609 156.49 77.0609 156.947ZM84.0074 156.947C84.0074 157.868 84.3734 158.751 85.0247 159.403C85.6761 160.054 86.5596 160.42 87.4807 160.42C88.4019 160.42 89.2854 160.054 89.9367 159.403C90.5881 158.751 90.954 157.868 90.954 156.947C90.954 156.025 90.5881 155.142 89.9367 154.491C89.2854 153.839 88.4019 153.473 87.4807 153.473C86.5596 153.473 85.6761 153.839 85.0247 154.491C84.3734 155.142 84.0074 156.025 84.0074 156.947ZM90.954 156.947C90.954 157.868 91.32 158.751 91.9713 159.403C92.6227 160.054 93.5061 160.42 94.4273 160.42C95.3485 160.42 96.2319 160.054 96.8833 159.403C97.5347 158.751 97.9006 157.868 97.9006 156.947C97.9006 156.025 97.5347 155.142 96.8833 154.491C96.2319 153.839 95.3485 153.473 94.4273 153.473C93.5061 153.473 92.6227 153.839 91.9713 154.491C91.32 155.142 90.954 156.025 90.954 156.947ZM118.74 156.947C118.74 157.868 119.106 158.751 119.758 159.403C120.409 160.054 121.292 160.42 122.214 160.42C123.135 160.42 124.018 160.054 124.67 159.403C125.321 158.751 125.687 157.868 125.687 156.947C125.687 156.025 125.321 155.142 124.67 154.491C124.018 153.839 123.135 153.473 122.214 153.473C121.292 153.473 120.409 153.839 119.758 154.491C119.106 155.142 118.74 156.025 118.74 156.947ZM146.527 156.947C146.527 157.868 146.893 158.751 147.544 159.403C148.195 160.054 149.079 160.42 150 160.42C150.921 160.42 151.805 160.054 152.456 159.403C153.107 158.751 153.473 157.868 153.473 156.947C153.473 156.025 153.107 155.142 152.456 154.491C151.805 153.839 150.921 153.473 150 153.473C149.079 153.473 148.195 153.839 147.544 154.491C146.893 155.142 146.527 156.025 146.527 156.947ZM160.42 156.947C160.42 157.868 160.786 158.751 161.437 159.403C162.089 160.054 162.972 160.42 163.893 160.42C164.814 160.42 165.698 160.054 166.349 159.403C167.001 158.751 167.366 157.868 167.366 156.947C167.366 156.025 167.001 155.142 166.349 154.491C165.698 153.839 164.814 153.473 163.893 153.473C162.972 153.473 162.089 153.839 161.437 154.491C160.786 155.142 160.42 156.025 160.42 156.947ZM195.153 156.947C195.153 157.403 195.243 157.854 195.417 158.276C195.592 158.697 195.848 159.08 196.17 159.403C196.493 159.725 196.876 159.981 197.297 160.155C197.718 160.33 198.17 160.42 198.626 160.42C199.082 160.42 199.534 160.33 199.955 160.155C200.377 159.981 200.76 159.725 201.082 159.403C201.405 159.08 201.661 158.697 201.835 158.276C202.01 157.854 202.099 157.403 202.099 156.947C202.099 156.49 202.01 156.039 201.835 155.617C201.661 155.196 201.405 154.813 201.082 154.491C200.76 154.168 200.377 153.912 199.955 153.738C199.534 153.563 199.082 153.473 198.626 153.473C198.17 153.473 197.718 153.563 197.297 153.738C196.876 153.912 196.493 154.168 196.17 154.491C195.848 154.813 195.592 155.196 195.417 155.617C195.243 156.039 195.153 156.49 195.153 156.947ZM202.099 156.947C202.099 157.868 202.465 158.751 203.117 159.403C203.768 160.054 204.652 160.42 205.573 160.42C206.494 160.42 207.377 160.054 208.029 159.403C208.68 158.751 209.046 157.868 209.046 156.947C209.046 156.025 208.68 155.142 208.029 154.491C207.377 153.839 206.494 153.473 205.573 153.473C204.652 153.473 203.768 153.839 203.117 154.491C202.465 155.142 202.099 156.025 202.099 156.947ZM209.046 156.947C209.046 157.868 209.412 158.751 210.063 159.403C210.715 160.054 211.598 160.42 212.519 160.42C213.44 160.42 214.324 160.054 214.975 159.403C215.627 158.751 215.993 157.868 215.993 156.947C215.993 156.025 215.627 155.142 214.975 154.491C214.324 153.839 213.44 153.473 212.519 153.473C211.598 153.473 210.715 153.839 210.063 154.491C209.412 155.142 209.046 156.025 209.046 156.947ZM236.832 156.947C236.832 157.868 237.198 158.751 237.85 159.403C238.501 160.054 239.384 160.42 240.306 160.42C241.227 160.42 242.11 160.054 242.762 159.403C243.413 158.751 243.779 157.868 243.779 156.947C243.779 156.025 243.413 155.142 242.762 154.491C242.11 153.839 241.227 153.473 240.306 153.473C239.384 153.473 238.501 153.839 237.85 154.491C237.198 155.142 236.832 156.025 236.832 156.947ZM243.779 156.947C243.779 157.868 244.145 158.751 244.796 159.403C245.448 160.054 246.331 160.42 247.252 160.42C248.173 160.42 249.057 160.054 249.708 159.403C250.36 158.751 250.726 157.868 250.726 156.947C250.726 156.025 250.36 155.142 249.708 154.491C249.057 153.839 248.173 153.473 247.252 153.473C246.331 153.473 245.448 153.839 244.796 154.491C244.145 155.142 243.779 156.025 243.779 156.947ZM257.672 156.947C257.672 157.868 258.038 158.751 258.689 159.403C259.341 160.054 260.224 160.42 261.145 160.42C262.067 160.42 262.95 160.054 263.601 159.403C264.253 158.751 264.619 157.868 264.619 156.947C264.619 156.025 264.253 155.142 263.601 154.491C262.95 153.839 262.067 153.473 261.145 153.473C260.224 153.473 259.341 153.839 258.689 154.491C258.038 155.142 257.672 156.025 257.672 156.947ZM264.619 156.947C264.619 157.868 264.985 158.751 265.636 159.403C266.287 160.054 267.171 160.42 268.092 160.42C269.013 160.42 269.897 160.054 270.548 159.403C271.199 158.751 271.565 157.868 271.565 156.947C271.565 156.025 271.199 155.142 270.548 154.491C269.897 153.839 269.013 153.473 268.092 153.473C267.171 153.473 266.287 153.839 265.636 154.491C264.985 155.142 264.619 156.025 264.619 156.947ZM285.458 156.947C285.458 157.868 285.824 158.751 286.476 159.403C287.127 160.054 288.011 160.42 288.932 160.42C289.853 160.42 290.736 160.054 291.388 159.403C292.039 158.751 292.405 157.868 292.405 156.947C292.405 156.025 292.039 155.142 291.388 154.491C290.736 153.839 289.853 153.473 288.932 153.473C288.011 153.473 287.127 153.839 286.476 154.491C285.824 155.142 285.458 156.025 285.458 156.947ZM21.4881 163.893C21.4881 164.814 21.8541 165.698 22.5055 166.349C23.1568 167.001 24.0403 167.366 24.9614 167.366C25.8826 167.366 26.7661 167.001 27.4174 166.349C28.0688 165.698 28.4347 164.814 28.4347 163.893C28.4347 162.972 28.0688 162.089 27.4174 161.437C26.7661 160.786 25.8826 160.42 24.9614 160.42C24.0403 160.42 23.1568 160.786 22.5055 161.437C21.8541 162.089 21.4881 162.972 21.4881 163.893ZM28.4347 163.893C28.4347 164.814 28.8007 165.698 29.452 166.349C30.1034 167.001 30.9869 167.366 31.908 167.366C32.8292 167.366 33.7126 167.001 34.364 166.349C35.0154 165.698 35.3813 164.814 35.3813 163.893C35.3813 162.972 35.0154 162.089 34.364 161.437C33.7126 160.786 32.8292 160.42 31.908 160.42C30.9869 160.42 30.1034 160.786 29.452 161.437C28.8007 162.089 28.4347 162.972 28.4347 163.893ZM49.2745 163.893C49.2745 164.349 49.3643 164.801 49.5389 165.222C49.7134 165.644 49.9693 166.027 50.2918 166.349C50.6143 166.672 50.9972 166.928 51.4186 167.102C51.84 167.277 52.2917 167.366 52.7478 167.366C53.2039 167.366 53.6556 167.277 54.077 167.102C54.4984 166.928 54.8813 166.672 55.2038 166.349C55.5263 166.027 55.7821 165.644 55.9567 165.222C56.1312 164.801 56.2211 164.349 56.2211 163.893C56.2211 163.437 56.1312 162.985 55.9567 162.564C55.7821 162.143 55.5263 161.76 55.2038 161.437C54.8813 161.115 54.4984 160.859 54.077 160.684C53.6556 160.51 53.2039 160.42 52.7478 160.42C52.2917 160.42 51.84 160.51 51.4186 160.684C50.9972 160.859 50.6143 161.115 50.2918 161.437C49.9693 161.76 49.7134 162.143 49.5389 162.564C49.3643 162.985 49.2745 163.437 49.2745 163.893ZM56.2211 163.893C56.2211 164.814 56.587 165.698 57.2384 166.349C57.8898 167.001 58.7732 167.366 59.6944 167.366C60.6156 167.366 61.499 167.001 62.1504 166.349C62.8017 165.698 63.1677 164.814 63.1677 163.893C63.1677 162.972 62.8017 162.089 62.1504 161.437C61.499 160.786 60.6156 160.42 59.6944 160.42C58.7732 160.42 57.8898 160.786 57.2384 161.437C56.587 162.089 56.2211 162.972 56.2211 163.893ZM63.1677 163.893C63.1677 164.814 63.5336 165.698 64.185 166.349C64.8363 167.001 65.7198 167.366 66.641 167.366C67.5621 167.366 68.4456 167.001 69.097 166.349C69.7483 165.698 70.1143 164.814 70.1143 163.893C70.1143 162.972 69.7483 162.089 69.097 161.437C68.4456 160.786 67.5621 160.42 66.641 160.42C65.7198 160.42 64.8363 160.786 64.185 161.437C63.5336 162.089 63.1677 162.972 63.1677 163.893ZM90.954 163.893C90.954 164.814 91.32 165.698 91.9713 166.349C92.6227 167.001 93.5061 167.366 94.4273 167.366C95.3485 167.366 96.2319 167.001 96.8833 166.349C97.5347 165.698 97.9006 164.814 97.9006 163.893C97.9006 162.972 97.5347 162.089 96.8833 161.437C96.2319 160.786 95.3485 160.42 94.4273 160.42C93.5061 160.42 92.6227 160.786 91.9713 161.437C91.32 162.089 90.954 162.972 90.954 163.893ZM104.847 163.893C104.847 164.814 105.213 165.698 105.865 166.349C106.516 167.001 107.399 167.366 108.321 167.366C109.242 167.366 110.125 167.001 110.776 166.349C111.428 165.698 111.794 164.814 111.794 163.893C111.794 162.972 111.428 162.089 110.776 161.437C110.125 160.786 109.242 160.42 108.321 160.42C107.399 160.42 106.516 160.786 105.865 161.437C105.213 162.089 104.847 162.972 104.847 163.893ZM125.687 163.893C125.687 164.814 126.053 165.698 126.704 166.349C127.356 167.001 128.239 167.366 129.16 167.366C130.081 167.366 130.965 167.001 131.616 166.349C132.268 165.698 132.634 164.814 132.634 163.893C132.634 162.972 132.268 162.089 131.616 161.437C130.965 160.786 130.081 160.42 129.16 160.42C128.239 160.42 127.356 160.786 126.704 161.437C126.053 162.089 125.687 162.972 125.687 163.893ZM132.634 163.893C132.634 164.814 132.999 165.698 133.651 166.349C134.302 167.001 135.186 167.366 136.107 167.366C137.028 167.366 137.911 167.001 138.563 166.349C139.214 165.698 139.58 164.814 139.58 163.893C139.58 162.972 139.214 162.089 138.563 161.437C137.911 160.786 137.028 160.42 136.107 160.42C135.186 160.42 134.302 160.786 133.651 161.437C132.999 162.089 132.634 162.972 132.634 163.893ZM139.58 163.893C139.58 164.814 139.946 165.698 140.597 166.349C141.249 167.001 142.132 167.366 143.053 167.366C143.975 167.366 144.858 167.001 145.509 166.349C146.161 165.698 146.527 164.814 146.527 163.893C146.527 162.972 146.161 162.089 145.509 161.437C144.858 160.786 143.975 160.42 143.053 160.42C142.132 160.42 141.249 160.786 140.597 161.437C139.946 162.089 139.58 162.972 139.58 163.893ZM146.527 163.893C146.527 164.814 146.893 165.698 147.544 166.349C148.195 167.001 149.079 167.366 150 167.366C150.921 167.366 151.805 167.001 152.456 166.349C153.107 165.698 153.473 164.814 153.473 163.893C153.473 162.972 153.107 162.089 152.456 161.437C151.805 160.786 150.921 160.42 150 160.42C149.079 160.42 148.195 160.786 147.544 161.437C146.893 162.089 146.527 162.972 146.527 163.893ZM174.313 163.893C174.313 164.814 174.679 165.698 175.33 166.349C175.982 167.001 176.865 167.366 177.786 167.366C178.708 167.366 179.591 167.001 180.242 166.349C180.894 165.698 181.26 164.814 181.26 163.893C181.26 162.972 180.894 162.089 180.242 161.437C179.591 160.786 178.708 160.42 177.786 160.42C176.865 160.42 175.982 160.786 175.33 161.437C174.679 162.089 174.313 162.972 174.313 163.893ZM195.153 163.893C195.153 164.349 195.243 164.801 195.417 165.222C195.592 165.644 195.848 166.027 196.17 166.349C196.493 166.672 196.876 166.928 197.297 167.102C197.718 167.277 198.17 167.366 198.626 167.366C199.082 167.366 199.534 167.277 199.955 167.102C200.377 166.928 200.76 166.672 201.082 166.349C201.405 166.027 201.661 165.644 201.835 165.222C202.01 164.801 202.099 164.349 202.099 163.893C202.099 163.437 202.01 162.985 201.835 162.564C201.661 162.143 201.405 161.76 201.082 161.437C200.76 161.115 200.377 160.859 199.955 160.684C199.534 160.51 199.082 160.42 198.626 160.42C198.17 160.42 197.718 160.51 197.297 160.684C196.876 160.859 196.493 161.115 196.17 161.437C195.848 161.76 195.592 162.143 195.417 162.564C195.243 162.985 195.153 163.437 195.153 163.893ZM215.993 163.893C215.993 164.814 216.359 165.698 217.01 166.349C217.661 167.001 218.545 167.366 219.466 167.366C220.387 167.366 221.271 167.001 221.922 166.349C222.573 165.698 222.939 164.814 222.939 163.893C222.939 162.972 222.573 162.089 221.922 161.437C221.271 160.786 220.387 160.42 219.466 160.42C218.545 160.42 217.661 160.786 217.01 161.437C216.359 162.089 215.993 162.972 215.993 163.893ZM236.832 163.893C236.832 164.814 237.198 165.698 237.85 166.349C238.501 167.001 239.384 167.366 240.306 167.366C241.227 167.366 242.11 167.001 242.762 166.349C243.413 165.698 243.779 164.814 243.779 163.893C243.779 162.972 243.413 162.089 242.762 161.437C242.11 160.786 241.227 160.42 240.306 160.42C239.384 160.42 238.501 160.786 237.85 161.437C237.198 162.089 236.832 162.972 236.832 163.893ZM243.779 163.893C243.779 164.814 244.145 165.698 244.796 166.349C245.448 167.001 246.331 167.366 247.252 167.366C248.173 167.366 249.057 167.001 249.708 166.349C250.36 165.698 250.726 164.814 250.726 163.893C250.726 162.972 250.36 162.089 249.708 161.437C249.057 160.786 248.173 160.42 247.252 160.42C246.331 160.42 245.448 160.786 244.796 161.437C244.145 162.089 243.779 162.972 243.779 163.893ZM264.619 163.893C264.619 164.814 264.985 165.698 265.636 166.349C266.287 167.001 267.171 167.366 268.092 167.366C269.013 167.366 269.897 167.001 270.548 166.349C271.199 165.698 271.565 164.814 271.565 163.893C271.565 162.972 271.199 162.089 270.548 161.437C269.897 160.786 269.013 160.42 268.092 160.42C267.171 160.42 266.287 160.786 265.636 161.437C264.985 162.089 264.619 162.972 264.619 163.893ZM285.458 163.893C285.458 164.814 285.824 165.698 286.476 166.349C287.127 167.001 288.011 167.366 288.932 167.366C289.853 167.366 290.736 167.001 291.388 166.349C292.039 165.698 292.405 164.814 292.405 163.893C292.405 162.972 292.039 162.089 291.388 161.437C290.736 160.786 289.853 160.42 288.932 160.42C288.011 160.42 287.127 160.786 286.476 161.437C285.824 162.089 285.458 162.972 285.458 163.893ZM7.59497 170.84C7.59497 171.761 7.96091 172.644 8.61227 173.296C9.26364 173.947 10.1471 174.313 11.0683 174.313C11.9894 174.313 12.8729 173.947 13.5243 173.296C14.1756 172.644 14.5416 171.761 14.5416 170.84C14.5416 169.919 14.1756 169.035 13.5243 168.384C12.8729 167.732 11.9894 167.366 11.0683 167.366C10.1471 167.366 9.26364 167.732 8.61227 168.384C7.96091 169.035 7.59497 169.919 7.59497 170.84ZM21.4881 170.84C21.4881 171.761 21.8541 172.644 22.5055 173.296C23.1568 173.947 24.0403 174.313 24.9614 174.313C25.8826 174.313 26.7661 173.947 27.4174 173.296C28.0688 172.644 28.4347 171.761 28.4347 170.84C28.4347 169.919 28.0688 169.035 27.4174 168.384C26.7661 167.732 25.8826 167.366 24.9614 167.366C24.0403 167.366 23.1568 167.732 22.5055 168.384C21.8541 169.035 21.4881 169.919 21.4881 170.84ZM35.3813 170.84C35.3813 171.761 35.7473 172.644 36.3986 173.296C37.05 173.947 37.9334 174.313 38.8546 174.313C39.7758 174.313 40.6592 173.947 41.3106 173.296C41.962 172.644 42.3279 171.761 42.3279 170.84C42.3279 169.919 41.962 169.035 41.3106 168.384C40.6592 167.732 39.7758 167.366 38.8546 167.366C37.9334 167.366 37.05 167.732 36.3986 168.384C35.7473 169.035 35.3813 169.919 35.3813 170.84ZM56.2211 170.84C56.2211 171.761 56.587 172.644 57.2384 173.296C57.8898 173.947 58.7732 174.313 59.6944 174.313C60.6156 174.313 61.499 173.947 62.1504 173.296C62.8017 172.644 63.1677 171.761 63.1677 170.84C63.1677 169.919 62.8017 169.035 62.1504 168.384C61.499 167.732 60.6156 167.366 59.6944 167.366C58.7732 167.366 57.8898 167.732 57.2384 168.384C56.587 169.035 56.2211 169.919 56.2211 170.84ZM84.0074 170.84C84.0074 171.761 84.3734 172.644 85.0247 173.296C85.6761 173.947 86.5596 174.313 87.4807 174.313C88.4019 174.313 89.2854 173.947 89.9367 173.296C90.5881 172.644 90.954 171.761 90.954 170.84C90.954 169.919 90.5881 169.035 89.9367 168.384C89.2854 167.732 88.4019 167.366 87.4807 167.366C86.5596 167.366 85.6761 167.732 85.0247 168.384C84.3734 169.035 84.0074 169.919 84.0074 170.84ZM111.794 170.84C111.794 171.761 112.16 172.644 112.811 173.296C113.462 173.947 114.346 174.313 115.267 174.313C116.188 174.313 117.072 173.947 117.723 173.296C118.374 172.644 118.74 171.761 118.74 170.84C118.74 169.919 118.374 169.035 117.723 168.384C117.072 167.732 116.188 167.366 115.267 167.366C114.346 167.366 113.462 167.732 112.811 168.384C112.16 169.035 111.794 169.919 111.794 170.84ZM125.687 170.84C125.687 171.761 126.053 172.644 126.704 173.296C127.356 173.947 128.239 174.313 129.16 174.313C130.081 174.313 130.965 173.947 131.616 173.296C132.268 172.644 132.634 171.761 132.634 170.84C132.634 169.919 132.268 169.035 131.616 168.384C130.965 167.732 130.081 167.366 129.16 167.366C128.239 167.366 127.356 167.732 126.704 168.384C126.053 169.035 125.687 169.919 125.687 170.84ZM139.58 170.84C139.58 171.761 139.946 172.644 140.597 173.296C141.249 173.947 142.132 174.313 143.053 174.313C143.975 174.313 144.858 173.947 145.509 173.296C146.161 172.644 146.527 171.761 146.527 170.84C146.527 169.919 146.161 169.035 145.509 168.384C144.858 167.732 143.975 167.366 143.053 167.366C142.132 167.366 141.249 167.732 140.597 168.384C139.946 169.035 139.58 169.919 139.58 170.84ZM160.42 170.84C160.42 171.761 160.786 172.644 161.437 173.296C162.089 173.947 162.972 174.313 163.893 174.313C164.814 174.313 165.698 173.947 166.349 173.296C167.001 172.644 167.366 171.761 167.366 170.84C167.366 169.919 167.001 169.035 166.349 168.384C165.698 167.732 164.814 167.366 163.893 167.366C162.972 167.366 162.089 167.732 161.437 168.384C160.786 169.035 160.42 169.919 160.42 170.84ZM181.26 170.84C181.26 171.761 181.626 172.644 182.277 173.296C182.928 173.947 183.812 174.313 184.733 174.313C185.654 174.313 186.538 173.947 187.189 173.296C187.84 172.644 188.206 171.761 188.206 170.84C188.206 169.919 187.84 169.035 187.189 168.384C186.538 167.732 185.654 167.366 184.733 167.366C183.812 167.366 182.928 167.732 182.277 168.384C181.626 169.035 181.26 169.919 181.26 170.84ZM188.206 170.84C188.206 171.761 188.572 172.644 189.224 173.296C189.875 173.947 190.758 174.313 191.68 174.313C192.601 174.313 193.484 173.947 194.136 173.296C194.787 172.644 195.153 171.761 195.153 170.84C195.153 169.919 194.787 169.035 194.136 168.384C193.484 167.732 192.601 167.366 191.68 167.366C190.758 167.366 189.875 167.732 189.224 168.384C188.572 169.035 188.206 169.919 188.206 170.84ZM195.153 170.84C195.153 171.296 195.243 171.748 195.417 172.169C195.592 172.59 195.848 172.973 196.17 173.296C196.493 173.618 196.876 173.874 197.297 174.049C197.718 174.223 198.17 174.313 198.626 174.313C199.082 174.313 199.534 174.223 199.955 174.049C200.377 173.874 200.76 173.618 201.082 173.296C201.405 172.973 201.661 172.59 201.835 172.169C202.01 171.748 202.099 171.296 202.099 170.84C202.099 170.384 202.01 169.932 201.835 169.511C201.661 169.089 201.405 168.706 201.082 168.384C200.76 168.061 200.377 167.805 199.955 167.631C199.534 167.456 199.082 167.366 198.626 167.366C198.17 167.366 197.718 167.456 197.297 167.631C196.876 167.805 196.493 168.061 196.17 168.384C195.848 168.706 195.592 169.089 195.417 169.511C195.243 169.932 195.153 170.384 195.153 170.84ZM202.099 170.84C202.099 171.761 202.465 172.644 203.117 173.296C203.768 173.947 204.652 174.313 205.573 174.313C206.494 174.313 207.377 173.947 208.029 173.296C208.68 172.644 209.046 171.761 209.046 170.84C209.046 169.919 208.68 169.035 208.029 168.384C207.377 167.732 206.494 167.366 205.573 167.366C204.652 167.366 203.768 167.732 203.117 168.384C202.465 169.035 202.099 169.919 202.099 170.84ZM209.046 170.84C209.046 171.761 209.412 172.644 210.063 173.296C210.715 173.947 211.598 174.313 212.519 174.313C213.44 174.313 214.324 173.947 214.975 173.296C215.627 172.644 215.993 171.761 215.993 170.84C215.993 169.919 215.627 169.035 214.975 168.384C214.324 167.732 213.44 167.366 212.519 167.366C211.598 167.366 210.715 167.732 210.063 168.384C209.412 169.035 209.046 169.919 209.046 170.84ZM222.939 170.84C222.939 171.761 223.305 172.644 223.957 173.296C224.608 173.947 225.491 174.313 226.413 174.313C227.334 174.313 228.217 173.947 228.868 173.296C229.52 172.644 229.886 171.761 229.886 170.84C229.886 169.919 229.52 169.035 228.868 168.384C228.217 167.732 227.334 167.366 226.413 167.366C225.491 167.366 224.608 167.732 223.957 168.384C223.305 169.035 222.939 169.919 222.939 170.84ZM229.886 170.84C229.886 171.761 230.252 172.644 230.903 173.296C231.554 173.947 232.438 174.313 233.359 174.313C234.28 174.313 235.164 173.947 235.815 173.296C236.466 172.644 236.832 171.761 236.832 170.84C236.832 169.919 236.466 169.035 235.815 168.384C235.164 167.732 234.28 167.366 233.359 167.366C232.438 167.366 231.554 167.732 230.903 168.384C230.252 169.035 229.886 169.919 229.886 170.84ZM243.779 170.84C243.779 171.761 244.145 172.644 244.796 173.296C245.448 173.947 246.331 174.313 247.252 174.313C248.173 174.313 249.057 173.947 249.708 173.296C250.36 172.644 250.726 171.761 250.726 170.84C250.726 169.919 250.36 169.035 249.708 168.384C249.057 167.732 248.173 167.366 247.252 167.366C246.331 167.366 245.448 167.732 244.796 168.384C244.145 169.035 243.779 169.919 243.779 170.84ZM250.726 170.84C250.726 171.761 251.091 172.644 251.743 173.296C252.394 173.947 253.278 174.313 254.199 174.313C255.12 174.313 256.003 173.947 256.655 173.296C257.306 172.644 257.672 171.761 257.672 170.84C257.672 169.919 257.306 169.035 256.655 168.384C256.003 167.732 255.12 167.366 254.199 167.366C253.278 167.366 252.394 167.732 251.743 168.384C251.091 169.035 250.726 169.919 250.726 170.84ZM278.512 170.84C278.512 171.761 278.878 172.644 279.529 173.296C280.181 173.947 281.064 174.313 281.985 174.313C282.906 174.313 283.79 173.947 284.441 173.296C285.093 172.644 285.458 171.761 285.458 170.84C285.458 169.919 285.093 169.035 284.441 168.384C283.79 167.732 282.906 167.366 281.985 167.366C281.064 167.366 280.181 167.732 279.529 168.384C278.878 169.035 278.512 169.919 278.512 170.84ZM14.5416 177.786C14.5416 178.708 14.9075 179.591 15.5589 180.242C16.2102 180.894 17.0937 181.26 18.0149 181.26C18.936 181.26 19.8195 180.894 20.4708 180.242C21.1222 179.591 21.4881 178.708 21.4881 177.786C21.4881 176.865 21.1222 175.982 20.4708 175.33C19.8195 174.679 18.936 174.313 18.0149 174.313C17.0937 174.313 16.2102 174.679 15.5589 175.33C14.9075 175.982 14.5416 176.865 14.5416 177.786ZM21.4881 177.786C21.4881 178.708 21.8541 179.591 22.5055 180.242C23.1568 180.894 24.0403 181.26 24.9614 181.26C25.8826 181.26 26.7661 180.894 27.4174 180.242C28.0688 179.591 28.4347 178.708 28.4347 177.786C28.4347 176.865 28.0688 175.982 27.4174 175.33C26.7661 174.679 25.8826 174.313 24.9614 174.313C24.0403 174.313 23.1568 174.679 22.5055 175.33C21.8541 175.982 21.4881 176.865 21.4881 177.786ZM42.3279 177.786C42.3279 178.242 42.4177 178.694 42.5923 179.116C42.7668 179.537 43.0227 179.92 43.3452 180.242C43.6677 180.565 44.0506 180.821 44.472 180.995C44.8934 181.17 45.3451 181.26 45.8012 181.26C46.2573 181.26 46.709 181.17 47.1304 180.995C47.5518 180.821 47.9347 180.565 48.2572 180.242C48.5797 179.92 48.8356 179.537 49.0101 179.116C49.1847 178.694 49.2745 178.242 49.2745 177.786C49.2745 177.33 49.1847 176.879 49.0101 176.457C48.8356 176.036 48.5797 175.653 48.2572 175.33C47.9347 175.008 47.5518 174.752 47.1304 174.577C46.709 174.403 46.2573 174.313 45.8012 174.313C45.3451 174.313 44.8934 174.403 44.472 174.577C44.0506 174.752 43.6677 175.008 43.3452 175.33C43.0227 175.653 42.7668 176.036 42.5923 176.457C42.4177 176.879 42.3279 177.33 42.3279 177.786ZM49.2745 177.786C49.2745 178.242 49.3643 178.694 49.5389 179.116C49.7134 179.537 49.9693 179.92 50.2918 180.242C50.6143 180.565 50.9972 180.821 51.4186 180.995C51.84 181.17 52.2917 181.26 52.7478 181.26C53.2039 181.26 53.6556 181.17 54.077 180.995C54.4984 180.821 54.8813 180.565 55.2038 180.242C55.5263 179.92 55.7821 179.537 55.9567 179.116C56.1312 178.694 56.2211 178.242 56.2211 177.786C56.2211 177.33 56.1312 176.879 55.9567 176.457C55.7821 176.036 55.5263 175.653 55.2038 175.33C54.8813 175.008 54.4984 174.752 54.077 174.577C53.6556 174.403 53.2039 174.313 52.7478 174.313C52.2917 174.313 51.84 174.403 51.4186 174.577C50.9972 174.752 50.6143 175.008 50.2918 175.33C49.9693 175.653 49.7134 176.036 49.5389 176.457C49.3643 176.879 49.2745 177.33 49.2745 177.786ZM63.1677 177.786C63.1677 178.708 63.5336 179.591 64.185 180.242C64.8363 180.894 65.7198 181.26 66.641 181.26C67.5621 181.26 68.4456 180.894 69.097 180.242C69.7483 179.591 70.1143 178.708 70.1143 177.786C70.1143 176.865 69.7483 175.982 69.097 175.33C68.4456 174.679 67.5621 174.313 66.641 174.313C65.7198 174.313 64.8363 174.679 64.185 175.33C63.5336 175.982 63.1677 176.865 63.1677 177.786ZM77.0609 177.786C77.0609 178.242 77.1507 178.694 77.3252 179.116C77.4998 179.537 77.7556 179.92 78.0782 180.242C78.4007 180.565 78.7836 180.821 79.205 180.995C79.6264 181.17 80.078 181.26 80.5341 181.26C80.9903 181.26 81.4419 181.17 81.8633 180.995C82.2847 180.821 82.6676 180.565 82.9901 180.242C83.3127 179.92 83.5685 179.537 83.743 179.116C83.9176 178.694 84.0074 178.242 84.0074 177.786C84.0074 177.33 83.9176 176.879 83.743 176.457C83.5685 176.036 83.3127 175.653 82.9901 175.33C82.6676 175.008 82.2847 174.752 81.8633 174.577C81.4419 174.403 80.9903 174.313 80.5341 174.313C80.078 174.313 79.6264 174.403 79.205 174.577C78.7836 174.752 78.4007 175.008 78.0782 175.33C77.7556 175.653 77.4998 176.036 77.3252 176.457C77.1507 176.879 77.0609 177.33 77.0609 177.786ZM90.954 177.786C90.954 178.708 91.32 179.591 91.9713 180.242C92.6227 180.894 93.5061 181.26 94.4273 181.26C95.3485 181.26 96.2319 180.894 96.8833 180.242C97.5347 179.591 97.9006 178.708 97.9006 177.786C97.9006 176.865 97.5347 175.982 96.8833 175.33C96.2319 174.679 95.3485 174.313 94.4273 174.313C93.5061 174.313 92.6227 174.679 91.9713 175.33C91.32 175.982 90.954 176.865 90.954 177.786ZM97.9006 177.786C97.9006 178.242 97.9905 178.694 98.165 179.116C98.3396 179.537 98.5954 179.92 98.9179 180.242C99.2404 180.565 99.6233 180.821 100.045 180.995C100.466 181.17 100.918 181.26 101.374 181.26C101.83 181.26 102.282 181.17 102.703 180.995C103.124 180.821 103.507 180.565 103.83 180.242C104.152 179.92 104.408 179.537 104.583 179.116C104.757 178.694 104.847 178.242 104.847 177.786C104.847 177.33 104.757 176.879 104.583 176.457C104.408 176.036 104.152 175.653 103.83 175.33C103.507 175.008 103.124 174.752 102.703 174.577C102.282 174.403 101.83 174.313 101.374 174.313C100.918 174.313 100.466 174.403 100.045 174.577C99.6233 174.752 99.2404 175.008 98.9179 175.33C98.5954 175.653 98.3396 176.036 98.165 176.457C97.9905 176.879 97.9006 177.33 97.9006 177.786ZM118.74 177.786C118.74 178.708 119.106 179.591 119.758 180.242C120.409 180.894 121.292 181.26 122.214 181.26C123.135 181.26 124.018 180.894 124.67 180.242C125.321 179.591 125.687 178.708 125.687 177.786C125.687 176.865 125.321 175.982 124.67 175.33C124.018 174.679 123.135 174.313 122.214 174.313C121.292 174.313 120.409 174.679 119.758 175.33C119.106 175.982 118.74 176.865 118.74 177.786ZM125.687 177.786C125.687 178.708 126.053 179.591 126.704 180.242C127.356 180.894 128.239 181.26 129.16 181.26C130.081 181.26 130.965 180.894 131.616 180.242C132.268 179.591 132.634 178.708 132.634 177.786C132.634 176.865 132.268 175.982 131.616 175.33C130.965 174.679 130.081 174.313 129.16 174.313C128.239 174.313 127.356 174.679 126.704 175.33C126.053 175.982 125.687 176.865 125.687 177.786ZM132.634 177.786C132.634 178.708 132.999 179.591 133.651 180.242C134.302 180.894 135.186 181.26 136.107 181.26C137.028 181.26 137.911 180.894 138.563 180.242C139.214 179.591 139.58 178.708 139.58 177.786C139.58 176.865 139.214 175.982 138.563 175.33C137.911 174.679 137.028 174.313 136.107 174.313C135.186 174.313 134.302 174.679 133.651 175.33C132.999 175.982 132.634 176.865 132.634 177.786ZM139.58 177.786C139.58 178.708 139.946 179.591 140.597 180.242C141.249 180.894 142.132 181.26 143.053 181.26C143.975 181.26 144.858 180.894 145.509 180.242C146.161 179.591 146.527 178.708 146.527 177.786C146.527 176.865 146.161 175.982 145.509 175.33C144.858 174.679 143.975 174.313 143.053 174.313C142.132 174.313 141.249 174.679 140.597 175.33C139.946 175.982 139.58 176.865 139.58 177.786ZM174.313 177.786C174.313 178.708 174.679 179.591 175.33 180.242C175.982 180.894 176.865 181.26 177.786 181.26C178.708 181.26 179.591 180.894 180.242 180.242C180.894 179.591 181.26 178.708 181.26 177.786C181.26 176.865 180.894 175.982 180.242 175.33C179.591 174.679 178.708 174.313 177.786 174.313C176.865 174.313 175.982 174.679 175.33 175.33C174.679 175.982 174.313 176.865 174.313 177.786ZM181.26 177.786C181.26 178.708 181.626 179.591 182.277 180.242C182.928 180.894 183.812 181.26 184.733 181.26C185.654 181.26 186.538 180.894 187.189 180.242C187.84 179.591 188.206 178.708 188.206 177.786C188.206 176.865 187.84 175.982 187.189 175.33C186.538 174.679 185.654 174.313 184.733 174.313C183.812 174.313 182.928 174.679 182.277 175.33C181.626 175.982 181.26 176.865 181.26 177.786ZM188.206 177.786C188.206 178.708 188.572 179.591 189.224 180.242C189.875 180.894 190.758 181.26 191.68 181.26C192.601 181.26 193.484 180.894 194.136 180.242C194.787 179.591 195.153 178.708 195.153 177.786C195.153 176.865 194.787 175.982 194.136 175.33C193.484 174.679 192.601 174.313 191.68 174.313C190.758 174.313 189.875 174.679 189.224 175.33C188.572 175.982 188.206 176.865 188.206 177.786ZM195.153 177.786C195.153 178.242 195.243 178.694 195.417 179.116C195.592 179.537 195.848 179.92 196.17 180.242C196.493 180.565 196.876 180.821 197.297 180.995C197.718 181.17 198.17 181.26 198.626 181.26C199.082 181.26 199.534 181.17 199.955 180.995C200.377 180.821 200.76 180.565 201.082 180.242C201.405 179.92 201.661 179.537 201.835 179.116C202.01 178.694 202.099 178.242 202.099 177.786C202.099 177.33 202.01 176.879 201.835 176.457C201.661 176.036 201.405 175.653 201.082 175.33C200.76 175.008 200.377 174.752 199.955 174.577C199.534 174.403 199.082 174.313 198.626 174.313C198.17 174.313 197.718 174.403 197.297 174.577C196.876 174.752 196.493 175.008 196.17 175.33C195.848 175.653 195.592 176.036 195.417 176.457C195.243 176.879 195.153 177.33 195.153 177.786ZM202.099 177.786C202.099 178.708 202.465 179.591 203.117 180.242C203.768 180.894 204.652 181.26 205.573 181.26C206.494 181.26 207.377 180.894 208.029 180.242C208.68 179.591 209.046 178.708 209.046 177.786C209.046 176.865 208.68 175.982 208.029 175.33C207.377 174.679 206.494 174.313 205.573 174.313C204.652 174.313 203.768 174.679 203.117 175.33C202.465 175.982 202.099 176.865 202.099 177.786ZM209.046 177.786C209.046 178.708 209.412 179.591 210.063 180.242C210.715 180.894 211.598 181.26 212.519 181.26C213.44 181.26 214.324 180.894 214.975 180.242C215.627 179.591 215.993 178.708 215.993 177.786C215.993 176.865 215.627 175.982 214.975 175.33C214.324 174.679 213.44 174.313 212.519 174.313C211.598 174.313 210.715 174.679 210.063 175.33C209.412 175.982 209.046 176.865 209.046 177.786ZM229.886 177.786C229.886 178.708 230.252 179.591 230.903 180.242C231.554 180.894 232.438 181.26 233.359 181.26C234.28 181.26 235.164 180.894 235.815 180.242C236.466 179.591 236.832 178.708 236.832 177.786C236.832 176.865 236.466 175.982 235.815 175.33C235.164 174.679 234.28 174.313 233.359 174.313C232.438 174.313 231.554 174.679 230.903 175.33C230.252 175.982 229.886 176.865 229.886 177.786ZM250.726 177.786C250.726 178.708 251.091 179.591 251.743 180.242C252.394 180.894 253.278 181.26 254.199 181.26C255.12 181.26 256.003 180.894 256.655 180.242C257.306 179.591 257.672 178.708 257.672 177.786C257.672 176.865 257.306 175.982 256.655 175.33C256.003 174.679 255.12 174.313 254.199 174.313C253.278 174.313 252.394 174.679 251.743 175.33C251.091 175.982 250.726 176.865 250.726 177.786ZM264.619 177.786C264.619 178.708 264.985 179.591 265.636 180.242C266.287 180.894 267.171 181.26 268.092 181.26C269.013 181.26 269.897 180.894 270.548 180.242C271.199 179.591 271.565 178.708 271.565 177.786C271.565 176.865 271.199 175.982 270.548 175.33C269.897 174.679 269.013 174.313 268.092 174.313C267.171 174.313 266.287 174.679 265.636 175.33C264.985 175.982 264.619 176.865 264.619 177.786ZM271.565 177.786C271.565 178.708 271.931 179.591 272.583 180.242C273.234 180.894 274.117 181.26 275.039 181.26C275.96 181.26 276.843 180.894 277.495 180.242C278.146 179.591 278.512 178.708 278.512 177.786C278.512 176.865 278.146 175.982 277.495 175.33C276.843 174.679 275.96 174.313 275.039 174.313C274.117 174.313 273.234 174.679 272.583 175.33C271.931 175.982 271.565 176.865 271.565 177.786ZM278.512 177.786C278.512 178.708 278.878 179.591 279.529 180.242C280.181 180.894 281.064 181.26 281.985 181.26C282.906 181.26 283.79 180.894 284.441 180.242C285.093 179.591 285.458 178.708 285.458 177.786C285.458 176.865 285.093 175.982 284.441 175.33C283.79 174.679 282.906 174.313 281.985 174.313C281.064 174.313 280.181 174.679 279.529 175.33C278.878 175.982 278.512 176.865 278.512 177.786ZM285.458 177.786C285.458 178.708 285.824 179.591 286.476 180.242C287.127 180.894 288.011 181.26 288.932 181.26C289.853 181.26 290.736 180.894 291.388 180.242C292.039 179.591 292.405 178.708 292.405 177.786C292.405 176.865 292.039 175.982 291.388 175.33C290.736 174.679 289.853 174.313 288.932 174.313C288.011 174.313 287.127 174.679 286.476 175.33C285.824 175.982 285.458 176.865 285.458 177.786ZM7.59497 184.733C7.59497 185.654 7.96091 186.538 8.61227 187.189C9.26364 187.84 10.1471 188.206 11.0683 188.206C11.9894 188.206 12.8729 187.84 13.5243 187.189C14.1756 186.538 14.5416 185.654 14.5416 184.733C14.5416 183.812 14.1756 182.928 13.5243 182.277C12.8729 181.626 11.9894 181.26 11.0683 181.26C10.1471 181.26 9.26364 181.626 8.61227 182.277C7.96091 182.928 7.59497 183.812 7.59497 184.733ZM28.4347 184.733C28.4347 185.654 28.8007 186.538 29.452 187.189C30.1034 187.84 30.9869 188.206 31.908 188.206C32.8292 188.206 33.7126 187.84 34.364 187.189C35.0154 186.538 35.3813 185.654 35.3813 184.733C35.3813 183.812 35.0154 182.928 34.364 182.277C33.7126 181.626 32.8292 181.26 31.908 181.26C30.9869 181.26 30.1034 181.626 29.452 182.277C28.8007 182.928 28.4347 183.812 28.4347 184.733ZM35.3813 184.733C35.3813 185.654 35.7473 186.538 36.3986 187.189C37.05 187.84 37.9334 188.206 38.8546 188.206C39.7758 188.206 40.6592 187.84 41.3106 187.189C41.962 186.538 42.3279 185.654 42.3279 184.733C42.3279 183.812 41.962 182.928 41.3106 182.277C40.6592 181.626 39.7758 181.26 38.8546 181.26C37.9334 181.26 37.05 181.626 36.3986 182.277C35.7473 182.928 35.3813 183.812 35.3813 184.733ZM42.3279 184.733C42.3279 185.189 42.4177 185.641 42.5923 186.062C42.7668 186.484 43.0227 186.866 43.3452 187.189C43.6677 187.511 44.0506 187.767 44.472 187.942C44.8934 188.116 45.3451 188.206 45.8012 188.206C46.2573 188.206 46.709 188.116 47.1304 187.942C47.5518 187.767 47.9347 187.511 48.2572 187.189C48.5797 186.866 48.8356 186.484 49.0101 186.062C49.1847 185.641 49.2745 185.189 49.2745 184.733C49.2745 184.277 49.1847 183.825 49.0101 183.404C48.8356 182.982 48.5797 182.599 48.2572 182.277C47.9347 181.954 47.5518 181.699 47.1304 181.524C46.709 181.349 46.2573 181.26 45.8012 181.26C45.3451 181.26 44.8934 181.349 44.472 181.524C44.0506 181.699 43.6677 181.954 43.3452 182.277C43.0227 182.599 42.7668 182.982 42.5923 183.404C42.4177 183.825 42.3279 184.277 42.3279 184.733ZM56.2211 184.733C56.2211 185.654 56.587 186.538 57.2384 187.189C57.8898 187.84 58.7732 188.206 59.6944 188.206C60.6156 188.206 61.499 187.84 62.1504 187.189C62.8017 186.538 63.1677 185.654 63.1677 184.733C63.1677 183.812 62.8017 182.928 62.1504 182.277C61.499 181.626 60.6156 181.26 59.6944 181.26C58.7732 181.26 57.8898 181.626 57.2384 182.277C56.587 182.928 56.2211 183.812 56.2211 184.733ZM77.0609 184.733C77.0609 185.189 77.1507 185.641 77.3252 186.062C77.4998 186.484 77.7556 186.866 78.0782 187.189C78.4007 187.511 78.7836 187.767 79.205 187.942C79.6264 188.116 80.078 188.206 80.5341 188.206C80.9903 188.206 81.4419 188.116 81.8633 187.942C82.2847 187.767 82.6676 187.511 82.9901 187.189C83.3127 186.866 83.5685 186.484 83.743 186.062C83.9176 185.641 84.0074 185.189 84.0074 184.733C84.0074 184.277 83.9176 183.825 83.743 183.404C83.5685 182.982 83.3127 182.599 82.9901 182.277C82.6676 181.954 82.2847 181.699 81.8633 181.524C81.4419 181.349 80.9903 181.26 80.5341 181.26C80.078 181.26 79.6264 181.349 79.205 181.524C78.7836 181.699 78.4007 181.954 78.0782 182.277C77.7556 182.599 77.4998 182.982 77.3252 183.404C77.1507 183.825 77.0609 184.277 77.0609 184.733ZM84.0074 184.733C84.0074 185.654 84.3734 186.538 85.0247 187.189C85.6761 187.84 86.5596 188.206 87.4807 188.206C88.4019 188.206 89.2854 187.84 89.9367 187.189C90.5881 186.538 90.954 185.654 90.954 184.733C90.954 183.812 90.5881 182.928 89.9367 182.277C89.2854 181.626 88.4019 181.26 87.4807 181.26C86.5596 181.26 85.6761 181.626 85.0247 182.277C84.3734 182.928 84.0074 183.812 84.0074 184.733ZM125.687 184.733C125.687 185.654 126.053 186.538 126.704 187.189C127.356 187.84 128.239 188.206 129.16 188.206C130.081 188.206 130.965 187.84 131.616 187.189C132.268 186.538 132.634 185.654 132.634 184.733C132.634 183.812 132.268 182.928 131.616 182.277C130.965 181.626 130.081 181.26 129.16 181.26C128.239 181.26 127.356 181.626 126.704 182.277C126.053 182.928 125.687 183.812 125.687 184.733ZM132.634 184.733C132.634 185.654 132.999 186.538 133.651 187.189C134.302 187.84 135.186 188.206 136.107 188.206C137.028 188.206 137.911 187.84 138.563 187.189C139.214 186.538 139.58 185.654 139.58 184.733C139.58 183.812 139.214 182.928 138.563 182.277C137.911 181.626 137.028 181.26 136.107 181.26C135.186 181.26 134.302 181.626 133.651 182.277C132.999 182.928 132.634 183.812 132.634 184.733ZM146.527 184.733C146.527 185.654 146.893 186.538 147.544 187.189C148.195 187.84 149.079 188.206 150 188.206C150.921 188.206 151.805 187.84 152.456 187.189C153.107 186.538 153.473 185.654 153.473 184.733C153.473 183.812 153.107 182.928 152.456 182.277C151.805 181.626 150.921 181.26 150 181.26C149.079 181.26 148.195 181.626 147.544 182.277C146.893 182.928 146.527 183.812 146.527 184.733ZM174.313 184.733C174.313 185.654 174.679 186.538 175.33 187.189C175.982 187.84 176.865 188.206 177.786 188.206C178.708 188.206 179.591 187.84 180.242 187.189C180.894 186.538 181.26 185.654 181.26 184.733C181.26 183.812 180.894 182.928 180.242 182.277C179.591 181.626 178.708 181.26 177.786 181.26C176.865 181.26 175.982 181.626 175.33 182.277C174.679 182.928 174.313 183.812 174.313 184.733ZM195.153 184.733C195.153 185.189 195.243 185.641 195.417 186.062C195.592 186.484 195.848 186.866 196.17 187.189C196.493 187.511 196.876 187.767 197.297 187.942C197.718 188.116 198.17 188.206 198.626 188.206C199.082 188.206 199.534 188.116 199.955 187.942C200.377 187.767 200.76 187.511 201.082 187.189C201.405 186.866 201.661 186.484 201.835 186.062C202.01 185.641 202.099 185.189 202.099 184.733C202.099 184.277 202.01 183.825 201.835 183.404C201.661 182.982 201.405 182.599 201.082 182.277C200.76 181.954 200.377 181.699 199.955 181.524C199.534 181.349 199.082 181.26 198.626 181.26C198.17 181.26 197.718 181.349 197.297 181.524C196.876 181.699 196.493 181.954 196.17 182.277C195.848 182.599 195.592 182.982 195.417 183.404C195.243 183.825 195.153 184.277 195.153 184.733ZM202.099 184.733C202.099 185.654 202.465 186.538 203.117 187.189C203.768 187.84 204.652 188.206 205.573 188.206C206.494 188.206 207.377 187.84 208.029 187.189C208.68 186.538 209.046 185.654 209.046 184.733C209.046 183.812 208.68 182.928 208.029 182.277C207.377 181.626 206.494 181.26 205.573 181.26C204.652 181.26 203.768 181.626 203.117 182.277C202.465 182.928 202.099 183.812 202.099 184.733ZM215.993 184.733C215.993 185.654 216.359 186.538 217.01 187.189C217.661 187.84 218.545 188.206 219.466 188.206C220.387 188.206 221.271 187.84 221.922 187.189C222.573 186.538 222.939 185.654 222.939 184.733C222.939 183.812 222.573 182.928 221.922 182.277C221.271 181.626 220.387 181.26 219.466 181.26C218.545 181.26 217.661 181.626 217.01 182.277C216.359 182.928 215.993 183.812 215.993 184.733ZM229.886 184.733C229.886 185.654 230.252 186.538 230.903 187.189C231.554 187.84 232.438 188.206 233.359 188.206C234.28 188.206 235.164 187.84 235.815 187.189C236.466 186.538 236.832 185.654 236.832 184.733C236.832 183.812 236.466 182.928 235.815 182.277C235.164 181.626 234.28 181.26 233.359 181.26C232.438 181.26 231.554 181.626 230.903 182.277C230.252 182.928 229.886 183.812 229.886 184.733ZM236.832 184.733C236.832 185.654 237.198 186.538 237.85 187.189C238.501 187.84 239.384 188.206 240.306 188.206C241.227 188.206 242.11 187.84 242.762 187.189C243.413 186.538 243.779 185.654 243.779 184.733C243.779 183.812 243.413 182.928 242.762 182.277C242.11 181.626 241.227 181.26 240.306 181.26C239.384 181.26 238.501 181.626 237.85 182.277C237.198 182.928 236.832 183.812 236.832 184.733ZM243.779 184.733C243.779 185.654 244.145 186.538 244.796 187.189C245.448 187.84 246.331 188.206 247.252 188.206C248.173 188.206 249.057 187.84 249.708 187.189C250.36 186.538 250.726 185.654 250.726 184.733C250.726 183.812 250.36 182.928 249.708 182.277C249.057 181.626 248.173 181.26 247.252 181.26C246.331 181.26 245.448 181.626 244.796 182.277C244.145 182.928 243.779 183.812 243.779 184.733ZM257.672 184.733C257.672 185.654 258.038 186.538 258.689 187.189C259.341 187.84 260.224 188.206 261.145 188.206C262.067 188.206 262.95 187.84 263.601 187.189C264.253 186.538 264.619 185.654 264.619 184.733C264.619 183.812 264.253 182.928 263.601 182.277C262.95 181.626 262.067 181.26 261.145 181.26C260.224 181.26 259.341 181.626 258.689 182.277C258.038 182.928 257.672 183.812 257.672 184.733ZM271.565 184.733C271.565 185.654 271.931 186.538 272.583 187.189C273.234 187.84 274.117 188.206 275.039 188.206C275.96 188.206 276.843 187.84 277.495 187.189C278.146 186.538 278.512 185.654 278.512 184.733C278.512 183.812 278.146 182.928 277.495 182.277C276.843 181.626 275.96 181.26 275.039 181.26C274.117 181.26 273.234 181.626 272.583 182.277C271.931 182.928 271.565 183.812 271.565 184.733ZM285.458 184.733C285.458 185.654 285.824 186.538 286.476 187.189C287.127 187.84 288.011 188.206 288.932 188.206C289.853 188.206 290.736 187.84 291.388 187.189C292.039 186.538 292.405 185.654 292.405 184.733C292.405 183.812 292.039 182.928 291.388 182.277C290.736 181.626 289.853 181.26 288.932 181.26C288.011 181.26 287.127 181.626 286.476 182.277C285.824 182.928 285.458 183.812 285.458 184.733ZM7.59497 191.68C7.59497 192.601 7.96091 193.484 8.61227 194.136C9.26364 194.787 10.1471 195.153 11.0683 195.153C11.9894 195.153 12.8729 194.787 13.5243 194.136C14.1756 193.484 14.5416 192.601 14.5416 191.68C14.5416 190.758 14.1756 189.875 13.5243 189.224C12.8729 188.572 11.9894 188.206 11.0683 188.206C10.1471 188.206 9.26364 188.572 8.61227 189.224C7.96091 189.875 7.59497 190.758 7.59497 191.68ZM14.5416 191.68C14.5416 192.601 14.9075 193.484 15.5589 194.136C16.2102 194.787 17.0937 195.153 18.0149 195.153C18.936 195.153 19.8195 194.787 20.4708 194.136C21.1222 193.484 21.4881 192.601 21.4881 191.68C21.4881 190.758 21.1222 189.875 20.4708 189.224C19.8195 188.572 18.936 188.206 18.0149 188.206C17.0937 188.206 16.2102 188.572 15.5589 189.224C14.9075 189.875 14.5416 190.758 14.5416 191.68ZM21.4881 191.68C21.4881 192.601 21.8541 193.484 22.5055 194.136C23.1568 194.787 24.0403 195.153 24.9614 195.153C25.8826 195.153 26.7661 194.787 27.4174 194.136C28.0688 193.484 28.4347 192.601 28.4347 191.68C28.4347 190.758 28.0688 189.875 27.4174 189.224C26.7661 188.572 25.8826 188.206 24.9614 188.206C24.0403 188.206 23.1568 188.572 22.5055 189.224C21.8541 189.875 21.4881 190.758 21.4881 191.68ZM28.4347 191.68C28.4347 192.601 28.8007 193.484 29.452 194.136C30.1034 194.787 30.9869 195.153 31.908 195.153C32.8292 195.153 33.7126 194.787 34.364 194.136C35.0154 193.484 35.3813 192.601 35.3813 191.68C35.3813 190.758 35.0154 189.875 34.364 189.224C33.7126 188.572 32.8292 188.206 31.908 188.206C30.9869 188.206 30.1034 188.572 29.452 189.224C28.8007 189.875 28.4347 190.758 28.4347 191.68ZM42.3279 191.68C42.3279 192.136 42.4177 192.587 42.5923 193.009C42.7668 193.43 43.0227 193.813 43.3452 194.136C43.6677 194.458 44.0506 194.714 44.472 194.888C44.8934 195.063 45.3451 195.153 45.8012 195.153C46.2573 195.153 46.709 195.063 47.1304 194.888C47.5518 194.714 47.9347 194.458 48.2572 194.136C48.5797 193.813 48.8356 193.43 49.0101 193.009C49.1847 192.587 49.2745 192.136 49.2745 191.68C49.2745 191.223 49.1847 190.772 49.0101 190.35C48.8356 189.929 48.5797 189.546 48.2572 189.224C47.9347 188.901 47.5518 188.645 47.1304 188.471C46.709 188.296 46.2573 188.206 45.8012 188.206C45.3451 188.206 44.8934 188.296 44.472 188.471C44.0506 188.645 43.6677 188.901 43.3452 189.224C43.0227 189.546 42.7668 189.929 42.5923 190.35C42.4177 190.772 42.3279 191.223 42.3279 191.68ZM49.2745 191.68C49.2745 192.136 49.3643 192.587 49.5389 193.009C49.7134 193.43 49.9693 193.813 50.2918 194.136C50.6143 194.458 50.9972 194.714 51.4186 194.888C51.84 195.063 52.2917 195.153 52.7478 195.153C53.2039 195.153 53.6556 195.063 54.077 194.888C54.4984 194.714 54.8813 194.458 55.2038 194.136C55.5263 193.813 55.7821 193.43 55.9567 193.009C56.1312 192.587 56.2211 192.136 56.2211 191.68C56.2211 191.223 56.1312 190.772 55.9567 190.35C55.7821 189.929 55.5263 189.546 55.2038 189.224C54.8813 188.901 54.4984 188.645 54.077 188.471C53.6556 188.296 53.2039 188.206 52.7478 188.206C52.2917 188.206 51.84 188.296 51.4186 188.471C50.9972 188.645 50.6143 188.901 50.2918 189.224C49.9693 189.546 49.7134 189.929 49.5389 190.35C49.3643 190.772 49.2745 191.223 49.2745 191.68ZM56.2211 191.68C56.2211 192.601 56.587 193.484 57.2384 194.136C57.8898 194.787 58.7732 195.153 59.6944 195.153C60.6156 195.153 61.499 194.787 62.1504 194.136C62.8017 193.484 63.1677 192.601 63.1677 191.68C63.1677 190.758 62.8017 189.875 62.1504 189.224C61.499 188.572 60.6156 188.206 59.6944 188.206C58.7732 188.206 57.8898 188.572 57.2384 189.224C56.587 189.875 56.2211 190.758 56.2211 191.68ZM77.0609 191.68C77.0609 192.136 77.1507 192.587 77.3252 193.009C77.4998 193.43 77.7556 193.813 78.0782 194.136C78.4007 194.458 78.7836 194.714 79.205 194.888C79.6264 195.063 80.078 195.153 80.5341 195.153C80.9903 195.153 81.4419 195.063 81.8633 194.888C82.2847 194.714 82.6676 194.458 82.9901 194.136C83.3127 193.813 83.5685 193.43 83.743 193.009C83.9176 192.587 84.0074 192.136 84.0074 191.68C84.0074 191.223 83.9176 190.772 83.743 190.35C83.5685 189.929 83.3127 189.546 82.9901 189.224C82.6676 188.901 82.2847 188.645 81.8633 188.471C81.4419 188.296 80.9903 188.206 80.5341 188.206C80.078 188.206 79.6264 188.296 79.205 188.471C78.7836 188.645 78.4007 188.901 78.0782 189.224C77.7556 189.546 77.4998 189.929 77.3252 190.35C77.1507 190.772 77.0609 191.223 77.0609 191.68ZM84.0074 191.68C84.0074 192.601 84.3734 193.484 85.0247 194.136C85.6761 194.787 86.5596 195.153 87.4807 195.153C88.4019 195.153 89.2854 194.787 89.9367 194.136C90.5881 193.484 90.954 192.601 90.954 191.68C90.954 190.758 90.5881 189.875 89.9367 189.224C89.2854 188.572 88.4019 188.206 87.4807 188.206C86.5596 188.206 85.6761 188.572 85.0247 189.224C84.3734 189.875 84.0074 190.758 84.0074 191.68ZM90.954 191.68C90.954 192.601 91.32 193.484 91.9713 194.136C92.6227 194.787 93.5061 195.153 94.4273 195.153C95.3485 195.153 96.2319 194.787 96.8833 194.136C97.5347 193.484 97.9006 192.601 97.9006 191.68C97.9006 190.758 97.5347 189.875 96.8833 189.224C96.2319 188.572 95.3485 188.206 94.4273 188.206C93.5061 188.206 92.6227 188.572 91.9713 189.224C91.32 189.875 90.954 190.758 90.954 191.68ZM97.9006 191.68C97.9006 192.136 97.9905 192.587 98.165 193.009C98.3396 193.43 98.5954 193.813 98.9179 194.136C99.2404 194.458 99.6233 194.714 100.045 194.888C100.466 195.063 100.918 195.153 101.374 195.153C101.83 195.153 102.282 195.063 102.703 194.888C103.124 194.714 103.507 194.458 103.83 194.136C104.152 193.813 104.408 193.43 104.583 193.009C104.757 192.587 104.847 192.136 104.847 191.68C104.847 191.223 104.757 190.772 104.583 190.35C104.408 189.929 104.152 189.546 103.83 189.224C103.507 188.901 103.124 188.645 102.703 188.471C102.282 188.296 101.83 188.206 101.374 188.206C100.918 188.206 100.466 188.296 100.045 188.471C99.6233 188.645 99.2404 188.901 98.9179 189.224C98.5954 189.546 98.3396 189.929 98.165 190.35C97.9905 190.772 97.9006 191.223 97.9006 191.68ZM104.847 191.68C104.847 192.601 105.213 193.484 105.865 194.136C106.516 194.787 107.399 195.153 108.321 195.153C109.242 195.153 110.125 194.787 110.776 194.136C111.428 193.484 111.794 192.601 111.794 191.68C111.794 190.758 111.428 189.875 110.776 189.224C110.125 188.572 109.242 188.206 108.321 188.206C107.399 188.206 106.516 188.572 105.865 189.224C105.213 189.875 104.847 190.758 104.847 191.68ZM111.794 191.68C111.794 192.601 112.16 193.484 112.811 194.136C113.462 194.787 114.346 195.153 115.267 195.153C116.188 195.153 117.072 194.787 117.723 194.136C118.374 193.484 118.74 192.601 118.74 191.68C118.74 190.758 118.374 189.875 117.723 189.224C117.072 188.572 116.188 188.206 115.267 188.206C114.346 188.206 113.462 188.572 112.811 189.224C112.16 189.875 111.794 190.758 111.794 191.68ZM118.74 191.68C118.74 192.601 119.106 193.484 119.758 194.136C120.409 194.787 121.292 195.153 122.214 195.153C123.135 195.153 124.018 194.787 124.67 194.136C125.321 193.484 125.687 192.601 125.687 191.68C125.687 190.758 125.321 189.875 124.67 189.224C124.018 188.572 123.135 188.206 122.214 188.206C121.292 188.206 120.409 188.572 119.758 189.224C119.106 189.875 118.74 190.758 118.74 191.68ZM125.687 191.68C125.687 192.601 126.053 193.484 126.704 194.136C127.356 194.787 128.239 195.153 129.16 195.153C130.081 195.153 130.965 194.787 131.616 194.136C132.268 193.484 132.634 192.601 132.634 191.68C132.634 190.758 132.268 189.875 131.616 189.224C130.965 188.572 130.081 188.206 129.16 188.206C128.239 188.206 127.356 188.572 126.704 189.224C126.053 189.875 125.687 190.758 125.687 191.68ZM146.527 191.68C146.527 192.601 146.893 193.484 147.544 194.136C148.195 194.787 149.079 195.153 150 195.153C150.921 195.153 151.805 194.787 152.456 194.136C153.107 193.484 153.473 192.601 153.473 191.68C153.473 190.758 153.107 189.875 152.456 189.224C151.805 188.572 150.921 188.206 150 188.206C149.079 188.206 148.195 188.572 147.544 189.224C146.893 189.875 146.527 190.758 146.527 191.68ZM153.473 191.68C153.473 192.136 153.563 192.587 153.738 193.009C153.912 193.43 154.168 193.813 154.491 194.136C154.813 194.458 155.196 194.714 155.617 194.888C156.039 195.063 156.491 195.153 156.947 195.153C157.403 195.153 157.854 195.063 158.276 194.888C158.697 194.714 159.08 194.458 159.403 194.136C159.725 193.813 159.981 193.43 160.156 193.009C160.33 192.587 160.42 192.136 160.42 191.68C160.42 191.223 160.33 190.772 160.156 190.35C159.981 189.929 159.725 189.546 159.403 189.224C159.08 188.901 158.697 188.645 158.276 188.471C157.854 188.296 157.403 188.206 156.947 188.206C156.491 188.206 156.039 188.296 155.617 188.471C155.196 188.645 154.813 188.901 154.491 189.224C154.168 189.546 153.912 189.929 153.738 190.35C153.563 190.772 153.473 191.223 153.473 191.68ZM160.42 191.68C160.42 192.601 160.786 193.484 161.437 194.136C162.089 194.787 162.972 195.153 163.893 195.153C164.814 195.153 165.698 194.787 166.349 194.136C167.001 193.484 167.366 192.601 167.366 191.68C167.366 190.758 167.001 189.875 166.349 189.224C165.698 188.572 164.814 188.206 163.893 188.206C162.972 188.206 162.089 188.572 161.437 189.224C160.786 189.875 160.42 190.758 160.42 191.68ZM167.366 191.68C167.366 192.601 167.732 193.484 168.384 194.136C169.035 194.787 169.919 195.153 170.84 195.153C171.761 195.153 172.644 194.787 173.296 194.136C173.947 193.484 174.313 192.601 174.313 191.68C174.313 190.758 173.947 189.875 173.296 189.224C172.644 188.572 171.761 188.206 170.84 188.206C169.919 188.206 169.035 188.572 168.384 189.224C167.732 189.875 167.366 190.758 167.366 191.68ZM188.206 191.68C188.206 192.601 188.572 193.484 189.224 194.136C189.875 194.787 190.758 195.153 191.68 195.153C192.601 195.153 193.484 194.787 194.136 194.136C194.787 193.484 195.153 192.601 195.153 191.68C195.153 190.758 194.787 189.875 194.136 189.224C193.484 188.572 192.601 188.206 191.68 188.206C190.758 188.206 189.875 188.572 189.224 189.224C188.572 189.875 188.206 190.758 188.206 191.68ZM195.153 191.68C195.153 192.136 195.243 192.587 195.417 193.009C195.592 193.43 195.848 193.813 196.17 194.136C196.493 194.458 196.876 194.714 197.297 194.888C197.718 195.063 198.17 195.153 198.626 195.153C199.082 195.153 199.534 195.063 199.955 194.888C200.377 194.714 200.76 194.458 201.082 194.136C201.405 193.813 201.661 193.43 201.835 193.009C202.01 192.587 202.099 192.136 202.099 191.68C202.099 191.223 202.01 190.772 201.835 190.35C201.661 189.929 201.405 189.546 201.082 189.224C200.76 188.901 200.377 188.645 199.955 188.471C199.534 188.296 199.082 188.206 198.626 188.206C198.17 188.206 197.718 188.296 197.297 188.471C196.876 188.645 196.493 188.901 196.17 189.224C195.848 189.546 195.592 189.929 195.417 190.35C195.243 190.772 195.153 191.223 195.153 191.68ZM209.046 191.68C209.046 192.601 209.412 193.484 210.063 194.136C210.715 194.787 211.598 195.153 212.519 195.153C213.44 195.153 214.324 194.787 214.975 194.136C215.627 193.484 215.993 192.601 215.993 191.68C215.993 190.758 215.627 189.875 214.975 189.224C214.324 188.572 213.44 188.206 212.519 188.206C211.598 188.206 210.715 188.572 210.063 189.224C209.412 189.875 209.046 190.758 209.046 191.68ZM215.993 191.68C215.993 192.601 216.359 193.484 217.01 194.136C217.661 194.787 218.545 195.153 219.466 195.153C220.387 195.153 221.271 194.787 221.922 194.136C222.573 193.484 222.939 192.601 222.939 191.68C222.939 190.758 222.573 189.875 221.922 189.224C221.271 188.572 220.387 188.206 219.466 188.206C218.545 188.206 217.661 188.572 217.01 189.224C216.359 189.875 215.993 190.758 215.993 191.68ZM229.886 191.68C229.886 192.601 230.252 193.484 230.903 194.136C231.554 194.787 232.438 195.153 233.359 195.153C234.28 195.153 235.164 194.787 235.815 194.136C236.466 193.484 236.832 192.601 236.832 191.68C236.832 190.758 236.466 189.875 235.815 189.224C235.164 188.572 234.28 188.206 233.359 188.206C232.438 188.206 231.554 188.572 230.903 189.224C230.252 189.875 229.886 190.758 229.886 191.68ZM236.832 191.68C236.832 192.601 237.198 193.484 237.85 194.136C238.501 194.787 239.384 195.153 240.306 195.153C241.227 195.153 242.11 194.787 242.762 194.136C243.413 193.484 243.779 192.601 243.779 191.68C243.779 190.758 243.413 189.875 242.762 189.224C242.11 188.572 241.227 188.206 240.306 188.206C239.384 188.206 238.501 188.572 237.85 189.224C237.198 189.875 236.832 190.758 236.832 191.68ZM243.779 191.68C243.779 192.601 244.145 193.484 244.796 194.136C245.448 194.787 246.331 195.153 247.252 195.153C248.173 195.153 249.057 194.787 249.708 194.136C250.36 193.484 250.726 192.601 250.726 191.68C250.726 190.758 250.36 189.875 249.708 189.224C249.057 188.572 248.173 188.206 247.252 188.206C246.331 188.206 245.448 188.572 244.796 189.224C244.145 189.875 243.779 190.758 243.779 191.68ZM257.672 191.68C257.672 192.601 258.038 193.484 258.689 194.136C259.341 194.787 260.224 195.153 261.145 195.153C262.067 195.153 262.95 194.787 263.601 194.136C264.253 193.484 264.619 192.601 264.619 191.68C264.619 190.758 264.253 189.875 263.601 189.224C262.95 188.572 262.067 188.206 261.145 188.206C260.224 188.206 259.341 188.572 258.689 189.224C258.038 189.875 257.672 190.758 257.672 191.68ZM285.458 191.68C285.458 192.601 285.824 193.484 286.476 194.136C287.127 194.787 288.011 195.153 288.932 195.153C289.853 195.153 290.736 194.787 291.388 194.136C292.039 193.484 292.405 192.601 292.405 191.68C292.405 190.758 292.039 189.875 291.388 189.224C290.736 188.572 289.853 188.206 288.932 188.206C288.011 188.206 287.127 188.572 286.476 189.224C285.824 189.875 285.458 190.758 285.458 191.68ZM7.59497 198.626C7.59497 199.547 7.96091 200.431 8.61227 201.082C9.26364 201.733 10.1471 202.099 11.0683 202.099C11.9894 202.099 12.8729 201.733 13.5243 201.082C14.1756 200.431 14.5416 199.547 14.5416 198.626C14.5416 197.705 14.1756 196.821 13.5243 196.17C12.8729 195.519 11.9894 195.153 11.0683 195.153C10.1471 195.153 9.26364 195.519 8.61227 196.17C7.96091 196.821 7.59497 197.705 7.59497 198.626ZM14.5416 198.626C14.5416 199.547 14.9075 200.431 15.5589 201.082C16.2102 201.733 17.0937 202.099 18.0149 202.099C18.936 202.099 19.8195 201.733 20.4708 201.082C21.1222 200.431 21.4881 199.547 21.4881 198.626C21.4881 197.705 21.1222 196.821 20.4708 196.17C19.8195 195.519 18.936 195.153 18.0149 195.153C17.0937 195.153 16.2102 195.519 15.5589 196.17C14.9075 196.821 14.5416 197.705 14.5416 198.626ZM21.4881 198.626C21.4881 199.547 21.8541 200.431 22.5055 201.082C23.1568 201.733 24.0403 202.099 24.9614 202.099C25.8826 202.099 26.7661 201.733 27.4174 201.082C28.0688 200.431 28.4347 199.547 28.4347 198.626C28.4347 197.705 28.0688 196.821 27.4174 196.17C26.7661 195.519 25.8826 195.153 24.9614 195.153C24.0403 195.153 23.1568 195.519 22.5055 196.17C21.8541 196.821 21.4881 197.705 21.4881 198.626ZM42.3279 198.626C42.3279 199.082 42.4177 199.534 42.5923 199.955C42.7668 200.377 43.0227 200.76 43.3452 201.082C43.6677 201.405 44.0506 201.66 44.472 201.835C44.8934 202.01 45.3451 202.099 45.8012 202.099C46.2573 202.099 46.709 202.01 47.1304 201.835C47.5518 201.66 47.9347 201.405 48.2572 201.082C48.5797 200.76 48.8356 200.377 49.0101 199.955C49.1847 199.534 49.2745 199.082 49.2745 198.626C49.2745 198.17 49.1847 197.718 49.0101 197.297C48.8356 196.876 48.5797 196.493 48.2572 196.17C47.9347 195.848 47.5518 195.592 47.1304 195.417C46.709 195.243 46.2573 195.153 45.8012 195.153C45.3451 195.153 44.8934 195.243 44.472 195.417C44.0506 195.592 43.6677 195.848 43.3452 196.17C43.0227 196.493 42.7668 196.876 42.5923 197.297C42.4177 197.718 42.3279 198.17 42.3279 198.626ZM56.2211 198.626C56.2211 199.547 56.587 200.431 57.2384 201.082C57.8898 201.733 58.7732 202.099 59.6944 202.099C60.6156 202.099 61.499 201.733 62.1504 201.082C62.8017 200.431 63.1677 199.547 63.1677 198.626C63.1677 197.705 62.8017 196.821 62.1504 196.17C61.499 195.519 60.6156 195.153 59.6944 195.153C58.7732 195.153 57.8898 195.519 57.2384 196.17C56.587 196.821 56.2211 197.705 56.2211 198.626ZM70.1143 198.626C70.1143 199.547 70.4802 200.431 71.1316 201.082C71.7829 201.733 72.6664 202.099 73.5876 202.099C74.5087 202.099 75.3922 201.733 76.0436 201.082C76.6949 200.431 77.0609 199.547 77.0609 198.626C77.0609 197.705 76.6949 196.821 76.0436 196.17C75.3922 195.519 74.5087 195.153 73.5876 195.153C72.6664 195.153 71.7829 195.519 71.1316 196.17C70.4802 196.821 70.1143 197.705 70.1143 198.626ZM77.0609 198.626C77.0609 199.082 77.1507 199.534 77.3252 199.955C77.4998 200.377 77.7556 200.76 78.0782 201.082C78.4007 201.405 78.7836 201.66 79.205 201.835C79.6264 202.01 80.078 202.099 80.5341 202.099C80.9903 202.099 81.4419 202.01 81.8633 201.835C82.2847 201.66 82.6676 201.405 82.9901 201.082C83.3127 200.76 83.5685 200.377 83.743 199.955C83.9176 199.534 84.0074 199.082 84.0074 198.626C84.0074 198.17 83.9176 197.718 83.743 197.297C83.5685 196.876 83.3127 196.493 82.9901 196.17C82.6676 195.848 82.2847 195.592 81.8633 195.417C81.4419 195.243 80.9903 195.153 80.5341 195.153C80.078 195.153 79.6264 195.243 79.205 195.417C78.7836 195.592 78.4007 195.848 78.0782 196.17C77.7556 196.493 77.4998 196.876 77.3252 197.297C77.1507 197.718 77.0609 198.17 77.0609 198.626ZM84.0074 198.626C84.0074 199.547 84.3734 200.431 85.0247 201.082C85.6761 201.733 86.5596 202.099 87.4807 202.099C88.4019 202.099 89.2854 201.733 89.9367 201.082C90.5881 200.431 90.954 199.547 90.954 198.626C90.954 197.705 90.5881 196.821 89.9367 196.17C89.2854 195.519 88.4019 195.153 87.4807 195.153C86.5596 195.153 85.6761 195.519 85.0247 196.17C84.3734 196.821 84.0074 197.705 84.0074 198.626ZM111.794 198.626C111.794 199.547 112.16 200.431 112.811 201.082C113.462 201.733 114.346 202.099 115.267 202.099C116.188 202.099 117.072 201.733 117.723 201.082C118.374 200.431 118.74 199.547 118.74 198.626C118.74 197.705 118.374 196.821 117.723 196.17C117.072 195.519 116.188 195.153 115.267 195.153C114.346 195.153 113.462 195.519 112.811 196.17C112.16 196.821 111.794 197.705 111.794 198.626ZM160.42 198.626C160.42 199.547 160.786 200.431 161.437 201.082C162.089 201.733 162.972 202.099 163.893 202.099C164.814 202.099 165.698 201.733 166.349 201.082C167.001 200.431 167.366 199.547 167.366 198.626C167.366 197.705 167.001 196.821 166.349 196.17C165.698 195.519 164.814 195.153 163.893 195.153C162.972 195.153 162.089 195.519 161.437 196.17C160.786 196.821 160.42 197.705 160.42 198.626ZM181.26 198.626C181.26 199.547 181.626 200.431 182.277 201.082C182.928 201.733 183.812 202.099 184.733 202.099C185.654 202.099 186.538 201.733 187.189 201.082C187.84 200.431 188.206 199.547 188.206 198.626C188.206 197.705 187.84 196.821 187.189 196.17C186.538 195.519 185.654 195.153 184.733 195.153C183.812 195.153 182.928 195.519 182.277 196.17C181.626 196.821 181.26 197.705 181.26 198.626ZM188.206 198.626C188.206 199.547 188.572 200.431 189.224 201.082C189.875 201.733 190.758 202.099 191.68 202.099C192.601 202.099 193.484 201.733 194.136 201.082C194.787 200.431 195.153 199.547 195.153 198.626C195.153 197.705 194.787 196.821 194.136 196.17C193.484 195.519 192.601 195.153 191.68 195.153C190.758 195.153 189.875 195.519 189.224 196.17C188.572 196.821 188.206 197.705 188.206 198.626ZM202.099 198.626C202.099 199.547 202.465 200.431 203.117 201.082C203.768 201.733 204.652 202.099 205.573 202.099C206.494 202.099 207.377 201.733 208.029 201.082C208.68 200.431 209.046 199.547 209.046 198.626C209.046 197.705 208.68 196.821 208.029 196.17C207.377 195.519 206.494 195.153 205.573 195.153C204.652 195.153 203.768 195.519 203.117 196.17C202.465 196.821 202.099 197.705 202.099 198.626ZM209.046 198.626C209.046 199.547 209.412 200.431 210.063 201.082C210.715 201.733 211.598 202.099 212.519 202.099C213.44 202.099 214.324 201.733 214.975 201.082C215.627 200.431 215.993 199.547 215.993 198.626C215.993 197.705 215.627 196.821 214.975 196.17C214.324 195.519 213.44 195.153 212.519 195.153C211.598 195.153 210.715 195.519 210.063 196.17C209.412 196.821 209.046 197.705 209.046 198.626ZM215.993 198.626C215.993 199.547 216.359 200.431 217.01 201.082C217.661 201.733 218.545 202.099 219.466 202.099C220.387 202.099 221.271 201.733 221.922 201.082C222.573 200.431 222.939 199.547 222.939 198.626C222.939 197.705 222.573 196.821 221.922 196.17C221.271 195.519 220.387 195.153 219.466 195.153C218.545 195.153 217.661 195.519 217.01 196.17C216.359 196.821 215.993 197.705 215.993 198.626ZM222.939 198.626C222.939 199.547 223.305 200.431 223.957 201.082C224.608 201.733 225.491 202.099 226.413 202.099C227.334 202.099 228.217 201.733 228.868 201.082C229.52 200.431 229.886 199.547 229.886 198.626C229.886 197.705 229.52 196.821 228.868 196.17C228.217 195.519 227.334 195.153 226.413 195.153C225.491 195.153 224.608 195.519 223.957 196.17C223.305 196.821 222.939 197.705 222.939 198.626ZM229.886 198.626C229.886 199.547 230.252 200.431 230.903 201.082C231.554 201.733 232.438 202.099 233.359 202.099C234.28 202.099 235.164 201.733 235.815 201.082C236.466 200.431 236.832 199.547 236.832 198.626C236.832 197.705 236.466 196.821 235.815 196.17C235.164 195.519 234.28 195.153 233.359 195.153C232.438 195.153 231.554 195.519 230.903 196.17C230.252 196.821 229.886 197.705 229.886 198.626ZM243.779 198.626C243.779 199.547 244.145 200.431 244.796 201.082C245.448 201.733 246.331 202.099 247.252 202.099C248.173 202.099 249.057 201.733 249.708 201.082C250.36 200.431 250.726 199.547 250.726 198.626C250.726 197.705 250.36 196.821 249.708 196.17C249.057 195.519 248.173 195.153 247.252 195.153C246.331 195.153 245.448 195.519 244.796 196.17C244.145 196.821 243.779 197.705 243.779 198.626ZM257.672 198.626C257.672 199.547 258.038 200.431 258.689 201.082C259.341 201.733 260.224 202.099 261.145 202.099C262.067 202.099 262.95 201.733 263.601 201.082C264.253 200.431 264.619 199.547 264.619 198.626C264.619 197.705 264.253 196.821 263.601 196.17C262.95 195.519 262.067 195.153 261.145 195.153C260.224 195.153 259.341 195.519 258.689 196.17C258.038 196.821 257.672 197.705 257.672 198.626ZM264.619 198.626C264.619 199.547 264.985 200.431 265.636 201.082C266.287 201.733 267.171 202.099 268.092 202.099C269.013 202.099 269.897 201.733 270.548 201.082C271.199 200.431 271.565 199.547 271.565 198.626C271.565 197.705 271.199 196.821 270.548 196.17C269.897 195.519 269.013 195.153 268.092 195.153C267.171 195.153 266.287 195.519 265.636 196.17C264.985 196.821 264.619 197.705 264.619 198.626ZM14.5416 205.573C14.5416 206.494 14.9075 207.377 15.5589 208.029C16.2102 208.68 17.0937 209.046 18.0149 209.046C18.936 209.046 19.8195 208.68 20.4708 208.029C21.1222 207.377 21.4881 206.494 21.4881 205.573C21.4881 204.652 21.1222 203.768 20.4708 203.117C19.8195 202.465 18.936 202.099 18.0149 202.099C17.0937 202.099 16.2102 202.465 15.5589 203.117C14.9075 203.768 14.5416 204.652 14.5416 205.573ZM28.4347 205.573C28.4347 206.494 28.8007 207.377 29.452 208.029C30.1034 208.68 30.9869 209.046 31.908 209.046C32.8292 209.046 33.7126 208.68 34.364 208.029C35.0154 207.377 35.3813 206.494 35.3813 205.573C35.3813 204.652 35.0154 203.768 34.364 203.117C33.7126 202.465 32.8292 202.099 31.908 202.099C30.9869 202.099 30.1034 202.465 29.452 203.117C28.8007 203.768 28.4347 204.652 28.4347 205.573ZM42.3279 205.573C42.3279 206.029 42.4177 206.48 42.5923 206.902C42.7668 207.323 43.0227 207.706 43.3452 208.029C43.6677 208.351 44.0506 208.607 44.472 208.782C44.8934 208.956 45.3451 209.046 45.8012 209.046C46.2573 209.046 46.709 208.956 47.1304 208.782C47.5518 208.607 47.9347 208.351 48.2572 208.029C48.5797 207.706 48.8356 207.323 49.0101 206.902C49.1847 206.48 49.2745 206.029 49.2745 205.573C49.2745 205.117 49.1847 204.665 49.0101 204.244C48.8356 203.822 48.5797 203.439 48.2572 203.117C47.9347 202.794 47.5518 202.538 47.1304 202.364C46.709 202.189 46.2573 202.099 45.8012 202.099C45.3451 202.099 44.8934 202.189 44.472 202.364C44.0506 202.538 43.6677 202.794 43.3452 203.117C43.0227 203.439 42.7668 203.822 42.5923 204.244C42.4177 204.665 42.3279 205.117 42.3279 205.573ZM49.2745 205.573C49.2745 206.029 49.3643 206.48 49.5389 206.902C49.7134 207.323 49.9693 207.706 50.2918 208.029C50.6143 208.351 50.9972 208.607 51.4186 208.782C51.84 208.956 52.2917 209.046 52.7478 209.046C53.2039 209.046 53.6556 208.956 54.077 208.782C54.4984 208.607 54.8813 208.351 55.2038 208.029C55.5263 207.706 55.7821 207.323 55.9567 206.902C56.1312 206.48 56.2211 206.029 56.2211 205.573C56.2211 205.117 56.1312 204.665 55.9567 204.244C55.7821 203.822 55.5263 203.439 55.2038 203.117C54.8813 202.794 54.4984 202.538 54.077 202.364C53.6556 202.189 53.2039 202.099 52.7478 202.099C52.2917 202.099 51.84 202.189 51.4186 202.364C50.9972 202.538 50.6143 202.794 50.2918 203.117C49.9693 203.439 49.7134 203.822 49.5389 204.244C49.3643 204.665 49.2745 205.117 49.2745 205.573ZM70.1143 205.573C70.1143 206.494 70.4802 207.377 71.1316 208.029C71.7829 208.68 72.6664 209.046 73.5876 209.046C74.5087 209.046 75.3922 208.68 76.0436 208.029C76.6949 207.377 77.0609 206.494 77.0609 205.573C77.0609 204.652 76.6949 203.768 76.0436 203.117C75.3922 202.465 74.5087 202.099 73.5876 202.099C72.6664 202.099 71.7829 202.465 71.1316 203.117C70.4802 203.768 70.1143 204.652 70.1143 205.573ZM90.954 205.573C90.954 206.494 91.32 207.377 91.9713 208.029C92.6227 208.68 93.5061 209.046 94.4273 209.046C95.3485 209.046 96.2319 208.68 96.8833 208.029C97.5347 207.377 97.9006 206.494 97.9006 205.573C97.9006 204.652 97.5347 203.768 96.8833 203.117C96.2319 202.465 95.3485 202.099 94.4273 202.099C93.5061 202.099 92.6227 202.465 91.9713 203.117C91.32 203.768 90.954 204.652 90.954 205.573ZM111.794 205.573C111.794 206.494 112.16 207.377 112.811 208.029C113.462 208.68 114.346 209.046 115.267 209.046C116.188 209.046 117.072 208.68 117.723 208.029C118.374 207.377 118.74 206.494 118.74 205.573C118.74 204.652 118.374 203.768 117.723 203.117C117.072 202.465 116.188 202.099 115.267 202.099C114.346 202.099 113.462 202.465 112.811 203.117C112.16 203.768 111.794 204.652 111.794 205.573ZM132.634 205.573C132.634 206.494 132.999 207.377 133.651 208.029C134.302 208.68 135.186 209.046 136.107 209.046C137.028 209.046 137.911 208.68 138.563 208.029C139.214 207.377 139.58 206.494 139.58 205.573C139.58 204.652 139.214 203.768 138.563 203.117C137.911 202.465 137.028 202.099 136.107 202.099C135.186 202.099 134.302 202.465 133.651 203.117C132.999 203.768 132.634 204.652 132.634 205.573ZM146.527 205.573C146.527 206.494 146.893 207.377 147.544 208.029C148.195 208.68 149.079 209.046 150 209.046C150.921 209.046 151.805 208.68 152.456 208.029C153.107 207.377 153.473 206.494 153.473 205.573C153.473 204.652 153.107 203.768 152.456 203.117C151.805 202.465 150.921 202.099 150 202.099C149.079 202.099 148.195 202.465 147.544 203.117C146.893 203.768 146.527 204.652 146.527 205.573ZM174.313 205.573C174.313 206.494 174.679 207.377 175.33 208.029C175.982 208.68 176.865 209.046 177.786 209.046C178.708 209.046 179.591 208.68 180.242 208.029C180.894 207.377 181.26 206.494 181.26 205.573C181.26 204.652 180.894 203.768 180.242 203.117C179.591 202.465 178.708 202.099 177.786 202.099C176.865 202.099 175.982 202.465 175.33 203.117C174.679 203.768 174.313 204.652 174.313 205.573ZM181.26 205.573C181.26 206.494 181.626 207.377 182.277 208.029C182.928 208.68 183.812 209.046 184.733 209.046C185.654 209.046 186.538 208.68 187.189 208.029C187.84 207.377 188.206 206.494 188.206 205.573C188.206 204.652 187.84 203.768 187.189 203.117C186.538 202.465 185.654 202.099 184.733 202.099C183.812 202.099 182.928 202.465 182.277 203.117C181.626 203.768 181.26 204.652 181.26 205.573ZM188.206 205.573C188.206 206.494 188.572 207.377 189.224 208.029C189.875 208.68 190.758 209.046 191.68 209.046C192.601 209.046 193.484 208.68 194.136 208.029C194.787 207.377 195.153 206.494 195.153 205.573C195.153 204.652 194.787 203.768 194.136 203.117C193.484 202.465 192.601 202.099 191.68 202.099C190.758 202.099 189.875 202.465 189.224 203.117C188.572 203.768 188.206 204.652 188.206 205.573ZM202.099 205.573C202.099 206.494 202.465 207.377 203.117 208.029C203.768 208.68 204.652 209.046 205.573 209.046C206.494 209.046 207.377 208.68 208.029 208.029C208.68 207.377 209.046 206.494 209.046 205.573C209.046 204.652 208.68 203.768 208.029 203.117C207.377 202.465 206.494 202.099 205.573 202.099C204.652 202.099 203.768 202.465 203.117 203.117C202.465 203.768 202.099 204.652 202.099 205.573ZM209.046 205.573C209.046 206.494 209.412 207.377 210.063 208.029C210.715 208.68 211.598 209.046 212.519 209.046C213.44 209.046 214.324 208.68 214.975 208.029C215.627 207.377 215.993 206.494 215.993 205.573C215.993 204.652 215.627 203.768 214.975 203.117C214.324 202.465 213.44 202.099 212.519 202.099C211.598 202.099 210.715 202.465 210.063 203.117C209.412 203.768 209.046 204.652 209.046 205.573ZM229.886 205.573C229.886 206.494 230.252 207.377 230.903 208.029C231.554 208.68 232.438 209.046 233.359 209.046C234.28 209.046 235.164 208.68 235.815 208.029C236.466 207.377 236.832 206.494 236.832 205.573C236.832 204.652 236.466 203.768 235.815 203.117C235.164 202.465 234.28 202.099 233.359 202.099C232.438 202.099 231.554 202.465 230.903 203.117C230.252 203.768 229.886 204.652 229.886 205.573ZM7.59497 212.519C7.59497 213.44 7.96091 214.324 8.61227 214.975C9.26364 215.627 10.1471 215.993 11.0683 215.993C11.9894 215.993 12.8729 215.627 13.5243 214.975C14.1756 214.324 14.5416 213.44 14.5416 212.519C14.5416 211.598 14.1756 210.715 13.5243 210.063C12.8729 209.412 11.9894 209.046 11.0683 209.046C10.1471 209.046 9.26364 209.412 8.61227 210.063C7.96091 210.715 7.59497 211.598 7.59497 212.519ZM14.5416 212.519C14.5416 213.44 14.9075 214.324 15.5589 214.975C16.2102 215.627 17.0937 215.993 18.0149 215.993C18.936 215.993 19.8195 215.627 20.4708 214.975C21.1222 214.324 21.4881 213.44 21.4881 212.519C21.4881 211.598 21.1222 210.715 20.4708 210.063C19.8195 209.412 18.936 209.046 18.0149 209.046C17.0937 209.046 16.2102 209.412 15.5589 210.063C14.9075 210.715 14.5416 211.598 14.5416 212.519ZM21.4881 212.519C21.4881 213.44 21.8541 214.324 22.5055 214.975C23.1568 215.627 24.0403 215.993 24.9614 215.993C25.8826 215.993 26.7661 215.627 27.4174 214.975C28.0688 214.324 28.4347 213.44 28.4347 212.519C28.4347 211.598 28.0688 210.715 27.4174 210.063C26.7661 209.412 25.8826 209.046 24.9614 209.046C24.0403 209.046 23.1568 209.412 22.5055 210.063C21.8541 210.715 21.4881 211.598 21.4881 212.519ZM35.3813 212.519C35.3813 213.44 35.7473 214.324 36.3986 214.975C37.05 215.627 37.9334 215.993 38.8546 215.993C39.7758 215.993 40.6592 215.627 41.3106 214.975C41.962 214.324 42.3279 213.44 42.3279 212.519C42.3279 211.598 41.962 210.715 41.3106 210.063C40.6592 209.412 39.7758 209.046 38.8546 209.046C37.9334 209.046 37.05 209.412 36.3986 210.063C35.7473 210.715 35.3813 211.598 35.3813 212.519ZM42.3279 212.519C42.3279 212.975 42.4177 213.427 42.5923 213.848C42.7668 214.27 43.0227 214.653 43.3452 214.975C43.6677 215.298 44.0506 215.554 44.472 215.728C44.8934 215.903 45.3451 215.993 45.8012 215.993C46.2573 215.993 46.709 215.903 47.1304 215.728C47.5518 215.554 47.9347 215.298 48.2572 214.975C48.5797 214.653 48.8356 214.27 49.0101 213.848C49.1847 213.427 49.2745 212.975 49.2745 212.519C49.2745 212.063 49.1847 211.612 49.0101 211.19C48.8356 210.769 48.5797 210.386 48.2572 210.063C47.9347 209.741 47.5518 209.485 47.1304 209.31C46.709 209.136 46.2573 209.046 45.8012 209.046C45.3451 209.046 44.8934 209.136 44.472 209.31C44.0506 209.485 43.6677 209.741 43.3452 210.063C43.0227 210.386 42.7668 210.769 42.5923 211.19C42.4177 211.612 42.3279 212.063 42.3279 212.519ZM70.1143 212.519C70.1143 213.44 70.4802 214.324 71.1316 214.975C71.7829 215.627 72.6664 215.993 73.5876 215.993C74.5087 215.993 75.3922 215.627 76.0436 214.975C76.6949 214.324 77.0609 213.44 77.0609 212.519C77.0609 211.598 76.6949 210.715 76.0436 210.063C75.3922 209.412 74.5087 209.046 73.5876 209.046C72.6664 209.046 71.7829 209.412 71.1316 210.063C70.4802 210.715 70.1143 211.598 70.1143 212.519ZM77.0609 212.519C77.0609 212.975 77.1507 213.427 77.3252 213.848C77.4998 214.27 77.7556 214.653 78.0782 214.975C78.4007 215.298 78.7836 215.554 79.205 215.728C79.6264 215.903 80.078 215.993 80.5341 215.993C80.9903 215.993 81.4419 215.903 81.8633 215.728C82.2847 215.554 82.6676 215.298 82.9901 214.975C83.3127 214.653 83.5685 214.27 83.743 213.848C83.9176 213.427 84.0074 212.975 84.0074 212.519C84.0074 212.063 83.9176 211.612 83.743 211.19C83.5685 210.769 83.3127 210.386 82.9901 210.063C82.6676 209.741 82.2847 209.485 81.8633 209.31C81.4419 209.136 80.9903 209.046 80.5341 209.046C80.078 209.046 79.6264 209.136 79.205 209.31C78.7836 209.485 78.4007 209.741 78.0782 210.063C77.7556 210.386 77.4998 210.769 77.3252 211.19C77.1507 211.612 77.0609 212.063 77.0609 212.519ZM97.9006 212.519C97.9006 212.975 97.9905 213.427 98.165 213.848C98.3396 214.27 98.5954 214.653 98.9179 214.975C99.2404 215.298 99.6233 215.554 100.045 215.728C100.466 215.903 100.918 215.993 101.374 215.993C101.83 215.993 102.282 215.903 102.703 215.728C103.124 215.554 103.507 215.298 103.83 214.975C104.152 214.653 104.408 214.27 104.583 213.848C104.757 213.427 104.847 212.975 104.847 212.519C104.847 212.063 104.757 211.612 104.583 211.19C104.408 210.769 104.152 210.386 103.83 210.063C103.507 209.741 103.124 209.485 102.703 209.31C102.282 209.136 101.83 209.046 101.374 209.046C100.918 209.046 100.466 209.136 100.045 209.31C99.6233 209.485 99.2404 209.741 98.9179 210.063C98.5954 210.386 98.3396 210.769 98.165 211.19C97.9905 211.612 97.9006 212.063 97.9006 212.519ZM111.794 212.519C111.794 213.44 112.16 214.324 112.811 214.975C113.462 215.627 114.346 215.993 115.267 215.993C116.188 215.993 117.072 215.627 117.723 214.975C118.374 214.324 118.74 213.44 118.74 212.519C118.74 211.598 118.374 210.715 117.723 210.063C117.072 209.412 116.188 209.046 115.267 209.046C114.346 209.046 113.462 209.412 112.811 210.063C112.16 210.715 111.794 211.598 111.794 212.519ZM118.74 212.519C118.74 213.44 119.106 214.324 119.758 214.975C120.409 215.627 121.292 215.993 122.214 215.993C123.135 215.993 124.018 215.627 124.67 214.975C125.321 214.324 125.687 213.44 125.687 212.519C125.687 211.598 125.321 210.715 124.67 210.063C124.018 209.412 123.135 209.046 122.214 209.046C121.292 209.046 120.409 209.412 119.758 210.063C119.106 210.715 118.74 211.598 118.74 212.519ZM125.687 212.519C125.687 213.44 126.053 214.324 126.704 214.975C127.356 215.627 128.239 215.993 129.16 215.993C130.081 215.993 130.965 215.627 131.616 214.975C132.268 214.324 132.634 213.44 132.634 212.519C132.634 211.598 132.268 210.715 131.616 210.063C130.965 209.412 130.081 209.046 129.16 209.046C128.239 209.046 127.356 209.412 126.704 210.063C126.053 210.715 125.687 211.598 125.687 212.519ZM132.634 212.519C132.634 213.44 132.999 214.324 133.651 214.975C134.302 215.627 135.186 215.993 136.107 215.993C137.028 215.993 137.911 215.627 138.563 214.975C139.214 214.324 139.58 213.44 139.58 212.519C139.58 211.598 139.214 210.715 138.563 210.063C137.911 209.412 137.028 209.046 136.107 209.046C135.186 209.046 134.302 209.412 133.651 210.063C132.999 210.715 132.634 211.598 132.634 212.519ZM139.58 212.519C139.58 213.44 139.946 214.324 140.597 214.975C141.249 215.627 142.132 215.993 143.053 215.993C143.975 215.993 144.858 215.627 145.509 214.975C146.161 214.324 146.527 213.44 146.527 212.519C146.527 211.598 146.161 210.715 145.509 210.063C144.858 209.412 143.975 209.046 143.053 209.046C142.132 209.046 141.249 209.412 140.597 210.063C139.946 210.715 139.58 211.598 139.58 212.519ZM167.366 212.519C167.366 213.44 167.732 214.324 168.384 214.975C169.035 215.627 169.919 215.993 170.84 215.993C171.761 215.993 172.644 215.627 173.296 214.975C173.947 214.324 174.313 213.44 174.313 212.519C174.313 211.598 173.947 210.715 173.296 210.063C172.644 209.412 171.761 209.046 170.84 209.046C169.919 209.046 169.035 209.412 168.384 210.063C167.732 210.715 167.366 211.598 167.366 212.519ZM181.26 212.519C181.26 213.44 181.626 214.324 182.277 214.975C182.928 215.627 183.812 215.993 184.733 215.993C185.654 215.993 186.538 215.627 187.189 214.975C187.84 214.324 188.206 213.44 188.206 212.519C188.206 211.598 187.84 210.715 187.189 210.063C186.538 209.412 185.654 209.046 184.733 209.046C183.812 209.046 182.928 209.412 182.277 210.063C181.626 210.715 181.26 211.598 181.26 212.519ZM188.206 212.519C188.206 213.44 188.572 214.324 189.224 214.975C189.875 215.627 190.758 215.993 191.68 215.993C192.601 215.993 193.484 215.627 194.136 214.975C194.787 214.324 195.153 213.44 195.153 212.519C195.153 211.598 194.787 210.715 194.136 210.063C193.484 209.412 192.601 209.046 191.68 209.046C190.758 209.046 189.875 209.412 189.224 210.063C188.572 210.715 188.206 211.598 188.206 212.519ZM215.993 212.519C215.993 213.44 216.359 214.324 217.01 214.975C217.661 215.627 218.545 215.993 219.466 215.993C220.387 215.993 221.271 215.627 221.922 214.975C222.573 214.324 222.939 213.44 222.939 212.519C222.939 211.598 222.573 210.715 221.922 210.063C221.271 209.412 220.387 209.046 219.466 209.046C218.545 209.046 217.661 209.412 217.01 210.063C216.359 210.715 215.993 211.598 215.993 212.519ZM222.939 212.519C222.939 213.44 223.305 214.324 223.957 214.975C224.608 215.627 225.491 215.993 226.413 215.993C227.334 215.993 228.217 215.627 228.868 214.975C229.52 214.324 229.886 213.44 229.886 212.519C229.886 211.598 229.52 210.715 228.868 210.063C228.217 209.412 227.334 209.046 226.413 209.046C225.491 209.046 224.608 209.412 223.957 210.063C223.305 210.715 222.939 211.598 222.939 212.519ZM236.832 212.519C236.832 213.44 237.198 214.324 237.85 214.975C238.501 215.627 239.384 215.993 240.306 215.993C241.227 215.993 242.11 215.627 242.762 214.975C243.413 214.324 243.779 213.44 243.779 212.519C243.779 211.598 243.413 210.715 242.762 210.063C242.11 209.412 241.227 209.046 240.306 209.046C239.384 209.046 238.501 209.412 237.85 210.063C237.198 210.715 236.832 211.598 236.832 212.519ZM250.726 212.519C250.726 213.44 251.091 214.324 251.743 214.975C252.394 215.627 253.278 215.993 254.199 215.993C255.12 215.993 256.003 215.627 256.655 214.975C257.306 214.324 257.672 213.44 257.672 212.519C257.672 211.598 257.306 210.715 256.655 210.063C256.003 209.412 255.12 209.046 254.199 209.046C253.278 209.046 252.394 209.412 251.743 210.063C251.091 210.715 250.726 211.598 250.726 212.519ZM257.672 212.519C257.672 213.44 258.038 214.324 258.689 214.975C259.341 215.627 260.224 215.993 261.145 215.993C262.067 215.993 262.95 215.627 263.601 214.975C264.253 214.324 264.619 213.44 264.619 212.519C264.619 211.598 264.253 210.715 263.601 210.063C262.95 209.412 262.067 209.046 261.145 209.046C260.224 209.046 259.341 209.412 258.689 210.063C258.038 210.715 257.672 211.598 257.672 212.519ZM264.619 212.519C264.619 213.44 264.985 214.324 265.636 214.975C266.287 215.627 267.171 215.993 268.092 215.993C269.013 215.993 269.897 215.627 270.548 214.975C271.199 214.324 271.565 213.44 271.565 212.519C271.565 211.598 271.199 210.715 270.548 210.063C269.897 209.412 269.013 209.046 268.092 209.046C267.171 209.046 266.287 209.412 265.636 210.063C264.985 210.715 264.619 211.598 264.619 212.519ZM271.565 212.519C271.565 213.44 271.931 214.324 272.583 214.975C273.234 215.627 274.117 215.993 275.039 215.993C275.96 215.993 276.843 215.627 277.495 214.975C278.146 214.324 278.512 213.44 278.512 212.519C278.512 211.598 278.146 210.715 277.495 210.063C276.843 209.412 275.96 209.046 275.039 209.046C274.117 209.046 273.234 209.412 272.583 210.063C271.931 210.715 271.565 211.598 271.565 212.519ZM285.458 212.519C285.458 213.44 285.824 214.324 286.476 214.975C287.127 215.627 288.011 215.993 288.932 215.993C289.853 215.993 290.736 215.627 291.388 214.975C292.039 214.324 292.405 213.44 292.405 212.519C292.405 211.598 292.039 210.715 291.388 210.063C290.736 209.412 289.853 209.046 288.932 209.046C288.011 209.046 287.127 209.412 286.476 210.063C285.824 210.715 285.458 211.598 285.458 212.519ZM35.3813 219.466C35.3813 220.387 35.7473 221.27 36.3986 221.922C37.05 222.573 37.9334 222.939 38.8546 222.939C39.7758 222.939 40.6592 222.573 41.3106 221.922C41.962 221.27 42.3279 220.387 42.3279 219.466C42.3279 218.545 41.962 217.661 41.3106 217.01C40.6592 216.359 39.7758 215.993 38.8546 215.993C37.9334 215.993 37.05 216.359 36.3986 217.01C35.7473 217.661 35.3813 218.545 35.3813 219.466ZM42.3279 219.466C42.3279 219.922 42.4177 220.374 42.5923 220.795C42.7668 221.216 43.0227 221.599 43.3452 221.922C43.6677 222.244 44.0506 222.5 44.472 222.675C44.8934 222.849 45.3451 222.939 45.8012 222.939C46.2573 222.939 46.709 222.849 47.1304 222.675C47.5518 222.5 47.9347 222.244 48.2572 221.922C48.5797 221.599 48.8356 221.216 49.0101 220.795C49.1847 220.374 49.2745 219.922 49.2745 219.466C49.2745 219.01 49.1847 218.558 49.0101 218.137C48.8356 217.715 48.5797 217.332 48.2572 217.01C47.9347 216.687 47.5518 216.432 47.1304 216.257C46.709 216.082 46.2573 215.993 45.8012 215.993C45.3451 215.993 44.8934 216.082 44.472 216.257C44.0506 216.432 43.6677 216.687 43.3452 217.01C43.0227 217.332 42.7668 217.715 42.5923 218.137C42.4177 218.558 42.3279 219.01 42.3279 219.466ZM49.2745 219.466C49.2745 219.922 49.3643 220.374 49.5389 220.795C49.7134 221.216 49.9693 221.599 50.2918 221.922C50.6143 222.244 50.9972 222.5 51.4186 222.675C51.84 222.849 52.2917 222.939 52.7478 222.939C53.2039 222.939 53.6556 222.849 54.077 222.675C54.4984 222.5 54.8813 222.244 55.2038 221.922C55.5263 221.599 55.7821 221.216 55.9567 220.795C56.1312 220.374 56.2211 219.922 56.2211 219.466C56.2211 219.01 56.1312 218.558 55.9567 218.137C55.7821 217.715 55.5263 217.332 55.2038 217.01C54.8813 216.687 54.4984 216.432 54.077 216.257C53.6556 216.082 53.2039 215.993 52.7478 215.993C52.2917 215.993 51.84 216.082 51.4186 216.257C50.9972 216.432 50.6143 216.687 50.2918 217.01C49.9693 217.332 49.7134 217.715 49.5389 218.137C49.3643 218.558 49.2745 219.01 49.2745 219.466ZM56.2211 219.466C56.2211 220.387 56.587 221.27 57.2384 221.922C57.8898 222.573 58.7732 222.939 59.6944 222.939C60.6156 222.939 61.499 222.573 62.1504 221.922C62.8017 221.27 63.1677 220.387 63.1677 219.466C63.1677 218.545 62.8017 217.661 62.1504 217.01C61.499 216.359 60.6156 215.993 59.6944 215.993C58.7732 215.993 57.8898 216.359 57.2384 217.01C56.587 217.661 56.2211 218.545 56.2211 219.466ZM63.1677 219.466C63.1677 220.387 63.5336 221.27 64.185 221.922C64.8363 222.573 65.7198 222.939 66.641 222.939C67.5621 222.939 68.4456 222.573 69.097 221.922C69.7483 221.27 70.1143 220.387 70.1143 219.466C70.1143 218.545 69.7483 217.661 69.097 217.01C68.4456 216.359 67.5621 215.993 66.641 215.993C65.7198 215.993 64.8363 216.359 64.185 217.01C63.5336 217.661 63.1677 218.545 63.1677 219.466ZM84.0074 219.466C84.0074 220.387 84.3734 221.27 85.0247 221.922C85.6761 222.573 86.5596 222.939 87.4807 222.939C88.4019 222.939 89.2854 222.573 89.9367 221.922C90.5881 221.27 90.954 220.387 90.954 219.466C90.954 218.545 90.5881 217.661 89.9367 217.01C89.2854 216.359 88.4019 215.993 87.4807 215.993C86.5596 215.993 85.6761 216.359 85.0247 217.01C84.3734 217.661 84.0074 218.545 84.0074 219.466ZM97.9006 219.466C97.9006 219.922 97.9905 220.374 98.165 220.795C98.3396 221.216 98.5954 221.599 98.9179 221.922C99.2404 222.244 99.6233 222.5 100.045 222.675C100.466 222.849 100.918 222.939 101.374 222.939C101.83 222.939 102.282 222.849 102.703 222.675C103.124 222.5 103.507 222.244 103.83 221.922C104.152 221.599 104.408 221.216 104.583 220.795C104.757 220.374 104.847 219.922 104.847 219.466C104.847 219.01 104.757 218.558 104.583 218.137C104.408 217.715 104.152 217.332 103.83 217.01C103.507 216.687 103.124 216.432 102.703 216.257C102.282 216.082 101.83 215.993 101.374 215.993C100.918 215.993 100.466 216.082 100.045 216.257C99.6233 216.432 99.2404 216.687 98.9179 217.01C98.5954 217.332 98.3396 217.715 98.165 218.137C97.9905 218.558 97.9006 219.01 97.9006 219.466ZM104.847 219.466C104.847 220.387 105.213 221.27 105.865 221.922C106.516 222.573 107.399 222.939 108.321 222.939C109.242 222.939 110.125 222.573 110.776 221.922C111.428 221.27 111.794 220.387 111.794 219.466C111.794 218.545 111.428 217.661 110.776 217.01C110.125 216.359 109.242 215.993 108.321 215.993C107.399 215.993 106.516 216.359 105.865 217.01C105.213 217.661 104.847 218.545 104.847 219.466ZM111.794 219.466C111.794 220.387 112.16 221.27 112.811 221.922C113.462 222.573 114.346 222.939 115.267 222.939C116.188 222.939 117.072 222.573 117.723 221.922C118.374 221.27 118.74 220.387 118.74 219.466C118.74 218.545 118.374 217.661 117.723 217.01C117.072 216.359 116.188 215.993 115.267 215.993C114.346 215.993 113.462 216.359 112.811 217.01C112.16 217.661 111.794 218.545 111.794 219.466ZM118.74 219.466C118.74 220.387 119.106 221.27 119.758 221.922C120.409 222.573 121.292 222.939 122.214 222.939C123.135 222.939 124.018 222.573 124.67 221.922C125.321 221.27 125.687 220.387 125.687 219.466C125.687 218.545 125.321 217.661 124.67 217.01C124.018 216.359 123.135 215.993 122.214 215.993C121.292 215.993 120.409 216.359 119.758 217.01C119.106 217.661 118.74 218.545 118.74 219.466ZM160.42 219.466C160.42 220.387 160.786 221.27 161.437 221.922C162.089 222.573 162.972 222.939 163.893 222.939C164.814 222.939 165.698 222.573 166.349 221.922C167.001 221.27 167.366 220.387 167.366 219.466C167.366 218.545 167.001 217.661 166.349 217.01C165.698 216.359 164.814 215.993 163.893 215.993C162.972 215.993 162.089 216.359 161.437 217.01C160.786 217.661 160.42 218.545 160.42 219.466ZM181.26 219.466C181.26 220.387 181.626 221.27 182.277 221.922C182.928 222.573 183.812 222.939 184.733 222.939C185.654 222.939 186.538 222.573 187.189 221.922C187.84 221.27 188.206 220.387 188.206 219.466C188.206 218.545 187.84 217.661 187.189 217.01C186.538 216.359 185.654 215.993 184.733 215.993C183.812 215.993 182.928 216.359 182.277 217.01C181.626 217.661 181.26 218.545 181.26 219.466ZM188.206 219.466C188.206 220.387 188.572 221.27 189.224 221.922C189.875 222.573 190.758 222.939 191.68 222.939C192.601 222.939 193.484 222.573 194.136 221.922C194.787 221.27 195.153 220.387 195.153 219.466C195.153 218.545 194.787 217.661 194.136 217.01C193.484 216.359 192.601 215.993 191.68 215.993C190.758 215.993 189.875 216.359 189.224 217.01C188.572 217.661 188.206 218.545 188.206 219.466ZM195.153 219.466C195.153 219.922 195.243 220.374 195.417 220.795C195.592 221.216 195.848 221.599 196.17 221.922C196.493 222.244 196.876 222.5 197.297 222.675C197.718 222.849 198.17 222.939 198.626 222.939C199.082 222.939 199.534 222.849 199.955 222.675C200.377 222.5 200.76 222.244 201.082 221.922C201.405 221.599 201.661 221.216 201.835 220.795C202.01 220.374 202.099 219.922 202.099 219.466C202.099 219.01 202.01 218.558 201.835 218.137C201.661 217.715 201.405 217.332 201.082 217.01C200.76 216.687 200.377 216.432 199.955 216.257C199.534 216.082 199.082 215.993 198.626 215.993C198.17 215.993 197.718 216.082 197.297 216.257C196.876 216.432 196.493 216.687 196.17 217.01C195.848 217.332 195.592 217.715 195.417 218.137C195.243 218.558 195.153 219.01 195.153 219.466ZM215.993 219.466C215.993 220.387 216.359 221.27 217.01 221.922C217.661 222.573 218.545 222.939 219.466 222.939C220.387 222.939 221.271 222.573 221.922 221.922C222.573 221.27 222.939 220.387 222.939 219.466C222.939 218.545 222.573 217.661 221.922 217.01C221.271 216.359 220.387 215.993 219.466 215.993C218.545 215.993 217.661 216.359 217.01 217.01C216.359 217.661 215.993 218.545 215.993 219.466ZM222.939 219.466C222.939 220.387 223.305 221.27 223.957 221.922C224.608 222.573 225.491 222.939 226.413 222.939C227.334 222.939 228.217 222.573 228.868 221.922C229.52 221.27 229.886 220.387 229.886 219.466C229.886 218.545 229.52 217.661 228.868 217.01C228.217 216.359 227.334 215.993 226.413 215.993C225.491 215.993 224.608 216.359 223.957 217.01C223.305 217.661 222.939 218.545 222.939 219.466ZM236.832 219.466C236.832 220.387 237.198 221.27 237.85 221.922C238.501 222.573 239.384 222.939 240.306 222.939C241.227 222.939 242.11 222.573 242.762 221.922C243.413 221.27 243.779 220.387 243.779 219.466C243.779 218.545 243.413 217.661 242.762 217.01C242.11 216.359 241.227 215.993 240.306 215.993C239.384 215.993 238.501 216.359 237.85 217.01C237.198 217.661 236.832 218.545 236.832 219.466ZM250.726 219.466C250.726 220.387 251.091 221.27 251.743 221.922C252.394 222.573 253.278 222.939 254.199 222.939C255.12 222.939 256.003 222.573 256.655 221.922C257.306 221.27 257.672 220.387 257.672 219.466C257.672 218.545 257.306 217.661 256.655 217.01C256.003 216.359 255.12 215.993 254.199 215.993C253.278 215.993 252.394 216.359 251.743 217.01C251.091 217.661 250.726 218.545 250.726 219.466ZM264.619 219.466C264.619 220.387 264.985 221.27 265.636 221.922C266.287 222.573 267.171 222.939 268.092 222.939C269.013 222.939 269.897 222.573 270.548 221.922C271.199 221.27 271.565 220.387 271.565 219.466C271.565 218.545 271.199 217.661 270.548 217.01C269.897 216.359 269.013 215.993 268.092 215.993C267.171 215.993 266.287 216.359 265.636 217.01C264.985 217.661 264.619 218.545 264.619 219.466ZM278.512 219.466C278.512 220.387 278.878 221.27 279.529 221.922C280.181 222.573 281.064 222.939 281.985 222.939C282.906 222.939 283.79 222.573 284.441 221.922C285.093 221.27 285.458 220.387 285.458 219.466C285.458 218.545 285.093 217.661 284.441 217.01C283.79 216.359 282.906 215.993 281.985 215.993C281.064 215.993 280.181 216.359 279.529 217.01C278.878 217.661 278.512 218.545 278.512 219.466ZM285.458 219.466C285.458 220.387 285.824 221.27 286.476 221.922C287.127 222.573 288.011 222.939 288.932 222.939C289.853 222.939 290.736 222.573 291.388 221.922C292.039 221.27 292.405 220.387 292.405 219.466C292.405 218.545 292.039 217.661 291.388 217.01C290.736 216.359 289.853 215.993 288.932 215.993C288.011 215.993 287.127 216.359 286.476 217.01C285.824 217.661 285.458 218.545 285.458 219.466ZM21.4881 226.412C21.4881 227.334 21.8541 228.217 22.5055 228.868C23.1568 229.52 24.0403 229.886 24.9614 229.886C25.8826 229.886 26.7661 229.52 27.4174 228.868C28.0688 228.217 28.4347 227.334 28.4347 226.412C28.4347 225.491 28.0688 224.608 27.4174 223.956C26.7661 223.305 25.8826 222.939 24.9614 222.939C24.0403 222.939 23.1568 223.305 22.5055 223.956C21.8541 224.608 21.4881 225.491 21.4881 226.412ZM28.4347 226.412C28.4347 227.334 28.8007 228.217 29.452 228.868C30.1034 229.52 30.9869 229.886 31.908 229.886C32.8292 229.886 33.7126 229.52 34.364 228.868C35.0154 228.217 35.3813 227.334 35.3813 226.412C35.3813 225.491 35.0154 224.608 34.364 223.956C33.7126 223.305 32.8292 222.939 31.908 222.939C30.9869 222.939 30.1034 223.305 29.452 223.956C28.8007 224.608 28.4347 225.491 28.4347 226.412ZM35.3813 226.412C35.3813 227.334 35.7473 228.217 36.3986 228.868C37.05 229.52 37.9334 229.886 38.8546 229.886C39.7758 229.886 40.6592 229.52 41.3106 228.868C41.962 228.217 42.3279 227.334 42.3279 226.412C42.3279 225.491 41.962 224.608 41.3106 223.956C40.6592 223.305 39.7758 222.939 38.8546 222.939C37.9334 222.939 37.05 223.305 36.3986 223.956C35.7473 224.608 35.3813 225.491 35.3813 226.412ZM56.2211 226.412C56.2211 227.334 56.587 228.217 57.2384 228.868C57.8898 229.52 58.7732 229.886 59.6944 229.886C60.6156 229.886 61.499 229.52 62.1504 228.868C62.8017 228.217 63.1677 227.334 63.1677 226.412C63.1677 225.491 62.8017 224.608 62.1504 223.956C61.499 223.305 60.6156 222.939 59.6944 222.939C58.7732 222.939 57.8898 223.305 57.2384 223.956C56.587 224.608 56.2211 225.491 56.2211 226.412ZM63.1677 226.412C63.1677 227.334 63.5336 228.217 64.185 228.868C64.8363 229.52 65.7198 229.886 66.641 229.886C67.5621 229.886 68.4456 229.52 69.097 228.868C69.7483 228.217 70.1143 227.334 70.1143 226.412C70.1143 225.491 69.7483 224.608 69.097 223.956C68.4456 223.305 67.5621 222.939 66.641 222.939C65.7198 222.939 64.8363 223.305 64.185 223.956C63.5336 224.608 63.1677 225.491 63.1677 226.412ZM70.1143 226.412C70.1143 227.334 70.4802 228.217 71.1316 228.868C71.7829 229.52 72.6664 229.886 73.5876 229.886C74.5087 229.886 75.3922 229.52 76.0436 228.868C76.6949 228.217 77.0609 227.334 77.0609 226.412C77.0609 225.491 76.6949 224.608 76.0436 223.956C75.3922 223.305 74.5087 222.939 73.5876 222.939C72.6664 222.939 71.7829 223.305 71.1316 223.956C70.4802 224.608 70.1143 225.491 70.1143 226.412ZM77.0609 226.412C77.0609 226.869 77.1507 227.32 77.3252 227.742C77.4998 228.163 77.7556 228.546 78.0782 228.868C78.4007 229.191 78.7836 229.447 79.205 229.621C79.6264 229.796 80.078 229.886 80.5341 229.886C80.9903 229.886 81.4419 229.796 81.8633 229.621C82.2847 229.447 82.6676 229.191 82.9901 228.868C83.3127 228.546 83.5685 228.163 83.743 227.742C83.9176 227.32 84.0074 226.869 84.0074 226.412C84.0074 225.956 83.9176 225.505 83.743 225.083C83.5685 224.662 83.3127 224.279 82.9901 223.956C82.6676 223.634 82.2847 223.378 81.8633 223.204C81.4419 223.029 80.9903 222.939 80.5341 222.939C80.078 222.939 79.6264 223.029 79.205 223.204C78.7836 223.378 78.4007 223.634 78.0782 223.956C77.7556 224.279 77.4998 224.662 77.3252 225.083C77.1507 225.505 77.0609 225.956 77.0609 226.412ZM84.0074 226.412C84.0074 227.334 84.3734 228.217 85.0247 228.868C85.6761 229.52 86.5596 229.886 87.4807 229.886C88.4019 229.886 89.2854 229.52 89.9367 228.868C90.5881 228.217 90.954 227.334 90.954 226.412C90.954 225.491 90.5881 224.608 89.9367 223.956C89.2854 223.305 88.4019 222.939 87.4807 222.939C86.5596 222.939 85.6761 223.305 85.0247 223.956C84.3734 224.608 84.0074 225.491 84.0074 226.412ZM97.9006 226.412C97.9006 226.869 97.9905 227.32 98.165 227.742C98.3396 228.163 98.5954 228.546 98.9179 228.868C99.2404 229.191 99.6233 229.447 100.045 229.621C100.466 229.796 100.918 229.886 101.374 229.886C101.83 229.886 102.282 229.796 102.703 229.621C103.124 229.447 103.507 229.191 103.83 228.868C104.152 228.546 104.408 228.163 104.583 227.742C104.757 227.32 104.847 226.869 104.847 226.412C104.847 225.956 104.757 225.505 104.583 225.083C104.408 224.662 104.152 224.279 103.83 223.956C103.507 223.634 103.124 223.378 102.703 223.204C102.282 223.029 101.83 222.939 101.374 222.939C100.918 222.939 100.466 223.029 100.045 223.204C99.6233 223.378 99.2404 223.634 98.9179 223.956C98.5954 224.279 98.3396 224.662 98.165 225.083C97.9905 225.505 97.9006 225.956 97.9006 226.412ZM111.794 226.412C111.794 227.334 112.16 228.217 112.811 228.868C113.462 229.52 114.346 229.886 115.267 229.886C116.188 229.886 117.072 229.52 117.723 228.868C118.374 228.217 118.74 227.334 118.74 226.412C118.74 225.491 118.374 224.608 117.723 223.956C117.072 223.305 116.188 222.939 115.267 222.939C114.346 222.939 113.462 223.305 112.811 223.956C112.16 224.608 111.794 225.491 111.794 226.412ZM125.687 226.412C125.687 227.334 126.053 228.217 126.704 228.868C127.356 229.52 128.239 229.886 129.16 229.886C130.081 229.886 130.965 229.52 131.616 228.868C132.268 228.217 132.634 227.334 132.634 226.412C132.634 225.491 132.268 224.608 131.616 223.956C130.965 223.305 130.081 222.939 129.16 222.939C128.239 222.939 127.356 223.305 126.704 223.956C126.053 224.608 125.687 225.491 125.687 226.412ZM132.634 226.412C132.634 227.334 132.999 228.217 133.651 228.868C134.302 229.52 135.186 229.886 136.107 229.886C137.028 229.886 137.911 229.52 138.563 228.868C139.214 228.217 139.58 227.334 139.58 226.412C139.58 225.491 139.214 224.608 138.563 223.956C137.911 223.305 137.028 222.939 136.107 222.939C135.186 222.939 134.302 223.305 133.651 223.956C132.999 224.608 132.634 225.491 132.634 226.412ZM160.42 226.412C160.42 227.334 160.786 228.217 161.437 228.868C162.089 229.52 162.972 229.886 163.893 229.886C164.814 229.886 165.698 229.52 166.349 228.868C167.001 228.217 167.366 227.334 167.366 226.412C167.366 225.491 167.001 224.608 166.349 223.956C165.698 223.305 164.814 222.939 163.893 222.939C162.972 222.939 162.089 223.305 161.437 223.956C160.786 224.608 160.42 225.491 160.42 226.412ZM195.153 226.412C195.153 226.869 195.243 227.32 195.417 227.742C195.592 228.163 195.848 228.546 196.17 228.868C196.493 229.191 196.876 229.447 197.297 229.621C197.718 229.796 198.17 229.886 198.626 229.886C199.082 229.886 199.534 229.796 199.955 229.621C200.377 229.447 200.76 229.191 201.082 228.868C201.405 228.546 201.661 228.163 201.835 227.742C202.01 227.32 202.099 226.869 202.099 226.412C202.099 225.956 202.01 225.505 201.835 225.083C201.661 224.662 201.405 224.279 201.082 223.956C200.76 223.634 200.377 223.378 199.955 223.204C199.534 223.029 199.082 222.939 198.626 222.939C198.17 222.939 197.718 223.029 197.297 223.204C196.876 223.378 196.493 223.634 196.17 223.956C195.848 224.279 195.592 224.662 195.417 225.083C195.243 225.505 195.153 225.956 195.153 226.412ZM202.099 226.412C202.099 227.334 202.465 228.217 203.117 228.868C203.768 229.52 204.652 229.886 205.573 229.886C206.494 229.886 207.377 229.52 208.029 228.868C208.68 228.217 209.046 227.334 209.046 226.412C209.046 225.491 208.68 224.608 208.029 223.956C207.377 223.305 206.494 222.939 205.573 222.939C204.652 222.939 203.768 223.305 203.117 223.956C202.465 224.608 202.099 225.491 202.099 226.412ZM209.046 226.412C209.046 227.334 209.412 228.217 210.063 228.868C210.715 229.52 211.598 229.886 212.519 229.886C213.44 229.886 214.324 229.52 214.975 228.868C215.627 228.217 215.993 227.334 215.993 226.412C215.993 225.491 215.627 224.608 214.975 223.956C214.324 223.305 213.44 222.939 212.519 222.939C211.598 222.939 210.715 223.305 210.063 223.956C209.412 224.608 209.046 225.491 209.046 226.412ZM222.939 226.412C222.939 227.334 223.305 228.217 223.957 228.868C224.608 229.52 225.491 229.886 226.413 229.886C227.334 229.886 228.217 229.52 228.868 228.868C229.52 228.217 229.886 227.334 229.886 226.412C229.886 225.491 229.52 224.608 228.868 223.956C228.217 223.305 227.334 222.939 226.413 222.939C225.491 222.939 224.608 223.305 223.957 223.956C223.305 224.608 222.939 225.491 222.939 226.412ZM229.886 226.412C229.886 227.334 230.252 228.217 230.903 228.868C231.554 229.52 232.438 229.886 233.359 229.886C234.28 229.886 235.164 229.52 235.815 228.868C236.466 228.217 236.832 227.334 236.832 226.412C236.832 225.491 236.466 224.608 235.815 223.956C235.164 223.305 234.28 222.939 233.359 222.939C232.438 222.939 231.554 223.305 230.903 223.956C230.252 224.608 229.886 225.491 229.886 226.412ZM236.832 226.412C236.832 227.334 237.198 228.217 237.85 228.868C238.501 229.52 239.384 229.886 240.306 229.886C241.227 229.886 242.11 229.52 242.762 228.868C243.413 228.217 243.779 227.334 243.779 226.412C243.779 225.491 243.413 224.608 242.762 223.956C242.11 223.305 241.227 222.939 240.306 222.939C239.384 222.939 238.501 223.305 237.85 223.956C237.198 224.608 236.832 225.491 236.832 226.412ZM257.672 226.412C257.672 227.334 258.038 228.217 258.689 228.868C259.341 229.52 260.224 229.886 261.145 229.886C262.067 229.886 262.95 229.52 263.601 228.868C264.253 228.217 264.619 227.334 264.619 226.412C264.619 225.491 264.253 224.608 263.601 223.956C262.95 223.305 262.067 222.939 261.145 222.939C260.224 222.939 259.341 223.305 258.689 223.956C258.038 224.608 257.672 225.491 257.672 226.412ZM264.619 226.412C264.619 227.334 264.985 228.217 265.636 228.868C266.287 229.52 267.171 229.886 268.092 229.886C269.013 229.886 269.897 229.52 270.548 228.868C271.199 228.217 271.565 227.334 271.565 226.412C271.565 225.491 271.199 224.608 270.548 223.956C269.897 223.305 269.013 222.939 268.092 222.939C267.171 222.939 266.287 223.305 265.636 223.956C264.985 224.608 264.619 225.491 264.619 226.412ZM7.59497 233.359C7.59497 234.28 7.96091 235.164 8.61227 235.815C9.26364 236.466 10.1471 236.832 11.0683 236.832C11.9894 236.832 12.8729 236.466 13.5243 235.815C14.1756 235.164 14.5416 234.28 14.5416 233.359C14.5416 232.438 14.1756 231.554 13.5243 230.903C12.8729 230.252 11.9894 229.886 11.0683 229.886C10.1471 229.886 9.26364 230.252 8.61227 230.903C7.96091 231.554 7.59497 232.438 7.59497 233.359ZM14.5416 233.359C14.5416 234.28 14.9075 235.164 15.5589 235.815C16.2102 236.466 17.0937 236.832 18.0149 236.832C18.936 236.832 19.8195 236.466 20.4708 235.815C21.1222 235.164 21.4881 234.28 21.4881 233.359C21.4881 232.438 21.1222 231.554 20.4708 230.903C19.8195 230.252 18.936 229.886 18.0149 229.886C17.0937 229.886 16.2102 230.252 15.5589 230.903C14.9075 231.554 14.5416 232.438 14.5416 233.359ZM42.3279 233.359C42.3279 233.815 42.4177 234.267 42.5923 234.688C42.7668 235.11 43.0227 235.493 43.3452 235.815C43.6677 236.138 44.0506 236.393 44.472 236.568C44.8934 236.743 45.3451 236.832 45.8012 236.832C46.2573 236.832 46.709 236.743 47.1304 236.568C47.5518 236.393 47.9347 236.138 48.2572 235.815C48.5797 235.493 48.8356 235.11 49.0101 234.688C49.1847 234.267 49.2745 233.815 49.2745 233.359C49.2745 232.903 49.1847 232.451 49.0101 232.03C48.8356 231.608 48.5797 231.226 48.2572 230.903C47.9347 230.581 47.5518 230.325 47.1304 230.15C46.709 229.976 46.2573 229.886 45.8012 229.886C45.3451 229.886 44.8934 229.976 44.472 230.15C44.0506 230.325 43.6677 230.581 43.3452 230.903C43.0227 231.226 42.7668 231.608 42.5923 232.03C42.4177 232.451 42.3279 232.903 42.3279 233.359ZM49.2745 233.359C49.2745 233.815 49.3643 234.267 49.5389 234.688C49.7134 235.11 49.9693 235.493 50.2918 235.815C50.6143 236.138 50.9972 236.393 51.4186 236.568C51.84 236.743 52.2917 236.832 52.7478 236.832C53.2039 236.832 53.6556 236.743 54.077 236.568C54.4984 236.393 54.8813 236.138 55.2038 235.815C55.5263 235.493 55.7821 235.11 55.9567 234.688C56.1312 234.267 56.2211 233.815 56.2211 233.359C56.2211 232.903 56.1312 232.451 55.9567 232.03C55.7821 231.608 55.5263 231.226 55.2038 230.903C54.8813 230.581 54.4984 230.325 54.077 230.15C53.6556 229.976 53.2039 229.886 52.7478 229.886C52.2917 229.886 51.84 229.976 51.4186 230.15C50.9972 230.325 50.6143 230.581 50.2918 230.903C49.9693 231.226 49.7134 231.608 49.5389 232.03C49.3643 232.451 49.2745 232.903 49.2745 233.359ZM70.1143 233.359C70.1143 234.28 70.4802 235.164 71.1316 235.815C71.7829 236.466 72.6664 236.832 73.5876 236.832C74.5087 236.832 75.3922 236.466 76.0436 235.815C76.6949 235.164 77.0609 234.28 77.0609 233.359C77.0609 232.438 76.6949 231.554 76.0436 230.903C75.3922 230.252 74.5087 229.886 73.5876 229.886C72.6664 229.886 71.7829 230.252 71.1316 230.903C70.4802 231.554 70.1143 232.438 70.1143 233.359ZM84.0074 233.359C84.0074 234.28 84.3734 235.164 85.0247 235.815C85.6761 236.466 86.5596 236.832 87.4807 236.832C88.4019 236.832 89.2854 236.466 89.9367 235.815C90.5881 235.164 90.954 234.28 90.954 233.359C90.954 232.438 90.5881 231.554 89.9367 230.903C89.2854 230.252 88.4019 229.886 87.4807 229.886C86.5596 229.886 85.6761 230.252 85.0247 230.903C84.3734 231.554 84.0074 232.438 84.0074 233.359ZM90.954 233.359C90.954 234.28 91.32 235.164 91.9713 235.815C92.6227 236.466 93.5061 236.832 94.4273 236.832C95.3485 236.832 96.2319 236.466 96.8833 235.815C97.5347 235.164 97.9006 234.28 97.9006 233.359C97.9006 232.438 97.5347 231.554 96.8833 230.903C96.2319 230.252 95.3485 229.886 94.4273 229.886C93.5061 229.886 92.6227 230.252 91.9713 230.903C91.32 231.554 90.954 232.438 90.954 233.359ZM146.527 233.359C146.527 234.28 146.893 235.164 147.544 235.815C148.195 236.466 149.079 236.832 150 236.832C150.921 236.832 151.805 236.466 152.456 235.815C153.107 235.164 153.473 234.28 153.473 233.359C153.473 232.438 153.107 231.554 152.456 230.903C151.805 230.252 150.921 229.886 150 229.886C149.079 229.886 148.195 230.252 147.544 230.903C146.893 231.554 146.527 232.438 146.527 233.359ZM153.473 233.359C153.473 233.815 153.563 234.267 153.738 234.688C153.912 235.11 154.168 235.493 154.491 235.815C154.813 236.138 155.196 236.393 155.617 236.568C156.039 236.743 156.491 236.832 156.947 236.832C157.403 236.832 157.854 236.743 158.276 236.568C158.697 236.393 159.08 236.138 159.403 235.815C159.725 235.493 159.981 235.11 160.156 234.688C160.33 234.267 160.42 233.815 160.42 233.359C160.42 232.903 160.33 232.451 160.156 232.03C159.981 231.608 159.725 231.226 159.403 230.903C159.08 230.581 158.697 230.325 158.276 230.15C157.854 229.976 157.403 229.886 156.947 229.886C156.491 229.886 156.039 229.976 155.617 230.15C155.196 230.325 154.813 230.581 154.491 230.903C154.168 231.226 153.912 231.608 153.738 232.03C153.563 232.451 153.473 232.903 153.473 233.359ZM167.366 233.359C167.366 234.28 167.732 235.164 168.384 235.815C169.035 236.466 169.919 236.832 170.84 236.832C171.761 236.832 172.644 236.466 173.296 235.815C173.947 235.164 174.313 234.28 174.313 233.359C174.313 232.438 173.947 231.554 173.296 230.903C172.644 230.252 171.761 229.886 170.84 229.886C169.919 229.886 169.035 230.252 168.384 230.903C167.732 231.554 167.366 232.438 167.366 233.359ZM181.26 233.359C181.26 234.28 181.626 235.164 182.277 235.815C182.928 236.466 183.812 236.832 184.733 236.832C185.654 236.832 186.538 236.466 187.189 235.815C187.84 235.164 188.206 234.28 188.206 233.359C188.206 232.438 187.84 231.554 187.189 230.903C186.538 230.252 185.654 229.886 184.733 229.886C183.812 229.886 182.928 230.252 182.277 230.903C181.626 231.554 181.26 232.438 181.26 233.359ZM188.206 233.359C188.206 234.28 188.572 235.164 189.224 235.815C189.875 236.466 190.758 236.832 191.68 236.832C192.601 236.832 193.484 236.466 194.136 235.815C194.787 235.164 195.153 234.28 195.153 233.359C195.153 232.438 194.787 231.554 194.136 230.903C193.484 230.252 192.601 229.886 191.68 229.886C190.758 229.886 189.875 230.252 189.224 230.903C188.572 231.554 188.206 232.438 188.206 233.359ZM209.046 233.359C209.046 234.28 209.412 235.164 210.063 235.815C210.715 236.466 211.598 236.832 212.519 236.832C213.44 236.832 214.324 236.466 214.975 235.815C215.627 235.164 215.993 234.28 215.993 233.359C215.993 232.438 215.627 231.554 214.975 230.903C214.324 230.252 213.44 229.886 212.519 229.886C211.598 229.886 210.715 230.252 210.063 230.903C209.412 231.554 209.046 232.438 209.046 233.359ZM229.886 233.359C229.886 234.28 230.252 235.164 230.903 235.815C231.554 236.466 232.438 236.832 233.359 236.832C234.28 236.832 235.164 236.466 235.815 235.815C236.466 235.164 236.832 234.28 236.832 233.359C236.832 232.438 236.466 231.554 235.815 230.903C235.164 230.252 234.28 229.886 233.359 229.886C232.438 229.886 231.554 230.252 230.903 230.903C230.252 231.554 229.886 232.438 229.886 233.359ZM236.832 233.359C236.832 234.28 237.198 235.164 237.85 235.815C238.501 236.466 239.384 236.832 240.306 236.832C241.227 236.832 242.11 236.466 242.762 235.815C243.413 235.164 243.779 234.28 243.779 233.359C243.779 232.438 243.413 231.554 242.762 230.903C242.11 230.252 241.227 229.886 240.306 229.886C239.384 229.886 238.501 230.252 237.85 230.903C237.198 231.554 236.832 232.438 236.832 233.359ZM243.779 233.359C243.779 234.28 244.145 235.164 244.796 235.815C245.448 236.466 246.331 236.832 247.252 236.832C248.173 236.832 249.057 236.466 249.708 235.815C250.36 235.164 250.726 234.28 250.726 233.359C250.726 232.438 250.36 231.554 249.708 230.903C249.057 230.252 248.173 229.886 247.252 229.886C246.331 229.886 245.448 230.252 244.796 230.903C244.145 231.554 243.779 232.438 243.779 233.359ZM250.726 233.359C250.726 234.28 251.091 235.164 251.743 235.815C252.394 236.466 253.278 236.832 254.199 236.832C255.12 236.832 256.003 236.466 256.655 235.815C257.306 235.164 257.672 234.28 257.672 233.359C257.672 232.438 257.306 231.554 256.655 230.903C256.003 230.252 255.12 229.886 254.199 229.886C253.278 229.886 252.394 230.252 251.743 230.903C251.091 231.554 250.726 232.438 250.726 233.359ZM257.672 233.359C257.672 234.28 258.038 235.164 258.689 235.815C259.341 236.466 260.224 236.832 261.145 236.832C262.067 236.832 262.95 236.466 263.601 235.815C264.253 235.164 264.619 234.28 264.619 233.359C264.619 232.438 264.253 231.554 263.601 230.903C262.95 230.252 262.067 229.886 261.145 229.886C260.224 229.886 259.341 230.252 258.689 230.903C258.038 231.554 257.672 232.438 257.672 233.359ZM264.619 233.359C264.619 234.28 264.985 235.164 265.636 235.815C266.287 236.466 267.171 236.832 268.092 236.832C269.013 236.832 269.897 236.466 270.548 235.815C271.199 235.164 271.565 234.28 271.565 233.359C271.565 232.438 271.199 231.554 270.548 230.903C269.897 230.252 269.013 229.886 268.092 229.886C267.171 229.886 266.287 230.252 265.636 230.903C264.985 231.554 264.619 232.438 264.619 233.359ZM285.458 233.359C285.458 234.28 285.824 235.164 286.476 235.815C287.127 236.466 288.011 236.832 288.932 236.832C289.853 236.832 290.736 236.466 291.388 235.815C292.039 235.164 292.405 234.28 292.405 233.359C292.405 232.438 292.039 231.554 291.388 230.903C290.736 230.252 289.853 229.886 288.932 229.886C288.011 229.886 287.127 230.252 286.476 230.903C285.824 231.554 285.458 232.438 285.458 233.359ZM63.1677 240.306C63.1677 241.227 63.5336 242.11 64.185 242.762C64.8363 243.413 65.7198 243.779 66.641 243.779C67.5621 243.779 68.4456 243.413 69.097 242.762C69.7483 242.11 70.1143 241.227 70.1143 240.306C70.1143 239.384 69.7483 238.501 69.097 237.85C68.4456 237.198 67.5621 236.832 66.641 236.832C65.7198 236.832 64.8363 237.198 64.185 237.85C63.5336 238.501 63.1677 239.384 63.1677 240.306ZM84.0074 240.306C84.0074 241.227 84.3734 242.11 85.0247 242.762C85.6761 243.413 86.5596 243.779 87.4807 243.779C88.4019 243.779 89.2854 243.413 89.9367 242.762C90.5881 242.11 90.954 241.227 90.954 240.306C90.954 239.384 90.5881 238.501 89.9367 237.85C89.2854 237.198 88.4019 236.832 87.4807 236.832C86.5596 236.832 85.6761 237.198 85.0247 237.85C84.3734 238.501 84.0074 239.384 84.0074 240.306ZM90.954 240.306C90.954 241.227 91.32 242.11 91.9713 242.762C92.6227 243.413 93.5061 243.779 94.4273 243.779C95.3485 243.779 96.2319 243.413 96.8833 242.762C97.5347 242.11 97.9006 241.227 97.9006 240.306C97.9006 239.384 97.5347 238.501 96.8833 237.85C96.2319 237.198 95.3485 236.832 94.4273 236.832C93.5061 236.832 92.6227 237.198 91.9713 237.85C91.32 238.501 90.954 239.384 90.954 240.306ZM104.847 240.306C104.847 241.227 105.213 242.11 105.865 242.762C106.516 243.413 107.399 243.779 108.321 243.779C109.242 243.779 110.125 243.413 110.776 242.762C111.428 242.11 111.794 241.227 111.794 240.306C111.794 239.384 111.428 238.501 110.776 237.85C110.125 237.198 109.242 236.832 108.321 236.832C107.399 236.832 106.516 237.198 105.865 237.85C105.213 238.501 104.847 239.384 104.847 240.306ZM132.634 240.306C132.634 241.227 132.999 242.11 133.651 242.762C134.302 243.413 135.186 243.779 136.107 243.779C137.028 243.779 137.911 243.413 138.563 242.762C139.214 242.11 139.58 241.227 139.58 240.306C139.58 239.384 139.214 238.501 138.563 237.85C137.911 237.198 137.028 236.832 136.107 236.832C135.186 236.832 134.302 237.198 133.651 237.85C132.999 238.501 132.634 239.384 132.634 240.306ZM146.527 240.306C146.527 241.227 146.893 242.11 147.544 242.762C148.195 243.413 149.079 243.779 150 243.779C150.921 243.779 151.805 243.413 152.456 242.762C153.107 242.11 153.473 241.227 153.473 240.306C153.473 239.384 153.107 238.501 152.456 237.85C151.805 237.198 150.921 236.832 150 236.832C149.079 236.832 148.195 237.198 147.544 237.85C146.893 238.501 146.527 239.384 146.527 240.306ZM153.473 240.306C153.473 240.762 153.563 241.213 153.738 241.635C153.912 242.056 154.168 242.439 154.491 242.762C154.813 243.084 155.196 243.34 155.617 243.515C156.039 243.689 156.491 243.779 156.947 243.779C157.403 243.779 157.854 243.689 158.276 243.515C158.697 243.34 159.08 243.084 159.403 242.762C159.725 242.439 159.981 242.056 160.156 241.635C160.33 241.213 160.42 240.762 160.42 240.306C160.42 239.85 160.33 239.398 160.156 238.976C159.981 238.555 159.725 238.172 159.403 237.85C159.08 237.527 158.697 237.271 158.276 237.097C157.854 236.922 157.403 236.832 156.947 236.832C156.491 236.832 156.039 236.922 155.617 237.097C155.196 237.271 154.813 237.527 154.491 237.85C154.168 238.172 153.912 238.555 153.738 238.976C153.563 239.398 153.473 239.85 153.473 240.306ZM160.42 240.306C160.42 241.227 160.786 242.11 161.437 242.762C162.089 243.413 162.972 243.779 163.893 243.779C164.814 243.779 165.698 243.413 166.349 242.762C167.001 242.11 167.366 241.227 167.366 240.306C167.366 239.384 167.001 238.501 166.349 237.85C165.698 237.198 164.814 236.832 163.893 236.832C162.972 236.832 162.089 237.198 161.437 237.85C160.786 238.501 160.42 239.384 160.42 240.306ZM188.206 240.306C188.206 241.227 188.572 242.11 189.224 242.762C189.875 243.413 190.758 243.779 191.68 243.779C192.601 243.779 193.484 243.413 194.136 242.762C194.787 242.11 195.153 241.227 195.153 240.306C195.153 239.384 194.787 238.501 194.136 237.85C193.484 237.198 192.601 236.832 191.68 236.832C190.758 236.832 189.875 237.198 189.224 237.85C188.572 238.501 188.206 239.384 188.206 240.306ZM195.153 240.306C195.153 240.762 195.243 241.213 195.417 241.635C195.592 242.056 195.848 242.439 196.17 242.762C196.493 243.084 196.876 243.34 197.297 243.515C197.718 243.689 198.17 243.779 198.626 243.779C199.082 243.779 199.534 243.689 199.955 243.515C200.377 243.34 200.76 243.084 201.082 242.762C201.405 242.439 201.661 242.056 201.835 241.635C202.01 241.213 202.099 240.762 202.099 240.306C202.099 239.85 202.01 239.398 201.835 238.976C201.661 238.555 201.405 238.172 201.082 237.85C200.76 237.527 200.377 237.271 199.955 237.097C199.534 236.922 199.082 236.832 198.626 236.832C198.17 236.832 197.718 236.922 197.297 237.097C196.876 237.271 196.493 237.527 196.17 237.85C195.848 238.172 195.592 238.555 195.417 238.976C195.243 239.398 195.153 239.85 195.153 240.306ZM202.099 240.306C202.099 241.227 202.465 242.11 203.117 242.762C203.768 243.413 204.652 243.779 205.573 243.779C206.494 243.779 207.377 243.413 208.029 242.762C208.68 242.11 209.046 241.227 209.046 240.306C209.046 239.384 208.68 238.501 208.029 237.85C207.377 237.198 206.494 236.832 205.573 236.832C204.652 236.832 203.768 237.198 203.117 237.85C202.465 238.501 202.099 239.384 202.099 240.306ZM209.046 240.306C209.046 241.227 209.412 242.11 210.063 242.762C210.715 243.413 211.598 243.779 212.519 243.779C213.44 243.779 214.324 243.413 214.975 242.762C215.627 242.11 215.993 241.227 215.993 240.306C215.993 239.384 215.627 238.501 214.975 237.85C214.324 237.198 213.44 236.832 212.519 236.832C211.598 236.832 210.715 237.198 210.063 237.85C209.412 238.501 209.046 239.384 209.046 240.306ZM229.886 240.306C229.886 241.227 230.252 242.11 230.903 242.762C231.554 243.413 232.438 243.779 233.359 243.779C234.28 243.779 235.164 243.413 235.815 242.762C236.466 242.11 236.832 241.227 236.832 240.306C236.832 239.384 236.466 238.501 235.815 237.85C235.164 237.198 234.28 236.832 233.359 236.832C232.438 236.832 231.554 237.198 230.903 237.85C230.252 238.501 229.886 239.384 229.886 240.306ZM257.672 240.306C257.672 241.227 258.038 242.11 258.689 242.762C259.341 243.413 260.224 243.779 261.145 243.779C262.067 243.779 262.95 243.413 263.601 242.762C264.253 242.11 264.619 241.227 264.619 240.306C264.619 239.384 264.253 238.501 263.601 237.85C262.95 237.198 262.067 236.832 261.145 236.832C260.224 236.832 259.341 237.198 258.689 237.85C258.038 238.501 257.672 239.384 257.672 240.306ZM271.565 240.306C271.565 241.227 271.931 242.11 272.583 242.762C273.234 243.413 274.117 243.779 275.039 243.779C275.96 243.779 276.843 243.413 277.495 242.762C278.146 242.11 278.512 241.227 278.512 240.306C278.512 239.384 278.146 238.501 277.495 237.85C276.843 237.198 275.96 236.832 275.039 236.832C274.117 236.832 273.234 237.198 272.583 237.85C271.931 238.501 271.565 239.384 271.565 240.306ZM278.512 240.306C278.512 241.227 278.878 242.11 279.529 242.762C280.181 243.413 281.064 243.779 281.985 243.779C282.906 243.779 283.79 243.413 284.441 242.762C285.093 242.11 285.458 241.227 285.458 240.306C285.458 239.384 285.093 238.501 284.441 237.85C283.79 237.198 282.906 236.832 281.985 236.832C281.064 236.832 280.181 237.198 279.529 237.85C278.878 238.501 278.512 239.384 278.512 240.306ZM285.458 240.306C285.458 241.227 285.824 242.11 286.476 242.762C287.127 243.413 288.011 243.779 288.932 243.779C289.853 243.779 290.736 243.413 291.388 242.762C292.039 242.11 292.405 241.227 292.405 240.306C292.405 239.384 292.039 238.501 291.388 237.85C290.736 237.198 289.853 236.832 288.932 236.832C288.011 236.832 287.127 237.198 286.476 237.85C285.824 238.501 285.458 239.384 285.458 240.306ZM7.59497 247.252C7.59497 248.173 7.96091 249.057 8.61227 249.708C9.26364 250.36 10.1471 250.726 11.0683 250.726C11.9894 250.726 12.8729 250.36 13.5243 249.708C14.1756 249.057 14.5416 248.173 14.5416 247.252C14.5416 246.331 14.1756 245.448 13.5243 244.796C12.8729 244.145 11.9894 243.779 11.0683 243.779C10.1471 243.779 9.26364 244.145 8.61227 244.796C7.96091 245.448 7.59497 246.331 7.59497 247.252ZM14.5416 247.252C14.5416 248.173 14.9075 249.057 15.5589 249.708C16.2102 250.36 17.0937 250.726 18.0149 250.726C18.936 250.726 19.8195 250.36 20.4708 249.708C21.1222 249.057 21.4881 248.173 21.4881 247.252C21.4881 246.331 21.1222 245.448 20.4708 244.796C19.8195 244.145 18.936 243.779 18.0149 243.779C17.0937 243.779 16.2102 244.145 15.5589 244.796C14.9075 245.448 14.5416 246.331 14.5416 247.252ZM21.4881 247.252C21.4881 248.173 21.8541 249.057 22.5055 249.708C23.1568 250.36 24.0403 250.726 24.9614 250.726C25.8826 250.726 26.7661 250.36 27.4174 249.708C28.0688 249.057 28.4347 248.173 28.4347 247.252C28.4347 246.331 28.0688 245.448 27.4174 244.796C26.7661 244.145 25.8826 243.779 24.9614 243.779C24.0403 243.779 23.1568 244.145 22.5055 244.796C21.8541 245.448 21.4881 246.331 21.4881 247.252ZM28.4347 247.252C28.4347 248.173 28.8007 249.057 29.452 249.708C30.1034 250.36 30.9869 250.726 31.908 250.726C32.8292 250.726 33.7126 250.36 34.364 249.708C35.0154 249.057 35.3813 248.173 35.3813 247.252C35.3813 246.331 35.0154 245.448 34.364 244.796C33.7126 244.145 32.8292 243.779 31.908 243.779C30.9869 243.779 30.1034 244.145 29.452 244.796C28.8007 245.448 28.4347 246.331 28.4347 247.252ZM35.3813 247.252C35.3813 248.173 35.7473 249.057 36.3986 249.708C37.05 250.36 37.9334 250.726 38.8546 250.726C39.7758 250.726 40.6592 250.36 41.3106 249.708C41.962 249.057 42.3279 248.173 42.3279 247.252C42.3279 246.331 41.962 245.448 41.3106 244.796C40.6592 244.145 39.7758 243.779 38.8546 243.779C37.9334 243.779 37.05 244.145 36.3986 244.796C35.7473 245.448 35.3813 246.331 35.3813 247.252ZM42.3279 247.252C42.3279 247.708 42.4177 248.16 42.5923 248.581C42.7668 249.003 43.0227 249.386 43.3452 249.708C43.6677 250.031 44.0506 250.287 44.472 250.461C44.8934 250.636 45.3451 250.726 45.8012 250.726C46.2573 250.726 46.709 250.636 47.1304 250.461C47.5518 250.287 47.9347 250.031 48.2572 249.708C48.5797 249.386 48.8356 249.003 49.0101 248.581C49.1847 248.16 49.2745 247.708 49.2745 247.252C49.2745 246.796 49.1847 246.344 49.0101 245.923C48.8356 245.502 48.5797 245.119 48.2572 244.796C47.9347 244.474 47.5518 244.218 47.1304 244.043C46.709 243.869 46.2573 243.779 45.8012 243.779C45.3451 243.779 44.8934 243.869 44.472 244.043C44.0506 244.218 43.6677 244.474 43.3452 244.796C43.0227 245.119 42.7668 245.502 42.5923 245.923C42.4177 246.344 42.3279 246.796 42.3279 247.252ZM49.2745 247.252C49.2745 247.708 49.3643 248.16 49.5389 248.581C49.7134 249.003 49.9693 249.386 50.2918 249.708C50.6143 250.031 50.9972 250.287 51.4186 250.461C51.84 250.636 52.2917 250.726 52.7478 250.726C53.2039 250.726 53.6556 250.636 54.077 250.461C54.4984 250.287 54.8813 250.031 55.2038 249.708C55.5263 249.386 55.7821 249.003 55.9567 248.581C56.1312 248.16 56.2211 247.708 56.2211 247.252C56.2211 246.796 56.1312 246.344 55.9567 245.923C55.7821 245.502 55.5263 245.119 55.2038 244.796C54.8813 244.474 54.4984 244.218 54.077 244.043C53.6556 243.869 53.2039 243.779 52.7478 243.779C52.2917 243.779 51.84 243.869 51.4186 244.043C50.9972 244.218 50.6143 244.474 50.2918 244.796C49.9693 245.119 49.7134 245.502 49.5389 245.923C49.3643 246.344 49.2745 246.796 49.2745 247.252ZM63.1677 247.252C63.1677 248.173 63.5336 249.057 64.185 249.708C64.8363 250.36 65.7198 250.726 66.641 250.726C67.5621 250.726 68.4456 250.36 69.097 249.708C69.7483 249.057 70.1143 248.173 70.1143 247.252C70.1143 246.331 69.7483 245.448 69.097 244.796C68.4456 244.145 67.5621 243.779 66.641 243.779C65.7198 243.779 64.8363 244.145 64.185 244.796C63.5336 245.448 63.1677 246.331 63.1677 247.252ZM77.0609 247.252C77.0609 247.708 77.1507 248.16 77.3252 248.581C77.4998 249.003 77.7556 249.386 78.0782 249.708C78.4007 250.031 78.7836 250.287 79.205 250.461C79.6264 250.636 80.078 250.726 80.5341 250.726C80.9903 250.726 81.4419 250.636 81.8633 250.461C82.2847 250.287 82.6676 250.031 82.9901 249.708C83.3127 249.386 83.5685 249.003 83.743 248.581C83.9176 248.16 84.0074 247.708 84.0074 247.252C84.0074 246.796 83.9176 246.344 83.743 245.923C83.5685 245.502 83.3127 245.119 82.9901 244.796C82.6676 244.474 82.2847 244.218 81.8633 244.043C81.4419 243.869 80.9903 243.779 80.5341 243.779C80.078 243.779 79.6264 243.869 79.205 244.043C78.7836 244.218 78.4007 244.474 78.0782 244.796C77.7556 245.119 77.4998 245.502 77.3252 245.923C77.1507 246.344 77.0609 246.796 77.0609 247.252ZM84.0074 247.252C84.0074 248.173 84.3734 249.057 85.0247 249.708C85.6761 250.36 86.5596 250.726 87.4807 250.726C88.4019 250.726 89.2854 250.36 89.9367 249.708C90.5881 249.057 90.954 248.173 90.954 247.252C90.954 246.331 90.5881 245.448 89.9367 244.796C89.2854 244.145 88.4019 243.779 87.4807 243.779C86.5596 243.779 85.6761 244.145 85.0247 244.796C84.3734 245.448 84.0074 246.331 84.0074 247.252ZM90.954 247.252C90.954 248.173 91.32 249.057 91.9713 249.708C92.6227 250.36 93.5061 250.726 94.4273 250.726C95.3485 250.726 96.2319 250.36 96.8833 249.708C97.5347 249.057 97.9006 248.173 97.9006 247.252C97.9006 246.331 97.5347 245.448 96.8833 244.796C96.2319 244.145 95.3485 243.779 94.4273 243.779C93.5061 243.779 92.6227 244.145 91.9713 244.796C91.32 245.448 90.954 246.331 90.954 247.252ZM104.847 247.252C104.847 248.173 105.213 249.057 105.865 249.708C106.516 250.36 107.399 250.726 108.321 250.726C109.242 250.726 110.125 250.36 110.776 249.708C111.428 249.057 111.794 248.173 111.794 247.252C111.794 246.331 111.428 245.448 110.776 244.796C110.125 244.145 109.242 243.779 108.321 243.779C107.399 243.779 106.516 244.145 105.865 244.796C105.213 245.448 104.847 246.331 104.847 247.252ZM132.634 247.252C132.634 248.173 132.999 249.057 133.651 249.708C134.302 250.36 135.186 250.726 136.107 250.726C137.028 250.726 137.911 250.36 138.563 249.708C139.214 249.057 139.58 248.173 139.58 247.252C139.58 246.331 139.214 245.448 138.563 244.796C137.911 244.145 137.028 243.779 136.107 243.779C135.186 243.779 134.302 244.145 133.651 244.796C132.999 245.448 132.634 246.331 132.634 247.252ZM153.473 247.252C153.473 247.708 153.563 248.16 153.738 248.581C153.912 249.003 154.168 249.386 154.491 249.708C154.813 250.031 155.196 250.287 155.617 250.461C156.039 250.636 156.491 250.726 156.947 250.726C157.403 250.726 157.854 250.636 158.276 250.461C158.697 250.287 159.08 250.031 159.403 249.708C159.725 249.386 159.981 249.003 160.156 248.581C160.33 248.16 160.42 247.708 160.42 247.252C160.42 246.796 160.33 246.344 160.156 245.923C159.981 245.502 159.725 245.119 159.403 244.796C159.08 244.474 158.697 244.218 158.276 244.043C157.854 243.869 157.403 243.779 156.947 243.779C156.491 243.779 156.039 243.869 155.617 244.043C155.196 244.218 154.813 244.474 154.491 244.796C154.168 245.119 153.912 245.502 153.738 245.923C153.563 246.344 153.473 246.796 153.473 247.252ZM167.366 247.252C167.366 248.173 167.732 249.057 168.384 249.708C169.035 250.36 169.919 250.726 170.84 250.726C171.761 250.726 172.644 250.36 173.296 249.708C173.947 249.057 174.313 248.173 174.313 247.252C174.313 246.331 173.947 245.448 173.296 244.796C172.644 244.145 171.761 243.779 170.84 243.779C169.919 243.779 169.035 244.145 168.384 244.796C167.732 245.448 167.366 246.331 167.366 247.252ZM174.313 247.252C174.313 248.173 174.679 249.057 175.33 249.708C175.982 250.36 176.865 250.726 177.786 250.726C178.708 250.726 179.591 250.36 180.242 249.708C180.894 249.057 181.26 248.173 181.26 247.252C181.26 246.331 180.894 245.448 180.242 244.796C179.591 244.145 178.708 243.779 177.786 243.779C176.865 243.779 175.982 244.145 175.33 244.796C174.679 245.448 174.313 246.331 174.313 247.252ZM188.206 247.252C188.206 248.173 188.572 249.057 189.224 249.708C189.875 250.36 190.758 250.726 191.68 250.726C192.601 250.726 193.484 250.36 194.136 249.708C194.787 249.057 195.153 248.173 195.153 247.252C195.153 246.331 194.787 245.448 194.136 244.796C193.484 244.145 192.601 243.779 191.68 243.779C190.758 243.779 189.875 244.145 189.224 244.796C188.572 245.448 188.206 246.331 188.206 247.252ZM195.153 247.252C195.153 247.708 195.243 248.16 195.417 248.581C195.592 249.003 195.848 249.386 196.17 249.708C196.493 250.031 196.876 250.287 197.297 250.461C197.718 250.636 198.17 250.726 198.626 250.726C199.082 250.726 199.534 250.636 199.955 250.461C200.377 250.287 200.76 250.031 201.082 249.708C201.405 249.386 201.661 249.003 201.835 248.581C202.01 248.16 202.099 247.708 202.099 247.252C202.099 246.796 202.01 246.344 201.835 245.923C201.661 245.502 201.405 245.119 201.082 244.796C200.76 244.474 200.377 244.218 199.955 244.043C199.534 243.869 199.082 243.779 198.626 243.779C198.17 243.779 197.718 243.869 197.297 244.043C196.876 244.218 196.493 244.474 196.17 244.796C195.848 245.119 195.592 245.502 195.417 245.923C195.243 246.344 195.153 246.796 195.153 247.252ZM215.993 247.252C215.993 248.173 216.359 249.057 217.01 249.708C217.661 250.36 218.545 250.726 219.466 250.726C220.387 250.726 221.271 250.36 221.922 249.708C222.573 249.057 222.939 248.173 222.939 247.252C222.939 246.331 222.573 245.448 221.922 244.796C221.271 244.145 220.387 243.779 219.466 243.779C218.545 243.779 217.661 244.145 217.01 244.796C216.359 245.448 215.993 246.331 215.993 247.252ZM222.939 247.252C222.939 248.173 223.305 249.057 223.957 249.708C224.608 250.36 225.491 250.726 226.413 250.726C227.334 250.726 228.217 250.36 228.868 249.708C229.52 249.057 229.886 248.173 229.886 247.252C229.886 246.331 229.52 245.448 228.868 244.796C228.217 244.145 227.334 243.779 226.413 243.779C225.491 243.779 224.608 244.145 223.957 244.796C223.305 245.448 222.939 246.331 222.939 247.252ZM229.886 247.252C229.886 248.173 230.252 249.057 230.903 249.708C231.554 250.36 232.438 250.726 233.359 250.726C234.28 250.726 235.164 250.36 235.815 249.708C236.466 249.057 236.832 248.173 236.832 247.252C236.832 246.331 236.466 245.448 235.815 244.796C235.164 244.145 234.28 243.779 233.359 243.779C232.438 243.779 231.554 244.145 230.903 244.796C230.252 245.448 229.886 246.331 229.886 247.252ZM243.779 247.252C243.779 248.173 244.145 249.057 244.796 249.708C245.448 250.36 246.331 250.726 247.252 250.726C248.173 250.726 249.057 250.36 249.708 249.708C250.36 249.057 250.726 248.173 250.726 247.252C250.726 246.331 250.36 245.448 249.708 244.796C249.057 244.145 248.173 243.779 247.252 243.779C246.331 243.779 245.448 244.145 244.796 244.796C244.145 245.448 243.779 246.331 243.779 247.252ZM257.672 247.252C257.672 248.173 258.038 249.057 258.689 249.708C259.341 250.36 260.224 250.726 261.145 250.726C262.067 250.726 262.95 250.36 263.601 249.708C264.253 249.057 264.619 248.173 264.619 247.252C264.619 246.331 264.253 245.448 263.601 244.796C262.95 244.145 262.067 243.779 261.145 243.779C260.224 243.779 259.341 244.145 258.689 244.796C258.038 245.448 257.672 246.331 257.672 247.252ZM264.619 247.252C264.619 248.173 264.985 249.057 265.636 249.708C266.287 250.36 267.171 250.726 268.092 250.726C269.013 250.726 269.897 250.36 270.548 249.708C271.199 249.057 271.565 248.173 271.565 247.252C271.565 246.331 271.199 245.448 270.548 244.796C269.897 244.145 269.013 243.779 268.092 243.779C267.171 243.779 266.287 244.145 265.636 244.796C264.985 245.448 264.619 246.331 264.619 247.252ZM285.458 247.252C285.458 248.173 285.824 249.057 286.476 249.708C287.127 250.36 288.011 250.726 288.932 250.726C289.853 250.726 290.736 250.36 291.388 249.708C292.039 249.057 292.405 248.173 292.405 247.252C292.405 246.331 292.039 245.448 291.388 244.796C290.736 244.145 289.853 243.779 288.932 243.779C288.011 243.779 287.127 244.145 286.476 244.796C285.824 245.448 285.458 246.331 285.458 247.252ZM7.59497 254.199C7.59497 255.12 7.96091 256.003 8.61227 256.655C9.26364 257.306 10.1471 257.672 11.0683 257.672C11.9894 257.672 12.8729 257.306 13.5243 256.655C14.1756 256.003 14.5416 255.12 14.5416 254.199C14.5416 253.278 14.1756 252.394 13.5243 251.743C12.8729 251.091 11.9894 250.726 11.0683 250.726C10.1471 250.726 9.26364 251.091 8.61227 251.743C7.96091 252.394 7.59497 253.278 7.59497 254.199ZM49.2745 254.199C49.2745 254.655 49.3643 255.107 49.5389 255.528C49.7134 255.949 49.9693 256.332 50.2918 256.655C50.6143 256.977 50.9972 257.233 51.4186 257.408C51.84 257.582 52.2917 257.672 52.7478 257.672C53.2039 257.672 53.6556 257.582 54.077 257.408C54.4984 257.233 54.8813 256.977 55.2038 256.655C55.5263 256.332 55.7821 255.949 55.9567 255.528C56.1312 255.107 56.2211 254.655 56.2211 254.199C56.2211 253.743 56.1312 253.291 55.9567 252.87C55.7821 252.448 55.5263 252.065 55.2038 251.743C54.8813 251.42 54.4984 251.164 54.077 250.99C53.6556 250.815 53.2039 250.726 52.7478 250.726C52.2917 250.726 51.84 250.815 51.4186 250.99C50.9972 251.164 50.6143 251.42 50.2918 251.743C49.9693 252.065 49.7134 252.448 49.5389 252.87C49.3643 253.291 49.2745 253.743 49.2745 254.199ZM63.1677 254.199C63.1677 255.12 63.5336 256.003 64.185 256.655C64.8363 257.306 65.7198 257.672 66.641 257.672C67.5621 257.672 68.4456 257.306 69.097 256.655C69.7483 256.003 70.1143 255.12 70.1143 254.199C70.1143 253.278 69.7483 252.394 69.097 251.743C68.4456 251.091 67.5621 250.726 66.641 250.726C65.7198 250.726 64.8363 251.091 64.185 251.743C63.5336 252.394 63.1677 253.278 63.1677 254.199ZM77.0609 254.199C77.0609 254.655 77.1507 255.107 77.3252 255.528C77.4998 255.949 77.7556 256.332 78.0782 256.655C78.4007 256.977 78.7836 257.233 79.205 257.408C79.6264 257.582 80.078 257.672 80.5341 257.672C80.9903 257.672 81.4419 257.582 81.8633 257.408C82.2847 257.233 82.6676 256.977 82.9901 256.655C83.3127 256.332 83.5685 255.949 83.743 255.528C83.9176 255.107 84.0074 254.655 84.0074 254.199C84.0074 253.743 83.9176 253.291 83.743 252.87C83.5685 252.448 83.3127 252.065 82.9901 251.743C82.6676 251.42 82.2847 251.164 81.8633 250.99C81.4419 250.815 80.9903 250.726 80.5341 250.726C80.078 250.726 79.6264 250.815 79.205 250.99C78.7836 251.164 78.4007 251.42 78.0782 251.743C77.7556 252.065 77.4998 252.448 77.3252 252.87C77.1507 253.291 77.0609 253.743 77.0609 254.199ZM90.954 254.199C90.954 255.12 91.32 256.003 91.9713 256.655C92.6227 257.306 93.5061 257.672 94.4273 257.672C95.3485 257.672 96.2319 257.306 96.8833 256.655C97.5347 256.003 97.9006 255.12 97.9006 254.199C97.9006 253.278 97.5347 252.394 96.8833 251.743C96.2319 251.091 95.3485 250.726 94.4273 250.726C93.5061 250.726 92.6227 251.091 91.9713 251.743C91.32 252.394 90.954 253.278 90.954 254.199ZM118.74 254.199C118.74 255.12 119.106 256.003 119.758 256.655C120.409 257.306 121.292 257.672 122.214 257.672C123.135 257.672 124.018 257.306 124.67 256.655C125.321 256.003 125.687 255.12 125.687 254.199C125.687 253.278 125.321 252.394 124.67 251.743C124.018 251.091 123.135 250.726 122.214 250.726C121.292 250.726 120.409 251.091 119.758 251.743C119.106 252.394 118.74 253.278 118.74 254.199ZM132.634 254.199C132.634 255.12 132.999 256.003 133.651 256.655C134.302 257.306 135.186 257.672 136.107 257.672C137.028 257.672 137.911 257.306 138.563 256.655C139.214 256.003 139.58 255.12 139.58 254.199C139.58 253.278 139.214 252.394 138.563 251.743C137.911 251.091 137.028 250.726 136.107 250.726C135.186 250.726 134.302 251.091 133.651 251.743C132.999 252.394 132.634 253.278 132.634 254.199ZM146.527 254.199C146.527 255.12 146.893 256.003 147.544 256.655C148.195 257.306 149.079 257.672 150 257.672C150.921 257.672 151.805 257.306 152.456 256.655C153.107 256.003 153.473 255.12 153.473 254.199C153.473 253.278 153.107 252.394 152.456 251.743C151.805 251.091 150.921 250.726 150 250.726C149.079 250.726 148.195 251.091 147.544 251.743C146.893 252.394 146.527 253.278 146.527 254.199ZM167.366 254.199C167.366 255.12 167.732 256.003 168.384 256.655C169.035 257.306 169.919 257.672 170.84 257.672C171.761 257.672 172.644 257.306 173.296 256.655C173.947 256.003 174.313 255.12 174.313 254.199C174.313 253.278 173.947 252.394 173.296 251.743C172.644 251.091 171.761 250.726 170.84 250.726C169.919 250.726 169.035 251.091 168.384 251.743C167.732 252.394 167.366 253.278 167.366 254.199ZM181.26 254.199C181.26 255.12 181.626 256.003 182.277 256.655C182.928 257.306 183.812 257.672 184.733 257.672C185.654 257.672 186.538 257.306 187.189 256.655C187.84 256.003 188.206 255.12 188.206 254.199C188.206 253.278 187.84 252.394 187.189 251.743C186.538 251.091 185.654 250.726 184.733 250.726C183.812 250.726 182.928 251.091 182.277 251.743C181.626 252.394 181.26 253.278 181.26 254.199ZM188.206 254.199C188.206 255.12 188.572 256.003 189.224 256.655C189.875 257.306 190.758 257.672 191.68 257.672C192.601 257.672 193.484 257.306 194.136 256.655C194.787 256.003 195.153 255.12 195.153 254.199C195.153 253.278 194.787 252.394 194.136 251.743C193.484 251.091 192.601 250.726 191.68 250.726C190.758 250.726 189.875 251.091 189.224 251.743C188.572 252.394 188.206 253.278 188.206 254.199ZM222.939 254.199C222.939 255.12 223.305 256.003 223.957 256.655C224.608 257.306 225.491 257.672 226.413 257.672C227.334 257.672 228.217 257.306 228.868 256.655C229.52 256.003 229.886 255.12 229.886 254.199C229.886 253.278 229.52 252.394 228.868 251.743C228.217 251.091 227.334 250.726 226.413 250.726C225.491 250.726 224.608 251.091 223.957 251.743C223.305 252.394 222.939 253.278 222.939 254.199ZM229.886 254.199C229.886 255.12 230.252 256.003 230.903 256.655C231.554 257.306 232.438 257.672 233.359 257.672C234.28 257.672 235.164 257.306 235.815 256.655C236.466 256.003 236.832 255.12 236.832 254.199C236.832 253.278 236.466 252.394 235.815 251.743C235.164 251.091 234.28 250.726 233.359 250.726C232.438 250.726 231.554 251.091 230.903 251.743C230.252 252.394 229.886 253.278 229.886 254.199ZM257.672 254.199C257.672 255.12 258.038 256.003 258.689 256.655C259.341 257.306 260.224 257.672 261.145 257.672C262.067 257.672 262.95 257.306 263.601 256.655C264.253 256.003 264.619 255.12 264.619 254.199C264.619 253.278 264.253 252.394 263.601 251.743C262.95 251.091 262.067 250.726 261.145 250.726C260.224 250.726 259.341 251.091 258.689 251.743C258.038 252.394 257.672 253.278 257.672 254.199ZM285.458 254.199C285.458 255.12 285.824 256.003 286.476 256.655C287.127 257.306 288.011 257.672 288.932 257.672C289.853 257.672 290.736 257.306 291.388 256.655C292.039 256.003 292.405 255.12 292.405 254.199C292.405 253.278 292.039 252.394 291.388 251.743C290.736 251.091 289.853 250.726 288.932 250.726C288.011 250.726 287.127 251.091 286.476 251.743C285.824 252.394 285.458 253.278 285.458 254.199ZM7.59497 261.145C7.59497 262.067 7.96091 262.95 8.61227 263.601C9.26364 264.253 10.1471 264.619 11.0683 264.619C11.9894 264.619 12.8729 264.253 13.5243 263.601C14.1756 262.95 14.5416 262.067 14.5416 261.145C14.5416 260.224 14.1756 259.341 13.5243 258.689C12.8729 258.038 11.9894 257.672 11.0683 257.672C10.1471 257.672 9.26364 258.038 8.61227 258.689C7.96091 259.341 7.59497 260.224 7.59497 261.145ZM21.4881 261.145C21.4881 262.067 21.8541 262.95 22.5055 263.601C23.1568 264.253 24.0403 264.619 24.9614 264.619C25.8826 264.619 26.7661 264.253 27.4174 263.601C28.0688 262.95 28.4347 262.067 28.4347 261.145C28.4347 260.224 28.0688 259.341 27.4174 258.689C26.7661 258.038 25.8826 257.672 24.9614 257.672C24.0403 257.672 23.1568 258.038 22.5055 258.689C21.8541 259.341 21.4881 260.224 21.4881 261.145ZM28.4347 261.145C28.4347 262.067 28.8007 262.95 29.452 263.601C30.1034 264.253 30.9869 264.619 31.908 264.619C32.8292 264.619 33.7126 264.253 34.364 263.601C35.0154 262.95 35.3813 262.067 35.3813 261.145C35.3813 260.224 35.0154 259.341 34.364 258.689C33.7126 258.038 32.8292 257.672 31.908 257.672C30.9869 257.672 30.1034 258.038 29.452 258.689C28.8007 259.341 28.4347 260.224 28.4347 261.145ZM35.3813 261.145C35.3813 262.067 35.7473 262.95 36.3986 263.601C37.05 264.253 37.9334 264.619 38.8546 264.619C39.7758 264.619 40.6592 264.253 41.3106 263.601C41.962 262.95 42.3279 262.067 42.3279 261.145C42.3279 260.224 41.962 259.341 41.3106 258.689C40.6592 258.038 39.7758 257.672 38.8546 257.672C37.9334 257.672 37.05 258.038 36.3986 258.689C35.7473 259.341 35.3813 260.224 35.3813 261.145ZM49.2745 261.145C49.2745 261.602 49.3643 262.053 49.5389 262.475C49.7134 262.896 49.9693 263.279 50.2918 263.601C50.6143 263.924 50.9972 264.18 51.4186 264.354C51.84 264.529 52.2917 264.619 52.7478 264.619C53.2039 264.619 53.6556 264.529 54.077 264.354C54.4984 264.18 54.8813 263.924 55.2038 263.601C55.5263 263.279 55.7821 262.896 55.9567 262.475C56.1312 262.053 56.2211 261.602 56.2211 261.145C56.2211 260.689 56.1312 260.238 55.9567 259.816C55.7821 259.395 55.5263 259.012 55.2038 258.689C54.8813 258.367 54.4984 258.111 54.077 257.936C53.6556 257.762 53.2039 257.672 52.7478 257.672C52.2917 257.672 51.84 257.762 51.4186 257.936C50.9972 258.111 50.6143 258.367 50.2918 258.689C49.9693 259.012 49.7134 259.395 49.5389 259.816C49.3643 260.238 49.2745 260.689 49.2745 261.145ZM63.1677 261.145C63.1677 262.067 63.5336 262.95 64.185 263.601C64.8363 264.253 65.7198 264.619 66.641 264.619C67.5621 264.619 68.4456 264.253 69.097 263.601C69.7483 262.95 70.1143 262.067 70.1143 261.145C70.1143 260.224 69.7483 259.341 69.097 258.689C68.4456 258.038 67.5621 257.672 66.641 257.672C65.7198 257.672 64.8363 258.038 64.185 258.689C63.5336 259.341 63.1677 260.224 63.1677 261.145ZM70.1143 261.145C70.1143 262.067 70.4802 262.95 71.1316 263.601C71.7829 264.253 72.6664 264.619 73.5876 264.619C74.5087 264.619 75.3922 264.253 76.0436 263.601C76.6949 262.95 77.0609 262.067 77.0609 261.145C77.0609 260.224 76.6949 259.341 76.0436 258.689C75.3922 258.038 74.5087 257.672 73.5876 257.672C72.6664 257.672 71.7829 258.038 71.1316 258.689C70.4802 259.341 70.1143 260.224 70.1143 261.145ZM97.9006 261.145C97.9006 261.602 97.9905 262.053 98.165 262.475C98.3396 262.896 98.5954 263.279 98.9179 263.601C99.2404 263.924 99.6233 264.18 100.045 264.354C100.466 264.529 100.918 264.619 101.374 264.619C101.83 264.619 102.282 264.529 102.703 264.354C103.124 264.18 103.507 263.924 103.83 263.601C104.152 263.279 104.408 262.896 104.583 262.475C104.757 262.053 104.847 261.602 104.847 261.145C104.847 260.689 104.757 260.238 104.583 259.816C104.408 259.395 104.152 259.012 103.83 258.689C103.507 258.367 103.124 258.111 102.703 257.936C102.282 257.762 101.83 257.672 101.374 257.672C100.918 257.672 100.466 257.762 100.045 257.936C99.6233 258.111 99.2404 258.367 98.9179 258.689C98.5954 259.012 98.3396 259.395 98.165 259.816C97.9905 260.238 97.9006 260.689 97.9006 261.145ZM125.687 261.145C125.687 262.067 126.053 262.95 126.704 263.601C127.356 264.253 128.239 264.619 129.16 264.619C130.081 264.619 130.965 264.253 131.616 263.601C132.268 262.95 132.634 262.067 132.634 261.145C132.634 260.224 132.268 259.341 131.616 258.689C130.965 258.038 130.081 257.672 129.16 257.672C128.239 257.672 127.356 258.038 126.704 258.689C126.053 259.341 125.687 260.224 125.687 261.145ZM132.634 261.145C132.634 262.067 132.999 262.95 133.651 263.601C134.302 264.253 135.186 264.619 136.107 264.619C137.028 264.619 137.911 264.253 138.563 263.601C139.214 262.95 139.58 262.067 139.58 261.145C139.58 260.224 139.214 259.341 138.563 258.689C137.911 258.038 137.028 257.672 136.107 257.672C135.186 257.672 134.302 258.038 133.651 258.689C132.999 259.341 132.634 260.224 132.634 261.145ZM153.473 261.145C153.473 261.602 153.563 262.053 153.738 262.475C153.912 262.896 154.168 263.279 154.491 263.601C154.813 263.924 155.196 264.18 155.617 264.354C156.039 264.529 156.491 264.619 156.947 264.619C157.403 264.619 157.854 264.529 158.276 264.354C158.697 264.18 159.08 263.924 159.403 263.601C159.725 263.279 159.981 262.896 160.156 262.475C160.33 262.053 160.42 261.602 160.42 261.145C160.42 260.689 160.33 260.238 160.156 259.816C159.981 259.395 159.725 259.012 159.403 258.689C159.08 258.367 158.697 258.111 158.276 257.936C157.854 257.762 157.403 257.672 156.947 257.672C156.491 257.672 156.039 257.762 155.617 257.936C155.196 258.111 154.813 258.367 154.491 258.689C154.168 259.012 153.912 259.395 153.738 259.816C153.563 260.238 153.473 260.689 153.473 261.145ZM167.366 261.145C167.366 262.067 167.732 262.95 168.384 263.601C169.035 264.253 169.919 264.619 170.84 264.619C171.761 264.619 172.644 264.253 173.296 263.601C173.947 262.95 174.313 262.067 174.313 261.145C174.313 260.224 173.947 259.341 173.296 258.689C172.644 258.038 171.761 257.672 170.84 257.672C169.919 257.672 169.035 258.038 168.384 258.689C167.732 259.341 167.366 260.224 167.366 261.145ZM174.313 261.145C174.313 262.067 174.679 262.95 175.33 263.601C175.982 264.253 176.865 264.619 177.786 264.619C178.708 264.619 179.591 264.253 180.242 263.601C180.894 262.95 181.26 262.067 181.26 261.145C181.26 260.224 180.894 259.341 180.242 258.689C179.591 258.038 178.708 257.672 177.786 257.672C176.865 257.672 175.982 258.038 175.33 258.689C174.679 259.341 174.313 260.224 174.313 261.145ZM188.206 261.145C188.206 262.067 188.572 262.95 189.224 263.601C189.875 264.253 190.758 264.619 191.68 264.619C192.601 264.619 193.484 264.253 194.136 263.601C194.787 262.95 195.153 262.067 195.153 261.145C195.153 260.224 194.787 259.341 194.136 258.689C193.484 258.038 192.601 257.672 191.68 257.672C190.758 257.672 189.875 258.038 189.224 258.689C188.572 259.341 188.206 260.224 188.206 261.145ZM222.939 261.145C222.939 262.067 223.305 262.95 223.957 263.601C224.608 264.253 225.491 264.619 226.413 264.619C227.334 264.619 228.217 264.253 228.868 263.601C229.52 262.95 229.886 262.067 229.886 261.145C229.886 260.224 229.52 259.341 228.868 258.689C228.217 258.038 227.334 257.672 226.413 257.672C225.491 257.672 224.608 258.038 223.957 258.689C223.305 259.341 222.939 260.224 222.939 261.145ZM229.886 261.145C229.886 262.067 230.252 262.95 230.903 263.601C231.554 264.253 232.438 264.619 233.359 264.619C234.28 264.619 235.164 264.253 235.815 263.601C236.466 262.95 236.832 262.067 236.832 261.145C236.832 260.224 236.466 259.341 235.815 258.689C235.164 258.038 234.28 257.672 233.359 257.672C232.438 257.672 231.554 258.038 230.903 258.689C230.252 259.341 229.886 260.224 229.886 261.145ZM236.832 261.145C236.832 262.067 237.198 262.95 237.85 263.601C238.501 264.253 239.384 264.619 240.306 264.619C241.227 264.619 242.11 264.253 242.762 263.601C243.413 262.95 243.779 262.067 243.779 261.145C243.779 260.224 243.413 259.341 242.762 258.689C242.11 258.038 241.227 257.672 240.306 257.672C239.384 257.672 238.501 258.038 237.85 258.689C237.198 259.341 236.832 260.224 236.832 261.145ZM243.779 261.145C243.779 262.067 244.145 262.95 244.796 263.601C245.448 264.253 246.331 264.619 247.252 264.619C248.173 264.619 249.057 264.253 249.708 263.601C250.36 262.95 250.726 262.067 250.726 261.145C250.726 260.224 250.36 259.341 249.708 258.689C249.057 258.038 248.173 257.672 247.252 257.672C246.331 257.672 245.448 258.038 244.796 258.689C244.145 259.341 243.779 260.224 243.779 261.145ZM250.726 261.145C250.726 262.067 251.091 262.95 251.743 263.601C252.394 264.253 253.278 264.619 254.199 264.619C255.12 264.619 256.003 264.253 256.655 263.601C257.306 262.95 257.672 262.067 257.672 261.145C257.672 260.224 257.306 259.341 256.655 258.689C256.003 258.038 255.12 257.672 254.199 257.672C253.278 257.672 252.394 258.038 251.743 258.689C251.091 259.341 250.726 260.224 250.726 261.145ZM257.672 261.145C257.672 262.067 258.038 262.95 258.689 263.601C259.341 264.253 260.224 264.619 261.145 264.619C262.067 264.619 262.95 264.253 263.601 263.601C264.253 262.95 264.619 262.067 264.619 261.145C264.619 260.224 264.253 259.341 263.601 258.689C262.95 258.038 262.067 257.672 261.145 257.672C260.224 257.672 259.341 258.038 258.689 258.689C258.038 259.341 257.672 260.224 257.672 261.145ZM264.619 261.145C264.619 262.067 264.985 262.95 265.636 263.601C266.287 264.253 267.171 264.619 268.092 264.619C269.013 264.619 269.897 264.253 270.548 263.601C271.199 262.95 271.565 262.067 271.565 261.145C271.565 260.224 271.199 259.341 270.548 258.689C269.897 258.038 269.013 257.672 268.092 257.672C267.171 257.672 266.287 258.038 265.636 258.689C264.985 259.341 264.619 260.224 264.619 261.145ZM7.59497 268.092C7.59497 269.013 7.96091 269.897 8.61227 270.548C9.26364 271.199 10.1471 271.565 11.0683 271.565C11.9894 271.565 12.8729 271.199 13.5243 270.548C14.1756 269.897 14.5416 269.013 14.5416 268.092C14.5416 267.171 14.1756 266.287 13.5243 265.636C12.8729 264.985 11.9894 264.619 11.0683 264.619C10.1471 264.619 9.26364 264.985 8.61227 265.636C7.96091 266.287 7.59497 267.171 7.59497 268.092ZM21.4881 268.092C21.4881 269.013 21.8541 269.897 22.5055 270.548C23.1568 271.199 24.0403 271.565 24.9614 271.565C25.8826 271.565 26.7661 271.199 27.4174 270.548C28.0688 269.897 28.4347 269.013 28.4347 268.092C28.4347 267.171 28.0688 266.287 27.4174 265.636C26.7661 264.985 25.8826 264.619 24.9614 264.619C24.0403 264.619 23.1568 264.985 22.5055 265.636C21.8541 266.287 21.4881 267.171 21.4881 268.092ZM28.4347 268.092C28.4347 269.013 28.8007 269.897 29.452 270.548C30.1034 271.199 30.9869 271.565 31.908 271.565C32.8292 271.565 33.7126 271.199 34.364 270.548C35.0154 269.897 35.3813 269.013 35.3813 268.092C35.3813 267.171 35.0154 266.287 34.364 265.636C33.7126 264.985 32.8292 264.619 31.908 264.619C30.9869 264.619 30.1034 264.985 29.452 265.636C28.8007 266.287 28.4347 267.171 28.4347 268.092ZM35.3813 268.092C35.3813 269.013 35.7473 269.897 36.3986 270.548C37.05 271.199 37.9334 271.565 38.8546 271.565C39.7758 271.565 40.6592 271.199 41.3106 270.548C41.962 269.897 42.3279 269.013 42.3279 268.092C42.3279 267.171 41.962 266.287 41.3106 265.636C40.6592 264.985 39.7758 264.619 38.8546 264.619C37.9334 264.619 37.05 264.985 36.3986 265.636C35.7473 266.287 35.3813 267.171 35.3813 268.092ZM49.2745 268.092C49.2745 268.548 49.3643 269 49.5389 269.421C49.7134 269.843 49.9693 270.225 50.2918 270.548C50.6143 270.871 50.9972 271.126 51.4186 271.301C51.84 271.475 52.2917 271.565 52.7478 271.565C53.2039 271.565 53.6556 271.475 54.077 271.301C54.4984 271.126 54.8813 270.871 55.2038 270.548C55.5263 270.225 55.7821 269.843 55.9567 269.421C56.1312 269 56.2211 268.548 56.2211 268.092C56.2211 267.636 56.1312 267.184 55.9567 266.763C55.7821 266.341 55.5263 265.959 55.2038 265.636C54.8813 265.313 54.4984 265.058 54.077 264.883C53.6556 264.709 53.2039 264.619 52.7478 264.619C52.2917 264.619 51.84 264.709 51.4186 264.883C50.9972 265.058 50.6143 265.313 50.2918 265.636C49.9693 265.959 49.7134 266.341 49.5389 266.763C49.3643 267.184 49.2745 267.636 49.2745 268.092ZM77.0609 268.092C77.0609 268.548 77.1507 269 77.3252 269.421C77.4998 269.843 77.7556 270.225 78.0782 270.548C78.4007 270.871 78.7836 271.126 79.205 271.301C79.6264 271.475 80.078 271.565 80.5341 271.565C80.9903 271.565 81.4419 271.475 81.8633 271.301C82.2847 271.126 82.6676 270.871 82.9901 270.548C83.3127 270.225 83.5685 269.843 83.743 269.421C83.9176 269 84.0074 268.548 84.0074 268.092C84.0074 267.636 83.9176 267.184 83.743 266.763C83.5685 266.341 83.3127 265.959 82.9901 265.636C82.6676 265.313 82.2847 265.058 81.8633 264.883C81.4419 264.709 80.9903 264.619 80.5341 264.619C80.078 264.619 79.6264 264.709 79.205 264.883C78.7836 265.058 78.4007 265.313 78.0782 265.636C77.7556 265.959 77.4998 266.341 77.3252 266.763C77.1507 267.184 77.0609 267.636 77.0609 268.092ZM84.0074 268.092C84.0074 269.013 84.3734 269.897 85.0247 270.548C85.6761 271.199 86.5596 271.565 87.4807 271.565C88.4019 271.565 89.2854 271.199 89.9367 270.548C90.5881 269.897 90.954 269.013 90.954 268.092C90.954 267.171 90.5881 266.287 89.9367 265.636C89.2854 264.985 88.4019 264.619 87.4807 264.619C86.5596 264.619 85.6761 264.985 85.0247 265.636C84.3734 266.287 84.0074 267.171 84.0074 268.092ZM104.847 268.092C104.847 269.013 105.213 269.897 105.865 270.548C106.516 271.199 107.399 271.565 108.321 271.565C109.242 271.565 110.125 271.199 110.776 270.548C111.428 269.897 111.794 269.013 111.794 268.092C111.794 267.171 111.428 266.287 110.776 265.636C110.125 264.985 109.242 264.619 108.321 264.619C107.399 264.619 106.516 264.985 105.865 265.636C105.213 266.287 104.847 267.171 104.847 268.092ZM153.473 268.092C153.473 268.548 153.563 269 153.738 269.421C153.912 269.843 154.168 270.225 154.491 270.548C154.813 270.871 155.196 271.126 155.617 271.301C156.039 271.475 156.491 271.565 156.947 271.565C157.403 271.565 157.854 271.475 158.276 271.301C158.697 271.126 159.08 270.871 159.403 270.548C159.725 270.225 159.981 269.843 160.156 269.421C160.33 269 160.42 268.548 160.42 268.092C160.42 267.636 160.33 267.184 160.156 266.763C159.981 266.341 159.725 265.959 159.403 265.636C159.08 265.313 158.697 265.058 158.276 264.883C157.854 264.709 157.403 264.619 156.947 264.619C156.491 264.619 156.039 264.709 155.617 264.883C155.196 265.058 154.813 265.313 154.491 265.636C154.168 265.959 153.912 266.341 153.738 266.763C153.563 267.184 153.473 267.636 153.473 268.092ZM174.313 268.092C174.313 269.013 174.679 269.897 175.33 270.548C175.982 271.199 176.865 271.565 177.786 271.565C178.708 271.565 179.591 271.199 180.242 270.548C180.894 269.897 181.26 269.013 181.26 268.092C181.26 267.171 180.894 266.287 180.242 265.636C179.591 264.985 178.708 264.619 177.786 264.619C176.865 264.619 175.982 264.985 175.33 265.636C174.679 266.287 174.313 267.171 174.313 268.092ZM181.26 268.092C181.26 269.013 181.626 269.897 182.277 270.548C182.928 271.199 183.812 271.565 184.733 271.565C185.654 271.565 186.538 271.199 187.189 270.548C187.84 269.897 188.206 269.013 188.206 268.092C188.206 267.171 187.84 266.287 187.189 265.636C186.538 264.985 185.654 264.619 184.733 264.619C183.812 264.619 182.928 264.985 182.277 265.636C181.626 266.287 181.26 267.171 181.26 268.092ZM188.206 268.092C188.206 269.013 188.572 269.897 189.224 270.548C189.875 271.199 190.758 271.565 191.68 271.565C192.601 271.565 193.484 271.199 194.136 270.548C194.787 269.897 195.153 269.013 195.153 268.092C195.153 267.171 194.787 266.287 194.136 265.636C193.484 264.985 192.601 264.619 191.68 264.619C190.758 264.619 189.875 264.985 189.224 265.636C188.572 266.287 188.206 267.171 188.206 268.092ZM195.153 268.092C195.153 268.548 195.243 269 195.417 269.421C195.592 269.843 195.848 270.225 196.17 270.548C196.493 270.871 196.876 271.126 197.297 271.301C197.718 271.475 198.17 271.565 198.626 271.565C199.082 271.565 199.534 271.475 199.955 271.301C200.377 271.126 200.76 270.871 201.082 270.548C201.405 270.225 201.661 269.843 201.835 269.421C202.01 269 202.099 268.548 202.099 268.092C202.099 267.636 202.01 267.184 201.835 266.763C201.661 266.341 201.405 265.959 201.082 265.636C200.76 265.313 200.377 265.058 199.955 264.883C199.534 264.709 199.082 264.619 198.626 264.619C198.17 264.619 197.718 264.709 197.297 264.883C196.876 265.058 196.493 265.313 196.17 265.636C195.848 265.959 195.592 266.341 195.417 266.763C195.243 267.184 195.153 267.636 195.153 268.092ZM202.099 268.092C202.099 269.013 202.465 269.897 203.117 270.548C203.768 271.199 204.652 271.565 205.573 271.565C206.494 271.565 207.377 271.199 208.029 270.548C208.68 269.897 209.046 269.013 209.046 268.092C209.046 267.171 208.68 266.287 208.029 265.636C207.377 264.985 206.494 264.619 205.573 264.619C204.652 264.619 203.768 264.985 203.117 265.636C202.465 266.287 202.099 267.171 202.099 268.092ZM209.046 268.092C209.046 269.013 209.412 269.897 210.063 270.548C210.715 271.199 211.598 271.565 212.519 271.565C213.44 271.565 214.324 271.199 214.975 270.548C215.627 269.897 215.993 269.013 215.993 268.092C215.993 267.171 215.627 266.287 214.975 265.636C214.324 264.985 213.44 264.619 212.519 264.619C211.598 264.619 210.715 264.985 210.063 265.636C209.412 266.287 209.046 267.171 209.046 268.092ZM215.993 268.092C215.993 269.013 216.359 269.897 217.01 270.548C217.661 271.199 218.545 271.565 219.466 271.565C220.387 271.565 221.271 271.199 221.922 270.548C222.573 269.897 222.939 269.013 222.939 268.092C222.939 267.171 222.573 266.287 221.922 265.636C221.271 264.985 220.387 264.619 219.466 264.619C218.545 264.619 217.661 264.985 217.01 265.636C216.359 266.287 215.993 267.171 215.993 268.092ZM250.726 268.092C250.726 269.013 251.091 269.897 251.743 270.548C252.394 271.199 253.278 271.565 254.199 271.565C255.12 271.565 256.003 271.199 256.655 270.548C257.306 269.897 257.672 269.013 257.672 268.092C257.672 267.171 257.306 266.287 256.655 265.636C256.003 264.985 255.12 264.619 254.199 264.619C253.278 264.619 252.394 264.985 251.743 265.636C251.091 266.287 250.726 267.171 250.726 268.092ZM285.458 268.092C285.458 269.013 285.824 269.897 286.476 270.548C287.127 271.199 288.011 271.565 288.932 271.565C289.853 271.565 290.736 271.199 291.388 270.548C292.039 269.897 292.405 269.013 292.405 268.092C292.405 267.171 292.039 266.287 291.388 265.636C290.736 264.985 289.853 264.619 288.932 264.619C288.011 264.619 287.127 264.985 286.476 265.636C285.824 266.287 285.458 267.171 285.458 268.092ZM7.59497 275.039C7.59497 275.96 7.96091 276.843 8.61227 277.495C9.26364 278.146 10.1471 278.512 11.0683 278.512C11.9894 278.512 12.8729 278.146 13.5243 277.495C14.1756 276.843 14.5416 275.96 14.5416 275.039C14.5416 274.117 14.1756 273.234 13.5243 272.583C12.8729 271.931 11.9894 271.565 11.0683 271.565C10.1471 271.565 9.26364 271.931 8.61227 272.583C7.96091 273.234 7.59497 274.117 7.59497 275.039ZM21.4881 275.039C21.4881 275.96 21.8541 276.843 22.5055 277.495C23.1568 278.146 24.0403 278.512 24.9614 278.512C25.8826 278.512 26.7661 278.146 27.4174 277.495C28.0688 276.843 28.4347 275.96 28.4347 275.039C28.4347 274.117 28.0688 273.234 27.4174 272.583C26.7661 271.931 25.8826 271.565 24.9614 271.565C24.0403 271.565 23.1568 271.931 22.5055 272.583C21.8541 273.234 21.4881 274.117 21.4881 275.039ZM28.4347 275.039C28.4347 275.96 28.8007 276.843 29.452 277.495C30.1034 278.146 30.9869 278.512 31.908 278.512C32.8292 278.512 33.7126 278.146 34.364 277.495C35.0154 276.843 35.3813 275.96 35.3813 275.039C35.3813 274.117 35.0154 273.234 34.364 272.583C33.7126 271.931 32.8292 271.565 31.908 271.565C30.9869 271.565 30.1034 271.931 29.452 272.583C28.8007 273.234 28.4347 274.117 28.4347 275.039ZM35.3813 275.039C35.3813 275.96 35.7473 276.843 36.3986 277.495C37.05 278.146 37.9334 278.512 38.8546 278.512C39.7758 278.512 40.6592 278.146 41.3106 277.495C41.962 276.843 42.3279 275.96 42.3279 275.039C42.3279 274.117 41.962 273.234 41.3106 272.583C40.6592 271.931 39.7758 271.565 38.8546 271.565C37.9334 271.565 37.05 271.931 36.3986 272.583C35.7473 273.234 35.3813 274.117 35.3813 275.039ZM49.2745 275.039C49.2745 275.495 49.3643 275.946 49.5389 276.368C49.7134 276.789 49.9693 277.172 50.2918 277.495C50.6143 277.817 50.9972 278.073 51.4186 278.247C51.84 278.422 52.2917 278.512 52.7478 278.512C53.2039 278.512 53.6556 278.422 54.077 278.247C54.4984 278.073 54.8813 277.817 55.2038 277.495C55.5263 277.172 55.7821 276.789 55.9567 276.368C56.1312 275.946 56.2211 275.495 56.2211 275.039C56.2211 274.582 56.1312 274.131 55.9567 273.709C55.7821 273.288 55.5263 272.905 55.2038 272.583C54.8813 272.26 54.4984 272.004 54.077 271.83C53.6556 271.655 53.2039 271.565 52.7478 271.565C52.2917 271.565 51.84 271.655 51.4186 271.83C50.9972 272.004 50.6143 272.26 50.2918 272.583C49.9693 272.905 49.7134 273.288 49.5389 273.709C49.3643 274.131 49.2745 274.582 49.2745 275.039ZM70.1143 275.039C70.1143 275.96 70.4802 276.843 71.1316 277.495C71.7829 278.146 72.6664 278.512 73.5876 278.512C74.5087 278.512 75.3922 278.146 76.0436 277.495C76.6949 276.843 77.0609 275.96 77.0609 275.039C77.0609 274.117 76.6949 273.234 76.0436 272.583C75.3922 271.931 74.5087 271.565 73.5876 271.565C72.6664 271.565 71.7829 271.931 71.1316 272.583C70.4802 273.234 70.1143 274.117 70.1143 275.039ZM90.954 275.039C90.954 275.96 91.32 276.843 91.9713 277.495C92.6227 278.146 93.5061 278.512 94.4273 278.512C95.3485 278.512 96.2319 278.146 96.8833 277.495C97.5347 276.843 97.9006 275.96 97.9006 275.039C97.9006 274.117 97.5347 273.234 96.8833 272.583C96.2319 271.931 95.3485 271.565 94.4273 271.565C93.5061 271.565 92.6227 271.931 91.9713 272.583C91.32 273.234 90.954 274.117 90.954 275.039ZM104.847 275.039C104.847 275.96 105.213 276.843 105.865 277.495C106.516 278.146 107.399 278.512 108.321 278.512C109.242 278.512 110.125 278.146 110.776 277.495C111.428 276.843 111.794 275.96 111.794 275.039C111.794 274.117 111.428 273.234 110.776 272.583C110.125 271.931 109.242 271.565 108.321 271.565C107.399 271.565 106.516 271.931 105.865 272.583C105.213 273.234 104.847 274.117 104.847 275.039ZM118.74 275.039C118.74 275.96 119.106 276.843 119.758 277.495C120.409 278.146 121.292 278.512 122.214 278.512C123.135 278.512 124.018 278.146 124.67 277.495C125.321 276.843 125.687 275.96 125.687 275.039C125.687 274.117 125.321 273.234 124.67 272.583C124.018 271.931 123.135 271.565 122.214 271.565C121.292 271.565 120.409 271.931 119.758 272.583C119.106 273.234 118.74 274.117 118.74 275.039ZM139.58 275.039C139.58 275.96 139.946 276.843 140.597 277.495C141.249 278.146 142.132 278.512 143.053 278.512C143.975 278.512 144.858 278.146 145.509 277.495C146.161 276.843 146.527 275.96 146.527 275.039C146.527 274.117 146.161 273.234 145.509 272.583C144.858 271.931 143.975 271.565 143.053 271.565C142.132 271.565 141.249 271.931 140.597 272.583C139.946 273.234 139.58 274.117 139.58 275.039ZM146.527 275.039C146.527 275.96 146.893 276.843 147.544 277.495C148.195 278.146 149.079 278.512 150 278.512C150.921 278.512 151.805 278.146 152.456 277.495C153.107 276.843 153.473 275.96 153.473 275.039C153.473 274.117 153.107 273.234 152.456 272.583C151.805 271.931 150.921 271.565 150 271.565C149.079 271.565 148.195 271.931 147.544 272.583C146.893 273.234 146.527 274.117 146.527 275.039ZM153.473 275.039C153.473 275.495 153.563 275.946 153.738 276.368C153.912 276.789 154.168 277.172 154.491 277.495C154.813 277.817 155.196 278.073 155.617 278.247C156.039 278.422 156.491 278.512 156.947 278.512C157.403 278.512 157.854 278.422 158.276 278.247C158.697 278.073 159.08 277.817 159.403 277.495C159.725 277.172 159.981 276.789 160.156 276.368C160.33 275.946 160.42 275.495 160.42 275.039C160.42 274.582 160.33 274.131 160.156 273.709C159.981 273.288 159.725 272.905 159.403 272.583C159.08 272.26 158.697 272.004 158.276 271.83C157.854 271.655 157.403 271.565 156.947 271.565C156.491 271.565 156.039 271.655 155.617 271.83C155.196 272.004 154.813 272.26 154.491 272.583C154.168 272.905 153.912 273.288 153.738 273.709C153.563 274.131 153.473 274.582 153.473 275.039ZM167.366 275.039C167.366 275.96 167.732 276.843 168.384 277.495C169.035 278.146 169.919 278.512 170.84 278.512C171.761 278.512 172.644 278.146 173.296 277.495C173.947 276.843 174.313 275.96 174.313 275.039C174.313 274.117 173.947 273.234 173.296 272.583C172.644 271.931 171.761 271.565 170.84 271.565C169.919 271.565 169.035 271.931 168.384 272.583C167.732 273.234 167.366 274.117 167.366 275.039ZM174.313 275.039C174.313 275.96 174.679 276.843 175.33 277.495C175.982 278.146 176.865 278.512 177.786 278.512C178.708 278.512 179.591 278.146 180.242 277.495C180.894 276.843 181.26 275.96 181.26 275.039C181.26 274.117 180.894 273.234 180.242 272.583C179.591 271.931 178.708 271.565 177.786 271.565C176.865 271.565 175.982 271.931 175.33 272.583C174.679 273.234 174.313 274.117 174.313 275.039ZM188.206 275.039C188.206 275.96 188.572 276.843 189.224 277.495C189.875 278.146 190.758 278.512 191.68 278.512C192.601 278.512 193.484 278.146 194.136 277.495C194.787 276.843 195.153 275.96 195.153 275.039C195.153 274.117 194.787 273.234 194.136 272.583C193.484 271.931 192.601 271.565 191.68 271.565C190.758 271.565 189.875 271.931 189.224 272.583C188.572 273.234 188.206 274.117 188.206 275.039ZM195.153 275.039C195.153 275.495 195.243 275.946 195.417 276.368C195.592 276.789 195.848 277.172 196.17 277.495C196.493 277.817 196.876 278.073 197.297 278.247C197.718 278.422 198.17 278.512 198.626 278.512C199.082 278.512 199.534 278.422 199.955 278.247C200.377 278.073 200.76 277.817 201.082 277.495C201.405 277.172 201.661 276.789 201.835 276.368C202.01 275.946 202.099 275.495 202.099 275.039C202.099 274.582 202.01 274.131 201.835 273.709C201.661 273.288 201.405 272.905 201.082 272.583C200.76 272.26 200.377 272.004 199.955 271.83C199.534 271.655 199.082 271.565 198.626 271.565C198.17 271.565 197.718 271.655 197.297 271.83C196.876 272.004 196.493 272.26 196.17 272.583C195.848 272.905 195.592 273.288 195.417 273.709C195.243 274.131 195.153 274.582 195.153 275.039ZM202.099 275.039C202.099 275.96 202.465 276.843 203.117 277.495C203.768 278.146 204.652 278.512 205.573 278.512C206.494 278.512 207.377 278.146 208.029 277.495C208.68 276.843 209.046 275.96 209.046 275.039C209.046 274.117 208.68 273.234 208.029 272.583C207.377 271.931 206.494 271.565 205.573 271.565C204.652 271.565 203.768 271.931 203.117 272.583C202.465 273.234 202.099 274.117 202.099 275.039ZM209.046 275.039C209.046 275.96 209.412 276.843 210.063 277.495C210.715 278.146 211.598 278.512 212.519 278.512C213.44 278.512 214.324 278.146 214.975 277.495C215.627 276.843 215.993 275.96 215.993 275.039C215.993 274.117 215.627 273.234 214.975 272.583C214.324 271.931 213.44 271.565 212.519 271.565C211.598 271.565 210.715 271.931 210.063 272.583C209.412 273.234 209.046 274.117 209.046 275.039ZM236.832 275.039C236.832 275.96 237.198 276.843 237.85 277.495C238.501 278.146 239.384 278.512 240.306 278.512C241.227 278.512 242.11 278.146 242.762 277.495C243.413 276.843 243.779 275.96 243.779 275.039C243.779 274.117 243.413 273.234 242.762 272.583C242.11 271.931 241.227 271.565 240.306 271.565C239.384 271.565 238.501 271.931 237.85 272.583C237.198 273.234 236.832 274.117 236.832 275.039ZM271.565 275.039C271.565 275.96 271.931 276.843 272.583 277.495C273.234 278.146 274.117 278.512 275.039 278.512C275.96 278.512 276.843 278.146 277.495 277.495C278.146 276.843 278.512 275.96 278.512 275.039C278.512 274.117 278.146 273.234 277.495 272.583C276.843 271.931 275.96 271.565 275.039 271.565C274.117 271.565 273.234 271.931 272.583 272.583C271.931 273.234 271.565 274.117 271.565 275.039ZM278.512 275.039C278.512 275.96 278.878 276.843 279.529 277.495C280.181 278.146 281.064 278.512 281.985 278.512C282.906 278.512 283.79 278.146 284.441 277.495C285.093 276.843 285.458 275.96 285.458 275.039C285.458 274.117 285.093 273.234 284.441 272.583C283.79 271.931 282.906 271.565 281.985 271.565C281.064 271.565 280.181 271.931 279.529 272.583C278.878 273.234 278.512 274.117 278.512 275.039ZM285.458 275.039C285.458 275.96 285.824 276.843 286.476 277.495C287.127 278.146 288.011 278.512 288.932 278.512C289.853 278.512 290.736 278.146 291.388 277.495C292.039 276.843 292.405 275.96 292.405 275.039C292.405 274.117 292.039 273.234 291.388 272.583C290.736 271.931 289.853 271.565 288.932 271.565C288.011 271.565 287.127 271.931 286.476 272.583C285.824 273.234 285.458 274.117 285.458 275.039ZM7.59497 281.985C7.59497 282.906 7.96091 283.79 8.61227 284.441C9.26364 285.093 10.1471 285.458 11.0683 285.458C11.9894 285.458 12.8729 285.093 13.5243 284.441C14.1756 283.79 14.5416 282.906 14.5416 281.985C14.5416 281.064 14.1756 280.181 13.5243 279.529C12.8729 278.878 11.9894 278.512 11.0683 278.512C10.1471 278.512 9.26364 278.878 8.61227 279.529C7.96091 280.181 7.59497 281.064 7.59497 281.985ZM49.2745 281.985C49.2745 282.441 49.3643 282.893 49.5389 283.314C49.7134 283.736 49.9693 284.119 50.2918 284.441C50.6143 284.764 50.9972 285.02 51.4186 285.194C51.84 285.369 52.2917 285.458 52.7478 285.458C53.2039 285.458 53.6556 285.369 54.077 285.194C54.4984 285.02 54.8813 284.764 55.2038 284.441C55.5263 284.119 55.7821 283.736 55.9567 283.314C56.1312 282.893 56.2211 282.441 56.2211 281.985C56.2211 281.529 56.1312 281.077 55.9567 280.656C55.7821 280.235 55.5263 279.852 55.2038 279.529C54.8813 279.207 54.4984 278.951 54.077 278.776C53.6556 278.602 53.2039 278.512 52.7478 278.512C52.2917 278.512 51.84 278.602 51.4186 278.776C50.9972 278.951 50.6143 279.207 50.2918 279.529C49.9693 279.852 49.7134 280.235 49.5389 280.656C49.3643 281.077 49.2745 281.529 49.2745 281.985ZM84.0074 281.985C84.0074 282.906 84.3734 283.79 85.0247 284.441C85.6761 285.093 86.5596 285.458 87.4807 285.458C88.4019 285.458 89.2854 285.093 89.9367 284.441C90.5881 283.79 90.954 282.906 90.954 281.985C90.954 281.064 90.5881 280.181 89.9367 279.529C89.2854 278.878 88.4019 278.512 87.4807 278.512C86.5596 278.512 85.6761 278.878 85.0247 279.529C84.3734 280.181 84.0074 281.064 84.0074 281.985ZM90.954 281.985C90.954 282.906 91.32 283.79 91.9713 284.441C92.6227 285.093 93.5061 285.458 94.4273 285.458C95.3485 285.458 96.2319 285.093 96.8833 284.441C97.5347 283.79 97.9006 282.906 97.9006 281.985C97.9006 281.064 97.5347 280.181 96.8833 279.529C96.2319 278.878 95.3485 278.512 94.4273 278.512C93.5061 278.512 92.6227 278.878 91.9713 279.529C91.32 280.181 90.954 281.064 90.954 281.985ZM118.74 281.985C118.74 282.906 119.106 283.79 119.758 284.441C120.409 285.093 121.292 285.458 122.214 285.458C123.135 285.458 124.018 285.093 124.67 284.441C125.321 283.79 125.687 282.906 125.687 281.985C125.687 281.064 125.321 280.181 124.67 279.529C124.018 278.878 123.135 278.512 122.214 278.512C121.292 278.512 120.409 278.878 119.758 279.529C119.106 280.181 118.74 281.064 118.74 281.985ZM132.634 281.985C132.634 282.906 132.999 283.79 133.651 284.441C134.302 285.093 135.186 285.458 136.107 285.458C137.028 285.458 137.911 285.093 138.563 284.441C139.214 283.79 139.58 282.906 139.58 281.985C139.58 281.064 139.214 280.181 138.563 279.529C137.911 278.878 137.028 278.512 136.107 278.512C135.186 278.512 134.302 278.878 133.651 279.529C132.999 280.181 132.634 281.064 132.634 281.985ZM139.58 281.985C139.58 282.906 139.946 283.79 140.597 284.441C141.249 285.093 142.132 285.458 143.053 285.458C143.975 285.458 144.858 285.093 145.509 284.441C146.161 283.79 146.527 282.906 146.527 281.985C146.527 281.064 146.161 280.181 145.509 279.529C144.858 278.878 143.975 278.512 143.053 278.512C142.132 278.512 141.249 278.878 140.597 279.529C139.946 280.181 139.58 281.064 139.58 281.985ZM146.527 281.985C146.527 282.906 146.893 283.79 147.544 284.441C148.195 285.093 149.079 285.458 150 285.458C150.921 285.458 151.805 285.093 152.456 284.441C153.107 283.79 153.473 282.906 153.473 281.985C153.473 281.064 153.107 280.181 152.456 279.529C151.805 278.878 150.921 278.512 150 278.512C149.079 278.512 148.195 278.878 147.544 279.529C146.893 280.181 146.527 281.064 146.527 281.985ZM181.26 281.985C181.26 282.906 181.626 283.79 182.277 284.441C182.928 285.093 183.812 285.458 184.733 285.458C185.654 285.458 186.538 285.093 187.189 284.441C187.84 283.79 188.206 282.906 188.206 281.985C188.206 281.064 187.84 280.181 187.189 279.529C186.538 278.878 185.654 278.512 184.733 278.512C183.812 278.512 182.928 278.878 182.277 279.529C181.626 280.181 181.26 281.064 181.26 281.985ZM188.206 281.985C188.206 282.906 188.572 283.79 189.224 284.441C189.875 285.093 190.758 285.458 191.68 285.458C192.601 285.458 193.484 285.093 194.136 284.441C194.787 283.79 195.153 282.906 195.153 281.985C195.153 281.064 194.787 280.181 194.136 279.529C193.484 278.878 192.601 278.512 191.68 278.512C190.758 278.512 189.875 278.878 189.224 279.529C188.572 280.181 188.206 281.064 188.206 281.985ZM195.153 281.985C195.153 282.441 195.243 282.893 195.417 283.314C195.592 283.736 195.848 284.119 196.17 284.441C196.493 284.764 196.876 285.02 197.297 285.194C197.718 285.369 198.17 285.458 198.626 285.458C199.082 285.458 199.534 285.369 199.955 285.194C200.377 285.02 200.76 284.764 201.082 284.441C201.405 284.119 201.661 283.736 201.835 283.314C202.01 282.893 202.099 282.441 202.099 281.985C202.099 281.529 202.01 281.077 201.835 280.656C201.661 280.235 201.405 279.852 201.082 279.529C200.76 279.207 200.377 278.951 199.955 278.776C199.534 278.602 199.082 278.512 198.626 278.512C198.17 278.512 197.718 278.602 197.297 278.776C196.876 278.951 196.493 279.207 196.17 279.529C195.848 279.852 195.592 280.235 195.417 280.656C195.243 281.077 195.153 281.529 195.153 281.985ZM209.046 281.985C209.046 282.906 209.412 283.79 210.063 284.441C210.715 285.093 211.598 285.458 212.519 285.458C213.44 285.458 214.324 285.093 214.975 284.441C215.627 283.79 215.993 282.906 215.993 281.985C215.993 281.064 215.627 280.181 214.975 279.529C214.324 278.878 213.44 278.512 212.519 278.512C211.598 278.512 210.715 278.878 210.063 279.529C209.412 280.181 209.046 281.064 209.046 281.985ZM215.993 281.985C215.993 282.906 216.359 283.79 217.01 284.441C217.661 285.093 218.545 285.458 219.466 285.458C220.387 285.458 221.271 285.093 221.922 284.441C222.573 283.79 222.939 282.906 222.939 281.985C222.939 281.064 222.573 280.181 221.922 279.529C221.271 278.878 220.387 278.512 219.466 278.512C218.545 278.512 217.661 278.878 217.01 279.529C216.359 280.181 215.993 281.064 215.993 281.985ZM229.886 281.985C229.886 282.906 230.252 283.79 230.903 284.441C231.554 285.093 232.438 285.458 233.359 285.458C234.28 285.458 235.164 285.093 235.815 284.441C236.466 283.79 236.832 282.906 236.832 281.985C236.832 281.064 236.466 280.181 235.815 279.529C235.164 278.878 234.28 278.512 233.359 278.512C232.438 278.512 231.554 278.878 230.903 279.529C230.252 280.181 229.886 281.064 229.886 281.985ZM243.779 281.985C243.779 282.906 244.145 283.79 244.796 284.441C245.448 285.093 246.331 285.458 247.252 285.458C248.173 285.458 249.057 285.093 249.708 284.441C250.36 283.79 250.726 282.906 250.726 281.985C250.726 281.064 250.36 280.181 249.708 279.529C249.057 278.878 248.173 278.512 247.252 278.512C246.331 278.512 245.448 278.878 244.796 279.529C244.145 280.181 243.779 281.064 243.779 281.985ZM250.726 281.985C250.726 282.906 251.091 283.79 251.743 284.441C252.394 285.093 253.278 285.458 254.199 285.458C255.12 285.458 256.003 285.093 256.655 284.441C257.306 283.79 257.672 282.906 257.672 281.985C257.672 281.064 257.306 280.181 256.655 279.529C256.003 278.878 255.12 278.512 254.199 278.512C253.278 278.512 252.394 278.878 251.743 279.529C251.091 280.181 250.726 281.064 250.726 281.985ZM264.619 281.985C264.619 282.906 264.985 283.79 265.636 284.441C266.287 285.093 267.171 285.458 268.092 285.458C269.013 285.458 269.897 285.093 270.548 284.441C271.199 283.79 271.565 282.906 271.565 281.985C271.565 281.064 271.199 280.181 270.548 279.529C269.897 278.878 269.013 278.512 268.092 278.512C267.171 278.512 266.287 278.878 265.636 279.529C264.985 280.181 264.619 281.064 264.619 281.985ZM271.565 281.985C271.565 282.906 271.931 283.79 272.583 284.441C273.234 285.093 274.117 285.458 275.039 285.458C275.96 285.458 276.843 285.093 277.495 284.441C278.146 283.79 278.512 282.906 278.512 281.985C278.512 281.064 278.146 280.181 277.495 279.529C276.843 278.878 275.96 278.512 275.039 278.512C274.117 278.512 273.234 278.878 272.583 279.529C271.931 280.181 271.565 281.064 271.565 281.985ZM278.512 281.985C278.512 282.906 278.878 283.79 279.529 284.441C280.181 285.093 281.064 285.458 281.985 285.458C282.906 285.458 283.79 285.093 284.441 284.441C285.093 283.79 285.458 282.906 285.458 281.985C285.458 281.064 285.093 280.181 284.441 279.529C283.79 278.878 282.906 278.512 281.985 278.512C281.064 278.512 280.181 278.878 279.529 279.529C278.878 280.181 278.512 281.064 278.512 281.985ZM285.458 281.985C285.458 282.906 285.824 283.79 286.476 284.441C287.127 285.093 288.011 285.458 288.932 285.458C289.853 285.458 290.736 285.093 291.388 284.441C292.039 283.79 292.405 282.906 292.405 281.985C292.405 281.064 292.039 280.181 291.388 279.529C290.736 278.878 289.853 278.512 288.932 278.512C288.011 278.512 287.127 278.878 286.476 279.529C285.824 280.181 285.458 281.064 285.458 281.985ZM7.59497 288.932C7.59497 289.853 7.96091 290.736 8.61227 291.388C9.26364 292.039 10.1471 292.405 11.0683 292.405C11.9894 292.405 12.8729 292.039 13.5243 291.388C14.1756 290.736 14.5416 289.853 14.5416 288.932C14.5416 288.011 14.1756 287.127 13.5243 286.476C12.8729 285.824 11.9894 285.458 11.0683 285.458C10.1471 285.458 9.26364 285.824 8.61227 286.476C7.96091 287.127 7.59497 288.011 7.59497 288.932ZM14.5416 288.932C14.5416 289.853 14.9075 290.736 15.5589 291.388C16.2102 292.039 17.0937 292.405 18.0149 292.405C18.936 292.405 19.8195 292.039 20.4708 291.388C21.1222 290.736 21.4881 289.853 21.4881 288.932C21.4881 288.011 21.1222 287.127 20.4708 286.476C19.8195 285.824 18.936 285.458 18.0149 285.458C17.0937 285.458 16.2102 285.824 15.5589 286.476C14.9075 287.127 14.5416 288.011 14.5416 288.932ZM21.4881 288.932C21.4881 289.853 21.8541 290.736 22.5055 291.388C23.1568 292.039 24.0403 292.405 24.9614 292.405C25.8826 292.405 26.7661 292.039 27.4174 291.388C28.0688 290.736 28.4347 289.853 28.4347 288.932C28.4347 288.011 28.0688 287.127 27.4174 286.476C26.7661 285.824 25.8826 285.458 24.9614 285.458C24.0403 285.458 23.1568 285.824 22.5055 286.476C21.8541 287.127 21.4881 288.011 21.4881 288.932ZM28.4347 288.932C28.4347 289.853 28.8007 290.736 29.452 291.388C30.1034 292.039 30.9869 292.405 31.908 292.405C32.8292 292.405 33.7126 292.039 34.364 291.388C35.0154 290.736 35.3813 289.853 35.3813 288.932C35.3813 288.011 35.0154 287.127 34.364 286.476C33.7126 285.824 32.8292 285.458 31.908 285.458C30.9869 285.458 30.1034 285.824 29.452 286.476C28.8007 287.127 28.4347 288.011 28.4347 288.932ZM35.3813 288.932C35.3813 289.853 35.7473 290.736 36.3986 291.388C37.05 292.039 37.9334 292.405 38.8546 292.405C39.7758 292.405 40.6592 292.039 41.3106 291.388C41.962 290.736 42.3279 289.853 42.3279 288.932C42.3279 288.011 41.962 287.127 41.3106 286.476C40.6592 285.824 39.7758 285.458 38.8546 285.458C37.9334 285.458 37.05 285.824 36.3986 286.476C35.7473 287.127 35.3813 288.011 35.3813 288.932ZM42.3279 288.932C42.3279 289.388 42.4177 289.84 42.5923 290.261C42.7668 290.682 43.0227 291.065 43.3452 291.388C43.6677 291.71 44.0506 291.966 44.472 292.141C44.8934 292.315 45.3451 292.405 45.8012 292.405C46.2573 292.405 46.709 292.315 47.1304 292.141C47.5518 291.966 47.9347 291.71 48.2572 291.388C48.5797 291.065 48.8356 290.682 49.0101 290.261C49.1847 289.84 49.2745 289.388 49.2745 288.932C49.2745 288.476 49.1847 288.024 49.0101 287.603C48.8356 287.181 48.5797 286.798 48.2572 286.476C47.9347 286.153 47.5518 285.897 47.1304 285.723C46.709 285.548 46.2573 285.458 45.8012 285.458C45.3451 285.458 44.8934 285.548 44.472 285.723C44.0506 285.897 43.6677 286.153 43.3452 286.476C43.0227 286.798 42.7668 287.181 42.5923 287.603C42.4177 288.024 42.3279 288.476 42.3279 288.932ZM49.2745 288.932C49.2745 289.388 49.3643 289.84 49.5389 290.261C49.7134 290.682 49.9693 291.065 50.2918 291.388C50.6143 291.71 50.9972 291.966 51.4186 292.141C51.84 292.315 52.2917 292.405 52.7478 292.405C53.2039 292.405 53.6556 292.315 54.077 292.141C54.4984 291.966 54.8813 291.71 55.2038 291.388C55.5263 291.065 55.7821 290.682 55.9567 290.261C56.1312 289.84 56.2211 289.388 56.2211 288.932C56.2211 288.476 56.1312 288.024 55.9567 287.603C55.7821 287.181 55.5263 286.798 55.2038 286.476C54.8813 286.153 54.4984 285.897 54.077 285.723C53.6556 285.548 53.2039 285.458 52.7478 285.458C52.2917 285.458 51.84 285.548 51.4186 285.723C50.9972 285.897 50.6143 286.153 50.2918 286.476C49.9693 286.798 49.7134 287.181 49.5389 287.603C49.3643 288.024 49.2745 288.476 49.2745 288.932ZM70.1143 288.932C70.1143 289.853 70.4802 290.736 71.1316 291.388C71.7829 292.039 72.6664 292.405 73.5876 292.405C74.5087 292.405 75.3922 292.039 76.0436 291.388C76.6949 290.736 77.0609 289.853 77.0609 288.932C77.0609 288.011 76.6949 287.127 76.0436 286.476C75.3922 285.824 74.5087 285.458 73.5876 285.458C72.6664 285.458 71.7829 285.824 71.1316 286.476C70.4802 287.127 70.1143 288.011 70.1143 288.932ZM132.634 288.932C132.634 289.853 132.999 290.736 133.651 291.388C134.302 292.039 135.186 292.405 136.107 292.405C137.028 292.405 137.911 292.039 138.563 291.388C139.214 290.736 139.58 289.853 139.58 288.932C139.58 288.011 139.214 287.127 138.563 286.476C137.911 285.824 137.028 285.458 136.107 285.458C135.186 285.458 134.302 285.824 133.651 286.476C132.999 287.127 132.634 288.011 132.634 288.932ZM139.58 288.932C139.58 289.853 139.946 290.736 140.597 291.388C141.249 292.039 142.132 292.405 143.053 292.405C143.975 292.405 144.858 292.039 145.509 291.388C146.161 290.736 146.527 289.853 146.527 288.932C146.527 288.011 146.161 287.127 145.509 286.476C144.858 285.824 143.975 285.458 143.053 285.458C142.132 285.458 141.249 285.824 140.597 286.476C139.946 287.127 139.58 288.011 139.58 288.932ZM146.527 288.932C146.527 289.853 146.893 290.736 147.544 291.388C148.195 292.039 149.079 292.405 150 292.405C150.921 292.405 151.805 292.039 152.456 291.388C153.107 290.736 153.473 289.853 153.473 288.932C153.473 288.011 153.107 287.127 152.456 286.476C151.805 285.824 150.921 285.458 150 285.458C149.079 285.458 148.195 285.824 147.544 286.476C146.893 287.127 146.527 288.011 146.527 288.932ZM160.42 288.932C160.42 289.853 160.786 290.736 161.437 291.388C162.089 292.039 162.972 292.405 163.893 292.405C164.814 292.405 165.698 292.039 166.349 291.388C167.001 290.736 167.366 289.853 167.366 288.932C167.366 288.011 167.001 287.127 166.349 286.476C165.698 285.824 164.814 285.458 163.893 285.458C162.972 285.458 162.089 285.824 161.437 286.476C160.786 287.127 160.42 288.011 160.42 288.932ZM188.206 288.932C188.206 289.853 188.572 290.736 189.224 291.388C189.875 292.039 190.758 292.405 191.68 292.405C192.601 292.405 193.484 292.039 194.136 291.388C194.787 290.736 195.153 289.853 195.153 288.932C195.153 288.011 194.787 287.127 194.136 286.476C193.484 285.824 192.601 285.458 191.68 285.458C190.758 285.458 189.875 285.824 189.224 286.476C188.572 287.127 188.206 288.011 188.206 288.932ZM195.153 288.932C195.153 289.388 195.243 289.84 195.417 290.261C195.592 290.682 195.848 291.065 196.17 291.388C196.493 291.71 196.876 291.966 197.297 292.141C197.718 292.315 198.17 292.405 198.626 292.405C199.082 292.405 199.534 292.315 199.955 292.141C200.377 291.966 200.76 291.71 201.082 291.388C201.405 291.065 201.661 290.682 201.835 290.261C202.01 289.84 202.099 289.388 202.099 288.932C202.099 288.476 202.01 288.024 201.835 287.603C201.661 287.181 201.405 286.798 201.082 286.476C200.76 286.153 200.377 285.897 199.955 285.723C199.534 285.548 199.082 285.458 198.626 285.458C198.17 285.458 197.718 285.548 197.297 285.723C196.876 285.897 196.493 286.153 196.17 286.476C195.848 286.798 195.592 287.181 195.417 287.603C195.243 288.024 195.153 288.476 195.153 288.932ZM202.099 288.932C202.099 289.853 202.465 290.736 203.117 291.388C203.768 292.039 204.652 292.405 205.573 292.405C206.494 292.405 207.377 292.039 208.029 291.388C208.68 290.736 209.046 289.853 209.046 288.932C209.046 288.011 208.68 287.127 208.029 286.476C207.377 285.824 206.494 285.458 205.573 285.458C204.652 285.458 203.768 285.824 203.117 286.476C202.465 287.127 202.099 288.011 202.099 288.932ZM209.046 288.932C209.046 289.853 209.412 290.736 210.063 291.388C210.715 292.039 211.598 292.405 212.519 292.405C213.44 292.405 214.324 292.039 214.975 291.388C215.627 290.736 215.993 289.853 215.993 288.932C215.993 288.011 215.627 287.127 214.975 286.476C214.324 285.824 213.44 285.458 212.519 285.458C211.598 285.458 210.715 285.824 210.063 286.476C209.412 287.127 209.046 288.011 209.046 288.932ZM222.939 288.932C222.939 289.853 223.305 290.736 223.957 291.388C224.608 292.039 225.491 292.405 226.413 292.405C227.334 292.405 228.217 292.039 228.868 291.388C229.52 290.736 229.886 289.853 229.886 288.932C229.886 288.011 229.52 287.127 228.868 286.476C228.217 285.824 227.334 285.458 226.413 285.458C225.491 285.458 224.608 285.824 223.957 286.476C223.305 287.127 222.939 288.011 222.939 288.932ZM229.886 288.932C229.886 289.853 230.252 290.736 230.903 291.388C231.554 292.039 232.438 292.405 233.359 292.405C234.28 292.405 235.164 292.039 235.815 291.388C236.466 290.736 236.832 289.853 236.832 288.932C236.832 288.011 236.466 287.127 235.815 286.476C235.164 285.824 234.28 285.458 233.359 285.458C232.438 285.458 231.554 285.824 230.903 286.476C230.252 287.127 229.886 288.011 229.886 288.932ZM250.726 288.932C250.726 289.853 251.091 290.736 251.743 291.388C252.394 292.039 253.278 292.405 254.199 292.405C255.12 292.405 256.003 292.039 256.655 291.388C257.306 290.736 257.672 289.853 257.672 288.932C257.672 288.011 257.306 287.127 256.655 286.476C256.003 285.824 255.12 285.458 254.199 285.458C253.278 285.458 252.394 285.824 251.743 286.476C251.091 287.127 250.726 288.011 250.726 288.932ZM257.672 288.932C257.672 289.853 258.038 290.736 258.689 291.388C259.341 292.039 260.224 292.405 261.145 292.405C262.067 292.405 262.95 292.039 263.601 291.388C264.253 290.736 264.619 289.853 264.619 288.932C264.619 288.011 264.253 287.127 263.601 286.476C262.95 285.824 262.067 285.458 261.145 285.458C260.224 285.458 259.341 285.824 258.689 286.476C258.038 287.127 257.672 288.011 257.672 288.932ZM264.619 288.932C264.619 289.853 264.985 290.736 265.636 291.388C266.287 292.039 267.171 292.405 268.092 292.405C269.013 292.405 269.897 292.039 270.548 291.388C271.199 290.736 271.565 289.853 271.565 288.932C271.565 288.011 271.199 287.127 270.548 286.476C269.897 285.824 269.013 285.458 268.092 285.458C267.171 285.458 266.287 285.824 265.636 286.476C264.985 287.127 264.619 288.011 264.619 288.932ZM271.565 288.932C271.565 289.853 271.931 290.736 272.583 291.388C273.234 292.039 274.117 292.405 275.039 292.405C275.96 292.405 276.843 292.039 277.495 291.388C278.146 290.736 278.512 289.853 278.512 288.932C278.512 288.011 278.146 287.127 277.495 286.476C276.843 285.824 275.96 285.458 275.039 285.458C274.117 285.458 273.234 285.824 272.583 286.476C271.931 287.127 271.565 288.011 271.565 288.932ZM278.512 288.932C278.512 289.853 278.878 290.736 279.529 291.388C280.181 292.039 281.064 292.405 281.985 292.405C282.906 292.405 283.79 292.039 284.441 291.388C285.093 290.736 285.458 289.853 285.458 288.932C285.458 288.011 285.093 287.127 284.441 286.476C283.79 285.824 282.906 285.458 281.985 285.458C281.064 285.458 280.181 285.824 279.529 286.476C278.878 287.127 278.512 288.011 278.512 288.932Z"
          fill="#FB49FF"
        />
        <path
          d="M7.59497 11.0682C7.59497 11.9894 7.96091 12.8729 8.61227 13.5242C9.26364 14.1756 10.1471 14.5415 11.0683 14.5415C11.9894 14.5415 12.8729 14.1756 13.5243 13.5242C14.1756 12.8729 14.5416 11.9894 14.5416 11.0682C14.5416 10.1471 14.1756 9.26361 13.5243 8.61224C12.8729 7.96088 11.9894 7.59494 11.0683 7.59494C10.1471 7.59494 9.26364 7.96088 8.61227 8.61224C7.96091 9.26361 7.59497 10.1471 7.59497 11.0682ZM14.5416 11.0682C14.5416 11.9894 14.9075 12.8729 15.5589 13.5242C16.2102 14.1756 17.0937 14.5415 18.0149 14.5415C18.936 14.5415 19.8195 14.1756 20.4708 13.5242C21.1222 12.8729 21.4881 11.9894 21.4881 11.0682C21.4881 10.1471 21.1222 9.26361 20.4708 8.61224C19.8195 7.96088 18.936 7.59494 18.0149 7.59494C17.0937 7.59494 16.2102 7.96088 15.5589 8.61224C14.9075 9.26361 14.5416 10.1471 14.5416 11.0682ZM21.4881 11.0682C21.4881 11.9894 21.8541 12.8729 22.5055 13.5242C23.1568 14.1756 24.0403 14.5415 24.9614 14.5415C25.8826 14.5415 26.7661 14.1756 27.4174 13.5242C28.0688 12.8729 28.4347 11.9894 28.4347 11.0682C28.4347 10.1471 28.0688 9.26361 27.4174 8.61224C26.7661 7.96088 25.8826 7.59494 24.9614 7.59494C24.0403 7.59494 23.1568 7.96088 22.5055 8.61224C21.8541 9.26361 21.4881 10.1471 21.4881 11.0682ZM28.4347 11.0682C28.4347 11.9894 28.8007 12.8729 29.452 13.5242C30.1034 14.1756 30.9869 14.5415 31.908 14.5415C32.8292 14.5415 33.7126 14.1756 34.364 13.5242C35.0154 12.8729 35.3813 11.9894 35.3813 11.0682C35.3813 10.1471 35.0154 9.26361 34.364 8.61224C33.7126 7.96088 32.8292 7.59494 31.908 7.59494C30.9869 7.59494 30.1034 7.96088 29.452 8.61224C28.8007 9.26361 28.4347 10.1471 28.4347 11.0682ZM35.3813 11.0682C35.3813 11.9894 35.7473 12.8729 36.3986 13.5242C37.05 14.1756 37.9334 14.5415 38.8546 14.5415C39.7758 14.5415 40.6592 14.1756 41.3106 13.5242C41.962 12.8729 42.3279 11.9894 42.3279 11.0682C42.3279 10.1471 41.962 9.26361 41.3106 8.61224C40.6592 7.96088 39.7758 7.59494 38.8546 7.59494C37.9334 7.59494 37.05 7.96088 36.3986 8.61224C35.7473 9.26361 35.3813 10.1471 35.3813 11.0682ZM42.3279 11.0682C42.3279 11.5244 42.4177 11.976 42.5923 12.3974C42.7668 12.8188 43.0227 13.2017 43.3452 13.5242C43.6677 13.8467 44.0506 14.1026 44.472 14.2771C44.8934 14.4517 45.3451 14.5415 45.8012 14.5415C46.2573 14.5415 46.709 14.4517 47.1304 14.2771C47.5518 14.1026 47.9347 13.8467 48.2572 13.5242C48.5797 13.2017 48.8356 12.8188 49.0101 12.3974C49.1847 11.976 49.2745 11.5244 49.2745 11.0682C49.2745 10.6121 49.1847 10.1605 49.0101 9.73906C48.8356 9.31766 48.5797 8.93477 48.2572 8.61224C47.9347 8.28972 47.5518 8.03388 47.1304 7.85933C46.709 7.68478 46.2573 7.59494 45.8012 7.59494C45.3451 7.59494 44.8934 7.68478 44.472 7.85933C44.0506 8.03388 43.6677 8.28972 43.3452 8.61224C43.0227 8.93477 42.7668 9.31766 42.5923 9.73906C42.4177 10.1605 42.3279 10.6121 42.3279 11.0682ZM49.2745 11.0682C49.2745 11.5244 49.3643 11.976 49.5389 12.3974C49.7134 12.8188 49.9693 13.2017 50.2918 13.5242C50.6143 13.8467 50.9972 14.1026 51.4186 14.2771C51.84 14.4517 52.2917 14.5415 52.7478 14.5415C53.2039 14.5415 53.6556 14.4517 54.077 14.2771C54.4984 14.1026 54.8813 13.8467 55.2038 13.5242C55.5263 13.2017 55.7821 12.8188 55.9567 12.3974C56.1312 11.976 56.2211 11.5244 56.2211 11.0682C56.2211 10.6121 56.1312 10.1605 55.9567 9.73906C55.7821 9.31766 55.5263 8.93477 55.2038 8.61224C54.8813 8.28972 54.4984 8.03388 54.077 7.85933C53.6556 7.68478 53.2039 7.59494 52.7478 7.59494C52.2917 7.59494 51.84 7.68478 51.4186 7.85933C50.9972 8.03388 50.6143 8.28972 50.2918 8.61224C49.9693 8.93477 49.7134 9.31766 49.5389 9.73906C49.3643 10.1605 49.2745 10.6121 49.2745 11.0682ZM77.0609 11.0682C77.0609 11.5244 77.1507 11.976 77.3252 12.3974C77.4998 12.8188 77.7556 13.2017 78.0782 13.5242C78.4007 13.8468 78.7836 14.1026 79.205 14.2771C79.6264 14.4517 80.078 14.5415 80.5341 14.5415C80.9903 14.5415 81.4419 14.4517 81.8633 14.2771C82.2847 14.1026 82.6676 13.8468 82.9901 13.5242C83.3127 13.2017 83.5685 12.8188 83.743 12.3974C83.9176 11.976 84.0074 11.5244 84.0074 11.0682C84.0074 10.6121 83.9176 10.1605 83.743 9.73906C83.5685 9.31766 83.3127 8.93477 82.9901 8.61224C82.6676 8.28972 82.2847 8.03388 81.8633 7.85933C81.4419 7.68478 80.9903 7.59494 80.5341 7.59494C80.078 7.59494 79.6264 7.68478 79.205 7.85933C78.7836 8.03388 78.4007 8.28972 78.0782 8.61224C77.7556 8.93477 77.4998 9.31766 77.3252 9.73906C77.1507 10.1605 77.0609 10.6121 77.0609 11.0682ZM84.0074 11.0682C84.0074 11.9894 84.3734 12.8729 85.0247 13.5242C85.6761 14.1756 86.5596 14.5415 87.4807 14.5415C88.4019 14.5415 89.2854 14.1756 89.9367 13.5242C90.5881 12.8729 90.954 11.9894 90.954 11.0682C90.954 10.1471 90.5881 9.26361 89.9367 8.61224C89.2854 7.96088 88.4019 7.59494 87.4807 7.59494C86.5596 7.59494 85.6761 7.96088 85.0247 8.61224C84.3734 9.26361 84.0074 10.1471 84.0074 11.0682ZM97.9006 11.0682C97.9006 11.5244 97.9905 11.976 98.165 12.3974C98.3396 12.8188 98.5954 13.2017 98.9179 13.5242C99.2404 13.8468 99.6233 14.1026 100.045 14.2771C100.466 14.4517 100.918 14.5415 101.374 14.5415C101.83 14.5415 102.282 14.4517 102.703 14.2771C103.124 14.1026 103.507 13.8468 103.83 13.5242C104.152 13.2017 104.408 12.8188 104.583 12.3974C104.757 11.976 104.847 11.5244 104.847 11.0682C104.847 10.6121 104.757 10.1605 104.583 9.73906C104.408 9.31766 104.152 8.93477 103.83 8.61224C103.507 8.28972 103.124 8.03388 102.703 7.85933C102.282 7.68478 101.83 7.59494 101.374 7.59494C100.918 7.59494 100.466 7.68478 100.045 7.85933C99.6233 8.03388 99.2404 8.28972 98.9179 8.61224C98.5954 8.93477 98.3396 9.31766 98.165 9.73906C97.9905 10.1605 97.9006 10.6121 97.9006 11.0682ZM111.794 11.0682C111.794 11.9894 112.16 12.8729 112.811 13.5242C113.462 14.1756 114.346 14.5415 115.267 14.5415C116.188 14.5415 117.072 14.1756 117.723 13.5242C118.374 12.8729 118.74 11.9894 118.74 11.0682C118.74 10.1471 118.374 9.26361 117.723 8.61224C117.072 7.96088 116.188 7.59494 115.267 7.59494C114.346 7.59494 113.462 7.96088 112.811 8.61224C112.16 9.26361 111.794 10.1471 111.794 11.0682ZM167.366 11.0682C167.366 11.9894 167.732 12.8729 168.384 13.5242C169.035 14.1756 169.919 14.5415 170.84 14.5415C171.761 14.5415 172.644 14.1756 173.296 13.5242C173.947 12.8729 174.313 11.9894 174.313 11.0682C174.313 10.1471 173.947 9.26361 173.296 8.61224C172.644 7.96088 171.761 7.59494 170.84 7.59494C169.919 7.59494 169.035 7.96088 168.384 8.61224C167.732 9.26361 167.366 10.1471 167.366 11.0682ZM181.26 11.0682C181.26 11.9894 181.626 12.8729 182.277 13.5242C182.928 14.1756 183.812 14.5415 184.733 14.5415C185.654 14.5415 186.538 14.1756 187.189 13.5242C187.84 12.8729 188.206 11.9894 188.206 11.0682C188.206 10.1471 187.84 9.26361 187.189 8.61224C186.538 7.96088 185.654 7.59494 184.733 7.59494C183.812 7.59494 182.928 7.96088 182.277 8.61224C181.626 9.26361 181.26 10.1471 181.26 11.0682ZM188.206 11.0682C188.206 11.9894 188.572 12.8729 189.224 13.5242C189.875 14.1756 190.758 14.5415 191.68 14.5415C192.601 14.5415 193.484 14.1756 194.136 13.5242C194.787 12.8729 195.153 11.9894 195.153 11.0682C195.153 10.1471 194.787 9.26361 194.136 8.61224C193.484 7.96088 192.601 7.59494 191.68 7.59494C190.758 7.59494 189.875 7.96088 189.224 8.61224C188.572 9.26361 188.206 10.1471 188.206 11.0682ZM195.153 11.0682C195.153 11.5244 195.243 11.976 195.417 12.3974C195.592 12.8188 195.848 13.2017 196.17 13.5242C196.493 13.8468 196.876 14.1026 197.297 14.2771C197.718 14.4517 198.17 14.5415 198.626 14.5415C199.082 14.5415 199.534 14.4517 199.955 14.2771C200.377 14.1026 200.76 13.8468 201.082 13.5242C201.405 13.2017 201.661 12.8188 201.835 12.3974C202.01 11.976 202.099 11.5244 202.099 11.0682C202.099 10.6121 202.01 10.1605 201.835 9.73906C201.661 9.31766 201.405 8.93477 201.082 8.61224C200.76 8.28972 200.377 8.03388 199.955 7.85933C199.534 7.68478 199.082 7.59494 198.626 7.59494C198.17 7.59494 197.718 7.68478 197.297 7.85933C196.876 8.03388 196.493 8.28972 196.17 8.61224C195.848 8.93477 195.592 9.31766 195.417 9.73906C195.243 10.1605 195.153 10.6121 195.153 11.0682ZM202.099 11.0682C202.099 11.9894 202.465 12.8729 203.117 13.5242C203.768 14.1756 204.652 14.5415 205.573 14.5415C206.494 14.5415 207.377 14.1756 208.029 13.5242C208.68 12.8729 209.046 11.9894 209.046 11.0682C209.046 10.1471 208.68 9.26361 208.029 8.61224C207.377 7.96088 206.494 7.59494 205.573 7.59494C204.652 7.59494 203.768 7.96088 203.117 8.61224C202.465 9.26361 202.099 10.1471 202.099 11.0682ZM209.046 11.0682C209.046 11.9894 209.412 12.8729 210.063 13.5242C210.715 14.1756 211.598 14.5415 212.519 14.5415C213.44 14.5415 214.324 14.1756 214.975 13.5242C215.627 12.8729 215.993 11.9894 215.993 11.0682C215.993 10.1471 215.627 9.26361 214.975 8.61224C214.324 7.96088 213.44 7.59494 212.519 7.59494C211.598 7.59494 210.715 7.96088 210.063 8.61224C209.412 9.26361 209.046 10.1471 209.046 11.0682ZM243.779 11.0682C243.779 11.9894 244.145 12.8729 244.796 13.5242C245.448 14.1756 246.331 14.5415 247.252 14.5415C248.173 14.5415 249.057 14.1756 249.708 13.5242C250.36 12.8729 250.726 11.9894 250.726 11.0682C250.726 10.1471 250.36 9.26361 249.708 8.61224C249.057 7.96088 248.173 7.59494 247.252 7.59494C246.331 7.59494 245.448 7.96088 244.796 8.61224C244.145 9.26361 243.779 10.1471 243.779 11.0682ZM250.726 11.0682C250.726 11.9894 251.091 12.8729 251.743 13.5242C252.394 14.1756 253.278 14.5415 254.199 14.5415C255.12 14.5415 256.003 14.1756 256.655 13.5242C257.306 12.8729 257.672 11.9894 257.672 11.0682C257.672 10.1471 257.306 9.26361 256.655 8.61224C256.003 7.96088 255.12 7.59494 254.199 7.59494C253.278 7.59494 252.394 7.96088 251.743 8.61224C251.091 9.26361 250.726 10.1471 250.726 11.0682ZM257.672 11.0682C257.672 11.9894 258.038 12.8729 258.689 13.5242C259.341 14.1756 260.224 14.5415 261.145 14.5415C262.067 14.5415 262.95 14.1756 263.601 13.5242C264.253 12.8729 264.619 11.9894 264.619 11.0682C264.619 10.1471 264.253 9.26361 263.601 8.61224C262.95 7.96088 262.067 7.59494 261.145 7.59494C260.224 7.59494 259.341 7.96088 258.689 8.61224C258.038 9.26361 257.672 10.1471 257.672 11.0682ZM264.619 11.0682C264.619 11.9894 264.985 12.8729 265.636 13.5242C266.287 14.1756 267.171 14.5415 268.092 14.5415C269.013 14.5415 269.897 14.1756 270.548 13.5242C271.199 12.8729 271.565 11.9894 271.565 11.0682C271.565 10.1471 271.199 9.26361 270.548 8.61224C269.897 7.96088 269.013 7.59494 268.092 7.59494C267.171 7.59494 266.287 7.96088 265.636 8.61224C264.985 9.26361 264.619 10.1471 264.619 11.0682ZM271.565 11.0682C271.565 11.9894 271.931 12.8729 272.583 13.5242C273.234 14.1756 274.117 14.5415 275.039 14.5415C275.96 14.5415 276.843 14.1756 277.495 13.5242C278.146 12.8729 278.512 11.9894 278.512 11.0682C278.512 10.1471 278.146 9.26361 277.495 8.61224C276.843 7.96088 275.96 7.59494 275.039 7.59494C274.117 7.59494 273.234 7.96088 272.583 8.61224C271.931 9.26361 271.565 10.1471 271.565 11.0682ZM278.512 11.0682C278.512 11.9894 278.878 12.8729 279.529 13.5242C280.181 14.1756 281.064 14.5415 281.985 14.5415C282.906 14.5415 283.79 14.1756 284.441 13.5242C285.093 12.8729 285.458 11.9894 285.458 11.0682C285.458 10.1471 285.093 9.26361 284.441 8.61224C283.79 7.96088 282.906 7.59494 281.985 7.59494C281.064 7.59494 280.181 7.96088 279.529 8.61224C278.878 9.26361 278.512 10.1471 278.512 11.0682ZM285.458 11.0682C285.458 11.9894 285.824 12.8729 286.476 13.5242C287.127 14.1756 288.011 14.5415 288.932 14.5415C289.853 14.5415 290.736 14.1756 291.388 13.5242C292.039 12.8729 292.405 11.9894 292.405 11.0682C292.405 10.1471 292.039 9.26361 291.388 8.61224C290.736 7.96088 289.853 7.59494 288.932 7.59494C288.011 7.59494 287.127 7.96088 286.476 8.61224C285.824 9.26361 285.458 10.1471 285.458 11.0682ZM7.59497 18.0148C7.59497 18.936 7.96091 19.8194 8.61227 20.4708C9.26364 21.1222 10.1471 21.4881 11.0683 21.4881C11.9894 21.4881 12.8729 21.1222 13.5243 20.4708C14.1756 19.8194 14.5416 18.936 14.5416 18.0148C14.5416 17.0936 14.1756 16.2102 13.5243 15.5588C12.8729 14.9075 11.9894 14.5415 11.0683 14.5415C10.1471 14.5415 9.26364 14.9075 8.61227 15.5588C7.96091 16.2102 7.59497 17.0936 7.59497 18.0148ZM49.2745 18.0148C49.2745 18.4709 49.3643 18.9226 49.5389 19.344C49.7134 19.7654 49.9693 20.1483 50.2918 20.4708C50.6143 20.7933 50.9972 21.0492 51.4186 21.2237C51.84 21.3983 52.2917 21.4881 52.7478 21.4881C53.2039 21.4881 53.6556 21.3983 54.077 21.2237C54.4984 21.0492 54.8813 20.7933 55.2038 20.4708C55.5263 20.1483 55.7821 19.7654 55.9567 19.344C56.1312 18.9226 56.2211 18.4709 56.2211 18.0148C56.2211 17.5587 56.1312 17.107 55.9567 16.6857C55.7821 16.2643 55.5263 15.8814 55.2038 15.5588C54.8813 15.2363 54.4984 14.9805 54.077 14.8059C53.6556 14.6314 53.2039 14.5415 52.7478 14.5415C52.2917 14.5415 51.84 14.6314 51.4186 14.8059C50.9972 14.9805 50.6143 15.2363 50.2918 15.5588C49.9693 15.8814 49.7134 16.2643 49.5389 16.6857C49.3643 17.107 49.2745 17.5587 49.2745 18.0148ZM63.1677 18.0148C63.1677 18.936 63.5336 19.8194 64.185 20.4708C64.8363 21.1222 65.7198 21.4881 66.641 21.4881C67.5621 21.4881 68.4456 21.1222 69.097 20.4708C69.7483 19.8194 70.1143 18.936 70.1143 18.0148C70.1143 17.0936 69.7483 16.2102 69.097 15.5588C68.4456 14.9075 67.5621 14.5415 66.641 14.5415C65.7198 14.5415 64.8363 14.9075 64.185 15.5588C63.5336 16.2102 63.1677 17.0936 63.1677 18.0148ZM90.954 18.0148C90.954 18.936 91.32 19.8194 91.9713 20.4708C92.6227 21.1222 93.5061 21.4881 94.4273 21.4881C95.3485 21.4881 96.2319 21.1222 96.8833 20.4708C97.5347 19.8194 97.9006 18.936 97.9006 18.0148C97.9006 17.0936 97.5347 16.2102 96.8833 15.5588C96.2319 14.9075 95.3485 14.5415 94.4273 14.5415C93.5061 14.5415 92.6227 14.9075 91.9713 15.5588C91.32 16.2102 90.954 17.0936 90.954 18.0148ZM111.794 18.0148C111.794 18.936 112.16 19.8194 112.811 20.4708C113.462 21.1222 114.346 21.4881 115.267 21.4881C116.188 21.4881 117.072 21.1222 117.723 20.4708C118.374 19.8194 118.74 18.936 118.74 18.0148C118.74 17.0936 118.374 16.2102 117.723 15.5588C117.072 14.9075 116.188 14.5415 115.267 14.5415C114.346 14.5415 113.462 14.9075 112.811 15.5588C112.16 16.2102 111.794 17.0936 111.794 18.0148ZM118.74 18.0148C118.74 18.936 119.106 19.8194 119.758 20.4708C120.409 21.1222 121.292 21.4881 122.214 21.4881C123.135 21.4881 124.018 21.1222 124.67 20.4708C125.321 19.8194 125.687 18.936 125.687 18.0148C125.687 17.0936 125.321 16.2102 124.67 15.5588C124.018 14.9075 123.135 14.5415 122.214 14.5415C121.292 14.5415 120.409 14.9075 119.758 15.5588C119.106 16.2102 118.74 17.0936 118.74 18.0148ZM125.687 18.0148C125.687 18.936 126.053 19.8194 126.704 20.4708C127.356 21.1222 128.239 21.4881 129.16 21.4881C130.081 21.4881 130.965 21.1222 131.616 20.4708C132.268 19.8194 132.634 18.936 132.634 18.0148C132.634 17.0936 132.268 16.2102 131.616 15.5588C130.965 14.9075 130.081 14.5415 129.16 14.5415C128.239 14.5415 127.356 14.9075 126.704 15.5588C126.053 16.2102 125.687 17.0936 125.687 18.0148ZM132.634 18.0148C132.634 18.936 132.999 19.8194 133.651 20.4708C134.302 21.1222 135.186 21.4881 136.107 21.4881C137.028 21.4881 137.911 21.1222 138.563 20.4708C139.214 19.8194 139.58 18.936 139.58 18.0148C139.58 17.0936 139.214 16.2102 138.563 15.5588C137.911 14.9075 137.028 14.5415 136.107 14.5415C135.186 14.5415 134.302 14.9075 133.651 15.5588C132.999 16.2102 132.634 17.0936 132.634 18.0148ZM139.58 18.0148C139.58 18.936 139.946 19.8194 140.597 20.4708C141.249 21.1222 142.132 21.4881 143.053 21.4881C143.975 21.4881 144.858 21.1222 145.509 20.4708C146.161 19.8194 146.527 18.936 146.527 18.0148C146.527 17.0936 146.161 16.2102 145.509 15.5588C144.858 14.9075 143.975 14.5415 143.053 14.5415C142.132 14.5415 141.249 14.9075 140.597 15.5588C139.946 16.2102 139.58 17.0936 139.58 18.0148ZM146.527 18.0148C146.527 18.936 146.893 19.8194 147.544 20.4708C148.195 21.1222 149.079 21.4881 150 21.4881C150.921 21.4881 151.805 21.1222 152.456 20.4708C153.107 19.8194 153.473 18.936 153.473 18.0148C153.473 17.0936 153.107 16.2102 152.456 15.5588C151.805 14.9075 150.921 14.5415 150 14.5415C149.079 14.5415 148.195 14.9075 147.544 15.5588C146.893 16.2102 146.527 17.0936 146.527 18.0148ZM153.473 18.0148C153.473 18.4709 153.563 18.9226 153.738 19.344C153.912 19.7654 154.168 20.1483 154.491 20.4708C154.813 20.7933 155.196 21.0492 155.617 21.2237C156.039 21.3983 156.491 21.4881 156.947 21.4881C157.403 21.4881 157.854 21.3983 158.276 21.2237C158.697 21.0492 159.08 20.7933 159.403 20.4708C159.725 20.1483 159.981 19.7654 160.156 19.344C160.33 18.9226 160.42 18.4709 160.42 18.0148C160.42 17.5587 160.33 17.107 160.156 16.6857C159.981 16.2643 159.725 15.8814 159.403 15.5588C159.08 15.2363 158.697 14.9805 158.276 14.8059C157.854 14.6314 157.403 14.5415 156.947 14.5415C156.491 14.5415 156.039 14.6314 155.617 14.8059C155.196 14.9805 154.813 15.2363 154.491 15.5588C154.168 15.8814 153.912 16.2643 153.738 16.6857C153.563 17.107 153.473 17.5587 153.473 18.0148ZM160.42 18.0148C160.42 18.936 160.786 19.8194 161.437 20.4708C162.089 21.1222 162.972 21.4881 163.893 21.4881C164.814 21.4881 165.698 21.1222 166.349 20.4708C167.001 19.8194 167.366 18.936 167.366 18.0148C167.366 17.0936 167.001 16.2102 166.349 15.5588C165.698 14.9075 164.814 14.5415 163.893 14.5415C162.972 14.5415 162.089 14.9075 161.437 15.5588C160.786 16.2102 160.42 17.0936 160.42 18.0148ZM167.366 18.0148C167.366 18.936 167.732 19.8194 168.384 20.4708C169.035 21.1222 169.919 21.4881 170.84 21.4881C171.761 21.4881 172.644 21.1222 173.296 20.4708C173.947 19.8194 174.313 18.936 174.313 18.0148C174.313 17.0936 173.947 16.2102 173.296 15.5588C172.644 14.9075 171.761 14.5415 170.84 14.5415C169.919 14.5415 169.035 14.9075 168.384 15.5588C167.732 16.2102 167.366 17.0936 167.366 18.0148ZM181.26 18.0148C181.26 18.936 181.626 19.8194 182.277 20.4708C182.928 21.1222 183.812 21.4881 184.733 21.4881C185.654 21.4881 186.538 21.1222 187.189 20.4708C187.84 19.8194 188.206 18.936 188.206 18.0148C188.206 17.0936 187.84 16.2102 187.189 15.5588C186.538 14.9075 185.654 14.5415 184.733 14.5415C183.812 14.5415 182.928 14.9075 182.277 15.5588C181.626 16.2102 181.26 17.0936 181.26 18.0148ZM188.206 18.0148C188.206 18.936 188.572 19.8194 189.224 20.4708C189.875 21.1222 190.758 21.4881 191.68 21.4881C192.601 21.4881 193.484 21.1222 194.136 20.4708C194.787 19.8194 195.153 18.936 195.153 18.0148C195.153 17.0936 194.787 16.2102 194.136 15.5588C193.484 14.9075 192.601 14.5415 191.68 14.5415C190.758 14.5415 189.875 14.9075 189.224 15.5588C188.572 16.2102 188.206 17.0936 188.206 18.0148ZM209.046 18.0148C209.046 18.936 209.412 19.8194 210.063 20.4708C210.715 21.1222 211.598 21.4881 212.519 21.4881C213.44 21.4881 214.324 21.1222 214.975 20.4708C215.627 19.8194 215.993 18.936 215.993 18.0148C215.993 17.0936 215.627 16.2102 214.975 15.5588C214.324 14.9075 213.44 14.5415 212.519 14.5415C211.598 14.5415 210.715 14.9075 210.063 15.5588C209.412 16.2102 209.046 17.0936 209.046 18.0148ZM222.939 18.0148C222.939 18.936 223.305 19.8194 223.957 20.4708C224.608 21.1222 225.491 21.4881 226.413 21.4881C227.334 21.4881 228.217 21.1222 228.868 20.4708C229.52 19.8194 229.886 18.936 229.886 18.0148C229.886 17.0936 229.52 16.2102 228.868 15.5588C228.217 14.9075 227.334 14.5415 226.413 14.5415C225.491 14.5415 224.608 14.9075 223.957 15.5588C223.305 16.2102 222.939 17.0936 222.939 18.0148ZM243.779 18.0148C243.779 18.936 244.145 19.8194 244.796 20.4708C245.448 21.1222 246.331 21.4881 247.252 21.4881C248.173 21.4881 249.057 21.1222 249.708 20.4708C250.36 19.8194 250.726 18.936 250.726 18.0148C250.726 17.0936 250.36 16.2102 249.708 15.5588C249.057 14.9075 248.173 14.5415 247.252 14.5415C246.331 14.5415 245.448 14.9075 244.796 15.5588C244.145 16.2102 243.779 17.0936 243.779 18.0148ZM285.458 18.0148C285.458 18.936 285.824 19.8194 286.476 20.4708C287.127 21.1222 288.011 21.4881 288.932 21.4881C289.853 21.4881 290.736 21.1222 291.388 20.4708C292.039 19.8194 292.405 18.936 292.405 18.0148C292.405 17.0936 292.039 16.2102 291.388 15.5588C290.736 14.9075 289.853 14.5415 288.932 14.5415C288.011 14.5415 287.127 14.9075 286.476 15.5588C285.824 16.2102 285.458 17.0936 285.458 18.0148ZM7.59497 24.9614C7.59497 25.8826 7.96091 26.766 8.61227 27.4174C9.26364 28.0688 10.1471 28.4347 11.0683 28.4347C11.9894 28.4347 12.8729 28.0688 13.5243 27.4174C14.1756 26.766 14.5416 25.8826 14.5416 24.9614C14.5416 24.0402 14.1756 23.1568 13.5243 22.5054C12.8729 21.8541 11.9894 21.4881 11.0683 21.4881C10.1471 21.4881 9.26364 21.8541 8.61227 22.5054C7.96091 23.1568 7.59497 24.0402 7.59497 24.9614ZM21.4881 24.9614C21.4881 25.8826 21.8541 26.766 22.5055 27.4174C23.1568 28.0688 24.0403 28.4347 24.9614 28.4347C25.8826 28.4347 26.7661 28.0688 27.4174 27.4174C28.0688 26.766 28.4347 25.8826 28.4347 24.9614C28.4347 24.0402 28.0688 23.1568 27.4174 22.5054C26.7661 21.8541 25.8826 21.4881 24.9614 21.4881C24.0403 21.4881 23.1568 21.8541 22.5055 22.5054C21.8541 23.1568 21.4881 24.0402 21.4881 24.9614ZM28.4347 24.9614C28.4347 25.8826 28.8007 26.766 29.452 27.4174C30.1034 28.0688 30.9869 28.4347 31.908 28.4347C32.8292 28.4347 33.7126 28.0688 34.364 27.4174C35.0154 26.766 35.3813 25.8826 35.3813 24.9614C35.3813 24.0402 35.0154 23.1568 34.364 22.5054C33.7126 21.8541 32.8292 21.4881 31.908 21.4881C30.9869 21.4881 30.1034 21.8541 29.452 22.5054C28.8007 23.1568 28.4347 24.0402 28.4347 24.9614ZM35.3813 24.9614C35.3813 25.8826 35.7473 26.766 36.3986 27.4174C37.05 28.0688 37.9334 28.4347 38.8546 28.4347C39.7758 28.4347 40.6592 28.0688 41.3106 27.4174C41.962 26.766 42.3279 25.8826 42.3279 24.9614C42.3279 24.0402 41.962 23.1568 41.3106 22.5054C40.6592 21.8541 39.7758 21.4881 38.8546 21.4881C37.9334 21.4881 37.05 21.8541 36.3986 22.5054C35.7473 23.1568 35.3813 24.0402 35.3813 24.9614ZM49.2745 24.9614C49.2745 25.4175 49.3643 25.8692 49.5389 26.2906C49.7134 26.712 49.9693 27.0949 50.2918 27.4174C50.6143 27.7399 50.9972 27.9958 51.4186 28.1703C51.84 28.3449 52.2917 28.4347 52.7478 28.4347C53.2039 28.4347 53.6556 28.3449 54.077 28.1703C54.4984 27.9958 54.8813 27.7399 55.2038 27.4174C55.5263 27.0949 55.7821 26.712 55.9567 26.2906C56.1312 25.8692 56.2211 25.4175 56.2211 24.9614C56.2211 24.5053 56.1312 24.0536 55.9567 23.6322C55.7821 23.2108 55.5263 22.8279 55.2038 22.5054C54.8813 22.1829 54.4984 21.9271 54.077 21.7525C53.6556 21.578 53.2039 21.4881 52.7478 21.4881C52.2917 21.4881 51.84 21.578 51.4186 21.7525C50.9972 21.9271 50.6143 22.1829 50.2918 22.5054C49.9693 22.8279 49.7134 23.2108 49.5389 23.6322C49.3643 24.0536 49.2745 24.5053 49.2745 24.9614ZM70.1143 24.9614C70.1143 25.8826 70.4802 26.766 71.1316 27.4174C71.7829 28.0688 72.6664 28.4347 73.5876 28.4347C74.5087 28.4347 75.3922 28.0688 76.0436 27.4174C76.6949 26.766 77.0609 25.8826 77.0609 24.9614C77.0609 24.0402 76.6949 23.1568 76.0436 22.5054C75.3922 21.8541 74.5087 21.4881 73.5876 21.4881C72.6664 21.4881 71.7829 21.8541 71.1316 22.5054C70.4802 23.1568 70.1143 24.0402 70.1143 24.9614ZM104.847 24.9614C104.847 25.8826 105.213 26.766 105.865 27.4174C106.516 28.0688 107.399 28.4347 108.321 28.4347C109.242 28.4347 110.125 28.0688 110.776 27.4174C111.428 26.766 111.794 25.8826 111.794 24.9614C111.794 24.0402 111.428 23.1568 110.776 22.5054C110.125 21.8541 109.242 21.4881 108.321 21.4881C107.399 21.4881 106.516 21.8541 105.865 22.5054C105.213 23.1568 104.847 24.0402 104.847 24.9614ZM111.794 24.9614C111.794 25.8826 112.16 26.766 112.811 27.4174C113.462 28.0688 114.346 28.4347 115.267 28.4347C116.188 28.4347 117.072 28.0688 117.723 27.4174C118.374 26.766 118.74 25.8826 118.74 24.9614C118.74 24.0402 118.374 23.1568 117.723 22.5054C117.072 21.8541 116.188 21.4881 115.267 21.4881C114.346 21.4881 113.462 21.8541 112.811 22.5054C112.16 23.1568 111.794 24.0402 111.794 24.9614ZM118.74 24.9614C118.74 25.8826 119.106 26.766 119.758 27.4174C120.409 28.0688 121.292 28.4347 122.214 28.4347C123.135 28.4347 124.018 28.0688 124.67 27.4174C125.321 26.766 125.687 25.8826 125.687 24.9614C125.687 24.0402 125.321 23.1568 124.67 22.5054C124.018 21.8541 123.135 21.4881 122.214 21.4881C121.292 21.4881 120.409 21.8541 119.758 22.5054C119.106 23.1568 118.74 24.0402 118.74 24.9614ZM132.634 24.9614C132.634 25.8826 132.999 26.766 133.651 27.4174C134.302 28.0688 135.186 28.4347 136.107 28.4347C137.028 28.4347 137.911 28.0688 138.563 27.4174C139.214 26.766 139.58 25.8826 139.58 24.9614C139.58 24.0402 139.214 23.1568 138.563 22.5054C137.911 21.8541 137.028 21.4881 136.107 21.4881C135.186 21.4881 134.302 21.8541 133.651 22.5054C132.999 23.1568 132.634 24.0402 132.634 24.9614ZM146.527 24.9614C146.527 25.8826 146.893 26.766 147.544 27.4174C148.195 28.0688 149.079 28.4347 150 28.4347C150.921 28.4347 151.805 28.0688 152.456 27.4174C153.107 26.766 153.473 25.8826 153.473 24.9614C153.473 24.0402 153.107 23.1568 152.456 22.5054C151.805 21.8541 150.921 21.4881 150 21.4881C149.079 21.4881 148.195 21.8541 147.544 22.5054C146.893 23.1568 146.527 24.0402 146.527 24.9614ZM153.473 24.9614C153.473 25.4175 153.563 25.8692 153.738 26.2906C153.912 26.712 154.168 27.0949 154.491 27.4174C154.813 27.7399 155.196 27.9958 155.617 28.1703C156.039 28.3449 156.491 28.4347 156.947 28.4347C157.403 28.4347 157.854 28.3449 158.276 28.1703C158.697 27.9958 159.08 27.7399 159.403 27.4174C159.725 27.0949 159.981 26.712 160.156 26.2906C160.33 25.8692 160.42 25.4175 160.42 24.9614C160.42 24.5053 160.33 24.0536 160.156 23.6322C159.981 23.2108 159.725 22.8279 159.403 22.5054C159.08 22.1829 158.697 21.9271 158.276 21.7525C157.854 21.578 157.403 21.4881 156.947 21.4881C156.491 21.4881 156.039 21.578 155.617 21.7525C155.196 21.9271 154.813 22.1829 154.491 22.5054C154.168 22.8279 153.912 23.2108 153.738 23.6322C153.563 24.0536 153.473 24.5053 153.473 24.9614ZM167.366 24.9614C167.366 25.8826 167.732 26.766 168.384 27.4174C169.035 28.0688 169.919 28.4347 170.84 28.4347C171.761 28.4347 172.644 28.0688 173.296 27.4174C173.947 26.766 174.313 25.8826 174.313 24.9614C174.313 24.0402 173.947 23.1568 173.296 22.5054C172.644 21.8541 171.761 21.4881 170.84 21.4881C169.919 21.4881 169.035 21.8541 168.384 22.5054C167.732 23.1568 167.366 24.0402 167.366 24.9614ZM188.206 24.9614C188.206 25.8826 188.572 26.766 189.224 27.4174C189.875 28.0688 190.758 28.4347 191.68 28.4347C192.601 28.4347 193.484 28.0688 194.136 27.4174C194.787 26.766 195.153 25.8826 195.153 24.9614C195.153 24.0402 194.787 23.1568 194.136 22.5054C193.484 21.8541 192.601 21.4881 191.68 21.4881C190.758 21.4881 189.875 21.8541 189.224 22.5054C188.572 23.1568 188.206 24.0402 188.206 24.9614ZM222.939 24.9614C222.939 25.8826 223.305 26.766 223.957 27.4174C224.608 28.0688 225.491 28.4347 226.413 28.4347C227.334 28.4347 228.217 28.0688 228.868 27.4174C229.52 26.766 229.886 25.8826 229.886 24.9614C229.886 24.0402 229.52 23.1568 228.868 22.5054C228.217 21.8541 227.334 21.4881 226.413 21.4881C225.491 21.4881 224.608 21.8541 223.957 22.5054C223.305 23.1568 222.939 24.0402 222.939 24.9614ZM229.886 24.9614C229.886 25.8826 230.252 26.766 230.903 27.4174C231.554 28.0688 232.438 28.4347 233.359 28.4347C234.28 28.4347 235.164 28.0688 235.815 27.4174C236.466 26.766 236.832 25.8826 236.832 24.9614C236.832 24.0402 236.466 23.1568 235.815 22.5054C235.164 21.8541 234.28 21.4881 233.359 21.4881C232.438 21.4881 231.554 21.8541 230.903 22.5054C230.252 23.1568 229.886 24.0402 229.886 24.9614ZM243.779 24.9614C243.779 25.8826 244.145 26.766 244.796 27.4174C245.448 28.0688 246.331 28.4347 247.252 28.4347C248.173 28.4347 249.057 28.0688 249.708 27.4174C250.36 26.766 250.726 25.8826 250.726 24.9614C250.726 24.0402 250.36 23.1568 249.708 22.5054C249.057 21.8541 248.173 21.4881 247.252 21.4881C246.331 21.4881 245.448 21.8541 244.796 22.5054C244.145 23.1568 243.779 24.0402 243.779 24.9614ZM257.672 24.9614C257.672 25.8826 258.038 26.766 258.689 27.4174C259.341 28.0688 260.224 28.4347 261.145 28.4347C262.067 28.4347 262.95 28.0688 263.601 27.4174C264.253 26.766 264.619 25.8826 264.619 24.9614C264.619 24.0402 264.253 23.1568 263.601 22.5054C262.95 21.8541 262.067 21.4881 261.145 21.4881C260.224 21.4881 259.341 21.8541 258.689 22.5054C258.038 23.1568 257.672 24.0402 257.672 24.9614ZM264.619 24.9614C264.619 25.8826 264.985 26.766 265.636 27.4174C266.287 28.0688 267.171 28.4347 268.092 28.4347C269.013 28.4347 269.897 28.0688 270.548 27.4174C271.199 26.766 271.565 25.8826 271.565 24.9614C271.565 24.0402 271.199 23.1568 270.548 22.5054C269.897 21.8541 269.013 21.4881 268.092 21.4881C267.171 21.4881 266.287 21.8541 265.636 22.5054C264.985 23.1568 264.619 24.0402 264.619 24.9614ZM271.565 24.9614C271.565 25.8826 271.931 26.766 272.583 27.4174C273.234 28.0688 274.117 28.4347 275.039 28.4347C275.96 28.4347 276.843 28.0688 277.495 27.4174C278.146 26.766 278.512 25.8826 278.512 24.9614C278.512 24.0402 278.146 23.1568 277.495 22.5054C276.843 21.8541 275.96 21.4881 275.039 21.4881C274.117 21.4881 273.234 21.8541 272.583 22.5054C271.931 23.1568 271.565 24.0402 271.565 24.9614ZM285.458 24.9614C285.458 25.8826 285.824 26.766 286.476 27.4174C287.127 28.0688 288.011 28.4347 288.932 28.4347C289.853 28.4347 290.736 28.0688 291.388 27.4174C292.039 26.766 292.405 25.8826 292.405 24.9614C292.405 24.0402 292.039 23.1568 291.388 22.5054C290.736 21.8541 289.853 21.4881 288.932 21.4881C288.011 21.4881 287.127 21.8541 286.476 22.5054C285.824 23.1568 285.458 24.0402 285.458 24.9614ZM7.59497 31.908C7.59497 32.8292 7.96091 33.7126 8.61227 34.364C9.26364 35.0154 10.1471 35.3813 11.0683 35.3813C11.9894 35.3813 12.8729 35.0154 13.5243 34.364C14.1756 33.7126 14.5416 32.8292 14.5416 31.908C14.5416 30.9868 14.1756 30.1034 13.5243 29.452C12.8729 28.8006 11.9894 28.4347 11.0683 28.4347C10.1471 28.4347 9.26364 28.8006 8.61227 29.452C7.96091 30.1034 7.59497 30.9868 7.59497 31.908ZM21.4881 31.908C21.4881 32.8292 21.8541 33.7126 22.5055 34.364C23.1568 35.0154 24.0403 35.3813 24.9614 35.3813C25.8826 35.3813 26.7661 35.0154 27.4174 34.364C28.0688 33.7126 28.4347 32.8292 28.4347 31.908C28.4347 30.9868 28.0688 30.1034 27.4174 29.452C26.7661 28.8006 25.8826 28.4347 24.9614 28.4347C24.0403 28.4347 23.1568 28.8006 22.5055 29.452C21.8541 30.1034 21.4881 30.9868 21.4881 31.908ZM28.4347 31.908C28.4347 32.8292 28.8007 33.7126 29.452 34.364C30.1034 35.0154 30.9869 35.3813 31.908 35.3813C32.8292 35.3813 33.7126 35.0154 34.364 34.364C35.0154 33.7126 35.3813 32.8292 35.3813 31.908C35.3813 30.9868 35.0154 30.1034 34.364 29.452C33.7126 28.8006 32.8292 28.4347 31.908 28.4347C30.9869 28.4347 30.1034 28.8006 29.452 29.452C28.8007 30.1034 28.4347 30.9868 28.4347 31.908ZM35.3813 31.908C35.3813 32.8292 35.7473 33.7126 36.3986 34.364C37.05 35.0154 37.9334 35.3813 38.8546 35.3813C39.7758 35.3813 40.6592 35.0154 41.3106 34.364C41.962 33.7126 42.3279 32.8292 42.3279 31.908C42.3279 30.9868 41.962 30.1034 41.3106 29.452C40.6592 28.8006 39.7758 28.4347 38.8546 28.4347C37.9334 28.4347 37.05 28.8006 36.3986 29.452C35.7473 30.1034 35.3813 30.9868 35.3813 31.908ZM49.2745 31.908C49.2745 32.3641 49.3643 32.8158 49.5389 33.2372C49.7134 33.6586 49.9693 34.0415 50.2918 34.364C50.6143 34.6865 50.9972 34.9424 51.4186 35.1169C51.84 35.2915 52.2917 35.3813 52.7478 35.3813C53.2039 35.3813 53.6556 35.2915 54.077 35.1169C54.4984 34.9424 54.8813 34.6865 55.2038 34.364C55.5263 34.0415 55.7821 33.6586 55.9567 33.2372C56.1312 32.8158 56.2211 32.3641 56.2211 31.908C56.2211 31.4519 56.1312 31.0002 55.9567 30.5788C55.7821 30.1574 55.5263 29.7745 55.2038 29.452C54.8813 29.1295 54.4984 28.8736 54.077 28.6991C53.6556 28.5245 53.2039 28.4347 52.7478 28.4347C52.2917 28.4347 51.84 28.5245 51.4186 28.6991C50.9972 28.8736 50.6143 29.1295 50.2918 29.452C49.9693 29.7745 49.7134 30.1574 49.5389 30.5788C49.3643 31.0002 49.2745 31.4519 49.2745 31.908ZM70.1143 31.908C70.1143 32.8292 70.4802 33.7126 71.1316 34.364C71.7829 35.0154 72.6664 35.3813 73.5876 35.3813C74.5087 35.3813 75.3922 35.0154 76.0436 34.364C76.6949 33.7126 77.0609 32.8292 77.0609 31.908C77.0609 30.9868 76.6949 30.1034 76.0436 29.452C75.3922 28.8006 74.5087 28.4347 73.5876 28.4347C72.6664 28.4347 71.7829 28.8006 71.1316 29.452C70.4802 30.1034 70.1143 30.9868 70.1143 31.908ZM84.0074 31.908C84.0074 32.8292 84.3734 33.7126 85.0247 34.364C85.6761 35.0154 86.5596 35.3813 87.4807 35.3813C88.4019 35.3813 89.2854 35.0154 89.9367 34.364C90.5881 33.7126 90.954 32.8292 90.954 31.908C90.954 30.9868 90.5881 30.1034 89.9367 29.452C89.2854 28.8006 88.4019 28.4347 87.4807 28.4347C86.5596 28.4347 85.6761 28.8006 85.0247 29.452C84.3734 30.1034 84.0074 30.9868 84.0074 31.908ZM90.954 31.908C90.954 32.8292 91.32 33.7126 91.9713 34.364C92.6227 35.0154 93.5061 35.3813 94.4273 35.3813C95.3485 35.3813 96.2319 35.0154 96.8833 34.364C97.5347 33.7126 97.9006 32.8292 97.9006 31.908C97.9006 30.9868 97.5347 30.1034 96.8833 29.452C96.2319 28.8006 95.3485 28.4347 94.4273 28.4347C93.5061 28.4347 92.6227 28.8006 91.9713 29.452C91.32 30.1034 90.954 30.9868 90.954 31.908ZM104.847 31.908C104.847 32.8292 105.213 33.7126 105.865 34.364C106.516 35.0154 107.399 35.3813 108.321 35.3813C109.242 35.3813 110.125 35.0154 110.776 34.364C111.428 33.7126 111.794 32.8292 111.794 31.908C111.794 30.9868 111.428 30.1034 110.776 29.452C110.125 28.8006 109.242 28.4347 108.321 28.4347C107.399 28.4347 106.516 28.8006 105.865 29.452C105.213 30.1034 104.847 30.9868 104.847 31.908ZM111.794 31.908C111.794 32.8292 112.16 33.7126 112.811 34.364C113.462 35.0154 114.346 35.3813 115.267 35.3813C116.188 35.3813 117.072 35.0154 117.723 34.364C118.374 33.7126 118.74 32.8292 118.74 31.908C118.74 30.9868 118.374 30.1034 117.723 29.452C117.072 28.8006 116.188 28.4347 115.267 28.4347C114.346 28.4347 113.462 28.8006 112.811 29.452C112.16 30.1034 111.794 30.9868 111.794 31.908ZM118.74 31.908C118.74 32.8292 119.106 33.7126 119.758 34.364C120.409 35.0154 121.292 35.3813 122.214 35.3813C123.135 35.3813 124.018 35.0154 124.67 34.364C125.321 33.7126 125.687 32.8292 125.687 31.908C125.687 30.9868 125.321 30.1034 124.67 29.452C124.018 28.8006 123.135 28.4347 122.214 28.4347C121.292 28.4347 120.409 28.8006 119.758 29.452C119.106 30.1034 118.74 30.9868 118.74 31.908ZM125.687 31.908C125.687 32.8292 126.053 33.7126 126.704 34.364C127.356 35.0154 128.239 35.3813 129.16 35.3813C130.081 35.3813 130.965 35.0154 131.616 34.364C132.268 33.7126 132.634 32.8292 132.634 31.908C132.634 30.9868 132.268 30.1034 131.616 29.452C130.965 28.8006 130.081 28.4347 129.16 28.4347C128.239 28.4347 127.356 28.8006 126.704 29.452C126.053 30.1034 125.687 30.9868 125.687 31.908ZM139.58 31.908C139.58 32.8292 139.946 33.7126 140.597 34.364C141.249 35.0154 142.132 35.3813 143.053 35.3813C143.975 35.3813 144.858 35.0154 145.509 34.364C146.161 33.7126 146.527 32.8292 146.527 31.908C146.527 30.9868 146.161 30.1034 145.509 29.452C144.858 28.8006 143.975 28.4347 143.053 28.4347C142.132 28.4347 141.249 28.8006 140.597 29.452C139.946 30.1034 139.58 30.9868 139.58 31.908ZM146.527 31.908C146.527 32.8292 146.893 33.7126 147.544 34.364C148.195 35.0154 149.079 35.3813 150 35.3813C150.921 35.3813 151.805 35.0154 152.456 34.364C153.107 33.7126 153.473 32.8292 153.473 31.908C153.473 30.9868 153.107 30.1034 152.456 29.452C151.805 28.8006 150.921 28.4347 150 28.4347C149.079 28.4347 148.195 28.8006 147.544 29.452C146.893 30.1034 146.527 30.9868 146.527 31.908ZM174.313 31.908C174.313 32.8292 174.679 33.7126 175.33 34.364C175.982 35.0154 176.865 35.3813 177.786 35.3813C178.708 35.3813 179.591 35.0154 180.242 34.364C180.894 33.7126 181.26 32.8292 181.26 31.908C181.26 30.9868 180.894 30.1034 180.242 29.452C179.591 28.8006 178.708 28.4347 177.786 28.4347C176.865 28.4347 175.982 28.8006 175.33 29.452C174.679 30.1034 174.313 30.9868 174.313 31.908ZM202.099 31.908C202.099 32.8292 202.465 33.7126 203.117 34.364C203.768 35.0154 204.652 35.3813 205.573 35.3813C206.494 35.3813 207.377 35.0154 208.029 34.364C208.68 33.7126 209.046 32.8292 209.046 31.908C209.046 30.9868 208.68 30.1034 208.029 29.452C207.377 28.8006 206.494 28.4347 205.573 28.4347C204.652 28.4347 203.768 28.8006 203.117 29.452C202.465 30.1034 202.099 30.9868 202.099 31.908ZM209.046 31.908C209.046 32.8292 209.412 33.7126 210.063 34.364C210.715 35.0154 211.598 35.3813 212.519 35.3813C213.44 35.3813 214.324 35.0154 214.975 34.364C215.627 33.7126 215.993 32.8292 215.993 31.908C215.993 30.9868 215.627 30.1034 214.975 29.452C214.324 28.8006 213.44 28.4347 212.519 28.4347C211.598 28.4347 210.715 28.8006 210.063 29.452C209.412 30.1034 209.046 30.9868 209.046 31.908ZM215.993 31.908C215.993 32.8292 216.359 33.7126 217.01 34.364C217.661 35.0154 218.545 35.3813 219.466 35.3813C220.387 35.3813 221.271 35.0154 221.922 34.364C222.573 33.7126 222.939 32.8292 222.939 31.908C222.939 30.9868 222.573 30.1034 221.922 29.452C221.271 28.8006 220.387 28.4347 219.466 28.4347C218.545 28.4347 217.661 28.8006 217.01 29.452C216.359 30.1034 215.993 30.9868 215.993 31.908ZM222.939 31.908C222.939 32.8292 223.305 33.7126 223.957 34.364C224.608 35.0154 225.491 35.3813 226.413 35.3813C227.334 35.3813 228.217 35.0154 228.868 34.364C229.52 33.7126 229.886 32.8292 229.886 31.908C229.886 30.9868 229.52 30.1034 228.868 29.452C228.217 28.8006 227.334 28.4347 226.413 28.4347C225.491 28.4347 224.608 28.8006 223.957 29.452C223.305 30.1034 222.939 30.9868 222.939 31.908ZM243.779 31.908C243.779 32.8292 244.145 33.7126 244.796 34.364C245.448 35.0154 246.331 35.3813 247.252 35.3813C248.173 35.3813 249.057 35.0154 249.708 34.364C250.36 33.7126 250.726 32.8292 250.726 31.908C250.726 30.9868 250.36 30.1034 249.708 29.452C249.057 28.8006 248.173 28.4347 247.252 28.4347C246.331 28.4347 245.448 28.8006 244.796 29.452C244.145 30.1034 243.779 30.9868 243.779 31.908ZM257.672 31.908C257.672 32.8292 258.038 33.7126 258.689 34.364C259.341 35.0154 260.224 35.3813 261.145 35.3813C262.067 35.3813 262.95 35.0154 263.601 34.364C264.253 33.7126 264.619 32.8292 264.619 31.908C264.619 30.9868 264.253 30.1034 263.601 29.452C262.95 28.8006 262.067 28.4347 261.145 28.4347C260.224 28.4347 259.341 28.8006 258.689 29.452C258.038 30.1034 257.672 30.9868 257.672 31.908ZM264.619 31.908C264.619 32.8292 264.985 33.7126 265.636 34.364C266.287 35.0154 267.171 35.3813 268.092 35.3813C269.013 35.3813 269.897 35.0154 270.548 34.364C271.199 33.7126 271.565 32.8292 271.565 31.908C271.565 30.9868 271.199 30.1034 270.548 29.452C269.897 28.8006 269.013 28.4347 268.092 28.4347C267.171 28.4347 266.287 28.8006 265.636 29.452C264.985 30.1034 264.619 30.9868 264.619 31.908ZM271.565 31.908C271.565 32.8292 271.931 33.7126 272.583 34.364C273.234 35.0154 274.117 35.3813 275.039 35.3813C275.96 35.3813 276.843 35.0154 277.495 34.364C278.146 33.7126 278.512 32.8292 278.512 31.908C278.512 30.9868 278.146 30.1034 277.495 29.452C276.843 28.8006 275.96 28.4347 275.039 28.4347C274.117 28.4347 273.234 28.8006 272.583 29.452C271.931 30.1034 271.565 30.9868 271.565 31.908ZM285.458 31.908C285.458 32.8292 285.824 33.7126 286.476 34.364C287.127 35.0154 288.011 35.3813 288.932 35.3813C289.853 35.3813 290.736 35.0154 291.388 34.364C292.039 33.7126 292.405 32.8292 292.405 31.908C292.405 30.9868 292.039 30.1034 291.388 29.452C290.736 28.8006 289.853 28.4347 288.932 28.4347C288.011 28.4347 287.127 28.8006 286.476 29.452C285.824 30.1034 285.458 30.9868 285.458 31.908ZM7.59497 38.8546C7.59497 39.7758 7.96091 40.6592 8.61227 41.3106C9.26364 41.9619 10.1471 42.3279 11.0683 42.3279C11.9894 42.3279 12.8729 41.9619 13.5243 41.3106C14.1756 40.6592 14.5416 39.7758 14.5416 38.8546C14.5416 37.9334 14.1756 37.05 13.5243 36.3986C12.8729 35.7472 11.9894 35.3813 11.0683 35.3813C10.1471 35.3813 9.26364 35.7472 8.61227 36.3986C7.96091 37.05 7.59497 37.9334 7.59497 38.8546ZM21.4881 38.8546C21.4881 39.7758 21.8541 40.6592 22.5055 41.3106C23.1568 41.9619 24.0403 42.3279 24.9614 42.3279C25.8826 42.3279 26.7661 41.9619 27.4174 41.3106C28.0688 40.6592 28.4347 39.7758 28.4347 38.8546C28.4347 37.9334 28.0688 37.05 27.4174 36.3986C26.7661 35.7472 25.8826 35.3813 24.9614 35.3813C24.0403 35.3813 23.1568 35.7472 22.5055 36.3986C21.8541 37.05 21.4881 37.9334 21.4881 38.8546ZM28.4347 38.8546C28.4347 39.7758 28.8007 40.6592 29.452 41.3106C30.1034 41.9619 30.9869 42.3279 31.908 42.3279C32.8292 42.3279 33.7126 41.9619 34.364 41.3106C35.0154 40.6592 35.3813 39.7758 35.3813 38.8546C35.3813 37.9334 35.0154 37.05 34.364 36.3986C33.7126 35.7472 32.8292 35.3813 31.908 35.3813C30.9869 35.3813 30.1034 35.7472 29.452 36.3986C28.8007 37.05 28.4347 37.9334 28.4347 38.8546ZM35.3813 38.8546C35.3813 39.7758 35.7473 40.6592 36.3986 41.3106C37.05 41.9619 37.9334 42.3279 38.8546 42.3279C39.7758 42.3279 40.6592 41.9619 41.3106 41.3106C41.962 40.6592 42.3279 39.7758 42.3279 38.8546C42.3279 37.9334 41.962 37.05 41.3106 36.3986C40.6592 35.7472 39.7758 35.3813 38.8546 35.3813C37.9334 35.3813 37.05 35.7472 36.3986 36.3986C35.7473 37.05 35.3813 37.9334 35.3813 38.8546ZM49.2745 38.8546C49.2745 39.3107 49.3643 39.7624 49.5389 40.1838C49.7134 40.6052 49.9693 40.9881 50.2918 41.3106C50.6143 41.6331 50.9972 41.8889 51.4186 42.0635C51.84 42.238 52.2917 42.3279 52.7478 42.3279C53.2039 42.3279 53.6556 42.238 54.077 42.0635C54.4984 41.8889 54.8813 41.6331 55.2038 41.3106C55.5263 40.9881 55.7821 40.6052 55.9567 40.1838C56.1312 39.7624 56.2211 39.3107 56.2211 38.8546C56.2211 38.3985 56.1312 37.9468 55.9567 37.5254C55.7821 37.104 55.5263 36.7211 55.2038 36.3986C54.8813 36.0761 54.4984 35.8202 54.077 35.6457C53.6556 35.4711 53.2039 35.3813 52.7478 35.3813C52.2917 35.3813 51.84 35.4711 51.4186 35.6457C50.9972 35.8202 50.6143 36.0761 50.2918 36.3986C49.9693 36.7211 49.7134 37.104 49.5389 37.5254C49.3643 37.9468 49.2745 38.3985 49.2745 38.8546ZM70.1143 38.8546C70.1143 39.7758 70.4802 40.6592 71.1316 41.3106C71.7829 41.9619 72.6664 42.3279 73.5876 42.3279C74.5087 42.3279 75.3922 41.9619 76.0436 41.3106C76.6949 40.6592 77.0609 39.7758 77.0609 38.8546C77.0609 37.9334 76.6949 37.05 76.0436 36.3986C75.3922 35.7472 74.5087 35.3813 73.5876 35.3813C72.6664 35.3813 71.7829 35.7472 71.1316 36.3986C70.4802 37.05 70.1143 37.9334 70.1143 38.8546ZM90.954 38.8546C90.954 39.7758 91.32 40.6592 91.9713 41.3106C92.6227 41.9619 93.5061 42.3279 94.4273 42.3279C95.3485 42.3279 96.2319 41.9619 96.8833 41.3106C97.5347 40.6592 97.9006 39.7758 97.9006 38.8546C97.9006 37.9334 97.5347 37.05 96.8833 36.3986C96.2319 35.7472 95.3485 35.3813 94.4273 35.3813C93.5061 35.3813 92.6227 35.7472 91.9713 36.3986C91.32 37.05 90.954 37.9334 90.954 38.8546ZM97.9006 38.8546C97.9006 39.3107 97.9905 39.7624 98.165 40.1838C98.3396 40.6052 98.5954 40.9881 98.9179 41.3106C99.2404 41.6331 99.6233 41.8889 100.045 42.0635C100.466 42.238 100.918 42.3279 101.374 42.3279C101.83 42.3279 102.282 42.238 102.703 42.0635C103.124 41.8889 103.507 41.6331 103.83 41.3106C104.152 40.9881 104.408 40.6052 104.583 40.1838C104.757 39.7624 104.847 39.3107 104.847 38.8546C104.847 38.3985 104.757 37.9468 104.583 37.5254C104.408 37.104 104.152 36.7211 103.83 36.3986C103.507 36.0761 103.124 35.8202 102.703 35.6457C102.282 35.4711 101.83 35.3813 101.374 35.3813C100.918 35.3813 100.466 35.4711 100.045 35.6457C99.6233 35.8202 99.2404 36.0761 98.9179 36.3986C98.5954 36.7211 98.3396 37.104 98.165 37.5254C97.9905 37.9468 97.9006 38.3985 97.9006 38.8546ZM104.847 38.8546C104.847 39.7758 105.213 40.6592 105.865 41.3106C106.516 41.9619 107.399 42.3279 108.321 42.3279C109.242 42.3279 110.125 41.9619 110.776 41.3106C111.428 40.6592 111.794 39.7758 111.794 38.8546C111.794 37.9334 111.428 37.05 110.776 36.3986C110.125 35.7472 109.242 35.3813 108.321 35.3813C107.399 35.3813 106.516 35.7472 105.865 36.3986C105.213 37.05 104.847 37.9334 104.847 38.8546ZM111.794 38.8546C111.794 39.7758 112.16 40.6592 112.811 41.3106C113.462 41.9619 114.346 42.3279 115.267 42.3279C116.188 42.3279 117.072 41.9619 117.723 41.3106C118.374 40.6592 118.74 39.7758 118.74 38.8546C118.74 37.9334 118.374 37.05 117.723 36.3986C117.072 35.7472 116.188 35.3813 115.267 35.3813C114.346 35.3813 113.462 35.7472 112.811 36.3986C112.16 37.05 111.794 37.9334 111.794 38.8546ZM125.687 38.8546C125.687 39.7758 126.053 40.6592 126.704 41.3106C127.356 41.9619 128.239 42.3279 129.16 42.3279C130.081 42.3279 130.965 41.9619 131.616 41.3106C132.268 40.6592 132.634 39.7758 132.634 38.8546C132.634 37.9334 132.268 37.05 131.616 36.3986C130.965 35.7472 130.081 35.3813 129.16 35.3813C128.239 35.3813 127.356 35.7472 126.704 36.3986C126.053 37.05 125.687 37.9334 125.687 38.8546ZM153.473 38.8546C153.473 39.3107 153.563 39.7624 153.738 40.1838C153.912 40.6052 154.168 40.9881 154.491 41.3106C154.813 41.6331 155.196 41.8889 155.617 42.0635C156.039 42.238 156.491 42.3279 156.947 42.3279C157.403 42.3279 157.854 42.238 158.276 42.0635C158.697 41.8889 159.08 41.6331 159.403 41.3106C159.725 40.9881 159.981 40.6052 160.156 40.1838C160.33 39.7624 160.42 39.3107 160.42 38.8546C160.42 38.3985 160.33 37.9468 160.156 37.5254C159.981 37.104 159.725 36.7211 159.403 36.3986C159.08 36.0761 158.697 35.8202 158.276 35.6457C157.854 35.4711 157.403 35.3813 156.947 35.3813C156.491 35.3813 156.039 35.4711 155.617 35.6457C155.196 35.8202 154.813 36.0761 154.491 36.3986C154.168 36.7211 153.912 37.104 153.738 37.5254C153.563 37.9468 153.473 38.3985 153.473 38.8546ZM167.366 38.8546C167.366 39.7758 167.732 40.6592 168.384 41.3106C169.035 41.9619 169.919 42.3279 170.84 42.3279C171.761 42.3279 172.644 41.9619 173.296 41.3106C173.947 40.6592 174.313 39.7758 174.313 38.8546C174.313 37.9334 173.947 37.05 173.296 36.3986C172.644 35.7472 171.761 35.3813 170.84 35.3813C169.919 35.3813 169.035 35.7472 168.384 36.3986C167.732 37.05 167.366 37.9334 167.366 38.8546ZM195.153 38.8546C195.153 39.3107 195.243 39.7624 195.417 40.1838C195.592 40.6052 195.848 40.9881 196.17 41.3106C196.493 41.6331 196.876 41.8889 197.297 42.0635C197.718 42.238 198.17 42.3279 198.626 42.3279C199.082 42.3279 199.534 42.238 199.955 42.0635C200.377 41.8889 200.76 41.6331 201.082 41.3106C201.405 40.9881 201.661 40.6052 201.835 40.1838C202.01 39.7624 202.099 39.3107 202.099 38.8546C202.099 38.3985 202.01 37.9468 201.835 37.5254C201.661 37.104 201.405 36.7211 201.082 36.3986C200.76 36.0761 200.377 35.8202 199.955 35.6457C199.534 35.4711 199.082 35.3813 198.626 35.3813C198.17 35.3813 197.718 35.4711 197.297 35.6457C196.876 35.8202 196.493 36.0761 196.17 36.3986C195.848 36.7211 195.592 37.104 195.417 37.5254C195.243 37.9468 195.153 38.3985 195.153 38.8546ZM202.099 38.8546C202.099 39.7758 202.465 40.6592 203.117 41.3106C203.768 41.9619 204.652 42.3279 205.573 42.3279C206.494 42.3279 207.377 41.9619 208.029 41.3106C208.68 40.6592 209.046 39.7758 209.046 38.8546C209.046 37.9334 208.68 37.05 208.029 36.3986C207.377 35.7472 206.494 35.3813 205.573 35.3813C204.652 35.3813 203.768 35.7472 203.117 36.3986C202.465 37.05 202.099 37.9334 202.099 38.8546ZM215.993 38.8546C215.993 39.7758 216.359 40.6592 217.01 41.3106C217.661 41.9619 218.545 42.3279 219.466 42.3279C220.387 42.3279 221.271 41.9619 221.922 41.3106C222.573 40.6592 222.939 39.7758 222.939 38.8546C222.939 37.9334 222.573 37.05 221.922 36.3986C221.271 35.7472 220.387 35.3813 219.466 35.3813C218.545 35.3813 217.661 35.7472 217.01 36.3986C216.359 37.05 215.993 37.9334 215.993 38.8546ZM243.779 38.8546C243.779 39.7758 244.145 40.6592 244.796 41.3106C245.448 41.9619 246.331 42.3279 247.252 42.3279C248.173 42.3279 249.057 41.9619 249.708 41.3106C250.36 40.6592 250.726 39.7758 250.726 38.8546C250.726 37.9334 250.36 37.05 249.708 36.3986C249.057 35.7472 248.173 35.3813 247.252 35.3813C246.331 35.3813 245.448 35.7472 244.796 36.3986C244.145 37.05 243.779 37.9334 243.779 38.8546ZM257.672 38.8546C257.672 39.7758 258.038 40.6592 258.689 41.3106C259.341 41.9619 260.224 42.3279 261.145 42.3279C262.067 42.3279 262.95 41.9619 263.601 41.3106C264.253 40.6592 264.619 39.7758 264.619 38.8546C264.619 37.9334 264.253 37.05 263.601 36.3986C262.95 35.7472 262.067 35.3813 261.145 35.3813C260.224 35.3813 259.341 35.7472 258.689 36.3986C258.038 37.05 257.672 37.9334 257.672 38.8546ZM264.619 38.8546C264.619 39.7758 264.985 40.6592 265.636 41.3106C266.287 41.9619 267.171 42.3279 268.092 42.3279C269.013 42.3279 269.897 41.9619 270.548 41.3106C271.199 40.6592 271.565 39.7758 271.565 38.8546C271.565 37.9334 271.199 37.05 270.548 36.3986C269.897 35.7472 269.013 35.3813 268.092 35.3813C267.171 35.3813 266.287 35.7472 265.636 36.3986C264.985 37.05 264.619 37.9334 264.619 38.8546ZM271.565 38.8546C271.565 39.7758 271.931 40.6592 272.583 41.3106C273.234 41.9619 274.117 42.3279 275.039 42.3279C275.96 42.3279 276.843 41.9619 277.495 41.3106C278.146 40.6592 278.512 39.7758 278.512 38.8546C278.512 37.9334 278.146 37.05 277.495 36.3986C276.843 35.7472 275.96 35.3813 275.039 35.3813C274.117 35.3813 273.234 35.7472 272.583 36.3986C271.931 37.05 271.565 37.9334 271.565 38.8546ZM285.458 38.8546C285.458 39.7758 285.824 40.6592 286.476 41.3106C287.127 41.9619 288.011 42.3279 288.932 42.3279C289.853 42.3279 290.736 41.9619 291.388 41.3106C292.039 40.6592 292.405 39.7758 292.405 38.8546C292.405 37.9334 292.039 37.05 291.388 36.3986C290.736 35.7472 289.853 35.3813 288.932 35.3813C288.011 35.3813 287.127 35.7472 286.476 36.3986C285.824 37.05 285.458 37.9334 285.458 38.8546ZM7.59497 45.8012C7.59497 46.7224 7.96091 47.6058 8.61227 48.2572C9.26364 48.9085 10.1471 49.2745 11.0683 49.2745C11.9894 49.2745 12.8729 48.9085 13.5243 48.2572C14.1756 47.6058 14.5416 46.7224 14.5416 45.8012C14.5416 44.88 14.1756 43.9966 13.5243 43.3452C12.8729 42.6938 11.9894 42.3279 11.0683 42.3279C10.1471 42.3279 9.26364 42.6938 8.61227 43.3452C7.96091 43.9966 7.59497 44.88 7.59497 45.8012ZM49.2745 45.8012C49.2745 46.2573 49.3643 46.7089 49.5389 47.1303C49.7134 47.5517 49.9693 47.9346 50.2918 48.2572C50.6143 48.5797 50.9972 48.8355 51.4186 49.0101C51.84 49.1846 52.2917 49.2745 52.7478 49.2745C53.2039 49.2745 53.6556 49.1846 54.077 49.0101C54.4984 48.8355 54.8813 48.5797 55.2038 48.2572C55.5263 47.9346 55.7821 47.5517 55.9567 47.1303C56.1312 46.7089 56.2211 46.2573 56.2211 45.8012C56.2211 45.3451 56.1312 44.8934 55.9567 44.472C55.7821 44.0506 55.5263 43.6677 55.2038 43.3452C54.8813 43.0227 54.4984 42.7668 54.077 42.5923C53.6556 42.4177 53.2039 42.3279 52.7478 42.3279C52.2917 42.3279 51.84 42.4177 51.4186 42.5923C50.9972 42.7668 50.6143 43.0227 50.2918 43.3452C49.9693 43.6677 49.7134 44.0506 49.5389 44.472C49.3643 44.8934 49.2745 45.3451 49.2745 45.8012ZM63.1677 45.8012C63.1677 46.7224 63.5336 47.6058 64.185 48.2572C64.8363 48.9085 65.7198 49.2745 66.641 49.2745C67.5621 49.2745 68.4456 48.9085 69.097 48.2572C69.7483 47.6058 70.1143 46.7224 70.1143 45.8012C70.1143 44.88 69.7483 43.9966 69.097 43.3452C68.4456 42.6938 67.5621 42.3279 66.641 42.3279C65.7198 42.3279 64.8363 42.6938 64.185 43.3452C63.5336 43.9966 63.1677 44.88 63.1677 45.8012ZM77.0609 45.8012C77.0609 46.2573 77.1507 46.7089 77.3252 47.1303C77.4998 47.5517 77.7556 47.9346 78.0782 48.2572C78.4007 48.5797 78.7836 48.8355 79.205 49.0101C79.6264 49.1846 80.078 49.2745 80.5341 49.2745C80.9903 49.2745 81.4419 49.1846 81.8633 49.0101C82.2847 48.8355 82.6676 48.5797 82.9901 48.2572C83.3127 47.9346 83.5685 47.5517 83.743 47.1303C83.9176 46.7089 84.0074 46.2573 84.0074 45.8012C84.0074 45.3451 83.9176 44.8934 83.743 44.472C83.5685 44.0506 83.3127 43.6677 82.9901 43.3452C82.6676 43.0227 82.2847 42.7668 81.8633 42.5923C81.4419 42.4177 80.9903 42.3279 80.5341 42.3279C80.078 42.3279 79.6264 42.4177 79.205 42.5923C78.7836 42.7668 78.4007 43.0227 78.0782 43.3452C77.7556 43.6677 77.4998 44.0506 77.3252 44.472C77.1507 44.8934 77.0609 45.3451 77.0609 45.8012ZM84.0074 45.8012C84.0074 46.7224 84.3734 47.6058 85.0247 48.2572C85.6761 48.9085 86.5596 49.2745 87.4807 49.2745C88.4019 49.2745 89.2854 48.9085 89.9367 48.2572C90.5881 47.6058 90.954 46.7224 90.954 45.8012C90.954 44.88 90.5881 43.9966 89.9367 43.3452C89.2854 42.6938 88.4019 42.3279 87.4807 42.3279C86.5596 42.3279 85.6761 42.6938 85.0247 43.3452C84.3734 43.9966 84.0074 44.88 84.0074 45.8012ZM90.954 45.8012C90.954 46.7224 91.32 47.6058 91.9713 48.2572C92.6227 48.9085 93.5061 49.2745 94.4273 49.2745C95.3485 49.2745 96.2319 48.9085 96.8833 48.2572C97.5347 47.6058 97.9006 46.7224 97.9006 45.8012C97.9006 44.88 97.5347 43.9966 96.8833 43.3452C96.2319 42.6938 95.3485 42.3279 94.4273 42.3279C93.5061 42.3279 92.6227 42.6938 91.9713 43.3452C91.32 43.9966 90.954 44.88 90.954 45.8012ZM97.9006 45.8012C97.9006 46.2573 97.9905 46.7089 98.165 47.1303C98.3396 47.5517 98.5954 47.9346 98.9179 48.2572C99.2404 48.5797 99.6233 48.8355 100.045 49.0101C100.466 49.1846 100.918 49.2745 101.374 49.2745C101.83 49.2745 102.282 49.1846 102.703 49.0101C103.124 48.8355 103.507 48.5797 103.83 48.2572C104.152 47.9346 104.408 47.5517 104.583 47.1303C104.757 46.7089 104.847 46.2573 104.847 45.8012C104.847 45.3451 104.757 44.8934 104.583 44.472C104.408 44.0506 104.152 43.6677 103.83 43.3452C103.507 43.0227 103.124 42.7668 102.703 42.5923C102.282 42.4177 101.83 42.3279 101.374 42.3279C100.918 42.3279 100.466 42.4177 100.045 42.5923C99.6233 42.7668 99.2404 43.0227 98.9179 43.3452C98.5954 43.6677 98.3396 44.0506 98.165 44.472C97.9905 44.8934 97.9006 45.3451 97.9006 45.8012ZM118.74 45.8012C118.74 46.7224 119.106 47.6058 119.758 48.2572C120.409 48.9085 121.292 49.2745 122.214 49.2745C123.135 49.2745 124.018 48.9085 124.67 48.2572C125.321 47.6058 125.687 46.7224 125.687 45.8012C125.687 44.88 125.321 43.9966 124.67 43.3452C124.018 42.6938 123.135 42.3279 122.214 42.3279C121.292 42.3279 120.409 42.6938 119.758 43.3452C119.106 43.9966 118.74 44.88 118.74 45.8012ZM125.687 45.8012C125.687 46.7224 126.053 47.6058 126.704 48.2572C127.356 48.9085 128.239 49.2745 129.16 49.2745C130.081 49.2745 130.965 48.9085 131.616 48.2572C132.268 47.6058 132.634 46.7224 132.634 45.8012C132.634 44.88 132.268 43.9966 131.616 43.3452C130.965 42.6938 130.081 42.3279 129.16 42.3279C128.239 42.3279 127.356 42.6938 126.704 43.3452C126.053 43.9966 125.687 44.88 125.687 45.8012ZM132.634 45.8012C132.634 46.7224 132.999 47.6058 133.651 48.2572C134.302 48.9085 135.186 49.2745 136.107 49.2745C137.028 49.2745 137.911 48.9085 138.563 48.2572C139.214 47.6058 139.58 46.7224 139.58 45.8012C139.58 44.88 139.214 43.9966 138.563 43.3452C137.911 42.6938 137.028 42.3279 136.107 42.3279C135.186 42.3279 134.302 42.6938 133.651 43.3452C132.999 43.9966 132.634 44.88 132.634 45.8012ZM139.58 45.8012C139.58 46.7224 139.946 47.6058 140.597 48.2572C141.249 48.9085 142.132 49.2745 143.053 49.2745C143.975 49.2745 144.858 48.9085 145.509 48.2572C146.161 47.6058 146.527 46.7224 146.527 45.8012C146.527 44.88 146.161 43.9966 145.509 43.3452C144.858 42.6938 143.975 42.3279 143.053 42.3279C142.132 42.3279 141.249 42.6938 140.597 43.3452C139.946 43.9966 139.58 44.88 139.58 45.8012ZM146.527 45.8012C146.527 46.7224 146.893 47.6058 147.544 48.2572C148.195 48.9085 149.079 49.2745 150 49.2745C150.921 49.2745 151.805 48.9085 152.456 48.2572C153.107 47.6058 153.473 46.7224 153.473 45.8012C153.473 44.88 153.107 43.9966 152.456 43.3452C151.805 42.6938 150.921 42.3279 150 42.3279C149.079 42.3279 148.195 42.6938 147.544 43.3452C146.893 43.9966 146.527 44.88 146.527 45.8012ZM153.473 45.8012C153.473 46.2573 153.563 46.7089 153.738 47.1303C153.912 47.5517 154.168 47.9346 154.491 48.2572C154.813 48.5797 155.196 48.8355 155.617 49.0101C156.039 49.1846 156.491 49.2745 156.947 49.2745C157.403 49.2745 157.854 49.1846 158.276 49.0101C158.697 48.8355 159.08 48.5797 159.403 48.2572C159.725 47.9346 159.981 47.5517 160.156 47.1303C160.33 46.7089 160.42 46.2573 160.42 45.8012C160.42 45.3451 160.33 44.8934 160.156 44.472C159.981 44.0506 159.725 43.6677 159.403 43.3452C159.08 43.0227 158.697 42.7668 158.276 42.5923C157.854 42.4177 157.403 42.3279 156.947 42.3279C156.491 42.3279 156.039 42.4177 155.617 42.5923C155.196 42.7668 154.813 43.0227 154.491 43.3452C154.168 43.6677 153.912 44.0506 153.738 44.472C153.563 44.8934 153.473 45.3451 153.473 45.8012ZM167.366 45.8012C167.366 46.7224 167.732 47.6058 168.384 48.2572C169.035 48.9085 169.919 49.2745 170.84 49.2745C171.761 49.2745 172.644 48.9085 173.296 48.2572C173.947 47.6058 174.313 46.7224 174.313 45.8012C174.313 44.88 173.947 43.9966 173.296 43.3452C172.644 42.6938 171.761 42.3279 170.84 42.3279C169.919 42.3279 169.035 42.6938 168.384 43.3452C167.732 43.9966 167.366 44.88 167.366 45.8012ZM174.313 45.8012C174.313 46.7224 174.679 47.6058 175.33 48.2572C175.982 48.9085 176.865 49.2745 177.786 49.2745C178.708 49.2745 179.591 48.9085 180.242 48.2572C180.894 47.6058 181.26 46.7224 181.26 45.8012C181.26 44.88 180.894 43.9966 180.242 43.3452C179.591 42.6938 178.708 42.3279 177.786 42.3279C176.865 42.3279 175.982 42.6938 175.33 43.3452C174.679 43.9966 174.313 44.88 174.313 45.8012ZM181.26 45.8012C181.26 46.7224 181.626 47.6058 182.277 48.2572C182.928 48.9085 183.812 49.2745 184.733 49.2745C185.654 49.2745 186.538 48.9085 187.189 48.2572C187.84 47.6058 188.206 46.7224 188.206 45.8012C188.206 44.88 187.84 43.9966 187.189 43.3452C186.538 42.6938 185.654 42.3279 184.733 42.3279C183.812 42.3279 182.928 42.6938 182.277 43.3452C181.626 43.9966 181.26 44.88 181.26 45.8012ZM188.206 45.8012C188.206 46.7224 188.572 47.6058 189.224 48.2572C189.875 48.9085 190.758 49.2745 191.68 49.2745C192.601 49.2745 193.484 48.9085 194.136 48.2572C194.787 47.6058 195.153 46.7224 195.153 45.8012C195.153 44.88 194.787 43.9966 194.136 43.3452C193.484 42.6938 192.601 42.3279 191.68 42.3279C190.758 42.3279 189.875 42.6938 189.224 43.3452C188.572 43.9966 188.206 44.88 188.206 45.8012ZM222.939 45.8012C222.939 46.7224 223.305 47.6058 223.957 48.2572C224.608 48.9085 225.491 49.2745 226.413 49.2745C227.334 49.2745 228.217 48.9085 228.868 48.2572C229.52 47.6058 229.886 46.7224 229.886 45.8012C229.886 44.88 229.52 43.9966 228.868 43.3452C228.217 42.6938 227.334 42.3279 226.413 42.3279C225.491 42.3279 224.608 42.6938 223.957 43.3452C223.305 43.9966 222.939 44.88 222.939 45.8012ZM243.779 45.8012C243.779 46.7224 244.145 47.6058 244.796 48.2572C245.448 48.9085 246.331 49.2745 247.252 49.2745C248.173 49.2745 249.057 48.9085 249.708 48.2572C250.36 47.6058 250.726 46.7224 250.726 45.8012C250.726 44.88 250.36 43.9966 249.708 43.3452C249.057 42.6938 248.173 42.3279 247.252 42.3279C246.331 42.3279 245.448 42.6938 244.796 43.3452C244.145 43.9966 243.779 44.88 243.779 45.8012ZM285.458 45.8012C285.458 46.7224 285.824 47.6058 286.476 48.2572C287.127 48.9085 288.011 49.2745 288.932 49.2745C289.853 49.2745 290.736 48.9085 291.388 48.2572C292.039 47.6058 292.405 46.7224 292.405 45.8012C292.405 44.88 292.039 43.9966 291.388 43.3452C290.736 42.6938 289.853 42.3279 288.932 42.3279C288.011 42.3279 287.127 42.6938 286.476 43.3452C285.824 43.9966 285.458 44.88 285.458 45.8012ZM7.59497 52.7478C7.59497 53.6689 7.96091 54.5524 8.61227 55.2038C9.26364 55.8551 10.1471 56.2211 11.0683 56.2211C11.9894 56.2211 12.8729 55.8551 13.5243 55.2038C14.1756 54.5524 14.5416 53.6689 14.5416 52.7478C14.5416 51.8266 14.1756 50.9431 13.5243 50.2918C12.8729 49.6404 11.9894 49.2745 11.0683 49.2745C10.1471 49.2745 9.26364 49.6404 8.61227 50.2918C7.96091 50.9431 7.59497 51.8266 7.59497 52.7478ZM14.5416 52.7478C14.5416 53.6689 14.9075 54.5524 15.5589 55.2038C16.2102 55.8551 17.0937 56.2211 18.0149 56.2211C18.936 56.2211 19.8195 55.8551 20.4708 55.2038C21.1222 54.5524 21.4881 53.6689 21.4881 52.7478C21.4881 51.8266 21.1222 50.9431 20.4708 50.2918C19.8195 49.6404 18.936 49.2745 18.0149 49.2745C17.0937 49.2745 16.2102 49.6404 15.5589 50.2918C14.9075 50.9431 14.5416 51.8266 14.5416 52.7478ZM21.4881 52.7478C21.4881 53.6689 21.8541 54.5524 22.5055 55.2038C23.1568 55.8551 24.0403 56.2211 24.9614 56.2211C25.8826 56.2211 26.7661 55.8551 27.4174 55.2038C28.0688 54.5524 28.4347 53.6689 28.4347 52.7478C28.4347 51.8266 28.0688 50.9431 27.4174 50.2918C26.7661 49.6404 25.8826 49.2745 24.9614 49.2745C24.0403 49.2745 23.1568 49.6404 22.5055 50.2918C21.8541 50.9431 21.4881 51.8266 21.4881 52.7478ZM28.4347 52.7478C28.4347 53.6689 28.8007 54.5524 29.452 55.2038C30.1034 55.8551 30.9869 56.2211 31.908 56.2211C32.8292 56.2211 33.7126 55.8551 34.364 55.2038C35.0154 54.5524 35.3813 53.6689 35.3813 52.7478C35.3813 51.8266 35.0154 50.9431 34.364 50.2918C33.7126 49.6404 32.8292 49.2745 31.908 49.2745C30.9869 49.2745 30.1034 49.6404 29.452 50.2918C28.8007 50.9431 28.4347 51.8266 28.4347 52.7478ZM35.3813 52.7478C35.3813 53.6689 35.7473 54.5524 36.3986 55.2038C37.05 55.8551 37.9334 56.2211 38.8546 56.2211C39.7758 56.2211 40.6592 55.8551 41.3106 55.2038C41.962 54.5524 42.3279 53.6689 42.3279 52.7478C42.3279 51.8266 41.962 50.9431 41.3106 50.2918C40.6592 49.6404 39.7758 49.2745 38.8546 49.2745C37.9334 49.2745 37.05 49.6404 36.3986 50.2918C35.7473 50.9431 35.3813 51.8266 35.3813 52.7478ZM42.3279 52.7478C42.3279 53.2039 42.4177 53.6555 42.5923 54.0769C42.7668 54.4983 43.0227 54.8812 43.3452 55.2038C43.6677 55.5263 44.0506 55.7821 44.472 55.9567C44.8934 56.1312 45.3451 56.2211 45.8012 56.2211C46.2573 56.2211 46.709 56.1312 47.1304 55.9567C47.5518 55.7821 47.9347 55.5263 48.2572 55.2038C48.5797 54.8812 48.8356 54.4983 49.0101 54.0769C49.1847 53.6555 49.2745 53.2039 49.2745 52.7478C49.2745 52.2916 49.1847 51.84 49.0101 51.4186C48.8356 50.9972 48.5797 50.6143 48.2572 50.2918C47.9347 49.9692 47.5518 49.7134 47.1304 49.5389C46.709 49.3643 46.2573 49.2745 45.8012 49.2745C45.3451 49.2745 44.8934 49.3643 44.472 49.5389C44.0506 49.7134 43.6677 49.9692 43.3452 50.2918C43.0227 50.6143 42.7668 50.9972 42.5923 51.4186C42.4177 51.84 42.3279 52.2916 42.3279 52.7478ZM49.2745 52.7478C49.2745 53.2039 49.3643 53.6555 49.5389 54.0769C49.7134 54.4983 49.9693 54.8812 50.2918 55.2038C50.6143 55.5263 50.9972 55.7821 51.4186 55.9567C51.84 56.1312 52.2917 56.2211 52.7478 56.2211C53.2039 56.2211 53.6556 56.1312 54.077 55.9567C54.4984 55.7821 54.8813 55.5263 55.2038 55.2038C55.5263 54.8812 55.7821 54.4983 55.9567 54.0769C56.1312 53.6555 56.2211 53.2039 56.2211 52.7478C56.2211 52.2916 56.1312 51.84 55.9567 51.4186C55.7821 50.9972 55.5263 50.6143 55.2038 50.2918C54.8813 49.9692 54.4984 49.7134 54.077 49.5389C53.6556 49.3643 53.2039 49.2745 52.7478 49.2745C52.2917 49.2745 51.84 49.3643 51.4186 49.5389C50.9972 49.7134 50.6143 49.9692 50.2918 50.2918C49.9693 50.6143 49.7134 50.9972 49.5389 51.4186C49.3643 51.84 49.2745 52.2916 49.2745 52.7478ZM63.1677 52.7478C63.1677 53.6689 63.5336 54.5524 64.185 55.2038C64.8363 55.8551 65.7198 56.2211 66.641 56.2211C67.5621 56.2211 68.4456 55.8551 69.097 55.2038C69.7483 54.5524 70.1143 53.6689 70.1143 52.7478C70.1143 51.8266 69.7483 50.9431 69.097 50.2918C68.4456 49.6404 67.5621 49.2745 66.641 49.2745C65.7198 49.2745 64.8363 49.6404 64.185 50.2918C63.5336 50.9431 63.1677 51.8266 63.1677 52.7478ZM77.0609 52.7478C77.0609 53.2039 77.1507 53.6555 77.3252 54.0769C77.4998 54.4983 77.7556 54.8812 78.0782 55.2038C78.4007 55.5263 78.7836 55.7821 79.205 55.9567C79.6264 56.1312 80.078 56.2211 80.5341 56.2211C80.9903 56.2211 81.4419 56.1312 81.8633 55.9567C82.2847 55.7821 82.6676 55.5263 82.9901 55.2038C83.3127 54.8812 83.5685 54.4983 83.743 54.0769C83.9176 53.6555 84.0074 53.2039 84.0074 52.7478C84.0074 52.2916 83.9176 51.84 83.743 51.4186C83.5685 50.9972 83.3127 50.6143 82.9901 50.2918C82.6676 49.9692 82.2847 49.7134 81.8633 49.5389C81.4419 49.3643 80.9903 49.2745 80.5341 49.2745C80.078 49.2745 79.6264 49.3643 79.205 49.5389C78.7836 49.7134 78.4007 49.9692 78.0782 50.2918C77.7556 50.6143 77.4998 50.9972 77.3252 51.4186C77.1507 51.84 77.0609 52.2916 77.0609 52.7478ZM90.954 52.7478C90.954 53.6689 91.32 54.5524 91.9713 55.2038C92.6227 55.8551 93.5061 56.2211 94.4273 56.2211C95.3485 56.2211 96.2319 55.8551 96.8833 55.2038C97.5347 54.5524 97.9006 53.6689 97.9006 52.7478C97.9006 51.8266 97.5347 50.9431 96.8833 50.2918C96.2319 49.6404 95.3485 49.2745 94.4273 49.2745C93.5061 49.2745 92.6227 49.6404 91.9713 50.2918C91.32 50.9431 90.954 51.8266 90.954 52.7478ZM104.847 52.7478C104.847 53.6689 105.213 54.5524 105.865 55.2038C106.516 55.8551 107.399 56.2211 108.321 56.2211C109.242 56.2211 110.125 55.8551 110.776 55.2038C111.428 54.5524 111.794 53.6689 111.794 52.7478C111.794 51.8266 111.428 50.9431 110.776 50.2918C110.125 49.6404 109.242 49.2745 108.321 49.2745C107.399 49.2745 106.516 49.6404 105.865 50.2918C105.213 50.9431 104.847 51.8266 104.847 52.7478ZM118.74 52.7478C118.74 53.6689 119.106 54.5524 119.758 55.2038C120.409 55.8551 121.292 56.2211 122.214 56.2211C123.135 56.2211 124.018 55.8551 124.67 55.2038C125.321 54.5524 125.687 53.6689 125.687 52.7478C125.687 51.8266 125.321 50.9431 124.67 50.2918C124.018 49.6404 123.135 49.2745 122.214 49.2745C121.292 49.2745 120.409 49.6404 119.758 50.2918C119.106 50.9431 118.74 51.8266 118.74 52.7478ZM132.634 52.7478C132.634 53.6689 132.999 54.5524 133.651 55.2038C134.302 55.8551 135.186 56.2211 136.107 56.2211C137.028 56.2211 137.911 55.8551 138.563 55.2038C139.214 54.5524 139.58 53.6689 139.58 52.7478C139.58 51.8266 139.214 50.9431 138.563 50.2918C137.911 49.6404 137.028 49.2745 136.107 49.2745C135.186 49.2745 134.302 49.6404 133.651 50.2918C132.999 50.9431 132.634 51.8266 132.634 52.7478ZM146.527 52.7478C146.527 53.6689 146.893 54.5524 147.544 55.2038C148.195 55.8551 149.079 56.2211 150 56.2211C150.921 56.2211 151.805 55.8551 152.456 55.2038C153.107 54.5524 153.473 53.6689 153.473 52.7478C153.473 51.8266 153.107 50.9431 152.456 50.2918C151.805 49.6404 150.921 49.2745 150 49.2745C149.079 49.2745 148.195 49.6404 147.544 50.2918C146.893 50.9431 146.527 51.8266 146.527 52.7478ZM160.42 52.7478C160.42 53.6689 160.786 54.5524 161.437 55.2038C162.089 55.8551 162.972 56.2211 163.893 56.2211C164.814 56.2211 165.698 55.8551 166.349 55.2038C167.001 54.5524 167.366 53.6689 167.366 52.7478C167.366 51.8266 167.001 50.9431 166.349 50.2918C165.698 49.6404 164.814 49.2745 163.893 49.2745C162.972 49.2745 162.089 49.6404 161.437 50.2918C160.786 50.9431 160.42 51.8266 160.42 52.7478ZM174.313 52.7478C174.313 53.6689 174.679 54.5524 175.33 55.2038C175.982 55.8551 176.865 56.2211 177.786 56.2211C178.708 56.2211 179.591 55.8551 180.242 55.2038C180.894 54.5524 181.26 53.6689 181.26 52.7478C181.26 51.8266 180.894 50.9431 180.242 50.2918C179.591 49.6404 178.708 49.2745 177.786 49.2745C176.865 49.2745 175.982 49.6404 175.33 50.2918C174.679 50.9431 174.313 51.8266 174.313 52.7478ZM188.206 52.7478C188.206 53.6689 188.572 54.5524 189.224 55.2038C189.875 55.8551 190.758 56.2211 191.68 56.2211C192.601 56.2211 193.484 55.8551 194.136 55.2038C194.787 54.5524 195.153 53.6689 195.153 52.7478C195.153 51.8266 194.787 50.9431 194.136 50.2918C193.484 49.6404 192.601 49.2745 191.68 49.2745C190.758 49.2745 189.875 49.6404 189.224 50.2918C188.572 50.9431 188.206 51.8266 188.206 52.7478ZM202.099 52.7478C202.099 53.6689 202.465 54.5524 203.117 55.2038C203.768 55.8551 204.652 56.2211 205.573 56.2211C206.494 56.2211 207.377 55.8551 208.029 55.2038C208.68 54.5524 209.046 53.6689 209.046 52.7478C209.046 51.8266 208.68 50.9431 208.029 50.2918C207.377 49.6404 206.494 49.2745 205.573 49.2745C204.652 49.2745 203.768 49.6404 203.117 50.2918C202.465 50.9431 202.099 51.8266 202.099 52.7478ZM215.993 52.7478C215.993 53.6689 216.359 54.5524 217.01 55.2038C217.661 55.8551 218.545 56.2211 219.466 56.2211C220.387 56.2211 221.271 55.8551 221.922 55.2038C222.573 54.5524 222.939 53.6689 222.939 52.7478C222.939 51.8266 222.573 50.9431 221.922 50.2918C221.271 49.6404 220.387 49.2745 219.466 49.2745C218.545 49.2745 217.661 49.6404 217.01 50.2918C216.359 50.9431 215.993 51.8266 215.993 52.7478ZM229.886 52.7478C229.886 53.6689 230.252 54.5524 230.903 55.2038C231.554 55.8551 232.438 56.2211 233.359 56.2211C234.28 56.2211 235.164 55.8551 235.815 55.2038C236.466 54.5524 236.832 53.6689 236.832 52.7478C236.832 51.8266 236.466 50.9431 235.815 50.2918C235.164 49.6404 234.28 49.2745 233.359 49.2745C232.438 49.2745 231.554 49.6404 230.903 50.2918C230.252 50.9431 229.886 51.8266 229.886 52.7478ZM243.779 52.7478C243.779 53.6689 244.145 54.5524 244.796 55.2038C245.448 55.8551 246.331 56.2211 247.252 56.2211C248.173 56.2211 249.057 55.8551 249.708 55.2038C250.36 54.5524 250.726 53.6689 250.726 52.7478C250.726 51.8266 250.36 50.9431 249.708 50.2918C249.057 49.6404 248.173 49.2745 247.252 49.2745C246.331 49.2745 245.448 49.6404 244.796 50.2918C244.145 50.9431 243.779 51.8266 243.779 52.7478ZM250.726 52.7478C250.726 53.6689 251.091 54.5524 251.743 55.2038C252.394 55.8551 253.278 56.2211 254.199 56.2211C255.12 56.2211 256.003 55.8551 256.655 55.2038C257.306 54.5524 257.672 53.6689 257.672 52.7478C257.672 51.8266 257.306 50.9431 256.655 50.2918C256.003 49.6404 255.12 49.2745 254.199 49.2745C253.278 49.2745 252.394 49.6404 251.743 50.2918C251.091 50.9431 250.726 51.8266 250.726 52.7478ZM257.672 52.7478C257.672 53.6689 258.038 54.5524 258.689 55.2038C259.341 55.8551 260.224 56.2211 261.145 56.2211C262.067 56.2211 262.95 55.8551 263.601 55.2038C264.253 54.5524 264.619 53.6689 264.619 52.7478C264.619 51.8266 264.253 50.9431 263.601 50.2918C262.95 49.6404 262.067 49.2745 261.145 49.2745C260.224 49.2745 259.341 49.6404 258.689 50.2918C258.038 50.9431 257.672 51.8266 257.672 52.7478ZM264.619 52.7478C264.619 53.6689 264.985 54.5524 265.636 55.2038C266.287 55.8551 267.171 56.2211 268.092 56.2211C269.013 56.2211 269.897 55.8551 270.548 55.2038C271.199 54.5524 271.565 53.6689 271.565 52.7478C271.565 51.8266 271.199 50.9431 270.548 50.2918C269.897 49.6404 269.013 49.2745 268.092 49.2745C267.171 49.2745 266.287 49.6404 265.636 50.2918C264.985 50.9431 264.619 51.8266 264.619 52.7478ZM271.565 52.7478C271.565 53.6689 271.931 54.5524 272.583 55.2038C273.234 55.8551 274.117 56.2211 275.039 56.2211C275.96 56.2211 276.843 55.8551 277.495 55.2038C278.146 54.5524 278.512 53.6689 278.512 52.7478C278.512 51.8266 278.146 50.9431 277.495 50.2918C276.843 49.6404 275.96 49.2745 275.039 49.2745C274.117 49.2745 273.234 49.6404 272.583 50.2918C271.931 50.9431 271.565 51.8266 271.565 52.7478ZM278.512 52.7478C278.512 53.6689 278.878 54.5524 279.529 55.2038C280.181 55.8551 281.064 56.2211 281.985 56.2211C282.906 56.2211 283.79 55.8551 284.441 55.2038C285.093 54.5524 285.458 53.6689 285.458 52.7478C285.458 51.8266 285.093 50.9431 284.441 50.2918C283.79 49.6404 282.906 49.2745 281.985 49.2745C281.064 49.2745 280.181 49.6404 279.529 50.2918C278.878 50.9431 278.512 51.8266 278.512 52.7478ZM285.458 52.7478C285.458 53.6689 285.824 54.5524 286.476 55.2038C287.127 55.8551 288.011 56.2211 288.932 56.2211C289.853 56.2211 290.736 55.8551 291.388 55.2038C292.039 54.5524 292.405 53.6689 292.405 52.7478C292.405 51.8266 292.039 50.9431 291.388 50.2918C290.736 49.6404 289.853 49.2745 288.932 49.2745C288.011 49.2745 287.127 49.6404 286.476 50.2918C285.824 50.9431 285.458 51.8266 285.458 52.7478ZM63.1677 59.6944C63.1677 60.6155 63.5336 61.499 64.185 62.1503C64.8363 62.8017 65.7198 63.1676 66.641 63.1676C67.5621 63.1676 68.4456 62.8017 69.097 62.1503C69.7483 61.499 70.1143 60.6155 70.1143 59.6944C70.1143 58.7732 69.7483 57.8897 69.097 57.2384C68.4456 56.587 67.5621 56.2211 66.641 56.2211C65.7198 56.2211 64.8363 56.587 64.185 57.2384C63.5336 57.8897 63.1677 58.7732 63.1677 59.6944ZM70.1143 59.6944C70.1143 60.6155 70.4802 61.499 71.1316 62.1503C71.7829 62.8017 72.6664 63.1676 73.5876 63.1676C74.5087 63.1676 75.3922 62.8017 76.0436 62.1503C76.6949 61.499 77.0609 60.6155 77.0609 59.6944C77.0609 58.7732 76.6949 57.8897 76.0436 57.2384C75.3922 56.587 74.5087 56.2211 73.5876 56.2211C72.6664 56.2211 71.7829 56.587 71.1316 57.2384C70.4802 57.8897 70.1143 58.7732 70.1143 59.6944ZM77.0609 59.6944C77.0609 60.1505 77.1507 60.6021 77.3252 61.0235C77.4998 61.4449 77.7556 61.8278 78.0782 62.1503C78.4007 62.4729 78.7836 62.7287 79.205 62.9033C79.6264 63.0778 80.078 63.1676 80.5341 63.1676C80.9903 63.1676 81.4419 63.0778 81.8633 62.9033C82.2847 62.7287 82.6676 62.4729 82.9901 62.1503C83.3127 61.8278 83.5685 61.4449 83.743 61.0235C83.9176 60.6021 84.0074 60.1505 84.0074 59.6944C84.0074 59.2382 83.9176 58.7866 83.743 58.3652C83.5685 57.9438 83.3127 57.5609 82.9901 57.2384C82.6676 56.9158 82.2847 56.66 81.8633 56.4854C81.4419 56.3109 80.9903 56.2211 80.5341 56.2211C80.078 56.2211 79.6264 56.3109 79.205 56.4854C78.7836 56.66 78.4007 56.9158 78.0782 57.2384C77.7556 57.5609 77.4998 57.9438 77.3252 58.3652C77.1507 58.7866 77.0609 59.2382 77.0609 59.6944ZM118.74 59.6944C118.74 60.6155 119.106 61.499 119.758 62.1503C120.409 62.8017 121.292 63.1676 122.214 63.1676C123.135 63.1676 124.018 62.8017 124.67 62.1503C125.321 61.499 125.687 60.6155 125.687 59.6944C125.687 58.7732 125.321 57.8897 124.67 57.2384C124.018 56.587 123.135 56.2211 122.214 56.2211C121.292 56.2211 120.409 56.587 119.758 57.2384C119.106 57.8897 118.74 58.7732 118.74 59.6944ZM125.687 59.6944C125.687 60.6155 126.053 61.499 126.704 62.1503C127.356 62.8017 128.239 63.1676 129.16 63.1676C130.081 63.1676 130.965 62.8017 131.616 62.1503C132.268 61.499 132.634 60.6155 132.634 59.6944C132.634 58.7732 132.268 57.8897 131.616 57.2384C130.965 56.587 130.081 56.2211 129.16 56.2211C128.239 56.2211 127.356 56.587 126.704 57.2384C126.053 57.8897 125.687 58.7732 125.687 59.6944ZM139.58 59.6944C139.58 60.6155 139.946 61.499 140.597 62.1503C141.249 62.8017 142.132 63.1676 143.053 63.1676C143.975 63.1676 144.858 62.8017 145.509 62.1503C146.161 61.499 146.527 60.6155 146.527 59.6944C146.527 58.7732 146.161 57.8897 145.509 57.2384C144.858 56.587 143.975 56.2211 143.053 56.2211C142.132 56.2211 141.249 56.587 140.597 57.2384C139.946 57.8897 139.58 58.7732 139.58 59.6944ZM160.42 59.6944C160.42 60.6155 160.786 61.499 161.437 62.1503C162.089 62.8017 162.972 63.1676 163.893 63.1676C164.814 63.1676 165.698 62.8017 166.349 62.1503C167.001 61.499 167.366 60.6155 167.366 59.6944C167.366 58.7732 167.001 57.8897 166.349 57.2384C165.698 56.587 164.814 56.2211 163.893 56.2211C162.972 56.2211 162.089 56.587 161.437 57.2384C160.786 57.8897 160.42 58.7732 160.42 59.6944ZM174.313 59.6944C174.313 60.6155 174.679 61.499 175.33 62.1503C175.982 62.8017 176.865 63.1676 177.786 63.1676C178.708 63.1676 179.591 62.8017 180.242 62.1503C180.894 61.499 181.26 60.6155 181.26 59.6944C181.26 58.7732 180.894 57.8897 180.242 57.2384C179.591 56.587 178.708 56.2211 177.786 56.2211C176.865 56.2211 175.982 56.587 175.33 57.2384C174.679 57.8897 174.313 58.7732 174.313 59.6944ZM188.206 59.6944C188.206 60.6155 188.572 61.499 189.224 62.1503C189.875 62.8017 190.758 63.1676 191.68 63.1676C192.601 63.1676 193.484 62.8017 194.136 62.1503C194.787 61.499 195.153 60.6155 195.153 59.6944C195.153 58.7732 194.787 57.8897 194.136 57.2384C193.484 56.587 192.601 56.2211 191.68 56.2211C190.758 56.2211 189.875 56.587 189.224 57.2384C188.572 57.8897 188.206 58.7732 188.206 59.6944ZM209.046 59.6944C209.046 60.6155 209.412 61.499 210.063 62.1503C210.715 62.8017 211.598 63.1676 212.519 63.1676C213.44 63.1676 214.324 62.8017 214.975 62.1503C215.627 61.499 215.993 60.6155 215.993 59.6944C215.993 58.7732 215.627 57.8897 214.975 57.2384C214.324 56.587 213.44 56.2211 212.519 56.2211C211.598 56.2211 210.715 56.587 210.063 57.2384C209.412 57.8897 209.046 58.7732 209.046 59.6944ZM215.993 59.6944C215.993 60.6155 216.359 61.499 217.01 62.1503C217.661 62.8017 218.545 63.1676 219.466 63.1676C220.387 63.1676 221.271 62.8017 221.922 62.1503C222.573 61.499 222.939 60.6155 222.939 59.6944C222.939 58.7732 222.573 57.8897 221.922 57.2384C221.271 56.587 220.387 56.2211 219.466 56.2211C218.545 56.2211 217.661 56.587 217.01 57.2384C216.359 57.8897 215.993 58.7732 215.993 59.6944ZM222.939 59.6944C222.939 60.6155 223.305 61.499 223.957 62.1503C224.608 62.8017 225.491 63.1676 226.413 63.1676C227.334 63.1676 228.217 62.8017 228.868 62.1503C229.52 61.499 229.886 60.6155 229.886 59.6944C229.886 58.7732 229.52 57.8897 228.868 57.2384C228.217 56.587 227.334 56.2211 226.413 56.2211C225.491 56.2211 224.608 56.587 223.957 57.2384C223.305 57.8897 222.939 58.7732 222.939 59.6944ZM229.886 59.6944C229.886 60.6155 230.252 61.499 230.903 62.1503C231.554 62.8017 232.438 63.1676 233.359 63.1676C234.28 63.1676 235.164 62.8017 235.815 62.1503C236.466 61.499 236.832 60.6155 236.832 59.6944C236.832 58.7732 236.466 57.8897 235.815 57.2384C235.164 56.587 234.28 56.2211 233.359 56.2211C232.438 56.2211 231.554 56.587 230.903 57.2384C230.252 57.8897 229.886 58.7732 229.886 59.6944ZM35.3813 66.6409C35.3813 67.5621 35.7473 68.4456 36.3986 69.0969C37.05 69.7483 37.9334 70.1142 38.8546 70.1142C39.7758 70.1142 40.6592 69.7483 41.3106 69.0969C41.962 68.4456 42.3279 67.5621 42.3279 66.6409C42.3279 65.7198 41.962 64.8363 41.3106 64.185C40.6592 63.5336 39.7758 63.1676 38.8546 63.1676C37.9334 63.1676 37.05 63.5336 36.3986 64.185C35.7473 64.8363 35.3813 65.7198 35.3813 66.6409ZM42.3279 66.6409C42.3279 67.0971 42.4177 67.5487 42.5923 67.9701C42.7668 68.3915 43.0227 68.7744 43.3452 69.0969C43.6677 69.4195 44.0506 69.6753 44.472 69.8498C44.8934 70.0244 45.3451 70.1142 45.8012 70.1142C46.2573 70.1142 46.709 70.0244 47.1304 69.8498C47.5518 69.6753 47.9347 69.4195 48.2572 69.0969C48.5797 68.7744 48.8356 68.3915 49.0101 67.9701C49.1847 67.5487 49.2745 67.0971 49.2745 66.6409C49.2745 66.1848 49.1847 65.7332 49.0101 65.3118C48.8356 64.8904 48.5797 64.5075 48.2572 64.185C47.9347 63.8624 47.5518 63.6066 47.1304 63.432C46.709 63.2575 46.2573 63.1676 45.8012 63.1676C45.3451 63.1676 44.8934 63.2575 44.472 63.432C44.0506 63.6066 43.6677 63.8624 43.3452 64.185C43.0227 64.5075 42.7668 64.8904 42.5923 65.3118C42.4177 65.7332 42.3279 66.1848 42.3279 66.6409ZM49.2745 66.6409C49.2745 67.0971 49.3643 67.5487 49.5389 67.9701C49.7134 68.3915 49.9693 68.7744 50.2918 69.0969C50.6143 69.4195 50.9972 69.6753 51.4186 69.8498C51.84 70.0244 52.2917 70.1142 52.7478 70.1142C53.2039 70.1142 53.6556 70.0244 54.077 69.8498C54.4984 69.6753 54.8813 69.4195 55.2038 69.0969C55.5263 68.7744 55.7821 68.3915 55.9567 67.9701C56.1312 67.5487 56.2211 67.0971 56.2211 66.6409C56.2211 66.1848 56.1312 65.7332 55.9567 65.3118C55.7821 64.8904 55.5263 64.5075 55.2038 64.185C54.8813 63.8624 54.4984 63.6066 54.077 63.432C53.6556 63.2575 53.2039 63.1676 52.7478 63.1676C52.2917 63.1676 51.84 63.2575 51.4186 63.432C50.9972 63.6066 50.6143 63.8624 50.2918 64.185C49.9693 64.5075 49.7134 64.8904 49.5389 65.3118C49.3643 65.7332 49.2745 66.1848 49.2745 66.6409ZM56.2211 66.6409C56.2211 67.5621 56.587 68.4456 57.2384 69.0969C57.8898 69.7483 58.7732 70.1142 59.6944 70.1142C60.6156 70.1142 61.499 69.7483 62.1504 69.0969C62.8017 68.4456 63.1677 67.5621 63.1677 66.6409C63.1677 65.7198 62.8017 64.8363 62.1504 64.185C61.499 63.5336 60.6156 63.1676 59.6944 63.1676C58.7732 63.1676 57.8898 63.5336 57.2384 64.185C56.587 64.8363 56.2211 65.7198 56.2211 66.6409ZM70.1143 66.6409C70.1143 67.5621 70.4802 68.4456 71.1316 69.0969C71.7829 69.7483 72.6664 70.1142 73.5876 70.1142C74.5087 70.1142 75.3922 69.7483 76.0436 69.0969C76.6949 68.4456 77.0609 67.5621 77.0609 66.6409C77.0609 65.7198 76.6949 64.8363 76.0436 64.185C75.3922 63.5336 74.5087 63.1676 73.5876 63.1676C72.6664 63.1676 71.7829 63.5336 71.1316 64.185C70.4802 64.8363 70.1143 65.7198 70.1143 66.6409ZM77.0609 66.6409C77.0609 67.0971 77.1507 67.5487 77.3252 67.9701C77.4998 68.3915 77.7556 68.7744 78.0782 69.0969C78.4007 69.4195 78.7836 69.6753 79.205 69.8498C79.6264 70.0244 80.078 70.1142 80.5341 70.1142C80.9903 70.1142 81.4419 70.0244 81.8633 69.8498C82.2847 69.6753 82.6676 69.4195 82.9901 69.0969C83.3127 68.7744 83.5685 68.3915 83.743 67.9701C83.9176 67.5487 84.0074 67.0971 84.0074 66.6409C84.0074 66.1848 83.9176 65.7332 83.743 65.3118C83.5685 64.8904 83.3127 64.5075 82.9901 64.185C82.6676 63.8624 82.2847 63.6066 81.8633 63.432C81.4419 63.2575 80.9903 63.1676 80.5341 63.1676C80.078 63.1676 79.6264 63.2575 79.205 63.432C78.7836 63.6066 78.4007 63.8624 78.0782 64.185C77.7556 64.5075 77.4998 64.8904 77.3252 65.3118C77.1507 65.7332 77.0609 66.1848 77.0609 66.6409ZM84.0074 66.6409C84.0074 67.5621 84.3734 68.4456 85.0247 69.0969C85.6761 69.7483 86.5596 70.1142 87.4807 70.1142C88.4019 70.1142 89.2854 69.7483 89.9367 69.0969C90.5881 68.4456 90.954 67.5621 90.954 66.6409C90.954 65.7198 90.5881 64.8363 89.9367 64.185C89.2854 63.5336 88.4019 63.1676 87.4807 63.1676C86.5596 63.1676 85.6761 63.5336 85.0247 64.185C84.3734 64.8363 84.0074 65.7198 84.0074 66.6409ZM111.794 66.6409C111.794 67.5621 112.16 68.4456 112.811 69.0969C113.462 69.7483 114.346 70.1142 115.267 70.1142C116.188 70.1142 117.072 69.7483 117.723 69.0969C118.374 68.4456 118.74 67.5621 118.74 66.6409C118.74 65.7198 118.374 64.8363 117.723 64.185C117.072 63.5336 116.188 63.1676 115.267 63.1676C114.346 63.1676 113.462 63.5336 112.811 64.185C112.16 64.8363 111.794 65.7198 111.794 66.6409ZM118.74 66.6409C118.74 67.5621 119.106 68.4456 119.758 69.0969C120.409 69.7483 121.292 70.1142 122.214 70.1142C123.135 70.1142 124.018 69.7483 124.67 69.0969C125.321 68.4456 125.687 67.5621 125.687 66.6409C125.687 65.7198 125.321 64.8363 124.67 64.185C124.018 63.5336 123.135 63.1676 122.214 63.1676C121.292 63.1676 120.409 63.5336 119.758 64.185C119.106 64.8363 118.74 65.7198 118.74 66.6409ZM125.687 66.6409C125.687 67.5621 126.053 68.4456 126.704 69.0969C127.356 69.7483 128.239 70.1142 129.16 70.1142C130.081 70.1142 130.965 69.7483 131.616 69.0969C132.268 68.4456 132.634 67.5621 132.634 66.6409C132.634 65.7198 132.268 64.8363 131.616 64.185C130.965 63.5336 130.081 63.1676 129.16 63.1676C128.239 63.1676 127.356 63.5336 126.704 64.185C126.053 64.8363 125.687 65.7198 125.687 66.6409ZM132.634 66.6409C132.634 67.5621 132.999 68.4456 133.651 69.0969C134.302 69.7483 135.186 70.1142 136.107 70.1142C137.028 70.1142 137.911 69.7483 138.563 69.0969C139.214 68.4456 139.58 67.5621 139.58 66.6409C139.58 65.7198 139.214 64.8363 138.563 64.185C137.911 63.5336 137.028 63.1676 136.107 63.1676C135.186 63.1676 134.302 63.5336 133.651 64.185C132.999 64.8363 132.634 65.7198 132.634 66.6409ZM160.42 66.6409C160.42 67.5621 160.786 68.4456 161.437 69.0969C162.089 69.7483 162.972 70.1142 163.893 70.1142C164.814 70.1142 165.698 69.7483 166.349 69.0969C167.001 68.4456 167.366 67.5621 167.366 66.6409C167.366 65.7198 167.001 64.8363 166.349 64.185C165.698 63.5336 164.814 63.1676 163.893 63.1676C162.972 63.1676 162.089 63.5336 161.437 64.185C160.786 64.8363 160.42 65.7198 160.42 66.6409ZM174.313 66.6409C174.313 67.5621 174.679 68.4456 175.33 69.0969C175.982 69.7483 176.865 70.1142 177.786 70.1142C178.708 70.1142 179.591 69.7483 180.242 69.0969C180.894 68.4456 181.26 67.5621 181.26 66.6409C181.26 65.7198 180.894 64.8363 180.242 64.185C179.591 63.5336 178.708 63.1676 177.786 63.1676C176.865 63.1676 175.982 63.5336 175.33 64.185C174.679 64.8363 174.313 65.7198 174.313 66.6409ZM195.153 66.6409C195.153 67.0971 195.243 67.5487 195.417 67.9701C195.592 68.3915 195.848 68.7744 196.17 69.0969C196.493 69.4195 196.876 69.6753 197.297 69.8498C197.718 70.0244 198.17 70.1142 198.626 70.1142C199.082 70.1142 199.534 70.0244 199.955 69.8498C200.377 69.6753 200.76 69.4195 201.082 69.0969C201.405 68.7744 201.661 68.3915 201.835 67.9701C202.01 67.5487 202.099 67.0971 202.099 66.6409C202.099 66.1848 202.01 65.7332 201.835 65.3118C201.661 64.8904 201.405 64.5075 201.082 64.185C200.76 63.8624 200.377 63.6066 199.955 63.432C199.534 63.2575 199.082 63.1676 198.626 63.1676C198.17 63.1676 197.718 63.2575 197.297 63.432C196.876 63.6066 196.493 63.8624 196.17 64.185C195.848 64.5075 195.592 64.8904 195.417 65.3118C195.243 65.7332 195.153 66.1848 195.153 66.6409ZM209.046 66.6409C209.046 67.5621 209.412 68.4456 210.063 69.0969C210.715 69.7483 211.598 70.1142 212.519 70.1142C213.44 70.1142 214.324 69.7483 214.975 69.0969C215.627 68.4456 215.993 67.5621 215.993 66.6409C215.993 65.7198 215.627 64.8363 214.975 64.185C214.324 63.5336 213.44 63.1676 212.519 63.1676C211.598 63.1676 210.715 63.5336 210.063 64.185C209.412 64.8363 209.046 65.7198 209.046 66.6409ZM243.779 66.6409C243.779 67.5621 244.145 68.4456 244.796 69.0969C245.448 69.7483 246.331 70.1142 247.252 70.1142C248.173 70.1142 249.057 69.7483 249.708 69.0969C250.36 68.4456 250.726 67.5621 250.726 66.6409C250.726 65.7198 250.36 64.8363 249.708 64.185C249.057 63.5336 248.173 63.1676 247.252 63.1676C246.331 63.1676 245.448 63.5336 244.796 64.185C244.145 64.8363 243.779 65.7198 243.779 66.6409ZM250.726 66.6409C250.726 67.5621 251.091 68.4456 251.743 69.0969C252.394 69.7483 253.278 70.1142 254.199 70.1142C255.12 70.1142 256.003 69.7483 256.655 69.0969C257.306 68.4456 257.672 67.5621 257.672 66.6409C257.672 65.7198 257.306 64.8363 256.655 64.185C256.003 63.5336 255.12 63.1676 254.199 63.1676C253.278 63.1676 252.394 63.5336 251.743 64.185C251.091 64.8363 250.726 65.7198 250.726 66.6409ZM278.512 66.6409C278.512 67.5621 278.878 68.4456 279.529 69.0969C280.181 69.7483 281.064 70.1142 281.985 70.1142C282.906 70.1142 283.79 69.7483 284.441 69.0969C285.093 68.4456 285.458 67.5621 285.458 66.6409C285.458 65.7198 285.093 64.8363 284.441 64.185C283.79 63.5336 282.906 63.1676 281.985 63.1676C281.064 63.1676 280.181 63.5336 279.529 64.185C278.878 64.8363 278.512 65.7198 278.512 66.6409ZM7.59497 73.5875C7.59497 74.5087 7.96091 75.3922 8.61227 76.0435C9.26364 76.6949 10.1471 77.0608 11.0683 77.0608C11.9894 77.0608 12.8729 76.6949 13.5243 76.0435C14.1756 75.3922 14.5416 74.5087 14.5416 73.5875C14.5416 72.6663 14.1756 71.7829 13.5243 71.1315C12.8729 70.4802 11.9894 70.1142 11.0683 70.1142C10.1471 70.1142 9.26364 70.4802 8.61227 71.1315C7.96091 71.7829 7.59497 72.6663 7.59497 73.5875ZM35.3813 73.5875C35.3813 74.5087 35.7473 75.3922 36.3986 76.0435C37.05 76.6949 37.9334 77.0608 38.8546 77.0608C39.7758 77.0608 40.6592 76.6949 41.3106 76.0435C41.962 75.3922 42.3279 74.5087 42.3279 73.5875C42.3279 72.6663 41.962 71.7829 41.3106 71.1315C40.6592 70.4802 39.7758 70.1142 38.8546 70.1142C37.9334 70.1142 37.05 70.4802 36.3986 71.1315C35.7473 71.7829 35.3813 72.6663 35.3813 73.5875ZM97.9006 73.5875C97.9006 74.0436 97.9905 74.4953 98.165 74.9167C98.3396 75.3381 98.5954 75.721 98.9179 76.0435C99.2404 76.366 99.6233 76.6219 100.045 76.7964C100.466 76.971 100.918 77.0608 101.374 77.0608C101.83 77.0608 102.282 76.971 102.703 76.7964C103.124 76.6219 103.507 76.366 103.83 76.0435C104.152 75.721 104.408 75.3381 104.583 74.9167C104.757 74.4953 104.847 74.0436 104.847 73.5875C104.847 73.1314 104.757 72.6798 104.583 72.2584C104.408 71.837 104.152 71.4541 103.83 71.1315C103.507 70.809 103.124 70.5532 102.703 70.3786C102.282 70.2041 101.83 70.1142 101.374 70.1142C100.918 70.1142 100.466 70.2041 100.045 70.3786C99.6233 70.5532 99.2404 70.809 98.9179 71.1315C98.5954 71.4541 98.3396 71.837 98.165 72.2584C97.9905 72.6798 97.9006 73.1314 97.9006 73.5875ZM111.794 73.5875C111.794 74.5087 112.16 75.3922 112.811 76.0435C113.462 76.6949 114.346 77.0608 115.267 77.0608C116.188 77.0608 117.072 76.6949 117.723 76.0435C118.374 75.3922 118.74 74.5087 118.74 73.5875C118.74 72.6663 118.374 71.7829 117.723 71.1315C117.072 70.4802 116.188 70.1142 115.267 70.1142C114.346 70.1142 113.462 70.4802 112.811 71.1315C112.16 71.7829 111.794 72.6663 111.794 73.5875ZM125.687 73.5875C125.687 74.5087 126.053 75.3922 126.704 76.0435C127.356 76.6949 128.239 77.0608 129.16 77.0608C130.081 77.0608 130.965 76.6949 131.616 76.0435C132.268 75.3922 132.634 74.5087 132.634 73.5875C132.634 72.6663 132.268 71.7829 131.616 71.1315C130.965 70.4802 130.081 70.1142 129.16 70.1142C128.239 70.1142 127.356 70.4802 126.704 71.1315C126.053 71.7829 125.687 72.6663 125.687 73.5875ZM146.527 73.5875C146.527 74.5087 146.893 75.3922 147.544 76.0435C148.195 76.6949 149.079 77.0608 150 77.0608C150.921 77.0608 151.805 76.6949 152.456 76.0435C153.107 75.3922 153.473 74.5087 153.473 73.5875C153.473 72.6663 153.107 71.7829 152.456 71.1315C151.805 70.4802 150.921 70.1142 150 70.1142C149.079 70.1142 148.195 70.4802 147.544 71.1315C146.893 71.7829 146.527 72.6663 146.527 73.5875ZM153.473 73.5875C153.473 74.0436 153.563 74.4953 153.738 74.9167C153.912 75.3381 154.168 75.721 154.491 76.0435C154.813 76.366 155.196 76.6219 155.617 76.7964C156.039 76.971 156.491 77.0608 156.947 77.0608C157.403 77.0608 157.854 76.971 158.276 76.7964C158.697 76.6219 159.08 76.366 159.403 76.0435C159.725 75.721 159.981 75.3381 160.156 74.9167C160.33 74.4953 160.42 74.0436 160.42 73.5875C160.42 73.1314 160.33 72.6798 160.156 72.2584C159.981 71.837 159.725 71.4541 159.403 71.1315C159.08 70.809 158.697 70.5532 158.276 70.3786C157.854 70.2041 157.403 70.1142 156.947 70.1142C156.491 70.1142 156.039 70.2041 155.617 70.3786C155.196 70.5532 154.813 70.809 154.491 71.1315C154.168 71.4541 153.912 71.837 153.738 72.2584C153.563 72.6798 153.473 73.1314 153.473 73.5875ZM160.42 73.5875C160.42 74.5087 160.786 75.3922 161.437 76.0435C162.089 76.6949 162.972 77.0608 163.893 77.0608C164.814 77.0608 165.698 76.6949 166.349 76.0435C167.001 75.3922 167.366 74.5087 167.366 73.5875C167.366 72.6663 167.001 71.7829 166.349 71.1315C165.698 70.4802 164.814 70.1142 163.893 70.1142C162.972 70.1142 162.089 70.4802 161.437 71.1315C160.786 71.7829 160.42 72.6663 160.42 73.5875ZM181.26 73.5875C181.26 74.5087 181.626 75.3922 182.277 76.0435C182.928 76.6949 183.812 77.0608 184.733 77.0608C185.654 77.0608 186.538 76.6949 187.189 76.0435C187.84 75.3922 188.206 74.5087 188.206 73.5875C188.206 72.6663 187.84 71.7829 187.189 71.1315C186.538 70.4802 185.654 70.1142 184.733 70.1142C183.812 70.1142 182.928 70.4802 182.277 71.1315C181.626 71.7829 181.26 72.6663 181.26 73.5875ZM188.206 73.5875C188.206 74.5087 188.572 75.3922 189.224 76.0435C189.875 76.6949 190.758 77.0608 191.68 77.0608C192.601 77.0608 193.484 76.6949 194.136 76.0435C194.787 75.3922 195.153 74.5087 195.153 73.5875C195.153 72.6663 194.787 71.7829 194.136 71.1315C193.484 70.4802 192.601 70.1142 191.68 70.1142C190.758 70.1142 189.875 70.4802 189.224 71.1315C188.572 71.7829 188.206 72.6663 188.206 73.5875ZM195.153 73.5875C195.153 74.0436 195.243 74.4953 195.417 74.9167C195.592 75.3381 195.848 75.721 196.17 76.0435C196.493 76.366 196.876 76.6219 197.297 76.7964C197.718 76.971 198.17 77.0608 198.626 77.0608C199.082 77.0608 199.534 76.971 199.955 76.7964C200.377 76.6219 200.76 76.366 201.082 76.0435C201.405 75.721 201.661 75.3381 201.835 74.9167C202.01 74.4953 202.099 74.0436 202.099 73.5875C202.099 73.1314 202.01 72.6798 201.835 72.2584C201.661 71.837 201.405 71.4541 201.082 71.1315C200.76 70.809 200.377 70.5532 199.955 70.3786C199.534 70.2041 199.082 70.1142 198.626 70.1142C198.17 70.1142 197.718 70.2041 197.297 70.3786C196.876 70.5532 196.493 70.809 196.17 71.1315C195.848 71.4541 195.592 71.837 195.417 72.2584C195.243 72.6798 195.153 73.1314 195.153 73.5875ZM202.099 73.5875C202.099 74.5087 202.465 75.3922 203.117 76.0435C203.768 76.6949 204.652 77.0608 205.573 77.0608C206.494 77.0608 207.377 76.6949 208.029 76.0435C208.68 75.3922 209.046 74.5087 209.046 73.5875C209.046 72.6663 208.68 71.7829 208.029 71.1315C207.377 70.4802 206.494 70.1142 205.573 70.1142C204.652 70.1142 203.768 70.4802 203.117 71.1315C202.465 71.7829 202.099 72.6663 202.099 73.5875ZM209.046 73.5875C209.046 74.5087 209.412 75.3922 210.063 76.0435C210.715 76.6949 211.598 77.0608 212.519 77.0608C213.44 77.0608 214.324 76.6949 214.975 76.0435C215.627 75.3922 215.993 74.5087 215.993 73.5875C215.993 72.6663 215.627 71.7829 214.975 71.1315C214.324 70.4802 213.44 70.1142 212.519 70.1142C211.598 70.1142 210.715 70.4802 210.063 71.1315C209.412 71.7829 209.046 72.6663 209.046 73.5875ZM215.993 73.5875C215.993 74.5087 216.359 75.3922 217.01 76.0435C217.661 76.6949 218.545 77.0608 219.466 77.0608C220.387 77.0608 221.271 76.6949 221.922 76.0435C222.573 75.3922 222.939 74.5087 222.939 73.5875C222.939 72.6663 222.573 71.7829 221.922 71.1315C221.271 70.4802 220.387 70.1142 219.466 70.1142C218.545 70.1142 217.661 70.4802 217.01 71.1315C216.359 71.7829 215.993 72.6663 215.993 73.5875ZM236.832 73.5875C236.832 74.5087 237.198 75.3922 237.85 76.0435C238.501 76.6949 239.384 77.0608 240.306 77.0608C241.227 77.0608 242.11 76.6949 242.762 76.0435C243.413 75.3922 243.779 74.5087 243.779 73.5875C243.779 72.6663 243.413 71.7829 242.762 71.1315C242.11 70.4802 241.227 70.1142 240.306 70.1142C239.384 70.1142 238.501 70.4802 237.85 71.1315C237.198 71.7829 236.832 72.6663 236.832 73.5875ZM243.779 73.5875C243.779 74.5087 244.145 75.3922 244.796 76.0435C245.448 76.6949 246.331 77.0608 247.252 77.0608C248.173 77.0608 249.057 76.6949 249.708 76.0435C250.36 75.3922 250.726 74.5087 250.726 73.5875C250.726 72.6663 250.36 71.7829 249.708 71.1315C249.057 70.4802 248.173 70.1142 247.252 70.1142C246.331 70.1142 245.448 70.4802 244.796 71.1315C244.145 71.7829 243.779 72.6663 243.779 73.5875ZM250.726 73.5875C250.726 74.5087 251.091 75.3922 251.743 76.0435C252.394 76.6949 253.278 77.0608 254.199 77.0608C255.12 77.0608 256.003 76.6949 256.655 76.0435C257.306 75.3922 257.672 74.5087 257.672 73.5875C257.672 72.6663 257.306 71.7829 256.655 71.1315C256.003 70.4802 255.12 70.1142 254.199 70.1142C253.278 70.1142 252.394 70.4802 251.743 71.1315C251.091 71.7829 250.726 72.6663 250.726 73.5875ZM257.672 73.5875C257.672 74.5087 258.038 75.3922 258.689 76.0435C259.341 76.6949 260.224 77.0608 261.145 77.0608C262.067 77.0608 262.95 76.6949 263.601 76.0435C264.253 75.3922 264.619 74.5087 264.619 73.5875C264.619 72.6663 264.253 71.7829 263.601 71.1315C262.95 70.4802 262.067 70.1142 261.145 70.1142C260.224 70.1142 259.341 70.4802 258.689 71.1315C258.038 71.7829 257.672 72.6663 257.672 73.5875ZM264.619 73.5875C264.619 74.5087 264.985 75.3922 265.636 76.0435C266.287 76.6949 267.171 77.0608 268.092 77.0608C269.013 77.0608 269.897 76.6949 270.548 76.0435C271.199 75.3922 271.565 74.5087 271.565 73.5875C271.565 72.6663 271.199 71.7829 270.548 71.1315C269.897 70.4802 269.013 70.1142 268.092 70.1142C267.171 70.1142 266.287 70.4802 265.636 71.1315C264.985 71.7829 264.619 72.6663 264.619 73.5875ZM278.512 73.5875C278.512 74.5087 278.878 75.3922 279.529 76.0435C280.181 76.6949 281.064 77.0608 281.985 77.0608C282.906 77.0608 283.79 76.6949 284.441 76.0435C285.093 75.3922 285.458 74.5087 285.458 73.5875C285.458 72.6663 285.093 71.7829 284.441 71.1315C283.79 70.4802 282.906 70.1142 281.985 70.1142C281.064 70.1142 280.181 70.4802 279.529 71.1315C278.878 71.7829 278.512 72.6663 278.512 73.5875ZM285.458 73.5875C285.458 74.5087 285.824 75.3922 286.476 76.0435C287.127 76.6949 288.011 77.0608 288.932 77.0608C289.853 77.0608 290.736 76.6949 291.388 76.0435C292.039 75.3922 292.405 74.5087 292.405 73.5875C292.405 72.6663 292.039 71.7829 291.388 71.1315C290.736 70.4802 289.853 70.1142 288.932 70.1142C288.011 70.1142 287.127 70.4802 286.476 71.1315C285.824 71.7829 285.458 72.6663 285.458 73.5875ZM7.59497 80.5341C7.59497 81.4553 7.96091 82.3387 8.61227 82.9901C9.26364 83.6415 10.1471 84.0074 11.0683 84.0074C11.9894 84.0074 12.8729 83.6415 13.5243 82.9901C14.1756 82.3387 14.5416 81.4553 14.5416 80.5341C14.5416 79.6129 14.1756 78.7295 13.5243 78.0781C12.8729 77.4268 11.9894 77.0608 11.0683 77.0608C10.1471 77.0608 9.26364 77.4268 8.61227 78.0781C7.96091 78.7295 7.59497 79.6129 7.59497 80.5341ZM21.4881 80.5341C21.4881 81.4553 21.8541 82.3387 22.5055 82.9901C23.1568 83.6415 24.0403 84.0074 24.9614 84.0074C25.8826 84.0074 26.7661 83.6415 27.4174 82.9901C28.0688 82.3387 28.4347 81.4553 28.4347 80.5341C28.4347 79.6129 28.0688 78.7295 27.4174 78.0781C26.7661 77.4268 25.8826 77.0608 24.9614 77.0608C24.0403 77.0608 23.1568 77.4268 22.5055 78.0781C21.8541 78.7295 21.4881 79.6129 21.4881 80.5341ZM28.4347 80.5341C28.4347 81.4553 28.8007 82.3387 29.452 82.9901C30.1034 83.6415 30.9869 84.0074 31.908 84.0074C32.8292 84.0074 33.7126 83.6415 34.364 82.9901C35.0154 82.3387 35.3813 81.4553 35.3813 80.5341C35.3813 79.6129 35.0154 78.7295 34.364 78.0781C33.7126 77.4268 32.8292 77.0608 31.908 77.0608C30.9869 77.0608 30.1034 77.4268 29.452 78.0781C28.8007 78.7295 28.4347 79.6129 28.4347 80.5341ZM35.3813 80.5341C35.3813 81.4553 35.7473 82.3387 36.3986 82.9901C37.05 83.6415 37.9334 84.0074 38.8546 84.0074C39.7758 84.0074 40.6592 83.6415 41.3106 82.9901C41.962 82.3387 42.3279 81.4553 42.3279 80.5341C42.3279 79.6129 41.962 78.7295 41.3106 78.0781C40.6592 77.4268 39.7758 77.0608 38.8546 77.0608C37.9334 77.0608 37.05 77.4268 36.3986 78.0781C35.7473 78.7295 35.3813 79.6129 35.3813 80.5341ZM49.2745 80.5341C49.2745 80.9902 49.3643 81.4419 49.5389 81.8633C49.7134 82.2847 49.9693 82.6676 50.2918 82.9901C50.6143 83.3126 50.9972 83.5685 51.4186 83.743C51.84 83.9176 52.2917 84.0074 52.7478 84.0074C53.2039 84.0074 53.6556 83.9176 54.077 83.743C54.4984 83.5685 54.8813 83.3126 55.2038 82.9901C55.5263 82.6676 55.7821 82.2847 55.9567 81.8633C56.1312 81.4419 56.2211 80.9902 56.2211 80.5341C56.2211 80.078 56.1312 79.6263 55.9567 79.2049C55.7821 78.7835 55.5263 78.4007 55.2038 78.0781C54.8813 77.7556 54.4984 77.4998 54.077 77.3252C53.6556 77.1507 53.2039 77.0608 52.7478 77.0608C52.2917 77.0608 51.84 77.1507 51.4186 77.3252C50.9972 77.4998 50.6143 77.7556 50.2918 78.0781C49.9693 78.4007 49.7134 78.7835 49.5389 79.2049C49.3643 79.6263 49.2745 80.078 49.2745 80.5341ZM56.2211 80.5341C56.2211 81.4553 56.587 82.3387 57.2384 82.9901C57.8898 83.6415 58.7732 84.0074 59.6944 84.0074C60.6156 84.0074 61.499 83.6415 62.1504 82.9901C62.8017 82.3387 63.1677 81.4553 63.1677 80.5341C63.1677 79.6129 62.8017 78.7295 62.1504 78.0781C61.499 77.4268 60.6156 77.0608 59.6944 77.0608C58.7732 77.0608 57.8898 77.4268 57.2384 78.0781C56.587 78.7295 56.2211 79.6129 56.2211 80.5341ZM63.1677 80.5341C63.1677 81.4553 63.5336 82.3387 64.185 82.9901C64.8363 83.6415 65.7198 84.0074 66.641 84.0074C67.5621 84.0074 68.4456 83.6415 69.097 82.9901C69.7483 82.3387 70.1143 81.4553 70.1143 80.5341C70.1143 79.6129 69.7483 78.7295 69.097 78.0781C68.4456 77.4268 67.5621 77.0608 66.641 77.0608C65.7198 77.0608 64.8363 77.4268 64.185 78.0781C63.5336 78.7295 63.1677 79.6129 63.1677 80.5341ZM70.1143 80.5341C70.1143 81.4553 70.4802 82.3387 71.1316 82.9901C71.7829 83.6415 72.6664 84.0074 73.5876 84.0074C74.5087 84.0074 75.3922 83.6415 76.0436 82.9901C76.6949 82.3387 77.0609 81.4553 77.0609 80.5341C77.0609 79.6129 76.6949 78.7295 76.0436 78.0781C75.3922 77.4268 74.5087 77.0608 73.5876 77.0608C72.6664 77.0608 71.7829 77.4268 71.1316 78.0781C70.4802 78.7295 70.1143 79.6129 70.1143 80.5341ZM77.0609 80.5341C77.0609 80.9902 77.1507 81.4419 77.3252 81.8633C77.4998 82.2847 77.7556 82.6676 78.0782 82.9901C78.4007 83.3126 78.7836 83.5685 79.205 83.743C79.6264 83.9176 80.078 84.0074 80.5341 84.0074C80.9903 84.0074 81.4419 83.9176 81.8633 83.743C82.2847 83.5685 82.6676 83.3126 82.9901 82.9901C83.3127 82.6676 83.5685 82.2847 83.743 81.8633C83.9176 81.4419 84.0074 80.9902 84.0074 80.5341C84.0074 80.078 83.9176 79.6263 83.743 79.2049C83.5685 78.7835 83.3127 78.4007 82.9901 78.0781C82.6676 77.7556 82.2847 77.4998 81.8633 77.3252C81.4419 77.1507 80.9903 77.0608 80.5341 77.0608C80.078 77.0608 79.6264 77.1507 79.205 77.3252C78.7836 77.4998 78.4007 77.7556 78.0782 78.0781C77.7556 78.4007 77.4998 78.7835 77.3252 79.2049C77.1507 79.6263 77.0609 80.078 77.0609 80.5341ZM84.0074 80.5341C84.0074 81.4553 84.3734 82.3387 85.0247 82.9901C85.6761 83.6415 86.5596 84.0074 87.4807 84.0074C88.4019 84.0074 89.2854 83.6415 89.9367 82.9901C90.5881 82.3387 90.954 81.4553 90.954 80.5341C90.954 79.6129 90.5881 78.7295 89.9367 78.0781C89.2854 77.4268 88.4019 77.0608 87.4807 77.0608C86.5596 77.0608 85.6761 77.4268 85.0247 78.0781C84.3734 78.7295 84.0074 79.6129 84.0074 80.5341ZM97.9006 80.5341C97.9006 80.9902 97.9905 81.4419 98.165 81.8633C98.3396 82.2847 98.5954 82.6676 98.9179 82.9901C99.2404 83.3126 99.6233 83.5685 100.045 83.743C100.466 83.9176 100.918 84.0074 101.374 84.0074C101.83 84.0074 102.282 83.9176 102.703 83.743C103.124 83.5685 103.507 83.3126 103.83 82.9901C104.152 82.6676 104.408 82.2847 104.583 81.8633C104.757 81.4419 104.847 80.9902 104.847 80.5341C104.847 80.078 104.757 79.6263 104.583 79.2049C104.408 78.7835 104.152 78.4007 103.83 78.0781C103.507 77.7556 103.124 77.4998 102.703 77.3252C102.282 77.1507 101.83 77.0608 101.374 77.0608C100.918 77.0608 100.466 77.1507 100.045 77.3252C99.6233 77.4998 99.2404 77.7556 98.9179 78.0781C98.5954 78.4007 98.3396 78.7835 98.165 79.2049C97.9905 79.6263 97.9006 80.078 97.9006 80.5341ZM111.794 80.5341C111.794 81.4553 112.16 82.3387 112.811 82.9901C113.462 83.6415 114.346 84.0074 115.267 84.0074C116.188 84.0074 117.072 83.6415 117.723 82.9901C118.374 82.3387 118.74 81.4553 118.74 80.5341C118.74 79.6129 118.374 78.7295 117.723 78.0781C117.072 77.4268 116.188 77.0608 115.267 77.0608C114.346 77.0608 113.462 77.4268 112.811 78.0781C112.16 78.7295 111.794 79.6129 111.794 80.5341ZM153.473 80.5341C153.473 80.9902 153.563 81.4419 153.738 81.8633C153.912 82.2847 154.168 82.6676 154.491 82.9901C154.813 83.3126 155.196 83.5685 155.617 83.743C156.039 83.9176 156.491 84.0074 156.947 84.0074C157.403 84.0074 157.854 83.9176 158.276 83.743C158.697 83.5685 159.08 83.3126 159.403 82.9901C159.725 82.6676 159.981 82.2847 160.156 81.8633C160.33 81.4419 160.42 80.9902 160.42 80.5341C160.42 80.078 160.33 79.6263 160.156 79.2049C159.981 78.7835 159.725 78.4007 159.403 78.0781C159.08 77.7556 158.697 77.4998 158.276 77.3252C157.854 77.1507 157.403 77.0608 156.947 77.0608C156.491 77.0608 156.039 77.1507 155.617 77.3252C155.196 77.4998 154.813 77.7556 154.491 78.0781C154.168 78.4007 153.912 78.7835 153.738 79.2049C153.563 79.6263 153.473 80.078 153.473 80.5341ZM160.42 80.5341C160.42 81.4553 160.786 82.3387 161.437 82.9901C162.089 83.6415 162.972 84.0074 163.893 84.0074C164.814 84.0074 165.698 83.6415 166.349 82.9901C167.001 82.3387 167.366 81.4553 167.366 80.5341C167.366 79.6129 167.001 78.7295 166.349 78.0781C165.698 77.4268 164.814 77.0608 163.893 77.0608C162.972 77.0608 162.089 77.4268 161.437 78.0781C160.786 78.7295 160.42 79.6129 160.42 80.5341ZM167.366 80.5341C167.366 81.4553 167.732 82.3387 168.384 82.9901C169.035 83.6415 169.919 84.0074 170.84 84.0074C171.761 84.0074 172.644 83.6415 173.296 82.9901C173.947 82.3387 174.313 81.4553 174.313 80.5341C174.313 79.6129 173.947 78.7295 173.296 78.0781C172.644 77.4268 171.761 77.0608 170.84 77.0608C169.919 77.0608 169.035 77.4268 168.384 78.0781C167.732 78.7295 167.366 79.6129 167.366 80.5341ZM188.206 80.5341C188.206 81.4553 188.572 82.3387 189.224 82.9901C189.875 83.6415 190.758 84.0074 191.68 84.0074C192.601 84.0074 193.484 83.6415 194.136 82.9901C194.787 82.3387 195.153 81.4553 195.153 80.5341C195.153 79.6129 194.787 78.7295 194.136 78.0781C193.484 77.4268 192.601 77.0608 191.68 77.0608C190.758 77.0608 189.875 77.4268 189.224 78.0781C188.572 78.7295 188.206 79.6129 188.206 80.5341ZM195.153 80.5341C195.153 80.9902 195.243 81.4419 195.417 81.8633C195.592 82.2847 195.848 82.6676 196.17 82.9901C196.493 83.3126 196.876 83.5685 197.297 83.743C197.718 83.9176 198.17 84.0074 198.626 84.0074C199.082 84.0074 199.534 83.9176 199.955 83.743C200.377 83.5685 200.76 83.3126 201.082 82.9901C201.405 82.6676 201.661 82.2847 201.835 81.8633C202.01 81.4419 202.099 80.9902 202.099 80.5341C202.099 80.078 202.01 79.6263 201.835 79.2049C201.661 78.7835 201.405 78.4007 201.082 78.0781C200.76 77.7556 200.377 77.4998 199.955 77.3252C199.534 77.1507 199.082 77.0608 198.626 77.0608C198.17 77.0608 197.718 77.1507 197.297 77.3252C196.876 77.4998 196.493 77.7556 196.17 78.0781C195.848 78.4007 195.592 78.7835 195.417 79.2049C195.243 79.6263 195.153 80.078 195.153 80.5341ZM215.993 80.5341C215.993 81.4553 216.359 82.3387 217.01 82.9901C217.661 83.6415 218.545 84.0074 219.466 84.0074C220.387 84.0074 221.271 83.6415 221.922 82.9901C222.573 82.3387 222.939 81.4553 222.939 80.5341C222.939 79.6129 222.573 78.7295 221.922 78.0781C221.271 77.4268 220.387 77.0608 219.466 77.0608C218.545 77.0608 217.661 77.4268 217.01 78.0781C216.359 78.7295 215.993 79.6129 215.993 80.5341ZM229.886 80.5341C229.886 81.4553 230.252 82.3387 230.903 82.9901C231.554 83.6415 232.438 84.0074 233.359 84.0074C234.28 84.0074 235.164 83.6415 235.815 82.9901C236.466 82.3387 236.832 81.4553 236.832 80.5341C236.832 79.6129 236.466 78.7295 235.815 78.0781C235.164 77.4268 234.28 77.0608 233.359 77.0608C232.438 77.0608 231.554 77.4268 230.903 78.0781C230.252 78.7295 229.886 79.6129 229.886 80.5341ZM250.726 80.5341C250.726 81.4553 251.091 82.3387 251.743 82.9901C252.394 83.6415 253.278 84.0074 254.199 84.0074C255.12 84.0074 256.003 83.6415 256.655 82.9901C257.306 82.3387 257.672 81.4553 257.672 80.5341C257.672 79.6129 257.306 78.7295 256.655 78.0781C256.003 77.4268 255.12 77.0608 254.199 77.0608C253.278 77.0608 252.394 77.4268 251.743 78.0781C251.091 78.7295 250.726 79.6129 250.726 80.5341ZM278.512 80.5341C278.512 81.4553 278.878 82.3387 279.529 82.9901C280.181 83.6415 281.064 84.0074 281.985 84.0074C282.906 84.0074 283.79 83.6415 284.441 82.9901C285.093 82.3387 285.458 81.4553 285.458 80.5341C285.458 79.6129 285.093 78.7295 284.441 78.0781C283.79 77.4268 282.906 77.0608 281.985 77.0608C281.064 77.0608 280.181 77.4268 279.529 78.0781C278.878 78.7295 278.512 79.6129 278.512 80.5341ZM285.458 80.5341C285.458 81.4553 285.824 82.3387 286.476 82.9901C287.127 83.6415 288.011 84.0074 288.932 84.0074C289.853 84.0074 290.736 83.6415 291.388 82.9901C292.039 82.3387 292.405 81.4553 292.405 80.5341C292.405 79.6129 292.039 78.7295 291.388 78.0781C290.736 77.4268 289.853 77.0608 288.932 77.0608C288.011 77.0608 287.127 77.4268 286.476 78.0781C285.824 78.7295 285.458 79.6129 285.458 80.5341ZM14.5416 87.4807C14.5416 88.4019 14.9075 89.2853 15.5589 89.9367C16.2102 90.5881 17.0937 90.954 18.0149 90.954C18.936 90.954 19.8195 90.5881 20.4708 89.9367C21.1222 89.2853 21.4881 88.4019 21.4881 87.4807C21.4881 86.5595 21.1222 85.6761 20.4708 85.0247C19.8195 84.3733 18.936 84.0074 18.0149 84.0074C17.0937 84.0074 16.2102 84.3733 15.5589 85.0247C14.9075 85.6761 14.5416 86.5595 14.5416 87.4807ZM63.1677 87.4807C63.1677 88.4019 63.5336 89.2853 64.185 89.9367C64.8363 90.5881 65.7198 90.954 66.641 90.954C67.5621 90.954 68.4456 90.5881 69.097 89.9367C69.7483 89.2853 70.1143 88.4019 70.1143 87.4807C70.1143 86.5595 69.7483 85.6761 69.097 85.0247C68.4456 84.3733 67.5621 84.0074 66.641 84.0074C65.7198 84.0074 64.8363 84.3733 64.185 85.0247C63.5336 85.6761 63.1677 86.5595 63.1677 87.4807ZM70.1143 87.4807C70.1143 88.4019 70.4802 89.2853 71.1316 89.9367C71.7829 90.5881 72.6664 90.954 73.5876 90.954C74.5087 90.954 75.3922 90.5881 76.0436 89.9367C76.6949 89.2853 77.0609 88.4019 77.0609 87.4807C77.0609 86.5595 76.6949 85.6761 76.0436 85.0247C75.3922 84.3733 74.5087 84.0074 73.5876 84.0074C72.6664 84.0074 71.7829 84.3733 71.1316 85.0247C70.4802 85.6761 70.1143 86.5595 70.1143 87.4807ZM77.0609 87.4807C77.0609 87.9368 77.1507 88.3885 77.3252 88.8099C77.4998 89.2313 77.7556 89.6142 78.0782 89.9367C78.4007 90.2592 78.7836 90.5151 79.205 90.6896C79.6264 90.8642 80.078 90.954 80.5341 90.954C80.9903 90.954 81.4419 90.8642 81.8633 90.6896C82.2847 90.5151 82.6676 90.2592 82.9901 89.9367C83.3127 89.6142 83.5685 89.2313 83.743 88.8099C83.9176 88.3885 84.0074 87.9368 84.0074 87.4807C84.0074 87.0246 83.9176 86.5729 83.743 86.1515C83.5685 85.7301 83.3127 85.3472 82.9901 85.0247C82.6676 84.7022 82.2847 84.4463 81.8633 84.2718C81.4419 84.0973 80.9903 84.0074 80.5341 84.0074C80.078 84.0074 79.6264 84.0973 79.205 84.2718C78.7836 84.4463 78.4007 84.7022 78.0782 85.0247C77.7556 85.3472 77.4998 85.7301 77.3252 86.1515C77.1507 86.5729 77.0609 87.0246 77.0609 87.4807ZM90.954 87.4807C90.954 88.4019 91.32 89.2853 91.9713 89.9367C92.6227 90.5881 93.5061 90.954 94.4273 90.954C95.3485 90.954 96.2319 90.5881 96.8833 89.9367C97.5347 89.2853 97.9006 88.4019 97.9006 87.4807C97.9006 86.5595 97.5347 85.6761 96.8833 85.0247C96.2319 84.3733 95.3485 84.0074 94.4273 84.0074C93.5061 84.0074 92.6227 84.3733 91.9713 85.0247C91.32 85.6761 90.954 86.5595 90.954 87.4807ZM104.847 87.4807C104.847 88.4019 105.213 89.2853 105.865 89.9367C106.516 90.5881 107.399 90.954 108.321 90.954C109.242 90.954 110.125 90.5881 110.776 89.9367C111.428 89.2853 111.794 88.4019 111.794 87.4807C111.794 86.5595 111.428 85.6761 110.776 85.0247C110.125 84.3733 109.242 84.0074 108.321 84.0074C107.399 84.0074 106.516 84.3733 105.865 85.0247C105.213 85.6761 104.847 86.5595 104.847 87.4807ZM118.74 87.4807C118.74 88.4019 119.106 89.2853 119.758 89.9367C120.409 90.5881 121.292 90.954 122.214 90.954C123.135 90.954 124.018 90.5881 124.67 89.9367C125.321 89.2853 125.687 88.4019 125.687 87.4807C125.687 86.5595 125.321 85.6761 124.67 85.0247C124.018 84.3733 123.135 84.0074 122.214 84.0074C121.292 84.0074 120.409 84.3733 119.758 85.0247C119.106 85.6761 118.74 86.5595 118.74 87.4807ZM153.473 87.4807C153.473 87.9368 153.563 88.3885 153.738 88.8099C153.912 89.2313 154.168 89.6142 154.491 89.9367C154.813 90.2592 155.196 90.5151 155.617 90.6896C156.039 90.8642 156.491 90.954 156.947 90.954C157.403 90.954 157.854 90.8642 158.276 90.6896C158.697 90.5151 159.08 90.2592 159.403 89.9367C159.725 89.6142 159.981 89.2313 160.156 88.8099C160.33 88.3885 160.42 87.9368 160.42 87.4807C160.42 87.0246 160.33 86.5729 160.156 86.1515C159.981 85.7301 159.725 85.3472 159.403 85.0247C159.08 84.7022 158.697 84.4463 158.276 84.2718C157.854 84.0973 157.403 84.0074 156.947 84.0074C156.491 84.0074 156.039 84.0973 155.617 84.2718C155.196 84.4463 154.813 84.7022 154.491 85.0247C154.168 85.3472 153.912 85.7301 153.738 86.1515C153.563 86.5729 153.473 87.0246 153.473 87.4807ZM167.366 87.4807C167.366 88.4019 167.732 89.2853 168.384 89.9367C169.035 90.5881 169.919 90.954 170.84 90.954C171.761 90.954 172.644 90.5881 173.296 89.9367C173.947 89.2853 174.313 88.4019 174.313 87.4807C174.313 86.5595 173.947 85.6761 173.296 85.0247C172.644 84.3733 171.761 84.0074 170.84 84.0074C169.919 84.0074 169.035 84.3733 168.384 85.0247C167.732 85.6761 167.366 86.5595 167.366 87.4807ZM174.313 87.4807C174.313 88.4019 174.679 89.2853 175.33 89.9367C175.982 90.5881 176.865 90.954 177.786 90.954C178.708 90.954 179.591 90.5881 180.242 89.9367C180.894 89.2853 181.26 88.4019 181.26 87.4807C181.26 86.5595 180.894 85.6761 180.242 85.0247C179.591 84.3733 178.708 84.0074 177.786 84.0074C176.865 84.0074 175.982 84.3733 175.33 85.0247C174.679 85.6761 174.313 86.5595 174.313 87.4807ZM209.046 87.4807C209.046 88.4019 209.412 89.2853 210.063 89.9367C210.715 90.5881 211.598 90.954 212.519 90.954C213.44 90.954 214.324 90.5881 214.975 89.9367C215.627 89.2853 215.993 88.4019 215.993 87.4807C215.993 86.5595 215.627 85.6761 214.975 85.0247C214.324 84.3733 213.44 84.0074 212.519 84.0074C211.598 84.0074 210.715 84.3733 210.063 85.0247C209.412 85.6761 209.046 86.5595 209.046 87.4807ZM222.939 87.4807C222.939 88.4019 223.305 89.2853 223.957 89.9367C224.608 90.5881 225.491 90.954 226.413 90.954C227.334 90.954 228.217 90.5881 228.868 89.9367C229.52 89.2853 229.886 88.4019 229.886 87.4807C229.886 86.5595 229.52 85.6761 228.868 85.0247C228.217 84.3733 227.334 84.0074 226.413 84.0074C225.491 84.0074 224.608 84.3733 223.957 85.0247C223.305 85.6761 222.939 86.5595 222.939 87.4807ZM229.886 87.4807C229.886 88.4019 230.252 89.2853 230.903 89.9367C231.554 90.5881 232.438 90.954 233.359 90.954C234.28 90.954 235.164 90.5881 235.815 89.9367C236.466 89.2853 236.832 88.4019 236.832 87.4807C236.832 86.5595 236.466 85.6761 235.815 85.0247C235.164 84.3733 234.28 84.0074 233.359 84.0074C232.438 84.0074 231.554 84.3733 230.903 85.0247C230.252 85.6761 229.886 86.5595 229.886 87.4807ZM236.832 87.4807C236.832 88.4019 237.198 89.2853 237.85 89.9367C238.501 90.5881 239.384 90.954 240.306 90.954C241.227 90.954 242.11 90.5881 242.762 89.9367C243.413 89.2853 243.779 88.4019 243.779 87.4807C243.779 86.5595 243.413 85.6761 242.762 85.0247C242.11 84.3733 241.227 84.0074 240.306 84.0074C239.384 84.0074 238.501 84.3733 237.85 85.0247C237.198 85.6761 236.832 86.5595 236.832 87.4807ZM250.726 87.4807C250.726 88.4019 251.091 89.2853 251.743 89.9367C252.394 90.5881 253.278 90.954 254.199 90.954C255.12 90.954 256.003 90.5881 256.655 89.9367C257.306 89.2853 257.672 88.4019 257.672 87.4807C257.672 86.5595 257.306 85.6761 256.655 85.0247C256.003 84.3733 255.12 84.0074 254.199 84.0074C253.278 84.0074 252.394 84.3733 251.743 85.0247C251.091 85.6761 250.726 86.5595 250.726 87.4807ZM257.672 87.4807C257.672 88.4019 258.038 89.2853 258.689 89.9367C259.341 90.5881 260.224 90.954 261.145 90.954C262.067 90.954 262.95 90.5881 263.601 89.9367C264.253 89.2853 264.619 88.4019 264.619 87.4807C264.619 86.5595 264.253 85.6761 263.601 85.0247C262.95 84.3733 262.067 84.0074 261.145 84.0074C260.224 84.0074 259.341 84.3733 258.689 85.0247C258.038 85.6761 257.672 86.5595 257.672 87.4807ZM264.619 87.4807C264.619 88.4019 264.985 89.2853 265.636 89.9367C266.287 90.5881 267.171 90.954 268.092 90.954C269.013 90.954 269.897 90.5881 270.548 89.9367C271.199 89.2853 271.565 88.4019 271.565 87.4807C271.565 86.5595 271.199 85.6761 270.548 85.0247C269.897 84.3733 269.013 84.0074 268.092 84.0074C267.171 84.0074 266.287 84.3733 265.636 85.0247C264.985 85.6761 264.619 86.5595 264.619 87.4807ZM278.512 87.4807C278.512 88.4019 278.878 89.2853 279.529 89.9367C280.181 90.5881 281.064 90.954 281.985 90.954C282.906 90.954 283.79 90.5881 284.441 89.9367C285.093 89.2853 285.458 88.4019 285.458 87.4807C285.458 86.5595 285.093 85.6761 284.441 85.0247C283.79 84.3733 282.906 84.0074 281.985 84.0074C281.064 84.0074 280.181 84.3733 279.529 85.0247C278.878 85.6761 278.512 86.5595 278.512 87.4807ZM7.59497 94.4273C7.59497 95.3485 7.96091 96.2319 8.61227 96.8833C9.26364 97.5347 10.1471 97.9006 11.0683 97.9006C11.9894 97.9006 12.8729 97.5347 13.5243 96.8833C14.1756 96.2319 14.5416 95.3485 14.5416 94.4273C14.5416 93.5061 14.1756 92.6227 13.5243 91.9713C12.8729 91.3199 11.9894 90.954 11.0683 90.954C10.1471 90.954 9.26364 91.3199 8.61227 91.9713C7.96091 92.6227 7.59497 93.5061 7.59497 94.4273ZM14.5416 94.4273C14.5416 95.3485 14.9075 96.2319 15.5589 96.8833C16.2102 97.5347 17.0937 97.9006 18.0149 97.9006C18.936 97.9006 19.8195 97.5347 20.4708 96.8833C21.1222 96.2319 21.4881 95.3485 21.4881 94.4273C21.4881 93.5061 21.1222 92.6227 20.4708 91.9713C19.8195 91.3199 18.936 90.954 18.0149 90.954C17.0937 90.954 16.2102 91.3199 15.5589 91.9713C14.9075 92.6227 14.5416 93.5061 14.5416 94.4273ZM21.4881 94.4273C21.4881 95.3485 21.8541 96.2319 22.5055 96.8833C23.1568 97.5347 24.0403 97.9006 24.9614 97.9006C25.8826 97.9006 26.7661 97.5347 27.4174 96.8833C28.0688 96.2319 28.4347 95.3485 28.4347 94.4273C28.4347 93.5061 28.0688 92.6227 27.4174 91.9713C26.7661 91.3199 25.8826 90.954 24.9614 90.954C24.0403 90.954 23.1568 91.3199 22.5055 91.9713C21.8541 92.6227 21.4881 93.5061 21.4881 94.4273ZM35.3813 94.4273C35.3813 95.3485 35.7473 96.2319 36.3986 96.8833C37.05 97.5347 37.9334 97.9006 38.8546 97.9006C39.7758 97.9006 40.6592 97.5347 41.3106 96.8833C41.962 96.2319 42.3279 95.3485 42.3279 94.4273C42.3279 93.5061 41.962 92.6227 41.3106 91.9713C40.6592 91.3199 39.7758 90.954 38.8546 90.954C37.9334 90.954 37.05 91.3199 36.3986 91.9713C35.7473 92.6227 35.3813 93.5061 35.3813 94.4273ZM49.2745 94.4273C49.2745 94.8834 49.3643 95.3351 49.5389 95.7565C49.7134 96.1779 49.9693 96.5608 50.2918 96.8833C50.6143 97.2058 50.9972 97.4616 51.4186 97.6362C51.84 97.8107 52.2917 97.9006 52.7478 97.9006C53.2039 97.9006 53.6556 97.8107 54.077 97.6362C54.4984 97.4616 54.8813 97.2058 55.2038 96.8833C55.5263 96.5608 55.7821 96.1779 55.9567 95.7565C56.1312 95.3351 56.2211 94.8834 56.2211 94.4273C56.2211 93.9712 56.1312 93.5195 55.9567 93.0981C55.7821 92.6767 55.5263 92.2938 55.2038 91.9713C54.8813 91.6488 54.4984 91.3929 54.077 91.2184C53.6556 91.0438 53.2039 90.954 52.7478 90.954C52.2917 90.954 51.84 91.0438 51.4186 91.2184C50.9972 91.3929 50.6143 91.6488 50.2918 91.9713C49.9693 92.2938 49.7134 92.6767 49.5389 93.0981C49.3643 93.5195 49.2745 93.9712 49.2745 94.4273ZM63.1677 94.4273C63.1677 95.3485 63.5336 96.2319 64.185 96.8833C64.8363 97.5347 65.7198 97.9006 66.641 97.9006C67.5621 97.9006 68.4456 97.5347 69.097 96.8833C69.7483 96.2319 70.1143 95.3485 70.1143 94.4273C70.1143 93.5061 69.7483 92.6227 69.097 91.9713C68.4456 91.3199 67.5621 90.954 66.641 90.954C65.7198 90.954 64.8363 91.3199 64.185 91.9713C63.5336 92.6227 63.1677 93.5061 63.1677 94.4273ZM77.0609 94.4273C77.0609 94.8834 77.1507 95.3351 77.3252 95.7565C77.4998 96.1779 77.7556 96.5608 78.0782 96.8833C78.4007 97.2058 78.7836 97.4616 79.205 97.6362C79.6264 97.8107 80.078 97.9006 80.5341 97.9006C80.9903 97.9006 81.4419 97.8107 81.8633 97.6362C82.2847 97.4616 82.6676 97.2058 82.9901 96.8833C83.3127 96.5608 83.5685 96.1779 83.743 95.7565C83.9176 95.3351 84.0074 94.8834 84.0074 94.4273C84.0074 93.9712 83.9176 93.5195 83.743 93.0981C83.5685 92.6767 83.3127 92.2938 82.9901 91.9713C82.6676 91.6488 82.2847 91.3929 81.8633 91.2184C81.4419 91.0438 80.9903 90.954 80.5341 90.954C80.078 90.954 79.6264 91.0438 79.205 91.2184C78.7836 91.3929 78.4007 91.6488 78.0782 91.9713C77.7556 92.2938 77.4998 92.6767 77.3252 93.0981C77.1507 93.5195 77.0609 93.9712 77.0609 94.4273ZM90.954 94.4273C90.954 95.3485 91.32 96.2319 91.9713 96.8833C92.6227 97.5347 93.5061 97.9006 94.4273 97.9006C95.3485 97.9006 96.2319 97.5347 96.8833 96.8833C97.5347 96.2319 97.9006 95.3485 97.9006 94.4273C97.9006 93.5061 97.5347 92.6227 96.8833 91.9713C96.2319 91.3199 95.3485 90.954 94.4273 90.954C93.5061 90.954 92.6227 91.3199 91.9713 91.9713C91.32 92.6227 90.954 93.5061 90.954 94.4273ZM111.794 94.4273C111.794 95.3485 112.16 96.2319 112.811 96.8833C113.462 97.5347 114.346 97.9006 115.267 97.9006C116.188 97.9006 117.072 97.5347 117.723 96.8833C118.374 96.2319 118.74 95.3485 118.74 94.4273C118.74 93.5061 118.374 92.6227 117.723 91.9713C117.072 91.3199 116.188 90.954 115.267 90.954C114.346 90.954 113.462 91.3199 112.811 91.9713C112.16 92.6227 111.794 93.5061 111.794 94.4273ZM118.74 94.4273C118.74 95.3485 119.106 96.2319 119.758 96.8833C120.409 97.5347 121.292 97.9006 122.214 97.9006C123.135 97.9006 124.018 97.5347 124.67 96.8833C125.321 96.2319 125.687 95.3485 125.687 94.4273C125.687 93.5061 125.321 92.6227 124.67 91.9713C124.018 91.3199 123.135 90.954 122.214 90.954C121.292 90.954 120.409 91.3199 119.758 91.9713C119.106 92.6227 118.74 93.5061 118.74 94.4273ZM139.58 94.4273C139.58 95.3485 139.946 96.2319 140.597 96.8833C141.249 97.5347 142.132 97.9006 143.053 97.9006C143.975 97.9006 144.858 97.5347 145.509 96.8833C146.161 96.2319 146.527 95.3485 146.527 94.4273C146.527 93.5061 146.161 92.6227 145.509 91.9713C144.858 91.3199 143.975 90.954 143.053 90.954C142.132 90.954 141.249 91.3199 140.597 91.9713C139.946 92.6227 139.58 93.5061 139.58 94.4273ZM146.527 94.4273C146.527 95.3485 146.893 96.2319 147.544 96.8833C148.195 97.5347 149.079 97.9006 150 97.9006C150.921 97.9006 151.805 97.5347 152.456 96.8833C153.107 96.2319 153.473 95.3485 153.473 94.4273C153.473 93.5061 153.107 92.6227 152.456 91.9713C151.805 91.3199 150.921 90.954 150 90.954C149.079 90.954 148.195 91.3199 147.544 91.9713C146.893 92.6227 146.527 93.5061 146.527 94.4273ZM153.473 94.4273C153.473 94.8834 153.563 95.3351 153.738 95.7565C153.912 96.1779 154.168 96.5608 154.491 96.8833C154.813 97.2058 155.196 97.4616 155.617 97.6362C156.039 97.8107 156.491 97.9006 156.947 97.9006C157.403 97.9006 157.854 97.8107 158.276 97.6362C158.697 97.4616 159.08 97.2058 159.403 96.8833C159.725 96.5608 159.981 96.1779 160.156 95.7565C160.33 95.3351 160.42 94.8834 160.42 94.4273C160.42 93.9712 160.33 93.5195 160.156 93.0981C159.981 92.6767 159.725 92.2938 159.403 91.9713C159.08 91.6488 158.697 91.3929 158.276 91.2184C157.854 91.0438 157.403 90.954 156.947 90.954C156.491 90.954 156.039 91.0438 155.617 91.2184C155.196 91.3929 154.813 91.6488 154.491 91.9713C154.168 92.2938 153.912 92.6767 153.738 93.0981C153.563 93.5195 153.473 93.9712 153.473 94.4273ZM167.366 94.4273C167.366 95.3485 167.732 96.2319 168.384 96.8833C169.035 97.5347 169.919 97.9006 170.84 97.9006C171.761 97.9006 172.644 97.5347 173.296 96.8833C173.947 96.2319 174.313 95.3485 174.313 94.4273C174.313 93.5061 173.947 92.6227 173.296 91.9713C172.644 91.3199 171.761 90.954 170.84 90.954C169.919 90.954 169.035 91.3199 168.384 91.9713C167.732 92.6227 167.366 93.5061 167.366 94.4273ZM174.313 94.4273C174.313 95.3485 174.679 96.2319 175.33 96.8833C175.982 97.5347 176.865 97.9006 177.786 97.9006C178.708 97.9006 179.591 97.5347 180.242 96.8833C180.894 96.2319 181.26 95.3485 181.26 94.4273C181.26 93.5061 180.894 92.6227 180.242 91.9713C179.591 91.3199 178.708 90.954 177.786 90.954C176.865 90.954 175.982 91.3199 175.33 91.9713C174.679 92.6227 174.313 93.5061 174.313 94.4273ZM181.26 94.4273C181.26 95.3485 181.626 96.2319 182.277 96.8833C182.928 97.5347 183.812 97.9006 184.733 97.9006C185.654 97.9006 186.538 97.5347 187.189 96.8833C187.84 96.2319 188.206 95.3485 188.206 94.4273C188.206 93.5061 187.84 92.6227 187.189 91.9713C186.538 91.3199 185.654 90.954 184.733 90.954C183.812 90.954 182.928 91.3199 182.277 91.9713C181.626 92.6227 181.26 93.5061 181.26 94.4273ZM188.206 94.4273C188.206 95.3485 188.572 96.2319 189.224 96.8833C189.875 97.5347 190.758 97.9006 191.68 97.9006C192.601 97.9006 193.484 97.5347 194.136 96.8833C194.787 96.2319 195.153 95.3485 195.153 94.4273C195.153 93.5061 194.787 92.6227 194.136 91.9713C193.484 91.3199 192.601 90.954 191.68 90.954C190.758 90.954 189.875 91.3199 189.224 91.9713C188.572 92.6227 188.206 93.5061 188.206 94.4273ZM209.046 94.4273C209.046 95.3485 209.412 96.2319 210.063 96.8833C210.715 97.5347 211.598 97.9006 212.519 97.9006C213.44 97.9006 214.324 97.5347 214.975 96.8833C215.627 96.2319 215.993 95.3485 215.993 94.4273C215.993 93.5061 215.627 92.6227 214.975 91.9713C214.324 91.3199 213.44 90.954 212.519 90.954C211.598 90.954 210.715 91.3199 210.063 91.9713C209.412 92.6227 209.046 93.5061 209.046 94.4273ZM236.832 94.4273C236.832 95.3485 237.198 96.2319 237.85 96.8833C238.501 97.5347 239.384 97.9006 240.306 97.9006C241.227 97.9006 242.11 97.5347 242.762 96.8833C243.413 96.2319 243.779 95.3485 243.779 94.4273C243.779 93.5061 243.413 92.6227 242.762 91.9713C242.11 91.3199 241.227 90.954 240.306 90.954C239.384 90.954 238.501 91.3199 237.85 91.9713C237.198 92.6227 236.832 93.5061 236.832 94.4273ZM243.779 94.4273C243.779 95.3485 244.145 96.2319 244.796 96.8833C245.448 97.5347 246.331 97.9006 247.252 97.9006C248.173 97.9006 249.057 97.5347 249.708 96.8833C250.36 96.2319 250.726 95.3485 250.726 94.4273C250.726 93.5061 250.36 92.6227 249.708 91.9713C249.057 91.3199 248.173 90.954 247.252 90.954C246.331 90.954 245.448 91.3199 244.796 91.9713C244.145 92.6227 243.779 93.5061 243.779 94.4273ZM278.512 94.4273C278.512 95.3485 278.878 96.2319 279.529 96.8833C280.181 97.5347 281.064 97.9006 281.985 97.9006C282.906 97.9006 283.79 97.5347 284.441 96.8833C285.093 96.2319 285.458 95.3485 285.458 94.4273C285.458 93.5061 285.093 92.6227 284.441 91.9713C283.79 91.3199 282.906 90.954 281.985 90.954C281.064 90.954 280.181 91.3199 279.529 91.9713C278.878 92.6227 278.512 93.5061 278.512 94.4273ZM7.59497 101.374C7.59497 102.295 7.96091 103.178 8.61227 103.83C9.26364 104.481 10.1471 104.847 11.0683 104.847C11.9894 104.847 12.8729 104.481 13.5243 103.83C14.1756 103.178 14.5416 102.295 14.5416 101.374C14.5416 100.453 14.1756 99.5693 13.5243 98.9179C12.8729 98.2665 11.9894 97.9006 11.0683 97.9006C10.1471 97.9006 9.26364 98.2665 8.61227 98.9179C7.96091 99.5693 7.59497 100.453 7.59497 101.374ZM14.5416 101.374C14.5416 102.295 14.9075 103.178 15.5589 103.83C16.2102 104.481 17.0937 104.847 18.0149 104.847C18.936 104.847 19.8195 104.481 20.4708 103.83C21.1222 103.178 21.4881 102.295 21.4881 101.374C21.4881 100.453 21.1222 99.5693 20.4708 98.9179C19.8195 98.2665 18.936 97.9006 18.0149 97.9006C17.0937 97.9006 16.2102 98.2665 15.5589 98.9179C14.9075 99.5693 14.5416 100.453 14.5416 101.374ZM28.4347 101.374C28.4347 102.295 28.8007 103.178 29.452 103.83C30.1034 104.481 30.9869 104.847 31.908 104.847C32.8292 104.847 33.7126 104.481 34.364 103.83C35.0154 103.178 35.3813 102.295 35.3813 101.374C35.3813 100.453 35.0154 99.5693 34.364 98.9179C33.7126 98.2665 32.8292 97.9006 31.908 97.9006C30.9869 97.9006 30.1034 98.2665 29.452 98.9179C28.8007 99.5693 28.4347 100.453 28.4347 101.374ZM35.3813 101.374C35.3813 102.295 35.7473 103.178 36.3986 103.83C37.05 104.481 37.9334 104.847 38.8546 104.847C39.7758 104.847 40.6592 104.481 41.3106 103.83C41.962 103.178 42.3279 102.295 42.3279 101.374C42.3279 100.453 41.962 99.5693 41.3106 98.9179C40.6592 98.2665 39.7758 97.9006 38.8546 97.9006C37.9334 97.9006 37.05 98.2665 36.3986 98.9179C35.7473 99.5693 35.3813 100.453 35.3813 101.374ZM56.2211 101.374C56.2211 102.295 56.587 103.178 57.2384 103.83C57.8898 104.481 58.7732 104.847 59.6944 104.847C60.6156 104.847 61.499 104.481 62.1504 103.83C62.8017 103.178 63.1677 102.295 63.1677 101.374C63.1677 100.453 62.8017 99.5693 62.1504 98.9179C61.499 98.2665 60.6156 97.9006 59.6944 97.9006C58.7732 97.9006 57.8898 98.2665 57.2384 98.9179C56.587 99.5693 56.2211 100.453 56.2211 101.374ZM70.1143 101.374C70.1143 102.295 70.4802 103.178 71.1316 103.83C71.7829 104.481 72.6664 104.847 73.5876 104.847C74.5087 104.847 75.3922 104.481 76.0436 103.83C76.6949 103.178 77.0609 102.295 77.0609 101.374C77.0609 100.453 76.6949 99.5693 76.0436 98.9179C75.3922 98.2665 74.5087 97.9006 73.5876 97.9006C72.6664 97.9006 71.7829 98.2665 71.1316 98.9179C70.4802 99.5693 70.1143 100.453 70.1143 101.374ZM77.0609 101.374C77.0609 101.83 77.1507 102.282 77.3252 102.703C77.4998 103.124 77.7556 103.507 78.0782 103.83C78.4007 104.152 78.7836 104.408 79.205 104.583C79.6264 104.757 80.078 104.847 80.5341 104.847C80.9903 104.847 81.4419 104.757 81.8633 104.583C82.2847 104.408 82.6676 104.152 82.9901 103.83C83.3127 103.507 83.5685 103.124 83.743 102.703C83.9176 102.282 84.0074 101.83 84.0074 101.374C84.0074 100.918 83.9176 100.466 83.743 100.045C83.5685 99.6233 83.3127 99.2404 82.9901 98.9179C82.6676 98.5954 82.2847 98.3395 81.8633 98.165C81.4419 97.9904 80.9903 97.9006 80.5341 97.9006C80.078 97.9006 79.6264 97.9904 79.205 98.165C78.7836 98.3395 78.4007 98.5954 78.0782 98.9179C77.7556 99.2404 77.4998 99.6233 77.3252 100.045C77.1507 100.466 77.0609 100.918 77.0609 101.374ZM97.9006 101.374C97.9006 101.83 97.9905 102.282 98.165 102.703C98.3396 103.124 98.5954 103.507 98.9179 103.83C99.2404 104.152 99.6233 104.408 100.045 104.583C100.466 104.757 100.918 104.847 101.374 104.847C101.83 104.847 102.282 104.757 102.703 104.583C103.124 104.408 103.507 104.152 103.83 103.83C104.152 103.507 104.408 103.124 104.583 102.703C104.757 102.282 104.847 101.83 104.847 101.374C104.847 100.918 104.757 100.466 104.583 100.045C104.408 99.6233 104.152 99.2404 103.83 98.9179C103.507 98.5954 103.124 98.3395 102.703 98.165C102.282 97.9904 101.83 97.9006 101.374 97.9006C100.918 97.9006 100.466 97.9904 100.045 98.165C99.6233 98.3395 99.2404 98.5954 98.9179 98.9179C98.5954 99.2404 98.3396 99.6233 98.165 100.045C97.9905 100.466 97.9006 100.918 97.9006 101.374ZM111.794 101.374C111.794 102.295 112.16 103.178 112.811 103.83C113.462 104.481 114.346 104.847 115.267 104.847C116.188 104.847 117.072 104.481 117.723 103.83C118.374 103.178 118.74 102.295 118.74 101.374C118.74 100.453 118.374 99.5693 117.723 98.9179C117.072 98.2665 116.188 97.9006 115.267 97.9006C114.346 97.9006 113.462 98.2665 112.811 98.9179C112.16 99.5693 111.794 100.453 111.794 101.374ZM118.74 101.374C118.74 102.295 119.106 103.178 119.758 103.83C120.409 104.481 121.292 104.847 122.214 104.847C123.135 104.847 124.018 104.481 124.67 103.83C125.321 103.178 125.687 102.295 125.687 101.374C125.687 100.453 125.321 99.5693 124.67 98.9179C124.018 98.2665 123.135 97.9006 122.214 97.9006C121.292 97.9006 120.409 98.2665 119.758 98.9179C119.106 99.5693 118.74 100.453 118.74 101.374ZM132.634 101.374C132.634 102.295 132.999 103.178 133.651 103.83C134.302 104.481 135.186 104.847 136.107 104.847C137.028 104.847 137.911 104.481 138.563 103.83C139.214 103.178 139.58 102.295 139.58 101.374C139.58 100.453 139.214 99.5693 138.563 98.9179C137.911 98.2665 137.028 97.9006 136.107 97.9006C135.186 97.9006 134.302 98.2665 133.651 98.9179C132.999 99.5693 132.634 100.453 132.634 101.374ZM146.527 101.374C146.527 102.295 146.893 103.178 147.544 103.83C148.195 104.481 149.079 104.847 150 104.847C150.921 104.847 151.805 104.481 152.456 103.83C153.107 103.178 153.473 102.295 153.473 101.374C153.473 100.453 153.107 99.5693 152.456 98.9179C151.805 98.2665 150.921 97.9006 150 97.9006C149.079 97.9006 148.195 98.2665 147.544 98.9179C146.893 99.5693 146.527 100.453 146.527 101.374ZM174.313 101.374C174.313 102.295 174.679 103.178 175.33 103.83C175.982 104.481 176.865 104.847 177.786 104.847C178.708 104.847 179.591 104.481 180.242 103.83C180.894 103.178 181.26 102.295 181.26 101.374C181.26 100.453 180.894 99.5693 180.242 98.9179C179.591 98.2665 178.708 97.9006 177.786 97.9006C176.865 97.9006 175.982 98.2665 175.33 98.9179C174.679 99.5693 174.313 100.453 174.313 101.374ZM202.099 101.374C202.099 102.295 202.465 103.178 203.117 103.83C203.768 104.481 204.652 104.847 205.573 104.847C206.494 104.847 207.377 104.481 208.029 103.83C208.68 103.178 209.046 102.295 209.046 101.374C209.046 100.453 208.68 99.5693 208.029 98.9179C207.377 98.2665 206.494 97.9006 205.573 97.9006C204.652 97.9006 203.768 98.2665 203.117 98.9179C202.465 99.5693 202.099 100.453 202.099 101.374ZM215.993 101.374C215.993 102.295 216.359 103.178 217.01 103.83C217.661 104.481 218.545 104.847 219.466 104.847C220.387 104.847 221.271 104.481 221.922 103.83C222.573 103.178 222.939 102.295 222.939 101.374C222.939 100.453 222.573 99.5693 221.922 98.9179C221.271 98.2665 220.387 97.9006 219.466 97.9006C218.545 97.9006 217.661 98.2665 217.01 98.9179C216.359 99.5693 215.993 100.453 215.993 101.374ZM222.939 101.374C222.939 102.295 223.305 103.178 223.957 103.83C224.608 104.481 225.491 104.847 226.413 104.847C227.334 104.847 228.217 104.481 228.868 103.83C229.52 103.178 229.886 102.295 229.886 101.374C229.886 100.453 229.52 99.5693 228.868 98.9179C228.217 98.2665 227.334 97.9006 226.413 97.9006C225.491 97.9006 224.608 98.2665 223.957 98.9179C223.305 99.5693 222.939 100.453 222.939 101.374ZM229.886 101.374C229.886 102.295 230.252 103.178 230.903 103.83C231.554 104.481 232.438 104.847 233.359 104.847C234.28 104.847 235.164 104.481 235.815 103.83C236.466 103.178 236.832 102.295 236.832 101.374C236.832 100.453 236.466 99.5693 235.815 98.9179C235.164 98.2665 234.28 97.9006 233.359 97.9006C232.438 97.9006 231.554 98.2665 230.903 98.9179C230.252 99.5693 229.886 100.453 229.886 101.374ZM250.726 101.374C250.726 102.295 251.091 103.178 251.743 103.83C252.394 104.481 253.278 104.847 254.199 104.847C255.12 104.847 256.003 104.481 256.655 103.83C257.306 103.178 257.672 102.295 257.672 101.374C257.672 100.453 257.306 99.5693 256.655 98.9179C256.003 98.2665 255.12 97.9006 254.199 97.9006C253.278 97.9006 252.394 98.2665 251.743 98.9179C251.091 99.5693 250.726 100.453 250.726 101.374ZM257.672 101.374C257.672 102.295 258.038 103.178 258.689 103.83C259.341 104.481 260.224 104.847 261.145 104.847C262.067 104.847 262.95 104.481 263.601 103.83C264.253 103.178 264.619 102.295 264.619 101.374C264.619 100.453 264.253 99.5693 263.601 98.9179C262.95 98.2665 262.067 97.9006 261.145 97.9006C260.224 97.9006 259.341 98.2665 258.689 98.9179C258.038 99.5693 257.672 100.453 257.672 101.374ZM271.565 101.374C271.565 102.295 271.931 103.178 272.583 103.83C273.234 104.481 274.117 104.847 275.039 104.847C275.96 104.847 276.843 104.481 277.495 103.83C278.146 103.178 278.512 102.295 278.512 101.374C278.512 100.453 278.146 99.5693 277.495 98.9179C276.843 98.2665 275.96 97.9006 275.039 97.9006C274.117 97.9006 273.234 98.2665 272.583 98.9179C271.931 99.5693 271.565 100.453 271.565 101.374ZM285.458 101.374C285.458 102.295 285.824 103.178 286.476 103.83C287.127 104.481 288.011 104.847 288.932 104.847C289.853 104.847 290.736 104.481 291.388 103.83C292.039 103.178 292.405 102.295 292.405 101.374C292.405 100.453 292.039 99.5693 291.388 98.9179C290.736 98.2665 289.853 97.9006 288.932 97.9006C288.011 97.9006 287.127 98.2665 286.476 98.9179C285.824 99.5693 285.458 100.453 285.458 101.374ZM7.59497 108.32C7.59497 109.242 7.96091 110.125 8.61227 110.776C9.26364 111.428 10.1471 111.794 11.0683 111.794C11.9894 111.794 12.8729 111.428 13.5243 110.776C14.1756 110.125 14.5416 109.242 14.5416 108.32C14.5416 107.399 14.1756 106.516 13.5243 105.864C12.8729 105.213 11.9894 104.847 11.0683 104.847C10.1471 104.847 9.26364 105.213 8.61227 105.864C7.96091 106.516 7.59497 107.399 7.59497 108.32ZM42.3279 108.32C42.3279 108.777 42.4177 109.228 42.5923 109.65C42.7668 110.071 43.0227 110.454 43.3452 110.776C43.6677 111.099 44.0506 111.355 44.472 111.529C44.8934 111.704 45.3451 111.794 45.8012 111.794C46.2573 111.794 46.709 111.704 47.1304 111.529C47.5518 111.355 47.9347 111.099 48.2572 110.776C48.5797 110.454 48.8356 110.071 49.0101 109.65C49.1847 109.228 49.2745 108.777 49.2745 108.32C49.2745 107.864 49.1847 107.413 49.0101 106.991C48.8356 106.57 48.5797 106.187 48.2572 105.864C47.9347 105.542 47.5518 105.286 47.1304 105.112C46.709 104.937 46.2573 104.847 45.8012 104.847C45.3451 104.847 44.8934 104.937 44.472 105.112C44.0506 105.286 43.6677 105.542 43.3452 105.864C43.0227 106.187 42.7668 106.57 42.5923 106.991C42.4177 107.413 42.3279 107.864 42.3279 108.32ZM49.2745 108.32C49.2745 108.777 49.3643 109.228 49.5389 109.65C49.7134 110.071 49.9693 110.454 50.2918 110.776C50.6143 111.099 50.9972 111.355 51.4186 111.529C51.84 111.704 52.2917 111.794 52.7478 111.794C53.2039 111.794 53.6556 111.704 54.077 111.529C54.4984 111.355 54.8813 111.099 55.2038 110.776C55.5263 110.454 55.7821 110.071 55.9567 109.65C56.1312 109.228 56.2211 108.777 56.2211 108.32C56.2211 107.864 56.1312 107.413 55.9567 106.991C55.7821 106.57 55.5263 106.187 55.2038 105.864C54.8813 105.542 54.4984 105.286 54.077 105.112C53.6556 104.937 53.2039 104.847 52.7478 104.847C52.2917 104.847 51.84 104.937 51.4186 105.112C50.9972 105.286 50.6143 105.542 50.2918 105.864C49.9693 106.187 49.7134 106.57 49.5389 106.991C49.3643 107.413 49.2745 107.864 49.2745 108.32ZM56.2211 108.32C56.2211 109.242 56.587 110.125 57.2384 110.776C57.8898 111.428 58.7732 111.794 59.6944 111.794C60.6156 111.794 61.499 111.428 62.1504 110.776C62.8017 110.125 63.1677 109.242 63.1677 108.32C63.1677 107.399 62.8017 106.516 62.1504 105.864C61.499 105.213 60.6156 104.847 59.6944 104.847C58.7732 104.847 57.8898 105.213 57.2384 105.864C56.587 106.516 56.2211 107.399 56.2211 108.32ZM77.0609 108.32C77.0609 108.777 77.1507 109.228 77.3252 109.65C77.4998 110.071 77.7556 110.454 78.0782 110.776C78.4007 111.099 78.7836 111.355 79.205 111.529C79.6264 111.704 80.078 111.794 80.5341 111.794C80.9903 111.794 81.4419 111.704 81.8633 111.529C82.2847 111.355 82.6676 111.099 82.9901 110.776C83.3127 110.454 83.5685 110.071 83.743 109.65C83.9176 109.228 84.0074 108.777 84.0074 108.32C84.0074 107.864 83.9176 107.413 83.743 106.991C83.5685 106.57 83.3127 106.187 82.9901 105.864C82.6676 105.542 82.2847 105.286 81.8633 105.112C81.4419 104.937 80.9903 104.847 80.5341 104.847C80.078 104.847 79.6264 104.937 79.205 105.112C78.7836 105.286 78.4007 105.542 78.0782 105.864C77.7556 106.187 77.4998 106.57 77.3252 106.991C77.1507 107.413 77.0609 107.864 77.0609 108.32ZM84.0074 108.32C84.0074 109.242 84.3734 110.125 85.0247 110.776C85.6761 111.428 86.5596 111.794 87.4807 111.794C88.4019 111.794 89.2854 111.428 89.9367 110.776C90.5881 110.125 90.954 109.242 90.954 108.32C90.954 107.399 90.5881 106.516 89.9367 105.864C89.2854 105.213 88.4019 104.847 87.4807 104.847C86.5596 104.847 85.6761 105.213 85.0247 105.864C84.3734 106.516 84.0074 107.399 84.0074 108.32ZM97.9006 108.32C97.9006 108.777 97.9905 109.228 98.165 109.65C98.3396 110.071 98.5954 110.454 98.9179 110.776C99.2404 111.099 99.6233 111.355 100.045 111.529C100.466 111.704 100.918 111.794 101.374 111.794C101.83 111.794 102.282 111.704 102.703 111.529C103.124 111.355 103.507 111.099 103.83 110.776C104.152 110.454 104.408 110.071 104.583 109.65C104.757 109.228 104.847 108.777 104.847 108.32C104.847 107.864 104.757 107.413 104.583 106.991C104.408 106.57 104.152 106.187 103.83 105.864C103.507 105.542 103.124 105.286 102.703 105.112C102.282 104.937 101.83 104.847 101.374 104.847C100.918 104.847 100.466 104.937 100.045 105.112C99.6233 105.286 99.2404 105.542 98.9179 105.864C98.5954 106.187 98.3396 106.57 98.165 106.991C97.9905 107.413 97.9006 107.864 97.9006 108.32ZM111.794 108.32C111.794 109.242 112.16 110.125 112.811 110.776C113.462 111.428 114.346 111.794 115.267 111.794C116.188 111.794 117.072 111.428 117.723 110.776C118.374 110.125 118.74 109.242 118.74 108.32C118.74 107.399 118.374 106.516 117.723 105.864C117.072 105.213 116.188 104.847 115.267 104.847C114.346 104.847 113.462 105.213 112.811 105.864C112.16 106.516 111.794 107.399 111.794 108.32ZM118.74 108.32C118.74 109.242 119.106 110.125 119.758 110.776C120.409 111.428 121.292 111.794 122.214 111.794C123.135 111.794 124.018 111.428 124.67 110.776C125.321 110.125 125.687 109.242 125.687 108.32C125.687 107.399 125.321 106.516 124.67 105.864C124.018 105.213 123.135 104.847 122.214 104.847C121.292 104.847 120.409 105.213 119.758 105.864C119.106 106.516 118.74 107.399 118.74 108.32ZM125.687 108.32C125.687 109.242 126.053 110.125 126.704 110.776C127.356 111.428 128.239 111.794 129.16 111.794C130.081 111.794 130.965 111.428 131.616 110.776C132.268 110.125 132.634 109.242 132.634 108.32C132.634 107.399 132.268 106.516 131.616 105.864C130.965 105.213 130.081 104.847 129.16 104.847C128.239 104.847 127.356 105.213 126.704 105.864C126.053 106.516 125.687 107.399 125.687 108.32ZM132.634 108.32C132.634 109.242 132.999 110.125 133.651 110.776C134.302 111.428 135.186 111.794 136.107 111.794C137.028 111.794 137.911 111.428 138.563 110.776C139.214 110.125 139.58 109.242 139.58 108.32C139.58 107.399 139.214 106.516 138.563 105.864C137.911 105.213 137.028 104.847 136.107 104.847C135.186 104.847 134.302 105.213 133.651 105.864C132.999 106.516 132.634 107.399 132.634 108.32ZM139.58 108.32C139.58 109.242 139.946 110.125 140.597 110.776C141.249 111.428 142.132 111.794 143.053 111.794C143.975 111.794 144.858 111.428 145.509 110.776C146.161 110.125 146.527 109.242 146.527 108.32C146.527 107.399 146.161 106.516 145.509 105.864C144.858 105.213 143.975 104.847 143.053 104.847C142.132 104.847 141.249 105.213 140.597 105.864C139.946 106.516 139.58 107.399 139.58 108.32ZM146.527 108.32C146.527 109.242 146.893 110.125 147.544 110.776C148.195 111.428 149.079 111.794 150 111.794C150.921 111.794 151.805 111.428 152.456 110.776C153.107 110.125 153.473 109.242 153.473 108.32C153.473 107.399 153.107 106.516 152.456 105.864C151.805 105.213 150.921 104.847 150 104.847C149.079 104.847 148.195 105.213 147.544 105.864C146.893 106.516 146.527 107.399 146.527 108.32ZM153.473 108.32C153.473 108.777 153.563 109.228 153.738 109.65C153.912 110.071 154.168 110.454 154.491 110.776C154.813 111.099 155.196 111.355 155.617 111.529C156.039 111.704 156.491 111.794 156.947 111.794C157.403 111.794 157.854 111.704 158.276 111.529C158.697 111.355 159.08 111.099 159.403 110.776C159.725 110.454 159.981 110.071 160.156 109.65C160.33 109.228 160.42 108.777 160.42 108.32C160.42 107.864 160.33 107.413 160.156 106.991C159.981 106.57 159.725 106.187 159.403 105.864C159.08 105.542 158.697 105.286 158.276 105.112C157.854 104.937 157.403 104.847 156.947 104.847C156.491 104.847 156.039 104.937 155.617 105.112C155.196 105.286 154.813 105.542 154.491 105.864C154.168 106.187 153.912 106.57 153.738 106.991C153.563 107.413 153.473 107.864 153.473 108.32ZM160.42 108.32C160.42 109.242 160.786 110.125 161.437 110.776C162.089 111.428 162.972 111.794 163.893 111.794C164.814 111.794 165.698 111.428 166.349 110.776C167.001 110.125 167.366 109.242 167.366 108.32C167.366 107.399 167.001 106.516 166.349 105.864C165.698 105.213 164.814 104.847 163.893 104.847C162.972 104.847 162.089 105.213 161.437 105.864C160.786 106.516 160.42 107.399 160.42 108.32ZM167.366 108.32C167.366 109.242 167.732 110.125 168.384 110.776C169.035 111.428 169.919 111.794 170.84 111.794C171.761 111.794 172.644 111.428 173.296 110.776C173.947 110.125 174.313 109.242 174.313 108.32C174.313 107.399 173.947 106.516 173.296 105.864C172.644 105.213 171.761 104.847 170.84 104.847C169.919 104.847 169.035 105.213 168.384 105.864C167.732 106.516 167.366 107.399 167.366 108.32ZM174.313 108.32C174.313 109.242 174.679 110.125 175.33 110.776C175.982 111.428 176.865 111.794 177.786 111.794C178.708 111.794 179.591 111.428 180.242 110.776C180.894 110.125 181.26 109.242 181.26 108.32C181.26 107.399 180.894 106.516 180.242 105.864C179.591 105.213 178.708 104.847 177.786 104.847C176.865 104.847 175.982 105.213 175.33 105.864C174.679 106.516 174.313 107.399 174.313 108.32ZM202.099 108.32C202.099 109.242 202.465 110.125 203.117 110.776C203.768 111.428 204.652 111.794 205.573 111.794C206.494 111.794 207.377 111.428 208.029 110.776C208.68 110.125 209.046 109.242 209.046 108.32C209.046 107.399 208.68 106.516 208.029 105.864C207.377 105.213 206.494 104.847 205.573 104.847C204.652 104.847 203.768 105.213 203.117 105.864C202.465 106.516 202.099 107.399 202.099 108.32ZM209.046 108.32C209.046 109.242 209.412 110.125 210.063 110.776C210.715 111.428 211.598 111.794 212.519 111.794C213.44 111.794 214.324 111.428 214.975 110.776C215.627 110.125 215.993 109.242 215.993 108.32C215.993 107.399 215.627 106.516 214.975 105.864C214.324 105.213 213.44 104.847 212.519 104.847C211.598 104.847 210.715 105.213 210.063 105.864C209.412 106.516 209.046 107.399 209.046 108.32ZM229.886 108.32C229.886 109.242 230.252 110.125 230.903 110.776C231.554 111.428 232.438 111.794 233.359 111.794C234.28 111.794 235.164 111.428 235.815 110.776C236.466 110.125 236.832 109.242 236.832 108.32C236.832 107.399 236.466 106.516 235.815 105.864C235.164 105.213 234.28 104.847 233.359 104.847C232.438 104.847 231.554 105.213 230.903 105.864C230.252 106.516 229.886 107.399 229.886 108.32ZM236.832 108.32C236.832 109.242 237.198 110.125 237.85 110.776C238.501 111.428 239.384 111.794 240.306 111.794C241.227 111.794 242.11 111.428 242.762 110.776C243.413 110.125 243.779 109.242 243.779 108.32C243.779 107.399 243.413 106.516 242.762 105.864C242.11 105.213 241.227 104.847 240.306 104.847C239.384 104.847 238.501 105.213 237.85 105.864C237.198 106.516 236.832 107.399 236.832 108.32ZM243.779 108.32C243.779 109.242 244.145 110.125 244.796 110.776C245.448 111.428 246.331 111.794 247.252 111.794C248.173 111.794 249.057 111.428 249.708 110.776C250.36 110.125 250.726 109.242 250.726 108.32C250.726 107.399 250.36 106.516 249.708 105.864C249.057 105.213 248.173 104.847 247.252 104.847C246.331 104.847 245.448 105.213 244.796 105.864C244.145 106.516 243.779 107.399 243.779 108.32ZM250.726 108.32C250.726 109.242 251.091 110.125 251.743 110.776C252.394 111.428 253.278 111.794 254.199 111.794C255.12 111.794 256.003 111.428 256.655 110.776C257.306 110.125 257.672 109.242 257.672 108.32C257.672 107.399 257.306 106.516 256.655 105.864C256.003 105.213 255.12 104.847 254.199 104.847C253.278 104.847 252.394 105.213 251.743 105.864C251.091 106.516 250.726 107.399 250.726 108.32ZM264.619 108.32C264.619 109.242 264.985 110.125 265.636 110.776C266.287 111.428 267.171 111.794 268.092 111.794C269.013 111.794 269.897 111.428 270.548 110.776C271.199 110.125 271.565 109.242 271.565 108.32C271.565 107.399 271.199 106.516 270.548 105.864C269.897 105.213 269.013 104.847 268.092 104.847C267.171 104.847 266.287 105.213 265.636 105.864C264.985 106.516 264.619 107.399 264.619 108.32ZM271.565 108.32C271.565 109.242 271.931 110.125 272.583 110.776C273.234 111.428 274.117 111.794 275.039 111.794C275.96 111.794 276.843 111.428 277.495 110.776C278.146 110.125 278.512 109.242 278.512 108.32C278.512 107.399 278.146 106.516 277.495 105.864C276.843 105.213 275.96 104.847 275.039 104.847C274.117 104.847 273.234 105.213 272.583 105.864C271.931 106.516 271.565 107.399 271.565 108.32ZM285.458 108.32C285.458 109.242 285.824 110.125 286.476 110.776C287.127 111.428 288.011 111.794 288.932 111.794C289.853 111.794 290.736 111.428 291.388 110.776C292.039 110.125 292.405 109.242 292.405 108.32C292.405 107.399 292.039 106.516 291.388 105.864C290.736 105.213 289.853 104.847 288.932 104.847C288.011 104.847 287.127 105.213 286.476 105.864C285.824 106.516 285.458 107.399 285.458 108.32ZM7.59497 115.267C7.59497 116.188 7.96091 117.072 8.61227 117.723C9.26364 118.374 10.1471 118.74 11.0683 118.74C11.9894 118.74 12.8729 118.374 13.5243 117.723C14.1756 117.072 14.5416 116.188 14.5416 115.267C14.5416 114.346 14.1756 113.462 13.5243 112.811C12.8729 112.16 11.9894 111.794 11.0683 111.794C10.1471 111.794 9.26364 112.16 8.61227 112.811C7.96091 113.462 7.59497 114.346 7.59497 115.267ZM14.5416 115.267C14.5416 116.188 14.9075 117.072 15.5589 117.723C16.2102 118.374 17.0937 118.74 18.0149 118.74C18.936 118.74 19.8195 118.374 20.4708 117.723C21.1222 117.072 21.4881 116.188 21.4881 115.267C21.4881 114.346 21.1222 113.462 20.4708 112.811C19.8195 112.16 18.936 111.794 18.0149 111.794C17.0937 111.794 16.2102 112.16 15.5589 112.811C14.9075 113.462 14.5416 114.346 14.5416 115.267ZM35.3813 115.267C35.3813 116.188 35.7473 117.072 36.3986 117.723C37.05 118.374 37.9334 118.74 38.8546 118.74C39.7758 118.74 40.6592 118.374 41.3106 117.723C41.962 117.072 42.3279 116.188 42.3279 115.267C42.3279 114.346 41.962 113.462 41.3106 112.811C40.6592 112.16 39.7758 111.794 38.8546 111.794C37.9334 111.794 37.05 112.16 36.3986 112.811C35.7473 113.462 35.3813 114.346 35.3813 115.267ZM42.3279 115.267C42.3279 115.723 42.4177 116.175 42.5923 116.596C42.7668 117.018 43.0227 117.401 43.3452 117.723C43.6677 118.046 44.0506 118.301 44.472 118.476C44.8934 118.651 45.3451 118.74 45.8012 118.74C46.2573 118.74 46.709 118.651 47.1304 118.476C47.5518 118.301 47.9347 118.046 48.2572 117.723C48.5797 117.401 48.8356 117.018 49.0101 116.596C49.1847 116.175 49.2745 115.723 49.2745 115.267C49.2745 114.811 49.1847 114.359 49.0101 113.938C48.8356 113.516 48.5797 113.134 48.2572 112.811C47.9347 112.489 47.5518 112.233 47.1304 112.058C46.709 111.884 46.2573 111.794 45.8012 111.794C45.3451 111.794 44.8934 111.884 44.472 112.058C44.0506 112.233 43.6677 112.489 43.3452 112.811C43.0227 113.134 42.7668 113.516 42.5923 113.938C42.4177 114.359 42.3279 114.811 42.3279 115.267ZM56.2211 115.267C56.2211 116.188 56.587 117.072 57.2384 117.723C57.8898 118.374 58.7732 118.74 59.6944 118.74C60.6156 118.74 61.499 118.374 62.1504 117.723C62.8017 117.072 63.1677 116.188 63.1677 115.267C63.1677 114.346 62.8017 113.462 62.1504 112.811C61.499 112.16 60.6156 111.794 59.6944 111.794C58.7732 111.794 57.8898 112.16 57.2384 112.811C56.587 113.462 56.2211 114.346 56.2211 115.267ZM84.0074 115.267C84.0074 116.188 84.3734 117.072 85.0247 117.723C85.6761 118.374 86.5596 118.74 87.4807 118.74C88.4019 118.74 89.2854 118.374 89.9367 117.723C90.5881 117.072 90.954 116.188 90.954 115.267C90.954 114.346 90.5881 113.462 89.9367 112.811C89.2854 112.16 88.4019 111.794 87.4807 111.794C86.5596 111.794 85.6761 112.16 85.0247 112.811C84.3734 113.462 84.0074 114.346 84.0074 115.267ZM111.794 115.267C111.794 116.188 112.16 117.072 112.811 117.723C113.462 118.374 114.346 118.74 115.267 118.74C116.188 118.74 117.072 118.374 117.723 117.723C118.374 117.072 118.74 116.188 118.74 115.267C118.74 114.346 118.374 113.462 117.723 112.811C117.072 112.16 116.188 111.794 115.267 111.794C114.346 111.794 113.462 112.16 112.811 112.811C112.16 113.462 111.794 114.346 111.794 115.267ZM125.687 115.267C125.687 116.188 126.053 117.072 126.704 117.723C127.356 118.374 128.239 118.74 129.16 118.74C130.081 118.74 130.965 118.374 131.616 117.723C132.268 117.072 132.634 116.188 132.634 115.267C132.634 114.346 132.268 113.462 131.616 112.811C130.965 112.16 130.081 111.794 129.16 111.794C128.239 111.794 127.356 112.16 126.704 112.811C126.053 113.462 125.687 114.346 125.687 115.267ZM132.634 115.267C132.634 116.188 132.999 117.072 133.651 117.723C134.302 118.374 135.186 118.74 136.107 118.74C137.028 118.74 137.911 118.374 138.563 117.723C139.214 117.072 139.58 116.188 139.58 115.267C139.58 114.346 139.214 113.462 138.563 112.811C137.911 112.16 137.028 111.794 136.107 111.794C135.186 111.794 134.302 112.16 133.651 112.811C132.999 113.462 132.634 114.346 132.634 115.267ZM153.473 115.267C153.473 115.723 153.563 116.175 153.738 116.596C153.912 117.018 154.168 117.401 154.491 117.723C154.813 118.046 155.196 118.301 155.617 118.476C156.039 118.651 156.491 118.74 156.947 118.74C157.403 118.74 157.854 118.651 158.276 118.476C158.697 118.301 159.08 118.046 159.403 117.723C159.725 117.401 159.981 117.018 160.156 116.596C160.33 116.175 160.42 115.723 160.42 115.267C160.42 114.811 160.33 114.359 160.156 113.938C159.981 113.516 159.725 113.134 159.403 112.811C159.08 112.489 158.697 112.233 158.276 112.058C157.854 111.884 157.403 111.794 156.947 111.794C156.491 111.794 156.039 111.884 155.617 112.058C155.196 112.233 154.813 112.489 154.491 112.811C154.168 113.134 153.912 113.516 153.738 113.938C153.563 114.359 153.473 114.811 153.473 115.267ZM160.42 115.267C160.42 116.188 160.786 117.072 161.437 117.723C162.089 118.374 162.972 118.74 163.893 118.74C164.814 118.74 165.698 118.374 166.349 117.723C167.001 117.072 167.366 116.188 167.366 115.267C167.366 114.346 167.001 113.462 166.349 112.811C165.698 112.16 164.814 111.794 163.893 111.794C162.972 111.794 162.089 112.16 161.437 112.811C160.786 113.462 160.42 114.346 160.42 115.267ZM181.26 115.267C181.26 116.188 181.626 117.072 182.277 117.723C182.928 118.374 183.812 118.74 184.733 118.74C185.654 118.74 186.538 118.374 187.189 117.723C187.84 117.072 188.206 116.188 188.206 115.267C188.206 114.346 187.84 113.462 187.189 112.811C186.538 112.16 185.654 111.794 184.733 111.794C183.812 111.794 182.928 112.16 182.277 112.811C181.626 113.462 181.26 114.346 181.26 115.267ZM188.206 115.267C188.206 116.188 188.572 117.072 189.224 117.723C189.875 118.374 190.758 118.74 191.68 118.74C192.601 118.74 193.484 118.374 194.136 117.723C194.787 117.072 195.153 116.188 195.153 115.267C195.153 114.346 194.787 113.462 194.136 112.811C193.484 112.16 192.601 111.794 191.68 111.794C190.758 111.794 189.875 112.16 189.224 112.811C188.572 113.462 188.206 114.346 188.206 115.267ZM209.046 115.267C209.046 116.188 209.412 117.072 210.063 117.723C210.715 118.374 211.598 118.74 212.519 118.74C213.44 118.74 214.324 118.374 214.975 117.723C215.627 117.072 215.993 116.188 215.993 115.267C215.993 114.346 215.627 113.462 214.975 112.811C214.324 112.16 213.44 111.794 212.519 111.794C211.598 111.794 210.715 112.16 210.063 112.811C209.412 113.462 209.046 114.346 209.046 115.267ZM215.993 115.267C215.993 116.188 216.359 117.072 217.01 117.723C217.661 118.374 218.545 118.74 219.466 118.74C220.387 118.74 221.271 118.374 221.922 117.723C222.573 117.072 222.939 116.188 222.939 115.267C222.939 114.346 222.573 113.462 221.922 112.811C221.271 112.16 220.387 111.794 219.466 111.794C218.545 111.794 217.661 112.16 217.01 112.811C216.359 113.462 215.993 114.346 215.993 115.267ZM257.672 115.267C257.672 116.188 258.038 117.072 258.689 117.723C259.341 118.374 260.224 118.74 261.145 118.74C262.067 118.74 262.95 118.374 263.601 117.723C264.253 117.072 264.619 116.188 264.619 115.267C264.619 114.346 264.253 113.462 263.601 112.811C262.95 112.16 262.067 111.794 261.145 111.794C260.224 111.794 259.341 112.16 258.689 112.811C258.038 113.462 257.672 114.346 257.672 115.267ZM264.619 115.267C264.619 116.188 264.985 117.072 265.636 117.723C266.287 118.374 267.171 118.74 268.092 118.74C269.013 118.74 269.897 118.374 270.548 117.723C271.199 117.072 271.565 116.188 271.565 115.267C271.565 114.346 271.199 113.462 270.548 112.811C269.897 112.16 269.013 111.794 268.092 111.794C267.171 111.794 266.287 112.16 265.636 112.811C264.985 113.462 264.619 114.346 264.619 115.267ZM278.512 115.267C278.512 116.188 278.878 117.072 279.529 117.723C280.181 118.374 281.064 118.74 281.985 118.74C282.906 118.74 283.79 118.374 284.441 117.723C285.093 117.072 285.458 116.188 285.458 115.267C285.458 114.346 285.093 113.462 284.441 112.811C283.79 112.16 282.906 111.794 281.985 111.794C281.064 111.794 280.181 112.16 279.529 112.811C278.878 113.462 278.512 114.346 278.512 115.267ZM7.59497 122.214C7.59497 123.135 7.96091 124.018 8.61227 124.67C9.26364 125.321 10.1471 125.687 11.0683 125.687C11.9894 125.687 12.8729 125.321 13.5243 124.67C14.1756 124.018 14.5416 123.135 14.5416 122.214C14.5416 121.292 14.1756 120.409 13.5243 119.758C12.8729 119.106 11.9894 118.74 11.0683 118.74C10.1471 118.74 9.26364 119.106 8.61227 119.758C7.96091 120.409 7.59497 121.292 7.59497 122.214ZM14.5416 122.214C14.5416 123.135 14.9075 124.018 15.5589 124.67C16.2102 125.321 17.0937 125.687 18.0149 125.687C18.936 125.687 19.8195 125.321 20.4708 124.67C21.1222 124.018 21.4881 123.135 21.4881 122.214C21.4881 121.292 21.1222 120.409 20.4708 119.758C19.8195 119.106 18.936 118.74 18.0149 118.74C17.0937 118.74 16.2102 119.106 15.5589 119.758C14.9075 120.409 14.5416 121.292 14.5416 122.214ZM28.4347 122.214C28.4347 123.135 28.8007 124.018 29.452 124.67C30.1034 125.321 30.9869 125.687 31.908 125.687C32.8292 125.687 33.7126 125.321 34.364 124.67C35.0154 124.018 35.3813 123.135 35.3813 122.214C35.3813 121.292 35.0154 120.409 34.364 119.758C33.7126 119.106 32.8292 118.74 31.908 118.74C30.9869 118.74 30.1034 119.106 29.452 119.758C28.8007 120.409 28.4347 121.292 28.4347 122.214ZM42.3279 122.214C42.3279 122.67 42.4177 123.121 42.5923 123.543C42.7668 123.964 43.0227 124.347 43.3452 124.67C43.6677 124.992 44.0506 125.248 44.472 125.423C44.8934 125.597 45.3451 125.687 45.8012 125.687C46.2573 125.687 46.709 125.597 47.1304 125.423C47.5518 125.248 47.9347 124.992 48.2572 124.67C48.5797 124.347 48.8356 123.964 49.0101 123.543C49.1847 123.121 49.2745 122.67 49.2745 122.214C49.2745 121.758 49.1847 121.306 49.0101 120.884C48.8356 120.463 48.5797 120.08 48.2572 119.758C47.9347 119.435 47.5518 119.179 47.1304 119.005C46.709 118.83 46.2573 118.74 45.8012 118.74C45.3451 118.74 44.8934 118.83 44.472 119.005C44.0506 119.179 43.6677 119.435 43.3452 119.758C43.0227 120.08 42.7668 120.463 42.5923 120.884C42.4177 121.306 42.3279 121.758 42.3279 122.214ZM49.2745 122.214C49.2745 122.67 49.3643 123.121 49.5389 123.543C49.7134 123.964 49.9693 124.347 50.2918 124.67C50.6143 124.992 50.9972 125.248 51.4186 125.423C51.84 125.597 52.2917 125.687 52.7478 125.687C53.2039 125.687 53.6556 125.597 54.077 125.423C54.4984 125.248 54.8813 124.992 55.2038 124.67C55.5263 124.347 55.7821 123.964 55.9567 123.543C56.1312 123.121 56.2211 122.67 56.2211 122.214C56.2211 121.758 56.1312 121.306 55.9567 120.884C55.7821 120.463 55.5263 120.08 55.2038 119.758C54.8813 119.435 54.4984 119.179 54.077 119.005C53.6556 118.83 53.2039 118.74 52.7478 118.74C52.2917 118.74 51.84 118.83 51.4186 119.005C50.9972 119.179 50.6143 119.435 50.2918 119.758C49.9693 120.08 49.7134 120.463 49.5389 120.884C49.3643 121.306 49.2745 121.758 49.2745 122.214ZM56.2211 122.214C56.2211 123.135 56.587 124.018 57.2384 124.67C57.8898 125.321 58.7732 125.687 59.6944 125.687C60.6156 125.687 61.499 125.321 62.1504 124.67C62.8017 124.018 63.1677 123.135 63.1677 122.214C63.1677 121.292 62.8017 120.409 62.1504 119.758C61.499 119.106 60.6156 118.74 59.6944 118.74C58.7732 118.74 57.8898 119.106 57.2384 119.758C56.587 120.409 56.2211 121.292 56.2211 122.214ZM63.1677 122.214C63.1677 123.135 63.5336 124.018 64.185 124.67C64.8363 125.321 65.7198 125.687 66.641 125.687C67.5621 125.687 68.4456 125.321 69.097 124.67C69.7483 124.018 70.1143 123.135 70.1143 122.214C70.1143 121.292 69.7483 120.409 69.097 119.758C68.4456 119.106 67.5621 118.74 66.641 118.74C65.7198 118.74 64.8363 119.106 64.185 119.758C63.5336 120.409 63.1677 121.292 63.1677 122.214ZM70.1143 122.214C70.1143 123.135 70.4802 124.018 71.1316 124.67C71.7829 125.321 72.6664 125.687 73.5876 125.687C74.5087 125.687 75.3922 125.321 76.0436 124.67C76.6949 124.018 77.0609 123.135 77.0609 122.214C77.0609 121.292 76.6949 120.409 76.0436 119.758C75.3922 119.106 74.5087 118.74 73.5876 118.74C72.6664 118.74 71.7829 119.106 71.1316 119.758C70.4802 120.409 70.1143 121.292 70.1143 122.214ZM77.0609 122.214C77.0609 122.67 77.1507 123.121 77.3252 123.543C77.4998 123.964 77.7556 124.347 78.0782 124.67C78.4007 124.992 78.7836 125.248 79.205 125.423C79.6264 125.597 80.078 125.687 80.5341 125.687C80.9903 125.687 81.4419 125.597 81.8633 125.423C82.2847 125.248 82.6676 124.992 82.9901 124.67C83.3127 124.347 83.5685 123.964 83.743 123.543C83.9176 123.121 84.0074 122.67 84.0074 122.214C84.0074 121.758 83.9176 121.306 83.743 120.884C83.5685 120.463 83.3127 120.08 82.9901 119.758C82.6676 119.435 82.2847 119.179 81.8633 119.005C81.4419 118.83 80.9903 118.74 80.5341 118.74C80.078 118.74 79.6264 118.83 79.205 119.005C78.7836 119.179 78.4007 119.435 78.0782 119.758C77.7556 120.08 77.4998 120.463 77.3252 120.884C77.1507 121.306 77.0609 121.758 77.0609 122.214ZM84.0074 122.214C84.0074 123.135 84.3734 124.018 85.0247 124.67C85.6761 125.321 86.5596 125.687 87.4807 125.687C88.4019 125.687 89.2854 125.321 89.9367 124.67C90.5881 124.018 90.954 123.135 90.954 122.214C90.954 121.292 90.5881 120.409 89.9367 119.758C89.2854 119.106 88.4019 118.74 87.4807 118.74C86.5596 118.74 85.6761 119.106 85.0247 119.758C84.3734 120.409 84.0074 121.292 84.0074 122.214ZM97.9006 122.214C97.9006 122.67 97.9905 123.121 98.165 123.543C98.3396 123.964 98.5954 124.347 98.9179 124.67C99.2404 124.992 99.6233 125.248 100.045 125.423C100.466 125.597 100.918 125.687 101.374 125.687C101.83 125.687 102.282 125.597 102.703 125.423C103.124 125.248 103.507 124.992 103.83 124.67C104.152 124.347 104.408 123.964 104.583 123.543C104.757 123.121 104.847 122.67 104.847 122.214C104.847 121.758 104.757 121.306 104.583 120.884C104.408 120.463 104.152 120.08 103.83 119.758C103.507 119.435 103.124 119.179 102.703 119.005C102.282 118.83 101.83 118.74 101.374 118.74C100.918 118.74 100.466 118.83 100.045 119.005C99.6233 119.179 99.2404 119.435 98.9179 119.758C98.5954 120.08 98.3396 120.463 98.165 120.884C97.9905 121.306 97.9006 121.758 97.9006 122.214ZM111.794 122.214C111.794 123.135 112.16 124.018 112.811 124.67C113.462 125.321 114.346 125.687 115.267 125.687C116.188 125.687 117.072 125.321 117.723 124.67C118.374 124.018 118.74 123.135 118.74 122.214C118.74 121.292 118.374 120.409 117.723 119.758C117.072 119.106 116.188 118.74 115.267 118.74C114.346 118.74 113.462 119.106 112.811 119.758C112.16 120.409 111.794 121.292 111.794 122.214ZM125.687 122.214C125.687 123.135 126.053 124.018 126.704 124.67C127.356 125.321 128.239 125.687 129.16 125.687C130.081 125.687 130.965 125.321 131.616 124.67C132.268 124.018 132.634 123.135 132.634 122.214C132.634 121.292 132.268 120.409 131.616 119.758C130.965 119.106 130.081 118.74 129.16 118.74C128.239 118.74 127.356 119.106 126.704 119.758C126.053 120.409 125.687 121.292 125.687 122.214ZM146.527 122.214C146.527 123.135 146.893 124.018 147.544 124.67C148.195 125.321 149.079 125.687 150 125.687C150.921 125.687 151.805 125.321 152.456 124.67C153.107 124.018 153.473 123.135 153.473 122.214C153.473 121.292 153.107 120.409 152.456 119.758C151.805 119.106 150.921 118.74 150 118.74C149.079 118.74 148.195 119.106 147.544 119.758C146.893 120.409 146.527 121.292 146.527 122.214ZM153.473 122.214C153.473 122.67 153.563 123.121 153.738 123.543C153.912 123.964 154.168 124.347 154.491 124.67C154.813 124.992 155.196 125.248 155.617 125.423C156.039 125.597 156.491 125.687 156.947 125.687C157.403 125.687 157.854 125.597 158.276 125.423C158.697 125.248 159.08 124.992 159.403 124.67C159.725 124.347 159.981 123.964 160.156 123.543C160.33 123.121 160.42 122.67 160.42 122.214C160.42 121.758 160.33 121.306 160.156 120.884C159.981 120.463 159.725 120.08 159.403 119.758C159.08 119.435 158.697 119.179 158.276 119.005C157.854 118.83 157.403 118.74 156.947 118.74C156.491 118.74 156.039 118.83 155.617 119.005C155.196 119.179 154.813 119.435 154.491 119.758C154.168 120.08 153.912 120.463 153.738 120.884C153.563 121.306 153.473 121.758 153.473 122.214ZM160.42 122.214C160.42 123.135 160.786 124.018 161.437 124.67C162.089 125.321 162.972 125.687 163.893 125.687C164.814 125.687 165.698 125.321 166.349 124.67C167.001 124.018 167.366 123.135 167.366 122.214C167.366 121.292 167.001 120.409 166.349 119.758C165.698 119.106 164.814 118.74 163.893 118.74C162.972 118.74 162.089 119.106 161.437 119.758C160.786 120.409 160.42 121.292 160.42 122.214ZM188.206 122.214C188.206 123.135 188.572 124.018 189.224 124.67C189.875 125.321 190.758 125.687 191.68 125.687C192.601 125.687 193.484 125.321 194.136 124.67C194.787 124.018 195.153 123.135 195.153 122.214C195.153 121.292 194.787 120.409 194.136 119.758C193.484 119.106 192.601 118.74 191.68 118.74C190.758 118.74 189.875 119.106 189.224 119.758C188.572 120.409 188.206 121.292 188.206 122.214ZM195.153 122.214C195.153 122.67 195.243 123.121 195.417 123.543C195.592 123.964 195.848 124.347 196.17 124.67C196.493 124.992 196.876 125.248 197.297 125.423C197.718 125.597 198.17 125.687 198.626 125.687C199.082 125.687 199.534 125.597 199.955 125.423C200.377 125.248 200.76 124.992 201.082 124.67C201.405 124.347 201.661 123.964 201.835 123.543C202.01 123.121 202.099 122.67 202.099 122.214C202.099 121.758 202.01 121.306 201.835 120.884C201.661 120.463 201.405 120.08 201.082 119.758C200.76 119.435 200.377 119.179 199.955 119.005C199.534 118.83 199.082 118.74 198.626 118.74C198.17 118.74 197.718 118.83 197.297 119.005C196.876 119.179 196.493 119.435 196.17 119.758C195.848 120.08 195.592 120.463 195.417 120.884C195.243 121.306 195.153 121.758 195.153 122.214ZM209.046 122.214C209.046 123.135 209.412 124.018 210.063 124.67C210.715 125.321 211.598 125.687 212.519 125.687C213.44 125.687 214.324 125.321 214.975 124.67C215.627 124.018 215.993 123.135 215.993 122.214C215.993 121.292 215.627 120.409 214.975 119.758C214.324 119.106 213.44 118.74 212.519 118.74C211.598 118.74 210.715 119.106 210.063 119.758C209.412 120.409 209.046 121.292 209.046 122.214ZM222.939 122.214C222.939 123.135 223.305 124.018 223.957 124.67C224.608 125.321 225.491 125.687 226.413 125.687C227.334 125.687 228.217 125.321 228.868 124.67C229.52 124.018 229.886 123.135 229.886 122.214C229.886 121.292 229.52 120.409 228.868 119.758C228.217 119.106 227.334 118.74 226.413 118.74C225.491 118.74 224.608 119.106 223.957 119.758C223.305 120.409 222.939 121.292 222.939 122.214ZM229.886 122.214C229.886 123.135 230.252 124.018 230.903 124.67C231.554 125.321 232.438 125.687 233.359 125.687C234.28 125.687 235.164 125.321 235.815 124.67C236.466 124.018 236.832 123.135 236.832 122.214C236.832 121.292 236.466 120.409 235.815 119.758C235.164 119.106 234.28 118.74 233.359 118.74C232.438 118.74 231.554 119.106 230.903 119.758C230.252 120.409 229.886 121.292 229.886 122.214ZM250.726 122.214C250.726 123.135 251.091 124.018 251.743 124.67C252.394 125.321 253.278 125.687 254.199 125.687C255.12 125.687 256.003 125.321 256.655 124.67C257.306 124.018 257.672 123.135 257.672 122.214C257.672 121.292 257.306 120.409 256.655 119.758C256.003 119.106 255.12 118.74 254.199 118.74C253.278 118.74 252.394 119.106 251.743 119.758C251.091 120.409 250.726 121.292 250.726 122.214ZM264.619 122.214C264.619 123.135 264.985 124.018 265.636 124.67C266.287 125.321 267.171 125.687 268.092 125.687C269.013 125.687 269.897 125.321 270.548 124.67C271.199 124.018 271.565 123.135 271.565 122.214C271.565 121.292 271.199 120.409 270.548 119.758C269.897 119.106 269.013 118.74 268.092 118.74C267.171 118.74 266.287 119.106 265.636 119.758C264.985 120.409 264.619 121.292 264.619 122.214ZM278.512 122.214C278.512 123.135 278.878 124.018 279.529 124.67C280.181 125.321 281.064 125.687 281.985 125.687C282.906 125.687 283.79 125.321 284.441 124.67C285.093 124.018 285.458 123.135 285.458 122.214C285.458 121.292 285.093 120.409 284.441 119.758C283.79 119.106 282.906 118.74 281.985 118.74C281.064 118.74 280.181 119.106 279.529 119.758C278.878 120.409 278.512 121.292 278.512 122.214ZM285.458 122.214C285.458 123.135 285.824 124.018 286.476 124.67C287.127 125.321 288.011 125.687 288.932 125.687C289.853 125.687 290.736 125.321 291.388 124.67C292.039 124.018 292.405 123.135 292.405 122.214C292.405 121.292 292.039 120.409 291.388 119.758C290.736 119.106 289.853 118.74 288.932 118.74C288.011 118.74 287.127 119.106 286.476 119.758C285.824 120.409 285.458 121.292 285.458 122.214ZM7.59497 129.16C7.59497 130.081 7.96091 130.965 8.61227 131.616C9.26364 132.268 10.1471 132.634 11.0683 132.634C11.9894 132.634 12.8729 132.268 13.5243 131.616C14.1756 130.965 14.5416 130.081 14.5416 129.16C14.5416 128.239 14.1756 127.356 13.5243 126.704C12.8729 126.053 11.9894 125.687 11.0683 125.687C10.1471 125.687 9.26364 126.053 8.61227 126.704C7.96091 127.356 7.59497 128.239 7.59497 129.16ZM21.4881 129.16C21.4881 130.081 21.8541 130.965 22.5055 131.616C23.1568 132.268 24.0403 132.634 24.9614 132.634C25.8826 132.634 26.7661 132.268 27.4174 131.616C28.0688 130.965 28.4347 130.081 28.4347 129.16C28.4347 128.239 28.0688 127.356 27.4174 126.704C26.7661 126.053 25.8826 125.687 24.9614 125.687C24.0403 125.687 23.1568 126.053 22.5055 126.704C21.8541 127.356 21.4881 128.239 21.4881 129.16ZM28.4347 129.16C28.4347 130.081 28.8007 130.965 29.452 131.616C30.1034 132.268 30.9869 132.634 31.908 132.634C32.8292 132.634 33.7126 132.268 34.364 131.616C35.0154 130.965 35.3813 130.081 35.3813 129.16C35.3813 128.239 35.0154 127.356 34.364 126.704C33.7126 126.053 32.8292 125.687 31.908 125.687C30.9869 125.687 30.1034 126.053 29.452 126.704C28.8007 127.356 28.4347 128.239 28.4347 129.16ZM35.3813 129.16C35.3813 130.081 35.7473 130.965 36.3986 131.616C37.05 132.268 37.9334 132.634 38.8546 132.634C39.7758 132.634 40.6592 132.268 41.3106 131.616C41.962 130.965 42.3279 130.081 42.3279 129.16C42.3279 128.239 41.962 127.356 41.3106 126.704C40.6592 126.053 39.7758 125.687 38.8546 125.687C37.9334 125.687 37.05 126.053 36.3986 126.704C35.7473 127.356 35.3813 128.239 35.3813 129.16ZM70.1143 129.16C70.1143 130.081 70.4802 130.965 71.1316 131.616C71.7829 132.268 72.6664 132.634 73.5876 132.634C74.5087 132.634 75.3922 132.268 76.0436 131.616C76.6949 130.965 77.0609 130.081 77.0609 129.16C77.0609 128.239 76.6949 127.356 76.0436 126.704C75.3922 126.053 74.5087 125.687 73.5876 125.687C72.6664 125.687 71.7829 126.053 71.1316 126.704C70.4802 127.356 70.1143 128.239 70.1143 129.16ZM84.0074 129.16C84.0074 130.081 84.3734 130.965 85.0247 131.616C85.6761 132.268 86.5596 132.634 87.4807 132.634C88.4019 132.634 89.2854 132.268 89.9367 131.616C90.5881 130.965 90.954 130.081 90.954 129.16C90.954 128.239 90.5881 127.356 89.9367 126.704C89.2854 126.053 88.4019 125.687 87.4807 125.687C86.5596 125.687 85.6761 126.053 85.0247 126.704C84.3734 127.356 84.0074 128.239 84.0074 129.16ZM97.9006 129.16C97.9006 129.616 97.9905 130.068 98.165 130.489C98.3396 130.911 98.5954 131.294 98.9179 131.616C99.2404 131.939 99.6233 132.195 100.045 132.369C100.466 132.544 100.918 132.634 101.374 132.634C101.83 132.634 102.282 132.544 102.703 132.369C103.124 132.195 103.507 131.939 103.83 131.616C104.152 131.294 104.408 130.911 104.583 130.489C104.757 130.068 104.847 129.616 104.847 129.16C104.847 128.704 104.757 128.252 104.583 127.831C104.408 127.41 104.152 127.027 103.83 126.704C103.507 126.382 103.124 126.126 102.703 125.951C102.282 125.777 101.83 125.687 101.374 125.687C100.918 125.687 100.466 125.777 100.045 125.951C99.6233 126.126 99.2404 126.382 98.9179 126.704C98.5954 127.027 98.3396 127.41 98.165 127.831C97.9905 128.252 97.9006 128.704 97.9006 129.16ZM104.847 129.16C104.847 130.081 105.213 130.965 105.865 131.616C106.516 132.268 107.399 132.634 108.321 132.634C109.242 132.634 110.125 132.268 110.776 131.616C111.428 130.965 111.794 130.081 111.794 129.16C111.794 128.239 111.428 127.356 110.776 126.704C110.125 126.053 109.242 125.687 108.321 125.687C107.399 125.687 106.516 126.053 105.865 126.704C105.213 127.356 104.847 128.239 104.847 129.16ZM111.794 129.16C111.794 130.081 112.16 130.965 112.811 131.616C113.462 132.268 114.346 132.634 115.267 132.634C116.188 132.634 117.072 132.268 117.723 131.616C118.374 130.965 118.74 130.081 118.74 129.16C118.74 128.239 118.374 127.356 117.723 126.704C117.072 126.053 116.188 125.687 115.267 125.687C114.346 125.687 113.462 126.053 112.811 126.704C112.16 127.356 111.794 128.239 111.794 129.16ZM118.74 129.16C118.74 130.081 119.106 130.965 119.758 131.616C120.409 132.268 121.292 132.634 122.214 132.634C123.135 132.634 124.018 132.268 124.67 131.616C125.321 130.965 125.687 130.081 125.687 129.16C125.687 128.239 125.321 127.356 124.67 126.704C124.018 126.053 123.135 125.687 122.214 125.687C121.292 125.687 120.409 126.053 119.758 126.704C119.106 127.356 118.74 128.239 118.74 129.16ZM167.366 129.16C167.366 130.081 167.732 130.965 168.384 131.616C169.035 132.268 169.919 132.634 170.84 132.634C171.761 132.634 172.644 132.268 173.296 131.616C173.947 130.965 174.313 130.081 174.313 129.16C174.313 128.239 173.947 127.356 173.296 126.704C172.644 126.053 171.761 125.687 170.84 125.687C169.919 125.687 169.035 126.053 168.384 126.704C167.732 127.356 167.366 128.239 167.366 129.16ZM181.26 129.16C181.26 130.081 181.626 130.965 182.277 131.616C182.928 132.268 183.812 132.634 184.733 132.634C185.654 132.634 186.538 132.268 187.189 131.616C187.84 130.965 188.206 130.081 188.206 129.16C188.206 128.239 187.84 127.356 187.189 126.704C186.538 126.053 185.654 125.687 184.733 125.687C183.812 125.687 182.928 126.053 182.277 126.704C181.626 127.356 181.26 128.239 181.26 129.16ZM195.153 129.16C195.153 129.616 195.243 130.068 195.417 130.489C195.592 130.911 195.848 131.294 196.17 131.616C196.493 131.939 196.876 132.195 197.297 132.369C197.718 132.544 198.17 132.634 198.626 132.634C199.082 132.634 199.534 132.544 199.955 132.369C200.377 132.195 200.76 131.939 201.082 131.616C201.405 131.294 201.661 130.911 201.835 130.489C202.01 130.068 202.099 129.616 202.099 129.16C202.099 128.704 202.01 128.252 201.835 127.831C201.661 127.41 201.405 127.027 201.082 126.704C200.76 126.382 200.377 126.126 199.955 125.951C199.534 125.777 199.082 125.687 198.626 125.687C198.17 125.687 197.718 125.777 197.297 125.951C196.876 126.126 196.493 126.382 196.17 126.704C195.848 127.027 195.592 127.41 195.417 127.831C195.243 128.252 195.153 128.704 195.153 129.16ZM202.099 129.16C202.099 130.081 202.465 130.965 203.117 131.616C203.768 132.268 204.652 132.634 205.573 132.634C206.494 132.634 207.377 132.268 208.029 131.616C208.68 130.965 209.046 130.081 209.046 129.16C209.046 128.239 208.68 127.356 208.029 126.704C207.377 126.053 206.494 125.687 205.573 125.687C204.652 125.687 203.768 126.053 203.117 126.704C202.465 127.356 202.099 128.239 202.099 129.16ZM215.993 129.16C215.993 130.081 216.359 130.965 217.01 131.616C217.661 132.268 218.545 132.634 219.466 132.634C220.387 132.634 221.271 132.268 221.922 131.616C222.573 130.965 222.939 130.081 222.939 129.16C222.939 128.239 222.573 127.356 221.922 126.704C221.271 126.053 220.387 125.687 219.466 125.687C218.545 125.687 217.661 126.053 217.01 126.704C216.359 127.356 215.993 128.239 215.993 129.16ZM229.886 129.16C229.886 130.081 230.252 130.965 230.903 131.616C231.554 132.268 232.438 132.634 233.359 132.634C234.28 132.634 235.164 132.268 235.815 131.616C236.466 130.965 236.832 130.081 236.832 129.16C236.832 128.239 236.466 127.356 235.815 126.704C235.164 126.053 234.28 125.687 233.359 125.687C232.438 125.687 231.554 126.053 230.903 126.704C230.252 127.356 229.886 128.239 229.886 129.16ZM236.832 129.16C236.832 130.081 237.198 130.965 237.85 131.616C238.501 132.268 239.384 132.634 240.306 132.634C241.227 132.634 242.11 132.268 242.762 131.616C243.413 130.965 243.779 130.081 243.779 129.16C243.779 128.239 243.413 127.356 242.762 126.704C242.11 126.053 241.227 125.687 240.306 125.687C239.384 125.687 238.501 126.053 237.85 126.704C237.198 127.356 236.832 128.239 236.832 129.16ZM243.779 129.16C243.779 130.081 244.145 130.965 244.796 131.616C245.448 132.268 246.331 132.634 247.252 132.634C248.173 132.634 249.057 132.268 249.708 131.616C250.36 130.965 250.726 130.081 250.726 129.16C250.726 128.239 250.36 127.356 249.708 126.704C249.057 126.053 248.173 125.687 247.252 125.687C246.331 125.687 245.448 126.053 244.796 126.704C244.145 127.356 243.779 128.239 243.779 129.16ZM250.726 129.16C250.726 130.081 251.091 130.965 251.743 131.616C252.394 132.268 253.278 132.634 254.199 132.634C255.12 132.634 256.003 132.268 256.655 131.616C257.306 130.965 257.672 130.081 257.672 129.16C257.672 128.239 257.306 127.356 256.655 126.704C256.003 126.053 255.12 125.687 254.199 125.687C253.278 125.687 252.394 126.053 251.743 126.704C251.091 127.356 250.726 128.239 250.726 129.16ZM257.672 129.16C257.672 130.081 258.038 130.965 258.689 131.616C259.341 132.268 260.224 132.634 261.145 132.634C262.067 132.634 262.95 132.268 263.601 131.616C264.253 130.965 264.619 130.081 264.619 129.16C264.619 128.239 264.253 127.356 263.601 126.704C262.95 126.053 262.067 125.687 261.145 125.687C260.224 125.687 259.341 126.053 258.689 126.704C258.038 127.356 257.672 128.239 257.672 129.16ZM278.512 129.16C278.512 130.081 278.878 130.965 279.529 131.616C280.181 132.268 281.064 132.634 281.985 132.634C282.906 132.634 283.79 132.268 284.441 131.616C285.093 130.965 285.458 130.081 285.458 129.16C285.458 128.239 285.093 127.356 284.441 126.704C283.79 126.053 282.906 125.687 281.985 125.687C281.064 125.687 280.181 126.053 279.529 126.704C278.878 127.356 278.512 128.239 278.512 129.16ZM285.458 129.16C285.458 130.081 285.824 130.965 286.476 131.616C287.127 132.268 288.011 132.634 288.932 132.634C289.853 132.634 290.736 132.268 291.388 131.616C292.039 130.965 292.405 130.081 292.405 129.16C292.405 128.239 292.039 127.356 291.388 126.704C290.736 126.053 289.853 125.687 288.932 125.687C288.011 125.687 287.127 126.053 286.476 126.704C285.824 127.356 285.458 128.239 285.458 129.16ZM21.4881 136.107C21.4881 137.028 21.8541 137.911 22.5055 138.563C23.1568 139.214 24.0403 139.58 24.9614 139.58C25.8826 139.58 26.7661 139.214 27.4174 138.563C28.0688 137.911 28.4347 137.028 28.4347 136.107C28.4347 135.186 28.0688 134.302 27.4174 133.651C26.7661 132.999 25.8826 132.634 24.9614 132.634C24.0403 132.634 23.1568 132.999 22.5055 133.651C21.8541 134.302 21.4881 135.186 21.4881 136.107ZM42.3279 136.107C42.3279 136.563 42.4177 137.015 42.5923 137.436C42.7668 137.857 43.0227 138.24 43.3452 138.563C43.6677 138.885 44.0506 139.141 44.472 139.316C44.8934 139.49 45.3451 139.58 45.8012 139.58C46.2573 139.58 46.709 139.49 47.1304 139.316C47.5518 139.141 47.9347 138.885 48.2572 138.563C48.5797 138.24 48.8356 137.857 49.0101 137.436C49.1847 137.015 49.2745 136.563 49.2745 136.107C49.2745 135.651 49.1847 135.199 49.0101 134.778C48.8356 134.356 48.5797 133.973 48.2572 133.651C47.9347 133.328 47.5518 133.072 47.1304 132.898C46.709 132.723 46.2573 132.634 45.8012 132.634C45.3451 132.634 44.8934 132.723 44.472 132.898C44.0506 133.072 43.6677 133.328 43.3452 133.651C43.0227 133.973 42.7668 134.356 42.5923 134.778C42.4177 135.199 42.3279 135.651 42.3279 136.107ZM49.2745 136.107C49.2745 136.563 49.3643 137.015 49.5389 137.436C49.7134 137.857 49.9693 138.24 50.2918 138.563C50.6143 138.885 50.9972 139.141 51.4186 139.316C51.84 139.49 52.2917 139.58 52.7478 139.58C53.2039 139.58 53.6556 139.49 54.077 139.316C54.4984 139.141 54.8813 138.885 55.2038 138.563C55.5263 138.24 55.7821 137.857 55.9567 137.436C56.1312 137.015 56.2211 136.563 56.2211 136.107C56.2211 135.651 56.1312 135.199 55.9567 134.778C55.7821 134.356 55.5263 133.973 55.2038 133.651C54.8813 133.328 54.4984 133.072 54.077 132.898C53.6556 132.723 53.2039 132.634 52.7478 132.634C52.2917 132.634 51.84 132.723 51.4186 132.898C50.9972 133.072 50.6143 133.328 50.2918 133.651C49.9693 133.973 49.7134 134.356 49.5389 134.778C49.3643 135.199 49.2745 135.651 49.2745 136.107ZM77.0609 136.107C77.0609 136.563 77.1507 137.015 77.3252 137.436C77.4998 137.857 77.7556 138.24 78.0782 138.563C78.4007 138.885 78.7836 139.141 79.205 139.316C79.6264 139.49 80.078 139.58 80.5341 139.58C80.9903 139.58 81.4419 139.49 81.8633 139.316C82.2847 139.141 82.6676 138.885 82.9901 138.563C83.3127 138.24 83.5685 137.857 83.743 137.436C83.9176 137.015 84.0074 136.563 84.0074 136.107C84.0074 135.651 83.9176 135.199 83.743 134.778C83.5685 134.356 83.3127 133.973 82.9901 133.651C82.6676 133.328 82.2847 133.072 81.8633 132.898C81.4419 132.723 80.9903 132.634 80.5341 132.634C80.078 132.634 79.6264 132.723 79.205 132.898C78.7836 133.072 78.4007 133.328 78.0782 133.651C77.7556 133.973 77.4998 134.356 77.3252 134.778C77.1507 135.199 77.0609 135.651 77.0609 136.107ZM104.847 136.107C104.847 137.028 105.213 137.911 105.865 138.563C106.516 139.214 107.399 139.58 108.321 139.58C109.242 139.58 110.125 139.214 110.776 138.563C111.428 137.911 111.794 137.028 111.794 136.107C111.794 135.186 111.428 134.302 110.776 133.651C110.125 132.999 109.242 132.634 108.321 132.634C107.399 132.634 106.516 132.999 105.865 133.651C105.213 134.302 104.847 135.186 104.847 136.107ZM111.794 136.107C111.794 137.028 112.16 137.911 112.811 138.563C113.462 139.214 114.346 139.58 115.267 139.58C116.188 139.58 117.072 139.214 117.723 138.563C118.374 137.911 118.74 137.028 118.74 136.107C118.74 135.186 118.374 134.302 117.723 133.651C117.072 132.999 116.188 132.634 115.267 132.634C114.346 132.634 113.462 132.999 112.811 133.651C112.16 134.302 111.794 135.186 111.794 136.107ZM125.687 136.107C125.687 137.028 126.053 137.911 126.704 138.563C127.356 139.214 128.239 139.58 129.16 139.58C130.081 139.58 130.965 139.214 131.616 138.563C132.268 137.911 132.634 137.028 132.634 136.107C132.634 135.186 132.268 134.302 131.616 133.651C130.965 132.999 130.081 132.634 129.16 132.634C128.239 132.634 127.356 132.999 126.704 133.651C126.053 134.302 125.687 135.186 125.687 136.107ZM146.527 136.107C146.527 137.028 146.893 137.911 147.544 138.563C148.195 139.214 149.079 139.58 150 139.58C150.921 139.58 151.805 139.214 152.456 138.563C153.107 137.911 153.473 137.028 153.473 136.107C153.473 135.186 153.107 134.302 152.456 133.651C151.805 132.999 150.921 132.634 150 132.634C149.079 132.634 148.195 132.999 147.544 133.651C146.893 134.302 146.527 135.186 146.527 136.107ZM153.473 136.107C153.473 136.563 153.563 137.015 153.738 137.436C153.912 137.857 154.168 138.24 154.491 138.563C154.813 138.885 155.196 139.141 155.617 139.316C156.039 139.49 156.491 139.58 156.947 139.58C157.403 139.58 157.854 139.49 158.276 139.316C158.697 139.141 159.08 138.885 159.403 138.563C159.725 138.24 159.981 137.857 160.156 137.436C160.33 137.015 160.42 136.563 160.42 136.107C160.42 135.651 160.33 135.199 160.156 134.778C159.981 134.356 159.725 133.973 159.403 133.651C159.08 133.328 158.697 133.072 158.276 132.898C157.854 132.723 157.403 132.634 156.947 132.634C156.491 132.634 156.039 132.723 155.617 132.898C155.196 133.072 154.813 133.328 154.491 133.651C154.168 133.973 153.912 134.356 153.738 134.778C153.563 135.199 153.473 135.651 153.473 136.107ZM174.313 136.107C174.313 137.028 174.679 137.911 175.33 138.563C175.982 139.214 176.865 139.58 177.786 139.58C178.708 139.58 179.591 139.214 180.242 138.563C180.894 137.911 181.26 137.028 181.26 136.107C181.26 135.186 180.894 134.302 180.242 133.651C179.591 132.999 178.708 132.634 177.786 132.634C176.865 132.634 175.982 132.999 175.33 133.651C174.679 134.302 174.313 135.186 174.313 136.107ZM181.26 136.107C181.26 137.028 181.626 137.911 182.277 138.563C182.928 139.214 183.812 139.58 184.733 139.58C185.654 139.58 186.538 139.214 187.189 138.563C187.84 137.911 188.206 137.028 188.206 136.107C188.206 135.186 187.84 134.302 187.189 133.651C186.538 132.999 185.654 132.634 184.733 132.634C183.812 132.634 182.928 132.999 182.277 133.651C181.626 134.302 181.26 135.186 181.26 136.107ZM195.153 136.107C195.153 136.563 195.243 137.015 195.417 137.436C195.592 137.857 195.848 138.24 196.17 138.563C196.493 138.885 196.876 139.141 197.297 139.316C197.718 139.49 198.17 139.58 198.626 139.58C199.082 139.58 199.534 139.49 199.955 139.316C200.377 139.141 200.76 138.885 201.082 138.563C201.405 138.24 201.661 137.857 201.835 137.436C202.01 137.015 202.099 136.563 202.099 136.107C202.099 135.651 202.01 135.199 201.835 134.778C201.661 134.356 201.405 133.973 201.082 133.651C200.76 133.328 200.377 133.072 199.955 132.898C199.534 132.723 199.082 132.634 198.626 132.634C198.17 132.634 197.718 132.723 197.297 132.898C196.876 133.072 196.493 133.328 196.17 133.651C195.848 133.973 195.592 134.356 195.417 134.778C195.243 135.199 195.153 135.651 195.153 136.107ZM202.099 136.107C202.099 137.028 202.465 137.911 203.117 138.563C203.768 139.214 204.652 139.58 205.573 139.58C206.494 139.58 207.377 139.214 208.029 138.563C208.68 137.911 209.046 137.028 209.046 136.107C209.046 135.186 208.68 134.302 208.029 133.651C207.377 132.999 206.494 132.634 205.573 132.634C204.652 132.634 203.768 132.999 203.117 133.651C202.465 134.302 202.099 135.186 202.099 136.107ZM209.046 136.107C209.046 137.028 209.412 137.911 210.063 138.563C210.715 139.214 211.598 139.58 212.519 139.58C213.44 139.58 214.324 139.214 214.975 138.563C215.627 137.911 215.993 137.028 215.993 136.107C215.993 135.186 215.627 134.302 214.975 133.651C214.324 132.999 213.44 132.634 212.519 132.634C211.598 132.634 210.715 132.999 210.063 133.651C209.412 134.302 209.046 135.186 209.046 136.107ZM229.886 136.107C229.886 137.028 230.252 137.911 230.903 138.563C231.554 139.214 232.438 139.58 233.359 139.58C234.28 139.58 235.164 139.214 235.815 138.563C236.466 137.911 236.832 137.028 236.832 136.107C236.832 135.186 236.466 134.302 235.815 133.651C235.164 132.999 234.28 132.634 233.359 132.634C232.438 132.634 231.554 132.999 230.903 133.651C230.252 134.302 229.886 135.186 229.886 136.107ZM243.779 136.107C243.779 137.028 244.145 137.911 244.796 138.563C245.448 139.214 246.331 139.58 247.252 139.58C248.173 139.58 249.057 139.214 249.708 138.563C250.36 137.911 250.726 137.028 250.726 136.107C250.726 135.186 250.36 134.302 249.708 133.651C249.057 132.999 248.173 132.634 247.252 132.634C246.331 132.634 245.448 132.999 244.796 133.651C244.145 134.302 243.779 135.186 243.779 136.107ZM250.726 136.107C250.726 137.028 251.091 137.911 251.743 138.563C252.394 139.214 253.278 139.58 254.199 139.58C255.12 139.58 256.003 139.214 256.655 138.563C257.306 137.911 257.672 137.028 257.672 136.107C257.672 135.186 257.306 134.302 256.655 133.651C256.003 132.999 255.12 132.634 254.199 132.634C253.278 132.634 252.394 132.999 251.743 133.651C251.091 134.302 250.726 135.186 250.726 136.107ZM264.619 136.107C264.619 137.028 264.985 137.911 265.636 138.563C266.287 139.214 267.171 139.58 268.092 139.58C269.013 139.58 269.897 139.214 270.548 138.563C271.199 137.911 271.565 137.028 271.565 136.107C271.565 135.186 271.199 134.302 270.548 133.651C269.897 132.999 269.013 132.634 268.092 132.634C267.171 132.634 266.287 132.999 265.636 133.651C264.985 134.302 264.619 135.186 264.619 136.107ZM285.458 136.107C285.458 137.028 285.824 137.911 286.476 138.563C287.127 139.214 288.011 139.58 288.932 139.58C289.853 139.58 290.736 139.214 291.388 138.563C292.039 137.911 292.405 137.028 292.405 136.107C292.405 135.186 292.039 134.302 291.388 133.651C290.736 132.999 289.853 132.634 288.932 132.634C288.011 132.634 287.127 132.999 286.476 133.651C285.824 134.302 285.458 135.186 285.458 136.107ZM14.5416 143.053C14.5416 143.975 14.9075 144.858 15.5589 145.509C16.2102 146.161 17.0937 146.527 18.0149 146.527C18.936 146.527 19.8195 146.161 20.4708 145.509C21.1222 144.858 21.4881 143.975 21.4881 143.053C21.4881 142.132 21.1222 141.249 20.4708 140.597C19.8195 139.946 18.936 139.58 18.0149 139.58C17.0937 139.58 16.2102 139.946 15.5589 140.597C14.9075 141.249 14.5416 142.132 14.5416 143.053ZM42.3279 143.053C42.3279 143.51 42.4177 143.961 42.5923 144.383C42.7668 144.804 43.0227 145.187 43.3452 145.509C43.6677 145.832 44.0506 146.088 44.472 146.262C44.8934 146.437 45.3451 146.527 45.8012 146.527C46.2573 146.527 46.709 146.437 47.1304 146.262C47.5518 146.088 47.9347 145.832 48.2572 145.509C48.5797 145.187 48.8356 144.804 49.0101 144.383C49.1847 143.961 49.2745 143.51 49.2745 143.053C49.2745 142.597 49.1847 142.146 49.0101 141.724C48.8356 141.303 48.5797 140.92 48.2572 140.597C47.9347 140.275 47.5518 140.019 47.1304 139.845C46.709 139.67 46.2573 139.58 45.8012 139.58C45.3451 139.58 44.8934 139.67 44.472 139.845C44.0506 140.019 43.6677 140.275 43.3452 140.597C43.0227 140.92 42.7668 141.303 42.5923 141.724C42.4177 142.146 42.3279 142.597 42.3279 143.053ZM63.1677 143.053C63.1677 143.975 63.5336 144.858 64.185 145.509C64.8363 146.161 65.7198 146.527 66.641 146.527C67.5621 146.527 68.4456 146.161 69.097 145.509C69.7483 144.858 70.1143 143.975 70.1143 143.053C70.1143 142.132 69.7483 141.249 69.097 140.597C68.4456 139.946 67.5621 139.58 66.641 139.58C65.7198 139.58 64.8363 139.946 64.185 140.597C63.5336 141.249 63.1677 142.132 63.1677 143.053ZM70.1143 143.053C70.1143 143.975 70.4802 144.858 71.1316 145.509C71.7829 146.161 72.6664 146.527 73.5876 146.527C74.5087 146.527 75.3922 146.161 76.0436 145.509C76.6949 144.858 77.0609 143.975 77.0609 143.053C77.0609 142.132 76.6949 141.249 76.0436 140.597C75.3922 139.946 74.5087 139.58 73.5876 139.58C72.6664 139.58 71.7829 139.946 71.1316 140.597C70.4802 141.249 70.1143 142.132 70.1143 143.053ZM77.0609 143.053C77.0609 143.51 77.1507 143.961 77.3252 144.383C77.4998 144.804 77.7556 145.187 78.0782 145.509C78.4007 145.832 78.7836 146.088 79.205 146.262C79.6264 146.437 80.078 146.527 80.5341 146.527C80.9903 146.527 81.4419 146.437 81.8633 146.262C82.2847 146.088 82.6676 145.832 82.9901 145.509C83.3127 145.187 83.5685 144.804 83.743 144.383C83.9176 143.961 84.0074 143.51 84.0074 143.053C84.0074 142.597 83.9176 142.146 83.743 141.724C83.5685 141.303 83.3127 140.92 82.9901 140.597C82.6676 140.275 82.2847 140.019 81.8633 139.845C81.4419 139.67 80.9903 139.58 80.5341 139.58C80.078 139.58 79.6264 139.67 79.205 139.845C78.7836 140.019 78.4007 140.275 78.0782 140.597C77.7556 140.92 77.4998 141.303 77.3252 141.724C77.1507 142.146 77.0609 142.597 77.0609 143.053ZM104.847 143.053C104.847 143.975 105.213 144.858 105.865 145.509C106.516 146.161 107.399 146.527 108.321 146.527C109.242 146.527 110.125 146.161 110.776 145.509C111.428 144.858 111.794 143.975 111.794 143.053C111.794 142.132 111.428 141.249 110.776 140.597C110.125 139.946 109.242 139.58 108.321 139.58C107.399 139.58 106.516 139.946 105.865 140.597C105.213 141.249 104.847 142.132 104.847 143.053ZM118.74 143.053C118.74 143.975 119.106 144.858 119.758 145.509C120.409 146.161 121.292 146.527 122.214 146.527C123.135 146.527 124.018 146.161 124.67 145.509C125.321 144.858 125.687 143.975 125.687 143.053C125.687 142.132 125.321 141.249 124.67 140.597C124.018 139.946 123.135 139.58 122.214 139.58C121.292 139.58 120.409 139.946 119.758 140.597C119.106 141.249 118.74 142.132 118.74 143.053ZM132.634 143.053C132.634 143.975 132.999 144.858 133.651 145.509C134.302 146.161 135.186 146.527 136.107 146.527C137.028 146.527 137.911 146.161 138.563 145.509C139.214 144.858 139.58 143.975 139.58 143.053C139.58 142.132 139.214 141.249 138.563 140.597C137.911 139.946 137.028 139.58 136.107 139.58C135.186 139.58 134.302 139.946 133.651 140.597C132.999 141.249 132.634 142.132 132.634 143.053ZM146.527 143.053C146.527 143.975 146.893 144.858 147.544 145.509C148.195 146.161 149.079 146.527 150 146.527C150.921 146.527 151.805 146.161 152.456 145.509C153.107 144.858 153.473 143.975 153.473 143.053C153.473 142.132 153.107 141.249 152.456 140.597C151.805 139.946 150.921 139.58 150 139.58C149.079 139.58 148.195 139.946 147.544 140.597C146.893 141.249 146.527 142.132 146.527 143.053ZM153.473 143.053C153.473 143.51 153.563 143.961 153.738 144.383C153.912 144.804 154.168 145.187 154.491 145.509C154.813 145.832 155.196 146.088 155.617 146.262C156.039 146.437 156.491 146.527 156.947 146.527C157.403 146.527 157.854 146.437 158.276 146.262C158.697 146.088 159.08 145.832 159.403 145.509C159.725 145.187 159.981 144.804 160.156 144.383C160.33 143.961 160.42 143.51 160.42 143.053C160.42 142.597 160.33 142.146 160.156 141.724C159.981 141.303 159.725 140.92 159.403 140.597C159.08 140.275 158.697 140.019 158.276 139.845C157.854 139.67 157.403 139.58 156.947 139.58C156.491 139.58 156.039 139.67 155.617 139.845C155.196 140.019 154.813 140.275 154.491 140.597C154.168 140.92 153.912 141.303 153.738 141.724C153.563 142.146 153.473 142.597 153.473 143.053ZM174.313 143.053C174.313 143.975 174.679 144.858 175.33 145.509C175.982 146.161 176.865 146.527 177.786 146.527C178.708 146.527 179.591 146.161 180.242 145.509C180.894 144.858 181.26 143.975 181.26 143.053C181.26 142.132 180.894 141.249 180.242 140.597C179.591 139.946 178.708 139.58 177.786 139.58C176.865 139.58 175.982 139.946 175.33 140.597C174.679 141.249 174.313 142.132 174.313 143.053ZM181.26 143.053C181.26 143.975 181.626 144.858 182.277 145.509C182.928 146.161 183.812 146.527 184.733 146.527C185.654 146.527 186.538 146.161 187.189 145.509C187.84 144.858 188.206 143.975 188.206 143.053C188.206 142.132 187.84 141.249 187.189 140.597C186.538 139.946 185.654 139.58 184.733 139.58C183.812 139.58 182.928 139.946 182.277 140.597C181.626 141.249 181.26 142.132 181.26 143.053ZM195.153 143.053C195.153 143.51 195.243 143.961 195.417 144.383C195.592 144.804 195.848 145.187 196.17 145.509C196.493 145.832 196.876 146.088 197.297 146.262C197.718 146.437 198.17 146.527 198.626 146.527C199.082 146.527 199.534 146.437 199.955 146.262C200.377 146.088 200.76 145.832 201.082 145.509C201.405 145.187 201.661 144.804 201.835 144.383C202.01 143.961 202.099 143.51 202.099 143.053C202.099 142.597 202.01 142.146 201.835 141.724C201.661 141.303 201.405 140.92 201.082 140.597C200.76 140.275 200.377 140.019 199.955 139.845C199.534 139.67 199.082 139.58 198.626 139.58C198.17 139.58 197.718 139.67 197.297 139.845C196.876 140.019 196.493 140.275 196.17 140.597C195.848 140.92 195.592 141.303 195.417 141.724C195.243 142.146 195.153 142.597 195.153 143.053ZM209.046 143.053C209.046 143.975 209.412 144.858 210.063 145.509C210.715 146.161 211.598 146.527 212.519 146.527C213.44 146.527 214.324 146.161 214.975 145.509C215.627 144.858 215.993 143.975 215.993 143.053C215.993 142.132 215.627 141.249 214.975 140.597C214.324 139.946 213.44 139.58 212.519 139.58C211.598 139.58 210.715 139.946 210.063 140.597C209.412 141.249 209.046 142.132 209.046 143.053ZM215.993 143.053C215.993 143.975 216.359 144.858 217.01 145.509C217.661 146.161 218.545 146.527 219.466 146.527C220.387 146.527 221.271 146.161 221.922 145.509C222.573 144.858 222.939 143.975 222.939 143.053C222.939 142.132 222.573 141.249 221.922 140.597C221.271 139.946 220.387 139.58 219.466 139.58C218.545 139.58 217.661 139.946 217.01 140.597C216.359 141.249 215.993 142.132 215.993 143.053ZM243.779 143.053C243.779 143.975 244.145 144.858 244.796 145.509C245.448 146.161 246.331 146.527 247.252 146.527C248.173 146.527 249.057 146.161 249.708 145.509C250.36 144.858 250.726 143.975 250.726 143.053C250.726 142.132 250.36 141.249 249.708 140.597C249.057 139.946 248.173 139.58 247.252 139.58C246.331 139.58 245.448 139.946 244.796 140.597C244.145 141.249 243.779 142.132 243.779 143.053ZM250.726 143.053C250.726 143.975 251.091 144.858 251.743 145.509C252.394 146.161 253.278 146.527 254.199 146.527C255.12 146.527 256.003 146.161 256.655 145.509C257.306 144.858 257.672 143.975 257.672 143.053C257.672 142.132 257.306 141.249 256.655 140.597C256.003 139.946 255.12 139.58 254.199 139.58C253.278 139.58 252.394 139.946 251.743 140.597C251.091 141.249 250.726 142.132 250.726 143.053ZM264.619 143.053C264.619 143.975 264.985 144.858 265.636 145.509C266.287 146.161 267.171 146.527 268.092 146.527C269.013 146.527 269.897 146.161 270.548 145.509C271.199 144.858 271.565 143.975 271.565 143.053C271.565 142.132 271.199 141.249 270.548 140.597C269.897 139.946 269.013 139.58 268.092 139.58C267.171 139.58 266.287 139.946 265.636 140.597C264.985 141.249 264.619 142.132 264.619 143.053ZM278.512 143.053C278.512 143.975 278.878 144.858 279.529 145.509C280.181 146.161 281.064 146.527 281.985 146.527C282.906 146.527 283.79 146.161 284.441 145.509C285.093 144.858 285.458 143.975 285.458 143.053C285.458 142.132 285.093 141.249 284.441 140.597C283.79 139.946 282.906 139.58 281.985 139.58C281.064 139.58 280.181 139.946 279.529 140.597C278.878 141.249 278.512 142.132 278.512 143.053ZM285.458 143.053C285.458 143.975 285.824 144.858 286.476 145.509C287.127 146.161 288.011 146.527 288.932 146.527C289.853 146.527 290.736 146.161 291.388 145.509C292.039 144.858 292.405 143.975 292.405 143.053C292.405 142.132 292.039 141.249 291.388 140.597C290.736 139.946 289.853 139.58 288.932 139.58C288.011 139.58 287.127 139.946 286.476 140.597C285.824 141.249 285.458 142.132 285.458 143.053ZM14.5416 150C14.5416 150.921 14.9075 151.805 15.5589 152.456C16.2102 153.107 17.0937 153.473 18.0149 153.473C18.936 153.473 19.8195 153.107 20.4708 152.456C21.1222 151.805 21.4881 150.921 21.4881 150C21.4881 149.079 21.1222 148.195 20.4708 147.544C19.8195 146.893 18.936 146.527 18.0149 146.527C17.0937 146.527 16.2102 146.893 15.5589 147.544C14.9075 148.195 14.5416 149.079 14.5416 150ZM21.4881 150C21.4881 150.921 21.8541 151.805 22.5055 152.456C23.1568 153.107 24.0403 153.473 24.9614 153.473C25.8826 153.473 26.7661 153.107 27.4174 152.456C28.0688 151.805 28.4347 150.921 28.4347 150C28.4347 149.079 28.0688 148.195 27.4174 147.544C26.7661 146.893 25.8826 146.527 24.9614 146.527C24.0403 146.527 23.1568 146.893 22.5055 147.544C21.8541 148.195 21.4881 149.079 21.4881 150ZM28.4347 150C28.4347 150.921 28.8007 151.805 29.452 152.456C30.1034 153.107 30.9869 153.473 31.908 153.473C32.8292 153.473 33.7126 153.107 34.364 152.456C35.0154 151.805 35.3813 150.921 35.3813 150C35.3813 149.079 35.0154 148.195 34.364 147.544C33.7126 146.893 32.8292 146.527 31.908 146.527C30.9869 146.527 30.1034 146.893 29.452 147.544C28.8007 148.195 28.4347 149.079 28.4347 150ZM35.3813 150C35.3813 150.921 35.7473 151.805 36.3986 152.456C37.05 153.107 37.9334 153.473 38.8546 153.473C39.7758 153.473 40.6592 153.107 41.3106 152.456C41.962 151.805 42.3279 150.921 42.3279 150C42.3279 149.079 41.962 148.195 41.3106 147.544C40.6592 146.893 39.7758 146.527 38.8546 146.527C37.9334 146.527 37.05 146.893 36.3986 147.544C35.7473 148.195 35.3813 149.079 35.3813 150ZM42.3279 150C42.3279 150.456 42.4177 150.908 42.5923 151.329C42.7668 151.751 43.0227 152.133 43.3452 152.456C43.6677 152.779 44.0506 153.034 44.472 153.209C44.8934 153.383 45.3451 153.473 45.8012 153.473C46.2573 153.473 46.709 153.383 47.1304 153.209C47.5518 153.034 47.9347 152.779 48.2572 152.456C48.5797 152.133 48.8356 151.751 49.0101 151.329C49.1847 150.908 49.2745 150.456 49.2745 150C49.2745 149.544 49.1847 149.092 49.0101 148.671C48.8356 148.249 48.5797 147.867 48.2572 147.544C47.9347 147.221 47.5518 146.966 47.1304 146.791C46.709 146.617 46.2573 146.527 45.8012 146.527C45.3451 146.527 44.8934 146.617 44.472 146.791C44.0506 146.966 43.6677 147.221 43.3452 147.544C43.0227 147.867 42.7668 148.249 42.5923 148.671C42.4177 149.092 42.3279 149.544 42.3279 150ZM49.2745 150C49.2745 150.456 49.3643 150.908 49.5389 151.329C49.7134 151.751 49.9693 152.133 50.2918 152.456C50.6143 152.779 50.9972 153.034 51.4186 153.209C51.84 153.383 52.2917 153.473 52.7478 153.473C53.2039 153.473 53.6556 153.383 54.077 153.209C54.4984 153.034 54.8813 152.779 55.2038 152.456C55.5263 152.133 55.7821 151.751 55.9567 151.329C56.1312 150.908 56.2211 150.456 56.2211 150C56.2211 149.544 56.1312 149.092 55.9567 148.671C55.7821 148.249 55.5263 147.867 55.2038 147.544C54.8813 147.221 54.4984 146.966 54.077 146.791C53.6556 146.617 53.2039 146.527 52.7478 146.527C52.2917 146.527 51.84 146.617 51.4186 146.791C50.9972 146.966 50.6143 147.221 50.2918 147.544C49.9693 147.867 49.7134 148.249 49.5389 148.671C49.3643 149.092 49.2745 149.544 49.2745 150ZM56.2211 150C56.2211 150.921 56.587 151.805 57.2384 152.456C57.8898 153.107 58.7732 153.473 59.6944 153.473C60.6156 153.473 61.499 153.107 62.1504 152.456C62.8017 151.805 63.1677 150.921 63.1677 150C63.1677 149.079 62.8017 148.195 62.1504 147.544C61.499 146.893 60.6156 146.527 59.6944 146.527C58.7732 146.527 57.8898 146.893 57.2384 147.544C56.587 148.195 56.2211 149.079 56.2211 150ZM63.1677 150C63.1677 150.921 63.5336 151.805 64.185 152.456C64.8363 153.107 65.7198 153.473 66.641 153.473C67.5621 153.473 68.4456 153.107 69.097 152.456C69.7483 151.805 70.1143 150.921 70.1143 150C70.1143 149.079 69.7483 148.195 69.097 147.544C68.4456 146.893 67.5621 146.527 66.641 146.527C65.7198 146.527 64.8363 146.893 64.185 147.544C63.5336 148.195 63.1677 149.079 63.1677 150ZM70.1143 150C70.1143 150.921 70.4802 151.805 71.1316 152.456C71.7829 153.107 72.6664 153.473 73.5876 153.473C74.5087 153.473 75.3922 153.107 76.0436 152.456C76.6949 151.805 77.0609 150.921 77.0609 150C77.0609 149.079 76.6949 148.195 76.0436 147.544C75.3922 146.893 74.5087 146.527 73.5876 146.527C72.6664 146.527 71.7829 146.893 71.1316 147.544C70.4802 148.195 70.1143 149.079 70.1143 150ZM84.0074 150C84.0074 150.921 84.3734 151.805 85.0247 152.456C85.6761 153.107 86.5596 153.473 87.4807 153.473C88.4019 153.473 89.2854 153.107 89.9367 152.456C90.5881 151.805 90.954 150.921 90.954 150C90.954 149.079 90.5881 148.195 89.9367 147.544C89.2854 146.893 88.4019 146.527 87.4807 146.527C86.5596 146.527 85.6761 146.893 85.0247 147.544C84.3734 148.195 84.0074 149.079 84.0074 150ZM90.954 150C90.954 150.921 91.32 151.805 91.9713 152.456C92.6227 153.107 93.5061 153.473 94.4273 153.473C95.3485 153.473 96.2319 153.107 96.8833 152.456C97.5347 151.805 97.9006 150.921 97.9006 150C97.9006 149.079 97.5347 148.195 96.8833 147.544C96.2319 146.893 95.3485 146.527 94.4273 146.527C93.5061 146.527 92.6227 146.893 91.9713 147.544C91.32 148.195 90.954 149.079 90.954 150ZM97.9006 150C97.9006 150.456 97.9905 150.908 98.165 151.329C98.3396 151.751 98.5954 152.133 98.9179 152.456C99.2404 152.779 99.6233 153.034 100.045 153.209C100.466 153.383 100.918 153.473 101.374 153.473C101.83 153.473 102.282 153.383 102.703 153.209C103.124 153.034 103.507 152.779 103.83 152.456C104.152 152.133 104.408 151.751 104.583 151.329C104.757 150.908 104.847 150.456 104.847 150C104.847 149.544 104.757 149.092 104.583 148.671C104.408 148.249 104.152 147.867 103.83 147.544C103.507 147.221 103.124 146.966 102.703 146.791C102.282 146.617 101.83 146.527 101.374 146.527C100.918 146.527 100.466 146.617 100.045 146.791C99.6233 146.966 99.2404 147.221 98.9179 147.544C98.5954 147.867 98.3396 148.249 98.165 148.671C97.9905 149.092 97.9006 149.544 97.9006 150ZM111.794 150C111.794 150.921 112.16 151.805 112.811 152.456C113.462 153.107 114.346 153.473 115.267 153.473C116.188 153.473 117.072 153.107 117.723 152.456C118.374 151.805 118.74 150.921 118.74 150C118.74 149.079 118.374 148.195 117.723 147.544C117.072 146.893 116.188 146.527 115.267 146.527C114.346 146.527 113.462 146.893 112.811 147.544C112.16 148.195 111.794 149.079 111.794 150ZM118.74 150C118.74 150.921 119.106 151.805 119.758 152.456C120.409 153.107 121.292 153.473 122.214 153.473C123.135 153.473 124.018 153.107 124.67 152.456C125.321 151.805 125.687 150.921 125.687 150C125.687 149.079 125.321 148.195 124.67 147.544C124.018 146.893 123.135 146.527 122.214 146.527C121.292 146.527 120.409 146.893 119.758 147.544C119.106 148.195 118.74 149.079 118.74 150ZM132.634 150C132.634 150.921 132.999 151.805 133.651 152.456C134.302 153.107 135.186 153.473 136.107 153.473C137.028 153.473 137.911 153.107 138.563 152.456C139.214 151.805 139.58 150.921 139.58 150C139.58 149.079 139.214 148.195 138.563 147.544C137.911 146.893 137.028 146.527 136.107 146.527C135.186 146.527 134.302 146.893 133.651 147.544C132.999 148.195 132.634 149.079 132.634 150ZM139.58 150C139.58 150.921 139.946 151.805 140.597 152.456C141.249 153.107 142.132 153.473 143.053 153.473C143.975 153.473 144.858 153.107 145.509 152.456C146.161 151.805 146.527 150.921 146.527 150C146.527 149.079 146.161 148.195 145.509 147.544C144.858 146.893 143.975 146.527 143.053 146.527C142.132 146.527 141.249 146.893 140.597 147.544C139.946 148.195 139.58 149.079 139.58 150ZM146.527 150C146.527 150.921 146.893 151.805 147.544 152.456C148.195 153.107 149.079 153.473 150 153.473C150.921 153.473 151.805 153.107 152.456 152.456C153.107 151.805 153.473 150.921 153.473 150C153.473 149.079 153.107 148.195 152.456 147.544C151.805 146.893 150.921 146.527 150 146.527C149.079 146.527 148.195 146.893 147.544 147.544C146.893 148.195 146.527 149.079 146.527 150ZM167.366 150C167.366 150.921 167.732 151.805 168.384 152.456C169.035 153.107 169.919 153.473 170.84 153.473C171.761 153.473 172.644 153.107 173.296 152.456C173.947 151.805 174.313 150.921 174.313 150C174.313 149.079 173.947 148.195 173.296 147.544C172.644 146.893 171.761 146.527 170.84 146.527C169.919 146.527 169.035 146.893 168.384 147.544C167.732 148.195 167.366 149.079 167.366 150ZM174.313 150C174.313 150.921 174.679 151.805 175.33 152.456C175.982 153.107 176.865 153.473 177.786 153.473C178.708 153.473 179.591 153.107 180.242 152.456C180.894 151.805 181.26 150.921 181.26 150C181.26 149.079 180.894 148.195 180.242 147.544C179.591 146.893 178.708 146.527 177.786 146.527C176.865 146.527 175.982 146.893 175.33 147.544C174.679 148.195 174.313 149.079 174.313 150ZM195.153 150C195.153 150.456 195.243 150.908 195.417 151.329C195.592 151.751 195.848 152.133 196.17 152.456C196.493 152.779 196.876 153.034 197.297 153.209C197.718 153.383 198.17 153.473 198.626 153.473C199.082 153.473 199.534 153.383 199.955 153.209C200.377 153.034 200.76 152.779 201.082 152.456C201.405 152.133 201.661 151.751 201.835 151.329C202.01 150.908 202.099 150.456 202.099 150C202.099 149.544 202.01 149.092 201.835 148.671C201.661 148.249 201.405 147.867 201.082 147.544C200.76 147.221 200.377 146.966 199.955 146.791C199.534 146.617 199.082 146.527 198.626 146.527C198.17 146.527 197.718 146.617 197.297 146.791C196.876 146.966 196.493 147.221 196.17 147.544C195.848 147.867 195.592 148.249 195.417 148.671C195.243 149.092 195.153 149.544 195.153 150ZM215.993 150C215.993 150.921 216.359 151.805 217.01 152.456C217.661 153.107 218.545 153.473 219.466 153.473C220.387 153.473 221.271 153.107 221.922 152.456C222.573 151.805 222.939 150.921 222.939 150C222.939 149.079 222.573 148.195 221.922 147.544C221.271 146.893 220.387 146.527 219.466 146.527C218.545 146.527 217.661 146.893 217.01 147.544C216.359 148.195 215.993 149.079 215.993 150ZM229.886 150C229.886 150.921 230.252 151.805 230.903 152.456C231.554 153.107 232.438 153.473 233.359 153.473C234.28 153.473 235.164 153.107 235.815 152.456C236.466 151.805 236.832 150.921 236.832 150C236.832 149.079 236.466 148.195 235.815 147.544C235.164 146.893 234.28 146.527 233.359 146.527C232.438 146.527 231.554 146.893 230.903 147.544C230.252 148.195 229.886 149.079 229.886 150ZM236.832 150C236.832 150.921 237.198 151.805 237.85 152.456C238.501 153.107 239.384 153.473 240.306 153.473C241.227 153.473 242.11 153.107 242.762 152.456C243.413 151.805 243.779 150.921 243.779 150C243.779 149.079 243.413 148.195 242.762 147.544C242.11 146.893 241.227 146.527 240.306 146.527C239.384 146.527 238.501 146.893 237.85 147.544C237.198 148.195 236.832 149.079 236.832 150ZM250.726 150C250.726 150.921 251.091 151.805 251.743 152.456C252.394 153.107 253.278 153.473 254.199 153.473C255.12 153.473 256.003 153.107 256.655 152.456C257.306 151.805 257.672 150.921 257.672 150C257.672 149.079 257.306 148.195 256.655 147.544C256.003 146.893 255.12 146.527 254.199 146.527C253.278 146.527 252.394 146.893 251.743 147.544C251.091 148.195 250.726 149.079 250.726 150ZM257.672 150C257.672 150.921 258.038 151.805 258.689 152.456C259.341 153.107 260.224 153.473 261.145 153.473C262.067 153.473 262.95 153.107 263.601 152.456C264.253 151.805 264.619 150.921 264.619 150C264.619 149.079 264.253 148.195 263.601 147.544C262.95 146.893 262.067 146.527 261.145 146.527C260.224 146.527 259.341 146.893 258.689 147.544C258.038 148.195 257.672 149.079 257.672 150ZM264.619 150C264.619 150.921 264.985 151.805 265.636 152.456C266.287 153.107 267.171 153.473 268.092 153.473C269.013 153.473 269.897 153.107 270.548 152.456C271.199 151.805 271.565 150.921 271.565 150C271.565 149.079 271.199 148.195 270.548 147.544C269.897 146.893 269.013 146.527 268.092 146.527C267.171 146.527 266.287 146.893 265.636 147.544C264.985 148.195 264.619 149.079 264.619 150ZM7.59497 156.947C7.59497 157.868 7.96091 158.751 8.61227 159.403C9.26364 160.054 10.1471 160.42 11.0683 160.42C11.9894 160.42 12.8729 160.054 13.5243 159.403C14.1756 158.751 14.5416 157.868 14.5416 156.947C14.5416 156.025 14.1756 155.142 13.5243 154.491C12.8729 153.839 11.9894 153.473 11.0683 153.473C10.1471 153.473 9.26364 153.839 8.61227 154.491C7.96091 155.142 7.59497 156.025 7.59497 156.947ZM21.4881 156.947C21.4881 157.868 21.8541 158.751 22.5055 159.403C23.1568 160.054 24.0403 160.42 24.9614 160.42C25.8826 160.42 26.7661 160.054 27.4174 159.403C28.0688 158.751 28.4347 157.868 28.4347 156.947C28.4347 156.025 28.0688 155.142 27.4174 154.491C26.7661 153.839 25.8826 153.473 24.9614 153.473C24.0403 153.473 23.1568 153.839 22.5055 154.491C21.8541 155.142 21.4881 156.025 21.4881 156.947ZM28.4347 156.947C28.4347 157.868 28.8007 158.751 29.452 159.403C30.1034 160.054 30.9869 160.42 31.908 160.42C32.8292 160.42 33.7126 160.054 34.364 159.403C35.0154 158.751 35.3813 157.868 35.3813 156.947C35.3813 156.025 35.0154 155.142 34.364 154.491C33.7126 153.839 32.8292 153.473 31.908 153.473C30.9869 153.473 30.1034 153.839 29.452 154.491C28.8007 155.142 28.4347 156.025 28.4347 156.947ZM35.3813 156.947C35.3813 157.868 35.7473 158.751 36.3986 159.403C37.05 160.054 37.9334 160.42 38.8546 160.42C39.7758 160.42 40.6592 160.054 41.3106 159.403C41.962 158.751 42.3279 157.868 42.3279 156.947C42.3279 156.025 41.962 155.142 41.3106 154.491C40.6592 153.839 39.7758 153.473 38.8546 153.473C37.9334 153.473 37.05 153.839 36.3986 154.491C35.7473 155.142 35.3813 156.025 35.3813 156.947ZM42.3279 156.947C42.3279 157.403 42.4177 157.854 42.5923 158.276C42.7668 158.697 43.0227 159.08 43.3452 159.403C43.6677 159.725 44.0506 159.981 44.472 160.155C44.8934 160.33 45.3451 160.42 45.8012 160.42C46.2573 160.42 46.709 160.33 47.1304 160.155C47.5518 159.981 47.9347 159.725 48.2572 159.403C48.5797 159.08 48.8356 158.697 49.0101 158.276C49.1847 157.854 49.2745 157.403 49.2745 156.947C49.2745 156.49 49.1847 156.039 49.0101 155.617C48.8356 155.196 48.5797 154.813 48.2572 154.491C47.9347 154.168 47.5518 153.912 47.1304 153.738C46.709 153.563 46.2573 153.473 45.8012 153.473C45.3451 153.473 44.8934 153.563 44.472 153.738C44.0506 153.912 43.6677 154.168 43.3452 154.491C43.0227 154.813 42.7668 155.196 42.5923 155.617C42.4177 156.039 42.3279 156.49 42.3279 156.947ZM70.1143 156.947C70.1143 157.868 70.4802 158.751 71.1316 159.403C71.7829 160.054 72.6664 160.42 73.5876 160.42C74.5087 160.42 75.3922 160.054 76.0436 159.403C76.6949 158.751 77.0609 157.868 77.0609 156.947C77.0609 156.025 76.6949 155.142 76.0436 154.491C75.3922 153.839 74.5087 153.473 73.5876 153.473C72.6664 153.473 71.7829 153.839 71.1316 154.491C70.4802 155.142 70.1143 156.025 70.1143 156.947ZM77.0609 156.947C77.0609 157.403 77.1507 157.854 77.3252 158.276C77.4998 158.697 77.7556 159.08 78.0782 159.403C78.4007 159.725 78.7836 159.981 79.205 160.155C79.6264 160.33 80.078 160.42 80.5341 160.42C80.9903 160.42 81.4419 160.33 81.8633 160.155C82.2847 159.981 82.6676 159.725 82.9901 159.403C83.3127 159.08 83.5685 158.697 83.743 158.276C83.9176 157.854 84.0074 157.403 84.0074 156.947C84.0074 156.49 83.9176 156.039 83.743 155.617C83.5685 155.196 83.3127 154.813 82.9901 154.491C82.6676 154.168 82.2847 153.912 81.8633 153.738C81.4419 153.563 80.9903 153.473 80.5341 153.473C80.078 153.473 79.6264 153.563 79.205 153.738C78.7836 153.912 78.4007 154.168 78.0782 154.491C77.7556 154.813 77.4998 155.196 77.3252 155.617C77.1507 156.039 77.0609 156.49 77.0609 156.947ZM84.0074 156.947C84.0074 157.868 84.3734 158.751 85.0247 159.403C85.6761 160.054 86.5596 160.42 87.4807 160.42C88.4019 160.42 89.2854 160.054 89.9367 159.403C90.5881 158.751 90.954 157.868 90.954 156.947C90.954 156.025 90.5881 155.142 89.9367 154.491C89.2854 153.839 88.4019 153.473 87.4807 153.473C86.5596 153.473 85.6761 153.839 85.0247 154.491C84.3734 155.142 84.0074 156.025 84.0074 156.947ZM90.954 156.947C90.954 157.868 91.32 158.751 91.9713 159.403C92.6227 160.054 93.5061 160.42 94.4273 160.42C95.3485 160.42 96.2319 160.054 96.8833 159.403C97.5347 158.751 97.9006 157.868 97.9006 156.947C97.9006 156.025 97.5347 155.142 96.8833 154.491C96.2319 153.839 95.3485 153.473 94.4273 153.473C93.5061 153.473 92.6227 153.839 91.9713 154.491C91.32 155.142 90.954 156.025 90.954 156.947ZM118.74 156.947C118.74 157.868 119.106 158.751 119.758 159.403C120.409 160.054 121.292 160.42 122.214 160.42C123.135 160.42 124.018 160.054 124.67 159.403C125.321 158.751 125.687 157.868 125.687 156.947C125.687 156.025 125.321 155.142 124.67 154.491C124.018 153.839 123.135 153.473 122.214 153.473C121.292 153.473 120.409 153.839 119.758 154.491C119.106 155.142 118.74 156.025 118.74 156.947ZM146.527 156.947C146.527 157.868 146.893 158.751 147.544 159.403C148.195 160.054 149.079 160.42 150 160.42C150.921 160.42 151.805 160.054 152.456 159.403C153.107 158.751 153.473 157.868 153.473 156.947C153.473 156.025 153.107 155.142 152.456 154.491C151.805 153.839 150.921 153.473 150 153.473C149.079 153.473 148.195 153.839 147.544 154.491C146.893 155.142 146.527 156.025 146.527 156.947ZM160.42 156.947C160.42 157.868 160.786 158.751 161.437 159.403C162.089 160.054 162.972 160.42 163.893 160.42C164.814 160.42 165.698 160.054 166.349 159.403C167.001 158.751 167.366 157.868 167.366 156.947C167.366 156.025 167.001 155.142 166.349 154.491C165.698 153.839 164.814 153.473 163.893 153.473C162.972 153.473 162.089 153.839 161.437 154.491C160.786 155.142 160.42 156.025 160.42 156.947ZM195.153 156.947C195.153 157.403 195.243 157.854 195.417 158.276C195.592 158.697 195.848 159.08 196.17 159.403C196.493 159.725 196.876 159.981 197.297 160.155C197.718 160.33 198.17 160.42 198.626 160.42C199.082 160.42 199.534 160.33 199.955 160.155C200.377 159.981 200.76 159.725 201.082 159.403C201.405 159.08 201.661 158.697 201.835 158.276C202.01 157.854 202.099 157.403 202.099 156.947C202.099 156.49 202.01 156.039 201.835 155.617C201.661 155.196 201.405 154.813 201.082 154.491C200.76 154.168 200.377 153.912 199.955 153.738C199.534 153.563 199.082 153.473 198.626 153.473C198.17 153.473 197.718 153.563 197.297 153.738C196.876 153.912 196.493 154.168 196.17 154.491C195.848 154.813 195.592 155.196 195.417 155.617C195.243 156.039 195.153 156.49 195.153 156.947ZM202.099 156.947C202.099 157.868 202.465 158.751 203.117 159.403C203.768 160.054 204.652 160.42 205.573 160.42C206.494 160.42 207.377 160.054 208.029 159.403C208.68 158.751 209.046 157.868 209.046 156.947C209.046 156.025 208.68 155.142 208.029 154.491C207.377 153.839 206.494 153.473 205.573 153.473C204.652 153.473 203.768 153.839 203.117 154.491C202.465 155.142 202.099 156.025 202.099 156.947ZM209.046 156.947C209.046 157.868 209.412 158.751 210.063 159.403C210.715 160.054 211.598 160.42 212.519 160.42C213.44 160.42 214.324 160.054 214.975 159.403C215.627 158.751 215.993 157.868 215.993 156.947C215.993 156.025 215.627 155.142 214.975 154.491C214.324 153.839 213.44 153.473 212.519 153.473C211.598 153.473 210.715 153.839 210.063 154.491C209.412 155.142 209.046 156.025 209.046 156.947ZM236.832 156.947C236.832 157.868 237.198 158.751 237.85 159.403C238.501 160.054 239.384 160.42 240.306 160.42C241.227 160.42 242.11 160.054 242.762 159.403C243.413 158.751 243.779 157.868 243.779 156.947C243.779 156.025 243.413 155.142 242.762 154.491C242.11 153.839 241.227 153.473 240.306 153.473C239.384 153.473 238.501 153.839 237.85 154.491C237.198 155.142 236.832 156.025 236.832 156.947ZM243.779 156.947C243.779 157.868 244.145 158.751 244.796 159.403C245.448 160.054 246.331 160.42 247.252 160.42C248.173 160.42 249.057 160.054 249.708 159.403C250.36 158.751 250.726 157.868 250.726 156.947C250.726 156.025 250.36 155.142 249.708 154.491C249.057 153.839 248.173 153.473 247.252 153.473C246.331 153.473 245.448 153.839 244.796 154.491C244.145 155.142 243.779 156.025 243.779 156.947ZM257.672 156.947C257.672 157.868 258.038 158.751 258.689 159.403C259.341 160.054 260.224 160.42 261.145 160.42C262.067 160.42 262.95 160.054 263.601 159.403C264.253 158.751 264.619 157.868 264.619 156.947C264.619 156.025 264.253 155.142 263.601 154.491C262.95 153.839 262.067 153.473 261.145 153.473C260.224 153.473 259.341 153.839 258.689 154.491C258.038 155.142 257.672 156.025 257.672 156.947ZM264.619 156.947C264.619 157.868 264.985 158.751 265.636 159.403C266.287 160.054 267.171 160.42 268.092 160.42C269.013 160.42 269.897 160.054 270.548 159.403C271.199 158.751 271.565 157.868 271.565 156.947C271.565 156.025 271.199 155.142 270.548 154.491C269.897 153.839 269.013 153.473 268.092 153.473C267.171 153.473 266.287 153.839 265.636 154.491C264.985 155.142 264.619 156.025 264.619 156.947ZM285.458 156.947C285.458 157.868 285.824 158.751 286.476 159.403C287.127 160.054 288.011 160.42 288.932 160.42C289.853 160.42 290.736 160.054 291.388 159.403C292.039 158.751 292.405 157.868 292.405 156.947C292.405 156.025 292.039 155.142 291.388 154.491C290.736 153.839 289.853 153.473 288.932 153.473C288.011 153.473 287.127 153.839 286.476 154.491C285.824 155.142 285.458 156.025 285.458 156.947ZM21.4881 163.893C21.4881 164.814 21.8541 165.698 22.5055 166.349C23.1568 167.001 24.0403 167.366 24.9614 167.366C25.8826 167.366 26.7661 167.001 27.4174 166.349C28.0688 165.698 28.4347 164.814 28.4347 163.893C28.4347 162.972 28.0688 162.089 27.4174 161.437C26.7661 160.786 25.8826 160.42 24.9614 160.42C24.0403 160.42 23.1568 160.786 22.5055 161.437C21.8541 162.089 21.4881 162.972 21.4881 163.893ZM28.4347 163.893C28.4347 164.814 28.8007 165.698 29.452 166.349C30.1034 167.001 30.9869 167.366 31.908 167.366C32.8292 167.366 33.7126 167.001 34.364 166.349C35.0154 165.698 35.3813 164.814 35.3813 163.893C35.3813 162.972 35.0154 162.089 34.364 161.437C33.7126 160.786 32.8292 160.42 31.908 160.42C30.9869 160.42 30.1034 160.786 29.452 161.437C28.8007 162.089 28.4347 162.972 28.4347 163.893ZM49.2745 163.893C49.2745 164.349 49.3643 164.801 49.5389 165.222C49.7134 165.644 49.9693 166.027 50.2918 166.349C50.6143 166.672 50.9972 166.928 51.4186 167.102C51.84 167.277 52.2917 167.366 52.7478 167.366C53.2039 167.366 53.6556 167.277 54.077 167.102C54.4984 166.928 54.8813 166.672 55.2038 166.349C55.5263 166.027 55.7821 165.644 55.9567 165.222C56.1312 164.801 56.2211 164.349 56.2211 163.893C56.2211 163.437 56.1312 162.985 55.9567 162.564C55.7821 162.143 55.5263 161.76 55.2038 161.437C54.8813 161.115 54.4984 160.859 54.077 160.684C53.6556 160.51 53.2039 160.42 52.7478 160.42C52.2917 160.42 51.84 160.51 51.4186 160.684C50.9972 160.859 50.6143 161.115 50.2918 161.437C49.9693 161.76 49.7134 162.143 49.5389 162.564C49.3643 162.985 49.2745 163.437 49.2745 163.893ZM56.2211 163.893C56.2211 164.814 56.587 165.698 57.2384 166.349C57.8898 167.001 58.7732 167.366 59.6944 167.366C60.6156 167.366 61.499 167.001 62.1504 166.349C62.8017 165.698 63.1677 164.814 63.1677 163.893C63.1677 162.972 62.8017 162.089 62.1504 161.437C61.499 160.786 60.6156 160.42 59.6944 160.42C58.7732 160.42 57.8898 160.786 57.2384 161.437C56.587 162.089 56.2211 162.972 56.2211 163.893ZM63.1677 163.893C63.1677 164.814 63.5336 165.698 64.185 166.349C64.8363 167.001 65.7198 167.366 66.641 167.366C67.5621 167.366 68.4456 167.001 69.097 166.349C69.7483 165.698 70.1143 164.814 70.1143 163.893C70.1143 162.972 69.7483 162.089 69.097 161.437C68.4456 160.786 67.5621 160.42 66.641 160.42C65.7198 160.42 64.8363 160.786 64.185 161.437C63.5336 162.089 63.1677 162.972 63.1677 163.893ZM90.954 163.893C90.954 164.814 91.32 165.698 91.9713 166.349C92.6227 167.001 93.5061 167.366 94.4273 167.366C95.3485 167.366 96.2319 167.001 96.8833 166.349C97.5347 165.698 97.9006 164.814 97.9006 163.893C97.9006 162.972 97.5347 162.089 96.8833 161.437C96.2319 160.786 95.3485 160.42 94.4273 160.42C93.5061 160.42 92.6227 160.786 91.9713 161.437C91.32 162.089 90.954 162.972 90.954 163.893ZM104.847 163.893C104.847 164.814 105.213 165.698 105.865 166.349C106.516 167.001 107.399 167.366 108.321 167.366C109.242 167.366 110.125 167.001 110.776 166.349C111.428 165.698 111.794 164.814 111.794 163.893C111.794 162.972 111.428 162.089 110.776 161.437C110.125 160.786 109.242 160.42 108.321 160.42C107.399 160.42 106.516 160.786 105.865 161.437C105.213 162.089 104.847 162.972 104.847 163.893ZM125.687 163.893C125.687 164.814 126.053 165.698 126.704 166.349C127.356 167.001 128.239 167.366 129.16 167.366C130.081 167.366 130.965 167.001 131.616 166.349C132.268 165.698 132.634 164.814 132.634 163.893C132.634 162.972 132.268 162.089 131.616 161.437C130.965 160.786 130.081 160.42 129.16 160.42C128.239 160.42 127.356 160.786 126.704 161.437C126.053 162.089 125.687 162.972 125.687 163.893ZM132.634 163.893C132.634 164.814 132.999 165.698 133.651 166.349C134.302 167.001 135.186 167.366 136.107 167.366C137.028 167.366 137.911 167.001 138.563 166.349C139.214 165.698 139.58 164.814 139.58 163.893C139.58 162.972 139.214 162.089 138.563 161.437C137.911 160.786 137.028 160.42 136.107 160.42C135.186 160.42 134.302 160.786 133.651 161.437C132.999 162.089 132.634 162.972 132.634 163.893ZM139.58 163.893C139.58 164.814 139.946 165.698 140.597 166.349C141.249 167.001 142.132 167.366 143.053 167.366C143.975 167.366 144.858 167.001 145.509 166.349C146.161 165.698 146.527 164.814 146.527 163.893C146.527 162.972 146.161 162.089 145.509 161.437C144.858 160.786 143.975 160.42 143.053 160.42C142.132 160.42 141.249 160.786 140.597 161.437C139.946 162.089 139.58 162.972 139.58 163.893ZM146.527 163.893C146.527 164.814 146.893 165.698 147.544 166.349C148.195 167.001 149.079 167.366 150 167.366C150.921 167.366 151.805 167.001 152.456 166.349C153.107 165.698 153.473 164.814 153.473 163.893C153.473 162.972 153.107 162.089 152.456 161.437C151.805 160.786 150.921 160.42 150 160.42C149.079 160.42 148.195 160.786 147.544 161.437C146.893 162.089 146.527 162.972 146.527 163.893ZM174.313 163.893C174.313 164.814 174.679 165.698 175.33 166.349C175.982 167.001 176.865 167.366 177.786 167.366C178.708 167.366 179.591 167.001 180.242 166.349C180.894 165.698 181.26 164.814 181.26 163.893C181.26 162.972 180.894 162.089 180.242 161.437C179.591 160.786 178.708 160.42 177.786 160.42C176.865 160.42 175.982 160.786 175.33 161.437C174.679 162.089 174.313 162.972 174.313 163.893ZM195.153 163.893C195.153 164.349 195.243 164.801 195.417 165.222C195.592 165.644 195.848 166.027 196.17 166.349C196.493 166.672 196.876 166.928 197.297 167.102C197.718 167.277 198.17 167.366 198.626 167.366C199.082 167.366 199.534 167.277 199.955 167.102C200.377 166.928 200.76 166.672 201.082 166.349C201.405 166.027 201.661 165.644 201.835 165.222C202.01 164.801 202.099 164.349 202.099 163.893C202.099 163.437 202.01 162.985 201.835 162.564C201.661 162.143 201.405 161.76 201.082 161.437C200.76 161.115 200.377 160.859 199.955 160.684C199.534 160.51 199.082 160.42 198.626 160.42C198.17 160.42 197.718 160.51 197.297 160.684C196.876 160.859 196.493 161.115 196.17 161.437C195.848 161.76 195.592 162.143 195.417 162.564C195.243 162.985 195.153 163.437 195.153 163.893ZM215.993 163.893C215.993 164.814 216.359 165.698 217.01 166.349C217.661 167.001 218.545 167.366 219.466 167.366C220.387 167.366 221.271 167.001 221.922 166.349C222.573 165.698 222.939 164.814 222.939 163.893C222.939 162.972 222.573 162.089 221.922 161.437C221.271 160.786 220.387 160.42 219.466 160.42C218.545 160.42 217.661 160.786 217.01 161.437C216.359 162.089 215.993 162.972 215.993 163.893ZM236.832 163.893C236.832 164.814 237.198 165.698 237.85 166.349C238.501 167.001 239.384 167.366 240.306 167.366C241.227 167.366 242.11 167.001 242.762 166.349C243.413 165.698 243.779 164.814 243.779 163.893C243.779 162.972 243.413 162.089 242.762 161.437C242.11 160.786 241.227 160.42 240.306 160.42C239.384 160.42 238.501 160.786 237.85 161.437C237.198 162.089 236.832 162.972 236.832 163.893ZM243.779 163.893C243.779 164.814 244.145 165.698 244.796 166.349C245.448 167.001 246.331 167.366 247.252 167.366C248.173 167.366 249.057 167.001 249.708 166.349C250.36 165.698 250.726 164.814 250.726 163.893C250.726 162.972 250.36 162.089 249.708 161.437C249.057 160.786 248.173 160.42 247.252 160.42C246.331 160.42 245.448 160.786 244.796 161.437C244.145 162.089 243.779 162.972 243.779 163.893ZM264.619 163.893C264.619 164.814 264.985 165.698 265.636 166.349C266.287 167.001 267.171 167.366 268.092 167.366C269.013 167.366 269.897 167.001 270.548 166.349C271.199 165.698 271.565 164.814 271.565 163.893C271.565 162.972 271.199 162.089 270.548 161.437C269.897 160.786 269.013 160.42 268.092 160.42C267.171 160.42 266.287 160.786 265.636 161.437C264.985 162.089 264.619 162.972 264.619 163.893ZM285.458 163.893C285.458 164.814 285.824 165.698 286.476 166.349C287.127 167.001 288.011 167.366 288.932 167.366C289.853 167.366 290.736 167.001 291.388 166.349C292.039 165.698 292.405 164.814 292.405 163.893C292.405 162.972 292.039 162.089 291.388 161.437C290.736 160.786 289.853 160.42 288.932 160.42C288.011 160.42 287.127 160.786 286.476 161.437C285.824 162.089 285.458 162.972 285.458 163.893ZM7.59497 170.84C7.59497 171.761 7.96091 172.644 8.61227 173.296C9.26364 173.947 10.1471 174.313 11.0683 174.313C11.9894 174.313 12.8729 173.947 13.5243 173.296C14.1756 172.644 14.5416 171.761 14.5416 170.84C14.5416 169.919 14.1756 169.035 13.5243 168.384C12.8729 167.732 11.9894 167.366 11.0683 167.366C10.1471 167.366 9.26364 167.732 8.61227 168.384C7.96091 169.035 7.59497 169.919 7.59497 170.84ZM21.4881 170.84C21.4881 171.761 21.8541 172.644 22.5055 173.296C23.1568 173.947 24.0403 174.313 24.9614 174.313C25.8826 174.313 26.7661 173.947 27.4174 173.296C28.0688 172.644 28.4347 171.761 28.4347 170.84C28.4347 169.919 28.0688 169.035 27.4174 168.384C26.7661 167.732 25.8826 167.366 24.9614 167.366C24.0403 167.366 23.1568 167.732 22.5055 168.384C21.8541 169.035 21.4881 169.919 21.4881 170.84ZM35.3813 170.84C35.3813 171.761 35.7473 172.644 36.3986 173.296C37.05 173.947 37.9334 174.313 38.8546 174.313C39.7758 174.313 40.6592 173.947 41.3106 173.296C41.962 172.644 42.3279 171.761 42.3279 170.84C42.3279 169.919 41.962 169.035 41.3106 168.384C40.6592 167.732 39.7758 167.366 38.8546 167.366C37.9334 167.366 37.05 167.732 36.3986 168.384C35.7473 169.035 35.3813 169.919 35.3813 170.84ZM56.2211 170.84C56.2211 171.761 56.587 172.644 57.2384 173.296C57.8898 173.947 58.7732 174.313 59.6944 174.313C60.6156 174.313 61.499 173.947 62.1504 173.296C62.8017 172.644 63.1677 171.761 63.1677 170.84C63.1677 169.919 62.8017 169.035 62.1504 168.384C61.499 167.732 60.6156 167.366 59.6944 167.366C58.7732 167.366 57.8898 167.732 57.2384 168.384C56.587 169.035 56.2211 169.919 56.2211 170.84ZM84.0074 170.84C84.0074 171.761 84.3734 172.644 85.0247 173.296C85.6761 173.947 86.5596 174.313 87.4807 174.313C88.4019 174.313 89.2854 173.947 89.9367 173.296C90.5881 172.644 90.954 171.761 90.954 170.84C90.954 169.919 90.5881 169.035 89.9367 168.384C89.2854 167.732 88.4019 167.366 87.4807 167.366C86.5596 167.366 85.6761 167.732 85.0247 168.384C84.3734 169.035 84.0074 169.919 84.0074 170.84ZM111.794 170.84C111.794 171.761 112.16 172.644 112.811 173.296C113.462 173.947 114.346 174.313 115.267 174.313C116.188 174.313 117.072 173.947 117.723 173.296C118.374 172.644 118.74 171.761 118.74 170.84C118.74 169.919 118.374 169.035 117.723 168.384C117.072 167.732 116.188 167.366 115.267 167.366C114.346 167.366 113.462 167.732 112.811 168.384C112.16 169.035 111.794 169.919 111.794 170.84ZM125.687 170.84C125.687 171.761 126.053 172.644 126.704 173.296C127.356 173.947 128.239 174.313 129.16 174.313C130.081 174.313 130.965 173.947 131.616 173.296C132.268 172.644 132.634 171.761 132.634 170.84C132.634 169.919 132.268 169.035 131.616 168.384C130.965 167.732 130.081 167.366 129.16 167.366C128.239 167.366 127.356 167.732 126.704 168.384C126.053 169.035 125.687 169.919 125.687 170.84ZM139.58 170.84C139.58 171.761 139.946 172.644 140.597 173.296C141.249 173.947 142.132 174.313 143.053 174.313C143.975 174.313 144.858 173.947 145.509 173.296C146.161 172.644 146.527 171.761 146.527 170.84C146.527 169.919 146.161 169.035 145.509 168.384C144.858 167.732 143.975 167.366 143.053 167.366C142.132 167.366 141.249 167.732 140.597 168.384C139.946 169.035 139.58 169.919 139.58 170.84ZM160.42 170.84C160.42 171.761 160.786 172.644 161.437 173.296C162.089 173.947 162.972 174.313 163.893 174.313C164.814 174.313 165.698 173.947 166.349 173.296C167.001 172.644 167.366 171.761 167.366 170.84C167.366 169.919 167.001 169.035 166.349 168.384C165.698 167.732 164.814 167.366 163.893 167.366C162.972 167.366 162.089 167.732 161.437 168.384C160.786 169.035 160.42 169.919 160.42 170.84ZM181.26 170.84C181.26 171.761 181.626 172.644 182.277 173.296C182.928 173.947 183.812 174.313 184.733 174.313C185.654 174.313 186.538 173.947 187.189 173.296C187.84 172.644 188.206 171.761 188.206 170.84C188.206 169.919 187.84 169.035 187.189 168.384C186.538 167.732 185.654 167.366 184.733 167.366C183.812 167.366 182.928 167.732 182.277 168.384C181.626 169.035 181.26 169.919 181.26 170.84ZM188.206 170.84C188.206 171.761 188.572 172.644 189.224 173.296C189.875 173.947 190.758 174.313 191.68 174.313C192.601 174.313 193.484 173.947 194.136 173.296C194.787 172.644 195.153 171.761 195.153 170.84C195.153 169.919 194.787 169.035 194.136 168.384C193.484 167.732 192.601 167.366 191.68 167.366C190.758 167.366 189.875 167.732 189.224 168.384C188.572 169.035 188.206 169.919 188.206 170.84ZM195.153 170.84C195.153 171.296 195.243 171.748 195.417 172.169C195.592 172.59 195.848 172.973 196.17 173.296C196.493 173.618 196.876 173.874 197.297 174.049C197.718 174.223 198.17 174.313 198.626 174.313C199.082 174.313 199.534 174.223 199.955 174.049C200.377 173.874 200.76 173.618 201.082 173.296C201.405 172.973 201.661 172.59 201.835 172.169C202.01 171.748 202.099 171.296 202.099 170.84C202.099 170.384 202.01 169.932 201.835 169.511C201.661 169.089 201.405 168.706 201.082 168.384C200.76 168.061 200.377 167.805 199.955 167.631C199.534 167.456 199.082 167.366 198.626 167.366C198.17 167.366 197.718 167.456 197.297 167.631C196.876 167.805 196.493 168.061 196.17 168.384C195.848 168.706 195.592 169.089 195.417 169.511C195.243 169.932 195.153 170.384 195.153 170.84ZM202.099 170.84C202.099 171.761 202.465 172.644 203.117 173.296C203.768 173.947 204.652 174.313 205.573 174.313C206.494 174.313 207.377 173.947 208.029 173.296C208.68 172.644 209.046 171.761 209.046 170.84C209.046 169.919 208.68 169.035 208.029 168.384C207.377 167.732 206.494 167.366 205.573 167.366C204.652 167.366 203.768 167.732 203.117 168.384C202.465 169.035 202.099 169.919 202.099 170.84ZM209.046 170.84C209.046 171.761 209.412 172.644 210.063 173.296C210.715 173.947 211.598 174.313 212.519 174.313C213.44 174.313 214.324 173.947 214.975 173.296C215.627 172.644 215.993 171.761 215.993 170.84C215.993 169.919 215.627 169.035 214.975 168.384C214.324 167.732 213.44 167.366 212.519 167.366C211.598 167.366 210.715 167.732 210.063 168.384C209.412 169.035 209.046 169.919 209.046 170.84ZM222.939 170.84C222.939 171.761 223.305 172.644 223.957 173.296C224.608 173.947 225.491 174.313 226.413 174.313C227.334 174.313 228.217 173.947 228.868 173.296C229.52 172.644 229.886 171.761 229.886 170.84C229.886 169.919 229.52 169.035 228.868 168.384C228.217 167.732 227.334 167.366 226.413 167.366C225.491 167.366 224.608 167.732 223.957 168.384C223.305 169.035 222.939 169.919 222.939 170.84ZM229.886 170.84C229.886 171.761 230.252 172.644 230.903 173.296C231.554 173.947 232.438 174.313 233.359 174.313C234.28 174.313 235.164 173.947 235.815 173.296C236.466 172.644 236.832 171.761 236.832 170.84C236.832 169.919 236.466 169.035 235.815 168.384C235.164 167.732 234.28 167.366 233.359 167.366C232.438 167.366 231.554 167.732 230.903 168.384C230.252 169.035 229.886 169.919 229.886 170.84ZM243.779 170.84C243.779 171.761 244.145 172.644 244.796 173.296C245.448 173.947 246.331 174.313 247.252 174.313C248.173 174.313 249.057 173.947 249.708 173.296C250.36 172.644 250.726 171.761 250.726 170.84C250.726 169.919 250.36 169.035 249.708 168.384C249.057 167.732 248.173 167.366 247.252 167.366C246.331 167.366 245.448 167.732 244.796 168.384C244.145 169.035 243.779 169.919 243.779 170.84ZM250.726 170.84C250.726 171.761 251.091 172.644 251.743 173.296C252.394 173.947 253.278 174.313 254.199 174.313C255.12 174.313 256.003 173.947 256.655 173.296C257.306 172.644 257.672 171.761 257.672 170.84C257.672 169.919 257.306 169.035 256.655 168.384C256.003 167.732 255.12 167.366 254.199 167.366C253.278 167.366 252.394 167.732 251.743 168.384C251.091 169.035 250.726 169.919 250.726 170.84ZM278.512 170.84C278.512 171.761 278.878 172.644 279.529 173.296C280.181 173.947 281.064 174.313 281.985 174.313C282.906 174.313 283.79 173.947 284.441 173.296C285.093 172.644 285.458 171.761 285.458 170.84C285.458 169.919 285.093 169.035 284.441 168.384C283.79 167.732 282.906 167.366 281.985 167.366C281.064 167.366 280.181 167.732 279.529 168.384C278.878 169.035 278.512 169.919 278.512 170.84ZM14.5416 177.786C14.5416 178.708 14.9075 179.591 15.5589 180.242C16.2102 180.894 17.0937 181.26 18.0149 181.26C18.936 181.26 19.8195 180.894 20.4708 180.242C21.1222 179.591 21.4881 178.708 21.4881 177.786C21.4881 176.865 21.1222 175.982 20.4708 175.33C19.8195 174.679 18.936 174.313 18.0149 174.313C17.0937 174.313 16.2102 174.679 15.5589 175.33C14.9075 175.982 14.5416 176.865 14.5416 177.786ZM21.4881 177.786C21.4881 178.708 21.8541 179.591 22.5055 180.242C23.1568 180.894 24.0403 181.26 24.9614 181.26C25.8826 181.26 26.7661 180.894 27.4174 180.242C28.0688 179.591 28.4347 178.708 28.4347 177.786C28.4347 176.865 28.0688 175.982 27.4174 175.33C26.7661 174.679 25.8826 174.313 24.9614 174.313C24.0403 174.313 23.1568 174.679 22.5055 175.33C21.8541 175.982 21.4881 176.865 21.4881 177.786ZM42.3279 177.786C42.3279 178.242 42.4177 178.694 42.5923 179.116C42.7668 179.537 43.0227 179.92 43.3452 180.242C43.6677 180.565 44.0506 180.821 44.472 180.995C44.8934 181.17 45.3451 181.26 45.8012 181.26C46.2573 181.26 46.709 181.17 47.1304 180.995C47.5518 180.821 47.9347 180.565 48.2572 180.242C48.5797 179.92 48.8356 179.537 49.0101 179.116C49.1847 178.694 49.2745 178.242 49.2745 177.786C49.2745 177.33 49.1847 176.879 49.0101 176.457C48.8356 176.036 48.5797 175.653 48.2572 175.33C47.9347 175.008 47.5518 174.752 47.1304 174.577C46.709 174.403 46.2573 174.313 45.8012 174.313C45.3451 174.313 44.8934 174.403 44.472 174.577C44.0506 174.752 43.6677 175.008 43.3452 175.33C43.0227 175.653 42.7668 176.036 42.5923 176.457C42.4177 176.879 42.3279 177.33 42.3279 177.786ZM49.2745 177.786C49.2745 178.242 49.3643 178.694 49.5389 179.116C49.7134 179.537 49.9693 179.92 50.2918 180.242C50.6143 180.565 50.9972 180.821 51.4186 180.995C51.84 181.17 52.2917 181.26 52.7478 181.26C53.2039 181.26 53.6556 181.17 54.077 180.995C54.4984 180.821 54.8813 180.565 55.2038 180.242C55.5263 179.92 55.7821 179.537 55.9567 179.116C56.1312 178.694 56.2211 178.242 56.2211 177.786C56.2211 177.33 56.1312 176.879 55.9567 176.457C55.7821 176.036 55.5263 175.653 55.2038 175.33C54.8813 175.008 54.4984 174.752 54.077 174.577C53.6556 174.403 53.2039 174.313 52.7478 174.313C52.2917 174.313 51.84 174.403 51.4186 174.577C50.9972 174.752 50.6143 175.008 50.2918 175.33C49.9693 175.653 49.7134 176.036 49.5389 176.457C49.3643 176.879 49.2745 177.33 49.2745 177.786ZM63.1677 177.786C63.1677 178.708 63.5336 179.591 64.185 180.242C64.8363 180.894 65.7198 181.26 66.641 181.26C67.5621 181.26 68.4456 180.894 69.097 180.242C69.7483 179.591 70.1143 178.708 70.1143 177.786C70.1143 176.865 69.7483 175.982 69.097 175.33C68.4456 174.679 67.5621 174.313 66.641 174.313C65.7198 174.313 64.8363 174.679 64.185 175.33C63.5336 175.982 63.1677 176.865 63.1677 177.786ZM77.0609 177.786C77.0609 178.242 77.1507 178.694 77.3252 179.116C77.4998 179.537 77.7556 179.92 78.0782 180.242C78.4007 180.565 78.7836 180.821 79.205 180.995C79.6264 181.17 80.078 181.26 80.5341 181.26C80.9903 181.26 81.4419 181.17 81.8633 180.995C82.2847 180.821 82.6676 180.565 82.9901 180.242C83.3127 179.92 83.5685 179.537 83.743 179.116C83.9176 178.694 84.0074 178.242 84.0074 177.786C84.0074 177.33 83.9176 176.879 83.743 176.457C83.5685 176.036 83.3127 175.653 82.9901 175.33C82.6676 175.008 82.2847 174.752 81.8633 174.577C81.4419 174.403 80.9903 174.313 80.5341 174.313C80.078 174.313 79.6264 174.403 79.205 174.577C78.7836 174.752 78.4007 175.008 78.0782 175.33C77.7556 175.653 77.4998 176.036 77.3252 176.457C77.1507 176.879 77.0609 177.33 77.0609 177.786ZM90.954 177.786C90.954 178.708 91.32 179.591 91.9713 180.242C92.6227 180.894 93.5061 181.26 94.4273 181.26C95.3485 181.26 96.2319 180.894 96.8833 180.242C97.5347 179.591 97.9006 178.708 97.9006 177.786C97.9006 176.865 97.5347 175.982 96.8833 175.33C96.2319 174.679 95.3485 174.313 94.4273 174.313C93.5061 174.313 92.6227 174.679 91.9713 175.33C91.32 175.982 90.954 176.865 90.954 177.786ZM97.9006 177.786C97.9006 178.242 97.9905 178.694 98.165 179.116C98.3396 179.537 98.5954 179.92 98.9179 180.242C99.2404 180.565 99.6233 180.821 100.045 180.995C100.466 181.17 100.918 181.26 101.374 181.26C101.83 181.26 102.282 181.17 102.703 180.995C103.124 180.821 103.507 180.565 103.83 180.242C104.152 179.92 104.408 179.537 104.583 179.116C104.757 178.694 104.847 178.242 104.847 177.786C104.847 177.33 104.757 176.879 104.583 176.457C104.408 176.036 104.152 175.653 103.83 175.33C103.507 175.008 103.124 174.752 102.703 174.577C102.282 174.403 101.83 174.313 101.374 174.313C100.918 174.313 100.466 174.403 100.045 174.577C99.6233 174.752 99.2404 175.008 98.9179 175.33C98.5954 175.653 98.3396 176.036 98.165 176.457C97.9905 176.879 97.9006 177.33 97.9006 177.786ZM118.74 177.786C118.74 178.708 119.106 179.591 119.758 180.242C120.409 180.894 121.292 181.26 122.214 181.26C123.135 181.26 124.018 180.894 124.67 180.242C125.321 179.591 125.687 178.708 125.687 177.786C125.687 176.865 125.321 175.982 124.67 175.33C124.018 174.679 123.135 174.313 122.214 174.313C121.292 174.313 120.409 174.679 119.758 175.33C119.106 175.982 118.74 176.865 118.74 177.786ZM125.687 177.786C125.687 178.708 126.053 179.591 126.704 180.242C127.356 180.894 128.239 181.26 129.16 181.26C130.081 181.26 130.965 180.894 131.616 180.242C132.268 179.591 132.634 178.708 132.634 177.786C132.634 176.865 132.268 175.982 131.616 175.33C130.965 174.679 130.081 174.313 129.16 174.313C128.239 174.313 127.356 174.679 126.704 175.33C126.053 175.982 125.687 176.865 125.687 177.786ZM132.634 177.786C132.634 178.708 132.999 179.591 133.651 180.242C134.302 180.894 135.186 181.26 136.107 181.26C137.028 181.26 137.911 180.894 138.563 180.242C139.214 179.591 139.58 178.708 139.58 177.786C139.58 176.865 139.214 175.982 138.563 175.33C137.911 174.679 137.028 174.313 136.107 174.313C135.186 174.313 134.302 174.679 133.651 175.33C132.999 175.982 132.634 176.865 132.634 177.786ZM139.58 177.786C139.58 178.708 139.946 179.591 140.597 180.242C141.249 180.894 142.132 181.26 143.053 181.26C143.975 181.26 144.858 180.894 145.509 180.242C146.161 179.591 146.527 178.708 146.527 177.786C146.527 176.865 146.161 175.982 145.509 175.33C144.858 174.679 143.975 174.313 143.053 174.313C142.132 174.313 141.249 174.679 140.597 175.33C139.946 175.982 139.58 176.865 139.58 177.786ZM174.313 177.786C174.313 178.708 174.679 179.591 175.33 180.242C175.982 180.894 176.865 181.26 177.786 181.26C178.708 181.26 179.591 180.894 180.242 180.242C180.894 179.591 181.26 178.708 181.26 177.786C181.26 176.865 180.894 175.982 180.242 175.33C179.591 174.679 178.708 174.313 177.786 174.313C176.865 174.313 175.982 174.679 175.33 175.33C174.679 175.982 174.313 176.865 174.313 177.786ZM181.26 177.786C181.26 178.708 181.626 179.591 182.277 180.242C182.928 180.894 183.812 181.26 184.733 181.26C185.654 181.26 186.538 180.894 187.189 180.242C187.84 179.591 188.206 178.708 188.206 177.786C188.206 176.865 187.84 175.982 187.189 175.33C186.538 174.679 185.654 174.313 184.733 174.313C183.812 174.313 182.928 174.679 182.277 175.33C181.626 175.982 181.26 176.865 181.26 177.786ZM188.206 177.786C188.206 178.708 188.572 179.591 189.224 180.242C189.875 180.894 190.758 181.26 191.68 181.26C192.601 181.26 193.484 180.894 194.136 180.242C194.787 179.591 195.153 178.708 195.153 177.786C195.153 176.865 194.787 175.982 194.136 175.33C193.484 174.679 192.601 174.313 191.68 174.313C190.758 174.313 189.875 174.679 189.224 175.33C188.572 175.982 188.206 176.865 188.206 177.786ZM195.153 177.786C195.153 178.242 195.243 178.694 195.417 179.116C195.592 179.537 195.848 179.92 196.17 180.242C196.493 180.565 196.876 180.821 197.297 180.995C197.718 181.17 198.17 181.26 198.626 181.26C199.082 181.26 199.534 181.17 199.955 180.995C200.377 180.821 200.76 180.565 201.082 180.242C201.405 179.92 201.661 179.537 201.835 179.116C202.01 178.694 202.099 178.242 202.099 177.786C202.099 177.33 202.01 176.879 201.835 176.457C201.661 176.036 201.405 175.653 201.082 175.33C200.76 175.008 200.377 174.752 199.955 174.577C199.534 174.403 199.082 174.313 198.626 174.313C198.17 174.313 197.718 174.403 197.297 174.577C196.876 174.752 196.493 175.008 196.17 175.33C195.848 175.653 195.592 176.036 195.417 176.457C195.243 176.879 195.153 177.33 195.153 177.786ZM202.099 177.786C202.099 178.708 202.465 179.591 203.117 180.242C203.768 180.894 204.652 181.26 205.573 181.26C206.494 181.26 207.377 180.894 208.029 180.242C208.68 179.591 209.046 178.708 209.046 177.786C209.046 176.865 208.68 175.982 208.029 175.33C207.377 174.679 206.494 174.313 205.573 174.313C204.652 174.313 203.768 174.679 203.117 175.33C202.465 175.982 202.099 176.865 202.099 177.786ZM209.046 177.786C209.046 178.708 209.412 179.591 210.063 180.242C210.715 180.894 211.598 181.26 212.519 181.26C213.44 181.26 214.324 180.894 214.975 180.242C215.627 179.591 215.993 178.708 215.993 177.786C215.993 176.865 215.627 175.982 214.975 175.33C214.324 174.679 213.44 174.313 212.519 174.313C211.598 174.313 210.715 174.679 210.063 175.33C209.412 175.982 209.046 176.865 209.046 177.786ZM229.886 177.786C229.886 178.708 230.252 179.591 230.903 180.242C231.554 180.894 232.438 181.26 233.359 181.26C234.28 181.26 235.164 180.894 235.815 180.242C236.466 179.591 236.832 178.708 236.832 177.786C236.832 176.865 236.466 175.982 235.815 175.33C235.164 174.679 234.28 174.313 233.359 174.313C232.438 174.313 231.554 174.679 230.903 175.33C230.252 175.982 229.886 176.865 229.886 177.786ZM250.726 177.786C250.726 178.708 251.091 179.591 251.743 180.242C252.394 180.894 253.278 181.26 254.199 181.26C255.12 181.26 256.003 180.894 256.655 180.242C257.306 179.591 257.672 178.708 257.672 177.786C257.672 176.865 257.306 175.982 256.655 175.33C256.003 174.679 255.12 174.313 254.199 174.313C253.278 174.313 252.394 174.679 251.743 175.33C251.091 175.982 250.726 176.865 250.726 177.786ZM264.619 177.786C264.619 178.708 264.985 179.591 265.636 180.242C266.287 180.894 267.171 181.26 268.092 181.26C269.013 181.26 269.897 180.894 270.548 180.242C271.199 179.591 271.565 178.708 271.565 177.786C271.565 176.865 271.199 175.982 270.548 175.33C269.897 174.679 269.013 174.313 268.092 174.313C267.171 174.313 266.287 174.679 265.636 175.33C264.985 175.982 264.619 176.865 264.619 177.786ZM271.565 177.786C271.565 178.708 271.931 179.591 272.583 180.242C273.234 180.894 274.117 181.26 275.039 181.26C275.96 181.26 276.843 180.894 277.495 180.242C278.146 179.591 278.512 178.708 278.512 177.786C278.512 176.865 278.146 175.982 277.495 175.33C276.843 174.679 275.96 174.313 275.039 174.313C274.117 174.313 273.234 174.679 272.583 175.33C271.931 175.982 271.565 176.865 271.565 177.786ZM278.512 177.786C278.512 178.708 278.878 179.591 279.529 180.242C280.181 180.894 281.064 181.26 281.985 181.26C282.906 181.26 283.79 180.894 284.441 180.242C285.093 179.591 285.458 178.708 285.458 177.786C285.458 176.865 285.093 175.982 284.441 175.33C283.79 174.679 282.906 174.313 281.985 174.313C281.064 174.313 280.181 174.679 279.529 175.33C278.878 175.982 278.512 176.865 278.512 177.786ZM285.458 177.786C285.458 178.708 285.824 179.591 286.476 180.242C287.127 180.894 288.011 181.26 288.932 181.26C289.853 181.26 290.736 180.894 291.388 180.242C292.039 179.591 292.405 178.708 292.405 177.786C292.405 176.865 292.039 175.982 291.388 175.33C290.736 174.679 289.853 174.313 288.932 174.313C288.011 174.313 287.127 174.679 286.476 175.33C285.824 175.982 285.458 176.865 285.458 177.786ZM7.59497 184.733C7.59497 185.654 7.96091 186.538 8.61227 187.189C9.26364 187.84 10.1471 188.206 11.0683 188.206C11.9894 188.206 12.8729 187.84 13.5243 187.189C14.1756 186.538 14.5416 185.654 14.5416 184.733C14.5416 183.812 14.1756 182.928 13.5243 182.277C12.8729 181.626 11.9894 181.26 11.0683 181.26C10.1471 181.26 9.26364 181.626 8.61227 182.277C7.96091 182.928 7.59497 183.812 7.59497 184.733ZM28.4347 184.733C28.4347 185.654 28.8007 186.538 29.452 187.189C30.1034 187.84 30.9869 188.206 31.908 188.206C32.8292 188.206 33.7126 187.84 34.364 187.189C35.0154 186.538 35.3813 185.654 35.3813 184.733C35.3813 183.812 35.0154 182.928 34.364 182.277C33.7126 181.626 32.8292 181.26 31.908 181.26C30.9869 181.26 30.1034 181.626 29.452 182.277C28.8007 182.928 28.4347 183.812 28.4347 184.733ZM35.3813 184.733C35.3813 185.654 35.7473 186.538 36.3986 187.189C37.05 187.84 37.9334 188.206 38.8546 188.206C39.7758 188.206 40.6592 187.84 41.3106 187.189C41.962 186.538 42.3279 185.654 42.3279 184.733C42.3279 183.812 41.962 182.928 41.3106 182.277C40.6592 181.626 39.7758 181.26 38.8546 181.26C37.9334 181.26 37.05 181.626 36.3986 182.277C35.7473 182.928 35.3813 183.812 35.3813 184.733ZM42.3279 184.733C42.3279 185.189 42.4177 185.641 42.5923 186.062C42.7668 186.484 43.0227 186.866 43.3452 187.189C43.6677 187.511 44.0506 187.767 44.472 187.942C44.8934 188.116 45.3451 188.206 45.8012 188.206C46.2573 188.206 46.709 188.116 47.1304 187.942C47.5518 187.767 47.9347 187.511 48.2572 187.189C48.5797 186.866 48.8356 186.484 49.0101 186.062C49.1847 185.641 49.2745 185.189 49.2745 184.733C49.2745 184.277 49.1847 183.825 49.0101 183.404C48.8356 182.982 48.5797 182.599 48.2572 182.277C47.9347 181.954 47.5518 181.699 47.1304 181.524C46.709 181.349 46.2573 181.26 45.8012 181.26C45.3451 181.26 44.8934 181.349 44.472 181.524C44.0506 181.699 43.6677 181.954 43.3452 182.277C43.0227 182.599 42.7668 182.982 42.5923 183.404C42.4177 183.825 42.3279 184.277 42.3279 184.733ZM56.2211 184.733C56.2211 185.654 56.587 186.538 57.2384 187.189C57.8898 187.84 58.7732 188.206 59.6944 188.206C60.6156 188.206 61.499 187.84 62.1504 187.189C62.8017 186.538 63.1677 185.654 63.1677 184.733C63.1677 183.812 62.8017 182.928 62.1504 182.277C61.499 181.626 60.6156 181.26 59.6944 181.26C58.7732 181.26 57.8898 181.626 57.2384 182.277C56.587 182.928 56.2211 183.812 56.2211 184.733ZM77.0609 184.733C77.0609 185.189 77.1507 185.641 77.3252 186.062C77.4998 186.484 77.7556 186.866 78.0782 187.189C78.4007 187.511 78.7836 187.767 79.205 187.942C79.6264 188.116 80.078 188.206 80.5341 188.206C80.9903 188.206 81.4419 188.116 81.8633 187.942C82.2847 187.767 82.6676 187.511 82.9901 187.189C83.3127 186.866 83.5685 186.484 83.743 186.062C83.9176 185.641 84.0074 185.189 84.0074 184.733C84.0074 184.277 83.9176 183.825 83.743 183.404C83.5685 182.982 83.3127 182.599 82.9901 182.277C82.6676 181.954 82.2847 181.699 81.8633 181.524C81.4419 181.349 80.9903 181.26 80.5341 181.26C80.078 181.26 79.6264 181.349 79.205 181.524C78.7836 181.699 78.4007 181.954 78.0782 182.277C77.7556 182.599 77.4998 182.982 77.3252 183.404C77.1507 183.825 77.0609 184.277 77.0609 184.733ZM84.0074 184.733C84.0074 185.654 84.3734 186.538 85.0247 187.189C85.6761 187.84 86.5596 188.206 87.4807 188.206C88.4019 188.206 89.2854 187.84 89.9367 187.189C90.5881 186.538 90.954 185.654 90.954 184.733C90.954 183.812 90.5881 182.928 89.9367 182.277C89.2854 181.626 88.4019 181.26 87.4807 181.26C86.5596 181.26 85.6761 181.626 85.0247 182.277C84.3734 182.928 84.0074 183.812 84.0074 184.733ZM125.687 184.733C125.687 185.654 126.053 186.538 126.704 187.189C127.356 187.84 128.239 188.206 129.16 188.206C130.081 188.206 130.965 187.84 131.616 187.189C132.268 186.538 132.634 185.654 132.634 184.733C132.634 183.812 132.268 182.928 131.616 182.277C130.965 181.626 130.081 181.26 129.16 181.26C128.239 181.26 127.356 181.626 126.704 182.277C126.053 182.928 125.687 183.812 125.687 184.733ZM132.634 184.733C132.634 185.654 132.999 186.538 133.651 187.189C134.302 187.84 135.186 188.206 136.107 188.206C137.028 188.206 137.911 187.84 138.563 187.189C139.214 186.538 139.58 185.654 139.58 184.733C139.58 183.812 139.214 182.928 138.563 182.277C137.911 181.626 137.028 181.26 136.107 181.26C135.186 181.26 134.302 181.626 133.651 182.277C132.999 182.928 132.634 183.812 132.634 184.733ZM146.527 184.733C146.527 185.654 146.893 186.538 147.544 187.189C148.195 187.84 149.079 188.206 150 188.206C150.921 188.206 151.805 187.84 152.456 187.189C153.107 186.538 153.473 185.654 153.473 184.733C153.473 183.812 153.107 182.928 152.456 182.277C151.805 181.626 150.921 181.26 150 181.26C149.079 181.26 148.195 181.626 147.544 182.277C146.893 182.928 146.527 183.812 146.527 184.733ZM174.313 184.733C174.313 185.654 174.679 186.538 175.33 187.189C175.982 187.84 176.865 188.206 177.786 188.206C178.708 188.206 179.591 187.84 180.242 187.189C180.894 186.538 181.26 185.654 181.26 184.733C181.26 183.812 180.894 182.928 180.242 182.277C179.591 181.626 178.708 181.26 177.786 181.26C176.865 181.26 175.982 181.626 175.33 182.277C174.679 182.928 174.313 183.812 174.313 184.733ZM195.153 184.733C195.153 185.189 195.243 185.641 195.417 186.062C195.592 186.484 195.848 186.866 196.17 187.189C196.493 187.511 196.876 187.767 197.297 187.942C197.718 188.116 198.17 188.206 198.626 188.206C199.082 188.206 199.534 188.116 199.955 187.942C200.377 187.767 200.76 187.511 201.082 187.189C201.405 186.866 201.661 186.484 201.835 186.062C202.01 185.641 202.099 185.189 202.099 184.733C202.099 184.277 202.01 183.825 201.835 183.404C201.661 182.982 201.405 182.599 201.082 182.277C200.76 181.954 200.377 181.699 199.955 181.524C199.534 181.349 199.082 181.26 198.626 181.26C198.17 181.26 197.718 181.349 197.297 181.524C196.876 181.699 196.493 181.954 196.17 182.277C195.848 182.599 195.592 182.982 195.417 183.404C195.243 183.825 195.153 184.277 195.153 184.733ZM202.099 184.733C202.099 185.654 202.465 186.538 203.117 187.189C203.768 187.84 204.652 188.206 205.573 188.206C206.494 188.206 207.377 187.84 208.029 187.189C208.68 186.538 209.046 185.654 209.046 184.733C209.046 183.812 208.68 182.928 208.029 182.277C207.377 181.626 206.494 181.26 205.573 181.26C204.652 181.26 203.768 181.626 203.117 182.277C202.465 182.928 202.099 183.812 202.099 184.733ZM215.993 184.733C215.993 185.654 216.359 186.538 217.01 187.189C217.661 187.84 218.545 188.206 219.466 188.206C220.387 188.206 221.271 187.84 221.922 187.189C222.573 186.538 222.939 185.654 222.939 184.733C222.939 183.812 222.573 182.928 221.922 182.277C221.271 181.626 220.387 181.26 219.466 181.26C218.545 181.26 217.661 181.626 217.01 182.277C216.359 182.928 215.993 183.812 215.993 184.733ZM229.886 184.733C229.886 185.654 230.252 186.538 230.903 187.189C231.554 187.84 232.438 188.206 233.359 188.206C234.28 188.206 235.164 187.84 235.815 187.189C236.466 186.538 236.832 185.654 236.832 184.733C236.832 183.812 236.466 182.928 235.815 182.277C235.164 181.626 234.28 181.26 233.359 181.26C232.438 181.26 231.554 181.626 230.903 182.277C230.252 182.928 229.886 183.812 229.886 184.733ZM236.832 184.733C236.832 185.654 237.198 186.538 237.85 187.189C238.501 187.84 239.384 188.206 240.306 188.206C241.227 188.206 242.11 187.84 242.762 187.189C243.413 186.538 243.779 185.654 243.779 184.733C243.779 183.812 243.413 182.928 242.762 182.277C242.11 181.626 241.227 181.26 240.306 181.26C239.384 181.26 238.501 181.626 237.85 182.277C237.198 182.928 236.832 183.812 236.832 184.733ZM243.779 184.733C243.779 185.654 244.145 186.538 244.796 187.189C245.448 187.84 246.331 188.206 247.252 188.206C248.173 188.206 249.057 187.84 249.708 187.189C250.36 186.538 250.726 185.654 250.726 184.733C250.726 183.812 250.36 182.928 249.708 182.277C249.057 181.626 248.173 181.26 247.252 181.26C246.331 181.26 245.448 181.626 244.796 182.277C244.145 182.928 243.779 183.812 243.779 184.733ZM257.672 184.733C257.672 185.654 258.038 186.538 258.689 187.189C259.341 187.84 260.224 188.206 261.145 188.206C262.067 188.206 262.95 187.84 263.601 187.189C264.253 186.538 264.619 185.654 264.619 184.733C264.619 183.812 264.253 182.928 263.601 182.277C262.95 181.626 262.067 181.26 261.145 181.26C260.224 181.26 259.341 181.626 258.689 182.277C258.038 182.928 257.672 183.812 257.672 184.733ZM271.565 184.733C271.565 185.654 271.931 186.538 272.583 187.189C273.234 187.84 274.117 188.206 275.039 188.206C275.96 188.206 276.843 187.84 277.495 187.189C278.146 186.538 278.512 185.654 278.512 184.733C278.512 183.812 278.146 182.928 277.495 182.277C276.843 181.626 275.96 181.26 275.039 181.26C274.117 181.26 273.234 181.626 272.583 182.277C271.931 182.928 271.565 183.812 271.565 184.733ZM285.458 184.733C285.458 185.654 285.824 186.538 286.476 187.189C287.127 187.84 288.011 188.206 288.932 188.206C289.853 188.206 290.736 187.84 291.388 187.189C292.039 186.538 292.405 185.654 292.405 184.733C292.405 183.812 292.039 182.928 291.388 182.277C290.736 181.626 289.853 181.26 288.932 181.26C288.011 181.26 287.127 181.626 286.476 182.277C285.824 182.928 285.458 183.812 285.458 184.733ZM7.59497 191.68C7.59497 192.601 7.96091 193.484 8.61227 194.136C9.26364 194.787 10.1471 195.153 11.0683 195.153C11.9894 195.153 12.8729 194.787 13.5243 194.136C14.1756 193.484 14.5416 192.601 14.5416 191.68C14.5416 190.758 14.1756 189.875 13.5243 189.224C12.8729 188.572 11.9894 188.206 11.0683 188.206C10.1471 188.206 9.26364 188.572 8.61227 189.224C7.96091 189.875 7.59497 190.758 7.59497 191.68ZM14.5416 191.68C14.5416 192.601 14.9075 193.484 15.5589 194.136C16.2102 194.787 17.0937 195.153 18.0149 195.153C18.936 195.153 19.8195 194.787 20.4708 194.136C21.1222 193.484 21.4881 192.601 21.4881 191.68C21.4881 190.758 21.1222 189.875 20.4708 189.224C19.8195 188.572 18.936 188.206 18.0149 188.206C17.0937 188.206 16.2102 188.572 15.5589 189.224C14.9075 189.875 14.5416 190.758 14.5416 191.68ZM21.4881 191.68C21.4881 192.601 21.8541 193.484 22.5055 194.136C23.1568 194.787 24.0403 195.153 24.9614 195.153C25.8826 195.153 26.7661 194.787 27.4174 194.136C28.0688 193.484 28.4347 192.601 28.4347 191.68C28.4347 190.758 28.0688 189.875 27.4174 189.224C26.7661 188.572 25.8826 188.206 24.9614 188.206C24.0403 188.206 23.1568 188.572 22.5055 189.224C21.8541 189.875 21.4881 190.758 21.4881 191.68ZM28.4347 191.68C28.4347 192.601 28.8007 193.484 29.452 194.136C30.1034 194.787 30.9869 195.153 31.908 195.153C32.8292 195.153 33.7126 194.787 34.364 194.136C35.0154 193.484 35.3813 192.601 35.3813 191.68C35.3813 190.758 35.0154 189.875 34.364 189.224C33.7126 188.572 32.8292 188.206 31.908 188.206C30.9869 188.206 30.1034 188.572 29.452 189.224C28.8007 189.875 28.4347 190.758 28.4347 191.68ZM42.3279 191.68C42.3279 192.136 42.4177 192.587 42.5923 193.009C42.7668 193.43 43.0227 193.813 43.3452 194.136C43.6677 194.458 44.0506 194.714 44.472 194.888C44.8934 195.063 45.3451 195.153 45.8012 195.153C46.2573 195.153 46.709 195.063 47.1304 194.888C47.5518 194.714 47.9347 194.458 48.2572 194.136C48.5797 193.813 48.8356 193.43 49.0101 193.009C49.1847 192.587 49.2745 192.136 49.2745 191.68C49.2745 191.223 49.1847 190.772 49.0101 190.35C48.8356 189.929 48.5797 189.546 48.2572 189.224C47.9347 188.901 47.5518 188.645 47.1304 188.471C46.709 188.296 46.2573 188.206 45.8012 188.206C45.3451 188.206 44.8934 188.296 44.472 188.471C44.0506 188.645 43.6677 188.901 43.3452 189.224C43.0227 189.546 42.7668 189.929 42.5923 190.35C42.4177 190.772 42.3279 191.223 42.3279 191.68ZM49.2745 191.68C49.2745 192.136 49.3643 192.587 49.5389 193.009C49.7134 193.43 49.9693 193.813 50.2918 194.136C50.6143 194.458 50.9972 194.714 51.4186 194.888C51.84 195.063 52.2917 195.153 52.7478 195.153C53.2039 195.153 53.6556 195.063 54.077 194.888C54.4984 194.714 54.8813 194.458 55.2038 194.136C55.5263 193.813 55.7821 193.43 55.9567 193.009C56.1312 192.587 56.2211 192.136 56.2211 191.68C56.2211 191.223 56.1312 190.772 55.9567 190.35C55.7821 189.929 55.5263 189.546 55.2038 189.224C54.8813 188.901 54.4984 188.645 54.077 188.471C53.6556 188.296 53.2039 188.206 52.7478 188.206C52.2917 188.206 51.84 188.296 51.4186 188.471C50.9972 188.645 50.6143 188.901 50.2918 189.224C49.9693 189.546 49.7134 189.929 49.5389 190.35C49.3643 190.772 49.2745 191.223 49.2745 191.68ZM56.2211 191.68C56.2211 192.601 56.587 193.484 57.2384 194.136C57.8898 194.787 58.7732 195.153 59.6944 195.153C60.6156 195.153 61.499 194.787 62.1504 194.136C62.8017 193.484 63.1677 192.601 63.1677 191.68C63.1677 190.758 62.8017 189.875 62.1504 189.224C61.499 188.572 60.6156 188.206 59.6944 188.206C58.7732 188.206 57.8898 188.572 57.2384 189.224C56.587 189.875 56.2211 190.758 56.2211 191.68ZM77.0609 191.68C77.0609 192.136 77.1507 192.587 77.3252 193.009C77.4998 193.43 77.7556 193.813 78.0782 194.136C78.4007 194.458 78.7836 194.714 79.205 194.888C79.6264 195.063 80.078 195.153 80.5341 195.153C80.9903 195.153 81.4419 195.063 81.8633 194.888C82.2847 194.714 82.6676 194.458 82.9901 194.136C83.3127 193.813 83.5685 193.43 83.743 193.009C83.9176 192.587 84.0074 192.136 84.0074 191.68C84.0074 191.223 83.9176 190.772 83.743 190.35C83.5685 189.929 83.3127 189.546 82.9901 189.224C82.6676 188.901 82.2847 188.645 81.8633 188.471C81.4419 188.296 80.9903 188.206 80.5341 188.206C80.078 188.206 79.6264 188.296 79.205 188.471C78.7836 188.645 78.4007 188.901 78.0782 189.224C77.7556 189.546 77.4998 189.929 77.3252 190.35C77.1507 190.772 77.0609 191.223 77.0609 191.68ZM84.0074 191.68C84.0074 192.601 84.3734 193.484 85.0247 194.136C85.6761 194.787 86.5596 195.153 87.4807 195.153C88.4019 195.153 89.2854 194.787 89.9367 194.136C90.5881 193.484 90.954 192.601 90.954 191.68C90.954 190.758 90.5881 189.875 89.9367 189.224C89.2854 188.572 88.4019 188.206 87.4807 188.206C86.5596 188.206 85.6761 188.572 85.0247 189.224C84.3734 189.875 84.0074 190.758 84.0074 191.68ZM90.954 191.68C90.954 192.601 91.32 193.484 91.9713 194.136C92.6227 194.787 93.5061 195.153 94.4273 195.153C95.3485 195.153 96.2319 194.787 96.8833 194.136C97.5347 193.484 97.9006 192.601 97.9006 191.68C97.9006 190.758 97.5347 189.875 96.8833 189.224C96.2319 188.572 95.3485 188.206 94.4273 188.206C93.5061 188.206 92.6227 188.572 91.9713 189.224C91.32 189.875 90.954 190.758 90.954 191.68ZM97.9006 191.68C97.9006 192.136 97.9905 192.587 98.165 193.009C98.3396 193.43 98.5954 193.813 98.9179 194.136C99.2404 194.458 99.6233 194.714 100.045 194.888C100.466 195.063 100.918 195.153 101.374 195.153C101.83 195.153 102.282 195.063 102.703 194.888C103.124 194.714 103.507 194.458 103.83 194.136C104.152 193.813 104.408 193.43 104.583 193.009C104.757 192.587 104.847 192.136 104.847 191.68C104.847 191.223 104.757 190.772 104.583 190.35C104.408 189.929 104.152 189.546 103.83 189.224C103.507 188.901 103.124 188.645 102.703 188.471C102.282 188.296 101.83 188.206 101.374 188.206C100.918 188.206 100.466 188.296 100.045 188.471C99.6233 188.645 99.2404 188.901 98.9179 189.224C98.5954 189.546 98.3396 189.929 98.165 190.35C97.9905 190.772 97.9006 191.223 97.9006 191.68ZM104.847 191.68C104.847 192.601 105.213 193.484 105.865 194.136C106.516 194.787 107.399 195.153 108.321 195.153C109.242 195.153 110.125 194.787 110.776 194.136C111.428 193.484 111.794 192.601 111.794 191.68C111.794 190.758 111.428 189.875 110.776 189.224C110.125 188.572 109.242 188.206 108.321 188.206C107.399 188.206 106.516 188.572 105.865 189.224C105.213 189.875 104.847 190.758 104.847 191.68ZM111.794 191.68C111.794 192.601 112.16 193.484 112.811 194.136C113.462 194.787 114.346 195.153 115.267 195.153C116.188 195.153 117.072 194.787 117.723 194.136C118.374 193.484 118.74 192.601 118.74 191.68C118.74 190.758 118.374 189.875 117.723 189.224C117.072 188.572 116.188 188.206 115.267 188.206C114.346 188.206 113.462 188.572 112.811 189.224C112.16 189.875 111.794 190.758 111.794 191.68ZM118.74 191.68C118.74 192.601 119.106 193.484 119.758 194.136C120.409 194.787 121.292 195.153 122.214 195.153C123.135 195.153 124.018 194.787 124.67 194.136C125.321 193.484 125.687 192.601 125.687 191.68C125.687 190.758 125.321 189.875 124.67 189.224C124.018 188.572 123.135 188.206 122.214 188.206C121.292 188.206 120.409 188.572 119.758 189.224C119.106 189.875 118.74 190.758 118.74 191.68ZM125.687 191.68C125.687 192.601 126.053 193.484 126.704 194.136C127.356 194.787 128.239 195.153 129.16 195.153C130.081 195.153 130.965 194.787 131.616 194.136C132.268 193.484 132.634 192.601 132.634 191.68C132.634 190.758 132.268 189.875 131.616 189.224C130.965 188.572 130.081 188.206 129.16 188.206C128.239 188.206 127.356 188.572 126.704 189.224C126.053 189.875 125.687 190.758 125.687 191.68ZM146.527 191.68C146.527 192.601 146.893 193.484 147.544 194.136C148.195 194.787 149.079 195.153 150 195.153C150.921 195.153 151.805 194.787 152.456 194.136C153.107 193.484 153.473 192.601 153.473 191.68C153.473 190.758 153.107 189.875 152.456 189.224C151.805 188.572 150.921 188.206 150 188.206C149.079 188.206 148.195 188.572 147.544 189.224C146.893 189.875 146.527 190.758 146.527 191.68ZM153.473 191.68C153.473 192.136 153.563 192.587 153.738 193.009C153.912 193.43 154.168 193.813 154.491 194.136C154.813 194.458 155.196 194.714 155.617 194.888C156.039 195.063 156.491 195.153 156.947 195.153C157.403 195.153 157.854 195.063 158.276 194.888C158.697 194.714 159.08 194.458 159.403 194.136C159.725 193.813 159.981 193.43 160.156 193.009C160.33 192.587 160.42 192.136 160.42 191.68C160.42 191.223 160.33 190.772 160.156 190.35C159.981 189.929 159.725 189.546 159.403 189.224C159.08 188.901 158.697 188.645 158.276 188.471C157.854 188.296 157.403 188.206 156.947 188.206C156.491 188.206 156.039 188.296 155.617 188.471C155.196 188.645 154.813 188.901 154.491 189.224C154.168 189.546 153.912 189.929 153.738 190.35C153.563 190.772 153.473 191.223 153.473 191.68ZM160.42 191.68C160.42 192.601 160.786 193.484 161.437 194.136C162.089 194.787 162.972 195.153 163.893 195.153C164.814 195.153 165.698 194.787 166.349 194.136C167.001 193.484 167.366 192.601 167.366 191.68C167.366 190.758 167.001 189.875 166.349 189.224C165.698 188.572 164.814 188.206 163.893 188.206C162.972 188.206 162.089 188.572 161.437 189.224C160.786 189.875 160.42 190.758 160.42 191.68ZM167.366 191.68C167.366 192.601 167.732 193.484 168.384 194.136C169.035 194.787 169.919 195.153 170.84 195.153C171.761 195.153 172.644 194.787 173.296 194.136C173.947 193.484 174.313 192.601 174.313 191.68C174.313 190.758 173.947 189.875 173.296 189.224C172.644 188.572 171.761 188.206 170.84 188.206C169.919 188.206 169.035 188.572 168.384 189.224C167.732 189.875 167.366 190.758 167.366 191.68ZM188.206 191.68C188.206 192.601 188.572 193.484 189.224 194.136C189.875 194.787 190.758 195.153 191.68 195.153C192.601 195.153 193.484 194.787 194.136 194.136C194.787 193.484 195.153 192.601 195.153 191.68C195.153 190.758 194.787 189.875 194.136 189.224C193.484 188.572 192.601 188.206 191.68 188.206C190.758 188.206 189.875 188.572 189.224 189.224C188.572 189.875 188.206 190.758 188.206 191.68ZM195.153 191.68C195.153 192.136 195.243 192.587 195.417 193.009C195.592 193.43 195.848 193.813 196.17 194.136C196.493 194.458 196.876 194.714 197.297 194.888C197.718 195.063 198.17 195.153 198.626 195.153C199.082 195.153 199.534 195.063 199.955 194.888C200.377 194.714 200.76 194.458 201.082 194.136C201.405 193.813 201.661 193.43 201.835 193.009C202.01 192.587 202.099 192.136 202.099 191.68C202.099 191.223 202.01 190.772 201.835 190.35C201.661 189.929 201.405 189.546 201.082 189.224C200.76 188.901 200.377 188.645 199.955 188.471C199.534 188.296 199.082 188.206 198.626 188.206C198.17 188.206 197.718 188.296 197.297 188.471C196.876 188.645 196.493 188.901 196.17 189.224C195.848 189.546 195.592 189.929 195.417 190.35C195.243 190.772 195.153 191.223 195.153 191.68ZM209.046 191.68C209.046 192.601 209.412 193.484 210.063 194.136C210.715 194.787 211.598 195.153 212.519 195.153C213.44 195.153 214.324 194.787 214.975 194.136C215.627 193.484 215.993 192.601 215.993 191.68C215.993 190.758 215.627 189.875 214.975 189.224C214.324 188.572 213.44 188.206 212.519 188.206C211.598 188.206 210.715 188.572 210.063 189.224C209.412 189.875 209.046 190.758 209.046 191.68ZM215.993 191.68C215.993 192.601 216.359 193.484 217.01 194.136C217.661 194.787 218.545 195.153 219.466 195.153C220.387 195.153 221.271 194.787 221.922 194.136C222.573 193.484 222.939 192.601 222.939 191.68C222.939 190.758 222.573 189.875 221.922 189.224C221.271 188.572 220.387 188.206 219.466 188.206C218.545 188.206 217.661 188.572 217.01 189.224C216.359 189.875 215.993 190.758 215.993 191.68ZM229.886 191.68C229.886 192.601 230.252 193.484 230.903 194.136C231.554 194.787 232.438 195.153 233.359 195.153C234.28 195.153 235.164 194.787 235.815 194.136C236.466 193.484 236.832 192.601 236.832 191.68C236.832 190.758 236.466 189.875 235.815 189.224C235.164 188.572 234.28 188.206 233.359 188.206C232.438 188.206 231.554 188.572 230.903 189.224C230.252 189.875 229.886 190.758 229.886 191.68ZM236.832 191.68C236.832 192.601 237.198 193.484 237.85 194.136C238.501 194.787 239.384 195.153 240.306 195.153C241.227 195.153 242.11 194.787 242.762 194.136C243.413 193.484 243.779 192.601 243.779 191.68C243.779 190.758 243.413 189.875 242.762 189.224C242.11 188.572 241.227 188.206 240.306 188.206C239.384 188.206 238.501 188.572 237.85 189.224C237.198 189.875 236.832 190.758 236.832 191.68ZM243.779 191.68C243.779 192.601 244.145 193.484 244.796 194.136C245.448 194.787 246.331 195.153 247.252 195.153C248.173 195.153 249.057 194.787 249.708 194.136C250.36 193.484 250.726 192.601 250.726 191.68C250.726 190.758 250.36 189.875 249.708 189.224C249.057 188.572 248.173 188.206 247.252 188.206C246.331 188.206 245.448 188.572 244.796 189.224C244.145 189.875 243.779 190.758 243.779 191.68ZM257.672 191.68C257.672 192.601 258.038 193.484 258.689 194.136C259.341 194.787 260.224 195.153 261.145 195.153C262.067 195.153 262.95 194.787 263.601 194.136C264.253 193.484 264.619 192.601 264.619 191.68C264.619 190.758 264.253 189.875 263.601 189.224C262.95 188.572 262.067 188.206 261.145 188.206C260.224 188.206 259.341 188.572 258.689 189.224C258.038 189.875 257.672 190.758 257.672 191.68ZM285.458 191.68C285.458 192.601 285.824 193.484 286.476 194.136C287.127 194.787 288.011 195.153 288.932 195.153C289.853 195.153 290.736 194.787 291.388 194.136C292.039 193.484 292.405 192.601 292.405 191.68C292.405 190.758 292.039 189.875 291.388 189.224C290.736 188.572 289.853 188.206 288.932 188.206C288.011 188.206 287.127 188.572 286.476 189.224C285.824 189.875 285.458 190.758 285.458 191.68ZM7.59497 198.626C7.59497 199.547 7.96091 200.431 8.61227 201.082C9.26364 201.733 10.1471 202.099 11.0683 202.099C11.9894 202.099 12.8729 201.733 13.5243 201.082C14.1756 200.431 14.5416 199.547 14.5416 198.626C14.5416 197.705 14.1756 196.821 13.5243 196.17C12.8729 195.519 11.9894 195.153 11.0683 195.153C10.1471 195.153 9.26364 195.519 8.61227 196.17C7.96091 196.821 7.59497 197.705 7.59497 198.626ZM14.5416 198.626C14.5416 199.547 14.9075 200.431 15.5589 201.082C16.2102 201.733 17.0937 202.099 18.0149 202.099C18.936 202.099 19.8195 201.733 20.4708 201.082C21.1222 200.431 21.4881 199.547 21.4881 198.626C21.4881 197.705 21.1222 196.821 20.4708 196.17C19.8195 195.519 18.936 195.153 18.0149 195.153C17.0937 195.153 16.2102 195.519 15.5589 196.17C14.9075 196.821 14.5416 197.705 14.5416 198.626ZM21.4881 198.626C21.4881 199.547 21.8541 200.431 22.5055 201.082C23.1568 201.733 24.0403 202.099 24.9614 202.099C25.8826 202.099 26.7661 201.733 27.4174 201.082C28.0688 200.431 28.4347 199.547 28.4347 198.626C28.4347 197.705 28.0688 196.821 27.4174 196.17C26.7661 195.519 25.8826 195.153 24.9614 195.153C24.0403 195.153 23.1568 195.519 22.5055 196.17C21.8541 196.821 21.4881 197.705 21.4881 198.626ZM42.3279 198.626C42.3279 199.082 42.4177 199.534 42.5923 199.955C42.7668 200.377 43.0227 200.76 43.3452 201.082C43.6677 201.405 44.0506 201.66 44.472 201.835C44.8934 202.01 45.3451 202.099 45.8012 202.099C46.2573 202.099 46.709 202.01 47.1304 201.835C47.5518 201.66 47.9347 201.405 48.2572 201.082C48.5797 200.76 48.8356 200.377 49.0101 199.955C49.1847 199.534 49.2745 199.082 49.2745 198.626C49.2745 198.17 49.1847 197.718 49.0101 197.297C48.8356 196.876 48.5797 196.493 48.2572 196.17C47.9347 195.848 47.5518 195.592 47.1304 195.417C46.709 195.243 46.2573 195.153 45.8012 195.153C45.3451 195.153 44.8934 195.243 44.472 195.417C44.0506 195.592 43.6677 195.848 43.3452 196.17C43.0227 196.493 42.7668 196.876 42.5923 197.297C42.4177 197.718 42.3279 198.17 42.3279 198.626ZM56.2211 198.626C56.2211 199.547 56.587 200.431 57.2384 201.082C57.8898 201.733 58.7732 202.099 59.6944 202.099C60.6156 202.099 61.499 201.733 62.1504 201.082C62.8017 200.431 63.1677 199.547 63.1677 198.626C63.1677 197.705 62.8017 196.821 62.1504 196.17C61.499 195.519 60.6156 195.153 59.6944 195.153C58.7732 195.153 57.8898 195.519 57.2384 196.17C56.587 196.821 56.2211 197.705 56.2211 198.626ZM70.1143 198.626C70.1143 199.547 70.4802 200.431 71.1316 201.082C71.7829 201.733 72.6664 202.099 73.5876 202.099C74.5087 202.099 75.3922 201.733 76.0436 201.082C76.6949 200.431 77.0609 199.547 77.0609 198.626C77.0609 197.705 76.6949 196.821 76.0436 196.17C75.3922 195.519 74.5087 195.153 73.5876 195.153C72.6664 195.153 71.7829 195.519 71.1316 196.17C70.4802 196.821 70.1143 197.705 70.1143 198.626ZM77.0609 198.626C77.0609 199.082 77.1507 199.534 77.3252 199.955C77.4998 200.377 77.7556 200.76 78.0782 201.082C78.4007 201.405 78.7836 201.66 79.205 201.835C79.6264 202.01 80.078 202.099 80.5341 202.099C80.9903 202.099 81.4419 202.01 81.8633 201.835C82.2847 201.66 82.6676 201.405 82.9901 201.082C83.3127 200.76 83.5685 200.377 83.743 199.955C83.9176 199.534 84.0074 199.082 84.0074 198.626C84.0074 198.17 83.9176 197.718 83.743 197.297C83.5685 196.876 83.3127 196.493 82.9901 196.17C82.6676 195.848 82.2847 195.592 81.8633 195.417C81.4419 195.243 80.9903 195.153 80.5341 195.153C80.078 195.153 79.6264 195.243 79.205 195.417C78.7836 195.592 78.4007 195.848 78.0782 196.17C77.7556 196.493 77.4998 196.876 77.3252 197.297C77.1507 197.718 77.0609 198.17 77.0609 198.626ZM84.0074 198.626C84.0074 199.547 84.3734 200.431 85.0247 201.082C85.6761 201.733 86.5596 202.099 87.4807 202.099C88.4019 202.099 89.2854 201.733 89.9367 201.082C90.5881 200.431 90.954 199.547 90.954 198.626C90.954 197.705 90.5881 196.821 89.9367 196.17C89.2854 195.519 88.4019 195.153 87.4807 195.153C86.5596 195.153 85.6761 195.519 85.0247 196.17C84.3734 196.821 84.0074 197.705 84.0074 198.626ZM111.794 198.626C111.794 199.547 112.16 200.431 112.811 201.082C113.462 201.733 114.346 202.099 115.267 202.099C116.188 202.099 117.072 201.733 117.723 201.082C118.374 200.431 118.74 199.547 118.74 198.626C118.74 197.705 118.374 196.821 117.723 196.17C117.072 195.519 116.188 195.153 115.267 195.153C114.346 195.153 113.462 195.519 112.811 196.17C112.16 196.821 111.794 197.705 111.794 198.626ZM160.42 198.626C160.42 199.547 160.786 200.431 161.437 201.082C162.089 201.733 162.972 202.099 163.893 202.099C164.814 202.099 165.698 201.733 166.349 201.082C167.001 200.431 167.366 199.547 167.366 198.626C167.366 197.705 167.001 196.821 166.349 196.17C165.698 195.519 164.814 195.153 163.893 195.153C162.972 195.153 162.089 195.519 161.437 196.17C160.786 196.821 160.42 197.705 160.42 198.626ZM181.26 198.626C181.26 199.547 181.626 200.431 182.277 201.082C182.928 201.733 183.812 202.099 184.733 202.099C185.654 202.099 186.538 201.733 187.189 201.082C187.84 200.431 188.206 199.547 188.206 198.626C188.206 197.705 187.84 196.821 187.189 196.17C186.538 195.519 185.654 195.153 184.733 195.153C183.812 195.153 182.928 195.519 182.277 196.17C181.626 196.821 181.26 197.705 181.26 198.626ZM188.206 198.626C188.206 199.547 188.572 200.431 189.224 201.082C189.875 201.733 190.758 202.099 191.68 202.099C192.601 202.099 193.484 201.733 194.136 201.082C194.787 200.431 195.153 199.547 195.153 198.626C195.153 197.705 194.787 196.821 194.136 196.17C193.484 195.519 192.601 195.153 191.68 195.153C190.758 195.153 189.875 195.519 189.224 196.17C188.572 196.821 188.206 197.705 188.206 198.626ZM202.099 198.626C202.099 199.547 202.465 200.431 203.117 201.082C203.768 201.733 204.652 202.099 205.573 202.099C206.494 202.099 207.377 201.733 208.029 201.082C208.68 200.431 209.046 199.547 209.046 198.626C209.046 197.705 208.68 196.821 208.029 196.17C207.377 195.519 206.494 195.153 205.573 195.153C204.652 195.153 203.768 195.519 203.117 196.17C202.465 196.821 202.099 197.705 202.099 198.626ZM209.046 198.626C209.046 199.547 209.412 200.431 210.063 201.082C210.715 201.733 211.598 202.099 212.519 202.099C213.44 202.099 214.324 201.733 214.975 201.082C215.627 200.431 215.993 199.547 215.993 198.626C215.993 197.705 215.627 196.821 214.975 196.17C214.324 195.519 213.44 195.153 212.519 195.153C211.598 195.153 210.715 195.519 210.063 196.17C209.412 196.821 209.046 197.705 209.046 198.626ZM215.993 198.626C215.993 199.547 216.359 200.431 217.01 201.082C217.661 201.733 218.545 202.099 219.466 202.099C220.387 202.099 221.271 201.733 221.922 201.082C222.573 200.431 222.939 199.547 222.939 198.626C222.939 197.705 222.573 196.821 221.922 196.17C221.271 195.519 220.387 195.153 219.466 195.153C218.545 195.153 217.661 195.519 217.01 196.17C216.359 196.821 215.993 197.705 215.993 198.626ZM222.939 198.626C222.939 199.547 223.305 200.431 223.957 201.082C224.608 201.733 225.491 202.099 226.413 202.099C227.334 202.099 228.217 201.733 228.868 201.082C229.52 200.431 229.886 199.547 229.886 198.626C229.886 197.705 229.52 196.821 228.868 196.17C228.217 195.519 227.334 195.153 226.413 195.153C225.491 195.153 224.608 195.519 223.957 196.17C223.305 196.821 222.939 197.705 222.939 198.626ZM229.886 198.626C229.886 199.547 230.252 200.431 230.903 201.082C231.554 201.733 232.438 202.099 233.359 202.099C234.28 202.099 235.164 201.733 235.815 201.082C236.466 200.431 236.832 199.547 236.832 198.626C236.832 197.705 236.466 196.821 235.815 196.17C235.164 195.519 234.28 195.153 233.359 195.153C232.438 195.153 231.554 195.519 230.903 196.17C230.252 196.821 229.886 197.705 229.886 198.626ZM243.779 198.626C243.779 199.547 244.145 200.431 244.796 201.082C245.448 201.733 246.331 202.099 247.252 202.099C248.173 202.099 249.057 201.733 249.708 201.082C250.36 200.431 250.726 199.547 250.726 198.626C250.726 197.705 250.36 196.821 249.708 196.17C249.057 195.519 248.173 195.153 247.252 195.153C246.331 195.153 245.448 195.519 244.796 196.17C244.145 196.821 243.779 197.705 243.779 198.626ZM257.672 198.626C257.672 199.547 258.038 200.431 258.689 201.082C259.341 201.733 260.224 202.099 261.145 202.099C262.067 202.099 262.95 201.733 263.601 201.082C264.253 200.431 264.619 199.547 264.619 198.626C264.619 197.705 264.253 196.821 263.601 196.17C262.95 195.519 262.067 195.153 261.145 195.153C260.224 195.153 259.341 195.519 258.689 196.17C258.038 196.821 257.672 197.705 257.672 198.626ZM264.619 198.626C264.619 199.547 264.985 200.431 265.636 201.082C266.287 201.733 267.171 202.099 268.092 202.099C269.013 202.099 269.897 201.733 270.548 201.082C271.199 200.431 271.565 199.547 271.565 198.626C271.565 197.705 271.199 196.821 270.548 196.17C269.897 195.519 269.013 195.153 268.092 195.153C267.171 195.153 266.287 195.519 265.636 196.17C264.985 196.821 264.619 197.705 264.619 198.626ZM14.5416 205.573C14.5416 206.494 14.9075 207.377 15.5589 208.029C16.2102 208.68 17.0937 209.046 18.0149 209.046C18.936 209.046 19.8195 208.68 20.4708 208.029C21.1222 207.377 21.4881 206.494 21.4881 205.573C21.4881 204.652 21.1222 203.768 20.4708 203.117C19.8195 202.465 18.936 202.099 18.0149 202.099C17.0937 202.099 16.2102 202.465 15.5589 203.117C14.9075 203.768 14.5416 204.652 14.5416 205.573ZM28.4347 205.573C28.4347 206.494 28.8007 207.377 29.452 208.029C30.1034 208.68 30.9869 209.046 31.908 209.046C32.8292 209.046 33.7126 208.68 34.364 208.029C35.0154 207.377 35.3813 206.494 35.3813 205.573C35.3813 204.652 35.0154 203.768 34.364 203.117C33.7126 202.465 32.8292 202.099 31.908 202.099C30.9869 202.099 30.1034 202.465 29.452 203.117C28.8007 203.768 28.4347 204.652 28.4347 205.573ZM42.3279 205.573C42.3279 206.029 42.4177 206.48 42.5923 206.902C42.7668 207.323 43.0227 207.706 43.3452 208.029C43.6677 208.351 44.0506 208.607 44.472 208.782C44.8934 208.956 45.3451 209.046 45.8012 209.046C46.2573 209.046 46.709 208.956 47.1304 208.782C47.5518 208.607 47.9347 208.351 48.2572 208.029C48.5797 207.706 48.8356 207.323 49.0101 206.902C49.1847 206.48 49.2745 206.029 49.2745 205.573C49.2745 205.117 49.1847 204.665 49.0101 204.244C48.8356 203.822 48.5797 203.439 48.2572 203.117C47.9347 202.794 47.5518 202.538 47.1304 202.364C46.709 202.189 46.2573 202.099 45.8012 202.099C45.3451 202.099 44.8934 202.189 44.472 202.364C44.0506 202.538 43.6677 202.794 43.3452 203.117C43.0227 203.439 42.7668 203.822 42.5923 204.244C42.4177 204.665 42.3279 205.117 42.3279 205.573ZM49.2745 205.573C49.2745 206.029 49.3643 206.48 49.5389 206.902C49.7134 207.323 49.9693 207.706 50.2918 208.029C50.6143 208.351 50.9972 208.607 51.4186 208.782C51.84 208.956 52.2917 209.046 52.7478 209.046C53.2039 209.046 53.6556 208.956 54.077 208.782C54.4984 208.607 54.8813 208.351 55.2038 208.029C55.5263 207.706 55.7821 207.323 55.9567 206.902C56.1312 206.48 56.2211 206.029 56.2211 205.573C56.2211 205.117 56.1312 204.665 55.9567 204.244C55.7821 203.822 55.5263 203.439 55.2038 203.117C54.8813 202.794 54.4984 202.538 54.077 202.364C53.6556 202.189 53.2039 202.099 52.7478 202.099C52.2917 202.099 51.84 202.189 51.4186 202.364C50.9972 202.538 50.6143 202.794 50.2918 203.117C49.9693 203.439 49.7134 203.822 49.5389 204.244C49.3643 204.665 49.2745 205.117 49.2745 205.573ZM70.1143 205.573C70.1143 206.494 70.4802 207.377 71.1316 208.029C71.7829 208.68 72.6664 209.046 73.5876 209.046C74.5087 209.046 75.3922 208.68 76.0436 208.029C76.6949 207.377 77.0609 206.494 77.0609 205.573C77.0609 204.652 76.6949 203.768 76.0436 203.117C75.3922 202.465 74.5087 202.099 73.5876 202.099C72.6664 202.099 71.7829 202.465 71.1316 203.117C70.4802 203.768 70.1143 204.652 70.1143 205.573ZM90.954 205.573C90.954 206.494 91.32 207.377 91.9713 208.029C92.6227 208.68 93.5061 209.046 94.4273 209.046C95.3485 209.046 96.2319 208.68 96.8833 208.029C97.5347 207.377 97.9006 206.494 97.9006 205.573C97.9006 204.652 97.5347 203.768 96.8833 203.117C96.2319 202.465 95.3485 202.099 94.4273 202.099C93.5061 202.099 92.6227 202.465 91.9713 203.117C91.32 203.768 90.954 204.652 90.954 205.573ZM111.794 205.573C111.794 206.494 112.16 207.377 112.811 208.029C113.462 208.68 114.346 209.046 115.267 209.046C116.188 209.046 117.072 208.68 117.723 208.029C118.374 207.377 118.74 206.494 118.74 205.573C118.74 204.652 118.374 203.768 117.723 203.117C117.072 202.465 116.188 202.099 115.267 202.099C114.346 202.099 113.462 202.465 112.811 203.117C112.16 203.768 111.794 204.652 111.794 205.573ZM132.634 205.573C132.634 206.494 132.999 207.377 133.651 208.029C134.302 208.68 135.186 209.046 136.107 209.046C137.028 209.046 137.911 208.68 138.563 208.029C139.214 207.377 139.58 206.494 139.58 205.573C139.58 204.652 139.214 203.768 138.563 203.117C137.911 202.465 137.028 202.099 136.107 202.099C135.186 202.099 134.302 202.465 133.651 203.117C132.999 203.768 132.634 204.652 132.634 205.573ZM146.527 205.573C146.527 206.494 146.893 207.377 147.544 208.029C148.195 208.68 149.079 209.046 150 209.046C150.921 209.046 151.805 208.68 152.456 208.029C153.107 207.377 153.473 206.494 153.473 205.573C153.473 204.652 153.107 203.768 152.456 203.117C151.805 202.465 150.921 202.099 150 202.099C149.079 202.099 148.195 202.465 147.544 203.117C146.893 203.768 146.527 204.652 146.527 205.573ZM174.313 205.573C174.313 206.494 174.679 207.377 175.33 208.029C175.982 208.68 176.865 209.046 177.786 209.046C178.708 209.046 179.591 208.68 180.242 208.029C180.894 207.377 181.26 206.494 181.26 205.573C181.26 204.652 180.894 203.768 180.242 203.117C179.591 202.465 178.708 202.099 177.786 202.099C176.865 202.099 175.982 202.465 175.33 203.117C174.679 203.768 174.313 204.652 174.313 205.573ZM181.26 205.573C181.26 206.494 181.626 207.377 182.277 208.029C182.928 208.68 183.812 209.046 184.733 209.046C185.654 209.046 186.538 208.68 187.189 208.029C187.84 207.377 188.206 206.494 188.206 205.573C188.206 204.652 187.84 203.768 187.189 203.117C186.538 202.465 185.654 202.099 184.733 202.099C183.812 202.099 182.928 202.465 182.277 203.117C181.626 203.768 181.26 204.652 181.26 205.573ZM188.206 205.573C188.206 206.494 188.572 207.377 189.224 208.029C189.875 208.68 190.758 209.046 191.68 209.046C192.601 209.046 193.484 208.68 194.136 208.029C194.787 207.377 195.153 206.494 195.153 205.573C195.153 204.652 194.787 203.768 194.136 203.117C193.484 202.465 192.601 202.099 191.68 202.099C190.758 202.099 189.875 202.465 189.224 203.117C188.572 203.768 188.206 204.652 188.206 205.573ZM202.099 205.573C202.099 206.494 202.465 207.377 203.117 208.029C203.768 208.68 204.652 209.046 205.573 209.046C206.494 209.046 207.377 208.68 208.029 208.029C208.68 207.377 209.046 206.494 209.046 205.573C209.046 204.652 208.68 203.768 208.029 203.117C207.377 202.465 206.494 202.099 205.573 202.099C204.652 202.099 203.768 202.465 203.117 203.117C202.465 203.768 202.099 204.652 202.099 205.573ZM209.046 205.573C209.046 206.494 209.412 207.377 210.063 208.029C210.715 208.68 211.598 209.046 212.519 209.046C213.44 209.046 214.324 208.68 214.975 208.029C215.627 207.377 215.993 206.494 215.993 205.573C215.993 204.652 215.627 203.768 214.975 203.117C214.324 202.465 213.44 202.099 212.519 202.099C211.598 202.099 210.715 202.465 210.063 203.117C209.412 203.768 209.046 204.652 209.046 205.573ZM229.886 205.573C229.886 206.494 230.252 207.377 230.903 208.029C231.554 208.68 232.438 209.046 233.359 209.046C234.28 209.046 235.164 208.68 235.815 208.029C236.466 207.377 236.832 206.494 236.832 205.573C236.832 204.652 236.466 203.768 235.815 203.117C235.164 202.465 234.28 202.099 233.359 202.099C232.438 202.099 231.554 202.465 230.903 203.117C230.252 203.768 229.886 204.652 229.886 205.573ZM7.59497 212.519C7.59497 213.44 7.96091 214.324 8.61227 214.975C9.26364 215.627 10.1471 215.993 11.0683 215.993C11.9894 215.993 12.8729 215.627 13.5243 214.975C14.1756 214.324 14.5416 213.44 14.5416 212.519C14.5416 211.598 14.1756 210.715 13.5243 210.063C12.8729 209.412 11.9894 209.046 11.0683 209.046C10.1471 209.046 9.26364 209.412 8.61227 210.063C7.96091 210.715 7.59497 211.598 7.59497 212.519ZM14.5416 212.519C14.5416 213.44 14.9075 214.324 15.5589 214.975C16.2102 215.627 17.0937 215.993 18.0149 215.993C18.936 215.993 19.8195 215.627 20.4708 214.975C21.1222 214.324 21.4881 213.44 21.4881 212.519C21.4881 211.598 21.1222 210.715 20.4708 210.063C19.8195 209.412 18.936 209.046 18.0149 209.046C17.0937 209.046 16.2102 209.412 15.5589 210.063C14.9075 210.715 14.5416 211.598 14.5416 212.519ZM21.4881 212.519C21.4881 213.44 21.8541 214.324 22.5055 214.975C23.1568 215.627 24.0403 215.993 24.9614 215.993C25.8826 215.993 26.7661 215.627 27.4174 214.975C28.0688 214.324 28.4347 213.44 28.4347 212.519C28.4347 211.598 28.0688 210.715 27.4174 210.063C26.7661 209.412 25.8826 209.046 24.9614 209.046C24.0403 209.046 23.1568 209.412 22.5055 210.063C21.8541 210.715 21.4881 211.598 21.4881 212.519ZM35.3813 212.519C35.3813 213.44 35.7473 214.324 36.3986 214.975C37.05 215.627 37.9334 215.993 38.8546 215.993C39.7758 215.993 40.6592 215.627 41.3106 214.975C41.962 214.324 42.3279 213.44 42.3279 212.519C42.3279 211.598 41.962 210.715 41.3106 210.063C40.6592 209.412 39.7758 209.046 38.8546 209.046C37.9334 209.046 37.05 209.412 36.3986 210.063C35.7473 210.715 35.3813 211.598 35.3813 212.519ZM42.3279 212.519C42.3279 212.975 42.4177 213.427 42.5923 213.848C42.7668 214.27 43.0227 214.653 43.3452 214.975C43.6677 215.298 44.0506 215.554 44.472 215.728C44.8934 215.903 45.3451 215.993 45.8012 215.993C46.2573 215.993 46.709 215.903 47.1304 215.728C47.5518 215.554 47.9347 215.298 48.2572 214.975C48.5797 214.653 48.8356 214.27 49.0101 213.848C49.1847 213.427 49.2745 212.975 49.2745 212.519C49.2745 212.063 49.1847 211.612 49.0101 211.19C48.8356 210.769 48.5797 210.386 48.2572 210.063C47.9347 209.741 47.5518 209.485 47.1304 209.31C46.709 209.136 46.2573 209.046 45.8012 209.046C45.3451 209.046 44.8934 209.136 44.472 209.31C44.0506 209.485 43.6677 209.741 43.3452 210.063C43.0227 210.386 42.7668 210.769 42.5923 211.19C42.4177 211.612 42.3279 212.063 42.3279 212.519ZM70.1143 212.519C70.1143 213.44 70.4802 214.324 71.1316 214.975C71.7829 215.627 72.6664 215.993 73.5876 215.993C74.5087 215.993 75.3922 215.627 76.0436 214.975C76.6949 214.324 77.0609 213.44 77.0609 212.519C77.0609 211.598 76.6949 210.715 76.0436 210.063C75.3922 209.412 74.5087 209.046 73.5876 209.046C72.6664 209.046 71.7829 209.412 71.1316 210.063C70.4802 210.715 70.1143 211.598 70.1143 212.519ZM77.0609 212.519C77.0609 212.975 77.1507 213.427 77.3252 213.848C77.4998 214.27 77.7556 214.653 78.0782 214.975C78.4007 215.298 78.7836 215.554 79.205 215.728C79.6264 215.903 80.078 215.993 80.5341 215.993C80.9903 215.993 81.4419 215.903 81.8633 215.728C82.2847 215.554 82.6676 215.298 82.9901 214.975C83.3127 214.653 83.5685 214.27 83.743 213.848C83.9176 213.427 84.0074 212.975 84.0074 212.519C84.0074 212.063 83.9176 211.612 83.743 211.19C83.5685 210.769 83.3127 210.386 82.9901 210.063C82.6676 209.741 82.2847 209.485 81.8633 209.31C81.4419 209.136 80.9903 209.046 80.5341 209.046C80.078 209.046 79.6264 209.136 79.205 209.31C78.7836 209.485 78.4007 209.741 78.0782 210.063C77.7556 210.386 77.4998 210.769 77.3252 211.19C77.1507 211.612 77.0609 212.063 77.0609 212.519ZM97.9006 212.519C97.9006 212.975 97.9905 213.427 98.165 213.848C98.3396 214.27 98.5954 214.653 98.9179 214.975C99.2404 215.298 99.6233 215.554 100.045 215.728C100.466 215.903 100.918 215.993 101.374 215.993C101.83 215.993 102.282 215.903 102.703 215.728C103.124 215.554 103.507 215.298 103.83 214.975C104.152 214.653 104.408 214.27 104.583 213.848C104.757 213.427 104.847 212.975 104.847 212.519C104.847 212.063 104.757 211.612 104.583 211.19C104.408 210.769 104.152 210.386 103.83 210.063C103.507 209.741 103.124 209.485 102.703 209.31C102.282 209.136 101.83 209.046 101.374 209.046C100.918 209.046 100.466 209.136 100.045 209.31C99.6233 209.485 99.2404 209.741 98.9179 210.063C98.5954 210.386 98.3396 210.769 98.165 211.19C97.9905 211.612 97.9006 212.063 97.9006 212.519ZM111.794 212.519C111.794 213.44 112.16 214.324 112.811 214.975C113.462 215.627 114.346 215.993 115.267 215.993C116.188 215.993 117.072 215.627 117.723 214.975C118.374 214.324 118.74 213.44 118.74 212.519C118.74 211.598 118.374 210.715 117.723 210.063C117.072 209.412 116.188 209.046 115.267 209.046C114.346 209.046 113.462 209.412 112.811 210.063C112.16 210.715 111.794 211.598 111.794 212.519ZM118.74 212.519C118.74 213.44 119.106 214.324 119.758 214.975C120.409 215.627 121.292 215.993 122.214 215.993C123.135 215.993 124.018 215.627 124.67 214.975C125.321 214.324 125.687 213.44 125.687 212.519C125.687 211.598 125.321 210.715 124.67 210.063C124.018 209.412 123.135 209.046 122.214 209.046C121.292 209.046 120.409 209.412 119.758 210.063C119.106 210.715 118.74 211.598 118.74 212.519ZM125.687 212.519C125.687 213.44 126.053 214.324 126.704 214.975C127.356 215.627 128.239 215.993 129.16 215.993C130.081 215.993 130.965 215.627 131.616 214.975C132.268 214.324 132.634 213.44 132.634 212.519C132.634 211.598 132.268 210.715 131.616 210.063C130.965 209.412 130.081 209.046 129.16 209.046C128.239 209.046 127.356 209.412 126.704 210.063C126.053 210.715 125.687 211.598 125.687 212.519ZM132.634 212.519C132.634 213.44 132.999 214.324 133.651 214.975C134.302 215.627 135.186 215.993 136.107 215.993C137.028 215.993 137.911 215.627 138.563 214.975C139.214 214.324 139.58 213.44 139.58 212.519C139.58 211.598 139.214 210.715 138.563 210.063C137.911 209.412 137.028 209.046 136.107 209.046C135.186 209.046 134.302 209.412 133.651 210.063C132.999 210.715 132.634 211.598 132.634 212.519ZM139.58 212.519C139.58 213.44 139.946 214.324 140.597 214.975C141.249 215.627 142.132 215.993 143.053 215.993C143.975 215.993 144.858 215.627 145.509 214.975C146.161 214.324 146.527 213.44 146.527 212.519C146.527 211.598 146.161 210.715 145.509 210.063C144.858 209.412 143.975 209.046 143.053 209.046C142.132 209.046 141.249 209.412 140.597 210.063C139.946 210.715 139.58 211.598 139.58 212.519ZM167.366 212.519C167.366 213.44 167.732 214.324 168.384 214.975C169.035 215.627 169.919 215.993 170.84 215.993C171.761 215.993 172.644 215.627 173.296 214.975C173.947 214.324 174.313 213.44 174.313 212.519C174.313 211.598 173.947 210.715 173.296 210.063C172.644 209.412 171.761 209.046 170.84 209.046C169.919 209.046 169.035 209.412 168.384 210.063C167.732 210.715 167.366 211.598 167.366 212.519ZM181.26 212.519C181.26 213.44 181.626 214.324 182.277 214.975C182.928 215.627 183.812 215.993 184.733 215.993C185.654 215.993 186.538 215.627 187.189 214.975C187.84 214.324 188.206 213.44 188.206 212.519C188.206 211.598 187.84 210.715 187.189 210.063C186.538 209.412 185.654 209.046 184.733 209.046C183.812 209.046 182.928 209.412 182.277 210.063C181.626 210.715 181.26 211.598 181.26 212.519ZM188.206 212.519C188.206 213.44 188.572 214.324 189.224 214.975C189.875 215.627 190.758 215.993 191.68 215.993C192.601 215.993 193.484 215.627 194.136 214.975C194.787 214.324 195.153 213.44 195.153 212.519C195.153 211.598 194.787 210.715 194.136 210.063C193.484 209.412 192.601 209.046 191.68 209.046C190.758 209.046 189.875 209.412 189.224 210.063C188.572 210.715 188.206 211.598 188.206 212.519ZM215.993 212.519C215.993 213.44 216.359 214.324 217.01 214.975C217.661 215.627 218.545 215.993 219.466 215.993C220.387 215.993 221.271 215.627 221.922 214.975C222.573 214.324 222.939 213.44 222.939 212.519C222.939 211.598 222.573 210.715 221.922 210.063C221.271 209.412 220.387 209.046 219.466 209.046C218.545 209.046 217.661 209.412 217.01 210.063C216.359 210.715 215.993 211.598 215.993 212.519ZM222.939 212.519C222.939 213.44 223.305 214.324 223.957 214.975C224.608 215.627 225.491 215.993 226.413 215.993C227.334 215.993 228.217 215.627 228.868 214.975C229.52 214.324 229.886 213.44 229.886 212.519C229.886 211.598 229.52 210.715 228.868 210.063C228.217 209.412 227.334 209.046 226.413 209.046C225.491 209.046 224.608 209.412 223.957 210.063C223.305 210.715 222.939 211.598 222.939 212.519ZM236.832 212.519C236.832 213.44 237.198 214.324 237.85 214.975C238.501 215.627 239.384 215.993 240.306 215.993C241.227 215.993 242.11 215.627 242.762 214.975C243.413 214.324 243.779 213.44 243.779 212.519C243.779 211.598 243.413 210.715 242.762 210.063C242.11 209.412 241.227 209.046 240.306 209.046C239.384 209.046 238.501 209.412 237.85 210.063C237.198 210.715 236.832 211.598 236.832 212.519ZM250.726 212.519C250.726 213.44 251.091 214.324 251.743 214.975C252.394 215.627 253.278 215.993 254.199 215.993C255.12 215.993 256.003 215.627 256.655 214.975C257.306 214.324 257.672 213.44 257.672 212.519C257.672 211.598 257.306 210.715 256.655 210.063C256.003 209.412 255.12 209.046 254.199 209.046C253.278 209.046 252.394 209.412 251.743 210.063C251.091 210.715 250.726 211.598 250.726 212.519ZM257.672 212.519C257.672 213.44 258.038 214.324 258.689 214.975C259.341 215.627 260.224 215.993 261.145 215.993C262.067 215.993 262.95 215.627 263.601 214.975C264.253 214.324 264.619 213.44 264.619 212.519C264.619 211.598 264.253 210.715 263.601 210.063C262.95 209.412 262.067 209.046 261.145 209.046C260.224 209.046 259.341 209.412 258.689 210.063C258.038 210.715 257.672 211.598 257.672 212.519ZM264.619 212.519C264.619 213.44 264.985 214.324 265.636 214.975C266.287 215.627 267.171 215.993 268.092 215.993C269.013 215.993 269.897 215.627 270.548 214.975C271.199 214.324 271.565 213.44 271.565 212.519C271.565 211.598 271.199 210.715 270.548 210.063C269.897 209.412 269.013 209.046 268.092 209.046C267.171 209.046 266.287 209.412 265.636 210.063C264.985 210.715 264.619 211.598 264.619 212.519ZM271.565 212.519C271.565 213.44 271.931 214.324 272.583 214.975C273.234 215.627 274.117 215.993 275.039 215.993C275.96 215.993 276.843 215.627 277.495 214.975C278.146 214.324 278.512 213.44 278.512 212.519C278.512 211.598 278.146 210.715 277.495 210.063C276.843 209.412 275.96 209.046 275.039 209.046C274.117 209.046 273.234 209.412 272.583 210.063C271.931 210.715 271.565 211.598 271.565 212.519ZM285.458 212.519C285.458 213.44 285.824 214.324 286.476 214.975C287.127 215.627 288.011 215.993 288.932 215.993C289.853 215.993 290.736 215.627 291.388 214.975C292.039 214.324 292.405 213.44 292.405 212.519C292.405 211.598 292.039 210.715 291.388 210.063C290.736 209.412 289.853 209.046 288.932 209.046C288.011 209.046 287.127 209.412 286.476 210.063C285.824 210.715 285.458 211.598 285.458 212.519ZM35.3813 219.466C35.3813 220.387 35.7473 221.27 36.3986 221.922C37.05 222.573 37.9334 222.939 38.8546 222.939C39.7758 222.939 40.6592 222.573 41.3106 221.922C41.962 221.27 42.3279 220.387 42.3279 219.466C42.3279 218.545 41.962 217.661 41.3106 217.01C40.6592 216.359 39.7758 215.993 38.8546 215.993C37.9334 215.993 37.05 216.359 36.3986 217.01C35.7473 217.661 35.3813 218.545 35.3813 219.466ZM42.3279 219.466C42.3279 219.922 42.4177 220.374 42.5923 220.795C42.7668 221.216 43.0227 221.599 43.3452 221.922C43.6677 222.244 44.0506 222.5 44.472 222.675C44.8934 222.849 45.3451 222.939 45.8012 222.939C46.2573 222.939 46.709 222.849 47.1304 222.675C47.5518 222.5 47.9347 222.244 48.2572 221.922C48.5797 221.599 48.8356 221.216 49.0101 220.795C49.1847 220.374 49.2745 219.922 49.2745 219.466C49.2745 219.01 49.1847 218.558 49.0101 218.137C48.8356 217.715 48.5797 217.332 48.2572 217.01C47.9347 216.687 47.5518 216.432 47.1304 216.257C46.709 216.082 46.2573 215.993 45.8012 215.993C45.3451 215.993 44.8934 216.082 44.472 216.257C44.0506 216.432 43.6677 216.687 43.3452 217.01C43.0227 217.332 42.7668 217.715 42.5923 218.137C42.4177 218.558 42.3279 219.01 42.3279 219.466ZM49.2745 219.466C49.2745 219.922 49.3643 220.374 49.5389 220.795C49.7134 221.216 49.9693 221.599 50.2918 221.922C50.6143 222.244 50.9972 222.5 51.4186 222.675C51.84 222.849 52.2917 222.939 52.7478 222.939C53.2039 222.939 53.6556 222.849 54.077 222.675C54.4984 222.5 54.8813 222.244 55.2038 221.922C55.5263 221.599 55.7821 221.216 55.9567 220.795C56.1312 220.374 56.2211 219.922 56.2211 219.466C56.2211 219.01 56.1312 218.558 55.9567 218.137C55.7821 217.715 55.5263 217.332 55.2038 217.01C54.8813 216.687 54.4984 216.432 54.077 216.257C53.6556 216.082 53.2039 215.993 52.7478 215.993C52.2917 215.993 51.84 216.082 51.4186 216.257C50.9972 216.432 50.6143 216.687 50.2918 217.01C49.9693 217.332 49.7134 217.715 49.5389 218.137C49.3643 218.558 49.2745 219.01 49.2745 219.466ZM56.2211 219.466C56.2211 220.387 56.587 221.27 57.2384 221.922C57.8898 222.573 58.7732 222.939 59.6944 222.939C60.6156 222.939 61.499 222.573 62.1504 221.922C62.8017 221.27 63.1677 220.387 63.1677 219.466C63.1677 218.545 62.8017 217.661 62.1504 217.01C61.499 216.359 60.6156 215.993 59.6944 215.993C58.7732 215.993 57.8898 216.359 57.2384 217.01C56.587 217.661 56.2211 218.545 56.2211 219.466ZM63.1677 219.466C63.1677 220.387 63.5336 221.27 64.185 221.922C64.8363 222.573 65.7198 222.939 66.641 222.939C67.5621 222.939 68.4456 222.573 69.097 221.922C69.7483 221.27 70.1143 220.387 70.1143 219.466C70.1143 218.545 69.7483 217.661 69.097 217.01C68.4456 216.359 67.5621 215.993 66.641 215.993C65.7198 215.993 64.8363 216.359 64.185 217.01C63.5336 217.661 63.1677 218.545 63.1677 219.466ZM84.0074 219.466C84.0074 220.387 84.3734 221.27 85.0247 221.922C85.6761 222.573 86.5596 222.939 87.4807 222.939C88.4019 222.939 89.2854 222.573 89.9367 221.922C90.5881 221.27 90.954 220.387 90.954 219.466C90.954 218.545 90.5881 217.661 89.9367 217.01C89.2854 216.359 88.4019 215.993 87.4807 215.993C86.5596 215.993 85.6761 216.359 85.0247 217.01C84.3734 217.661 84.0074 218.545 84.0074 219.466ZM97.9006 219.466C97.9006 219.922 97.9905 220.374 98.165 220.795C98.3396 221.216 98.5954 221.599 98.9179 221.922C99.2404 222.244 99.6233 222.5 100.045 222.675C100.466 222.849 100.918 222.939 101.374 222.939C101.83 222.939 102.282 222.849 102.703 222.675C103.124 222.5 103.507 222.244 103.83 221.922C104.152 221.599 104.408 221.216 104.583 220.795C104.757 220.374 104.847 219.922 104.847 219.466C104.847 219.01 104.757 218.558 104.583 218.137C104.408 217.715 104.152 217.332 103.83 217.01C103.507 216.687 103.124 216.432 102.703 216.257C102.282 216.082 101.83 215.993 101.374 215.993C100.918 215.993 100.466 216.082 100.045 216.257C99.6233 216.432 99.2404 216.687 98.9179 217.01C98.5954 217.332 98.3396 217.715 98.165 218.137C97.9905 218.558 97.9006 219.01 97.9006 219.466ZM104.847 219.466C104.847 220.387 105.213 221.27 105.865 221.922C106.516 222.573 107.399 222.939 108.321 222.939C109.242 222.939 110.125 222.573 110.776 221.922C111.428 221.27 111.794 220.387 111.794 219.466C111.794 218.545 111.428 217.661 110.776 217.01C110.125 216.359 109.242 215.993 108.321 215.993C107.399 215.993 106.516 216.359 105.865 217.01C105.213 217.661 104.847 218.545 104.847 219.466ZM111.794 219.466C111.794 220.387 112.16 221.27 112.811 221.922C113.462 222.573 114.346 222.939 115.267 222.939C116.188 222.939 117.072 222.573 117.723 221.922C118.374 221.27 118.74 220.387 118.74 219.466C118.74 218.545 118.374 217.661 117.723 217.01C117.072 216.359 116.188 215.993 115.267 215.993C114.346 215.993 113.462 216.359 112.811 217.01C112.16 217.661 111.794 218.545 111.794 219.466ZM118.74 219.466C118.74 220.387 119.106 221.27 119.758 221.922C120.409 222.573 121.292 222.939 122.214 222.939C123.135 222.939 124.018 222.573 124.67 221.922C125.321 221.27 125.687 220.387 125.687 219.466C125.687 218.545 125.321 217.661 124.67 217.01C124.018 216.359 123.135 215.993 122.214 215.993C121.292 215.993 120.409 216.359 119.758 217.01C119.106 217.661 118.74 218.545 118.74 219.466ZM160.42 219.466C160.42 220.387 160.786 221.27 161.437 221.922C162.089 222.573 162.972 222.939 163.893 222.939C164.814 222.939 165.698 222.573 166.349 221.922C167.001 221.27 167.366 220.387 167.366 219.466C167.366 218.545 167.001 217.661 166.349 217.01C165.698 216.359 164.814 215.993 163.893 215.993C162.972 215.993 162.089 216.359 161.437 217.01C160.786 217.661 160.42 218.545 160.42 219.466ZM181.26 219.466C181.26 220.387 181.626 221.27 182.277 221.922C182.928 222.573 183.812 222.939 184.733 222.939C185.654 222.939 186.538 222.573 187.189 221.922C187.84 221.27 188.206 220.387 188.206 219.466C188.206 218.545 187.84 217.661 187.189 217.01C186.538 216.359 185.654 215.993 184.733 215.993C183.812 215.993 182.928 216.359 182.277 217.01C181.626 217.661 181.26 218.545 181.26 219.466ZM188.206 219.466C188.206 220.387 188.572 221.27 189.224 221.922C189.875 222.573 190.758 222.939 191.68 222.939C192.601 222.939 193.484 222.573 194.136 221.922C194.787 221.27 195.153 220.387 195.153 219.466C195.153 218.545 194.787 217.661 194.136 217.01C193.484 216.359 192.601 215.993 191.68 215.993C190.758 215.993 189.875 216.359 189.224 217.01C188.572 217.661 188.206 218.545 188.206 219.466ZM195.153 219.466C195.153 219.922 195.243 220.374 195.417 220.795C195.592 221.216 195.848 221.599 196.17 221.922C196.493 222.244 196.876 222.5 197.297 222.675C197.718 222.849 198.17 222.939 198.626 222.939C199.082 222.939 199.534 222.849 199.955 222.675C200.377 222.5 200.76 222.244 201.082 221.922C201.405 221.599 201.661 221.216 201.835 220.795C202.01 220.374 202.099 219.922 202.099 219.466C202.099 219.01 202.01 218.558 201.835 218.137C201.661 217.715 201.405 217.332 201.082 217.01C200.76 216.687 200.377 216.432 199.955 216.257C199.534 216.082 199.082 215.993 198.626 215.993C198.17 215.993 197.718 216.082 197.297 216.257C196.876 216.432 196.493 216.687 196.17 217.01C195.848 217.332 195.592 217.715 195.417 218.137C195.243 218.558 195.153 219.01 195.153 219.466ZM215.993 219.466C215.993 220.387 216.359 221.27 217.01 221.922C217.661 222.573 218.545 222.939 219.466 222.939C220.387 222.939 221.271 222.573 221.922 221.922C222.573 221.27 222.939 220.387 222.939 219.466C222.939 218.545 222.573 217.661 221.922 217.01C221.271 216.359 220.387 215.993 219.466 215.993C218.545 215.993 217.661 216.359 217.01 217.01C216.359 217.661 215.993 218.545 215.993 219.466ZM222.939 219.466C222.939 220.387 223.305 221.27 223.957 221.922C224.608 222.573 225.491 222.939 226.413 222.939C227.334 222.939 228.217 222.573 228.868 221.922C229.52 221.27 229.886 220.387 229.886 219.466C229.886 218.545 229.52 217.661 228.868 217.01C228.217 216.359 227.334 215.993 226.413 215.993C225.491 215.993 224.608 216.359 223.957 217.01C223.305 217.661 222.939 218.545 222.939 219.466ZM236.832 219.466C236.832 220.387 237.198 221.27 237.85 221.922C238.501 222.573 239.384 222.939 240.306 222.939C241.227 222.939 242.11 222.573 242.762 221.922C243.413 221.27 243.779 220.387 243.779 219.466C243.779 218.545 243.413 217.661 242.762 217.01C242.11 216.359 241.227 215.993 240.306 215.993C239.384 215.993 238.501 216.359 237.85 217.01C237.198 217.661 236.832 218.545 236.832 219.466ZM250.726 219.466C250.726 220.387 251.091 221.27 251.743 221.922C252.394 222.573 253.278 222.939 254.199 222.939C255.12 222.939 256.003 222.573 256.655 221.922C257.306 221.27 257.672 220.387 257.672 219.466C257.672 218.545 257.306 217.661 256.655 217.01C256.003 216.359 255.12 215.993 254.199 215.993C253.278 215.993 252.394 216.359 251.743 217.01C251.091 217.661 250.726 218.545 250.726 219.466ZM264.619 219.466C264.619 220.387 264.985 221.27 265.636 221.922C266.287 222.573 267.171 222.939 268.092 222.939C269.013 222.939 269.897 222.573 270.548 221.922C271.199 221.27 271.565 220.387 271.565 219.466C271.565 218.545 271.199 217.661 270.548 217.01C269.897 216.359 269.013 215.993 268.092 215.993C267.171 215.993 266.287 216.359 265.636 217.01C264.985 217.661 264.619 218.545 264.619 219.466ZM278.512 219.466C278.512 220.387 278.878 221.27 279.529 221.922C280.181 222.573 281.064 222.939 281.985 222.939C282.906 222.939 283.79 222.573 284.441 221.922C285.093 221.27 285.458 220.387 285.458 219.466C285.458 218.545 285.093 217.661 284.441 217.01C283.79 216.359 282.906 215.993 281.985 215.993C281.064 215.993 280.181 216.359 279.529 217.01C278.878 217.661 278.512 218.545 278.512 219.466ZM285.458 219.466C285.458 220.387 285.824 221.27 286.476 221.922C287.127 222.573 288.011 222.939 288.932 222.939C289.853 222.939 290.736 222.573 291.388 221.922C292.039 221.27 292.405 220.387 292.405 219.466C292.405 218.545 292.039 217.661 291.388 217.01C290.736 216.359 289.853 215.993 288.932 215.993C288.011 215.993 287.127 216.359 286.476 217.01C285.824 217.661 285.458 218.545 285.458 219.466ZM21.4881 226.412C21.4881 227.334 21.8541 228.217 22.5055 228.868C23.1568 229.52 24.0403 229.886 24.9614 229.886C25.8826 229.886 26.7661 229.52 27.4174 228.868C28.0688 228.217 28.4347 227.334 28.4347 226.412C28.4347 225.491 28.0688 224.608 27.4174 223.956C26.7661 223.305 25.8826 222.939 24.9614 222.939C24.0403 222.939 23.1568 223.305 22.5055 223.956C21.8541 224.608 21.4881 225.491 21.4881 226.412ZM28.4347 226.412C28.4347 227.334 28.8007 228.217 29.452 228.868C30.1034 229.52 30.9869 229.886 31.908 229.886C32.8292 229.886 33.7126 229.52 34.364 228.868C35.0154 228.217 35.3813 227.334 35.3813 226.412C35.3813 225.491 35.0154 224.608 34.364 223.956C33.7126 223.305 32.8292 222.939 31.908 222.939C30.9869 222.939 30.1034 223.305 29.452 223.956C28.8007 224.608 28.4347 225.491 28.4347 226.412ZM35.3813 226.412C35.3813 227.334 35.7473 228.217 36.3986 228.868C37.05 229.52 37.9334 229.886 38.8546 229.886C39.7758 229.886 40.6592 229.52 41.3106 228.868C41.962 228.217 42.3279 227.334 42.3279 226.412C42.3279 225.491 41.962 224.608 41.3106 223.956C40.6592 223.305 39.7758 222.939 38.8546 222.939C37.9334 222.939 37.05 223.305 36.3986 223.956C35.7473 224.608 35.3813 225.491 35.3813 226.412ZM56.2211 226.412C56.2211 227.334 56.587 228.217 57.2384 228.868C57.8898 229.52 58.7732 229.886 59.6944 229.886C60.6156 229.886 61.499 229.52 62.1504 228.868C62.8017 228.217 63.1677 227.334 63.1677 226.412C63.1677 225.491 62.8017 224.608 62.1504 223.956C61.499 223.305 60.6156 222.939 59.6944 222.939C58.7732 222.939 57.8898 223.305 57.2384 223.956C56.587 224.608 56.2211 225.491 56.2211 226.412ZM63.1677 226.412C63.1677 227.334 63.5336 228.217 64.185 228.868C64.8363 229.52 65.7198 229.886 66.641 229.886C67.5621 229.886 68.4456 229.52 69.097 228.868C69.7483 228.217 70.1143 227.334 70.1143 226.412C70.1143 225.491 69.7483 224.608 69.097 223.956C68.4456 223.305 67.5621 222.939 66.641 222.939C65.7198 222.939 64.8363 223.305 64.185 223.956C63.5336 224.608 63.1677 225.491 63.1677 226.412ZM70.1143 226.412C70.1143 227.334 70.4802 228.217 71.1316 228.868C71.7829 229.52 72.6664 229.886 73.5876 229.886C74.5087 229.886 75.3922 229.52 76.0436 228.868C76.6949 228.217 77.0609 227.334 77.0609 226.412C77.0609 225.491 76.6949 224.608 76.0436 223.956C75.3922 223.305 74.5087 222.939 73.5876 222.939C72.6664 222.939 71.7829 223.305 71.1316 223.956C70.4802 224.608 70.1143 225.491 70.1143 226.412ZM77.0609 226.412C77.0609 226.869 77.1507 227.32 77.3252 227.742C77.4998 228.163 77.7556 228.546 78.0782 228.868C78.4007 229.191 78.7836 229.447 79.205 229.621C79.6264 229.796 80.078 229.886 80.5341 229.886C80.9903 229.886 81.4419 229.796 81.8633 229.621C82.2847 229.447 82.6676 229.191 82.9901 228.868C83.3127 228.546 83.5685 228.163 83.743 227.742C83.9176 227.32 84.0074 226.869 84.0074 226.412C84.0074 225.956 83.9176 225.505 83.743 225.083C83.5685 224.662 83.3127 224.279 82.9901 223.956C82.6676 223.634 82.2847 223.378 81.8633 223.204C81.4419 223.029 80.9903 222.939 80.5341 222.939C80.078 222.939 79.6264 223.029 79.205 223.204C78.7836 223.378 78.4007 223.634 78.0782 223.956C77.7556 224.279 77.4998 224.662 77.3252 225.083C77.1507 225.505 77.0609 225.956 77.0609 226.412ZM84.0074 226.412C84.0074 227.334 84.3734 228.217 85.0247 228.868C85.6761 229.52 86.5596 229.886 87.4807 229.886C88.4019 229.886 89.2854 229.52 89.9367 228.868C90.5881 228.217 90.954 227.334 90.954 226.412C90.954 225.491 90.5881 224.608 89.9367 223.956C89.2854 223.305 88.4019 222.939 87.4807 222.939C86.5596 222.939 85.6761 223.305 85.0247 223.956C84.3734 224.608 84.0074 225.491 84.0074 226.412ZM97.9006 226.412C97.9006 226.869 97.9905 227.32 98.165 227.742C98.3396 228.163 98.5954 228.546 98.9179 228.868C99.2404 229.191 99.6233 229.447 100.045 229.621C100.466 229.796 100.918 229.886 101.374 229.886C101.83 229.886 102.282 229.796 102.703 229.621C103.124 229.447 103.507 229.191 103.83 228.868C104.152 228.546 104.408 228.163 104.583 227.742C104.757 227.32 104.847 226.869 104.847 226.412C104.847 225.956 104.757 225.505 104.583 225.083C104.408 224.662 104.152 224.279 103.83 223.956C103.507 223.634 103.124 223.378 102.703 223.204C102.282 223.029 101.83 222.939 101.374 222.939C100.918 222.939 100.466 223.029 100.045 223.204C99.6233 223.378 99.2404 223.634 98.9179 223.956C98.5954 224.279 98.3396 224.662 98.165 225.083C97.9905 225.505 97.9006 225.956 97.9006 226.412ZM111.794 226.412C111.794 227.334 112.16 228.217 112.811 228.868C113.462 229.52 114.346 229.886 115.267 229.886C116.188 229.886 117.072 229.52 117.723 228.868C118.374 228.217 118.74 227.334 118.74 226.412C118.74 225.491 118.374 224.608 117.723 223.956C117.072 223.305 116.188 222.939 115.267 222.939C114.346 222.939 113.462 223.305 112.811 223.956C112.16 224.608 111.794 225.491 111.794 226.412ZM125.687 226.412C125.687 227.334 126.053 228.217 126.704 228.868C127.356 229.52 128.239 229.886 129.16 229.886C130.081 229.886 130.965 229.52 131.616 228.868C132.268 228.217 132.634 227.334 132.634 226.412C132.634 225.491 132.268 224.608 131.616 223.956C130.965 223.305 130.081 222.939 129.16 222.939C128.239 222.939 127.356 223.305 126.704 223.956C126.053 224.608 125.687 225.491 125.687 226.412ZM132.634 226.412C132.634 227.334 132.999 228.217 133.651 228.868C134.302 229.52 135.186 229.886 136.107 229.886C137.028 229.886 137.911 229.52 138.563 228.868C139.214 228.217 139.58 227.334 139.58 226.412C139.58 225.491 139.214 224.608 138.563 223.956C137.911 223.305 137.028 222.939 136.107 222.939C135.186 222.939 134.302 223.305 133.651 223.956C132.999 224.608 132.634 225.491 132.634 226.412ZM160.42 226.412C160.42 227.334 160.786 228.217 161.437 228.868C162.089 229.52 162.972 229.886 163.893 229.886C164.814 229.886 165.698 229.52 166.349 228.868C167.001 228.217 167.366 227.334 167.366 226.412C167.366 225.491 167.001 224.608 166.349 223.956C165.698 223.305 164.814 222.939 163.893 222.939C162.972 222.939 162.089 223.305 161.437 223.956C160.786 224.608 160.42 225.491 160.42 226.412ZM195.153 226.412C195.153 226.869 195.243 227.32 195.417 227.742C195.592 228.163 195.848 228.546 196.17 228.868C196.493 229.191 196.876 229.447 197.297 229.621C197.718 229.796 198.17 229.886 198.626 229.886C199.082 229.886 199.534 229.796 199.955 229.621C200.377 229.447 200.76 229.191 201.082 228.868C201.405 228.546 201.661 228.163 201.835 227.742C202.01 227.32 202.099 226.869 202.099 226.412C202.099 225.956 202.01 225.505 201.835 225.083C201.661 224.662 201.405 224.279 201.082 223.956C200.76 223.634 200.377 223.378 199.955 223.204C199.534 223.029 199.082 222.939 198.626 222.939C198.17 222.939 197.718 223.029 197.297 223.204C196.876 223.378 196.493 223.634 196.17 223.956C195.848 224.279 195.592 224.662 195.417 225.083C195.243 225.505 195.153 225.956 195.153 226.412ZM202.099 226.412C202.099 227.334 202.465 228.217 203.117 228.868C203.768 229.52 204.652 229.886 205.573 229.886C206.494 229.886 207.377 229.52 208.029 228.868C208.68 228.217 209.046 227.334 209.046 226.412C209.046 225.491 208.68 224.608 208.029 223.956C207.377 223.305 206.494 222.939 205.573 222.939C204.652 222.939 203.768 223.305 203.117 223.956C202.465 224.608 202.099 225.491 202.099 226.412ZM209.046 226.412C209.046 227.334 209.412 228.217 210.063 228.868C210.715 229.52 211.598 229.886 212.519 229.886C213.44 229.886 214.324 229.52 214.975 228.868C215.627 228.217 215.993 227.334 215.993 226.412C215.993 225.491 215.627 224.608 214.975 223.956C214.324 223.305 213.44 222.939 212.519 222.939C211.598 222.939 210.715 223.305 210.063 223.956C209.412 224.608 209.046 225.491 209.046 226.412ZM222.939 226.412C222.939 227.334 223.305 228.217 223.957 228.868C224.608 229.52 225.491 229.886 226.413 229.886C227.334 229.886 228.217 229.52 228.868 228.868C229.52 228.217 229.886 227.334 229.886 226.412C229.886 225.491 229.52 224.608 228.868 223.956C228.217 223.305 227.334 222.939 226.413 222.939C225.491 222.939 224.608 223.305 223.957 223.956C223.305 224.608 222.939 225.491 222.939 226.412ZM229.886 226.412C229.886 227.334 230.252 228.217 230.903 228.868C231.554 229.52 232.438 229.886 233.359 229.886C234.28 229.886 235.164 229.52 235.815 228.868C236.466 228.217 236.832 227.334 236.832 226.412C236.832 225.491 236.466 224.608 235.815 223.956C235.164 223.305 234.28 222.939 233.359 222.939C232.438 222.939 231.554 223.305 230.903 223.956C230.252 224.608 229.886 225.491 229.886 226.412ZM236.832 226.412C236.832 227.334 237.198 228.217 237.85 228.868C238.501 229.52 239.384 229.886 240.306 229.886C241.227 229.886 242.11 229.52 242.762 228.868C243.413 228.217 243.779 227.334 243.779 226.412C243.779 225.491 243.413 224.608 242.762 223.956C242.11 223.305 241.227 222.939 240.306 222.939C239.384 222.939 238.501 223.305 237.85 223.956C237.198 224.608 236.832 225.491 236.832 226.412ZM257.672 226.412C257.672 227.334 258.038 228.217 258.689 228.868C259.341 229.52 260.224 229.886 261.145 229.886C262.067 229.886 262.95 229.52 263.601 228.868C264.253 228.217 264.619 227.334 264.619 226.412C264.619 225.491 264.253 224.608 263.601 223.956C262.95 223.305 262.067 222.939 261.145 222.939C260.224 222.939 259.341 223.305 258.689 223.956C258.038 224.608 257.672 225.491 257.672 226.412ZM264.619 226.412C264.619 227.334 264.985 228.217 265.636 228.868C266.287 229.52 267.171 229.886 268.092 229.886C269.013 229.886 269.897 229.52 270.548 228.868C271.199 228.217 271.565 227.334 271.565 226.412C271.565 225.491 271.199 224.608 270.548 223.956C269.897 223.305 269.013 222.939 268.092 222.939C267.171 222.939 266.287 223.305 265.636 223.956C264.985 224.608 264.619 225.491 264.619 226.412ZM7.59497 233.359C7.59497 234.28 7.96091 235.164 8.61227 235.815C9.26364 236.466 10.1471 236.832 11.0683 236.832C11.9894 236.832 12.8729 236.466 13.5243 235.815C14.1756 235.164 14.5416 234.28 14.5416 233.359C14.5416 232.438 14.1756 231.554 13.5243 230.903C12.8729 230.252 11.9894 229.886 11.0683 229.886C10.1471 229.886 9.26364 230.252 8.61227 230.903C7.96091 231.554 7.59497 232.438 7.59497 233.359ZM14.5416 233.359C14.5416 234.28 14.9075 235.164 15.5589 235.815C16.2102 236.466 17.0937 236.832 18.0149 236.832C18.936 236.832 19.8195 236.466 20.4708 235.815C21.1222 235.164 21.4881 234.28 21.4881 233.359C21.4881 232.438 21.1222 231.554 20.4708 230.903C19.8195 230.252 18.936 229.886 18.0149 229.886C17.0937 229.886 16.2102 230.252 15.5589 230.903C14.9075 231.554 14.5416 232.438 14.5416 233.359ZM42.3279 233.359C42.3279 233.815 42.4177 234.267 42.5923 234.688C42.7668 235.11 43.0227 235.493 43.3452 235.815C43.6677 236.138 44.0506 236.393 44.472 236.568C44.8934 236.743 45.3451 236.832 45.8012 236.832C46.2573 236.832 46.709 236.743 47.1304 236.568C47.5518 236.393 47.9347 236.138 48.2572 235.815C48.5797 235.493 48.8356 235.11 49.0101 234.688C49.1847 234.267 49.2745 233.815 49.2745 233.359C49.2745 232.903 49.1847 232.451 49.0101 232.03C48.8356 231.608 48.5797 231.226 48.2572 230.903C47.9347 230.581 47.5518 230.325 47.1304 230.15C46.709 229.976 46.2573 229.886 45.8012 229.886C45.3451 229.886 44.8934 229.976 44.472 230.15C44.0506 230.325 43.6677 230.581 43.3452 230.903C43.0227 231.226 42.7668 231.608 42.5923 232.03C42.4177 232.451 42.3279 232.903 42.3279 233.359ZM49.2745 233.359C49.2745 233.815 49.3643 234.267 49.5389 234.688C49.7134 235.11 49.9693 235.493 50.2918 235.815C50.6143 236.138 50.9972 236.393 51.4186 236.568C51.84 236.743 52.2917 236.832 52.7478 236.832C53.2039 236.832 53.6556 236.743 54.077 236.568C54.4984 236.393 54.8813 236.138 55.2038 235.815C55.5263 235.493 55.7821 235.11 55.9567 234.688C56.1312 234.267 56.2211 233.815 56.2211 233.359C56.2211 232.903 56.1312 232.451 55.9567 232.03C55.7821 231.608 55.5263 231.226 55.2038 230.903C54.8813 230.581 54.4984 230.325 54.077 230.15C53.6556 229.976 53.2039 229.886 52.7478 229.886C52.2917 229.886 51.84 229.976 51.4186 230.15C50.9972 230.325 50.6143 230.581 50.2918 230.903C49.9693 231.226 49.7134 231.608 49.5389 232.03C49.3643 232.451 49.2745 232.903 49.2745 233.359ZM70.1143 233.359C70.1143 234.28 70.4802 235.164 71.1316 235.815C71.7829 236.466 72.6664 236.832 73.5876 236.832C74.5087 236.832 75.3922 236.466 76.0436 235.815C76.6949 235.164 77.0609 234.28 77.0609 233.359C77.0609 232.438 76.6949 231.554 76.0436 230.903C75.3922 230.252 74.5087 229.886 73.5876 229.886C72.6664 229.886 71.7829 230.252 71.1316 230.903C70.4802 231.554 70.1143 232.438 70.1143 233.359ZM84.0074 233.359C84.0074 234.28 84.3734 235.164 85.0247 235.815C85.6761 236.466 86.5596 236.832 87.4807 236.832C88.4019 236.832 89.2854 236.466 89.9367 235.815C90.5881 235.164 90.954 234.28 90.954 233.359C90.954 232.438 90.5881 231.554 89.9367 230.903C89.2854 230.252 88.4019 229.886 87.4807 229.886C86.5596 229.886 85.6761 230.252 85.0247 230.903C84.3734 231.554 84.0074 232.438 84.0074 233.359ZM90.954 233.359C90.954 234.28 91.32 235.164 91.9713 235.815C92.6227 236.466 93.5061 236.832 94.4273 236.832C95.3485 236.832 96.2319 236.466 96.8833 235.815C97.5347 235.164 97.9006 234.28 97.9006 233.359C97.9006 232.438 97.5347 231.554 96.8833 230.903C96.2319 230.252 95.3485 229.886 94.4273 229.886C93.5061 229.886 92.6227 230.252 91.9713 230.903C91.32 231.554 90.954 232.438 90.954 233.359ZM146.527 233.359C146.527 234.28 146.893 235.164 147.544 235.815C148.195 236.466 149.079 236.832 150 236.832C150.921 236.832 151.805 236.466 152.456 235.815C153.107 235.164 153.473 234.28 153.473 233.359C153.473 232.438 153.107 231.554 152.456 230.903C151.805 230.252 150.921 229.886 150 229.886C149.079 229.886 148.195 230.252 147.544 230.903C146.893 231.554 146.527 232.438 146.527 233.359ZM153.473 233.359C153.473 233.815 153.563 234.267 153.738 234.688C153.912 235.11 154.168 235.493 154.491 235.815C154.813 236.138 155.196 236.393 155.617 236.568C156.039 236.743 156.491 236.832 156.947 236.832C157.403 236.832 157.854 236.743 158.276 236.568C158.697 236.393 159.08 236.138 159.403 235.815C159.725 235.493 159.981 235.11 160.156 234.688C160.33 234.267 160.42 233.815 160.42 233.359C160.42 232.903 160.33 232.451 160.156 232.03C159.981 231.608 159.725 231.226 159.403 230.903C159.08 230.581 158.697 230.325 158.276 230.15C157.854 229.976 157.403 229.886 156.947 229.886C156.491 229.886 156.039 229.976 155.617 230.15C155.196 230.325 154.813 230.581 154.491 230.903C154.168 231.226 153.912 231.608 153.738 232.03C153.563 232.451 153.473 232.903 153.473 233.359ZM167.366 233.359C167.366 234.28 167.732 235.164 168.384 235.815C169.035 236.466 169.919 236.832 170.84 236.832C171.761 236.832 172.644 236.466 173.296 235.815C173.947 235.164 174.313 234.28 174.313 233.359C174.313 232.438 173.947 231.554 173.296 230.903C172.644 230.252 171.761 229.886 170.84 229.886C169.919 229.886 169.035 230.252 168.384 230.903C167.732 231.554 167.366 232.438 167.366 233.359ZM181.26 233.359C181.26 234.28 181.626 235.164 182.277 235.815C182.928 236.466 183.812 236.832 184.733 236.832C185.654 236.832 186.538 236.466 187.189 235.815C187.84 235.164 188.206 234.28 188.206 233.359C188.206 232.438 187.84 231.554 187.189 230.903C186.538 230.252 185.654 229.886 184.733 229.886C183.812 229.886 182.928 230.252 182.277 230.903C181.626 231.554 181.26 232.438 181.26 233.359ZM188.206 233.359C188.206 234.28 188.572 235.164 189.224 235.815C189.875 236.466 190.758 236.832 191.68 236.832C192.601 236.832 193.484 236.466 194.136 235.815C194.787 235.164 195.153 234.28 195.153 233.359C195.153 232.438 194.787 231.554 194.136 230.903C193.484 230.252 192.601 229.886 191.68 229.886C190.758 229.886 189.875 230.252 189.224 230.903C188.572 231.554 188.206 232.438 188.206 233.359ZM209.046 233.359C209.046 234.28 209.412 235.164 210.063 235.815C210.715 236.466 211.598 236.832 212.519 236.832C213.44 236.832 214.324 236.466 214.975 235.815C215.627 235.164 215.993 234.28 215.993 233.359C215.993 232.438 215.627 231.554 214.975 230.903C214.324 230.252 213.44 229.886 212.519 229.886C211.598 229.886 210.715 230.252 210.063 230.903C209.412 231.554 209.046 232.438 209.046 233.359ZM229.886 233.359C229.886 234.28 230.252 235.164 230.903 235.815C231.554 236.466 232.438 236.832 233.359 236.832C234.28 236.832 235.164 236.466 235.815 235.815C236.466 235.164 236.832 234.28 236.832 233.359C236.832 232.438 236.466 231.554 235.815 230.903C235.164 230.252 234.28 229.886 233.359 229.886C232.438 229.886 231.554 230.252 230.903 230.903C230.252 231.554 229.886 232.438 229.886 233.359ZM236.832 233.359C236.832 234.28 237.198 235.164 237.85 235.815C238.501 236.466 239.384 236.832 240.306 236.832C241.227 236.832 242.11 236.466 242.762 235.815C243.413 235.164 243.779 234.28 243.779 233.359C243.779 232.438 243.413 231.554 242.762 230.903C242.11 230.252 241.227 229.886 240.306 229.886C239.384 229.886 238.501 230.252 237.85 230.903C237.198 231.554 236.832 232.438 236.832 233.359ZM243.779 233.359C243.779 234.28 244.145 235.164 244.796 235.815C245.448 236.466 246.331 236.832 247.252 236.832C248.173 236.832 249.057 236.466 249.708 235.815C250.36 235.164 250.726 234.28 250.726 233.359C250.726 232.438 250.36 231.554 249.708 230.903C249.057 230.252 248.173 229.886 247.252 229.886C246.331 229.886 245.448 230.252 244.796 230.903C244.145 231.554 243.779 232.438 243.779 233.359ZM250.726 233.359C250.726 234.28 251.091 235.164 251.743 235.815C252.394 236.466 253.278 236.832 254.199 236.832C255.12 236.832 256.003 236.466 256.655 235.815C257.306 235.164 257.672 234.28 257.672 233.359C257.672 232.438 257.306 231.554 256.655 230.903C256.003 230.252 255.12 229.886 254.199 229.886C253.278 229.886 252.394 230.252 251.743 230.903C251.091 231.554 250.726 232.438 250.726 233.359ZM257.672 233.359C257.672 234.28 258.038 235.164 258.689 235.815C259.341 236.466 260.224 236.832 261.145 236.832C262.067 236.832 262.95 236.466 263.601 235.815C264.253 235.164 264.619 234.28 264.619 233.359C264.619 232.438 264.253 231.554 263.601 230.903C262.95 230.252 262.067 229.886 261.145 229.886C260.224 229.886 259.341 230.252 258.689 230.903C258.038 231.554 257.672 232.438 257.672 233.359ZM264.619 233.359C264.619 234.28 264.985 235.164 265.636 235.815C266.287 236.466 267.171 236.832 268.092 236.832C269.013 236.832 269.897 236.466 270.548 235.815C271.199 235.164 271.565 234.28 271.565 233.359C271.565 232.438 271.199 231.554 270.548 230.903C269.897 230.252 269.013 229.886 268.092 229.886C267.171 229.886 266.287 230.252 265.636 230.903C264.985 231.554 264.619 232.438 264.619 233.359ZM285.458 233.359C285.458 234.28 285.824 235.164 286.476 235.815C287.127 236.466 288.011 236.832 288.932 236.832C289.853 236.832 290.736 236.466 291.388 235.815C292.039 235.164 292.405 234.28 292.405 233.359C292.405 232.438 292.039 231.554 291.388 230.903C290.736 230.252 289.853 229.886 288.932 229.886C288.011 229.886 287.127 230.252 286.476 230.903C285.824 231.554 285.458 232.438 285.458 233.359ZM63.1677 240.306C63.1677 241.227 63.5336 242.11 64.185 242.762C64.8363 243.413 65.7198 243.779 66.641 243.779C67.5621 243.779 68.4456 243.413 69.097 242.762C69.7483 242.11 70.1143 241.227 70.1143 240.306C70.1143 239.384 69.7483 238.501 69.097 237.85C68.4456 237.198 67.5621 236.832 66.641 236.832C65.7198 236.832 64.8363 237.198 64.185 237.85C63.5336 238.501 63.1677 239.384 63.1677 240.306ZM84.0074 240.306C84.0074 241.227 84.3734 242.11 85.0247 242.762C85.6761 243.413 86.5596 243.779 87.4807 243.779C88.4019 243.779 89.2854 243.413 89.9367 242.762C90.5881 242.11 90.954 241.227 90.954 240.306C90.954 239.384 90.5881 238.501 89.9367 237.85C89.2854 237.198 88.4019 236.832 87.4807 236.832C86.5596 236.832 85.6761 237.198 85.0247 237.85C84.3734 238.501 84.0074 239.384 84.0074 240.306ZM90.954 240.306C90.954 241.227 91.32 242.11 91.9713 242.762C92.6227 243.413 93.5061 243.779 94.4273 243.779C95.3485 243.779 96.2319 243.413 96.8833 242.762C97.5347 242.11 97.9006 241.227 97.9006 240.306C97.9006 239.384 97.5347 238.501 96.8833 237.85C96.2319 237.198 95.3485 236.832 94.4273 236.832C93.5061 236.832 92.6227 237.198 91.9713 237.85C91.32 238.501 90.954 239.384 90.954 240.306ZM104.847 240.306C104.847 241.227 105.213 242.11 105.865 242.762C106.516 243.413 107.399 243.779 108.321 243.779C109.242 243.779 110.125 243.413 110.776 242.762C111.428 242.11 111.794 241.227 111.794 240.306C111.794 239.384 111.428 238.501 110.776 237.85C110.125 237.198 109.242 236.832 108.321 236.832C107.399 236.832 106.516 237.198 105.865 237.85C105.213 238.501 104.847 239.384 104.847 240.306ZM132.634 240.306C132.634 241.227 132.999 242.11 133.651 242.762C134.302 243.413 135.186 243.779 136.107 243.779C137.028 243.779 137.911 243.413 138.563 242.762C139.214 242.11 139.58 241.227 139.58 240.306C139.58 239.384 139.214 238.501 138.563 237.85C137.911 237.198 137.028 236.832 136.107 236.832C135.186 236.832 134.302 237.198 133.651 237.85C132.999 238.501 132.634 239.384 132.634 240.306ZM146.527 240.306C146.527 241.227 146.893 242.11 147.544 242.762C148.195 243.413 149.079 243.779 150 243.779C150.921 243.779 151.805 243.413 152.456 242.762C153.107 242.11 153.473 241.227 153.473 240.306C153.473 239.384 153.107 238.501 152.456 237.85C151.805 237.198 150.921 236.832 150 236.832C149.079 236.832 148.195 237.198 147.544 237.85C146.893 238.501 146.527 239.384 146.527 240.306ZM153.473 240.306C153.473 240.762 153.563 241.213 153.738 241.635C153.912 242.056 154.168 242.439 154.491 242.762C154.813 243.084 155.196 243.34 155.617 243.515C156.039 243.689 156.491 243.779 156.947 243.779C157.403 243.779 157.854 243.689 158.276 243.515C158.697 243.34 159.08 243.084 159.403 242.762C159.725 242.439 159.981 242.056 160.156 241.635C160.33 241.213 160.42 240.762 160.42 240.306C160.42 239.85 160.33 239.398 160.156 238.976C159.981 238.555 159.725 238.172 159.403 237.85C159.08 237.527 158.697 237.271 158.276 237.097C157.854 236.922 157.403 236.832 156.947 236.832C156.491 236.832 156.039 236.922 155.617 237.097C155.196 237.271 154.813 237.527 154.491 237.85C154.168 238.172 153.912 238.555 153.738 238.976C153.563 239.398 153.473 239.85 153.473 240.306ZM160.42 240.306C160.42 241.227 160.786 242.11 161.437 242.762C162.089 243.413 162.972 243.779 163.893 243.779C164.814 243.779 165.698 243.413 166.349 242.762C167.001 242.11 167.366 241.227 167.366 240.306C167.366 239.384 167.001 238.501 166.349 237.85C165.698 237.198 164.814 236.832 163.893 236.832C162.972 236.832 162.089 237.198 161.437 237.85C160.786 238.501 160.42 239.384 160.42 240.306ZM188.206 240.306C188.206 241.227 188.572 242.11 189.224 242.762C189.875 243.413 190.758 243.779 191.68 243.779C192.601 243.779 193.484 243.413 194.136 242.762C194.787 242.11 195.153 241.227 195.153 240.306C195.153 239.384 194.787 238.501 194.136 237.85C193.484 237.198 192.601 236.832 191.68 236.832C190.758 236.832 189.875 237.198 189.224 237.85C188.572 238.501 188.206 239.384 188.206 240.306ZM195.153 240.306C195.153 240.762 195.243 241.213 195.417 241.635C195.592 242.056 195.848 242.439 196.17 242.762C196.493 243.084 196.876 243.34 197.297 243.515C197.718 243.689 198.17 243.779 198.626 243.779C199.082 243.779 199.534 243.689 199.955 243.515C200.377 243.34 200.76 243.084 201.082 242.762C201.405 242.439 201.661 242.056 201.835 241.635C202.01 241.213 202.099 240.762 202.099 240.306C202.099 239.85 202.01 239.398 201.835 238.976C201.661 238.555 201.405 238.172 201.082 237.85C200.76 237.527 200.377 237.271 199.955 237.097C199.534 236.922 199.082 236.832 198.626 236.832C198.17 236.832 197.718 236.922 197.297 237.097C196.876 237.271 196.493 237.527 196.17 237.85C195.848 238.172 195.592 238.555 195.417 238.976C195.243 239.398 195.153 239.85 195.153 240.306ZM202.099 240.306C202.099 241.227 202.465 242.11 203.117 242.762C203.768 243.413 204.652 243.779 205.573 243.779C206.494 243.779 207.377 243.413 208.029 242.762C208.68 242.11 209.046 241.227 209.046 240.306C209.046 239.384 208.68 238.501 208.029 237.85C207.377 237.198 206.494 236.832 205.573 236.832C204.652 236.832 203.768 237.198 203.117 237.85C202.465 238.501 202.099 239.384 202.099 240.306ZM209.046 240.306C209.046 241.227 209.412 242.11 210.063 242.762C210.715 243.413 211.598 243.779 212.519 243.779C213.44 243.779 214.324 243.413 214.975 242.762C215.627 242.11 215.993 241.227 215.993 240.306C215.993 239.384 215.627 238.501 214.975 237.85C214.324 237.198 213.44 236.832 212.519 236.832C211.598 236.832 210.715 237.198 210.063 237.85C209.412 238.501 209.046 239.384 209.046 240.306ZM229.886 240.306C229.886 241.227 230.252 242.11 230.903 242.762C231.554 243.413 232.438 243.779 233.359 243.779C234.28 243.779 235.164 243.413 235.815 242.762C236.466 242.11 236.832 241.227 236.832 240.306C236.832 239.384 236.466 238.501 235.815 237.85C235.164 237.198 234.28 236.832 233.359 236.832C232.438 236.832 231.554 237.198 230.903 237.85C230.252 238.501 229.886 239.384 229.886 240.306ZM257.672 240.306C257.672 241.227 258.038 242.11 258.689 242.762C259.341 243.413 260.224 243.779 261.145 243.779C262.067 243.779 262.95 243.413 263.601 242.762C264.253 242.11 264.619 241.227 264.619 240.306C264.619 239.384 264.253 238.501 263.601 237.85C262.95 237.198 262.067 236.832 261.145 236.832C260.224 236.832 259.341 237.198 258.689 237.85C258.038 238.501 257.672 239.384 257.672 240.306ZM271.565 240.306C271.565 241.227 271.931 242.11 272.583 242.762C273.234 243.413 274.117 243.779 275.039 243.779C275.96 243.779 276.843 243.413 277.495 242.762C278.146 242.11 278.512 241.227 278.512 240.306C278.512 239.384 278.146 238.501 277.495 237.85C276.843 237.198 275.96 236.832 275.039 236.832C274.117 236.832 273.234 237.198 272.583 237.85C271.931 238.501 271.565 239.384 271.565 240.306ZM278.512 240.306C278.512 241.227 278.878 242.11 279.529 242.762C280.181 243.413 281.064 243.779 281.985 243.779C282.906 243.779 283.79 243.413 284.441 242.762C285.093 242.11 285.458 241.227 285.458 240.306C285.458 239.384 285.093 238.501 284.441 237.85C283.79 237.198 282.906 236.832 281.985 236.832C281.064 236.832 280.181 237.198 279.529 237.85C278.878 238.501 278.512 239.384 278.512 240.306ZM285.458 240.306C285.458 241.227 285.824 242.11 286.476 242.762C287.127 243.413 288.011 243.779 288.932 243.779C289.853 243.779 290.736 243.413 291.388 242.762C292.039 242.11 292.405 241.227 292.405 240.306C292.405 239.384 292.039 238.501 291.388 237.85C290.736 237.198 289.853 236.832 288.932 236.832C288.011 236.832 287.127 237.198 286.476 237.85C285.824 238.501 285.458 239.384 285.458 240.306ZM7.59497 247.252C7.59497 248.173 7.96091 249.057 8.61227 249.708C9.26364 250.36 10.1471 250.726 11.0683 250.726C11.9894 250.726 12.8729 250.36 13.5243 249.708C14.1756 249.057 14.5416 248.173 14.5416 247.252C14.5416 246.331 14.1756 245.448 13.5243 244.796C12.8729 244.145 11.9894 243.779 11.0683 243.779C10.1471 243.779 9.26364 244.145 8.61227 244.796C7.96091 245.448 7.59497 246.331 7.59497 247.252ZM14.5416 247.252C14.5416 248.173 14.9075 249.057 15.5589 249.708C16.2102 250.36 17.0937 250.726 18.0149 250.726C18.936 250.726 19.8195 250.36 20.4708 249.708C21.1222 249.057 21.4881 248.173 21.4881 247.252C21.4881 246.331 21.1222 245.448 20.4708 244.796C19.8195 244.145 18.936 243.779 18.0149 243.779C17.0937 243.779 16.2102 244.145 15.5589 244.796C14.9075 245.448 14.5416 246.331 14.5416 247.252ZM21.4881 247.252C21.4881 248.173 21.8541 249.057 22.5055 249.708C23.1568 250.36 24.0403 250.726 24.9614 250.726C25.8826 250.726 26.7661 250.36 27.4174 249.708C28.0688 249.057 28.4347 248.173 28.4347 247.252C28.4347 246.331 28.0688 245.448 27.4174 244.796C26.7661 244.145 25.8826 243.779 24.9614 243.779C24.0403 243.779 23.1568 244.145 22.5055 244.796C21.8541 245.448 21.4881 246.331 21.4881 247.252ZM28.4347 247.252C28.4347 248.173 28.8007 249.057 29.452 249.708C30.1034 250.36 30.9869 250.726 31.908 250.726C32.8292 250.726 33.7126 250.36 34.364 249.708C35.0154 249.057 35.3813 248.173 35.3813 247.252C35.3813 246.331 35.0154 245.448 34.364 244.796C33.7126 244.145 32.8292 243.779 31.908 243.779C30.9869 243.779 30.1034 244.145 29.452 244.796C28.8007 245.448 28.4347 246.331 28.4347 247.252ZM35.3813 247.252C35.3813 248.173 35.7473 249.057 36.3986 249.708C37.05 250.36 37.9334 250.726 38.8546 250.726C39.7758 250.726 40.6592 250.36 41.3106 249.708C41.962 249.057 42.3279 248.173 42.3279 247.252C42.3279 246.331 41.962 245.448 41.3106 244.796C40.6592 244.145 39.7758 243.779 38.8546 243.779C37.9334 243.779 37.05 244.145 36.3986 244.796C35.7473 245.448 35.3813 246.331 35.3813 247.252ZM42.3279 247.252C42.3279 247.708 42.4177 248.16 42.5923 248.581C42.7668 249.003 43.0227 249.386 43.3452 249.708C43.6677 250.031 44.0506 250.287 44.472 250.461C44.8934 250.636 45.3451 250.726 45.8012 250.726C46.2573 250.726 46.709 250.636 47.1304 250.461C47.5518 250.287 47.9347 250.031 48.2572 249.708C48.5797 249.386 48.8356 249.003 49.0101 248.581C49.1847 248.16 49.2745 247.708 49.2745 247.252C49.2745 246.796 49.1847 246.344 49.0101 245.923C48.8356 245.502 48.5797 245.119 48.2572 244.796C47.9347 244.474 47.5518 244.218 47.1304 244.043C46.709 243.869 46.2573 243.779 45.8012 243.779C45.3451 243.779 44.8934 243.869 44.472 244.043C44.0506 244.218 43.6677 244.474 43.3452 244.796C43.0227 245.119 42.7668 245.502 42.5923 245.923C42.4177 246.344 42.3279 246.796 42.3279 247.252ZM49.2745 247.252C49.2745 247.708 49.3643 248.16 49.5389 248.581C49.7134 249.003 49.9693 249.386 50.2918 249.708C50.6143 250.031 50.9972 250.287 51.4186 250.461C51.84 250.636 52.2917 250.726 52.7478 250.726C53.2039 250.726 53.6556 250.636 54.077 250.461C54.4984 250.287 54.8813 250.031 55.2038 249.708C55.5263 249.386 55.7821 249.003 55.9567 248.581C56.1312 248.16 56.2211 247.708 56.2211 247.252C56.2211 246.796 56.1312 246.344 55.9567 245.923C55.7821 245.502 55.5263 245.119 55.2038 244.796C54.8813 244.474 54.4984 244.218 54.077 244.043C53.6556 243.869 53.2039 243.779 52.7478 243.779C52.2917 243.779 51.84 243.869 51.4186 244.043C50.9972 244.218 50.6143 244.474 50.2918 244.796C49.9693 245.119 49.7134 245.502 49.5389 245.923C49.3643 246.344 49.2745 246.796 49.2745 247.252ZM63.1677 247.252C63.1677 248.173 63.5336 249.057 64.185 249.708C64.8363 250.36 65.7198 250.726 66.641 250.726C67.5621 250.726 68.4456 250.36 69.097 249.708C69.7483 249.057 70.1143 248.173 70.1143 247.252C70.1143 246.331 69.7483 245.448 69.097 244.796C68.4456 244.145 67.5621 243.779 66.641 243.779C65.7198 243.779 64.8363 244.145 64.185 244.796C63.5336 245.448 63.1677 246.331 63.1677 247.252ZM77.0609 247.252C77.0609 247.708 77.1507 248.16 77.3252 248.581C77.4998 249.003 77.7556 249.386 78.0782 249.708C78.4007 250.031 78.7836 250.287 79.205 250.461C79.6264 250.636 80.078 250.726 80.5341 250.726C80.9903 250.726 81.4419 250.636 81.8633 250.461C82.2847 250.287 82.6676 250.031 82.9901 249.708C83.3127 249.386 83.5685 249.003 83.743 248.581C83.9176 248.16 84.0074 247.708 84.0074 247.252C84.0074 246.796 83.9176 246.344 83.743 245.923C83.5685 245.502 83.3127 245.119 82.9901 244.796C82.6676 244.474 82.2847 244.218 81.8633 244.043C81.4419 243.869 80.9903 243.779 80.5341 243.779C80.078 243.779 79.6264 243.869 79.205 244.043C78.7836 244.218 78.4007 244.474 78.0782 244.796C77.7556 245.119 77.4998 245.502 77.3252 245.923C77.1507 246.344 77.0609 246.796 77.0609 247.252ZM84.0074 247.252C84.0074 248.173 84.3734 249.057 85.0247 249.708C85.6761 250.36 86.5596 250.726 87.4807 250.726C88.4019 250.726 89.2854 250.36 89.9367 249.708C90.5881 249.057 90.954 248.173 90.954 247.252C90.954 246.331 90.5881 245.448 89.9367 244.796C89.2854 244.145 88.4019 243.779 87.4807 243.779C86.5596 243.779 85.6761 244.145 85.0247 244.796C84.3734 245.448 84.0074 246.331 84.0074 247.252ZM90.954 247.252C90.954 248.173 91.32 249.057 91.9713 249.708C92.6227 250.36 93.5061 250.726 94.4273 250.726C95.3485 250.726 96.2319 250.36 96.8833 249.708C97.5347 249.057 97.9006 248.173 97.9006 247.252C97.9006 246.331 97.5347 245.448 96.8833 244.796C96.2319 244.145 95.3485 243.779 94.4273 243.779C93.5061 243.779 92.6227 244.145 91.9713 244.796C91.32 245.448 90.954 246.331 90.954 247.252ZM104.847 247.252C104.847 248.173 105.213 249.057 105.865 249.708C106.516 250.36 107.399 250.726 108.321 250.726C109.242 250.726 110.125 250.36 110.776 249.708C111.428 249.057 111.794 248.173 111.794 247.252C111.794 246.331 111.428 245.448 110.776 244.796C110.125 244.145 109.242 243.779 108.321 243.779C107.399 243.779 106.516 244.145 105.865 244.796C105.213 245.448 104.847 246.331 104.847 247.252ZM132.634 247.252C132.634 248.173 132.999 249.057 133.651 249.708C134.302 250.36 135.186 250.726 136.107 250.726C137.028 250.726 137.911 250.36 138.563 249.708C139.214 249.057 139.58 248.173 139.58 247.252C139.58 246.331 139.214 245.448 138.563 244.796C137.911 244.145 137.028 243.779 136.107 243.779C135.186 243.779 134.302 244.145 133.651 244.796C132.999 245.448 132.634 246.331 132.634 247.252ZM153.473 247.252C153.473 247.708 153.563 248.16 153.738 248.581C153.912 249.003 154.168 249.386 154.491 249.708C154.813 250.031 155.196 250.287 155.617 250.461C156.039 250.636 156.491 250.726 156.947 250.726C157.403 250.726 157.854 250.636 158.276 250.461C158.697 250.287 159.08 250.031 159.403 249.708C159.725 249.386 159.981 249.003 160.156 248.581C160.33 248.16 160.42 247.708 160.42 247.252C160.42 246.796 160.33 246.344 160.156 245.923C159.981 245.502 159.725 245.119 159.403 244.796C159.08 244.474 158.697 244.218 158.276 244.043C157.854 243.869 157.403 243.779 156.947 243.779C156.491 243.779 156.039 243.869 155.617 244.043C155.196 244.218 154.813 244.474 154.491 244.796C154.168 245.119 153.912 245.502 153.738 245.923C153.563 246.344 153.473 246.796 153.473 247.252ZM167.366 247.252C167.366 248.173 167.732 249.057 168.384 249.708C169.035 250.36 169.919 250.726 170.84 250.726C171.761 250.726 172.644 250.36 173.296 249.708C173.947 249.057 174.313 248.173 174.313 247.252C174.313 246.331 173.947 245.448 173.296 244.796C172.644 244.145 171.761 243.779 170.84 243.779C169.919 243.779 169.035 244.145 168.384 244.796C167.732 245.448 167.366 246.331 167.366 247.252ZM174.313 247.252C174.313 248.173 174.679 249.057 175.33 249.708C175.982 250.36 176.865 250.726 177.786 250.726C178.708 250.726 179.591 250.36 180.242 249.708C180.894 249.057 181.26 248.173 181.26 247.252C181.26 246.331 180.894 245.448 180.242 244.796C179.591 244.145 178.708 243.779 177.786 243.779C176.865 243.779 175.982 244.145 175.33 244.796C174.679 245.448 174.313 246.331 174.313 247.252ZM188.206 247.252C188.206 248.173 188.572 249.057 189.224 249.708C189.875 250.36 190.758 250.726 191.68 250.726C192.601 250.726 193.484 250.36 194.136 249.708C194.787 249.057 195.153 248.173 195.153 247.252C195.153 246.331 194.787 245.448 194.136 244.796C193.484 244.145 192.601 243.779 191.68 243.779C190.758 243.779 189.875 244.145 189.224 244.796C188.572 245.448 188.206 246.331 188.206 247.252ZM195.153 247.252C195.153 247.708 195.243 248.16 195.417 248.581C195.592 249.003 195.848 249.386 196.17 249.708C196.493 250.031 196.876 250.287 197.297 250.461C197.718 250.636 198.17 250.726 198.626 250.726C199.082 250.726 199.534 250.636 199.955 250.461C200.377 250.287 200.76 250.031 201.082 249.708C201.405 249.386 201.661 249.003 201.835 248.581C202.01 248.16 202.099 247.708 202.099 247.252C202.099 246.796 202.01 246.344 201.835 245.923C201.661 245.502 201.405 245.119 201.082 244.796C200.76 244.474 200.377 244.218 199.955 244.043C199.534 243.869 199.082 243.779 198.626 243.779C198.17 243.779 197.718 243.869 197.297 244.043C196.876 244.218 196.493 244.474 196.17 244.796C195.848 245.119 195.592 245.502 195.417 245.923C195.243 246.344 195.153 246.796 195.153 247.252ZM215.993 247.252C215.993 248.173 216.359 249.057 217.01 249.708C217.661 250.36 218.545 250.726 219.466 250.726C220.387 250.726 221.271 250.36 221.922 249.708C222.573 249.057 222.939 248.173 222.939 247.252C222.939 246.331 222.573 245.448 221.922 244.796C221.271 244.145 220.387 243.779 219.466 243.779C218.545 243.779 217.661 244.145 217.01 244.796C216.359 245.448 215.993 246.331 215.993 247.252ZM222.939 247.252C222.939 248.173 223.305 249.057 223.957 249.708C224.608 250.36 225.491 250.726 226.413 250.726C227.334 250.726 228.217 250.36 228.868 249.708C229.52 249.057 229.886 248.173 229.886 247.252C229.886 246.331 229.52 245.448 228.868 244.796C228.217 244.145 227.334 243.779 226.413 243.779C225.491 243.779 224.608 244.145 223.957 244.796C223.305 245.448 222.939 246.331 222.939 247.252ZM229.886 247.252C229.886 248.173 230.252 249.057 230.903 249.708C231.554 250.36 232.438 250.726 233.359 250.726C234.28 250.726 235.164 250.36 235.815 249.708C236.466 249.057 236.832 248.173 236.832 247.252C236.832 246.331 236.466 245.448 235.815 244.796C235.164 244.145 234.28 243.779 233.359 243.779C232.438 243.779 231.554 244.145 230.903 244.796C230.252 245.448 229.886 246.331 229.886 247.252ZM243.779 247.252C243.779 248.173 244.145 249.057 244.796 249.708C245.448 250.36 246.331 250.726 247.252 250.726C248.173 250.726 249.057 250.36 249.708 249.708C250.36 249.057 250.726 248.173 250.726 247.252C250.726 246.331 250.36 245.448 249.708 244.796C249.057 244.145 248.173 243.779 247.252 243.779C246.331 243.779 245.448 244.145 244.796 244.796C244.145 245.448 243.779 246.331 243.779 247.252ZM257.672 247.252C257.672 248.173 258.038 249.057 258.689 249.708C259.341 250.36 260.224 250.726 261.145 250.726C262.067 250.726 262.95 250.36 263.601 249.708C264.253 249.057 264.619 248.173 264.619 247.252C264.619 246.331 264.253 245.448 263.601 244.796C262.95 244.145 262.067 243.779 261.145 243.779C260.224 243.779 259.341 244.145 258.689 244.796C258.038 245.448 257.672 246.331 257.672 247.252ZM264.619 247.252C264.619 248.173 264.985 249.057 265.636 249.708C266.287 250.36 267.171 250.726 268.092 250.726C269.013 250.726 269.897 250.36 270.548 249.708C271.199 249.057 271.565 248.173 271.565 247.252C271.565 246.331 271.199 245.448 270.548 244.796C269.897 244.145 269.013 243.779 268.092 243.779C267.171 243.779 266.287 244.145 265.636 244.796C264.985 245.448 264.619 246.331 264.619 247.252ZM285.458 247.252C285.458 248.173 285.824 249.057 286.476 249.708C287.127 250.36 288.011 250.726 288.932 250.726C289.853 250.726 290.736 250.36 291.388 249.708C292.039 249.057 292.405 248.173 292.405 247.252C292.405 246.331 292.039 245.448 291.388 244.796C290.736 244.145 289.853 243.779 288.932 243.779C288.011 243.779 287.127 244.145 286.476 244.796C285.824 245.448 285.458 246.331 285.458 247.252ZM7.59497 254.199C7.59497 255.12 7.96091 256.003 8.61227 256.655C9.26364 257.306 10.1471 257.672 11.0683 257.672C11.9894 257.672 12.8729 257.306 13.5243 256.655C14.1756 256.003 14.5416 255.12 14.5416 254.199C14.5416 253.278 14.1756 252.394 13.5243 251.743C12.8729 251.091 11.9894 250.726 11.0683 250.726C10.1471 250.726 9.26364 251.091 8.61227 251.743C7.96091 252.394 7.59497 253.278 7.59497 254.199ZM49.2745 254.199C49.2745 254.655 49.3643 255.107 49.5389 255.528C49.7134 255.949 49.9693 256.332 50.2918 256.655C50.6143 256.977 50.9972 257.233 51.4186 257.408C51.84 257.582 52.2917 257.672 52.7478 257.672C53.2039 257.672 53.6556 257.582 54.077 257.408C54.4984 257.233 54.8813 256.977 55.2038 256.655C55.5263 256.332 55.7821 255.949 55.9567 255.528C56.1312 255.107 56.2211 254.655 56.2211 254.199C56.2211 253.743 56.1312 253.291 55.9567 252.87C55.7821 252.448 55.5263 252.065 55.2038 251.743C54.8813 251.42 54.4984 251.164 54.077 250.99C53.6556 250.815 53.2039 250.726 52.7478 250.726C52.2917 250.726 51.84 250.815 51.4186 250.99C50.9972 251.164 50.6143 251.42 50.2918 251.743C49.9693 252.065 49.7134 252.448 49.5389 252.87C49.3643 253.291 49.2745 253.743 49.2745 254.199ZM63.1677 254.199C63.1677 255.12 63.5336 256.003 64.185 256.655C64.8363 257.306 65.7198 257.672 66.641 257.672C67.5621 257.672 68.4456 257.306 69.097 256.655C69.7483 256.003 70.1143 255.12 70.1143 254.199C70.1143 253.278 69.7483 252.394 69.097 251.743C68.4456 251.091 67.5621 250.726 66.641 250.726C65.7198 250.726 64.8363 251.091 64.185 251.743C63.5336 252.394 63.1677 253.278 63.1677 254.199ZM77.0609 254.199C77.0609 254.655 77.1507 255.107 77.3252 255.528C77.4998 255.949 77.7556 256.332 78.0782 256.655C78.4007 256.977 78.7836 257.233 79.205 257.408C79.6264 257.582 80.078 257.672 80.5341 257.672C80.9903 257.672 81.4419 257.582 81.8633 257.408C82.2847 257.233 82.6676 256.977 82.9901 256.655C83.3127 256.332 83.5685 255.949 83.743 255.528C83.9176 255.107 84.0074 254.655 84.0074 254.199C84.0074 253.743 83.9176 253.291 83.743 252.87C83.5685 252.448 83.3127 252.065 82.9901 251.743C82.6676 251.42 82.2847 251.164 81.8633 250.99C81.4419 250.815 80.9903 250.726 80.5341 250.726C80.078 250.726 79.6264 250.815 79.205 250.99C78.7836 251.164 78.4007 251.42 78.0782 251.743C77.7556 252.065 77.4998 252.448 77.3252 252.87C77.1507 253.291 77.0609 253.743 77.0609 254.199ZM90.954 254.199C90.954 255.12 91.32 256.003 91.9713 256.655C92.6227 257.306 93.5061 257.672 94.4273 257.672C95.3485 257.672 96.2319 257.306 96.8833 256.655C97.5347 256.003 97.9006 255.12 97.9006 254.199C97.9006 253.278 97.5347 252.394 96.8833 251.743C96.2319 251.091 95.3485 250.726 94.4273 250.726C93.5061 250.726 92.6227 251.091 91.9713 251.743C91.32 252.394 90.954 253.278 90.954 254.199ZM118.74 254.199C118.74 255.12 119.106 256.003 119.758 256.655C120.409 257.306 121.292 257.672 122.214 257.672C123.135 257.672 124.018 257.306 124.67 256.655C125.321 256.003 125.687 255.12 125.687 254.199C125.687 253.278 125.321 252.394 124.67 251.743C124.018 251.091 123.135 250.726 122.214 250.726C121.292 250.726 120.409 251.091 119.758 251.743C119.106 252.394 118.74 253.278 118.74 254.199ZM132.634 254.199C132.634 255.12 132.999 256.003 133.651 256.655C134.302 257.306 135.186 257.672 136.107 257.672C137.028 257.672 137.911 257.306 138.563 256.655C139.214 256.003 139.58 255.12 139.58 254.199C139.58 253.278 139.214 252.394 138.563 251.743C137.911 251.091 137.028 250.726 136.107 250.726C135.186 250.726 134.302 251.091 133.651 251.743C132.999 252.394 132.634 253.278 132.634 254.199ZM146.527 254.199C146.527 255.12 146.893 256.003 147.544 256.655C148.195 257.306 149.079 257.672 150 257.672C150.921 257.672 151.805 257.306 152.456 256.655C153.107 256.003 153.473 255.12 153.473 254.199C153.473 253.278 153.107 252.394 152.456 251.743C151.805 251.091 150.921 250.726 150 250.726C149.079 250.726 148.195 251.091 147.544 251.743C146.893 252.394 146.527 253.278 146.527 254.199ZM167.366 254.199C167.366 255.12 167.732 256.003 168.384 256.655C169.035 257.306 169.919 257.672 170.84 257.672C171.761 257.672 172.644 257.306 173.296 256.655C173.947 256.003 174.313 255.12 174.313 254.199C174.313 253.278 173.947 252.394 173.296 251.743C172.644 251.091 171.761 250.726 170.84 250.726C169.919 250.726 169.035 251.091 168.384 251.743C167.732 252.394 167.366 253.278 167.366 254.199ZM181.26 254.199C181.26 255.12 181.626 256.003 182.277 256.655C182.928 257.306 183.812 257.672 184.733 257.672C185.654 257.672 186.538 257.306 187.189 256.655C187.84 256.003 188.206 255.12 188.206 254.199C188.206 253.278 187.84 252.394 187.189 251.743C186.538 251.091 185.654 250.726 184.733 250.726C183.812 250.726 182.928 251.091 182.277 251.743C181.626 252.394 181.26 253.278 181.26 254.199ZM188.206 254.199C188.206 255.12 188.572 256.003 189.224 256.655C189.875 257.306 190.758 257.672 191.68 257.672C192.601 257.672 193.484 257.306 194.136 256.655C194.787 256.003 195.153 255.12 195.153 254.199C195.153 253.278 194.787 252.394 194.136 251.743C193.484 251.091 192.601 250.726 191.68 250.726C190.758 250.726 189.875 251.091 189.224 251.743C188.572 252.394 188.206 253.278 188.206 254.199ZM222.939 254.199C222.939 255.12 223.305 256.003 223.957 256.655C224.608 257.306 225.491 257.672 226.413 257.672C227.334 257.672 228.217 257.306 228.868 256.655C229.52 256.003 229.886 255.12 229.886 254.199C229.886 253.278 229.52 252.394 228.868 251.743C228.217 251.091 227.334 250.726 226.413 250.726C225.491 250.726 224.608 251.091 223.957 251.743C223.305 252.394 222.939 253.278 222.939 254.199ZM229.886 254.199C229.886 255.12 230.252 256.003 230.903 256.655C231.554 257.306 232.438 257.672 233.359 257.672C234.28 257.672 235.164 257.306 235.815 256.655C236.466 256.003 236.832 255.12 236.832 254.199C236.832 253.278 236.466 252.394 235.815 251.743C235.164 251.091 234.28 250.726 233.359 250.726C232.438 250.726 231.554 251.091 230.903 251.743C230.252 252.394 229.886 253.278 229.886 254.199ZM257.672 254.199C257.672 255.12 258.038 256.003 258.689 256.655C259.341 257.306 260.224 257.672 261.145 257.672C262.067 257.672 262.95 257.306 263.601 256.655C264.253 256.003 264.619 255.12 264.619 254.199C264.619 253.278 264.253 252.394 263.601 251.743C262.95 251.091 262.067 250.726 261.145 250.726C260.224 250.726 259.341 251.091 258.689 251.743C258.038 252.394 257.672 253.278 257.672 254.199ZM285.458 254.199C285.458 255.12 285.824 256.003 286.476 256.655C287.127 257.306 288.011 257.672 288.932 257.672C289.853 257.672 290.736 257.306 291.388 256.655C292.039 256.003 292.405 255.12 292.405 254.199C292.405 253.278 292.039 252.394 291.388 251.743C290.736 251.091 289.853 250.726 288.932 250.726C288.011 250.726 287.127 251.091 286.476 251.743C285.824 252.394 285.458 253.278 285.458 254.199ZM7.59497 261.145C7.59497 262.067 7.96091 262.95 8.61227 263.601C9.26364 264.253 10.1471 264.619 11.0683 264.619C11.9894 264.619 12.8729 264.253 13.5243 263.601C14.1756 262.95 14.5416 262.067 14.5416 261.145C14.5416 260.224 14.1756 259.341 13.5243 258.689C12.8729 258.038 11.9894 257.672 11.0683 257.672C10.1471 257.672 9.26364 258.038 8.61227 258.689C7.96091 259.341 7.59497 260.224 7.59497 261.145ZM21.4881 261.145C21.4881 262.067 21.8541 262.95 22.5055 263.601C23.1568 264.253 24.0403 264.619 24.9614 264.619C25.8826 264.619 26.7661 264.253 27.4174 263.601C28.0688 262.95 28.4347 262.067 28.4347 261.145C28.4347 260.224 28.0688 259.341 27.4174 258.689C26.7661 258.038 25.8826 257.672 24.9614 257.672C24.0403 257.672 23.1568 258.038 22.5055 258.689C21.8541 259.341 21.4881 260.224 21.4881 261.145ZM28.4347 261.145C28.4347 262.067 28.8007 262.95 29.452 263.601C30.1034 264.253 30.9869 264.619 31.908 264.619C32.8292 264.619 33.7126 264.253 34.364 263.601C35.0154 262.95 35.3813 262.067 35.3813 261.145C35.3813 260.224 35.0154 259.341 34.364 258.689C33.7126 258.038 32.8292 257.672 31.908 257.672C30.9869 257.672 30.1034 258.038 29.452 258.689C28.8007 259.341 28.4347 260.224 28.4347 261.145ZM35.3813 261.145C35.3813 262.067 35.7473 262.95 36.3986 263.601C37.05 264.253 37.9334 264.619 38.8546 264.619C39.7758 264.619 40.6592 264.253 41.3106 263.601C41.962 262.95 42.3279 262.067 42.3279 261.145C42.3279 260.224 41.962 259.341 41.3106 258.689C40.6592 258.038 39.7758 257.672 38.8546 257.672C37.9334 257.672 37.05 258.038 36.3986 258.689C35.7473 259.341 35.3813 260.224 35.3813 261.145ZM49.2745 261.145C49.2745 261.602 49.3643 262.053 49.5389 262.475C49.7134 262.896 49.9693 263.279 50.2918 263.601C50.6143 263.924 50.9972 264.18 51.4186 264.354C51.84 264.529 52.2917 264.619 52.7478 264.619C53.2039 264.619 53.6556 264.529 54.077 264.354C54.4984 264.18 54.8813 263.924 55.2038 263.601C55.5263 263.279 55.7821 262.896 55.9567 262.475C56.1312 262.053 56.2211 261.602 56.2211 261.145C56.2211 260.689 56.1312 260.238 55.9567 259.816C55.7821 259.395 55.5263 259.012 55.2038 258.689C54.8813 258.367 54.4984 258.111 54.077 257.936C53.6556 257.762 53.2039 257.672 52.7478 257.672C52.2917 257.672 51.84 257.762 51.4186 257.936C50.9972 258.111 50.6143 258.367 50.2918 258.689C49.9693 259.012 49.7134 259.395 49.5389 259.816C49.3643 260.238 49.2745 260.689 49.2745 261.145ZM63.1677 261.145C63.1677 262.067 63.5336 262.95 64.185 263.601C64.8363 264.253 65.7198 264.619 66.641 264.619C67.5621 264.619 68.4456 264.253 69.097 263.601C69.7483 262.95 70.1143 262.067 70.1143 261.145C70.1143 260.224 69.7483 259.341 69.097 258.689C68.4456 258.038 67.5621 257.672 66.641 257.672C65.7198 257.672 64.8363 258.038 64.185 258.689C63.5336 259.341 63.1677 260.224 63.1677 261.145ZM70.1143 261.145C70.1143 262.067 70.4802 262.95 71.1316 263.601C71.7829 264.253 72.6664 264.619 73.5876 264.619C74.5087 264.619 75.3922 264.253 76.0436 263.601C76.6949 262.95 77.0609 262.067 77.0609 261.145C77.0609 260.224 76.6949 259.341 76.0436 258.689C75.3922 258.038 74.5087 257.672 73.5876 257.672C72.6664 257.672 71.7829 258.038 71.1316 258.689C70.4802 259.341 70.1143 260.224 70.1143 261.145ZM97.9006 261.145C97.9006 261.602 97.9905 262.053 98.165 262.475C98.3396 262.896 98.5954 263.279 98.9179 263.601C99.2404 263.924 99.6233 264.18 100.045 264.354C100.466 264.529 100.918 264.619 101.374 264.619C101.83 264.619 102.282 264.529 102.703 264.354C103.124 264.18 103.507 263.924 103.83 263.601C104.152 263.279 104.408 262.896 104.583 262.475C104.757 262.053 104.847 261.602 104.847 261.145C104.847 260.689 104.757 260.238 104.583 259.816C104.408 259.395 104.152 259.012 103.83 258.689C103.507 258.367 103.124 258.111 102.703 257.936C102.282 257.762 101.83 257.672 101.374 257.672C100.918 257.672 100.466 257.762 100.045 257.936C99.6233 258.111 99.2404 258.367 98.9179 258.689C98.5954 259.012 98.3396 259.395 98.165 259.816C97.9905 260.238 97.9006 260.689 97.9006 261.145ZM125.687 261.145C125.687 262.067 126.053 262.95 126.704 263.601C127.356 264.253 128.239 264.619 129.16 264.619C130.081 264.619 130.965 264.253 131.616 263.601C132.268 262.95 132.634 262.067 132.634 261.145C132.634 260.224 132.268 259.341 131.616 258.689C130.965 258.038 130.081 257.672 129.16 257.672C128.239 257.672 127.356 258.038 126.704 258.689C126.053 259.341 125.687 260.224 125.687 261.145ZM132.634 261.145C132.634 262.067 132.999 262.95 133.651 263.601C134.302 264.253 135.186 264.619 136.107 264.619C137.028 264.619 137.911 264.253 138.563 263.601C139.214 262.95 139.58 262.067 139.58 261.145C139.58 260.224 139.214 259.341 138.563 258.689C137.911 258.038 137.028 257.672 136.107 257.672C135.186 257.672 134.302 258.038 133.651 258.689C132.999 259.341 132.634 260.224 132.634 261.145ZM153.473 261.145C153.473 261.602 153.563 262.053 153.738 262.475C153.912 262.896 154.168 263.279 154.491 263.601C154.813 263.924 155.196 264.18 155.617 264.354C156.039 264.529 156.491 264.619 156.947 264.619C157.403 264.619 157.854 264.529 158.276 264.354C158.697 264.18 159.08 263.924 159.403 263.601C159.725 263.279 159.981 262.896 160.156 262.475C160.33 262.053 160.42 261.602 160.42 261.145C160.42 260.689 160.33 260.238 160.156 259.816C159.981 259.395 159.725 259.012 159.403 258.689C159.08 258.367 158.697 258.111 158.276 257.936C157.854 257.762 157.403 257.672 156.947 257.672C156.491 257.672 156.039 257.762 155.617 257.936C155.196 258.111 154.813 258.367 154.491 258.689C154.168 259.012 153.912 259.395 153.738 259.816C153.563 260.238 153.473 260.689 153.473 261.145ZM167.366 261.145C167.366 262.067 167.732 262.95 168.384 263.601C169.035 264.253 169.919 264.619 170.84 264.619C171.761 264.619 172.644 264.253 173.296 263.601C173.947 262.95 174.313 262.067 174.313 261.145C174.313 260.224 173.947 259.341 173.296 258.689C172.644 258.038 171.761 257.672 170.84 257.672C169.919 257.672 169.035 258.038 168.384 258.689C167.732 259.341 167.366 260.224 167.366 261.145ZM174.313 261.145C174.313 262.067 174.679 262.95 175.33 263.601C175.982 264.253 176.865 264.619 177.786 264.619C178.708 264.619 179.591 264.253 180.242 263.601C180.894 262.95 181.26 262.067 181.26 261.145C181.26 260.224 180.894 259.341 180.242 258.689C179.591 258.038 178.708 257.672 177.786 257.672C176.865 257.672 175.982 258.038 175.33 258.689C174.679 259.341 174.313 260.224 174.313 261.145ZM188.206 261.145C188.206 262.067 188.572 262.95 189.224 263.601C189.875 264.253 190.758 264.619 191.68 264.619C192.601 264.619 193.484 264.253 194.136 263.601C194.787 262.95 195.153 262.067 195.153 261.145C195.153 260.224 194.787 259.341 194.136 258.689C193.484 258.038 192.601 257.672 191.68 257.672C190.758 257.672 189.875 258.038 189.224 258.689C188.572 259.341 188.206 260.224 188.206 261.145ZM222.939 261.145C222.939 262.067 223.305 262.95 223.957 263.601C224.608 264.253 225.491 264.619 226.413 264.619C227.334 264.619 228.217 264.253 228.868 263.601C229.52 262.95 229.886 262.067 229.886 261.145C229.886 260.224 229.52 259.341 228.868 258.689C228.217 258.038 227.334 257.672 226.413 257.672C225.491 257.672 224.608 258.038 223.957 258.689C223.305 259.341 222.939 260.224 222.939 261.145ZM229.886 261.145C229.886 262.067 230.252 262.95 230.903 263.601C231.554 264.253 232.438 264.619 233.359 264.619C234.28 264.619 235.164 264.253 235.815 263.601C236.466 262.95 236.832 262.067 236.832 261.145C236.832 260.224 236.466 259.341 235.815 258.689C235.164 258.038 234.28 257.672 233.359 257.672C232.438 257.672 231.554 258.038 230.903 258.689C230.252 259.341 229.886 260.224 229.886 261.145ZM236.832 261.145C236.832 262.067 237.198 262.95 237.85 263.601C238.501 264.253 239.384 264.619 240.306 264.619C241.227 264.619 242.11 264.253 242.762 263.601C243.413 262.95 243.779 262.067 243.779 261.145C243.779 260.224 243.413 259.341 242.762 258.689C242.11 258.038 241.227 257.672 240.306 257.672C239.384 257.672 238.501 258.038 237.85 258.689C237.198 259.341 236.832 260.224 236.832 261.145ZM243.779 261.145C243.779 262.067 244.145 262.95 244.796 263.601C245.448 264.253 246.331 264.619 247.252 264.619C248.173 264.619 249.057 264.253 249.708 263.601C250.36 262.95 250.726 262.067 250.726 261.145C250.726 260.224 250.36 259.341 249.708 258.689C249.057 258.038 248.173 257.672 247.252 257.672C246.331 257.672 245.448 258.038 244.796 258.689C244.145 259.341 243.779 260.224 243.779 261.145ZM250.726 261.145C250.726 262.067 251.091 262.95 251.743 263.601C252.394 264.253 253.278 264.619 254.199 264.619C255.12 264.619 256.003 264.253 256.655 263.601C257.306 262.95 257.672 262.067 257.672 261.145C257.672 260.224 257.306 259.341 256.655 258.689C256.003 258.038 255.12 257.672 254.199 257.672C253.278 257.672 252.394 258.038 251.743 258.689C251.091 259.341 250.726 260.224 250.726 261.145ZM257.672 261.145C257.672 262.067 258.038 262.95 258.689 263.601C259.341 264.253 260.224 264.619 261.145 264.619C262.067 264.619 262.95 264.253 263.601 263.601C264.253 262.95 264.619 262.067 264.619 261.145C264.619 260.224 264.253 259.341 263.601 258.689C262.95 258.038 262.067 257.672 261.145 257.672C260.224 257.672 259.341 258.038 258.689 258.689C258.038 259.341 257.672 260.224 257.672 261.145ZM264.619 261.145C264.619 262.067 264.985 262.95 265.636 263.601C266.287 264.253 267.171 264.619 268.092 264.619C269.013 264.619 269.897 264.253 270.548 263.601C271.199 262.95 271.565 262.067 271.565 261.145C271.565 260.224 271.199 259.341 270.548 258.689C269.897 258.038 269.013 257.672 268.092 257.672C267.171 257.672 266.287 258.038 265.636 258.689C264.985 259.341 264.619 260.224 264.619 261.145ZM7.59497 268.092C7.59497 269.013 7.96091 269.897 8.61227 270.548C9.26364 271.199 10.1471 271.565 11.0683 271.565C11.9894 271.565 12.8729 271.199 13.5243 270.548C14.1756 269.897 14.5416 269.013 14.5416 268.092C14.5416 267.171 14.1756 266.287 13.5243 265.636C12.8729 264.985 11.9894 264.619 11.0683 264.619C10.1471 264.619 9.26364 264.985 8.61227 265.636C7.96091 266.287 7.59497 267.171 7.59497 268.092ZM21.4881 268.092C21.4881 269.013 21.8541 269.897 22.5055 270.548C23.1568 271.199 24.0403 271.565 24.9614 271.565C25.8826 271.565 26.7661 271.199 27.4174 270.548C28.0688 269.897 28.4347 269.013 28.4347 268.092C28.4347 267.171 28.0688 266.287 27.4174 265.636C26.7661 264.985 25.8826 264.619 24.9614 264.619C24.0403 264.619 23.1568 264.985 22.5055 265.636C21.8541 266.287 21.4881 267.171 21.4881 268.092ZM28.4347 268.092C28.4347 269.013 28.8007 269.897 29.452 270.548C30.1034 271.199 30.9869 271.565 31.908 271.565C32.8292 271.565 33.7126 271.199 34.364 270.548C35.0154 269.897 35.3813 269.013 35.3813 268.092C35.3813 267.171 35.0154 266.287 34.364 265.636C33.7126 264.985 32.8292 264.619 31.908 264.619C30.9869 264.619 30.1034 264.985 29.452 265.636C28.8007 266.287 28.4347 267.171 28.4347 268.092ZM35.3813 268.092C35.3813 269.013 35.7473 269.897 36.3986 270.548C37.05 271.199 37.9334 271.565 38.8546 271.565C39.7758 271.565 40.6592 271.199 41.3106 270.548C41.962 269.897 42.3279 269.013 42.3279 268.092C42.3279 267.171 41.962 266.287 41.3106 265.636C40.6592 264.985 39.7758 264.619 38.8546 264.619C37.9334 264.619 37.05 264.985 36.3986 265.636C35.7473 266.287 35.3813 267.171 35.3813 268.092ZM49.2745 268.092C49.2745 268.548 49.3643 269 49.5389 269.421C49.7134 269.843 49.9693 270.225 50.2918 270.548C50.6143 270.871 50.9972 271.126 51.4186 271.301C51.84 271.475 52.2917 271.565 52.7478 271.565C53.2039 271.565 53.6556 271.475 54.077 271.301C54.4984 271.126 54.8813 270.871 55.2038 270.548C55.5263 270.225 55.7821 269.843 55.9567 269.421C56.1312 269 56.2211 268.548 56.2211 268.092C56.2211 267.636 56.1312 267.184 55.9567 266.763C55.7821 266.341 55.5263 265.959 55.2038 265.636C54.8813 265.313 54.4984 265.058 54.077 264.883C53.6556 264.709 53.2039 264.619 52.7478 264.619C52.2917 264.619 51.84 264.709 51.4186 264.883C50.9972 265.058 50.6143 265.313 50.2918 265.636C49.9693 265.959 49.7134 266.341 49.5389 266.763C49.3643 267.184 49.2745 267.636 49.2745 268.092ZM77.0609 268.092C77.0609 268.548 77.1507 269 77.3252 269.421C77.4998 269.843 77.7556 270.225 78.0782 270.548C78.4007 270.871 78.7836 271.126 79.205 271.301C79.6264 271.475 80.078 271.565 80.5341 271.565C80.9903 271.565 81.4419 271.475 81.8633 271.301C82.2847 271.126 82.6676 270.871 82.9901 270.548C83.3127 270.225 83.5685 269.843 83.743 269.421C83.9176 269 84.0074 268.548 84.0074 268.092C84.0074 267.636 83.9176 267.184 83.743 266.763C83.5685 266.341 83.3127 265.959 82.9901 265.636C82.6676 265.313 82.2847 265.058 81.8633 264.883C81.4419 264.709 80.9903 264.619 80.5341 264.619C80.078 264.619 79.6264 264.709 79.205 264.883C78.7836 265.058 78.4007 265.313 78.0782 265.636C77.7556 265.959 77.4998 266.341 77.3252 266.763C77.1507 267.184 77.0609 267.636 77.0609 268.092ZM84.0074 268.092C84.0074 269.013 84.3734 269.897 85.0247 270.548C85.6761 271.199 86.5596 271.565 87.4807 271.565C88.4019 271.565 89.2854 271.199 89.9367 270.548C90.5881 269.897 90.954 269.013 90.954 268.092C90.954 267.171 90.5881 266.287 89.9367 265.636C89.2854 264.985 88.4019 264.619 87.4807 264.619C86.5596 264.619 85.6761 264.985 85.0247 265.636C84.3734 266.287 84.0074 267.171 84.0074 268.092ZM104.847 268.092C104.847 269.013 105.213 269.897 105.865 270.548C106.516 271.199 107.399 271.565 108.321 271.565C109.242 271.565 110.125 271.199 110.776 270.548C111.428 269.897 111.794 269.013 111.794 268.092C111.794 267.171 111.428 266.287 110.776 265.636C110.125 264.985 109.242 264.619 108.321 264.619C107.399 264.619 106.516 264.985 105.865 265.636C105.213 266.287 104.847 267.171 104.847 268.092ZM153.473 268.092C153.473 268.548 153.563 269 153.738 269.421C153.912 269.843 154.168 270.225 154.491 270.548C154.813 270.871 155.196 271.126 155.617 271.301C156.039 271.475 156.491 271.565 156.947 271.565C157.403 271.565 157.854 271.475 158.276 271.301C158.697 271.126 159.08 270.871 159.403 270.548C159.725 270.225 159.981 269.843 160.156 269.421C160.33 269 160.42 268.548 160.42 268.092C160.42 267.636 160.33 267.184 160.156 266.763C159.981 266.341 159.725 265.959 159.403 265.636C159.08 265.313 158.697 265.058 158.276 264.883C157.854 264.709 157.403 264.619 156.947 264.619C156.491 264.619 156.039 264.709 155.617 264.883C155.196 265.058 154.813 265.313 154.491 265.636C154.168 265.959 153.912 266.341 153.738 266.763C153.563 267.184 153.473 267.636 153.473 268.092ZM174.313 268.092C174.313 269.013 174.679 269.897 175.33 270.548C175.982 271.199 176.865 271.565 177.786 271.565C178.708 271.565 179.591 271.199 180.242 270.548C180.894 269.897 181.26 269.013 181.26 268.092C181.26 267.171 180.894 266.287 180.242 265.636C179.591 264.985 178.708 264.619 177.786 264.619C176.865 264.619 175.982 264.985 175.33 265.636C174.679 266.287 174.313 267.171 174.313 268.092ZM181.26 268.092C181.26 269.013 181.626 269.897 182.277 270.548C182.928 271.199 183.812 271.565 184.733 271.565C185.654 271.565 186.538 271.199 187.189 270.548C187.84 269.897 188.206 269.013 188.206 268.092C188.206 267.171 187.84 266.287 187.189 265.636C186.538 264.985 185.654 264.619 184.733 264.619C183.812 264.619 182.928 264.985 182.277 265.636C181.626 266.287 181.26 267.171 181.26 268.092ZM188.206 268.092C188.206 269.013 188.572 269.897 189.224 270.548C189.875 271.199 190.758 271.565 191.68 271.565C192.601 271.565 193.484 271.199 194.136 270.548C194.787 269.897 195.153 269.013 195.153 268.092C195.153 267.171 194.787 266.287 194.136 265.636C193.484 264.985 192.601 264.619 191.68 264.619C190.758 264.619 189.875 264.985 189.224 265.636C188.572 266.287 188.206 267.171 188.206 268.092ZM195.153 268.092C195.153 268.548 195.243 269 195.417 269.421C195.592 269.843 195.848 270.225 196.17 270.548C196.493 270.871 196.876 271.126 197.297 271.301C197.718 271.475 198.17 271.565 198.626 271.565C199.082 271.565 199.534 271.475 199.955 271.301C200.377 271.126 200.76 270.871 201.082 270.548C201.405 270.225 201.661 269.843 201.835 269.421C202.01 269 202.099 268.548 202.099 268.092C202.099 267.636 202.01 267.184 201.835 266.763C201.661 266.341 201.405 265.959 201.082 265.636C200.76 265.313 200.377 265.058 199.955 264.883C199.534 264.709 199.082 264.619 198.626 264.619C198.17 264.619 197.718 264.709 197.297 264.883C196.876 265.058 196.493 265.313 196.17 265.636C195.848 265.959 195.592 266.341 195.417 266.763C195.243 267.184 195.153 267.636 195.153 268.092ZM202.099 268.092C202.099 269.013 202.465 269.897 203.117 270.548C203.768 271.199 204.652 271.565 205.573 271.565C206.494 271.565 207.377 271.199 208.029 270.548C208.68 269.897 209.046 269.013 209.046 268.092C209.046 267.171 208.68 266.287 208.029 265.636C207.377 264.985 206.494 264.619 205.573 264.619C204.652 264.619 203.768 264.985 203.117 265.636C202.465 266.287 202.099 267.171 202.099 268.092ZM209.046 268.092C209.046 269.013 209.412 269.897 210.063 270.548C210.715 271.199 211.598 271.565 212.519 271.565C213.44 271.565 214.324 271.199 214.975 270.548C215.627 269.897 215.993 269.013 215.993 268.092C215.993 267.171 215.627 266.287 214.975 265.636C214.324 264.985 213.44 264.619 212.519 264.619C211.598 264.619 210.715 264.985 210.063 265.636C209.412 266.287 209.046 267.171 209.046 268.092ZM215.993 268.092C215.993 269.013 216.359 269.897 217.01 270.548C217.661 271.199 218.545 271.565 219.466 271.565C220.387 271.565 221.271 271.199 221.922 270.548C222.573 269.897 222.939 269.013 222.939 268.092C222.939 267.171 222.573 266.287 221.922 265.636C221.271 264.985 220.387 264.619 219.466 264.619C218.545 264.619 217.661 264.985 217.01 265.636C216.359 266.287 215.993 267.171 215.993 268.092ZM250.726 268.092C250.726 269.013 251.091 269.897 251.743 270.548C252.394 271.199 253.278 271.565 254.199 271.565C255.12 271.565 256.003 271.199 256.655 270.548C257.306 269.897 257.672 269.013 257.672 268.092C257.672 267.171 257.306 266.287 256.655 265.636C256.003 264.985 255.12 264.619 254.199 264.619C253.278 264.619 252.394 264.985 251.743 265.636C251.091 266.287 250.726 267.171 250.726 268.092ZM285.458 268.092C285.458 269.013 285.824 269.897 286.476 270.548C287.127 271.199 288.011 271.565 288.932 271.565C289.853 271.565 290.736 271.199 291.388 270.548C292.039 269.897 292.405 269.013 292.405 268.092C292.405 267.171 292.039 266.287 291.388 265.636C290.736 264.985 289.853 264.619 288.932 264.619C288.011 264.619 287.127 264.985 286.476 265.636C285.824 266.287 285.458 267.171 285.458 268.092ZM7.59497 275.039C7.59497 275.96 7.96091 276.843 8.61227 277.495C9.26364 278.146 10.1471 278.512 11.0683 278.512C11.9894 278.512 12.8729 278.146 13.5243 277.495C14.1756 276.843 14.5416 275.96 14.5416 275.039C14.5416 274.117 14.1756 273.234 13.5243 272.583C12.8729 271.931 11.9894 271.565 11.0683 271.565C10.1471 271.565 9.26364 271.931 8.61227 272.583C7.96091 273.234 7.59497 274.117 7.59497 275.039ZM21.4881 275.039C21.4881 275.96 21.8541 276.843 22.5055 277.495C23.1568 278.146 24.0403 278.512 24.9614 278.512C25.8826 278.512 26.7661 278.146 27.4174 277.495C28.0688 276.843 28.4347 275.96 28.4347 275.039C28.4347 274.117 28.0688 273.234 27.4174 272.583C26.7661 271.931 25.8826 271.565 24.9614 271.565C24.0403 271.565 23.1568 271.931 22.5055 272.583C21.8541 273.234 21.4881 274.117 21.4881 275.039ZM28.4347 275.039C28.4347 275.96 28.8007 276.843 29.452 277.495C30.1034 278.146 30.9869 278.512 31.908 278.512C32.8292 278.512 33.7126 278.146 34.364 277.495C35.0154 276.843 35.3813 275.96 35.3813 275.039C35.3813 274.117 35.0154 273.234 34.364 272.583C33.7126 271.931 32.8292 271.565 31.908 271.565C30.9869 271.565 30.1034 271.931 29.452 272.583C28.8007 273.234 28.4347 274.117 28.4347 275.039ZM35.3813 275.039C35.3813 275.96 35.7473 276.843 36.3986 277.495C37.05 278.146 37.9334 278.512 38.8546 278.512C39.7758 278.512 40.6592 278.146 41.3106 277.495C41.962 276.843 42.3279 275.96 42.3279 275.039C42.3279 274.117 41.962 273.234 41.3106 272.583C40.6592 271.931 39.7758 271.565 38.8546 271.565C37.9334 271.565 37.05 271.931 36.3986 272.583C35.7473 273.234 35.3813 274.117 35.3813 275.039ZM49.2745 275.039C49.2745 275.495 49.3643 275.946 49.5389 276.368C49.7134 276.789 49.9693 277.172 50.2918 277.495C50.6143 277.817 50.9972 278.073 51.4186 278.247C51.84 278.422 52.2917 278.512 52.7478 278.512C53.2039 278.512 53.6556 278.422 54.077 278.247C54.4984 278.073 54.8813 277.817 55.2038 277.495C55.5263 277.172 55.7821 276.789 55.9567 276.368C56.1312 275.946 56.2211 275.495 56.2211 275.039C56.2211 274.582 56.1312 274.131 55.9567 273.709C55.7821 273.288 55.5263 272.905 55.2038 272.583C54.8813 272.26 54.4984 272.004 54.077 271.83C53.6556 271.655 53.2039 271.565 52.7478 271.565C52.2917 271.565 51.84 271.655 51.4186 271.83C50.9972 272.004 50.6143 272.26 50.2918 272.583C49.9693 272.905 49.7134 273.288 49.5389 273.709C49.3643 274.131 49.2745 274.582 49.2745 275.039ZM70.1143 275.039C70.1143 275.96 70.4802 276.843 71.1316 277.495C71.7829 278.146 72.6664 278.512 73.5876 278.512C74.5087 278.512 75.3922 278.146 76.0436 277.495C76.6949 276.843 77.0609 275.96 77.0609 275.039C77.0609 274.117 76.6949 273.234 76.0436 272.583C75.3922 271.931 74.5087 271.565 73.5876 271.565C72.6664 271.565 71.7829 271.931 71.1316 272.583C70.4802 273.234 70.1143 274.117 70.1143 275.039ZM90.954 275.039C90.954 275.96 91.32 276.843 91.9713 277.495C92.6227 278.146 93.5061 278.512 94.4273 278.512C95.3485 278.512 96.2319 278.146 96.8833 277.495C97.5347 276.843 97.9006 275.96 97.9006 275.039C97.9006 274.117 97.5347 273.234 96.8833 272.583C96.2319 271.931 95.3485 271.565 94.4273 271.565C93.5061 271.565 92.6227 271.931 91.9713 272.583C91.32 273.234 90.954 274.117 90.954 275.039ZM104.847 275.039C104.847 275.96 105.213 276.843 105.865 277.495C106.516 278.146 107.399 278.512 108.321 278.512C109.242 278.512 110.125 278.146 110.776 277.495C111.428 276.843 111.794 275.96 111.794 275.039C111.794 274.117 111.428 273.234 110.776 272.583C110.125 271.931 109.242 271.565 108.321 271.565C107.399 271.565 106.516 271.931 105.865 272.583C105.213 273.234 104.847 274.117 104.847 275.039ZM118.74 275.039C118.74 275.96 119.106 276.843 119.758 277.495C120.409 278.146 121.292 278.512 122.214 278.512C123.135 278.512 124.018 278.146 124.67 277.495C125.321 276.843 125.687 275.96 125.687 275.039C125.687 274.117 125.321 273.234 124.67 272.583C124.018 271.931 123.135 271.565 122.214 271.565C121.292 271.565 120.409 271.931 119.758 272.583C119.106 273.234 118.74 274.117 118.74 275.039ZM139.58 275.039C139.58 275.96 139.946 276.843 140.597 277.495C141.249 278.146 142.132 278.512 143.053 278.512C143.975 278.512 144.858 278.146 145.509 277.495C146.161 276.843 146.527 275.96 146.527 275.039C146.527 274.117 146.161 273.234 145.509 272.583C144.858 271.931 143.975 271.565 143.053 271.565C142.132 271.565 141.249 271.931 140.597 272.583C139.946 273.234 139.58 274.117 139.58 275.039ZM146.527 275.039C146.527 275.96 146.893 276.843 147.544 277.495C148.195 278.146 149.079 278.512 150 278.512C150.921 278.512 151.805 278.146 152.456 277.495C153.107 276.843 153.473 275.96 153.473 275.039C153.473 274.117 153.107 273.234 152.456 272.583C151.805 271.931 150.921 271.565 150 271.565C149.079 271.565 148.195 271.931 147.544 272.583C146.893 273.234 146.527 274.117 146.527 275.039ZM153.473 275.039C153.473 275.495 153.563 275.946 153.738 276.368C153.912 276.789 154.168 277.172 154.491 277.495C154.813 277.817 155.196 278.073 155.617 278.247C156.039 278.422 156.491 278.512 156.947 278.512C157.403 278.512 157.854 278.422 158.276 278.247C158.697 278.073 159.08 277.817 159.403 277.495C159.725 277.172 159.981 276.789 160.156 276.368C160.33 275.946 160.42 275.495 160.42 275.039C160.42 274.582 160.33 274.131 160.156 273.709C159.981 273.288 159.725 272.905 159.403 272.583C159.08 272.26 158.697 272.004 158.276 271.83C157.854 271.655 157.403 271.565 156.947 271.565C156.491 271.565 156.039 271.655 155.617 271.83C155.196 272.004 154.813 272.26 154.491 272.583C154.168 272.905 153.912 273.288 153.738 273.709C153.563 274.131 153.473 274.582 153.473 275.039ZM167.366 275.039C167.366 275.96 167.732 276.843 168.384 277.495C169.035 278.146 169.919 278.512 170.84 278.512C171.761 278.512 172.644 278.146 173.296 277.495C173.947 276.843 174.313 275.96 174.313 275.039C174.313 274.117 173.947 273.234 173.296 272.583C172.644 271.931 171.761 271.565 170.84 271.565C169.919 271.565 169.035 271.931 168.384 272.583C167.732 273.234 167.366 274.117 167.366 275.039ZM174.313 275.039C174.313 275.96 174.679 276.843 175.33 277.495C175.982 278.146 176.865 278.512 177.786 278.512C178.708 278.512 179.591 278.146 180.242 277.495C180.894 276.843 181.26 275.96 181.26 275.039C181.26 274.117 180.894 273.234 180.242 272.583C179.591 271.931 178.708 271.565 177.786 271.565C176.865 271.565 175.982 271.931 175.33 272.583C174.679 273.234 174.313 274.117 174.313 275.039ZM188.206 275.039C188.206 275.96 188.572 276.843 189.224 277.495C189.875 278.146 190.758 278.512 191.68 278.512C192.601 278.512 193.484 278.146 194.136 277.495C194.787 276.843 195.153 275.96 195.153 275.039C195.153 274.117 194.787 273.234 194.136 272.583C193.484 271.931 192.601 271.565 191.68 271.565C190.758 271.565 189.875 271.931 189.224 272.583C188.572 273.234 188.206 274.117 188.206 275.039ZM195.153 275.039C195.153 275.495 195.243 275.946 195.417 276.368C195.592 276.789 195.848 277.172 196.17 277.495C196.493 277.817 196.876 278.073 197.297 278.247C197.718 278.422 198.17 278.512 198.626 278.512C199.082 278.512 199.534 278.422 199.955 278.247C200.377 278.073 200.76 277.817 201.082 277.495C201.405 277.172 201.661 276.789 201.835 276.368C202.01 275.946 202.099 275.495 202.099 275.039C202.099 274.582 202.01 274.131 201.835 273.709C201.661 273.288 201.405 272.905 201.082 272.583C200.76 272.26 200.377 272.004 199.955 271.83C199.534 271.655 199.082 271.565 198.626 271.565C198.17 271.565 197.718 271.655 197.297 271.83C196.876 272.004 196.493 272.26 196.17 272.583C195.848 272.905 195.592 273.288 195.417 273.709C195.243 274.131 195.153 274.582 195.153 275.039ZM202.099 275.039C202.099 275.96 202.465 276.843 203.117 277.495C203.768 278.146 204.652 278.512 205.573 278.512C206.494 278.512 207.377 278.146 208.029 277.495C208.68 276.843 209.046 275.96 209.046 275.039C209.046 274.117 208.68 273.234 208.029 272.583C207.377 271.931 206.494 271.565 205.573 271.565C204.652 271.565 203.768 271.931 203.117 272.583C202.465 273.234 202.099 274.117 202.099 275.039ZM209.046 275.039C209.046 275.96 209.412 276.843 210.063 277.495C210.715 278.146 211.598 278.512 212.519 278.512C213.44 278.512 214.324 278.146 214.975 277.495C215.627 276.843 215.993 275.96 215.993 275.039C215.993 274.117 215.627 273.234 214.975 272.583C214.324 271.931 213.44 271.565 212.519 271.565C211.598 271.565 210.715 271.931 210.063 272.583C209.412 273.234 209.046 274.117 209.046 275.039ZM236.832 275.039C236.832 275.96 237.198 276.843 237.85 277.495C238.501 278.146 239.384 278.512 240.306 278.512C241.227 278.512 242.11 278.146 242.762 277.495C243.413 276.843 243.779 275.96 243.779 275.039C243.779 274.117 243.413 273.234 242.762 272.583C242.11 271.931 241.227 271.565 240.306 271.565C239.384 271.565 238.501 271.931 237.85 272.583C237.198 273.234 236.832 274.117 236.832 275.039ZM271.565 275.039C271.565 275.96 271.931 276.843 272.583 277.495C273.234 278.146 274.117 278.512 275.039 278.512C275.96 278.512 276.843 278.146 277.495 277.495C278.146 276.843 278.512 275.96 278.512 275.039C278.512 274.117 278.146 273.234 277.495 272.583C276.843 271.931 275.96 271.565 275.039 271.565C274.117 271.565 273.234 271.931 272.583 272.583C271.931 273.234 271.565 274.117 271.565 275.039ZM278.512 275.039C278.512 275.96 278.878 276.843 279.529 277.495C280.181 278.146 281.064 278.512 281.985 278.512C282.906 278.512 283.79 278.146 284.441 277.495C285.093 276.843 285.458 275.96 285.458 275.039C285.458 274.117 285.093 273.234 284.441 272.583C283.79 271.931 282.906 271.565 281.985 271.565C281.064 271.565 280.181 271.931 279.529 272.583C278.878 273.234 278.512 274.117 278.512 275.039ZM285.458 275.039C285.458 275.96 285.824 276.843 286.476 277.495C287.127 278.146 288.011 278.512 288.932 278.512C289.853 278.512 290.736 278.146 291.388 277.495C292.039 276.843 292.405 275.96 292.405 275.039C292.405 274.117 292.039 273.234 291.388 272.583C290.736 271.931 289.853 271.565 288.932 271.565C288.011 271.565 287.127 271.931 286.476 272.583C285.824 273.234 285.458 274.117 285.458 275.039ZM7.59497 281.985C7.59497 282.906 7.96091 283.79 8.61227 284.441C9.26364 285.093 10.1471 285.458 11.0683 285.458C11.9894 285.458 12.8729 285.093 13.5243 284.441C14.1756 283.79 14.5416 282.906 14.5416 281.985C14.5416 281.064 14.1756 280.181 13.5243 279.529C12.8729 278.878 11.9894 278.512 11.0683 278.512C10.1471 278.512 9.26364 278.878 8.61227 279.529C7.96091 280.181 7.59497 281.064 7.59497 281.985ZM49.2745 281.985C49.2745 282.441 49.3643 282.893 49.5389 283.314C49.7134 283.736 49.9693 284.119 50.2918 284.441C50.6143 284.764 50.9972 285.02 51.4186 285.194C51.84 285.369 52.2917 285.458 52.7478 285.458C53.2039 285.458 53.6556 285.369 54.077 285.194C54.4984 285.02 54.8813 284.764 55.2038 284.441C55.5263 284.119 55.7821 283.736 55.9567 283.314C56.1312 282.893 56.2211 282.441 56.2211 281.985C56.2211 281.529 56.1312 281.077 55.9567 280.656C55.7821 280.235 55.5263 279.852 55.2038 279.529C54.8813 279.207 54.4984 278.951 54.077 278.776C53.6556 278.602 53.2039 278.512 52.7478 278.512C52.2917 278.512 51.84 278.602 51.4186 278.776C50.9972 278.951 50.6143 279.207 50.2918 279.529C49.9693 279.852 49.7134 280.235 49.5389 280.656C49.3643 281.077 49.2745 281.529 49.2745 281.985ZM84.0074 281.985C84.0074 282.906 84.3734 283.79 85.0247 284.441C85.6761 285.093 86.5596 285.458 87.4807 285.458C88.4019 285.458 89.2854 285.093 89.9367 284.441C90.5881 283.79 90.954 282.906 90.954 281.985C90.954 281.064 90.5881 280.181 89.9367 279.529C89.2854 278.878 88.4019 278.512 87.4807 278.512C86.5596 278.512 85.6761 278.878 85.0247 279.529C84.3734 280.181 84.0074 281.064 84.0074 281.985ZM90.954 281.985C90.954 282.906 91.32 283.79 91.9713 284.441C92.6227 285.093 93.5061 285.458 94.4273 285.458C95.3485 285.458 96.2319 285.093 96.8833 284.441C97.5347 283.79 97.9006 282.906 97.9006 281.985C97.9006 281.064 97.5347 280.181 96.8833 279.529C96.2319 278.878 95.3485 278.512 94.4273 278.512C93.5061 278.512 92.6227 278.878 91.9713 279.529C91.32 280.181 90.954 281.064 90.954 281.985ZM118.74 281.985C118.74 282.906 119.106 283.79 119.758 284.441C120.409 285.093 121.292 285.458 122.214 285.458C123.135 285.458 124.018 285.093 124.67 284.441C125.321 283.79 125.687 282.906 125.687 281.985C125.687 281.064 125.321 280.181 124.67 279.529C124.018 278.878 123.135 278.512 122.214 278.512C121.292 278.512 120.409 278.878 119.758 279.529C119.106 280.181 118.74 281.064 118.74 281.985ZM132.634 281.985C132.634 282.906 132.999 283.79 133.651 284.441C134.302 285.093 135.186 285.458 136.107 285.458C137.028 285.458 137.911 285.093 138.563 284.441C139.214 283.79 139.58 282.906 139.58 281.985C139.58 281.064 139.214 280.181 138.563 279.529C137.911 278.878 137.028 278.512 136.107 278.512C135.186 278.512 134.302 278.878 133.651 279.529C132.999 280.181 132.634 281.064 132.634 281.985ZM139.58 281.985C139.58 282.906 139.946 283.79 140.597 284.441C141.249 285.093 142.132 285.458 143.053 285.458C143.975 285.458 144.858 285.093 145.509 284.441C146.161 283.79 146.527 282.906 146.527 281.985C146.527 281.064 146.161 280.181 145.509 279.529C144.858 278.878 143.975 278.512 143.053 278.512C142.132 278.512 141.249 278.878 140.597 279.529C139.946 280.181 139.58 281.064 139.58 281.985ZM146.527 281.985C146.527 282.906 146.893 283.79 147.544 284.441C148.195 285.093 149.079 285.458 150 285.458C150.921 285.458 151.805 285.093 152.456 284.441C153.107 283.79 153.473 282.906 153.473 281.985C153.473 281.064 153.107 280.181 152.456 279.529C151.805 278.878 150.921 278.512 150 278.512C149.079 278.512 148.195 278.878 147.544 279.529C146.893 280.181 146.527 281.064 146.527 281.985ZM181.26 281.985C181.26 282.906 181.626 283.79 182.277 284.441C182.928 285.093 183.812 285.458 184.733 285.458C185.654 285.458 186.538 285.093 187.189 284.441C187.84 283.79 188.206 282.906 188.206 281.985C188.206 281.064 187.84 280.181 187.189 279.529C186.538 278.878 185.654 278.512 184.733 278.512C183.812 278.512 182.928 278.878 182.277 279.529C181.626 280.181 181.26 281.064 181.26 281.985ZM188.206 281.985C188.206 282.906 188.572 283.79 189.224 284.441C189.875 285.093 190.758 285.458 191.68 285.458C192.601 285.458 193.484 285.093 194.136 284.441C194.787 283.79 195.153 282.906 195.153 281.985C195.153 281.064 194.787 280.181 194.136 279.529C193.484 278.878 192.601 278.512 191.68 278.512C190.758 278.512 189.875 278.878 189.224 279.529C188.572 280.181 188.206 281.064 188.206 281.985ZM195.153 281.985C195.153 282.441 195.243 282.893 195.417 283.314C195.592 283.736 195.848 284.119 196.17 284.441C196.493 284.764 196.876 285.02 197.297 285.194C197.718 285.369 198.17 285.458 198.626 285.458C199.082 285.458 199.534 285.369 199.955 285.194C200.377 285.02 200.76 284.764 201.082 284.441C201.405 284.119 201.661 283.736 201.835 283.314C202.01 282.893 202.099 282.441 202.099 281.985C202.099 281.529 202.01 281.077 201.835 280.656C201.661 280.235 201.405 279.852 201.082 279.529C200.76 279.207 200.377 278.951 199.955 278.776C199.534 278.602 199.082 278.512 198.626 278.512C198.17 278.512 197.718 278.602 197.297 278.776C196.876 278.951 196.493 279.207 196.17 279.529C195.848 279.852 195.592 280.235 195.417 280.656C195.243 281.077 195.153 281.529 195.153 281.985ZM209.046 281.985C209.046 282.906 209.412 283.79 210.063 284.441C210.715 285.093 211.598 285.458 212.519 285.458C213.44 285.458 214.324 285.093 214.975 284.441C215.627 283.79 215.993 282.906 215.993 281.985C215.993 281.064 215.627 280.181 214.975 279.529C214.324 278.878 213.44 278.512 212.519 278.512C211.598 278.512 210.715 278.878 210.063 279.529C209.412 280.181 209.046 281.064 209.046 281.985ZM215.993 281.985C215.993 282.906 216.359 283.79 217.01 284.441C217.661 285.093 218.545 285.458 219.466 285.458C220.387 285.458 221.271 285.093 221.922 284.441C222.573 283.79 222.939 282.906 222.939 281.985C222.939 281.064 222.573 280.181 221.922 279.529C221.271 278.878 220.387 278.512 219.466 278.512C218.545 278.512 217.661 278.878 217.01 279.529C216.359 280.181 215.993 281.064 215.993 281.985ZM229.886 281.985C229.886 282.906 230.252 283.79 230.903 284.441C231.554 285.093 232.438 285.458 233.359 285.458C234.28 285.458 235.164 285.093 235.815 284.441C236.466 283.79 236.832 282.906 236.832 281.985C236.832 281.064 236.466 280.181 235.815 279.529C235.164 278.878 234.28 278.512 233.359 278.512C232.438 278.512 231.554 278.878 230.903 279.529C230.252 280.181 229.886 281.064 229.886 281.985ZM243.779 281.985C243.779 282.906 244.145 283.79 244.796 284.441C245.448 285.093 246.331 285.458 247.252 285.458C248.173 285.458 249.057 285.093 249.708 284.441C250.36 283.79 250.726 282.906 250.726 281.985C250.726 281.064 250.36 280.181 249.708 279.529C249.057 278.878 248.173 278.512 247.252 278.512C246.331 278.512 245.448 278.878 244.796 279.529C244.145 280.181 243.779 281.064 243.779 281.985ZM250.726 281.985C250.726 282.906 251.091 283.79 251.743 284.441C252.394 285.093 253.278 285.458 254.199 285.458C255.12 285.458 256.003 285.093 256.655 284.441C257.306 283.79 257.672 282.906 257.672 281.985C257.672 281.064 257.306 280.181 256.655 279.529C256.003 278.878 255.12 278.512 254.199 278.512C253.278 278.512 252.394 278.878 251.743 279.529C251.091 280.181 250.726 281.064 250.726 281.985ZM264.619 281.985C264.619 282.906 264.985 283.79 265.636 284.441C266.287 285.093 267.171 285.458 268.092 285.458C269.013 285.458 269.897 285.093 270.548 284.441C271.199 283.79 271.565 282.906 271.565 281.985C271.565 281.064 271.199 280.181 270.548 279.529C269.897 278.878 269.013 278.512 268.092 278.512C267.171 278.512 266.287 278.878 265.636 279.529C264.985 280.181 264.619 281.064 264.619 281.985ZM271.565 281.985C271.565 282.906 271.931 283.79 272.583 284.441C273.234 285.093 274.117 285.458 275.039 285.458C275.96 285.458 276.843 285.093 277.495 284.441C278.146 283.79 278.512 282.906 278.512 281.985C278.512 281.064 278.146 280.181 277.495 279.529C276.843 278.878 275.96 278.512 275.039 278.512C274.117 278.512 273.234 278.878 272.583 279.529C271.931 280.181 271.565 281.064 271.565 281.985ZM278.512 281.985C278.512 282.906 278.878 283.79 279.529 284.441C280.181 285.093 281.064 285.458 281.985 285.458C282.906 285.458 283.79 285.093 284.441 284.441C285.093 283.79 285.458 282.906 285.458 281.985C285.458 281.064 285.093 280.181 284.441 279.529C283.79 278.878 282.906 278.512 281.985 278.512C281.064 278.512 280.181 278.878 279.529 279.529C278.878 280.181 278.512 281.064 278.512 281.985ZM285.458 281.985C285.458 282.906 285.824 283.79 286.476 284.441C287.127 285.093 288.011 285.458 288.932 285.458C289.853 285.458 290.736 285.093 291.388 284.441C292.039 283.79 292.405 282.906 292.405 281.985C292.405 281.064 292.039 280.181 291.388 279.529C290.736 278.878 289.853 278.512 288.932 278.512C288.011 278.512 287.127 278.878 286.476 279.529C285.824 280.181 285.458 281.064 285.458 281.985ZM7.59497 288.932C7.59497 289.853 7.96091 290.736 8.61227 291.388C9.26364 292.039 10.1471 292.405 11.0683 292.405C11.9894 292.405 12.8729 292.039 13.5243 291.388C14.1756 290.736 14.5416 289.853 14.5416 288.932C14.5416 288.011 14.1756 287.127 13.5243 286.476C12.8729 285.824 11.9894 285.458 11.0683 285.458C10.1471 285.458 9.26364 285.824 8.61227 286.476C7.96091 287.127 7.59497 288.011 7.59497 288.932ZM14.5416 288.932C14.5416 289.853 14.9075 290.736 15.5589 291.388C16.2102 292.039 17.0937 292.405 18.0149 292.405C18.936 292.405 19.8195 292.039 20.4708 291.388C21.1222 290.736 21.4881 289.853 21.4881 288.932C21.4881 288.011 21.1222 287.127 20.4708 286.476C19.8195 285.824 18.936 285.458 18.0149 285.458C17.0937 285.458 16.2102 285.824 15.5589 286.476C14.9075 287.127 14.5416 288.011 14.5416 288.932ZM21.4881 288.932C21.4881 289.853 21.8541 290.736 22.5055 291.388C23.1568 292.039 24.0403 292.405 24.9614 292.405C25.8826 292.405 26.7661 292.039 27.4174 291.388C28.0688 290.736 28.4347 289.853 28.4347 288.932C28.4347 288.011 28.0688 287.127 27.4174 286.476C26.7661 285.824 25.8826 285.458 24.9614 285.458C24.0403 285.458 23.1568 285.824 22.5055 286.476C21.8541 287.127 21.4881 288.011 21.4881 288.932ZM28.4347 288.932C28.4347 289.853 28.8007 290.736 29.452 291.388C30.1034 292.039 30.9869 292.405 31.908 292.405C32.8292 292.405 33.7126 292.039 34.364 291.388C35.0154 290.736 35.3813 289.853 35.3813 288.932C35.3813 288.011 35.0154 287.127 34.364 286.476C33.7126 285.824 32.8292 285.458 31.908 285.458C30.9869 285.458 30.1034 285.824 29.452 286.476C28.8007 287.127 28.4347 288.011 28.4347 288.932ZM35.3813 288.932C35.3813 289.853 35.7473 290.736 36.3986 291.388C37.05 292.039 37.9334 292.405 38.8546 292.405C39.7758 292.405 40.6592 292.039 41.3106 291.388C41.962 290.736 42.3279 289.853 42.3279 288.932C42.3279 288.011 41.962 287.127 41.3106 286.476C40.6592 285.824 39.7758 285.458 38.8546 285.458C37.9334 285.458 37.05 285.824 36.3986 286.476C35.7473 287.127 35.3813 288.011 35.3813 288.932ZM42.3279 288.932C42.3279 289.388 42.4177 289.84 42.5923 290.261C42.7668 290.682 43.0227 291.065 43.3452 291.388C43.6677 291.71 44.0506 291.966 44.472 292.141C44.8934 292.315 45.3451 292.405 45.8012 292.405C46.2573 292.405 46.709 292.315 47.1304 292.141C47.5518 291.966 47.9347 291.71 48.2572 291.388C48.5797 291.065 48.8356 290.682 49.0101 290.261C49.1847 289.84 49.2745 289.388 49.2745 288.932C49.2745 288.476 49.1847 288.024 49.0101 287.603C48.8356 287.181 48.5797 286.798 48.2572 286.476C47.9347 286.153 47.5518 285.897 47.1304 285.723C46.709 285.548 46.2573 285.458 45.8012 285.458C45.3451 285.458 44.8934 285.548 44.472 285.723C44.0506 285.897 43.6677 286.153 43.3452 286.476C43.0227 286.798 42.7668 287.181 42.5923 287.603C42.4177 288.024 42.3279 288.476 42.3279 288.932ZM49.2745 288.932C49.2745 289.388 49.3643 289.84 49.5389 290.261C49.7134 290.682 49.9693 291.065 50.2918 291.388C50.6143 291.71 50.9972 291.966 51.4186 292.141C51.84 292.315 52.2917 292.405 52.7478 292.405C53.2039 292.405 53.6556 292.315 54.077 292.141C54.4984 291.966 54.8813 291.71 55.2038 291.388C55.5263 291.065 55.7821 290.682 55.9567 290.261C56.1312 289.84 56.2211 289.388 56.2211 288.932C56.2211 288.476 56.1312 288.024 55.9567 287.603C55.7821 287.181 55.5263 286.798 55.2038 286.476C54.8813 286.153 54.4984 285.897 54.077 285.723C53.6556 285.548 53.2039 285.458 52.7478 285.458C52.2917 285.458 51.84 285.548 51.4186 285.723C50.9972 285.897 50.6143 286.153 50.2918 286.476C49.9693 286.798 49.7134 287.181 49.5389 287.603C49.3643 288.024 49.2745 288.476 49.2745 288.932ZM70.1143 288.932C70.1143 289.853 70.4802 290.736 71.1316 291.388C71.7829 292.039 72.6664 292.405 73.5876 292.405C74.5087 292.405 75.3922 292.039 76.0436 291.388C76.6949 290.736 77.0609 289.853 77.0609 288.932C77.0609 288.011 76.6949 287.127 76.0436 286.476C75.3922 285.824 74.5087 285.458 73.5876 285.458C72.6664 285.458 71.7829 285.824 71.1316 286.476C70.4802 287.127 70.1143 288.011 70.1143 288.932ZM132.634 288.932C132.634 289.853 132.999 290.736 133.651 291.388C134.302 292.039 135.186 292.405 136.107 292.405C137.028 292.405 137.911 292.039 138.563 291.388C139.214 290.736 139.58 289.853 139.58 288.932C139.58 288.011 139.214 287.127 138.563 286.476C137.911 285.824 137.028 285.458 136.107 285.458C135.186 285.458 134.302 285.824 133.651 286.476C132.999 287.127 132.634 288.011 132.634 288.932ZM139.58 288.932C139.58 289.853 139.946 290.736 140.597 291.388C141.249 292.039 142.132 292.405 143.053 292.405C143.975 292.405 144.858 292.039 145.509 291.388C146.161 290.736 146.527 289.853 146.527 288.932C146.527 288.011 146.161 287.127 145.509 286.476C144.858 285.824 143.975 285.458 143.053 285.458C142.132 285.458 141.249 285.824 140.597 286.476C139.946 287.127 139.58 288.011 139.58 288.932ZM146.527 288.932C146.527 289.853 146.893 290.736 147.544 291.388C148.195 292.039 149.079 292.405 150 292.405C150.921 292.405 151.805 292.039 152.456 291.388C153.107 290.736 153.473 289.853 153.473 288.932C153.473 288.011 153.107 287.127 152.456 286.476C151.805 285.824 150.921 285.458 150 285.458C149.079 285.458 148.195 285.824 147.544 286.476C146.893 287.127 146.527 288.011 146.527 288.932ZM160.42 288.932C160.42 289.853 160.786 290.736 161.437 291.388C162.089 292.039 162.972 292.405 163.893 292.405C164.814 292.405 165.698 292.039 166.349 291.388C167.001 290.736 167.366 289.853 167.366 288.932C167.366 288.011 167.001 287.127 166.349 286.476C165.698 285.824 164.814 285.458 163.893 285.458C162.972 285.458 162.089 285.824 161.437 286.476C160.786 287.127 160.42 288.011 160.42 288.932ZM188.206 288.932C188.206 289.853 188.572 290.736 189.224 291.388C189.875 292.039 190.758 292.405 191.68 292.405C192.601 292.405 193.484 292.039 194.136 291.388C194.787 290.736 195.153 289.853 195.153 288.932C195.153 288.011 194.787 287.127 194.136 286.476C193.484 285.824 192.601 285.458 191.68 285.458C190.758 285.458 189.875 285.824 189.224 286.476C188.572 287.127 188.206 288.011 188.206 288.932ZM195.153 288.932C195.153 289.388 195.243 289.84 195.417 290.261C195.592 290.682 195.848 291.065 196.17 291.388C196.493 291.71 196.876 291.966 197.297 292.141C197.718 292.315 198.17 292.405 198.626 292.405C199.082 292.405 199.534 292.315 199.955 292.141C200.377 291.966 200.76 291.71 201.082 291.388C201.405 291.065 201.661 290.682 201.835 290.261C202.01 289.84 202.099 289.388 202.099 288.932C202.099 288.476 202.01 288.024 201.835 287.603C201.661 287.181 201.405 286.798 201.082 286.476C200.76 286.153 200.377 285.897 199.955 285.723C199.534 285.548 199.082 285.458 198.626 285.458C198.17 285.458 197.718 285.548 197.297 285.723C196.876 285.897 196.493 286.153 196.17 286.476C195.848 286.798 195.592 287.181 195.417 287.603C195.243 288.024 195.153 288.476 195.153 288.932ZM202.099 288.932C202.099 289.853 202.465 290.736 203.117 291.388C203.768 292.039 204.652 292.405 205.573 292.405C206.494 292.405 207.377 292.039 208.029 291.388C208.68 290.736 209.046 289.853 209.046 288.932C209.046 288.011 208.68 287.127 208.029 286.476C207.377 285.824 206.494 285.458 205.573 285.458C204.652 285.458 203.768 285.824 203.117 286.476C202.465 287.127 202.099 288.011 202.099 288.932ZM209.046 288.932C209.046 289.853 209.412 290.736 210.063 291.388C210.715 292.039 211.598 292.405 212.519 292.405C213.44 292.405 214.324 292.039 214.975 291.388C215.627 290.736 215.993 289.853 215.993 288.932C215.993 288.011 215.627 287.127 214.975 286.476C214.324 285.824 213.44 285.458 212.519 285.458C211.598 285.458 210.715 285.824 210.063 286.476C209.412 287.127 209.046 288.011 209.046 288.932ZM222.939 288.932C222.939 289.853 223.305 290.736 223.957 291.388C224.608 292.039 225.491 292.405 226.413 292.405C227.334 292.405 228.217 292.039 228.868 291.388C229.52 290.736 229.886 289.853 229.886 288.932C229.886 288.011 229.52 287.127 228.868 286.476C228.217 285.824 227.334 285.458 226.413 285.458C225.491 285.458 224.608 285.824 223.957 286.476C223.305 287.127 222.939 288.011 222.939 288.932ZM229.886 288.932C229.886 289.853 230.252 290.736 230.903 291.388C231.554 292.039 232.438 292.405 233.359 292.405C234.28 292.405 235.164 292.039 235.815 291.388C236.466 290.736 236.832 289.853 236.832 288.932C236.832 288.011 236.466 287.127 235.815 286.476C235.164 285.824 234.28 285.458 233.359 285.458C232.438 285.458 231.554 285.824 230.903 286.476C230.252 287.127 229.886 288.011 229.886 288.932ZM250.726 288.932C250.726 289.853 251.091 290.736 251.743 291.388C252.394 292.039 253.278 292.405 254.199 292.405C255.12 292.405 256.003 292.039 256.655 291.388C257.306 290.736 257.672 289.853 257.672 288.932C257.672 288.011 257.306 287.127 256.655 286.476C256.003 285.824 255.12 285.458 254.199 285.458C253.278 285.458 252.394 285.824 251.743 286.476C251.091 287.127 250.726 288.011 250.726 288.932ZM257.672 288.932C257.672 289.853 258.038 290.736 258.689 291.388C259.341 292.039 260.224 292.405 261.145 292.405C262.067 292.405 262.95 292.039 263.601 291.388C264.253 290.736 264.619 289.853 264.619 288.932C264.619 288.011 264.253 287.127 263.601 286.476C262.95 285.824 262.067 285.458 261.145 285.458C260.224 285.458 259.341 285.824 258.689 286.476C258.038 287.127 257.672 288.011 257.672 288.932ZM264.619 288.932C264.619 289.853 264.985 290.736 265.636 291.388C266.287 292.039 267.171 292.405 268.092 292.405C269.013 292.405 269.897 292.039 270.548 291.388C271.199 290.736 271.565 289.853 271.565 288.932C271.565 288.011 271.199 287.127 270.548 286.476C269.897 285.824 269.013 285.458 268.092 285.458C267.171 285.458 266.287 285.824 265.636 286.476C264.985 287.127 264.619 288.011 264.619 288.932ZM271.565 288.932C271.565 289.853 271.931 290.736 272.583 291.388C273.234 292.039 274.117 292.405 275.039 292.405C275.96 292.405 276.843 292.039 277.495 291.388C278.146 290.736 278.512 289.853 278.512 288.932C278.512 288.011 278.146 287.127 277.495 286.476C276.843 285.824 275.96 285.458 275.039 285.458C274.117 285.458 273.234 285.824 272.583 286.476C271.931 287.127 271.565 288.011 271.565 288.932ZM278.512 288.932C278.512 289.853 278.878 290.736 279.529 291.388C280.181 292.039 281.064 292.405 281.985 292.405C282.906 292.405 283.79 292.039 284.441 291.388C285.093 290.736 285.458 289.853 285.458 288.932C285.458 288.011 285.093 287.127 284.441 286.476C283.79 285.824 282.906 285.458 281.985 285.458C281.064 285.458 280.181 285.824 279.529 286.476C278.878 287.127 278.512 288.011 278.512 288.932Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path d="M7.59497 7.59494H60.595V60.5949H7.59497V7.59494Z" fill={bg} />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.59497 23.4949C7.59497 14.7136 14.7136 7.59494 23.495 7.59494H44.695C53.4763 7.59494 60.595 14.7136 60.595 23.4949V44.6949C60.595 53.4762 53.4763 60.5949 44.695 60.5949H23.495C14.7136 60.5949 7.59497 53.4762 7.59497 44.6949V23.4949ZM44.695 15.9087H23.495C19.3052 15.9087 15.9087 19.3052 15.9087 23.4949V44.6949C15.9087 48.8847 19.3052 52.2812 23.495 52.2812H44.695C48.8848 52.2812 52.2813 48.8847 52.2813 44.6949V23.4949C52.2813 19.3052 48.8848 15.9087 44.695 15.9087Z"
          fill="#FB49FF"
        />
        <path
          d="M22.1699 30.1199C22.1699 25.7293 25.7293 22.1699 30.1199 22.1699H38.0699C42.4606 22.1699 46.0199 25.7293 46.0199 30.1199V38.0699C46.0199 42.4606 42.4606 46.0199 38.0699 46.0199H30.1199C25.7293 46.0199 22.1699 42.4606 22.1699 38.0699V30.1199Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.59497 23.4949C7.59497 14.7136 14.7136 7.59494 23.495 7.59494H44.695C53.4763 7.59494 60.595 14.7136 60.595 23.4949V44.6949C60.595 53.4762 53.4763 60.5949 44.695 60.5949H23.495C14.7136 60.5949 7.59497 53.4762 7.59497 44.6949V23.4949ZM44.695 15.9087H23.495C19.3052 15.9087 15.9087 19.3052 15.9087 23.4949V44.6949C15.9087 48.8847 19.3052 52.2812 23.495 52.2812H44.695C48.8848 52.2812 52.2813 48.8847 52.2813 44.6949V23.4949C52.2813 19.3052 48.8848 15.9087 44.695 15.9087Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M22.1699 30.1199C22.1699 25.7293 25.7293 22.1699 30.1199 22.1699H38.0699C42.4606 22.1699 46.0199 25.7293 46.0199 30.1199V38.0699C46.0199 42.4606 42.4606 46.0199 38.0699 46.0199H30.1199C25.7293 46.0199 22.1699 42.4606 22.1699 38.0699V30.1199Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path d="M7.59497 7.59494H60.595V60.5949H7.59497V7.59494Z" fill={bg} />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.59497 23.4949C7.59497 14.7136 14.7136 7.59494 23.495 7.59494H44.695C53.4763 7.59494 60.595 14.7136 60.595 23.4949V44.6949C60.595 53.4762 53.4763 60.5949 44.695 60.5949H23.495C14.7136 60.5949 7.59497 53.4762 7.59497 44.6949V23.4949ZM44.695 15.9087H23.495C19.3052 15.9087 15.9087 19.3052 15.9087 23.4949V44.6949C15.9087 48.8847 19.3052 52.2812 23.495 52.2812H44.695C48.8848 52.2812 52.2813 48.8847 52.2813 44.6949V23.4949C52.2813 19.3052 48.8848 15.9087 44.695 15.9087Z"
          fill="#FB49FF"
        />
        <path
          d="M22.1699 30.1199C22.1699 25.7293 25.7293 22.1699 30.1199 22.1699H38.0699C42.4606 22.1699 46.0199 25.7293 46.0199 30.1199V38.0699C46.0199 42.4606 42.4606 46.0199 38.0699 46.0199H30.1199C25.7293 46.0199 22.1699 42.4606 22.1699 38.0699V30.1199Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.59497 23.4949C7.59497 14.7136 14.7136 7.59494 23.495 7.59494H44.695C53.4763 7.59494 60.595 14.7136 60.595 23.4949V44.6949C60.595 53.4762 53.4763 60.5949 44.695 60.5949H23.495C14.7136 60.5949 7.59497 53.4762 7.59497 44.6949V23.4949ZM44.695 15.9087H23.495C19.3052 15.9087 15.9087 19.3052 15.9087 23.4949V44.6949C15.9087 48.8847 19.3052 52.2812 23.495 52.2812H44.695C48.8848 52.2812 52.2813 48.8847 52.2813 44.6949V23.4949C52.2813 19.3052 48.8848 15.9087 44.695 15.9087Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M22.1699 30.1199C22.1699 25.7293 25.7293 22.1699 30.1199 22.1699H38.0699C42.4606 22.1699 46.0199 25.7293 46.0199 30.1199V38.0699C46.0199 42.4606 42.4606 46.0199 38.0699 46.0199H30.1199C25.7293 46.0199 22.1699 42.4606 22.1699 38.0699V30.1199Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path d="M7.59497 7.59494H60.595V60.5949H7.59497V7.59494Z" fill={bg} />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.59497 23.4949C7.59497 14.7136 14.7136 7.59494 23.495 7.59494H44.695C53.4763 7.59494 60.595 14.7136 60.595 23.4949V44.6949C60.595 53.4762 53.4763 60.5949 44.695 60.5949H23.495C14.7136 60.5949 7.59497 53.4762 7.59497 44.6949V23.4949ZM44.695 15.9087H23.495C19.3052 15.9087 15.9087 19.3052 15.9087 23.4949V44.6949C15.9087 48.8847 19.3052 52.2812 23.495 52.2812H44.695C48.8848 52.2812 52.2813 48.8847 52.2813 44.6949V23.4949C52.2813 19.3052 48.8848 15.9087 44.695 15.9087Z"
          fill="#FB49FF"
        />
        <path
          d="M22.1699 30.1199C22.1699 25.7293 25.7293 22.1699 30.1199 22.1699H38.0699C42.4606 22.1699 46.0199 25.7293 46.0199 30.1199V38.0699C46.0199 42.4606 42.4606 46.0199 38.0699 46.0199H30.1199C25.7293 46.0199 22.1699 42.4606 22.1699 38.0699V30.1199Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M7.59497 23.4949C7.59497 14.7136 14.7136 7.59494 23.495 7.59494H44.695C53.4763 7.59494 60.595 14.7136 60.595 23.4949V44.6949C60.595 53.4762 53.4763 60.5949 44.695 60.5949H23.495C14.7136 60.5949 7.59497 53.4762 7.59497 44.6949V23.4949ZM44.695 15.9087H23.495C19.3052 15.9087 15.9087 19.3052 15.9087 23.4949V44.6949C15.9087 48.8847 19.3052 52.2812 23.495 52.2812H44.695C48.8848 52.2812 52.2813 48.8847 52.2813 44.6949V23.4949C52.2813 19.3052 48.8848 15.9087 44.695 15.9087Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M22.1699 30.1199C22.1699 25.7293 25.7293 22.1699 30.1199 22.1699H38.0699C42.4606 22.1699 46.0199 25.7293 46.0199 30.1199V38.0699C46.0199 42.4606 42.4606 46.0199 38.0699 46.0199H30.1199C25.7293 46.0199 22.1699 42.4606 22.1699 38.0699V30.1199Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path d="M8 239H61V292H8V239Z" fill={bg} />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8 254.9C8 246.119 15.1187 239 23.9 239H45.1C53.8813 239 61 246.119 61 254.9V276.1C61 284.881 53.8813 292 45.1 292H23.9C15.1187 292 8 284.881 8 276.1V254.9ZM45.1 247.314H23.9C19.7102 247.314 16.3137 250.71 16.3137 254.9V276.1C16.3137 280.29 19.7102 283.686 23.9 283.686H45.1C49.2898 283.686 52.6863 280.29 52.6863 276.1V254.9C52.6863 250.71 49.2898 247.314 45.1 247.314Z"
          fill="#FB49FF"
        />
        <path
          d="M22.575 261.525C22.575 257.134 26.1343 253.575 30.525 253.575H38.475C42.8656 253.575 46.425 257.134 46.425 261.525V269.475C46.425 273.866 42.8656 277.425 38.475 277.425H30.525C26.1343 277.425 22.575 273.866 22.575 269.475V261.525Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8 254.9C8 246.119 15.1187 239 23.9 239H45.1C53.8813 239 61 246.119 61 254.9V276.1C61 284.881 53.8813 292 45.1 292H23.9C15.1187 292 8 284.881 8 276.1V254.9ZM45.1 247.314H23.9C19.7102 247.314 16.3137 250.71 16.3137 254.9V276.1C16.3137 280.29 19.7102 283.686 23.9 283.686H45.1C49.2898 283.686 52.6863 280.29 52.6863 276.1V254.9C52.6863 250.71 49.2898 247.314 45.1 247.314Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M22.575 261.525C22.575 257.134 26.1343 253.575 30.525 253.575H38.475C42.8656 253.575 46.425 257.134 46.425 261.525V269.475C46.425 273.866 42.8656 277.425 38.475 277.425H30.525C26.1343 277.425 22.575 273.866 22.575 269.475V261.525Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path d="M8 239H61V292H8V239Z" fill={bg} />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8 254.9C8 246.119 15.1187 239 23.9 239H45.1C53.8813 239 61 246.119 61 254.9V276.1C61 284.881 53.8813 292 45.1 292H23.9C15.1187 292 8 284.881 8 276.1V254.9ZM45.1 247.314H23.9C19.7102 247.314 16.3137 250.71 16.3137 254.9V276.1C16.3137 280.29 19.7102 283.686 23.9 283.686H45.1C49.2898 283.686 52.6863 280.29 52.6863 276.1V254.9C52.6863 250.71 49.2898 247.314 45.1 247.314Z"
          fill="#FB49FF"
        />
        <path
          d="M22.575 261.525C22.575 257.134 26.1343 253.575 30.525 253.575H38.475C42.8656 253.575 46.425 257.134 46.425 261.525V269.475C46.425 273.866 42.8656 277.425 38.475 277.425H30.525C26.1343 277.425 22.575 273.866 22.575 269.475V261.525Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8 254.9C8 246.119 15.1187 239 23.9 239H45.1C53.8813 239 61 246.119 61 254.9V276.1C61 284.881 53.8813 292 45.1 292H23.9C15.1187 292 8 284.881 8 276.1V254.9ZM45.1 247.314H23.9C19.7102 247.314 16.3137 250.71 16.3137 254.9V276.1C16.3137 280.29 19.7102 283.686 23.9 283.686H45.1C49.2898 283.686 52.6863 280.29 52.6863 276.1V254.9C52.6863 250.71 49.2898 247.314 45.1 247.314Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M22.575 261.525C22.575 257.134 26.1343 253.575 30.525 253.575H38.475C42.8656 253.575 46.425 257.134 46.425 261.525V269.475C46.425 273.866 42.8656 277.425 38.475 277.425H30.525C26.1343 277.425 22.575 273.866 22.575 269.475V261.525Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M6 247C6 242.582 9.58172 239 14 239H53C57.4183 239 61 242.582 61 247V286C61 290.418 57.4183 294 53 294H14C9.58172 294 6 290.418 6 286V247Z"
          fill={bg}
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8 254.9C8 246.119 15.1187 239 23.9 239H45.1C53.8813 239 61 246.119 61 254.9V276.1C61 284.881 53.8813 292 45.1 292H23.9C15.1187 292 8 284.881 8 276.1V254.9ZM45.1 247.314H23.9C19.7102 247.314 16.3137 250.71 16.3137 254.9V276.1C16.3137 280.29 19.7102 283.686 23.9 283.686H45.1C49.2898 283.686 52.6863 280.29 52.6863 276.1V254.9C52.6863 250.71 49.2898 247.314 45.1 247.314Z"
          fill="#FB49FF"
        />
        <path
          d="M22.575 261.525C22.575 257.134 26.1343 253.575 30.525 253.575H38.475C42.8656 253.575 46.425 257.134 46.425 261.525V269.475C46.425 273.866 42.8656 277.425 38.475 277.425H30.525C26.1343 277.425 22.575 273.866 22.575 269.475V261.525Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M8 254.9C8 246.119 15.1187 239 23.9 239H45.1C53.8813 239 61 246.119 61 254.9V276.1C61 284.881 53.8813 292 45.1 292H23.9C15.1187 292 8 284.881 8 276.1V254.9ZM45.1 247.314H23.9C19.7102 247.314 16.3137 250.71 16.3137 254.9V276.1C16.3137 280.29 19.7102 283.686 23.9 283.686H45.1C49.2898 283.686 52.6863 280.29 52.6863 276.1V254.9C52.6863 250.71 49.2898 247.314 45.1 247.314Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M22.575 261.525C22.575 257.134 26.1343 253.575 30.525 253.575H38.475C42.8656 253.575 46.425 257.134 46.425 261.525V269.475C46.425 273.866 42.8656 277.425 38.475 277.425H30.525C26.1343 277.425 22.575 273.866 22.575 269.475V261.525Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path d="M239 8H292V61H239V8Z" fill={bg} />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M239 23.9C239 15.1187 246.119 8 254.9 8H276.1C284.881 8 292 15.1187 292 23.9V45.1C292 53.8813 284.881 61 276.1 61H254.9C246.119 61 239 53.8813 239 45.1V23.9ZM276.1 16.3137H254.9C250.71 16.3137 247.314 19.7102 247.314 23.9V45.1C247.314 49.2898 250.71 52.6863 254.9 52.6863H276.1C280.29 52.6863 283.686 49.2898 283.686 45.1V23.9C283.686 19.7102 280.29 16.3137 276.1 16.3137Z"
          fill="#FB49FF"
        />
        <path
          d="M253.575 30.525C253.575 26.1343 257.134 22.575 261.525 22.575H269.475C273.866 22.575 277.425 26.1343 277.425 30.525V38.475C277.425 42.8657 273.866 46.425 269.475 46.425H261.525C257.134 46.425 253.575 42.8657 253.575 38.475V30.525Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M239 23.9C239 15.1187 246.119 8 254.9 8H276.1C284.881 8 292 15.1187 292 23.9V45.1C292 53.8813 284.881 61 276.1 61H254.9C246.119 61 239 53.8813 239 45.1V23.9ZM276.1 16.3137H254.9C250.71 16.3137 247.314 19.7102 247.314 23.9V45.1C247.314 49.2898 250.71 52.6863 254.9 52.6863H276.1C280.29 52.6863 283.686 49.2898 283.686 45.1V23.9C283.686 19.7102 280.29 16.3137 276.1 16.3137Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M253.575 30.525C253.575 26.1343 257.134 22.575 261.525 22.575H269.475C273.866 22.575 277.425 26.1343 277.425 30.525V38.475C277.425 42.8657 273.866 46.425 269.475 46.425H261.525C257.134 46.425 253.575 42.8657 253.575 38.475V30.525Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path d="M239 8H292V61H239V8Z" fill={bg} />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M239 23.9C239 15.1187 246.119 8 254.9 8H276.1C284.881 8 292 15.1187 292 23.9V45.1C292 53.8813 284.881 61 276.1 61H254.9C246.119 61 239 53.8813 239 45.1V23.9ZM276.1 16.3137H254.9C250.71 16.3137 247.314 19.7102 247.314 23.9V45.1C247.314 49.2898 250.71 52.6863 254.9 52.6863H276.1C280.29 52.6863 283.686 49.2898 283.686 45.1V23.9C283.686 19.7102 280.29 16.3137 276.1 16.3137Z"
          fill="#FB49FF"
        />
        <path
          d="M253.575 30.525C253.575 26.1343 257.134 22.575 261.525 22.575H269.475C273.866 22.575 277.425 26.1343 277.425 30.525V38.475C277.425 42.8657 273.866 46.425 269.475 46.425H261.525C257.134 46.425 253.575 42.8657 253.575 38.475V30.525Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M239 23.9C239 15.1187 246.119 8 254.9 8H276.1C284.881 8 292 15.1187 292 23.9V45.1C292 53.8813 284.881 61 276.1 61H254.9C246.119 61 239 53.8813 239 45.1V23.9ZM276.1 16.3137H254.9C250.71 16.3137 247.314 19.7102 247.314 23.9V45.1C247.314 49.2898 250.71 52.6863 254.9 52.6863H276.1C280.29 52.6863 283.686 49.2898 283.686 45.1V23.9C283.686 19.7102 280.29 16.3137 276.1 16.3137Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M253.575 30.525C253.575 26.1343 257.134 22.575 261.525 22.575H269.475C273.866 22.575 277.425 26.1343 277.425 30.525V38.475C277.425 42.8657 273.866 46.425 269.475 46.425H261.525C257.134 46.425 253.575 42.8657 253.575 38.475V30.525Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M239 17C239 10.3726 244.373 5 251 5H284C290.627 5 296 10.3726 296 17V49C296 55.6274 290.627 61 284 61H251C244.373 61 239 55.6274 239 49V17Z"
          fill={bg}
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M239 23.9C239 15.1187 246.119 8 254.9 8H276.1C284.881 8 292 15.1187 292 23.9V45.1C292 53.8813 284.881 61 276.1 61H254.9C246.119 61 239 53.8813 239 45.1V23.9ZM276.1 16.3137H254.9C250.71 16.3137 247.314 19.7102 247.314 23.9V45.1C247.314 49.2898 250.71 52.6863 254.9 52.6863H276.1C280.29 52.6863 283.686 49.2898 283.686 45.1V23.9C283.686 19.7102 280.29 16.3137 276.1 16.3137Z"
          fill="#FB49FF"
        />
        <path
          d="M253.575 30.525C253.575 26.1343 257.134 22.575 261.525 22.575H269.475C273.866 22.575 277.425 26.1343 277.425 30.525V38.475C277.425 42.8657 273.866 46.425 269.475 46.425H261.525C257.134 46.425 253.575 42.8657 253.575 38.475V30.525Z"
          fill="#FB49FF"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M239 23.9C239 15.1187 246.119 8 254.9 8H276.1C284.881 8 292 15.1187 292 23.9V45.1C292 53.8813 284.881 61 276.1 61H254.9C246.119 61 239 53.8813 239 45.1V23.9ZM276.1 16.3137H254.9C250.71 16.3137 247.314 19.7102 247.314 23.9V45.1C247.314 49.2898 250.71 52.6863 254.9 52.6863H276.1C280.29 52.6863 283.686 49.2898 283.686 45.1V23.9C283.686 19.7102 280.29 16.3137 276.1 16.3137Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <path
          d="M253.575 30.525C253.575 26.1343 257.134 22.575 261.525 22.575H269.475C273.866 22.575 277.425 26.1343 277.425 30.525V38.475C277.425 42.8657 273.866 46.425 269.475 46.425H261.525C257.134 46.425 253.575 42.8657 253.575 38.475V30.525Z"
          fill="white"
          fillOpacity="0.176471"
        />
        <g clipPath="url(#clip1_12_3375)">
          <rect x="105" y="105" width="90" height="90" rx="8.75912" fill={bg} />
          <g filter="url(#filter0_d_12_3375)">
            <path
              d="M165.41 130.354C165.482 129.096 165.653 128.266 165.998 127.508C166.134 127.208 166.262 126.962 166.281 126.962C166.301 126.962 166.242 127.184 166.15 127.454C165.899 128.19 165.858 129.196 166.031 130.367C166.25 131.852 166.374 132.066 167.951 133.67C168.69 134.423 169.551 135.372 169.862 135.779L170.429 136.52L169.862 135.991C169.169 135.343 167.574 134.08 167.222 133.9C166.986 133.779 166.951 133.781 166.805 133.925C166.671 134.058 166.643 134.258 166.624 135.203C166.595 136.676 166.393 137.621 165.907 138.566C165.644 139.078 165.602 138.969 165.84 138.392C166.018 137.961 166.036 137.771 166.035 136.346C166.032 133.481 165.69 132.792 163.687 131.613C163.18 131.314 162.344 130.883 161.829 130.655C161.315 130.427 160.906 130.228 160.921 130.213C160.977 130.157 162.931 130.725 163.717 131.026C164.887 131.474 165.08 131.532 165.222 131.478C165.317 131.442 165.364 131.166 165.41 130.354Z"
              fill="url(#paint0_linear_12_3375)"
            />
            <path
              d="M140.697 126.187C140.003 126.08 139.974 126.067 140.3 126.017C140.926 125.922 142.404 126.052 143.422 126.292C145.799 126.854 147.962 128.292 150.271 130.847L150.884 131.525L151.761 131.385C155.458 130.795 159.219 131.264 162.364 132.708C163.229 133.105 164.594 133.896 164.764 134.099C164.818 134.164 164.918 134.581 164.986 135.026C165.219 136.565 165.102 137.744 164.629 138.625C164.371 139.105 164.357 139.257 164.53 139.667C164.668 139.994 165.054 140.237 165.436 140.236C166.217 140.235 167.059 138.979 167.449 137.232L167.603 136.538L167.91 136.884C169.593 138.778 170.914 141.361 171.141 143.2L171.2 143.68L170.918 143.244C170.431 142.494 169.942 141.983 169.316 141.571C168.187 140.829 166.993 140.577 163.832 140.411C160.977 140.262 159.361 140.019 157.759 139.5C155.032 138.617 153.658 137.44 150.42 133.219C148.982 131.343 148.093 130.306 147.208 129.47C145.199 127.572 143.224 126.576 140.697 126.187Z"
              fill="url(#paint1_linear_12_3375)"
            />
            <path
              d="M142.045 135.268C140.636 133.341 139.764 130.386 139.953 128.177L140.011 127.494L140.332 127.552C140.934 127.661 141.972 128.045 142.459 128.338C143.793 129.143 144.37 130.203 144.958 132.925C145.13 133.723 145.356 134.625 145.46 134.93C145.627 135.422 146.259 136.57 146.773 137.316C147.143 137.853 146.897 138.108 146.079 138.034C144.829 137.922 143.137 136.762 142.045 135.268Z"
              fill="url(#paint2_linear_12_3375)"
            />
            <path
              d="M163.7 149.61C157.117 146.976 154.798 144.69 154.798 140.833C154.798 140.265 154.818 139.801 154.842 139.801C154.866 139.801 155.12 139.988 155.408 140.217C156.743 141.281 158.237 141.735 162.376 142.335C164.811 142.688 166.181 142.973 167.445 143.39C171.463 144.714 173.949 147.401 174.542 151.061C174.714 152.125 174.613 154.119 174.334 155.17C174.113 156.001 173.44 157.497 173.262 157.554C173.213 157.57 173.164 157.382 173.151 157.126C173.084 155.751 172.385 154.413 171.211 153.411C169.876 152.271 168.083 151.364 163.7 149.61Z"
              fill="url(#paint3_linear_12_3375)"
            />
            <path
              d="M159.078 150.704C158.996 150.217 158.853 149.594 158.76 149.32L158.592 148.823L158.904 149.171C159.336 149.652 159.677 150.269 159.966 151.089C160.187 151.716 160.212 151.902 160.21 152.92C160.209 153.919 160.181 154.129 159.977 154.693C159.656 155.582 159.257 156.212 158.588 156.889C157.385 158.105 155.839 158.778 153.608 159.058C153.221 159.106 152.09 159.188 151.097 159.239C148.592 159.369 146.944 159.636 145.463 160.153C145.25 160.227 145.06 160.272 145.041 160.253C144.981 160.194 145.989 159.596 146.822 159.198C147.996 158.636 149.165 158.329 151.785 157.895C153.079 157.681 154.415 157.421 154.754 157.318C157.958 156.342 159.605 153.823 159.078 150.704Z"
              fill="url(#paint4_linear_12_3375)"
            />
            <path
              d="M162.096 156.03C161.221 154.162 161.02 152.358 161.499 150.675C161.551 150.496 161.633 150.348 161.683 150.348C161.732 150.348 161.939 150.459 162.141 150.595C162.544 150.864 163.353 151.318 165.506 152.485C168.194 153.941 169.726 155.069 170.768 156.357C171.68 157.485 172.245 158.769 172.517 160.336C172.671 161.223 172.58 163.359 172.351 164.252C171.629 167.07 169.95 169.283 167.554 170.575C167.203 170.764 166.888 170.919 166.854 170.92C166.82 170.92 166.948 170.597 167.139 170.202C167.944 168.528 168.036 166.9 167.427 165.088C167.054 163.978 166.293 162.625 164.758 160.336C162.973 157.676 162.535 156.968 162.096 156.03Z"
              fill="url(#paint5_linear_12_3375)"
            />
            <path
              d="M137.37 166.111C139.813 164.061 142.852 162.605 145.621 162.158C146.814 161.965 148.802 162.042 149.907 162.323C151.678 162.773 153.262 163.782 154.086 164.984C154.891 166.159 155.237 167.182 155.597 169.46C155.738 170.359 155.893 171.261 155.94 171.465C156.21 172.645 156.735 173.589 157.387 174.063C158.421 174.815 160.203 174.862 161.955 174.183C162.253 174.067 162.511 173.988 162.529 174.006C162.593 174.068 161.71 174.655 161.088 174.964C160.25 175.38 159.584 175.541 158.699 175.541C157.094 175.541 155.761 174.73 154.649 173.075C154.43 172.75 153.938 171.774 153.556 170.908C152.382 168.247 151.802 167.437 150.439 166.549C149.253 165.777 147.723 165.639 146.572 166.2C145.06 166.937 144.638 168.856 145.721 170.073C146.152 170.557 146.954 170.974 147.61 171.055C148.838 171.207 149.893 170.278 149.893 169.047C149.893 168.247 149.584 167.791 148.805 167.441C147.741 166.964 146.598 167.522 146.604 168.515C146.606 168.938 146.792 169.204 147.219 169.396C147.493 169.519 147.499 169.529 147.276 169.483C146.3 169.282 146.071 168.113 146.856 167.337C147.798 166.405 149.746 166.816 150.415 168.088C150.696 168.622 150.728 169.686 150.483 170.328C149.935 171.766 148.336 172.522 146.714 172.111C145.61 171.831 145.16 171.527 143.829 170.165C141.515 167.796 140.617 167.337 137.282 166.82L136.642 166.721L137.37 166.111Z"
              fill="url(#paint6_linear_12_3375)"
            />
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M126.514 123.724C134.24 133.043 139.562 136.887 140.153 137.7C140.641 138.37 140.458 138.973 139.621 139.446C139.156 139.709 138.2 139.975 137.721 139.975C137.179 139.975 136.993 139.767 136.993 139.767C136.679 139.471 136.503 139.523 134.89 136.679C132.651 133.227 130.778 130.363 130.727 130.315C130.608 130.204 130.61 130.208 134.662 137.411C135.316 138.913 134.792 139.464 134.792 139.678C134.792 140.113 134.672 140.341 134.132 140.94C133.232 141.938 132.83 143.059 132.539 145.38C132.214 147.981 131.298 149.819 128.76 152.964C127.275 154.805 127.032 155.142 126.657 155.884C126.185 156.818 126.055 157.342 126.002 158.522C125.947 159.769 126.055 160.575 126.439 161.768C126.774 162.812 127.125 163.502 128.021 164.881C128.794 166.071 129.24 166.955 129.24 167.301C129.24 167.577 129.292 167.577 130.491 167.308C133.358 166.665 135.687 165.533 136.996 164.146C137.807 163.288 137.997 162.814 138.003 161.637C138.007 160.868 137.98 160.707 137.771 160.264C137.43 159.543 136.81 158.944 135.443 158.016C133.651 156.799 132.886 155.819 132.675 154.472C132.501 153.367 132.703 152.587 133.694 150.523C134.719 148.386 134.973 147.476 135.145 145.323C135.256 143.932 135.41 143.383 135.812 142.943C136.232 142.483 136.61 142.328 137.648 142.187C139.34 141.957 140.418 141.522 141.304 140.711C142.073 140.007 142.394 139.329 142.444 138.308L142.481 137.534L142.052 137.037C140.496 135.235 125.473 122.308 125.377 122.308C125.356 122.308 125.868 122.945 126.514 123.724ZM130.113 159.933C130.464 159.314 130.277 158.519 129.689 158.13C129.133 157.763 128.27 157.936 128.27 158.414C128.27 158.56 128.351 158.667 128.534 158.76C128.843 158.918 128.865 159.095 128.623 159.458C128.377 159.825 128.397 160.148 128.679 160.367C129.133 160.72 129.776 160.526 130.113 159.933Z"
              fill="url(#paint7_linear_12_3375)"
            />
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M143.549 142.593C142.755 142.835 141.982 143.672 141.743 144.55C141.597 145.085 141.68 146.024 141.899 146.314C142.251 146.782 142.593 146.906 143.517 146.899C145.327 146.887 146.9 146.115 147.083 145.151C147.233 144.361 146.542 143.266 145.59 142.785C145.099 142.537 144.055 142.439 143.549 142.593ZM145.665 144.236C145.944 143.842 145.822 143.417 145.347 143.129C144.443 142.58 143.076 143.034 143.076 143.882C143.076 144.305 143.789 144.766 144.442 144.766C144.877 144.766 145.472 144.508 145.665 144.236Z"
              fill="url(#paint8_linear_12_3375)"
            />
          </g>
        </g>
      </g>
      <defs>
        <filter
          id="filter0_d_12_3375"
          x="124.261"
          y="121.193"
          width="51.4807"
          height="55.4637"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset />
          <feGaussianBlur stdDeviation="0.557607" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.605405 0 0 0 0.15 0" />
          <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_12_3375" />
          <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_12_3375" result="shape" />
        </filter>
        <linearGradient
          id="paint0_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint1_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint2_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint3_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint4_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint5_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint6_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint7_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <linearGradient
          id="paint8_linear_12_3375"
          x1="172.151"
          y1="167.208"
          x2="129.726"
          y2="125.988"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FFCDF1" />
          <stop offset="0.380969" stopColor="#F436DA" />
          <stop offset="1" stopColor="#F356EF" />
        </linearGradient>
        <clipPath id="clip0_12_3375">
          <rect width="300" height="300" fill="white" />
        </clipPath>
        <clipPath id="clip1_12_3375">
          <rect x="105" y="105" width="90" height="90" rx="8.75912" fill="white" />
        </clipPath>
      </defs>
    </svg>
  )
}
