type SVGProps = React.SVGProps<SVGSVGElement>

export const USD_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M0 0H92.4107V3.74133H0V0ZM0 7.48265H92.4107V11.224H0V7.48265ZM0 14.9653H92.4107V18.7066H0V14.9653ZM0 22.448H92.4107V26.1893H0V22.448ZM0 29.9306H92.4107V33.6719H0V29.9306ZM0 37.4133H92.4107V41.1546H0V37.4133ZM0 44.8959H92.4107V48.6372H0V44.8959Z"
      fill="#BD3D44"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M0 3.74133H92.4107V7.48266H0V3.74133ZM0 11.224H92.4107V14.9653H0V11.224ZM0 18.7066H92.4107V22.448H0V18.7066ZM0 26.1893H92.4107V29.9306H0V26.1893ZM0 33.6719H92.4107V37.4133H0V33.6719ZM0 41.1546H92.4107V44.8959H0V41.1546Z"
      fill="white"
    />
    <path fillRule="evenodd" clipRule="evenodd" d="M0 0H36.9643V26.1893H0V0Z" fill="#192F5D" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M3.06837 1.12244L3.44251 2.17001H4.49008L3.62957 2.80603L3.96629 3.81619L3.06837 3.18017L2.24528 3.81619L2.582 2.80603L1.68408 2.17001H2.80648L3.06837 1.12244ZM9.24156 1.12244L9.57828 2.17001H10.6633L9.76535 2.80603L10.1395 3.81619L9.24156 3.18017L8.34364 3.81619L8.71777 2.80603L7.81986 2.17001H8.90484L9.24156 1.12244ZM15.4147 1.12244L15.7515 2.17001H16.8365L15.9385 2.80603L16.3127 3.81619L15.4147 3.18017L14.5168 3.81619L14.891 2.80603L13.993 2.17001H15.078L15.4147 1.12244ZM21.5505 1.12244L21.9247 2.17001H22.9722L22.1117 2.80603L22.4484 3.81619L21.5505 3.18017L20.69 3.81619L21.0267 2.80603L20.1288 2.17001H21.2512L21.5505 1.12244ZM27.7237 1.12244L28.0604 2.17001H29.1454L28.2475 2.80603L28.6216 3.81619L27.6863 3.18017L26.8258 3.81619L27.1625 2.80603L26.2646 2.17001H27.3496L27.7237 1.12244ZM33.8969 1.12244L34.2336 2.17001H35.3186L34.4207 2.80603L34.7948 3.81619L33.8969 3.18017L32.999 3.81619L33.3731 2.80603L32.4752 2.17001H33.5602L33.8969 1.12244ZM6.17367 3.74136L6.51039 4.78894H7.59538L6.69746 5.42496L7.07159 6.43512L6.17367 5.79909L5.27575 6.43512L5.64989 5.42496L4.75197 4.78894H5.83695L6.17367 3.74136ZM12.3094 3.74136L12.6836 4.78894H13.7312L12.8706 5.42496L13.2074 6.43512L12.3094 5.79909L11.4489 6.43512L11.7857 5.42496L10.8877 4.78894H12.0101L12.3094 3.74136ZM18.4826 3.74136L18.8194 4.78894H19.9043L19.0064 5.42496L19.3806 6.43512L18.4826 5.79909L17.5847 6.43512L17.9588 5.42496L17.0609 4.78894H18.1459L18.4826 3.74136ZM24.6558 3.74136L24.9925 4.78894H26.0775L25.1796 5.42496L25.5537 6.43512L24.6558 5.79909L23.7579 6.43512L24.132 5.42496L23.2341 4.78894H24.3191L24.6558 3.74136ZM30.7916 3.74136L31.1657 4.78894H32.1759L31.3154 5.42496L31.6521 6.43512L30.7542 5.79909L29.8937 6.43512L30.2304 5.42496L29.3325 4.78894H30.4549L30.7916 3.74136ZM3.10579 6.36029L3.40509 7.40786H4.52749L3.62957 8.04389L3.96629 9.05405L3.06837 8.41802L2.24528 9.05405L2.582 8.04389L1.68408 7.40786H2.80648L3.10579 6.36029ZM9.24156 6.36029L9.57828 7.40786H10.6633L9.80276 8.04389L10.1395 9.05405L9.24156 8.41802L8.38105 9.05405L8.71777 8.04389L7.81986 7.40786H8.90484L9.24156 6.36029ZM15.4147 6.36029L15.7515 7.40786H16.8365L15.9385 8.04389L16.3127 9.05405L15.4147 8.41802L14.5168 9.05405L14.891 8.04389L13.993 7.40786H15.078L15.4147 6.36029ZM21.5505 6.36029L21.9247 7.40786H22.9722L22.1117 8.04389L22.4484 9.05405L21.5505 8.41802L20.69 9.05405L21.0267 8.04389L20.1288 7.40786H21.2512L21.5505 6.36029ZM27.7237 6.36029L28.0604 7.40786H29.1454L28.2849 8.04389L28.6216 9.05405L27.7237 8.41802L26.8632 9.05405L27.1999 8.04389L26.302 7.40786H27.387L27.7237 6.36029ZM33.8969 6.36029L34.2336 7.40786H35.3186L34.4207 8.04389L34.7948 9.05405L33.8969 8.41802L32.999 9.05405L33.3731 8.04389L32.4752 7.40786H33.5602L33.8969 6.36029ZM6.17367 8.97922L6.51039 10.0268H7.59538L6.69746 10.6628L7.07159 11.673L6.17367 11.0369L5.27575 11.673L5.64989 10.6628L4.75197 10.0268H5.83695L6.17367 8.97922ZM12.3094 8.97922L12.6836 10.0268H13.7312L12.8706 10.6628L13.2074 11.673L12.3094 11.0369L11.4489 11.673L11.7857 10.6628L10.8877 10.0268H12.0101L12.3094 8.97922ZM18.4826 8.97922L18.8194 10.0268H19.9043L19.0438 10.6628L19.3806 11.673L18.4826 11.0369L17.6221 11.673L17.9588 10.6628L17.0609 10.0268H18.1459L18.4826 8.97922ZM24.6558 8.97922L24.9925 10.0268H26.0775L25.1796 10.6628L25.5537 11.673L24.6558 11.0369L23.7579 11.673L24.132 10.6628L23.2341 10.0268H24.3191L24.6558 8.97922ZM30.7916 8.97922L31.1657 10.0268H32.1759L31.3154 10.6628L31.6521 11.673L30.7542 11.0369L29.8937 11.673L30.2304 10.6628L29.3325 10.0268H30.4549L30.7916 8.97922ZM3.10579 11.5981L3.40509 12.6457H4.52749L3.62957 13.2817L3.96629 14.2919L3.06837 13.6559L2.24528 14.2919L2.582 13.2817L1.68408 12.6457H2.80648L3.10579 11.5981ZM9.24156 11.5981L9.57828 12.6457H10.6633L9.80276 13.2817L10.1395 14.2919L9.24156 13.6559L8.38105 14.2919L8.71777 13.2817L7.81986 12.6457H8.90484L9.24156 11.5981ZM15.4147 11.5981L15.7515 12.6457H16.8365L15.9385 13.2817L16.3127 14.2919L15.4147 13.6559L14.5168 14.2919L14.891 13.2817L13.993 12.6457H15.078L15.4147 11.5981ZM21.5505 11.5981L21.9247 12.6457H22.9722L22.1117 13.2817L22.4484 14.2919L21.5505 13.6559L20.69 14.2919L21.0267 13.2817L20.1288 12.6457H21.2512L21.5505 11.5981ZM27.7237 11.5981L28.0604 12.6457H29.1454L28.2849 13.2817L28.6216 14.2919L27.7237 13.6559L26.8632 14.2919L27.1999 13.2817L26.302 12.6457H27.387L27.7237 11.5981ZM33.8969 11.5981L34.2336 12.6457H35.3186L34.4207 13.2817L34.7948 14.2919L33.8969 13.6559L32.999 14.2919L33.3731 13.2817L32.4752 12.6457H33.5602L33.8969 11.5981ZM6.17367 14.2171L6.51039 15.2646H7.59538L6.69746 15.9007L7.07159 16.9108L6.17367 16.2748L5.27575 16.9108L5.64989 15.9007L4.75197 15.2646H5.83695L6.17367 14.2171ZM12.3094 14.2171L12.6836 15.2646H13.7312L12.8706 15.9007L13.2074 16.9108L12.3094 16.2748L11.4489 16.9108L11.7857 15.9007L10.8877 15.2646H12.0101L12.3094 14.2171ZM18.4826 14.2171L18.8194 15.2646H19.9043L19.0438 15.9007L19.3806 16.9108L18.4826 16.2748L17.6221 16.9108L17.9588 15.9007L17.0609 15.2646H18.1459L18.4826 14.2171ZM24.6558 14.2171L24.9925 15.2646H26.0775L25.1796 15.9007L25.5537 16.9108L24.6558 16.2748L23.7579 16.9108L24.132 15.9007L23.2341 15.2646H24.3191L24.6558 14.2171ZM30.7916 14.2171L31.1657 15.2646H32.1759L31.3154 15.9007L31.6521 16.9108L30.7542 16.2748L29.8937 16.9108L30.2304 15.9007L29.3325 15.2646H30.4549L30.7916 14.2171ZM3.10579 16.836L3.40509 17.8836H4.52749L3.62957 18.5196L3.96629 19.5298L3.06837 18.8937L2.24528 19.5298L2.582 18.5196L1.68408 17.8836H2.80648L3.10579 16.836ZM9.24156 16.836L9.57828 17.8836H10.6633L9.80276 18.5196L10.1395 19.5298L9.24156 18.8937L8.38105 19.5298L8.71777 18.5196L7.81986 17.8836H8.90484L9.24156 16.836ZM15.4147 16.836L15.7515 17.8836H16.8365L15.9385 18.5196L16.3127 19.5298L15.4147 18.8937L14.5168 19.5298L14.891 18.5196L13.993 17.8836H15.078L15.4147 16.836ZM21.5505 16.836L21.9247 17.8836H22.9722L22.1117 18.5196L22.4484 19.5298L21.5505 18.8937L20.69 19.5298L21.0267 18.5196L20.1288 17.8836H21.2512L21.5505 16.836ZM27.7237 16.836L28.0604 17.8836H29.1454L28.2849 18.5196L28.6216 19.5298L27.7237 18.8937L26.8632 19.5298L27.1999 18.5196L26.302 17.8836H27.387L27.7237 16.836ZM33.8969 16.836L34.2336 17.8836H35.3186L34.4207 18.5196L34.7948 19.5298L33.8969 18.8937L32.999 19.5298L33.3731 18.5196L32.4752 17.8836H33.5602L33.8969 16.836ZM6.17367 19.4549L6.51039 20.5025H7.59538L6.69746 21.1385L7.07159 22.1487L6.17367 21.5127L5.27575 22.1487L5.64989 21.1385L4.75197 20.5025H5.83695L6.17367 19.4549ZM12.3094 19.4549L12.6836 20.5025H13.7312L12.8706 21.1385L13.2074 22.1487L12.3094 21.5127L11.4489 22.1487L11.7857 21.1385L10.8877 20.5025H12.0101L12.3094 19.4549ZM18.4826 19.4549L18.8194 20.5025H19.9043L19.0438 21.1385L19.3806 22.1487L18.4826 21.5127L17.6221 22.1487L17.9588 21.1385L17.0609 20.5025H18.1459L18.4826 19.4549ZM24.6558 19.4549L24.9925 20.5025H26.0775L25.1796 21.1385L25.5537 22.1487L24.6558 21.5127L23.7579 22.1487L24.132 21.1385L23.2341 20.5025H24.3191L24.6558 19.4549ZM30.7916 19.4549L31.1657 20.5025H32.1759L31.3154 21.1385L31.6521 22.1487L30.7542 21.5127L29.8937 22.1487L30.2304 21.1385L29.3325 20.5025H30.4549L30.7916 19.4549ZM3.10579 22.0739L3.40509 23.1214H4.52749L3.62957 23.7575L3.96629 24.7676L3.06837 24.1316L2.24528 24.7676L2.582 23.7575L1.68408 23.1214H2.80648L3.10579 22.0739ZM9.24156 22.0739L9.57828 23.1214H10.6633L9.80276 23.7575L10.1395 24.7676L9.24156 24.1316L8.38105 24.7676L8.71777 23.7575L7.81986 23.1214H8.90484L9.24156 22.0739ZM15.4147 22.0739L15.7515 23.1214H16.8365L15.9385 23.7575L16.3127 24.7676L15.4147 24.1316L14.5168 24.7676L14.891 23.7575L13.993 23.1214H15.078L15.4147 22.0739ZM21.5505 22.0739L21.9247 23.1214H22.9722L22.1117 23.7575L22.4484 24.7676L21.5505 24.1316L20.69 24.7676L21.0267 23.7575L20.1288 23.1214H21.2512L21.5505 22.0739ZM27.7237 22.0739L28.0604 23.1214H29.1454L28.2849 23.7575L28.6216 24.7676L27.7237 24.1316L26.8632 24.7676L27.1999 23.7575L26.302 23.1214H27.387L27.7237 22.0739ZM33.8969 22.0739L34.2336 23.1214H35.3186L34.4207 23.7575L34.7948 24.7676L33.8969 24.1316L32.999 24.7676L33.3731 23.7575L32.4752 23.1214H33.5602L33.8969 22.0739Z"
      fill="white"
    />
  </svg>
)

export const EUR_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61766)">
      <path d="M0 0H48.5142V48.6368H0V0Z" fill="#003399" />
      <path
        d="M24.86 8.99864L24.2251 7.05127L23.5902 8.99864H21.5625L23.2112 10.1956L22.5764 12.1429L24.2251 10.946L25.8738 12.1429L25.2484 10.1956L26.8972 8.99864H24.86Z"
        fill="#FFCE08"
      />
      <path
        d="M39.6417 23.6277L39.0068 21.6803L38.372 23.6277H36.3442L37.993 24.8246L37.3581 26.772L39.0068 25.575L40.6556 26.772L40.0302 24.8246L41.6789 23.6277H39.6417Z"
        fill="#FFCE08"
      />
      <path
        d="M10.0782 23.6277L9.44336 21.6803L8.80851 23.6277H6.78076L8.42949 24.8246L7.79463 26.772L9.44336 25.575L11.0921 26.772L10.4667 24.8246L12.1154 23.6277H10.0782Z"
        fill="#FFCE08"
      />
      <path
        d="M24.86 38.3517L24.2251 36.4043L23.5902 38.3517H21.5625L23.2112 39.5486L22.5764 41.496L24.2251 40.299L25.8738 41.496L25.2484 39.5486L26.8972 38.3517H24.86Z"
        fill="#FFCE08"
      />
      <path
        d="M17.5403 10.965L16.9068 9.01905L16.2712 10.9657L14.2445 10.9668L15.8918 12.1621L15.2562 14.1087L16.9047 12.9116L18.5519 14.1069L17.9279 12.161L19.5764 10.9638L17.5403 10.965Z"
        fill="#FFCE08"
      />
      <path
        d="M37.6375 16.2245L37.004 14.2786L36.3684 16.2252L34.3417 16.2263L35.9889 17.4216L35.3533 19.3682L37.0019 18.1711L38.6491 19.3664L38.0251 17.4205L39.6736 16.2234L37.6375 16.2245Z"
        fill="#FFCE08"
      />
      <path
        d="M12.0349 31.0436L11.4014 29.0977L10.7659 31.0443L8.73917 31.0454L10.3864 32.2407L9.75081 34.1873L11.3993 32.9902L13.0465 34.1855L12.4226 32.2396L14.0711 31.0425L12.0349 31.0436Z"
        fill="#FFCE08"
      />
      <path
        d="M32.1794 36.3855L31.546 34.4396L30.9104 36.3862L28.8837 36.3873L30.5309 37.5826L29.8953 39.5292L31.5439 38.3321L33.1911 39.5274L32.5671 37.5815L34.2156 36.3844L32.1794 36.3855Z"
        fill="#FFCE08"
      />
      <path
        d="M12.1806 16.3376L11.545 14.391L10.9115 16.3369L8.88485 16.3358L10.5334 17.5329L9.89991 19.4788L11.5471 18.2835L13.1956 19.4806L12.5695 17.534L14.2167 16.3387L12.1806 16.3376Z"
        fill="#FFCE08"
      />
      <path
        d="M32.2089 10.8185L31.5733 8.87194L30.9399 10.8178L28.9132 10.8167L30.5617 12.0139L29.9282 13.9598L31.5754 12.7644L33.224 13.9616L32.5979 12.015L34.2451 10.8197L32.2089 10.8185Z"
        fill="#FFCE08"
      />
      <path
        d="M17.4272 36.4858L16.7916 34.5392L16.1581 36.4851L14.1314 36.484L15.78 37.6811L15.1465 39.627L16.7937 38.4317L18.4422 39.6288L17.8161 37.6822L19.4633 36.4869L17.4272 36.4858Z"
        fill="#FFCE08"
      />
      <path
        d="M37.537 31.0141L36.9014 29.0675L36.268 31.0134L34.2413 31.0123L35.8898 32.2094L35.2564 34.1553L36.9036 32.96L38.5521 34.1571L37.926 32.2105L39.5732 31.0152L37.537 31.0141Z"
        fill="#FFCE08"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61766">
        <path
          d="M0 24.3184C0 10.9215 10.8603 0 24.2571 0C37.654 0 48.5142 10.9215 48.5142 24.3184C48.5142 37.7152 37.654 48.6368 24.2571 48.6368C10.8603 48.6368 0 37.7152 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const RUB_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61784)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0H48.6368V48.5142H0V0Z" fill="white" />
      <path fillRule="evenodd" clipRule="evenodd" d="M0 16.1746H48.6368V48.5142H0V16.1746Z" fill="#0039A6" />
      <path fillRule="evenodd" clipRule="evenodd" d="M0 32.3397H48.6368V48.5143H0V32.3397Z" fill="#D52B1E" />
    </g>
    <defs>
      <clipPath id="clip0_1942_61784">
        <path
          d="M0 24.2571C0 10.8603 10.9215 0 24.3184 0C37.7152 0 48.6368 10.8603 48.6368 24.2571C48.6368 37.654 37.7152 48.5142 24.3184 48.5142C10.9215 48.5142 0 37.654 0 24.2571Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const INR_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61789)">
      <path d="M0 0H48.5142V16.2154H0V0Z" fill="#FF9933" />
      <path d="M0 16.2155H48.5142V32.4214H0V16.2155Z" fill="white" />
      <path d="M0 32.4214H48.5142V48.6368H0V32.4214Z" fill="#128807" />
      <path
        d="M24.2576 30.8033C27.8301 30.8033 30.7262 27.8999 30.7262 24.3184C30.7262 20.7369 27.8301 17.8335 24.2576 17.8335C20.6851 17.8335 17.7891 20.7369 17.7891 24.3184C17.7891 27.8999 20.6851 30.8033 24.2576 30.8033Z"
        fill="#000088"
      />
      <path
        d="M24.2572 29.9927C27.3831 29.9927 29.9171 27.4523 29.9171 24.3184C29.9171 21.1846 27.3831 18.6442 24.2572 18.6442C21.1312 18.6442 18.5972 21.1846 18.5972 24.3184C18.5972 27.4523 21.1312 29.9927 24.2572 29.9927Z"
        fill="white"
      />
      <path
        d="M24.2575 25.4533C24.8827 25.4533 25.3895 24.9452 25.3895 24.3185C25.3895 23.6917 24.8827 23.1836 24.2575 23.1836C23.6323 23.1836 23.1255 23.6917 23.1255 24.3185C23.1255 24.9452 23.6323 25.4533 24.2575 25.4533Z"
        fill="#000088"
      />
      <path
        d="M29.8308 25.3505C29.9902 25.3715 30.1364 25.2591 30.1574 25.0993C30.1783 24.9395 30.0661 24.7929 29.9068 24.7719C29.7474 24.7508 29.6012 24.8633 29.5802 25.0231C29.5592 25.1829 29.6714 25.3295 29.8308 25.3505Z"
        fill="#000088"
      />
      <path d="M24.257 29.9926L24.4511 26.588L24.257 24.9668L24.063 26.588L24.257 29.9926Z" fill="#000088" />
    </g>
    <defs>
      <clipPath id="clip0_1942_61789">
        <path
          d="M0 24.3184C0 10.9215 10.8603 0 24.2571 0C37.654 0 48.5142 10.9215 48.5142 24.3184C48.5142 37.7152 37.654 48.6368 24.2571 48.6368C10.8603 48.6368 0 37.7152 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const GBP_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61803)">
      <path d="M0 0H48.6368V48.5142H0V0Z" fill="#012169" />
      <path
        d="M48.6368 0V6.06428L30.588 24.2571L48.6368 41.9762V48.5142H42.2722L24.1284 30.7004L6.45957 48.5142H0V42.0709L17.6688 24.3519L0 7.01183V0H5.88961L24.1284 17.8138L41.7972 0H48.6368Z"
        fill="white"
      />
      <path
        d="M17.4788 30.7004L18.5238 33.9221L3.98973 48.5142H0V48.23L17.4788 30.7004ZM29.258 29.5634L34.3877 30.3214L48.6368 44.2503V48.5142L29.258 29.5634ZM48.6368 0L30.398 18.5719L30.018 14.4027L44.267 0H48.6368ZM0 0.0947544L18.3338 18.0033L12.7292 17.2453L0 4.64297V0.0947544Z"
        fill="#C8102E"
      />
      <path d="M16.7189 0V48.5142H31.9179V0H16.7189ZM0 16.6768V31.8375H48.6368V16.6768H0Z" fill="white" />
      <path d="M0 19.7089V28.8053H48.6368V19.7089H0ZM19.7587 0V48.5142H28.8781V0H19.7587Z" fill="#C8102E" />
    </g>
    <defs>
      <clipPath id="clip0_1942_61803">
        <path
          d="M0 24.2571C0 10.8603 10.9215 0 24.3184 0C37.7152 0 48.6368 10.8603 48.6368 24.2571C48.6368 37.654 37.7152 48.5142 24.3184 48.5142C10.9215 48.5142 0 37.654 0 24.2571Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const JPY_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61809)">
      <path fillRule="evenodd" clipRule="evenodd" d="M-12.1284 0H60.6436V48.6395H-12.1284V0Z" fill="white" />
      <path
        d="M24.2581 39.4414C32.5865 39.4414 39.338 32.6728 39.338 24.3234C39.338 15.974 32.5865 9.20544 24.2581 9.20544C15.9297 9.20544 9.17822 15.974 9.17822 24.3234C9.17822 32.6728 15.9297 39.4414 24.2581 39.4414Z"
        fill="#D30000"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61809">
        <path
          d="M0 24.3184C0 10.9215 10.8603 0 24.2571 0C37.654 0 48.5142 10.9215 48.5142 24.3184C48.5142 37.7152 37.654 48.6368 24.2571 48.6368C10.8603 48.6368 0 37.7152 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const VND_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61813)">
      <path fillRule="evenodd" clipRule="evenodd" d="M-12.1592 0H60.7966V48.517H-12.1592V0Z" fill="#EC0015" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M33.2067 36.1123L24.6963 29.773L16.234 36.1739L19.3842 25.7681L10.9287 19.3467L21.3882 19.2577L24.6277 8.88611L27.9426 19.2371L38.4021 19.2508L29.9947 25.7339L33.2067 36.1123Z"
        fill="#FFFF00"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61813">
        <path
          d="M0 24.2571C0 10.8603 10.9215 0 24.3184 0C37.7152 0 48.6368 10.8603 48.6368 24.2571C48.6368 37.654 37.7152 48.5142 24.3184 48.5142C10.9215 48.5142 0 37.654 0 24.2571Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const SGD_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61817)">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M-1.8999 6.10352e-05H71.0559V48.6395H-1.8999V6.10352e-05Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M-1.8999 6.10352e-05H71.0559V24.3164H-1.8999V6.10352e-05Z"
        fill="#DF0000"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M14.9283 4.07679C13.0084 4.48815 11.2885 5.54765 10.0576 7.07732C8.82663 8.607 8.15956 10.5137 8.16842 12.4771C8.17727 14.4406 8.86151 16.3411 10.1062 17.8597C11.3509 19.3782 13.0802 20.4221 15.0038 20.8161C13.7086 21.1951 12.3432 21.268 11.015 21.029C9.68694 20.79 8.43253 20.2457 7.35079 19.439C6.26905 18.6322 5.38957 17.5852 4.78173 16.3804C4.17389 15.1756 3.85432 13.846 3.84823 12.4966C3.84215 11.1472 4.14971 9.81479 4.74666 8.60457C5.34361 7.39434 6.21361 6.33939 7.28803 5.52293C8.36245 4.70646 9.6119 4.15083 10.9378 3.89987C12.2637 3.6489 13.6298 3.70947 14.9283 4.07679Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.9636 11.1459L10.6665 10.1988L12.2794 10.1851L12.7735 8.65461L13.2882 10.1851H14.8942L13.604 11.1459L14.0981 12.6764L12.7872 11.7362L11.4832 12.6833L11.9636 11.1459ZM13.7481 16.4237L12.4441 15.4766L14.0569 15.4629L14.5579 13.9324L15.0658 15.456H16.6787L15.3747 16.4169L15.8757 17.9474L14.5717 17.014L13.2677 17.9611L13.7481 16.4237ZM19.671 16.3826L18.367 15.4354L19.973 15.4217L20.474 13.8912L20.9819 15.4217H22.6016L21.3045 16.3826L21.8055 17.9131L20.4946 16.9728L19.1906 17.9199L19.671 16.3826ZM21.4349 11.1528L20.1309 10.2057L21.7437 10.192L22.2379 8.66147L22.7526 10.1851H24.3586L23.0683 11.1459L23.5625 12.6764L22.2516 11.743L20.9476 12.6902L21.4349 11.1528ZM16.7473 7.6869L15.4433 6.73978L17.0561 6.72605L17.5572 5.19556L18.065 6.72605H19.6779L18.3739 7.6869L18.8749 9.21053L17.5709 8.27713L16.2669 9.22425L16.7473 7.6869Z"
        fill="white"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61817">
        <path
          d="M0 24.3184C0 10.8877 10.8877 0 24.3184 0C37.749 0 48.6368 10.8877 48.6368 24.3184C48.6368 37.7491 37.749 48.6368 24.3184 48.6368C10.8877 48.6368 0 37.749 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const BRL_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61823)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0H48.6368V48.6368H0V0Z" fill="#229E45" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M24.8312 38.5104L46.6608 24.3373L24.6982 10.1263L2.7832 24.3753L24.8217 38.5104H24.8312Z"
        fill="#F8E509"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M34.3398 24.3183C34.3782 25.5552 34.1675 26.7871 33.7204 27.941C33.2733 29.0949 32.5988 30.1471 31.737 31.0351C30.8752 31.9231 29.8437 32.6289 28.7038 33.1104C27.5639 33.592 26.3388 33.8394 25.1013 33.8382C23.8639 33.8369 22.6393 33.5869 21.5004 33.103C20.3614 32.6191 19.3314 31.9113 18.4714 31.0215C17.6115 30.1316 16.9391 29.078 16.4944 27.9233C16.0496 26.7685 15.8416 25.5361 15.8825 24.2993C15.9618 21.903 16.9701 19.6316 18.6942 17.9654C20.4182 16.2992 22.7227 15.3689 25.1203 15.3714C27.5179 15.3739 29.8206 16.3089 31.5411 17.9786C33.2617 19.6483 34.2654 21.9219 34.3398 24.3183Z"
        fill="#2B49A3"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M22.0666 29.847L21.7816 29.676L21.4872 29.828L21.5537 29.4955L21.3257 29.258L21.6487 29.22L21.8006 28.916L21.9431 29.2295L22.2661 29.2865L22.0191 29.5145L22.0666 29.847ZM28.2602 31.4143L27.9752 31.2434L27.6713 31.3953L27.7377 31.0629L27.5098 30.8254L27.8422 30.7874L27.9942 30.4834L28.1272 30.7969L28.4502 30.8539L28.2127 31.0819L28.2602 31.4143ZM25.5909 28.9065L25.3439 28.764L25.0874 28.8875L25.1444 28.6025L24.9544 28.3935L25.2299 28.365L25.3629 28.1086L25.4769 28.3745L25.7619 28.422L25.5529 28.612L25.5909 28.9065ZM31.8415 28.0041L31.5945 27.8616L31.3475 27.9851L31.4045 27.7096L31.2145 27.5101L31.49 27.4721L31.6135 27.2251L31.737 27.4816L32.0125 27.5291L31.8035 27.7191L31.8415 28.0041ZM25.4769 26.1327L25.1919 25.9617L24.8974 26.1137L24.9639 25.7812L24.7359 25.5437L25.0589 25.5057L25.2109 25.2113L25.3534 25.5152L25.6764 25.5722L25.4294 25.8002L25.4769 26.1327ZM17.8584 23.2734L17.5734 23.1024L17.2884 23.2544L17.3454 22.9219L17.1175 22.6844L17.4499 22.6464L17.6019 22.3425L17.7349 22.6559L18.0579 22.7129L17.8204 22.9409L17.8584 23.2734ZM18.7798 27.0731L18.4949 26.9116L18.2004 27.0541L18.2669 26.7312L18.0389 26.4842L18.3619 26.4462L18.5139 26.1612L18.6564 26.4557L18.9793 26.5222L18.7323 26.7407L18.7798 27.0731ZM28.2887 21.8675L28.0417 21.725L27.7757 21.8485L27.8327 21.5635L27.6428 21.345L27.9277 21.3165L28.0607 21.0505L28.1842 21.326L28.4692 21.3735L28.2507 21.573L28.2887 21.8675ZM27.7757 24.3468L27.5478 24.2233L27.3483 24.3183L27.3863 24.0903L27.2343 23.9288L27.4623 23.9003L27.5668 23.6914L27.6618 23.9098L27.8897 23.9478L27.7187 24.0998L27.7757 24.3468ZM17.4214 27.7571L17.2314 27.6431L17.032 27.7381L17.07 27.5196L16.918 27.3581L17.146 27.3391L17.2409 27.1491L17.3359 27.3391L17.5544 27.3866L17.3929 27.5386L17.4214 27.7571ZM31.889 28.631L31.7275 28.555L31.566 28.6215L31.604 28.46L31.4805 28.3366L31.661 28.3176L31.7465 28.1751L31.813 28.3271L31.9935 28.3555L31.8605 28.4695"
        fill="#FFFFEF"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M17.4312 27.7666L17.2412 27.6526L17.0417 27.7476L17.0892 27.5291L16.9277 27.3676L17.1462 27.3486L17.2507 27.1586L17.3457 27.3486L17.5642 27.3961L17.4027 27.5481"
        fill="#FFFFEF"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M17.4312 27.7665L17.2412 27.6526L17.0417 27.7475L17.0892 27.5291L16.9277 27.3676L17.1462 27.3486L17.2507 27.1586L17.3457 27.3486L17.5642 27.3961L17.4027 27.5481L17.4312 27.7665ZM20.4615 27.7665L20.2715 27.6526L20.0815 27.7475L20.1195 27.5291L19.9675 27.3676L20.186 27.3486L20.281 27.1491L20.376 27.3486L20.5945 27.3961L20.433 27.5481L20.4615 27.7665ZM20.0815 28.783L19.8915 28.669L19.7015 28.764L19.7395 28.5455L19.5876 28.384L19.806 28.3555L19.901 28.1655L19.996 28.3555L20.2145 28.403L20.053 28.555L20.0815 28.783ZM26.3891 26.9401L26.1991 26.8261L25.9996 26.9211L26.0376 26.7026L25.8856 26.5411L26.1041 26.5221L26.2086 26.3226L26.3036 26.5221L26.5126 26.5601L26.3511 26.7121L26.3891 26.9401ZM24.5367 26.9401L24.3467 26.8261L24.1473 26.9211L24.1947 26.7026L24.0428 26.5411L24.2612 26.5221L24.3562 26.3226L24.4512 26.5221L24.6697 26.5601L24.5082 26.7121L24.5367 26.9401ZM19.5211 26.2941L19.4071 26.2277L19.2836 26.2846L19.3026 26.1422L19.2076 26.0472L19.3501 26.0282L19.4166 25.9047L19.4641 26.0377L19.6066 26.0567L19.5116 26.1517L19.5211 26.2941ZM31.6518 29.4479L31.4618 29.3434L31.2623 29.4384L31.3098 29.22L31.1578 29.0585L31.3763 29.03L31.4713 28.84L31.5663 29.03L31.7847 29.0775L31.6233 29.2295L31.6518 29.4479ZM30.1034 29.6474L29.9514 29.5524L29.7899 29.6474L29.8279 29.4574L29.6949 29.3244L29.8849 29.3054L29.9609 29.144L30.0369 29.3054L30.2268 29.3434L30.0844 29.4669L30.1034 29.6474ZM30.8443 29.6379L30.6923 29.5429L30.5403 29.6284L30.5688 29.4574L30.4548 29.3339L30.6258 29.3149L30.7018 29.163L30.7683 29.3149L30.9393 29.3434L30.8158 29.4669L30.8443 29.6379ZM32.9247 27.814L32.7822 27.7285L32.6302 27.8045L32.6682 27.6431L32.5542 27.5196L32.7157 27.5006L32.7917 27.3581L32.8582 27.5101L33.0197 27.5386L32.8962 27.6526L32.9247 27.814ZM30.1129 30.6734L29.9229 30.5689L29.7329 30.6639L29.7804 30.4549L29.6284 30.3124L29.8374 30.2839L29.9419 30.1034L30.0369 30.2934L30.2363 30.3314L30.0844 30.4644L30.1129 30.6734ZM30.1224 31.4998L29.9514 31.4048L29.7804 31.4903L29.8184 31.2813L29.6854 31.1388L29.8754 31.1103L29.9704 30.9298L30.0464 31.1198L30.2363 31.1578L30.0939 31.2908L30.1224 31.4998ZM28.7164 29.6379L28.574 29.5524L28.422 29.6284L28.46 29.4574L28.346 29.3434L28.5075 29.3244L28.5835 29.1725L28.65 29.3244L28.8114 29.3529L28.688 29.4669L28.7164 29.6379ZM27.4055 29.6379L27.263 29.5524L27.1111 29.6284L27.1491 29.4574L27.0351 29.3434L27.1965 29.3244L27.2725 29.1725L27.339 29.3244L27.5005 29.3529L27.3865 29.4669L27.4055 29.6379ZM25.1732 27.6811L25.0307 27.5956L24.8787 27.6716L24.9167 27.5101L24.8027 27.3866L24.9642 27.3676L25.0402 27.2251L25.1067 27.3771L25.2682 27.4056L25.1447 27.5101L25.1732 27.6811ZM25.4202 31.6423L25.2967 31.5758L25.1732 31.6423L25.2017 31.4998L25.1067 31.4048L25.2397 31.3763L25.3062 31.2528L25.3632 31.3858L25.5057 31.4048L25.4012 31.4998L25.4202 31.6423ZM22.0574 25.2302L21.7724 25.0687L21.4779 25.2112L21.5444 24.8882L21.3164 24.6413L21.6394 24.6033L21.7914 24.3088L21.9339 24.6128L22.2569 24.6698L22.0099 24.8977"
        fill="#FFFFEF"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M33.7323 27.6431C33.911 27.1773 34.0508 26.6976 34.1502 26.2087C29.2486 21.896 23.7769 19.6826 16.8614 20.1386C16.6136 20.6227 16.4101 21.1283 16.2534 21.649C19.426 21.3286 22.6303 21.6975 25.6471 22.7304C28.6639 23.7633 31.4219 25.4359 33.7323 27.6336V27.6431Z"
        fill="white"
      />
      <path
        d="M31.5285 25.2112L31.6995 25.3062C31.6729 25.3591 31.6662 25.4198 31.6805 25.4772C31.69 25.5152 31.728 25.5627 31.7755 25.5912C31.8325 25.6292 31.88 25.6482 31.9275 25.6482C31.9655 25.6482 32.0035 25.6197 32.0225 25.5912C32.032 25.5722 32.0415 25.5532 32.032 25.5247L32.0035 25.4487L31.8895 25.3252C31.8289 25.2636 31.7834 25.1889 31.7565 25.1067C31.7399 25.045 31.7461 24.9792 31.7741 24.9217C31.802 24.8641 31.8497 24.8185 31.9085 24.7933C31.9592 24.7708 32.0155 24.7642 32.07 24.7743C32.1386 24.7892 32.2033 24.8183 32.26 24.8598C32.3423 24.9177 32.4079 24.9963 32.45 25.0878C32.4615 25.1298 32.4632 25.1739 32.455 25.2168C32.4467 25.2596 32.4288 25.2999 32.4025 25.3347L32.2315 25.2302C32.2505 25.1827 32.26 25.1352 32.2505 25.0973C32.241 25.0688 32.203 25.0308 32.1555 25.0023C32.108 24.9643 32.0605 24.9548 32.0225 24.9548C32.0115 24.9551 32.0007 24.9578 31.9909 24.9627C31.981 24.9677 31.9724 24.9747 31.9655 24.9833C31.9589 24.9929 31.9547 25.0039 31.953 25.0154C31.9514 25.0269 31.9524 25.0387 31.956 25.0498C31.956 25.0878 32.0035 25.1447 32.07 25.2112L32.2125 25.4012C32.2384 25.4485 32.2504 25.5022 32.247 25.556C32.2436 25.6098 32.2251 25.6615 32.1935 25.7052C32.1603 25.7523 32.1141 25.7886 32.0605 25.8097C32.004 25.8355 31.9406 25.8422 31.88 25.8287C31.808 25.8104 31.7402 25.7781 31.6805 25.7337C31.5908 25.6798 31.5234 25.5956 31.4905 25.4962C31.462 25.4107 31.4715 25.3157 31.5285 25.2112ZM30.6926 24.6698L30.8826 24.7648C30.8603 24.8121 30.8537 24.8654 30.8636 24.9168C30.8731 24.9643 30.9111 25.0118 30.9586 25.0403C31.0156 25.0783 31.0631 25.0878 31.1106 25.0783C31.1486 25.0783 31.1866 25.0593 31.2056 25.0213C31.2146 25.0037 31.2179 24.9838 31.2151 24.9643C31.2151 24.9358 31.2056 24.9168 31.1771 24.8883L31.0631 24.7648C31.0005 24.7067 30.9518 24.6352 30.9206 24.5558C30.908 24.5181 30.904 24.478 30.9089 24.4386C30.9139 24.3991 30.9276 24.3613 30.9491 24.3278C30.9773 24.286 31.0168 24.253 31.0631 24.2328C31.1139 24.2109 31.17 24.2043 31.2246 24.2138C31.2816 24.2138 31.3386 24.2423 31.4146 24.2898C31.5095 24.3563 31.5855 24.4228 31.6045 24.5083C31.6188 24.5489 31.6236 24.5923 31.6186 24.6351C31.6137 24.6778 31.5991 24.7189 31.576 24.7553L31.3956 24.6508C31.424 24.6033 31.4241 24.5558 31.4146 24.5273C31.3956 24.4893 31.3671 24.4608 31.3196 24.4323C31.2788 24.4008 31.2286 24.3841 31.1771 24.3848C31.1653 24.3862 31.1539 24.3904 31.144 24.397C31.1341 24.4036 31.1259 24.4124 31.1201 24.4228C31.115 24.4332 31.1124 24.4445 31.1124 24.456C31.1124 24.4676 31.115 24.4789 31.1201 24.4893C31.1201 24.5178 31.1676 24.5748 31.2341 24.6508C31.3101 24.7173 31.3576 24.7838 31.3861 24.8218C31.4153 24.8692 31.43 24.9242 31.4283 24.9799C31.4266 25.0357 31.4086 25.0897 31.3766 25.1352C31.3442 25.1845 31.2983 25.2233 31.2443 25.2469C31.1903 25.2705 31.1307 25.2779 31.0726 25.2682C30.998 25.2537 30.927 25.2247 30.8636 25.1827C30.7726 25.1323 30.702 25.0517 30.6641 24.9548C30.6371 24.8596 30.6472 24.7577 30.6926 24.6698ZM29.6667 24.3848L30.1986 23.5299L30.8351 23.9098L30.7401 24.0618L30.2841 23.7768L30.1606 23.9668L30.5976 24.2328L30.5026 24.3848L30.0751 24.1188L29.9326 24.3563L30.4076 24.6413L30.3221 24.7933L29.6667 24.3943V24.3848ZM28.1658 23.1594L28.2513 23.0074L28.6312 23.2164L28.4507 23.5679C28.2967 23.602 28.1356 23.5819 27.9948 23.5109C27.9098 23.4668 27.8378 23.4013 27.7858 23.3209C27.7356 23.2484 27.709 23.1621 27.7098 23.0739C27.7098 22.9789 27.7383 22.8934 27.7858 22.8079C27.8296 22.7202 27.895 22.645 27.9758 22.5894C28.0423 22.5324 28.1373 22.5039 28.2323 22.5039C28.2988 22.5039 28.3843 22.5324 28.4697 22.5704C28.5634 22.6144 28.6401 22.6878 28.6882 22.7794C28.7262 22.8554 28.7357 22.9409 28.7167 23.0359L28.5172 22.9789C28.528 22.9306 28.5212 22.8802 28.4982 22.8364C28.473 22.7898 28.4328 22.753 28.3843 22.7319C28.3505 22.711 28.3127 22.6977 28.2734 22.6928C28.234 22.6878 28.1941 22.6915 28.1563 22.7034C28.0898 22.7319 28.0233 22.7984 27.9663 22.8934C27.92 22.9807 27.9033 23.0807 27.9188 23.1784C27.9378 23.2544 27.9853 23.3114 28.0708 23.3494L28.1943 23.3874H28.3178L28.3748 23.2734L28.1658 23.1594ZM21.6302 21.5445L21.7822 20.5376L22.0862 20.5851L22.1622 21.2975L22.4471 20.6325L22.7416 20.68L22.5991 21.687L22.4091 21.6585L22.5231 20.87L22.2097 21.63L22.0197 21.6015L21.9342 20.775L21.8202 21.573L21.6302 21.5445ZM20.6138 21.421L20.7088 20.4141L21.4497 20.4806L21.4402 20.6515L20.8893 20.604L20.8703 20.8225L21.3737 20.87L21.3642 21.041L20.8608 20.9935L20.8323 21.2785L21.3927 21.326L21.3737 21.497L20.6138 21.421Z"
        fill="#309E3A"
      />
      <path
        d="M17.2319 20.7845C17.2319 20.6895 17.2509 20.5945 17.2794 20.528L17.3744 20.395L17.5169 20.3001C17.5871 20.2759 17.6614 20.2662 17.7354 20.2716C17.8013 20.2711 17.8666 20.2844 17.9271 20.3106C17.9876 20.3367 18.042 20.3752 18.0869 20.4235C18.1819 20.5185 18.2104 20.642 18.2104 20.8035C18.2104 20.9745 18.1534 21.098 18.0679 21.1835C18.0203 21.2296 17.9636 21.2653 17.9014 21.2882C17.8393 21.3111 17.773 21.3207 17.7069 21.3165C17.6417 21.3182 17.5768 21.3064 17.5163 21.2818C17.4558 21.2573 17.4011 21.2206 17.3554 21.174C17.3085 21.1234 17.2731 21.0632 17.2518 20.9976C17.2304 20.932 17.2237 20.8625 17.2319 20.794V20.7845Z"
        fill="#309E3A"
      />
      <path
        d="M17.4407 20.7845C17.4407 20.8985 17.4596 20.9935 17.5166 21.0505C17.5641 21.117 17.6306 21.1455 17.7066 21.1455C17.7455 21.1462 17.784 21.139 17.82 21.1243C17.8559 21.1096 17.8884 21.0877 17.9156 21.06C17.9631 21.003 17.9916 20.9175 18.0011 20.8035C18.0011 20.68 17.9821 20.5945 17.9251 20.5375C17.9021 20.509 17.8732 20.4858 17.8404 20.4694C17.8076 20.453 17.7717 20.4438 17.7351 20.4425C17.6401 20.4425 17.5736 20.471 17.5261 20.528C17.4691 20.585 17.4407 20.6705 17.4312 20.7845H17.4407Z"
        fill="#F7FFFF"
      />
      <path
        d="M18.4287 21.3165L18.4382 20.3001H18.8657C18.9797 20.3001 19.0557 20.3191 19.1032 20.3381C19.1507 20.3571 19.1982 20.3856 19.2172 20.4331C19.2362 20.4806 19.2647 20.5281 19.2647 20.5946C19.2647 20.6706 19.2362 20.7276 19.1982 20.7846C19.1507 20.8321 19.0842 20.8606 18.9892 20.8796C19.0367 20.8986 19.0747 20.9271 19.1032 20.9556L19.2172 21.1266L19.3407 21.3165H19.0937L18.9512 21.0981C18.9164 21.0451 18.8783 20.9943 18.8372 20.9461C18.8213 20.9292 18.8018 20.9162 18.7802 20.9081C18.7496 20.8971 18.7176 20.8907 18.6852 20.8891H18.6377V21.3165H18.4287Z"
        fill="#309E3A"
      />
      <path
        d="M18.6377 20.7276H18.7897C18.8528 20.7355 18.9166 20.7355 18.9797 20.7276L19.0272 20.6801C19.0462 20.6611 19.0557 20.6326 19.0557 20.6041C19.0557 20.5661 19.0462 20.5376 19.0272 20.5186C19.0071 20.4974 18.9802 20.4839 18.9512 20.4807H18.6472V20.7276H18.6377Z"
        fill="white"
      />
      <path
        d="M19.5878 20.3476L19.9582 20.3666C20.0225 20.3676 20.0864 20.3772 20.1482 20.3951C20.2023 20.4155 20.2511 20.448 20.2907 20.4901C20.3351 20.5427 20.3675 20.6042 20.3857 20.6706C20.4047 20.7371 20.4047 20.8131 20.4047 20.9081C20.4075 20.9808 20.3946 21.0533 20.3667 21.1205C20.3388 21.1878 20.2967 21.2481 20.2432 21.2975C20.2052 21.326 20.1577 21.3545 20.1007 21.3735H19.9107L19.5308 21.364L19.5878 20.3476Z"
        fill="#309E3A"
      />
      <path
        d="M19.7775 20.5281L19.749 21.193L19.901 21.212H20.0245L20.11 21.1645C20.1385 21.1455 20.148 21.117 20.167 21.0695L20.1955 20.8796L20.186 20.7086C20.167 20.6611 20.1575 20.6326 20.129 20.6136C20.1037 20.5856 20.0706 20.5657 20.034 20.5566C19.9808 20.5454 19.9268 20.5391 19.8725 20.5376H19.7775V20.5281Z"
        fill="white"
      />
      <path
        d="M24.5557 22.162L24.7931 21.1741L25.1066 21.2501C25.2301 21.2786 25.3061 21.3071 25.3441 21.3261C25.3916 21.3546 25.4391 21.3926 25.4581 21.4496C25.4866 21.5161 25.4866 21.5825 25.4676 21.6585C25.4592 21.7075 25.4381 21.7535 25.4064 21.7918C25.3748 21.8301 25.3336 21.8595 25.2871 21.877C25.2544 21.8931 25.219 21.9028 25.1826 21.9055C25.1119 21.8994 25.042 21.8867 24.9736 21.8675L24.8406 21.839L24.7457 22.2095L24.5557 22.162Z"
        fill="#309E3A"
      />
      <path
        d="M24.9449 21.3925L24.8784 21.6775L24.9924 21.6965C25.0684 21.7155 25.1254 21.725 25.1539 21.7155C25.1802 21.7128 25.2051 21.7023 25.2254 21.6854C25.2457 21.6685 25.2605 21.6459 25.2679 21.6205L25.2584 21.516C25.242 21.4853 25.215 21.4617 25.1824 21.4495L25.0399 21.4115L24.9449 21.3925Z"
        fill="white"
      />
      <path
        d="M25.4966 22.447L25.8291 21.4875L26.2375 21.63C26.3116 21.6509 26.3821 21.683 26.4465 21.725C26.4845 21.763 26.513 21.8105 26.532 21.8675C26.551 21.9245 26.532 21.972 26.513 22.029C26.494 22.105 26.4465 22.1525 26.3895 22.181C26.3568 22.2 26.3207 22.2123 26.2831 22.2172C26.2456 22.2221 26.2075 22.2195 26.171 22.2095L26.247 22.3235L26.304 22.5135L26.3515 22.7415L26.1235 22.6655L26.057 22.409C26.0422 22.3476 26.0232 22.2873 26.0001 22.2285C25.9919 22.2069 25.9789 22.1874 25.9621 22.1715C25.9332 22.1505 25.9011 22.1345 25.8671 22.124L25.8291 22.1145L25.6866 22.5135L25.4966 22.447Z"
        fill="#309E3A"
      />
      <path
        d="M25.8765 21.9624L26.019 22.0099L26.1994 22.0574C26.2279 22.0574 26.2469 22.0574 26.2659 22.0384L26.3134 21.9719V21.8769C26.3013 21.8521 26.2813 21.832 26.2564 21.8199L26.1139 21.7724L25.962 21.7155L25.8765 21.9624Z"
        fill="white"
      />
      <path
        d="M26.6834 22.4089C26.7076 22.322 26.7496 22.2411 26.8069 22.1715C26.8354 22.124 26.8829 22.0955 26.9304 22.067C26.9774 22.0411 27.0291 22.0249 27.0824 22.0195C27.1489 22.0195 27.2249 22.0195 27.3009 22.048C27.3654 22.0641 27.4257 22.0936 27.4781 22.1345C27.5304 22.1754 27.5736 22.2268 27.6049 22.2855C27.6619 22.3994 27.6714 22.5419 27.6144 22.6939C27.5987 22.7623 27.5696 22.8268 27.5288 22.8839C27.4881 22.9409 27.4364 22.9894 27.3769 23.0264C27.3183 23.0556 27.2543 23.0723 27.1889 23.0756C27.1235 23.0789 27.0581 23.0686 26.9969 23.0454C26.9325 23.0293 26.8721 22.9998 26.8197 22.9589C26.7674 22.918 26.7242 22.8666 26.6929 22.8079C26.6371 22.6814 26.6337 22.538 26.6834 22.4089Z"
        fill="#309E3A"
      />
      <path
        d="M26.8832 22.4659C26.8547 22.5704 26.8547 22.6559 26.8832 22.7319C26.9212 22.8079 26.9782 22.8554 27.0542 22.8839C27.1302 22.9029 27.1967 22.8934 27.2632 22.8554C27.3297 22.8174 27.3867 22.7414 27.4247 22.6274C27.4532 22.5134 27.4532 22.4279 27.4247 22.3519C27.4087 22.3168 27.385 22.2858 27.3554 22.2611C27.3258 22.2365 27.291 22.2188 27.2537 22.2094C27.2174 22.1976 27.179 22.1941 27.1412 22.199C27.1034 22.2039 27.0672 22.2172 27.0352 22.2379C26.9687 22.2759 26.9212 22.3519 26.8832 22.4659Z"
        fill="white"
      />
      <path
        d="M28.6592 23.8244L29.1246 22.9219L29.5046 23.1119C29.5996 23.1689 29.6661 23.2069 29.6946 23.2449C29.7326 23.2924 29.7516 23.3399 29.7611 23.3874C29.7706 23.4349 29.7611 23.5014 29.7231 23.5489C29.6946 23.6154 29.6471 23.6629 29.5806 23.6914C29.5141 23.7104 29.4476 23.7104 29.3621 23.6819C29.3906 23.7199 29.4096 23.7674 29.4191 23.8054L29.4476 24.0049L29.4666 24.2423L29.2481 24.1284L29.2196 23.8624L29.1911 23.6724C29.183 23.6507 29.17 23.6312 29.1531 23.6154C29.1278 23.5921 29.0989 23.5728 29.0677 23.5584L29.0297 23.5394L28.8397 23.9194L28.6592 23.8244Z"
        fill="#309E3A"
      />
      <path
        d="M29.106 23.3969L29.2389 23.4634L29.4099 23.5394C29.4384 23.5394 29.4574 23.5394 29.4764 23.5204C29.502 23.5071 29.523 23.4864 29.5366 23.4609C29.5501 23.4355 29.5557 23.4065 29.5524 23.3779C29.5422 23.3495 29.5219 23.3258 29.4954 23.3114C29.4552 23.2846 29.414 23.2592 29.3719 23.2354L29.2295 23.1689L29.106 23.3969Z"
        fill="white"
      />
      <path
        d="M32.4115 25.6767C32.4685 25.5817 32.5255 25.5247 32.6015 25.4867C32.6479 25.4558 32.6993 25.4333 32.7535 25.4202C32.8037 25.4105 32.8553 25.4105 32.9055 25.4202C32.972 25.4297 33.048 25.4582 33.1145 25.5152C33.1706 25.5495 33.219 25.595 33.2566 25.649C33.2942 25.703 33.3202 25.7641 33.3329 25.8287C33.3467 25.9669 33.3096 26.1054 33.2284 26.2182C33.1924 26.2795 33.1443 26.3329 33.0872 26.3753C33.0301 26.4178 32.9651 26.4483 32.896 26.4651C32.8317 26.4772 32.7656 26.4758 32.7018 26.4611C32.638 26.4464 32.578 26.4186 32.5255 26.3796C32.4694 26.3454 32.4209 26.2998 32.3833 26.2458C32.3457 26.1919 32.3197 26.1307 32.307 26.0662C32.2964 25.9982 32.2994 25.9288 32.3157 25.862C32.332 25.7951 32.3613 25.7322 32.402 25.6767H32.4115Z"
        fill="#309E3A"
      />
      <path
        d="M32.5827 25.7812C32.5257 25.8762 32.4972 25.9712 32.5067 26.0472C32.5132 26.0856 32.5275 26.1223 32.5487 26.155C32.57 26.1877 32.5977 26.2157 32.6302 26.2372C32.6603 26.2581 32.6945 26.2723 32.7305 26.2788C32.7666 26.2854 32.8036 26.2842 32.8392 26.2752C32.9152 26.2562 32.9911 26.1992 33.0576 26.0947C33.1241 25.9997 33.1526 25.9142 33.1336 25.8382C33.1336 25.7622 33.0861 25.7052 33.0196 25.6482C32.9532 25.5912 32.8772 25.5912 32.8012 25.6102C32.7252 25.6292 32.6587 25.6862 32.5922 25.7812H32.5827Z"
        fill="white"
      />
      <path
        d="M23.4062 21.7535L23.5677 21.0316L24.0997 21.155L24.0712 21.2785L23.6912 21.1835L23.6532 21.345L24.0047 21.4305L23.9762 21.554L23.6247 21.459L23.5772 21.6585L23.9762 21.7535L23.9477 21.877L23.4062 21.7535Z"
        fill="#309E3A"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61823">
        <path
          d="M0 24.3184C0 10.8877 10.8877 0 24.3184 0C37.749 0 48.6368 10.8877 48.6368 24.3184C48.6368 37.7491 37.749 48.6368 24.3184 48.6368C10.8877 48.6368 0 37.749 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const HKD_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61858)">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M59.7616 49.3548H-10.7451V6.10352e-05H59.7616V49.3548Z"
        fill="#BA0000"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M23.5066 23.8849C23.5066 23.8849 18.532 21.7425 19.2417 16.1908C19.9315 13.5178 21.1519 11.7004 23.3673 10.7121C24.405 10.4107 25.4726 10.2238 26.551 10.155C26.2592 10.4203 26.0204 10.6922 25.901 11.0305C25.6622 11.6407 25.8347 12.2244 26.1531 12.8081C26.5668 13.5023 26.8121 14.2837 26.8694 15.0898C26.9422 15.7074 26.8505 16.3332 26.6035 16.904C26.3566 17.4747 25.9632 17.9701 25.4632 18.3399C24.8265 18.824 24.0704 18.9965 23.4601 19.5537C22.9615 20.0088 22.6496 20.6328 22.5846 21.3047C22.5647 22.8568 22.9892 23.0757 23.5066 23.8915V23.8849Z"
        fill="white"
      />
      <path fillRule="evenodd" clipRule="evenodd" d="M22.5581 15.853V15.8326V15.853Z" fill="#BA0000" />
      <path d="M22.5581 15.853V15.8326" stroke="black" strokeWidth="0.265848" />
      <path
        d="M22.8765 23.3078C20.9398 21.5965 21.1056 17.2919 22.5847 15.8525"
        stroke="#BA0000"
        strokeWidth="0.265848"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M22.5449 14.7913L23.1817 14.652L23.2546 14.0286L23.573 14.5592L24.2098 14.4199L23.772 14.8908L24.0904 15.4215L23.4934 15.1827L23.0556 15.6536L23.1352 15.0368"
        fill="#BA0000"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M23.9309 23.5201C23.9309 23.5201 24.5213 18.1342 30.0331 17.1924C32.7924 17.0664 34.8883 17.7031 36.4869 19.5271C37.0766 20.4307 37.5659 21.396 37.9461 22.4058C37.6078 22.2068 37.2828 22.0609 36.918 22.041C36.268 21.9945 35.7639 22.3328 35.2996 22.8037C34.769 23.3874 34.172 23.8186 33.323 24.1568C32.7543 24.4061 32.13 24.5011 31.5128 24.4324C30.8957 24.3637 30.3076 24.1337 29.8076 23.7655C29.151 23.3012 28.7729 22.6313 28.0566 22.2068C27.4758 21.8626 26.7878 21.7468 26.1264 21.8818C24.634 22.3262 24.5544 22.7905 23.9243 23.5201H23.9309Z"
        fill="white"
      />
      <path fillRule="evenodd" clipRule="evenodd" d="M31.333 20.2635L31.3534 20.2567L31.333 20.2635Z" fill="#BA0000" />
      <path d="M31.333 20.2635L31.3534 20.2567" stroke="black" strokeWidth="0.265848" />
      <path
        d="M24.2959 22.7506C25.3638 20.396 29.5358 19.3015 31.3399 20.2832"
        stroke="#BA0000"
        strokeWidth="0.265848"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M32.3411 19.9384L32.6595 20.5088L33.2763 20.396L32.8651 20.8603L33.1901 21.4241L32.6064 21.1389L32.1885 21.6032L32.2482 20.9664L31.6646 20.6812L32.2814 20.5751"
        fill="#BA0000"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M24.3025 23.9114C24.3025 23.9114 29.5955 22.7573 32.242 27.6921C33.2369 30.2656 33.3032 32.4545 32.0762 34.5504C31.4129 35.4127 30.6369 36.1423 29.8078 36.8454C29.8874 36.4607 29.9205 36.1025 29.8277 35.7576C29.6685 35.1275 29.1843 34.756 28.5873 34.4642C27.8483 34.141 27.196 33.6479 26.6837 33.0249C26.2652 32.5647 25.9756 32.0023 25.844 31.3944C25.7124 30.7865 25.7435 30.1546 25.9342 29.5626C26.1664 28.7931 26.6837 28.2161 26.8562 27.4069C26.9988 26.7458 26.89 26.0553 26.5511 25.4701C25.6623 24.2032 25.1913 24.2762 24.2959 23.9114H24.3025Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M29.7417 29.8942L29.7553 29.9146L29.7417 29.8942Z"
        fill="#BA0000"
      />
      <path d="M29.7417 29.8942L29.7553 29.9146" stroke="black" strokeWidth="0.265848" />
      <path
        d="M25.145 24.0109C27.7185 24.2762 30.0865 27.8844 29.7217 29.9074"
        stroke="#BA0000"
        strokeWidth="0.265848"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M30.365 30.7498L29.9339 31.234L30.2323 31.7845L29.6619 31.5325L29.2308 32.0233L29.317 31.3799L28.7466 31.1345L29.3634 30.9886L29.4497 30.3452L29.7481 30.8957"
        fill="#BA0000"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M24.1832 24.4553C24.1832 24.4553 26.77 29.211 22.7837 33.1442C20.5882 34.8157 18.5055 35.4923 16.1509 34.9019C15.136 34.5172 14.2207 33.9733 13.312 33.3764C13.6967 33.3432 14.0549 33.2769 14.36 33.0845C14.9172 32.7529 15.1427 32.1891 15.2554 31.5325C15.3561 30.7314 15.6447 29.9655 16.0978 29.2972C16.4227 28.7664 16.8822 28.331 17.4297 28.0352C17.9772 27.7393 18.5932 27.5935 19.2152 27.6125C20.0111 27.6191 20.7142 27.9507 21.5367 27.8911C22.2127 27.8437 22.8466 27.5456 23.3143 27.0553C24.2827 25.8415 24.0837 25.4104 24.1765 24.4553H24.1832Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.9647 31.3534L19.9512 31.3737L19.9647 31.3534Z"
        fill="#BA0000"
      />
      <path d="M19.9647 31.3534L19.9512 31.3737" stroke="black" strokeWidth="0.265848" />
      <path
        d="M24.3225 25.2977C24.7868 27.838 21.9944 31.1213 19.9448 31.3402"
        stroke="#BA0000"
        strokeWidth="0.265848"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M19.3213 32.1958L18.731 31.9172L18.2866 32.3616L18.3662 31.7447L17.7759 31.4662L18.4193 31.3667L18.4922 30.7498L18.8106 31.307L19.4473 31.2075L19.0029 31.6452"
        fill="#BA0000"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M23.5926 24.3492C23.5926 24.3492 19.9644 28.3753 14.9368 25.9146C12.6285 24.4023 11.2953 22.6645 11.0698 20.2502C11.0964 19.169 11.3086 18.121 11.5673 17.0664C11.7331 17.4179 11.9056 17.7297 12.1908 17.9552C12.6882 18.3731 13.2984 18.3996 13.9485 18.2868C14.7375 18.1161 15.5556 18.1342 16.3363 18.3399C16.9442 18.4698 17.5071 18.7577 17.9683 19.1746C18.4294 19.5915 18.7725 20.1227 18.9629 20.7145C19.2282 21.4772 19.142 22.24 19.4736 23.0028C19.7443 23.6224 20.2362 24.119 20.8532 24.3957C22.3124 24.9064 22.6573 24.5814 23.5926 24.3492Z"
        fill="white"
      />
      <path fillRule="evenodd" clipRule="evenodd" d="M15.68 22.6645H15.6597H15.68Z" fill="#BA0000" />
      <path d="M15.68 22.6645H15.6597" stroke="black" strokeWidth="0.265848" />
      <path
        d="M22.8435 24.767C20.6016 26.0472 16.5755 24.5017 15.6934 22.6445"
        stroke="#BA0000"
        strokeWidth="0.265848"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M14.6715 22.3394L14.7378 21.6894L14.1807 21.4241L14.7842 21.2914L14.8506 20.6414L15.1623 21.2118L15.7593 21.0792L15.348 21.5634L15.6531 22.1338L15.0894 21.8619"
        fill="#BA0000"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61858">
        <path
          d="M0 24.2571C0 10.8603 10.8603 0 24.2571 0C37.654 0 48.5142 10.8603 48.5142 24.2571C48.5142 37.654 37.654 48.5142 24.2571 48.5142C10.8603 48.5142 0 37.654 0 24.2571Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const CAD_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61881)">
      <path d="M7.70361 -6.10352e-05H42.1198V48.6367H7.70361V-6.10352e-05Z" fill="white" />
      <path
        d="M-9.49951 -6.10352e-05H7.70384V48.6367H-9.49951V-6.10352e-05ZM42.1201 -6.10352e-05H59.3234V48.6367H42.1201V-6.10352e-05ZM12.8525 23.5014L11.5226 23.9573L17.7352 29.4195C18.2101 30.8254 17.5737 31.2339 17.1652 31.9748L23.9098 31.1199L23.7388 37.9119L25.1447 37.8644L24.8312 31.1294L31.5947 31.9273C31.1768 31.0439 30.8063 30.5784 31.1863 29.1725L37.3989 23.9953L36.3159 23.6059C35.423 22.9124 36.6959 20.3001 36.8859 18.6472C36.8859 18.6472 33.2666 19.8916 33.0292 19.2362L32.0887 17.4788L28.8019 21.0885C28.441 21.1835 28.289 21.0315 28.2035 20.7276L29.7234 13.1566L27.3105 14.515C27.111 14.6005 26.9116 14.515 26.7786 14.287L24.4512 9.6323L22.0574 14.4675C21.8769 14.6385 21.6964 14.6575 21.5444 14.5435L19.2456 13.2516L20.623 20.7751C20.5185 21.06 20.2525 21.155 19.9485 20.9935L16.7852 17.4028C16.3768 18.0677 16.0918 19.1507 15.5503 19.3976C15.0089 19.6161 13.1755 18.9322 11.9501 18.6662C12.368 20.1766 13.6789 22.6844 12.8525 23.5109V23.5014Z"
        fill="#D52B1E"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61881">
        <path
          d="M0 24.3184C0 10.8877 10.8877 0 24.3184 0C37.749 0 48.6368 10.8877 48.6368 24.3184C48.6368 37.7491 37.749 48.6368 24.3184 48.6368C10.8877 48.6368 0 37.749 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const IDR_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61884)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0H48.6368V25.2208H0V0Z" fill="#E70011" />
      <path fillRule="evenodd" clipRule="evenodd" d="M0 24.3184H48.6368V48.6367H0V24.3184Z" fill="white" />
    </g>
    <defs>
      <clipPath id="clip0_1942_61884">
        <path
          d="M0 24.3184C0 10.8877 10.8877 0 24.3184 0C37.749 0 48.6368 10.8877 48.6368 24.3184C48.6368 37.7491 37.749 48.6368 24.3184 48.6368C10.8877 48.6368 0 37.749 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const TRY_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61888)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0H48.5142V48.6368H0V0Z" fill="#E30A17" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M33.0501 25.0783C33.0501 31.7849 27.5259 37.228 20.7226 37.228C13.9192 37.228 8.39502 31.7849 8.39502 25.0688C8.39502 18.3528 13.9097 12.9286 20.7131 12.9286C27.5165 12.9286 33.0596 18.3623 33.0596 25.0783H33.0501Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M33.6661 25.0784C33.6661 30.4455 29.2506 34.7962 23.8022 34.7962C18.3538 34.7962 13.9478 30.4455 13.9478 25.0784C13.9478 19.7112 18.3538 15.3605 23.8022 15.3605C29.2506 15.3605 33.6567 19.7112 33.6567 25.0784H33.6661Z"
        fill="#E30A17"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M35.4475 19.3978L35.3527 23.891L31.1646 25.0309L35.2864 26.5033L35.1916 30.6165L37.8732 27.4057L41.9381 28.8116L39.5882 25.3634L42.4498 21.9341L38.0532 23.15L35.4475 19.3978Z"
        fill="white"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61888">
        <path
          d="M0 24.3184C0 10.9215 10.8603 0 24.2571 0C37.654 0 48.5142 10.9215 48.5142 24.3184C48.5142 37.7152 37.654 48.6368 24.2571 48.6368C10.8603 48.6368 0 37.7152 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const NGN_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1942_61894)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0H48.6368V48.6368H0V0Z" fill="white" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M32.4213 0H48.6368V48.6368H32.4213V0ZM0 0H16.2154V48.6368H0V0Z"
        fill="#008753"
      />
    </g>
    <defs>
      <clipPath id="clip0_1942_61894">
        <path
          d="M0 24.3184C0 10.8877 10.8877 0 24.3184 0C37.749 0 48.6368 10.8877 48.6368 24.3184C48.6368 37.7491 37.749 48.6368 24.3184 48.6368C10.8877 48.6368 0 37.749 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const AUD_ICON = (props: SVGProps) => (
  <svg width="49" height="49" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1969_48727)">
      <path d="M0 0H48.6368V48.6368H0V0Z" fill="#00008B" />
      <path
        d="M24.3184 0V3.0398L15.294 12.1592L24.3184 21.0411V24.3184H21.1361L12.0642 15.389L3.22978 24.3184H0V21.0886L8.83441 12.2067L0 3.51477V0H2.9448L12.0642 8.9294L20.8986 0H24.3184Z"
        fill="white"
      />
      <path
        d="M8.73942 15.389L9.26188 17.0039L1.99487 24.3184H0V24.1759L8.73942 15.389ZM14.629 14.819L17.1939 15.199L24.3184 22.181V24.3184L14.629 14.819ZM24.3184 0L15.199 9.30938L15.009 7.21952L22.1335 0H24.3184ZM0 0.0474968L9.16689 9.0244L6.36458 8.64442L0 2.32734V0.0474968Z"
        fill="#FF0000"
      />
      <path d="M8.35944 0V24.3184H15.9589V0H8.35944ZM0 8.35944V15.9589H24.3184V8.35944H0Z" fill="white" />
      <path d="M0 9.87934V14.439H24.3184V9.87934H0ZM9.87934 0V24.3184H14.439V0H9.87934Z" fill="#FF0000" />
      <path
        d="M19.1892 38.2634L14.8385 38.7764L15.2755 43.1366L12.1597 40.0588L9.02489 43.1176L9.49036 38.7574L5.13965 38.2064L8.8349 35.8506L6.55505 32.1079L10.6968 33.5328L12.1977 29.41L13.6701 33.5423L17.8213 32.1459L15.513 35.8696L19.1987 38.2539L19.1892 38.2634Z"
        fill="white"
      />
      <path
        d="M40.344 39.0234L38.3966 39.2704L38.6056 41.2178L37.1997 39.8499L35.8033 41.2273L35.9933 39.2799L34.0459 39.0519L35.6893 37.988L34.6539 36.3256L36.5157 36.9431L37.1712 35.0907L37.8456 36.9336L39.698 36.2971L38.6816 37.969L40.344 39.0234Z"
        fill="white"
      />
      <path
        d="M39.4225 27.8902L39.679 26.6553L38.748 25.8003L40.002 25.6578L40.5244 24.5084L41.0469 25.6578L42.3008 25.8003L41.3699 26.6553L41.6264 27.8902L40.5244 27.2632L39.4225 27.8902Z"
        fill="white"
      />
      <path
        d="M31.4335 22.1905L29.5051 22.3995L29.6761 24.3279L28.3082 22.9505L26.9023 24.2899L27.1303 22.3615L25.2114 22.105L26.8548 21.0791L25.8574 19.4167L27.6908 20.0627L28.3747 18.2483L29.0112 20.0817L30.854 19.4832L29.8186 21.1266L31.4335 22.1905Z"
        fill="white"
      />
      <path
        d="M48.1338 19.0748L46.1484 19.3313L46.3669 21.3166L44.9325 19.9202L43.5076 21.3261L43.707 19.3313L41.7217 19.1033L43.4031 18.0108L42.3486 16.3105L44.2485 16.9469L44.9135 15.066L45.5974 16.9469L47.4878 16.2915L46.4429 18.0013L48.1338 19.0748Z"
        fill="white"
      />
      <path
        d="M40.3346 11.1427L38.3682 11.3612L38.5487 13.3371L37.1523 11.9312L35.7179 13.2991L35.9459 11.3327L33.9795 11.0667L35.6609 10.0218L34.6444 8.32143L36.5158 8.97689L37.2093 7.12451L37.8552 8.99589L39.7361 8.37843L38.6817 10.0503L40.3346 11.1427Z"
        fill="white"
      />
    </g>
    <defs>
      <clipPath id="clip0_1969_48727">
        <path
          d="M0 24.3184C0 10.8877 10.8877 0 24.3184 0C37.749 0 48.6368 10.8877 48.6368 24.3184C48.6368 37.7491 37.749 48.6368 24.3184 48.6368C10.8877 48.6368 0 37.749 0 24.3184Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const PKR_ICON = (props: SVGProps) => (
  <svg width="49" height="50" viewBox="0 0 49 50" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1969_48716)">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M-9.02441 0.996704H63.9307V49.511H-9.02441V0.996704Z"
        fill="#0C590B"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M-9.02441 0.996704H9.26187V49.511H-9.02441V0.996704Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M38.3491 22.3544L35.3852 21.729L33.8274 24.3158L33.5044 21.3216L30.5596 20.6393L33.3144 19.4075L33.0579 16.4038L35.0908 18.64L37.8741 17.4651L36.3637 20.0803L38.3585 22.3544H38.3491Z"
        fill="white"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M39.4606 29.9916C38.8284 31.3676 37.9298 32.6054 36.8163 33.6338C35.7029 34.6622 34.3966 35.4609 32.9727 35.9839C31.5487 36.507 30.0351 36.7441 28.519 36.6817C27.0028 36.6192 25.514 36.2584 24.1381 35.62C21.3466 34.3308 19.1829 31.9883 18.1229 29.1078C17.063 26.2273 17.1936 23.0448 18.486 20.2603C19.1278 18.829 20.0629 17.5474 21.231 16.4981C22.3991 15.4488 23.7744 14.655 25.2685 14.1676C24.8774 14.4925 24.5032 14.8372 24.1476 15.2004C22.2943 17.2478 21.3104 19.933 21.4035 22.6899C21.4966 25.4468 22.6593 28.0599 24.6466 29.9782C26.6338 31.8965 29.2902 32.9701 32.0556 32.9726C34.8211 32.9751 37.4794 31.9063 39.4701 29.9916H39.4606Z"
        fill="white"
      />
    </g>
    <defs>
      <clipPath id="clip0_1969_48716">
        <path
          d="M0 25.2538C0 11.857 10.9215 0.996704 24.3184 0.996704C37.7152 0.996704 48.6368 11.857 48.6368 25.2538C48.6368 38.6507 37.7152 49.511 24.3184 49.511C10.9215 49.511 0 38.6507 0 25.2538Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const UAH_ICON = (props: SVGProps) => (
  <svg width="49" height="50" viewBox="0 0 49 50" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1969_48723)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0.870972H48.5142V49.5077H0V0.870972Z" fill="#FFD700" />
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0.870972H48.5142V25.1894H0V0.870972Z" fill="#0057B8" />
    </g>
    <defs>
      <clipPath id="clip0_1969_48723">
        <path
          d="M0 25.1894C0 11.7925 10.8603 0.870972 24.2571 0.870972C37.654 0.870972 48.5142 11.7925 48.5142 25.1894C48.5142 38.5862 37.654 49.5077 24.2571 49.5077C10.8603 49.5077 0 38.5862 0 25.1894Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const THB_ICON = (props: SVGProps) => (
  <svg width="49" height="50" viewBox="0 0 49 50" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_1969_48741)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0.867676H48.6368V49.5044H0V0.867676Z" fill="#F4F5F8" />
      <path fillRule="evenodd" clipRule="evenodd" d="M0 17.3396H48.6368V33.5455H0V17.3396Z" fill="#2D2A4A" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0 0.867676H48.6368V9.22712H0V0.867676ZM0 41.4015H48.6368V49.5044H0V41.4015Z"
        fill="#A51931"
      />
    </g>
    <defs>
      <clipPath id="clip0_1969_48741">
        <path
          d="M0 25.1861C0 11.7554 10.8877 0.867676 24.3184 0.867676C37.749 0.867676 48.6368 11.7554 48.6368 25.1861C48.6368 38.6167 37.749 49.5044 24.3184 49.5044C10.8877 49.5044 0 38.6167 0 25.1861Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)

export const CNY_ICON = (props: SVGProps) => (
  <svg width="512" height="512" viewBox="0 0 512 512" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_4_7124)">
      <path
        d="M256 512C397.385 512 512 397.385 512 256C512 114.615 397.385 0 256 0C114.615 0 0 114.615 0 256C0 397.385 114.615 512 256 512Z"
        fill="#D80027"
      />
      <path
        d="M140.1 155.8L162.2 223.8H233.7L175.9 265.9L198 333.9L140.1 291.9L82.2 333.9L104.4 265.9L46.5 223.8H118L140.1 155.8Z"
        fill="#FFDA44"
      />
      <path
        d="M303.5 396.5L286.6 375.7L261.6 385.4L276.1 362.9L259.2 342L285.1 348.9L299.7 326.4L301.1 353.2L327.1 360.1L302 369.7L303.5 396.5Z"
        fill="#FFDA44"
      />
      <path
        d="M337.1 335.5L345.1 309.9L323.2 294.4L350 294L357.9 268.4L366.6 293.8L393.4 293.5L371.9 309.5L380.5 334.9L358.6 319.4L337.1 335.5Z"
        fill="#FFDA44"
      />
      <path
        d="M382.4 187.9L370.6 212L389.8 230.7L363.3 226.9L351.5 250.9L346.9 224.5L320.3 220.7L344.1 208.2L339.5 181.7L358.7 200.4L382.4 187.9Z"
        fill="#FFDA44"
      />
      <path
        d="M304.2 114.9L302.2 141.6L327.1 151.7L301 158.1L299.1 184.9L285 162.1L258.9 168.5L276.2 148L262 125.3L286.9 135.4L304.2 114.9Z"
        fill="#FFDA44"
      />
    </g>
    <defs>
      <clipPath id="clip0_4_7124">
        <rect width="512" height="512" fill="white" />
      </clipPath>
    </defs>
  </svg>
)

export const KRW_ICON = (props: SVGProps) => (
  <svg width="512" height="512" viewBox="0 0 512 512" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
    <g clipPath="url(#clip0_2_35996)">
      <path fillRule="evenodd" clipRule="evenodd" d="M0 0H512V512H0V0Z" fill="white" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M21.9756 167.546L84.3956 73.9515L99.9947 84.3549L37.5747 177.95L21.9756 167.546ZM45.3743 183.151L107.794 89.5565L123.393 99.9599L60.9734 193.555L45.3743 183.151ZM68.773 198.756L131.193 105.162L146.792 115.565L84.3721 209.16L68.773 198.756Z"
        fill="black"
      />
      <path fillRule="evenodd" clipRule="evenodd" d="M388.567 344.421L466.563 396.437L388.567 344.421Z" fill="black" />
      <path d="M388.567 344.421L466.563 396.437" stroke="white" strokeWidth="9.375" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M162.38 193.572C178.934 168.749 204.672 151.52 233.931 145.673C263.189 139.827 293.572 145.843 318.394 162.397C343.217 178.952 360.447 204.69 366.294 233.948C372.14 263.207 366.124 293.589 349.569 318.412L162.38 193.572Z"
        fill="#CD2E3A"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M162.38 193.572C145.825 218.395 139.809 248.778 145.655 278.036C151.502 307.295 168.732 333.032 193.555 349.587C218.377 366.142 248.76 372.158 278.018 366.311C307.277 360.465 333.015 343.235 349.569 318.412C357.847 306.001 360.855 290.809 357.932 276.18C355.008 261.551 346.393 248.682 333.982 240.405C321.571 232.127 306.379 229.119 291.75 232.043C277.121 234.966 264.252 243.581 255.975 255.992L162.38 193.572Z"
        fill="#0047A0"
      />
      <path
        d="M255.975 255.992C273.211 230.147 266.233 195.222 240.387 177.985C214.542 160.748 179.616 167.727 162.38 193.572C145.143 219.418 152.122 254.343 177.967 271.58C203.813 288.816 238.738 281.838 255.975 255.992Z"
        fill="#CD2E3A"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M72.7358 378.231L96.1345 362.626L72.7358 378.231ZM388.618 167.564L415.917 149.358L388.618 167.564ZM439.316 133.753L462.714 118.148L439.316 133.753Z"
        fill="black"
      />
      <path
        d="M439.316 133.753L462.714 118.148M72.7358 378.231L96.1345 362.626L72.7358 378.231ZM388.618 167.564L415.917 149.358L388.618 167.564Z"
        stroke="white"
        strokeWidth="9.375"
      />
    </g>
    <defs>
      <clipPath id="clip0_2_35996">
        <path
          d="M0 256C0 114.615 114.615 0 256 0C397.385 0 512 114.615 512 256C512 397.385 397.385 512 256 512C114.615 512 0 397.385 0 256Z"
          fill="white"
        />
      </clipPath>
    </defs>
  </svg>
)
