import { Path, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [WifiSlash, AnimatedWifiSlash] = createIcon({
  name: 'WifiSlash',
  getIcon: (props) => (
    <Svg viewBox="0 0 14 14" fill="none" {...props}>
      <Path
        d="M13.3534 1.35333L1.3534 13.3533C1.25607 13.4507 1.12805 13.5 1.00005 13.5C0.872052 13.5 0.744032 13.4513 0.646699 13.3533C0.451365 13.158 0.451365 12.8413 0.646699 12.646L6.42079 6.872C5.27812 6.98934 4.19605 7.44799 3.32671 8.19799C3.23205 8.27933 3.11605 8.31933 3.00005 8.31933C2.86005 8.31933 2.72079 8.26066 2.62212 8.14599C2.44146 7.93732 2.46472 7.62134 2.67339 7.44067C3.87006 6.408 5.40672 5.83933 7.00005 5.83933C7.14672 5.83933 7.28805 5.85266 7.43072 5.86199L8.90598 4.38665C8.27998 4.24332 7.64205 4.16599 7.00005 4.16599C4.90605 4.16599 2.89405 4.93532 1.33338 6.33199C1.23805 6.41732 1.11938 6.45933 1.00005 6.45933C0.862718 6.45933 0.725997 6.40333 0.62733 6.29266C0.44333 6.08666 0.460718 5.77066 0.666718 5.58666C2.41072 4.02533 4.66005 3.16599 7.00005 3.16599C7.92272 3.16599 8.83539 3.30665 9.72206 3.57065L12.6467 0.645991C12.842 0.450657 13.1587 0.450657 13.3541 0.645991C13.5487 0.841324 13.5487 1.15866 13.3534 1.35333ZM7.00005 11C6.63205 11 6.33339 11.2987 6.33339 11.6667C6.33339 12.0347 6.63205 12.3333 7.00005 12.3333C7.36805 12.3333 7.66672 12.0347 7.66672 11.6667C7.66672 11.2987 7.36805 11 7.00005 11ZM7.68869 8.57466C7.41669 8.52599 7.15746 8.70665 7.10812 8.97865C7.05946 9.25065 7.24011 9.51065 7.51144 9.55932C7.94611 9.63732 8.35536 9.81599 8.69536 10.0773C8.78603 10.1467 8.89275 10.1807 8.99875 10.1807C9.14942 10.1807 9.29738 10.1133 9.39605 9.98533C9.56471 9.76599 9.52277 9.45199 9.30344 9.28399C8.8381 8.92599 8.27936 8.68066 7.68869 8.57466ZM9.91867 6.51666C9.66734 6.39532 9.37139 6.5 9.25005 6.748C9.12939 6.99667 9.23333 7.29532 9.48133 7.41599C9.91667 7.62732 10.3174 7.89066 10.6734 8.19799C10.7681 8.27999 10.8841 8.32 11.0001 8.32C11.1401 8.32 11.2793 8.26133 11.378 8.14666C11.5586 7.938 11.5354 7.62199 11.3267 7.44132C10.9054 7.07732 10.4313 6.76599 9.91867 6.51666ZM11.938 4.55867C11.7014 4.416 11.3947 4.492 11.252 4.728C11.1087 4.964 11.1848 5.272 11.4214 5.41467C11.8568 5.67867 12.2767 5.988 12.6687 6.33467C12.764 6.41867 12.8821 6.46 13.0001 6.46C13.1381 6.46 13.2754 6.40334 13.3747 6.29134C13.5574 6.08467 13.5388 5.76866 13.3321 5.58532C12.8948 5.19932 12.426 4.854 11.938 4.55867Z"
        fill={'currentColor' ?? '#7D7D7D'}
        stroke="currentColor"
        strokeWidth="0.5"
      />
    </Svg>
  ),
  defaultFill: '#7D7D7D',
})
