import { isNumber } from 'nft/utils/numbers'
import { FormEvent, forwardRef } from 'react'

import { Box, BoxProps } from '../Box'

export const Input = forwardRef<HTMLInputElement, BoxProps>((props, ref) => (
  <Box
    ref={ref}
    as="input"
    borderColor={{ default: 'medGray', focus: 'darkGray' }}
    borderWidth="1px"
    borderStyle="solid"
    borderRadius="12"
    padding="12"
    fontSize="14"
    color={{ placeholder: 'darkGray', default: 'blackBlue' }}
    backgroundColor="transparent"
    {...props}
  />
))

Input.displayName = 'Input'

export const NumericInput = forwardRef<HTMLInputElement, BoxProps>((props, ref) => {
  return (
    <Box
      ref={ref}
      as="input"
      autoComplete="off"
      type="text"
      onInput={(v: FormEvent<HTMLInputElement>) => {
        v.currentTarget.value =
          !!v.currentTarget.value && isNumber(v.currentTarget.value) && parseFloat(v.currentTarget.value) >= 0
            ? v.currentTarget.value
            : ''
      }}
      {...props}
    />
  )
})

NumericInput.displayName = 'Input'
