import { ChainId } from '@uniswap/sdk-core'

export const FACTORY_ADDRESSES: { [chainId in ChainId]: string } = {
  [ChainId.MAINNET]: '',
  [ChainId.ROPSTEN]: '0x864e344eCd7f3a9A4368dEC11Be8104db5770364',
  [ChainId.RINKEBY]: '0xAE28628c0fdFb5e54d60FEDC6C9085199aec14dF',
  [ChainId.GÖRLI]: '0x864e344eCd7f3a9A4368dEC11Be8104db5770364',
  [ChainId.KOVAN]: '0xd4013a706fa79487989b595Df35eF8AD1ffBb422',
}

export const TICK_LENS_ADDRESSES: { [chainId in ChainId]: string } = {
  [ChainId.MAINNET]: '',
  [ChainId.ROPSTEN]: '0xc97c7D6C2F1EE518bE4D4B8566bcEb917dED4F39',
  [ChainId.RINKEBY]: '0x2d31366B7D446d629ac36933F12bdbca96860f84',
  [ChainId.GÖRLI]: '0xc97c7D6C2F1EE518bE4D4B8566bcEb917dED4F39',
  [ChainId.KOVAN]: '0xD2AAa0217a203d9FaB6e5272b211Be2Aba52f385',
}

export const NONFUNGIBLE_POSITION_MANAGER_ADDRESSES: { [chainId in ChainId]: string } = {
  [ChainId.MAINNET]: '',
  [ChainId.ROPSTEN]: '0xc97c7D6C2F1EE518bE4D4B8566bcEb917dED4F39',
  [ChainId.RINKEBY]: '0xbBca0fFBFE60F60071630A8c80bb6253dC9D6023',
  [ChainId.GÖRLI]: '0x539BF58f052dE91ae369dAd59f1ac6887dF39Bc5',
  [ChainId.KOVAN]: '0xAE28628c0fdFb5e54d60FEDC6C9085199aec14dF',
}

export const NONFUNGIBLE_TOKEN_POSITION_DESCRIPTOR_ADDRESSES: { [chainId in ChainId]: string } = {
  [ChainId.MAINNET]: '',
  [ChainId.ROPSTEN]: '0x8dF824f7885611c587AA45924BF23153EC832b89',
  [ChainId.RINKEBY]: '0x3b1aC1c352F3A18A58471908982b8b870c836EC0',
  [ChainId.GÖRLI]: '0x8dF824f7885611c587AA45924BF23153EC832b89',
  [ChainId.KOVAN]: '0x30Ba713F78Ad3c175a25aD767e3f423549Ac2D65',
}

export const SWAP_ROUTER_ADDRESSES: { [chainId in ChainId]: string } = {
  [ChainId.MAINNET]: '',
  [ChainId.ROPSTEN]: '0x7046f9311663DB8B7cf218BC7B6F3f17B0Ea1047',
  [ChainId.RINKEBY]: '0x8dF824f7885611c587AA45924BF23153EC832b89',
  [ChainId.GÖRLI]: '0x7046f9311663DB8B7cf218BC7B6F3f17B0Ea1047',
  [ChainId.KOVAN]: '0x921647f0c094e2e59CDE6DEfafD77743012f52bd',
}

export const V2_MIGRATOR_ADDRESSES: { [chainId in ChainId]: string } = {
  [ChainId.MAINNET]: '',
  [ChainId.ROPSTEN]: '0xbBca0fFBFE60F60071630A8c80bb6253dC9D6023',
  [ChainId.RINKEBY]: '0xc4b81504F9a2bd6a6f2617091FB01Efb38D119c8',
  [ChainId.GÖRLI]: '0xbBca0fFBFE60F60071630A8c80bb6253dC9D6023',
  [ChainId.KOVAN]: '0xc97c7D6C2F1EE518bE4D4B8566bcEb917dED4F39',
}
