import { Path, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [ScanHome, AnimatedScanHome] = createIcon({
  name: 'ScanHome',
  getIcon: (props) => (
    <Svg viewBox="0 0 28 28" fill="none" {...props}>
      <Path
        d="M5.06026 5.0602C5.62479 4.49567 6.39045 4.17853 7.18881 4.17853H10.097C10.6887 4.17853 11.1684 4.65822 11.1684 5.24996C11.1684 5.84169 10.6887 6.32138 10.097 6.32138H7.18881C6.95877 6.32138 6.73815 6.41277 6.57549 6.57543C6.41283 6.73809 6.32145 6.95871 6.32145 7.18874V10.0969C6.32145 10.6887 5.84175 11.1684 5.25002 11.1684C4.65828 11.1684 4.17859 10.6887 4.17859 10.0969V7.18874C4.17859 6.39039 4.49574 5.62472 5.06026 5.0602ZM16.7807 5.24996C16.7807 4.65822 17.2604 4.17853 17.8521 4.17853H20.7603C21.5587 4.17853 22.3243 4.49567 22.8889 5.0602C23.4534 5.62472 23.7705 6.39038 23.7705 7.18874V10.0969C23.7705 10.6887 23.2908 11.1684 22.6991 11.1684C22.1074 11.1684 21.6277 10.6887 21.6277 10.0969V7.18874C21.6277 6.95871 21.5363 6.73809 21.3736 6.57543C21.211 6.41277 20.9904 6.32138 20.7603 6.32138H17.8521C17.2604 6.32138 16.7807 5.84169 16.7807 5.24996ZM5.25002 16.7806C5.84175 16.7806 6.32145 17.2603 6.32145 17.8521V20.7603C6.32145 20.9903 6.41283 21.2109 6.57549 21.3736C6.73815 21.5362 6.95877 21.6276 7.18881 21.6276H10.097C10.6887 21.6276 11.1684 22.1073 11.1684 22.699C11.1684 23.2908 10.6887 23.7705 10.097 23.7705H7.18881C6.39045 23.7705 5.62479 23.4533 5.06026 22.8888C4.49574 22.3243 4.17859 21.5586 4.17859 20.7603V17.8521C4.17859 17.2603 4.65828 16.7806 5.25002 16.7806ZM22.6991 16.7806C23.2908 16.7806 23.7705 17.2603 23.7705 17.8521V20.7603C23.7705 21.5586 23.4534 22.3243 22.8889 22.8888C22.3243 23.4533 21.5587 23.7705 20.7603 23.7705H17.8521C17.2604 23.7705 16.7807 23.2908 16.7807 22.699C16.7807 22.1073 17.2604 21.6276 17.8521 21.6276H20.7603C20.9904 21.6276 21.211 21.5362 21.3736 21.3736C21.5363 21.2109 21.6277 20.9903 21.6277 20.7603V17.8521C21.6277 17.2603 22.1074 16.7806 22.6991 16.7806Z"
        fill={'currentColor' ?? '#7D7D7D'}
        fillRule="evenodd"
        clipRule="evenodd"
      />
    </Svg>
  ),
  defaultFill: '#7D7D7D',
})
