import { Path, Rect, Svg } from 'react-native-svg'

// eslint-disable-next-line no-relative-import-paths/no-relative-import-paths
import { createIcon } from '../factories/createIcon'

export const [Contract, AnimatedContract] = createIcon({
  name: 'Contract',
  getIcon: (props) => (
    <Svg viewBox="0 0 24 24" fill="none" {...props}>
      <Rect width="24" height="24" rx="12" fill={'currentColor' ?? '#00C3A0'} />
      <Path
        d="M8 7.33333C7.63181 7.33333 7.33333 7.63181 7.33333 8C7.33333 8.36819 7.63181 8.66667 8 8.66667C8.36819 8.66667 8.66667 8.36819 8.66667 8C8.66667 7.63181 8.36819 7.33333 8 7.33333ZM6 8C6 6.89543 6.89543 6 8 6C8.87081 6 9.61164 6.55654 9.8862 7.33333H14.6667C16.1394 7.33333 17.3333 8.52724 17.3333 10C17.3333 11.4728 16.1394 12.6667 14.6667 12.6667H9.33333C8.59695 12.6667 8 13.2636 8 14C8 14.7364 8.59695 15.3333 9.33333 15.3333H14.1138C14.3884 14.5565 15.1292 14 16 14C17.1046 14 18 14.8954 18 16C18 17.1046 17.1046 18 16 18C15.1292 18 14.3884 17.4435 14.1138 16.6667H9.33333C7.86057 16.6667 6.66667 15.4728 6.66667 14C6.66667 12.5272 7.86057 11.3333 9.33333 11.3333H14.6667C15.403 11.3333 16 10.7364 16 10C16 9.26362 15.403 8.66667 14.6667 8.66667H9.8862C9.61164 9.44346 8.87081 10 8 10C6.89543 10 6 9.10457 6 8ZM16 15.3333C15.6318 15.3333 15.3333 15.6318 15.3333 16C15.3333 16.3682 15.6318 16.6667 16 16.6667C16.3682 16.6667 16.6667 16.3682 16.6667 16C16.6667 15.6318 16.3682 15.3333 16 15.3333Z"
        fill="white"
        fillRule="evenodd"
        clipRule="evenodd"
      />
    </Svg>
  ),
  defaultFill: '#00C3A0',
})
